(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[  29345373,     670213]*)
(*NotebookOutlinePosition[  29347107,     670267]*)
(*  CellTagsIndexPosition[  29346995,     670260]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Differential Evolution (2004)", "Title",
  CellFrame->True,
  TextAlignment->Center,
  TextJustification->0,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["Ivan Zelinka",
    FontWeight->"Bold"],
  " \nTomas Bata University, Faculty of Technology, Institute of Information \
Technologies\nnam. T.G.M. 275, 760 01 Zlin, Czech Republic\nemail - \
zelinka@ft.utb.cz, tel. +420 57 603 5192, ",
  StyleBox["http://www.ft.utb.cz/people/zelinka/hp",
    FontWeight->"Bold"]
}], "Subsubtitle",
  CellFrame->True,
  TextAlignment->Center,
  TextJustification->0,
  FontSize->14,
  Background->GrayLevel[0.849989]],

Cell["\<\
Acknowledgement : special thanks belongs to Daniel Lichtblau and Rainer Storn \
for their review of following code and help with its improvement.\
\>", "Text",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[TextData[{
  "For ocassional update of this notebook, please visit website ",
  StyleBox["http://www.ft.utb.cz/people/zelinka/soma",
    FontWeight->"Bold"]
}], "Text",
  TextAlignment->Center,
  TextJustification->0,
  FontSize->16,
  FontWeight->"Bold"],

Cell["\<\
This is a free software program; you can redistribute it and/or modify it \
under the terms of the GNU General Public License as published by the Free \
Software Foundation; either version 1, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT \
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS \
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more \
details. A copy of the GNU General Public License can be obtained from the \
Free Software foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\
\>", "Text",
  CellFrame->True,
  TextAlignment->Center,
  TextJustification->0,
  FontSize->16,
  FontColor->RGBColor[1, 1, 0],
  Background->RGBColor[0.531258, 0, 0]],

Cell["\<\
Important notices:
    
- in this notebook you can find use of \"PathToFile=here is some path\". \
Variable \"PathToFile\" is filled by my path from my computer so in your PC \
you will have to redefine these paths according to the positions of \
\"Mandelbrot.exe,Spider.exe, Vortex.exe and MathEA.exe\" which are associated \
with this notebook.

- this notebook was developed under version 5.0.1 so it is recommended to use \
this or higher versions despite the fact that there is no definite knowledge \
that version 3.0 would be problematic. When a lower version is used, then a \
warning is generated upon on starting - it is a general warning which has no \
impact on the funcionality of code in this notebook.
    
- it sometimes happen that Mathematica behaves peculiary (usually as a result \
of the user's mistake), on which case I recommend shutting down Kernel or \
Mathematica and starting again.\
\>", "Text",
  FontSize->16],

Cell[TextData[{
  "For users who are unfamiliar with ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "here are some introductory hints: the notebook is organized in \"cells\" \
with blue (default) brackets on the right side. They can be opened or closed \
by doubleclicking on them and recalculated by:\n\na) selecting of all or only \
some of them (Ctrl+ mouse_click_on_brackets)\nb) putting the cursor in a cell\
\n\nand pressing Shift+Enter.\n\nFor more information see the help section of \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", item \"Tour\" or \"Getting started\"."
}], "Text",
  CellFrame->True,
  TextAlignment->Left,
  TextJustification->0,
  FontSize->16,
  FontColor->RGBColor[1, 1, 0],
  Background->RGBColor[0.531258, 0, 0]],

Cell[CellGroupData[{

Cell[TextData[{
  "Differential Evolution in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Environment"
}], "Subtitle",
  CellFrame->True,
  TextAlignment->Center,
  TextJustification->0,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  "This section deals with differential evolution which is based only on a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " integrated environment"
}], "Subsubtitle",
  CellFrame->True,
  TextAlignment->Center,
  TextJustification->0,
  FontSize->14,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  "More of code, test function, etc. than is in this notebook is accessible \
on ",
  StyleBox["http://www.ft.utb.cz/people/zelinka/soma",
    FontWeight->"Bold"],
  ". There are source files in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", Matlab and C++ programming language, 15 test functions including their \
visualisation etc."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["1 Some Subroutines", "Section"],

Cell[CellGroupData[{

Cell["1.1 Cost Function", "Subsection"],

Cell["Cost function for purposes here is defined as", "Text"],

Cell[BoxData[
    \(CostFunction[x_] := x[\([1]\)]^2 + x[\([2]\)]^2\)], "Input"],

Cell["\<\
the argument named \"x\" is in fact a vector and thus indexes [[1]]...[[n]] \
are pointers on its parameters, i.e. on arguments of cost function\
\>", "Text"],

Cell["\<\
This cost function (Schwefel's function) will be used for the following text. \
Two approaches are tested here. The first one is cost function in an \
\"uncompiled\" form.\
\>", "Text"],

Cell[BoxData[
    \(CostF[x_] := 
      N[Sum[\(-x[\([i]\)]\)\ Sin[Sqrt[Abs[x[\([i]\)]]]], {i, 
            1, \(Dimensions[x]\)[\([1]\)]}]]\)], "Input"],

Cell["\<\
This is another way how to write this cost function in a \"streamlined\" way.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CostF2 = 
      Compile[{{x, _Real, 1}}, \(-x . Sin[Sqrt[Abs[x]]]\)]\)], "Input"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, \(-x . Sin[\@Abs[x]]\), 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["Its speed can be tested by the \"Timing\" function", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[Do[CostF2[{420, 420}], {100000}]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{46.607`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell["\<\
and the result on PIII / 800 MHz is 47 seconds. When \"Compile\" command is \
used...\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CostFu = 
      Compile[{{x, _Real, 1}}, 
        N[Sum[\(-x[\([i]\)]\)\ Sin[Sqrt[Abs[x[\([i]\)]]]], {i, 
              1, \(Dimensions[x]\)[\([1]\)]}]]]\)], "Input"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, 
        Block[{$$28}, 
          N[\[Sum]\+\(i = 1\)\%\(\(Dimensions[x]\)\[LeftDoubleBracket]1\
\[RightDoubleBracket]\)\(($$28 = 
                  x\[LeftDoubleBracket]
                    i\[RightDoubleBracket]; \(-$$28\)\ Sin[\@Abs[$$28]])\)]], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[Do[CostFu[{420, 420}], {100000}]]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{1.1720000000000113`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell["\<\
... then for the same number of cost function evaluations  only 1.1 second  \
is needed !!! The compiled version is almost 42 times faster here than the \
uncompiled one!!! Thus only the compiled version will be further used in a \
\"streamlined\" form as mentioned above. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CostFunction = 
      Compile[{{x, _Real, 1}}, \(-x . Sin[Sqrt[Abs[x]]]\)]\)], "Input"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, \(-x . Sin[\@Abs[x]]\), 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2 Population", "Subsection"],

Cell["\<\
A population in DE is generated by means of a Specimen, which contains \
information about the type of parameter and its allowed interval\
\>", "Text"],

Cell[BoxData[
    \(\(Specimen = {{{Integer, {\(-512\), 0}}, {Real, {50, 
                100}}, {Integer, {200, 512}}}, {{Real, {\(-512\), 
                0}}, {Integer, {300, 512}}}};\)\)], "Input"],

Cell[BoxData[
    \(DoPopulation[NP_, Specimen_] := 
      Module[{pop, cv}, 
        pop = Table[
            MapThread[
              Random[#1[\([#2, 1]\)], #1[\([#2, 2]\)]] &, {Specimen, \(Random[
                      Integer, {1, #1}] &\) /@ 
                  Flatten[\({#1} &\) /@ \((\(\(Dimensions[#1]\)[\([1]\)] &\) /@ 
                          Specimen)\)]}], {i, NP}]; \[IndentingNewLine]cv = 
          CostFunction /@ pop; \[IndentingNewLine]Return[
          MapThread[{#1, #2} &, {cv, pop}]]\[IndentingNewLine]]\)], "Input"],

Cell["\<\
A population is generated by means ofthe  function \"DoPopulation\" with two \
arguments. The first one is the size of population and the second one is the \
Specimen\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Population = DoPopulation[10, Specimen];\)\), "\[IndentingNewLine]", 
    \(% // TableForm\)}], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {"37.13391801572806`", GridBox[{
                  {"86.55644139395335`"},
                  {\(-76.64497066203211`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {\(-446.33897503109733`\), GridBox[{
                  {\(-347\)},
                  {"401"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"334.46636976994535`", GridBox[{
                  {\(-227\)},
                  {\(-208.8245913810788`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {\(-604.7832373994929`\), GridBox[{
                  {"399"},
                  {"382"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"249.527334677121`", GridBox[{
                  {"479"},
                  {"305"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {\(-58.936518814712834`\), GridBox[{
                  {"63.774741977025066`"},
                  {"484"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {\(-245.0907967027331`\), GridBox[{
                  {"442"},
                  {\(-472.49229957590757`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"324.344278502963`", GridBox[{
                  {"314"},
                  {\(-78.9880815103735`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {\(-26.87282586840052`\), GridBox[{
                  {"84.16326701619049`"},
                  {\(-37.48707931159433`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"102.50274624032099`", GridBox[{
                  {"83.52487774635811`"},
                  {"495"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {{37.133918015728057, {
          86.556441393953349, -76.644970662032108}}, {-446.33897503109733, \
{-347, 401}}, {
          334.46636976994535, {-227, -208.82459138107879}}, \
{-604.78323739949292, {399, 382}}, {249.52733467712099, {479, 
          305}}, {-58.936518814712834, {63.774741977025066, 
          484}}, {-245.09079670273309, {442, -472.49229957590757}}, {
          324.34427850296299, {
          314, -78.988081510373505}}, {-26.872825868400518, {
          84.163267016190488, -37.487079311594329}}, {102.50274624032099, {
          83.524877746358115, 495}}}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Population\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              "37.13391801572806`", \({86.55644139395335`, \
\(-76.64497066203211`\)}\)},
            {\(-446.33897503109733`\), \({\(-347\), 401}\)},
            {"334.46636976994535`", \({\(-227\), \(-208.8245913810788`\)}\)},
            {\(-604.7832373994929`\), \({399, 382}\)},
            {"249.527334677121`", \({479, 305}\)},
            {\(-58.936518814712834`\), \({63.774741977025066`, 484}\)},
            {\(-245.0907967027331`\), \({442, \(-472.49229957590757`\)}\)},
            {"324.344278502963`", \({314, \(-78.9880815103735`\)}\)},
            {\(-26.87282586840052`\), \({84.16326701619049`, \
\(-37.48707931159433`\)}\)},
            {"102.50274624032099`", \({83.52487774635811`, 495}\)}
            }], "\[NoBreak]", ")"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "A population has following structure ",
  StyleBox["{{CostFunction, {Parameter_1, Parameter_2, ... Parameter_n}}, \
{CostFunction, {Parameter_1, Parameter_2, ... Parameter_n}}}",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " where ",
  StyleBox["{CostFunction, {Parameter_1, Parameter_2, ... Parameter_n}}",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is one of all individuals"
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3 Visualization of Population", "Subsection"],

Cell["\<\
A population with NP individuals can be visualized as in the table:\
\>", "Text"],

Cell[BoxData[
    \(\(NP = 10;\)\)], "Input"],

Cell[BoxData[
    \(\(Population = DoPopulation[NP, Specimen];\)\)], "Input"],

Cell[BoxData[
    \(ShowPopulation[Pop_] := 
      MapIndexed[{"\<Individual No. \>" <> 
              ToString[#2[\([1]\)]] <> "\< -> \>", #1[\([1]\)], #1[\([2]\)]} \
&, Pop]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShowPopulation[Population] // TableForm\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {"\<\"Individual No. 1 -> \"\>", \(-201.97605927158838`\), 
              GridBox[{
                  {"208"},
                  {\(-11.247779138125392`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"\<\"Individual No. 2 -> \"\>", "61.59859664722106`", GridBox[{
                  {"94.46196567682898`"},
                  {\(-80.77931829774985`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"\<\"Individual No. 3 -> \"\>", \(-264.65991844132765`\), 
              GridBox[{
                  {\(-88\)},
                  {"385"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"\<\"Individual No. 4 -> \"\>", \(-70.55455326954316`\), 
              GridBox[{
                  {"93.41843804706005`"},
                  {"475"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"\<\"Individual No. 5 -> \"\>", \(-38.36408142804237`\), 
              GridBox[{
                  {"55.33556958148703`"},
                  {"354"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"\<\"Individual No. 6 -> \"\>", "1.6867906303057012`", GridBox[{
                  {"69.44610155268768`"},
                  {\(-63.96071308608027`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"\<\"Individual No. 7 -> \"\>", "78.74312932576407`", GridBox[{
                  {\(-410\)},
                  {"393"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"\<\"Individual No. 8 -> \"\>", "228.99361878327298`", GridBox[{
                  {\(-56\)},
                  {\(-189.5606978400725`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"\<\"Individual No. 9 -> \"\>", "462.37259567933387`", GridBox[{
                  {"488"},
                  {\(-414.58323595670385`\)}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]},
            {"\<\"Individual No. 10 -> \"\>", \(-640.116263518051`\), 
              GridBox[{
                  {"386"},
                  {"442"}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {{"Individual No. 1 -> ", -201.97605927158838, {
          208, -11.247779138125392}}, {"Individual No. 2 -> ", 
          61.598596647221058, {94.461965676828981, -80.779318297749853}}, {
          "Individual No. 3 -> ", -264.65991844132765, {-88, 385}}, {
          "Individual No. 4 -> ", -70.554553269543163, {93.41843804706005, 
          475}}, {"Individual No. 5 -> ", -38.364081428042368, {
          55.335569581487029, 354}}, {"Individual No. 6 -> ", 
          1.6867906303057012, {69.446101552687679, -63.960713086080268}}, {
          "Individual No. 7 -> ", 78.743129325764073, {-410, 393}}, {
          "Individual No. 8 -> ", 
          228.99361878327298, {-56, -189.56069784007249}}, {
          "Individual No. 9 -> ", 462.37259567933387, {
          488, -414.58323595670385}}, {
          "Individual No. 10 -> ", -640.11626351805103, {386, 442}}}]], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell["Or as in a set of points on a hyperplane", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(<< Graphics`Graphics`\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(NumOfPop = 4;\)\), "\[IndentingNewLine]", 
    \(\(DifferentPop = 
        Table[{"\<Population \>" <> ToString[i], 
            ShowPopulation[DoPopulation[NP, Specimen]]}, {i, 
            NumOfPop}];\)\), "\[IndentingNewLine]", 
    \(\(\(TableForm[Transpose[DifferentPop]]\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(ForbiddenAreas = 
        Show[Graphics[{RGBColor[1, 1, 1], 
              Rectangle[{0, \(-512\)}, {50, 512}], RGBColor[1, 1, 1], 
              Rectangle[{100, \(-512\)}, {200, 512}], RGBColor[1, 1, 1], 
              Rectangle[{\(-512\), 0}, {512, 300}]}], 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(text = 
        Show[Graphics[{Text["\<Forbidden area\>", {0, 200}], 
              Text["\<Hard constrain\>", {0, 100}]}], PlotRange \[Rule] All, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(ClearPop = 
        Table[{DifferentPop[\([j, 2, i, 3, 1]\)], 
            DifferentPop[\([j, 2, i, 3, 2]\)]}, {i, NP}, {j, 
            NumOfPop}];\)\), "\n", 
    \(\(IntervalFrom = \(-512\);\)\ \ \ \ \ \ \ \ \ \ \ \ \), "\n", 
    \(\(IntervalTo = 511;\)\ \ \), "\n", 
    \(\(plt = 
        DensityPlot[
          CostFunction[{x\_1, x\_2}], {x\_1, IntervalFrom, 
            IntervalTo}, {x\_2, IntervalFrom, IntervalTo}, 
          PlotPoints \[Rule] 200, Mesh -> False, PlotRange -> All, 
          ColorFunction -> \((Hue[#, 1, If[# < 0.001, 0, 1]] &)\), 
          DisplayFunction \[Rule] Identity];\)\), "\n", 
    \(Show[
      GraphicsArray[
        Table[Show[{plt, ForbiddenAreas, text, 
              LabeledListPlot[\(Transpose[ClearPop]\)[\([i]\)], 
                Frame \[Rule] False, Axes \[Rule] False, 
                DisplayFunction \[Rule] Identity], 
              ListPlot[\(Transpose[ClearPop]\)[\([i]\)], 
                PlotStyle -> PointSize[ .03], Frame \[Rule] False, 
                Axes \[Rule] False, DisplayFunction \[Rule] Identity]}], {i, 
            NumOfPop}]], DisplayFunction \[Rule] $DisplayFunction, 
      ImageSize \[Rule] 1000]\)}], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {"\<\"Population 1\"\>", "\<\"Population 2\"\>", "\<\"Population \
3\"\>", "\<\"Population 4\"\>"},
            {GridBox[{
                  {"\<\"Individual No. 1 -> \"\>", \(-420.70814450837224`\), 
                    GridBox[{
                        {"60.74035744928269`"},
                        {"399"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 2 -> \"\>", "121.67914425567022`", 
                    GridBox[{
                        {\(-499\)},
                        {"311"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 3 -> \"\>", \(-532.4853283208164`\), 
                    GridBox[{
                        {"473"},
                        {"420"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 4 -> \"\>", "337.9165071442599`", 
                    GridBox[{
                        {"293"},
                        {\(-54.569642611583596`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 5 -> \"\>", "203.20271534089494`", 
                    GridBox[{
                        {"89.21389086043183`"},
                        {\(-201.88757349010828`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 6 -> \"\>", "174.00248662348247`", 
                    GridBox[{
                        {\(-424\)},
                        {\(-323.903448539527`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 7 -> \"\>", \(-103.15516363750248`\), 
                    GridBox[{
                        {\(-136\)},
                        {\(-4.263857070902589`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 8 -> \"\>", \(-272.69311067553633`\), 
                    GridBox[{
                        {"52.65744946647847`"},
                        {"461"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 9 -> \"\>", \(-173.16133028299572`\), 
                    GridBox[{
                        {"62.230722932429316`"},
                        {\(-115.0788571584482`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 10 -> \"\>", "92.89325148348652`", 
                    GridBox[{
                        {\(-140\)},
                        {\(-375.2104992261659`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}], GridBox[{
                  {"\<\"Individual No. 1 -> \"\>", "47.43310502248558`", 
                    GridBox[{
                        {"357"},
                        {\(-66.71998296083196`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 2 -> \"\>", "441.7465449406143`", 
                    GridBox[{
                        {\(-422\)},
                        {\(-46.25452131770268`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 3 -> \"\>", \(-533.4470364292115`\), 
                    GridBox[{
                        {\(-331\)},
                        {"394"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 4 -> \"\>", \(-244.73456922496388`\), 
                    GridBox[{
                        {"335"},
                        {"422"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 5 -> \"\>", "563.3774148716277`", 
                    GridBox[{
                        {"293"},
                        {"317"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 6 -> \"\>", \(-200.01435326682923`\), 
                    GridBox[{
                        {"77.07490262818922`"},
                        {\(-337.72341991457154`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 7 -> \"\>", \(-519.6883130381945`\), 
                    GridBox[{
                        {\(-115\)},
                        {"412"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 8 -> \"\>", \(-68.86378637839314`\), 
                    GridBox[{
                        {"72.99074558966063`"},
                        {\(-35.00674217957729`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 9 -> \"\>", \(-365.38968997738726`\), 
                    GridBox[{
                        {"443"},
                        {"483"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 10 -> \"\>", \(-131.82638439801758`\), 
                    GridBox[{
                        {\(-55\)},
                        {\(-333.9564743819288`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}], GridBox[{
                  {"\<\"Individual No. 1 -> \"\>", \(-771.4784409250866`\), 
                    GridBox[{
                        {"431"},
                        {"400"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 2 -> \"\>", \(-352.2226960219362`\), 
                    GridBox[{
                        {"75.09219742351775`"},
                        {\(-302.8204292362298`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 3 -> \"\>", \(-64.84933336688482`\), 
                    GridBox[{
                        {"98.0830575844873`"},
                        {\(-134.82839448240702`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 4 -> \"\>", "76.29623929593457`", 
                    GridBox[{
                        {\(-348\)},
                        {"339"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 5 -> \"\>", \(-168.45695077115187`\), 
                    GridBox[{
                        {"68.84603403620522`"},
                        {\(-113.25973139615733`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 6 -> \"\>", \(-79.52124455192552`\), 
                    GridBox[{
                        {"57.59641344809046`"},
                        {\(-24.847134201752258`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 7 -> \"\>", "228.06948989233882`", 
                    GridBox[{
                        {\(-31\)},
                        {"323"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 8 -> \"\>", "523.7217938574166`", 
                    GridBox[{
                        {"504"},
                        {"303"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 9 -> \"\>", \(-189.40222843151827`\), 
                    GridBox[{
                        {\(-141\)},
                        {\(-138.41374591915783`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 10 -> \"\>", \(-399.9704460208229`\), 
                    GridBox[{
                        {"71.84662978372415`"},
                        {"446"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}], GridBox[{
                  {"\<\"Individual No. 1 -> \"\>", \(-48.98357471498001`\), 
                    GridBox[{
                        {"87.88083009944708`"},
                        {"360"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 2 -> \"\>", \(-171.69491848438747`\), 
                    GridBox[{
                        {"70.79528180295168`"},
                        {\(-134.14988884825524`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 3 -> \"\>", \(-187.50613990117026`\), 
                    GridBox[{
                        {"69.1891803172457`"},
                        {\(-262.6570973902618`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 4 -> \"\>", "56.004407608604964`", 
                    GridBox[{
                        {"59.55711215857198`"},
                        {"494"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 5 -> \"\>", "294.0420474346539`", 
                    GridBox[{
                        {\(-457\)},
                        {"352"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 6 -> \"\>", \(-190.93217894675408`\), 
                    GridBox[{
                        {"246"},
                        {\(-270.9393896220894`\)}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 7 -> \"\>", "298.31746436314927`", 
                    GridBox[{
                        {"251"},
                        {"508"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 8 -> \"\>", "7.960157625681347`", 
                    GridBox[{
                        {\(-436\)},
                        {"438"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 9 -> \"\>", \(-487.4548072499457`\), 
                    GridBox[{
                        {"426"},
                        {"477"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]},
                  {"\<\"Individual No. 10 -> \"\>", \(-460.17946269623275`\), 
                    GridBox[{
                        {"62.67355698122695`"},
                        {"434"}
                        },
                      RowSpacings->0.25,
                      ColumnSpacings->1,
                      RowAlignments->Baseline,
                      ColumnAlignments->{Left}]}
                  },
                RowSpacings->0.25,
                ColumnSpacings->1,
                RowAlignments->Baseline,
                ColumnAlignments->{Left}]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {{"Population 1", "Population 2", "Population 3", 
          "Population 4"}, {{{"Individual No. 1 -> ", -420.70814450837224, {
          60.740357449282691, 399}}, {"Individual No. 2 -> ", 
          121.67914425567022, {-499, 311}}, {
          "Individual No. 3 -> ", -532.48532832081639, {473, 420}}, {
          "Individual No. 4 -> ", 337.91650714425992, {
          293, -54.569642611583596}}, {"Individual No. 5 -> ", 
          203.20271534089494, {89.213890860431832, -201.88757349010828}}, {
          "Individual No. 6 -> ", 
          174.00248662348247, {-424, -323.90344853952701}}, {
          "Individual No. 7 -> ", -103.15516363750248, {-136, \
-4.2638570709025894}}, {"Individual No. 8 -> ", -272.69311067553633, {
          52.657449466478468, 461}}, {
          "Individual No. 9 -> ", -173.16133028299572, {
          62.230722932429316, -115.0788571584482}}, {"Individual No. 10 -> ", 
          92.893251483486523, {-140, -375.21049922616589}}}, {{
          "Individual No. 1 -> ", 47.433105022485577, {
          357, -66.719982960831956}}, {"Individual No. 2 -> ", 
          441.74654494061429, {-422, -46.254521317702682}}, {
          "Individual No. 3 -> ", -533.44703642921149, {-331, 394}}, {
          "Individual No. 4 -> ", -244.73456922496388, {335, 422}}, {
          "Individual No. 5 -> ", 563.37741487162771, {293, 317}}, {
          "Individual No. 6 -> ", -200.01435326682923, {
          77.074902628189221, -337.72341991457154}}, {
          "Individual No. 7 -> ", -519.68831303819445, {-115, 412}}, {
          "Individual No. 8 -> ", -68.863786378393144, {
          72.990745589660634, -35.006742179577287}}, {
          "Individual No. 9 -> ", -365.38968997738726, {443, 483}}, {
          "Individual No. 10 -> ", -131.82638439801758, {-55, \
-333.95647438192879}}}, {{"Individual No. 1 -> ", -771.4784409250866, {431, 
          400}}, {"Individual No. 2 -> ", -352.2226960219362, {
          75.092197423517746, -302.82042923622981}}, {
          "Individual No. 3 -> ", -64.849333366884821, {
          98.083057584487307, -134.82839448240702}}, {"Individual No. 4 -> ", 
          76.296239295934569, {-348, 339}}, {
          "Individual No. 5 -> ", -168.45695077115187, {
          68.846034036205225, -113.25973139615733}}, {
          "Individual No. 6 -> ", -79.52124455192552, {
          57.596413448090459, -24.847134201752258}}, {"Individual No. 7 -> ", 
          228.06948989233882, {-31, 323}}, {"Individual No. 8 -> ", 
          523.72179385741663, {504, 303}}, {
          "Individual No. 9 -> ", -189.40222843151827, {-141, \
-138.41374591915783}}, {"Individual No. 10 -> ", -399.97044602082292, {
          71.846629783724154, 446}}}, {{
          "Individual No. 1 -> ", -48.983574714980008, {87.880830099447081, 
          360}}, {"Individual No. 2 -> ", -171.69491848438747, {
          70.795281802951678, -134.14988884825524}}, {
          "Individual No. 3 -> ", -187.50613990117026, {
          69.1891803172457, -262.65709739026181}}, {"Individual No. 4 -> ", 
          56.004407608604964, {59.557112158571982, 494}}, {
          "Individual No. 5 -> ", 294.04204743465391, {-457, 352}}, {
          "Individual No. 6 -> ", -190.93217894675408, {
          246, -270.93938962208938}}, {"Individual No. 7 -> ", 
          298.31746436314927, {251, 508}}, {"Individual No. 8 -> ", 
          7.9601576256813473, {-436, 438}}, {
          "Individual No. 9 -> ", -487.4548072499457, {426, 477}}, {
          "Individual No. 10 -> ", -460.17946269623275, {62.673556981226952, 
          434}}}}}]], TraditionalForm]], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .23256 
%%ImageSize: 1000 232.558 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.0055371 0.238095 [
[ 0 0 0 0 ]
[ 1 .23256 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .23256 L
0 .23256 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0055371 0.245293 0.227021 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.00093006 0.5 0.00093006 [
[.12798 -0.0125 -12 -9 ]
[.12798 -0.0125 12 0 ]
[.31399 -0.0125 -12 -9 ]
[.31399 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.68601 -0.0125 -9 -9 ]
[.68601 -0.0125 9 0 ]
[.87202 -0.0125 -9 -9 ]
[.87202 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .12798 -24 -4.5 ]
[-0.0125 .12798 0 4.5 ]
[-0.0125 .31399 -24 -4.5 ]
[-0.0125 .31399 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .68601 -18 -4.5 ]
[-0.0125 .68601 0 4.5 ]
[-0.0125 .87202 -18 -4.5 ]
[-0.0125 .87202 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 .68601 -44 -6.375 ]
[.5 .68601 44 6.375 ]
[.5 .59301 -44 -6.375 ]
[.5 .59301 44 6.375 ]
[.57149 .87109 0 -4.5 ]
[.57149 .87109 6 4.5 ]
[.0509 .78925 0 -4.5 ]
[.0509 .78925 6 4.5 ]
[.95492 .89063 0 -4.5 ]
[.95492 .89063 6 4.5 ]
[.78751 .44925 0 -4.5 ]
[.78751 .44925 6 4.5 ]
[.59797 .31223 0 -4.5 ]
[.59797 .31223 6 4.5 ]
[.12065 .19875 0 -4.5 ]
[.12065 .19875 6 4.5 ]
[.38851 .49603 0 -4.5 ]
[.38851 .49603 6 4.5 ]
[.56397 .92876 0 -4.5 ]
[.56397 .92876 6 4.5 ]
[.57288 .39297 0 -4.5 ]
[.57288 .39297 6 4.5 ]
[.38479 .15103 0 -4.5 ]
[.38479 .15103 12 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12798 0 m
.12798 .00625 L
s
[(-400)] .12798 -0.0125 0 1 Mshowa
.31399 0 m
.31399 .00625 L
s
[(-200)] .31399 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.68601 0 m
.68601 .00625 L
s
[(200)] .68601 -0.0125 0 1 Mshowa
.87202 0 m
.87202 .00625 L
s
[(400)] .87202 -0.0125 0 1 Mshowa
.125 Mabswid
.17448 0 m
.17448 .00375 L
s
.22098 0 m
.22098 .00375 L
s
.26749 0 m
.26749 .00375 L
s
.36049 0 m
.36049 .00375 L
s
.40699 0 m
.40699 .00375 L
s
.4535 0 m
.4535 .00375 L
s
.5465 0 m
.5465 .00375 L
s
.59301 0 m
.59301 .00375 L
s
.63951 0 m
.63951 .00375 L
s
.73251 0 m
.73251 .00375 L
s
.77902 0 m
.77902 .00375 L
s
.82552 0 m
.82552 .00375 L
s
.08147 0 m
.08147 .00375 L
s
.03497 0 m
.03497 .00375 L
s
.91853 0 m
.91853 .00375 L
s
.96503 0 m
.96503 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .12798 m
.00625 .12798 L
s
[(-400)] -0.0125 .12798 1 0 Mshowa
0 .31399 m
.00625 .31399 L
s
[(-200)] -0.0125 .31399 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .68601 m
.00625 .68601 L
s
[(200)] -0.0125 .68601 1 0 Mshowa
0 .87202 m
.00625 .87202 L
s
[(400)] -0.0125 .87202 1 0 Mshowa
.125 Mabswid
0 .17448 m
.00375 .17448 L
s
0 .22098 m
.00375 .22098 L
s
0 .26749 m
.00375 .26749 L
s
0 .36049 m
.00375 .36049 L
s
0 .40699 m
.00375 .40699 L
s
0 .4535 m
.00375 .4535 L
s
0 .5465 m
.00375 .5465 L
s
0 .59301 m
.00375 .59301 L
s
0 .63951 m
.00375 .63951 L
s
0 .73251 m
.00375 .73251 L
s
0 .77902 m
.00375 .77902 L
s
0 .82552 m
.00375 .82552 L
s
0 .08147 m
.00375 .08147 L
s
0 .03497 m
.00375 .03497 L
s
0 .91853 m
.00375 .91853 L
s
0 .96503 m
.00375 .96503 L
s
.25 Mabswid
0 0 m
0 1 L
s
.12798 .99375 m
.12798 1 L
s
.31399 .99375 m
.31399 1 L
s
.5 .99375 m
.5 1 L
s
.68601 .99375 m
.68601 1 L
s
.87202 .99375 m
.87202 1 L
s
.125 Mabswid
.17448 .99625 m
.17448 1 L
s
.22098 .99625 m
.22098 1 L
s
.26749 .99625 m
.26749 1 L
s
.36049 .99625 m
.36049 1 L
s
.40699 .99625 m
.40699 1 L
s
.4535 .99625 m
.4535 1 L
s
.5465 .99625 m
.5465 1 L
s
.59301 .99625 m
.59301 1 L
s
.63951 .99625 m
.63951 1 L
s
.73251 .99625 m
.73251 1 L
s
.77902 .99625 m
.77902 1 L
s
.82552 .99625 m
.82552 1 L
s
.08147 .99625 m
.08147 1 L
s
.03497 .99625 m
.03497 1 L
s
.91853 .99625 m
.91853 1 L
s
.96503 .99625 m
.96503 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .12798 m
1 .12798 L
s
.99375 .31399 m
1 .31399 L
s
.99375 .5 m
1 .5 L
s
.99375 .68601 m
1 .68601 L
s
.99375 .87202 m
1 .87202 L
s
.125 Mabswid
.99625 .17448 m
1 .17448 L
s
.99625 .22098 m
1 .22098 L
s
.99625 .26749 m
1 .26749 L
s
.99625 .36049 m
1 .36049 L
s
.99625 .40699 m
1 .40699 L
s
.99625 .4535 m
1 .4535 L
s
.99625 .5465 m
1 .5465 L
s
.99625 .59301 m
1 .59301 L
s
.99625 .63951 m
1 .63951 L
s
.99625 .73251 m
1 .73251 L
s
.99625 .77902 m
1 .77902 L
s
.99625 .82552 m
1 .82552 L
s
.99625 .08147 m
1 .08147 L
s
.99625 .03497 m
1 .03497 L
s
.99625 .91853 m
1 .91853 L
s
.99625 .96503 m
1 .96503 L
s
.25 Mabswid
1 0 m
1 1 L
s
% Start of colorimage (RGB)
p
.02381 .02381 translate
.95145 .95145 scale
600 string
200 200 8 [200 0 0 200 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  false 3 Mcolorimage
FFD100FFFF00CEFF009BFF0067FF0032FF0000FF0100FF3300FF6400FF9200FFBD00FFE5
00F7FF00D9FF00C0FF00ADFF00A0FF0098FF0097FF009CFF00A7FF00B7FF00CDFF00E8FF
00FFF700FFD300FFAC00FF8300FF5700FF2A02FF002EFF0059FF0082FF00A8FF00CAFF00
E8FF00FFFF00FFEB00FFDD00FFD600FFD400FFD900FFE300FFF400F6FF00DCFF00BEFF00
9CFF0078FF0053FF002EFF0008FF0000FF1A00FF3B00FF5900FF7200FF8700FF9500FF9E
00FFA100FF9E00FF9400FF8500FF7200FF5900FF3E00FF2100FF021BFF0037FF0051FF00
67FF0077FF0083FF0088FF0086FF007FFF0073FF0061FF004CFF0035FF001EFF0009FF00
00FF0900FF1700FF2000FF2200FF1E00FF1400FF0609FF0018FF0025FF002CFF002DFF00
27FF001DFF0015FF0014FF0019FF001AFF0013FF0009FF0002FF0002FF0007FF0013FF00
22FF0033FF0041FF004CFF0051FF0050FF0049FF003CFF002AFF0014FF0000FF0200FF19
00FF2E00FF4000FF4E00FF5600FF5900FF5500FF4B00FF3B00FF2600FF0D0EFF002CFF00
4AFF0068FF0084FF009CFF00B1FF00C1FF00CCFF00D0FF00CFFF00C7FF00B9FF00A6FF00
8DFF0071FF0050FF002DFF0008FF0000FF1D00FF4200FF6600FF8800FFA700FFC200FFD8
00FFEA00FFF500FFFB00FFFB00FFF400FFE800FFD500FFBE00FFA100FF7F00FF5A00FF32
00FF0724FF0051FF007EFF00AAFF00D4FF00FBFF00FFDF00FFBF00FFA300FF8C00FF7A00
FF6E00FF6800FF6800FF6E00FF7B00FF8D00FFA500FFC200FFE400F5FF00CAFF009DFF00
6CFF003AFF0006FF0000FF2D00FF6100FF9500FFC600FFF6
FFFF00D0FF009FFF006CFF0038FF0003FF0000FF3000FF6200FF9300FFC100FFED00EBFF
00C8FF00AAFF0091FF007EFF0070FF0069FF0068FF006DFF0077FF0088FF009EFF00B9FF
00D9FF00FDFF00FFDB00FFB200FF8600FF5900FF2C00FF002AFF0053FF0079FF009BFF00
B9FF00D1FF00E5FF00F2FF00FAFF00FCFF00F7FF00EDFF00DCFF00C7FF00ADFF008FFF00
6DFF0049FF0024FF0000FF0100FF2600FF4900FF6A00FF8800FFA100FFB600FFC400FFCD
00FFD000FFCD00FFC300FFB500FFA100FF8900FF6D00FF5000FF3100FF1308FF0022FF00
37FF0048FF0053FF0058FF0057FF0050FF0043FF0032FF001DFF0006FF0000FF1000FF26
00FF3800FF4700FF4F00FF5100FF4D00FF4300FF3600FF2500FF1600FF0900FF0200FF02
00FF0700FF1100FF1900FF1A00FF1500FF1400FF1B00FF2500FF2C00FF2D00FF2700FF1B
00FF0C04FF0012FF001DFF0022FF0021FF001AFF000DFF0000FF0400FF1A00FF3100FF48
00FF5D00FF6F00FF7D00FF8500FF8800FF8400FF7A00FF6A00FF5500FF3C00FF2000FF02
1BFF0039FF0055FF006DFF0082FF0092FF009DFF00A1FF00A0FF0098FF008AFF0077FF00
5EFF0041FF0021FF0000FF0100FF2600FF4C00FF7100FF9500FFB700FFD600FFF100F8FF
00E6FF00DBFF00D5FF00D5FF00DCFF00E8FF00FBFF00FFED00FFD000FFAE00FF8900FF61
00FF3600FF0A22FF004FFF007AFF00A5FF00CCFF00F1FF00FFEE00FFD200FFBB00FFA900
FF9D00FF9700FF9700FF9D00FFAA00FFBC00FFD400FFF100ECFF00C6FF009BFF006DFF00
3DFF000BFF0000FF2800FF5C00FF9000FFC400FFF600DAFF
CEFF009FFF006DFF003AFF0006FF0000FF2D00FF6100FF9400FFC500FFF300E1FF00BAFF
0097FF0079FF0060FF004CFF003FFF0038FF0036FF003BFF0046FF0057FF006DFF0088FF
00A7FF00CBFF00F2FF00FFE300FFB800FF8B00FF5E00FF3100FF0621FF0047FF0069FF00
87FF00A0FF00B3FF00C1FF00C9FF00CAFF00C6FF00BBFF00ABFF0095FF007BFF005DFF00
3CFF0018FF0000FF0C00FF3200FF5700FF7B00FF9C00FFB900FFD300FFE700FFF600FFFF
00FDFF00FFFE00FFF500FFE600FFD200FFBA00FF9F00FF8100FF6300FF4500FF2800FF0F
06FF0017FF0022FF0027FF0026FF001FFF0012FF0001FF0000FF1300FF2A00FF4100FF57
00FF6A00FF7800FF8000FF8300FF7F00FF7500FF6700FF5700FF4700FF3B00FF3300FF33
00FF3900FF4200FF4A00FF4B00FF4700FF4500FF4D00FF5600FF5D00FF5E00FF5800FF4C
00FF3D00FF2D00FF1E00FF1400FF0E00FF0F00FF1700FF2400FF3600FF4B00FF6200FF79
00FF8F00FFA100FFAE00FFB700FFB900FFB500FFAB00FF9B00FF8700FF6E00FF5200FF34
00FF1507FF0023FF003CFF0051FF0061FF006BFF0070FF006EFF0066FF0059FF0045FF00
2DFF0010FF0000FF0F00FF3300FF5700FF7D00FFA300FFC700FFE900F8FF00DDFF00C6FF
00B5FF00A9FF00A3FF00A4FF00AAFF00B7FF00C9FF00E1FF00FEFF00FFE000FFBB00FF92
00FF6800FF3C00FF0F1DFF0049FF0073FF009BFF00BFFF00E0FF00FCFF00FFEC00FFDB00
FFCF00FFC900FFC900FFCF00FFDB00FFED00FAFF00DDFF00BBFF0094FF006AFF003CFF00
0CFF0000FF2600FF5900FF8E00FFC200FFF500D8FF00A8FF
9BFF006CFF003AFF0007FF0000FF2C00FF6000FF9400FFC700FFF800D9FF00AEFF0087FF
0064FF0046FF002DFF0019FF000CFF0005FF0003FF0008FF0013FF0024FF003AFF0055FF
0074FF0098FF00BFFF00E9FF00FFEB00FFBE00FF9100FF6500FF3A00FF1114FF0036FF00
54FF006DFF0080FF008EFF0096FF0097FF0093FF0088FF0078FF0062FF0048FF002AFF00
09FF0000FF1A00FF3F00FF6500FF8A00FFAE00FFCF00FFEC00F9FF00E5FF00D6FF00CDFF
00CAFF00CEFF00D7FF00E6FF00FAFF00FFED00FFD200FFB400FF9600FF7800FF5B00FF42
00FF2C00FF1B00FF1000FF0B00FF0C00FF1300FF2000FF3200FF4600FF5D00FF7400FF8A
00FF9D00FFAB00FFB400FFB600FFB200FFA800FF9A00FF8A00FF7A00FF6E00FF6600FF66
00FF6C00FF7500FF7E00FF7E00FF7A00FF7900FF8000FF8900FF9000FF9100FF8B00FF7F
00FF7000FF6000FF5100FF4700FF4100FF4200FF4A00FF5700FF6900FF7E00FF9500FFAC
00FFC200FFD400FFE100FFEA00FFEC00FFE800FFDE00FFCF00FFBA00FFA100FF8500FF67
00FF4900FF2B00FF0F09FF001EFF002EFF0038FF003DFF003BFF0033FF0026FF0012FF00
00FF0500FF2200FF4300FF6600FF8B00FFB000FFD600FFFA00E3FF00C4FF00A9FF0093FF
0082FF0076FF0070FF0071FF0077FF0084FF0096FF00AEFF00CBFF00ECFF00FFEE00FFC6
00FF9B00FF6F00FF4200FF1516FF0040FF0068FF008CFF00ADFF00C9FF00E0FF00F1FF00
FDFF00FFFC00FFFC00FDFF00F1FF00DFFF00C7FF00AAFF0088FF0061FF0037FF0009FF00
00FF2600FF5900FF8D00FFC100FFF500D7FF00A5FF0075FF
67FF0038FF0006FF0000FF2C00FF6000FF9400FFC800FFFB00D3FF00A5FF007AFF0053FF
0030FF0011FF0600FF1A00FF2700FF2E00FF3000FF2B00FF2000FF1000FF0005FF0021FF
0040FF0064FF008BFF00B5FF00E0FF00FFF200FFC500FF9900FF6E00FF4500FF1F02FF00
20FF0039FF004CFF005AFF0062FF0063FF005EFF0054FF0044FF002EFF0014FF0000FF09
00FF2A00FF4E00FF7300FF9900FFBE00FFE200FCFF00DFFF00C5FF00B1FF00A2FF0099FF
0096FF009AFF00A3FF00B2FF00C6FF00DEFF00F9FF00FFE800FFCA00FFAC00FF8F00FF76
00FF6000FF4F00FF4400FF3F00FF4000FF4700FF5400FF6600FF7A00FF9100FFA800FFBE
00FFD100FFDF00FFE800FFEA00FFE600FFDC00FFCE00FFBE00FFAE00FFA200FF9B00FF9A
00FFA000FFAA00FFB200FFB200FFAE00FFAD00FFB400FFBD00FFC400FFC500FFBF00FFB4
00FFA400FF9400FF8500FF7B00FF7600FF7600FF7E00FF8B00FF9D00FFB200FFC900FFE0
00FFF600F7FF00E9FF00E1FF00DFFF00E3FF00EDFF00FCFF00FFEE00FFD500FFB900FF9B
00FF7D00FF5F00FF4300FF2A00FF1500FF0604FF0009FF0007FF0000FF0000FF0E00FF21
00FF3900FF5600FF7700FF9A00FFBF00FFE400F5FF00D1FF00AFFF0090FF0075FF005FFF
004EFF0042FF003CFF003DFF0043FF0050FF0062FF007AFF0097FF00B8FF00DDFF00FFFA
00FFCF00FFA300FF7600FF4900FF1D0CFF0034FF0058FF0079FF0095FF00ACFF00BDFF00
C9FF00CFFF00CFFF00C9FF00BDFF00ABFF0093FF0076FF0054FF002DFF0003FF0000FF2A
00FF5B00FF8D00FFC100FFF500D6FF00A3FF0071FF0041FF
32FF0003FF0000FF2D00FF6000FF9400FFC900FFFD00D0FF009FFF0071FF0046FF001EFF
0400FF2200FF3B00FF4E00FF5B00FF6300FF6400FF5F00FF5400FF4400FF2E00FF1300FF
000CFF0030FF0057FF0080FF00ACFF00D9FF00FFF900FFCD00FFA200FF7900FF5300FF31
00FF1304FF0018FF0026FF002DFF002FFF002AFF0020FF000FFF0000FF0500FF1F00FF3D
00FF5F00FF8300FFA800FFCD00FFF300E9FF00C8FF00AAFF0091FF007DFF006EFF0065FF
0062FF0065FF006FFF007EFF0091FF00AAFF00C5FF00E2FF00FFFE00FFE000FFC400FFAA
00FF9400FF8400FF7800FF7300FF7500FF7C00FF8800FF9A00FFAF00FFC600FFDD00FFF2
00FAFF00ECFF00E3FF00E1FF00E5FF00EFFF00FDFF00FFF200FFE300FFD600FFCF00FFCE
00FFD400FFDE00FFE600FFE700FFE200FFE100FFE800FFF200FFF900FFF900FFF400FFE8
00FFD900FFC800FFBA00FFAF00FFAA00FFAB00FFB200FFBF00FFD100FFE700FFFE00EAFF
00D5FF00C3FF00B5FF00ADFF00AAFF00AEFF00B8FF00C8FF00DDFF00F6FF00FFED00FFCF
00FFB100FF9300FF7700FF5F00FF4A00FF3A00FF2F00FF2B00FF2C00FF3400FF4200FF55
00FF6E00FF8A00FFAB00FFCE00FFF300E6FF00C1FF009DFF007BFF005CFF0041FF002BFF
0019FF000EFF0008FF0008FF000FFF001BFF002EFF0045FF0062FF0084FF00A9FF00D1FF
00FCFF00FFD700FFAA00FF7D00FF5100FF2700FF0024FF0044FF0060FF0077FF0089FF00
95FF009BFF009BFF0095FF0088FF0076FF005EFF0041FF001FFF0000FF0600FF3100FF5E
00FF8F00FFC100FFF500D6FF00A2FF006EFF003DFF000DFF
00FF0100FF3000FF6100FF9400FFC800FFFD00CFFF009CFF006BFF003DFF0012FF1500FF
3800FF5600FF6F00FF8200FF8F00FF9700FF9800FF9300FF8800FF7800FF6200FF4700FF
2700FF0300FF0023FF004DFF0078FF00A5FF00D2FF00FEFF00FFD600FFAD00FF8700FF65
00FF4700FF2E00FF1B00FF0D00FF0600FF0400FF0900FF1300FF2300FF3900FF5300FF71
00FF9300FFB600FFDC00FEFF00D9FF00B5FF0094FF0076FF005DFF0049FF003AFF0031FF
002EFF0031FF003BFF004AFF005EFF0076FF0091FF00AEFF00CDFF00EBFF00FFF800FFDE
00FFC800FFB800FFAC00FFA700FFA800FFB000FFBC00FFCE00FFE300FFF900EEFF00D9FF
00C6FF00B8FF00AFFF00ADFF00B1FF00BBFF00C9FF00D9FF00E9FF00F5FF00FCFF00FDFF
00F7FF00EDFF00E5FF00E5FF00E9FF00EAFF00E3FF00D9FF00D3FF00D2FF00D8FF00E3FF
00F3FF00FFFC00FFEE00FFE300FFDE00FFDF00FFE600FFF300FAFF00E5FF00CEFF00B6FF
00A1FF008FFF0081FF0079FF0077FF007AFF0084FF0094FF00A9FF00C2FF00DEFF00FCFF
00FFE500FFC700FFAB00FF9200FF7E00FF6E00FF6300FF5F00FF6000FF6800FF7600FF89
00FFA100FFBE00FFDF00FDFF00D8FF00B3FF008DFF0069FF0047FF0028FF000DFF0800FF
1900FF2500FF2B00FF2B00FF2400FF1800FF0500FF0012FF002EFF0050FF0075FF009DFF
00C8FF00F4FF00FFDE00FFB100FF8500FF5B00FF3400FF0F10FF002CFF0043FF0055FF00
61FF0067FF0067FF0061FF0055FF0042FF002BFF000DFF0000FF1400FF3A00FF6500FF92
00FFC300FFF500D6FF00A2FF006EFF003AFF0009FF2600FF
00FF3300FF6200FF9400FFC700FFFB00D0FF009CFF0069FF0038FF000AFF2000FF4700FF
6A00FF8800FFA100FFB500FFC200FFC900FFCB00FFC600FFBB00FFAA00FF9400FF7900FF
5A00FF3600FF0F00FF001AFF0045FF0072FF009FFF00CCFF00F7FF00FFE000FFBA00FF98
00FF7A00FF6100FF4E00FF4000FF3800FF3700FF3B00FF4600FF5600FF6C00FF8600FFA4
00FFC500FFE900F1FF00CBFF00A6FF0082FF0061FF0044FF002AFF0016FF0007FF0100FF
0400FF0000FF0008FF0017FF002BFF0043FF005EFF007CFF009AFF00B8FF00D5FF00EEFF
00FFFB00FFEA00FFDF00FFDA00FFDB00FFE200FFEF00FFFF00EAFF00D3FF00BCFF00A6FF
0093FF0085FF007DFF007AFF007EFF0088FF0096FF00A6FF00B6FF00C2FF00CAFF00CAFF
00C4FF00BBFF00B3FF00B2FF00B6FF00B8FF00B0FF00A7FF00A0FF009FFF00A5FF00B1FF
00C0FF00D0FF00DFFF00E9FF00EFFF00EEFF00E6FF00D9FF00C7FF00B2FF009BFF0084FF
006EFF005CFF004FFF0046FF0044FF0048FF0052FF0062FF0076FF008FFF00ABFF00C9FF
00E8FF00FFFA00FFDE00FFC500FFB000FFA000FF9600FF9100FF9300FF9B00FFA800FFBC
00FFD400FFF100EEFF00CAFF00A6FF0080FF005AFF0036FF0014FF0900FF2400FF3B00FF
4C00FF5800FF5E00FF5D00FF5700FF4A00FF3800FF2000FF0300FF001DFF0042FF006BFF
0095FF00C1FF00EEFF00FFE400FFB800FF8E00FF6600FF4200FF2100FF0511FF0022FF00
2EFF0034FF0034FF002EFF0022FF0010FF0000FF0700FF2400FF4600FF6D00FF9700FFC5
00FFF500D7FF00A4FF006FFF003BFF0008FF2900FF5900FF
00FF6400FF9300FFC500FFF800D3FF009FFF006BFF0038FF0008FF2600FF5100FF7800FF
9B00FFB900FFD200FFE500FFF300FFFA00FFFB00FFF700FFEC00FFDB00FFC500FFAA00FF
8A00FF6700FF4000FF1600FF0015FF0041FF006EFF009BFF00C6FF00EFFF00FFEB00FFC9
00FFAB00FF9200FF7E00FF7100FF6900FF6800FF6C00FF7700FF8700FF9C00FFB700FFD5
00FFF600E5FF00C0FF009AFF0075FF0051FF0030FF0013FF0500FF1A00FF2900FF3200FF
3400FF3100FF2800FF1900FF0500FF0012FF002DFF004BFF0069FF0087FF00A4FF00BDFF
00D3FF00E4FF00EFFF00F4FF00F3FF00ECFF00DFFF00CEFF00B9FF00A2FF008BFF0075FF
0062FF0054FF004CFF0049FF004EFF0057FF0065FF0075FF0085FF0092FF0099FF0099FF
0093FF008AFF0082FF0081FF0086FF0087FF0080FF0076FF006FFF006EFF0074FF0080FF
008FFF009FFF00AEFF00B9FF00BEFF00BDFF00B5FF00A8FF0096FF0081FF006AFF0053FF
003EFF002BFF001EFF0015FF0013FF0017FF0021FF0031FF0046FF005FFF007AFF0098FF
00B7FF00D4FF00F0FF00FFF600FFE100FFD100FFC700FFC200FFC400FFCC00FFD900FFED
00FAFF00DDFF00BDFF009AFF0075FF004FFF002AFF0006FF1B00FF3A00FF5500FF6C00FF
7D00FF8900FF8E00FF8E00FF8800FF7B00FF6900FF5100FF3400FF1300FF0011FF003AFF
0064FF0091FF00BDFF00EAFF00FFE900FFBF00FF9700FF7300FF5200FF3600FF1F00FF0D
00FF0104FF0003FF0000FF0200FF0E00FF2000FF3800FF5500FF7700FF9E00FFC800FFF6
00D9FF00A6FF0073FF003EFF000AFF2800FF5A00FF8900FF
00FF9200FFC100FFF300D9FF00A5FF0071FF003DFF000AFF2600FF5400FF7F00FFA600FF
C900FFE700FFFF00FFFF00EBFF00DEFF00D7FF00D5FF00DAFF00E5FF00F5F300FFD800FF
B900FF9500FF6E00FF4400FF1900FF0013FF0040FF006CFF0097FF00C0FF00E6FF00FFF7
00FFD900FFC000FFAD00FF9F00FF9700FF9600FF9A00FFA500FFB500FFCB00FFE500FCFF
00DBFF00B7FF0092FF006CFF0047FF0023FF0002FF1A00FF3400FF4800FF5700FF6000FF
6300FF5F00FF5600FF4700FF3300FF1B00FF0000FF001DFF003BFF0059FF0076FF008FFF
00A5FF00B6FF00C1FF00C6FF00C5FF00BEFF00B1FF009FFF008BFF0074FF005DFF0047FF
0034FF0026FF001DFF001BFF001FFF0029FF0037FF0047FF0057FF0063FF006AFF006BFF
0065FF005BFF0053FF0053FF0057FF0058FF0051FF0048FF0041FF0040FF0046FF0052FF
0061FF0071FF0080FF008AFF008FFF008FFF0087FF007AFF0068FF0053FF003CFF0025FF
000FFF0200FF1000FF1800FF1A00FF1600FF0C00FF0002FF0017FF0030FF004CFF006AFF
0088FF00A6FF00C2FF00DBFF00F0FF00FFFF00FFF500FFF000FFF200FFFA00F7FF00E4FF
00CCFF00AFFF008EFF006BFF0046FF0021FF0400FF2800FF4A00FF6900FF8400FF9A00FF
AB00FFB700FFBD00FFBC00FFB600FFA900FF9700FF7F00FF6200FF4100FF1C00FF000BFF
0036FF0062FF008FFF00BCFF00E8FF00FFED00FFC500FFA100FF8000FF6400FF4D00FF3C
00FF3000FF2A00FF2A00FF3000FF3C00FF4E00FF6600FF8300FFA500FFCC00FFF600DBFF
00ABFF0078FF0044FF0010FF2300FF5600FF8800FFB800FF
00FFBD00FFED00E1FF00AEFF007AFF0046FF0012FF2000FF5100FF7F00FFAA00FFD100FF
F400FFFF00ECFF00D4FF00C0FF00B3FF00ABFF00AAFF00AFFF00BAFF00CAFF00E0FF00FC
E400FFC000FF9900FF6F00FF4400FF1700FF0015FF0041FF006CFF0095FF00BBFF00DDFF
00FBFF00FFEB00FFD800FFCA00FFC300FFC100FFC600FFD000FFE000FFF600EFFF00D1FF
00AFFF008CFF0066FF0041FF001CFF0700FF2800FF4600FF5F00FF7300FF8200FF8B00FF
8E00FF8A00FF8100FF7200FF5E00FF4600FF2B00FF0D00FF0010FF002EFF004AFF0064FF
007AFF008BFF0096FF009BFF009AFF0092FF0086FF0074FF0060FF0049FF0032FF001CFF
0009FF0400FF0D00FF0F00FF0B00FF0100FF000CFF001CFF002CFF0038FF003FFF0040FF
003AFF0030FF0028FF0028FF002CFF002DFF0026FF001DFF0016FF0015FF001BFF0026FF
0036FF0046FF0054FF005FFF0064FF0063FF005CFF004FFF003DFF0028FF0011FF0500FF
1B00FF2D00FF3B00FF4300FF4500FF4100FF3700FF2800FF1300FF0005FF0021FF003FFF
005DFF007BFF0097FF00B0FF00C4FF00D4FF00DFFF00E3FF00E2FF00DAFF00CCFF00B9FF
00A1FF0084FF0063FF0040FF001BFF0900FF2F00FF5300FF7500FF9400FFAF00FFC500FF
D600FFE200FFE800FFE700FFE100FFD400FFC200FFAA00FF8D00FF6C00FF4700FF1F00FF
000BFF0037FF0064FF0091FF00BDFF00E7FF00FFF000FFCC00FFAC00FF9000FF7800FF67
00FF5B00FF5500FF5500FF5B00FF6700FF7A00FF9100FFAF00FFD100FFF700DEFF00B0FF
007FFF004DFF0019FF1A00FF4E00FF8100FFB300FFE300FF
00FFE500EBFF00BAFF0087FF0053FF001EFF1500FF4700FF7800FFA600FFD100FFF900FF
FF00E3FF00C5FF00ACFF0099FF008CFF0084FF0083FF0088FF0092FF00A3FF00B9FF00D4
FF00F4E700FFC000FF9700FF6B00FF3E00FF1100FF001AFF0045FF006EFF0094FF00B6FF
00D4FF00ECFF00FFFF00FFF100FFEA00FFE800FFED00FFF700F7FF00E2FF00C8FF00AAFF
0088FF0064FF003FFF0019FF0B00FF2E00FF4F00FF6D00FF8600FF9B00FFA900FFB200FF
B500FFB200FFA800FF9A00FF8600FF6E00FF5200FF3500FF1600FF0007FF0023FF003DFF
0052FF0063FF006EFF0074FF0072FF006BFF005EFF004DFF0038FF0021FF000AFF0B00FF
1D00FF2B00FF3400FF3600FF3200FF2800FF1A00FF0A00FF0004FF0011FF0018FF0019FF
0013FF0009FF0001FF0000FF0005FF0006FF0000FF0A00FF1100FF1200FF0C00FF0000FF
000EFF001FFF002DFF0038FF003DFF003CFF0035FF0028FF0016FF0000FF1600FF2D00FF
4200FF5400FF6200FF6A00FF6D00FF6900FF5F00FF4F00FF3A00FF2100FF0500FF0018FF
0036FF0054FF0070FF0088FF009DFF00ADFF00B8FF00BCFF00BBFF00B3FF00A5FF0092FF
0079FF005CFF003CFF0019FF0B00FF3100FF5600FF7A00FF9C00FFBB00FFD600FFEC00FF
FE00FFFF00F6FF00F0FF00F0FF00F7FC00FFE900FFD200FFB500FF9300FF6E00FF4600FF
1B00FF0010FF003DFF006AFF0095FF00C0FF00E7FF00FFF300FFD300FFB700FFA000FF8E
00FF8200FF7C00FF7C00FF8200FF8F00FFA100FFB900FFD600FFF800E1FF00B6FF0088FF
0058FF0026FF0D00FF4100FF7500FFA900FFDB00FFFF00F5
00F7FF00C8FF0097FF0064FF0030FF0400FF3800FF6A00FF9B00FFC900FFF400FFFF00E3
FF00C0FF00A2FF0089FF0076FF0069FF0061FF0060FF0065FF0070FF0080FF0096FF00B1
FF00D1FF00F5E300FFBA00FF8E00FF6100FF3400FF0800FF0022FF004BFF0071FF0093FF
00B1FF00C9FF00DDFF00EBFF00F2FF00F4FF00EFFF00E5FF00D4FF00BFFF00A5FF0087FF
0065FF0041FF001CFF0800FF2E00FF5100FF7200FF9000FFA900FFBE00FFCC00FFD500FF
D800FFD500FFCB00FFBC00FFA900FF9000FF7500FF5800FF3900FF1B00FF0000FF001AFF
002FFF0040FF004BFF0051FF004FFF0048FF003BFF002AFF0015FF0100FF1800FF2E00FF
4000FF4E00FF5700FF5900FF5500FF4B00FF3D00FF2D00FF1E00FF1100FF0A00FF0900FF
0F00FF1900FF2100FF2200FF1D00FF1C00FF2300FF2D00FF3400FF3500FF2F00FF2300FF
1400FF0300FF000AFF0015FF001AFF0019FF0012FF0005FF0C00FF2200FF3900FF5000FF
6500FF7700FF8500FF8D00FF9000FF8C00FF8200FF7200FF5D00FF4400FF2800FF0A00FF
0013FF0031FF004DFF0065FF007AFF008AFF0095FF0099FF0098FF0090FF0082FF006FFF
0056FF0039FF0019FF0900FF2E00FF5400FF7900FF9D00FFBF00FFDE00FFF900FFFF00F0
FF00DEFF00D3FF00CDFF00CDFF00D4FF00E0FF00F3F500FFD800FFB600FF9100FF6900FF
3E00FF1200FF001AFF0047FF0073FF009DFF00C4FF00E9FF00FFF600FFDA00FFC300FFB1
00FFA500FF9F00FF9F00FFA500FFB200FFC400FFDC00FFF900E4FF00BEFF0093FF0066FF
0035FF0003FF3000FF6400FF9800FFCC00FFFE00FFFF00D2
00D9FF00AAFF0079FF0046FF0011FF2200FF5600FF8800FFB900FFE700FFFF00ECFF00C5
FF00A2FF0084FF006BFF0058FF004AFF0043FF0042FF0047FF0051FF0062FF0078FF0093
FF00B3FF00D6FF00FED800FFAC00FF7F00FF5300FF2600FF0004FF002DFF0053FF0075FF
0092FF00ABFF00BFFF00CCFF00D4FF00D6FF00D1FF00C6FF00B6FF00A1FF0087FF0068FF
0047FF0023FF0100FF2700FF4C00FF6F00FF9000FFAE00FFC700FFDC00FFEB00FFF300FF
F600FFF300FFEA00FFDB00FFC700FFAF00FF9300FF7600FF5700FF3900FF1D00FF0300FF
0011FF0022FF002DFF0032FF0031FF002AFF001DFF000CFF0800FF1F00FF3600FF4C00FF
5E00FF6D00FF7500FF7700FF7300FF6A00FF5C00FF4B00FF3C00FF2F00FF2800FF2800FF
2D00FF3700FF3F00FF4000FF3B00FF3A00FF4100FF4B00FF5200FF5300FF4D00FF4100FF
3200FF2200FF1300FF0800FF0300FF0400FF0B00FF1900FF2A00FF4000FF5700FF6E00FF
8300FF9500FFA300FFAB00FFAE00FFAA00FFA000FF9000FF7B00FF6200FF4600FF2800FF
0A00FF0013FF002EFF0047FF005CFF006CFF0076FF007BFF0079FF0072FF0064FF0051FF
0038FF001BFF0400FF2700FF4C00FF7200FF9700FFBB00FFDD00FFFC00FFFF00E8FF00D1
FF00C0FF00B5FF00AFFF00AFFF00B6FF00C2FF00D4FF00ECF600FFD500FFAF00FF8700FF
5C00FF3000FF0300FF0028FF0054FF007FFF00A6FF00CBFF00EBFF00FFF800FFE100FFCF
00FFC300FFBD00FFBD00FFC400FFD000FFE200FFFA00E8FF00C6FF00A0FF0075FF0047FF
0017FF1A00FF4E00FF8200FFB700FFEA00FFFF00E3FF00B4
00C0FF0091FF0060FF002DFF0600FF3B00FF6F00FFA100FFD200FFFF00FFFF00D4FF00AC
FF0089FF006BFF0052FF003FFF0032FF002AFF0029FF002EFF0038FF0049FF005FFF007A
FF009AFF00BEFF00E5F100FFC500FF9800FF6B00FF3F00FF1400FF0014FF003AFF005CFF
007AFF0092FF00A6FF00B4FF00BBFF00BDFF00B8FF00AEFF009DFF0088FF006EFF0050FF
002EFF000AFF1A00FF4000FF6500FF8800FFA900FFC700FFE000FFF500FFFF00FCFF00F3
FF00F0FF00F3FF00FDF300FFE000FFC800FFAC00FF8F00FF7000FF5200FF3600FF1C00FF
0700FF0009FF0014FF001AFF0018FF0011FF0004FF0C00FF2100FF3800FF4F00FF6500FF
7700FF8500FF8E00FF9000FF8C00FF8200FF7400FF6400FF5500FF4800FF4100FF4000FF
4600FF5000FF5800FF5900FF5400FF5300FF5A00FF6400FF6B00FF6C00FF6600FF5A00FF
4B00FF3A00FF2C00FF2100FF1C00FF1D00FF2400FF3100FF4300FF5900FF7000FF8700FF
9C00FFAE00FFBC00FFC400FFC700FFC300FFB900FFA900FF9400FF7B00FF5F00FF4100FF
2300FF0500FF0016FF002EFF0043FF0053FF005EFF0062FF0061FF0059FF004BFF0038FF
001FFF0002FF1D00FF4000FF6500FF8B00FFB000FFD400FFF600FFFF00EAFF00CFFF00B9
FF00A7FF009CFF0096FF0096FF009DFF00A9FF00BCFF00D3FF00F0ED00FFC800FFA000FF
7500FF4900FF1C00FF0010FF003BFF0066FF008DFF00B2FF00D2FF00EEFF00FFFA00FFE8
00FFDC00FFD600FFD600FFDC00FFE900FFFB00ECFF00CFFF00ADFF0087FF005CFF002FFF
0100FF3300FF6700FF9B00FFCF00FFFF00FCFF00CAFF009B
00ADFF007EFF004CFF0019FF1A00FF4E00FF8200FFB500FFE500FFFF00EBFF00C0FF0099
FF0076FF0058FF003FFF002CFF001EFF0017FF0016FF001AFF0025FF0036FF004CFF0067
FF0087FF00AAFF00D1FF00FBD800FFAC00FF7F00FF5200FF2700FF0001FF0026FF0049FF
0066FF007FFF0093FF00A0FF00A8FF00A9FF00A5FF009AFF008AFF0075FF005AFF003CFF
001BFF0800FF2D00FF5300FF7800FF9B00FFBD00FFDA00FFF300FFFF00F7FF00E8FF00DF
FF00DDFF00E0FF00E9FF00F8F300FFDB00FFBF00FFA200FF8400FF6600FF4900FF3000FF
1A00FF0900FF0001FF0006FF0005FF0100FF0E00FF1F00FF3400FF4B00FF6200FF7800FF
8B00FF9900FFA100FFA400FF9F00FF9600FF8800FF7800FF6800FF5B00FF5400FF5400FF
5A00FF6300FF6B00FF6C00FF6700FF6600FF6D00FF7700FF7E00FF7F00FF7900FF6D00FF
5E00FF4E00FF3F00FF3400FF2F00FF3000FF3800FF4500FF5700FF6C00FF8300FF9A00FF
AF00FFC100FFCF00FFD800FFDA00FFD600FFCC00FFBC00FFA700FF8E00FF7200FF5500FF
3600FF1800FF0002FF001BFF0030FF0040FF004AFF004FFF004DFF0046FF0038FF0024FF
000CFF1000FF3000FF5300FF7800FF9E00FFC300FFE700FFFF00F6FF00D7FF00BCFF00A5
FF0094FF0088FF0083FF0083FF0089FF0096FF00A8FF00C0FF00DDFF00FEDC00FFB300FF
8900FF5C00FF2F00FF0300FF0028FF0052FF007AFF009EFF00BFFF00DBFF00F2FF00FFFB
00FFEF00FFE900FFEA00FFF000FFFC00F1FF00D9FF00BCFF009AFF0073FF0049FF001BFF
1400FF4700FF7A00FFAF00FFE300FFFF00E9FF00B7FF0088
00A0FF0070FF003FFF000CFF2700FF5B00FF8F00FFC200FFF300FFFF00DEFF00B3FF008C
FF0069FF004AFF0032FF001EFF0011FF0009FF0008FF000DFF0018FF0028FF003EFF005A
FF0079FF009DFF00C4FF00EEE600FFB900FF8C00FF6000FF3500FF0C00FF0019FF003BFF
0059FF0072FF0085FF0093FF009AFF009CFF0097FF008DFF007DFF0067FF004DFF002FFF
000DFF1500FF3B00FF6000FF8500FFA900FFCA00FFE800FFFF00FEFF00EAFF00DBFF00D2
FF00CFFF00D3FF00DCFF00EBFF00FFE800FFCD00FFAF00FF9100FF7300FF5700FF3D00FF
2700FF1600FF0B00FF0600FF0700FF0F00FF1B00FF2D00FF4100FF5800FF6F00FF8500FF
9800FFA600FFAF00FFB100FFAD00FFA300FF9500FF8500FF7500FF6900FF6200FF6100FF
6700FF7100FF7900FF7900FF7500FF7400FF7B00FF8400FF8B00FF8C00FF8600FF7B00FF
6B00FF5B00FF4D00FF4200FF3D00FF3E00FF4500FF5200FF6400FF7900FF9000FFA700FF
BD00FFCF00FFDD00FFE500FFE700FFE300FFD900FFCA00FFB500FF9C00FF8000FF6200FF
4400FF2600FF0A00FF000EFF0022FF0032FF003DFF0041FF0040FF0038FF002AFF0017FF
0000FF1D00FF3E00FF6100FF8600FFAB00FFD100FFF500FFFF00E8FF00C9FF00AEFF0098
FF0087FF007BFF0075FF0076FF007CFF0089FF009BFF00B3FF00D0FF00F1E900FFC100FF
9600FF6A00FF3D00FF1000FF001BFF0045FF006DFF0091FF00B1FF00CDFF00E5FF00F6FF
00FFFD00FFF700FFF700FFFD00F6FF00E3FF00CCFF00AEFF008CFF0066FF003CFF000EFF
2200FF5400FF8800FFBC00FFF000FFFF00DCFF00AAFF007A
0098FF0069FF0038FF0005FF2E00FF6300FF9700FFC900FFFA00FFFF00D7FF00ABFF0084
FF0061FF0043FF002AFF0017FF0009FF0002FF0001FF0006FF0010FF0021FF0037FF0052
FF0072FF0095FF00BDFF00E6ED00FFC000FF9300FF6700FF3C00FF1300FF0012FF0034FF
0051FF006AFF007EFF008BFF0093FF0095FF0090FF0085FF0075FF0060FF0046FF0027FF
0006FF1D00FF4200FF6800FF8D00FFB000FFD100FFEF00FFFF00F7FF00E2FF00D3FF00CB
FF00C8FF00CBFF00D5FF00E3FF00F7F000FFD400FFB700FF9800FF7A00FF5E00FF4400FF
2F00FF1E00FF1300FF0E00FF0F00FF1600FF2300FF3400FF4900FF6000FF7700FF8D00FF
9F00FFAE00FFB600FFB800FFB400FFAA00FF9D00FF8C00FF7D00FF7000FF6900FF6900FF
6E00FF7800FF8000FF8100FF7C00FF7B00FF8200FF8C00FF9300FF9400FF8E00FF8200FF
7300FF6200FF5400FF4900FF4400FF4500FF4C00FF5900FF6B00FF8100FF9800FFAF00FF
C400FFD600FFE400FFEC00FFEF00FFEB00FFE100FFD100FFBC00FFA300FF8700FF6900FF
4B00FF2D00FF1100FF0006FF001BFF002BFF0035FF003AFF0038FF0031FF0023FF0010FF
0800FF2500FF4500FF6800FF8D00FFB300FFD800FFFC00FFFF00E1FF00C2FF00A7FF0091
FF007FFF0074FF006EFF006EFF0075FF0081FF0093FF00ABFF00C8FF00E9F000FFC800FF
9D00FF7100FF4400FF1700FF0013FF003EFF0065FF008AFF00AAFF00C6FF00DDFF00EFFF
00FBFF00FFFE00FFFE00FAFF00EEFF00DCFF00C4FF00A7FF0085FF005FFF0034FF0006FF
2900FF5B00FF8F00FFC300FFF700FFFF00D4FF00A2FF0073
0097FF0068FF0036FF0003FF3000FF6400FF9800FFCB00FFFB00FFFF00D5FF00AAFF0083
FF0060FF0042FF0029FF0016FF0008FF0001FF0000FF0004FF000FFF0020FF0036FF0051
FF0071FF0094FF00BBFF00E5EE00FFC200FF9500FF6800FF3D00FF1500FF0010FF0032FF
0050FF0069FF007CFF008AFF0092FF0093FF008FFF0084FF0074FF005FFF0044FF0026FF
0005FF1E00FF4300FF6900FF8E00FFB200FFD300FFF000FFFF00F5FF00E1FF00D2FF00C9
FF00C7FF00CAFF00D3FF00E2FF00F6F100FFD600FFB800FF9A00FF7C00FF5F00FF4600FF
3000FF1F00FF1400FF0F00FF1000FF1700FF2400FF3500FF4A00FF6100FF7800FF8E00FF
A100FFAF00FFB700FFBA00FFB500FFAC00FF9E00FF8E00FF7E00FF7100FF6A00FF6A00FF
7000FF7900FF8100FF8200FF7D00FF7C00FF8300FF8D00FF9400FF9500FF8F00FF8300FF
7400FF6400FF5500FF4B00FF4500FF4600FF4E00FF5B00FF6D00FF8200FF9900FFB000FF
C500FFD800FFE500FFEE00FFF000FFEC00FFE200FFD200FFBD00FFA500FF8900FF6B00FF
4C00FF2F00FF1300FF0005FF001AFF002AFF0034FF0039FF0037FF002FFF0022FF000EFF
0900FF2600FF4600FF6900FF8E00FFB400FFD900FFFE00FFFF00E0FF00C1FF00A6FF008F
FF007EFF0072FF006DFF006DFF0073FF0080FF0092FF00AAFF00C7FF00E8F200FFC900FF
9F00FF7200FF4600FF1900FF0012FF003CFF0064FF0088FF00A9FF00C5FF00DCFF00EEFF
00FAFF00FFFF00FFFF00F9FF00EDFF00DBFF00C3FF00A6FF0084FF005DFF0033FF0005FF
2A00FF5D00FF9000FFC500FFF900FFFF00D3FF00A1FF0071
009CFF006DFF003BFF0008FF2B00FF5F00FF9300FFC600FFF700FFFF00DAFF00AFFF0088
FF0065FF0047FF002EFF001AFF000DFF0006FF0004FF0009FF0014FF0025FF003BFF0056
FF0075FF0099FF00C0FF00EAEA00FFBD00FF9000FF6400FF3900FF1000FF0015FF0037FF
0055FF006EFF0081FF008FFF0097FF0098FF0094FF0089FF0079FF0063FF0049FF002BFF
000AFF1900FF3E00FF6400FF8900FFAD00FFCE00FFEB00FFFF00FAFF00E6FF00D7FF00CE
FF00CBFF00CFFF00D8FF00E7FF00FBEC00FFD100FFB300FF9500FF7700FF5A00FF4100FF
2B00FF1A00FF0F00FF0A00FF0B00FF1200FF1F00FF3000FF4500FF5C00FF7300FF8900FF
9C00FFAA00FFB300FFB500FFB100FFA700FF9900FF8900FF7900FF6D00FF6500FF6500FF
6B00FF7400FF7C00FF7D00FF7900FF7800FF7F00FF8800FF8F00FF9000FF8A00FF7E00FF
6F00FF5F00FF5000FF4600FF4000FF4100FF4900FF5600FF6800FF7D00FF9400FFAB00FF
C100FFD300FFE000FFE900FFEB00FFE700FFDD00FFCD00FFB900FFA000FF8400FF6600FF
4700FF2A00FF0E00FF000AFF001FFF002FFF0039FF003EFF003CFF0034FF0027FF0013FF
0400FF2100FF4200FF6500FF8A00FFAF00FFD500FFF900FFFF00E4FF00C5FF00AAFF0094
FF0083FF0077FF0071FF0072FF0078FF0085FF0097FF00AFFF00CCFF00EDED00FFC500FF
9A00FF6E00FF4100FF1400FF0017FF0041FF0069FF008DFF00AEFF00CAFF00E1FF00F2FF
00FEFF00FFFB00FFFB00FEFF00F2FF00E0FF00C8FF00ABFF0089FF0062FF0038FF000AFF
2500FF5800FF8B00FFC000FFF400FFFF00D8FF00A6FF0076
00A7FF0077FF0046FF0013FF2000FF5400FF8800FFBB00FFEC00FFFF00E5FF00BAFF0092
FF0070FF0051FF0038FF0025FF0018FF0010FF000FFF0014FF001FFF002FFF0045FF0060
FF0080FF00A4FF00CBFF00F5DF00FFB200FF8500FF5900FF2E00FF0500FF0020FF0042FF
0060FF0079FF008CFF009AFF00A1FF00A3FF009EFF0094FF0084FF006EFF0054FF0036FF
0014FF0E00FF3400FF5900FF7E00FFA200FFC300FFE100FFFA00FFFF00F1FF00E2FF00D9
FF00D6FF00DAFF00E3FF00F2F900FFE100FFC600FFA800FF8A00FF6C00FF5000FF3600FF
2000FF0F00FF0400FF0000FF0000FF0800FF1400FF2600FF3A00FF5100FF6800FF7E00FF
9100FF9F00FFA800FFAA00FFA600FF9C00FF8E00FF7E00FF6E00FF6200FF5B00FF5A00FF
6000FF6A00FF7200FF7200FF6E00FF6D00FF7400FF7D00FF8400FF8500FF7F00FF7400FF
6400FF5400FF4600FF3B00FF3600FF3700FF3E00FF4B00FF5D00FF7200FF8900FFA000FF
B600FFC800FFD600FFDE00FFE000FFDC00FFD200FFC300FFAE00FF9500FF7900FF5B00FF
3D00FF1F00FF0300FF0015FF0029FF0039FF0044FF0048FF0047FF003FFF0031FF001EFF
0006FF1600FF3700FF5A00FF7F00FFA400FFCA00FFEE00FFFF00EFFF00D0FF00B5FF009F
FF008EFF0082FF007CFF007DFF0083FF008FFF00A2FF00BAFF00D7FF00F8E200FFBA00FF
8F00FF6300FF3600FF0900FF0022FF004CFF0074FF0098FF00B8FF00D4FF00ECFF00FDFF
00FFF600FFF000FFF000FFF600FDFF00EAFF00D3FF00B5FF0093FF006DFF0042FF0015FF
1B00FF4D00FF8100FFB500FFE900FFFF00E3FF00B1FF0081
00B7FF0088FF0057FF0024FF1000FF4400FF7800FFAA00FFDB00FFFF00F5FF00CAFF00A3
FF0080FF0062FF0049FF0036FF0028FF0021FF0020FF0025FF002FFF0040FF0056FF0071
FF0091FF00B4FF00DBFA00FFCE00FFA200FF7500FF4800FF1D00FF000BFF0031FF0053FF
0070FF0089FF009DFF00AAFF00B2FF00B4FF00AFFF00A4FF0094FF007FFF0065FF0046FF
0025FF0001FF2300FF4900FF6E00FF9100FFB200FFD000FFE900FFFE00FFFF00F2FF00EA
FF00E7FF00EAFF00F3FD00FFE900FFD100FFB500FF9800FF7A00FF5B00FF3F00FF2500FF
1000FF0000FF000BFF0010FF000FFF0008FF0400FF1500FF2A00FF4100FF5800FF6E00FF
8000FF8F00FF9700FF9900FF9500FF8C00FF7E00FF6E00FF5E00FF5100FF4A00FF4A00FF
5000FF5900FF6100FF6200FF5D00FF5C00FF6300FF6D00FF7400FF7500FF6F00FF6300FF
5400FF4400FF3500FF2A00FF2500FF2600FF2D00FF3B00FF4D00FF6200FF7900FF9000FF
A500FFB700FFC500FFCD00FFD000FFCC00FFC200FFB200FF9D00FF8400FF6800FF4B00FF
2C00FF0E00FF000CFF0025FF003AFF004AFF0054FF0059FF0057FF0050FF0042FF002FFF
0016FF0600FF2600FF4900FF6E00FF9400FFB900FFDD00FFFF00FFFF00E1FF00C6FF00AF
FF009EFF0093FF008DFF008DFF0094FF00A0FF00B2FF00CAFF00E7F700FFD100FFA900FF
7E00FF5200FF2500FF0006FF0032FF005CFF0084FF00A8FF00C9FF00E5FF00FCFF00FFF1
00FFE500FFDF00FFDF00FFE600FFF200FBFF00E3FF00C6FF00A4FF007DFF0053FF0025FF
0A00FF3C00FF7000FFA400FFD900FFFF00F3FF00C1FF0092
00CDFF009EFF006DFF003AFF0005FF2E00FF6200FF9400FFC500FFF300FFFF00E0FF00B9
FF0096FF0078FF005FFF004CFF003EFF0037FF0036FF003BFF0045FF0056FF006CFF0087
FF00A7FF00CAFF00F2E400FFB800FF8B00FF5F00FF3200FF0700FF0021FF0047FF0069FF
0086FF009FFF00B3FF00C0FF00C8FF00CAFF00C5FF00BAFF00AAFF0095FF007BFF005CFF
003BFF0017FF0D00FF3300FF5800FF7B00FF9C00FFBA00FFD300FFE800FFF700FFFF00FF
FF00FDFF00FFF600FFE700FFD300FFBB00FF9F00FF8200FF6300FF4500FF2900FF0F00FF
0005FF0016FF0021FF0026FF0025FF001EFF0011FF0000FF1400FF2B00FF4200FF5800FF
6A00FF7900FF8100FF8300FF7F00FF7600FF6800FF5700FF4800FF3B00FF3400FF3400FF
3900FF4300FF4B00FF4C00FF4700FF4600FF4D00FF5700FF5E00FF5F00FF5900FF4D00FF
3E00FF2D00FF1F00FF1400FF0F00FF1000FF1700FF2500FF3600FF4C00FF6300FF7A00FF
8F00FFA100FFAF00FFB700FFBA00FFB600FFAC00FF9C00FF8700FF6E00FF5200FF3400FF
1600FF0007FF0022FF003BFF0050FF0060FF006AFF006FFF006DFF0066FF0058FF0045FF
002CFF000FFF1000FF3300FF5800FF7E00FFA300FFC700FFE900FFFF00F7FF00DCFF00C6
FF00B4FF00A9FF00A3FF00A3FF00AAFF00B6FF00C8FF00E0FF00FDE100FFBB00FF9300FF
6800FF3C00FF0F00FF001DFF0048FF0073FF009AFF00BFFF00DFFF00FBFF00FFED00FFDB
00FFCF00FFC900FFC900FFD000FFDC00FFEE00F9FF00DCFF00BAFF0094FF0069FF003BFF
000BFF2600FF5A00FF8E00FFC300FFF600FFFF00D7FF00A8
00E8FF00B9FF0088FF0055FF0021FF1300FF4700FF7900FFAA00FFD800FFFF00FCFF00D4
FF00B1FF0093FF007AFF0067FF005AFF0052FF0051FF0056FF0060FF0071FF0087FF00A2
FF00C2FF00E6F200FFC900FF9D00FF7000FF4300FF1700FF0013FF003CFF0062FF0084FF
00A2FF00BAFF00CEFF00DCFF00E3FF00E5FF00E0FF00D6FF00C5FF00B0FF0096FF0078FF
0056FF0032FF000DFF1800FF3D00FF6000FF8100FF9F00FFB800FFCD00FFDB00FFE400FF
E700FFE400FFDA00FFCB00FFB800FFA000FF8400FF6700FF4800FF2A00FF0E00FF000BFF
0020FF0031FF003CFF0042FF0040FF0039FF002CFF001BFF0006FF1000FF2700FF3D00FF
4F00FF5D00FF6600FF6800FF6400FF5A00FF4C00FF3C00FF2D00FF2000FF1900FF1800FF
1E00FF2800FF3000FF3100FF2C00FF2B00FF3200FF3C00FF4300FF4400FF3E00FF3200FF
2300FF1200FF0400FF0006FF000BFF000AFF0003FF0900FF1B00FF3100FF4800FF5F00FF
7400FF8600FF9400FF9C00FF9F00FF9B00FF9100FF8100FF6C00FF5300FF3700FF1900FF
0004FF0022FF003EFF0056FF006BFF007BFF0086FF008AFF0089FF0081FF0073FF0060FF
0047FF002AFF000AFF1800FF3D00FF6300FF8800FFAC00FFCE00FFED00FFFF00F7FF00E1
FF00CFFF00C4FF00BEFF00BEFF00C5FF00D1FF00E4FF00FBE700FFC500FFA000FF7800FF
4D00FF2100FF000BFF0038FF0063FF008EFF00B5FF00DAFF00FAFF00FFE900FFD200FFC0
00FFB400FFAE00FFAE00FFB400FFC100FFD300FFEB00F7FF00D5FF00AFFF0084FF0057FF
0026FF0B00FF3F00FF7300FFA700FFDB00FFFF00F2FF00C3
00FFF700D9FF00A7FF0074FF0040FF000CFF2700FF5A00FF8A00FFB900FFE400FFFF00F4
FF00D1FF00B3FF009AFF0087FF0079FF0072FF0071FF0075FF0080FF0091FF00A7FF00C2
FF00E2FA00FFD300FFA900FF7D00FF5100FF2400FF0008FF0033FF005CFF0081FF00A3FF
00C1FF00DAFF00EEFF00FBFF00FFFC00FFFB00FFFF00F5FF00E5FF00D0FF00B5FF0097FF
0076FF0052FF002DFF0007FF1D00FF4100FF6200FF7F00FF9900FFAD00FFBC00FFC500FF
C700FFC400FFBB00FFAC00FF9800FF8000FF6500FF4700FF2900FF0B00FF0011FF002AFF
0040FF0051FF005CFF0061FF0060FF0059FF004CFF003BFF0026FF000FFF0700FF1D00FF
3000FF3E00FF4600FF4900FF4400FF3B00FF2D00FF1D00FF0D00FF0000FF0006FF0006FF
0000FF0800FF1000FF1100FF0C00FF0B00FF1200FF1C00FF2300FF2400FF1E00FF1200FF
0300FF000CFF001BFF0026FF002BFF002AFF0022FF0015FF0003FF1100FF2800FF3F00FF
5400FF6700FF7400FF7D00FF7F00FF7B00FF7100FF6100FF4C00FF3300FF1800FF0005FF
0024FF0041FF005DFF0076FF008BFF009BFF00A5FF00AAFF00A8FF00A0FF0093FF007FFF
0067FF004AFF002AFF0007FF1D00FF4300FF6800FF8C00FFAE00FFCD00FFE800FFFF00FF
FF00EFFF00E3FF00DEFF00DEFF00E4FF00F1FC00FFE400FFC700FFA600FF8100FF5800FF
2E00FF0100FF002AFF0057FF0083FF00ADFF00D5FF00F9FF00FFE500FFC900FFB200FFA0
00FF9400FF8E00FF8F00FF9500FFA100FFB300FFCB00FFE800F5FF00CEFF00A4FF0076FF
0046FF0013FF1F00FF5400FF8800FFBB00FFED00FFFF00E3
00FFD300FDFF00CBFF0098FF0064FF0030FF0300FF3600FF6700FF9500FFC000FFE700FF
FF00F5FF00D6FF00BEFF00AAFF009DFF0095FF0094FF0099FF00A4FF00B4FF00CAFF00E6
FA00FFD600FFAF00FF8500FF5A00FF2D00FF0000FF002BFF0056FF007FFF00A5FF00C7FF
00E5FF00FEFF00FFEE00FFE000FFD800FFD700FFDC00FFE600FFF600F3FF00D9FF00BBFF
009AFF0076FF0051FF002BFF0006FF1D00FF3E00FF5B00FF7500FF8900FF9800FFA100FF
A400FFA000FF9700FF8800FF7400FF5C00FF4100FF2300FF0500FF0018FF0034FF004EFF
0064FF0075FF0080FF0085FF0084FF007DFF0070FF005EFF004AFF0033FF001CFF0006FF
0C00FF1A00FF2300FF2500FF2100FF1700FF0900FF0006FF0016FF0022FF0029FF002AFF
0024FF001AFF0012FF0012FF0016FF0017FF0010FF0007FF0000FF0000FF0005FF0010FF
0020FF0030FF003FFF0049FF004EFF004DFF0046FF0039FF0027FF0012FF0400FF1B00FF
3100FF4300FF5100FF5900FF5B00FF5700FF4D00FF3E00FF2900FF1000FF000BFF0029FF
0047FF0065FF0081FF009AFF00AFFF00BEFF00C9FF00CDFF00CCFF00C4FF00B6FF00A3FF
008BFF006EFF004DFF002AFF0005FF1F00FF4500FF6900FF8B00FFAA00FFC500FFDB00FF
EC00FFF800FFFE00FFFD00FFF700FFEA00FFD800FFC000FFA300FF8200FF5D00FF3500FF
0A00FF0021FF004EFF007BFF00A7FF00D1FF00F9FF00FFE200FFC100FFA500FF8E00FF7D
00FF7100FF6B00FF6B00FF7100FF7D00FF8F00FFA700FFC400FFE700F2FF00C8FF009AFF
0069FF0037FF0003FF3000FF6400FF9700FFC900FFF900FF
00FFAC00FFDB00F2FF00BFFF008BFF0057FF0023FF0F00FF4000FF6E00FF9900FFC000FF
E300FFFF00FEFF00E5FF00D1FF00C4FF00BDFF00BBFF00C0FF00CBFF00DBFF00F2F200FF
D300FFAF00FF8800FF5E00FF3300FF0600FF0026FF0052FF007DFF00A6FF00CCFF00EEFF
00FFF300FFDA00FFC700FFB900FFB100FFB000FFB400FFBF00FFCF00FFE500FFFF00E2FF
00C1FF009DFF0078FF0052FF002DFF0009FF1700FF3400FF4E00FF6200FF7100FF7A00FF
7D00FF7900FF7000FF6100FF4D00FF3500FF1A00FF0003FF0021FF003FFF005CFF0075FF
008BFF009CFF00A7FF00ACFF00ABFF00A4FF0097FF0085FF0071FF005AFF0043FF002DFF
001AFF000CFF0003FF0001FF0005FF000FFF001DFF002DFF003DFF0049FF0050FF0051FF
004BFF0042FF0039FF0039FF003DFF003EFF0037FF002EFF0027FF0026FF002CFF0038FF
0047FF0057FF0066FF0070FF0076FF0075FF006DFF0060FF004EFF0039FF0022FF000BFF
0A00FF1C00FF2A00FF3200FF3400FF3000FF2600FF1700FF0200FF0016FF0032FF0050FF
006EFF008CFF00A8FF00C1FF00D6FF00E6FF00F0FF00F5FF00F3FF00EBFF00DDFF00CAFF
00B2FF0095FF0074FF0051FF002CFF0007FF1E00FF4200FF6400FF8300FF9E00FFB400FF
C500FFD100FFD700FFD600FFD000FFC300FFB100FF9900FF7C00FF5B00FF3600FF0E00FF
001CFF0048FF0075FF00A2FF00CEFF00F8FF00FFDF00FFBB00FF9A00FF7E00FF6700FF56
00FF4A00FF4400FF4400FF4A00FF5600FF6800FF8000FF9D00FFBF00FFE600EFFF00C1FF
0091FF005EFF002AFF0900FF3D00FF7000FFA200FFD200FF
00FF8300FFB200FFE300E9FF00B5FF0080FF004DFF001AFF1600FF4400FF6F00FF9700FF
BA00FFD800FFF100FFFF00FBFF00EEFF00E6FF00E5FF00EAFF00F5FA00FFE400FFC900FF
A900FF8500FF5E00FF3500FF0900FF0023FF0050FF007CFF00A7FF00D0FF00F6FF00FFE7
00FFC900FFB000FF9D00FF8F00FF8800FF8600FF8B00FF9500FFA600FFBB00FFD500FFF3
00EAFF00C6FF00A1FF007CFF0056FF0033FF0012FF0B00FF2400FF3800FF4700FF5000FF
5300FF5000FF4600FF3700FF2300FF0B00FF000FFF002CFF004BFF0069FF0085FF009FFF
00B5FF00C5FF00D1FF00D6FF00D5FF00CDFF00C1FF00AFFF009AFF0084FF006CFF0057FF
0044FF0036FF002DFF002BFF002FFF0039FF0047FF0057FF0066FF0073FF007AFF007BFF
0075FF006BFF0063FF0062FF0067FF0068FF0061FF0057FF0050FF0050FF0056FF0061FF
0071FF0081FF008FFF009AFF009FFF009EFF0097FF008AFF0078FF0062FF004BFF0034FF
001FFF000DFF0000FF0800FF0B00FF0700FF0002FF0012FF0027FF0040FF005CFF007AFF
0098FF00B6FF00D2FF00EBFF00FFFF00FFF000FFE500FFE100FFE200FFEA00FFF800F4FF
00DBFF00BFFF009EFF007BFF0056FF0030FF000BFF1800FF3A00FF5900FF7400FF8A00FF
9C00FFA700FFAD00FFAD00FFA600FF9A00FF8700FF6F00FF5300FF3100FF0C00FF001BFF
0046FF0072FF009FFF00CCFF00F8FF00FFDD00FFB600FF9100FF7100FF5500FF3E00FF2C
00FF2000FF1A00FF1A00FF2000FF2D00FF3F00FF5700FF7400FF9600FFBC00FFE700EBFF
00BAFF0088FF0054FF0020FF1300FF4700FF7800FFA800FF
00FF5700FF8600FFB800FFEB00E0FF00ACFF0078FF0045FF0015FF1900FF4400FF6B00FF
8E00FFAC00FFC500FFD800FFE600FFED00FFEE00FFEA00FFDF00FFCE00FFB800FF9D00FF
7D00FF5A00FF3300FF0900FF0022FF004EFF007BFF00A8FF00D3FF00FCFF00FFDE00FFBB
00FF9E00FF8500FF7100FF6400FF5C00FF5B00FF5F00FF6A00FF7A00FF8F00FFAA00FFC8
00FFE900F2FF00CDFF00A7FF0082FF005FFF003DFF0020FF0007FF0D00FF1C00FF2500FF
2700FF2400FF1B00FF0C00FF0007FF001FFF003BFF0058FF0076FF0094FF00B1FF00CAFF
00E0FF00F1FF00FCFF00FFFE00FFFF00F9FF00ECFF00DBFF00C6FF00AFFF0098FF0082FF
006FFF0061FF0059FF0056FF005BFF0064FF0072FF0082FF0092FF009FFF00A6FF00A6FF
00A0FF0097FF008FFF008EFF0093FF0094FF008DFF0083FF007CFF007BFF0081FF008DFF
009CFF00ACFF00BBFF00C6FF00CBFF00CAFF00C2FF00B5FF00A3FF008EFF0077FF0060FF
004BFF0039FF002BFF0022FF0020FF0024FF002EFF003EFF0053FF006CFF0088FF00A5FF
00C4FF00E1FF00FDFF00FFE900FFD400FFC400FFBA00FFB500FFB700FFBE00FFCC00FFE0
00FFF800EAFF00CAFF00A7FF0082FF005CFF0037FF0013FF0E00FF2D00FF4800FF5F00FF
7000FF7C00FF8100FF8100FF7B00FF6E00FF5C00FF4400FF2700FF0600FF001EFF0047FF
0071FF009EFF00CBFF00F7FF00FFDC00FFB200FF8A00FF6600FF4500FF2900FF1200FF00
0BFF0011FF0010FF000AFF0000FF0100FF1300FF2B00FF4800FF6A00FF9100FFBB00FFE9
00E6FF00B3FF0080FF004BFF0017FF1B00FF4D00FF7C00FF
00FF2A00FF5900FF8B00FFBE00FFF200D9FF00A5FF0072FF0041FF0013FF1700FF3E00FF
6100FF7F00FF9800FFAC00FFB900FFC000FFC200FFBD00FFB200FFA200FF8B00FF7000FF
5100FF2D00FF0600FF0023FF004EFF007BFF00A8FF00D4FF00FFFF00FFD700FFB100FF8F
00FF7100FF5800FF4500FF3700FF2F00FF2E00FF3200FF3D00FF4D00FF6300FF7D00FF9B
00FFBC00FFE000FAFF00D4FF00AFFF008BFF006AFF004DFF0033FF001FFF0010FF0007FF
0004FF0008FF0011FF0020FF0034FF004CFF0067FF0085FF00A3FF00C1FF00DEFF00F7FF
00FFF200FFE100FFD600FFD100FFD200FFD900FFE600FFF800F3FF00DCFF00C5FF00AFFF
009CFF008EFF0085FF0083FF0087FF0091FF009FFF00AFFF00BFFF00CBFF00D2FF00D3FF
00CDFF00C4FF00BBFF00BBFF00BFFF00C0FF00B9FF00B0FF00A9FF00A8FF00AEFF00BAFF
00C9FF00D9FF00E8FF00F2FF00F8FF00F7FF00EFFF00E2FF00D0FF00BBFF00A4FF008DFF
0077FF0065FF0057FF004FFF004DFF0051FF005BFF006AFF007FFF0098FF00B4FF00D2FF
00F0FF00FFF100FFD500FFBC00FFA700FF9700FF8D00FF8800FF8A00FF9200FFA000FFB3
00FFCB00FFE800F6FF00D3FF00AEFF0089FF0063FF003FFF001DFF0100FF1C00FF3200FF
4300FF4F00FF5500FF5400FF4E00FF4100FF2F00FF1700FF0005FF0026FF004BFF0073FF
009EFF00CAFF00F7FF00FFDB00FFAF00FF8500FF5D00FF3900FF1803FF001AFF002BFF00
37FF003DFF003DFF0037FF002BFF0019FF0001FF0000FF1B00FF3D00FF6400FF8E00FFBC
00FFEC00E0FF00ACFF0078FF0044FF0011FF2000FF5000FF
02FF0000FF2C00FF5E00FF9100FFC500FFF900D2FF009FFF006EFF0040FF0015FF1100FF
3400FF5300FF6B00FF7F00FF8C00FF9300FF9500FF9000FF8500FF7500FF5F00FF4300FF
2400FF0000FF0026FF0050FF007BFF00A8FF00D5FF00FFFE00FFD300FFAA00FF8400FF62
00FF4400FF2B00FF1800FF0A00FF0200FF0100FF0600FF1000FF2000FF3600FF5000FF6E
00FF8F00FFB300FFD800FFFE00DCFF00B8FF0097FF007AFF0060FF004CFF003DFF0034FF
0031FF0035FF003EFF004DFF0061FF0079FF0094FF00B2FF00D0FF00EEFF00FFF400FFDB
00FFC500FFB400FFA900FFA400FFA500FFAC00FFB900FFCB00FFDF00FFF600F2FF00DCFF
00C9FF00BBFF00B2FF00B0FF00B4FF00BEFF00CCFF00DCFF00ECFF00F8FF00FFFF00FFFF
00FAFF00F0FF00E8FF00E8FF00ECFF00EDFF00E6FF00DDFF00D6FF00D5FF00DBFF00E6FF
00F6FF00FFF900FFEA00FFE000FFDB00FFDB00FFE300FFF000FDFF00E8FF00D1FF00BAFF
00A4FF0092FF0084FF007CFF007AFF007EFF0088FF0097FF00ACFF00C5FF00E1FF00FFFF
00FFE200FFC400FFA800FF8F00FF7A00FF6B00FF6000FF5B00FF5D00FF6500FF7300FF86
00FF9E00FFBB00FFDC00FFFF00DBFF00B6FF0090FF006CFF004AFF002BFF0010FF0500FF
1600FF2200FF2800FF2700FF2100FF1400FF0200FF0015FF0032FF0053FF0078FF00A0FF
00CBFF00F7FF00FFDB00FFAE00FF8200FF5800FF3000FF0C14FF0030FF0047FF0058FF00
64FF006AFF006AFF0064FF0058FF0046FF002EFF0011FF0000FF1000FF3700FF6100FF8F
00FFBF00FFF200D9FF00A5FF0071FF003EFF000CFF2300FF
2EFF0000FF0000FF3100FF6500FF9900FFCD00FEFF00CCFF009BFF006CFF0041FF001AFF
0800FF2600FF3F00FF5200FF6000FF6700FF6800FF6400FF5900FF4800FF3200FF1700FF
0008FF002BFF0052FF007CFF00A8FF00D4FF00FFFE00FFD100FFA600FF7D00FF5800FF35
00FF1800FF0014FF0021FF0029FF002AFF0026FF001BFF000BFF0000FF0900FF2300FF42
00FF6300FF8700FFAC00FFD200FFF700E5FF00C4FF00A6FF008DFF0078FF0069FF0060FF
005EFF0061FF006AFF0079FF008DFF00A5FF00C1FF00DEFF00FCFF00FFE500FFC800FFAE
00FF9900FF8800FF7D00FF7800FF7900FF8000FF8D00FF9E00FFB300FFCA00FFE100FFF7
00F6FF00E7FF00DFFF00DDFF00E1FF00EAFF00F8FF00FFF700FFE700FFDA00FFD300FFD3
00FFD900FFE200FFEA00FFEB00FFE600FFE500FFEC00FFF600FFFD00FFFE00FFF800FFEC
00FFDD00FFCD00FFBE00FFB300FFAE00FFAF00FFB600FFC400FFD600FFEB00FDFF00E6FF
00D1FF00BFFF00B1FF00A9FF00A6FF00AAFF00B4FF00C4FF00D9FF00F2FF00FFF100FFD4
00FFB500FF9700FF7C00FF6300FF4E00FF3E00FF3400FF2F00FF3100FF3800FF4600FF59
00FF7200FF8F00FFAF00FFD200FFF700E2FF00BDFF0099FF0077FF0058FF003DFF0026FF
0015FF0009FF0004FF0004FF000AFF0017FF0029FF0041FF005EFF007FFF00A5FF00CDFF
00F7FF00FFDB00FFAE00FF8200FF5600FF2C00FF041FFF0040FF005CFF0073FF0085FF00
91FF0097FF0097FF0090FF0084FF0072FF005AFF003DFF001BFF0000FF0B00FF3500FF63
00FF9300FFC500FFF900D2FF009DFF006AFF0038FF0009FF
59FF002AFF0000FF0600FF3A00FF6E00FFA200FFD600F7FF00C6FF0097FF006CFF0045FF
0022FF0004FF1400FF2700FF3500FF3C00FF3D00FF3900FF2E00FF1D00FF0700FF0013FF
0033FF0056FF007DFF00A7FF00D3FF00FFFF00FFD300FFA600FF7B00FF5200FF2D00FF0A
12FF002BFF003FFF004CFF0054FF0056FF0051FF0046FF0036FF0021FF0007FF0000FF17
00FF3800FF5C00FF8100FFA700FFCC00FFEF00EFFF00D1FF00B8FF00A3FF0094FF008BFF
0089FF008CFF0095FF00A4FF00B8FF00D0FF00ECFF00FFF600FFD800FFBA00FF9D00FF83
00FF6E00FF5D00FF5200FF4D00FF4E00FF5500FF6200FF7300FF8800FF9F00FFB600FFCC
00FFDE00FFED00FFF500FFF700FFF300FFEA00FFDC00FFCC00FFBC00FFAF00FFA800FFA8
00FFAE00FFB700FFBF00FFC000FFBB00FFBA00FFC100FFCB00FFD200FFD300FFCD00FFC1
00FFB200FFA200FF9300FF8800FF8300FF8400FF8B00FF9900FFAB00FFC000FFD700FFEE
00FCFF00EAFF00DCFF00D4FF00D1FF00D5FF00DFFF00EFFF00FFFB00FFE200FFC600FFA9
00FF8A00FF6C00FF5100FF3800FF2300FF1300FF0900FF0400FF0600FF0D00FF1B00FF2E
00FF4700FF6400FF8400FFA700FFCC00FFF200E8FF00C4FF00A2FF0083FF0068FF0051FF
0040FF0034FF002FFF002FFF0036FF0042FF0054FF006CFF0089FF00AAFF00D0FF00F8FF
00FFDD00FFB000FF8300FF5700FF2B00FF0126FF004AFF006BFF0087FF009EFF00B0FF00
BCFF00C2FF00C2FF00BBFF00AFFF009DFF0085FF0068FF0046FF001FFF0000FF0A00FF38
00FF6800FF9A00FFCE00FDFF00C8FF0095FF0063FF0034FF
82FF0053FF0021FF0000FF1100FF4500FF7900FFAD00FFE000EFFF00C0FF0095FF006EFF
004BFF002DFF0014FF0001FF0C00FF1300FF1500FF1000FF0500FF000BFF0021FF003CFF
005CFF007FFF00A6FF00D0FF00FCFF00FFD700FFAA00FF7D00FF5200FF2A00FF041DFF00
3BFF0054FF0067FF0075FF007DFF007EFF007AFF006FFF005FFF004AFF002FFF0011FF00
00FF0F00FF3300FF5800FF7E00FFA300FFC700FFE800FAFF00E0FF00CCFF00BDFF00B4FF
00B1FF00B5FF00BEFF00CDFF00E1FF00F9FF00FFEB00FFCD00FFAF00FF9100FF7400FF5B
00FF4500FF3400FF2900FF2400FF2500FF2C00FF3900FF4A00FF5F00FF7600FF8D00FFA3
00FFB600FFC400FFCC00FFCF00FFCB00FFC100FFB300FFA300FF9300FF8600FF7F00FF7F
00FF8500FF8E00FF9600FF9700FF9200FF9100FF9800FFA200FFA900FFAA00FFA400FF98
00FF8900FF7900FF6A00FF6000FF5A00FF5B00FF6300FF7000FF8200FF9700FFAE00FFC5
00FFDA00FFED00FFFA00FCFF00FAFF00FEFF00FFF700FFE700FFD300FFBA00FF9E00FF80
00FF6100FF4400FF2800FF0F05FF0015FF001FFF0024FF0022FF001AFF000DFF0000FF06
00FF1E00FF3B00FF5B00FF7E00FFA300FFC900FFEE00ECFF00CAFF00ACFF0091FF007AFF
0069FF005DFF0058FF0058FF005EFF006BFF007DFF0095FF00B2FF00D3FF00F8FF00FFDE
00FFB400FF8800FF5B00FF2E00FF0227FF004FFF0073FF0094FF00B0FF00C7FF00D9FF00
E4FF00EAFF00EAFF00E4FF00D8FF00C6FF00AEFF0091FF006FFF0048FF001EFF0000FF0F
00FF3F00FF7200FFA500FFDA00F1FF00BEFF008CFF005CFF
A8FF0079FF0047FF0014FF0000FF1F00FF5300FF8700FFBA00FFEB00E6FF00BBFF0094FF
0071FF0053FF003AFF0026FF0019FF0012FF0010FF0015FF0020FF0031FF0047FF0062FF
0081FF00A5FF00CCFF00F6FF00FFDE00FFB100FF8400FF5800FF2D00FF0421FF0043FF00
61FF007AFF008DFF009BFF00A3FF00A4FF00A0FF0095FF0085FF006FFF0055FF0037FF00
16FF0000FF0D00FF3200FF5800FF7D00FFA100FFC200FFDF00FFF900F2FF00E3FF00DAFF
00D7FF00DBFF00E4FF00F3FF00FFF800FFE000FFC500FFA700FF8900FF6B00FF4E00FF35
00FF1F00FF0E00FF0301FF0000FF0000FF0600FF1300FF2400FF3900FF5000FF6700FF7D
00FF9000FF9E00FFA700FFA900FFA500FF9B00FF8D00FF7D00FF6D00FF6100FF5900FF59
00FF5F00FF6800FF7100FF7100FF6D00FF6C00FF7300FF7C00FF8300FF8400FF7E00FF72
00FF6300FF5300FF4400FF3A00FF3400FF3500FF3D00FF4A00FF5C00FF7100FF8800FF9F
00FFB500FFC700FFD400FFDD00FFDF00FFDB00FFD100FFC100FFAD00FF9400FF7800FF5A
00FF3B00FF1E00FF0216FF002BFF003BFF0045FF004AFF0048FF0040FF0033FF001FFF00
07FF0000FF1500FF3600FF5900FF7E00FFA300FFC900FFED00F0FF00D1FF00B6FF00A0FF
008FFF0083FF007DFF007EFF0084FF0091FF00A3FF00BBFF00D8FF00F9FF00FFE100FFB9
00FF8E00FF6200FF3500FF0823FF004DFF0075FF0099FF00BAFF00D6FF00EDFF00FEFF00
FFF500FFEF00FFEF00FFF500FEFF00ECFF00D4FF00B7FF0095FF006EFF0044FF0016FF00
00FF1900FF4C00FF8000FFB400FFE800E4FF00B2FF0082FF
CAFF009BFF0069FF0036FF0002FF0000FF3100FF6500FF9800FFC900FFF700DDFF00B6FF
0093FF0075FF005CFF0049FF003BFF0034FF0032FF0037FF0042FF0053FF0069FF0084FF
00A3FF00C7FF00EEFF00FFE700FFBB00FF8F00FF6200FF3500FF0A1DFF0043FF0065FF00
83FF009CFF00AFFF00BDFF00C5FF00C6FF00C2FF00B7FF00A7FF0091FF0077FF0059FF00
38FF0014FF0000FF1000FF3600FF5B00FF7F00FFA000FFBD00FFD700FFEB00FFFA00FCFF
00F9FF00FDFF00FFF900FFEA00FFD600FFBE00FFA300FF8500FF6700FF4900FF2C00FF13
02FF0013FF001EFF0023FF0022FF001BFF000EFF0000FF0200FF1700FF2E00FF4500FF5B
00FF6E00FF7C00FF8400FF8700FF8300FF7900FF6B00FF5B00FF4B00FF3F00FF3700FF37
00FF3D00FF4600FF4E00FF4F00FF4A00FF4900FF5000FF5A00FF6100FF6200FF5C00FF50
00FF4100FF3100FF2200FF1800FF1200FF1300FF1B00FF2800FF3A00FF4F00FF6600FF7D
00FF9200FFA500FFB200FFBB00FFBD00FFB900FFAF00FF9F00FF8B00FF7200FF5600FF38
00FF1903FF001FFF0038FF004DFF005DFF0067FF006CFF006AFF0062FF0055FF0041FF00
29FF000CFF0000FF1300FF3700FF5B00FF8100FFA600FFCB00FFED00F4FF00D9FF00C2FF
00B1FF00A5FF009FFF00A0FF00A6FF00B3FF00C5FF00DDFF00FAFF00FFE400FFBF00FF96
00FF6C00FF4000FF1319FF0045FF006FFF0097FF00BBFF00DCFF00F8FF00FFF000FFDF00
FFD300FFCD00FFCD00FFD300FFDF00FFF100F6FF00D9FF00B7FF0090FF0066FF0038FF00
08FF0000FF2A00FF5D00FF9200FFC600FFF900D4FF00A4FF
E8FF00B9FF0087FF0054FF0020FF0000FF1300FF4700FF7A00FFAB00FFD900FBFF00D4FF
00B1FF0092FF007AFF0066FF0059FF0051FF0050FF0055FF0060FF0070FF0086FF00A2FF
00C1FF00E5FF00FFF300FFC900FF9E00FF7100FF4400FF1812FF003BFF0061FF0083FF00
A1FF00BAFF00CDFF00DBFF00E3FF00E4FF00DFFF00D5FF00C5FF00AFFF0095FF0077FF00
56FF0032FF000DFF0000FF1800FF3D00FF6100FF8200FF9F00FFB900FFCD00FFDC00FFE5
00FFE800FFE400FFDB00FFCC00FFB800FFA000FF8500FF6700FF4900FF2B00FF0F0AFF00
20FF0031FF003CFF0041FF0040FF0039FF002CFF001AFF0006FF0000FF1000FF2700FF3D
00FF5000FF5E00FF6700FF6900FF6500FF5B00FF4D00FF3D00FF2D00FF2100FF1A00FF19
00FF1F00FF2900FF3100FF3100FF2D00FF2C00FF3300FF3C00FF4300FF4400FF3E00FF33
00FF2300FF1300FF0505FF000AFF0009FF0002FF0000FF0A00FF1C00FF3100FF4800FF5F
00FF7500FF8700FF9500FF9D00FF9F00FF9B00FF9100FF8200FF6D00FF5400FF3800FF1A
03FF0021FF003DFF0056FF006BFF007AFF0085FF0089FF0088FF0080FF0072FF005FFF00
47FF002AFF0009FF0000FF1900FF3E00FF6300FF8900FFAD00FFCF00FFEE00F6FF00E0FF
00CFFF00C3FF00BDFF00BEFF00C4FF00D1FF00E3FF00FBFF00FFE700FFC600FFA100FF79
00FF4E00FF220AFF0037FF0063FF008DFF00B5FF00D9FF00F9FF00FFE900FFD200FFC100
FFB500FFAF00FFAF00FFB500FFC100FFD300FFEB00F7FF00D4FF00AEFF0084FF0056FF00
25FF0000FF0C00FF4000FF7400FFA800FFDB00F2FF00C2FF
FFFF00D1FF00A0FF006DFF0039FF0004FF0000FF2E00FF6100FF9200FFC000FFEB00ECFF
00C9FF00ABFF0092FF007FFF0072FF006AFF0069FF006EFF0079FF0089FF009FFF00BAFF
00DAFF00FEFF00FFDA00FFB000FF8500FF5800FF2B00FF002BFF0054FF007AFF009CFF00
BAFF00D3FF00E6FF00F4FF00FBFF00FDFF00F8FF00EEFF00DEFF00C8FF00AEFF0090FF00
6EFF004BFF0025FF0000FF0000FF2400FF4800FF6900FF8700FFA000FFB400FFC300FFCC
00FFCF00FFCC00FFC200FFB300FF9F00FF8700FF6C00FF4F00FF3000FF1209FF0023FF00
39FF0049FF0055FF005AFF0059FF0051FF0045FF0033FF001EFF0008FF0000FF0F00FF24
00FF3700FF4500FF4E00FF5000FF4C00FF4200FF3400FF2400FF1500FF0800FF0100FF00
00FF0600FF1000FF1800FF1800FF1400FF1300FF1A00FF2400FF2A00FF2B00FF2500FF1A
00FF0A05FF0013FF001EFF0023FF0022FF001BFF000EFF0000FF0300FF1800FF3000FF47
00FF5C00FF6E00FF7C00FF8400FF8600FF8300FF7900FF6900FF5400FF3B00FF1F00FF01
1CFF003AFF0056FF006FFF0083FF0093FF009EFF00A2FF00A1FF0099FF008BFF0078FF00
5FFF0043FF0022FF0000FF0000FF2500FF4A00FF7000FF9400FFB600FFD500FFF000F9FF
00E8FF00DCFF00D6FF00D6FF00DDFF00E9FF00FCFF00FFEB00FFCF00FFAD00FF8800FF60
00FF3500FF0923FF0050FF007CFF00A6FF00CDFF00F2FF00FFED00FFD100FFBA00FFA800
FF9C00FF9600FF9600FF9C00FFA800FFBB00FFD200FFF000EDFF00C7FF009CFF006FFF00
3EFF000CFF0000FF2700FF5B00FF8F00FFC300FFF400DBFF
FFEB00E5FF00B3FF0080FF004CFF0018FF0000FF1B00FF4E00FF7E00FFAD00FFD800FFFF
00DDFF00BFFF00A6FF0093FF0085FF007EFF007CFF0081FF008CFF009DFF00B3FF00CEFF
00EEFF00FFEE00FFC700FF9D00FF7100FF4500FF1814FF003FFF0067FF008DFF00AFFF00
CDFF00E6FF00F9FF00FFF800FFF000FFEF00FFF300FFFE00F1FF00DCFF00C1FF00A3FF00
82FF005EFF0039FF0013FF0000FF1100FF3500FF5600FF7300FF8D00FFA100FFB000FFB9
00FFBC00FFB800FFAF00FFA000FF8C00FF7400FF5900FF3B00FF1D00FF001DFF0036FF00
4CFF005DFF0068FF006DFF006CFF0065FF0058FF0047FF0032FF001BFF0004FF0000FF11
00FF2400FF3200FF3A00FF3D00FF3900FF2F00FF2100FF1100FF010BFF0012FF0012FF00
0CFF0003FF0000FF0400FF0500FF0000FF0000FF0600FF1000FF1700FF1800FF1200FF06
08FF0018FF0027FF0031FF0037FF0036FF002EFF0021FF000FFF0000FF0500FF1C00FF33
00FF4800FF5B00FF6800FF7100FF7300FF6F00FF6500FF5500FF4100FF2800FF0C11FF00
30FF004DFF0069FF0082FF0097FF00A7FF00B1FF00B6FF00B4FF00ACFF009FFF008BFF00
73FF0056FF0036FF0013FF0000FF1100FF3700FF5C00FF8100FFA200FFC100FFDC00FFF3
00FBFF00EFFF00EAFF00EAFF00F0FF00FDFF00FFF000FFD800FFBB00FF9A00FF7500FF4C
00FF2209FF0036FF0063FF008FFF00B9FF00E1FF00FFFA00FFD900FFBD00FFA600FF9400
FF8900FF8300FF8300FF8900FF9500FFA700FFBF00FFDC00FFFE00DAFF00B0FF0082FF00
52FF001FFF0000FF1300FF4800FF7C00FFAF00FFE100EEFF
FFDD00F2FF00C1FF008EFF005AFF0026FF0000FF0D00FF4000FF7100FF9F00FFCA00FFF1
00EBFF00CCFF00B4FF00A0FF0093FF008BFF008AFF008FFF009AFF00AAFF00C0FF00DCFF
00FBFF00FFE000FFB900FF8F00FF6400FF3700FF0A21FF004CFF0075FF009BFF00BDFF00
DBFF00F4FF00FFF800FFEA00FFE300FFE100FFE600FFF000FFFF00E9FF00CFFF00B1FF00
8FFF006CFF0046FF0021FF0000FF0300FF2700FF4800FF6600FF7F00FF9300FFA200FFAB
00FFAE00FFAA00FFA100FF9200FF7E00FF6600FF4B00FF2D00FF0F0EFF002AFF0044FF00
5AFF006BFF0076FF007BFF007AFF0072FF0066FF0054FF0040FF0029FF0012FF0000FF03
00FF1600FF2400FF2D00FF2F00FF2B00FF2100FF1300FF030CFF0018FF001FFF0020FF00
1AFF0010FF0008FF0008FF000CFF000DFF0006FF0000FF0200FF0900FF0A00FF0406FF00
16FF0026FF0034FF003FFF0044FF0043FF003CFF002FFF001DFF0008FF0000FF0E00FF25
00FF3B00FF4D00FF5B00FF6300FF6500FF6100FF5700FF4800FF3300FF1A01FF001FFF00
3DFF005BFF0077FF0090FF00A4FF00B4FF00BFFF00C3FF00C2FF00BAFF00ACFF0099FF00
81FF0064FF0043FF0020FF0000FF0400FF2900FF4F00FF7300FF9500FFB400FFCF00FFE5
00FFF600FDFF00F7FF00F8FF00FEFF00FFF400FFE200FFCA00FFAD00FF8C00FF6700FF3F
00FF1417FF0044FF0071FF009DFF00C7FF00EFFF00FFEC00FFCC00FFB000FF9800FF8700
FF7B00FF7500FF7500FF7B00FF8700FF9A00FFB100FFCF00FFF100E8FF00BEFF0090FF00
5FFF002DFF0000FF0600FF3A00FF6E00FFA100FFD300FCFF
FFD600FAFF00C9FF0096FF0062FF002DFF0000FF0600FF3800FF6900FF9700FFC300FFEA
00F2FF00D4FF00BBFF00A8FF009AFF0093FF0092FF0097FF00A1FF00B2FF00C8FF00E3FF
00FFFC00FFD800FFB100FF8800FF5C00FF2F00FF0229FF0054FF007DFF00A3FF00C5FF00
E3FF00FBFF00FFF000FFE300FFDB00FFD900FFDE00FFE800FFF900F1FF00D7FF00B9FF00
97FF0073FF004EFF0028FF0003FF0000FF1F00FF4000FF5E00FF7700FF8C00FF9A00FFA3
00FFA600FFA300FF9900FF8B00FF7700FF5F00FF4300FF2600FF0716FF0032FF004CFF00
61FF0072FF007DFF0082FF0081FF007AFF006DFF005CFF0047FF0030FF0019FF0003FF00
00FF0E00FF1D00FF2500FF2700FF2300FF1900FF0C04FF0013FF0020FF0027FF0027FF00
22FF0018FF0010FF000FFF0014FF0015FF000EFF0004FF0000FF0200FF0302FF000EFF00
1DFF002EFF003CFF0047FF004CFF004BFF0044FF0037FF0025FF000FFF0000FF0700FF1E
00FF3300FF4500FF5300FF5B00FF5E00FF5A00FF5000FF4000FF2B00FF1209FF0027FF00
45FF0063FF007FFF0097FF00ACFF00BCFF00C7FF00CBFF00CAFF00C2FF00B4FF00A1FF00
88FF006BFF004BFF0028FF0003FF0000FF2200FF4700FF6B00FF8D00FFAC00FFC700FFDD
00FFEF00FFFA00FFFF00FFFF00FFF900FFED00FFDA00FFC300FFA600FF8400FF5F00FF37
00FF0C1FFF004CFF0079FF00A4FF00CFFF00F6FF00FFE400FFC400FFA800FF9100FF7F00
FF7300FF6D00FF6D00FF7300FF8000FF9200FFAA00FFC700FFE900F0FF00C5FF0097FF00
67FF0035FF0001FF0000FF3200FF6600FF9A00FFCC00FFFB
FFD400FCFF00CAFF0097FF0063FF002FFF0000FF0400FF3700FF6800FF9600FFC100FFE8
00F4FF00D6FF00BDFF00A9FF009CFF0095FF0093FF0098FF00A3FF00B4FF00CAFF00E5FF
00FFFB00FFD700FFB000FF8600FF5B00FF2E00FF012AFF0056FF007EFF00A4FF00C6FF00
E4FF00FDFF00FFEF00FFE100FFD900FFD800FFDC00FFE700FFF700F2FF00D8FF00BAFF00
99FF0075FF0050FF002AFF0005FF0000FF1E00FF3F00FF5C00FF7600FF8A00FF9900FFA2
00FFA500FFA100FF9800FF8900FF7500FF5D00FF4200FF2400FF0617FF0034FF004DFF00
63FF0074FF007FFF0084FF0083FF007CFF006FFF005EFF0049FF0032FF001BFF0005FF00
00FF0D00FF1B00FF2400FF2600FF2200FF1800FF0A05FF0015FF0021FF0029FF0029FF00
23FF001AFF0012FF0011FF0015FF0016FF000FFF0006FF0000FF0000FF0104FF0010FF00
1FFF002FFF003EFF0048FF004EFF004DFF0045FF0038FF0026FF0011FF0000FF0500FF1C
00FF3200FF4400FF5100FF5A00FF5C00FF5800FF4E00FF3E00FF2A00FF110AFF0028FF00
47FF0064FF0080FF0099FF00AEFF00BEFF00C8FF00CDFF00CBFF00C3FF00B6FF00A2FF00
8AFF006DFF004DFF0029FF0004FF0000FF2000FF4600FF6A00FF8C00FFAA00FFC500FFDC
00FFED00FFF900FFFF00FFFE00FFF800FFEB00FFD900FFC100FFA400FF8300FF5E00FF36
00FF0B20FF004DFF007AFF00A6FF00D0FF00F8FF00FFE300FFC200FFA600FF8F00FF7E00
FF7200FF6C00FF6C00FF7200FF7E00FF9000FFA800FFC500FFE700F1FF00C7FF0099FF00
69FF0036FF0003FF0000FF3100FF6500FF9800FFCA00FFFA
FFD900F7FF00C6FF0093FF005EFF002AFF0000FF0900FF3B00FF6C00FF9A00FFC600FFED
00EFFF00D1FF00B8FF00A5FF0097FF0090FF008FFF0094FF009EFF00AFFF00C5FF00E0FF
00FFFF00FFDC00FFB400FF8B00FF5F00FF3200FF0626FF0051FF007AFF00A0FF00C2FF00
DFFF00F8FF00FFF300FFE600FFDE00FFDC00FFE100FFEC00FFFC00EEFF00D4FF00B5FF00
94FF0070FF004BFF0025FF0000FF0000FF2200FF4300FF6100FF7A00FF8F00FF9E00FFA6
00FFA900FFA600FF9D00FF8E00FF7A00FF6200FF4600FF2900FF0A13FF002FFF0049FF00
5EFF006FFF007AFF007FFF007EFF0077FF006AFF0059FF0044FF002DFF0016FF0000FF00
00FF1100FF2000FF2800FF2A00FF2600FF1D00FF0F01FF0010FF001DFF0024FF0024FF00
1FFF0015FF000DFF000CFF0011FF0012FF000BFF0001FF0000FF0500FF0600FF000BFF00
1AFF002BFF0039FF0044FF0049FF0048FF0041FF0033FF0022FF000CFF0000FF0A00FF21
00FF3600FF4800FF5600FF5E00FF6100FF5D00FF5300FF4300FF2E00FF1506FF0024FF00
42FF0060FF007BFF0094FF00A9FF00B9FF00C3FF00C8FF00C6FF00BFFF00B1FF009EFF00
85FF0068FF0048FF0025FF0000FF0000FF2500FF4A00FF6E00FF9000FFAF00FFCA00FFE0
00FFF200FFFD00FCFF00FCFF00FFFC00FFF000FFDE00FFC600FFA900FF8800FF6200FF3A
00FF0F1CFF0049FF0076FF00A1FF00CCFF00F3FF00FFE700FFC700FFAB00FF9400FF8200
FF7600FF7000FF7000FF7700FF8300FF9500FFAD00FFCA00FFEC00EDFF00C2FF0094FF00
64FF0032FF0000FF0100FF3500FF6A00FF9D00FFCF00FFFE
FFE300EDFF00BBFF0088FF0054FF0020FF0000FF1300FF4600FF7700FFA500FFD000FFF7
00E5FF00C6FF00AEFF009AFF008DFF0085FF0084FF0089FF0094FF00A4FF00BAFF00D6FF
00F5FF00FFE600FFBF00FF9500FF6A00FF3D00FF101BFF0046FF006FFF0095FF00B7FF00
D5FF00EEFF00FFFE00FFF000FFE800FFE700FFEC00FFF600F9FF00E3FF00C9FF00ABFF00
8AFF0066FF0041FF001BFF0000FF0900FF2D00FF4E00FF6B00FF8500FF9900FFA800FFB1
00FFB400FFB000FFA700FF9800FF8400FF6C00FF5100FF3300FF1508FF0024FF003EFF00
54FF0065FF0070FF0075FF0074FF006DFF0060FF004EFF003AFF0023FF000CFF0000FF09
00FF1C00FF2A00FF3300FF3500FF3100FF2700FF1900FF0906FF0012FF0019FF001AFF00
14FF000AFF0002FF0002FF0006FF0007FF0000FF0000FF0800FF0F00FF1000FF0A00FF00
10FF0020FF002FFF0039FF003EFF003DFF0036FF0029FF0017FF0002FF0000FF1400FF2B
00FF4100FF5300FF6100FF6900FF6B00FF6700FF5D00FF4E00FF3900FF2000FF0419FF00
37FF0055FF0071FF008AFF009FFF00AEFF00B9FF00BDFF00BCFF00B4FF00A6FF0093FF00
7BFF005EFF003DFF001AFF0000FF0A00FF2F00FF5500FF7900FF9B00FFBA00FFD500FFEB
00FFFC00F7FF00F1FF00F2FF00F8FF00FFFA00FFE800FFD000FFB300FF9200FF6D00FF45
00FF1A11FF003EFF006BFF0097FF00C1FF00E9FF00FFF200FFD200FFB500FF9E00FF8D00
FF8100FF7B00FF7B00FF8100FF8D00FF9F00FFB700FFD400FFF700E2FF00B8FF008AFF00
59FF0027FF0000FF0C00FF4000FF7400FFA700FFD900F6FF
FFF400DCFF00ABFF0078FF0044FF000FFF0000FF2300FF5600FF8700FFB500FFE000F7FF
00D4FF00B6FF009DFF008AFF007DFF0075FF0074FF0079FF0084FF0094FF00AAFF00C5FF
00E5FF00FFF600FFCF00FFA600FF7A00FF4D00FF200BFF0036FF005FFF0085FF00A7FF00
C5FF00DEFF00F1FF00FFFF00FFF900FFF700FFFC00F9FF00E8FF00D3FF00B9FF009BFF00
79FF0056FF0030FF000BFF0000FF1900FF3D00FF5E00FF7C00FF9500FFA900FFB800FFC1
00FFC400FFC100FFB700FFA800FF9400FF7C00FF6100FF4400FF2500FF0714FF002EFF00
44FF0054FF0060FF0065FF0064FF005CFF0050FF003EFF0029FF0013FF0000FF0400FF19
00FF2C00FF3A00FF4300FF4500FF4100FF3700FF2900FF1900FF0A02FF0009FF000AFF00
04FF0000FF0500FF0D00FF0E00FF0900FF0800FF0F00FF1900FF2000FF2000FF1A00FF0F
00FF0010FF001EFF0029FF002EFF002DFF0026FF0019FF0007FF0000FF0E00FF2500FF3C
00FF5100FF6300FF7100FF7900FF7B00FF7800FF6E00FF5E00FF4900FF3000FF1409FF00
27FF0045FF0061FF007AFF008EFF009EFF00A9FF00ADFF00ACFF00A4FF0096FF0083FF00
6AFF004EFF002DFF000AFF0000FF1A00FF4000FF6500FF8900FFAB00FFCA00FFE500FFFB
00F2FF00E7FF00E1FF00E1FF00E8FF00F4FF00FFF800FFE000FFC400FFA200FF7D00FF55
00FF2A01FF002EFF005BFF0087FF00B1FF00D8FF00FDFF00FFE200FFC600FFAF00FF9D00
FF9100FF8B00FF8B00FF9100FF9E00FFB000FFC800FFE500F8FF00D2FF00A7FF007AFF00
49FF0017FF0000FF1C00FF5000FF8400FFB800FFE900E6FF
F6FF00C7FF0095FF0062FF002EFF0000FF0500FF3900FF6C00FF9C00FFCB00FFF600E2FF
00BFFF00A1FF0088FF0075FF0067FF0060FF005FFF0063FF006EFF007FFF0095FF00B0FF
00D0FF00F3FF00FFE500FFBB00FF8F00FF6300FF3600FF0921FF004AFF006FFF0091FF00
AFFF00C8FF00DCFF00E9FF00F1FF00F2FF00EEFF00E3FF00D3FF00BEFF00A3FF0085FF00
64FF0040FF001BFF0000FF0A00FF2F00FF5300FF7400FF9100FFAB00FFBF00FFCE00FFD7
00FFD900FFD600FFCD00FFBE00FFAA00FF9200FF7700FF5900FF3B00FF1D00FF0018FF00
2EFF003FFF004AFF004FFF004EFF0047FF003AFF0029FF0014FF0000FF0200FF1900FF2F
00FF4200FF5000FF5800FF5B00FF5600FF4D00FF3F00FF2F00FF1F00FF1200FF0B00FF0B
00FF1100FF1A00FF2200FF2300FF1E00FF1D00FF2400FF2E00FF3500FF3600FF3000FF24
00FF1500FF0509FF0014FF0019FF0018FF0010FF0003FF0000FF0E00FF2300FF3A00FF51
00FF6600FF7900FF8600FF8F00FF9100FF8D00FF8300FF7300FF5E00FF4600FF2A00FF0C
12FF002FFF004BFF0064FF0079FF0089FF0093FF0098FF0096FF008EFF0081FF006DFF00
55FF0038FF0018FF0000FF0A00FF2F00FF5500FF7A00FF9F00FFC000FFDF00FFFA00EEFF
00DDFF00D1FF00CCFF00CCFF00D2FF00DFFF00F1FF00FFF600FFD900FFB800FF9300FF6A
00FF4000FF1318FF0045FF0071FF009BFF00C3FF00E7FF00FFF700FFDB00FFC400FFB200
FFA600FFA000FFA100FFA700FFB300FFC500FFDD00FFFA00E3FF00BCFF0092FF0064FF00
34FF0001FF0000FF3100FF6600FF9A00FFCD00FFFF00D1FF
DCFF00ADFF007BFF0048FF0014FF0000FF1F00FF5300FF8600FFB700FFE500EFFF00C8FF
00A5FF0087FF006EFF005AFF004DFF0046FF0044FF0049FF0054FF0065FF007BFF0096FF
00B5FF00D9FF00FFFF00FFD500FFAA00FF7D00FF5000FF2307FF002FFF0055FF0077FF00
95FF00AEFF00C1FF00CFFF00D7FF00D8FF00D4FF00C9FF00B9FF00A3FF0089FF006BFF00
4AFF0026FF0001FF0000FF2400FF4900FF6D00FF8E00FFAB00FFC500FFD900FFE800FFF1
00FFF400FFF000FFE700FFD800FFC400FFAC00FF9100FF7300FF5500FF3700FF1A00FF01
14FF0025FF0030FF0035FF0034FF002DFF0020FF000FFF0000FF0500FF1C00FF3300FF49
00FF5C00FF6A00FF7200FF7500FF7100FF6700FF5900FF4900FF3900FF2D00FF2500FF25
00FF2B00FF3400FF3C00FF3D00FF3900FF3700FF3F00FF4800FF4F00FF5000FF4A00FF3E
00FF2F00FF1F00FF1000FF0600FF0000FF0100FF0900FF1600FF2800FF3D00FF5400FF6B
00FF8100FF9300FFA000FFA900FFAB00FFA700FF9D00FF8D00FF7900FF6000FF4400FF26
00FF0715FF0031FF004AFF005FFF006FFF0079FF007EFF007CFF0074FF0067FF0053FF00
3BFF001EFF0000FF0100FF2500FF4900FF6F00FF9500FFB900FFDB00FFF900EBFF00D4FF
00C3FF00B7FF00B1FF00B2FF00B8FF00C5FF00D7FF00EFFF00FFF300FFD200FFAD00FF84
00FF5A00FF2E00FF012BFF0057FF0081FF00A9FF00CDFF00EEFF00FFF500FFDE00FFCD00
FFC100FFBB00FFBB00FFC100FFCD00FFDF00FFF700EBFF00C9FF00A2FF0078FF004AFF00
1AFF0000FF1800FF4B00FF8000FFB400FFE700E6FF00B6FF
BEFF008FFF005DFF002AFF0000FF0900FF3D00FF7100FFA400FFD500FCFF00D1FF00AAFF
0087FF0068FF0050FF003CFF002FFF0027FF0026FF002BFF0036FF0046FF005CFF0078FF
0097FF00BBFF00E2FF00FFF300FFC800FF9B00FF6E00FF4200FF1711FF0037FF0059FF00
77FF0090FF00A3FF00B1FF00B9FF00BAFF00B5FF00ABFF009BFF0085FF006BFF004DFF00
2CFF0008FF0000FF1C00FF4200FF6700FF8B00FFAC00FFC900FFE300FFF700F9FF00F0FF
00EDFF00F1FF00FAFF00FFF600FFE200FFCA00FFAF00FF9100FF7300FF5500FF3900FF1F
00FF0907FF0012FF0017FF0016FF000FFF0002FF0000FF0F00FF2300FF3A00FF5100FF67
00FF7A00FF8800FF9100FF9300FF8F00FF8500FF7700FF6700FF5700FF4B00FF4400FF43
00FF4900FF5300FF5B00FF5B00FF5700FF5600FF5D00FF6600FF6D00FF6E00FF6800FF5D
00FF4D00FF3D00FF2E00FF2400FF1F00FF2000FF2700FF3400FF4600FF5B00FF7200FF89
00FF9F00FFB100FFBF00FFC700FFC900FFC500FFBB00FFAC00FF9700FF7E00FF6200FF44
00FF2600FF0813FF002CFF0041FF0050FF005BFF005FFF005EFF0056FF0048FF0035FF00
1DFF0000FF0000FF2000FF4300FF6800FF8D00FFB300FFD700FFF900E7FF00CCFF00B6FF
00A5FF0099FF0093FF0094FF009AFF00A7FF00B9FF00D1FF00EEFF00FFF000FFCB00FFA3
00FF7800FF4C00FF1F0DFF0039FF0063FF008BFF00AFFF00CFFF00ECFF00FFFC00FFEB00
FFDF00FFD900FFD900FFDF00FFEB00FFFD00EAFF00CDFF00AAFF0084FF005AFF002CFF00
00FF0400FF3600FF6A00FF9E00FFD200FAFF00C8FF0098FF
9CFF006DFF003CFF0009FF0000FF2A00FF5F00FF9300FFC500FFF600DBFF00AFFF0088FF
0065FF0047FF002EFF001BFF000DFF0006FF0005FF000AFF0014FF0025FF003BFF0056FF
0076FF009AFF00C1FF00EAFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006EFF0082FF008FFF0097FF0099FF0094FF008AFF0079FF0064FF004AFF002CFF00
0AFF0000FF1900FF3E00FF6400FF8900FFAC00FFCD00FFEB00FBFF00E6FF00D8FF00CFFF
00CCFF00CFFF00D9FF00E7FF00FBFF00FFEC00FFD000FFB300FF9400FF7600FF5A00FF40
00FF2B00FF1A00FF0F00FF0A00FF0B00FF1200FF1F00FF3000FF4500FF5C00FF7300FF89
00FF9B00FFAA00FFB200FFB400FFB000FFA600FF9900FF8800FF7900FF6C00FF6500FF65
00FF6A00FF7400FF7C00FF7D00FF7800FF7700FF7E00FF8800FF8F00FF9000FF8A00FF7E
00FF6F00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7D00FF9400FFAB
00FFC000FFD200FFE000FFE800FFEB00FFE700FFDD00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0AFF001FFF002FFF003AFF003EFF003CFF0035FF0027FF0014FF00
00FF0400FF2100FF4100FF6400FF8900FFAF00FFD400FFF800E5FF00C6FF00ABFF0095FF
0083FF0078FF0072FF0072FF0079FF0085FF0098FF00AFFF00CCFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1317FF0042FF0069FF008EFF00AEFF00CAFF00E1FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F2FF00E0FF00C8FF00ABFF0089FF0063FF0038FF000AFF00
00FF2500FF5700FF8B00FFBF00FFF300D8FF00A6FF0077FF
78FF0049FF0018FF0000FF1A00FF4E00FF8300FFB600FFE900E5FF00B7FF008CFF0064FF
0041FF0023FF000AFF0800FF1500FF1D00FF1E00FF1900FF0E00FF0001FF0017FF0032FF
0052FF0076FF009DFF00C6FF00F2FF00FFE000FFB300FF8700FF5C00FF3300FF0D14FF00
32FF004BFF005EFF006CFF0073FF0075FF0070FF0066FF0056FF0040FF0026FF0008FF00
00FF1900FF3C00FF6200FF8700FFAC00FFD000FFF100F0FF00D7FF00C3FF00B4FF00ABFF
00A8FF00ABFF00B5FF00C4FF00D8FF00F0FF00FFF400FFD700FFB800FF9A00FF7E00FF64
00FF4E00FF3E00FF3200FF2D00FF2E00FF3600FF4200FF5400FF6900FF7F00FF9700FFAC
00FFBF00FFCD00FFD600FFD800FFD400FFCA00FFBC00FFAC00FF9D00FF9000FF8900FF88
00FF8E00FF9800FFA000FFA100FF9C00FF9B00FFA200FFAC00FFB200FFB300FFAD00FFA2
00FF9200FF8200FF7400FF6900FF6400FF6500FF6C00FF7900FF8B00FFA100FFB800FFCF
00FFE400FFF600FBFF00F3FF00F1FF00F4FF00FEFF00FFF100FFDC00FFC300FFA700FF89
00FF6B00FF4D00FF3100FF1800FF040BFF0016FF001AFF0019FF0011FF0003FF0000FF0F
00FF2800FF4400FF6500FF8800FFAD00FFD200FFF800E3FF00C1FF00A2FF0087FF0071FF
0060FF0054FF004EFF004EFF0055FF0061FF0074FF008CFF00A8FF00CAFF00EFFF00FFE8
00FFBD00FF9100FF6400FF3700FF0B1EFF0045FF006AFF008AFF00A6FF00BDFF00CFFF00
DBFF00E1FF00E1FF00DBFF00CEFF00BCFF00A5FF0087FF0065FF003FFF0014FF0000FF18
00FF4900FF7B00FFAF00FFE300E8FF00B4FF0083FF0053FF
53FF0024FF0000FF0C00FF3F00FF7300FFA800FFDC00F1FF00C0FF0092FF0066FF003FFF
001CFF0100FF1A00FF2D00FF3B00FF4200FF4300FF3E00FF3400FF2300FF0D00FF000DFF
002DFF0051FF0078FF00A1FF00CDFF00FAFF00FFD800FFAC00FF8100FF5800FF3200FF10
0DFF0025FF0039FF0046FF004EFF0050FF004BFF0041FF0030FF001BFF0001FF0000FF1C
00FF3E00FF6200FF8700FFAD00FFD200FFF500E9FF00CBFF00B2FF009DFF008FFF0086FF
0083FF0086FF0090FF009EFF00B2FF00CAFF00E6FF00FFFC00FFDD00FFBF00FFA300FF89
00FF7400FF6300FF5800FF5300FF5400FF5B00FF6800FF7900FF8E00FFA500FFBC00FFD2
00FFE400FFF300FFFB00FFFD00FFF900FFEF00FFE200FFD100FFC200FFB500FFAE00FFAE
00FFB300FFBD00FFC500FFC600FFC100FFC000FFC700FFD100FFD800FFD900FFD300FFC7
00FFB800FFA700FF9900FF8E00FF8900FF8A00FF9100FF9E00FFB000FFC600FFDD00FFF4
00F6FF00E4FF00D6FF00CEFF00CBFF00CFFF00D9FF00E9FF00FEFF00FFE800FFCC00FFAE
00FF9000FF7200FF5600FF3E00FF2900FF1900FF0E00FF0A00FF0C00FF1300FF2100FF34
00FF4D00FF6A00FF8A00FFAD00FFD200FFF800E2FF00BEFF009CFF007DFF0062FF004CFF
003AFF002FFF0029FF0029FF0030FF003CFF004FFF0066FF0083FF00A5FF00CAFF00F2FF
00FFE200FFB600FF8900FF5C00FF3100FF0620FF0045FF0065FF0081FF0098FF00AAFF00
B6FF00BCFF00BCFF00B6FF00A9FF0097FF007FFF0062FF0040FF001AFF0000FF1000FF3E
00FF6E00FFA000FFD400F7FF00C3FF008FFF005DFF002EFF
2EFF0000FF0100FF3200FF6500FF9900FFCD00FEFF00CBFF009AFF006CFF0041FF0019FF
0800FF2700FF4000FF5300FF6000FF6800FF6900FF6400FF5900FF4900FF3300FF1800FF
0007FF002BFF0052FF007CFF00A7FF00D4FF00FFFE00FFD200FFA700FF7E00FF5800FF36
00FF1800FF0013FF0021FF0028FF002AFF0025FF001BFF000BFF0000FF0A00FF2400FF42
00FF6400FF8700FFAD00FFD200FFF700E4FF00C3FF00A5FF008CFF0078FF0069FF0060FF
005DFF0061FF006AFF0079FF008DFF00A5FF00C0FF00DEFF00FCFF00FFE500FFC900FFAF
00FF9900FF8800FF7D00FF7800FF7900FF8100FF8D00FF9F00FFB300FFCA00FFE100FFF7
00F5FF00E7FF00DEFF00DCFF00E0FF00EAFF00F8FF00FFF700FFE700FFDB00FFD400FFD3
00FFD900FFE300FFEB00FFEB00FFE700FFE600FFED00FFF600FFFD00FFFE00FFF800FFED
00FFDD00FFCD00FFBF00FFB400FFAF00FFB000FFB700FFC400FFD600FFEB00FDFF00E6FF
00D0FF00BEFF00B0FF00A8FF00A6FF00AAFF00B4FF00C3FF00D8FF00F1FF00FFF200FFD4
00FFB600FF9800FF7C00FF6300FF4F00FF3F00FF3400FF3000FF3100FF3900FF4700FF5A
00FF7200FF8F00FFB000FFD300FFF800E2FF00BCFF0098FF0076FF0057FF003CFF0026FF
0015FF0009FF0003FF0004FF000AFF0016FF0029FF0041FF005EFF007FFF00A4FF00CCFF
00F7FF00FFDC00FFAF00FF8200FF5600FF2C00FF041FFF003FFF005BFF0073FF0084FF00
90FF0096FF0096FF0090FF0084FF0071FF005AFF003CFF001AFF0000FF0B00FF3600FF63
00FF9400FFC600FFFA00D1FF009DFF006AFF0038FF0008FF
08FF0000FF2600FF5700FF8A00FFBE00FFF300D9FF00A6FF0075FF0047FF001CFF0B00FF
2E00FF4C00FF6500FF7800FF8500FF8D00FF8E00FF8900FF7E00FF6E00FF5800FF3D00FF
1D00FF0006FF002DFF0056FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0303FF0005FF0000FF0000FF0900FF1900FF2F00FF4900FF67
00FF8900FFAC00FFD200FFF700E3FF00BFFF009EFF0080FF0067FF0053FF0044FF003BFF
0038FF003BFF0045FF0054FF0068FF0080FF009BFF00B8FF00D7FF00F5FF00FFEE00FFD4
00FFBE00FFAE00FFA200FF9D00FF9E00FFA600FFB200FFC400FFD900FFEF00F8FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F2FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EEFF00F3FF00F4FF00EDFF00E3FF00DCFF00DCFF00E2FF00EDFF
00FDFF00FFF200FFE400FFD900FFD400FFD500FFDC00FFE900FFFB00EEFF00D7FF00C0FF
00ABFF0099FF008BFF0083FF0081FF0084FF008EFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7400FF6400FF5900FF5500FF5600FF5E00FF6C00FF7F
00FF9800FFB400FFD500FFF800E2FF00BCFF0097FF0073FF0051FF0032FF0017FF0001FF
1000FF1B00FF2100FF2100FF1A00FF0E00FF0004FF001CFF0038FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2A00FF051AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006BFF005EFF004CFF0034FF0017FF0000FF0A00FF3000FF5B00FF88
00FFB900FFEB00E0FF00ACFF0078FF0044FF0013FF1C00FF
00FF1A00FF4900FF7B00FFAE00FFE200E9FF00B5FF0082FF0051FF0023FF0700FF2E00FF
5100FF6F00FF8800FF9B00FFA900FFB000FFB200FFAD00FFA200FF9100FF7B00FF6000FF
4100FF1D00FF0009FF0033FF005FFF008BFF00B8FF00E5FF00FFEF00FFC700FFA100FF7F
00FF6100FF4800FF3500FF2700FF1F00FF1E00FF2200FF2D00FF3D00FF5300FF6D00FF8B
00FFAC00FFD000FFF500E4FF00BFFF009BFF007AFF005DFF0043FF002FFF0020FF0017FF
0014FF0018FF0021FF0030FF0044FF005CFF0077FF0095FF00B3FF00D1FF00EEFF00FFF8
00FFE200FFD100FFC600FFC100FFC200FFC900FFD600FFE700FFFC00ECFF00D5FF00BFFF
00ACFF009EFF0096FF0093FF0097FF00A1FF00AFFF00BFFF00CFFF00DBFF00E3FF00E3FF
00DDFF00D4FF00CCFF00CBFF00D0FF00D1FF00CAFF00C0FF00B9FF00B8FF00BEFF00CAFF
00D9FF00E9FF00F8FF00FFFD00FFF700FFF800FFFF00F2FF00E0FF00CBFF00B4FF009DFF
0088FF0075FF0068FF005FFF005DFF0061FF006BFF007BFF008FFF00A8FF00C4FF00E2FF
00FFFE00FFE100FFC500FFAC00FF9700FF8700FF7D00FF7800FF7A00FF8200FF8F00FFA3
00FFBB00FFD800FFF800E3FF00BFFF0099FF0074FF004FFF002DFF000FFF0B00FF2200FF
3300FF3F00FF4500FF4400FF3E00FF3100FF1F00FF0700FF0015FF0036FF005BFF0084FF
00AEFF00DAFF00FFF800FFCB00FF9F00FF7500FF4D00FF2900FF0813FF002AFF003BFF00
47FF004DFF004DFF0047FF003BFF0029FF0011FF0000FF0B00FF2D00FF5400FF7E00FFAC
00FFDC00F0FF00BDFF0088FF0054FF0021FF1000FF4000FF
00FF3B00FF6A00FF9C00FFCF00FCFF00C8FF0094FF0061FF0030FF0002FF2800FF4F00FF
7200FF9000FFA900FFBD00FFCA00FFD100FFD300FFCE00FFC300FFB200FF9C00FF8100FF
6200FF3E00FF1700FF0012FF003DFF006AFF0097FF00C4FF00EFFF00FFE800FFC200FFA0
00FF8200FF6900FF5600FF4800FF4000FF3F00FF4300FF4E00FF5E00FF7400FF8E00FFAC
00FFCD00FFF100E9FF00C3FF009EFF007AFF0059FF003CFF0022FF000EFF0000FF0900FF
0C00FF0800FF0000FF000FFF0023FF003BFF0056FF0074FF0092FF00B0FF00CDFF00E6FF
00FCFF00FFF200FFE700FFE200FFE300FFEA00FFF700F7FF00E2FF00CBFF00B4FF009EFF
008BFF007DFF0075FF0072FF0076FF0080FF008EFF009EFF00AEFF00BAFF00C2FF00C2FF
00BCFF00B3FF00ABFF00AAFF00AFFF00B0FF00A9FF009FFF0098FF0097FF009DFF00A9FF
00B8FF00C8FF00D7FF00E1FF00E7FF00E6FF00DEFF00D1FF00BFFF00AAFF0093FF007CFF
0066FF0054FF0047FF003EFF003CFF0040FF004AFF005AFF006EFF0087FF00A3FF00C1FF
00E0FF00FDFF00FFE600FFCD00FFB800FFA800FF9E00FF9900FF9B00FFA300FFB000FFC4
00FFDC00FFF900E6FF00C2FF009EFF0078FF0053FF002EFF000CFF1100FF2C00FF4300FF
5400FF6000FF6600FF6500FF5F00FF5200FF4000FF2800FF0B00FF0015FF003AFF0063FF
008DFF00B9FF00E6FF00FFEC00FFC000FF9600FF6E00FF4A00FF2900FF0D09FF001AFF00
26FF002CFF002CFF0026FF001AFF0008FF0000FF0F00FF2C00FF4E00FF7500FF9F00FFCD
00FFFD00CFFF009CFF0067FF0033FF0000FF3100FF6100FF
00FF5900FF8800FFB900FFEC00DFFF00AAFF0076FF0044FF0013FF1A00FF4600FF6D00FF
9000FFAE00FFC700FFDA00FFE800FFEF00FFF000FFEB00FFE100FFD000FFBA00FF9F00FF
7F00FF5B00FF3400FF0B00FF0020FF004DFF007AFF00A6FF00D1FF00FAFF00FFDF00FFBD
00FF9F00FF8700FF7300FF6600FF5E00FF5C00FF6100FF6B00FF7C00FF9100FFAB00FFC9
00FFEB00F0FF00CBFF00A5FF0080FF005DFF003CFF001EFF0005FF0F00FF1D00FF2600FF
2900FF2600FF1C00FF0E00FF0005FF001DFF0039FF0056FF0075FF0093FF00AFFF00C9FF
00DEFF00EFFF00FAFF00FFFF00FEFF00F7FF00EAFF00D9FF00C4FF00ADFF0096FF0080FF
006EFF005FFF0057FF0055FF0059FF0063FF0070FF0081FF0090FF009DFF00A4FF00A4FF
009FFF0095FF008DFF008CFF0091FF0092FF008BFF0081FF007AFF0079FF007FFF008BFF
009AFF00ABFF00B9FF00C4FF00C9FF00C8FF00C1FF00B4FF00A2FF008CFF0075FF005EFF
0049FF0037FF0029FF0021FF001EFF0022FF002CFF003CFF0051FF006AFF0086FF00A4FF
00C2FF00E0FF00FCFF00FFEB00FFD600FFC600FFBB00FFB700FFB900FFC000FFCE00FFE1
00FFFA00E8FF00C8FF00A5FF0080FF005AFF0035FF0011FF1000FF2F00FF4A00FF6000FF
7200FF7D00FF8300FF8300FF7C00FF7000FF5D00FF4600FF2900FF0700FF001DFF0045FF
0070FF009CFF00C9FF00F6FF00FFDE00FFB300FF8C00FF6700FF4700FF2B00FF1400FF02
09FF000FFF000FFF0009FF0000FF0300FF1500FF2D00FF4A00FF6C00FF9200FFBD00FFEB
00E4FF00B2FF007EFF004AFF0016FF1D00FF4F00FF7E00FF
00FF7200FFA100FFD300F9FF00C5FF0091FF005DFF002AFF0500FF3400FF5F00FF8600FF
A900FFC700FFE000FFF300FFFF00FEFF00F7FF00F5FF00FAFA00FFE900FFD300FFB800FF
9900FF7500FF4E00FF2400FF0007FF0033FF0060FF008DFF00B8FF00E0FF00FFF900FFD7
00FFB900FFA000FF8D00FF7F00FF7700FF7600FF7A00FF8500FF9500FFAB00FFC500FFE3
00FBFF00D7FF00B2FF008CFF0067FF0043FF0022FF0005FF1400FF2800FF3700FF4000FF
4300FF3F00FF3600FF2700FF1300FF0004FF001FFF003DFF005BFF0079FF0096FF00AFFF
00C5FF00D6FF00E1FF00E6FF00E5FF00DEFF00D1FF00C0FF00ABFF0094FF007DFF0067FF
0054FF0046FF003EFF003BFF003FFF0049FF0057FF0067FF0077FF0083FF008BFF008BFF
0085FF007CFF0074FF0073FF0078FF0079FF0072FF0068FF0061FF0060FF0066FF0072FF
0081FF0091FF00A0FF00AAFF00B0FF00AFFF00A7FF009AFF0088FF0073FF005CFF0045FF
0030FF001DFF0010FF0007FF0005FF0009FF0013FF0023FF0037FF0050FF006CFF008AFF
00A9FF00C6FF00E2FF00FBFF00FFEF00FFDF00FFD500FFD000FFD200FFDA00FFE700FFFB
00ECFF00CFFF00AFFF008BFF0067FF0041FF001CFF0800FF2A00FF4800FF6300FF7A00FF
8B00FF9700FF9D00FF9C00FF9600FF8900FF7700FF5F00FF4200FF2100FF0003FF002CFF
0056FF0082FF00AFFF00DCFF00FFF700FFCD00FFA500FF8100FF6000FF4400FF2D00FF1B
00FF1000FF0A00FF0A00FF1000FF1C00FF2E00FF4600FF6300FF8500FFAC00FFD600FBFF
00CBFF0098FF0065FF0030FF0300FF3600FF6800FF9800FF
00FF8700FFB600FFE700E5FF00B1FF007DFF0049FF0016FF1A00FF4800FF7300FF9B00FF
BE00FFDC00FFF500FFFF00F7FF00EAFF00E2FF00E1FF00E6FF00F1FE00FFE800FFCD00FF
AD00FF8900FF6200FF3800FF0D00FF001FFF004CFF0078FF00A3FF00CCFF00F2FF00FFEB
00FFCD00FFB400FFA100FF9300FF8C00FF8A00FF8F00FF9900FFA900FFBF00FFD900FFF7
00E6FF00C3FF009DFF0078FF0053FF002FFF000EFF0F00FF2800FF3C00FF4B00FF5400FF
5700FF5400FF4A00FF3B00FF2700FF0F00FF000BFF0028FF0047FF0065FF0081FF009BFF
00B1FF00C1FF00CDFF00D2FF00D1FF00C9FF00BDFF00ABFF0096FF0080FF0068FF0053FF
0040FF0032FF0029FF0027FF002BFF0035FF0043FF0053FF0063FF006FFF0076FF0077FF
0071FF0067FF005FFF005FFF0063FF0064FF005DFF0053FF004DFF004CFF0052FF005DFF
006DFF007DFF008BFF0096FF009BFF009AFF0093FF0086FF0074FF005FFF0048FF0031FF
001BFF0009FF0400FF0C00FF0E00FF0B00FF0000FF000EFF0023FF003CFF0058FF0076FF
0094FF00B2FF00CEFF00E7FF00FBFF00FFF400FFE900FFE500FFE600FFEE00FFFC00F0FF
00D8FF00BBFF009AFF0077FF0052FF002DFF0007FF1C00FF3E00FF5D00FF7800FF8E00FF
9F00FFAB00FFB100FFB100FFAA00FF9E00FF8B00FF7300FF5700FF3500FF1000FF0017FF
0042FF006EFF009BFF00C8FF00F4FF00FFE100FFBA00FF9500FF7500FF5900FF4200FF30
00FF2400FF1E00FF1E00FF2400FF3000FF4300FF5A00FF7800FF9A00FFC000FFEB00E7FF
00B6FF0084FF0050FF001CFF1700FF4B00FF7C00FFAC00FF
00FF9500FFC400FFF600D6FF00A2FF006EFF003AFF0007FF2900FF5700FF8200FFA900FF
CC00FFEB00FFFF00FCFF00E8FF00DBFF00D3FF00D2FF00D7FF00E2FF00F2F700FFDB00FF
BC00FF9800FF7100FF4700FF1C00FF0010FF003DFF0069FF0094FF00BDFF00E3FF00FFFA
00FFDC00FFC300FFB000FFA200FF9A00FF9900FF9E00FFA800FFB800FFCE00FFE800F9FF
00D8FF00B4FF008FFF0069FF0044FF0020FF0000FF1D00FF3700FF4B00FF5A00FF6300FF
6600FF6200FF5900FF4A00FF3600FF1E00FF0300FF001AFF0038FF0056FF0072FF008CFF
00A2FF00B3FF00BEFF00C3FF00C2FF00BBFF00AEFF009CFF0088FF0071FF005AFF0044FF
0031FF0023FF001AFF0018FF001CFF0026FF0034FF0044FF0054FF0060FF0067FF0068FF
0062FF0058FF0050FF0050FF0054FF0055FF004EFF0045FF003EFF003DFF0043FF004EFF
005EFF006EFF007DFF0087FF008CFF008BFF0084FF0077FF0065FF0050FF0039FF0022FF
000CFF0500FF1300FF1B00FF1D00FF1900FF0F00FF0000FF0014FF002DFF0049FF0067FF
0085FF00A3FF00BFFF00D8FF00EDFF00FCFF00FFF800FFF400FFF500FFFD00F4FF00E1FF
00C9FF00ACFF008BFF0068FF0043FF001EFF0700FF2B00FF4D00FF6C00FF8700FF9D00FF
AE00FFBA00FFC000FFBF00FFB900FFAC00FF9A00FF8200FF6500FF4400FF1F00FF0008FF
0033FF005FFF008CFF00B9FF00E5FF00FFF000FFC800FFA400FF8300FF6700FF5000FF3F
00FF3300FF2D00FF2D00FF3300FF3F00FF5100FF6900FF8600FFA900FFCF00FFF900D8FF
00A7FF0075FF0041FF000DFF2600FF5900FF8B00FFBB00FF
00FF9E00FFCD00FFFF00CDFF0099FF0065FF0031FF0100FF3200FF6000FF8B00FFB200FF
D500FFF300FFFF00F3FF00DFFF00D2FF00CBFF00C9FF00CEFF00D9FF00EAFF00FFE400FF
C500FFA100FF7A00FF5000FF2500FF0007FF0034FF0060FF008BFF00B4FF00DAFF00FCFF
00FFE500FFCC00FFB900FFAB00FFA300FFA200FFA600FFB100FFC100FFD700FFF100F0FF
00CFFF00ABFF0086FF0060FF003BFF0017FF0900FF2600FF4000FF5400FF6300FF6C00FF
6F00FF6B00FF6200FF5300FF3F00FF2700FF0C00FF0011FF002FFF004DFF006AFF0083FF
0099FF00AAFF00B5FF00BAFF00B9FF00B2FF00A5FF0093FF007FFF0068FF0051FF003BFF
0028FF001AFF0011FF000FFF0013FF001DFF002BFF003BFF004BFF0057FF005FFF005FFF
0059FF0050FF0047FF0047FF004BFF004CFF0045FF003CFF0035FF0034FF003AFF0046FF
0055FF0065FF0074FF007EFF0084FF0083FF007BFF006EFF005CFF0047FF0030FF0019FF
0003FF0E00FF1B00FF2400FF2600FF2200FF1800FF0900FF000BFF0024FF0040FF005EFF
007CFF009AFF00B6FF00CFFF00E4FF00F4FF00FEFF00FFFC00FFFE00F9FF00ECFF00D8FF
00C0FF00A3FF0082FF005FFF003AFF0015FF1000FF3400FF5600FF7500FF9000FFA600FF
B700FFC300FFC900FFC800FFC200FFB500FFA300FF8B00FF6E00FF4D00FF2800FF0000FF
002AFF0056FF0083FF00B0FF00DCFF00FFF900FFD100FFAD00FF8C00FF7000FF5900FF48
00FF3C00FF3600FF3600FF3C00FF4800FF5A00FF7200FF8F00FFB100FFD800FDFF00CFFF
009FFF006CFF0038FF0004FF2F00FF6200FF9400FFC400FF
00FFA100FFD000FDFF00CAFF0096FF0062FF002EFF0400FF3400FF6300FF8E00FFB500FF
D800FFF600FFFF00F0FF00DDFF00CFFF00C8FF00C7FF00CBFF00D6FF00E7FF00FDE700FF
C700FFA400FF7D00FF5300FF2700FF0004FF0031FF005EFF0089FF00B1FF00D7FF00F9FF
00FFE800FFCF00FFBC00FFAE00FFA600FFA500FFA900FFB400FFC400FFD900FFF400EDFF
00CCFF00A8FF0083FF005DFF0038FF0014FF0C00FF2900FF4300FF5700FF6600FF6F00FF
7100FF6E00FF6500FF5600FF4200FF2A00FF0F00FF000EFF002CFF004AFF0067FF0080FF
0096FF00A7FF00B2FF00B7FF00B6FF00AFFF00A2FF0091FF007CFF0065FF004EFF0038FF
0025FF0017FF000FFF000CFF0011FF001AFF0028FF0038FF0048FF0055FF005CFF005CFF
0056FF004DFF0045FF0044FF0049FF004AFF0043FF0039FF0032FF0031FF0037FF0043FF
0052FF0062FF0071FF007BFF0081FF0080FF0078FF006BFF0059FF0044FF002DFF0016FF
0001FF1100FF1E00FF2700FF2900FF2500FF1B00FF0B00FF0009FF0021FF003DFF005BFF
007AFF0097FF00B3FF00CCFF00E1FF00F1FF00FBFF00FFFF00FEFF00F6FF00E9FF00D5FF
00BDFF00A0FF0080FF005DFF0038FF0012FF1200FF3700FF5800FF7700FF9200FFA900FF
BA00FFC600FFCB00FFCB00FFC500FFB800FFA600FF8E00FF7100FF5000FF2B00FF0200FF
0027FF0054FF0080FF00ADFF00D9FF00FFFC00FFD400FFB000FF8F00FF7300FF5C00FF4A
00FF3E00FF3800FF3900FF3F00FF4B00FF5D00FF7500FF9200FFB400FFDB00FAFF00CCFF
009CFF0069FF0036FF0001FF3200FF6500FF9700FFC600FF
00FF9E00FFCD00FFFE00CEFF009AFF0065FF0031FF0000FF3100FF5F00FF8A00FFB200FF
D500FFF300FFFF00F3FF00E0FF00D3FF00CBFF00CAFF00CFFF00DAFF00EAFF00FFE400FF
C400FFA000FF7900FF5000FF2400FF0008FF0035FF0061FF008CFF00B5FF00DBFF00FDFF
00FFE400FFCC00FFB800FFAA00FFA300FFA100FFA600FFB000FFC100FFD600FFF000F1FF
00CFFF00ABFF0086FF0061FF003BFF0018FF0800FF2600FF3F00FF5400FF6200FF6B00FF
6E00FF6B00FF6100FF5200FF3F00FF2600FF0B00FF0011FF0030FF004EFF006AFF0084FF
0099FF00AAFF00B5FF00BBFF00B9FF00B2FF00A5FF0094FF007FFF0068FF0051FF003BFF
0029FF001BFF0012FF0010FF0014FF001EFF002CFF003CFF004BFF0058FF005FFF0060FF
005AFF0050FF0048FF0047FF004CFF004DFF0046FF003CFF0035FF0034FF003AFF0046FF
0055FF0066FF0074FF007FFF0084FF0083FF007CFF006FFF005DFF0047FF0030FF0019FF
0004FF0D00FF1B00FF2300FF2600FF2200FF1800FF0800FF000CFF0025FF0041FF005FFF
007DFF009BFF00B7FF00CFFF00E4FF00F4FF00FFFF00FFFC00FFFD00FAFF00ECFF00D9FF
00C0FF00A3FF0083FF0060FF003BFF0015FF0F00FF3300FF5500FF7400FF8F00FFA500FF
B700FFC200FFC800FFC800FFC100FFB500FFA200FF8B00FF6E00FF4C00FF2700FF0000FF
002BFF0057FF0084FF00B1FF00DDFF00FFF800FFD100FFAC00FF8C00FF7000FF5900FF47
00FF3B00FF3500FF3500FF3B00FF4800FF5A00FF7200FF8F00FFB100FFD700FDFF00D0FF
009FFF006DFF0039FF0005FF2E00FF6200FF9400FFC300FF
00FF9400FFC300FFF500D7FF00A3FF006FFF003BFF0008FF2800FF5600FF8100FFA800FF
CB00FFEA00FFFF00FDFF00E9FF00DCFF00D5FF00D3FF00D8FF00E3FF00F3F600FFDA00FF
BB00FF9700FF7000FF4600FF1B00FF0011FF003EFF006AFF0095FF00BEFF00E4FF00FFF9
00FFDB00FFC200FFAF00FFA100FF9900FF9800FF9D00FFA700FFB700FFCD00FFE700FAFF
00D9FF00B5FF0090FF006AFF0045FF0021FF0000FF1C00FF3600FF4A00FF5900FF6200FF
6500FF6100FF5800FF4900FF3500FF1D00FF0200FF001BFF0039FF0057FF0073FF008DFF
00A3FF00B4FF00BFFF00C4FF00C3FF00BCFF00AFFF009DFF0089FF0072FF005BFF0045FF
0032FF0024FF001BFF0019FF001DFF0027FF0035FF0045FF0055FF0061FF0068FF0069FF
0063FF0059FF0051FF0051FF0055FF0056FF004FFF0046FF003FFF003EFF0044FF004FFF
005FFF006FFF007EFF0088FF008DFF008CFF0085FF0078FF0066FF0051FF003AFF0023FF
000DFF0400FF1200FF1A00FF1C00FF1800FF0E00FF0000FF0015FF002EFF004AFF0068FF
0086FF00A4FF00C0FF00D9FF00EEFF00FDFF00FFF700FFF200FFF400FFFC00F5FF00E2FF
00CAFF00ADFF008CFF0069FF0044FF001FFF0600FF2A00FF4C00FF6B00FF8600FF9C00FF
AD00FFB900FFBF00FFBE00FFB800FFAB00FF9900FF8100FF6400FF4300FF1E00FF0009FF
0034FF0060FF008DFF00BAFF00E6FF00FFEF00FFC700FFA300FF8200FF6600FF4F00FF3E
00FF3200FF2C00FF2C00FF3200FF3E00FF5000FF6800FF8500FFA700FFCE00FFF800D9FF
00A8FF0076FF0042FF000EFF2500FF5800FF8A00FFBA00FF
00FF8500FFB500FFE600E6FF00B2FF007EFF004AFF0017FF1900FF4700FF7200FF9A00FF
BC00FFDB00FFF300FFFF00F8FF00EBFF00E3FF00E2FF00E7FF00F2FD00FFE700FFCB00FF
AC00FF8800FF6100FF3700FF0C00FF0020FF004DFF0079FF00A4FF00CDFF00F3FF00FFEA
00FFCC00FFB300FFA000FF9200FF8B00FF8900FF8E00FF9800FFA800FFBE00FFD800FFF6
00E7FF00C4FF009EFF0079FF0054FF0030FF000FFF0E00FF2700FF3B00FF4A00FF5300FF
5600FF5200FF4900FF3A00FF2600FF0E00FF000CFF002AFF0048FF0066FF0082FF009CFF
00B2FF00C3FF00CEFF00D3FF00D2FF00CAFF00BEFF00ACFF0098FF0081FF006AFF0054FF
0041FF0033FF002AFF0028FF002CFF0036FF0044FF0054FF0064FF0070FF0077FF0078FF
0072FF0068FF0060FF0060FF0064FF0065FF005EFF0055FF004EFF004DFF0053FF005EFF
006EFF007EFF008CFF0097FF009CFF009BFF0094FF0087FF0075FF0060FF0049FF0032FF
001CFF000AFF0300FF0B00FF0D00FF0900FF0000FF000FFF0024FF003DFF0059FF0077FF
0095FF00B3FF00CFFF00E8FF00FCFF00FFF300FFE800FFE400FFE500FFED00FFFB00F1FF
00D9FF00BCFF009BFF0078FF0053FF002EFF0008FF1B00FF3D00FF5C00FF7700FF8D00FF
9E00FFAA00FFB000FFAF00FFA900FF9C00FF8A00FF7200FF5500FF3400FF0F00FF0018FF
0043FF006FFF009CFF00C9FF00F5FF00FFE000FFB800FF9400FF7400FF5800FF4000FF2F
00FF2300FF1D00FF1D00FF2300FF2F00FF4200FF5900FF7700FF9900FFBF00FFE900E8FF
00B7FF0085FF0051FF001DFF1600FF4900FF7B00FFAB00FF
00FF7200FFA100FFD200FAFF00C6FF0091FF005EFF002BFF0500FF3300FF5E00FF8600FF
A900FFC700FFE000FFF300FFFF00FFFF00F7FF00F6FF00FBF900FFE900FFD300FFB800FF
9800FF7400FF4D00FF2300FF0007FF0034FF0061FF008DFF00B8FF00E1FF00FFF800FFD6
00FFB800FF9F00FF8C00FF7E00FF7700FF7500FF7A00FF8400FF9400FFAA00FFC400FFE2
00FBFF00D8FF00B2FF008DFF0068FF0044FF0023FF0005FF1300FF2700FF3600FF3F00FF
4200FF3F00FF3500FF2600FF1200FF0005FF0020FF003DFF005CFF007AFF0096FF00B0FF
00C6FF00D6FF00E2FF00E7FF00E6FF00DEFF00D2FF00C0FF00ABFF0095FF007DFF0068FF
0055FF0047FF003EFF003CFF0040FF004AFF0058FF0068FF0077FF0084FF008BFF008CFF
0086FF007CFF0074FF0074FF0078FF0079FF0072FF0068FF0062FF0061FF0067FF0072FF
0082FF0092FF00A0FF00ABFF00B0FF00AFFF00A8FF009BFF0089FF0074FF005CFF0045FF
0030FF001EFF0010FF0008FF0006FF0009FF0013FF0023FF0038FF0051FF006DFF008BFF
00A9FF00C7FF00E3FF00FCFF00FFEF00FFDF00FFD400FFD000FFD100FFD900FFE700FFFA
00ECFF00D0FF00AFFF008CFF0067FF0042FF001CFF0700FF2900FF4800FF6300FF7900FF
8A00FF9600FF9C00FF9C00FF9500FF8900FF7600FF5E00FF4200FF2000FF0004FF002CFF
0057FF0083FF00B0FF00DDFF00FFF600FFCC00FFA500FF8000FF6000FF4400FF2D00FF1B
00FF0F00FF0900FF0900FF0F00FF1B00FF2E00FF4500FF6300FF8500FFAB00FFD600FCFF
00CBFF0099FF0065FF0031FF0200FF3600FF6700FF9700FF
00FF5900FF8900FFBA00FFED00DEFF00AAFF0076FF0043FF0012FF1B00FF4600FF6E00FF
9000FFAF00FFC800FFDB00FFE800FFF000FFF100FFEC00FFE100FFD100FFBB00FFA000FF
8000FF5C00FF3500FF0B00FF001FFF004CFF0079FF00A5FF00D0FF00F9FF00FFE000FFBE
00FFA000FF8700FF7400FF6600FF5F00FF5D00FF6200FF6C00FF7C00FF9200FFAC00FFCA
00FFEC00F0FF00CAFF00A5FF0080FF005CFF003BFF001DFF0004FF0F00FF1E00FF2700FF
2A00FF2600FF1D00FF0E00FF0005FF001DFF0038FF0056FF0074FF0092FF00AEFF00C8FF
00DEFF00EFFF00FAFF00FFFF00FEFF00F6FF00EAFF00D8FF00C4FF00ADFF0096FF0080FF
006DFF005FFF0056FF0054FF0058FF0062FF0070FF0080FF0090FF009CFF00A3FF00A4FF
009EFF0094FF008CFF008CFF0090FF0091FF008AFF0081FF007AFF0079FF007FFF008AFF
009AFF00AAFF00B8FF00C3FF00C8FF00C7FF00C0FF00B3FF00A1FF008CFF0075FF005EFF
0048FF0036FF0028FF0020FF001EFF0022FF002CFF003BFF0050FF0069FF0085FF00A3FF
00C1FF00DFFF00FBFF00FFEB00FFD700FFC700FFBC00FFB800FFB900FFC100FFCF00FFE2
00FFFA00E8FF00C7FF00A4FF007FFF005AFF0034FF0010FF1100FF3000FF4B00FF6100FF
7200FF7E00FF8400FF8300FF7D00FF7100FF5E00FF4600FF2900FF0800FF001CFF0044FF
006FFF009BFF00C8FF00F5FF00FFDE00FFB400FF8C00FF6800FF4800FF2C00FF1400FF03
08FF000EFF000EFF0008FF0000FF0300FF1600FF2D00FF4B00FF6D00FF9300FFBE00FFEB
00E3FF00B1FF007DFF0049FF0015FF1D00FF4F00FF7F00FF
00FF3E00FF6D00FF9F00FFD200F9FF00C5FF0091FF005EFF002DFF0000FF2B00FF5200FF
7500FF9300FFAC00FFBF00FFCD00FFD400FFD600FFD100FFC600FFB500FF9F00FF8400FF
6500FF4100FF1A00FF000FFF003BFF0067FF0094FF00C1FF00ECFF00FFEB00FFC500FFA3
00FF8500FF6C00FF5900FF4B00FF4300FF4200FF4600FF5100FF6100FF7700FF9100FFAF
00FFD000FFF400E6FF00C0FF009BFF0077FF0056FF0039FF001FFF000BFF0300FF0C00FF
0F00FF0B00FF0200FF000CFF0020FF0038FF0053FF0071FF008FFF00ADFF00CAFF00E3FF
00F9FF00FFF500FFEA00FFE500FFE600FFED00FFFA00F4FF00DFFF00C8FF00B1FF009BFF
0088FF007AFF0072FF006FFF0073FF007DFF008BFF009BFF00ABFF00B7FF00BFFF00BFFF
00B9FF00B0FF00A8FF00A7FF00ACFF00ADFF00A6FF009CFF0095FF0094FF009AFF00A6FF
00B5FF00C5FF00D4FF00DEFF00E4FF00E3FF00DBFF00CEFF00BCFF00A7FF0090FF0079FF
0064FF0051FF0044FF003BFF0039FF003DFF0047FF0057FF006BFF0084FF00A0FF00BEFF
00DDFF00FAFF00FFE900FFD000FFBB00FFAB00FFA100FF9C00FF9E00FFA600FFB300FFC7
00FFDF00FFFC00E3FF00BFFF009BFF0075FF0050FF002BFF0009FF1400FF2F00FF4600FF
5700FF6300FF6900FF6800FF6200FF5500FF4300FF2B00FF0E00FF0012FF0037FF0060FF
008AFF00B6FF00E3FF00FFEF00FFC300FF9900FF7100FF4D00FF2C00FF1006FF0017FF00
23FF0029FF0029FF0023FF0017FF0005FF0000FF1200FF2F00FF5100FF7800FFA200FFD0
00FFFF00CCFF0099FF0064FF0030FF0200FF3400FF6400FF
00FF2100FF5000FF8100FFB400FFE800E2FF00AEFF007CFF004BFF001DFF0D00FF3500FF
5800FF7600FF8F00FFA200FFAF00FFB700FFB800FFB300FFA800FF9800FF8200FF6700FF
4700FF2300FF0003FF002CFF0058FF0085FF00B2FF00DEFF00FFF600FFCD00FFA700FF85
00FF6700FF4F00FF3B00FF2D00FF2600FF2400FF2900FF3300FF4400FF5900FF7300FF91
00FFB300FFD700FFFC00DEFF00B8FF0095FF0074FF0056FF003DFF0028FF001AFF0011FF
000EFF0011FF001BFF002AFF003DFF0056FF0071FF008EFF00ADFF00CBFF00E7FF00FFFE
00FFE900FFD800FFCD00FFC700FFC900FFD000FFDD00FFEE00FCFF00E5FF00CEFF00B9FF
00A6FF0098FF008FFF008DFF0091FF009BFF00A9FF00B9FF00C8FF00D5FF00DCFF00DDFF
00D7FF00CDFF00C5FF00C4FF00C9FF00CAFF00C3FF00B9FF00B2FF00B1FF00B7FF00C3FF
00D2FF00E3FF00F1FF00FCFF00FFFE00FFFF00F9FF00ECFF00DAFF00C4FF00ADFF0096FF
0081FF006FFF0061FF0059FF0056FF005AFF0064FF0074FF0089FF00A2FF00BEFF00DCFF
00FAFF00FFE700FFCB00FFB300FF9E00FF8E00FF8300FF7F00FF8000FF8800FF9600FFA9
00FFC200FFDF00FFFF00DDFF00B8FF0092FF006DFF0049FF0027FF0008FF1200FF2800FF
3A00FF4500FF4B00FF4B00FF4400FF3800FF2500FF0E00FF000EFF0030FF0055FF007DFF
00A8FF00D4FF00FFFE00FFD100FFA500FF7B00FF5400FF2F00FF0F0CFF0023FF0035FF00
41FF0047FF0047FF0041FF0034FF0022FF000AFF0000FF1200FF3400FF5A00FF8500FFB2
00FFE300EAFF00B6FF0082FF004EFF001AFF1700FF4600FF
00FF0200FF3100FF6300FF9600FFCA00FFFE00CDFF009AFF0069FF003BFF0010FF1600FF
3900FF5700FF7000FF8400FF9100FF9800FF9A00FF9500FF8A00FF7A00FF6300FF4800FF
2900FF0500FF0021FF004BFF0076FF00A3FF00D0FF00FCFF00FFD800FFAF00FF8900FF67
00FF4900FF3000FF1D00FF0F00FF0700FF0600FF0A00FF1500FF2500FF3B00FF5500FF73
00FF9400FFB800FFDD00FCFF00D7FF00B3FF0092FF0075FF005BFF0047FF0038FF002FFF
002CFF0030FF0039FF0048FF005CFF0074FF008FFF00ADFF00CBFF00E9FF00FFF900FFE0
00FFCA00FFB900FFAE00FFA900FFAA00FFB100FFBE00FFD000FFE400FFFB00EDFF00D7FF
00C4FF00B6FF00ADFF00ABFF00AFFF00B9FF00C7FF00D7FF00E7FF00F3FF00FAFF00FBFF
00F5FF00ECFF00E3FF00E3FF00E7FF00E8FF00E1FF00D8FF00D1FF00D0FF00D6FF00E2FF
00F1FF00FFFE00FFEF00FFE500FFDF00FFE000FFE800FFF500F8FF00E3FF00CCFF00B5FF
009FFF008DFF007FFF0077FF0075FF0079FF0083FF0092FF00A7FF00C0FF00DCFF00FAFF
00FFE700FFC900FFAD00FF9400FF7F00FF6F00FF6500FF6000FF6200FF6A00FF7800FF8B
00FFA300FFC000FFE100FBFF00D6FF00B1FF008BFF0067FF0045FF0026FF000BFF0A00FF
1B00FF2700FF2D00FF2C00FF2600FF1900FF0700FF0010FF002DFF004EFF0073FF009BFF
00C6FF00F2FF00FFE000FFB300FF8700FF5D00FF3500FF110FFF002BFF0042FF0053FF00
5FFF0065FF0065FF005FFF0053FF0041FF0029FF000CFF0000FF1500FF3C00FF6600FF94
00FFC400FFF700D4FF00A0FF006CFF0039FF0007FF2800FF
1BFF0000FF1300FF4500FF7800FFAC00FFE000EBFF00B8FF0087FF0059FF002EFF0007FF
1B00FF3900FF5200FF6600FF7300FF7A00FF7C00FF7700FF6C00FF5B00FF4500FF2A00FF
0B00FF0018FF003FFF0069FF0094FF00C1FF00EEFF00FFE500FFBA00FF9100FF6B00FF49
00FF2B00FF1200FF000EFF0016FF0017FF0013FF0008FF0000FF0700FF1D00FF3700FF55
00FF7600FF9A00FFBF00FFE500F5FF00D1FF00B0FF0093FF0079FF0065FF0056FF004DFF
004AFF004EFF0057FF0066FF007AFF0092FF00ADFF00CBFF00E9FF00FFF800FFDB00FFC2
00FFAC00FF9B00FF9000FF8B00FF8C00FF9300FFA000FFB100FFC600FFDD00FFF400F5FF
00E2FF00D4FF00CBFF00C9FF00CDFF00D7FF00E5FF00F5FF00FFFA00FFEE00FFE600FFE6
00FFEC00FFF500FFFE00FFFE00FFFA00FFF900FFFF00F6FF00EFFF00EEFF00F4FF00FFFF
00FFF000FFE000FFD100FFC700FFC100FFC200FFCA00FFD700FFE900FFFE00EAFF00D3FF
00BDFF00ABFF009EFF0095FF0093FF0097FF00A1FF00B1FF00C5FF00DEFF00FAFF00FFE7
00FFC800FFAB00FF8F00FF7600FF6100FF5100FF4700FF4200FF4400FF4C00FF5900FF6D
00FF8500FFA200FFC300FFE600F4FF00CFFF00A9FF0085FF0063FF0044FF0029FF0013FF
0002FF0900FF0F00FF0E00FF0800FF0004FF0016FF002EFF004BFF006CFF0091FF00B9FF
00E4FF00FFEF00FFC200FF9500FF6900FF3F00FF170CFF002DFF0049FF0060FF0071FF00
7DFF0083FF0083FF007DFF0071FF005FFF0047FF002AFF0008FF0000FF1E00FF4800FF76
00FFA600FFD900F2FF00BEFF008AFF0057FF0025FF0A00FF
37FF0008FF0000FF2800FF5B00FF8F00FFC400FFF800D5FF00A4FF0076FF004AFF0023FF
0000FF1D00FF3600FF4900FF5700FF5E00FF5F00FF5A00FF5000FF3F00FF2900FF0E00FF
0011FF0034FF005CFF0085FF00B1FF00DEFF00FFF400FFC800FF9D00FF7400FF4E00FF2C
00FF0F09FF001DFF002AFF0032FF0034FF002FFF0024FF0014FF0000FF0000FF1A00FF39
00FF5A00FF7E00FFA300FFC900FFEE00EEFF00CDFF00AFFF0096FF0081FF0072FF006AFF
0067FF006AFF0073FF0082FF0096FF00AEFF00CAFF00E7FF00FFF900FFDB00FFBF00FFA5
00FF9000FF7F00FF7400FF6F00FF7000FF7700FF8400FF9500FFAA00FFC100FFD800FFEE
00FFFF00F0FF00E8FF00E6FF00EAFF00F3FF00FFFE00FFED00FFDE00FFD100FFCA00FFCA
00FFCF00FFD900FFE100FFE200FFDD00FFDC00FFE300FFED00FFF400FFF500FFEF00FFE3
00FFD400FFC300FFB500FFAA00FFA500FFA600FFAD00FFBB00FFCC00FFE200FFF900EFFF
00DAFF00C8FF00BAFF00B2FF00AFFF00B3FF00BDFF00CDFF00E2FF00FBFF00FFE800FFCA
00FFAC00FF8E00FF7300FF5A00FF4500FF3500FF2B00FF2600FF2800FF2F00FF3D00FF50
00FF6900FF8600FFA600FFC900FFEE00EBFF00C6FF00A2FF0080FF0061FF0046FF0030FF
001EFF0013FF000DFF000DFF0014FF0020FF0032FF004AFF0067FF0088FF00AEFF00D6FF
00FFFE00FFD200FFA500FF7800FF4D00FF2204FF0029FF0049FF0065FF007CFF008EFF00
9AFF00A0FF00A0FF0099FF008DFF007BFF0063FF0046FF0024FF0000FF0100FF2C00FF5A
00FF8A00FFBC00FFF000DBFF00A6FF0073FF0041FF0012FF
51FF0022FF0000FF0F00FF4200FF7600FFAA00FFDE00EEFF00BDFF008FFF0064FF003DFF
001AFF0300FF1C00FF3000FF3D00FF4400FF4600FF4100FF3600FF2500FF0F00FF000BFF
002AFF004EFF0075FF009FFF00CAFF00F7FF00FFDB00FFAE00FF8300FF5B00FF3500FF13
0AFF0023FF0036FF0044FF004CFF004DFF0049FF003EFF002EFF0018FF0000FF0100FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF800E6FF00C9FF00AFFF009BFF008CFF0083FF
0080FF0084FF008DFF009CFF00B0FF00C8FF00E3FF00FFFE00FFE000FFC200FFA500FF8C
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE700FFF500FFFD00FFFF00FFFC00FFF200FFE400FFD400FFC400FFB800FFB000FFB0
00FFB600FFBF00FFC700FFC800FFC300FFC200FFCA00FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9100FF8B00FF8C00FF9400FFA100FFB300FFC800FFDF00FFF6
00F3FF00E1FF00D4FF00CBFF00C9FF00CDFF00D7FF00E7FF00FBFF00FFEB00FFCF00FFB1
00FF9200FF7500FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1600FF2300FF37
00FF4F00FF6C00FF8C00FFB000FFD400FFFA00DFFF00BBFF0099FF007BFF0060FF0049FF
0038FF002CFF0026FF0027FF002DFF003AFF004CFF0064FF0081FF00A2FF00C7FF00F0FF
00FFE500FFB900FF8C00FF5F00FF3300FF091EFF0042FF0063FF007FFF0096FF00A7FF00
B3FF00B9FF00B9FF00B3FF00A7FF0095FF007DFF0060FF003EFF0017FF0000FF1200FF40
00FF7000FFA300FFD600F4FF00C0FF008DFF005BFF002BFF
67FF0037FF0006FF0000FF2C00FF6000FF9400FFC800FFFB00D3FF00A5FF007AFF0052FF
002FFF0011FF0700FF1A00FF2700FF2F00FF3000FF2B00FF2000FF1000FF0005FF0020FF
0040FF0064FF008BFF00B5FF00E0FF00FFF200FFC500FF9900FF6E00FF4500FF1F02FF00
20FF0039FF004CFF005AFF0061FF0063FF005EFF0054FF0044FF002EFF0014FF0000FF09
00FF2B00FF4E00FF7400FF9900FFBE00FFE200FCFF00DEFF00C5FF00B1FF00A2FF0099FF
0096FF0099FF00A3FF00B2FF00C6FF00DEFF00F9FF00FFE900FFCA00FFAC00FF9000FF76
00FF6000FF5000FF4400FF3F00FF4000FF4800FF5400FF6600FF7B00FF9100FFA900FFBE
00FFD100FFDF00FFE800FFEA00FFE600FFDC00FFCE00FFBE00FFAE00FFA200FF9B00FF9A
00FFA000FFAA00FFB200FFB200FFAE00FFAD00FFB400FFBE00FFC400FFC500FFBF00FFB4
00FFA400FF9400FF8600FF7B00FF7600FF7700FF7E00FF8B00FF9D00FFB200FFC900FFE0
00FFF600F7FF00E9FF00E1FF00DFFF00E2FF00EDFF00FCFF00FFEE00FFD500FFB900FF9B
00FF7D00FF5F00FF4300FF2A00FF1600FF0604FF0008FF0007FF0000FF0000FF0E00FF21
00FF3900FF5600FF7700FF9A00FFBF00FFE400F5FF00D1FF00AFFF0090FF0075FF005FFF
004EFF0042FF003CFF003CFF0043FF004FFF0062FF007AFF0096FF00B8FF00DDFF00FFFA
00FFCF00FFA300FF7600FF4900FF1D0CFF0033FF0058FF0078FF0094FF00ABFF00BDFF00
C9FF00CFFF00CFFF00C9FF00BDFF00AAFF0093FF0075FF0053FF002DFF0002FF0000FF2A
00FF5B00FF8D00FFC100FFF500D6FF00A2FF0071FF0041FF
77FF0048FF0017FF0000FF1B00FF4F00FF8400FFB800FFEA00E4FF00B6FF008BFF0063FF
0040FF0022FF0009FF0900FF1600FF1E00FF1F00FF1A00FF0F00FF0000FF0016FF0031FF
0051FF0075FF009CFF00C5FF00F1FF00FFE100FFB400FF8800FF5D00FF3400FF0E13FF00
31FF0049FF005DFF006BFF0072FF0074FF006FFF0065FF0054FF003FFF0025FF0007FF00
00FF1A00FF3E00FF6300FF8800FFAE00FFD100FFF200EFFF00D6FF00C1FF00B3FF00AAFF
00A7FF00AAFF00B4FF00C3FF00D6FF00EFFF00FFF500FFD800FFB900FF9B00FF7F00FF65
00FF5000FF3F00FF3400FF2E00FF3000FF3700FF4400FF5500FF6A00FF8100FF9800FFAD
00FFC000FFCE00FFD700FFD900FFD500FFCB00FFBD00FFAD00FF9E00FF9100FF8A00FF89
00FF8F00FF9900FFA100FFA200FF9D00FF9C00FFA300FFAD00FFB400FFB400FFAF00FFA3
00FF9400FF8300FF7500FF6A00FF6500FF6600FF6D00FF7A00FF8C00FFA200FFB900FFD0
00FFE500FFF700FAFF00F2FF00EFFF00F3FF00FDFF00FFF200FFDD00FFC400FFA800FF8A
00FF6C00FF4E00FF3200FF1A00FF050AFF0015FF0019FF0018FF0010FF0002FF0000FF10
00FF2900FF4500FF6600FF8900FFAE00FFD400FFF900E2FF00C0FF00A1FF0086FF0070FF
005EFF0053FF004DFF004DFF0054FF0060FF0073FF008AFF00A7FF00C9FF00EEFF00FFE9
00FFBE00FF9200FF6500FF3800FF0C1DFF0044FF0069FF0089FF00A5FF00BCFF00CEFF00
DAFF00E0FF00E0FF00DAFF00CDFF00BBFF00A3FF0086FF0064FF003EFF0013FF0000FF19
00FF4A00FF7C00FFB000FFE400E7FF00B3FF0082FF0052FF
83FF0053FF0022FF0000FF1000FF4400FF7800FFAC00FFDF00EFFF00C1FF0096FF006EFF
004BFF002DFF0014FF0001FF0B00FF1300FF1400FF0F00FF0400FF000BFF0021FF003CFF
005CFF0080FF00A7FF00D1FF00FCFF00FFD600FFA900FF7D00FF5200FF2900FF031EFF00
3CFF0055FF0068FF0076FF007DFF007FFF007AFF0070FF0060FF004AFF0030FF0012FF00
00FF0F00FF3200FF5800FF7D00FFA200FFC600FFE700FAFF00E1FF00CDFF00BEFF00B5FF
00B2FF00B5FF00BFFF00CEFF00E2FF00FAFF00FFEA00FFCD00FFAE00FF9000FF7400FF5A
00FF4400FF3400FF2800FF2300FF2400FF2C00FF3800FF4A00FF5F00FF7500FF8D00FFA2
00FFB500FFC300FFCC00FFCE00FFCA00FFC000FFB200FFA200FF9200FF8600FF7F00FF7E
00FF8400FF8E00FF9600FF9600FF9200FF9100FF9800FFA200FFA800FFA900FFA300FF98
00FF8800FF7800FF6A00FF5F00FF5A00FF5B00FF6200FF6F00FF8100FF9600FFAD00FFC4
00FFDA00FFEC00FFFA00FDFF00FBFF00FEFF00FFF600FFE700FFD200FFB900FF9D00FF7F
00FF6100FF4300FF2700FF0E05FF0015FF0020FF0024FF0023FF001BFF000DFF0000FF05
00FF1D00FF3A00FF5B00FF7E00FFA300FFC800FFEE00EDFF00CBFF00ACFF0091FF007BFF
006AFF005EFF0058FF0058FF005FFF006BFF007EFF0096FF00B2FF00D4FF00F9FF00FFDE
00FFB300FF8700FF5A00FF2D00FF0128FF004FFF0074FF0094FF00B0FF00C7FF00D9FF00
E5FF00EBFF00EBFF00E5FF00D9FF00C6FF00AFFF0091FF006FFF0049FF001EFF0000FF0E
00FF3F00FF7100FFA500FFD900F2FF00BEFF008DFF005DFF
88FF0058FF0027FF0000FF0B00FF3F00FF7300FFA700FFDA00F4FF00C6FF009BFF0074FF
0051FF0032FF001AFF0006FF0600FF0E00FF0F00FF0A00FF0000FF0010FF0026FF0042FF
0061FF0085FF00ACFF00D6FF00FFFE00FFD100FFA400FF7800FF4D00FF2401FF0023FF00
41FF005AFF006DFF007BFF0082FF0084FF007FFF0075FF0065FF004FFF0035FF0017FF00
00FF0A00FF2D00FF5300FF7800FF9D00FFC100FFE200FFFF00E6FF00D2FF00C3FF00BAFF
00B7FF00BBFF00C4FF00D3FF00E7FF00FFFF00FFE500FFC700FFA900FF8B00FF6F00FF55
00FF3F00FF2E00FF2300FF1E00FF1F00FF2600FF3300FF4500FF5900FF7000FF8700FF9D
00FFB000FFBE00FFC700FFC900FFC500FFBB00FFAD00FF9D00FF8D00FF8100FF7A00FF79
00FF7F00FF8900FF9100FF9100FF8D00FF8C00FF9300FF9C00FFA300FFA400FF9E00FF93
00FF8300FF7300FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7C00FF9100FFA800FFBF
00FFD500FFE700FFF500FFFD00FFFF00FFFB00FFF100FFE200FFCD00FFB400FF9800FF7A
00FF5C00FF3E00FF2200FF090AFF001AFF0025FF0029FF0028FF0020FF0012FF0000FF00
00FF1800FF3500FF5600FF7900FF9E00FFC300FFE900F2FF00D0FF00B1FF0096FF0080FF
006FFF0063FF005DFF005EFF0064FF0071FF0083FF009BFF00B8FF00D9FF00FEFF00FFD9
00FFAE00FF8200FF5500FF2803FF002DFF0055FF0079FF0099FF00B6FF00CDFF00DEFF00
EAFF00F0FF00F0FF00EAFF00DEFF00CBFF00B4FF0097FF0074FF004EFF0024FF0000FF09
00FF3A00FF6C00FFA000FFD400F7FF00C4FF0092FF0062FF
86FF0057FF0026FF0000FF0C00FF4000FF7500FFA800FFDB00F3FF00C5FF009AFF0072FF
004FFF0031FF0018FF0005FF0700FF0F00FF1000FF0B00FF0000FF000FFF0025FF0040FF
0060FF0084FF00ABFF00D5FF00FFFF00FFD200FFA500FF7900FF4E00FF2500FF0022FF00
40FF0059FF006CFF007AFF0081FF0083FF007EFF0074FF0064FF004EFF0034FF0016FF00
00FF0B00FF2E00FF5400FF7900FF9E00FFC200FFE300FEFF00E5FF00D1FF00C2FF00B9FF
00B6FF00B9FF00C3FF00D2FF00E6FF00FEFF00FFE600FFC900FFAA00FF8C00FF7000FF56
00FF4000FF3000FF2400FF1F00FF2000FF2800FF3400FF4600FF5B00FF7100FF8900FF9E
00FFB100FFBF00FFC800FFCA00FFC600FFBC00FFAE00FF9E00FF8F00FF8200FF7B00FF7A
00FF8000FF8A00FF9200FF9300FF8E00FF8D00FF9400FF9E00FFA400FFA500FF9F00FF94
00FF8400FF7400FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7D00FF9200FFAA00FFC1
00FFD600FFE800FFF600FFFE00FFFF00FFFD00FFF300FFE300FFCE00FFB500FF9900FF7B
00FF5D00FF3F00FF2300FF0A09FF0019FF0024FF0028FF0027FF001FFF0011FF0000FF01
00FF1A00FF3600FF5700FF7A00FF9F00FFC400FFEA00F1FF00CFFF00B0FF0095FF007FFF
006EFF0062FF005CFF005CFF0063FF006FFF0082FF009AFF00B6FF00D8FF00FDFF00FFDA
00FFAF00FF8300FF5600FF2902FF002CFF0053FF0078FF0098FF00B4FF00CBFF00DDFF00
E9FF00EFFF00EFFF00E9FF00DCFF00CAFF00B3FF0095FF0073FF004DFF0022FF0000FF0A
00FF3B00FF6D00FFA100FFD500F6FF00C2FF0091FF0061FF
7FFF0050FF001FFF0000FF1300FF4700FF7C00FFB000FFE200ECFF00BEFF0092FF006BFF
0048FF002AFF0011FF0100FF0F00FF1600FF1700FF1200FF0800FF0008FF001EFF0039FF
0059FF007DFF00A4FF00CDFF00F9FF00FFD900FFAC00FF8000FF5500FF2C00FF061BFF00
39FF0051FF0065FF0072FF007AFF007CFF0077FF006DFF005CFF0047FF002DFF000FFF00
00FF1200FF3600FF5B00FF8100FFA600FFC900FFEA00F7FF00DEFF00C9FF00BBFF00B2FF
00AFFF00B2FF00BCFF00CAFF00DEFF00F6FF00FFED00FFD000FFB100FF9300FF7700FF5D
00FF4800FF3700FF2C00FF2600FF2800FF2F00FF3C00FF4D00FF6200FF7900FF9000FFA6
00FFB800FFC600FFCF00FFD100FFCD00FFC300FFB600FFA500FF9600FF8900FF8200FF81
00FF8700FF9100FF9900FF9A00FF9500FF9400FF9B00FFA500FFAC00FFAD00FFA700FF9B
00FF8C00FF7B00FF6D00FF6200FF5D00FF5E00FF6500FF7200FF8400FF9A00FFB100FFC8
00FFDD00FFEF00FFFD00FAFF00F7FF00FBFF00FFFA00FFEA00FFD500FFBC00FFA000FF82
00FF6400FF4600FF2A00FF1202FF0012FF001DFF0021FF0020FF0018FF000AFF0000FF08
00FF2100FF3E00FF5E00FF8100FFA600FFCC00FFF100EAFF00C8FF00A9FF008EFF0078FF
0066FF005BFF0055FF0055FF005CFF0068FF007BFF0092FF00AFFF00D1FF00F6FF00FFE1
00FFB600FF8A00FF5D00FF3000FF0525FF004CFF0071FF0091FF00ADFF00C4FF00D6FF00
E2FF00E8FF00E8FF00E2FF00D5FF00C3FF00ABFF008EFF006CFF0046FF001BFF0000FF12
00FF4200FF7400FFA800FFDC00EFFF00BBFF0089FF005AFF
73FF0043FF0012FF0000FF2000FF5400FF8800FFBC00FFEF00DFFF00B1FF0086FF005EFF
003BFF001DFF0004FF0E00FF1B00FF2300FF2400FF1F00FF1400FF0400FF0011FF002CFF
004CFF0070FF0097FF00C1FF00ECFF00FFE600FFB900FF8D00FF6200FF3900FF130EFF00
2CFF0045FF0058FF0066FF006DFF006FFF006AFF0060FF0050FF003AFF0020FF0002FF00
00FF1F00FF4200FF6800FF8D00FFB200FFD600FFF700EAFF00D1FF00BDFF00AEFF00A5FF
00A2FF00A5FF00AFFF00BEFF00D2FF00EAFF00FFFA00FFDD00FFBE00FFA000FF8400FF6A
00FF5400FF4400FF3800FF3300FF3400FF3C00FF4800FF5A00FF6F00FF8500FF9D00FFB2
00FFC500FFD300FFDC00FFDE00FFDA00FFD000FFC200FFB200FFA200FF9600FF8F00FF8E
00FF9400FF9E00FFA600FFA600FFA200FFA100FFA800FFB200FFB800FFB900FFB300FFA8
00FF9800FF8800FF7A00FF6F00FF6A00FF6B00FF7200FF7F00FF9100FFA600FFBD00FFD4
00FFEA00FFFC00F5FF00EDFF00EBFF00EEFF00F9FF00FFF700FFE200FFC900FFAD00FF8F
00FF7100FF5300FF3700FF1E00FF0A05FF0010FF0014FF0013FF000BFF0000FF0200FF15
00FF2D00FF4A00FF6B00FF8E00FFB300FFD800FFFE00DDFF00BBFF009CFF0081FF006BFF
005AFF004EFF0048FF0048FF004FFF005BFF006EFF0086FF00A2FF00C4FF00E9FF00FFEE
00FFC300FF9700FF6A00FF3D00FF1118FF003FFF0064FF0084FF00A0FF00B7FF00C9FF00
D5FF00DBFF00DBFF00D5FF00C9FF00B6FF009FFF0081FF005FFF0039FF000EFF0000FF1E
00FF4F00FF8100FFB500FFE900E2FF00AEFF007DFF004DFF
61FF0032FF0001FF0000FF3200FF6600FF9A00FFCE00FFFF00CEFF009FFF0074FF004DFF
002AFF000CFF0C00FF1F00FF2D00FF3400FF3500FF3000FF2600FF1500FF0000FF001BFF
003BFF005EFF0085FF00AFFF00DBFF00FFF800FFCB00FF9E00FF7300FF4A00FF2400FF02
1AFF0033FF0047FF0054FF005CFF005EFF0059FF004EFF003EFF0029FF000FFF0000FF0F
00FF3000FF5400FF7900FF9F00FFC400FFE700F7FF00D9FF00C0FF00ABFF009CFF0093FF
0091FF0094FF009DFF00ACFF00C0FF00D8FF00F4FF00FFEE00FFD000FFB100FF9500FF7B
00FF6600FF5500FF4A00FF4500FF4600FF4D00FF5A00FF6B00FF8000FF9700FFAE00FFC4
00FFD600FFE500FFED00FFEF00FFEB00FFE200FFD400FFC400FFB400FFA700FFA000FFA0
00FFA600FFAF00FFB700FFB800FFB300FFB200FFB900FFC300FFCA00FFCB00FFC500FFB9
00FFAA00FF9A00FF8B00FF8000FF7B00FF7C00FF8300FF9100FFA300FFB800FFCF00FFE6
00FFFB00F2FF00E4FF00DCFF00D9FF00DDFF00E7FF00F7FF00FFF300FFDA00FFBE00FFA1
00FF8200FF6400FF4900FF3000FF1B00FF0B00FF0103FF0001FF0000FF0500FF1300FF26
00FF3F00FF5C00FF7C00FF9F00FFC400FFEA00F0FF00CCFF00AAFF008BFF0070FF0059FF
0048FF003DFF0037FF0037FF003EFF004AFF005CFF0074FF0091FF00B2FF00D8FF00FFFF
00FFD400FFA800FF7B00FF4F00FF2306FF002EFF0052FF0073FF008FFF00A6FF00B8FF00
C4FF00CAFF00CAFF00C3FF00B7FF00A5FF008DFF0070FF004EFF0027FF0000FF0200FF30
00FF6000FF9200FFC600FFFA00D0FF009DFF006BFF003CFF
4CFF001DFF0000FF1300FF4600FF7A00FFAF00FFE300EAFF00B9FF008BFF0060FF0038FF
0015FF0800FF2100FF3400FF4100FF4900FF4A00FF4500FF3A00FF2A00FF1400FF0006FF
0026FF004AFF0071FF009AFF00C6FF00F3FF00FFDF00FFB300FF8800FF5F00FF3900FF17
06FF001EFF0032FF0040FF0047FF0049FF0044FF003AFF0029FF0014FF0000FF0500FF23
00FF4500FF6900FF8E00FFB300FFD900FFFC00E2FF00C4FF00ABFF0096FF0088FF007FFF
007CFF007FFF0089FF0098FF00ABFF00C4FF00DFFF00FCFF00FFE400FFC600FFAA00FF90
00FF7B00FF6A00FF5F00FF5900FF5B00FF6200FF6F00FF8000FF9500FFAC00FFC300FFD9
00FFEB00FFF900FDFF00FBFF00FFFF00FFF600FFE800FFD800FFC900FFBC00FFB500FFB4
00FFBA00FFC400FFCC00FFCD00FFC800FFC700FFCE00FFD800FFDF00FFE000FFDA00FFCE
00FFBF00FFAE00FFA000FF9500FF9000FF9100FF9800FFA500FFB700FFCD00FFE400FFFB
00EFFF00DDFF00CFFF00C7FF00C4FF00C8FF00D2FF00E2FF00F7FF00FFEF00FFD300FFB5
00FF9700FF7900FF5D00FF4500FF3000FF2000FF1500FF1100FF1200FF1A00FF2800FF3B
00FF5400FF7100FF9100FFB400FFD900FFFF00DBFF00B7FF0095FF0076FF005BFF0045FF
0033FF0028FF0022FF0022FF0029FF0035FF0048FF005FFF007CFF009EFF00C3FF00EBFF
00FFE900FFBD00FF9000FF6300FF3800FF0D19FF003EFF005EFF007AFF0091FF00A3FF00
AFFF00B5FF00B5FF00AFFF00A2FF0090FF0078FF005BFF0039FF0013FF0000FF1700FF44
00FF7500FFA700FFDB00F0FF00BCFF0088FF0056FF0027FF
35FF0006FF0000FF2A00FF5D00FF9100FFC600FFF900D3FF00A2FF0074FF0049FF0021FF
0100FF1F00FF3800FF4B00FF5800FF6000FF6100FF5C00FF5100FF4100FF2B00FF1000FF
000FFF0033FF005AFF0084FF00AFFF00DCFF00FFF600FFCA00FF9F00FF7600FF5000FF2E
00FF1008FF001BFF0029FF0030FF0032FF002DFF0023FF0013FF0000FF0200FF1C00FF3A
00FF5C00FF7F00FFA500FFCA00FFEF00ECFF00CBFF00ADFF0094FF0080FF0071FF0068FF
0065FF0068FF0072FF0081FF0095FF00ADFF00C8FF00E5FF00FFFB00FFDD00FFC100FFA7
00FF9100FF8100FF7500FF7000FF7100FF7900FF8500FF9700FFAC00FFC200FFDA00FFEF
00FDFF00EFFF00E6FF00E4FF00E8FF00F2FF00FFFF00FFEF00FFE000FFD300FFCC00FFCB
00FFD100FFDB00FFE300FFE300FFDF00FFDE00FFE500FFEF00FFF500FFF600FFF000FFE5
00FFD500FFC500FFB700FFAC00FFA700FFA800FFAF00FFBC00FFCE00FFE300FFFB00EDFF
00D8FF00C6FF00B8FF00B0FF00AEFF00B1FF00BBFF00CBFF00E0FF00F9FF00FFEA00FFCC
00FFAE00FF9000FF7400FF5B00FF4700FF3700FF2C00FF2800FF2900FF3100FF3F00FF52
00FF6B00FF8700FFA800FFCB00FFF000EAFF00C4FF00A0FF007EFF005FFF0044FF002EFF
001DFF0011FF000BFF000BFF0012FF001EFF0031FF0049FF0065FF0087FF00ACFF00D4FF
00FFFF00FFD400FFA700FF7A00FF4E00FF2402FF0027FF0047FF0063FF007AFF008CFF00
98FF009EFF009EFF0098FF008CFF0079FF0062FF0044FF0022FF0000FF0300FF2E00FF5B
00FF8C00FFBE00FFF200D9FF00A5FF0071FF0040FF0010FF
1EFF0000FF1000FF4100FF7400FFA800FFDD00EEFF00BCFF008BFF005DFF0032FF000AFF
1800FF3600FF4F00FF6200FF6F00FF7700FF7800FF7300FF6800FF5800FF4200FF2700FF
0700FF001CFF0043FF006CFF0098FF00C5FF00F2FF00FFE100FFB600FF8D00FF6700FF45
00FF2700FF0F04FF0012FF0019FF001BFF0016FF000CFF0000FF0400FF1900FF3300FF51
00FF7300FF9700FFBC00FFE100F8FF00D5FF00B4FF0096FF007DFF0068FF005AFF0051FF
004EFF0051FF005BFF006AFF007DFF0096FF00B1FF00CEFF00EDFF00FFF400FFD800FFBE
00FFA900FF9800FF8D00FF8700FF8900FF9000FF9D00FFAE00FFC300FFDA00FFF100F9FF
00E6FF00D8FF00CFFF00CDFF00D1FF00DBFF00E9FF00F9FF00FFF700FFEA00FFE300FFE2
00FFE800FFF200FFFA00FFFB00FFF600FFF500FFFC00F9FF00F2FF00F2FF00F7FF00FFFC
00FFED00FFDC00FFCE00FFC300FFBE00FFBF00FFC600FFD300FFE500FFFB00EDFF00D6FF
00C1FF00AFFF00A1FF0099FF0096FF009AFF00A4FF00B4FF00C9FF00E2FF00FEFF00FFE3
00FFC500FFA700FF8B00FF7300FF5E00FF4E00FF4300FF3F00FF4000FF4800FF5600FF69
00FF8200FF9E00FFBF00FFE200F8FF00D2FF00ADFF0089FF0067FF0048FF002DFF0017FF
0005FF0500FF0B00FF0B00FF0400FF0007FF001AFF0031FF004EFF0070FF0095FF00BDFF
00E8FF00FFEB00FFBE00FF9100FF6500FF3B00FF1410FF0030FF004CFF0063FF0075FF00
81FF0087FF0087FF0081FF0074FF0062FF004AFF002DFF000BFF0000FF1A00FF4500FF72
00FFA300FFD500F6FF00C2FF008EFF005AFF0028FF0600FF
09FF0000FF2600FF5700FF8A00FFBE00FFF200D9FF00A6FF0075FF0047FF001CFF0B00FF
2E00FF4C00FF6500FF7800FF8500FF8D00FF8E00FF8900FF7E00FF6E00FF5800FF3D00FF
1D00FF0006FF002DFF0057FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0303FF0005FF0000FF0000FF0900FF1900FF2F00FF4900FF67
00FF8900FFAC00FFD200FFF700E3FF00BFFF009EFF0080FF0067FF0053FF0044FF003BFF
0038FF003BFF0045FF0054FF0068FF0080FF009BFF00B9FF00D7FF00F5FF00FFEE00FFD4
00FFBE00FFAD00FFA200FF9D00FF9E00FFA600FFB200FFC400FFD900FFEF00F9FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F3FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EFFF00F3FF00F4FF00EDFF00E3FF00DDFF00DCFF00E2FF00EDFF
00FDFF00FFF200FFE400FFD900FFD400FFD500FFDC00FFE900FFFB00EFFF00D8FF00C1FF
00ABFF0099FF008BFF0083FF0081FF0085FF008FFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7400FF6400FF5900FF5500FF5600FF5E00FF6C00FF7F
00FF9700FFB400FFD500FFF800E2FF00BDFF0097FF0073FF0051FF0032FF0017FF0001FF
0F00FF1B00FF2100FF2100FF1A00FF0E00FF0004FF001CFF0038FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2A00FF051AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006BFF005FFF004CFF0035FF0017FF0000FF0A00FF3000FF5B00FF88
00FFB900FFEB00E0FF00ACFF0078FF0045FF0013FF1C00FF
00FF0900FF3800FF6A00FF9D00FFD100FAFF00C6FF0093FF0062FF0034FF0009FF1D00FF
4000FF5E00FF7700FF8B00FF9800FF9F00FFA100FF9C00FF9100FF8000FF6A00FF4F00FF
3000FF0C00FF001AFF0044FF006FFF009CFF00C9FF00F6FF00FFDE00FFB600FF9000FF6E
00FF5000FF3700FF2400FF1600FF0E00FF0D00FF1100FF1C00FF2C00FF4200FF5C00FF7A
00FF9B00FFBF00FFE400F5FF00D0FF00ACFF008BFF006EFF0054FF0040FF0031FF0028FF
0025FF0029FF0032FF0041FF0055FF006DFF0088FF00A6FF00C4FF00E2FF00FFFF00FFE7
00FFD100FFC000FFB500FFB000FFB100FFB800FFC500FFD600FFEB00FDFF00E6FF00D0FF
00BDFF00AFFF00A7FF00A4FF00A8FF00B2FF00C0FF00D0FF00E0FF00ECFF00F4FF00F4FF
00EEFF00E5FF00DDFF00DCFF00E0FF00E2FF00DAFF00D1FF00CAFF00C9FF00CFFF00DBFF
00EAFF00FAFF00FFF600FFEC00FFE600FFE700FFEF00FFFC00F1FF00DCFF00C5FF00AEFF
0098FF0086FF0079FF0070FF006EFF0072FF007CFF008CFF00A0FF00B9FF00D5FF00F3FF
00FFED00FFD000FFB400FF9B00FF8600FF7600FF6C00FF6700FF6900FF7100FF7E00FF92
00FFAA00FFC700FFE700F4FF00D0FF00AAFF0084FF0060FF003EFF0020FF0005FF1100FF
2200FF2E00FF3400FF3300FF2D00FF2000FF0E00FF0009FF0026FF0047FF006CFF0095FF
00BFFF00EBFF00FFE700FFBA00FF8E00FF6400FF3C00FF1808FF0024FF003BFF004CFF00
58FF005EFF005EFF0058FF004CFF003AFF0022FF0005FF0000FF1C00FF4300FF6D00FF9B
00FFCB00FFFE00CEFF0099FF0065FF0032FF0000FF2F00FF
00FF1700FF4700FF7800FFAB00FFDF00ECFF00B8FF0085FF0054FF0026FF0400FF2B00FF
4E00FF6D00FF8500FF9900FFA600FFAE00FFAF00FFAA00FF9F00FF8F00FF7900FF5D00FF
3E00FF1A00FF000CFF0036FF0061FF008EFF00BBFF00E7FF00FFED00FFC400FF9E00FF7C
00FF5E00FF4500FF3200FF2400FF1D00FF1B00FF2000FF2A00FF3A00FF5000FF6A00FF88
00FFAA00FFCD00FFF300E7FF00C2FF009EFF007DFF005FFF0046FF0032FF0023FF001AFF
0017FF001BFF0024FF0033FF0047FF005FFF007AFF0098FF00B6FF00D4FF00F0FF00FFF5
00FFDF00FFCE00FFC300FFBE00FFBF00FFC600FFD300FFE500FFF900EFFF00D8FF00C2FF
00AFFF00A1FF0098FF0096FF009AFF00A4FF00B2FF00C2FF00D2FF00DEFF00E5FF00E6FF
00E0FF00D6FF00CEFF00CEFF00D2FF00D3FF00CCFF00C3FF00BCFF00BBFF00C1FF00CCFF
00DCFF00ECFF00FAFF00FFFA00FFF500FFF600FFFD00F5FF00E3FF00CEFF00B7FF00A0FF
008AFF0078FF006AFF0062FF0060FF0064FF006EFF007DFF0092FF00ABFF00C7FF00E5FF
00FFFC00FFDE00FFC200FFA900FF9500FF8500FF7A00FF7600FF7700FF7F00FF8D00FFA0
00FFB800FFD500FFF600E6FF00C1FF009CFF0076FF0052FF0030FF0011FF0900FF1F00FF
3000FF3C00FF4200FF4100FF3B00FF2E00FF1C00FF0400FF0018FF0039FF005EFF0086FF
00B1FF00DDFF00FFF500FFC800FF9C00FF7200FF4A00FF2600FF0616FF002DFF003EFF00
4AFF0050FF0050FF004AFF003EFF002BFF0014FF0000FF0800FF2B00FF5100FF7B00FFA9
00FFDA00F3FF00BFFF008BFF0057FF0024FF0D00FF3D00FF
00FF2000FF4F00FF8000FFB400FFE800E3FF00AFFF007DFF004CFF001DFF0D00FF3400FF
5700FF7500FF8E00FFA100FFAF00FFB600FFB700FFB300FFA800FF9700FF8100FF6600FF
4600FF2300FF0003FF002DFF0059FF0085FF00B2FF00DFFF00FFF500FFCC00FFA700FF84
00FF6700FF4E00FF3A00FF2D00FF2500FF2400FF2800FF3300FF4300FF5800FF7200FF91
00FFB200FFD600FFFB00DEFF00B9FF0096FF0075FF0057FF003EFF0029FF001AFF0011FF
000FFF0012FF001BFF002AFF003EFF0056FF0072FF008FFF00ADFF00CBFF00E8FF00FFFD
00FFE800FFD700FFCC00FFC700FFC800FFCF00FFDC00FFED00FDFF00E6FF00CFFF00B9FF
00A7FF0098FF0090FF008EFF0092FF009BFF00A9FF00B9FF00C9FF00D6FF00DDFF00DDFF
00D7FF00CEFF00C6FF00C5FF00CAFF00CBFF00C4FF00BAFF00B3FF00B2FF00B8FF00C4FF
00D3FF00E3FF00F2FF00FDFF00FFFD00FFFE00FAFF00ECFF00DAFF00C5FF00AEFF0097FF
0082FF0070FF0062FF005AFF0057FF005BFF0065FF0075FF008AFF00A3FF00BFFF00DCFF
00FBFF00FFE600FFCB00FFB200FF9D00FF8D00FF8300FF7E00FF8000FF8700FF9500FFA8
00FFC100FFDE00FFFE00DEFF00B9FF0093FF006EFF004AFF0028FF0009FF1100FF2800FF
3900FF4500FF4A00FF4A00FF4400FF3700FF2500FF0D00FF000FFF0030FF0056FF007EFF
00A8FF00D5FF00FFFD00FFD100FFA500FF7B00FF5300FF2F00FF0E0DFF0024FF0036FF00
42FF0048FF0048FF0041FF0035FF0023FF000BFF0000FF1100FF3300FF5A00FF8400FFB2
00FFE200EBFF00B7FF0083FF004EFF001BFF1600FF4500FF
00FF2200FF5100FF8300FFB600FFEA00E1FF00ADFF007AFF0049FF001BFF0F00FF3600FF
5900FF7700FF9000FFA400FFB100FFB800FFBA00FFB500FFAA00FF9900FF8300FF6800FF
4900FF2500FF0001FF002BFF0056FF0083FF00B0FF00DDFF00FFF700FFCF00FFA900FF87
00FF6900FF5000FF3D00FF2F00FF2700FF2600FF2A00FF3500FF4500FF5B00FF7500FF93
00FFB400FFD800FFFD00DCFF00B7FF0093FF0072FF0055FF003BFF0027FF0018FF000FFF
000CFF0010FF0019FF0028FF003CFF0054FF006FFF008DFF00ABFF00C9FF00E6FF00FFFF
00FFEA00FFD900FFCE00FFC900FFCA00FFD100FFDE00FFEF00FBFF00E4FF00CDFF00B7FF
00A4FF0096FF008EFF008BFF008FFF0099FF00A7FF00B7FF00C7FF00D3FF00DBFF00DBFF
00D5FF00CCFF00C4FF00C3FF00C8FF00C9FF00C2FF00B8FF00B1FF00B0FF00B6FF00C2FF
00D1FF00E1FF00F0FF00FAFF00FFFF00FFFF00F7FF00EAFF00D8FF00C3FF00ACFF0095FF
007FFF006DFF0060FF0057FF0055FF0059FF0063FF0073FF0087FF00A0FF00BCFF00DAFF
00F9FF00FFE900FFCD00FFB400FF9F00FF8F00FF8500FF8000FF8200FF8A00FF9700FFAB
00FFC300FFE000FFFF00DBFF00B7FF0091FF006CFF0047FF0025FF0007FF1300FF2A00FF
3B00FF4700FF4D00FF4C00FF4600FF3900FF2700FF0F00FF000DFF002EFF0053FF007CFF
00A6FF00D2FF00FFFF00FFD300FFA700FF7D00FF5500FF3100FF100BFF0022FF0033FF00
3FFF0045FF0045FF003FFF0033FF0021FF0009FF0000FF1300FF3500FF5C00FF8600FFB4
00FFE400E8FF00B5FF0080FF004CFF0019FF1800FF4800FF
00FF1E00FF4D00FF7F00FFB200FFE600E5FF00B1FF007EFF004EFF001FFF0B00FF3200FF
5500FF7300FF8C00FF9F00FFAD00FFB400FFB500FFB100FFA600FF9500FF7F00FF6400FF
4400FF2100FF0005FF002FFF005BFF0087FF00B4FF00E1FF00FFF300FFCB00FFA500FF83
00FF6500FF4C00FF3900FF2B00FF2300FF2200FF2600FF3100FF4100FF5600FF7100FF8F
00FFB000FFD400FFF900E0FF00BBFF0097FF0076FF0059FF003FFF002BFF001CFF0013FF
0011FF0014FF001DFF002CFF0040FF0058FF0073FF0091FF00AFFF00CDFF00EAFF00FFFC
00FFE600FFD500FFCA00FFC500FFC600FFCD00FFDA00FFEB00FFFF00E8FF00D1FF00BBFF
00A8FF009AFF0092FF008FFF0094FF009DFF00ABFF00BBFF00CBFF00D8FF00DFFF00DFFF
00D9FF00D0FF00C8FF00C7FF00CCFF00CDFF00C6FF00BCFF00B5FF00B4FF00BAFF00C6FF
00D5FF00E5FF00F4FF00FEFF00FFFB00FFFC00FBFF00EEFF00DCFF00C7FF00B0FF0099FF
0084FF0071FF0064FF005BFF0059FF005DFF0067FF0077FF008CFF00A4FF00C0FF00DEFF
00FDFF00FFE500FFC900FFB000FF9B00FF8B00FF8100FF7C00FF7E00FF8600FF9300FFA7
00FFBF00FFDC00FFFC00E0FF00BBFF0095FF0070FF004BFF002AFF000BFF0F00FF2600FF
3700FF4300FF4800FF4800FF4200FF3500FF2300FF0B00FF0011FF0032FF0057FF0080FF
00AAFF00D7FF00FFFC00FFCF00FFA300FF7900FF5100FF2D00FF0C0FFF0026FF0038FF00
44FF004AFF0049FF0043FF0037FF0025FF000DFF0000FF0F00FF3100FF5800FF8200FFB0
00FFE000ECFF00B9FF0084FF0050FF001DFF1400FF4400FF
00FF1400FF4300FF7500FFA800FFDC00EFFF00BBFF0088FF0057FF0029FF0100FF2800FF
4B00FF6A00FF8200FF9600FFA300FFAA00FFAC00FFA700FF9C00FF8C00FF7600FF5A00FF
3B00FF1700FF000FFF0039FF0064FF0091FF00BEFF00EAFF00FFEA00FFC100FF9B00FF79
00FF5B00FF4200FF2F00FF2100FF1900FF1800FF1D00FF2700FF3700FF4D00FF6700FF85
00FFA600FFCA00FFEF00EAFF00C5FF00A1FF0080FF0063FF0049FF0035FF0026FF001DFF
001AFF001EFF0027FF0036FF004AFF0062FF007DFF009BFF00B9FF00D7FF00F3FF00FFF2
00FFDC00FFCB00FFC000FFBB00FFBC00FFC300FFD000FFE200FFF600F2FF00DBFF00C5FF
00B2FF00A4FF009BFF0099FF009DFF00A7FF00B5FF00C5FF00D5FF00E1FF00E8FF00E9FF
00E3FF00D9FF00D1FF00D1FF00D5FF00D6FF00CFFF00C6FF00BFFF00BEFF00C4FF00CFFF
00DFFF00EFFF00FEFF00FFF700FFF200FFF300FFFA00F8FF00E6FF00D1FF00BAFF00A3FF
008DFF007BFF006DFF0065FF0063FF0067FF0071FF0080FF0095FF00AEFF00CAFF00E8FF
00FFF900FFDB00FFBF00FFA600FF9100FF8200FF7700FF7200FF7400FF7C00FF8A00FF9D
00FFB500FFD200FFF300E9FF00C4FF009FFF0079FF0055FF0033FF0014FF0600FF1C00FF
2D00FF3900FF3F00FF3E00FF3800FF2B00FF1900FF0100FF001BFF003CFF0061FF0089FF
00B4FF00E0FF00FFF200FFC500FF9900FF6F00FF4700FF2300FF0219FF0030FF0041FF00
4DFF0053FF0053FF004DFF0041FF002FFF0017FF0000FF0500FF2700FF4E00FF7800FFA6
00FFD700F6FF00C2FF008EFF005AFF0027FF0A00FF3A00FF
00FF0600FF3600FF6700FF9A00FFCE00FDFF00C9FF0096FF0065FF0037FF000CFF1A00FF
3D00FF5C00FF7400FF8800FF9500FF9D00FF9E00FF9900FF8E00FF7E00FF6800FF4C00FF
2D00FF0900FF001DFF0047FF0072FF009FFF00CCFF00F8FF00FFDC00FFB300FF8D00FF6B
00FF4D00FF3400FF2100FF1300FF0C00FF0A00FF0F00FF1900FF2900FF3F00FF5900FF77
00FF9900FFBC00FFE200F8FF00D3FF00AFFF008EFF0070FF0057FF0043FF0034FF002BFF
0028FF002CFF0035FF0044FF0058FF0070FF008BFF00A9FF00C7FF00E5FF00FFFE00FFE4
00FFCE00FFBD00FFB200FFAD00FFAE00FFB600FFC200FFD400FFE800FFFF00E9FF00D3FF
00C0FF00B2FF00A9FF00A7FF00ABFF00B5FF00C3FF00D3FF00E3FF00EFFF00F6FF00F7FF
00F1FF00E7FF00DFFF00DFFF00E3FF00E4FF00DDFF00D4FF00CDFF00CCFF00D2FF00DDFF
00EDFF00FDFF00FFF400FFE900FFE400FFE500FFEC00FFF900F4FF00DFFF00C8FF00B1FF
009BFF0089FF007BFF0073FF0071FF0075FF007FFF008EFF00A3FF00BCFF00D8FF00F6FF
00FFEB00FFCD00FFB100FF9800FF8400FF7400FF6900FF6500FF6600FF6E00FF7C00FF8F
00FFA700FFC400FFE500F7FF00D2FF00ADFF0087FF0063FF0041FF0022FF0007FF0E00FF
1F00FF2B00FF3100FF3000FF2A00FF1D00FF0B00FF000CFF0029FF004AFF006FFF0097FF
00C2FF00EEFF00FFE400FFB700FF8B00FF6100FF3900FF150AFF0026FF003EFF004FFF00
5BFF0061FF0061FF005BFF004FFF003CFF0025FF0008FF0000FF1A00FF4000FF6A00FF98
00FFC900FFFB00D0FF009CFF0068FF0035FF0003FF2C00FF
09FF0000FF2500FF5700FF8A00FFBE00FFF200D9FF00A6FF0075FF0047FF001CFF0A00FF
2D00FF4B00FF6400FF7800FF8500FF8C00FF8E00FF8900FF7E00FF6E00FF5700FF3C00FF
1D00FF0006FF002DFF0057FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0304FF0005FF0001FF0000FF0900FF1900FF2F00FF4900FF67
00FF8800FFAC00FFD100FFF700E3FF00BFFF009EFF0081FF0067FF0053FF0044FF003BFF
0038FF003CFF0045FF0054FF0068FF0080FF009BFF00B9FF00D7FF00F5FF00FFED00FFD4
00FFBE00FFAD00FFA200FF9D00FF9E00FFA500FFB200FFC400FFD800FFEF00F9FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F3FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EFFF00F3FF00F4FF00EDFF00E4FF00DDFF00DCFF00E2FF00EEFF
00FDFF00FFF200FFE300FFD900FFD300FFD400FFDC00FFE900FFFB00EFFF00D8FF00C1FF
00ABFF0099FF008BFF0083FF0081FF0085FF008FFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7300FF6300FF5900FF5400FF5600FF5E00FF6C00FF7F
00FF9700FFB400FFD500FFF800E2FF00BDFF0097FF0073FF0051FF0032FF0017FF0001FF
0F00FF1B00FF2100FF2000FF1A00FF0D00FF0004FF001CFF0039FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2900FF051BFF0037FF004EFF005FFF00
6BFF0071FF0071FF006BFF005FFF004DFF0035FF0018FF0000FF0900FF3000FF5A00FF88
00FFB800FFEB00E0FF00ACFF0078FF0045FF0013FF1C00FF
18FF0000FF1600FF4700FF7A00FFAE00FFE300E9FF00B6FF0085FF0057FF002CFF0004FF
1E00FF3C00FF5500FF6800FF7500FF7D00FF7E00FF7900FF6E00FF5E00FF4800FF2D00FF
0D00FF0016FF003DFF0066FF0092FF00BFFF00ECFF00FFE700FFBC00FF9300FF6D00FF4B
00FF2D00FF1500FF010CFF0013FF0015FF0010FF0006FF0000FF0A00FF1F00FF3900FF57
00FF7900FF9D00FFC200FFE700F2FF00CFFF00AEFF0090FF0077FF0063FF0054FF004BFF
0048FF004BFF0055FF0064FF0077FF0090FF00ABFF00C8FF00E7FF00FFFA00FFDE00FFC4
00FFAE00FF9E00FF9200FF8D00FF8F00FF9600FFA200FFB400FFC900FFE000FFF700F3FF
00E0FF00D2FF00C9FF00C7FF00CBFF00D5FF00E3FF00F3FF00FFFD00FFF000FFE900FFE8
00FFEE00FFF800FFFF00FEFF00FFFC00FFFB00FDFF00F3FF00ECFF00ECFF00F1FF00FDFF
00FFF300FFE200FFD400FFC900FFC400FFC500FFCC00FFD900FFEB00FEFF00E7FF00D0FF
00BBFF00A9FF009BFF0093FF0090FF0094FF009EFF00AEFF00C3FF00DCFF00F8FF00FFE9
00FFCB00FFAD00FF9100FF7900FF6400FF5400FF4900FF4500FF4600FF4E00FF5C00FF6F
00FF8800FFA400FFC500FFE800F2FF00CCFF00A7FF0083FF0061FF0042FF0027FF0011FF
0000FF0B00FF1100FF1100FF0A00FF0001FF0014FF002BFF0048FF006AFF008FFF00B7FF
00E2FF00FFF100FFC400FF9700FF6B00FF4100FF1A0AFF002AFF0046FF005DFF006FFF00
7BFF0081FF0081FF007BFF006EFF005CFF0044FF0027FF0005FF0000FF2000FF4B00FF78
00FFA900FFDB00F0FF00BCFF0088FF0054FF0023FF0C00FF
25FF0000FF0900FF3B00FF6E00FFA200FFD600F5FF00C2FF0092FF0063FF0038FF0011FF
1100FF2F00FF4800FF5B00FF6900FF7000FF7100FF6D00FF6200FF5100FF3B00FF2000FF
0000FF0022FF0049FF0073FF009FFF00CBFF00F8FF00FFDA00FFAF00FF8600FF6100FF3F
00FF2100FF080BFF0018FF0020FF0021FF001DFF0012FF0002FF0000FF1200FF2D00FF4B
00FF6C00FF9000FFB500FFDB00FFFF00DBFF00BAFF009DFF0083FF006FFF0060FF0057FF
0055FF0058FF0061FF0070FF0084FF009CFF00B7FF00D5FF00F3FF00FFEE00FFD100FFB8
00FFA200FF9100FF8600FF8100FF8200FF8900FF9600FFA700FFBC00FFD300FFEA00FFFF
00ECFF00DEFF00D6FF00D3FF00D8FF00E1FF00EFFF00FFFF00FFF000FFE300FFDC00FFDC
00FFE200FFEB00FFF300FFF400FFEF00FFEE00FFF500FFFF00F9FF00F8FF00FEFF00FFF5
00FFE600FFD600FFC700FFBC00FFB700FFB800FFC000FFCD00FFDF00FFF400F4FF00DDFF
00C8FF00B5FF00A8FF009FFF009DFF00A1FF00ABFF00BBFF00D0FF00E8FF00FFFB00FFDD
00FFBE00FFA100FF8500FF6C00FF5700FF4700FF3D00FF3800FF3A00FF4200FF4F00FF63
00FF7B00FF9800FFB800FFDB00FFFF00D9FF00B4FF008FFF006EFF004FFF0034FF001DFF
000CFF0000FF0400FF0400FF0001FF000EFF0020FF0038FF0055FF0076FF009BFF00C4FF
00EEFF00FFE400FFB800FF8B00FF5F00FF3500FF0D16FF0037FF0053FF006AFF007CFF00
88FF008EFF008DFF0087FF007BFF0069FF0051FF0034FF0012FF0000FF1400FF3E00FF6C
00FF9C00FFCF00FDFF00C8FF0094FF0061FF002FFF0000FF
2CFF0000FF0200FF3300FF6600FF9B00FFCF00FCFF00CAFF0099FF006AFF003FFF0018FF
0A00FF2800FF4100FF5400FF6200FF6900FF6A00FF6500FF5B00FF4A00FF3400FF1900FF
0006FF0029FF0050FF007AFF00A6FF00D2FF00FFFF00FFD300FFA800FF7F00FF5900FF37
00FF1A00FF0112FF001FFF0027FF0029FF0024FF0019FF0009FF0000FF0B00FF2500FF44
00FF6500FF8900FFAE00FFD400FFF900E3FF00C2FF00A4FF008BFF0076FF0067FF005FFF
005CFF005FFF0068FF0077FF008BFF00A3FF00BFFF00DCFF00FAFF00FFE600FFCA00FFB0
00FF9B00FF8A00FF7F00FF7A00FF7B00FF8200FF8F00FFA000FFB500FFCC00FFE300FFF9
00F4FF00E5FF00DDFF00DBFF00DFFF00E8FF00F6FF00FFF900FFE900FFDC00FFD500FFD5
00FFDA00FFE400FFEC00FFED00FFE800FFE700FFEE00FFF800FFFF00FFFF00FFFA00FFEE
00FFDF00FFCF00FFC000FFB500FFB000FFB100FFB800FFC600FFD700FFED00FBFF00E4FF
00CFFF00BDFF00AFFF00A7FF00A4FF00A8FF00B2FF00C2FF00D7FF00F0FF00FFF300FFD5
00FFB700FF9900FF7E00FF6500FF5000FF4000FF3600FF3100FF3300FF3A00FF4800FF5B
00FF7400FF9100FFB100FFD400FFF900E0FF00BBFF0097FF0075FF0056FF003BFF0024FF
0013FF0008FF0002FF0002FF0009FF0015FF0027FF003FFF005CFF007DFF00A3FF00CBFF
00F6FF00FFDD00FFB000FF8400FF5800FF2E00FF061EFF003EFF005AFF0071FF0083FF00
8FFF0095FF0095FF008EFF0082FF0070FF0058FF003BFF0019FF0000FF0D00FF3700FF65
00FF9500FFC700FFFB00D0FF009BFF0068FF0036FF0007FF
2DFF0000FF0200FF3300FF6600FF9A00FFCE00FDFF00CAFF0099FF006BFF0040FF0019FF
0900FF2800FF4000FF5400FF6100FF6900FF6A00FF6500FF5A00FF4A00FF3400FF1800FF
0006FF002AFF0051FF007BFF00A6FF00D3FF00FFFF00FFD300FFA800FF7F00FF5900FF37
00FF1900FF0012FF0020FF0027FF0029FF0024FF001AFF000AFF0000FF0B00FF2500FF43
00FF6500FF8800FFAE00FFD300FFF800E3FF00C2FF00A4FF008BFF0077FF0068FF005FFF
005CFF0060FF0069FF0078FF008CFF00A4FF00BFFF00DDFF00FBFF00FFE600FFCA00FFB0
00FF9A00FF8900FF7E00FF7900FF7A00FF8100FF8E00FFA000FFB400FFCB00FFE200FFF8
00F4FF00E6FF00DDFF00DBFF00DFFF00E9FF00F7FF00FFF800FFE800FFDC00FFD500FFD4
00FFDA00FFE400FFEC00FFEC00FFE800FFE700FFEE00FFF700FFFE00FFFF00FFF900FFEE
00FFDE00FFCE00FFC000FFB500FFB000FFB100FFB800FFC500FFD700FFEC00FCFF00E5FF
00CFFF00BDFF00AFFF00A7FF00A5FF00A9FF00B3FF00C2FF00D7FF00F0FF00FFF300FFD5
00FFB700FF9900FF7D00FF6400FF5000FF4000FF3500FF3100FF3200FF3A00FF4800FF5B
00FF7300FF9000FFB100FFD400FFF900E1FF00BBFF0097FF0075FF0056FF003BFF0025FF
0014FF0008FF0002FF0003FF0009FF0016FF0028FF0040FF005DFF007EFF00A3FF00CBFF
00F6FF00FFDD00FFB000FF8300FF5700FF2D00FF051EFF003EFF005AFF0072FF0083FF00
8FFF0095FF0095FF008FFF0083FF0070FF0059FF003CFF0019FF0000FF0C00FF3600FF64
00FF9500FFC700FFFB00D0FF009CFF0069FF0037FF0007FF
27FF0000FF0700FF3900FF6C00FFA000FFD400F7FF00C4FF0093FF0065FF003AFF0013FF
0F00FF2D00FF4600FF5A00FF6700FF6E00FF7000FF6B00FF6000FF5000FF3900FF1E00FF
0000FF0024FF004BFF0075FF00A0FF00CDFF00FAFF00FFD900FFAE00FF8500FF5F00FF3D
00FF1F00FF060CFF001AFF0022FF0023FF001FFF0014FF0004FF0000FF1100FF2B00FF49
00FF6A00FF8E00FFB300FFD900FFFE00DDFF00BCFF009FFF0085FF0071FF0062FF0059FF
0056FF005AFF0063FF0072FF0086FF009EFF00B9FF00D7FF00F5FF00FFEC00FFCF00FFB6
00FFA000FF8F00FF8400FF7F00FF8000FF8700FF9400FFA600FFBA00FFD100FFE800FFFE
00EEFF00E0FF00D7FF00D5FF00D9FF00E3FF00F1FF00FFFE00FFEE00FFE200FFDA00FFDA
00FFE000FFE900FFF200FFF200FFEE00FFED00FFF400FFFD00FBFF00FAFF00FFFF00FFF3
00FFE400FFD400FFC500FFBB00FFB500FFB600FFBE00FFCB00FFDD00FFF200F6FF00DFFF
00C9FF00B7FF00A9FF00A1FF009FFF00A3FF00ADFF00BCFF00D1FF00EAFF00FFF900FFDB
00FFBD00FF9F00FF8300FF6A00FF5500FF4500FF3B00FF3600FF3800FF4000FF4D00FF61
00FF7900FF9600FFB700FFDA00FFFF00DBFF00B5FF0091FF006FFF0050FF0035FF001FFF
000EFF0002FF0300FF0200FF0003FF0010FF0022FF003AFF0057FF0078FF009DFF00C5FF
00F0FF00FFE300FFB600FF8900FF5D00FF3300FF0B18FF0039FF0055FF006CFF007DFF00
89FF008FFF008FFF0089FF007DFF006BFF0053FF0036FF0014FF0000FF1200FF3C00FF6A
00FF9A00FFCD00FEFF00CAFF0096FF0063FF0031FF0001FF
1DFF0000FF1100FF4200FF7500FFAA00FFDE00EDFF00BBFF008AFF005BFF0030FF0009FF
1900FF3700FF5000FF6300FF7100FF7800FF7900FF7400FF6A00FF5900FF4300FF2800FF
0800FF001AFF0042FF006BFF0097FF00C4FF00F0FF00FFE200FFB700FF8E00FF6800FF46
00FF2900FF1003FF0010FF0018FF001AFF0015FF000AFF0000FF0500FF1A00FF3400FF53
00FF7400FF9800FFBD00FFE300F7FF00D4FF00B3FF0095FF007CFF0067FF0058FF0050FF
004DFF0050FF0059FF0068FF007CFF0094FF00B0FF00CDFF00ECFF00FFF500FFD900FFBF
00FFAA00FF9900FF8E00FF8900FF8A00FF9100FF9E00FFAF00FFC400FFDB00FFF200F7FF
00E5FF00D6FF00CEFF00CCFF00D0FF00D9FF00E7FF00F7FF00FFF800FFEB00FFE400FFE4
00FFE900FFF300FFFB00FFFC00FFF700FFF600FFFD00F8FF00F1FF00F0FF00F6FF00FFFD
00FFEE00FFDE00FFCF00FFC400FFBF00FFC000FFC700FFD500FFE600FFFC00ECFF00D5FF
00C0FF00AEFF00A0FF0098FF0095FF0099FF00A3FF00B3FF00C8FF00E1FF00FDFF00FFE4
00FFC600FFA800FF8D00FF7400FF5F00FF4F00FF4500FF4000FF4200FF4900FF5700FF6A
00FF8300FFA000FFC000FFE300F7FF00D1FF00ACFF0088FF0066FF0047FF002CFF0015FF
0004FF0600FF0C00FF0C00FF0500FF0006FF0018FF0030FF004DFF006EFF0094FF00BCFF
00E7FF00FFEC00FFBF00FF9300FF6700FF3C00FF150FFF002FFF004BFF0062FF0074FF00
80FF0086FF0086FF007FFF0073FF0061FF0049FF002CFF000AFF0000FF1B00FF4600FF74
00FFA400FFD600F5FF00C1FF008CFF0059FF0027FF0700FF
15FF0000FF1900FF4A00FF7E00FFB200FFE600E5FF00B3FF0082FF0053FF0028FF0001FF
2100FF3F00FF5800FF6B00FF7900FF8000FF8100FF7C00FF7200FF6100FF4B00FF3000FF
1000FF0012FF0039FF0063FF008FFF00BBFF00E8FF00FFEA00FFBF00FF9600FF7100FF4E
00FF3100FF1800FF0408FF0010FF0012FF000DFF0002FF0000FF0D00FF2200FF3C00FF5B
00FF7C00FFA000FFC500FFEB00EFFF00CCFF00ABFF008DFF0074FF005FFF0050FF0047FF
0045FF0048FF0051FF0060FF0074FF008CFF00A8FF00C5FF00E3FF00FFFE00FFE100FFC7
00FFB200FFA100FF9600FF9100FF9200FF9900FFA600FFB700FFCC00FFE300FFFA00EFFF
00DDFF00CEFF00C6FF00C4FF00C8FF00D1FF00DFFF00EFFF00FFFF00FFF300FFEC00FFEC
00FFF200FFFB00FCFF00FBFF00FFFF00FFFE00FAFF00F0FF00E9FF00E8FF00EEFF00FAFF
00FFF600FFE600FFD700FFCC00FFC700FFC800FFCF00FFDD00FFEF00FBFF00E4FF00CDFF
00B8FF00A6FF0098FF0090FF008DFF0091FF009BFF00ABFF00C0FF00D9FF00F5FF00FFED
00FFCE00FFB000FF9500FF7C00FF6700FF5700FF4D00FF4800FF4A00FF5100FF5F00FF72
00FF8B00FFA800FFC800FFEB00EFFF00C9FF00A4FF0080FF005EFF003FFF0024FF000DFF
0300FF0F00FF1400FF1400FF0D00FF0100FF0010FF0028FF0045FF0066FF008CFF00B4FF
00DEFF00FFF400FFC700FF9B00FF6F00FF4500FF1D06FF0027FF0043FF005AFF006CFF00
78FF007EFF007EFF0077FF006BFF0059FF0041FF0024FF0002FF0000FF2400FF4E00FF7C
00FFAC00FFDE00EDFF00B9FF0084FF0051FF001FFF0F00FF
14FF0000FF1A00FF4B00FF7E00FFB200FFE700E5FF00B2FF0081FF0053FF0028FF0000FF
2200FF4000FF5900FF6C00FF7900FF8100FF8200FF7D00FF7200FF6200FF4C00FF3100FF
1100FF0012FF0039FF0062FF008EFF00BBFF00E8FF00FFEB00FFC000FF9700FF7100FF4F
00FF3100FF1800FF0508FF000FFF0011FF000CFF0002FF0000FF0E00FF2300FF3D00FF5B
00FF7D00FFA100FFC600FFEB00EEFF00CBFF00AAFF008CFF0073FF005FFF0050FF0047FF
0044FF0047FF0051FF0060FF0074FF008CFF00A7FF00C4FF00E3FF00FFFE00FFE200FFC8
00FFB200FFA200FF9600FF9100FF9300FF9A00FFA600FFB800FFCD00FFE300FFFB00EFFF
00DCFF00CEFF00C5FF00C3FF00C7FF00D1FF00DFFF00EFFF00FEFF00FFF400FFED00FFEC
00FFF200FFFC00FBFF00FAFF00FFFF00FFFF00F9FF00EFFF00E8FF00E8FF00EEFF00F9FF
00FFF700FFE600FFD800FFCD00FFC800FFC900FFD000FFDD00FFEF00FAFF00E3FF00CCFF
00B7FF00A5FF0097FF008FFF008CFF0090FF009AFF00AAFF00BFFF00D8FF00F4FF00FFED
00FFCF00FFB100FF9500FF7D00FF6800FF5800FF4D00FF4900FF4A00FF5200FF6000FF73
00FF8C00FFA800FFC900FFEC00EEFF00C8FF00A3FF007FFF005DFF003EFF0023FF000DFF
0400FF0F00FF1500FF1500FF0E00FF0200FF0010FF0027FF0044FF0066FF008BFF00B3FF
00DEFF00FFF500FFC800FF9B00FF6F00FF4500FF1E06FF0026FF0042FF0059FF006BFF00
77FF007DFF007DFF0077FF006AFF0058FF0040FF0023FF0001FF0000FF2400FF4F00FF7C
00FFAD00FFDF00ECFF00B8FF0084FF0050FF001FFF1000FF
19FF0000FF1500FF4700FF7A00FFAE00FFE200E9FF00B6FF0086FF0057FF002CFF0005FF
1D00FF3B00FF5400FF6700FF7500FF7C00FF7D00FF7900FF6E00FF5D00FF4700FF2C00FF
0C00FF0016FF003DFF0067FF0093FF00BFFF00ECFF00FFE600FFBB00FF9200FF6D00FF4A
00FF2D00FF1400FF000CFF0014FF0015FF0011FF0006FF0000FF0900FF1E00FF3900FF57
00FF7800FF9C00FFC100FFE700F3FF00D0FF00AFFF0091FF0078FF0063FF0054FF004BFF
0049FF004CFF0055FF0064FF0078FF0090FF00ACFF00C9FF00E7FF00FFFA00FFDD00FFC3
00FFAE00FF9D00FF9200FF8D00FF8E00FF9500FFA200FFB300FFC800FFDF00FFF600F3FF
00E0FF00D2FF00CAFF00C8FF00CCFF00D5FF00E3FF00F3FF00FFFC00FFEF00FFE800FFE8
00FFEE00FFF700FFFF00FFFF00FFFB00FFFA00FEFF00F4FF00EDFF00ECFF00F2FF00FEFF
00FFF200FFE200FFD300FFC800FFC300FFC400FFCB00FFD900FFEB00FFFF00E8FF00D1FF
00BCFF00AAFF009CFF0093FF0091FF0095FF009FFF00AFFF00C4FF00DDFF00F9FF00FFE9
00FFCA00FFAC00FF9100FF7800FF6300FF5300FF4900FF4400FF4600FF4D00FF5B00FF6F
00FF8700FFA400FFC400FFE700F3FF00CDFF00A8FF0084FF0062FF0043FF0028FF0011FF
0000FF0B00FF1000FF1000FF0A00FF0002FF0014FF002CFF0049FF006AFF008FFF00B8FF
00E2FF00FFF000FFC300FF9700FF6B00FF4100FF190AFF002BFF0047FF005EFF0070FF00
7CFF0082FF0082FF007BFF006FFF005DFF0045FF0028FF0006FF0000FF2000FF4A00FF78
00FFA800FFDB00F1FF00BDFF0088FF0055FF0023FF0B00FF
1AFF0000FF1400FF4500FF7900FFAD00FFE100EAFF00B8FF0087FF0058FF002DFF0006FF
1C00FF3A00FF5300FF6600FF7400FF7B00FF7C00FF7800FF6D00FF5C00FF4600FF2B00FF
0B00FF0017FF003EFF0068FF0094FF00C0FF00EDFF00FFE500FFBA00FF9100FF6C00FF49
00FF2C00FF1300FF000DFF0015FF0016FF0012FF0007FF0000FF0800FF1D00FF3700FF56
00FF7700FF9B00FFC000FFE600F4FF00D1FF00B0FF0092FF0079FF0064FF0055FF004CFF
004AFF004DFF0056FF0065FF0079FF0091FF00ADFF00CAFF00E8FF00FFF900FFDC00FFC2
00FFAD00FF9C00FF9100FF8C00FF8D00FF9400FFA100FFB200FFC700FFDE00FFF500F4FF
00E2FF00D3FF00CBFF00C9FF00CDFF00D6FF00E4FF00F4FF00FFFB00FFEE00FFE700FFE7
00FFED00FFF600FFFE00FFFF00FFFA00FFF900FFFF00F5FF00EEFF00EDFF00F3FF00FFFF
00FFF100FFE100FFD200FFC700FFC200FFC300FFCA00FFD800FFEA00FFFF00E9FF00D2FF
00BDFF00ABFF009DFF0095FF0092FF0096FF00A0FF00B0FF00C5FF00DEFF00FAFF00FFE8
00FFC900FFAB00FF9000FF7700FF6200FF5200FF4800FF4300FF4500FF4C00FF5A00FF6D
00FF8600FFA300FFC300FFE600F4FF00CEFF00A9FF0085FF0063FF0044FF0029FF0012FF
0001FF0A00FF0F00FF0F00FF0900FF0003FF0015FF002DFF004AFF006BFF0091FF00B9FF
00E3FF00FFEF00FFC200FF9600FF6A00FF4000FF180BFF002CFF0048FF005FFF0071FF00
7DFF0083FF0083FF007CFF0070FF005EFF0046FF0029FF0007FF0000FF1F00FF4900FF77
00FFA700FFD900F2FF00BEFF0089FF0056FF0024FF0A00FF
13FF0000FF1B00FF4D00FF8000FFB400FFE800E3FF00B0FF0080FF0051FF0026FF0000FF
2300FF4100FF5A00FF6D00FF7B00FF8200FF8300FF7F00FF7400FF6300FF4D00FF3200FF
1200FF0010FF0037FF0061FF008DFF00B9FF00E6FF00FFEC00FFC100FF9800FF7300FF50
00FF3300FF1A00FF0606FF000EFF000FFF000BFF0000FF0000FF0F00FF2400FF3F00FF5D
00FF7E00FFA200FFC700FFED00EDFF00CAFF00A9FF008BFF0072FF005DFF004EFF0045FF
0043FF0046FF004FFF005EFF0072FF008AFF00A6FF00C3FF00E1FF00FFFF00FFE300FFCA
00FFB400FFA300FF9800FF9300FF9400FF9B00FFA800FFB900FFCE00FFE500FFFC00EDFF
00DAFF00CCFF00C4FF00C2FF00C6FF00CFFF00DDFF00EDFF00FDFF00FFF500FFEE00FFEE
00FFF400FFFD00FAFF00F9FF00FEFF00FFFF00F8FF00EEFF00E7FF00E6FF00ECFF00F8FF
00FFF800FFE800FFD900FFCE00FFC900FFCA00FFD100FFDF00FFF100F9FF00E2FF00CBFF
00B6FF00A4FF0096FF008DFF008BFF008FFF0099FF00A9FF00BEFF00D7FF00F3FF00FFEF
00FFD000FFB200FF9700FF7E00FF6900FF5900FF4F00FF4A00FF4C00FF5300FF6100FF75
00FF8D00FFAA00FFCA00FFED00EDFF00C7FF00A2FF007EFF005CFF003DFF0022FF000BFF
0500FF1100FF1600FF1600FF1000FF0300FF000EFF0026FF0043FF0064FF0089FF00B2FF
00DCFF00FFF600FFC900FF9D00FF7100FF4700FF1F04FF0025FF0041FF0058FF006AFF00
76FF007CFF007CFF0075FF0069FF0057FF003FFF0022FF0000FF0000FF2600FF5000FF7E
00FFAE00FFE100EBFF00B6FF0082FF004FFF001DFF1100FF
09FF0000FF2500FF5600FF8900FFBD00FFF200D9FF00A7FF0076FF0048FF001DFF0A00FF
2D00FF4B00FF6400FF7700FF8400FF8C00FF8D00FF8800FF7D00FF6D00FF5700FF3C00FF
1C00FF0007FF002EFF0057FF0083FF00B0FF00DDFF00FFF600FFCB00FFA200FF7C00FF5A
00FF3C00FF2400FF1000FF0204FF0006FF0001FF0000FF0800FF1900FF2E00FF4800FF66
00FF8800FFAC00FFD100FFF600E3FF00C0FF009FFF0081FF0068FF0053FF0045FF003CFF
0039FF003CFF0046FF0055FF0068FF0081FF009CFF00B9FF00D8FF00F6FF00FFED00FFD3
00FFBE00FFAD00FFA200FF9C00FF9E00FFA500FFB200FFC300FFD800FFEF00F9FF00E3FF
00D1FF00C3FF00BAFF00B8FF00BCFF00C6FF00D4FF00E4FF00F3FF00FFFF00FFF800FFF7
00FFFD00F8FF00F0FF00EFFF00F4FF00F5FF00EEFF00E4FF00DDFF00DCFF00E2FF00EEFF
00FDFF00FFF100FFE300FFD800FFD300FFD400FFDB00FFE800FFFA00EFFF00D8FF00C1FF
00ACFF009AFF008CFF0084FF0081FF0085FF008FFF009FFF00B4FF00CDFF00E9FF00FFF8
00FFDA00FFBC00FFA000FF8800FF7300FF6300FF5800FF5400FF5500FF5D00FF6B00FF7E
00FF9700FFB400FFD400FFF700E3FF00BDFF0098FF0074FF0052FF0033FF0018FF0002FF
0F00FF1A00FF2000FF2000FF1900FF0D00FF0005FF001CFF0039FF005BFF0080FF00A8FF
00D3FF00FFFF00FFD300FFA600FF7A00FF5000FF2900FF041BFF0037FF004EFF0060FF00
6CFF0072FF0072FF006CFF005FFF004DFF0035FF0018FF0000FF0900FF2F00FF5A00FF87
00FFB800FFEA00E1FF00ADFF0079FF0045FF0013FF1B00FF
02FF0000FF2C00FF5D00FF9000FFC400FFF900D3FF00A0FF006FFF0041FF0016FF1100FF
3400FF5200FF6B00FF7E00FF8B00FF9300FF9400FF8F00FF8400FF7400FF5E00FF4300FF
2300FF0000FF0027FF0050FF007CFF00A9FF00D6FF00FFFD00FFD200FFA900FF8300FF61
00FF4300FF2A00FF1700FF0900FF0200FF0000FF0500FF0F00FF2000FF3500FF4F00FF6D
00FF8F00FFB200FFD800FFFD00DCFF00B9FF0098FF007AFF0061FF004DFF003EFF0035FF
0032FF0035FF003FFF004EFF0062FF007AFF0095FF00B2FF00D1FF00EFFF00FFF400FFDA
00FFC400FFB400FFA800FFA300FFA400FFAC00FFB800FFCA00FFDF00FFF500F2FF00DDFF
00CAFF00BCFF00B3FF00B1FF00B5FF00BFFF00CDFF00DDFF00ECFF00F9FF00FFFF00FFFE
00FBFF00F1FF00E9FF00E8FF00EDFF00EEFF00E7FF00DDFF00D6FF00D6FF00DCFF00E7FF
00F7FF00FFF800FFEA00FFDF00FFDA00FFDB00FFE200FFEF00FEFF00E8FF00D1FF00BAFF
00A5FF0093FF0085FF007DFF007AFF007EFF0088FF0098FF00ADFF00C6FF00E2FF00FFFF
00FFE100FFC300FFA700FF8E00FF7A00FF6A00FF5F00FF5B00FF5C00FF6400FF7200FF85
00FF9E00FFBA00FFDB00FFFE00DCFF00B6FF0091FF006DFF004BFF002CFF0011FF0400FF
1600FF2100FF2700FF2700FF2000FF1400FF0100FF0016FF0032FF0054FF0079FF00A1FF
00CCFF00F8FF00FFDA00FFAD00FF8100FF5700FF3000FF0B14FF0030FF0047FF0059FF00
65FF006BFF006BFF0065FF0058FF0046FF002EFF0011FF0000FF1000FF3600FF6100FF8E
00FFBF00FFF100DAFF00A6FF0072FF003EFF000DFF2200FF
02FF0000FF2D00FF5E00FF9100FFC500FFF900D2FF009FFF006EFF0040FF0015FF1200FF
3500FF5300FF6C00FF7F00FF8C00FF9400FF9500FF9000FF8500FF7500FF5F00FF4400FF
2400FF0000FF0026FF0050FF007BFF00A8FF00D5FF00FFFE00FFD300FFAA00FF8400FF62
00FF4400FF2B00FF1800FF0A00FF0300FF0100FF0600FF1000FF2000FF3600FF5000FF6E
00FF9000FFB300FFD900FFFE00DCFF00B8FF0097FF0079FF0060FF004CFF003DFF0034FF
0031FF0034FF003EFF004DFF0061FF0079FF0094FF00B1FF00D0FF00EEFF00FFF500FFDB
00FFC500FFB400FFA900FFA400FFA500FFAD00FFB900FFCB00FFE000FFF600F2FF00DCFF
00C9FF00BBFF00B2FF00B0FF00B4FF00BEFF00CCFF00DCFF00ECFF00F8FF00FFFF00FFFF
00FAFF00F0FF00E8FF00E8FF00ECFF00EDFF00E6FF00DCFF00D6FF00D5FF00DBFF00E6FF
00F6FF00FFF900FFEB00FFE000FFDB00FFDC00FFE300FFF000FDFF00E8FF00D1FF00BAFF
00A4FF0092FF0084FF007CFF007AFF007EFF0088FF0097FF00ACFF00C5FF00E1FF00FFFF
00FFE200FFC400FFA800FF8F00FF7B00FF6B00FF6000FF5C00FF5D00FF6500FF7300FF86
00FF9E00FFBB00FFDC00FFFF00DBFF00B6FF0090FF006CFF004AFF002BFF0010FF0500FF
1600FF2200FF2800FF2800FF2100FF1500FF0200FF0015FF0031FF0053FF0078FF00A0FF
00CBFF00F7FF00FFDB00FFAE00FF8200FF5800FF3100FF0C13FF002FFF0046FF0058FF00
64FF006AFF006AFF0064FF0058FF0045FF002EFF0010FF0000FF1100FF3700FF6200FF8F
00FFC000FFF200D9FF00A5FF0071FF003EFF000CFF2300FF
07FF0000FF2700FF5800FF8B00FFBF00FFF400D8FF00A5FF0074FF0046FF001BFF0C00FF
2F00FF4D00FF6600FF7900FF8600FF8E00FF8F00FF8A00FF7F00FF6F00FF5900FF3E00FF
1E00FF0005FF002CFF0056FF0081FF00AEFF00DBFF00FFF800FFCD00FFA400FF7E00FF5C
00FF3E00FF2500FF1200FF0402FF0004FF0000FF0000FF0A00FF1A00FF3000FF4A00FF68
00FF8A00FFAD00FFD300FFF800E2FF00BEFF009DFF007FFF0066FF0052FF0043FF003AFF
0037FF003AFF0044FF0053FF0067FF007FFF009AFF00B7FF00D6FF00F4FF00FFEF00FFD5
00FFBF00FFAF00FFA300FF9E00FF9F00FFA700FFB300FFC500FFDA00FFF000F7FF00E2FF
00CFFF00C1FF00B8FF00B6FF00BAFF00C4FF00D2FF00E2FF00F1FF00FEFF00FFFA00FFF9
00FFFF00F6FF00EEFF00EEFF00F2FF00F3FF00ECFF00E2FF00DCFF00DBFF00E1FF00ECFF
00FCFF00FFF300FFE500FFDA00FFD500FFD600FFDD00FFEA00FFFC00EEFF00D6FF00BFFF
00AAFF0098FF008AFF0082FF0080FF0083FF008DFF009DFF00B2FF00CBFF00E7FF00FFFA
00FFDC00FFBE00FFA200FF8900FF7500FF6500FF5A00FF5600FF5700FF5F00FF6D00FF80
00FF9900FFB500FFD600FFF900E1FF00BCFF0096FF0072FF0050FF0031FF0016FF0000FF
1000FF1C00FF2200FF2200FF1B00FF0F00FF0003FF001BFF0037FF0059FF007EFF00A6FF
00D1FF00FDFF00FFD500FFA800FF7C00FF5200FF2B00FF0619FF0035FF004CFF005EFF00
6AFF0070FF0070FF006AFF005EFF004BFF0034FF0016FF0000FF0B00FF3100FF5C00FF89
00FFBA00FFEC00DFFF00ABFF0077FF0043FF0012FF1D00FF
13FF0000FF1B00FF4C00FF7F00FFB400FFE800E3FF00B1FF0080FF0052FF0026FF0000FF
2300FF4100FF5A00FF6D00FF7B00FF8200FF8300FF7E00FF7400FF6300FF4D00FF3200FF
1200FF0010FF0038FF0061FF008DFF00BAFF00E6FF00FFEC00FFC100FF9800FF7200FF50
00FF3300FF1A00FF0606FF000EFF0010FF000BFF0000FF0000FF0F00FF2400FF3E00FF5D
00FF7E00FFA200FFC700FFED00EDFF00CAFF00A9FF008BFF0072FF005DFF004EFF0046FF
0043FF0046FF004FFF005EFF0072FF008AFF00A6FF00C3FF00E2FF00FFFF00FFE300FFC9
00FFB400FFA300FF9800FF9300FF9400FF9B00FFA800FFB900FFCE00FFE500FFFC00EDFF
00DBFF00CCFF00C4FF00C2FF00C6FF00CFFF00DDFF00EEFF00FDFF00FFF500FFEE00FFEE
00FFF300FFFD00FAFF00F9FF00FEFF00FFFF00F8FF00EEFF00E7FF00E6FF00ECFF00F8FF
00FFF800FFE700FFD900FFCE00FFC900FFCA00FFD100FFDF00FFF000F9FF00E2FF00CBFF
00B6FF00A4FF0096FF008EFF008BFF008FFF0099FF00A9FF00BEFF00D7FF00F3FF00FFEE
00FFD000FFB200FF9700FF7E00FF6900FF5900FF4F00FF4A00FF4C00FF5300FF6100FF74
00FF8D00FFAA00FFCA00FFED00EDFF00C7FF00A2FF007EFF005CFF003DFF0022FF000CFF
0500FF1000FF1600FF1600FF0F00FF0300FF000EFF0026FF0043FF0064FF008AFF00B2FF
00DDFF00FFF600FFC900FF9C00FF7100FF4600FF1F05FF0025FF0041FF0058FF006AFF00
76FF007CFF007CFF0075FF0069FF0057FF003FFF0022FF0000FF0000FF2500FF5000FF7E
00FFAE00FFE000EBFF00B7FF0082FF004FFF001DFF1100FF
22FF0000FF0C00FF3D00FF7000FFA400FFD900F3FF00C0FF008FFF0061FF0036FF000EFF
1400FF3200FF4B00FF5E00FF6B00FF7300FF7400FF6F00FF6400FF5400FF3E00FF2300FF
0300FF0020FF0047FF0071FF009CFF00C9FF00F6FF00FFDD00FFB200FF8900FF6300FF41
00FF2300FF0A08FF0016FF001DFF001FFF001AFF0010FF0000FF0000FF1500FF2F00FF4D
00FF6F00FF9200FFB800FFDD00FDFF00D9FF00B8FF009AFF0081FF006DFF005EFF0055FF
0052FF0055FF005FFF006EFF0082FF009AFF00B5FF00D2FF00F1FF00FFF000FFD400FFBA
00FFA400FF9400FF8800FF8300FF8400FF8C00FF9800FFAA00FFBF00FFD500FFED00FDFF
00EAFF00DCFF00D3FF00D1FF00D5FF00DFFF00EDFF00FDFF00FFF300FFE600FFDF00FFDE
00FFE400FFEE00FFF600FFF700FFF200FFF100FFF800FDFF00F7FF00F6FF00FCFF00FFF8
00FFE800FFD800FFCA00FFBF00FFBA00FFBB00FFC200FFCF00FFE100FFF600F1FF00DAFF
00C5FF00B3FF00A5FF009DFF009BFF009EFF00A8FF00B8FF00CDFF00E6FF00FFFD00FFDF
00FFC100FFA300FF8700FF6E00FF5A00FF4A00FF3F00FF3B00FF3C00FF4400FF5200FF65
00FF7E00FF9A00FFBB00FFDE00FCFF00D7FF00B1FF008DFF006BFF004CFF0031FF001BFF
000AFF0100FF0700FF0700FF0000FF000BFF001EFF0036FF0052FF0074FF0099FF00C1FF
00ECFF00FFE700FFBA00FF8D00FF6100FF3700FF1014FF0034FF0050FF0067FF0079FF00
85FF008BFF008BFF0085FF0078FF0066FF004FFF0031FF000FFF0000FF1600FF4100FF6E
00FF9F00FFD100FAFF00C6FF0092FF005EFF002DFF0200FF
33FF0004FF0000FF2D00FF6000FF9400FFC800FFFC00D0FF009FFF0071FF0046FF001FFF
0300FF2200FF3A00FF4E00FF5B00FF6200FF6400FF5F00FF5400FF4400FF2D00FF1200FF
000CFF0030FF0057FF0081FF00ACFF00D9FF00FFF900FFCD00FFA200FF7900FF5300FF31
00FF1305FF0018FF0026FF002EFF002FFF002BFF0020FF0010FF0000FF0500FF1F00FF3D
00FF5E00FF8200FFA700FFCD00FFF200E9FF00C8FF00ABFF0091FF007DFF006EFF0065FF
0062FF0066FF006FFF007EFF0092FF00AAFF00C5FF00E3FF00FFFE00FFE000FFC300FFAA
00FF9400FF8300FF7800FF7300FF7400FF7B00FF8800FF9A00FFAE00FFC500FFDC00FFF2
00FAFF00ECFF00E3FF00E1FF00E5FF00EFFF00FDFF00FFF200FFE200FFD600FFCF00FFCE
00FFD400FFDE00FFE600FFE600FFE200FFE100FFE800FFF100FFF800FFF900FFF300FFE7
00FFD800FFC800FFB900FFAF00FFAA00FFAA00FFB200FFBF00FFD100FFE600FFFD00EBFF
00D5FF00C3FF00B5FF00ADFF00ABFF00AFFF00B9FF00C8FF00DDFF00F6FF00FFED00FFCF
00FFB100FF9300FF7700FF5E00FF4900FF3900FF2F00FF2A00FF2C00FF3400FF4200FF55
00FF6D00FF8A00FFAB00FFCE00FFF300E7FF00C1FF009DFF007BFF005CFF0041FF002BFF
001AFF000EFF0008FF0009FF000FFF001CFF002EFF0046FF0063FF0084FF00A9FF00D1FF
00FCFF00FFD700FFAA00FF7D00FF5100FF2700FF0024FF0045FF0061FF0078FF0089FF00
95FF009BFF009BFF0095FF0089FF0077FF005FFF0042FF0020FF0000FF0600FF3000FF5E
00FF8E00FFC100FFF500D6FF00A2FF006FFF003DFF000DFF
41FF0012FF0000FF1E00FF5100FF8500FFBA00FFEE00DFFF00AEFF0080FF0054FF002DFF
000AFF1300FF2C00FF3F00FF4D00FF5400FF5500FF5000FF4600FF3500FF1F00FF0400FF
001BFF003FFF0066FF008FFF00BBFF00E8FF00FFEA00FFBE00FF9300FF6A00FF4400FF22
00FF0513FF0027FF0034FF003CFF003EFF0039FF002FFF001EFF0009FF0000FF1000FF2E
00FF5000FF7400FF9900FFBF00FFE400F8FF00D7FF00B9FF00A0FF008BFF007DFF0074FF
0071FF0074FF007EFF008CFF00A0FF00B8FF00D4FF00F1FF00FFEF00FFD100FFB500FF9B
00FF8600FF7500FF6A00FF6500FF6600FF6D00FF7A00FF8B00FFA000FFB700FFCE00FFE4
00FFF600FAFF00F2FF00F0FF00F4FF00FEFF00FFF400FFE300FFD400FFC700FFC000FFC0
00FFC500FFCF00FFD700FFD800FFD300FFD200FFD900FFE300FFEA00FFEB00FFE500FFD9
00FFCA00FFB900FFAB00FFA000FF9B00FF9C00FFA300FFB000FFC200FFD800FFEF00F9FF
00E4FF00D2FF00C4FF00BCFF00B9FF00BDFF00C7FF00D7FF00ECFF00FFFA00FFDE00FFC0
00FFA200FF8400FF6800FF5000FF3B00FF2B00FF2000FF1C00FF1E00FF2500FF3300FF46
00FF5F00FF7C00FF9C00FFBF00FFE400F5FF00D0FF00ACFF008AFF006BFF0050FF003AFF
0028FF001DFF0017FF0017FF001EFF002AFF003CFF0054FF0071FF0093FF00B8FF00E0FF
00FFF400FFC800FF9B00FF6E00FF4300FF180EFF0033FF0053FF006FFF0086FF0098FF00
A4FF00AAFF00AAFF00A4FF0097FF0085FF006DFF0050FF002EFF0008FF0000FF2200FF50
00FF8000FFB200FFE600E5FF00B1FF007DFF004BFF001CFF
4CFF001DFF0000FF1400FF4700FF7B00FFAF00FFE300E9FF00B9FF008AFF005FFF0038FF
0015FF0800FF2100FF3400FF4200FF4900FF4B00FF4600FF3B00FF2A00FF1400FF0006FF
0026FF0049FF0070FF009AFF00C6FF00F2FF00FFE000FFB300FF8800FF6000FF3A00FF18
05FF001EFF0031FF003FFF0047FF0048FF0044FF0039FF0029FF0014FF0000FF0600FF24
00FF4500FF6900FF8E00FFB400FFD900FFFD00E1FF00C4FF00AAFF0096FF0087FF007EFF
007BFF007FFF0088FF0097FF00ABFF00C3FF00DEFF00FCFF00FFE500FFC700FFAA00FF91
00FF7B00FF6A00FF5F00FF5A00FF5B00FF6200FF6F00FF8000FF9500FFAC00FFC300FFD9
00FFEC00FFFA00FDFF00FAFF00FEFF00FFF700FFE900FFD900FFC900FFBC00FFB500FFB5
00FFBB00FFC400FFCC00FFCD00FFC800FFC700FFCE00FFD800FFDF00FFE000FFDA00FFCE
00FFBF00FFAF00FFA000FF9600FF9000FF9100FF9900FFA600FFB800FFCD00FFE400FFFB
00EFFF00DCFF00CFFF00C6FF00C4FF00C8FF00D2FF00E2FF00F6FF00FFF000FFD400FFB6
00FF9700FF7A00FF5E00FF4500FF3000FF2000FF1600FF1100FF1300FF1B00FF2800FF3C
00FF5400FF7100FF9100FFB500FFD900FFFF00DBFF00B6FF0094FF0076FF005BFF0044FF
0033FF0027FF0022FF0022FF0028FF0035FF0047FF005FFF007CFF009DFF00C2FF00EBFF
00FFEA00FFBE00FF9100FF6400FF3800FF0E19FF003DFF005EFF007AFF0091FF00A3FF00
AEFF00B4FF00B4FF00AEFF00A2FF0090FF0078FF005BFF0039FF0012FF0000FF1700FF45
00FF7500FFA800FFDB00EFFF00BBFF0088FF0056FF0026FF
51FF0022FF0000FF0E00FF4100FF7600FFAA00FFDE00EFFF00BEFF008FFF0064FF003DFF
001AFF0300FF1C00FF2F00FF3D00FF4400FF4500FF4000FF3600FF2500FF0F00FF000BFF
002BFF004EFF0076FF009FFF00CBFF00F8FF00FFDB00FFAE00FF8300FF5A00FF3400FF12
0AFF0023FF0037FF0044FF004CFF004EFF0049FF003EFF002EFF0019FF0000FF0000FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF700E7FF00C9FF00B0FF009BFF008CFF0084FF
0081FF0084FF008DFF009CFF00B0FF00C8FF00E4FF00FFFE00FFDF00FFC100FFA500FF8B
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE600FFF500FFFD00FFFF00FFFB00FFF200FFE400FFD300FFC400FFB700FFB000FFB0
00FFB500FFBF00FFC700FFC800FFC300FFC200FFC900FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9000FF8B00FF8C00FF9300FFA100FFB200FFC800FFDF00FFF6
00F4FF00E2FF00D4FF00CCFF00C9FF00CDFF00D7FF00E7FF00FCFF00FFEA00FFCE00FFB0
00FF9200FF7400FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1500FF2300FF36
00FF4F00FF6C00FF8C00FFAF00FFD400FFFA00E0FF00BCFF009AFF007BFF0060FF0049FF
0038FF002DFF0027FF0027FF002EFF003AFF004CFF0064FF0081FF00A2FF00C8FF00F0FF
00FFE400FFB800FF8B00FF5F00FF3300FF081EFF0043FF0063FF007FFF0096FF00A8FF00
B4FF00BAFF00BAFF00B3FF00A7FF0095FF007DFF0060FF003EFF0018FF0000FF1200FF40
00FF7000FFA200FFD600F5FF00C0FF008DFF005BFF002CFF
50FF0021FF0000FF0F00FF4200FF7600FFAB00FFDF00EEFF00BDFF008FFF0063FF003CFF
0019FF0400FF1D00FF3000FF3E00FF4500FF4600FF4100FF3700FF2600FF1000FF000AFF
002AFF004DFF0075FF009EFF00CAFF00F7FF00FFDB00FFAF00FF8400FF5B00FF3500FF13
09FF0022FF0036FF0043FF004BFF004DFF0048FF003DFF002DFF0018FF0000FF0100FF20
00FF4100FF6500FF8A00FFB000FFD500FFF800E6FF00C8FF00AFFF009AFF008BFF0083FF
0080FF0083FF008CFF009BFF00AFFF00C7FF00E3FF00FFFF00FFE000FFC200FFA600FF8C
00FF7700FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7C00FF9100FFA800FFBF00FFD5
00FFE700FFF600FFFE00FFFF00FFFC00FFF300FFE500FFD400FFC500FFB800FFB100FFB1
00FFB600FFC000FFC800FFC900FFC400FFC300FFCA00FFD400FFDB00FFDC00FFD600FFCA
00FFBB00FFAA00FF9C00FF9100FF8C00FF8D00FF9400FFA200FFB300FFC900FFE000FFF7
00F3FF00E1FF00D3FF00CBFF00C8FF00CCFF00D6FF00E6FF00FBFF00FFEB00FFCF00FFB1
00FF9300FF7500FF5A00FF4100FF2C00FF1C00FF1200FF0D00FF0F00FF1600FF2400FF37
00FF5000FF6D00FF8D00FFB000FFD500FFFB00DFFF00BBFF0099FF007AFF005FFF0049FF
0037FF002CFF0026FF0026FF002DFF0039FF004BFF0063FF0080FF00A1FF00C7FF00EFFF
00FFE500FFB900FF8C00FF5F00FF3400FF091DFF0042FF0062FF007EFF0095FF00A7FF00
B3FF00B9FF00B9FF00B2FF00A6FF0094FF007CFF005FFF003DFF0017FF0000FF1300FF41
00FF7100FFA300FFD700F4FF00BFFF008CFF005AFF002BFF
49FF001AFF0000FF1700FF4A00FF7E00FFB200FFE600E6FF00B5FF0087FF005CFF0035FF
0012FF0B00FF2400FF3800FF4500FF4C00FF4E00FF4900FF3E00FF2D00FF1700FF0003FF
0022FF0046FF006DFF0097FF00C2FF00EFFF00FFE300FFB600FF8B00FF6300FF3D00FF1B
02FF001BFF002EFF003CFF0044FF0045FF0041FF0036FF0026FF0010FF0000FF0900FF27
00FF4800FF6C00FF9100FFB700FFDC00FFFF00DEFF00C1FF00A7FF0093FF0084FF007BFF
0078FF007CFF0085FF0094FF00A8FF00C0FF00DBFF00F9FF00FFE800FFCA00FFAD00FF94
00FF7E00FF6D00FF6200FF5D00FF5E00FF6500FF7200FF8300FF9800FFAF00FFC600FFDC
00FFEF00FFFD00FAFF00F7FF00FBFF00FFFA00FFEC00FFDC00FFCC00FFC000FFB800FFB8
00FFBE00FFC700FFCF00FFD000FFCB00FFCA00FFD100FFDB00FFE200FFE300FFDD00FFD1
00FFC200FFB200FFA300FF9900FF9300FF9400FF9C00FFA900FFBB00FFD000FFE700FFFE
00ECFF00D9FF00CCFF00C3FF00C1FF00C5FF00CFFF00DFFF00F3FF00FFF300FFD700FFB9
00FF9A00FF7D00FF6100FF4800FF3300FF2300FF1900FF1400FF1600FF1E00FF2B00FF3F
00FF5700FF7400FF9400FFB800FFDC00FDFF00D8FF00B3FF0091FF0073FF0058FF0041FF
0030FF0024FF001EFF001FFF0025FF0032FF0044FF005CFF0079FF009AFF00BFFF00E8FF
00FFED00FFC100FF9400FF6700FF3B00FF1116FF003AFF005BFF0077FF008EFF009FFF00
ABFF00B1FF00B1FF00ABFF009FFF008DFF0075FF0058FF0036FF000FFF0000FF1A00FF48
00FF7800FFAB00FFDE00ECFF00B8FF0085FF0053FF0023FF
3CFF000DFF0000FF2400FF5700FF8B00FFBF00FFF300D9FF00A8FF007AFF004FFF0028FF
0005FF1900FF3100FF4500FF5200FF5900FF5B00FF5600FF4B00FF3B00FF2500FF0900FF
0015FF0039FF0060FF008AFF00B5FF00E2FF00FFF000FFC400FF9900FF7000FF4A00FF28
00FF0A0EFF0021FF002FFF0037FF0038FF0033FF0029FF0019FF0003FF0000FF1600FF34
00FF5500FF7900FF9E00FFC400FFE900F2FF00D1FF00B4FF009AFF0086FF0077FF006EFF
006BFF006FFF0078FF0087FF009BFF00B3FF00CEFF00ECFF00FFF500FFD700FFBB00FFA1
00FF8B00FF7A00FF6F00FF6A00FF6B00FF7200FF7F00FF9100FFA500FFBC00FFD300FFE9
00FFFC00F5FF00ECFF00EAFF00EEFF00F8FF00FFF900FFE900FFD900FFCD00FFC600FFC5
00FFCB00FFD500FFDD00FFDD00FFD900FFD800FFDF00FFE800FFEF00FFF000FFEA00FFDF
00FFCF00FFBF00FFB000FFA600FFA100FFA200FFA900FFB600FFC800FFDD00FFF400F4FF
00DEFF00CCFF00BEFF00B6FF00B4FF00B8FF00C2FF00D1FF00E6FF00FFFF00FFE400FFC6
00FFA800FF8A00FF6E00FF5500FF4000FF3100FF2600FF2100FF2300FF2B00FF3900FF4C
00FF6400FF8100FFA200FFC500FFEA00F0FF00CAFF00A6FF0084FF0065FF004AFF0034FF
0023FF0017FF0011FF0012FF0018FF0025FF0037FF004FFF006CFF008DFF00B2FF00DAFF
00FFFA00FFCE00FFA100FF7400FF4800FF1E09FF002DFF004EFF006AFF0081FF0092FF00
9EFF00A4FF00A4FF009EFF0092FF0080FF0068FF004BFF0029FF0002FF0000FF2700FF55
00FF8600FFB800FFEC00DFFF00ABFF0078FF0046FF0016FF
2AFF0000FF0400FF3600FF6900FF9D00FFD100FAFF00C7FF0096FF0068FF003DFF0016FF
0C00FF2A00FF4300FF5700FF6400FF6B00FF6D00FF6800FF5D00FF4D00FF3600FF1B00FF
0003FF0027FF004EFF0078FF00A3FF00D0FF00FDFF00FFD600FFAB00FF8200FF5C00FF3A
00FF1C00FF030FFF001DFF0025FF0026FF0022FF0017FF0007FF0000FF0E00FF2800FF46
00FF6700FF8B00FFB000FFD600FFFB00E0FF00BFFF00A2FF0088FF0074FF0065FF005CFF
0059FF005DFF0066FF0075FF0089FF00A1FF00BCFF00DAFF00F8FF00FFE900FFCC00FFB3
00FF9D00FF8C00FF8100FF7C00FF7D00FF8400FF9100FFA300FFB700FFCE00FFE500FFFB
00F1FF00E3FF00DAFF00D8FF00DCFF00E6FF00F4FF00FFFB00FFEB00FFDF00FFD700FFD7
00FFDD00FFE600FFEF00FFEF00FFEB00FFEA00FFF100FFFA00FEFF00FDFF00FFFC00FFF0
00FFE100FFD100FFC200FFB800FFB200FFB300FFBB00FFC800FFDA00FFEF00F9FF00E2FF
00CCFF00BAFF00ACFF00A4FF00A2FF00A6FF00B0FF00BFFF00D4FF00EDFF00FFF600FFD8
00FFBA00FF9C00FF8000FF6700FF5200FF4200FF3800FF3300FF3500FF3D00FF4A00FF5E
00FF7600FF9300FFB400FFD700FFFC00DEFF00B8FF0094FF0072FF0053FF0038FF0022FF
0011FF0005FF0000FF0000FF0006FF0013FF0025FF003DFF005AFF007BFF00A0FF00C8FF
00F3FF00FFE000FFB300FF8600FF5A00FF3000FF081BFF003CFF0058FF006FFF0080FF00
8CFF0092FF0092FF008CFF0080FF006EFF0056FF0039FF0017FF0000FF0F00FF3900FF67
00FF9700FFCA00FFFE00CDFF0099FF0066FF0034FF0004FF
14FF0000FF1A00FF4B00FF7E00FFB200FFE700E5FF00B2FF0081FF0053FF0028FF0000FF
2200FF4000FF5900FF6C00FF7900FF8100FF8200FF7D00FF7200FF6200FF4C00FF3100FF
1100FF0012FF0039FF0062FF008EFF00BBFF00E8FF00FFEB00FFC000FF9700FF7100FF4F
00FF3100FF1800FF0508FF000FFF0011FF000CFF0002FF0000FF0E00FF2300FF3D00FF5B
00FF7D00FFA100FFC600FFEB00EEFF00CBFF00AAFF008CFF0073FF005FFF0050FF0047FF
0044FF0047FF0051FF0060FF0074FF008CFF00A7FF00C4FF00E3FF00FFFE00FFE200FFC8
00FFB200FFA200FF9600FF9100FF9200FF9A00FFA600FFB800FFCD00FFE300FFFB00EFFF
00DCFF00CEFF00C5FF00C3FF00C7FF00D1FF00DFFF00EFFF00FEFF00FFF400FFED00FFEC
00FFF200FFFC00FBFF00FAFF00FFFF00FFFF00F9FF00EFFF00E8FF00E8FF00EEFF00F9FF
00FFF600FFE600FFD800FFCD00FFC800FFC900FFD000FFDD00FFEF00FAFF00E3FF00CCFF
00B7FF00A5FF0097FF008FFF008CFF0090FF009AFF00AAFF00BFFF00D8FF00F4FF00FFED
00FFCF00FFB100FF9500FF7D00FF6800FF5800FF4D00FF4900FF4A00FF5200FF6000FF73
00FF8C00FFA800FFC900FFEC00EEFF00C8FF00A3FF007FFF005DFF003EFF0023FF000DFF
0400FF0F00FF1500FF1500FF0E00FF0200FF0010FF0027FF0044FF0066FF008BFF00B3FF
00DEFF00FFF500FFC800FF9B00FF6F00FF4500FF1E06FF0026FF0042FF0059FF006BFF00
77FF007DFF007DFF0077FF006AFF0058FF0040FF0023FF0001FF0000FF2400FF4F00FF7C
00FFAD00FFDF00ECFF00B8FF0084FF0050FF001FFF1000FF
00FF0200FF3100FF6200FF9500FFC900FFFE00CEFF009BFF006AFF003CFF0011FF1600FF
3900FF5700FF7000FF8300FF9000FF9800FF9900FF9400FF8900FF7900FF6300FF4800FF
2800FF0400FF0022FF004BFF0077FF00A4FF00D1FF00FDFF00FFD700FFAE00FF8800FF66
00FF4800FF3000FF1C00FF0E00FF0700FF0500FF0A00FF1400FF2500FF3A00FF5400FF72
00FF9400FFB800FFDD00FDFF00D7FF00B4FF0093FF0075FF005CFF0048FF0039FF0030FF
002DFF0030FF003AFF0049FF005CFF0075FF0090FF00ADFF00CCFF00EAFF00FFF900FFDF
00FFC900FFB900FFAD00FFA800FFAA00FFB100FFBD00FFCF00FFE400FFFB00EDFF00D8FF
00C5FF00B7FF00AEFF00ACFF00B0FF00BAFF00C8FF00D8FF00E7FF00F4FF00FBFF00FCFF
00F6FF00ECFF00E4FF00E3FF00E8FF00E9FF00E2FF00D8FF00D1FF00D1FF00D6FF00E2FF
00F1FF00FFFD00FFEF00FFE400FFDF00FFE000FFE700FFF400F9FF00E3FF00CCFF00B5FF
00A0FF008EFF0080FF0078FF0075FF0079FF0083FF0093FF00A8FF00C1FF00DDFF00FBFF
00FFE600FFC800FFAC00FF9400FF7F00FF6F00FF6400FF6000FF6100FF6900FF7700FF8A
00FFA300FFBF00FFE000FCFF00D7FF00B1FF008CFF0068FF0046FF0027FF000CFF0900FF
1B00FF2600FF2C00FF2C00FF2500FF1900FF0600FF0010FF002DFF004FFF0074FF009CFF
00C7FF00F3FF00FFDF00FFB200FF8600FF5C00FF3500FF100FFF002BFF0042FF0054FF00
60FF0066FF0066FF0060FF0053FF0041FF0029FF000CFF0000FF1500FF3B00FF6600FF93
00FFC400FFF600D5FF00A1FF006DFF0039FF0008FF2700FF
00FF1900FF4800FF7900FFAC00FFE000EAFF00B6FF0084FF0053FF0025FF0500FF2D00FF
5000FF6E00FF8700FF9A00FFA700FFAF00FFB000FFAB00FFA000FF9000FF7A00FF5F00FF
3F00FF1B00FF000BFF0034FF0060FF008DFF00BAFF00E6FF00FFEE00FFC500FF9F00FF7D
00FF5F00FF4700FF3300FF2500FF1E00FF1C00FF2100FF2B00FF3C00FF5100FF6B00FF89
00FFAB00FFCF00FFF400E6FF00C0FF009DFF007CFF005EFF0045FF0031FF0022FF0019FF
0016FF0019FF0023FF0032FF0045FF005EFF0079FF0096FF00B5FF00D3FF00EFFF00FFF6
00FFE000FFD000FFC400FFBF00FFC100FFC800FFD400FFE600FFFB00EDFF00D6FF00C1FF
00AEFF00A0FF0097FF0095FF0099FF00A3FF00B1FF00C1FF00D0FF00DDFF00E4FF00E5FF
00DFFF00D5FF00CDFF00CCFF00D1FF00D2FF00CBFF00C1FF00BAFF00BAFF00BFFF00CBFF
00DAFF00EBFF00F9FF00FFFB00FFF600FFF700FFFE00F4FF00E2FF00CCFF00B5FF009EFF
0089FF0077FF0069FF0061FF005EFF0062FF006CFF007CFF0091FF00AAFF00C6FF00E4FF
00FFFD00FFDF00FFC300FFAB00FF9600FF8600FF7B00FF7700FF7800FF8000FF8E00FFA1
00FFBA00FFD600FFF700E5FF00C0FF009AFF0075FF0051FF002FFF0010FF0A00FF2000FF
3200FF3D00FF4300FF4300FF3C00FF3000FF1D00FF0600FF0016FF0038FF005DFF0085FF
00B0FF00DCFF00FFF600FFC900FF9D00FF7300FF4C00FF2700FF0714FF002BFF003DFF00
49FF004FFF004FFF0049FF003CFF002AFF0012FF0000FF0A00FF2C00FF5200FF7D00FFAA
00FFDB00F2FF00BEFF008AFF0056FF0022FF0E00FF3E00FF
00FF2E00FF5D00FF8F00FFC200FFF600D5FF00A1FF006EFF003EFF000FFF1B00FF4200FF
6500FF8300FF9C00FFAF00FFBD00FFC400FFC500FFC100FFB600FFA500FF8F00FF7400FF
5400FF3100FF0A00FF001FFF004BFF0077FF00A4FF00D1FF00FCFF00FFDA00FFB500FF92
00FF7500FF5C00FF4800FF3B00FF3300FF3200FF3600FF4100FF5100FF6600FF8100FF9F
00FFC000FFE400F6FF00D0FF00ABFF0088FF0066FF0049FF0030FF001BFF000CFF0003FF
0001FF0004FF000DFF001CFF0030FF0048FF0064FF0081FF009FFF00BDFF00DAFF00F3FF
00FFF600FFE500FFDA00FFD500FFD600FFDD00FFEA00FFFB00EFFF00D8FF00C1FF00ABFF
0098FF008AFF0082FF007FFF0084FF008DFF009BFF00ABFF00BBFF00C8FF00CFFF00CFFF
00C9FF00C0FF00B8FF00B7FF00BCFF00BDFF00B6FF00ACFF00A5FF00A4FF00AAFF00B6FF
00C5FF00D5FF00E4FF00EFFF00F4FF00F3FF00ECFF00DEFF00CCFF00B7FF00A0FF0089FF
0074FF0062FF0054FF004BFF0049FF004DFF0057FF0067FF007CFF0095FF00B1FF00CEFF
00EDFF00FFF400FFD900FFC000FFAB00FF9B00FF9100FF8C00FF8E00FF9500FFA300FFB7
00FFCF00FFEC00F3FF00D0FF00ABFF0085FF0060FF003CFF001AFF0400FF1F00FF3600FF
4700FF5300FF5800FF5800FF5200FF4500FF3300FF1B00FF0001FF0022FF0047FF0070FF
009AFF00C7FF00F4FF00FFDF00FFB300FF8900FF6100FF3D00FF1C00FF0016FF0028FF00
34FF003AFF003AFF0033FF0027FF0015FF0000FF0200FF1F00FF4100FF6800FF9200FFC0
00FFF000DCFF00A9FF0074FF0040FF000DFF2400FF5300FF
00FF4000FF6F00FFA100FFD400F7FF00C3FF008FFF005CFF002BFF0200FF2D00FF5400FF
7700FF9500FFAE00FFC100FFCF00FFD600FFD800FFD300FFC800FFB700FFA100FF8600FF
6700FF4300FF1C00FF000DFF0039FF0065FF0092FF00BFFF00EAFF00FFED00FFC700FFA5
00FF8700FF6E00FF5B00FF4D00FF4500FF4400FF4800FF5300FF6300FF7900FF9300FFB1
00FFD200FFF600E4FF00BEFF0099FF0075FF0054FF0037FF001DFF0009FF0500FF0E00FF
1100FF0D00FF0400FF000AFF001EFF0036FF0051FF006FFF008DFF00ABFF00C8FF00E1FF
00F7FF00FFF700FFEC00FFE700FFE800FFEF00FFFC00F2FF00DDFF00C6FF00AFFF0099FF
0086FF0078FF0070FF006DFF0071FF007BFF0089FF0099FF00A9FF00B5FF00BDFF00BDFF
00B7FF00AEFF00A6FF00A5FF00AAFF00ABFF00A4FF009AFF0093FF0092FF0098FF00A4FF
00B3FF00C3FF00D2FF00DCFF00E2FF00E1FF00D9FF00CCFF00BAFF00A5FF008EFF0077FF
0062FF004FFF0042FF0039FF0037FF003BFF0045FF0055FF0069FF0082FF009EFF00BCFF
00DBFF00F8FF00FFEB00FFD200FFBD00FFAD00FFA300FF9E00FFA000FFA800FFB500FFC9
00FFE100FFFE00E1FF00BDFF0099FF0073FF004EFF0029FF0007FF1600FF3100FF4800FF
5900FF6500FF6B00FF6A00FF6400FF5700FF4500FF2D00FF1000FF0010FF0035FF005EFF
0088FF00B4FF00E1FF00FFF100FFC500FF9B00FF7300FF4F00FF2E00FF1204FF0015FF00
21FF0027FF0027FF0021FF0015FF0003FF0000FF1400FF3100FF5300FF7A00FFA400FFD2
00FDFF00CAFF0097FF0062FF002EFF0400FF3600FF6600FF
00FF4E00FF7D00FFAE00FFE100E9FF00B5FF0081FF004FFF001EFF1000FF3B00FF6200FF
8500FFA300FFBC00FFCF00FFDD00FFE400FFE500FFE000FFD600FFC500FFAF00FF9400FF
7400FF5100FF2A00FF0000FF002BFF0057FF0084FF00B1FF00DCFF00FFFA00FFD400FFB2
00FF9500FF7C00FF6800FF5B00FF5300FF5100FF5600FF6100FF7100FF8600FFA000FFBF
00FFE000FBFF00D6FF00B0FF008BFF0068FF0047FF0029FF0010FF0400FF1300FF1B00FF
1E00FF1B00FF1200FF0300FF0010FF0028FF0044FF0061FF007FFF009EFF00BAFF00D4FF
00E9FF00FAFF00FFFA00FFF500FFF600FFFD00F5FF00E4FF00CFFF00B8FF00A1FF008BFF
0079FF006AFF0062FF0060FF0064FF006DFF007BFF008BFF009BFF00A8FF00AFFF00AFFF
00A9FF00A0FF0098FF0097FF009CFF009DFF0096FF008CFF0085FF0084FF008AFF0096FF
00A5FF00B5FF00C4FF00CFFF00D4FF00D3FF00CCFF00BEFF00ACFF0097FF0080FF0069FF
0054FF0042FF0034FF002CFF0029FF002DFF0037FF0047FF005CFF0075FF0091FF00AEFF
00CDFF00EBFF00FFF900FFE000FFCB00FFBB00FFB100FFAC00FFAE00FFB500FFC300FFD6
00FFEF00F3FF00D3FF00B0FF008BFF0065FF0040FF001CFF0500FF2400FF3F00FF5600FF
6700FF7200FF7800FF7800FF7100FF6500FF5300FF3B00FF1E00FF0002FF0028FF0050FF
007BFF00A7FF00D4FF00FFFF00FFD300FFA900FF8100FF5D00FF3C00FF2000FF0908FF00
14FF001AFF001AFF0013FF0007FF0000FF0A00FF2200FF3F00FF6100FF8800FFB200FFE0
00EFFF00BDFF0089FF0055FF0020FF1200FF4400FF7300FF
00FF5600FF8500FFB700FFEA00E1FF00ADFF0079FF0046FF0015FF1800FF4300FF6A00FF
8D00FFAB00FFC400FFD800FFE500FFEC00FFEE00FFE900FFDE00FFCD00FFB700FF9C00FF
7D00FF5900FF3200FF0800FF0022FF004FFF007CFF00A9FF00D4FF00FCFF00FFDD00FFBB
00FF9D00FF8400FF7100FF6300FF5B00FF5A00FF5E00FF6900FF7900FF8F00FFA900FFC7
00FFE800F3FF00CEFF00A8FF0083FF005FFF003EFF0021FF0007FF0C00FF1B00FF2400FF
2700FF2300FF1A00FF0B00FF0008FF0020FF003BFF0059FF0077FF0095FF00B2FF00CBFF
00E1FF00F2FF00FDFF00FFFD00FFFE00FAFF00EDFF00DCFF00C7FF00B0FF0099FF0083FF
0070FF0062FF005AFF0057FF005BFF0065FF0073FF0083FF0093FF009FFF00A7FF00A7FF
00A1FF0098FF0090FF008FFF0093FF0095FF008DFF0084FF007DFF007CFF0082FF008EFF
009DFF00ADFF00BCFF00C6FF00CCFF00CBFF00C3FF00B6FF00A4FF008FFF0078FF0061FF
004BFF0039FF002CFF0023FF0021FF0025FF002FFF003FFF0053FF006CFF0088FF00A6FF
00C5FF00E2FF00FEFF00FFE800FFD300FFC300FFB900FFB400FFB600FFBE00FFCB00FFDF
00FFF700EBFF00CBFF00A7FF0082FF005DFF0037FF0013FF0E00FF2C00FF4700FF5E00FF
6F00FF7B00FF8100FF8000FF7A00FF6D00FF5B00FF4300FF2600FF0500FF001FFF0048FF
0072FF009EFF00CBFF00F8FF00FFDB00FFB100FF8900FF6500FF4400FF2800FF1100FF00
0BFF0011FF0011FF000BFF0000FF0000FF1200FF2A00FF4700FF6900FF9000FFBA00FFE8
00E7FF00B4FF0081FF004CFF0018FF1A00FF4C00FF7C00FF
00FF5900FF8800FFB900FFEC00DFFF00AAFF0077FF0044FF0013FF1A00FF4500FF6D00FF
9000FFAE00FFC700FFDA00FFE700FFEF00FFF000FFEB00FFE000FFD000FFBA00FF9F00FF
7F00FF5B00FF3400FF0B00FF0020FF004DFF007AFF00A6FF00D1FF00FAFF00FFDF00FFBD
00FF9F00FF8600FF7300FF6500FF5E00FF5C00FF6100FF6B00FF7B00FF9100FFAB00FFC9
00FFEB00F1FF00CBFF00A6FF0081FF005DFF003CFF001EFF0005FF0E00FF1D00FF2600FF
2900FF2600FF1C00FF0D00FF0006FF001EFF0039FF0056FF0075FF0093FF00AFFF00C9FF
00DFFF00EFFF00FBFF00FFFF00FFFF00F7FF00EBFF00D9FF00C4FF00AEFF0096FF0081FF
006EFF0060FF0057FF0055FF0059FF0063FF0071FF0081FF0090FF009DFF00A4FF00A5FF
009FFF0095FF008DFF008CFF0091FF0092FF008BFF0081FF007AFF007AFF0080FF008BFF
009BFF00ABFF00B9FF00C4FF00C9FF00C8FF00C1FF00B4FF00A2FF008CFF0075FF005EFF
0049FF0037FF0029FF0021FF001FFF0022FF002CFF003CFF0051FF006AFF0086FF00A4FF
00C2FF00E0FF00FCFF00FFEA00FFD600FFC600FFBB00FFB700FFB800FFC000FFCE00FFE1
00FFFA00E9FF00C8FF00A5FF0080FF005AFF0035FF0011FF1000FF2F00FF4A00FF6000FF
7200FF7D00FF8300FF8300FF7C00FF7000FF5D00FF4500FF2900FF0700FF001DFF0045FF
0070FF009CFF00C9FF00F6FF00FFDD00FFB300FF8C00FF6700FF4700FF2B00FF1400FF02
09FF000FFF000FFF0009FF0000FF0300FF1500FF2D00FF4A00FF6C00FF9200FFBD00FFEA
00E4FF00B2FF007EFF004AFF0016FF1D00FF4E00FF7E00FF
00FF5500FF8400FFB500FFE800E3FF00AEFF007AFF0048FF0017FF1600FF4100FF6900FF
8C00FFAA00FFC300FFD600FFE300FFEB00FFEC00FFE700FFDC00FFCC00FFB600FF9B00FF
7B00FF5700FF3000FF0700FF0024FF0051FF007EFF00AAFF00D5FF00FEFF00FFDB00FFB9
00FF9B00FF8300FF6F00FF6100FF5A00FF5800FF5D00FF6700FF7800FF8D00FFA700FFC5
00FFE700F4FF00CFFF00AAFF0084FF0061FF0040FF0022FF0009FF0B00FF1900FF2200FF
2500FF2200FF1800FF0900FF0009FF0022FF003DFF005AFF0079FF0097FF00B3FF00CDFF
00E2FF00F3FF00FEFF00FFFB00FFFD00FBFF00EEFF00DDFF00C8FF00B1FF009AFF0085FF
0072FF0064FF005BFF0059FF005DFF0067FF0075FF0085FF0094FF00A1FF00A8FF00A9FF
00A3FF0099FF0091FF0090FF0095FF0096FF008FFF0085FF007EFF007EFF0083FF008FFF
009EFF00AFFF00BDFF00C8FF00CDFF00CCFF00C5FF00B8FF00A6FF0090FF0079FF0062FF
004DFF003BFF002DFF0025FF0022FF0026FF0030FF0040FF0055FF006EFF008AFF00A8FF
00C6FF00E4FF00FFFF00FFE700FFD200FFC200FFB700FFB300FFB400FFBC00FFCA00FFDD
00FFF600EDFF00CCFF00A9FF0084FF005EFF0039FF0015FF0C00FF2B00FF4600FF5C00FF
6E00FF7900FF7F00FF7F00FF7800FF6C00FF5900FF4200FF2500FF0300FF0021FF0049FF
0074FF00A0FF00CDFF00FAFF00FFD900FFAF00FF8800FF6300FF4300FF2700FF1001FF00
0DFF0013FF0013FF000DFF0000FF0000FF1100FF2900FF4600FF6800FF8E00FFB900FFE6
00E8FF00B6FF0082FF004EFF001AFF1900FF4A00FF7A00FF
00FF4B00FF7A00FFAB00FFDE00EDFF00B8FF0084FF0052FF0021FF0C00FF3700FF5F00FF
8200FFA000FFB900FFCC00FFD900FFE100FFE200FFDD00FFD200FFC200FFAC00FF9100FF
7100FF4D00FF2600FF0002FF002EFF005BFF0088FF00B4FF00DFFF00FFF700FFD100FFAF
00FF9100FF7900FF6500FF5700FF5000FF4E00FF5300FF5D00FF6E00FF8300FF9D00FFBB
00FFDD00FEFF00D9FF00B4FF008EFF006BFF004AFF002CFF0013FF0000FF0F00FF1800FF
1B00FF1800FF0E00FF0000FF0013FF002CFF0047FF0064FF0083FF00A1FF00BDFF00D7FF
00EDFF00FDFF00FFF600FFF100FFF300FFFA00F9FF00E7FF00D2FF00BBFF00A4FF008FFF
007CFF006EFF0065FF0063FF0067FF0071FF007FFF008FFF009EFF00ABFF00B2FF00B3FF
00ADFF00A3FF009BFF009AFF009FFF00A0FF0099FF008FFF0088FF0088FF008DFF0099FF
00A8FF00B9FF00C7FF00D2FF00D7FF00D6FF00CFFF00C2FF00B0FF009AFF0083FF006CFF
0057FF0045FF0037FF002FFF002CFF0030FF003AFF004AFF005FFF0078FF0094FF00B2FF
00D0FF00EEFF00FFF500FFDD00FFC800FFB800FFAD00FFA900FFAA00FFB200FFC000FFD3
00FFEC00F7FF00D6FF00B3FF008EFF0068FF0043FF001FFF0200FF2100FF3C00FF5200FF
6400FF6F00FF7500FF7500FF6E00FF6200FF4F00FF3800FF1B00FF0006FF002BFF0053FF
007EFF00AAFF00D7FF00FFFB00FFCF00FFA500FF7E00FF5900FF3900FF1D00FF060BFF00
17FF001DFF001DFF0017FF000AFF0000FF0700FF1F00FF3C00FF5E00FF8400FFAF00FFDC
00F2FF00C0FF008CFF0058FF0024FF0F00FF4000FF7000FF
00FF3B00FF6A00FF9B00FFCF00FCFF00C8FF0094FF0062FF0031FF0002FF2800FF4F00FF
7200FF9000FFA900FFBC00FFCA00FFD100FFD200FFCD00FFC300FFB200FF9C00FF8100FF
6100FF3E00FF1700FF0012FF003EFF006AFF0097FF00C4FF00EFFF00FFE700FFC100FF9F
00FF8200FF6900FF5500FF4800FF4000FF3E00FF4300FF4E00FF5E00FF7300FF8D00FFAC
00FFCD00FFF100E9FF00C3FF009EFF007BFF005AFF003CFF0023FF000EFF0000FF0900FF
0B00FF0800FF0000FF000FFF0023FF003BFF0057FF0074FF0092FF00B1FF00CDFF00E7FF
00FCFF00FFF200FFE700FFE200FFE300FFEA00FFF700F7FF00E2FF00CBFF00B4FF009EFF
008CFF007DFF0075FF0073FF0077FF0080FF008EFF009EFF00AEFF00BBFF00C2FF00C2FF
00BCFF00B3FF00ABFF00AAFF00AFFF00B0FF00A9FF009FFF0098FF0097FF009DFF00A9FF
00B8FF00C8FF00D7FF00E2FF00E7FF00E6FF00DFFF00D1FF00BFFF00AAFF0093FF007CFF
0067FF0055FF0047FF003FFF003CFF0040FF004AFF005AFF006FFF0088FF00A4FF00C1FF
00E0FF00FEFF00FFE600FFCD00FFB800FFA800FF9E00FF9900FF9B00FFA200FFB000FFC3
00FFDC00FFF900E6FF00C3FF009EFF0078FF0053FF002FFF000DFF1100FF2C00FF4300FF
5400FF6000FF6500FF6500FF5E00FF5200FF4000FF2800FF0B00FF0015FF003BFF0063FF
008EFF00BAFF00E7FF00FFEC00FFC000FF9600FF6E00FF4A00FF2900FF0D09FF001BFF00
27FF002DFF002DFF0026FF001AFF0008FF0000FF0F00FF2C00FF4E00FF7500FF9F00FFCD
00FFFD00D0FF009CFF0068FF0033FF0000FF3100FF6000FF
00FF2600FF5500FF8700FFBA00FFEE00DDFF00A9FF0076FF0046FF0017FF1300FF3A00FF
5D00FF7B00FF9400FFA700FFB500FFBC00FFBD00FFB900FFAE00FF9D00FF8700FF6C00FF
4C00FF2900FF0200FF0027FF0053FF007FFF00ACFF00D9FF00FFFB00FFD300FFAD00FF8B
00FF6D00FF5400FF4100FF3300FF2B00FF2A00FF2E00FF3900FF4900FF5E00FF7900FF97
00FFB800FFDC00FEFF00D8FF00B3FF008FFF006EFF0051FF0037FF0023FF0014FF000BFF
0009FF000CFF0015FF0024FF0038FF0050FF006BFF0089FF00A7FF00C5FF00E2FF00FBFF
00FFEE00FFDD00FFD200FFCD00FFCE00FFD500FFE200FFF300F7FF00E0FF00C9FF00B3FF
00A0FF0092FF008AFF0087FF008CFF0095FF00A3FF00B3FF00C3FF00D0FF00D7FF00D7FF
00D1FF00C8FF00C0FF00BFFF00C4FF00C5FF00BEFF00B4FF00ADFF00ACFF00B2FF00BEFF
00CDFF00DDFF00ECFF00F6FF00FCFF00FBFF00F3FF00E6FF00D4FF00BFFF00A8FF0091FF
007CFF0069FF005CFF0053FF0051FF0055FF005FFF006FFF0084FF009CFF00B8FF00D6FF
00F5FF00FFED00FFD100FFB800FFA300FF9300FF8900FF8400FF8600FF8E00FF9B00FFAF
00FFC700FFE400FBFF00D8FF00B3FF008DFF0068FF0043FF0022FF0003FF1700FF2E00FF
3F00FF4B00FF5000FF5000FF4A00FF3D00FF2B00FF1300FF0009FF002AFF004FFF0078FF
00A2FF00CFFF00FBFF00FFD700FFAB00FF8100FF5900FF3500FF1407FF001EFF0030FF00
3CFF0042FF0041FF003BFF002FFF001DFF0005FF0000FF1700FF3900FF6000FF8A00FFB8
00FFE800E4FF00B1FF007CFF0048FF0015FF1C00FF4B00FF
00FF0D00FF3C00FF6E00FFA100FFD500F6FF00C2FF008FFF005FFF0030FF0005FF2100FF
4400FF6200FF7B00FF8E00FF9C00FFA300FFA500FFA000FF9500FF8400FF6E00FF5300FF
3300FF1000FF0016FF0040FF006CFF0098FF00C5FF00F2FF00FFE200FFBA00FF9400FF72
00FF5400FF3B00FF2800FF1A00FF1200FF1100FF1500FF2000FF3000FF4600FF6000FF7E
00FF9F00FFC300FFE800F1FF00CCFF00A8FF0087FF006AFF0050FF003CFF002DFF0024FF
0021FF0025FF002EFF003DFF0051FF0069FF0084FF00A2FF00C0FF00DEFF00FBFF00FFEB
00FFD500FFC400FFB900FFB400FFB500FFBC00FFC900FFDA00FFEF00F9FF00E2FF00CCFF
00B9FF00ABFF00A3FF00A0FF00A4FF00AEFF00BCFF00CCFF00DCFF00E8FF00F0FF00F0FF
00EAFF00E1FF00D9FF00D8FF00DDFF00DEFF00D7FF00CDFF00C6FF00C5FF00CBFF00D7FF
00E6FF00F6FF00FFFA00FFF000FFEA00FFEB00FFF300FFFF00EDFF00D8FF00C1FF00AAFF
0095FF0082FF0075FF006CFF006AFF006EFF0078FF0088FF009CFF00B5FF00D1FF00EFFF
00FFF100FFD400FFB800FF9F00FF8A00FF7A00FF7000FF6B00FF6D00FF7500FF8200FF96
00FFAE00FFCB00FFEB00F0FF00CCFF00A6FF0081FF005CFF003AFF001CFF0001FF1500FF
2600FF3200FF3700FF3700FF3100FF2400FF1200FF0005FF0022FF0043FF0068FF0091FF
00BBFF00E7FF00FFEB00FFBE00FF9200FF6800FF4000FF1C04FF0020FF0037FF0049FF00
54FF005AFF005AFF0054FF0048FF0036FF001EFF0001FF0000FF2000FF4700FF7100FF9F
00FFCF00FDFF00CAFF0095FF0061FF002EFF0300FF3300FF
0EFF0000FF2000FF5200FF8500FFB900FFED00DEFF00ABFF007AFF004CFF0021FF0500FF
2800FF4600FF5F00FF7200FF8000FF8700FF8900FF8400FF7900FF6800FF5200FF3700FF
1800FF000BFF0032FF005CFF0088FF00B4FF00E1FF00FFF100FFC600FF9E00FF7800FF56
00FF3800FF1F00FF0C01FF0009FF000AFF0006FF0000FF0400FF1400FF2A00FF4400FF62
00FF8300FFA700FFCC00FFF200E8FF00C4FF00A3FF0086FF006CFF0058FF0049FF0040FF
003DFF0041FF004AFF0059FF006DFF0085FF00A0FF00BEFF00DCFF00FAFF00FFE800FFCF
00FFB900FFA800FF9D00FF9800FF9900FFA000FFAD00FFBE00FFD300FFEA00FEFF00E8FF
00D5FF00C7FF00BFFF00BCFF00C0FF00CAFF00D8FF00E8FF00F8FF00FFFB00FFF300FFF3
00FFF900FDFF00F5FF00F4FF00F9FF00FAFF00F3FF00E9FF00E2FF00E1FF00E7FF00F3FF
00FFFD00FFED00FFDE00FFD400FFCE00FFCF00FFD700FFE400FFF600F4FF00DDFF00C6FF
00B1FF009EFF0091FF0088FF0086FF008AFF0094FF00A4FF00B8FF00D1FF00EDFF00FFF4
00FFD500FFB800FF9C00FF8300FF6E00FF5E00FF5400FF4F00FF5100FF5900FF6600FF7A
00FF9200FFAF00FFCF00FFF300E8FF00C2FF009DFF0078FF0056FF0038FF001DFF0006FF
0A00FF1600FF1C00FF1B00FF1500FF0800FF0009FF0021FF003EFF005FFF0084FF00ADFF
00D7FF00FFFC00FFCF00FFA200FF7600FF4C00FF2400FF0020FF003CFF0053FF0065FF00
70FF0076FF0076FF0070FF0064FF0052FF003AFF001DFF0000FF0400FF2B00FF5500FF83
00FFB300FFE600E6FF00B1FF007DFF004AFF0018FF1700FF
2CFF0000FF0200FF3400FF6700FF9B00FFCF00FCFF00C9FF0098FF006AFF003FFF0018FF
0A00FF2800FF4100FF5500FF6200FF6900FF6B00FF6600FF5B00FF4B00FF3400FF1900FF
0005FF0029FF0050FF007AFF00A5FF00D2FF00FFFF00FFD400FFA900FF8000FF5A00FF38
00FF1A00FF0111FF001FFF0027FF0028FF0024FF0019FF0009FF0000FF0C00FF2600FF44
00FF6500FF8900FFAE00FFD400FFF900E2FF00C1FF00A4FF008AFF0076FF0067FF005EFF
005BFF005FFF0068FF0077FF008BFF00A3FF00BEFF00DCFF00FAFF00FFE700FFCA00FFB1
00FF9B00FF8A00FF7F00FF7A00FF7B00FF8200FF8F00FFA100FFB500FFCC00FFE300FFF9
00F3FF00E5FF00DCFF00DAFF00DEFF00E8FF00F6FF00FFF900FFE900FFDD00FFD500FFD5
00FFDB00FFE400FFED00FFED00FFE900FFE800FFEF00FFF800FFFF00FFFF00FFFA00FFEE
00FFDF00FFCF00FFC000FFB600FFB000FFB100FFB900FFC600FFD800FFED00FBFF00E4FF
00CEFF00BCFF00AEFF00A6FF00A4FF00A8FF00B2FF00C1FF00D6FF00EFFF00FFF400FFD6
00FFB800FF9A00FF7E00FF6500FF5000FF4000FF3600FF3100FF3300FF3B00FF4800FF5C
00FF7400FF9100FFB200FFD500FFFA00E0FF00BAFF0096FF0074FF0055FF003AFF0024FF
0013FF0007FF0001FF0002FF0008FF0015FF0027FF003FFF005CFF007DFF00A2FF00CAFF
00F5FF00FFDE00FFB100FF8400FF5800FF2E00FF061DFF003EFF005AFF0071FF0082FF00
8EFF0094FF0094FF008EFF0082FF0070FF0058FF003BFF0019FF0000FF0D00FF3700FF65
00FF9500FFC800FFFC00CFFF009BFF0068FF0036FF0006FF
4AFF001BFF0000FF1500FF4900FF7D00FFB100FFE500E8FF00B7FF0088FF005DFF0036FF
0013FF0A00FF2300FF3600FF4400FF4B00FF4C00FF4700FF3D00FF2C00FF1600FF0004FF
0024FF0047FF006EFF0098FF00C4FF00F0FF00FFE200FFB500FF8A00FF6100FF3B00FF19
03FF001CFF0030FF003DFF0045FF0047FF0042FF0037FF0027FF0012FF0000FF0700FF26
00FF4700FF6B00FF9000FFB600FFDB00FFFE00E0FF00C2FF00A9FF0094FF0085FF007CFF
007AFF007DFF0086FF0095FF00A9FF00C1FF00DDFF00FAFF00FFE700FFC800FFAC00FF92
00FF7D00FF6C00FF6100FF5C00FF5D00FF6400FF7100FF8200FF9700FFAE00FFC500FFDB
00FFED00FFFC00FBFF00F9FF00FDFF00FFF900FFEB00FFDB00FFCB00FFBE00FFB700FFB7
00FFBD00FFC600FFCE00FFCF00FFCA00FFC900FFD000FFDA00FFE100FFE200FFDC00FFD0
00FFC100FFB100FFA200FF9700FF9200FF9300FF9A00FFA800FFBA00FFCF00FFE600FFFD
00EDFF00DBFF00CDFF00C5FF00C2FF00C6FF00D0FF00E0FF00F5FF00FFF100FFD500FFB8
00FF9900FF7B00FF6000FF4700FF3200FF2200FF1800FF1300FF1500FF1C00FF2A00FF3D
00FF5600FF7300FF9300FFB600FFDB00FEFF00D9FF00B5FF0093FF0074FF0059FF0042FF
0031FF0026FF0020FF0020FF0027FF0033FF0045FF005DFF007AFF009BFF00C1FF00E9FF
00FFEB00FFBF00FF9200FF6600FF3A00FF1017FF003BFF005CFF0078FF008FFF00A1FF00
ADFF00B3FF00B3FF00ACFF00A0FF008EFF0076FF0059FF0037FF0010FF0000FF1900FF47
00FF7700FFA900FFDD00EEFF00B9FF0086FF0054FF0025FF
68FF0039FF0007FF0000FF2B00FF5F00FF9300FFC700FFFA00D4FF00A6FF007BFF0054FF
0031FF0013FF0500FF1800FF2600FF2D00FF2F00FF2A00FF1F00FF0E00FF0007FF0022FF
0041FF0065FF008CFF00B6FF00E1FF00FFF100FFC400FF9700FF6C00FF4400FF1E03FF00
21FF003AFF004DFF005BFF0063FF0064FF0060FF0055FF0045FF002FFF0015FF0000FF08
00FF2900FF4D00FF7200FF9800FFBD00FFE100FDFF00E0FF00C6FF00B2FF00A3FF009AFF
0097FF009BFF00A4FF00B3FF00C7FF00DFFF00FAFF00FFE700FFC900FFAB00FF8E00FF75
00FF5F00FF4E00FF4300FF3E00FF3F00FF4600FF5300FF6400FF7900FF9000FFA700FFBD
00FFD000FFDE00FFE600FFE900FFE500FFDB00FFCD00FFBD00FFAD00FFA100FF9900FF99
00FF9F00FFA800FFB000FFB100FFAC00FFAB00FFB200FFBC00FFC300FFC400FFBE00FFB2
00FFA300FF9300FF8400FF7A00FF7400FF7500FF7D00FF8A00FF9C00FFB100FFC800FFDF
00FFF400F8FF00EBFF00E2FF00E0FF00E4FF00EEFF00FEFF00FFED00FFD400FFB800FF9A
00FF7B00FF5E00FF4200FF2900FF1400FF0405FF000AFF0008FF0000FF0000FF0C00FF20
00FF3800FF5500FF7500FF9900FFBD00FFE300F7FF00D2FF00B0FF0092FF0077FF0060FF
004FFF0043FF003DFF003EFF0044FF0051FF0063FF007BFF0098FF00B9FF00DEFF00FFF8
00FFCE00FFA200FF7500FF4800FF1C0DFF0035FF0059FF007AFF0096FF00ADFF00BEFF00
CAFF00D0FF00D0FF00CAFF00BEFF00ACFF0094FF0077FF0055FF002EFF0004FF0000FF29
00FF5900FF8C00FFBF00FFF400D7FF00A4FF0072FF0042FF
84FF0055FF0023FF0000FF0F00FF4300FF7700FFAB00FFDE00F0FF00C2FF0097FF0070FF
004DFF002EFF0016FF0002FF0A00FF1100FF1300FF0E00FF0300FF000CFF0022FF003EFF
005DFF0081FF00A8FF00D2FF00FDFF00FFD500FFA800FF7C00FF5100FF2800FF021FFF00
3DFF0056FF0069FF0077FF007FFF0080FF007BFF0071FF0061FF004BFF0031FF0013FF00
00FF0D00FF3100FF5600FF7C00FFA100FFC500FFE600FCFF00E2FF00CEFF00BFFF00B6FF
00B3FF00B7FF00C0FF00CFFF00E3FF00FBFF00FFE900FFCB00FFAD00FF8F00FF7300FF59
00FF4300FF3200FF2700FF2200FF2300FF2A00FF3700FF4900FF5D00FF7400FF8B00FFA1
00FFB400FFC200FFCB00FFCD00FFC900FFBF00FFB100FFA100FF9100FF8500FF7E00FF7D
00FF8300FF8D00FF9500FF9500FF9100FF9000FF9700FFA000FFA700FFA800FFA200FF97
00FF8700FF7700FF6800FF5E00FF5900FF5A00FF6100FF6E00FF8000FF9500FFAC00FFC3
00FFD900FFEB00FFF900FEFF00FCFF00FFFF00FFF500FFE600FFD100FFB800FF9C00FF7E
00FF6000FF4200FF2600FF0D07FF0016FF0021FF0026FF0024FF001CFF000EFF0000FF04
00FF1C00FF3900FF5A00FF7D00FFA200FFC700FFED00EEFF00CCFF00ADFF0092FF007CFF
006BFF005FFF0059FF005AFF0060FF006DFF007FFF0097FF00B4FF00D5FF00FAFF00FFDD
00FFB200FF8600FF5900FF2C00FF0029FF0051FF0075FF0096FF00B2FF00C9FF00DAFF00
E6FF00ECFF00ECFF00E6FF00DAFF00C8FF00B0FF0093FF0071FF004AFF0020FF0000FF0D
00FF3E00FF7000FFA400FFD800F3FF00C0FF008EFF005EFF
9CFF006DFF003CFF0009FF0000FF2A00FF5F00FF9200FFC500FFF600DBFF00B0FF0088FF
0065FF0047FF002EFF001BFF000EFF0006FF0005FF000AFF0015FF0025FF003BFF0056FF
0076FF009AFF00C1FF00EBFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006FFF0082FF0090FF0097FF0099FF0094FF008AFF007AFF0064FF004AFF002CFF00
0AFF0000FF1800FF3E00FF6300FF8800FFAC00FFCD00FFEB00FBFF00E7FF00D8FF00CFFF
00CCFF00CFFF00D9FF00E8FF00FCFF00FFEB00FFD000FFB300FF9400FF7600FF5A00FF40
00FF2A00FF1A00FF0E00FF0900FF0A00FF1200FF1E00FF3000FF4500FF5B00FF7300FF88
00FF9B00FFA900FFB200FFB400FFB000FFA600FF9800FF8800FF7900FF6C00FF6500FF64
00FF6A00FF7400FF7C00FF7D00FF7800FF7700FF7E00FF8800FF8E00FF8F00FF8900FF7E
00FF6E00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7D00FF9400FFAB
00FFC000FFD200FFE000FFE800FFEA00FFE700FFDD00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0BFF001FFF002FFF003AFF003EFF003DFF0035FF0027FF0014FF00
00FF0400FF2000FF4100FF6400FF8900FFAE00FFD400FFF800E5FF00C6FF00ABFF0095FF
0084FF0078FF0072FF0072FF0079FF0085FF0098FF00B0FF00CCFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1318FF0042FF0069FF008EFF00AEFF00CAFF00E1FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F2FF00E0FF00C9FF00ABFF0089FF0063FF0038FF000BFF00
00FF2500FF5700FF8B00FFBF00FFF300D8FF00A7FF0077FF
B1FF0082FF0051FF001EFF0000FF1500FF4A00FF7E00FFB000FFE100F0FF00C4FF009DFF
007AFF005CFF0043FF0030FF0022FF001BFF001AFF001FFF0029FF003AFF0050FF006BFF
008BFF00AFFF00D6FF00FFFF00FFD400FFA700FF7A00FF4E00FF2305FF002BFF004DFF00
6BFF0083FF0097FF00A4FF00ACFF00AEFF00A9FF009FFF008EFF0079FF005FFF0041FF00
1FFF0000FF0400FF2900FF4F00FF7400FF9700FFB800FFD600FFEF00FBFF00EDFF00E4FF
00E1FF00E4FF00EEFF00FCFF00FFEF00FFD700FFBB00FF9E00FF7F00FF6100FF4500FF2B
00FF1600FF0505FF000AFF0009FF0002FF0000FF0A00FF1B00FF3000FF4700FF5E00FF74
00FF8600FF9500FF9D00FF9F00FF9B00FF9100FF8400FF7300FF6400FF5700FF5000FF50
00FF5500FF5F00FF6700FF6800FF6300FF6200FF6900FF7300FF7A00FF7B00FF7500FF69
00FF5A00FF4900FF3B00FF3000FF2B00FF2C00FF3300FF4000FF5200FF6800FF7F00FF96
00FFAB00FFBD00FFCB00FFD300FFD600FFD200FFC800FFB800FFA300FF8A00FF6E00FF50
00FF3200FF1407FF001FFF0034FF0044FF004FFF0053FF0051FF004AFF003CFF0029FF00
10FF0000FF0C00FF2C00FF4F00FF7400FF9A00FFBF00FFE300FAFF00DBFF00C0FF00AAFF
0098FF008DFF0087FF0087FF008EFF009AFF00ADFF00C4FF00E1FF00FFFC00FFD700FFAF
00FF8400FF5800FF2B01FF002CFF0057FF007EFF00A3FF00C3FF00DFFF00F6FF00FFF700
FFEB00FFE500FFE500FFEB00FFF800F5FF00DDFF00C0FF009EFF0078FF004DFF001FFF00
00FF1000FF4200FF7600FFAA00FFDE00EDFF00BBFF008CFF
C1FF0092FF0061FF002EFF0000FF0600FF3A00FF6E00FFA000FFD100FFFF00D4FF00ADFF
008AFF006CFF0053FF0040FF0032FF002BFF002AFF002FFF0039FF004AFF0060FF007BFF
009BFF00BEFF00E6FF00FFF000FFC400FF9700FF6B00FF3E00FF1315FF003BFF005DFF00
7AFF0093FF00A7FF00B4FF00BCFF00BEFF00B9FF00AEFF009EFF0089FF006FFF0050FF00
2FFF000BFF0000FF1900FF3F00FF6400FF8700FFA800FFC600FFDF00FFF400FCFF00F4FF
00F1FF00F4FF00FDFF00FFF300FFDF00FFC700FFAB00FF8E00FF6F00FF5100FF3500FF1B
00FF060AFF0015FF001AFF0019FF0012FF0005FF0000FF0B00FF2000FF3700FF4E00FF64
00FF7600FF8500FF8D00FF8F00FF8B00FF8200FF7400FF6300FF5400FF4700FF4000FF40
00FF4500FF4F00FF5700FF5800FF5300FF5200FF5900FF6300FF6A00FF6B00FF6500FF59
00FF4A00FF3900FF2B00FF2000FF1B00FF1C00FF2300FF3100FF4200FF5800FF6F00FF86
00FF9B00FFAD00FFBB00FFC300FFC600FFC200FFB800FFA800FF9300FF7A00FF5E00FF40
00FF2200FF0416FF002FFF0044FF0054FF005EFF0063FF0061FF005AFF004CFF0039FF00
20FF0003FF0000FF1C00FF3F00FF6400FF8A00FFAF00FFD300FFF500EBFF00D0FF00BAFF
00A8FF009DFF0097FF0097FF009EFF00AAFF00BCFF00D4FF00F1FF00FFED00FFC700FF9F
00FF7400FF4800FF1B11FF003CFF0067FF008EFF00B3FF00D3FF00EFFF00FFF900FFE700
FFDB00FFD500FFD500FFDC00FFE800FFFA00EDFF00D0FF00AEFF0088FF005DFF002FFF00
00FF0000FF3200FF6600FF9A00FFCF00FDFF00CBFF009CFF
CCFF009DFF006BFF0038FF0004FF0000FF2F00FF6300FF9600FFC700FFF500DFFF00B8FF
0095FF0076FF005EFF004AFF003DFF0035FF0034FF0039FF0044FF0054FF006AFF0086FF
00A5FF00C9FF00F0FF00FFE500FFBA00FF8D00FF6000FF3400FF091FFF0045FF0067FF00
85FF009EFF00B1FF00BFFF00C7FF00C8FF00C3FF00B9FF00A9FF0093FF0079FF005BFF00
3AFF0016FF0000FF0E00FF3400FF5900FF7D00FF9E00FFBB00FFD500FFE900FFF800FEFF
00FBFF00FFFF00FFF700FFE800FFD400FFBC00FFA100FF8300FF6500FF4700FF2B00FF11
04FF0015FF0020FF0025FF0024FF001DFF0010FF0000FF0100FF1500FF2C00FF4300FF59
00FF6C00FF7A00FF8300FF8500FF8100FF7700FF6900FF5900FF4900FF3D00FF3600FF35
00FF3B00FF4500FF4D00FF4D00FF4900FF4800FF4F00FF5800FF5F00FF6000FF5A00FF4F
00FF3F00FF2F00FF2000FF1600FF1100FF1200FF1900FF2600FF3800FF4D00FF6400FF7B
00FF9100FFA300FFB100FFB900FFBB00FFB700FFAD00FF9E00FF8900FF7000FF5400FF36
00FF1805FF0021FF003AFF004FFF005EFF0069FF006DFF006CFF0064FF0056FF0043FF00
2BFF000EFF0000FF1200FF3500FF5A00FF7F00FFA500FFC900FFEB00F5FF00DAFF00C4FF
00B3FF00A7FF00A1FF00A2FF00A8FF00B5FF00C7FF00DFFF00FCFF00FFE200FFBD00FF95
00FF6A00FF3E00FF111BFF0047FF0071FF0099FF00BDFF00DEFF00FAFF00FFEE00FFDD00
FFD100FFCB00FFCB00FFD100FFDD00FFEF00F8FF00DBFF00B8FF0092FF0068FF003AFF00
09FF0000FF2800FF5C00FF9000FFC400FFF700D6FF00A6FF
D0FF00A1FF0070FF003DFF0009FF0000FF2B00FF5F00FF9100FFC200FFF000E3FF00BCFF
0099FF007BFF0062FF004FFF0041FF003AFF0039FF003EFF0048FF0059FF006FFF008AFF
00AAFF00CDFF00F5FF00FFE100FFB500FF8800FF5B00FF2F00FF0424FF004AFF006CFF00
89FF00A2FF00B6FF00C3FF00CBFF00CDFF00C8FF00BDFF00ADFF0098FF007EFF005FFF00
3EFF001AFF0000FF0A00FF3000FF5500FF7800FF9900FFB700FFD000FFE500FFF400FFFC
00FFFF00FFFC00FFF200FFE400FFD000FFB800FF9C00FF7F00FF6000FF4200FF2600FF0C
08FF0019FF0024FF0029FF0028FF0021FF0014FF0003FF0000FF1100FF2800FF3F00FF55
00FF6700FF7600FF7E00FF8000FF7C00FF7200FF6500FF5400FF4500FF3800FF3100FF31
00FF3600FF4000FF4800FF4900FF4400FF4300FF4A00FF5400FF5B00FF5C00FF5600FF4A
00FF3B00FF2A00FF1C00FF1100FF0C00FF0D00FF1400FF2100FF3300FF4900FF6000FF77
00FF8C00FF9E00FFAC00FFB400FFB700FFB300FFA900FF9900FF8400FF6B00FF4F00FF31
00FF130AFF0026FF003EFF0053FF0063FF006DFF0072FF0070FF0069FF005BFF0048FF00
2FFF0012FF0000FF0D00FF3000FF5500FF7B00FFA000FFC400FFE600FAFF00DFFF00C9FF
00B7FF00ACFF00A6FF00A6FF00ADFF00B9FF00CBFF00E3FF00FFFF00FFDE00FFB800FF90
00FF6500FF3900FF0C20FF004BFF0076FF009DFF00C2FF00E2FF00FEFF00FFEA00FFD800
FFCC00FFC600FFC600FFCD00FFD900FFEB00FCFF00DFFF00BDFF0097FF006CFF003EFF00
0EFF0000FF2300FF5700FF8B00FFBF00FFF300DAFF00ABFF
CFFF00A0FF006EFF003BFF0007FF0000FF2C00FF6000FF9300FFC400FFF200E2FF00BBFF
0098FF0079FF0061FF004DFF0040FF0038FF0037FF003CFF0047FF0057FF006DFF0089FF
00A8FF00CCFF00F3FF00FFE200FFB700FF8A00FF5D00FF3100FF0622FF0048FF006AFF00
88FF00A1FF00B4FF00C2FF00CAFF00CBFF00C6FF00BCFF00ACFF0096FF007CFF005EFF00
3CFF0019FF0000FF0C00FF3100FF5600FF7A00FF9B00FFB900FFD200FFE600FFF500FFFE
00FEFF00FFFD00FFF400FFE500FFD100FFB900FF9E00FF8000FF6200FF4400FF2800FF0E
07FF0018FF0023FF0028FF0027FF0020FF0013FF0001FF0000FF1200FF2900FF4000FF56
00FF6900FF7700FF8000FF8200FF7E00FF7400FF6600FF5600FF4600FF3A00FF3300FF32
00FF3800FF4200FF4A00FF4A00FF4600FF4500FF4C00FF5500FF5C00FF5D00FF5700FF4C
00FF3C00FF2C00FF1E00FF1300FF0E00FF0F00FF1600FF2300FF3500FF4A00FF6100FF78
00FF8E00FFA000FFAE00FFB600FFB800FFB400FFAA00FF9B00FF8600FF6D00FF5100FF33
00FF1508FF0024FF003DFF0051FF0061FF006CFF0070FF006FFF0067FF0059FF0046FF00
2EFF0011FF0000FF0F00FF3200FF5700FF7C00FFA200FFC600FFE800F8FF00DDFF00C7FF
00B6FF00AAFF00A4FF00A5FF00ABFF00B8FF00CAFF00E2FF00FFFF00FFDF00FFBA00FF92
00FF6700FF3B00FF0E1EFF004AFF0074FF009CFF00C0FF00E0FF00FDFF00FFEB00FFDA00
FFCE00FFC800FFC800FFCE00FFDA00FFED00FBFF00DEFF00BBFF0095FF006BFF003DFF00
0CFF0000FF2500FF5900FF8D00FFC100FFF400D9FF00A9FF
C7FF0098FF0066FF0033FF0000FF0000FF3400FF6800FF9B00FFCC00FFFA00DAFF00B3FF
0090FF0072FF0059FF0046FF0038FF0031FF002FFF0034FF003FFF0050FF0066FF0081FF
00A0FF00C4FF00EBFF00FFEA00FFBE00FF9200FF6500FF3800FF0D1AFF0040FF0062FF00
80FF0099FF00ACFF00BAFF00C2FF00C3FF00BFFF00B4FF00A4FF008EFF0074FF0056FF00
35FF0011FF0000FF1300FF3900FF5E00FF8200FFA300FFC000FFDA00FFEE00FFFD00F9FF
00F6FF00FAFF00FFFC00FFED00FFD900FFC100FFA600FF8800FF6A00FF4C00FF2F00FF16
00FF0010FF001BFF0020FF001FFF0018FF000BFF0000FF0500FF1A00FF3100FF4800FF5E
00FF7100FF7F00FF8700FF8A00FF8600FF7C00FF6E00FF5E00FF4E00FF4200FF3A00FF3A
00FF4000FF4900FF5100FF5200FF4D00FF4C00FF5300FF5D00FF6400FF6500FF5F00FF53
00FF4400FF3400FF2500FF1B00FF1500FF1600FF1E00FF2B00FF3D00FF5200FF6900FF80
00FF9500FFA800FFB500FFBE00FFC000FFBC00FFB200FFA200FF8E00FF7500FF5900FF3B
00FF1C00FF001CFF0035FF004AFF005AFF0064FF0069FF0067FF005FFF0052FF003EFF00
26FF0009FF0000FF1600FF3A00FF5E00FF8400FFA900FFCE00FFF000F1FF00D6FF00BFFF
00AEFF00A2FF009CFF009DFF00A3FF00B0FF00C2FF00DAFF00F7FF00FFE700FFC200FF99
00FF6F00FF4300FF1616FF0042FF006CFF0094FF00B8FF00D9FF00F5FF00FFF300FFE200
FFD600FFD000FFD000FFD600FFE200FFF400F3FF00D6FF00B4FF008DFF0063FF0035FF00
05FF0000FF2D00FF6000FF9500FFC900FFFC00D1FF00A1FF
B9FF008AFF0059FF0026FF0000FF0E00FF4200FF7600FFA800FFD900F7FF00CCFF00A5FF
0082FF0064FF004BFF0038FF002AFF0023FF0022FF0027FF0031FF0042FF0058FF0073FF
0093FF00B6FF00DDFF00FFF800FFCC00FFA000FF7300FF4600FF1B0DFF0033FF0055FF00
72FF008BFF009FFF00ACFF00B4FF00B6FF00B1FF00A6FF0096FF0081FF0067FF0048FF00
27FF0003FF0000FF2100FF4700FF6C00FF8F00FFB000FFCE00FFE700FFFC00F4FF00ECFF
00E9FF00ECFF00F5FF00FFFB00FFE700FFCF00FFB300FF9600FF7800FF5900FF3D00FF23
00FF0E02FF000DFF0012FF0011FF000AFF0000FF0200FF1300FF2800FF3F00FF5600FF6C
00FF7E00FF8D00FF9500FF9700FF9300FF8A00FF7C00FF6C00FF5C00FF4F00FF4800FF48
00FF4D00FF5700FF5F00FF6000FF5B00FF5A00FF6100FF6B00FF7200FF7300FF6D00FF61
00FF5200FF4200FF3300FF2800FF2300FF2400FF2B00FF3900FF4A00FF6000FF7700FF8E
00FFA300FFB500FFC300FFCB00FFCE00FFCA00FFC000FFB000FF9B00FF8200FF6600FF48
00FF2A00FF0C0EFF0027FF003CFF004CFF0056FF005BFF0059FF0052FF0044FF0031FF00
18FF0000FF0400FF2400FF4700FF6C00FF9200FFB700FFDB00FFFD00E3FF00C8FF00B1FF
00A0FF0095FF008FFF008FFF0096FF00A2FF00B4FF00CCFF00E9FF00FFF500FFCF00FFA7
00FF7C00FF5000FF2308FF0034FF005EFF0086FF00AAFF00CBFF00E7FF00FEFF00FFEF00
FFE300FFDD00FFDD00FFE400FFF000FDFF00E5FF00C8FF00A6FF007FFF0055FF0027FF00
00FF0800FF3A00FF6E00FFA200FFD700F5FF00C3FF0094FF
A6FF0077FF0045FF0012FF0000FF2100FF5500FF8900FFBC00FFED00E4FF00B9FF0092FF
006FFF0051FF0038FF0024FF0017FF0010FF000EFF0013FF001EFF002FFF0045FF0060FF
007FFF00A3FF00CAFF00F4FF00FFE000FFB300FF8600FF5900FF2E00FF061FFF0041FF00
5FFF0078FF008BFF0099FF00A1FF00A2FF009EFF0093FF0083FF006DFF0053FF0035FF00
14FF0000FF0F00FF3400FF5A00FF7F00FFA300FFC400FFE100FFFB00F0FF00E1FF00D8FF
00D5FF00D9FF00E2FF00F1FF00FFFA00FFE200FFC700FFA900FF8B00FF6D00FF5000FF37
00FF2100FF1000FF0500FF0000FF0100FF0800FF1500FF2600FF3B00FF5200FF6900FF7F
00FF9200FFA000FFA800FFAB00FFA700FF9D00FF8F00FF7F00FF6F00FF6300FF5B00FF5B
00FF6100FF6A00FF7200FF7300FF6F00FF6D00FF7500FF7E00FF8500FF8600FF8000FF74
00FF6500FF5500FF4600FF3C00FF3600FF3700FF3F00FF4C00FF5E00FF7300FF8A00FFA1
00FFB700FFC900FFD600FFDF00FFE100FFDD00FFD300FFC300FFAF00FF9600FF7A00FF5C
00FF3D00FF2000FF0414FF0029FF0039FF0043FF0048FF0046FF003EFF0031FF001DFF00
05FF0000FF1700FF3700FF5B00FF7F00FFA500FFCB00FFEF00EEFF00D0FF00B5FF009EFF
008DFF0081FF007BFF007CFF0082FF008FFF00A1FF00B9FF00D6FF00F7FF00FFE300FFBA
00FF9000FF6400FF3700FF0A21FF004BFF0073FF0097FF00B8FF00D4FF00EBFF00FCFF00
FFF700FFF100FFF100FFF700FCFF00EAFF00D2FF00B5FF0093FF006CFF0042FF0014FF00
00FF1B00FF4E00FF8100FFB600FFEA00E2FF00B0FF0080FF
8DFF005EFF002DFF0000FF0500FF3900FF6E00FFA100FFD400FAFF00CCFF00A1FF0079FF
0056FF0038FF001FFF000CFF0000FF0800FF0900FF0400FF0006FF0016FF002CFF0047FF
0067FF008BFF00B2FF00DBFF00FFF800FFCB00FF9E00FF7200FF4700FF1E07FF0029FF00
47FF005FFF0073FF0081FF0088FF008AFF0085FF007BFF006AFF0055FF003BFF001DFF00
00FF0400FF2800FF4D00FF7200FF9800FFBB00FFDC00FFFA00ECFF00D8FF00C9FF00C0FF
00BDFF00C0FF00CAFF00D9FF00ECFF00FFFA00FFDF00FFC200FFA300FF8500FF6900FF4F
00FF3900FF2900FF1D00FF1800FF1A00FF2100FF2D00FF3F00FF5400FF6B00FF8200FF97
00FFAA00FFB800FFC100FFC300FFBF00FFB500FFA700FF9700FF8800FF7B00FF7400FF73
00FF7900FF8300FF8B00FF8C00FF8700FF8600FF8D00FF9700FF9E00FF9E00FF9900FF8D
00FF7E00FF6D00FF5F00FF5400FF4F00FF5000FF5700FF6400FF7600FF8C00FFA300FFBA
00FFCF00FFE100FFEF00FFF700FFFA00FFF600FFEC00FFDC00FFC700FFAE00FF9200FF74
00FF5600FF3800FF1C00FF0410FF0020FF002BFF002FFF002EFF0026FF0018FF0005FF00
00FF1300FF2F00FF5000FF7300FF9800FFBE00FFE300F8FF00D6FF00B7FF009CFF0086FF
0074FF0069FF0063FF0063FF006AFF0076FF0089FF00A0FF00BDFF00DFFF00FFFB00FFD3
00FFA800FF7C00FF4F00FF2209FF0033FF005AFF007FFF009FFF00BBFF00D2FF00E4FF00
F0FF00F6FF00F6FF00F0FF00E3FF00D1FF00B9FF009CFF007AFF0054FF0029FF0000FF03
00FF3400FF6600FF9A00FFCE00FDFF00C9FF0098FF0068FF
71FF0041FF0010FF0000FF2200FF5600FF8A00FFBE00FFF100DDFF00AFFF0084FF005CFF
0039FF001BFF0002FF1000FF1D00FF2500FF2600FF2100FF1600FF0600FF000FFF002AFF
004AFF006EFF0095FF00BFFF00EAFF00FFE800FFBB00FF8F00FF6400FF3B00FF150CFF00
2AFF0043FF0056FF0064FF006BFF006DFF0068FF005EFF004EFF0038FF001EFF0000FF00
00FF2100FF4400FF6A00FF8F00FFB400FFD800FFF900E8FF00CFFF00BBFF00ACFF00A3FF
00A0FF00A3FF00ADFF00BCFF00D0FF00E8FF00FFFC00FFDF00FFC000FFA200FF8600FF6C
00FF5600FF4500FF3A00FF3500FF3600FF3E00FF4A00FF5C00FF7100FF8700FF9E00FFB4
00FFC700FFD500FFDE00FFE000FFDC00FFD200FFC400FFB400FFA400FF9800FF9100FF90
00FF9600FFA000FFA800FFA800FFA400FFA300FFAA00FFB400FFBA00FFBB00FFB500FFAA
00FF9A00FF8A00FF7C00FF7100FF6C00FF6D00FF7400FF8100FF9300FFA800FFBF00FFD6
00FFEC00FFFE00F3FF00EBFF00E9FF00EDFF00F7FF00FFF900FFE400FFCB00FFAF00FF91
00FF7300FF5500FF3900FF2000FF0C03FF000EFF0012FF0011FF0009FF0000FF0400FF17
00FF2F00FF4C00FF6D00FF9000FFB500FFDA00FFFF00DBFF00B9FF009AFF007FFF0069FF
0058FF004CFF0046FF0046FF004DFF0059FF006CFF0084FF00A0FF00C2FF00E7FF00FFF0
00FFC500FF9900FF6C00FF3F00FF1316FF003DFF0062FF0082FF009EFF00B5FF00C7FF00
D3FF00D9FF00D9FF00D3FF00C7FF00B4FF009DFF007FFF005DFF0037FF000CFF0000FF20
00FF5100FF8300FFB700FFEB00E0FF00ADFF007BFF004BFF
50FF0021FF0000FF0F00FF4300FF7700FFAB00FFDF00EEFF00BDFF008EFF0063FF003CFF
0019FF0400FF1D00FF3000FF3E00FF4500FF4600FF4200FF3700FF2600FF1000FF000AFF
002AFF004DFF0074FF009EFF00CAFF00F6FF00FFDC00FFAF00FF8400FF5B00FF3600FF13
09FF0022FF0036FF0043FF004BFF004DFF0048FF003DFF002DFF0018FF0000FF0100FF20
00FF4100FF6500FF8A00FFB000FFD500FFF800E6FF00C8FF00AFFF009AFF008BFF0082FF
0080FF0083FF008CFF009BFF00AFFF00C7FF00E3FF00FFFF00FFE100FFC300FFA600FF8C
00FF7700FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7C00FF9100FFA800FFBF00FFD5
00FFE700FFF600FFFE00FFFF00FFFC00FFF300FFE500FFD500FFC500FFB800FFB100FFB1
00FFB700FFC000FFC800FFC900FFC400FFC300FFCA00FFD400FFDB00FFDC00FFD600FFCA
00FFBB00FFAB00FF9C00FF9100FF8C00FF8D00FF9400FFA200FFB400FFC900FFE000FFF7
00F3FF00E1FF00D3FF00CBFF00C8FF00CCFF00D6FF00E6FF00FBFF00FFEB00FFCF00FFB2
00FF9300FF7500FF5A00FF4100FF2C00FF1C00FF1200FF0D00FF0F00FF1600FF2400FF37
00FF5000FF6D00FF8D00FFB000FFD500FFFB00DFFF00BBFF0099FF007AFF005FFF0048FF
0037FF002BFF0026FF0026FF002DFF0039FF004BFF0063FF0080FF00A1FF00C7FF00EFFF
00FFE600FFB900FF8C00FF6000FF3400FF0A1DFF0041FF0062FF007EFF0095FF00A7FF00
B3FF00B9FF00B9FF00B2FF00A6FF0094FF007CFF005FFF003DFF0016FF0000FF1300FF41
00FF7100FFA300FFD700F4FF00BFFF008CFF005AFF002BFF
2DFF0000FF0100FF3300FF6600FF9A00FFCE00FDFF00CAFF009AFF006BFF0040FF0019FF
0900FF2700FF4000FF5300FF6100FF6800FF6900FF6500FF5A00FF4900FF3300FF1800FF
0007FF002AFF0051FF007BFF00A7FF00D3FF00FFFF00FFD200FFA700FF7E00FF5900FF37
00FF1900FF0013FF0020FF0028FF0029FF0025FF001AFF000AFF0000FF0A00FF2500FF43
00FF6400FF8800FFAD00FFD300FFF800E3FF00C2FF00A5FF008BFF0077FF0068FF005FFF
005DFF0060FF0069FF0078FF008CFF00A4FF00BFFF00DDFF00FBFF00FFE600FFC900FFB0
00FF9A00FF8900FF7E00FF7900FF7A00FF8100FF8E00FF9F00FFB400FFCB00FFE200FFF8
00F4FF00E6FF00DEFF00DBFF00E0FF00E9FF00F7FF00FFF800FFE800FFDB00FFD400FFD4
00FFDA00FFE300FFEB00FFEC00FFE700FFE600FFED00FFF700FFFE00FFFF00FFF900FFED
00FFDE00FFCE00FFBF00FFB500FFAF00FFB000FFB800FFC500FFD700FFEC00FCFF00E5FF
00D0FF00BDFF00B0FF00A7FF00A5FF00A9FF00B3FF00C3FF00D8FF00F0FF00FFF300FFD5
00FFB600FF9900FF7D00FF6400FF4F00FF3F00FF3500FF3000FF3200FF3A00FF4700FF5B
00FF7300FF9000FFB000FFD300FFF800E1FF00BCFF0097FF0076FF0057FF003CFF0025FF
0014FF0008FF0003FF0003FF0009FF0016FF0028FF0040FF005DFF007EFF00A3FF00CCFF
00F6FF00FFDC00FFB000FF8300FF5700FF2D00FF051EFF003FFF005BFF0072FF0084FF00
90FF0096FF0095FF008FFF0083FF0071FF0059FF003CFF001AFF0000FF0C00FF3600FF64
00FF9400FFC700FFFA00D0FF009CFF0069FF0037FF0008FF
08FF0000FF2600FF5700FF8B00FFBF00FFF300D8FF00A6FF0075FF0046FF001BFF0B00FF
2E00FF4C00FF6500FF7800FF8600FF8D00FF8E00FF8A00FF7F00FF6E00FF5800FF3D00FF
1D00FF0005FF002CFF0056FF0082FF00AEFF00DBFF00FFF700FFCC00FFA300FF7E00FF5B
00FF3E00FF2500FF1100FF0403FF0004FF0000FF0000FF0A00FF1A00FF2F00FF4900FF68
00FF8900FFAD00FFD200FFF800E2FF00BFFF009EFF0080FF0067FF0052FF0043FF003AFF
0038FF003BFF0044FF0053FF0067FF007FFF009BFF00B8FF00D6FF00F4FF00FFEE00FFD4
00FFBF00FFAE00FFA300FF9E00FF9F00FFA600FFB300FFC400FFD900FFF000F8FF00E2FF
00D0FF00C1FF00B9FF00B7FF00BBFF00C4FF00D2FF00E2FF00F2FF00FFFF00FFF900FFF9
00FFFF00F7FF00EFFF00EEFF00F3FF00F4FF00EDFF00E3FF00DCFF00DBFF00E1FF00EDFF
00FCFF00FFF300FFE400FFD900FFD400FFD500FFDC00FFEA00FFFC00EEFF00D7FF00C0FF
00ABFF0099FF008BFF0082FF0080FF0084FF008EFF009EFF00B3FF00CCFF00E8FF00FFFA
00FFDB00FFBD00FFA200FF8900FF7400FF6400FF5A00FF5500FF5700FF5E00FF6C00FF7F
00FF9800FFB500FFD500FFF800E2FF00BCFF0097FF0073FF0051FF0032FF0017FF0000FF
1000FF1C00FF2100FF2100FF1B00FF0E00FF0003FF001BFF0038FF0059FF007EFF00A7FF
00D1FF00FEFF00FFD400FFA800FF7C00FF5200FF2A00FF061AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006AFF005EFF004CFF0034FF0017FF0000FF0A00FF3100FF5B00FF89
00FFB900FFEC00E0FF00ACFF0077FF0044FF0012FF1C00FF
00FF1D00FF4C00FF7D00FFB000FFE400E6FF00B3FF0080FF004FFF0021FF0900FF3100FF
5400FF7200FF8B00FF9E00FFAB00FFB300FFB400FFAF00FFA400FF9400FF7E00FF6300FF
4300FF1F00FF0007FF0030FF005CFF0089FF00B6FF00E2FF00FFF200FFC900FFA300FF81
00FF6300FF4A00FF3700FF2900FF2200FF2000FF2500FF2F00FF4000FF5500FF6F00FF8D
00FFAF00FFD200FFF800E2FF00BCFF0099FF0078FF005AFF0041FF002DFF001EFF0015FF
0012FF0015FF001FFF002EFF0042FF005AFF0075FF0092FF00B1FF00CFFF00EBFF00FFFA
00FFE400FFD400FFC800FFC300FFC400FFCC00FFD800FFEA00FFFF00EAFF00D2FF00BDFF
00AAFF009CFF0093FF0091FF0095FF009FFF00ADFF00BDFF00CCFF00D9FF00E0FF00E1FF
00DBFF00D1FF00C9FF00C8FF00CDFF00CEFF00C7FF00BDFF00B6FF00B6FF00BCFF00C7FF
00D7FF00E7FF00F5FF00FFFF00FFFA00FFFB00FDFF00F0FF00DEFF00C8FF00B1FF009AFF
0085FF0073FF0065FF005DFF005AFF005EFF0068FF0078FF008DFF00A6FF00C2FF00E0FF
00FEFF00FFE300FFC700FFAE00FF9A00FF8A00FF7F00FF7B00FF7C00FF8400FF9200FFA5
00FFBE00FFDA00FFFB00E1FF00BCFF0096FF0071FF004DFF002BFF000CFF0E00FF2400FF
3600FF4100FF4700FF4700FF4000FF3400FF2100FF0900FF0012FF0034FF0059FF0081FF
00ACFF00D8FF00FFFA00FFCD00FFA100FF7700FF5000FF2B00FF0B10FF0027FF0039FF00
45FF004BFF004BFF0045FF0038FF0026FF000EFF0000FF0E00FF3000FF5600FF8100FFAE
00FFDF00EEFF00BAFF0086FF0052FF001EFF1200FF4200FF
00FF4200FF7100FFA300FFD600F5FF00C1FF008DFF005AFF002AFF0400FF2F00FF5600FF
7900FF9700FFB000FFC300FFD100FFD800FFD900FFD500FFCA00FFB900FFA300FF8800FF
6800FF4500FF1E00FF000BFF0037FF0063FF0090FF00BDFF00E8FF00FFEE00FFC900FFA6
00FF8900FF7000FF5C00FF4F00FF4700FF4600FF4A00FF5500FF6500FF7A00FF9500FFB3
00FFD400FFF800E2FF00BCFF0097FF0074FF0053FF0035FF001CFF0007FF0700FF1000FF
1200FF0F00FF0600FF0008FF001CFF0034FF0050FF006DFF008BFF00A9FF00C6FF00DFFF
00F5FF00FFF900FFEE00FFE900FFEA00FFF100FFFE00F0FF00DBFF00C4FF00ADFF0097FF
0084FF0076FF006EFF006CFF0070FF0079FF0087FF0097FF00A7FF00B4FF00BBFF00BBFF
00B5FF00ACFF00A4FF00A3FF00A8FF00A9FF00A2FF0098FF0091FF0090FF0096FF00A2FF
00B1FF00C1FF00D0FF00DBFF00E0FF00DFFF00D8FF00CAFF00B8FF00A3FF008CFF0075FF
0060FF004EFF0040FF0037FF0035FF0039FF0043FF0053FF0068FF0081FF009DFF00BAFF
00D9FF00F7FF00FFED00FFD400FFBF00FFAF00FFA500FFA000FFA200FFA900FFB700FFCB
00FFE300FFFF00DFFF00BCFF0097FF0071FF004CFF0028FF0006FF1800FF3300FF4A00FF
5B00FF6700FF6C00FF6C00FF6600FF5900FF4700FF2F00FF1200FF000EFF0033FF005CFF
0086FF00B3FF00E0FF00FFF300FFC700FF9D00FF7500FF5100FF3000FF1402FF0014FF00
20FF0026FF0026FF001FFF0013FF0001FF0000FF1600FF3300FF5500FF7C00FFA600FFD4
00FBFF00C8FF0095FF0060FF002CFF0600FF3800FF6700FF
00FF6600FF9500FFC700FFFA00D1FF009DFF0069FF0036FF0006FF2800FF5300FF7A00FF
9D00FFBB00FFD400FFE700FFF500FFFC00FFFE00FFF900FFEE00FFDD00FFC700FFAC00FF
8C00FF6900FF4200FF1800FF0013FF003FFF006CFF0099FF00C4FF00ECFF00FFED00FFCB
00FFAD00FF9400FF8100FF7300FF6B00FF6A00FF6E00FF7900FF8900FF9F00FFB900FFD7
00FFF800E3FF00BEFF0098FF0073FF004FFF002EFF0011FF0800FF1C00FF2B00FF3400FF
3700FF3300FF2A00FF1B00FF0700FF0010FF002BFF0049FF0067FF0085FF00A2FF00BBFF
00D1FF00E2FF00EDFF00F2FF00F1FF00EAFF00DDFF00CCFF00B7FF00A0FF0089FF0073FF
0060FF0052FF004AFF0047FF004BFF0055FF0063FF0073FF0083FF008FFF0097FF0097FF
0091FF0088FF0080FF007FFF0084FF0085FF007EFF0074FF006DFF006CFF0072FF007EFF
008DFF009DFF00ACFF00B6FF00BCFF00BBFF00B3FF00A6FF0094FF007FFF0068FF0051FF
003CFF0029FF001CFF0013FF0011FF0015FF001FFF002FFF0043FF005CFF0078FF0096FF
00B5FF00D2FF00EEFF00FFF800FFE300FFD300FFC900FFC400FFC600FFCE00FFDB00FFEF
00F8FF00DBFF00BBFF0097FF0073FF004DFF0028FF0003FF1E00FF3C00FF5700FF6E00FF
7F00FF8B00FF9100FF9000FF8A00FF7D00FF6B00FF5300FF3600FF1500FF000FFF0038FF
0062FF008EFF00BBFF00E8FF00FFEB00FFC100FF9900FF7500FF5400FF3800FF2100FF0F
00FF0401FF0001FF0000FF0400FF1000FF2200FF3A00FF5700FF7900FFA000FFCA00FFF8
00D7FF00A4FF0071FF003CFF0008FF2A00FF5C00FF8C00FF
00FF8800FFB700FFE900E3FF00AFFF007BFF0047FF0014FF1B00FF4A00FF7500FF9C00FF
BF00FFDD00FFF600FFFF00F6FF00E8FF00E1FF00E0FF00E4FF00EFFF00FFE900FFCE00FF
AE00FF8B00FF6400FF3A00FF0E00FF001DFF004AFF0077FF00A2FF00CAFF00F0FF00FFED
00FFCF00FFB600FFA200FF9500FF8D00FF8C00FF9000FF9B00FFAB00FFC000FFDB00FFF9
00E5FF00C1FF009CFF0076FF0051FF002DFF000CFF1000FF2A00FF3E00FF4D00FF5600FF
5800FF5500FF4C00FF3D00FF2900FF1100FF0009FF0027FF0045FF0063FF0080FF0099FF
00AFFF00C0FF00CBFF00D0FF00CFFF00C8FF00BBFF00AAFF0095FF007EFF0067FF0051FF
003EFF0030FF0028FF0025FF002AFF0033FF0041FF0051FF0061FF006EFF0075FF0075FF
006FFF0066FF005EFF005DFF0062FF0063FF005CFF0052FF004BFF004AFF0050FF005CFF
006BFF007BFF008AFF0094FF009AFF0099FF0091FF0084FF0072FF005DFF0046FF002FFF
001AFF0007FF0500FF0E00FF1000FF0C00FF0200FF000DFF0022FF003AFF0056FF0074FF
0093FF00B0FF00CCFF00E5FF00FAFF00FFF500FFEB00FFE600FFE800FFF000FFFD00EEFF
00D6FF00B9FF0099FF0076FF0051FF002BFF0006FF1E00FF3F00FF5E00FF7900FF9000FF
A100FFAD00FFB200FFB200FFAC00FF9F00FF8D00FF7500FF5800FF3700FF1200FF0016FF
0040FF006DFF0099FF00C6FF00F2FF00FFE300FFBB00FF9700FF7600FF5A00FF4300FF31
00FF2500FF1F00FF2000FF2600FF3200FF4400FF5C00FF7900FF9B00FFC200FFEC00E5FF
00B5FF0082FF004FFF001AFF1900FF4C00FF7E00FFAD00FF
00FFA700FFD600F8FF00C4FF0090FF005CFF0028FF0900FF3A00FF6900FF9400FFBB00FF
DE00FFFC00FFFF00EAFF00D7FF00C9FF00C2FF00C1FF00C5FF00D0FF00E1FF00F7ED00FF
CD00FFAA00FF8300FF5900FF2D00FF0100FF002BFF0058FF0083FF00ACFF00D1FF00F4FF
00FFEE00FFD500FFC100FFB400FFAC00FFAA00FFAF00FFBA00FFCA00FFDF00FFF900E7FF
00C6FF00A2FF007DFF0057FF0032FF000FFF1100FF2F00FF4800FF5D00FF6C00FF7500FF
7700FF7400FF6B00FF5C00FF4800FF3000FF1400FF0008FF0026FF0044FF0061FF007BFF
0090FF00A1FF00ACFF00B1FF00B0FF00A9FF009CFF008BFF0076FF005FFF0048FF0032FF
0020FF0011FF0009FF0007FF000BFF0014FF0022FF0032FF0042FF004FFF0056FF0056FF
0050FF0047FF003FFF003EFF0043FF0044FF003DFF0033FF002CFF002BFF0031FF003DFF
004CFF005CFF006BFF0076FF007BFF007AFF0073FF0065FF0053FF003EFF0027FF0010FF
0400FF1600FF2400FF2C00FF2F00FF2B00FF2100FF1100FF0003FF001CFF0038FF0055FF
0074FF0092FF00ADFF00C6FF00DBFF00EBFF00F5FF00FAFF00F8FF00F1FF00E3FF00D0FF
00B7FF009AFF007AFF0057FF0032FF000CFF1800FF3C00FF5E00FF7D00FF9800FFAF00FF
C000FFCC00FFD100FFD100FFCA00FFBE00FFAC00FF9400FF7700FF5600FF3000FF0800FF
0021FF004EFF007BFF00A7FF00D3FF00FDFF00FFDA00FFB600FF9500FF7900FF6200FF50
00FF4400FF3E00FF3E00FF4500FF5100FF6300FF7B00FF9800FFBA00FFE100F4FF00C6FF
0096FF0064FF0030FF0300FF3800FF6B00FF9D00FFCC00FF
00FFC200FFF100DDFF00A9FF0075FF0041FF000DFF2400FF5500FF8400FFAF00FFD600FF
F900FFFF00E8FF00CFFF00BCFF00AEFF00A7FF00A6FF00AAFF00B5FF00C6FF00DCFF00F7
E800FFC500FF9E00FF7400FF4800FF1C00FF0010FF003DFF0068FF0091FF00B6FF00D9FF
00F6FF00FFF000FFDC00FFCF00FFC700FFC500FFCA00FFD500FFE500FFFA00EBFF00CCFF
00ABFF0087FF0062FF003CFF0017FF0B00FF2C00FF4A00FF6300FF7800FF8700FF9000FF
9200FF8F00FF8600FF7700FF6300FF4B00FF2F00FF1200FF000BFF0029FF0046FF0060FF
0075FF0086FF0091FF0096FF0095FF008EFF0081FF0070FF005BFF0044FF002DFF0017FF
0005FF0900FF1100FF1300FF0F00FF0600FF0007FF0017FF0027FF0034FF003BFF003BFF
0035FF002CFF0024FF0023FF0028FF0029FF0022FF0018FF0011FF0010FF0016FF0022FF
0031FF0041FF0050FF005BFF0060FF005FFF0058FF004AFF0038FF0023FF000CFF0A00FF
1F00FF3100FF3F00FF4700FF4A00FF4600FF3C00FF2C00FF1700FF0001FF001DFF003AFF
0059FF0077FF0092FF00ABFF00C0FF00D0FF00DAFF00DFFF00DDFF00D6FF00C8FF00B5FF
009CFF007FFF005FFF003CFF0017FF0E00FF3300FF5700FF7900FF9800FFB300FFCA00FF
DB00FFE700FFEC00FFEC00FFE500FFD900FFC700FFAF00FF9200FF7100FF4B00FF2300FF
0006FF0033FF0060FF008CFF00B8FF00E2FF00FFF500FFD100FFB000FF9400FF7D00FF6B
00FF5F00FF5900FF5900FF6000FF6C00FF7E00FF9600FFB300FFD500FFFC00D9FF00ABFF
007BFF0049FF0015FF1E00FF5300FF8600FFB800FFE700FF
00FFD800F8FF00C6FF0093FF005FFF002BFF0800FF3B00FF6C00FF9A00FFC500FFEC00FF
FF00F0FF00D1FF00B9FF00A5FF0098FF0091FF008FFF0094FF009FFF00AFFF00C6FF00E1
FF00FFDB00FFB400FF8A00FF5F00FF3200FF0500FF0026FF0051FF007AFF00A0FF00C2FF
00E0FF00F9FF00FFF300FFE500FFDD00FFDC00FFE000FFEB00FFFB00EEFF00D4FF00B6FF
0095FF0071FF004CFF0026FF0001FF2200FF4300FF6000FF7A00FF8E00FF9D00FFA600FF
A900FFA500FF9C00FF8D00FF7900FF6100FF4600FF2800FF0A00FF0013FF0030FF0049FF
005FFF0070FF007BFF0080FF007FFF0078FF006BFF0059FF0045FF002EFF0017FF0001FF
1100FF1F00FF2800FF2A00FF2600FF1C00FF0E00FF0001FF0011FF001DFF0024FF0025FF
001FFF0015FF000DFF000DFF0011FF0012FF000BFF0002FF0400FF0500FF0000FF000CFF
001BFF002BFF003AFF0044FF0049FF0049FF0041FF0034FF0022FF000DFF0900FF2000FF
3600FF4800FF5600FF5E00FF6000FF5C00FF5200FF4300FF2E00FF1500FF0006FF0024FF
0042FF0060FF007CFF0095FF00AAFF00BAFF00C4FF00C9FF00C7FF00BFFF00B1FF009EFF
0086FF0069FF0048FF0025FF0000FF2400FF4A00FF6E00FF9000FFAF00FFCA00FFE000FF
F100FFFD00FFFF00FCFF00FDFC00FFEF00FFDD00FFC500FFA800FF8700FF6200FF3A00FF
0F00FF001CFF0049FF0076FF00A2FF00CCFF00F4FF00FFE700FFC600FFAA00FF9300FF82
00FF7600FF7000FF7000FF7600FF8200FF9400FFAC00FFC900FFEB00EDFF00C3FF0095FF
0065FF0032FF0100FF3500FF6900FF9C00FFCE00FFFE00FF
00FFEA00E6FF00B5FF0082FF004EFF0019FF1900FF4C00FF7D00FFAB00FFD600FFFE00FF
FF00DEFF00C0FF00A7FF0094FF0087FF007FFF007EFF0083FF008EFF009EFF00B4FF00CF
FF00EFEC00FFC500FF9C00FF7000FF4300FF1600FF0015FF0040FF0069FF008FFF00B1FF
00CFFF00E8FF00FBFF00FFF600FFEF00FFED00FFF200FFFC00F2FF00DDFF00C3FF00A5FF
0083FF0060FF003AFF0015FF1000FF3300FF5400FF7200FF8B00FF9F00FFAE00FFB700FF
BA00FFB700FFAD00FF9E00FF8A00FF7200FF5700FF3A00FF1B00FF0002FF001EFF0038FF
004EFF005EFF006AFF006FFF006EFF0066FF005AFF0048FF0033FF001DFF0005FF0F00FF
2200FF3000FF3900FF3B00FF3700FF2D00FF1F00FF0F00FF0000FF000CFF0013FF0014FF
000EFF0004FF0300FF0400FF0000FF0001FF0500FF0F00FF1600FF1600FF1000FF0500FF
000AFF001AFF0028FF0033FF0038FF0037FF0030FF0023FF0011FF0400FF1B00FF3200FF
4700FF5900FF6700FF6F00FF7200FF6E00FF6400FF5400FF3F00FF2600FF0A00FF0013FF
0031FF004FFF006BFF0084FF0098FF00A8FF00B3FF00B7FF00B6FF00AEFF00A0FF008DFF
0074FF0058FF0037FF0014FF1000FF3600FF5B00FF7F00FFA100FFC000FFDB00FFF100FF
FF00FCFF00F1FF00EBFF00EBFF00F2FF00FEEE00FFD600FFBA00FF9800FF7300FF4B00FF
2000FF000BFF0038FF0065FF0091FF00BBFF00E2FF00FFF800FFD800FFBC00FFA500FF93
00FF8700FF8100FF8100FF8700FF9400FFA600FFBE00FFDB00FFFD00DCFF00B1FF0084FF
0053FF0021FF1200FF4600FF7A00FFAE00FFDF00FFFF00F0
00FFF500DBFF00A9FF0076FF0042FF000EFF2500FF5800FF8900FFB700FFE200FFFF00F6
FF00D3FF00B5FF009CFF0088FF007BFF0074FF0072FF0077FF0082FF0093FF00A9FF00C4
FF00E3F800FFD100FFA700FF7C00FF4F00FF2200FF0009FF0034FF005DFF0083FF00A5FF
00C3FF00DCFF00EFFF00FDFF00FFFA00FFF900FFFD00F7FF00E7FF00D1FF00B7FF0099FF
0078FF0054FF002FFF0009FF1B00FF3F00FF6000FF7D00FF9700FFAB00FFBA00FFC300FF
C600FFC200FFB900FFAA00FF9600FF7E00FF6300FF4500FF2700FF0900FF0013FF002CFF
0042FF0053FF005EFF0063FF0062FF005BFF004EFF003DFF0028FF0011FF0500FF1B00FF
2E00FF3C00FF4500FF4700FF4300FF3900FF2B00FF1B00FF0B00FF0000FF0008FF0008FF
0002FF0600FF0F00FF0F00FF0B00FF0A00FF1100FF1A00FF2100FF2200FF1C00FF1000FF
0100FF000EFF001DFF0027FF002DFF002CFF0024FF0017FF0005FF0F00FF2600FF3D00FF
5300FF6500FF7200FF7B00FF7D00FF7900FF6F00FF6000FF4B00FF3200FF1600FF0007FF
0026FF0043FF005FFF0078FF008DFF009DFF00A7FF00ACFF00AAFF00A2FF0095FF0081FF
0069FF004CFF002BFF0008FF1C00FF4100FF6700FF8B00FFAD00FFCC00FFE700FFFD00FF
FF00F1FF00E5FF00DFFF00E0FF00E6FF00F3FA00FFE200FFC500FFA400FF7F00FF5700FF
2C00FF0000FF002CFF0059FF0085FF00AFFF00D7FF00FBFF00FFE300FFC700FFB000FF9F
00FF9300FF8D00FF8D00FF9300FF9F00FFB100FFC900FFE600F7FF00D0FF00A6FF0078FF
0048FF0015FF1E00FF5200FF8600FFB900FFEB00FFFF00E4
00FFFB00D5FF00A3FF0070FF003CFF0008FF2B00FF5E00FF8E00FFBD00FFE800FFFF00F0
FF00CDFF00AFFF0096FF0083FF0075FF006EFF006DFF0071FF007CFF008DFF00A3FF00BE
FF00DEFE00FFD700FFAD00FF8100FF5500FF2800FF0004FF002FFF0058FF007DFF009FFF
00BDFF00D6FF00EAFF00F7FF00FFFF00FFFF00FCFF00F1FF00E1FF00CCFF00B1FF0093FF
0072FF004EFF0029FF0003FF2100FF4500FF6600FF8300FF9D00FFB100FFC000FFC900FF
CB00FFC800FFBF00FFB000FF9C00FF8400FF6900FF4B00FF2D00FF0F00FF000DFF0026FF
003CFF004DFF0058FF005DFF005CFF0055FF0048FF0037FF0022FF000BFF0B00FF2100FF
3400FF4200FF4A00FF4D00FF4800FF3F00FF3100FF2100FF1100FF0400FF0002FF0002FF
0300FF0C00FF1400FF1500FF1000FF0F00FF1600FF2000FF2700FF2800FF2200FF1600FF
0700FF0008FF0017FF0022FF0027FF0026FF001EFF0011FF0000FF1500FF2C00FF4300FF
5800FF6B00FF7800FF8100FF8300FF7F00FF7500FF6500FF5000FF3700FF1C00FF0001FF
0020FF003DFF0059FF0072FF0087FF0097FF00A1FF00A6FF00A4FF009CFF008FFF007BFF
0063FF0046FF0026FF0003FF2100FF4700FF6C00FF9100FFB200FFD100FFEC00FFFF00FC
FF00EBFF00DFFF00DAFF00DAFF00E0FF00EDFF00FFE800FFCB00FFAA00FF8500FF5C00FF
3200FF0500FF0026FF0053FF007FFF00A9FF00D1FF00F5FF00FFE900FFCD00FFB600FFA4
00FF9800FF9200FF9300FF9900FFA500FFB700FFCF00FFEC00F1FF00CAFF00A0FF0072FF
0042FF000FFF2300FF5800FF8C00FFBF00FFF100FFFF00DF
00FFFB00D5FF00A4FF0071FF003DFF0008FF2B00FF5D00FF8E00FFBC00FFE700FFFF00F0
FF00CDFF00AFFF0096FF0083FF0076FF006EFF006DFF0072FF007DFF008DFF00A3FF00BE
FF00DEFD00FFD600FFAD00FF8100FF5400FF2700FF0004FF002FFF0058FF007EFF00A0FF
00BEFF00D6FF00EAFF00F8FF00FFFF00FFFE00FCFF00F2FF00E1FF00CCFF00B2FF0094FF
0072FF004EFF0029FF0004FF2100FF4400FF6500FF8300FF9C00FFB100FFBF00FFC800FF
CB00FFC800FFBE00FFAF00FF9C00FF8300FF6800FF4B00FF2C00FF0E00FF000DFF0027FF
003CFF004DFF0058FF005EFF005CFF0055FF0048FF0037FF0022FF000BFF0B00FF2100FF
3300FF4100FF4A00FF4C00FF4800FF3E00FF3000FF2000FF1100FF0400FF0002FF0003FF
0200FF0C00FF1400FF1500FF1000FF0F00FF1600FF2000FF2700FF2800FF2200FF1600FF
0700FF0009FF0017FF0022FF0027FF0026FF001FFF0012FF0000FF1500FF2C00FF4300FF
5800FF6A00FF7800FF8000FF8300FF7F00FF7500FF6500FF5000FF3700FF1B00FF0002FF
0020FF003EFF005AFF0072FF0087FF0097FF00A2FF00A6FF00A5FF009DFF008FFF007CFF
0063FF0046FF0026FF0003FF2100FF4700FF6C00FF9000FFB200FFD100FFEC00FFFF00FD
FF00EBFF00E0FF00DAFF00DAFF00E1FF00EDFF00FFE800FFCB00FFA900FF8400FF5C00FF
3100FF0500FF0027FF0054FF007FFF00AAFF00D1FF00F6FF00FFE900FFCD00FFB600FFA4
00FF9800FF9200FF9200FF9800FFA500FFB700FFCF00FFEC00F1FF00CBFF00A0FF0073FF
0042FF0010FF2300FF5700FF8B00FFBF00FFF100FFFF00DF
00FFF400DCFF00AAFF0077FF0043FF000FFF2400FF5700FF8800FFB600FFE100FFFF00F7
FF00D4FF00B6FF009DFF0089FF007CFF0075FF0073FF0078FF0083FF0094FF00AAFF00C5
FF00E4F700FFD000FFA600FF7B00FF4E00FF2100FF000AFF0036FF005EFF0084FF00A6FF
00C4FF00DDFF00F0FF00FEFF00FFF900FFF800FFFC00F8FF00E8FF00D2FF00B8FF009AFF
0079FF0055FF0030FF000AFF1A00FF3E00FF5F00FF7C00FF9600FFAA00FFB900FFC200FF
C500FFC100FFB800FFA900FF9500FF7D00FF6200FF4400FF2600FF0800FF0014FF002DFF
0043FF0054FF005FFF0064FF0063FF005CFF004FFF003EFF0029FF0012FF0400FF1A00FF
2D00FF3B00FF4400FF4600FF4200FF3800FF2A00FF1A00FF0A00FF0001FF0009FF0009FF
0003FF0500FF0D00FF0E00FF0A00FF0900FF1000FF1900FF2000FF2100FF1B00FF0F00FF
0000FF000FFF001EFF0028FF002EFF002DFF0025FF0018FF0006FF0E00FF2500FF3C00FF
5200FF6400FF7100FF7A00FF7C00FF7800FF6E00FF5E00FF4A00FF3100FF1500FF0008FF
0027FF0044FF0060FF0079FF008EFF009EFF00A8FF00ADFF00ABFF00A3FF0096FF0082FF
006AFF004DFF002DFF0009FF1B00FF4000FF6600FF8A00FFAC00FFCA00FFE500FFFC00FF
FF00F2FF00E6FF00E0FF00E1FF00E7FF00F4F900FFE100FFC400FFA300FF7E00FF5600FF
2B00FF0000FF002DFF005AFF0086FF00B0FF00D8FF00FCFF00FFE200FFC600FFAF00FF9E
00FF9200FF8C00FF8C00FF9200FF9E00FFB000FFC800FFE500F8FF00D1FF00A7FF0079FF
0049FF0016FF1C00FF5100FF8500FFB800FFEA00FFFF00E5
00FFE800E8FF00B7FF0084FF0050FF001BFF1800FF4A00FF7B00FFA900FFD400FFFC00FF
FF00E0FF00C2FF00A9FF0096FF0089FF0081FF0080FF0085FF008FFF00A0FF00B6FF00D1
FF00F1EA00FFC300FF9A00FF6E00FF4100FF1400FF0017FF0042FF006BFF0091FF00B3FF
00D1FF00E9FF00FDFF00FFF400FFED00FFEB00FFF000FFFA00F4FF00DFFF00C5FF00A7FF
0085FF0061FF003CFF0016FF0E00FF3100FF5200FF7000FF8900FF9E00FFAC00FFB500FF
B800FFB500FFAB00FF9C00FF8900FF7100FF5500FF3800FF1900FF0004FF0020FF003AFF
004FFF0060FF006BFF0071FF006FFF0068FF005BFF004AFF0035FF001EFF0007FF0E00FF
2000FF2E00FF3700FF3900FF3500FF2B00FF1D00FF0D00FF0001FF000EFF0015FF0016FF
0010FF0006FF0100FF0200FF0002FF0003FF0300FF0D00FF1400FF1500FF0F00FF0300FF
000BFF001CFF002AFF0035FF003AFF0039FF0032FF0025FF0013FF0200FF1900FF3000FF
4500FF5700FF6500FF6D00FF7000FF6C00FF6200FF5200FF3D00FF2400FF0800FF0015FF
0033FF0051FF006DFF0085FF009AFF00AAFF00B5FF00B9FF00B8FF00B0FF00A2FF008FFF
0076FF0059FF0039FF0016FF0E00FF3400FF5900FF7D00FF9F00FFBE00FFD900FFEF00FF
FF00FEFF00F3FF00EDFF00EDFF00F4FF00FFEC00FFD500FFB800FF9600FF7100FF4900FF
1E00FF000DFF003AFF0067FF0092FF00BDFF00E4FF00FFF600FFD600FFBA00FFA300FF91
00FF8500FF7F00FF7F00FF8500FF9200FFA400FFBC00FFD900FFFB00DEFF00B3FF0086FF
0055FF0023FF1000FF4400FF7800FFAC00FFDE00FFFF00F2
00FFD500FBFF00C9FF0096FF0062FF002EFF0500FF3800FF6900FF9700FFC200FFE900FF
FF00F3FF00D4FF00BCFF00A8FF009BFF0093FF0092FF0097FF00A2FF00B2FF00C8FF00E4
FC00FFD800FFB100FF8700FF5C00FF2F00FF0200FF0029FF0054FF007DFF00A3FF00C5FF
00E3FF00FCFF00FFF000FFE200FFDA00FFD900FFDE00FFE800FFF800F1FF00D7FF00B9FF
0098FF0074FF004FFF0029FF0004FF1F00FF4000FF5D00FF7700FF8B00FF9A00FFA300FF
A600FFA200FF9900FF8A00FF7600FF5E00FF4300FF2500FF0700FF0016FF0032FF004CFF
0062FF0073FF007EFF0083FF0082FF007BFF006EFF005CFF0048FF0031FF001AFF0004FF
0E00FF1C00FF2500FF2700FF2300FF1900FF0B00FF0004FF0014FF0020FF0027FF0028FF
0022FF0018FF0010FF0010FF0014FF0015FF000EFF0005FF0100FF0200FF0003FF000EFF
001EFF002EFF003CFF0047FF004CFF004BFF0044FF0037FF0025FF0010FF0600FF1D00FF
3300FF4500FF5300FF5B00FF5D00FF5900FF4F00FF4000FF2B00FF1200FF0009FF0027FF
0045FF0063FF007FFF0098FF00ADFF00BCFF00C7FF00CBFF00CAFF00C2FF00B4FF00A1FF
0089FF006CFF004BFF0028FF0003FF2100FF4700FF6B00FF8D00FFAC00FFC700FFDD00FF
EE00FFFA00FFFF00FFFF00FFF900FFEC00FFDA00FFC200FFA500FF8400FF5F00FF3700FF
0C00FF001FFF004CFF0079FF00A5FF00CFFF00F7FF00FFE400FFC400FFA700FF9000FF7F
00FF7300FF6D00FF6D00FF7300FF7F00FF9200FFA900FFC600FFE900F0FF00C6FF0098FF
0067FF0035FF0001FF3200FF6600FF9900FFCB00FFFB00FF
00FFBE00FFED00E1FF00AEFF007AFF0045FF0012FF2000FF5100FF7F00FFAA00FFD200FF
F500FFFF00ECFF00D3FF00C0FF00B3FF00ABFF00AAFF00AFFF00BAFF00CAFF00E0FF00FB
E400FFC000FF9900FF6F00FF4400FF1700FF0015FF0041FF006CFF0095FF00BBFF00DDFF
00FBFF00FFEB00FFD800FFCA00FFC300FFC100FFC600FFD000FFE000FFF600EFFF00D1FF
00AFFF008CFF0066FF0041FF001CFF0700FF2800FF4600FF5F00FF7300FF8200FF8B00FF
8E00FF8B00FF8100FF7200FF5E00FF4600FF2B00FF0E00FF0010FF002EFF004AFF0064FF
007AFF008AFF0096FF009BFF009AFF0092FF0086FF0074FF005FFF0049FF0031FF001CFF
0009FF0400FF0D00FF0F00FF0B00FF0100FF000CFF001CFF002BFF0038FF003FFF0040FF
003AFF0030FF0028FF0027FF002CFF002DFF0026FF001CFF0016FF0015FF001BFF0026FF
0036FF0046FF0054FF005FFF0064FF0063FF005CFF004FFF003DFF0027FF0010FF0600FF
1B00FF2D00FF3B00FF4300FF4500FF4200FF3800FF2800FF1300FF0005FF0021FF003FFF
005DFF007BFF0097FF00B0FF00C4FF00D4FF00DFFF00E3FF00E2FF00DAFF00CCFF00B9FF
00A0FF0084FF0063FF0040FF001BFF0900FF2F00FF5300FF7500FF9400FFAF00FFC500FF
D600FFE200FFE800FFE800FFE100FFD500FFC200FFAA00FF8E00FF6C00FF4700FF1F00FF
000BFF0037FF0064FF0091FF00BDFF00E7FF00FFF100FFCC00FFAC00FF9000FF7900FF67
00FF5B00FF5500FF5500FF5B00FF6800FF7A00FF9100FFAF00FFD100FFF700DDFF00B0FF
007FFF004DFF0019FF1A00FF4E00FF8200FFB300FFE300FF
00FFA100FFD000FEFF00CBFF0097FF0062FF002EFF0300FF3400FF6200FF8D00FFB500FF
D800FFF600FFFF00F0FF00DDFF00D0FF00C8FF00C7FF00CCFF00D7FF00E7FF00FDE700FF
C700FFA300FF7C00FF5300FF2700FF0005FF0032FF005EFF0089FF00B2FF00D8FF00FAFF
00FFE700FFCF00FFBB00FFAD00FFA600FFA400FFA900FFB300FFC400FFD900FFF300EEFF
00CCFF00A8FF0083FF005EFF0038FF0015FF0B00FF2900FF4200FF5700FF6500FF6E00FF
7100FF6E00FF6400FF5500FF4200FF2900FF0E00FF000EFF002DFF004BFF0067FF0081FF
0096FF00A7FF00B2FF00B8FF00B6FF00AFFF00A2FF0091FF007CFF0065FF004EFF0038FF
0026FF0018FF000FFF000DFF0011FF001BFF0029FF0039FF0048FF0055FF005CFF005DFF
0057FF004DFF0045FF0044FF0049FF004AFF0043FF0039FF0032FF0031FF0037FF0043FF
0052FF0063FF0071FF007CFF0081FF0080FF0079FF006CFF005AFF0044FF002DFF0016FF
0001FF1000FF1E00FF2600FF2900FF2500FF1B00FF0B00FF0009FF0022FF003EFF005CFF
007AFF0098FF00B4FF00CCFF00E1FF00F1FF00FCFF00FFFF00FFFF00F7FF00E9FF00D6FF
00BDFF00A0FF0080FF005DFF0038FF0012FF1200FF3600FF5800FF7700FF9200FFA800FF
BA00FFC500FFCB00FFCB00FFC400FFB800FFA500FF8E00FF7100FF4F00FF2A00FF0200FF
0028FF0054FF0081FF00AEFF00DAFF00FFFB00FFD400FFAF00FF8F00FF7300FF5C00FF4A
00FF3E00FF3800FF3800FF3E00FF4B00FF5D00FF7500FF9200FFB400FFDA00FAFF00CDFF
009CFF006AFF0036FF0002FF3100FF6500FF9700FFC600FF
00FF7F00FFAE00FFE000ECFF00B8FF0084FF0050FF001DFF1300FF4100FF6C00FF9300FF
B600FFD500FFED00FFFF00FEFF00F1FF00E9FF00E8FF00EDFF00F8F700FFE100FFC500FF
A600FF8200FF5B00FF3100FF0600FF0026FF0053FF007FFF00AAFF00D3FF00F9FF00FFE4
00FFC600FFAD00FF9A00FF8C00FF8400FF8300FF8800FF9200FFA200FFB800FFD200FFF0
00EEFF00CAFF00A5FF007FFF005AFF0036FF0015FF0700FF2100FF3500FF4400FF4D00FF
5000FF4C00FF4300FF3400FF2000FF0800FF0012FF0030FF004EFF006CFF0088FF00A2FF
00B8FF00C9FF00D4FF00D9FF00D8FF00D1FF00C4FF00B2FF009EFF0087FF0070FF005AFF
0047FF0039FF0030FF002EFF0032FF003CFF004AFF005AFF006AFF0076FF007DFF007EFF
0078FF006EFF0066FF0066FF006AFF006BFF0064FF005BFF0054FF0053FF0059FF0064FF
0074FF0084FF0093FF009DFF00A2FF00A1FF009AFF008DFF007BFF0066FF004FFF0038FF
0022FF0010FF0002FF0500FF0700FF0300FF0006FF0015FF002AFF0043FF005FFF007DFF
009BFF00B9FF00D5FF00EEFF00FFFC00FFED00FFE200FFDE00FFDF00FFE700FFF500F7FF
00DFFF00C2FF00A1FF007EFF0059FF0034FF000EFF1500FF3700FF5600FF7100FF8700FF
9800FFA400FFAA00FFA900FFA300FF9600FF8400FF6C00FF4F00FF2E00FF0900FF001EFF
0049FF0075FF00A2FF00CFFF00FBFF00FFDA00FFB200FF8E00FF6E00FF5100FF3A00FF29
00FF1D00FF1700FF1700FF1D00FF2900FF3B00FF5300FF7000FF9300FFB900FFE300EEFF
00BDFF008BFF0057FF0023FF1000FF4300FF7500FFA500FF
00FF5A00FF8900FFBB00FFEE00DDFF00A9FF0075FF0042FF0011FF1C00FF4700FF6E00FF
9100FFAF00FFC800FFDC00FFE900FFF000FFF200FFED00FFE200FFD100FFBB00FFA000FF
8100FF5D00FF3600FF0C00FF001EFF004BFF0078FF00A5FF00D0FF00F8FF00FFE100FFBF
00FFA100FF8800FF7500FF6700FF5F00FF5E00FF6200FF6D00FF7D00FF9300FFAD00FFCB
00FFEC00EFFF00CAFF00A4FF007FFF005BFF003AFF001DFF0003FF1000FF1F00FF2800FF
2B00FF2700FF1E00FF0F00FF0004FF001CFF0037FF0055FF0073FF0091FF00AEFF00C7FF
00DDFF00EEFF00F9FF00FEFF00FDFF00F6FF00E9FF00D8FF00C3FF00ACFF0095FF007FFF
006CFF005EFF0056FF0053FF0057FF0061FF006FFF007FFF008FFF009BFF00A3FF00A3FF
009DFF0094FF008CFF008BFF008FFF0091FF0089FF0080FF0079FF0078FF007EFF008AFF
0099FF00A9FF00B8FF00C2FF00C8FF00C7FF00BFFF00B2FF00A0FF008BFF0074FF005DFF
0047FF0035FF0028FF001FFF001DFF0021FF002BFF003BFF004FFF0068FF0084FF00A2FF
00C1FF00DEFF00FAFF00FFEC00FFD700FFC700FFBD00FFB800FFBA00FFC200FFCF00FFE3
00FFFB00E7FF00C7FF00A3FF007EFF0059FF0033FF000FFF1200FF3000FF4B00FF6200FF
7300FF7F00FF8500FF8400FF7E00FF7100FF5F00FF4700FF2A00FF0900FF001BFF0044FF
006EFF009AFF00C7FF00F4FF00FFDF00FFB500FF8D00FF6900FF4800FF2C00FF1500FF04
07FF000DFF000DFF0007FF0000FF0400FF1600FF2E00FF4B00FF6D00FF9400FFBE00FFEC
00E3FF00B0FF007DFF0048FF0014FF1E00FF5000FF8000FF
00FF3200FF6100FF9200FFC600FFFA00D1FF009DFF006BFF003AFF000BFF1F00FF4600FF
6900FF8700FFA000FFB300FFC100FFC800FFC900FFC500FFBA00FFA900FF9300FF7800FF
5800FF3500FF0E00FF001BFF0047FF0073FF00A0FF00CDFF00F8FF00FFDE00FFB900FF96
00FF7900FF6000FF4C00FF3F00FF3700FF3600FF3A00FF4500FF5500FF6A00FF8400FFA3
00FFC400FFE800F2FF00CCFF00A7FF0084FF0063FF0045FF002CFF0017FF0008FF0000FF
0200FF0000FF0009FF0018FF002CFF0044FF0060FF007DFF009BFF00B9FF00D6FF00F0FF
00FFFA00FFE900FFDE00FFD900FFDA00FFE100FFEE00FFFF00EBFF00D4FF00BDFF00A7FF
0095FF0086FF007EFF007CFF0080FF0089FF0097FF00A7FF00B7FF00C4FF00CBFF00CBFF
00C5FF00BCFF00B4FF00B3FF00B8FF00B9FF00B2FF00A8FF00A1FF00A0FF00A6FF00B2FF
00C1FF00D1FF00E0FF00EBFF00F0FF00EFFF00E8FF00DAFF00C8FF00B3FF009CFF0085FF
0070FF005EFF0050FF0048FF0045FF0049FF0053FF0063FF0078FF0091FF00ADFF00CAFF
00E9FF00FFF800FFDD00FFC400FFAF00FF9F00FF9500FF9000FF9200FF9900FFA700FFBA
00FFD300FFF000EFFF00CCFF00A7FF0081FF005CFF0038FF0016FF0800FF2300FF3A00FF
4B00FF5700FF5C00FF5C00FF5600FF4900FF3700FF1F00FF0200FF001EFF0044FF006CFF
0096FF00C3FF00F0FF00FFE300FFB700FF8D00FF6500FF4100FF2000FF0412FF0024FF00
30FF0036FF0036FF002FFF0023FF0011FF0000FF0600FF2300FF4500FF6C00FF9600FFC4
00FFF400D9FF00A5FF0071FF003CFF0009FF2800FF5700FF
00FF0700FF3600FF6800FF9B00FFCF00FCFF00C8FF0095FF0064FF0036FF000BFF1B00FF
3E00FF5C00FF7500FF8900FF9600FF9D00FF9F00FF9A00FF8F00FF7E00FF6800FF4D00FF
2E00FF0A00FF001CFF0046FF0071FF009EFF00CBFF00F7FF00FFDD00FFB400FF8E00FF6C
00FF4E00FF3500FF2200FF1400FF0C00FF0B00FF0F00FF1A00FF2A00FF4000FF5A00FF78
00FF9900FFBD00FFE200F7FF00D2FF00AEFF008DFF0070FF0056FF0042FF0033FF002AFF
0027FF002BFF0034FF0043FF0057FF006FFF008AFF00A8FF00C6FF00E4FF00FFFE00FFE5
00FFCF00FFBE00FFB300FFAE00FFAF00FFB600FFC300FFD400FFE900FFFF00E8FF00D2FF
00BFFF00B1FF00A8FF00A6FF00AAFF00B4FF00C2FF00D2FF00E2FF00EEFF00F6FF00F6FF
00F0FF00E7FF00DEFF00DEFF00E2FF00E3FF00DCFF00D3FF00CCFF00CBFF00D1FF00DDFF
00ECFF00FCFF00FFF400FFEA00FFE400FFE500FFED00FFFA00F3FF00DEFF00C7FF00B0FF
009AFF0088FF007BFF0072FF0070FF0074FF007EFF008EFF00A2FF00BBFF00D7FF00F5FF
00FFEB00FFCE00FFB200FF9900FF8400FF7400FF6A00FF6500FF6700FF6F00FF7C00FF90
00FFA800FFC500FFE600F6FF00D1FF00ACFF0086FF0062FF0040FF0021FF0006FF0F00FF
2000FF2C00FF3200FF3100FF2B00FF1E00FF0C00FF000BFF0028FF0049FF006EFF0096FF
00C1FF00EDFF00FFE500FFB800FF8C00FF6200FF3A00FF160AFF0026FF003DFF004EFF00
5AFF0060FF0060FF005AFF004EFF003CFF0024FF0007FF0000FF1A00FF4100FF6B00FF99
00FFC900FFFC00CFFF009BFF0067FF0034FF0002FF2D00FF
24FF0000FF0A00FF3C00FF6F00FFA300FFD700F4FF00C1FF0091FF0062FF0037FF0010FF
1200FF3000FF4900FF5C00FF6A00FF7100FF7200FF6E00FF6300FF5200FF3C00FF2100FF
0100FF0021FF0048FF0072FF009EFF00CAFF00F7FF00FFDB00FFB000FF8800FF6200FF40
00FF2200FF0909FF0017FF001FFF0020FF001CFF0011FF0001FF0000FF1300FF2E00FF4C
00FF6D00FF9100FFB600FFDC00FEFF00DAFF00B9FF009CFF0082FF006EFF005FFF0056FF
0054FF0057FF0060FF006FFF0083FF009BFF00B6FF00D4FF00F2FF00FFEF00FFD200FFB9
00FFA300FF9200FF8700FF8200FF8300FF8A00FF9700FFA800FFBD00FFD400FFEB00FEFF
00EBFF00DDFF00D5FF00D2FF00D7FF00E0FF00EEFF00FEFF00FFF100FFE400FFDD00FFDD
00FFE300FFEC00FFF400FFF500FFF000FFEF00FFF600FFFF00F8FF00F7FF00FDFF00FFF6
00FFE700FFD700FFC800FFBE00FFB800FFB900FFC100FFCE00FFE000FFF500F3FF00DCFF
00C7FF00B4FF00A7FF009EFF009CFF00A0FF00AAFF00BAFF00CFFF00E7FF00FFFC00FFDE
00FFBF00FFA200FF8600FF6D00FF5800FF4800FF3E00FF3900FF3B00FF4300FF5000FF64
00FF7C00FF9900FFB900FFDC00FEFF00D8FF00B3FF008EFF006DFF004EFF0033FF001CFF
000BFF0000FF0500FF0500FF0000FF000DFF001FFF0037FF0054FF0075FF009AFF00C3FF
00EDFF00FFE500FFB900FF8C00FF6000FF3600FF0E15FF0036FF0052FF0069FF007BFF00
87FF008DFF008CFF0086FF007AFF0068FF0050FF0033FF0011FF0000FF1500FF3F00FF6D
00FF9D00FFD000FCFF00C7FF0093FF0060FF002EFF0000FF
51FF0022FF0000FF0F00FF4200FF7600FFAA00FFDE00EEFF00BDFF008FFF0064FF003DFF
001AFF0300FF1C00FF2F00FF3D00FF4400FF4600FF4100FF3600FF2500FF0F00FF000BFF
002AFF004EFF0075FF009FFF00CBFF00F7FF00FFDB00FFAE00FF8300FF5B00FF3500FF13
0AFF0023FF0036FF0044FF004CFF004DFF0049FF003EFF002EFF0018FF0000FF0100FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF800E6FF00C9FF00AFFF009BFF008CFF0083FF
0080FF0084FF008DFF009CFF00B0FF00C8FF00E3FF00FFFE00FFE000FFC200FFA500FF8C
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE700FFF500FFFD00FFFF00FFFC00FFF200FFE400FFD400FFC400FFB800FFB000FFB0
00FFB600FFBF00FFC700FFC800FFC300FFC200FFC900FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9100FF8B00FF8C00FF9400FFA100FFB300FFC800FFDF00FFF6
00F4FF00E1FF00D4FF00CBFF00C9FF00CDFF00D7FF00E7FF00FBFF00FFEB00FFCF00FFB1
00FF9200FF7500FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1600FF2300FF37
00FF4F00FF6C00FF8C00FFB000FFD400FFFA00E0FF00BBFF0099FF007BFF0060FF0049FF
0038FF002CFF0026FF0027FF002DFF003AFF004CFF0064FF0081FF00A2FF00C7FF00F0FF
00FFE500FFB900FF8C00FF5F00FF3300FF091EFF0042FF0063FF007FFF0096FF00A7FF00
B3FF00B9FF00B9FF00B3FF00A7FF0095FF007DFF0060FF003EFF0017FF0000FF1200FF40
00FF7000FFA300FFD600F4FF00C0FF008DFF005BFF002BFF
7EFF004FFF001DFF0000FF1500FF4900FF7D00FFB100FFE400EAFF00BCFF0091FF006AFF
0047FF0028FF0010FF0300FF1000FF1700FF1900FF1400FF0900FF0006FF001DFF0038FF
0057FF007BFF00A2FF00CCFF00F7FF00FFDB00FFAE00FF8200FF5700FF2E00FF0819FF00
37FF0050FF0063FF0071FF0079FF007AFF0076FF006BFF005BFF0045FF002BFF000DFF00
00FF1300FF3700FF5C00FF8200FFA700FFCB00FFEC00F6FF00DCFF00C8FF00B9FF00B0FF
00ADFF00B1FF00BAFF00C9FF00DDFF00F5FF00FFEF00FFD100FFB300FF9500FF7800FF5F
00FF4900FF3800FF2D00FF2800FF2900FF3000FF3D00FF4F00FF6300FF7A00FF9100FFA7
00FFBA00FFC800FFD100FFD300FFCF00FFC500FFB700FFA700FF9700FF8B00FF8400FF83
00FF8900FF9300FF9B00FF9B00FF9700FF9600FF9D00FFA600FFAD00FFAE00FFA800FF9C
00FF8D00FF7D00FF6E00FF6400FF5F00FF5F00FF6700FF7400FF8600FF9B00FFB200FFC9
00FFDF00FFF100FFFF00F8FF00F6FF00FAFF00FFFB00FFEC00FFD700FFBE00FFA200FF84
00FF6600FF4800FF2C00FF1301FF0011FF001BFF0020FF001EFF0016FF0008FF0000FF0A
00FF2200FF3F00FF6000FF8300FFA800FFCD00FFF300E8FF00C6FF00A7FF008CFF0076FF
0065FF0059FF0053FF0054FF005AFF0067FF0079FF0091FF00AEFF00CFFF00F4FF00FFE3
00FFB800FF8C00FF5F00FF3200FF0623FF004BFF006FFF0090FF00ACFF00C3FF00D4FF00
E0FF00E6FF00E6FF00E0FF00D4FF00C2FF00AAFF008DFF006BFF0044FF001AFF0000FF13
00FF4300FF7600FFAA00FFDE00EDFF00BAFF0088FF0058FF
AAFF007AFF0049FF0016FF0000FF1D00FF5100FF8500FFB800FFE900E8FF00BDFF0095FF
0073FF0054FF003BFF0028FF001BFF0013FF0012FF0017FF0022FF0032FF0048FF0063FF
0083FF00A7FF00CEFF00F8FF00FFDC00FFAF00FF8200FF5600FF2B00FF0223FF0045FF00
63FF007CFF008FFF009DFF00A4FF00A6FF00A1FF0097FF0087FF0071FF0057FF0039FF00
17FF0000FF0B00FF3100FF5600FF7B00FF9F00FFC000FFDE00FFF700F4FF00E5FF00DCFF
00D9FF00DDFF00E6FF00F5FF00FFF600FFDE00FFC300FFA500FF8700FF6900FF4D00FF33
00FF1D00FF0C00FF0103FF0002FF0000FF0500FF1100FF2300FF3800FF4E00FF6500FF7B
00FF8E00FF9C00FFA500FFA700FFA300FF9900FF8B00FF7B00FF6B00FF5F00FF5800FF57
00FF5D00FF6700FF6F00FF6F00FF6B00FF6A00FF7100FF7A00FF8100FF8200FF7C00FF71
00FF6100FF5100FF4300FF3800FF3300FF3400FF3B00FF4800FF5A00FF6F00FF8600FF9D
00FFB300FFC500FFD300FFDB00FFDD00FFD900FFCF00FFC000FFAB00FF9200FF7600FF58
00FF3A00FF1C00FF0018FF002CFF003CFF0047FF004BFF004AFF0042FF0034FF0021FF00
09FF0000FF1300FF3400FF5700FF7C00FFA100FFC700FFEB00F2FF00D3FF00B8FF00A2FF
0091FF0085FF007FFF007FFF0086FF0092FF00A5FF00BDFF00DAFF00FBFF00FFDF00FFB7
00FF8C00FF6000FF3300FF0625FF004FFF0077FF009BFF00BBFF00D7FF00EFFF00FFFF00
FFF300FFED00FFED00FFF300FFFF00EDFF00D6FF00B8FF0096FF0070FF0045FF0018FF00
00FF1800FF4A00FF7E00FFB200FFE600E6FF00B4FF0084FF
D4FF00A5FF0073FF0040FF000CFF0000FF2700FF5B00FF8E00FFBF00FFED00E7FF00C0FF
009DFF007FFF0066FF0052FF0045FF003EFF003CFF0041FF004CFF005CFF0073FF008EFF
00ADFF00D1FF00F8FF00FFDD00FFB200FF8500FF5800FF2C00FF0127FF004DFF006FFF00
8DFF00A6FF00B9FF00C7FF00CFFF00D0FF00CCFF00C1FF00B1FF009BFF0081FF0063FF00
42FF001EFF0000FF0600FF2C00FF5100FF7500FF9600FFB300FFCD00FFE100FFF000FFF9
00FFFC00FFF800FFEF00FFE000FFCC00FFB400FF9900FF7B00FF5D00FF3F00FF2200FF09
0CFF001DFF0028FF002DFF002CFF0025FF0018FF0006FF0000FF0D00FF2400FF3B00FF51
00FF6400FF7200FF7B00FF7D00FF7900FF6F00FF6100FF5100FF4100FF3500FF2E00FF2D
00FF3300FF3C00FF4500FF4500FF4100FF4000FF4700FF5000FF5700FF5800FF5200FF46
00FF3700FF2700FF1800FF0E00FF0800FF0900FF1100FF1E00FF3000FF4500FF5C00FF73
00FF8900FF9B00FFA900FFB100FFB300FFAF00FFA500FF9600FF8100FF6800FF4C00FF2E
00FF100DFF0029FF0042FF0057FF0067FF0071FF0076FF0074FF006CFF005EFF004BFF00
33FF0016FF0000FF0A00FF2D00FF5200FF7700FF9D00FFC100FFE300FDFF00E2FF00CCFF
00BBFF00AFFF00A9FF00AAFF00B0FF00BDFF00CFFF00E7FF00FFFB00FFDA00FFB500FF8D
00FF6200FF3600FF0923FF004FFF0079FF00A1FF00C5FF00E6FF00FFFD00FFE600FFD500
FFC900FFC300FFC300FFC900FFD500FFE700FFFF00E3FF00C1FF009AFF0070FF0042FF00
12FF0000FF2000FF5400FF8800FFBC00FFEF00DEFF00AEFF
FBFF00CCFF009BFF0068FF0034FF0000FF0000FF3400FF6600FF9700FFC500FFF000E7FF
00C4FF00A6FF008DFF007AFF006DFF0065FF0064FF0069FF0074FF0084FF009AFF00B5FF
00D5FF00F9FF00FFDF00FFB600FF8A00FF5D00FF3000FF0426FF004FFF0075FF0097FF00
B5FF00CDFF00E1FF00EFFF00F6FF00F8FF00F3FF00E9FF00D8FF00C3FF00A9FF008BFF00
69FF0045FF0020FF0000FF0400FF2A00FF4D00FF6E00FF8C00FFA500FFBA00FFC800FFD1
00FFD400FFD100FFC700FFB800FFA500FF8C00FF7100FF5400FF3500FF1704FF001EFF00
33FF0044FF004FFF0055FF0053FF004CFF003FFF002EFF0019FF0002FF0000FF1400FF2A
00FF3C00FF4A00FF5300FF5500FF5100FF4700FF3900FF2900FF1A00FF0D00FF0600FF05
00FF0B00FF1500FF1D00FF1E00FF1900FF1800FF1F00FF2900FF3000FF3100FF2B00FF1F
00FF1000FF000EFF0019FF001EFF001DFF0016FF0009FF0000FF0800FF1E00FF3500FF4C
00FF6100FF7300FF8100FF8900FF8C00FF8800FF7E00FF6E00FF5900FF4000FF2400FF06
17FF0035FF0051FF0069FF007EFF008EFF0099FF009DFF009CFF0094FF0086FF0073FF00
5AFF003DFF001DFF0000FF0500FF2A00FF5000FF7500FF9900FFBB00FFDA00FFF500F4FF
00E2FF00D7FF00D1FF00D1FF00D8FF00E4FF00F7FF00FFF100FFD400FFB200FF8D00FF65
00FF3A00FF0E1EFF004BFF0077FF00A1FF00C8FF00EDFF00FFF200FFD600FFBF00FFAD00
FFA100FF9B00FF9B00FFA100FFAE00FFC000FFD800FFF500E8FF00C2FF0097FF006AFF00
39FF0007FF0000FF2C00FF6000FF9400FFC800FFFA00D6FF
FFDF00F1FF00BFFF008CFF0058FF0024FF0000FF0F00FF4200FF7300FFA100FFCC00FFF3
00E9FF00CBFF00B2FF009EFF0091FF008AFF0088FF008DFF0098FF00A8FF00BFFF00DAFF
00F9FF00FFE200FFBB00FF9100FF6600FF3900FF0C1FFF004AFF0073FF0099FF00BBFF00
D9FF00F2FF00FFFA00FFEC00FFE400FFE300FFE700FFF200FDFF00E7FF00CDFF00AFFF00
8EFF006AFF0045FF001FFF0000FF0500FF2900FF4A00FF6700FF8100FF9500FFA400FFAD
00FFB000FFAC00FFA300FF9400FF8000FF6800FF4D00FF2F00FF110CFF0029FF0042FF00
58FF0069FF0074FF0079FF0078FF0071FF0064FF0052FF003EFF0027FF0010FF0000FF05
00FF1800FF2600FF2F00FF3100FF2D00FF2300FF1500FF050AFF0016FF001EFF001EFF00
18FF000FFF0006FF0006FF000AFF000BFF0004FF0000FF0400FF0B00FF0C00FF0605FF00
14FF0024FF0033FF003DFF0043FF0042FF003AFF002DFF001BFF0006FF0000FF1000FF27
00FF3D00FF4F00FF5D00FF6500FF6700FF6300FF5900FF4A00FF3500FF1C00FF001DFF00
3BFF0059FF0075FF008EFF00A3FF00B3FF00BDFF00C2FF00C0FF00B8FF00AAFF0097FF00
7FFF0062FF0041FF001EFF0000FF0600FF2B00FF5100FF7500FF9700FFB600FFD100FFE7
00FFF800FBFF00F5FF00F6FF00FCFF00FFF600FFE400FFCC00FFAF00FF8E00FF6900FF41
00FF1615FF0042FF006FFF009BFF00C5FF00EDFF00FFEE00FFCD00FFB100FF9A00FF8900
FF7D00FF7700FF7700FF7D00FF8900FF9B00FFB300FFD000FFF200E6FF00BCFF008EFF00
5EFF002BFF0000FF0800FF3C00FF7000FFA300FFD500FAFF
FFBF00FFEE00E0FF00ADFF0079FF0044FF0010FF0000FF2100FF5200FF8000FFAC00FFD3
00FFF600EBFF00D2FF00BFFF00B1FF00AAFF00A9FF00AEFF00B8FF00C9FF00DFFF00FAFF
00FFE500FFC100FF9A00FF7100FF4500FF1814FF0040FF006BFF0094FF00BAFF00DCFF00
F9FF00FFED00FFD900FFCC00FFC400FFC200FFC700FFD200FFE200FFF700EEFF00CFFF00
AEFF008AFF0065FF003FFF001AFF0000FF0800FF2900FF4700FF6000FF7500FF8300FF8C
00FF8F00FF8C00FF8200FF7400FF6000FF4800FF2C00FF0F0FFF002DFF0049FF0063FF00
78FF0089FF0094FF0099FF0098FF0091FF0084FF0073FF005EFF0047FF0030FF001AFF00
08FF0000FF0600FF0E00FF1000FF0C00FF020AFF001BFF002AFF0037FF003EFF003EFF00
39FF002FFF0027FF0026FF002BFF002CFF0025FF001BFF0014FF0013FF0019FF0025FF00
34FF0045FF0053FF005EFF0063FF0062FF005BFF004EFF003CFF0026FF000FFF0000FF07
00FF1C00FF2E00FF3C00FF4400FF4700FF4300FF3900FF2900FF1404FF0020FF003EFF00
5CFF007AFF0096FF00AEFF00C3FF00D3FF00DEFF00E2FF00E0FF00D9FF00CBFF00B8FF00
9FFF0082FF0062FF003FFF001AFF0000FF0B00FF3000FF5400FF7600FF9500FFB000FFC6
00FFD800FFE300FFE900FFE900FFE200FFD600FFC400FFAC00FF8F00FF6E00FF4800FF20
0AFF0036FF0063FF0090FF00BBFF00E6FF00FFF200FFCD00FFAD00FF9100FF7A00FF6800
FF5C00FF5600FF5600FF5D00FF6900FF7B00FF9300FFB000FFD200FFF800DCFF00AEFF00
7EFF004CFF0018FF0000FF1B00FF4F00FF8300FFB500FFE4
FFA300FFD200FCFF00C9FF0095FF0060FF002CFF0000FF0500FF3600FF6400FF9000FFB7
00FFDA00FFF800EEFF00DBFF00CDFF00C6FF00C5FF00CAFF00D4FF00E5FF00FBFF00FFE9
00FFC900FFA500FF7E00FF5500FF2903FF0030FF005CFF0087FF00B0FF00D6FF00F8FF00
FFE900FFD100FFBD00FFB000FFA800FFA600FFAB00FFB500FFC600FFDB00FFF500ECFF00
CAFF00A6FF0081FF005BFF0036FF0013FF0000FF0D00FF2B00FF4400FF5900FF6700FF70
00FF7300FF7000FF6600FF5800FF4400FF2C00FF100CFF002BFF0049FF0065FF007FFF00
94FF00A5FF00B0FF00B6FF00B4FF00ADFF00A0FF008FFF007AFF0063FF004CFF0036FF00
24FF0016FF000DFF000BFF000FFF0019FF0026FF0037FF0046FF0053FF005AFF005AFF00
55FF004BFF0043FF0042FF0047FF0048FF0041FF0037FF0030FF002FFF0035FF0041FF00
50FF0061FF006FFF007AFF007FFF007EFF0077FF006AFF0058FF0042FF002BFF0014FF00
00FF0000FF1200FF2000FF2800FF2B00FF2700FF1D00FF0D07FF0020FF003CFF005AFF00
78FF0096FF00B2FF00CAFF00DFFF00EFFF00FAFF00FEFF00FDFF00F5FF00E7FF00D4FF00
BBFF009EFF007EFF005BFF0036FF0010FF0000FF1400FF3800FF5A00FF7900FF9400FFAA
00FFBC00FFC700FFCD00FFCD00FFC600FFBA00FFA700FF9000FF7300FF5100FF2C00FF04
26FF0052FF007FFF00ACFF00D7FF00FFFD00FFD600FFB100FF9100FF7500FF5E00FF4C00
FF4000FF3A00FF3A00FF4000FF4D00FF5F00FF7700FF9400FFB600FFDC00F8FF00CAFF00
9AFF0068FF0034FF0000FF0000FF3300FF6700FF9900FFC8
FF8C00FFBB00FFEC00E0FF00ACFF0077FF0043FF0011FF0000FF1F00FF4D00FF7800FFA0
00FFC300FFE100FFFA00F2FF00E5FF00DDFF00DCFF00E1FF00ECFF00FCFF00FFED00FFD2
00FFB200FF8E00FF6700FF3E00FF121AFF0047FF0073FF009EFF00C7FF00EDFF00FFF000
FFD200FFBA00FFA600FF9800FF9100FF8F00FF9400FF9E00FFAF00FFC400FFDE00FFFC00
E1FF00BDFF0098FF0073FF004DFF002AFF0009FF0000FF1400FF2D00FF4200FF5000FF59
00FF5C00FF5900FF4F00FF4000FF2D00FF1406FF0023FF0042FF0060FF007CFF0096FF00
ABFF00BCFF00C7FF00CDFF00CBFF00C4FF00B7FF00A6FF0091FF007AFF0063FF004DFF00
3BFF002DFF0024FF0022FF0026FF0030FF003EFF004EFF005DFF006AFF0071FF0072FF00
6CFF0062FF005AFF0059FF005EFF005FFF0058FF004EFF0047FF0046FF004CFF0058FF00
67FF0078FF0086FF0091FF0096FF0095FF008EFF0081FF006FFF0059FF0042FF002BFF00
16FF0004FF0000FF0900FF1100FF1400FF1000FF0609FF001EFF0037FF0053FF0071FF00
8FFF00ADFF00C9FF00E1FF00F6FF00FFF900FFEE00FFEA00FFEB00FFF300FEFF00EBFF00
D2FF00B5FF0095FF0072FF004DFF0027FF0002FF0000FF2100FF4300FF6200FF7D00FF93
00FFA500FFB000FFB600FFB600FFAF00FFA300FF9000FF7900FF5C00FF3A00FF1512FF00
3DFF0069FF0096FF00C3FF00EFFF00FFE600FFBF00FF9A00FF7A00FF5E00FF4700FF3500
FF2900FF2300FF2300FF2900FF3600FF4800FF6000FF7D00FF9F00FFC500FFF000E2FF00
B1FF007FFF004BFF0017FF0000FF1C00FF5000FF8200FFB1
FF7A00FFA900FFDB00F1FF00BDFF0089FF0055FF0022FF0000FF0D00FF3C00FF6700FF8E
00FFB100FFCF00FFE800FFFB00F6FF00EFFF00EEFF00F2FF00FDFF00FFF100FFDB00FFC0
00FFA000FF7D00FF5600FF2C00FF002BFF0058FF0085FF00B0FF00D9FF00FEFF00FFDF00
FFC100FFA800FF9400FF8700FF7F00FF7E00FF8200FF8D00FF9D00FFB200FFCD00FFEB00
F3FF00CFFF00AAFF0084FF005FFF003BFF001AFF0000FF0200FF1B00FF3000FF3F00FF48
00FF4A00FF4700FF3E00FF2F00FF1B00FF0317FF0035FF0053FF0071FF008EFF00A7FF00
BDFF00CEFF00D9FF00DEFF00DDFF00D6FF00C9FF00B8FF00A3FF008CFF0075FF005FFF00
4CFF003EFF0036FF0033FF0038FF0041FF004FFF005FFF006FFF007CFF0083FF0083FF00
7DFF0074FF006CFF006BFF0070FF0071FF006AFF0060FF0059FF0058FF005EFF006AFF00
79FF0089FF0098FF00A3FF00A8FF00A7FF009FFF0092FF0080FF006BFF0054FF003DFF00
28FF0015FF0008FF0000FF0000FF0201FF000BFF001BFF0030FF0049FF0065FF0082FF00
A1FF00BEFF00DAFF00F3FF00FFF700FFE700FFDD00FFD800FFDA00FFE200FFEF00FCFF00
E4FF00C7FF00A7FF0084FF005FFF0039FF0014FF0000FF0F00FF3100FF5000FF6B00FF82
00FF9300FF9F00FFA400FFA400FF9E00FF9100FF7F00FF6700FF4A00FF2900FF0424FF00
4EFF007BFF00A7FF00D4FF00FFFF00FFD500FFAD00FF8900FF6800FF4C00FF3500FF2300
FF1700FF1100FF1200FF1800FF2400FF3600FF4E00FF6B00FF8D00FFB400FFDE00F3FF00
C3FF0090FF005DFF0028FF0000FF0B00FF3E00FF7000FF9F
FF6E00FF9D00FFCF00FDFF00C9FF0095FF0061FF002EFF0000FF0100FF3000FF5B00FF82
00FFA500FFC300FFDC00FFEF00FFFD00FBFF00FAFF00FEFF00FFF600FFE500FFCF00FFB4
00FF9400FF7100FF4A00FF200BFF0037FF0064FF0091FF00BCFF00E4FF00FFF500FFD300
FFB500FF9C00FF8900FF7B00FF7300FF7200FF7600FF8100FF9100FFA600FFC100FFDF00
FFFF00DBFF00B6FF0090FF006BFF0047FF0026FF0009FF0000FF1000FF2400FF3300FF3C
00FF3E00FF3B00FF3200FF2300FF0F08FF0023FF0041FF005FFF007DFF009AFF00B3FF00
C9FF00DAFF00E5FF00EAFF00E9FF00E2FF00D5FF00C4FF00AFFF0098FF0081FF006BFF00
58FF004AFF0042FF003FFF0044FF004DFF005BFF006BFF007BFF0088FF008FFF008FFF00
89FF0080FF0078FF0077FF007CFF007DFF0076FF006CFF0065FF0064FF006AFF0076FF00
85FF0095FF00A4FF00AEFF00B4FF00B3FF00ABFF009EFF008CFF0077FF0060FF0049FF00
34FF0021FF0014FF000BFF0009FF000DFF0017FF0027FF003CFF0054FF0070FF008EFF00
ADFF00CAFF00E6FF00FFFF00FFEB00FFDB00FFD100FFCC00FFCE00FFD600FFE300FFF700
F0FF00D3FF00B3FF0090FF006BFF0045FF0020FF0000FF0400FF2500FF4400FF5F00FF76
00FF8700FF9300FF9800FF9800FF9200FF8500FF7300FF5B00FF3E00FF1D07FF0030FF00
5AFF0087FF00B3FF00E0FF00FFF300FFC900FFA100FF7D00FF5C00FF4000FF2900FF1700
FF0B00FF0500FF0600FF0C00FF1800FF2A00FF4200FF5F00FF8100FFA800FFD200FFFF00
CFFF009CFF0069FF0034FF0000FF0000FF3200FF6400FF94
FF6800FF9700FFC900FFFC00CFFF009BFF0067FF0034FF0004FF0000FF2A00FF5500FF7C
00FF9F00FFBD00FFD600FFE900FFF700FFFE00FFFF00FFFB00FFF000FFDF00FFC900FFAE
00FF8E00FF6B00FF4400FF1A11FF003DFF006AFF0097FF00C2FF00EAFF00FFEF00FFCD00
FFAF00FF9600FF8300FF7500FF6D00FF6C00FF7000FF7B00FF8B00FFA000FFBB00FFD900
FFFA00E1FF00BCFF0096FF0071FF004DFF002CFF000FFF0000FF0A00FF1E00FF2D00FF36
00FF3800FF3500FF2C00FF1D00FF090EFF0029FF0047FF0065FF0083FF00A0FF00B9FF00
CFFF00E0FF00EBFF00F0FF00EFFF00E8FF00DBFF00CAFF00B5FF009EFF0087FF0071FF00
5EFF0050FF0048FF0045FF004AFF0053FF0061FF0071FF0081FF008EFF0095FF0095FF00
8FFF0086FF007EFF007DFF0082FF0083FF007CFF0072FF006BFF006AFF0070FF007CFF00
8BFF009BFF00AAFF00B4FF00BAFF00B9FF00B1FF00A4FF0092FF007DFF0066FF004FFF00
3AFF0027FF001AFF0011FF000FFF0013FF001DFF002DFF0042FF005AFF0076FF0094FF00
B3FF00D0FF00ECFF00FFFA00FFE500FFD500FFCB00FFC600FFC800FFD000FFDD00FFF100
F6FF00D9FF00B9FF0096FF0071FF004BFF0026FF0001FF0000FF1F00FF3E00FF5900FF70
00FF8100FF8D00FF9200FF9200FF8C00FF7F00FF6D00FF5500FF3800FF170DFF0036FF00
60FF008DFF00B9FF00E6FF00FFED00FFC300FF9B00FF7700FF5600FF3A00FF2300FF1100
FF0500000000000000FF0600FF1200FF2400FF3C00FF5900FF7B00FFA200FFCC00FFFA00
D5FF00A2FF006FFF003AFF0006FF0000FF2C00FF5E00FF8E
FF6800FF9700FFC900FFFC00CFFF009BFF0067FF0034FF0003FF0000FF2A00FF5500FF7C
00FF9F00FFBD00FFD600FFEA00FFF700FFFE00FFFF00FFFB00FFF000FFDF00FFC900FFAE
00FF8F00FF6B00FF4400FF1A10FF003DFF006AFF0097FF00C2FF00EAFF00FFEF00FFCD00
FFAF00FF9600FF8300FF7500FF6D00FF6C00FF7000FF7B00FF8B00FFA100FFBB00FFD900
FFFA00E1FF00BCFF0096FF0071FF004DFF002CFF000FFF0000FF0A00FF1E00FF2D00FF36
00FF3900FF3500FF2C00FF1D00FF090EFF0029FF0047FF0065FF0083FF00A0FF00B9FF00
CFFF00E0FF00EBFF00F0FF00EFFF00E8FF00DBFF00CAFF00B5FF009EFF0087FF0071FF00
5EFF0050FF0048FF0045FF0049FF0053FF0061FF0071FF0081FF008DFF0095FF0095FF00
8FFF0086FF007EFF007DFF0082FF0083FF007CFF0072FF006BFF006AFF0070FF007CFF00
8BFF009BFF00AAFF00B4FF00BAFF00B9FF00B1FF00A4FF0092FF007DFF0066FF004FFF00
3AFF0027FF001AFF0011FF000FFF0013FF001DFF002DFF0041FF005AFF0076FF0094FF00
B3FF00D0FF00ECFF00FFFA00FFE500FFD500FFCB00FFC600FFC800FFD000FFDD00FFF100
F6FF00D9FF00B9FF0095FF0071FF004BFF0026FF0001FF0000FF2000FF3E00FF5900FF70
00FF8100FF8D00FF9300FF9200FF8C00FF7F00FF6D00FF5500FF3800FF170DFF0036FF00
60FF008CFF00B9FF00E6FF00FFED00FFC300FF9B00FF7700FF5600FF3A00FF2300FF1200
FF0600000000000000FF0600FF1200FF2400FF3C00FF5900FF7B00FFA200FFCC00FFFA00
D5FF00A2FF006FFF003AFF0006FF0000FF2C00FF5E00FF8E
FF6E00FF9D00FFCF00FDFF00C9FF0095FF0061FF002EFF0000FF0200FF3000FF5B00FF82
00FFA500FFC400FFDC00FFF000FFFD00FAFF00F9FF00FEFF00FFF600FFE600FFD000FFB4
00FF9500FF7100FF4A00FF200AFF0037FF0064FF0090FF00BBFF00E4FF00FFF500FFD300
FFB500FF9C00FF8900FF7B00FF7300FF7200FF7700FF8100FF9100FFA700FFC100FFDF00
FFFF00DBFF00B6FF0090FF006BFF0047FF0026FF0009FF0000FF1000FF2400FF3300FF3C
00FF3F00FF3B00FF3200FF2300FF0F08FF0023FF0041FF005FFF007DFF0099FF00B3FF00
C9FF00DAFF00E5FF00EAFF00E9FF00E2FF00D5FF00C3FF00AFFF0098FF0081FF006BFF00
58FF004AFF0041FF003FFF0043FF004DFF005BFF006BFF007BFF0087FF008EFF008FFF00
89FF007FFF0077FF0077FF007BFF007CFF0075FF006CFF0065FF0064FF006AFF0075FF00
85FF0095FF00A4FF00AEFF00B3FF00B2FF00ABFF009EFF008CFF0077FF0060FF0049FF00
33FF0021FF0013FF000BFF0009FF000DFF0017FF0026FF003BFF0054FF0070FF008EFF00
ACFF00CAFF00E6FF00FFFF00FFEB00FFDC00FFD100FFCD00FFCE00FFD600FFE400FFF700
F0FF00D3FF00B2FF008FFF006AFF0045FF001FFF0000FF0400FF2600FF4500FF6000FF76
00FF8700FF9300FF9900FF9800FF9200FF8500FF7300FF5B00FF3E00FF1D07FF002FFF00
5AFF0086FF00B3FF00E0FF00FFF300FFC900FFA100FF7D00FF5D00FF4000FF2900FF1800
FF0C00FF0600FF0600FF0C00FF1800FF2A00FF4200FF5F00FF8200FFA800FFD200FFFF00
CEFF009CFF0068FF0034FF0000FF0000FF3200FF6400FF94
FF7B00FFAA00FFDB00F1FF00BDFF0088FF0055FF0022FF0000FF0E00FF3C00FF6700FF8F
00FFB200FFD000FFE900FFFC00F6FF00EEFF00EDFF00F2FF00FDFF00FFF200FFDC00FFC1
00FFA100FF7D00FF5600FF2D00FF012BFF0058FF0084FF00AFFF00D8FF00FEFF00FFDF00
FFC100FFA800FF9500FF8700FF8000FF7E00FF8300FF8D00FF9E00FFB300FFCD00FFEB00
F2FF00CEFF00A9FF0084FF005EFF003BFF001AFF0000FF0300FF1C00FF3000FF3F00FF48
00FF4B00FF4800FF3E00FF2F00FF1B00FF0317FF0034FF0053FF0071FF008DFF00A7FF00
BDFF00CDFF00D9FF00DEFF00DCFF00D5FF00C9FF00B7FF00A2FF008CFF0074FF005FFF00
4CFF003EFF0035FF0033FF0037FF0041FF004FFF005FFF006EFF007BFF0082FF0083FF00
7DFF0073FF006BFF006AFF006FFF0070FF0069FF005FFF0058FF0058FF005EFF0069FF00
78FF0089FF0097FF00A2FF00A7FF00A6FF009FFF0092FF0080FF006AFF0053FF003CFF00
27FF0015FF0007FF0000FF0000FF0300FF000AFF001AFF002FFF0048FF0064FF0082FF00
A0FF00BEFF00DAFF00F2FF00FFF800FFE800FFDD00FFD900FFDA00FFE200FFF000FCFF00
E3FF00C7FF00A6FF0083FF005EFF0038FF0013FF0000FF1000FF3200FF5100FF6C00FF82
00FF9400FF9F00FFA500FFA500FF9E00FF9200FF7F00FF6800FF4B00FF2900FF0423FF00
4EFF007AFF00A7FF00D4FF00FFFF00FFD500FFAE00FF8900FF6900FF4D00FF3600FF2400
FF1800FF1200FF1200FF1800FF2500FF3700FF4F00FF6C00FF8E00FFB400FFDF00F3FF00
C2FF0090FF005CFF0028FF0000FF0B00FF3F00FF7000FFA0
FF8D00FFBC00FFED00DFFF00ABFF0076FF0042FF0010FF0000FF2000FF4E00FF7A00FFA1
00FFC400FFE200FFFB00F1FF00E3FF00DCFF00DBFF00E0FF00EAFF00FBFF00FFEE00FFD3
00FFB300FF8F00FF6800FF3F00FF1319FF0046FF0072FF009DFF00C6FF00ECFF00FFF100
FFD300FFBB00FFA700FF9A00FF9200FF9000FF9500FF9F00FFB000FFC500FFDF00FFFD00
E0FF00BCFF0097FF0071FF004CFF0029FF0008FF0000FF1500FF2E00FF4300FF5100FF5A
00FF5D00FF5A00FF5000FF4200FF2E00FF1605FF0022FF0041FF005FFF007BFF0095FF00
AAFF00BBFF00C6FF00CBFF00CAFF00C3FF00B6FF00A5FF0090FF0079FF0062FF004CFF00
3AFF002BFF0023FF0021FF0025FF002FFF003CFF004DFF005CFF0069FF0070FF0070FF00
6BFF0061FF0059FF0058FF005DFF005EFF0057FF004DFF0046FF0045FF004BFF0057FF00
66FF0077FF0085FF0090FF0095FF0094FF008DFF0080FF006EFF0058FF0041FF002AFF00
15FF0003FF0000FF0A00FF1200FF1500FF1100FF0708FF001DFF0036FF0052FF0070FF00
8EFF00ACFF00C8FF00E0FF00F5FF00FFFA00FFEF00FFEB00FFED00FFF400FDFF00EAFF00
D1FF00B4FF0094FF0071FF004CFF0026FF0001FF0000FF2200FF4400FF6300FF7E00FF94
00FFA600FFB100FFB700FFB700FFB000FFA400FF9200FF7A00FF5D00FF3B00FF1611FF00
3CFF0068FF0095FF00C2FF00EDFF00FFE700FFC000FF9B00FF7B00FF5F00FF4800FF3600
FF2A00FF2400FF2400FF2A00FF3700FF4900FF6100FF7E00FFA000FFC600FFF100E0FF00
B0FF007EFF004AFF0016FF0000FF1D00FF5100FF8300FFB2
FFA500FFD400FAFF00C7FF0093FF005EFF002BFF0000FF0700FF3800FF6600FF9100FFB9
00FFDC00FFFA00ECFF00D9FF00CCFF00C4FF00C3FF00C8FF00D3FF00E3FF00F9FF00FFEB
00FFCB00FFA700FF8000FF5700FF2B01FF002EFF005AFF0085FF00AEFF00D4FF00F6FF00
FFEB00FFD200FFBF00FFB100FFAA00FFA800FFAD00FFB700FFC800FFDD00FFF700EAFF00
C8FF00A5FF007FFF005AFF0034FF0011FF0000FF0F00FF2D00FF4600FF5A00FF6900FF72
00FF7500FF7200FF6800FF5900FF4500FF2D00FF120AFF0029FF0047FF0063FF007DFF00
93FF00A3FF00AFFF00B4FF00B3FF00ABFF009FFF008DFF0078FF0062FF004AFF0035FF00
22FF0014FF000BFF0009FF000DFF0017FF0025FF0035FF0044FF0051FF0058FF0059FF00
53FF0049FF0041FF0040FF0045FF0046FF003FFF0035FF002EFF002EFF0034FF003FFF00
4FFF005FFF006DFF0078FF007DFF007CFF0075FF0068FF0056FF0040FF0029FF0012FF00
00FF0200FF1400FF2200FF2A00FF2D00FF2900FF1F00FF0F05FF001EFF003AFF0058FF00
76FF0094FF00B0FF00C9FF00DDFF00EDFF00F8FF00FCFF00FBFF00F3FF00E5FF00D2FF00
B9FF009DFF007CFF0059FF0034FF000EFF0000FF1600FF3A00FF5C00FF7B00FF9600FFAC
00FFBE00FFC900FFCF00FFCF00FFC800FFBC00FFA900FF9100FF7500FF5300FF2E00FF06
24FF0050FF007DFF00AAFF00D6FF00FFFF00FFD800FFB300FF9300FF7700FF6000FF4E00
FF4200FF3C00FF3C00FF4200FF4F00FF6100FF7900FF9600FFB800FFDE00F6FF00C9FF00
98FF0066FF0032FF0000FF0100FF3500FF6900FF9A00FFCA
FFC200FFF100DDFF00AAFF0076FF0041FF000DFF0000FF2400FF5500FF8300FFAF00FFD6
00FFF900E8FF00CFFF00BCFF00AEFF00A7FF00A6FF00ABFF00B5FF00C6FF00DCFF00F7FF
00FFE800FFC400FF9D00FF7400FF4800FF1B11FF003DFF0068FF0091FF00B7FF00D9FF00
F7FF00FFF000FFDC00FFCF00FFC700FFC500FFCA00FFD400FFE500FFFA00EBFF00CDFF00
ABFF0087FF0062FF003CFF0017FF0000FF0B00FF2C00FF4A00FF6300FF7800FF8600FF8F
00FF9200FF8F00FF8500FF7700FF6300FF4B00FF2F00FF120CFF002AFF0046FF0060FF00
75FF0086FF0091FF0097FF0095FF008EFF0081FF0070FF005BFF0044FF002DFF0017FF00
05FF0000FF0800FF1100FF1300FF0F00FF0508FF0018FF0027FF0034FF003BFF003CFF00
36FF002CFF0024FF0023FF0028FF0029FF0022FF0018FF0011FF0010FF0016FF0022FF00
31FF0042FF0050FF005BFF0060FF005FFF0058FF004BFF0039FF0023FF000CFF0000FF0A
00FF1F00FF3100FF3F00FF4700FF4A00FF4600FF3C00FF2C00FF1701FF001DFF003BFF00
59FF0077FF0093FF00ABFF00C0FF00D0FF00DBFF00DFFF00DEFF00D6FF00C8FF00B5FF00
9CFF007FFF005FFF003CFF0017FF0000FF0E00FF3300FF5700FF7900FF9800FFB300FFC9
00FFDB00FFE600FFEC00FFEC00FFE500FFD900FFC600FFAF00FF9200FF7000FF4B00FF23
07FF0033FF0060FF008DFF00B8FF00E3FF00FFF500FFD000FFB000FF9400FF7D00FF6B00
FF5F00FF5900FF5900FF5F00FF6C00FF7E00FF9600FFB300FFD500FFFB00D9FF00ABFF00
7BFF0049FF0015FF0000FF1E00FF5200FF8600FFB800FFE7
FFE400ECFF00BBFF0088FF0054FF001FFF0000FF1400FF4600FF7700FFA500FFD100FFF8
00E4FF00C6FF00ADFF009AFF008CFF0085FF0084FF0089FF0093FF00A4FF00BAFF00D5FF
00F5FF00FFE700FFBF00FF9600FF6A00FF3D00FF101BFF0046FF006FFF0095FF00B7FF00
D4FF00EDFF00FFFE00FFF100FFE900FFE700FFEC00FFF700F8FF00E3FF00C9FF00AAFF00
89FF0065FF0040FF001AFF0000FF0A00FF2D00FF4E00FF6C00FF8500FF9A00FFA900FFB1
00FFB400FFB100FFA700FF9900FF8500FF6D00FF5100FF3400FF1508FF0024FF003EFF00
53FF0064FF006FFF0074FF0073FF006CFF005FFF004EFF0039FF0022FF000BFF0000FF0A
00FF1C00FF2B00FF3300FF3500FF3100FF2700FF1A00FF0905FF0012FF0019FF0019FF00
14FF000AFF0002FF0001FF0006FF0007FF0000FF0000FF0900FF1000FF1100FF0B00FF00
0FFF0020FF002EFF0039FF003EFF003DFF0036FF0029FF0017FF0001FF0000FF1500FF2C
00FF4100FF5300FF6100FF6900FF6C00FF6800FF5E00FF4E00FF3900FF2000FF0419FF00
37FF0055FF0071FF0089FF009EFF00AEFF00B8FF00BDFF00BBFF00B4FF00A6FF0093FF00
7AFF005DFF003DFF001AFF0000FF0A00FF3000FF5500FF7900FF9B00FFBA00FFD500FFEB
00FFFD00F7FF00F1FF00F1FF00F8FF00FFFB00FFE900FFD100FFB400FF9300FF6D00FF45
00FF1A11FF003EFF006BFF0096FF00C1FF00E8FF00FFF200FFD200FFB600FF9F00FF8D00
FF8100FF7B00FF7B00FF8200FF8E00FFA000FFB800FFD500FFF700E2FF00B7FF0089FF00
59FF0027FF0000FF0C00FF4000FF7400FFA800FFDA00F6FF
F5FF00C6FF0094FF0061FF002DFF0000FF0600FF3A00FF6D00FF9E00FFCC00FFF700E1FF
00BEFF00A0FF0087FF0073FF0066FF005FFF005DFF0062FF006DFF007DFF0094FF00AFFF
00CEFF00F2FF00FFE600FFBC00FF9100FF6400FF3700FF0B1FFF0048FF006EFF0090FF00
AEFF00C7FF00DAFF00E8FF00F0FF00F1FF00EDFF00E2FF00D2FF00BCFF00A2FF0084FF00
63FF003FFF001AFF0000FF0B00FF3000FF5400FF7500FF9200FFAC00FFC000FFCF00FFD8
00FFDB00FFD700FFCE00FFBF00FFAB00FF9300FF7800FF5A00FF3C00FF1E00FF0117FF00
2DFF003EFF0049FF004EFF004DFF0046FF0039FF0027FF0013FF0000FF0300FF1A00FF30
00FF4300FF5100FF5A00FF5C00FF5800FF4E00FF4000FF3000FF2000FF1400FF0D00FF0C
00FF1200FF1B00FF2400FF2400FF2000FF1F00FF2600FF2F00FF3600FF3700FF3100FF25
00FF1600FF0608FF0012FF0018FF0017FF000FFF0002FF0000FF0F00FF2400FF3B00FF52
00FF6800FF7A00FF8800FF9000FF9200FF8E00FF8400FF7500FF6000FF4700FF2B00FF0D
10FF002EFF004AFF0063FF0078FF0088FF0092FF0097FF0095FF008DFF007FFF006CFF00
54FF0037FF0016FF0000FF0C00FF3100FF5600FF7C00FFA000FFC200FFE100FFFC00EDFF
00DCFF00D0FF00CAFF00CBFF00D1FF00DEFF00F0FF00FFF700FFDA00FFB900FF9400FF6C
00FF4100FF1517FF0044FF0070FF009AFF00C2FF00E6FF00FFF800FFDC00FFC500FFB400
FFA800FFA200FFA200FFA800FFB400FFC600FFDE00FFFB00E2FF00BBFF0091FF0063FF00
33FF0000FF0000FF3300FF6700FF9B00FFCE00FFFF00CFFF
CAFF009BFF006AFF0037FF0003FF0000FF3100FF6500FF9700FFC800FFF600DEFF00B6FF
0093FF0075FF005CFF0049FF003CFF0034FF0033FF0038FF0042FF0053FF0069FF0084FF
00A4FF00C8FF00EFFF00FFE700FFBB00FF8E00FF6100FF3500FF0A1EFF0044FF0066FF00
84FF009CFF00B0FF00BEFF00C5FF00C7FF00C2FF00B8FF00A7FF0092FF0078FF005AFF00
38FF0014FF0000FF1000FF3600FF5B00FF7E00FF9F00FFBD00FFD600FFEB00FFF900FDFF
00FAFF00FDFF00FFF800FFE900FFD600FFBE00FFA200FF8500FF6600FF4800FF2C00FF12
02FF0013FF001EFF0024FF0022FF001BFF000EFF0000FF0200FF1700FF2E00FF4500FF5B
00FF6D00FF7B00FF8400FF8600FF8200FF7800FF6A00FF5A00FF4B00FF3E00FF3700FF36
00FF3C00FF4600FF4E00FF4F00FF4A00FF4900FF5000FF5A00FF6100FF6200FF5C00FF50
00FF4100FF3000FF2200FF1700FF1200FF1300FF1A00FF2700FF3900FF4F00FF6600FF7D
00FF9200FFA400FFB200FFBA00FFBD00FFB900FFAF00FF9F00FF8A00FF7100FF5500FF37
00FF1904FF0020FF0038FF004DFF005DFF0068FF006CFF006BFF0063FF0055FF0042FF00
29FF000CFF0000FF1300FF3600FF5B00FF8100FFA600FFCA00FFEC00F4FF00D9FF00C3FF
00B1FF00A6FF00A0FF00A0FF00A7FF00B3FF00C6FF00DDFF00FAFF00FFE300FFBE00FF96
00FF6B00FF3F00FF121AFF0045FF0070FF0097FF00BCFF00DCFF00F8FF00FFF000FFDE00
FFD200FFCC00FFCC00FFD200FFDF00FFF100F6FF00D9FF00B7FF0091FF0066FF0039FF00
08FF0000FF2900FF5D00FF9100FFC500FFF900D4FF00A5FF
9DFF006DFF003CFF0009FF0000FF2A00FF5E00FF9200FFC500FFF600DBFF00B0FF0088FF
0066FF0047FF002FFF001BFF000EFF0006FF0005FF000AFF0015FF0025FF003BFF0057FF
0076FF009AFF00C1FF00EBFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006FFF0082FF0090FF0097FF0099FF0094FF008AFF007AFF0064FF004AFF002CFF00
0AFF0000FF1800FF3E00FF6300FF8800FFAC00FFCD00FFEB00FBFF00E7FF00D8FF00CFFF
00CCFF00D0FF00D9FF00E8FF00FCFF00FFEB00FFD000FFB200FF9400FF7600FF5A00FF40
00FF2A00FF1900FF0E00FF0900FF0A00FF1200FF1E00FF3000FF4400FF5B00FF7200FF88
00FF9B00FFA900FFB200FFB400FFB000FFA600FF9800FF8800FF7800FF6C00FF6500FF64
00FF6A00FF7400FF7C00FF7C00FF7800FF7700FF7E00FF8700FF8E00FF8F00FF8900FF7E
00FF6E00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7C00FF9300FFAA
00FFC000FFD200FFE000FFE800FFEA00FFE600FFDC00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0BFF001FFF002FFF003AFF003EFF003DFF0035FF0027FF0014FF00
00FF0300FF2000FF4100FF6400FF8900FFAE00FFD400FFF800E5FF00C6FF00ABFF0095FF
0084FF0078FF0072FF0073FF0079FF0086FF0098FF00B0FF00CDFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1318FF0042FF006AFF008EFF00AEFF00CAFF00E2FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F3FF00E0FF00C9FF00ABFF0089FF0063FF0039FF000BFF00
00FF2500FF5700FF8B00FFBF00FFF300D9FF00A7FF0077FF
6CFF003DFF000CFF0000FF2600FF5B00FF8F00FFC300FFF500D9FF00ABFF007FFF0058FF
0035FF0017FF0100FF1400FF2200FF2900FF2A00FF2500FF1B00FF0A00FF000BFF0026FF
0046FF0069FF0091FF00BAFF00E6FF00FFEC00FFBF00FF9300FF6800FF3F00FF1908FF00
25FF003EFF0052FF005FFF0067FF0069FF0064FF0059FF0049FF0034FF001AFF0000FF04
00FF2500FF4900FF6E00FF9400FFB900FFDC00FFFD00E4FF00CBFF00B6FF00A7FF009FFF
009CFF009FFF00A8FF00B7FF00CBFF00E3FF00FFFF00FFE300FFC400FFA600FF8A00FF70
00FF5B00FF4A00FF3F00FF3A00FF3B00FF4200FF4F00FF6000FF7500FF8C00FFA300FFB9
00FFCB00FFDA00FFE200FFE400FFE000FFD700FFC900FFB800FFA900FF9C00FF9500FF95
00FF9A00FFA400FFAC00FFAD00FFA800FFA700FFAE00FFB800FFBF00FFC000FFBA00FFAE
00FF9F00FF8E00FF8000FF7500FF7000FF7100FF7800FF8600FF9700FFAD00FFC400FFDB
00FFF000FDFF00EFFF00E7FF00E4FF00E8FF00F2FF00FFFD00FFE800FFCF00FFB300FF95
00FF7700FF5900FF3E00FF2500FF1000FF0009FF000EFF000CFF0005FF0000FF0800FF1B
00FF3400FF5100FF7100FF9400FFB900FFDF00FBFF00D7FF00B5FF0096FF007BFF0065FF
0053FF0048FF0042FF0042FF0049FF0055FF0067FF007FFF009CFF00BDFF00E3FF00FFF4
00FFC900FF9D00FF7000FF4300FF1812FF0039FF005EFF007EFF009AFF00B1FF00C3FF00
CFFF00D5FF00D5FF00CEFF00C2FF00B0FF0098FF007BFF0059FF0033FF0008FF0000FF25
00FF5500FF8700FFBB00FFEF00DBFF00A8FF0076FF0047FF
3AFF000BFF0000FF2600FF5900FF8D00FFC100FFF500D7FF00A6FF0078FF004DFF0026FF
0003FF1A00FF3300FF4700FF5400FF5B00FF5D00FF5800FF4D00FF3C00FF2600FF0B00FF
0013FF0037FF005EFF0088FF00B3FF00E0FF00FFF200FFC500FF9A00FF7200FF4C00FF2A
00FF0C0CFF001FFF002DFF0035FF0036FF0032FF0027FF0017FF0001FF0000FF1800FF36
00FF5700FF7B00FFA000FFC600FFEB00F0FF00CFFF00B2FF0098FF0084FF0075FF006CFF
0069FF006DFF0076FF0085FF0099FF00B1FF00CCFF00EAFF00FFF700FFD900FFBC00FFA3
00FF8D00FF7C00FF7100FF6C00FF6D00FF7400FF8100FF9200FFA700FFBE00FFD500FFEB
00FFFE00F3FF00EBFF00E8FF00ECFF00F6FF00FFFB00FFEB00FFDB00FFCF00FFC700FFC7
00FFCD00FFD600FFDE00FFDF00FFDB00FFD900FFE100FFEA00FFF100FFF200FFEC00FFE0
00FFD100FFC100FFB200FFA800FFA200FFA300FFAB00FFB800FFCA00FFDF00FFF600F2FF
00DCFF00CAFF00BDFF00B4FF00B2FF00B6FF00C0FF00D0FF00E4FF00FDFF00FFE600FFC8
00FFA900FF8C00FF7000FF5700FF4200FF3200FF2800FF2300FF2500FF2D00FF3A00FF4E
00FF6600FF8300FFA300FFC700FFEC00EEFF00C8FF00A4FF0082FF0064FF0049FF0032FF
0021FF0015FF000FFF0010FF0016FF0023FF0035FF004DFF006AFF008BFF00B0FF00D9FF
00FFFC00FFD000FFA300FF7600FF4A00FF2007FF002BFF004CFF0068FF007FFF0090FF00
9CFF00A2FF00A2FF009CFF0090FF007EFF0066FF0049FF0027FF0000FF0000FF2900FF57
00FF8700FFBA00FFED00DDFF00A9FF0076FF0044FF0014FF
06FF0000FF2800FF5900FF8D00FFC100FFF500D6FF00A4FF0073FF0044FF0019FF0D00FF
3000FF4E00FF6700FF7A00FF8800FF8F00FF9000FF8B00FF8100FF7000FF5A00FF3F00FF
1F00FF0003FF002AFF0054FF0080FF00ACFF00D9FF00FFF900FFCE00FFA500FF8000FF5D
00FF4000FF2700FF1300FF0601FF0003FF0000FF0100FF0C00FF1C00FF3100FF4B00FF6A
00FF8B00FFAF00FFD400FFFA00E0FF00BDFF009CFF007EFF0065FF0050FF0041FF0038FF
0036FF0039FF0042FF0051FF0065FF007DFF0099FF00B6FF00D4FF00F2FF00FFF000FFD6
00FFC100FFB000FFA500FFA000FFA100FFA800FFB500FFC600FFDB00FFF200F6FF00E0FF
00CEFF00BFFF00B7FF00B5FF00B9FF00C2FF00D0FF00E0FF00F0FF00FDFF00FFFB00FFFB
00FEFF00F5FF00EDFF00ECFF00F1FF00F2FF00EBFF00E1FF00DAFF00D9FF00DFFF00EBFF
00FAFF00FFF500FFE600FFDB00FFD600FFD700FFDE00FFEC00FFFE00ECFF00D5FF00BEFF
00A9FF0097FF0089FF0081FF007EFF0082FF008CFF009CFF00B1FF00CAFF00E6FF00FFFC
00FFDD00FFBF00FFA400FF8B00FF7600FF6600FF5C00FF5700FF5900FF6000FF6E00FF81
00FF9A00FFB700FFD700FFFA00E0FF00BAFF0095FF0071FF004FFF0030FF0015FF0100FF
1200FF1E00FF2300FF2300FF1C00FF1000FF0001FF0019FF0036FF0057FF007DFF00A5FF
00CFFF00FCFF00FFD600FFAA00FF7E00FF5400FF2C00FF0818FF0034FF004BFF005DFF00
69FF006FFF006FFF0068FF005CFF004AFF0032FF0015FF0000FF0C00FF3300FF5D00FF8B
00FFBB00FFED00DEFF00AAFF0075FF0042FF0010FF1E00FF
00FF2D00FF5C00FF8E00FFC100FFF500D6FF00A2FF006FFF003EFF0010FF1A00FF4100FF
6400FF8200FF9B00FFAF00FFBC00FFC300FFC500FFC000FFB500FFA400FF8E00FF7300FF
5400FF3000FF0900FF0020FF004BFF0078FF00A5FF00D2FF00FDFF00FFDA00FFB400FF92
00FF7400FF5B00FF4800FF3A00FF3200FF3100FF3500FF4000FF5000FF6600FF8000FF9E
00FFBF00FFE300F7FF00D1FF00ACFF0088FF0067FF004AFF0030FF001CFF000DFF0004FF
0001FF0005FF000EFF001DFF0031FF0049FF0064FF0082FF00A0FF00BEFF00DBFF00F4FF
00FFF500FFE400FFD900FFD400FFD500FFDC00FFE900FFFA00F0FF00D9FF00C2FF00ACFF
0099FF008BFF0083FF0080FF0084FF008EFF009CFF00ACFF00BCFF00C8FF00D0FF00D0FF
00CAFF00C1FF00B9FF00B8FF00BDFF00BEFF00B6FF00ADFF00A6FF00A5FF00ABFF00B7FF
00C6FF00D6FF00E5FF00EFFF00F5FF00F4FF00ECFF00DFFF00CDFF00B8FF00A1FF008AFF
0074FF0062FF0055FF004CFF004AFF004EFF0058FF0068FF007CFF0095FF00B1FF00CFFF
00EEFF00FFF400FFD800FFBF00FFAA00FF9A00FF9000FF8B00FF8D00FF9500FFA200FFB6
00FFCE00FFEB00F4FF00D0FF00ACFF0086FF0060FF003CFF001AFF0300FF1E00FF3500FF
4600FF5200FF5800FF5700FF5100FF4400FF3200FF1A00FF0002FF0023FF0048FF0071FF
009BFF00C7FF00F4FF00FFDE00FFB200FF8800FF6000FF3C00FF1B00FF0017FF0028FF00
34FF003AFF003AFF0034FF0028FF0016FF0000FF0100FF1E00FF4000FF6700FF9100FFBF
00FFEF00DDFF00AAFF0075FF0041FF000EFF2300FF5300FF
00FF6100FF9000FFC200FFF500D6FF00A2FF006EFF003BFF000AFF2300FF4E00FF7500FF
9800FFB700FFCF00FFE300FFF000FFF700FFF900FFF400FFE900FFD900FFC300FFA700FF
8800FF6400FF3D00FF1300FF0017FF0044FF0071FF009DFF00C8FF00F1FF00FFE800FFC6
00FFA800FF8F00FF7C00FF6E00FF6600FF6500FF6A00FF7400FF8400FF9A00FFB400FFD2
00FFF300E8FF00C3FF009DFF0078FF0054FF0033FF0016FF0300FF1700FF2600FF2F00FF
3200FF2E00FF2500FF1600FF0200FF0015FF0030FF004EFF006CFF008AFF00A6FF00C0FF
00D6FF00E7FF00F2FF00F7FF00F6FF00EFFF00E2FF00D0FF00BCFF00A5FF008EFF0078FF
0065FF0057FF004EFF004CFF0050FF005AFF0068FF0078FF0088FF0094FF009BFF009CFF
0096FF008CFF0084FF0084FF0088FF0089FF0082FF0079FF0072FF0071FF0077FF0082FF
0092FF00A2FF00B1FF00BBFF00C0FF00BFFF00B8FF00ABFF0099FF0084FF006DFF0056FF
0040FF002EFF0020FF0018FF0016FF001AFF0024FF0033FF0048FF0061FF007DFF009BFF
00B9FF00D7FF00F3FF00FFF300FFDE00FFCF00FFC400FFBF00FFC100FFC900FFD700FFEA
00FDFF00E0FF00BFFF009CFF0077FF0052FF002CFF0008FF1900FF3800FF5300FF6900FF
7A00FF8600FF8C00FF8B00FF8500FF7800FF6600FF4E00FF3100FF1000FF0014FF003CFF
0067FF0093FF00C0FF00EDFF00FFE600FFBC00FF9400FF7000FF4F00FF3300FF1C00FF0B
00FF0006FF0006FF0000FF0000FF0B00FF1D00FF3500FF5200FF7400FF9B00FFC500FFF3
00DBFF00A9FF0075FF0041FF000DFF2500FF5700FF8700FF
00FF9500FFC400FFF500D7FF00A3FF006EFF003AFF0008FF2800FF5600FF8100FFA900FF
CC00FFEA00FFFF00FCFF00E9FF00DCFF00D4FF00D3FF00D8FF00E3FF00F3F600FFDB00FF
BB00FF9700FF7000FF4700FF1B00FF0011FF003EFF006AFF0095FF00BEFF00E4FF00FFF9
00FFDB00FFC300FFAF00FFA100FF9A00FF9800FF9D00FFA700FFB800FFCD00FFE700FAFF
00D8FF00B4FF008FFF006AFF0044FF0021FF0000FF1D00FF3600FF4B00FF5900FF6200FF
6500FF6200FF5800FF4900FF3600FF1D00FF0200FF001AFF0039FF0057FF0073FF008DFF
00A2FF00B3FF00BEFF00C4FF00C2FF00BBFF00AEFF009DFF0088FF0071FF005AFF0045FF
0032FF0024FF001BFF0019FF001DFF0027FF0035FF0045FF0054FF0061FF0068FF0069FF
0063FF0059FF0051FF0050FF0055FF0056FF004FFF0045FF003EFF003EFF0043FF004FFF
005EFF006FFF007DFF0088FF008DFF008CFF0085FF0078FF0066FF0050FF0039FF0022FF
000DFF0400FF1200FF1A00FF1D00FF1900FF0F00FF0000FF0015FF002EFF004AFF0068FF
0086FF00A4FF00C0FF00D8FF00EDFF00FDFF00FFF700FFF300FFF400FFFC00F5FF00E2FF
00C9FF00ADFF008CFF0069FF0044FF001EFF0600FF2A00FF4C00FF6B00FF8600FF9C00FF
AE00FFB900FFBF00FFBF00FFB800FFAC00FF9900FF8200FF6500FF4300FF1E00FF0009FF
0034FF0060FF008DFF00BAFF00E6FF00FFEF00FFC800FFA300FF8300FF6700FF5000FF3E
00FF3200FF2C00FF2C00FF3200FF3F00FF5100FF6900FF8600FFA800FFCE00FFF900D9FF
00A8FF0076FF0042FF000EFF2500FF5900FF8A00FFBA00FF
00FFC600FFF600D8FF00A5FF0071FF003DFF0009FF2900FF5A00FF8800FFB300FFDB00FF
FE00FFFF00E3FF00CAFF00B7FF00AAFF00A2FF00A1FF00A6FF00B1FF00C1FF00D7FF00F2
ED00FFC900FFA200FF7800FF4D00FF2000FF000CFF0038FF0063FF008CFF00B2FF00D4FF
00F2FF00FFF400FFE100FFD300FFCC00FFCA00FFCF00FFD900FFE900FFFF00E6FF00C8FF
00A6FF0083FF005DFF0038FF0013FF1000FF3100FF4F00FF6800FF7C00FF8B00FF9400FF
9700FF9400FF8A00FF7B00FF6700FF4F00FF3400FF1700FF0007FF0025FF0041FF005BFF
0071FF0082FF008DFF0092FF0091FF0089FF007DFF006BFF0056FF0040FF0028FF0013FF
0000FF0D00FF1600FF1800FF1400FF0A00FF0003FF0013FF0023FF002FFF0036FF0037FF
0031FF0027FF001FFF001FFF0023FF0024FF001DFF0013FF000DFF000CFF0012FF001DFF
002DFF003DFF004BFF0056FF005BFF005AFF0053FF0046FF0034FF001FFF0008FF0E00FF
2400FF3600FF4400FF4C00FF4E00FF4A00FF4000FF3100FF1C00FF0300FF0018FF0036FF
0054FF0072FF008EFF00A7FF00BBFF00CBFF00D6FF00DAFF00D9FF00D1FF00C3FF00B0FF
0098FF007BFF005AFF0037FF0012FF1200FF3800FF5C00FF7E00FF9D00FFB800FFCE00FF
DF00FFEB00FFF100FFF100FFEA00FFDE00FFCB00FFB300FF9700FF7500FF5000FF2800FF
0002FF002EFF005BFF0088FF00B4FF00DEFF00FFFA00FFD500FFB500FF9900FF8200FF70
00FF6400FF5E00FF5E00FF6400FF7000FF8300FF9A00FFB800FFDA00FFFF00D4FF00A7FF
0076FF0044FF0010FF2300FF5700FF8A00FFBC00FFEC00FF
00FFF600DAFF00A8FF0075FF0041FF000DFF2600FF5900FF8900FFB800FFE300FFFF00F5
FF00D2FF00B4FF009BFF0088FF007AFF0073FF0071FF0076FF0081FF0092FF00A8FF00C3
FF00E3F900FFD200FFA800FF7C00FF5000FF2300FF0009FF0034FF005CFF0082FF00A4FF
00C2FF00DBFF00EEFF00FCFF00FFFB00FFFA00FFFE00F6FF00E6FF00D1FF00B6FF0098FF
0077FF0053FF002EFF0008FF1C00FF4000FF6100FF7E00FF9800FFAC00FFBB00FFC400FF
C600FFC300FFBA00FFAB00FF9700FF7F00FF6400FF4600FF2800FF0A00FF0012FF002BFF
0041FF0052FF005DFF0062FF0061FF005AFF004DFF003CFF0027FF0010FF0600FF1C00FF
2F00FF3D00FF4500FF4800FF4400FF3A00FF2C00FF1C00FF0C00FF0000FF0007FF0007FF
0001FF0700FF0F00FF1000FF0B00FF0A00FF1100FF1B00FF2200FF2300FF1D00FF1100FF
0200FF000DFF001CFF0026FF002CFF002BFF0023FF0016FF0004FF1000FF2700FF3E00FF
5300FF6600FF7300FF7C00FF7E00FF7A00FF7000FF6000FF4B00FF3300FF1700FF0006FF
0025FF0042FF005EFF0077FF008CFF009CFF00A6FF00ABFF00A9FF00A1FF0094FF0080FF
0068FF004BFF002BFF0008FF1C00FF4200FF6700FF8C00FFAD00FFCC00FFE700FFFE00FF
FF00F0FF00E4FF00DFFF00DFFF00E5FF00F2FB00FFE300FFC600FFA500FF8000FF5700FF
2D00FF0000FF002BFF0058FF0084FF00AEFF00D6FF00FAFF00FFE400FFC800FFB100FF9F
00FF9400FF8E00FF8E00FF9400FFA000FFB200FFCA00FFE700F6FF00CFFF00A5FF0077FF
0047FF0014FF1E00FF5300FF8700FFBA00FFEC00FFFF00E3
pop
P
% End of image
1 1 1 r
.5 .02381 m
.5 .97619 L
.5465 .97619 L
.5465 .02381 L
F
.59301 .02381 m
.59301 .97619 L
.68601 .97619 L
.68601 .02381 L
F
.02381 .5 m
.02381 .77902 L
.97619 .77902 L
.97619 .5 L
F
0 g
gsave
.5 .68601 -105 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Forbidden) show
123.000 13.000 moveto
(area) show
147.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .59301 -105 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Hard) show
93.000 13.000 moveto
(constrain) show
147.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.015 w
.55649 .87109 Mdot
[(1)] .57149 .87109 -1 0 Mshowa
.0359 .78925 Mdot
[(2)] .0509 .78925 -1 0 Mshowa
.93992 .89063 Mdot
[(3)] .95492 .89063 -1 0 Mshowa
.77251 .44925 Mdot
[(4)] .78751 .44925 -1 0 Mshowa
.58297 .31223 Mdot
[(5)] .59797 .31223 -1 0 Mshowa
.10565 .19875 Mdot
[(6)] .12065 .19875 -1 0 Mshowa
.37351 .49603 Mdot
[(7)] .38851 .49603 -1 0 Mshowa
.54897 .92876 Mdot
[(8)] .56397 .92876 -1 0 Mshowa
.55788 .39297 Mdot
[(9)] .57288 .39297 -1 0 Mshowa
.36979 .15103 Mdot
[(10)] .38479 .15103 -1 0 Mshowa
.03 w
.55649 .87109 Mdot
.0359 .78925 Mdot
.93992 .89063 Mdot
.77251 .44925 Mdot
.58297 .31223 Mdot
.10565 .19875 Mdot
.37351 .49603 Mdot
.54897 .92876 Mdot
.55788 .39297 Mdot
.36979 .15103 Mdot
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.0055371 0.488926 0.227021 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.00093006 0.5 0.00093006 [
[.12798 -0.0125 -12 -9 ]
[.12798 -0.0125 12 0 ]
[.31399 -0.0125 -12 -9 ]
[.31399 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.68601 -0.0125 -9 -9 ]
[.68601 -0.0125 9 0 ]
[.87202 -0.0125 -9 -9 ]
[.87202 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .12798 -24 -4.5 ]
[-0.0125 .12798 0 4.5 ]
[-0.0125 .31399 -24 -4.5 ]
[-0.0125 .31399 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .68601 -18 -4.5 ]
[-0.0125 .68601 0 4.5 ]
[-0.0125 .87202 -18 -4.5 ]
[-0.0125 .87202 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 .68601 -44 -6.375 ]
[.5 .68601 44 6.375 ]
[.5 .59301 -44 -6.375 ]
[.5 .59301 44 6.375 ]
[.84703 .43795 0 -4.5 ]
[.84703 .43795 6 4.5 ]
[.12251 .45698 0 -4.5 ]
[.12251 .45698 6 4.5 ]
[.20715 .86644 0 -4.5 ]
[.20715 .86644 6 4.5 ]
[.82657 .89249 0 -4.5 ]
[.82657 .89249 6 4.5 ]
[.78751 .79483 0 -4.5 ]
[.78751 .79483 6 4.5 ]
[.58668 .1859 0 -4.5 ]
[.58668 .1859 6 4.5 ]
[.40804 .88318 0 -4.5 ]
[.40804 .88318 6 4.5 ]
[.58289 .46744 0 -4.5 ]
[.58289 .46744 6 4.5 ]
[.92702 .94922 0 -4.5 ]
[.92702 .94922 6 4.5 ]
[.46385 .1894 0 -4.5 ]
[.46385 .1894 12 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12798 0 m
.12798 .00625 L
s
[(-400)] .12798 -0.0125 0 1 Mshowa
.31399 0 m
.31399 .00625 L
s
[(-200)] .31399 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.68601 0 m
.68601 .00625 L
s
[(200)] .68601 -0.0125 0 1 Mshowa
.87202 0 m
.87202 .00625 L
s
[(400)] .87202 -0.0125 0 1 Mshowa
.125 Mabswid
.17448 0 m
.17448 .00375 L
s
.22098 0 m
.22098 .00375 L
s
.26749 0 m
.26749 .00375 L
s
.36049 0 m
.36049 .00375 L
s
.40699 0 m
.40699 .00375 L
s
.4535 0 m
.4535 .00375 L
s
.5465 0 m
.5465 .00375 L
s
.59301 0 m
.59301 .00375 L
s
.63951 0 m
.63951 .00375 L
s
.73251 0 m
.73251 .00375 L
s
.77902 0 m
.77902 .00375 L
s
.82552 0 m
.82552 .00375 L
s
.08147 0 m
.08147 .00375 L
s
.03497 0 m
.03497 .00375 L
s
.91853 0 m
.91853 .00375 L
s
.96503 0 m
.96503 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .12798 m
.00625 .12798 L
s
[(-400)] -0.0125 .12798 1 0 Mshowa
0 .31399 m
.00625 .31399 L
s
[(-200)] -0.0125 .31399 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .68601 m
.00625 .68601 L
s
[(200)] -0.0125 .68601 1 0 Mshowa
0 .87202 m
.00625 .87202 L
s
[(400)] -0.0125 .87202 1 0 Mshowa
.125 Mabswid
0 .17448 m
.00375 .17448 L
s
0 .22098 m
.00375 .22098 L
s
0 .26749 m
.00375 .26749 L
s
0 .36049 m
.00375 .36049 L
s
0 .40699 m
.00375 .40699 L
s
0 .4535 m
.00375 .4535 L
s
0 .5465 m
.00375 .5465 L
s
0 .59301 m
.00375 .59301 L
s
0 .63951 m
.00375 .63951 L
s
0 .73251 m
.00375 .73251 L
s
0 .77902 m
.00375 .77902 L
s
0 .82552 m
.00375 .82552 L
s
0 .08147 m
.00375 .08147 L
s
0 .03497 m
.00375 .03497 L
s
0 .91853 m
.00375 .91853 L
s
0 .96503 m
.00375 .96503 L
s
.25 Mabswid
0 0 m
0 1 L
s
.12798 .99375 m
.12798 1 L
s
.31399 .99375 m
.31399 1 L
s
.5 .99375 m
.5 1 L
s
.68601 .99375 m
.68601 1 L
s
.87202 .99375 m
.87202 1 L
s
.125 Mabswid
.17448 .99625 m
.17448 1 L
s
.22098 .99625 m
.22098 1 L
s
.26749 .99625 m
.26749 1 L
s
.36049 .99625 m
.36049 1 L
s
.40699 .99625 m
.40699 1 L
s
.4535 .99625 m
.4535 1 L
s
.5465 .99625 m
.5465 1 L
s
.59301 .99625 m
.59301 1 L
s
.63951 .99625 m
.63951 1 L
s
.73251 .99625 m
.73251 1 L
s
.77902 .99625 m
.77902 1 L
s
.82552 .99625 m
.82552 1 L
s
.08147 .99625 m
.08147 1 L
s
.03497 .99625 m
.03497 1 L
s
.91853 .99625 m
.91853 1 L
s
.96503 .99625 m
.96503 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .12798 m
1 .12798 L
s
.99375 .31399 m
1 .31399 L
s
.99375 .5 m
1 .5 L
s
.99375 .68601 m
1 .68601 L
s
.99375 .87202 m
1 .87202 L
s
.125 Mabswid
.99625 .17448 m
1 .17448 L
s
.99625 .22098 m
1 .22098 L
s
.99625 .26749 m
1 .26749 L
s
.99625 .36049 m
1 .36049 L
s
.99625 .40699 m
1 .40699 L
s
.99625 .4535 m
1 .4535 L
s
.99625 .5465 m
1 .5465 L
s
.99625 .59301 m
1 .59301 L
s
.99625 .63951 m
1 .63951 L
s
.99625 .73251 m
1 .73251 L
s
.99625 .77902 m
1 .77902 L
s
.99625 .82552 m
1 .82552 L
s
.99625 .08147 m
1 .08147 L
s
.99625 .03497 m
1 .03497 L
s
.99625 .91853 m
1 .91853 L
s
.99625 .96503 m
1 .96503 L
s
.25 Mabswid
1 0 m
1 1 L
s
% Start of colorimage (RGB)
p
.02381 .02381 translate
.95145 .95145 scale
600 string
200 200 8 [200 0 0 200 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  false 3 Mcolorimage
FFD100FFFF00CEFF009BFF0067FF0032FF0000FF0100FF3300FF6400FF9200FFBD00FFE5
00F7FF00D9FF00C0FF00ADFF00A0FF0098FF0097FF009CFF00A7FF00B7FF00CDFF00E8FF
00FFF700FFD300FFAC00FF8300FF5700FF2A02FF002EFF0059FF0082FF00A8FF00CAFF00
E8FF00FFFF00FFEB00FFDD00FFD600FFD400FFD900FFE300FFF400F6FF00DCFF00BEFF00
9CFF0078FF0053FF002EFF0008FF0000FF1A00FF3B00FF5900FF7200FF8700FF9500FF9E
00FFA100FF9E00FF9400FF8500FF7200FF5900FF3E00FF2100FF021BFF0037FF0051FF00
67FF0077FF0083FF0088FF0086FF007FFF0073FF0061FF004CFF0035FF001EFF0009FF00
00FF0900FF1700FF2000FF2200FF1E00FF1400FF0609FF0018FF0025FF002CFF002DFF00
27FF001DFF0015FF0014FF0019FF001AFF0013FF0009FF0002FF0002FF0007FF0013FF00
22FF0033FF0041FF004CFF0051FF0050FF0049FF003CFF002AFF0014FF0000FF0200FF19
00FF2E00FF4000FF4E00FF5600FF5900FF5500FF4B00FF3B00FF2600FF0D0EFF002CFF00
4AFF0068FF0084FF009CFF00B1FF00C1FF00CCFF00D0FF00CFFF00C7FF00B9FF00A6FF00
8DFF0071FF0050FF002DFF0008FF0000FF1D00FF4200FF6600FF8800FFA700FFC200FFD8
00FFEA00FFF500FFFB00FFFB00FFF400FFE800FFD500FFBE00FFA100FF7F00FF5A00FF32
00FF0724FF0051FF007EFF00AAFF00D4FF00FBFF00FFDF00FFBF00FFA300FF8C00FF7A00
FF6E00FF6800FF6800FF6E00FF7B00FF8D00FFA500FFC200FFE400F5FF00CAFF009DFF00
6CFF003AFF0006FF0000FF2D00FF6100FF9500FFC600FFF6
FFFF00D0FF009FFF006CFF0038FF0003FF0000FF3000FF6200FF9300FFC100FFED00EBFF
00C8FF00AAFF0091FF007EFF0070FF0069FF0068FF006DFF0077FF0088FF009EFF00B9FF
00D9FF00FDFF00FFDB00FFB200FF8600FF5900FF2C00FF002AFF0053FF0079FF009BFF00
B9FF00D1FF00E5FF00F2FF00FAFF00FCFF00F7FF00EDFF00DCFF00C7FF00ADFF008FFF00
6DFF0049FF0024FF0000FF0100FF2600FF4900FF6A00FF8800FFA100FFB600FFC400FFCD
00FFD000FFCD00FFC300FFB500FFA100FF8900FF6D00FF5000FF3100FF1308FF0022FF00
37FF0048FF0053FF0058FF0057FF0050FF0043FF0032FF001DFF0006FF0000FF1000FF26
00FF3800FF4700FF4F00FF5100FF4D00FF4300FF3600FF2500FF1600FF0900FF0200FF02
00FF0700FF1100FF1900FF1A00FF1500FF1400FF1B00FF2500FF2C00FF2D00FF2700FF1B
00FF0C04FF0012FF001DFF0022FF0021FF001AFF000DFF0000FF0400FF1A00FF3100FF48
00FF5D00FF6F00FF7D00FF8500FF8800FF8400FF7A00FF6A00FF5500FF3C00FF2000FF02
1BFF0039FF0055FF006DFF0082FF0092FF009DFF00A1FF00A0FF0098FF008AFF0077FF00
5EFF0041FF0021FF0000FF0100FF2600FF4C00FF7100FF9500FFB700FFD600FFF100F8FF
00E6FF00DBFF00D5FF00D5FF00DCFF00E8FF00FBFF00FFED00FFD000FFAE00FF8900FF61
00FF3600FF0A22FF004FFF007AFF00A5FF00CCFF00F1FF00FFEE00FFD200FFBB00FFA900
FF9D00FF9700FF9700FF9D00FFAA00FFBC00FFD400FFF100ECFF00C6FF009BFF006DFF00
3DFF000BFF0000FF2800FF5C00FF9000FFC400FFF600DAFF
CEFF009FFF006DFF003AFF0006FF0000FF2D00FF6100FF9400FFC500FFF300E1FF00BAFF
0097FF0079FF0060FF004CFF003FFF0038FF0036FF003BFF0046FF0057FF006DFF0088FF
00A7FF00CBFF00F2FF00FFE300FFB800FF8B00FF5E00FF3100FF0621FF0047FF0069FF00
87FF00A0FF00B3FF00C1FF00C9FF00CAFF00C6FF00BBFF00ABFF0095FF007BFF005DFF00
3CFF0018FF0000FF0C00FF3200FF5700FF7B00FF9C00FFB900FFD300FFE700FFF600FFFF
00FDFF00FFFE00FFF500FFE600FFD200FFBA00FF9F00FF8100FF6300FF4500FF2800FF0F
06FF0017FF0022FF0027FF0026FF001FFF0012FF0001FF0000FF1300FF2A00FF4100FF57
00FF6A00FF7800FF8000FF8300FF7F00FF7500FF6700FF5700FF4700FF3B00FF3300FF33
00FF3900FF4200FF4A00FF4B00FF4700FF4500FF4D00FF5600FF5D00FF5E00FF5800FF4C
00FF3D00FF2D00FF1E00FF1400FF0E00FF0F00FF1700FF2400FF3600FF4B00FF6200FF79
00FF8F00FFA100FFAE00FFB700FFB900FFB500FFAB00FF9B00FF8700FF6E00FF5200FF34
00FF1507FF0023FF003CFF0051FF0061FF006BFF0070FF006EFF0066FF0059FF0045FF00
2DFF0010FF0000FF0F00FF3300FF5700FF7D00FFA300FFC700FFE900F8FF00DDFF00C6FF
00B5FF00A9FF00A3FF00A4FF00AAFF00B7FF00C9FF00E1FF00FEFF00FFE000FFBB00FF92
00FF6800FF3C00FF0F1DFF0049FF0073FF009BFF00BFFF00E0FF00FCFF00FFEC00FFDB00
FFCF00FFC900FFC900FFCF00FFDB00FFED00FAFF00DDFF00BBFF0094FF006AFF003CFF00
0CFF0000FF2600FF5900FF8E00FFC200FFF500D8FF00A8FF
9BFF006CFF003AFF0007FF0000FF2C00FF6000FF9400FFC700FFF800D9FF00AEFF0087FF
0064FF0046FF002DFF0019FF000CFF0005FF0003FF0008FF0013FF0024FF003AFF0055FF
0074FF0098FF00BFFF00E9FF00FFEB00FFBE00FF9100FF6500FF3A00FF1114FF0036FF00
54FF006DFF0080FF008EFF0096FF0097FF0093FF0088FF0078FF0062FF0048FF002AFF00
09FF0000FF1A00FF3F00FF6500FF8A00FFAE00FFCF00FFEC00F9FF00E5FF00D6FF00CDFF
00CAFF00CEFF00D7FF00E6FF00FAFF00FFED00FFD200FFB400FF9600FF7800FF5B00FF42
00FF2C00FF1B00FF1000FF0B00FF0C00FF1300FF2000FF3200FF4600FF5D00FF7400FF8A
00FF9D00FFAB00FFB400FFB600FFB200FFA800FF9A00FF8A00FF7A00FF6E00FF6600FF66
00FF6C00FF7500FF7E00FF7E00FF7A00FF7900FF8000FF8900FF9000FF9100FF8B00FF7F
00FF7000FF6000FF5100FF4700FF4100FF4200FF4A00FF5700FF6900FF7E00FF9500FFAC
00FFC200FFD400FFE100FFEA00FFEC00FFE800FFDE00FFCF00FFBA00FFA100FF8500FF67
00FF4900FF2B00FF0F09FF001EFF002EFF0038FF003DFF003BFF0033FF0026FF0012FF00
00FF0500FF2200FF4300FF6600FF8B00FFB000FFD600FFFA00E3FF00C4FF00A9FF0093FF
0082FF0076FF0070FF0071FF0077FF0084FF0096FF00AEFF00CBFF00ECFF00FFEE00FFC6
00FF9B00FF6F00FF4200FF1516FF0040FF0068FF008CFF00ADFF00C9FF00E0FF00F1FF00
FDFF00FFFC00FFFC00FDFF00F1FF00DFFF00C7FF00AAFF0088FF0061FF0037FF0009FF00
00FF2600FF5900FF8D00FFC100FFF500D7FF00A5FF0075FF
67FF0038FF0006FF0000FF2C00FF6000FF9400FFC800FFFB00D3FF00A5FF007AFF0053FF
0030FF0011FF0600FF1A00FF2700FF2E00FF3000FF2B00FF2000FF1000FF0005FF0021FF
0040FF0064FF008BFF00B5FF00E0FF00FFF200FFC500FF9900FF6E00FF4500FF1F02FF00
20FF0039FF004CFF005AFF0062FF0063FF005EFF0054FF0044FF002EFF0014FF0000FF09
00FF2A00FF4E00FF7300FF9900FFBE00FFE200FCFF00DFFF00C5FF00B1FF00A2FF0099FF
0096FF009AFF00A3FF00B2FF00C6FF00DEFF00F9FF00FFE800FFCA00FFAC00FF8F00FF76
00FF6000FF4F00FF4400FF3F00FF4000FF4700FF5400FF6600FF7A00FF9100FFA800FFBE
00FFD100FFDF00FFE800FFEA00FFE600FFDC00FFCE00FFBE00FFAE00FFA200FF9B00FF9A
00FFA000FFAA00FFB200FFB200FFAE00FFAD00FFB400FFBD00FFC400FFC500FFBF00FFB4
00FFA400FF9400FF8500FF7B00FF7600FF7600FF7E00FF8B00FF9D00FFB200FFC900FFE0
00FFF600F7FF00E9FF00E1FF00DFFF00E3FF00EDFF00FCFF00FFEE00FFD500FFB900FF9B
00FF7D00FF5F00FF4300FF2A00FF1500FF0604FF0009FF0007FF0000FF0000FF0E00FF21
00FF3900FF5600FF7700FF9A00FFBF00FFE400F5FF00D1FF00AFFF0090FF0075FF005FFF
004EFF0042FF003CFF003DFF0043FF0050FF0062FF007AFF0097FF00B8FF00DDFF00FFFA
00FFCF00FFA300FF7600FF4900FF1D0CFF0034FF0058FF0079FF0095FF00ACFF00BDFF00
C9FF00CFFF00CFFF00C9FF00BDFF00ABFF0093FF0076FF0054FF002DFF0003FF0000FF2A
00FF5B00FF8D00FFC100FFF500D6FF00A3FF0071FF0041FF
32FF0003FF0000FF2D00FF6000FF9400FFC900FFFD00D0FF009FFF0071FF0046FF001EFF
0400FF2200FF3B00FF4E00FF5B00FF6300FF6400FF5F00FF5400FF4400FF2E00FF1300FF
000CFF0030FF0057FF0080FF00ACFF00D9FF00FFF900FFCD00FFA200FF7900FF5300FF31
00FF1304FF0018FF0026FF002DFF002FFF002AFF0020FF000FFF0000FF0500FF1F00FF3D
00FF5F00FF8300FFA800FFCD00FFF300E9FF00C8FF00AAFF0091FF007DFF006EFF0065FF
0062FF0065FF006FFF007EFF0091FF00AAFF00C5FF00E2FF00FFFE00FFE000FFC400FFAA
00FF9400FF8400FF7800FF7300FF7500FF7C00FF8800FF9A00FFAF00FFC600FFDD00FFF2
00FAFF00ECFF00E3FF00E1FF00E5FF00EFFF00FDFF00FFF200FFE300FFD600FFCF00FFCE
00FFD400FFDE00FFE600FFE700FFE200FFE100FFE800FFF200FFF900FFF900FFF400FFE8
00FFD900FFC800FFBA00FFAF00FFAA00FFAB00FFB200FFBF00FFD100FFE700FFFE00EAFF
00D5FF00C3FF00B5FF00ADFF00AAFF00AEFF00B8FF00C8FF00DDFF00F6FF00FFED00FFCF
00FFB100FF9300FF7700FF5F00FF4A00FF3A00FF2F00FF2B00FF2C00FF3400FF4200FF55
00FF6E00FF8A00FFAB00FFCE00FFF300E6FF00C1FF009DFF007BFF005CFF0041FF002BFF
0019FF000EFF0008FF0008FF000FFF001BFF002EFF0045FF0062FF0084FF00A9FF00D1FF
00FCFF00FFD700FFAA00FF7D00FF5100FF2700FF0024FF0044FF0060FF0077FF0089FF00
95FF009BFF009BFF0095FF0088FF0076FF005EFF0041FF001FFF0000FF0600FF3100FF5E
00FF8F00FFC100FFF500D6FF00A2FF006EFF003DFF000DFF
00FF0100FF3000FF6100FF9400FFC800FFFD00CFFF009CFF006BFF003DFF0012FF1500FF
3800FF5600FF6F00FF8200FF8F00FF9700FF9800FF9300FF8800FF7800FF6200FF4700FF
2700FF0300FF0023FF004DFF0078FF00A5FF00D2FF00FEFF00FFD600FFAD00FF8700FF65
00FF4700FF2E00FF1B00FF0D00FF0600FF0400FF0900FF1300FF2300FF3900FF5300FF71
00FF9300FFB600FFDC00FEFF00D9FF00B5FF0094FF0076FF005DFF0049FF003AFF0031FF
002EFF0031FF003BFF004AFF005EFF0076FF0091FF00AEFF00CDFF00EBFF00FFF800FFDE
00FFC800FFB800FFAC00FFA700FFA800FFB000FFBC00FFCE00FFE300FFF900EEFF00D9FF
00C6FF00B8FF00AFFF00ADFF00B1FF00BBFF00C9FF00D9FF00E9FF00F5FF00FCFF00FDFF
00F7FF00EDFF00E5FF00E5FF00E9FF00EAFF00E3FF00D9FF00D3FF00D2FF00D8FF00E3FF
00F3FF00FFFC00FFEE00FFE300FFDE00FFDF00FFE600FFF300FAFF00E5FF00CEFF00B6FF
00A1FF008FFF0081FF0079FF0077FF007AFF0084FF0094FF00A9FF00C2FF00DEFF00FCFF
00FFE500FFC700FFAB00FF9200FF7E00FF6E00FF6300FF5F00FF6000FF6800FF7600FF89
00FFA100FFBE00FFDF00FDFF00D8FF00B3FF008DFF0069FF0047FF0028FF000DFF0800FF
1900FF2500FF2B00FF2B00FF2400FF1800FF0500FF0012FF002EFF0050FF0075FF009DFF
00C8FF00F4FF00FFDE00FFB100FF8500FF5B00FF3400FF0F10FF002CFF0043FF0055FF00
61FF0067FF0067FF0061FF0055FF0042FF002BFF000DFF0000FF1400FF3A00FF6500FF92
00FFC300FFF500D6FF00A2FF006EFF003AFF0009FF2600FF
00FF3300FF6200FF9400FFC700FFFB00D0FF009CFF0069FF0038FF000AFF2000FF4700FF
6A00FF8800FFA100FFB500FFC200FFC900FFCB00FFC600FFBB00FFAA00FF9400FF7900FF
5A00FF3600FF0F00FF001AFF0045FF0072FF009FFF00CCFF00F7FF00FFE000FFBA00FF98
00FF7A00FF6100FF4E00FF4000FF3800FF3700FF3B00FF4600FF5600FF6C00FF8600FFA4
00FFC500FFE900F1FF00CBFF00A6FF0082FF0061FF0044FF002AFF0016FF0007FF0100FF
0400FF0000FF0008FF0017FF002BFF0043FF005EFF007CFF009AFF00B8FF00D5FF00EEFF
00FFFB00FFEA00FFDF00FFDA00FFDB00FFE200FFEF00FFFF00EAFF00D3FF00BCFF00A6FF
0093FF0085FF007DFF007AFF007EFF0088FF0096FF00A6FF00B6FF00C2FF00CAFF00CAFF
00C4FF00BBFF00B3FF00B2FF00B6FF00B8FF00B0FF00A7FF00A0FF009FFF00A5FF00B1FF
00C0FF00D0FF00DFFF00E9FF00EFFF00EEFF00E6FF00D9FF00C7FF00B2FF009BFF0084FF
006EFF005CFF004FFF0046FF0044FF0048FF0052FF0062FF0076FF008FFF00ABFF00C9FF
00E8FF00FFFA00FFDE00FFC500FFB000FFA000FF9600FF9100FF9300FF9B00FFA800FFBC
00FFD400FFF100EEFF00CAFF00A6FF0080FF005AFF0036FF0014FF0900FF2400FF3B00FF
4C00FF5800FF5E00FF5D00FF5700FF4A00FF3800FF2000FF0300FF001DFF0042FF006BFF
0095FF00C1FF00EEFF00FFE400FFB800FF8E00FF6600FF4200FF2100FF0511FF0022FF00
2EFF0034FF0034FF002EFF0022FF0010FF0000FF0700FF2400FF4600FF6D00FF9700FFC5
00FFF500D7FF00A4FF006FFF003BFF0008FF2900FF5900FF
00FF6400FF9300FFC500FFF800D3FF009FFF006BFF0038FF0008FF2600FF5100FF7800FF
9B00FFB900FFD200FFE500FFF300FFFA00FFFB00FFF700FFEC00FFDB00FFC500FFAA00FF
8A00FF6700FF4000FF1600FF0015FF0041FF006EFF009BFF00C6FF00EFFF00FFEB00FFC9
00FFAB00FF9200FF7E00FF7100FF6900FF6800FF6C00FF7700FF8700FF9C00FFB700FFD5
00FFF600E5FF00C0FF009AFF0075FF0051FF0030FF0013FF0500FF1A00FF2900FF3200FF
3400FF3100FF2800FF1900FF0500FF0012FF002DFF004BFF0069FF0087FF00A4FF00BDFF
00D3FF00E4FF00EFFF00F4FF00F3FF00ECFF00DFFF00CEFF00B9FF00A2FF008BFF0075FF
0062FF0054FF004CFF0049FF004EFF0057FF0065FF0075FF0085FF0092FF0099FF0099FF
0093FF008AFF0082FF0081FF0086FF0087FF0080FF0076FF006FFF006EFF0074FF0080FF
008FFF009FFF00AEFF00B9FF00BEFF00BDFF00B5FF00A8FF0096FF0081FF006AFF0053FF
003EFF002BFF001EFF0015FF0013FF0017FF0021FF0031FF0046FF005FFF007AFF0098FF
00B7FF00D4FF00F0FF00FFF600FFE100FFD100FFC700FFC200FFC400FFCC00FFD900FFED
00FAFF00DDFF00BDFF009AFF0075FF004FFF002AFF0006FF1B00FF3A00FF5500FF6C00FF
7D00FF8900FF8E00FF8E00FF8800FF7B00FF6900FF5100FF3400FF1300FF0011FF003AFF
0064FF0091FF00BDFF00EAFF00FFE900FFBF00FF9700FF7300FF5200FF3600FF1F00FF0D
00FF0104FF0003FF0000FF0200FF0E00FF2000FF3800FF5500FF7700FF9E00FFC800FFF6
00D9FF00A6FF0073FF003EFF000AFF2800FF5A00FF8900FF
00FF9200FFC100FFF300D9FF00A5FF0071FF003DFF000AFF2600FF5400FF7F00FFA600FF
C900FFE700FFFF00FFFF00EBFF00DEFF00D7FF00D5FF00DAFF00E5FF00F5F300FFD800FF
B900FF9500FF6E00FF4400FF1900FF0013FF0040FF006CFF0097FF00C0FF00E6FF00FFF7
00FFD900FFC000FFAD00FF9F00FF9700FF9600FF9A00FFA500FFB500FFCB00FFE500FCFF
00DBFF00B7FF0092FF006CFF0047FF0023FF0002FF1A00FF3400FF4800FF5700FF6000FF
6300FF5F00FF5600FF4700FF3300FF1B00FF0000FF001DFF003BFF0059FF0076FF008FFF
00A5FF00B6FF00C1FF00C6FF00C5FF00BEFF00B1FF009FFF008BFF0074FF005DFF0047FF
0034FF0026FF001DFF001BFF001FFF0029FF0037FF0047FF0057FF0063FF006AFF006BFF
0065FF005BFF0053FF0053FF0057FF0058FF0051FF0048FF0041FF0040FF0046FF0052FF
0061FF0071FF0080FF008AFF008FFF008FFF0087FF007AFF0068FF0053FF003CFF0025FF
000FFF0200FF1000FF1800FF1A00FF1600FF0C00FF0002FF0017FF0030FF004CFF006AFF
0088FF00A6FF00C2FF00DBFF00F0FF00FFFF00FFF500FFF000FFF200FFFA00F7FF00E4FF
00CCFF00AFFF008EFF006BFF0046FF0021FF0400FF2800FF4A00FF6900FF8400FF9A00FF
AB00FFB700FFBD00FFBC00FFB600FFA900FF9700FF7F00FF6200FF4100FF1C00FF000BFF
0036FF0062FF008FFF00BCFF00E8FF00FFED00FFC500FFA100FF8000FF6400FF4D00FF3C
00FF3000FF2A00FF2A00FF3000FF3C00FF4E00FF6600FF8300FFA500FFCC00FFF600DBFF
00ABFF0078FF0044FF0010FF2300FF5600FF8800FFB800FF
00FFBD00FFED00E1FF00AEFF007AFF0046FF0012FF2000FF5100FF7F00FFAA00FFD100FF
F400FFFF00ECFF00D4FF00C0FF00B3FF00ABFF00AAFF00AFFF00BAFF00CAFF00E0FF00FC
E400FFC000FF9900FF6F00FF4400FF1700FF0015FF0041FF006CFF0095FF00BBFF00DDFF
00FBFF00FFEB00FFD800FFCA00FFC300FFC100FFC600FFD000FFE000FFF600EFFF00D1FF
00AFFF008CFF0066FF0041FF001CFF0700FF2800FF4600FF5F00FF7300FF8200FF8B00FF
8E00FF8A00FF8100FF7200FF5E00FF4600FF2B00FF0D00FF0010FF002EFF004AFF0064FF
007AFF008BFF0096FF009BFF009AFF0092FF0086FF0074FF0060FF0049FF0032FF001CFF
0009FF0400FF0D00FF0F00FF0B00FF0100FF000CFF001CFF002CFF0038FF003FFF0040FF
003AFF0030FF0028FF0028FF002CFF002DFF0026FF001DFF0016FF0015FF001BFF0026FF
0036FF0046FF0054FF005FFF0064FF0063FF005CFF004FFF003DFF0028FF0011FF0500FF
1B00FF2D00FF3B00FF4300FF4500FF4100FF3700FF2800FF1300FF0005FF0021FF003FFF
005DFF007BFF0097FF00B0FF00C4FF00D4FF00DFFF00E3FF00E2FF00DAFF00CCFF00B9FF
00A1FF0084FF0063FF0040FF001BFF0900FF2F00FF5300FF7500FF9400FFAF00FFC500FF
D600FFE200FFE800FFE700FFE100FFD400FFC200FFAA00FF8D00FF6C00FF4700FF1F00FF
000BFF0037FF0064FF0091FF00BDFF00E7FF00FFF000FFCC00FFAC00FF9000FF7800FF67
00FF5B00FF5500FF5500FF5B00FF6700FF7A00FF9100FFAF00FFD100FFF700DEFF00B0FF
007FFF004DFF0019FF1A00FF4E00FF8100FFB300FFE300FF
00FFE500EBFF00BAFF0087FF0053FF001EFF1500FF4700FF7800FFA600FFD100FFF900FF
FF00E3FF00C5FF00ACFF0099FF008CFF0084FF0083FF0088FF0092FF00A3FF00B9FF00D4
FF00F4E700FFC000FF9700FF6B00FF3E00FF1100FF001AFF0045FF006EFF0094FF00B6FF
00D4FF00ECFF00FFFF00FFF100FFEA00FFE800FFED00FFF700F7FF00E2FF00C8FF00AAFF
0088FF0064FF003FFF0019FF0B00FF2E00FF4F00FF6D00FF8600FF9B00FFA900FFB200FF
B500FFB200FFA800FF9A00FF8600FF6E00FF5200FF3500FF1600FF0007FF0023FF003DFF
0052FF0063FF006EFF0074FF0072FF006BFF005EFF004DFF0038FF0021FF000AFF0B00FF
1D00FF2B00FF3400FF3600FF3200FF2800FF1A00FF0A00FF0004FF0011FF0018FF0019FF
0013FF0009FF0001FF0000FF0005FF0006FF0000FF0A00FF1100FF1200FF0C00FF0000FF
000EFF001FFF002DFF0038FF003DFF003CFF0035FF0028FF0016FF0000FF1600FF2D00FF
4200FF5400FF6200FF6A00FF6D00FF6900FF5F00FF4F00FF3A00FF2100FF0500FF0018FF
0036FF0054FF0070FF0088FF009DFF00ADFF00B8FF00BCFF00BBFF00B3FF00A5FF0092FF
0079FF005CFF003CFF0019FF0B00FF3100FF5600FF7A00FF9C00FFBB00FFD600FFEC00FF
FE00FFFF00F6FF00F0FF00F0FF00F7FC00FFE900FFD200FFB500FF9300FF6E00FF4600FF
1B00FF0010FF003DFF006AFF0095FF00C0FF00E7FF00FFF300FFD300FFB700FFA000FF8E
00FF8200FF7C00FF7C00FF8200FF8F00FFA100FFB900FFD600FFF800E1FF00B6FF0088FF
0058FF0026FF0D00FF4100FF7500FFA900FFDB00FFFF00F5
00F7FF00C8FF0097FF0064FF0030FF0400FF3800FF6A00FF9B00FFC900FFF400FFFF00E3
FF00C0FF00A2FF0089FF0076FF0069FF0061FF0060FF0065FF0070FF0080FF0096FF00B1
FF00D1FF00F5E300FFBA00FF8E00FF6100FF3400FF0800FF0022FF004BFF0071FF0093FF
00B1FF00C9FF00DDFF00EBFF00F2FF00F4FF00EFFF00E5FF00D4FF00BFFF00A5FF0087FF
0065FF0041FF001CFF0800FF2E00FF5100FF7200FF9000FFA900FFBE00FFCC00FFD500FF
D800FFD500FFCB00FFBC00FFA900FF9000FF7500FF5800FF3900FF1B00FF0000FF001AFF
002FFF0040FF004BFF0051FF004FFF0048FF003BFF002AFF0015FF0100FF1800FF2E00FF
4000FF4E00FF5700FF5900FF5500FF4B00FF3D00FF2D00FF1E00FF1100FF0A00FF0900FF
0F00FF1900FF2100FF2200FF1D00FF1C00FF2300FF2D00FF3400FF3500FF2F00FF2300FF
1400FF0300FF000AFF0015FF001AFF0019FF0012FF0005FF0C00FF2200FF3900FF5000FF
6500FF7700FF8500FF8D00FF9000FF8C00FF8200FF7200FF5D00FF4400FF2800FF0A00FF
0013FF0031FF004DFF0065FF007AFF008AFF0095FF0099FF0098FF0090FF0082FF006FFF
0056FF0039FF0019FF0900FF2E00FF5400FF7900FF9D00FFBF00FFDE00FFF900FFFF00F0
FF00DEFF00D3FF00CDFF00CDFF00D4FF00E0FF00F3F500FFD800FFB600FF9100FF6900FF
3E00FF1200FF001AFF0047FF0073FF009DFF00C4FF00E9FF00FFF600FFDA00FFC300FFB1
00FFA500FF9F00FF9F00FFA500FFB200FFC400FFDC00FFF900E4FF00BEFF0093FF0066FF
0035FF0003FF3000FF6400FF9800FFCC00FFFE00FFFF00D2
00D9FF00AAFF0079FF0046FF0011FF2200FF5600FF8800FFB900FFE700FFFF00ECFF00C5
FF00A2FF0084FF006BFF0058FF004AFF0043FF0042FF0047FF0051FF0062FF0078FF0093
FF00B3FF00D6FF00FED800FFAC00FF7F00FF5300FF2600FF0004FF002DFF0053FF0075FF
0092FF00ABFF00BFFF00CCFF00D4FF00D6FF00D1FF00C6FF00B6FF00A1FF0087FF0068FF
0047FF0023FF0100FF2700FF4C00FF6F00FF9000FFAE00FFC700FFDC00FFEB00FFF300FF
F600FFF300FFEA00FFDB00FFC700FFAF00FF9300FF7600FF5700FF3900FF1D00FF0300FF
0011FF0022FF002DFF0032FF0031FF002AFF001DFF000CFF0800FF1F00FF3600FF4C00FF
5E00FF6D00FF7500FF7700FF7300FF6A00FF5C00FF4B00FF3C00FF2F00FF2800FF2800FF
2D00FF3700FF3F00FF4000FF3B00FF3A00FF4100FF4B00FF5200FF5300FF4D00FF4100FF
3200FF2200FF1300FF0800FF0300FF0400FF0B00FF1900FF2A00FF4000FF5700FF6E00FF
8300FF9500FFA300FFAB00FFAE00FFAA00FFA000FF9000FF7B00FF6200FF4600FF2800FF
0A00FF0013FF002EFF0047FF005CFF006CFF0076FF007BFF0079FF0072FF0064FF0051FF
0038FF001BFF0400FF2700FF4C00FF7200FF9700FFBB00FFDD00FFFC00FFFF00E8FF00D1
FF00C0FF00B5FF00AFFF00AFFF00B6FF00C2FF00D4FF00ECF600FFD500FFAF00FF8700FF
5C00FF3000FF0300FF0028FF0054FF007FFF00A6FF00CBFF00EBFF00FFF800FFE100FFCF
00FFC300FFBD00FFBD00FFC400FFD000FFE200FFFA00E8FF00C6FF00A0FF0075FF0047FF
0017FF1A00FF4E00FF8200FFB700FFEA00FFFF00E3FF00B4
00C0FF0091FF0060FF002DFF0600FF3B00FF6F00FFA100FFD200FFFF00FFFF00D4FF00AC
FF0089FF006BFF0052FF003FFF0032FF002AFF0029FF002EFF0038FF0049FF005FFF007A
FF009AFF00BEFF00E5F100FFC500FF9800FF6B00FF3F00FF1400FF0014FF003AFF005CFF
007AFF0092FF00A6FF00B4FF00BBFF00BDFF00B8FF00AEFF009DFF0088FF006EFF0050FF
002EFF000AFF1A00FF4000FF6500FF8800FFA900FFC700FFE000FFF500FFFF00FCFF00F3
FF00F0FF00F3FF00FDF300FFE000FFC800FFAC00FF8F00FF7000FF5200FF3600FF1C00FF
0700FF0009FF0014FF001AFF0018FF0011FF0004FF0C00FF2100FF3800FF4F00FF6500FF
7700FF8500FF8E00FF9000FF8C00FF8200FF7400FF6400FF5500FF4800FF4100FF4000FF
4600FF5000FF5800FF5900FF5400FF5300FF5A00FF6400FF6B00FF6C00FF6600FF5A00FF
4B00FF3A00FF2C00FF2100FF1C00FF1D00FF2400FF3100FF4300FF5900FF7000FF8700FF
9C00FFAE00FFBC00FFC400FFC700FFC300FFB900FFA900FF9400FF7B00FF5F00FF4100FF
2300FF0500FF0016FF002EFF0043FF0053FF005EFF0062FF0061FF0059FF004BFF0038FF
001FFF0002FF1D00FF4000FF6500FF8B00FFB000FFD400FFF600FFFF00EAFF00CFFF00B9
FF00A7FF009CFF0096FF0096FF009DFF00A9FF00BCFF00D3FF00F0ED00FFC800FFA000FF
7500FF4900FF1C00FF0010FF003BFF0066FF008DFF00B2FF00D2FF00EEFF00FFFA00FFE8
00FFDC00FFD600FFD600FFDC00FFE900FFFB00ECFF00CFFF00ADFF0087FF005CFF002FFF
0100FF3300FF6700FF9B00FFCF00FFFF00FCFF00CAFF009B
00ADFF007EFF004CFF0019FF1A00FF4E00FF8200FFB500FFE500FFFF00EBFF00C0FF0099
FF0076FF0058FF003FFF002CFF001EFF0017FF0016FF001AFF0025FF0036FF004CFF0067
FF0087FF00AAFF00D1FF00FBD800FFAC00FF7F00FF5200FF2700FF0001FF0026FF0049FF
0066FF007FFF0093FF00A0FF00A8FF00A9FF00A5FF009AFF008AFF0075FF005AFF003CFF
001BFF0800FF2D00FF5300FF7800FF9B00FFBD00FFDA00FFF300FFFF00F7FF00E8FF00DF
FF00DDFF00E0FF00E9FF00F8F300FFDB00FFBF00FFA200FF8400FF6600FF4900FF3000FF
1A00FF0900FF0001FF0006FF0005FF0100FF0E00FF1F00FF3400FF4B00FF6200FF7800FF
8B00FF9900FFA100FFA400FF9F00FF9600FF8800FF7800FF6800FF5B00FF5400FF5400FF
5A00FF6300FF6B00FF6C00FF6700FF6600FF6D00FF7700FF7E00FF7F00FF7900FF6D00FF
5E00FF4E00FF3F00FF3400FF2F00FF3000FF3800FF4500FF5700FF6C00FF8300FF9A00FF
AF00FFC100FFCF00FFD800FFDA00FFD600FFCC00FFBC00FFA700FF8E00FF7200FF5500FF
3600FF1800FF0002FF001BFF0030FF0040FF004AFF004FFF004DFF0046FF0038FF0024FF
000CFF1000FF3000FF5300FF7800FF9E00FFC300FFE700FFFF00F6FF00D7FF00BCFF00A5
FF0094FF0088FF0083FF0083FF0089FF0096FF00A8FF00C0FF00DDFF00FEDC00FFB300FF
8900FF5C00FF2F00FF0300FF0028FF0052FF007AFF009EFF00BFFF00DBFF00F2FF00FFFB
00FFEF00FFE900FFEA00FFF000FFFC00F1FF00D9FF00BCFF009AFF0073FF0049FF001BFF
1400FF4700FF7A00FFAF00FFE300FFFF00E9FF00B7FF0088
00A0FF0070FF003FFF000CFF2700FF5B00FF8F00FFC200FFF300FFFF00DEFF00B3FF008C
FF0069FF004AFF0032FF001EFF0011FF0009FF0008FF000DFF0018FF0028FF003EFF005A
FF0079FF009DFF00C4FF00EEE600FFB900FF8C00FF6000FF3500FF0C00FF0019FF003BFF
0059FF0072FF0085FF0093FF009AFF009CFF0097FF008DFF007DFF0067FF004DFF002FFF
000DFF1500FF3B00FF6000FF8500FFA900FFCA00FFE800FFFF00FEFF00EAFF00DBFF00D2
FF00CFFF00D3FF00DCFF00EBFF00FFE800FFCD00FFAF00FF9100FF7300FF5700FF3D00FF
2700FF1600FF0B00FF0600FF0700FF0F00FF1B00FF2D00FF4100FF5800FF6F00FF8500FF
9800FFA600FFAF00FFB100FFAD00FFA300FF9500FF8500FF7500FF6900FF6200FF6100FF
6700FF7100FF7900FF7900FF7500FF7400FF7B00FF8400FF8B00FF8C00FF8600FF7B00FF
6B00FF5B00FF4D00FF4200FF3D00FF3E00FF4500FF5200FF6400FF7900FF9000FFA700FF
BD00FFCF00FFDD00FFE500FFE700FFE300FFD900FFCA00FFB500FF9C00FF8000FF6200FF
4400FF2600FF0A00FF000EFF0022FF0032FF003DFF0041FF0040FF0038FF002AFF0017FF
0000FF1D00FF3E00FF6100FF8600FFAB00FFD100FFF500FFFF00E8FF00C9FF00AEFF0098
FF0087FF007BFF0075FF0076FF007CFF0089FF009BFF00B3FF00D0FF00F1E900FFC100FF
9600FF6A00FF3D00FF1000FF001BFF0045FF006DFF0091FF00B1FF00CDFF00E5FF00F6FF
00FFFD00FFF700FFF700FFFD00F6FF00E3FF00CCFF00AEFF008CFF0066FF003CFF000EFF
2200FF5400FF8800FFBC00FFF000FFFF00DCFF00AAFF007A
0098FF0069FF0038FF0005FF2E00FF6300FF9700FFC900FFFA00FFFF00D7FF00ABFF0084
FF0061FF0043FF002AFF0017FF0009FF0002FF0001FF0006FF0010FF0021FF0037FF0052
FF0072FF0095FF00BDFF00E6ED00FFC000FF9300FF6700FF3C00FF1300FF0012FF0034FF
0051FF006AFF007EFF008BFF0093FF0095FF0090FF0085FF0075FF0060FF0046FF0027FF
0006FF1D00FF4200FF6800FF8D00FFB000FFD100FFEF00FFFF00F7FF00E2FF00D3FF00CB
FF00C8FF00CBFF00D5FF00E3FF00F7F000FFD400FFB700FF9800FF7A00FF5E00FF4400FF
2F00FF1E00FF1300FF0E00FF0F00FF1600FF2300FF3400FF4900FF6000FF7700FF8D00FF
9F00FFAE00FFB600FFB800FFB400FFAA00FF9D00FF8C00FF7D00FF7000FF6900FF6900FF
6E00FF7800FF8000FF8100FF7C00FF7B00FF8200FF8C00FF9300FF9400FF8E00FF8200FF
7300FF6200FF5400FF4900FF4400FF4500FF4C00FF5900FF6B00FF8100FF9800FFAF00FF
C400FFD600FFE400FFEC00FFEF00FFEB00FFE100FFD100FFBC00FFA300FF8700FF6900FF
4B00FF2D00FF1100FF0006FF001BFF002BFF0035FF003AFF0038FF0031FF0023FF0010FF
0800FF2500FF4500FF6800FF8D00FFB300FFD800FFFC00FFFF00E1FF00C2FF00A7FF0091
FF007FFF0074FF006EFF006EFF0075FF0081FF0093FF00ABFF00C8FF00E9F000FFC800FF
9D00FF7100FF4400FF1700FF0013FF003EFF0065FF008AFF00AAFF00C6FF00DDFF00EFFF
00FBFF00FFFE00FFFE00FAFF00EEFF00DCFF00C4FF00A7FF0085FF005FFF0034FF0006FF
2900FF5B00FF8F00FFC300FFF700FFFF00D4FF00A2FF0073
0097FF0068FF0036FF0003FF3000FF6400FF9800FFCB00FFFB00FFFF00D5FF00AAFF0083
FF0060FF0042FF0029FF0016FF0008FF0001FF0000FF0004FF000FFF0020FF0036FF0051
FF0071FF0094FF00BBFF00E5EE00FFC200FF9500FF6800FF3D00FF1500FF0010FF0032FF
0050FF0069FF007CFF008AFF0092FF0093FF008FFF0084FF0074FF005FFF0044FF0026FF
0005FF1E00FF4300FF6900FF8E00FFB200FFD300FFF000FFFF00F5FF00E1FF00D2FF00C9
FF00C7FF00CAFF00D3FF00E2FF00F6F100FFD600FFB800FF9A00FF7C00FF5F00FF4600FF
3000FF1F00FF1400FF0F00FF1000FF1700FF2400FF3500FF4A00FF6100FF7800FF8E00FF
A100FFAF00FFB700FFBA00FFB500FFAC00FF9E00FF8E00FF7E00FF7100FF6A00FF6A00FF
7000FF7900FF8100FF8200FF7D00FF7C00FF8300FF8D00FF9400FF9500FF8F00FF8300FF
7400FF6400FF5500FF4B00FF4500FF4600FF4E00FF5B00FF6D00FF8200FF9900FFB000FF
C500FFD800FFE500FFEE00FFF000FFEC00FFE200FFD200FFBD00FFA500FF8900FF6B00FF
4C00FF2F00FF1300FF0005FF001AFF002AFF0034FF0039FF0037FF002FFF0022FF000EFF
0900FF2600FF4600FF6900FF8E00FFB400FFD900FFFE00FFFF00E0FF00C1FF00A6FF008F
FF007EFF0072FF006DFF006DFF0073FF0080FF0092FF00AAFF00C7FF00E8F200FFC900FF
9F00FF7200FF4600FF1900FF0012FF003CFF0064FF0088FF00A9FF00C5FF00DCFF00EEFF
00FAFF00FFFF00FFFF00F9FF00EDFF00DBFF00C3FF00A6FF0084FF005DFF0033FF0005FF
2A00FF5D00FF9000FFC500FFF900FFFF00D3FF00A1FF0071
009CFF006DFF003BFF0008FF2B00FF5F00FF9300FFC600FFF700FFFF00DAFF00AFFF0088
FF0065FF0047FF002EFF001AFF000DFF0006FF0004FF0009FF0014FF0025FF003BFF0056
FF0075FF0099FF00C0FF00EAEA00FFBD00FF9000FF6400FF3900FF1000FF0015FF0037FF
0055FF006EFF0081FF008FFF0097FF0098FF0094FF0089FF0079FF0063FF0049FF002BFF
000AFF1900FF3E00FF6400FF8900FFAD00FFCE00FFEB00FFFF00FAFF00E6FF00D7FF00CE
FF00CBFF00CFFF00D8FF00E7FF00FBEC00FFD100FFB300FF9500FF7700FF5A00FF4100FF
2B00FF1A00FF0F00FF0A00FF0B00FF1200FF1F00FF3000FF4500FF5C00FF7300FF8900FF
9C00FFAA00FFB300FFB500FFB100FFA700FF9900FF8900FF7900FF6D00FF6500FF6500FF
6B00FF7400FF7C00FF7D00FF7900FF7800FF7F00FF8800FF8F00FF9000FF8A00FF7E00FF
6F00FF5F00FF5000FF4600FF4000FF4100FF4900FF5600FF6800FF7D00FF9400FFAB00FF
C100FFD300FFE000FFE900FFEB00FFE700FFDD00FFCD00FFB900FFA000FF8400FF6600FF
4700FF2A00FF0E00FF000AFF001FFF002FFF0039FF003EFF003CFF0034FF0027FF0013FF
0400FF2100FF4200FF6500FF8A00FFAF00FFD500FFF900FFFF00E4FF00C5FF00AAFF0094
FF0083FF0077FF0071FF0072FF0078FF0085FF0097FF00AFFF00CCFF00EDED00FFC500FF
9A00FF6E00FF4100FF1400FF0017FF0041FF0069FF008DFF00AEFF00CAFF00E1FF00F2FF
00FEFF00FFFB00FFFB00FEFF00F2FF00E0FF00C8FF00ABFF0089FF0062FF0038FF000AFF
2500FF5800FF8B00FFC000FFF400FFFF00D8FF00A6FF0076
00A7FF0077FF0046FF0013FF2000FF5400FF8800FFBB00FFEC00FFFF00E5FF00BAFF0092
FF0070FF0051FF0038FF0025FF0018FF0010FF000FFF0014FF001FFF002FFF0045FF0060
FF0080FF00A4FF00CBFF00F5DF00FFB200FF8500FF5900FF2E00FF0500FF0020FF0042FF
0060FF0079FF008CFF009AFF00A1FF00A3FF009EFF0094FF0084FF006EFF0054FF0036FF
0014FF0E00FF3400FF5900FF7E00FFA200FFC300FFE100FFFA00FFFF00F1FF00E2FF00D9
FF00D6FF00DAFF00E3FF00F2F900FFE100FFC600FFA800FF8A00FF6C00FF5000FF3600FF
2000FF0F00FF0400FF0000FF0000FF0800FF1400FF2600FF3A00FF5100FF6800FF7E00FF
9100FF9F00FFA800FFAA00FFA600FF9C00FF8E00FF7E00FF6E00FF6200FF5B00FF5A00FF
6000FF6A00FF7200FF7200FF6E00FF6D00FF7400FF7D00FF8400FF8500FF7F00FF7400FF
6400FF5400FF4600FF3B00FF3600FF3700FF3E00FF4B00FF5D00FF7200FF8900FFA000FF
B600FFC800FFD600FFDE00FFE000FFDC00FFD200FFC300FFAE00FF9500FF7900FF5B00FF
3D00FF1F00FF0300FF0015FF0029FF0039FF0044FF0048FF0047FF003FFF0031FF001EFF
0006FF1600FF3700FF5A00FF7F00FFA400FFCA00FFEE00FFFF00EFFF00D0FF00B5FF009F
FF008EFF0082FF007CFF007DFF0083FF008FFF00A2FF00BAFF00D7FF00F8E200FFBA00FF
8F00FF6300FF3600FF0900FF0022FF004CFF0074FF0098FF00B8FF00D4FF00ECFF00FDFF
00FFF600FFF000FFF000FFF600FDFF00EAFF00D3FF00B5FF0093FF006DFF0042FF0015FF
1B00FF4D00FF8100FFB500FFE900FFFF00E3FF00B1FF0081
00B7FF0088FF0057FF0024FF1000FF4400FF7800FFAA00FFDB00FFFF00F5FF00CAFF00A3
FF0080FF0062FF0049FF0036FF0028FF0021FF0020FF0025FF002FFF0040FF0056FF0071
FF0091FF00B4FF00DBFA00FFCE00FFA200FF7500FF4800FF1D00FF000BFF0031FF0053FF
0070FF0089FF009DFF00AAFF00B2FF00B4FF00AFFF00A4FF0094FF007FFF0065FF0046FF
0025FF0001FF2300FF4900FF6E00FF9100FFB200FFD000FFE900FFFE00FFFF00F2FF00EA
FF00E7FF00EAFF00F3FD00FFE900FFD100FFB500FF9800FF7A00FF5B00FF3F00FF2500FF
1000FF0000FF000BFF0010FF000FFF0008FF0400FF1500FF2A00FF4100FF5800FF6E00FF
8000FF8F00FF9700FF9900FF9500FF8C00FF7E00FF6E00FF5E00FF5100FF4A00FF4A00FF
5000FF5900FF6100FF6200FF5D00FF5C00FF6300FF6D00FF7400FF7500FF6F00FF6300FF
5400FF4400FF3500FF2A00FF2500FF2600FF2D00FF3B00FF4D00FF6200FF7900FF9000FF
A500FFB700FFC500FFCD00FFD000FFCC00FFC200FFB200FF9D00FF8400FF6800FF4B00FF
2C00FF0E00FF000CFF0025FF003AFF004AFF0054FF0059FF0057FF0050FF0042FF002FFF
0016FF0600FF2600FF4900FF6E00FF9400FFB900FFDD00FFFF00FFFF00E1FF00C6FF00AF
FF009EFF0093FF008DFF008DFF0094FF00A0FF00B2FF00CAFF00E7F700FFD100FFA900FF
7E00FF5200FF2500FF0006FF0032FF005CFF0084FF00A8FF00C9FF00E5FF00FCFF00FFF1
00FFE500FFDF00FFDF00FFE600FFF200FBFF00E3FF00C6FF00A4FF007DFF0053FF0025FF
0A00FF3C00FF7000FFA400FFD900FFFF00F3FF00C1FF0092
00CDFF009EFF006DFF003AFF0005FF2E00FF6200FF9400FFC500FFF300FFFF00E0FF00B9
FF0096FF0078FF005FFF004CFF003EFF0037FF0036FF003BFF0045FF0056FF006CFF0087
FF00A7FF00CAFF00F2E400FFB800FF8B00FF5F00FF3200FF0700FF0021FF0047FF0069FF
0086FF009FFF00B3FF00C0FF00C8FF00CAFF00C5FF00BAFF00AAFF0095FF007BFF005CFF
003BFF0017FF0D00FF3300FF5800FF7B00FF9C00FFBA00FFD300FFE800FFF700FFFF00FF
FF00FDFF00FFF600FFE700FFD300FFBB00FF9F00FF8200FF6300FF4500FF2900FF0F00FF
0005FF0016FF0021FF0026FF0025FF001EFF0011FF0000FF1400FF2B00FF4200FF5800FF
6A00FF7900FF8100FF8300FF7F00FF7600FF6800FF5700FF4800FF3B00FF3400FF3400FF
3900FF4300FF4B00FF4C00FF4700FF4600FF4D00FF5700FF5E00FF5F00FF5900FF4D00FF
3E00FF2D00FF1F00FF1400FF0F00FF1000FF1700FF2500FF3600FF4C00FF6300FF7A00FF
8F00FFA100FFAF00FFB700FFBA00FFB600FFAC00FF9C00FF8700FF6E00FF5200FF3400FF
1600FF0007FF0022FF003BFF0050FF0060FF006AFF006FFF006DFF0066FF0058FF0045FF
002CFF000FFF1000FF3300FF5800FF7E00FFA300FFC700FFE900FFFF00F7FF00DCFF00C6
FF00B4FF00A9FF00A3FF00A3FF00AAFF00B6FF00C8FF00E0FF00FDE100FFBB00FF9300FF
6800FF3C00FF0F00FF001DFF0048FF0073FF009AFF00BFFF00DFFF00FBFF00FFED00FFDB
00FFCF00FFC900FFC900FFD000FFDC00FFEE00F9FF00DCFF00BAFF0094FF0069FF003BFF
000BFF2600FF5A00FF8E00FFC300FFF600FFFF00D7FF00A8
00E8FF00B9FF0088FF0055FF0021FF1300FF4700FF7900FFAA00FFD800FFFF00FCFF00D4
FF00B1FF0093FF007AFF0067FF005AFF0052FF0051FF0056FF0060FF0071FF0087FF00A2
FF00C2FF00E6F200FFC900FF9D00FF7000FF4300FF1700FF0013FF003CFF0062FF0084FF
00A2FF00BAFF00CEFF00DCFF00E3FF00E5FF00E0FF00D6FF00C5FF00B0FF0096FF0078FF
0056FF0032FF000DFF1800FF3D00FF6000FF8100FF9F00FFB800FFCD00FFDB00FFE400FF
E700FFE400FFDA00FFCB00FFB800FFA000FF8400FF6700FF4800FF2A00FF0E00FF000BFF
0020FF0031FF003CFF0042FF0040FF0039FF002CFF001BFF0006FF1000FF2700FF3D00FF
4F00FF5D00FF6600FF6800FF6400FF5A00FF4C00FF3C00FF2D00FF2000FF1900FF1800FF
1E00FF2800FF3000FF3100FF2C00FF2B00FF3200FF3C00FF4300FF4400FF3E00FF3200FF
2300FF1200FF0400FF0006FF000BFF000AFF0003FF0900FF1B00FF3100FF4800FF5F00FF
7400FF8600FF9400FF9C00FF9F00FF9B00FF9100FF8100FF6C00FF5300FF3700FF1900FF
0004FF0022FF003EFF0056FF006BFF007BFF0086FF008AFF0089FF0081FF0073FF0060FF
0047FF002AFF000AFF1800FF3D00FF6300FF8800FFAC00FFCE00FFED00FFFF00F7FF00E1
FF00CFFF00C4FF00BEFF00BEFF00C5FF00D1FF00E4FF00FBE700FFC500FFA000FF7800FF
4D00FF2100FF000BFF0038FF0063FF008EFF00B5FF00DAFF00FAFF00FFE900FFD200FFC0
00FFB400FFAE00FFAE00FFB400FFC100FFD300FFEB00F7FF00D5FF00AFFF0084FF0057FF
0026FF0B00FF3F00FF7300FFA700FFDB00FFFF00F2FF00C3
00FFF700D9FF00A7FF0074FF0040FF000CFF2700FF5A00FF8A00FFB900FFE400FFFF00F4
FF00D1FF00B3FF009AFF0087FF0079FF0072FF0071FF0075FF0080FF0091FF00A7FF00C2
FF00E2FA00FFD300FFA900FF7D00FF5100FF2400FF0008FF0033FF005CFF0081FF00A3FF
00C1FF00DAFF00EEFF00FBFF00FFFC00FFFB00FFFF00F5FF00E5FF00D0FF00B5FF0097FF
0076FF0052FF002DFF0007FF1D00FF4100FF6200FF7F00FF9900FFAD00FFBC00FFC500FF
C700FFC400FFBB00FFAC00FF9800FF8000FF6500FF4700FF2900FF0B00FF0011FF002AFF
0040FF0051FF005CFF0061FF0060FF0059FF004CFF003BFF0026FF000FFF0700FF1D00FF
3000FF3E00FF4600FF4900FF4400FF3B00FF2D00FF1D00FF0D00FF0000FF0006FF0006FF
0000FF0800FF1000FF1100FF0C00FF0B00FF1200FF1C00FF2300FF2400FF1E00FF1200FF
0300FF000CFF001BFF0026FF002BFF002AFF0022FF0015FF0003FF1100FF2800FF3F00FF
5400FF6700FF7400FF7D00FF7F00FF7B00FF7100FF6100FF4C00FF3300FF1800FF0005FF
0024FF0041FF005DFF0076FF008BFF009BFF00A5FF00AAFF00A8FF00A0FF0093FF007FFF
0067FF004AFF002AFF0007FF1D00FF4300FF6800FF8C00FFAE00FFCD00FFE800FFFF00FF
FF00EFFF00E3FF00DEFF00DEFF00E4FF00F1FC00FFE400FFC700FFA600FF8100FF5800FF
2E00FF0100FF002AFF0057FF0083FF00ADFF00D5FF00F9FF00FFE500FFC900FFB200FFA0
00FF9400FF8E00FF8F00FF9500FFA100FFB300FFCB00FFE800F5FF00CEFF00A4FF0076FF
0046FF0013FF1F00FF5400FF8800FFBB00FFED00FFFF00E3
00FFD300FDFF00CBFF0098FF0064FF0030FF0300FF3600FF6700FF9500FFC000FFE700FF
FF00F5FF00D6FF00BEFF00AAFF009DFF0095FF0094FF0099FF00A4FF00B4FF00CAFF00E6
FA00FFD600FFAF00FF8500FF5A00FF2D00FF0000FF002BFF0056FF007FFF00A5FF00C7FF
00E5FF00FEFF00FFEE00FFE000FFD800FFD700FFDC00FFE600FFF600F3FF00D9FF00BBFF
009AFF0076FF0051FF002BFF0006FF1D00FF3E00FF5B00FF7500FF8900FF9800FFA100FF
A400FFA000FF9700FF8800FF7400FF5C00FF4100FF2300FF0500FF0018FF0034FF004EFF
0064FF0075FF0080FF0085FF0084FF007DFF0070FF005EFF004AFF0033FF001CFF0006FF
0C00FF1A00FF2300FF2500FF2100FF1700FF0900FF0006FF0016FF0022FF0029FF002AFF
0024FF001AFF0012FF0012FF0016FF0017FF0010FF0007FF0000FF0000FF0005FF0010FF
0020FF0030FF003FFF0049FF004EFF004DFF0046FF0039FF0027FF0012FF0400FF1B00FF
3100FF4300FF5100FF5900FF5B00FF5700FF4D00FF3E00FF2900FF1000FF000BFF0029FF
0047FF0065FF0081FF009AFF00AFFF00BEFF00C9FF00CDFF00CCFF00C4FF00B6FF00A3FF
008BFF006EFF004DFF002AFF0005FF1F00FF4500FF6900FF8B00FFAA00FFC500FFDB00FF
EC00FFF800FFFE00FFFD00FFF700FFEA00FFD800FFC000FFA300FF8200FF5D00FF3500FF
0A00FF0021FF004EFF007BFF00A7FF00D1FF00F9FF00FFE200FFC100FFA500FF8E00FF7D
00FF7100FF6B00FF6B00FF7100FF7D00FF8F00FFA700FFC400FFE700F2FF00C8FF009AFF
0069FF0037FF0003FF3000FF6400FF9700FFC900FFF900FF
00FFAC00FFDB00F2FF00BFFF008BFF0057FF0023FF0F00FF4000FF6E00FF9900FFC000FF
E300FFFF00FEFF00E5FF00D1FF00C4FF00BDFF00BBFF00C0FF00CBFF00DBFF00F2F200FF
D300FFAF00FF8800FF5E00FF3300FF0600FF0026FF0052FF007DFF00A6FF00CCFF00EEFF
00FFF300FFDA00FFC700FFB900FFB100FFB000FFB400FFBF00FFCF00FFE500FFFF00E2FF
00C1FF009DFF0078FF0052FF002DFF0009FF1700FF3400FF4E00FF6200FF7100FF7A00FF
7D00FF7900FF7000FF6100FF4D00FF3500FF1A00FF0003FF0021FF003FFF005CFF0075FF
008BFF009CFF00A7FF00ACFF00ABFF00A4FF0097FF0085FF0071FF005AFF0043FF002DFF
001AFF000CFF0003FF0001FF0005FF000FFF001DFF002DFF003DFF0049FF0050FF0051FF
004BFF0042FF0039FF0039FF003DFF003EFF0037FF002EFF0027FF0026FF002CFF0038FF
0047FF0057FF0066FF0070FF0076FF0075FF006DFF0060FF004EFF0039FF0022FF000BFF
0A00FF1C00FF2A00FF3200FF3400FF3000FF2600FF1700FF0200FF0016FF0032FF0050FF
006EFF008CFF00A8FF00C1FF00D6FF00E6FF00F0FF00F5FF00F3FF00EBFF00DDFF00CAFF
00B2FF0095FF0074FF0051FF002CFF0007FF1E00FF4200FF6400FF8300FF9E00FFB400FF
C500FFD100FFD700FFD600FFD000FFC300FFB100FF9900FF7C00FF5B00FF3600FF0E00FF
001CFF0048FF0075FF00A2FF00CEFF00F8FF00FFDF00FFBB00FF9A00FF7E00FF6700FF56
00FF4A00FF4400FF4400FF4A00FF5600FF6800FF8000FF9D00FFBF00FFE600EFFF00C1FF
0091FF005EFF002AFF0900FF3D00FF7000FFA200FFD200FF
00FF8300FFB200FFE300E9FF00B5FF0080FF004DFF001AFF1600FF4400FF6F00FF9700FF
BA00FFD800FFF100FFFF00FBFF00EEFF00E6FF00E5FF00EAFF00F5FA00FFE400FFC900FF
A900FF8500FF5E00FF3500FF0900FF0023FF0050FF007CFF00A7FF00D0FF00F6FF00FFE7
00FFC900FFB000FF9D00FF8F00FF8800FF8600FF8B00FF9500FFA600FFBB00FFD500FFF3
00EAFF00C6FF00A1FF007CFF0056FF0033FF0012FF0B00FF2400FF3800FF4700FF5000FF
5300FF5000FF4600FF3700FF2300FF0B00FF000FFF002CFF004BFF0069FF0085FF009FFF
00B5FF00C5FF00D1FF00D6FF00D5FF00CDFF00C1FF00AFFF009AFF0084FF006CFF0057FF
0044FF0036FF002DFF002BFF002FFF0039FF0047FF0057FF0066FF0073FF007AFF007BFF
0075FF006BFF0063FF0062FF0067FF0068FF0061FF0057FF0050FF0050FF0056FF0061FF
0071FF0081FF008FFF009AFF009FFF009EFF0097FF008AFF0078FF0062FF004BFF0034FF
001FFF000DFF0000FF0800FF0B00FF0700FF0002FF0012FF0027FF0040FF005CFF007AFF
0098FF00B6FF00D2FF00EBFF00FFFF00FFF000FFE500FFE100FFE200FFEA00FFF800F4FF
00DBFF00BFFF009EFF007BFF0056FF0030FF000BFF1800FF3A00FF5900FF7400FF8A00FF
9C00FFA700FFAD00FFAD00FFA600FF9A00FF8700FF6F00FF5300FF3100FF0C00FF001BFF
0046FF0072FF009FFF00CCFF00F8FF00FFDD00FFB600FF9100FF7100FF5500FF3E00FF2C
00FF2000FF1A00FF1A00FF2000FF2D00FF3F00FF5700FF7400FF9600FFBC00FFE700EBFF
00BAFF0088FF0054FF0020FF1300FF4700FF7800FFA800FF
00FF5700FF8600FFB800FFEB00E0FF00ACFF0078FF0045FF0015FF1900FF4400FF6B00FF
8E00FFAC00FFC500FFD800FFE600FFED00FFEE00FFEA00FFDF00FFCE00FFB800FF9D00FF
7D00FF5A00FF3300FF0900FF0022FF004EFF007BFF00A8FF00D3FF00FCFF00FFDE00FFBB
00FF9E00FF8500FF7100FF6400FF5C00FF5B00FF5F00FF6A00FF7A00FF8F00FFAA00FFC8
00FFE900F2FF00CDFF00A7FF0082FF005FFF003DFF0020FF0007FF0D00FF1C00FF2500FF
2700FF2400FF1B00FF0C00FF0007FF001FFF003BFF0058FF0076FF0094FF00B1FF00CAFF
00E0FF00F1FF00FCFF00FFFE00FFFF00F9FF00ECFF00DBFF00C6FF00AFFF0098FF0082FF
006FFF0061FF0059FF0056FF005BFF0064FF0072FF0082FF0092FF009FFF00A6FF00A6FF
00A0FF0097FF008FFF008EFF0093FF0094FF008DFF0083FF007CFF007BFF0081FF008DFF
009CFF00ACFF00BBFF00C6FF00CBFF00CAFF00C2FF00B5FF00A3FF008EFF0077FF0060FF
004BFF0039FF002BFF0022FF0020FF0024FF002EFF003EFF0053FF006CFF0088FF00A5FF
00C4FF00E1FF00FDFF00FFE900FFD400FFC400FFBA00FFB500FFB700FFBE00FFCC00FFE0
00FFF800EAFF00CAFF00A7FF0082FF005CFF0037FF0013FF0E00FF2D00FF4800FF5F00FF
7000FF7C00FF8100FF8100FF7B00FF6E00FF5C00FF4400FF2700FF0600FF001EFF0047FF
0071FF009EFF00CBFF00F7FF00FFDC00FFB200FF8A00FF6600FF4500FF2900FF1200FF00
0BFF0011FF0010FF000AFF0000FF0100FF1300FF2B00FF4800FF6A00FF9100FFBB00FFE9
00E6FF00B3FF0080FF004BFF0017FF1B00FF4D00FF7C00FF
00FF2A00FF5900FF8B00FFBE00FFF200D9FF00A5FF0072FF0041FF0013FF1700FF3E00FF
6100FF7F00FF9800FFAC00FFB900FFC000FFC200FFBD00FFB200FFA200FF8B00FF7000FF
5100FF2D00FF0600FF0023FF004EFF007BFF00A8FF00D4FF00FFFF00FFD700FFB100FF8F
00FF7100FF5800FF4500FF3700FF2F00FF2E00FF3200FF3D00FF4D00FF6300FF7D00FF9B
00FFBC00FFE000FAFF00D4FF00AFFF008BFF006AFF004DFF0033FF001FFF0010FF0007FF
0004FF0008FF0011FF0020FF0034FF004CFF0067FF0085FF00A3FF00C1FF00DEFF00F7FF
00FFF200FFE100FFD600FFD100FFD200FFD900FFE600FFF800F3FF00DCFF00C5FF00AFFF
009CFF008EFF0085FF0083FF0087FF0091FF009FFF00AFFF00BFFF00CBFF00D2FF00D3FF
00CDFF00C4FF00BBFF00BBFF00BFFF00C0FF00B9FF00B0FF00A9FF00A8FF00AEFF00BAFF
00C9FF00D9FF00E8FF00F2FF00F8FF00F7FF00EFFF00E2FF00D0FF00BBFF00A4FF008DFF
0077FF0065FF0057FF004FFF004DFF0051FF005BFF006AFF007FFF0098FF00B4FF00D2FF
00F0FF00FFF100FFD500FFBC00FFA700FF9700FF8D00FF8800FF8A00FF9200FFA000FFB3
00FFCB00FFE800F6FF00D3FF00AEFF0089FF0063FF003FFF001DFF0100FF1C00FF3200FF
4300FF4F00FF5500FF5400FF4E00FF4100FF2F00FF1700FF0005FF0026FF004BFF0073FF
009EFF00CAFF00F7FF00FFDB00FFAF00FF8500FF5D00FF3900FF1803FF001AFF002BFF00
37FF003DFF003DFF0037FF002BFF0019FF0001FF0000FF1B00FF3D00FF6400FF8E00FFBC
00FFEC00E0FF00ACFF0078FF0044FF0011FF2000FF5000FF
02FF0000FF2C00FF5E00FF9100FFC500FFF900D2FF009FFF006EFF0040FF0015FF1100FF
3400FF5300FF6B00FF7F00FF8C00FF9300FF9500FF9000FF8500FF7500FF5F00FF4300FF
2400FF0000FF0026FF0050FF007BFF00A8FF00D5FF00FFFE00FFD300FFAA00FF8400FF62
00FF4400FF2B00FF1800FF0A00FF0200FF0100FF0600FF1000FF2000FF3600FF5000FF6E
00FF8F00FFB300FFD800FFFE00DCFF00B8FF0097FF007AFF0060FF004CFF003DFF0034FF
0031FF0035FF003EFF004DFF0061FF0079FF0094FF00B2FF00D0FF00EEFF00FFF400FFDB
00FFC500FFB400FFA900FFA400FFA500FFAC00FFB900FFCB00FFDF00FFF600F2FF00DCFF
00C9FF00BBFF00B2FF00B0FF00B4FF00BEFF00CCFF00DCFF00ECFF00F8FF00FFFF00FFFF
00FAFF00F0FF00E8FF00E8FF00ECFF00EDFF00E6FF00DDFF00D6FF00D5FF00DBFF00E6FF
00F6FF00FFF900FFEA00FFE000FFDB00FFDB00FFE300FFF000FDFF00E8FF00D1FF00BAFF
00A4FF0092FF0084FF007CFF007AFF007EFF0088FF0097FF00ACFF00C5FF00E1FF00FFFF
00FFE200FFC400FFA800FF8F00FF7A00FF6B00FF6000FF5B00FF5D00FF6500FF7300FF86
00FF9E00FFBB00FFDC00FFFF00DBFF00B6FF0090FF006CFF004AFF002BFF0010FF0500FF
1600FF2200FF2800FF2700FF2100FF1400FF0200FF0015FF0032FF0053FF0078FF00A0FF
00CBFF00F7FF00FFDB00FFAE00FF8200FF5800FF3000FF0C14FF0030FF0047FF0058FF00
64FF006AFF006AFF0064FF0058FF0046FF002EFF0011FF0000FF1000FF3700FF6100FF8F
00FFBF00FFF200D9FF00A5FF0071FF003EFF000CFF2300FF
2EFF0000FF0000FF3100FF6500FF9900FFCD00FEFF00CCFF009BFF006CFF0041FF001AFF
0800FF2600FF3F00FF5200FF6000FF6700FF6800FF6400FF5900FF4800FF3200FF1700FF
0008FF002BFF0052FF007CFF00A8FF00D4FF00FFFE00FFD100FFA600FF7D00FF5800FF35
00FF1800FF0014FF0021FF0029FF002AFF0026FF001BFF000BFF0000FF0900FF2300FF42
00FF6300FF8700FFAC00FFD200FFF700E5FF00C4FF00A6FF008DFF0078FF0069FF0060FF
005EFF0061FF006AFF0079FF008DFF00A5FF00C1FF00DEFF00FCFF00FFE500FFC800FFAE
00FF9900FF8800FF7D00FF7800FF7900FF8000FF8D00FF9E00FFB300FFCA00FFE100FFF7
00F6FF00E7FF00DFFF00DDFF00E1FF00EAFF00F8FF00FFF700FFE700FFDA00FFD300FFD3
00FFD900FFE200FFEA00FFEB00FFE600FFE500FFEC00FFF600FFFD00FFFE00FFF800FFEC
00FFDD00FFCD00FFBE00FFB300FFAE00FFAF00FFB600FFC400FFD600FFEB00FDFF00E6FF
00D1FF00BFFF00B1FF00A9FF00A6FF00AAFF00B4FF00C4FF00D9FF00F2FF00FFF100FFD4
00FFB500FF9700FF7C00FF6300FF4E00FF3E00FF3400FF2F00FF3100FF3800FF4600FF59
00FF7200FF8F00FFAF00FFD200FFF700E2FF00BDFF0099FF0077FF0058FF003DFF0026FF
0015FF0009FF0004FF0004FF000AFF0017FF0029FF0041FF005EFF007FFF00A5FF00CDFF
00F7FF00FFDB00FFAE00FF8200FF5600FF2C00FF041FFF0040FF005CFF0073FF0085FF00
91FF0097FF0097FF0090FF0084FF0072FF005AFF003DFF001BFF0000FF0B00FF3500FF63
00FF9300FFC500FFF900D2FF009DFF006AFF0038FF0009FF
59FF002AFF0000FF0600FF3A00FF6E00FFA200FFD600F7FF00C6FF0097FF006CFF0045FF
0022FF0004FF1400FF2700FF3500FF3C00FF3D00FF3900FF2E00FF1D00FF0700FF0013FF
0033FF0056FF007DFF00A7FF00D3FF00FFFF00FFD300FFA600FF7B00FF5200FF2D00FF0A
12FF002BFF003FFF004CFF0054FF0056FF0051FF0046FF0036FF0021FF0007FF0000FF17
00FF3800FF5C00FF8100FFA700FFCC00FFEF00EFFF00D1FF00B8FF00A3FF0094FF008BFF
0089FF008CFF0095FF00A4FF00B8FF00D0FF00ECFF00FFF600FFD800FFBA00FF9D00FF83
00FF6E00FF5D00FF5200FF4D00FF4E00FF5500FF6200FF7300FF8800FF9F00FFB600FFCC
00FFDE00FFED00FFF500FFF700FFF300FFEA00FFDC00FFCC00FFBC00FFAF00FFA800FFA8
00FFAE00FFB700FFBF00FFC000FFBB00FFBA00FFC100FFCB00FFD200FFD300FFCD00FFC1
00FFB200FFA200FF9300FF8800FF8300FF8400FF8B00FF9900FFAB00FFC000FFD700FFEE
00FCFF00EAFF00DCFF00D4FF00D1FF00D5FF00DFFF00EFFF00FFFB00FFE200FFC600FFA9
00FF8A00FF6C00FF5100FF3800FF2300FF1300FF0900FF0400FF0600FF0D00FF1B00FF2E
00FF4700FF6400FF8400FFA700FFCC00FFF200E8FF00C4FF00A2FF0083FF0068FF0051FF
0040FF0034FF002FFF002FFF0036FF0042FF0054FF006CFF0089FF00AAFF00D0FF00F8FF
00FFDD00FFB000FF8300FF5700FF2B00FF0126FF004AFF006BFF0087FF009EFF00B0FF00
BCFF00C2FF00C2FF00BBFF00AFFF009DFF0085FF0068FF0046FF001FFF0000FF0A00FF38
00FF6800FF9A00FFCE00FDFF00C8FF0095FF0063FF0034FF
82FF0053FF0021FF0000FF1100FF4500FF7900FFAD00FFE000EFFF00C0FF0095FF006EFF
004BFF002DFF0014FF0001FF0C00FF1300FF1500FF1000FF0500FF000BFF0021FF003CFF
005CFF007FFF00A6FF00D0FF00FCFF00FFD700FFAA00FF7D00FF5200FF2A00FF041DFF00
3BFF0054FF0067FF0075FF007DFF007EFF007AFF006FFF005FFF004AFF002FFF0011FF00
00FF0F00FF3300FF5800FF7E00FFA300FFC700FFE800FAFF00E0FF00CCFF00BDFF00B4FF
00B1FF00B5FF00BEFF00CDFF00E1FF00F9FF00FFEB00FFCD00FFAF00FF9100FF7400FF5B
00FF4500FF3400FF2900FF2400FF2500FF2C00FF3900FF4A00FF5F00FF7600FF8D00FFA3
00FFB600FFC400FFCC00FFCF00FFCB00FFC100FFB300FFA300FF9300FF8600FF7F00FF7F
00FF8500FF8E00FF9600FF9700FF9200FF9100FF9800FFA200FFA900FFAA00FFA400FF98
00FF8900FF7900FF6A00FF6000FF5A00FF5B00FF6300FF7000FF8200FF9700FFAE00FFC5
00FFDA00FFED00FFFA00FCFF00FAFF00FEFF00FFF700FFE700FFD300FFBA00FF9E00FF80
00FF6100FF4400FF2800FF0F05FF0015FF001FFF0024FF0022FF001AFF000DFF0000FF06
00FF1E00FF3B00FF5B00FF7E00FFA300FFC900FFEE00ECFF00CAFF00ACFF0091FF007AFF
0069FF005DFF0058FF0058FF005EFF006BFF007DFF0095FF00B2FF00D3FF00F8FF00FFDE
00FFB400FF8800FF5B00FF2E00FF0227FF004FFF0073FF0094FF00B0FF00C7FF00D9FF00
E4FF00EAFF00EAFF00E4FF00D8FF00C6FF00AEFF0091FF006FFF0048FF001EFF0000FF0F
00FF3F00FF7200FFA500FFDA00F1FF00BEFF008CFF005CFF
A8FF0079FF0047FF0014FF0000FF1F00FF5300FF8700FFBA00FFEB00E6FF00BBFF0094FF
0071FF0053FF003AFF0026FF0019FF0012FF0010FF0015FF0020FF0031FF0047FF0062FF
0081FF00A5FF00CCFF00F6FF00FFDE00FFB100FF8400FF5800FF2D00FF0421FF0043FF00
61FF007AFF008DFF009BFF00A3FF00A4FF00A0FF0095FF0085FF006FFF0055FF0037FF00
16FF0000FF0D00FF3200FF5800FF7D00FFA100FFC200FFDF00FFF900F2FF00E3FF00DAFF
00D7FF00DBFF00E4FF00F3FF00FFF800FFE000FFC500FFA700FF8900FF6B00FF4E00FF35
00FF1F00FF0E00FF0301FF0000FF0000FF0600FF1300FF2400FF3900FF5000FF6700FF7D
00FF9000FF9E00FFA700FFA900FFA500FF9B00FF8D00FF7D00FF6D00FF6100FF5900FF59
00FF5F00FF6800FF7100FF7100FF6D00FF6C00FF7300FF7C00FF8300FF8400FF7E00FF72
00FF6300FF5300FF4400FF3A00FF3400FF3500FF3D00FF4A00FF5C00FF7100FF8800FF9F
00FFB500FFC700FFD400FFDD00FFDF00FFDB00FFD100FFC100FFAD00FF9400FF7800FF5A
00FF3B00FF1E00FF0216FF002BFF003BFF0045FF004AFF0048FF0040FF0033FF001FFF00
07FF0000FF1500FF3600FF5900FF7E00FFA300FFC900FFED00F0FF00D1FF00B6FF00A0FF
008FFF0083FF007DFF007EFF0084FF0091FF00A3FF00BBFF00D8FF00F9FF00FFE100FFB9
00FF8E00FF6200FF3500FF0823FF004DFF0075FF0099FF00BAFF00D6FF00EDFF00FEFF00
FFF500FFEF00FFEF00FFF500FEFF00ECFF00D4FF00B7FF0095FF006EFF0044FF0016FF00
00FF1900FF4C00FF8000FFB400FFE800E4FF00B2FF0082FF
CAFF009BFF0069FF0036FF0002FF0000FF3100FF6500FF9800FFC900FFF700DDFF00B6FF
0093FF0075FF005CFF0049FF003BFF0034FF0032FF0037FF0042FF0053FF0069FF0084FF
00A3FF00C7FF00EEFF00FFE700FFBB00FF8F00FF6200FF3500FF0A1DFF0043FF0065FF00
83FF009CFF00AFFF00BDFF00C5FF00C6FF00C2FF00B7FF00A7FF0091FF0077FF0059FF00
38FF0014FF0000FF1000FF3600FF5B00FF7F00FFA000FFBD00FFD700FFEB00FFFA00FCFF
00F9FF00FDFF00FFF900FFEA00FFD600FFBE00FFA300FF8500FF6700FF4900FF2C00FF13
02FF0013FF001EFF0023FF0022FF001BFF000EFF0000FF0200FF1700FF2E00FF4500FF5B
00FF6E00FF7C00FF8400FF8700FF8300FF7900FF6B00FF5B00FF4B00FF3F00FF3700FF37
00FF3D00FF4600FF4E00FF4F00FF4A00FF4900FF5000FF5A00FF6100FF6200FF5C00FF50
00FF4100FF3100FF2200FF1800FF1200FF1300FF1B00FF2800FF3A00FF4F00FF6600FF7D
00FF9200FFA500FFB200FFBB00FFBD00FFB900FFAF00FF9F00FF8B00FF7200FF5600FF38
00FF1903FF001FFF0038FF004DFF005DFF0067FF006CFF006AFF0062FF0055FF0041FF00
29FF000CFF0000FF1300FF3700FF5B00FF8100FFA600FFCB00FFED00F4FF00D9FF00C2FF
00B1FF00A5FF009FFF00A0FF00A6FF00B3FF00C5FF00DDFF00FAFF00FFE400FFBF00FF96
00FF6C00FF4000FF1319FF0045FF006FFF0097FF00BBFF00DCFF00F8FF00FFF000FFDF00
FFD300FFCD00FFCD00FFD300FFDF00FFF100F6FF00D9FF00B7FF0090FF0066FF0038FF00
08FF0000FF2A00FF5D00FF9200FFC600FFF900D4FF00A4FF
E8FF00B9FF0087FF0054FF0020FF0000FF1300FF4700FF7A00FFAB00FFD900FBFF00D4FF
00B1FF0092FF007AFF0066FF0059FF0051FF0050FF0055FF0060FF0070FF0086FF00A2FF
00C1FF00E5FF00FFF300FFC900FF9E00FF7100FF4400FF1812FF003BFF0061FF0083FF00
A1FF00BAFF00CDFF00DBFF00E3FF00E4FF00DFFF00D5FF00C5FF00AFFF0095FF0077FF00
56FF0032FF000DFF0000FF1800FF3D00FF6100FF8200FF9F00FFB900FFCD00FFDC00FFE5
00FFE800FFE400FFDB00FFCC00FFB800FFA000FF8500FF6700FF4900FF2B00FF0F0AFF00
20FF0031FF003CFF0041FF0040FF0039FF002CFF001AFF0006FF0000FF1000FF2700FF3D
00FF5000FF5E00FF6700FF6900FF6500FF5B00FF4D00FF3D00FF2D00FF2100FF1A00FF19
00FF1F00FF2900FF3100FF3100FF2D00FF2C00FF3300FF3C00FF4300FF4400FF3E00FF33
00FF2300FF1300FF0505FF000AFF0009FF0002FF0000FF0A00FF1C00FF3100FF4800FF5F
00FF7500FF8700FF9500FF9D00FF9F00FF9B00FF9100FF8200FF6D00FF5400FF3800FF1A
03FF0021FF003DFF0056FF006BFF007AFF0085FF0089FF0088FF0080FF0072FF005FFF00
47FF002AFF0009FF0000FF1900FF3E00FF6300FF8900FFAD00FFCF00FFEE00F6FF00E0FF
00CFFF00C3FF00BDFF00BEFF00C4FF00D1FF00E3FF00FBFF00FFE700FFC600FFA100FF79
00FF4E00FF220AFF0037FF0063FF008DFF00B5FF00D9FF00F9FF00FFE900FFD200FFC100
FFB500FFAF00FFAF00FFB500FFC100FFD300FFEB00F7FF00D4FF00AEFF0084FF0056FF00
25FF0000FF0C00FF4000FF7400FFA800FFDB00F2FF00C2FF
FFFF00D1FF00A0FF006DFF0039FF0004FF0000FF2E00FF6100FF9200FFC000FFEB00ECFF
00C9FF00ABFF0092FF007FFF0072FF006AFF0069FF006EFF0079FF0089FF009FFF00BAFF
00DAFF00FEFF00FFDA00FFB000FF8500FF5800FF2B00FF002BFF0054FF007AFF009CFF00
BAFF00D3FF00E6FF00F4FF00FBFF00FDFF00F8FF00EEFF00DEFF00C8FF00AEFF0090FF00
6EFF004BFF0025FF0000FF0000FF2400FF4800FF6900FF8700FFA000FFB400FFC300FFCC
00FFCF00FFCC00FFC200FFB300FF9F00FF8700FF6C00FF4F00FF3000FF1209FF0023FF00
39FF0049FF0055FF005AFF0059FF0051FF0045FF0033FF001EFF0008FF0000FF0F00FF24
00FF3700FF4500FF4E00FF5000FF4C00FF4200FF3400FF2400FF1500FF0800FF0100FF00
00FF0600FF1000FF1800FF1800FF1400FF1300FF1A00FF2400FF2A00FF2B00FF2500FF1A
00FF0A05FF0013FF001EFF0023FF0022FF001BFF000EFF0000FF0300FF1800FF3000FF47
00FF5C00FF6E00FF7C00FF8400FF8600FF8300FF7900FF6900FF5400FF3B00FF1F00FF01
1CFF003AFF0056FF006FFF0083FF0093FF009EFF00A2FF00A1FF0099FF008BFF0078FF00
5FFF0043FF0022FF0000FF0000FF2500FF4A00FF7000FF9400FFB600FFD500FFF000F9FF
00E8FF00DCFF00D6FF00D6FF00DDFF00E9FF00FCFF00FFEB00FFCF00FFAD00FF8800FF60
00FF3500FF0923FF0050FF007CFF00A6FF00CDFF00F2FF00FFED00FFD100FFBA00FFA800
FF9C00FF9600FF9600FF9C00FFA800FFBB00FFD200FFF000EDFF00C7FF009CFF006FFF00
3EFF000CFF0000FF2700FF5B00FF8F00FFC300FFF400DBFF
FFEB00E5FF00B3FF0080FF004CFF0018FF0000FF1B00FF4E00FF7E00FFAD00FFD800FFFF
00DDFF00BFFF00A6FF0093FF0085FF007EFF007CFF0081FF008CFF009DFF00B3FF00CEFF
00EEFF00FFEE00FFC700FF9D00FF7100FF4500FF1814FF003FFF0067FF008DFF00AFFF00
CDFF00E6FF00F9FF00FFF800FFF000FFEF00FFF300FFFE00F1FF00DCFF00C1FF00A3FF00
82FF005EFF0039FF0013FF0000FF1100FF3500FF5600FF7300FF8D00FFA100FFB000FFB9
00FFBC00FFB800FFAF00FFA000FF8C00FF7400FF5900FF3B00FF1D00FF001DFF0036FF00
4CFF005DFF0068FF006DFF006CFF0065FF0058FF0047FF0032FF001BFF0004FF0000FF11
00FF2400FF3200FF3A00FF3D00FF3900FF2F00FF2100FF1100FF010BFF0012FF0012FF00
0CFF0003FF0000FF0400FF0500FF0000FF0000FF0600FF1000FF1700FF1800FF1200FF06
08FF0018FF0027FF0031FF0037FF0036FF002EFF0021FF000FFF0000FF0500FF1C00FF33
00FF4800FF5B00FF6800FF7100FF7300FF6F00FF6500FF5500FF4100FF2800FF0C11FF00
30FF004DFF0069FF0082FF0097FF00A7FF00B1FF00B6FF00B4FF00ACFF009FFF008BFF00
73FF0056FF0036FF0013FF0000FF1100FF3700FF5C00FF8100FFA200FFC100FFDC00FFF3
00FBFF00EFFF00EAFF00EAFF00F0FF00FDFF00FFF000FFD800FFBB00FF9A00FF7500FF4C
00FF2209FF0036FF0063FF008FFF00B9FF00E1FF00FFFA00FFD900FFBD00FFA600FF9400
FF8900FF8300FF8300FF8900FF9500FFA700FFBF00FFDC00FFFE00DAFF00B0FF0082FF00
52FF001FFF0000FF1300FF4800FF7C00FFAF00FFE100EEFF
FFDD00F2FF00C1FF008EFF005AFF0026FF0000FF0D00FF4000FF7100FF9F00FFCA00FFF1
00EBFF00CCFF00B4FF00A0FF0093FF008BFF008AFF008FFF009AFF00AAFF00C0FF00DCFF
00FBFF00FFE000FFB900FF8F00FF6400FF3700FF0A21FF004CFF0075FF009BFF00BDFF00
DBFF00F4FF00FFF800FFEA00FFE300FFE100FFE600FFF000FFFF00E9FF00CFFF00B1FF00
8FFF006CFF0046FF0021FF0000FF0300FF2700FF4800FF6600FF7F00FF9300FFA200FFAB
00FFAE00FFAA00FFA100FF9200FF7E00FF6600FF4B00FF2D00FF0F0EFF002AFF0044FF00
5AFF006BFF0076FF007BFF007AFF0072FF0066FF0054FF0040FF0029FF0012FF0000FF03
00FF1600FF2400FF2D00FF2F00FF2B00FF2100FF1300FF030CFF0018FF001FFF0020FF00
1AFF0010FF0008FF0008FF000CFF000DFF0006FF0000FF0200FF0900FF0A00FF0406FF00
16FF0026FF0034FF003FFF0044FF0043FF003CFF002FFF001DFF0008FF0000FF0E00FF25
00FF3B00FF4D00FF5B00FF6300FF6500FF6100FF5700FF4800FF3300FF1A01FF001FFF00
3DFF005BFF0077FF0090FF00A4FF00B4FF00BFFF00C3FF00C2FF00BAFF00ACFF0099FF00
81FF0064FF0043FF0020FF0000FF0400FF2900FF4F00FF7300FF9500FFB400FFCF00FFE5
00FFF600FDFF00F7FF00F8FF00FEFF00FFF400FFE200FFCA00FFAD00FF8C00FF6700FF3F
00FF1417FF0044FF0071FF009DFF00C7FF00EFFF00FFEC00FFCC00FFB000FF9800FF8700
FF7B00FF7500FF7500FF7B00FF8700FF9A00FFB100FFCF00FFF100E8FF00BEFF0090FF00
5FFF002DFF0000FF0600FF3A00FF6E00FFA100FFD300FCFF
FFD600FAFF00C9FF0096FF0062FF002DFF0000FF0600FF3800FF6900FF9700FFC300FFEA
00F2FF00D4FF00BBFF00A8FF009AFF0093FF0092FF0097FF00A1FF00B2FF00C8FF00E3FF
00FFFC00FFD800FFB100FF8800FF5C00FF2F00FF0229FF0054FF007DFF00A3FF00C5FF00
E3FF00FBFF00FFF000FFE300FFDB00FFD900FFDE00FFE800FFF900F1FF00D7FF00B9FF00
97FF0073FF004EFF0028FF0003FF0000FF1F00FF4000FF5E00FF7700FF8C00FF9A00FFA3
00FFA600FFA300FF9900FF8B00FF7700FF5F00FF4300FF2600FF0716FF0032FF004CFF00
61FF0072FF007DFF0082FF0081FF007AFF006DFF005CFF0047FF0030FF0019FF0003FF00
00FF0E00FF1D00FF2500FF2700FF2300FF1900FF0C04FF0013FF0020FF0027FF0027FF00
22FF0018FF0010FF000FFF0014FF0015FF000EFF0004FF0000FF0200FF0302FF000EFF00
1DFF002EFF003CFF0047FF004CFF004BFF0044FF0037FF0025FF000FFF0000FF0700FF1E
00FF3300FF4500FF5300FF5B00FF5E00FF5A00FF5000FF4000FF2B00FF1209FF0027FF00
45FF0063FF007FFF0097FF00ACFF00BCFF00C7FF00CBFF00CAFF00C2FF00B4FF00A1FF00
88FF006BFF004BFF0028FF0003FF0000FF2200FF4700FF6B00FF8D00FFAC00FFC700FFDD
00FFEF00FFFA00FFFF00FFFF00FFF900FFED00FFDA00FFC300FFA600FF8400FF5F00FF37
00FF0C1FFF004CFF0079FF00A4FF00CFFF00F6FF00FFE400FFC400FFA800FF9100FF7F00
FF7300FF6D00FF6D00FF7300FF8000FF9200FFAA00FFC700FFE900F0FF00C5FF0097FF00
67FF0035FF0001FF0000FF3200FF6600FF9A00FFCC00FFFB
FFD400FCFF00CAFF0097FF0063FF002FFF0000FF0400FF3700FF6800FF9600FFC100FFE8
00F4FF00D6FF00BDFF00A9FF009CFF0095FF0093FF0098FF00A3FF00B4FF00CAFF00E5FF
00FFFB00FFD700FFB000FF8600FF5B00FF2E00FF012AFF0056FF007EFF00A4FF00C6FF00
E4FF00FDFF00FFEF00FFE100FFD900FFD800FFDC00FFE700FFF700F2FF00D8FF00BAFF00
99FF0075FF0050FF002AFF0005FF0000FF1E00FF3F00FF5C00FF7600FF8A00FF9900FFA2
00FFA500FFA100FF9800FF8900FF7500FF5D00FF4200FF2400FF0617FF0034FF004DFF00
63FF0074FF007FFF0084FF0083FF007CFF006FFF005EFF0049FF0032FF001BFF0005FF00
00FF0D00FF1B00FF2400FF2600FF2200FF1800FF0A05FF0015FF0021FF0029FF0029FF00
23FF001AFF0012FF0011FF0015FF0016FF000FFF0006FF0000FF0000FF0104FF0010FF00
1FFF002FFF003EFF0048FF004EFF004DFF0045FF0038FF0026FF0011FF0000FF0500FF1C
00FF3200FF4400FF5100FF5A00FF5C00FF5800FF4E00FF3E00FF2A00FF110AFF0028FF00
47FF0064FF0080FF0099FF00AEFF00BEFF00C8FF00CDFF00CBFF00C3FF00B6FF00A2FF00
8AFF006DFF004DFF0029FF0004FF0000FF2000FF4600FF6A00FF8C00FFAA00FFC500FFDC
00FFED00FFF900FFFF00FFFE00FFF800FFEB00FFD900FFC100FFA400FF8300FF5E00FF36
00FF0B20FF004DFF007AFF00A6FF00D0FF00F8FF00FFE300FFC200FFA600FF8F00FF7E00
FF7200FF6C00FF6C00FF7200FF7E00FF9000FFA800FFC500FFE700F1FF00C7FF0099FF00
69FF0036FF0003FF0000FF3100FF6500FF9800FFCA00FFFA
FFD900F7FF00C6FF0093FF005EFF002AFF0000FF0900FF3B00FF6C00FF9A00FFC600FFED
00EFFF00D1FF00B8FF00A5FF0097FF0090FF008FFF0094FF009EFF00AFFF00C5FF00E0FF
00FFFF00FFDC00FFB400FF8B00FF5F00FF3200FF0626FF0051FF007AFF00A0FF00C2FF00
DFFF00F8FF00FFF300FFE600FFDE00FFDC00FFE100FFEC00FFFC00EEFF00D4FF00B5FF00
94FF0070FF004BFF0025FF0000FF0000FF2200FF4300FF6100FF7A00FF8F00FF9E00FFA6
00FFA900FFA600FF9D00FF8E00FF7A00FF6200FF4600FF2900FF0A13FF002FFF0049FF00
5EFF006FFF007AFF007FFF007EFF0077FF006AFF0059FF0044FF002DFF0016FF0000FF00
00FF1100FF2000FF2800FF2A00FF2600FF1D00FF0F01FF0010FF001DFF0024FF0024FF00
1FFF0015FF000DFF000CFF0011FF0012FF000BFF0001FF0000FF0500FF0600FF000BFF00
1AFF002BFF0039FF0044FF0049FF0048FF0041FF0033FF0022FF000CFF0000FF0A00FF21
00FF3600FF4800FF5600FF5E00FF6100FF5D00FF5300FF4300FF2E00FF1506FF0024FF00
42FF0060FF007BFF0094FF00A9FF00B9FF00C3FF00C8FF00C6FF00BFFF00B1FF009EFF00
85FF0068FF0048FF0025FF0000FF0000FF2500FF4A00FF6E00FF9000FFAF00FFCA00FFE0
00FFF200FFFD00FCFF00FCFF00FFFC00FFF000FFDE00FFC600FFA900FF8800FF6200FF3A
00FF0F1CFF0049FF0076FF00A1FF00CCFF00F3FF00FFE700FFC700FFAB00FF9400FF8200
FF7600FF7000FF7000FF7700FF8300FF9500FFAD00FFCA00FFEC00EDFF00C2FF0094FF00
64FF0032FF0000FF0100FF3500FF6A00FF9D00FFCF00FFFE
FFE300EDFF00BBFF0088FF0054FF0020FF0000FF1300FF4600FF7700FFA500FFD000FFF7
00E5FF00C6FF00AEFF009AFF008DFF0085FF0084FF0089FF0094FF00A4FF00BAFF00D6FF
00F5FF00FFE600FFBF00FF9500FF6A00FF3D00FF101BFF0046FF006FFF0095FF00B7FF00
D5FF00EEFF00FFFE00FFF000FFE800FFE700FFEC00FFF600F9FF00E3FF00C9FF00ABFF00
8AFF0066FF0041FF001BFF0000FF0900FF2D00FF4E00FF6B00FF8500FF9900FFA800FFB1
00FFB400FFB000FFA700FF9800FF8400FF6C00FF5100FF3300FF1508FF0024FF003EFF00
54FF0065FF0070FF0075FF0074FF006DFF0060FF004EFF003AFF0023FF000CFF0000FF09
00FF1C00FF2A00FF3300FF3500FF3100FF2700FF1900FF0906FF0012FF0019FF001AFF00
14FF000AFF0002FF0002FF0006FF0007FF0000FF0000FF0800FF0F00FF1000FF0A00FF00
10FF0020FF002FFF0039FF003EFF003DFF0036FF0029FF0017FF0002FF0000FF1400FF2B
00FF4100FF5300FF6100FF6900FF6B00FF6700FF5D00FF4E00FF3900FF2000FF0419FF00
37FF0055FF0071FF008AFF009FFF00AEFF00B9FF00BDFF00BCFF00B4FF00A6FF0093FF00
7BFF005EFF003DFF001AFF0000FF0A00FF2F00FF5500FF7900FF9B00FFBA00FFD500FFEB
00FFFC00F7FF00F1FF00F2FF00F8FF00FFFA00FFE800FFD000FFB300FF9200FF6D00FF45
00FF1A11FF003EFF006BFF0097FF00C1FF00E9FF00FFF200FFD200FFB500FF9E00FF8D00
FF8100FF7B00FF7B00FF8100FF8D00FF9F00FFB700FFD400FFF700E2FF00B8FF008AFF00
59FF0027FF0000FF0C00FF4000FF7400FFA700FFD900F6FF
FFF400DCFF00ABFF0078FF0044FF000FFF0000FF2300FF5600FF8700FFB500FFE000F7FF
00D4FF00B6FF009DFF008AFF007DFF0075FF0074FF0079FF0084FF0094FF00AAFF00C5FF
00E5FF00FFF600FFCF00FFA600FF7A00FF4D00FF200BFF0036FF005FFF0085FF00A7FF00
C5FF00DEFF00F1FF00FFFF00FFF900FFF700FFFC00F9FF00E8FF00D3FF00B9FF009BFF00
79FF0056FF0030FF000BFF0000FF1900FF3D00FF5E00FF7C00FF9500FFA900FFB800FFC1
00FFC400FFC100FFB700FFA800FF9400FF7C00FF6100FF4400FF2500FF0714FF002EFF00
44FF0054FF0060FF0065FF0064FF005CFF0050FF003EFF0029FF0013FF0000FF0400FF19
00FF2C00FF3A00FF4300FF4500FF4100FF3700FF2900FF1900FF0A02FF0009FF000AFF00
04FF0000FF0500FF0D00FF0E00FF0900FF0800FF0F00FF1900FF2000FF2000FF1A00FF0F
00FF0010FF001EFF0029FF002EFF002DFF0026FF0019FF0007FF0000FF0E00FF2500FF3C
00FF5100FF6300FF7100FF7900FF7B00FF7800FF6E00FF5E00FF4900FF3000FF1409FF00
27FF0045FF0061FF007AFF008EFF009EFF00A9FF00ADFF00ACFF00A4FF0096FF0083FF00
6AFF004EFF002DFF000AFF0000FF1A00FF4000FF6500FF8900FFAB00FFCA00FFE500FFFB
00F2FF00E7FF00E1FF00E1FF00E8FF00F4FF00FFF800FFE000FFC400FFA200FF7D00FF55
00FF2A01FF002EFF005BFF0087FF00B1FF00D8FF00FDFF00FFE200FFC600FFAF00FF9D00
FF9100FF8B00FF8B00FF9100FF9E00FFB000FFC800FFE500F8FF00D2FF00A7FF007AFF00
49FF0017FF0000FF1C00FF5000FF8400FFB800FFE900E6FF
F6FF00C7FF0095FF0062FF002EFF0000FF0500FF3900FF6C00FF9C00FFCB00FFF600E2FF
00BFFF00A1FF0088FF0075FF0067FF0060FF005FFF0063FF006EFF007FFF0095FF00B0FF
00D0FF00F3FF00FFE500FFBB00FF8F00FF6300FF3600FF0921FF004AFF006FFF0091FF00
AFFF00C8FF00DCFF00E9FF00F1FF00F2FF00EEFF00E3FF00D3FF00BEFF00A3FF0085FF00
64FF0040FF001BFF0000FF0A00FF2F00FF5300FF7400FF9100FFAB00FFBF00FFCE00FFD7
00FFD900FFD600FFCD00FFBE00FFAA00FF9200FF7700FF5900FF3B00FF1D00FF0018FF00
2EFF003FFF004AFF004FFF004EFF0047FF003AFF0029FF0014FF0000FF0200FF1900FF2F
00FF4200FF5000FF5800FF5B00FF5600FF4D00FF3F00FF2F00FF1F00FF1200FF0B00FF0B
00FF1100FF1A00FF2200FF2300FF1E00FF1D00FF2400FF2E00FF3500FF3600FF3000FF24
00FF1500FF0509FF0014FF0019FF0018FF0010FF0003FF0000FF0E00FF2300FF3A00FF51
00FF6600FF7900FF8600FF8F00FF9100FF8D00FF8300FF7300FF5E00FF4600FF2A00FF0C
12FF002FFF004BFF0064FF0079FF0089FF0093FF0098FF0096FF008EFF0081FF006DFF00
55FF0038FF0018FF0000FF0A00FF2F00FF5500FF7A00FF9F00FFC000FFDF00FFFA00EEFF
00DDFF00D1FF00CCFF00CCFF00D2FF00DFFF00F1FF00FFF600FFD900FFB800FF9300FF6A
00FF4000FF1318FF0045FF0071FF009BFF00C3FF00E7FF00FFF700FFDB00FFC400FFB200
FFA600FFA000FFA100FFA700FFB300FFC500FFDD00FFFA00E3FF00BCFF0092FF0064FF00
34FF0001FF0000FF3100FF6600FF9A00FFCD00FFFF00D1FF
DCFF00ADFF007BFF0048FF0014FF0000FF1F00FF5300FF8600FFB700FFE500EFFF00C8FF
00A5FF0087FF006EFF005AFF004DFF0046FF0044FF0049FF0054FF0065FF007BFF0096FF
00B5FF00D9FF00FFFF00FFD500FFAA00FF7D00FF5000FF2307FF002FFF0055FF0077FF00
95FF00AEFF00C1FF00CFFF00D7FF00D8FF00D4FF00C9FF00B9FF00A3FF0089FF006BFF00
4AFF0026FF0001FF0000FF2400FF4900FF6D00FF8E00FFAB00FFC500FFD900FFE800FFF1
00FFF400FFF000FFE700FFD800FFC400FFAC00FF9100FF7300FF5500FF3700FF1A00FF01
14FF0025FF0030FF0035FF0034FF002DFF0020FF000FFF0000FF0500FF1C00FF3300FF49
00FF5C00FF6A00FF7200FF7500FF7100FF6700FF5900FF4900FF3900FF2D00FF2500FF25
00FF2B00FF3400FF3C00FF3D00FF3900FF3700FF3F00FF4800FF4F00FF5000FF4A00FF3E
00FF2F00FF1F00FF1000FF0600FF0000FF0100FF0900FF1600FF2800FF3D00FF5400FF6B
00FF8100FF9300FFA000FFA900FFAB00FFA700FF9D00FF8D00FF7900FF6000FF4400FF26
00FF0715FF0031FF004AFF005FFF006FFF0079FF007EFF007CFF0074FF0067FF0053FF00
3BFF001EFF0000FF0100FF2500FF4900FF6F00FF9500FFB900FFDB00FFF900EBFF00D4FF
00C3FF00B7FF00B1FF00B2FF00B8FF00C5FF00D7FF00EFFF00FFF300FFD200FFAD00FF84
00FF5A00FF2E00FF012BFF0057FF0081FF00A9FF00CDFF00EEFF00FFF500FFDE00FFCD00
FFC100FFBB00FFBB00FFC100FFCD00FFDF00FFF700EBFF00C9FF00A2FF0078FF004AFF00
1AFF0000FF1800FF4B00FF8000FFB400FFE700E6FF00B6FF
BEFF008FFF005DFF002AFF0000FF0900FF3D00FF7100FFA400FFD500FCFF00D1FF00AAFF
0087FF0068FF0050FF003CFF002FFF0027FF0026FF002BFF0036FF0046FF005CFF0078FF
0097FF00BBFF00E2FF00FFF300FFC800FF9B00FF6E00FF4200FF1711FF0037FF0059FF00
77FF0090FF00A3FF00B1FF00B9FF00BAFF00B5FF00ABFF009BFF0085FF006BFF004DFF00
2CFF0008FF0000FF1C00FF4200FF6700FF8B00FFAC00FFC900FFE300FFF700F9FF00F0FF
00EDFF00F1FF00FAFF00FFF600FFE200FFCA00FFAF00FF9100FF7300FF5500FF3900FF1F
00FF0907FF0012FF0017FF0016FF000FFF0002FF0000FF0F00FF2300FF3A00FF5100FF67
00FF7A00FF8800FF9100FF9300FF8F00FF8500FF7700FF6700FF5700FF4B00FF4400FF43
00FF4900FF5300FF5B00FF5B00FF5700FF5600FF5D00FF6600FF6D00FF6E00FF6800FF5D
00FF4D00FF3D00FF2E00FF2400FF1F00FF2000FF2700FF3400FF4600FF5B00FF7200FF89
00FF9F00FFB100FFBF00FFC700FFC900FFC500FFBB00FFAC00FF9700FF7E00FF6200FF44
00FF2600FF0813FF002CFF0041FF0050FF005BFF005FFF005EFF0056FF0048FF0035FF00
1DFF0000FF0000FF2000FF4300FF6800FF8D00FFB300FFD700FFF900E7FF00CCFF00B6FF
00A5FF0099FF0093FF0094FF009AFF00A7FF00B9FF00D1FF00EEFF00FFF000FFCB00FFA3
00FF7800FF4C00FF1F0DFF0039FF0063FF008BFF00AFFF00CFFF00ECFF00FFFC00FFEB00
FFDF00FFD900FFD900FFDF00FFEB00FFFD00EAFF00CDFF00AAFF0084FF005AFF002CFF00
00FF0400FF3600FF6A00FF9E00FFD200FAFF00C8FF0098FF
9CFF006DFF003CFF0009FF0000FF2A00FF5F00FF9300FFC500FFF600DBFF00AFFF0088FF
0065FF0047FF002EFF001BFF000DFF0006FF0005FF000AFF0014FF0025FF003BFF0056FF
0076FF009AFF00C1FF00EAFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006EFF0082FF008FFF0097FF0099FF0094FF008AFF0079FF0064FF004AFF002CFF00
0AFF0000FF1900FF3E00FF6400FF8900FFAC00FFCD00FFEB00FBFF00E6FF00D8FF00CFFF
00CCFF00CFFF00D9FF00E7FF00FBFF00FFEC00FFD000FFB300FF9400FF7600FF5A00FF40
00FF2B00FF1A00FF0F00FF0A00FF0B00FF1200FF1F00FF3000FF4500FF5C00FF7300FF89
00FF9B00FFAA00FFB200FFB400FFB000FFA600FF9900FF8800FF7900FF6C00FF6500FF65
00FF6A00FF7400FF7C00FF7D00FF7800FF7700FF7E00FF8800FF8F00FF9000FF8A00FF7E
00FF6F00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7D00FF9400FFAB
00FFC000FFD200FFE000FFE800FFEB00FFE700FFDD00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0AFF001FFF002FFF003AFF003EFF003CFF0035FF0027FF0014FF00
00FF0400FF2100FF4100FF6400FF8900FFAF00FFD400FFF800E5FF00C6FF00ABFF0095FF
0083FF0078FF0072FF0072FF0079FF0085FF0098FF00AFFF00CCFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1317FF0042FF0069FF008EFF00AEFF00CAFF00E1FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F2FF00E0FF00C8FF00ABFF0089FF0063FF0038FF000AFF00
00FF2500FF5700FF8B00FFBF00FFF300D8FF00A6FF0077FF
78FF0049FF0018FF0000FF1A00FF4E00FF8300FFB600FFE900E5FF00B7FF008CFF0064FF
0041FF0023FF000AFF0800FF1500FF1D00FF1E00FF1900FF0E00FF0001FF0017FF0032FF
0052FF0076FF009DFF00C6FF00F2FF00FFE000FFB300FF8700FF5C00FF3300FF0D14FF00
32FF004BFF005EFF006CFF0073FF0075FF0070FF0066FF0056FF0040FF0026FF0008FF00
00FF1900FF3C00FF6200FF8700FFAC00FFD000FFF100F0FF00D7FF00C3FF00B4FF00ABFF
00A8FF00ABFF00B5FF00C4FF00D8FF00F0FF00FFF400FFD700FFB800FF9A00FF7E00FF64
00FF4E00FF3E00FF3200FF2D00FF2E00FF3600FF4200FF5400FF6900FF7F00FF9700FFAC
00FFBF00FFCD00FFD600FFD800FFD400FFCA00FFBC00FFAC00FF9D00FF9000FF8900FF88
00FF8E00FF9800FFA000FFA100FF9C00FF9B00FFA200FFAC00FFB200FFB300FFAD00FFA2
00FF9200FF8200FF7400FF6900FF6400FF6500FF6C00FF7900FF8B00FFA100FFB800FFCF
00FFE400FFF600FBFF00F3FF00F1FF00F4FF00FEFF00FFF100FFDC00FFC300FFA700FF89
00FF6B00FF4D00FF3100FF1800FF040BFF0016FF001AFF0019FF0011FF0003FF0000FF0F
00FF2800FF4400FF6500FF8800FFAD00FFD200FFF800E3FF00C1FF00A2FF0087FF0071FF
0060FF0054FF004EFF004EFF0055FF0061FF0074FF008CFF00A8FF00CAFF00EFFF00FFE8
00FFBD00FF9100FF6400FF3700FF0B1EFF0045FF006AFF008AFF00A6FF00BDFF00CFFF00
DBFF00E1FF00E1FF00DBFF00CEFF00BCFF00A5FF0087FF0065FF003FFF0014FF0000FF18
00FF4900FF7B00FFAF00FFE300E8FF00B4FF0083FF0053FF
53FF0024FF0000FF0C00FF3F00FF7300FFA800FFDC00F1FF00C0FF0092FF0066FF003FFF
001CFF0100FF1A00FF2D00FF3B00FF4200FF4300FF3E00FF3400FF2300FF0D00FF000DFF
002DFF0051FF0078FF00A1FF00CDFF00FAFF00FFD800FFAC00FF8100FF5800FF3200FF10
0DFF0025FF0039FF0046FF004EFF0050FF004BFF0041FF0030FF001BFF0001FF0000FF1C
00FF3E00FF6200FF8700FFAD00FFD200FFF500E9FF00CBFF00B2FF009DFF008FFF0086FF
0083FF0086FF0090FF009EFF00B2FF00CAFF00E6FF00FFFC00FFDD00FFBF00FFA300FF89
00FF7400FF6300FF5800FF5300FF5400FF5B00FF6800FF7900FF8E00FFA500FFBC00FFD2
00FFE400FFF300FFFB00FFFD00FFF900FFEF00FFE200FFD100FFC200FFB500FFAE00FFAE
00FFB300FFBD00FFC500FFC600FFC100FFC000FFC700FFD100FFD800FFD900FFD300FFC7
00FFB800FFA700FF9900FF8E00FF8900FF8A00FF9100FF9E00FFB000FFC600FFDD00FFF4
00F6FF00E4FF00D6FF00CEFF00CBFF00CFFF00D9FF00E9FF00FEFF00FFE800FFCC00FFAE
00FF9000FF7200FF5600FF3E00FF2900FF1900FF0E00FF0A00FF0C00FF1300FF2100FF34
00FF4D00FF6A00FF8A00FFAD00FFD200FFF800E2FF00BEFF009CFF007DFF0062FF004CFF
003AFF002FFF0029FF0029FF0030FF003CFF004FFF0066FF0083FF00A5FF00CAFF00F2FF
00FFE200FFB600FF8900FF5C00FF3100FF0620FF0045FF0065FF0081FF0098FF00AAFF00
B6FF00BCFF00BCFF00B6FF00A9FF0097FF007FFF0062FF0040FF001AFF0000FF1000FF3E
00FF6E00FFA000FFD400F7FF00C3FF008FFF005DFF002EFF
2EFF0000FF0100FF3200FF6500FF9900FFCD00FEFF00CBFF009AFF006CFF0041FF0019FF
0800FF2700FF4000FF5300FF6000FF6800FF6900FF6400FF5900FF4900FF3300FF1800FF
0007FF002BFF0052FF007CFF00A7FF00D4FF00FFFE00FFD200FFA700FF7E00FF5800FF36
00FF1800FF0013FF0021FF0028FF002AFF0025FF001BFF000BFF0000FF0A00FF2400FF42
00FF6400FF8700FFAD00FFD200FFF700E4FF00C3FF00A5FF008CFF0078FF0069FF0060FF
005DFF0061FF006AFF0079FF008DFF00A5FF00C0FF00DEFF00FCFF00FFE500FFC900FFAF
00FF9900FF8800FF7D00FF7800FF7900FF8100FF8D00FF9F00FFB300FFCA00FFE100FFF7
00F5FF00E7FF00DEFF00DCFF00E0FF00EAFF00F8FF00FFF700FFE700FFDB00FFD400FFD3
00FFD900FFE300FFEB00FFEB00FFE700FFE600FFED00FFF600FFFD00FFFE00FFF800FFED
00FFDD00FFCD00FFBF00FFB400FFAF00FFB000FFB700FFC400FFD600FFEB00FDFF00E6FF
00D0FF00BEFF00B0FF00A8FF00A6FF00AAFF00B4FF00C3FF00D8FF00F1FF00FFF200FFD4
00FFB600FF9800FF7C00FF6300FF4F00FF3F00FF3400FF3000FF3100FF3900FF4700FF5A
00FF7200FF8F00FFB000FFD300FFF800E2FF00BCFF0098FF0076FF0057FF003CFF0026FF
0015FF0009FF0003FF0004FF000AFF0016FF0029FF0041FF005EFF007FFF00A4FF00CCFF
00F7FF00FFDC00FFAF00FF8200FF5600FF2C00FF041FFF003FFF005BFF0073FF0084FF00
90FF0096FF0096FF0090FF0084FF0071FF005AFF003CFF001AFF0000FF0B00FF3600FF63
00FF9400FFC600FFFA00D1FF009DFF006AFF0038FF0008FF
08FF0000FF2600FF5700FF8A00FFBE00FFF300D9FF00A6FF0075FF0047FF001CFF0B00FF
2E00FF4C00FF6500FF7800FF8500FF8D00FF8E00FF8900FF7E00FF6E00FF5800FF3D00FF
1D00FF0006FF002DFF0056FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0303FF0005FF0000FF0000FF0900FF1900FF2F00FF4900FF67
00FF8900FFAC00FFD200FFF700E3FF00BFFF009EFF0080FF0067FF0053FF0044FF003BFF
0038FF003BFF0045FF0054FF0068FF0080FF009BFF00B8FF00D7FF00F5FF00FFEE00FFD4
00FFBE00FFAE00FFA200FF9D00FF9E00FFA600FFB200FFC400FFD900FFEF00F8FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F2FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EEFF00F3FF00F4FF00EDFF00E3FF00DCFF00DCFF00E2FF00EDFF
00FDFF00FFF200FFE400FFD900FFD400FFD500FFDC00FFE900FFFB00EEFF00D7FF00C0FF
00ABFF0099FF008BFF0083FF0081FF0084FF008EFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7400FF6400FF5900FF5500FF5600FF5E00FF6C00FF7F
00FF9800FFB400FFD500FFF800E2FF00BCFF0097FF0073FF0051FF0032FF0017FF0001FF
1000FF1B00FF2100FF2100FF1A00FF0E00FF0004FF001CFF0038FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2A00FF051AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006BFF005EFF004CFF0034FF0017FF0000FF0A00FF3000FF5B00FF88
00FFB900FFEB00E0FF00ACFF0078FF0044FF0013FF1C00FF
00FF1A00FF4900FF7B00FFAE00FFE200E9FF00B5FF0082FF0051FF0023FF0700FF2E00FF
5100FF6F00FF8800FF9B00FFA900FFB000FFB200FFAD00FFA200FF9100FF7B00FF6000FF
4100FF1D00FF0009FF0033FF005FFF008BFF00B8FF00E5FF00FFEF00FFC700FFA100FF7F
00FF6100FF4800FF3500FF2700FF1F00FF1E00FF2200FF2D00FF3D00FF5300FF6D00FF8B
00FFAC00FFD000FFF500E4FF00BFFF009BFF007AFF005DFF0043FF002FFF0020FF0017FF
0014FF0018FF0021FF0030FF0044FF005CFF0077FF0095FF00B3FF00D1FF00EEFF00FFF8
00FFE200FFD100FFC600FFC100FFC200FFC900FFD600FFE700FFFC00ECFF00D5FF00BFFF
00ACFF009EFF0096FF0093FF0097FF00A1FF00AFFF00BFFF00CFFF00DBFF00E3FF00E3FF
00DDFF00D4FF00CCFF00CBFF00D0FF00D1FF00CAFF00C0FF00B9FF00B8FF00BEFF00CAFF
00D9FF00E9FF00F8FF00FFFD00FFF700FFF800FFFF00F2FF00E0FF00CBFF00B4FF009DFF
0088FF0075FF0068FF005FFF005DFF0061FF006BFF007BFF008FFF00A8FF00C4FF00E2FF
00FFFE00FFE100FFC500FFAC00FF9700FF8700FF7D00FF7800FF7A00FF8200FF8F00FFA3
00FFBB00FFD800FFF800E3FF00BFFF0099FF0074FF004FFF002DFF000FFF0B00FF2200FF
3300FF3F00FF4500FF4400FF3E00FF3100FF1F00FF0700FF0015FF0036FF005BFF0084FF
00AEFF00DAFF00FFF800FFCB00FF9F00FF7500FF4D00FF2900FF0813FF002AFF003BFF00
47FF004DFF004DFF0047FF003BFF0029FF0011FF0000FF0B00FF2D00FF5400FF7E00FFAC
00FFDC00F0FF00BDFF0088FF0054FF0021FF1000FF4000FF
00FF3B00FF6A00FF9C00FFCF00FCFF00C8FF0094FF0061FF0030FF0002FF2800FF4F00FF
7200FF9000FFA900FFBD00FFCA00FFD100FFD300FFCE00FFC300FFB200FF9C00FF8100FF
6200FF3E00FF1700FF0012FF003DFF006AFF0097FF00C4FF00EFFF00FFE800FFC200FFA0
00FF8200FF6900FF5600FF4800FF4000FF3F00FF4300FF4E00FF5E00FF7400FF8E00FFAC
00FFCD00FFF100E9FF00C3FF009EFF007AFF0059FF003CFF0022FF000EFF0000FF0900FF
0C00FF0800FF0000FF000FFF0023FF003BFF0056FF0074FF0092FF00B0FF00CDFF00E6FF
00FCFF00FFF200FFE700FFE200FFE300FFEA00FFF700F7FF00E2FF00CBFF00B4FF009EFF
008BFF007DFF0075FF0072FF0076FF0080FF008EFF009EFF00AEFF00BAFF00C2FF00C2FF
00BCFF00B3FF00ABFF00AAFF00AFFF00B0FF00A9FF009FFF0098FF0097FF009DFF00A9FF
00B8FF00C8FF00D7FF00E1FF00E7FF00E6FF00DEFF00D1FF00BFFF00AAFF0093FF007CFF
0066FF0054FF0047FF003EFF003CFF0040FF004AFF005AFF006EFF0087FF00A3FF00C1FF
00E0FF00FDFF00FFE600FFCD00FFB800FFA800FF9E00FF9900FF9B00FFA300FFB000FFC4
00FFDC00FFF900E6FF00C2FF009EFF0078FF0053FF002EFF000CFF1100FF2C00FF4300FF
5400FF6000FF6600FF6500FF5F00FF5200FF4000FF2800FF0B00FF0015FF003AFF0063FF
008DFF00B9FF00E6FF00FFEC00FFC000FF9600FF6E00FF4A00FF2900FF0D09FF001AFF00
26FF002CFF002CFF0026FF001AFF0008FF0000FF0F00FF2C00FF4E00FF7500FF9F00FFCD
00FFFD00CFFF009CFF0067FF0033FF0000FF3100FF6100FF
00FF5900FF8800FFB900FFEC00DFFF00AAFF0076FF0044FF0013FF1A00FF4600FF6D00FF
9000FFAE00FFC700FFDA00FFE800FFEF00FFF000FFEB00FFE100FFD000FFBA00FF9F00FF
7F00FF5B00FF3400FF0B00FF0020FF004DFF007AFF00A6FF00D1FF00FAFF00FFDF00FFBD
00FF9F00FF8700FF7300FF6600FF5E00FF5C00FF6100FF6B00FF7C00FF9100FFAB00FFC9
00FFEB00F0FF00CBFF00A5FF0080FF005DFF003CFF001EFF0005FF0F00FF1D00FF2600FF
2900FF2600FF1C00FF0E00FF0005FF001DFF0039FF0056FF0075FF0093FF00AFFF00C9FF
00DEFF00EFFF00FAFF00FFFF00FEFF00F7FF00EAFF00D9FF00C4FF00ADFF0096FF0080FF
006EFF005FFF0057FF0055FF0059FF0063FF0070FF0081FF0090FF009DFF00A4FF00A4FF
009FFF0095FF008DFF008CFF0091FF0092FF008BFF0081FF007AFF0079FF007FFF008BFF
009AFF00ABFF00B9FF00C4FF00C9FF00C8FF00C1FF00B4FF00A2FF008CFF0075FF005EFF
0049FF0037FF0029FF0021FF001EFF0022FF002CFF003CFF0051FF006AFF0086FF00A4FF
00C2FF00E0FF00FCFF00FFEB00FFD600FFC600FFBB00FFB700FFB900FFC000FFCE00FFE1
00FFFA00E8FF00C8FF00A5FF0080FF005AFF0035FF0011FF1000FF2F00FF4A00FF6000FF
7200FF7D00FF8300FF8300FF7C00FF7000FF5D00FF4600FF2900FF0700FF001DFF0045FF
0070FF009CFF00C9FF00F6FF00FFDE00FFB300FF8C00FF6700FF4700FF2B00FF1400FF02
09FF000FFF000FFF0009FF0000FF0300FF1500FF2D00FF4A00FF6C00FF9200FFBD00FFEB
00E4FF00B2FF007EFF004AFF0016FF1D00FF4F00FF7E00FF
00FF7200FFA100FFD300F9FF00C5FF0091FF005DFF002AFF0500FF3400FF5F00FF8600FF
A900FFC700FFE000FFF300FFFF00FEFF00F7FF00F5FF00FAFA00FFE900FFD300FFB800FF
9900FF7500FF4E00FF2400FF0007FF0033FF0060FF008DFF00B8FF00E0FF00FFF900FFD7
00FFB900FFA000FF8D00FF7F00FF7700FF7600FF7A00FF8500FF9500FFAB00FFC500FFE3
00FBFF00D7FF00B2FF008CFF0067FF0043FF0022FF0005FF1400FF2800FF3700FF4000FF
4300FF3F00FF3600FF2700FF1300FF0004FF001FFF003DFF005BFF0079FF0096FF00AFFF
00C5FF00D6FF00E1FF00E6FF00E5FF00DEFF00D1FF00C0FF00ABFF0094FF007DFF0067FF
0054FF0046FF003EFF003BFF003FFF0049FF0057FF0067FF0077FF0083FF008BFF008BFF
0085FF007CFF0074FF0073FF0078FF0079FF0072FF0068FF0061FF0060FF0066FF0072FF
0081FF0091FF00A0FF00AAFF00B0FF00AFFF00A7FF009AFF0088FF0073FF005CFF0045FF
0030FF001DFF0010FF0007FF0005FF0009FF0013FF0023FF0037FF0050FF006CFF008AFF
00A9FF00C6FF00E2FF00FBFF00FFEF00FFDF00FFD500FFD000FFD200FFDA00FFE700FFFB
00ECFF00CFFF00AFFF008BFF0067FF0041FF001CFF0800FF2A00FF4800FF6300FF7A00FF
8B00FF9700FF9D00FF9C00FF9600FF8900FF7700FF5F00FF4200FF2100FF0003FF002CFF
0056FF0082FF00AFFF00DCFF00FFF700FFCD00FFA500FF8100FF6000FF4400FF2D00FF1B
00FF1000FF0A00FF0A00FF1000FF1C00FF2E00FF4600FF6300FF8500FFAC00FFD600FBFF
00CBFF0098FF0065FF0030FF0300FF3600FF6800FF9800FF
00FF8700FFB600FFE700E5FF00B1FF007DFF0049FF0016FF1A00FF4800FF7300FF9B00FF
BE00FFDC00FFF500FFFF00F7FF00EAFF00E2FF00E1FF00E6FF00F1FE00FFE800FFCD00FF
AD00FF8900FF6200FF3800FF0D00FF001FFF004CFF0078FF00A3FF00CCFF00F2FF00FFEB
00FFCD00FFB400FFA100FF9300FF8C00FF8A00FF8F00FF9900FFA900FFBF00FFD900FFF7
00E6FF00C3FF009DFF0078FF0053FF002FFF000EFF0F00FF2800FF3C00FF4B00FF5400FF
5700FF5400FF4A00FF3B00FF2700FF0F00FF000BFF0028FF0047FF0065FF0081FF009BFF
00B1FF00C1FF00CDFF00D2FF00D1FF00C9FF00BDFF00ABFF0096FF0080FF0068FF0053FF
0040FF0032FF0029FF0027FF002BFF0035FF0043FF0053FF0063FF006FFF0076FF0077FF
0071FF0067FF005FFF005FFF0063FF0064FF005DFF0053FF004DFF004CFF0052FF005DFF
006DFF007DFF008BFF0096FF009BFF009AFF0093FF0086FF0074FF005FFF0048FF0031FF
001BFF0009FF0400FF0C00FF0E00FF0B00FF0000FF000EFF0023FF003CFF0058FF0076FF
0094FF00B2FF00CEFF00E7FF00FBFF00FFF400FFE900FFE500FFE600FFEE00FFFC00F0FF
00D8FF00BBFF009AFF0077FF0052FF002DFF0007FF1C00FF3E00FF5D00FF7800FF8E00FF
9F00FFAB00FFB100FFB100FFAA00FF9E00FF8B00FF7300FF5700FF3500FF1000FF0017FF
0042FF006EFF009BFF00C8FF00F4FF00FFE100FFBA00FF9500FF7500FF5900FF4200FF30
00FF2400FF1E00FF1E00FF2400FF3000FF4300FF5A00FF7800FF9A00FFC000FFEB00E7FF
00B6FF0084FF0050FF001CFF1700FF4B00FF7C00FFAC00FF
00FF9500FFC400FFF600D6FF00A2FF006EFF003AFF0007FF2900FF5700FF8200FFA900FF
CC00FFEB00FFFF00FCFF00E8FF00DBFF00D3FF00D2FF00D7FF00E2FF00F2F700FFDB00FF
BC00FF9800FF7100FF4700FF1C00FF0010FF003DFF0069FF0094FF00BDFF00E3FF00FFFA
00FFDC00FFC300FFB000FFA200FF9A00FF9900FF9E00FFA800FFB800FFCE00FFE800F9FF
00D8FF00B4FF008FFF0069FF0044FF0020FF0000FF1D00FF3700FF4B00FF5A00FF6300FF
6600FF6200FF5900FF4A00FF3600FF1E00FF0300FF001AFF0038FF0056FF0072FF008CFF
00A2FF00B3FF00BEFF00C3FF00C2FF00BBFF00AEFF009CFF0088FF0071FF005AFF0044FF
0031FF0023FF001AFF0018FF001CFF0026FF0034FF0044FF0054FF0060FF0067FF0068FF
0062FF0058FF0050FF0050FF0054FF0055FF004EFF0045FF003EFF003DFF0043FF004EFF
005EFF006EFF007DFF0087FF008CFF008BFF0084FF0077FF0065FF0050FF0039FF0022FF
000CFF0500FF1300FF1B00FF1D00FF1900FF0F00FF0000FF0014FF002DFF0049FF0067FF
0085FF00A3FF00BFFF00D8FF00EDFF00FCFF00FFF800FFF400FFF500FFFD00F4FF00E1FF
00C9FF00ACFF008BFF0068FF0043FF001EFF0700FF2B00FF4D00FF6C00FF8700FF9D00FF
AE00FFBA00FFC000FFBF00FFB900FFAC00FF9A00FF8200FF6500FF4400FF1F00FF0008FF
0033FF005FFF008CFF00B9FF00E5FF00FFF000FFC800FFA400FF8300FF6700FF5000FF3F
00FF3300FF2D00FF2D00FF3300FF3F00FF5100FF6900FF8600FFA900FFCF00FFF900D8FF
00A7FF0075FF0041FF000DFF2600FF5900FF8B00FFBB00FF
00FF9E00FFCD00FFFF00CDFF0099FF0065FF0031FF0100FF3200FF6000FF8B00FFB200FF
D500FFF300FFFF00F3FF00DFFF00D2FF00CBFF00C9FF00CEFF00D9FF00EAFF00FFE400FF
C500FFA100FF7A00FF5000FF2500FF0007FF0034FF0060FF008BFF00B4FF00DAFF00FCFF
00FFE500FFCC00FFB900FFAB00FFA300FFA200FFA600FFB100FFC100FFD700FFF100F0FF
00CFFF00ABFF0086FF0060FF003BFF0017FF0900FF2600FF4000FF5400FF6300FF6C00FF
6F00FF6B00FF6200FF5300FF3F00FF2700FF0C00FF0011FF002FFF004DFF006AFF0083FF
0099FF00AAFF00B5FF00BAFF00B9FF00B2FF00A5FF0093FF007FFF0068FF0051FF003BFF
0028FF001AFF0011FF000FFF0013FF001DFF002BFF003BFF004BFF0057FF005FFF005FFF
0059FF0050FF0047FF0047FF004BFF004CFF0045FF003CFF0035FF0034FF003AFF0046FF
0055FF0065FF0074FF007EFF0084FF0083FF007BFF006EFF005CFF0047FF0030FF0019FF
0003FF0E00FF1B00FF2400FF2600FF2200FF1800FF0900FF000BFF0024FF0040FF005EFF
007CFF009AFF00B6FF00CFFF00E4FF00F4FF00FEFF00FFFC00FFFE00F9FF00ECFF00D8FF
00C0FF00A3FF0082FF005FFF003AFF0015FF1000FF3400FF5600FF7500FF9000FFA600FF
B700FFC300FFC900FFC800FFC200FFB500FFA300FF8B00FF6E00FF4D00FF2800FF0000FF
002AFF0056FF0083FF00B0FF00DCFF00FFF900FFD100FFAD00FF8C00FF7000FF5900FF48
00FF3C00FF3600FF3600FF3C00FF4800FF5A00FF7200FF8F00FFB100FFD800FDFF00CFFF
009FFF006CFF0038FF0004FF2F00FF6200FF9400FFC400FF
00FFA100FFD000FDFF00CAFF0096FF0062FF002EFF0400FF3400FF6300FF8E00FFB500FF
D800FFF600FFFF00F0FF00DDFF00CFFF00C8FF00C7FF00CBFF00D6FF00E7FF00FDE700FF
C700FFA400FF7D00FF5300FF2700FF0004FF0031FF005EFF0089FF00B1FF00D7FF00F9FF
00FFE800FFCF00FFBC00FFAE00FFA600FFA500FFA900FFB400FFC400FFD900FFF400EDFF
00CCFF00A8FF0083FF005DFF0038FF0014FF0C00FF2900FF4300FF5700FF6600FF6F00FF
7100FF6E00FF6500FF5600FF4200FF2A00FF0F00FF000EFF002CFF004AFF0067FF0080FF
0096FF00A7FF00B2FF00B7FF00B6FF00AFFF00A2FF0091FF007CFF0065FF004EFF0038FF
0025FF0017FF000FFF000CFF0011FF001AFF0028FF0038FF0048FF0055FF005CFF005CFF
0056FF004DFF0045FF0044FF0049FF004AFF0043FF0039FF0032FF0031FF0037FF0043FF
0052FF0062FF0071FF007BFF0081FF0080FF0078FF006BFF0059FF0044FF002DFF0016FF
0001FF1100FF1E00FF2700FF2900FF2500FF1B00FF0B00FF0009FF0021FF003DFF005BFF
007AFF0097FF00B3FF00CCFF00E1FF00F1FF00FBFF00FFFF00FEFF00F6FF00E9FF00D5FF
00BDFF00A0FF0080FF005DFF0038FF0012FF1200FF3700FF5800FF7700FF9200FFA900FF
BA00FFC600FFCB00FFCB00FFC500FFB800FFA600FF8E00FF7100FF5000FF2B00FF0200FF
0027FF0054FF0080FF00ADFF00D9FF00FFFC00FFD400FFB000FF8F00FF7300FF5C00FF4A
00FF3E00FF3800FF3900FF3F00FF4B00FF5D00FF7500FF9200FFB400FFDB00FAFF00CCFF
009CFF0069FF0036FF0001FF3200FF6500FF9700FFC600FF
00FF9E00FFCD00FFFE00CEFF009AFF0065FF0031FF0000FF3100FF5F00FF8A00FFB200FF
D500FFF300FFFF00F3FF00E0FF00D3FF00CBFF00CAFF00CFFF00DAFF00EAFF00FFE400FF
C400FFA000FF7900FF5000FF2400FF0008FF0035FF0061FF008CFF00B5FF00DBFF00FDFF
00FFE400FFCC00FFB800FFAA00FFA300FFA100FFA600FFB000FFC100FFD600FFF000F1FF
00CFFF00ABFF0086FF0061FF003BFF0018FF0800FF2600FF3F00FF5400FF6200FF6B00FF
6E00FF6B00FF6100FF5200FF3F00FF2600FF0B00FF0011FF0030FF004EFF006AFF0084FF
0099FF00AAFF00B5FF00BBFF00B9FF00B2FF00A5FF0094FF007FFF0068FF0051FF003BFF
0029FF001BFF0012FF0010FF0014FF001EFF002CFF003CFF004BFF0058FF005FFF0060FF
005AFF0050FF0048FF0047FF004CFF004DFF0046FF003CFF0035FF0034FF003AFF0046FF
0055FF0066FF0074FF007FFF0084FF0083FF007CFF006FFF005DFF0047FF0030FF0019FF
0004FF0D00FF1B00FF2300FF2600FF2200FF1800FF0800FF000CFF0025FF0041FF005FFF
007DFF009BFF00B7FF00CFFF00E4FF00F4FF00FFFF00FFFC00FFFD00FAFF00ECFF00D9FF
00C0FF00A3FF0083FF0060FF003BFF0015FF0F00FF3300FF5500FF7400FF8F00FFA500FF
B700FFC200FFC800FFC800FFC100FFB500FFA200FF8B00FF6E00FF4C00FF2700FF0000FF
002BFF0057FF0084FF00B1FF00DDFF00FFF800FFD100FFAC00FF8C00FF7000FF5900FF47
00FF3B00FF3500FF3500FF3B00FF4800FF5A00FF7200FF8F00FFB100FFD700FDFF00D0FF
009FFF006DFF0039FF0005FF2E00FF6200FF9400FFC300FF
00FF9400FFC300FFF500D7FF00A3FF006FFF003BFF0008FF2800FF5600FF8100FFA800FF
CB00FFEA00FFFF00FDFF00E9FF00DCFF00D5FF00D3FF00D8FF00E3FF00F3F600FFDA00FF
BB00FF9700FF7000FF4600FF1B00FF0011FF003EFF006AFF0095FF00BEFF00E4FF00FFF9
00FFDB00FFC200FFAF00FFA100FF9900FF9800FF9D00FFA700FFB700FFCD00FFE700FAFF
00D9FF00B5FF0090FF006AFF0045FF0021FF0000FF1C00FF3600FF4A00FF5900FF6200FF
6500FF6100FF5800FF4900FF3500FF1D00FF0200FF001BFF0039FF0057FF0073FF008DFF
00A3FF00B4FF00BFFF00C4FF00C3FF00BCFF00AFFF009DFF0089FF0072FF005BFF0045FF
0032FF0024FF001BFF0019FF001DFF0027FF0035FF0045FF0055FF0061FF0068FF0069FF
0063FF0059FF0051FF0051FF0055FF0056FF004FFF0046FF003FFF003EFF0044FF004FFF
005FFF006FFF007EFF0088FF008DFF008CFF0085FF0078FF0066FF0051FF003AFF0023FF
000DFF0400FF1200FF1A00FF1C00FF1800FF0E00FF0000FF0015FF002EFF004AFF0068FF
0086FF00A4FF00C0FF00D9FF00EEFF00FDFF00FFF700FFF200FFF400FFFC00F5FF00E2FF
00CAFF00ADFF008CFF0069FF0044FF001FFF0600FF2A00FF4C00FF6B00FF8600FF9C00FF
AD00FFB900FFBF00FFBE00FFB800FFAB00FF9900FF8100FF6400FF4300FF1E00FF0009FF
0034FF0060FF008DFF00BAFF00E6FF00FFEF00FFC700FFA300FF8200FF6600FF4F00FF3E
00FF3200FF2C00FF2C00FF3200FF3E00FF5000FF6800FF8500FFA700FFCE00FFF800D9FF
00A8FF0076FF0042FF000EFF2500FF5800FF8A00FFBA00FF
00FF8500FFB500FFE600E6FF00B2FF007EFF004AFF0017FF1900FF4700FF7200FF9A00FF
BC00FFDB00FFF300FFFF00F8FF00EBFF00E3FF00E2FF00E7FF00F2FD00FFE700FFCB00FF
AC00FF8800FF6100FF3700FF0C00FF0020FF004DFF0079FF00A4FF00CDFF00F3FF00FFEA
00FFCC00FFB300FFA000FF9200FF8B00FF8900FF8E00FF9800FFA800FFBE00FFD800FFF6
00E7FF00C4FF009EFF0079FF0054FF0030FF000FFF0E00FF2700FF3B00FF4A00FF5300FF
5600FF5200FF4900FF3A00FF2600FF0E00FF000CFF002AFF0048FF0066FF0082FF009CFF
00B2FF00C3FF00CEFF00D3FF00D2FF00CAFF00BEFF00ACFF0098FF0081FF006AFF0054FF
0041FF0033FF002AFF0028FF002CFF0036FF0044FF0054FF0064FF0070FF0077FF0078FF
0072FF0068FF0060FF0060FF0064FF0065FF005EFF0055FF004EFF004DFF0053FF005EFF
006EFF007EFF008CFF0097FF009CFF009BFF0094FF0087FF0075FF0060FF0049FF0032FF
001CFF000AFF0300FF0B00FF0D00FF0900FF0000FF000FFF0024FF003DFF0059FF0077FF
0095FF00B3FF00CFFF00E8FF00FCFF00FFF300FFE800FFE400FFE500FFED00FFFB00F1FF
00D9FF00BCFF009BFF0078FF0053FF002EFF0008FF1B00FF3D00FF5C00FF7700FF8D00FF
9E00FFAA00FFB000FFAF00FFA900FF9C00FF8A00FF7200FF5500FF3400FF0F00FF0018FF
0043FF006FFF009CFF00C9FF00F5FF00FFE000FFB800FF9400FF7400FF5800FF4000FF2F
00FF2300FF1D00FF1D00FF2300FF2F00FF4200FF5900FF7700FF9900FFBF00FFE900E8FF
00B7FF0085FF0051FF001DFF1600FF4900FF7B00FFAB00FF
00FF7200FFA100FFD200FAFF00C6FF0091FF005EFF002BFF0500FF3300FF5E00FF8600FF
A900FFC700FFE000FFF300FFFF00FFFF00F7FF00F6FF00FBF900FFE900FFD300FFB800FF
9800FF7400FF4D00FF2300FF0007FF0034FF0061FF008DFF00B8FF00E1FF00FFF800FFD6
00FFB800FF9F00FF8C00FF7E00FF7700FF7500FF7A00FF8400FF9400FFAA00FFC400FFE2
00FBFF00D8FF00B2FF008DFF0068FF0044FF0023FF0005FF1300FF2700FF3600FF3F00FF
4200FF3F00FF3500FF2600FF1200FF0005FF0020FF003DFF005CFF007AFF0096FF00B0FF
00C6FF00D6FF00E2FF00E7FF00E6FF00DEFF00D2FF00C0FF00ABFF0095FF007DFF0068FF
0055FF0047FF003EFF003CFF0040FF004AFF0058FF0068FF0077FF0084FF008BFF008CFF
0086FF007CFF0074FF0074FF0078FF0079FF0072FF0068FF0062FF0061FF0067FF0072FF
0082FF0092FF00A0FF00ABFF00B0FF00AFFF00A8FF009BFF0089FF0074FF005CFF0045FF
0030FF001EFF0010FF0008FF0006FF0009FF0013FF0023FF0038FF0051FF006DFF008BFF
00A9FF00C7FF00E3FF00FCFF00FFEF00FFDF00FFD400FFD000FFD100FFD900FFE700FFFA
00ECFF00D0FF00AFFF008CFF0067FF0042FF001CFF0700FF2900FF4800FF6300FF7900FF
8A00FF9600FF9C00FF9C00FF9500FF8900FF7600FF5E00FF4200FF2000FF0004FF002CFF
0057FF0083FF00B0FF00DDFF00FFF600FFCC00FFA500FF8000FF6000FF4400FF2D00FF1B
00FF0F00FF0900FF0900FF0F00FF1B00FF2E00FF4500FF6300FF8500FFAB00FFD600FCFF
00CBFF0099FF0065FF0031FF0200FF3600FF6700FF9700FF
00FF5900FF8900FFBA00FFED00DEFF00AAFF0076FF0043FF0012FF1B00FF4600FF6E00FF
9000FFAF00FFC800FFDB00FFE800FFF000FFF100FFEC00FFE100FFD100FFBB00FFA000FF
8000FF5C00FF3500FF0B00FF001FFF004CFF0079FF00A5FF00D0FF00F9FF00FFE000FFBE
00FFA000FF8700FF7400FF6600FF5F00FF5D00FF6200FF6C00FF7C00FF9200FFAC00FFCA
00FFEC00F0FF00CAFF00A5FF0080FF005CFF003BFF001DFF0004FF0F00FF1E00FF2700FF
2A00FF2600FF1D00FF0E00FF0005FF001DFF0038FF0056FF0074FF0092FF00AEFF00C8FF
00DEFF00EFFF00FAFF00FFFF00FEFF00F6FF00EAFF00D8FF00C4FF00ADFF0096FF0080FF
006DFF005FFF0056FF0054FF0058FF0062FF0070FF0080FF0090FF009CFF00A3FF00A4FF
009EFF0094FF008CFF008CFF0090FF0091FF008AFF0081FF007AFF0079FF007FFF008AFF
009AFF00AAFF00B8FF00C3FF00C8FF00C7FF00C0FF00B3FF00A1FF008CFF0075FF005EFF
0048FF0036FF0028FF0020FF001EFF0022FF002CFF003BFF0050FF0069FF0085FF00A3FF
00C1FF00DFFF00FBFF00FFEB00FFD700FFC700FFBC00FFB800FFB900FFC100FFCF00FFE2
00FFFA00E8FF00C7FF00A4FF007FFF005AFF0034FF0010FF1100FF3000FF4B00FF6100FF
7200FF7E00FF8400FF8300FF7D00FF7100FF5E00FF4600FF2900FF0800FF001CFF0044FF
006FFF009BFF00C8FF00F5FF00FFDE00FFB400FF8C00FF6800FF4800FF2C00FF1400FF03
08FF000EFF000EFF0008FF0000FF0300FF1600FF2D00FF4B00FF6D00FF9300FFBE00FFEB
00E3FF00B1FF007DFF0049FF0015FF1D00FF4F00FF7F00FF
00FF3E00FF6D00FF9F00FFD200F9FF00C5FF0091FF005EFF002DFF0000FF2B00FF5200FF
7500FF9300FFAC00FFBF00FFCD00FFD400FFD600FFD100FFC600FFB500FF9F00FF8400FF
6500FF4100FF1A00FF000FFF003BFF0067FF0094FF00C1FF00ECFF00FFEB00FFC500FFA3
00FF8500FF6C00FF5900FF4B00FF4300FF4200FF4600FF5100FF6100FF7700FF9100FFAF
00FFD000FFF400E6FF00C0FF009BFF0077FF0056FF0039FF001FFF000BFF0300FF0C00FF
0F00FF0B00FF0200FF000CFF0020FF0038FF0053FF0071FF008FFF00ADFF00CAFF00E3FF
00F9FF00FFF500FFEA00FFE500FFE600FFED00FFFA00F4FF00DFFF00C8FF00B1FF009BFF
0088FF007AFF0072FF006FFF0073FF007DFF008BFF009BFF00ABFF00B7FF00BFFF00BFFF
00B9FF00B0FF00A8FF00A7FF00ACFF00ADFF00A6FF009CFF0095FF0094FF009AFF00A6FF
00B5FF00C5FF00D4FF00DEFF00E4FF00E3FF00DBFF00CEFF00BCFF00A7FF0090FF0079FF
0064FF0051FF0044FF003BFF0039FF003DFF0047FF0057FF006BFF0084FF00A0FF00BEFF
00DDFF00FAFF00FFE900FFD000FFBB00FFAB00FFA100FF9C00FF9E00FFA600FFB300FFC7
00FFDF00FFFC00E3FF00BFFF009BFF0075FF0050FF002BFF0009FF1400FF2F00FF4600FF
5700FF6300FF6900FF6800FF6200FF5500FF4300FF2B00FF0E00FF0012FF0037FF0060FF
008AFF00B6FF00E3FF00FFEF00FFC300FF9900FF7100FF4D00FF2C00FF1006FF0017FF00
23FF0029FF0029FF0023FF0017FF0005FF0000FF1200FF2F00FF5100FF7800FFA200FFD0
00FFFF00CCFF0099FF0064FF0030FF0200FF3400FF6400FF
00FF2100FF5000FF8100FFB400FFE800E2FF00AEFF007CFF004BFF001DFF0D00FF3500FF
5800FF7600FF8F00FFA200FFAF00FFB700FFB800FFB300FFA800FF9800FF8200FF6700FF
4700FF2300FF0003FF002CFF0058FF0085FF00B2FF00DEFF00FFF600FFCD00FFA700FF85
00FF6700FF4F00FF3B00FF2D00FF2600FF2400FF2900FF3300FF4400FF5900FF7300FF91
00FFB300FFD700FFFC00DEFF00B8FF0095FF0074FF0056FF003DFF0028FF001AFF0011FF
000EFF0011FF001BFF002AFF003DFF0056FF0071FF008EFF00ADFF00CBFF00E7FF00FFFE
00FFE900FFD800FFCD00FFC700FFC900FFD000FFDD00FFEE00FCFF00E5FF00CEFF00B9FF
00A6FF0098FF008FFF008DFF0091FF009BFF00A9FF00B9FF00C8FF00D5FF00DCFF00DDFF
00D7FF00CDFF00C5FF00C4FF00C9FF00CAFF00C3FF00B9FF00B2FF00B1FF00B7FF00C3FF
00D2FF00E3FF00F1FF00FCFF00FFFE00FFFF00F9FF00ECFF00DAFF00C4FF00ADFF0096FF
0081FF006FFF0061FF0059FF0056FF005AFF0064FF0074FF0089FF00A2FF00BEFF00DCFF
00FAFF00FFE700FFCB00FFB300FF9E00FF8E00FF8300FF7F00FF8000FF8800FF9600FFA9
00FFC200FFDF00FFFF00DDFF00B8FF0092FF006DFF0049FF0027FF0008FF1200FF2800FF
3A00FF4500FF4B00FF4B00FF4400FF3800FF2500FF0E00FF000EFF0030FF0055FF007DFF
00A8FF00D4FF00FFFE00FFD100FFA500FF7B00FF5400FF2F00FF0F0CFF0023FF0035FF00
41FF0047FF0047FF0041FF0034FF0022FF000AFF0000FF1200FF3400FF5A00FF8500FFB2
00FFE300EAFF00B6FF0082FF004EFF001AFF1700FF4600FF
00FF0200FF3100FF6300FF9600FFCA00FFFE00CDFF009AFF0069FF003BFF0010FF1600FF
3900FF5700FF7000FF8400FF9100FF9800FF9A00FF9500FF8A00FF7A00FF6300FF4800FF
2900FF0500FF0021FF004BFF0076FF00A3FF00D0FF00FCFF00FFD800FFAF00FF8900FF67
00FF4900FF3000FF1D00FF0F00FF0700FF0600FF0A00FF1500FF2500FF3B00FF5500FF73
00FF9400FFB800FFDD00FCFF00D7FF00B3FF0092FF0075FF005BFF0047FF0038FF002FFF
002CFF0030FF0039FF0048FF005CFF0074FF008FFF00ADFF00CBFF00E9FF00FFF900FFE0
00FFCA00FFB900FFAE00FFA900FFAA00FFB100FFBE00FFD000FFE400FFFB00EDFF00D7FF
00C4FF00B6FF00ADFF00ABFF00AFFF00B9FF00C7FF00D7FF00E7FF00F3FF00FAFF00FBFF
00F5FF00ECFF00E3FF00E3FF00E7FF00E8FF00E1FF00D8FF00D1FF00D0FF00D6FF00E2FF
00F1FF00FFFE00FFEF00FFE500FFDF00FFE000FFE800FFF500F8FF00E3FF00CCFF00B5FF
009FFF008DFF007FFF0077FF0075FF0079FF0083FF0092FF00A7FF00C0FF00DCFF00FAFF
00FFE700FFC900FFAD00FF9400FF7F00FF6F00FF6500FF6000FF6200FF6A00FF7800FF8B
00FFA300FFC000FFE100FBFF00D6FF00B1FF008BFF0067FF0045FF0026FF000BFF0A00FF
1B00FF2700FF2D00FF2C00FF2600FF1900FF0700FF0010FF002DFF004EFF0073FF009BFF
00C6FF00F2FF00FFE000FFB300FF8700FF5D00FF3500FF110FFF002BFF0042FF0053FF00
5FFF0065FF0065FF005FFF0053FF0041FF0029FF000CFF0000FF1500FF3C00FF6600FF94
00FFC400FFF700D4FF00A0FF006CFF0039FF0007FF2800FF
1BFF0000FF1300FF4500FF7800FFAC00FFE000EBFF00B8FF0087FF0059FF002EFF0007FF
1B00FF3900FF5200FF6600FF7300FF7A00FF7C00FF7700FF6C00FF5B00FF4500FF2A00FF
0B00FF0018FF003FFF0069FF0094FF00C1FF00EEFF00FFE500FFBA00FF9100FF6B00FF49
00FF2B00FF1200FF000EFF0016FF0017FF0013FF0008FF0000FF0700FF1D00FF3700FF55
00FF7600FF9A00FFBF00FFE500F5FF00D1FF00B0FF0093FF0079FF0065FF0056FF004DFF
004AFF004EFF0057FF0066FF007AFF0092FF00ADFF00CBFF00E9FF00FFF800FFDB00FFC2
00FFAC00FF9B00FF9000FF8B00FF8C00FF9300FFA000FFB100FFC600FFDD00FFF400F5FF
00E2FF00D4FF00CBFF00C9FF00CDFF00D7FF00E5FF00F5FF00FFFA00FFEE00FFE600FFE6
00FFEC00FFF500FFFE00FFFE00FFFA00FFF900FFFF00F6FF00EFFF00EEFF00F4FF00FFFF
00FFF000FFE000FFD100FFC700FFC100FFC200FFCA00FFD700FFE900FFFE00EAFF00D3FF
00BDFF00ABFF009EFF0095FF0093FF0097FF00A1FF00B1FF00C5FF00DEFF00FAFF00FFE7
00FFC800FFAB00FF8F00FF7600FF6100FF5100FF4700FF4200FF4400FF4C00FF5900FF6D
00FF8500FFA200FFC300FFE600F4FF00CFFF00A9FF0085FF0063FF0044FF0029FF0013FF
0002FF0900FF0F00FF0E00FF0800FF0004FF0016FF002EFF004BFF006CFF0091FF00B9FF
00E4FF00FFEF00FFC200FF9500FF6900FF3F00FF170CFF002DFF0049FF0060FF0071FF00
7DFF0083FF0083FF007DFF0071FF005FFF0047FF002AFF0008FF0000FF1E00FF4800FF76
00FFA600FFD900F2FF00BEFF008AFF0057FF0025FF0A00FF
37FF0008FF0000FF2800FF5B00FF8F00FFC400FFF800D5FF00A4FF0076FF004AFF0023FF
0000FF1D00FF3600FF4900FF5700FF5E00FF5F00FF5A00FF5000FF3F00FF2900FF0E00FF
0011FF0034FF005CFF0085FF00B1FF00DEFF00FFF400FFC800FF9D00FF7400FF4E00FF2C
00FF0F09FF001DFF002AFF0032FF0034FF002FFF0024FF0014FF0000FF0000FF1A00FF39
00FF5A00FF7E00FFA300FFC900FFEE00EEFF00CDFF00AFFF0096FF0081FF0072FF006AFF
0067FF006AFF0073FF0082FF0096FF00AEFF00CAFF00E7FF00FFF900FFDB00FFBF00FFA5
00FF9000FF7F00FF7400FF6F00FF7000FF7700FF8400FF9500FFAA00FFC100FFD800FFEE
00FFFF00F0FF00E8FF00E6FF00EAFF00F3FF00FFFE00FFED00FFDE00FFD100FFCA00FFCA
00FFCF00FFD900FFE100FFE200FFDD00FFDC00FFE300FFED00FFF400FFF500FFEF00FFE3
00FFD400FFC300FFB500FFAA00FFA500FFA600FFAD00FFBB00FFCC00FFE200FFF900EFFF
00DAFF00C8FF00BAFF00B2FF00AFFF00B3FF00BDFF00CDFF00E2FF00FBFF00FFE800FFCA
00FFAC00FF8E00FF7300FF5A00FF4500FF3500FF2B00FF2600FF2800FF2F00FF3D00FF50
00FF6900FF8600FFA600FFC900FFEE00EBFF00C6FF00A2FF0080FF0061FF0046FF0030FF
001EFF0013FF000DFF000DFF0014FF0020FF0032FF004AFF0067FF0088FF00AEFF00D6FF
00FFFE00FFD200FFA500FF7800FF4D00FF2204FF0029FF0049FF0065FF007CFF008EFF00
9AFF00A0FF00A0FF0099FF008DFF007BFF0063FF0046FF0024FF0000FF0100FF2C00FF5A
00FF8A00FFBC00FFF000DBFF00A6FF0073FF0041FF0012FF
51FF0022FF0000FF0F00FF4200FF7600FFAA00FFDE00EEFF00BDFF008FFF0064FF003DFF
001AFF0300FF1C00FF3000FF3D00FF4400FF4600FF4100FF3600FF2500FF0F00FF000BFF
002AFF004EFF0075FF009FFF00CAFF00F7FF00FFDB00FFAE00FF8300FF5B00FF3500FF13
0AFF0023FF0036FF0044FF004CFF004DFF0049FF003EFF002EFF0018FF0000FF0100FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF800E6FF00C9FF00AFFF009BFF008CFF0083FF
0080FF0084FF008DFF009CFF00B0FF00C8FF00E3FF00FFFE00FFE000FFC200FFA500FF8C
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE700FFF500FFFD00FFFF00FFFC00FFF200FFE400FFD400FFC400FFB800FFB000FFB0
00FFB600FFBF00FFC700FFC800FFC300FFC200FFCA00FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9100FF8B00FF8C00FF9400FFA100FFB300FFC800FFDF00FFF6
00F3FF00E1FF00D4FF00CBFF00C9FF00CDFF00D7FF00E7FF00FBFF00FFEB00FFCF00FFB1
00FF9200FF7500FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1600FF2300FF37
00FF4F00FF6C00FF8C00FFB000FFD400FFFA00DFFF00BBFF0099FF007BFF0060FF0049FF
0038FF002CFF0026FF0027FF002DFF003AFF004CFF0064FF0081FF00A2FF00C7FF00F0FF
00FFE500FFB900FF8C00FF5F00FF3300FF091EFF0042FF0063FF007FFF0096FF00A7FF00
B3FF00B9FF00B9FF00B3FF00A7FF0095FF007DFF0060FF003EFF0017FF0000FF1200FF40
00FF7000FFA300FFD600F4FF00C0FF008DFF005BFF002BFF
67FF0037FF0006FF0000FF2C00FF6000FF9400FFC800FFFB00D3FF00A5FF007AFF0052FF
002FFF0011FF0700FF1A00FF2700FF2F00FF3000FF2B00FF2000FF1000FF0005FF0020FF
0040FF0064FF008BFF00B5FF00E0FF00FFF200FFC500FF9900FF6E00FF4500FF1F02FF00
20FF0039FF004CFF005AFF0061FF0063FF005EFF0054FF0044FF002EFF0014FF0000FF09
00FF2B00FF4E00FF7400FF9900FFBE00FFE200FCFF00DEFF00C5FF00B1FF00A2FF0099FF
0096FF0099FF00A3FF00B2FF00C6FF00DEFF00F9FF00FFE900FFCA00FFAC00FF9000FF76
00FF6000FF5000FF4400FF3F00FF4000FF4800FF5400FF6600FF7B00FF9100FFA900FFBE
00FFD100FFDF00FFE800FFEA00FFE600FFDC00FFCE00FFBE00FFAE00FFA200FF9B00FF9A
00FFA000FFAA00FFB200FFB200FFAE00FFAD00FFB400FFBE00FFC400FFC500FFBF00FFB4
00FFA400FF9400FF8600FF7B00FF7600FF7700FF7E00FF8B00FF9D00FFB200FFC900FFE0
00FFF600F7FF00E9FF00E1FF00DFFF00E2FF00EDFF00FCFF00FFEE00FFD500FFB900FF9B
00FF7D00FF5F00FF4300FF2A00FF1600FF0604FF0008FF0007FF0000FF0000FF0E00FF21
00FF3900FF5600FF7700FF9A00FFBF00FFE400F5FF00D1FF00AFFF0090FF0075FF005FFF
004EFF0042FF003CFF003CFF0043FF004FFF0062FF007AFF0096FF00B8FF00DDFF00FFFA
00FFCF00FFA300FF7600FF4900FF1D0CFF0033FF0058FF0078FF0094FF00ABFF00BDFF00
C9FF00CFFF00CFFF00C9FF00BDFF00AAFF0093FF0075FF0053FF002DFF0002FF0000FF2A
00FF5B00FF8D00FFC100FFF500D6FF00A2FF0071FF0041FF
77FF0048FF0017FF0000FF1B00FF4F00FF8400FFB800FFEA00E4FF00B6FF008BFF0063FF
0040FF0022FF0009FF0900FF1600FF1E00FF1F00FF1A00FF0F00FF0000FF0016FF0031FF
0051FF0075FF009CFF00C5FF00F1FF00FFE100FFB400FF8800FF5D00FF3400FF0E13FF00
31FF0049FF005DFF006BFF0072FF0074FF006FFF0065FF0054FF003FFF0025FF0007FF00
00FF1A00FF3E00FF6300FF8800FFAE00FFD100FFF200EFFF00D6FF00C1FF00B3FF00AAFF
00A7FF00AAFF00B4FF00C3FF00D6FF00EFFF00FFF500FFD800FFB900FF9B00FF7F00FF65
00FF5000FF3F00FF3400FF2E00FF3000FF3700FF4400FF5500FF6A00FF8100FF9800FFAD
00FFC000FFCE00FFD700FFD900FFD500FFCB00FFBD00FFAD00FF9E00FF9100FF8A00FF89
00FF8F00FF9900FFA100FFA200FF9D00FF9C00FFA300FFAD00FFB400FFB400FFAF00FFA3
00FF9400FF8300FF7500FF6A00FF6500FF6600FF6D00FF7A00FF8C00FFA200FFB900FFD0
00FFE500FFF700FAFF00F2FF00EFFF00F3FF00FDFF00FFF200FFDD00FFC400FFA800FF8A
00FF6C00FF4E00FF3200FF1A00FF050AFF0015FF0019FF0018FF0010FF0002FF0000FF10
00FF2900FF4500FF6600FF8900FFAE00FFD400FFF900E2FF00C0FF00A1FF0086FF0070FF
005EFF0053FF004DFF004DFF0054FF0060FF0073FF008AFF00A7FF00C9FF00EEFF00FFE9
00FFBE00FF9200FF6500FF3800FF0C1DFF0044FF0069FF0089FF00A5FF00BCFF00CEFF00
DAFF00E0FF00E0FF00DAFF00CDFF00BBFF00A3FF0086FF0064FF003EFF0013FF0000FF19
00FF4A00FF7C00FFB000FFE400E7FF00B3FF0082FF0052FF
83FF0053FF0022FF0000FF1000FF4400FF7800FFAC00FFDF00EFFF00C1FF0096FF006EFF
004BFF002DFF0014FF0001FF0B00FF1300FF1400FF0F00FF0400FF000BFF0021FF003CFF
005CFF0080FF00A7FF00D1FF00FCFF00FFD600FFA900FF7D00FF5200FF2900FF031EFF00
3CFF0055FF0068FF0076FF007DFF007FFF007AFF0070FF0060FF004AFF0030FF0012FF00
00FF0F00FF3200FF5800FF7D00FFA200FFC600FFE700FAFF00E1FF00CDFF00BEFF00B5FF
00B2FF00B5FF00BFFF00CEFF00E2FF00FAFF00FFEA00FFCD00FFAE00FF9000FF7400FF5A
00FF4400FF3400FF2800FF2300FF2400FF2C00FF3800FF4A00FF5F00FF7500FF8D00FFA2
00FFB500FFC300FFCC00FFCE00FFCA00FFC000FFB200FFA200FF9200FF8600FF7F00FF7E
00FF8400FF8E00FF9600FF9600FF9200FF9100FF9800FFA200FFA800FFA900FFA300FF98
00FF8800FF7800FF6A00FF5F00FF5A00FF5B00FF6200FF6F00FF8100FF9600FFAD00FFC4
00FFDA00FFEC00FFFA00FDFF00FBFF00FEFF00FFF600FFE700FFD200FFB900FF9D00FF7F
00FF6100FF4300FF2700FF0E05FF0015FF0020FF0024FF0023FF001BFF000DFF0000FF05
00FF1D00FF3A00FF5B00FF7E00FFA300FFC800FFEE00EDFF00CBFF00ACFF0091FF007BFF
006AFF005EFF0058FF0058FF005FFF006BFF007EFF0096FF00B2FF00D4FF00F9FF00FFDE
00FFB300FF8700FF5A00FF2D00FF0128FF004FFF0074FF0094FF00B0FF00C7FF00D9FF00
E5FF00EBFF00EBFF00E5FF00D9FF00C6FF00AFFF0091FF006FFF0049FF001EFF0000FF0E
00FF3F00FF7100FFA500FFD900F2FF00BEFF008DFF005DFF
88FF0058FF0027FF0000FF0B00FF3F00FF7300FFA700FFDA00F4FF00C6FF009BFF0074FF
0051FF0032FF001AFF0006FF0600FF0E00FF0F00FF0A00FF0000FF0010FF0026FF0042FF
0061FF0085FF00ACFF00D6FF00FFFE00FFD100FFA400FF7800FF4D00FF2401FF0023FF00
41FF005AFF006DFF007BFF0082FF0084FF007FFF0075FF0065FF004FFF0035FF0017FF00
00FF0A00FF2D00FF5300FF7800FF9D00FFC100FFE200FFFF00E6FF00D2FF00C3FF00BAFF
00B7FF00BBFF00C4FF00D3FF00E7FF00FFFF00FFE500FFC700FFA900FF8B00FF6F00FF55
00FF3F00FF2E00FF2300FF1E00FF1F00FF2600FF3300FF4500FF5900FF7000FF8700FF9D
00FFB000FFBE00FFC700FFC900FFC500FFBB00FFAD00FF9D00FF8D00FF8100FF7A00FF79
00FF7F00FF8900FF9100FF9100FF8D00FF8C00FF9300FF9C00FFA300FFA400FF9E00FF93
00FF8300FF7300FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7C00FF9100FFA800FFBF
00FFD500FFE700FFF500FFFD00FFFF00FFFB00FFF100FFE200FFCD00FFB400FF9800FF7A
00FF5C00FF3E00FF2200FF090AFF001AFF0025FF0029FF0028FF0020FF0012FF0000FF00
00FF1800FF3500FF5600FF7900FF9E00FFC300FFE900F2FF00D0FF00B1FF0096FF0080FF
006FFF0063FF005DFF005EFF0064FF0071FF0083FF009BFF00B8FF00D9FF00FEFF00FFD9
00FFAE00FF8200FF5500FF2803FF002DFF0055FF0079FF0099FF00B6FF00CDFF00DEFF00
EAFF00F0FF00F0FF00EAFF00DEFF00CBFF00B4FF0097FF0074FF004EFF0024FF0000FF09
00FF3A00FF6C00FFA000FFD400F7FF00C4FF0092FF0062FF
86FF0057FF0026FF0000FF0C00FF4000FF7500FFA800FFDB00F3FF00C5FF009AFF0072FF
004FFF0031FF0018FF0005FF0700FF0F00FF1000FF0B00FF0000FF000FFF0025FF0040FF
0060FF0084FF00ABFF00D5FF00FFFF00FFD200FFA500FF7900FF4E00FF2500FF0022FF00
40FF0059FF006CFF007AFF0081FF0083FF007EFF0074FF0064FF004EFF0034FF0016FF00
00FF0B00FF2E00FF5400FF7900FF9E00FFC200FFE300FEFF00E5FF00D1FF00C2FF00B9FF
00B6FF00B9FF00C3FF00D2FF00E6FF00FEFF00FFE600FFC900FFAA00FF8C00FF7000FF56
00FF4000FF3000FF2400FF1F00FF2000FF2800FF3400FF4600FF5B00FF7100FF8900FF9E
00FFB100FFBF00FFC800FFCA00FFC600FFBC00FFAE00FF9E00FF8F00FF8200FF7B00FF7A
00FF8000FF8A00FF9200FF9300FF8E00FF8D00FF9400FF9E00FFA400FFA500FF9F00FF94
00FF8400FF7400FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7D00FF9200FFAA00FFC1
00FFD600FFE800FFF600FFFE00FFFF00FFFD00FFF300FFE300FFCE00FFB500FF9900FF7B
00FF5D00FF3F00FF2300FF0A09FF0019FF0024FF0028FF0027FF001FFF0011FF0000FF01
00FF1A00FF3600FF5700FF7A00FF9F00FFC400FFEA00F1FF00CFFF00B0FF0095FF007FFF
006EFF0062FF005CFF005CFF0063FF006FFF0082FF009AFF00B6FF00D8FF00FDFF00FFDA
00FFAF00FF8300FF5600FF2902FF002CFF0053FF0078FF0098FF00B4FF00CBFF00DDFF00
E9FF00EFFF00EFFF00E9FF00DCFF00CAFF00B3FF0095FF0073FF004DFF0022FF0000FF0A
00FF3B00FF6D00FFA100FFD500F6FF00C2FF0091FF0061FF
7FFF0050FF001FFF0000FF1300FF4700FF7C00FFB000FFE200ECFF00BEFF0092FF006BFF
0048FF002AFF0011FF0100FF0F00FF1600FF1700FF1200FF0800FF0008FF001EFF0039FF
0059FF007DFF00A4FF00CDFF00F9FF00FFD900FFAC00FF8000FF5500FF2C00FF061BFF00
39FF0051FF0065FF0072FF007AFF007CFF0077FF006DFF005CFF0047FF002DFF000FFF00
00FF1200FF3600FF5B00FF8100FFA600FFC900FFEA00F7FF00DEFF00C9FF00BBFF00B2FF
00AFFF00B2FF00BCFF00CAFF00DEFF00F6FF00FFED00FFD000FFB100FF9300FF7700FF5D
00FF4800FF3700FF2C00FF2600FF2800FF2F00FF3C00FF4D00FF6200FF7900FF9000FFA6
00FFB800FFC600FFCF00FFD100FFCD00FFC300FFB600FFA500FF9600FF8900FF8200FF81
00FF8700FF9100FF9900FF9A00FF9500FF9400FF9B00FFA500FFAC00FFAD00FFA700FF9B
00FF8C00FF7B00FF6D00FF6200FF5D00FF5E00FF6500FF7200FF8400FF9A00FFB100FFC8
00FFDD00FFEF00FFFD00FAFF00F7FF00FBFF00FFFA00FFEA00FFD500FFBC00FFA000FF82
00FF6400FF4600FF2A00FF1202FF0012FF001DFF0021FF0020FF0018FF000AFF0000FF08
00FF2100FF3E00FF5E00FF8100FFA600FFCC00FFF100EAFF00C8FF00A9FF008EFF0078FF
0066FF005BFF0055FF0055FF005CFF0068FF007BFF0092FF00AFFF00D1FF00F6FF00FFE1
00FFB600FF8A00FF5D00FF3000FF0525FF004CFF0071FF0091FF00ADFF00C4FF00D6FF00
E2FF00E8FF00E8FF00E2FF00D5FF00C3FF00ABFF008EFF006CFF0046FF001BFF0000FF12
00FF4200FF7400FFA800FFDC00EFFF00BBFF0089FF005AFF
73FF0043FF0012FF0000FF2000FF5400FF8800FFBC00FFEF00DFFF00B1FF0086FF005EFF
003BFF001DFF0004FF0E00FF1B00FF2300FF2400FF1F00FF1400FF0400FF0011FF002CFF
004CFF0070FF0097FF00C1FF00ECFF00FFE600FFB900FF8D00FF6200FF3900FF130EFF00
2CFF0045FF0058FF0066FF006DFF006FFF006AFF0060FF0050FF003AFF0020FF0002FF00
00FF1F00FF4200FF6800FF8D00FFB200FFD600FFF700EAFF00D1FF00BDFF00AEFF00A5FF
00A2FF00A5FF00AFFF00BEFF00D2FF00EAFF00FFFA00FFDD00FFBE00FFA000FF8400FF6A
00FF5400FF4400FF3800FF3300FF3400FF3C00FF4800FF5A00FF6F00FF8500FF9D00FFB2
00FFC500FFD300FFDC00FFDE00FFDA00FFD000FFC200FFB200FFA200FF9600FF8F00FF8E
00FF9400FF9E00FFA600FFA600FFA200FFA100FFA800FFB200FFB800FFB900FFB300FFA8
00FF9800FF8800FF7A00FF6F00FF6A00FF6B00FF7200FF7F00FF9100FFA600FFBD00FFD4
00FFEA00FFFC00F5FF00EDFF00EBFF00EEFF00F9FF00FFF700FFE200FFC900FFAD00FF8F
00FF7100FF5300FF3700FF1E00FF0A05FF0010FF0014FF0013FF000BFF0000FF0200FF15
00FF2D00FF4A00FF6B00FF8E00FFB300FFD800FFFE00DDFF00BBFF009CFF0081FF006BFF
005AFF004EFF0048FF0048FF004FFF005BFF006EFF0086FF00A2FF00C4FF00E9FF00FFEE
00FFC300FF9700FF6A00FF3D00FF1118FF003FFF0064FF0084FF00A0FF00B7FF00C9FF00
D5FF00DBFF00DBFF00D5FF00C9FF00B6FF009FFF0081FF005FFF0039FF000EFF0000FF1E
00FF4F00FF8100FFB500FFE900E2FF00AEFF007DFF004DFF
61FF0032FF0001FF0000FF3200FF6600FF9A00FFCE00FFFF00CEFF009FFF0074FF004DFF
002AFF000CFF0C00FF1F00FF2D00FF3400FF3500FF3000FF2600FF1500FF0000FF001BFF
003BFF005EFF0085FF00AFFF00DBFF00FFF800FFCB00FF9E00FF7300FF4A00FF2400FF02
1AFF0033FF0047FF0054FF005CFF005EFF0059FF004EFF003EFF0029FF000FFF0000FF0F
00FF3000FF5400FF7900FF9F00FFC400FFE700F7FF00D9FF00C0FF00ABFF009CFF0093FF
0091FF0094FF009DFF00ACFF00C0FF00D8FF00F4FF00FFEE00FFD000FFB100FF9500FF7B
00FF6600FF5500FF4A00FF4500FF4600FF4D00FF5A00FF6B00FF8000FF9700FFAE00FFC4
00FFD600FFE500FFED00FFEF00FFEB00FFE200FFD400FFC400FFB400FFA700FFA000FFA0
00FFA600FFAF00FFB700FFB800FFB300FFB200FFB900FFC300FFCA00FFCB00FFC500FFB9
00FFAA00FF9A00FF8B00FF8000FF7B00FF7C00FF8300FF9100FFA300FFB800FFCF00FFE6
00FFFB00F2FF00E4FF00DCFF00D9FF00DDFF00E7FF00F7FF00FFF300FFDA00FFBE00FFA1
00FF8200FF6400FF4900FF3000FF1B00FF0B00FF0103FF0001FF0000FF0500FF1300FF26
00FF3F00FF5C00FF7C00FF9F00FFC400FFEA00F0FF00CCFF00AAFF008BFF0070FF0059FF
0048FF003DFF0037FF0037FF003EFF004AFF005CFF0074FF0091FF00B2FF00D8FF00FFFF
00FFD400FFA800FF7B00FF4F00FF2306FF002EFF0052FF0073FF008FFF00A6FF00B8FF00
C4FF00CAFF00CAFF00C3FF00B7FF00A5FF008DFF0070FF004EFF0027FF0000FF0200FF30
00FF6000FF9200FFC600FFFA00D0FF009DFF006BFF003CFF
4CFF001DFF0000FF1300FF4600FF7A00FFAF00FFE300EAFF00B9FF008BFF0060FF0038FF
0015FF0800FF2100FF3400FF4100FF4900FF4A00FF4500FF3A00FF2A00FF1400FF0006FF
0026FF004AFF0071FF009AFF00C6FF00F3FF00FFDF00FFB300FF8800FF5F00FF3900FF17
06FF001EFF0032FF0040FF0047FF0049FF0044FF003AFF0029FF0014FF0000FF0500FF23
00FF4500FF6900FF8E00FFB300FFD900FFFC00E2FF00C4FF00ABFF0096FF0088FF007FFF
007CFF007FFF0089FF0098FF00ABFF00C4FF00DFFF00FCFF00FFE400FFC600FFAA00FF90
00FF7B00FF6A00FF5F00FF5900FF5B00FF6200FF6F00FF8000FF9500FFAC00FFC300FFD9
00FFEB00FFF900FDFF00FBFF00FFFF00FFF600FFE800FFD800FFC900FFBC00FFB500FFB4
00FFBA00FFC400FFCC00FFCD00FFC800FFC700FFCE00FFD800FFDF00FFE000FFDA00FFCE
00FFBF00FFAE00FFA000FF9500FF9000FF9100FF9800FFA500FFB700FFCD00FFE400FFFB
00EFFF00DDFF00CFFF00C7FF00C4FF00C8FF00D2FF00E2FF00F7FF00FFEF00FFD300FFB5
00FF9700FF7900FF5D00FF4500FF3000FF2000FF1500FF1100FF1200FF1A00FF2800FF3B
00FF5400FF7100FF9100FFB400FFD900FFFF00DBFF00B7FF0095FF0076FF005BFF0045FF
0033FF0028FF0022FF0022FF0029FF0035FF0048FF005FFF007CFF009EFF00C3FF00EBFF
00FFE900FFBD00FF9000FF6300FF3800FF0D19FF003EFF005EFF007AFF0091FF00A3FF00
AFFF00B5FF00B5FF00AFFF00A2FF0090FF0078FF005BFF0039FF0013FF0000FF1700FF44
00FF7500FFA700FFDB00F0FF00BCFF0088FF0056FF0027FF
35FF0006FF0000FF2A00FF5D00FF9100FFC600FFF900D3FF00A2FF0074FF0049FF0021FF
0100FF1F00FF3800FF4B00FF5800FF6000FF6100FF5C00FF5100FF4100FF2B00FF1000FF
000FFF0033FF005AFF0084FF00AFFF00DCFF00FFF600FFCA00FF9F00FF7600FF5000FF2E
00FF1008FF001BFF0029FF0030FF0032FF002DFF0023FF0013FF0000FF0200FF1C00FF3A
00FF5C00FF7F00FFA500FFCA00FFEF00ECFF00CBFF00ADFF0094FF0080FF0071FF0068FF
0065FF0068FF0072FF0081FF0095FF00ADFF00C8FF00E5FF00FFFB00FFDD00FFC100FFA7
00FF9100FF8100FF7500FF7000FF7100FF7900FF8500FF9700FFAC00FFC200FFDA00FFEF
00FDFF00EFFF00E6FF00E4FF00E8FF00F2FF00FFFF00FFEF00FFE000FFD300FFCC00FFCB
00FFD100FFDB00FFE300FFE300FFDF00FFDE00FFE500FFEF00FFF500FFF600FFF000FFE5
00FFD500FFC500FFB700FFAC00FFA700FFA800FFAF00FFBC00FFCE00FFE300FFFB00EDFF
00D8FF00C6FF00B8FF00B0FF00AEFF00B1FF00BBFF00CBFF00E0FF00F9FF00FFEA00FFCC
00FFAE00FF9000FF7400FF5B00FF4700FF3700FF2C00FF2800FF2900FF3100FF3F00FF52
00FF6B00FF8700FFA800FFCB00FFF000EAFF00C4FF00A0FF007EFF005FFF0044FF002EFF
001DFF0011FF000BFF000BFF0012FF001EFF0031FF0049FF0065FF0087FF00ACFF00D4FF
00FFFF00FFD400FFA700FF7A00FF4E00FF2402FF0027FF0047FF0063FF007AFF008CFF00
98FF009EFF009EFF0098FF008CFF0079FF0062FF0044FF0022FF0000FF0300FF2E00FF5B
00FF8C00FFBE00FFF200D9FF00A5FF0071FF0040FF0010FF
1EFF0000FF1000FF4100FF7400FFA800FFDD00EEFF00BCFF008BFF005DFF0032FF000AFF
1800FF3600FF4F00FF6200FF6F00FF7700FF7800FF7300FF6800FF5800FF4200FF2700FF
0700FF001CFF0043FF006CFF0098FF00C5FF00F2FF00FFE100FFB600FF8D00FF6700FF45
00FF2700FF0F04FF0012FF0019FF001BFF0016FF000CFF0000FF0400FF1900FF3300FF51
00FF7300FF9700FFBC00FFE100F8FF00D5FF00B4FF0096FF007DFF0068FF005AFF0051FF
004EFF0051FF005BFF006AFF007DFF0096FF00B1FF00CEFF00EDFF00FFF400FFD800FFBE
00FFA900FF9800FF8D00FF8700FF8900FF9000FF9D00FFAE00FFC300FFDA00FFF100F9FF
00E6FF00D8FF00CFFF00CDFF00D1FF00DBFF00E9FF00F9FF00FFF700FFEA00FFE300FFE2
00FFE800FFF200FFFA00FFFB00FFF600FFF500FFFC00F9FF00F2FF00F2FF00F7FF00FFFC
00FFED00FFDC00FFCE00FFC300FFBE00FFBF00FFC600FFD300FFE500FFFB00EDFF00D6FF
00C1FF00AFFF00A1FF0099FF0096FF009AFF00A4FF00B4FF00C9FF00E2FF00FEFF00FFE3
00FFC500FFA700FF8B00FF7300FF5E00FF4E00FF4300FF3F00FF4000FF4800FF5600FF69
00FF8200FF9E00FFBF00FFE200F8FF00D2FF00ADFF0089FF0067FF0048FF002DFF0017FF
0005FF0500FF0B00FF0B00FF0400FF0007FF001AFF0031FF004EFF0070FF0095FF00BDFF
00E8FF00FFEB00FFBE00FF9100FF6500FF3B00FF1410FF0030FF004CFF0063FF0075FF00
81FF0087FF0087FF0081FF0074FF0062FF004AFF002DFF000BFF0000FF1A00FF4500FF72
00FFA300FFD500F6FF00C2FF008EFF005AFF0028FF0600FF
09FF0000FF2600FF5700FF8A00FFBE00FFF200D9FF00A6FF0075FF0047FF001CFF0B00FF
2E00FF4C00FF6500FF7800FF8500FF8D00FF8E00FF8900FF7E00FF6E00FF5800FF3D00FF
1D00FF0006FF002DFF0057FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0303FF0005FF0000FF0000FF0900FF1900FF2F00FF4900FF67
00FF8900FFAC00FFD200FFF700E3FF00BFFF009EFF0080FF0067FF0053FF0044FF003BFF
0038FF003BFF0045FF0054FF0068FF0080FF009BFF00B9FF00D7FF00F5FF00FFEE00FFD4
00FFBE00FFAD00FFA200FF9D00FF9E00FFA600FFB200FFC400FFD900FFEF00F9FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F3FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EFFF00F3FF00F4FF00EDFF00E3FF00DDFF00DCFF00E2FF00EDFF
00FDFF00FFF200FFE400FFD900FFD400FFD500FFDC00FFE900FFFB00EFFF00D8FF00C1FF
00ABFF0099FF008BFF0083FF0081FF0085FF008FFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7400FF6400FF5900FF5500FF5600FF5E00FF6C00FF7F
00FF9700FFB400FFD500FFF800E2FF00BDFF0097FF0073FF0051FF0032FF0017FF0001FF
0F00FF1B00FF2100FF2100FF1A00FF0E00FF0004FF001CFF0038FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2A00FF051AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006BFF005FFF004CFF0035FF0017FF0000FF0A00FF3000FF5B00FF88
00FFB900FFEB00E0FF00ACFF0078FF0045FF0013FF1C00FF
00FF0900FF3800FF6A00FF9D00FFD100FAFF00C6FF0093FF0062FF0034FF0009FF1D00FF
4000FF5E00FF7700FF8B00FF9800FF9F00FFA100FF9C00FF9100FF8000FF6A00FF4F00FF
3000FF0C00FF001AFF0044FF006FFF009CFF00C9FF00F6FF00FFDE00FFB600FF9000FF6E
00FF5000FF3700FF2400FF1600FF0E00FF0D00FF1100FF1C00FF2C00FF4200FF5C00FF7A
00FF9B00FFBF00FFE400F5FF00D0FF00ACFF008BFF006EFF0054FF0040FF0031FF0028FF
0025FF0029FF0032FF0041FF0055FF006DFF0088FF00A6FF00C4FF00E2FF00FFFF00FFE7
00FFD100FFC000FFB500FFB000FFB100FFB800FFC500FFD600FFEB00FDFF00E6FF00D0FF
00BDFF00AFFF00A7FF00A4FF00A8FF00B2FF00C0FF00D0FF00E0FF00ECFF00F4FF00F4FF
00EEFF00E5FF00DDFF00DCFF00E0FF00E2FF00DAFF00D1FF00CAFF00C9FF00CFFF00DBFF
00EAFF00FAFF00FFF600FFEC00FFE600FFE700FFEF00FFFC00F1FF00DCFF00C5FF00AEFF
0098FF0086FF0079FF0070FF006EFF0072FF007CFF008CFF00A0FF00B9FF00D5FF00F3FF
00FFED00FFD000FFB400FF9B00FF8600FF7600FF6C00FF6700FF6900FF7100FF7E00FF92
00FFAA00FFC700FFE700F4FF00D0FF00AAFF0084FF0060FF003EFF0020FF0005FF1100FF
2200FF2E00FF3400FF3300FF2D00FF2000FF0E00FF0009FF0026FF0047FF006CFF0095FF
00BFFF00EBFF00FFE700FFBA00FF8E00FF6400FF3C00FF1808FF0024FF003BFF004CFF00
58FF005EFF005EFF0058FF004CFF003AFF0022FF0005FF0000FF1C00FF4300FF6D00FF9B
00FFCB00FFFE00CEFF0099FF0065FF0032FF0000FF2F00FF
00FF1700FF4700FF7800FFAB00FFDF00ECFF00B8FF0085FF0054FF0026FF0400FF2B00FF
4E00FF6D00FF8500FF9900FFA600FFAE00FFAF00FFAA00FF9F00FF8F00FF7900FF5D00FF
3E00FF1A00FF000CFF0036FF0061FF008EFF00BBFF00E7FF00FFED00FFC400FF9E00FF7C
00FF5E00FF4500FF3200FF2400FF1D00FF1B00FF2000FF2A00FF3A00FF5000FF6A00FF88
00FFAA00FFCD00FFF300E7FF00C2FF009EFF007DFF005FFF0046FF0032FF0023FF001AFF
0017FF001BFF0024FF0033FF0047FF005FFF007AFF0098FF00B6FF00D4FF00F0FF00FFF5
00FFDF00FFCE00FFC300FFBE00FFBF00FFC600FFD300FFE500FFF900EFFF00D8FF00C2FF
00AFFF00A1FF0098FF0096FF009AFF00A4FF00B2FF00C2FF00D2FF00DEFF00E5FF00E6FF
00E0FF00D6FF00CEFF00CEFF00D2FF00D3FF00CCFF00C3FF00BCFF00BBFF00C1FF00CCFF
00DCFF00ECFF00FAFF00FFFA00FFF500FFF600FFFD00F5FF00E3FF00CEFF00B7FF00A0FF
008AFF0078FF006AFF0062FF0060FF0064FF006EFF007DFF0092FF00ABFF00C7FF00E5FF
00FFFC00FFDE00FFC200FFA900FF9500FF8500FF7A00FF7600FF7700FF7F00FF8D00FFA0
00FFB800FFD500FFF600E6FF00C1FF009CFF0076FF0052FF0030FF0011FF0900FF1F00FF
3000FF3C00FF4200FF4100FF3B00FF2E00FF1C00FF0400FF0018FF0039FF005EFF0086FF
00B1FF00DDFF00FFF500FFC800FF9C00FF7200FF4A00FF2600FF0616FF002DFF003EFF00
4AFF0050FF0050FF004AFF003EFF002BFF0014FF0000FF0800FF2B00FF5100FF7B00FFA9
00FFDA00F3FF00BFFF008BFF0057FF0024FF0D00FF3D00FF
00FF2000FF4F00FF8000FFB400FFE800E3FF00AFFF007DFF004CFF001DFF0D00FF3400FF
5700FF7500FF8E00FFA100FFAF00FFB600FFB700FFB300FFA800FF9700FF8100FF6600FF
4600FF2300FF0003FF002DFF0059FF0085FF00B2FF00DFFF00FFF500FFCC00FFA700FF84
00FF6700FF4E00FF3A00FF2D00FF2500FF2400FF2800FF3300FF4300FF5800FF7200FF91
00FFB200FFD600FFFB00DEFF00B9FF0096FF0075FF0057FF003EFF0029FF001AFF0011FF
000FFF0012FF001BFF002AFF003EFF0056FF0072FF008FFF00ADFF00CBFF00E8FF00FFFD
00FFE800FFD700FFCC00FFC700FFC800FFCF00FFDC00FFED00FDFF00E6FF00CFFF00B9FF
00A7FF0098FF0090FF008EFF0092FF009BFF00A9FF00B9FF00C9FF00D6FF00DDFF00DDFF
00D7FF00CEFF00C6FF00C5FF00CAFF00CBFF00C4FF00BAFF00B3FF00B2FF00B8FF00C4FF
00D3FF00E3FF00F2FF00FDFF00FFFD00FFFE00FAFF00ECFF00DAFF00C5FF00AEFF0097FF
0082FF0070FF0062FF005AFF0057FF005BFF0065FF0075FF008AFF00A3FF00BFFF00DCFF
00FBFF00FFE600FFCB00FFB200FF9D00FF8D00FF8300FF7E00FF8000FF8700FF9500FFA8
00FFC100FFDE00FFFE00DEFF00B9FF0093FF006EFF004AFF0028FF0009FF1100FF2800FF
3900FF4500FF4A00FF4A00FF4400FF3700FF2500FF0D00FF000FFF0030FF0056FF007EFF
00A8FF00D5FF00FFFD00FFD100FFA500FF7B00FF5300FF2F00FF0E0DFF0024FF0036FF00
42FF0048FF0048FF0041FF0035FF0023FF000BFF0000FF1100FF3300FF5A00FF8400FFB2
00FFE200EBFF00B7FF0083FF004EFF001BFF1600FF4500FF
00FF2200FF5100FF8300FFB600FFEA00E1FF00ADFF007AFF0049FF001BFF0F00FF3600FF
5900FF7700FF9000FFA400FFB100FFB800FFBA00FFB500FFAA00FF9900FF8300FF6800FF
4900FF2500FF0001FF002BFF0056FF0083FF00B0FF00DDFF00FFF700FFCF00FFA900FF87
00FF6900FF5000FF3D00FF2F00FF2700FF2600FF2A00FF3500FF4500FF5B00FF7500FF93
00FFB400FFD800FFFD00DCFF00B7FF0093FF0072FF0055FF003BFF0027FF0018FF000FFF
000CFF0010FF0019FF0028FF003CFF0054FF006FFF008DFF00ABFF00C9FF00E6FF00FFFF
00FFEA00FFD900FFCE00FFC900FFCA00FFD100FFDE00FFEF00FBFF00E4FF00CDFF00B7FF
00A4FF0096FF008EFF008BFF008FFF0099FF00A7FF00B7FF00C7FF00D3FF00DBFF00DBFF
00D5FF00CCFF00C4FF00C3FF00C8FF00C9FF00C2FF00B8FF00B1FF00B0FF00B6FF00C2FF
00D1FF00E1FF00F0FF00FAFF00FFFF00FFFF00F7FF00EAFF00D8FF00C3FF00ACFF0095FF
007FFF006DFF0060FF0057FF0055FF0059FF0063FF0073FF0087FF00A0FF00BCFF00DAFF
00F9FF00FFE900FFCD00FFB400FF9F00FF8F00FF8500FF8000FF8200FF8A00FF9700FFAB
00FFC300FFE000FFFF00DBFF00B7FF0091FF006CFF0047FF0025FF0007FF1300FF2A00FF
3B00FF4700FF4D00FF4C00FF4600FF3900FF2700FF0F00FF000DFF002EFF0053FF007CFF
00A6FF00D2FF00FFFF00FFD300FFA700FF7D00FF5500FF3100FF100BFF0022FF0033FF00
3FFF0045FF0045FF003FFF0033FF0021FF0009FF0000FF1300FF3500FF5C00FF8600FFB4
00FFE400E8FF00B5FF0080FF004CFF0019FF1800FF4800FF
00FF1E00FF4D00FF7F00FFB200FFE600E5FF00B1FF007EFF004EFF001FFF0B00FF3200FF
5500FF7300FF8C00FF9F00FFAD00FFB400FFB500FFB100FFA600FF9500FF7F00FF6400FF
4400FF2100FF0005FF002FFF005BFF0087FF00B4FF00E1FF00FFF300FFCB00FFA500FF83
00FF6500FF4C00FF3900FF2B00FF2300FF2200FF2600FF3100FF4100FF5600FF7100FF8F
00FFB000FFD400FFF900E0FF00BBFF0097FF0076FF0059FF003FFF002BFF001CFF0013FF
0011FF0014FF001DFF002CFF0040FF0058FF0073FF0091FF00AFFF00CDFF00EAFF00FFFC
00FFE600FFD500FFCA00FFC500FFC600FFCD00FFDA00FFEB00FFFF00E8FF00D1FF00BBFF
00A8FF009AFF0092FF008FFF0094FF009DFF00ABFF00BBFF00CBFF00D8FF00DFFF00DFFF
00D9FF00D0FF00C8FF00C7FF00CCFF00CDFF00C6FF00BCFF00B5FF00B4FF00BAFF00C6FF
00D5FF00E5FF00F4FF00FEFF00FFFB00FFFC00FBFF00EEFF00DCFF00C7FF00B0FF0099FF
0084FF0071FF0064FF005BFF0059FF005DFF0067FF0077FF008CFF00A4FF00C0FF00DEFF
00FDFF00FFE500FFC900FFB000FF9B00FF8B00FF8100FF7C00FF7E00FF8600FF9300FFA7
00FFBF00FFDC00FFFC00E0FF00BBFF0095FF0070FF004BFF002AFF000BFF0F00FF2600FF
3700FF4300FF4800FF4800FF4200FF3500FF2300FF0B00FF0011FF0032FF0057FF0080FF
00AAFF00D7FF00FFFC00FFCF00FFA300FF7900FF5100FF2D00FF0C0FFF0026FF0038FF00
44FF004AFF0049FF0043FF0037FF0025FF000DFF0000FF0F00FF3100FF5800FF8200FFB0
00FFE000ECFF00B9FF0084FF0050FF001DFF1400FF4400FF
00FF1400FF4300FF7500FFA800FFDC00EFFF00BBFF0088FF0057FF0029FF0100FF2800FF
4B00FF6A00FF8200FF9600FFA300FFAA00FFAC00FFA700FF9C00FF8C00FF7600FF5A00FF
3B00FF1700FF000FFF0039FF0064FF0091FF00BEFF00EAFF00FFEA00FFC100FF9B00FF79
00FF5B00FF4200FF2F00FF2100FF1900FF1800FF1D00FF2700FF3700FF4D00FF6700FF85
00FFA600FFCA00FFEF00EAFF00C5FF00A1FF0080FF0063FF0049FF0035FF0026FF001DFF
001AFF001EFF0027FF0036FF004AFF0062FF007DFF009BFF00B9FF00D7FF00F3FF00FFF2
00FFDC00FFCB00FFC000FFBB00FFBC00FFC300FFD000FFE200FFF600F2FF00DBFF00C5FF
00B2FF00A4FF009BFF0099FF009DFF00A7FF00B5FF00C5FF00D5FF00E1FF00E8FF00E9FF
00E3FF00D9FF00D1FF00D1FF00D5FF00D6FF00CFFF00C6FF00BFFF00BEFF00C4FF00CFFF
00DFFF00EFFF00FEFF00FFF700FFF200FFF300FFFA00F8FF00E6FF00D1FF00BAFF00A3FF
008DFF007BFF006DFF0065FF0063FF0067FF0071FF0080FF0095FF00AEFF00CAFF00E8FF
00FFF900FFDB00FFBF00FFA600FF9100FF8200FF7700FF7200FF7400FF7C00FF8A00FF9D
00FFB500FFD200FFF300E9FF00C4FF009FFF0079FF0055FF0033FF0014FF0600FF1C00FF
2D00FF3900FF3F00FF3E00FF3800FF2B00FF1900FF0100FF001BFF003CFF0061FF0089FF
00B4FF00E0FF00FFF200FFC500FF9900FF6F00FF4700FF2300FF0219FF0030FF0041FF00
4DFF0053FF0053FF004DFF0041FF002FFF0017FF0000FF0500FF2700FF4E00FF7800FFA6
00FFD700F6FF00C2FF008EFF005AFF0027FF0A00FF3A00FF
00FF0600FF3600FF6700FF9A00FFCE00FDFF00C9FF0096FF0065FF0037FF000CFF1A00FF
3D00FF5C00FF7400FF8800FF9500FF9D00FF9E00FF9900FF8E00FF7E00FF6800FF4C00FF
2D00FF0900FF001DFF0047FF0072FF009FFF00CCFF00F8FF00FFDC00FFB300FF8D00FF6B
00FF4D00FF3400FF2100FF1300FF0C00FF0A00FF0F00FF1900FF2900FF3F00FF5900FF77
00FF9900FFBC00FFE200F8FF00D3FF00AFFF008EFF0070FF0057FF0043FF0034FF002BFF
0028FF002CFF0035FF0044FF0058FF0070FF008BFF00A9FF00C7FF00E5FF00FFFE00FFE4
00FFCE00FFBD00FFB200FFAD00FFAE00FFB600FFC200FFD400FFE800FFFF00E9FF00D3FF
00C0FF00B2FF00A9FF00A7FF00ABFF00B5FF00C3FF00D3FF00E3FF00EFFF00F6FF00F7FF
00F1FF00E7FF00DFFF00DFFF00E3FF00E4FF00DDFF00D4FF00CDFF00CCFF00D2FF00DDFF
00EDFF00FDFF00FFF400FFE900FFE400FFE500FFEC00FFF900F4FF00DFFF00C8FF00B1FF
009BFF0089FF007BFF0073FF0071FF0075FF007FFF008EFF00A3FF00BCFF00D8FF00F6FF
00FFEB00FFCD00FFB100FF9800FF8400FF7400FF6900FF6500FF6600FF6E00FF7C00FF8F
00FFA700FFC400FFE500F7FF00D2FF00ADFF0087FF0063FF0041FF0022FF0007FF0E00FF
1F00FF2B00FF3100FF3000FF2A00FF1D00FF0B00FF000CFF0029FF004AFF006FFF0097FF
00C2FF00EEFF00FFE400FFB700FF8B00FF6100FF3900FF150AFF0026FF003EFF004FFF00
5BFF0061FF0061FF005BFF004FFF003CFF0025FF0008FF0000FF1A00FF4000FF6A00FF98
00FFC900FFFB00D0FF009CFF0068FF0035FF0003FF2C00FF
09FF0000FF2500FF5700FF8A00FFBE00FFF200D9FF00A6FF0075FF0047FF001CFF0A00FF
2D00FF4B00FF6400FF7800FF8500FF8C00FF8E00FF8900FF7E00FF6E00FF5700FF3C00FF
1D00FF0006FF002DFF0057FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0304FF0005FF0001FF0000FF0900FF1900FF2F00FF4900FF67
00FF8800FFAC00FFD100FFF700E3FF00BFFF009EFF0081FF0067FF0053FF0044FF003BFF
0038FF003CFF0045FF0054FF0068FF0080FF009BFF00B9FF00D7FF00F5FF00FFED00FFD4
00FFBE00FFAD00FFA200FF9D00FF9E00FFA500FFB200FFC400FFD800FFEF00F9FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F3FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EFFF00F3FF00F4FF00EDFF00E4FF00DDFF00DCFF00E2FF00EEFF
00FDFF00FFF200FFE300FFD900FFD300FFD400FFDC00FFE900FFFB00EFFF00D8FF00C1FF
00ABFF0099FF008BFF0083FF0081FF0085FF008FFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7300FF6300FF5900FF5400FF5600FF5E00FF6C00FF7F
00FF9700FFB400FFD500FFF800E2FF00BDFF0097FF0073FF0051FF0032FF0017FF0001FF
0F00FF1B00FF2100FF2000FF1A00FF0D00FF0004FF001CFF0039FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2900FF051BFF0037FF004EFF005FFF00
6BFF0071FF0071FF006BFF005FFF004DFF0035FF0018FF0000FF0900FF3000FF5A00FF88
00FFB800FFEB00E0FF00ACFF0078FF0045FF0013FF1C00FF
18FF0000FF1600FF4700FF7A00FFAE00FFE300E9FF00B6FF0085FF0057FF002CFF0004FF
1E00FF3C00FF5500FF6800FF7500FF7D00FF7E00FF7900FF6E00FF5E00FF4800FF2D00FF
0D00FF0016FF003DFF0066FF0092FF00BFFF00ECFF00FFE700FFBC00FF9300FF6D00FF4B
00FF2D00FF1500FF010CFF0013FF0015FF0010FF0006FF0000FF0A00FF1F00FF3900FF57
00FF7900FF9D00FFC200FFE700F2FF00CFFF00AEFF0090FF0077FF0063FF0054FF004BFF
0048FF004BFF0055FF0064FF0077FF0090FF00ABFF00C8FF00E7FF00FFFA00FFDE00FFC4
00FFAE00FF9E00FF9200FF8D00FF8F00FF9600FFA200FFB400FFC900FFE000FFF700F3FF
00E0FF00D2FF00C9FF00C7FF00CBFF00D5FF00E3FF00F3FF00FFFD00FFF000FFE900FFE8
00FFEE00FFF800FFFF00FEFF00FFFC00FFFB00FDFF00F3FF00ECFF00ECFF00F1FF00FDFF
00FFF300FFE200FFD400FFC900FFC400FFC500FFCC00FFD900FFEB00FEFF00E7FF00D0FF
00BBFF00A9FF009BFF0093FF0090FF0094FF009EFF00AEFF00C3FF00DCFF00F8FF00FFE9
00FFCB00FFAD00FF9100FF7900FF6400FF5400FF4900FF4500FF4600FF4E00FF5C00FF6F
00FF8800FFA400FFC500FFE800F2FF00CCFF00A7FF0083FF0061FF0042FF0027FF0011FF
0000FF0B00FF1100FF1100FF0A00FF0001FF0014FF002BFF0048FF006AFF008FFF00B7FF
00E2FF00FFF100FFC400FF9700FF6B00FF4100FF1A0AFF002AFF0046FF005DFF006FFF00
7BFF0081FF0081FF007BFF006EFF005CFF0044FF0027FF0005FF0000FF2000FF4B00FF78
00FFA900FFDB00F0FF00BCFF0088FF0054FF0023FF0C00FF
25FF0000FF0900FF3B00FF6E00FFA200FFD600F5FF00C2FF0092FF0063FF0038FF0011FF
1100FF2F00FF4800FF5B00FF6900FF7000FF7100FF6D00FF6200FF5100FF3B00FF2000FF
0000FF0022FF0049FF0073FF009FFF00CBFF00F8FF00FFDA00FFAF00FF8600FF6100FF3F
00FF2100FF080BFF0018FF0020FF0021FF001DFF0012FF0002FF0000FF1200FF2D00FF4B
00FF6C00FF9000FFB500FFDB00FFFF00DBFF00BAFF009DFF0083FF006FFF0060FF0057FF
0055FF0058FF0061FF0070FF0084FF009CFF00B7FF00D5FF00F3FF00FFEE00FFD100FFB8
00FFA200FF9100FF8600FF8100FF8200FF8900FF9600FFA700FFBC00FFD300FFEA00FFFF
00ECFF00DEFF00D6FF00D3FF00D8FF00E1FF00EFFF00FFFF00FFF000FFE300FFDC00FFDC
00FFE200FFEB00FFF300FFF400FFEF00FFEE00FFF500FFFF00F9FF00F8FF00FEFF00FFF5
00FFE600FFD600FFC700FFBC00FFB700FFB800FFC000FFCD00FFDF00FFF400F4FF00DDFF
00C8FF00B5FF00A8FF009FFF009DFF00A1FF00ABFF00BBFF00D0FF00E8FF00FFFB00FFDD
00FFBE00FFA100FF8500FF6C00FF5700FF4700FF3D00FF3800FF3A00FF4200FF4F00FF63
00FF7B00FF9800FFB800FFDB00FFFF00D9FF00B4FF008FFF006EFF004FFF0034FF001DFF
000CFF0000FF0400FF0400FF0001FF000EFF0020FF0038FF0055FF0076FF009BFF00C4FF
00EEFF00FFE400FFB800FF8B00FF5F00FF3500FF0D16FF0037FF0053FF006AFF007CFF00
88FF008EFF008DFF0087FF007BFF0069FF0051FF0034FF0012FF0000FF1400FF3E00FF6C
00FF9C00FFCF00FDFF00C8FF0094FF0061FF002FFF0000FF
2CFF0000FF0200FF3300FF6600FF9B00FFCF00FCFF00CAFF0099FF006AFF003FFF0018FF
0A00FF2800FF4100FF5400FF6200FF6900FF6A00FF6500FF5B00FF4A00FF3400FF1900FF
0006FF0029FF0050FF007AFF00A6FF00D2FF00FFFF00FFD300FFA800FF7F00FF5900FF37
00FF1A00FF0112FF001FFF0027FF0029FF0024FF0019FF0009FF0000FF0B00FF2500FF44
00FF6500FF8900FFAE00FFD400FFF900E3FF00C2FF00A4FF008BFF0076FF0067FF005FFF
005CFF005FFF0068FF0077FF008BFF00A3FF00BFFF00DCFF00FAFF00FFE600FFCA00FFB0
00FF9B00FF8A00FF7F00FF7A00FF7B00FF8200FF8F00FFA000FFB500FFCC00FFE300FFF9
00F4FF00E5FF00DDFF00DBFF00DFFF00E8FF00F6FF00FFF900FFE900FFDC00FFD500FFD5
00FFDA00FFE400FFEC00FFED00FFE800FFE700FFEE00FFF800FFFF00FFFF00FFFA00FFEE
00FFDF00FFCF00FFC000FFB500FFB000FFB100FFB800FFC600FFD700FFED00FBFF00E4FF
00CFFF00BDFF00AFFF00A7FF00A4FF00A8FF00B2FF00C2FF00D7FF00F0FF00FFF300FFD5
00FFB700FF9900FF7E00FF6500FF5000FF4000FF3600FF3100FF3300FF3A00FF4800FF5B
00FF7400FF9100FFB100FFD400FFF900E0FF00BBFF0097FF0075FF0056FF003BFF0024FF
0013FF0008FF0002FF0002FF0009FF0015FF0027FF003FFF005CFF007DFF00A3FF00CBFF
00F6FF00FFDD00FFB000FF8400FF5800FF2E00FF061EFF003EFF005AFF0071FF0083FF00
8FFF0095FF0095FF008EFF0082FF0070FF0058FF003BFF0019FF0000FF0D00FF3700FF65
00FF9500FFC700FFFB00D0FF009BFF0068FF0036FF0007FF
2DFF0000FF0200FF3300FF6600FF9A00FFCE00FDFF00CAFF0099FF006BFF0040FF0019FF
0900FF2800FF4000FF5400FF6100FF6900FF6A00FF6500FF5A00FF4A00FF3400FF1800FF
0006FF002AFF0051FF007BFF00A6FF00D3FF00FFFF00FFD300FFA800FF7F00FF5900FF37
00FF1900FF0012FF0020FF0027FF0029FF0024FF001AFF000AFF0000FF0B00FF2500FF43
00FF6500FF8800FFAE00FFD300FFF800E3FF00C2FF00A4FF008BFF0077FF0068FF005FFF
005CFF0060FF0069FF0078FF008CFF00A4FF00BFFF00DDFF00FBFF00FFE600FFCA00FFB0
00FF9A00FF8900FF7E00FF7900FF7A00FF8100FF8E00FFA000FFB400FFCB00FFE200FFF8
00F4FF00E6FF00DDFF00DBFF00DFFF00E9FF00F7FF00FFF800FFE800FFDC00FFD500FFD4
00FFDA00FFE400FFEC00FFEC00FFE800FFE700FFEE00FFF700FFFE00FFFF00FFF900FFEE
00FFDE00FFCE00FFC000FFB500FFB000FFB100FFB800FFC500FFD700FFEC00FCFF00E5FF
00CFFF00BDFF00AFFF00A7FF00A5FF00A9FF00B3FF00C2FF00D7FF00F0FF00FFF300FFD5
00FFB700FF9900FF7D00FF6400FF5000FF4000FF3500FF3100FF3200FF3A00FF4800FF5B
00FF7300FF9000FFB100FFD400FFF900E1FF00BBFF0097FF0075FF0056FF003BFF0025FF
0014FF0008FF0002FF0003FF0009FF0016FF0028FF0040FF005DFF007EFF00A3FF00CBFF
00F6FF00FFDD00FFB000FF8300FF5700FF2D00FF051EFF003EFF005AFF0072FF0083FF00
8FFF0095FF0095FF008FFF0083FF0070FF0059FF003CFF0019FF0000FF0C00FF3600FF64
00FF9500FFC700FFFB00D0FF009CFF0069FF0037FF0007FF
27FF0000FF0700FF3900FF6C00FFA000FFD400F7FF00C4FF0093FF0065FF003AFF0013FF
0F00FF2D00FF4600FF5A00FF6700FF6E00FF7000FF6B00FF6000FF5000FF3900FF1E00FF
0000FF0024FF004BFF0075FF00A0FF00CDFF00FAFF00FFD900FFAE00FF8500FF5F00FF3D
00FF1F00FF060CFF001AFF0022FF0023FF001FFF0014FF0004FF0000FF1100FF2B00FF49
00FF6A00FF8E00FFB300FFD900FFFE00DDFF00BCFF009FFF0085FF0071FF0062FF0059FF
0056FF005AFF0063FF0072FF0086FF009EFF00B9FF00D7FF00F5FF00FFEC00FFCF00FFB6
00FFA000FF8F00FF8400FF7F00FF8000FF8700FF9400FFA600FFBA00FFD100FFE800FFFE
00EEFF00E0FF00D7FF00D5FF00D9FF00E3FF00F1FF00FFFE00FFEE00FFE200FFDA00FFDA
00FFE000FFE900FFF200FFF200FFEE00FFED00FFF400FFFD00FBFF00FAFF00FFFF00FFF3
00FFE400FFD400FFC500FFBB00FFB500FFB600FFBE00FFCB00FFDD00FFF200F6FF00DFFF
00C9FF00B7FF00A9FF00A1FF009FFF00A3FF00ADFF00BCFF00D1FF00EAFF00FFF900FFDB
00FFBD00FF9F00FF8300FF6A00FF5500FF4500FF3B00FF3600FF3800FF4000FF4D00FF61
00FF7900FF9600FFB700FFDA00FFFF00DBFF00B5FF0091FF006FFF0050FF0035FF001FFF
000EFF0002FF0300FF0200FF0003FF0010FF0022FF003AFF0057FF0078FF009DFF00C5FF
00F0FF00FFE300FFB600FF8900FF5D00FF3300FF0B18FF0039FF0055FF006CFF007DFF00
89FF008FFF008FFF0089FF007DFF006BFF0053FF0036FF0014FF0000FF1200FF3C00FF6A
00FF9A00FFCD00FEFF00CAFF0096FF0063FF0031FF0001FF
1DFF0000FF1100FF4200FF7500FFAA00FFDE00EDFF00BBFF008AFF005BFF0030FF0009FF
1900FF3700FF5000FF6300FF7100FF7800FF7900FF7400FF6A00FF5900FF4300FF2800FF
0800FF001AFF0042FF006BFF0097FF00C4FF00F0FF00FFE200FFB700FF8E00FF6800FF46
00FF2900FF1003FF0010FF0018FF001AFF0015FF000AFF0000FF0500FF1A00FF3400FF53
00FF7400FF9800FFBD00FFE300F7FF00D4FF00B3FF0095FF007CFF0067FF0058FF0050FF
004DFF0050FF0059FF0068FF007CFF0094FF00B0FF00CDFF00ECFF00FFF500FFD900FFBF
00FFAA00FF9900FF8E00FF8900FF8A00FF9100FF9E00FFAF00FFC400FFDB00FFF200F7FF
00E5FF00D6FF00CEFF00CCFF00D0FF00D9FF00E7FF00F7FF00FFF800FFEB00FFE400FFE4
00FFE900FFF300FFFB00FFFC00FFF700FFF600FFFD00F8FF00F1FF00F0FF00F6FF00FFFD
00FFEE00FFDE00FFCF00FFC400FFBF00FFC000FFC700FFD500FFE600FFFC00ECFF00D5FF
00C0FF00AEFF00A0FF0098FF0095FF0099FF00A3FF00B3FF00C8FF00E1FF00FDFF00FFE4
00FFC600FFA800FF8D00FF7400FF5F00FF4F00FF4500FF4000FF4200FF4900FF5700FF6A
00FF8300FFA000FFC000FFE300F7FF00D1FF00ACFF0088FF0066FF0047FF002CFF0015FF
0004FF0600FF0C00FF0C00FF0500FF0006FF0018FF0030FF004DFF006EFF0094FF00BCFF
00E7FF00FFEC00FFBF00FF9300FF6700FF3C00FF150FFF002FFF004BFF0062FF0074FF00
80FF0086FF0086FF007FFF0073FF0061FF0049FF002CFF000AFF0000FF1B00FF4600FF74
00FFA400FFD600F5FF00C1FF008CFF0059FF0027FF0700FF
15FF0000FF1900FF4A00FF7E00FFB200FFE600E5FF00B3FF0082FF0053FF0028FF0001FF
2100FF3F00FF5800FF6B00FF7900FF8000FF8100FF7C00FF7200FF6100FF4B00FF3000FF
1000FF0012FF0039FF0063FF008FFF00BBFF00E8FF00FFEA00FFBF00FF9600FF7100FF4E
00FF3100FF1800FF0408FF0010FF0012FF000DFF0002FF0000FF0D00FF2200FF3C00FF5B
00FF7C00FFA000FFC500FFEB00EFFF00CCFF00ABFF008DFF0074FF005FFF0050FF0047FF
0045FF0048FF0051FF0060FF0074FF008CFF00A8FF00C5FF00E3FF00FFFE00FFE100FFC7
00FFB200FFA100FF9600FF9100FF9200FF9900FFA600FFB700FFCC00FFE300FFFA00EFFF
00DDFF00CEFF00C6FF00C4FF00C8FF00D1FF00DFFF00EFFF00FFFF00FFF300FFEC00FFEC
00FFF200FFFB00FCFF00FBFF00FFFF00FFFE00FAFF00F0FF00E9FF00E8FF00EEFF00FAFF
00FFF600FFE600FFD700FFCC00FFC700FFC800FFCF00FFDD00FFEF00FBFF00E4FF00CDFF
00B8FF00A6FF0098FF0090FF008DFF0091FF009BFF00ABFF00C0FF00D9FF00F5FF00FFED
00FFCE00FFB000FF9500FF7C00FF6700FF5700FF4D00FF4800FF4A00FF5100FF5F00FF72
00FF8B00FFA800FFC800FFEB00EFFF00C9FF00A4FF0080FF005EFF003FFF0024FF000DFF
0300FF0F00FF1400FF1400FF0D00FF0100FF0010FF0028FF0045FF0066FF008CFF00B4FF
00DEFF00FFF400FFC700FF9B00FF6F00FF4500FF1D06FF0027FF0043FF005AFF006CFF00
78FF007EFF007EFF0077FF006BFF0059FF0041FF0024FF0002FF0000FF2400FF4E00FF7C
00FFAC00FFDE00EDFF00B9FF0084FF0051FF001FFF0F00FF
14FF0000FF1A00FF4B00FF7E00FFB200FFE700E5FF00B2FF0081FF0053FF0028FF0000FF
2200FF4000FF5900FF6C00FF7900FF8100FF8200FF7D00FF7200FF6200FF4C00FF3100FF
1100FF0012FF0039FF0062FF008EFF00BBFF00E8FF00FFEB00FFC000FF9700FF7100FF4F
00FF3100FF1800FF0508FF000FFF0011FF000CFF0002FF0000FF0E00FF2300FF3D00FF5B
00FF7D00FFA100FFC600FFEB00EEFF00CBFF00AAFF008CFF0073FF005FFF0050FF0047FF
0044FF0047FF0051FF0060FF0074FF008CFF00A7FF00C4FF00E3FF00FFFE00FFE200FFC8
00FFB200FFA200FF9600FF9100FF9300FF9A00FFA600FFB800FFCD00FFE300FFFB00EFFF
00DCFF00CEFF00C5FF00C3FF00C7FF00D1FF00DFFF00EFFF00FEFF00FFF400FFED00FFEC
00FFF200FFFC00FBFF00FAFF00FFFF00FFFF00F9FF00EFFF00E8FF00E8FF00EEFF00F9FF
00FFF700FFE600FFD800FFCD00FFC800FFC900FFD000FFDD00FFEF00FAFF00E3FF00CCFF
00B7FF00A5FF0097FF008FFF008CFF0090FF009AFF00AAFF00BFFF00D8FF00F4FF00FFED
00FFCF00FFB100FF9500FF7D00FF6800FF5800FF4D00FF4900FF4A00FF5200FF6000FF73
00FF8C00FFA800FFC900FFEC00EEFF00C8FF00A3FF007FFF005DFF003EFF0023FF000DFF
0400FF0F00FF1500FF1500FF0E00FF0200FF0010FF0027FF0044FF0066FF008BFF00B3FF
00DEFF00FFF500FFC800FF9B00FF6F00FF4500FF1E06FF0026FF0042FF0059FF006BFF00
77FF007DFF007DFF0077FF006AFF0058FF0040FF0023FF0001FF0000FF2400FF4F00FF7C
00FFAD00FFDF00ECFF00B8FF0084FF0050FF001FFF1000FF
19FF0000FF1500FF4700FF7A00FFAE00FFE200E9FF00B6FF0086FF0057FF002CFF0005FF
1D00FF3B00FF5400FF6700FF7500FF7C00FF7D00FF7900FF6E00FF5D00FF4700FF2C00FF
0C00FF0016FF003DFF0067FF0093FF00BFFF00ECFF00FFE600FFBB00FF9200FF6D00FF4A
00FF2D00FF1400FF000CFF0014FF0015FF0011FF0006FF0000FF0900FF1E00FF3900FF57
00FF7800FF9C00FFC100FFE700F3FF00D0FF00AFFF0091FF0078FF0063FF0054FF004BFF
0049FF004CFF0055FF0064FF0078FF0090FF00ACFF00C9FF00E7FF00FFFA00FFDD00FFC3
00FFAE00FF9D00FF9200FF8D00FF8E00FF9500FFA200FFB300FFC800FFDF00FFF600F3FF
00E0FF00D2FF00CAFF00C8FF00CCFF00D5FF00E3FF00F3FF00FFFC00FFEF00FFE800FFE8
00FFEE00FFF700FFFF00FFFF00FFFB00FFFA00FEFF00F4FF00EDFF00ECFF00F2FF00FEFF
00FFF200FFE200FFD300FFC800FFC300FFC400FFCB00FFD900FFEB00FFFF00E8FF00D1FF
00BCFF00AAFF009CFF0093FF0091FF0095FF009FFF00AFFF00C4FF00DDFF00F9FF00FFE9
00FFCA00FFAC00FF9100FF7800FF6300FF5300FF4900FF4400FF4600FF4D00FF5B00FF6F
00FF8700FFA400FFC400FFE700F3FF00CDFF00A8FF0084FF0062FF0043FF0028FF0011FF
0000FF0B00FF1000FF1000FF0A00FF0002FF0014FF002CFF0049FF006AFF008FFF00B8FF
00E2FF00FFF000FFC300FF9700FF6B00FF4100FF190AFF002BFF0047FF005EFF0070FF00
7CFF0082FF0082FF007BFF006FFF005DFF0045FF0028FF0006FF0000FF2000FF4A00FF78
00FFA800FFDB00F1FF00BDFF0088FF0055FF0023FF0B00FF
1AFF0000FF1400FF4500FF7900FFAD00FFE100EAFF00B8FF0087FF0058FF002DFF0006FF
1C00FF3A00FF5300FF6600FF7400FF7B00FF7C00FF7800FF6D00FF5C00FF4600FF2B00FF
0B00FF0017FF003EFF0068FF0094FF00C0FF00EDFF00FFE500FFBA00FF9100FF6C00FF49
00FF2C00FF1300FF000DFF0015FF0016FF0012FF0007FF0000FF0800FF1D00FF3700FF56
00FF7700FF9B00FFC000FFE600F4FF00D1FF00B0FF0092FF0079FF0064FF0055FF004CFF
004AFF004DFF0056FF0065FF0079FF0091FF00ADFF00CAFF00E8FF00FFF900FFDC00FFC2
00FFAD00FF9C00FF9100FF8C00FF8D00FF9400FFA100FFB200FFC700FFDE00FFF500F4FF
00E2FF00D3FF00CBFF00C9FF00CDFF00D6FF00E4FF00F4FF00FFFB00FFEE00FFE700FFE7
00FFED00FFF600FFFE00FFFF00FFFA00FFF900FFFF00F5FF00EEFF00EDFF00F3FF00FFFF
00FFF100FFE100FFD200FFC700FFC200FFC300FFCA00FFD800FFEA00FFFF00E9FF00D2FF
00BDFF00ABFF009DFF0095FF0092FF0096FF00A0FF00B0FF00C5FF00DEFF00FAFF00FFE8
00FFC900FFAB00FF9000FF7700FF6200FF5200FF4800FF4300FF4500FF4C00FF5A00FF6D
00FF8600FFA300FFC300FFE600F4FF00CEFF00A9FF0085FF0063FF0044FF0029FF0012FF
0001FF0A00FF0F00FF0F00FF0900FF0003FF0015FF002DFF004AFF006BFF0091FF00B9FF
00E3FF00FFEF00FFC200FF9600FF6A00FF4000FF180BFF002CFF0048FF005FFF0071FF00
7DFF0083FF0083FF007CFF0070FF005EFF0046FF0029FF0007FF0000FF1F00FF4900FF77
00FFA700FFD900F2FF00BEFF0089FF0056FF0024FF0A00FF
13FF0000FF1B00FF4D00FF8000FFB400FFE800E3FF00B0FF0080FF0051FF0026FF0000FF
2300FF4100FF5A00FF6D00FF7B00FF8200FF8300FF7F00FF7400FF6300FF4D00FF3200FF
1200FF0010FF0037FF0061FF008DFF00B9FF00E6FF00FFEC00FFC100FF9800FF7300FF50
00FF3300FF1A00FF0606FF000EFF000FFF000BFF0000FF0000FF0F00FF2400FF3F00FF5D
00FF7E00FFA200FFC700FFED00EDFF00CAFF00A9FF008BFF0072FF005DFF004EFF0045FF
0043FF0046FF004FFF005EFF0072FF008AFF00A6FF00C3FF00E1FF00FFFF00FFE300FFCA
00FFB400FFA300FF9800FF9300FF9400FF9B00FFA800FFB900FFCE00FFE500FFFC00EDFF
00DAFF00CCFF00C4FF00C2FF00C6FF00CFFF00DDFF00EDFF00FDFF00FFF500FFEE00FFEE
00FFF400FFFD00FAFF00F9FF00FEFF00FFFF00F8FF00EEFF00E7FF00E6FF00ECFF00F8FF
00FFF800FFE800FFD900FFCE00FFC900FFCA00FFD100FFDF00FFF100F9FF00E2FF00CBFF
00B6FF00A4FF0096FF008DFF008BFF008FFF0099FF00A9FF00BEFF00D7FF00F3FF00FFEF
00FFD000FFB200FF9700FF7E00FF6900FF5900FF4F00FF4A00FF4C00FF5300FF6100FF75
00FF8D00FFAA00FFCA00FFED00EDFF00C7FF00A2FF007EFF005CFF003DFF0022FF000BFF
0500FF1100FF1600FF1600FF1000FF0300FF000EFF0026FF0043FF0064FF0089FF00B2FF
00DCFF00FFF600FFC900FF9D00FF7100FF4700FF1F04FF0025FF0041FF0058FF006AFF00
76FF007CFF007CFF0075FF0069FF0057FF003FFF0022FF0000FF0000FF2600FF5000FF7E
00FFAE00FFE100EBFF00B6FF0082FF004FFF001DFF1100FF
09FF0000FF2500FF5600FF8900FFBD00FFF200D9FF00A7FF0076FF0048FF001DFF0A00FF
2D00FF4B00FF6400FF7700FF8400FF8C00FF8D00FF8800FF7D00FF6D00FF5700FF3C00FF
1C00FF0007FF002EFF0057FF0083FF00B0FF00DDFF00FFF600FFCB00FFA200FF7C00FF5A
00FF3C00FF2400FF1000FF0204FF0006FF0001FF0000FF0800FF1900FF2E00FF4800FF66
00FF8800FFAC00FFD100FFF600E3FF00C0FF009FFF0081FF0068FF0053FF0045FF003CFF
0039FF003CFF0046FF0055FF0068FF0081FF009CFF00B9FF00D8FF00F6FF00FFED00FFD3
00FFBE00FFAD00FFA200FF9C00FF9E00FFA500FFB200FFC300FFD800FFEF00F9FF00E3FF
00D1FF00C3FF00BAFF00B8FF00BCFF00C6FF00D4FF00E4FF00F3FF00FFFF00FFF800FFF7
00FFFD00F8FF00F0FF00EFFF00F4FF00F5FF00EEFF00E4FF00DDFF00DCFF00E2FF00EEFF
00FDFF00FFF100FFE300FFD800FFD300FFD400FFDB00FFE800FFFA00EFFF00D8FF00C1FF
00ACFF009AFF008CFF0084FF0081FF0085FF008FFF009FFF00B4FF00CDFF00E9FF00FFF8
00FFDA00FFBC00FFA000FF8800FF7300FF6300FF5800FF5400FF5500FF5D00FF6B00FF7E
00FF9700FFB400FFD400FFF700E3FF00BDFF0098FF0074FF0052FF0033FF0018FF0002FF
0F00FF1A00FF2000FF2000FF1900FF0D00FF0005FF001CFF0039FF005BFF0080FF00A8FF
00D3FF00FFFF00FFD300FFA600FF7A00FF5000FF2900FF041BFF0037FF004EFF0060FF00
6CFF0072FF0072FF006CFF005FFF004DFF0035FF0018FF0000FF0900FF2F00FF5A00FF87
00FFB800FFEA00E1FF00ADFF0079FF0045FF0013FF1B00FF
02FF0000FF2C00FF5D00FF9000FFC400FFF900D3FF00A0FF006FFF0041FF0016FF1100FF
3400FF5200FF6B00FF7E00FF8B00FF9300FF9400FF8F00FF8400FF7400FF5E00FF4300FF
2300FF0000FF0027FF0050FF007CFF00A9FF00D6FF00FFFD00FFD200FFA900FF8300FF61
00FF4300FF2A00FF1700FF0900FF0200FF0000FF0500FF0F00FF2000FF3500FF4F00FF6D
00FF8F00FFB200FFD800FFFD00DCFF00B9FF0098FF007AFF0061FF004DFF003EFF0035FF
0032FF0035FF003FFF004EFF0062FF007AFF0095FF00B2FF00D1FF00EFFF00FFF400FFDA
00FFC400FFB400FFA800FFA300FFA400FFAC00FFB800FFCA00FFDF00FFF500F2FF00DDFF
00CAFF00BCFF00B3FF00B1FF00B5FF00BFFF00CDFF00DDFF00ECFF00F9FF00FFFF00FFFE
00FBFF00F1FF00E9FF00E8FF00EDFF00EEFF00E7FF00DDFF00D6FF00D6FF00DCFF00E7FF
00F7FF00FFF800FFEA00FFDF00FFDA00FFDB00FFE200FFEF00FEFF00E8FF00D1FF00BAFF
00A5FF0093FF0085FF007DFF007AFF007EFF0088FF0098FF00ADFF00C6FF00E2FF00FFFF
00FFE100FFC300FFA700FF8E00FF7A00FF6A00FF5F00FF5B00FF5C00FF6400FF7200FF85
00FF9E00FFBA00FFDB00FFFE00DCFF00B6FF0091FF006DFF004BFF002CFF0011FF0400FF
1600FF2100FF2700FF2700FF2000FF1400FF0100FF0016FF0032FF0054FF0079FF00A1FF
00CCFF00F8FF00FFDA00FFAD00FF8100FF5700FF3000FF0B14FF0030FF0047FF0059FF00
65FF006BFF006BFF0065FF0058FF0046FF002EFF0011FF0000FF1000FF3600FF6100FF8E
00FFBF00FFF100DAFF00A6FF0072FF003EFF000DFF2200FF
02FF0000FF2D00FF5E00FF9100FFC500FFF900D2FF009FFF006EFF0040FF0015FF1200FF
3500FF5300FF6C00FF7F00FF8C00FF9400FF9500FF9000FF8500FF7500FF5F00FF4400FF
2400FF0000FF0026FF0050FF007BFF00A8FF00D5FF00FFFE00FFD300FFAA00FF8400FF62
00FF4400FF2B00FF1800FF0A00FF0300FF0100FF0600FF1000FF2000FF3600FF5000FF6E
00FF9000FFB300FFD900FFFE00DCFF00B8FF0097FF0079FF0060FF004CFF003DFF0034FF
0031FF0034FF003EFF004DFF0061FF0079FF0094FF00B1FF00D0FF00EEFF00FFF500FFDB
00FFC500FFB400FFA900FFA400FFA500FFAD00FFB900FFCB00FFE000FFF600F2FF00DCFF
00C9FF00BBFF00B2FF00B0FF00B4FF00BEFF00CCFF00DCFF00ECFF00F8FF00FFFF00FFFF
00FAFF00F0FF00E8FF00E8FF00ECFF00EDFF00E6FF00DCFF00D6FF00D5FF00DBFF00E6FF
00F6FF00FFF900FFEB00FFE000FFDB00FFDC00FFE300FFF000FDFF00E8FF00D1FF00BAFF
00A4FF0092FF0084FF007CFF007AFF007EFF0088FF0097FF00ACFF00C5FF00E1FF00FFFF
00FFE200FFC400FFA800FF8F00FF7B00FF6B00FF6000FF5C00FF5D00FF6500FF7300FF86
00FF9E00FFBB00FFDC00FFFF00DBFF00B6FF0090FF006CFF004AFF002BFF0010FF0500FF
1600FF2200FF2800FF2800FF2100FF1500FF0200FF0015FF0031FF0053FF0078FF00A0FF
00CBFF00F7FF00FFDB00FFAE00FF8200FF5800FF3100FF0C13FF002FFF0046FF0058FF00
64FF006AFF006AFF0064FF0058FF0045FF002EFF0010FF0000FF1100FF3700FF6200FF8F
00FFC000FFF200D9FF00A5FF0071FF003EFF000CFF2300FF
07FF0000FF2700FF5800FF8B00FFBF00FFF400D8FF00A5FF0074FF0046FF001BFF0C00FF
2F00FF4D00FF6600FF7900FF8600FF8E00FF8F00FF8A00FF7F00FF6F00FF5900FF3E00FF
1E00FF0005FF002CFF0056FF0081FF00AEFF00DBFF00FFF800FFCD00FFA400FF7E00FF5C
00FF3E00FF2500FF1200FF0402FF0004FF0000FF0000FF0A00FF1A00FF3000FF4A00FF68
00FF8A00FFAD00FFD300FFF800E2FF00BEFF009DFF007FFF0066FF0052FF0043FF003AFF
0037FF003AFF0044FF0053FF0067FF007FFF009AFF00B7FF00D6FF00F4FF00FFEF00FFD5
00FFBF00FFAF00FFA300FF9E00FF9F00FFA700FFB300FFC500FFDA00FFF000F7FF00E2FF
00CFFF00C1FF00B8FF00B6FF00BAFF00C4FF00D2FF00E2FF00F1FF00FEFF00FFFA00FFF9
00FFFF00F6FF00EEFF00EEFF00F2FF00F3FF00ECFF00E2FF00DCFF00DBFF00E1FF00ECFF
00FCFF00FFF300FFE500FFDA00FFD500FFD600FFDD00FFEA00FFFC00EEFF00D6FF00BFFF
00AAFF0098FF008AFF0082FF0080FF0083FF008DFF009DFF00B2FF00CBFF00E7FF00FFFA
00FFDC00FFBE00FFA200FF8900FF7500FF6500FF5A00FF5600FF5700FF5F00FF6D00FF80
00FF9900FFB500FFD600FFF900E1FF00BCFF0096FF0072FF0050FF0031FF0016FF0000FF
1000FF1C00FF2200FF2200FF1B00FF0F00FF0003FF001BFF0037FF0059FF007EFF00A6FF
00D1FF00FDFF00FFD500FFA800FF7C00FF5200FF2B00FF0619FF0035FF004CFF005EFF00
6AFF0070FF0070FF006AFF005EFF004BFF0034FF0016FF0000FF0B00FF3100FF5C00FF89
00FFBA00FFEC00DFFF00ABFF0077FF0043FF0012FF1D00FF
13FF0000FF1B00FF4C00FF7F00FFB400FFE800E3FF00B1FF0080FF0052FF0026FF0000FF
2300FF4100FF5A00FF6D00FF7B00FF8200FF8300FF7E00FF7400FF6300FF4D00FF3200FF
1200FF0010FF0038FF0061FF008DFF00BAFF00E6FF00FFEC00FFC100FF9800FF7200FF50
00FF3300FF1A00FF0606FF000EFF0010FF000BFF0000FF0000FF0F00FF2400FF3E00FF5D
00FF7E00FFA200FFC700FFED00EDFF00CAFF00A9FF008BFF0072FF005DFF004EFF0046FF
0043FF0046FF004FFF005EFF0072FF008AFF00A6FF00C3FF00E2FF00FFFF00FFE300FFC9
00FFB400FFA300FF9800FF9300FF9400FF9B00FFA800FFB900FFCE00FFE500FFFC00EDFF
00DBFF00CCFF00C4FF00C2FF00C6FF00CFFF00DDFF00EEFF00FDFF00FFF500FFEE00FFEE
00FFF300FFFD00FAFF00F9FF00FEFF00FFFF00F8FF00EEFF00E7FF00E6FF00ECFF00F8FF
00FFF800FFE700FFD900FFCE00FFC900FFCA00FFD100FFDF00FFF000F9FF00E2FF00CBFF
00B6FF00A4FF0096FF008EFF008BFF008FFF0099FF00A9FF00BEFF00D7FF00F3FF00FFEE
00FFD000FFB200FF9700FF7E00FF6900FF5900FF4F00FF4A00FF4C00FF5300FF6100FF74
00FF8D00FFAA00FFCA00FFED00EDFF00C7FF00A2FF007EFF005CFF003DFF0022FF000CFF
0500FF1000FF1600FF1600FF0F00FF0300FF000EFF0026FF0043FF0064FF008AFF00B2FF
00DDFF00FFF600FFC900FF9C00FF7100FF4600FF1F05FF0025FF0041FF0058FF006AFF00
76FF007CFF007CFF0075FF0069FF0057FF003FFF0022FF0000FF0000FF2500FF5000FF7E
00FFAE00FFE000EBFF00B7FF0082FF004FFF001DFF1100FF
22FF0000FF0C00FF3D00FF7000FFA400FFD900F3FF00C0FF008FFF0061FF0036FF000EFF
1400FF3200FF4B00FF5E00FF6B00FF7300FF7400FF6F00FF6400FF5400FF3E00FF2300FF
0300FF0020FF0047FF0071FF009CFF00C9FF00F6FF00FFDD00FFB200FF8900FF6300FF41
00FF2300FF0A08FF0016FF001DFF001FFF001AFF0010FF0000FF0000FF1500FF2F00FF4D
00FF6F00FF9200FFB800FFDD00FDFF00D9FF00B8FF009AFF0081FF006DFF005EFF0055FF
0052FF0055FF005FFF006EFF0082FF009AFF00B5FF00D2FF00F1FF00FFF000FFD400FFBA
00FFA400FF9400FF8800FF8300FF8400FF8C00FF9800FFAA00FFBF00FFD500FFED00FDFF
00EAFF00DCFF00D3FF00D1FF00D5FF00DFFF00EDFF00FDFF00FFF300FFE600FFDF00FFDE
00FFE400FFEE00FFF600FFF700FFF200FFF100FFF800FDFF00F7FF00F6FF00FCFF00FFF8
00FFE800FFD800FFCA00FFBF00FFBA00FFBB00FFC200FFCF00FFE100FFF600F1FF00DAFF
00C5FF00B3FF00A5FF009DFF009BFF009EFF00A8FF00B8FF00CDFF00E6FF00FFFD00FFDF
00FFC100FFA300FF8700FF6E00FF5A00FF4A00FF3F00FF3B00FF3C00FF4400FF5200FF65
00FF7E00FF9A00FFBB00FFDE00FCFF00D7FF00B1FF008DFF006BFF004CFF0031FF001BFF
000AFF0100FF0700FF0700FF0000FF000BFF001EFF0036FF0052FF0074FF0099FF00C1FF
00ECFF00FFE700FFBA00FF8D00FF6100FF3700FF1014FF0034FF0050FF0067FF0079FF00
85FF008BFF008BFF0085FF0078FF0066FF004FFF0031FF000FFF0000FF1600FF4100FF6E
00FF9F00FFD100FAFF00C6FF0092FF005EFF002DFF0200FF
33FF0004FF0000FF2D00FF6000FF9400FFC800FFFC00D0FF009FFF0071FF0046FF001FFF
0300FF2200FF3A00FF4E00FF5B00FF6200FF6400FF5F00FF5400FF4400FF2D00FF1200FF
000CFF0030FF0057FF0081FF00ACFF00D9FF00FFF900FFCD00FFA200FF7900FF5300FF31
00FF1305FF0018FF0026FF002EFF002FFF002BFF0020FF0010FF0000FF0500FF1F00FF3D
00FF5E00FF8200FFA700FFCD00FFF200E9FF00C8FF00ABFF0091FF007DFF006EFF0065FF
0062FF0066FF006FFF007EFF0092FF00AAFF00C5FF00E3FF00FFFE00FFE000FFC300FFAA
00FF9400FF8300FF7800FF7300FF7400FF7B00FF8800FF9A00FFAE00FFC500FFDC00FFF2
00FAFF00ECFF00E3FF00E1FF00E5FF00EFFF00FDFF00FFF200FFE200FFD600FFCF00FFCE
00FFD400FFDE00FFE600FFE600FFE200FFE100FFE800FFF100FFF800FFF900FFF300FFE7
00FFD800FFC800FFB900FFAF00FFAA00FFAA00FFB200FFBF00FFD100FFE600FFFD00EBFF
00D5FF00C3FF00B5FF00ADFF00ABFF00AFFF00B9FF00C8FF00DDFF00F6FF00FFED00FFCF
00FFB100FF9300FF7700FF5E00FF4900FF3900FF2F00FF2A00FF2C00FF3400FF4200FF55
00FF6D00FF8A00FFAB00FFCE00FFF300E7FF00C1FF009DFF007BFF005CFF0041FF002BFF
001AFF000EFF0008FF0009FF000FFF001CFF002EFF0046FF0063FF0084FF00A9FF00D1FF
00FCFF00FFD700FFAA00FF7D00FF5100FF2700FF0024FF0045FF0061FF0078FF0089FF00
95FF009BFF009BFF0095FF0089FF0077FF005FFF0042FF0020FF0000FF0600FF3000FF5E
00FF8E00FFC100FFF500D6FF00A2FF006FFF003DFF000DFF
41FF0012FF0000FF1E00FF5100FF8500FFBA00FFEE00DFFF00AEFF0080FF0054FF002DFF
000AFF1300FF2C00FF3F00FF4D00FF5400FF5500FF5000FF4600FF3500FF1F00FF0400FF
001BFF003FFF0066FF008FFF00BBFF00E8FF00FFEA00FFBE00FF9300FF6A00FF4400FF22
00FF0513FF0027FF0034FF003CFF003EFF0039FF002FFF001EFF0009FF0000FF1000FF2E
00FF5000FF7400FF9900FFBF00FFE400F8FF00D7FF00B9FF00A0FF008BFF007DFF0074FF
0071FF0074FF007EFF008CFF00A0FF00B8FF00D4FF00F1FF00FFEF00FFD100FFB500FF9B
00FF8600FF7500FF6A00FF6500FF6600FF6D00FF7A00FF8B00FFA000FFB700FFCE00FFE4
00FFF600FAFF00F2FF00F0FF00F4FF00FEFF00FFF400FFE300FFD400FFC700FFC000FFC0
00FFC500FFCF00FFD700FFD800FFD300FFD200FFD900FFE300FFEA00FFEB00FFE500FFD9
00FFCA00FFB900FFAB00FFA000FF9B00FF9C00FFA300FFB000FFC200FFD800FFEF00F9FF
00E4FF00D2FF00C4FF00BCFF00B9FF00BDFF00C7FF00D7FF00ECFF00FFFA00FFDE00FFC0
00FFA200FF8400FF6800FF5000FF3B00FF2B00FF2000FF1C00FF1E00FF2500FF3300FF46
00FF5F00FF7C00FF9C00FFBF00FFE400F5FF00D0FF00ACFF008AFF006BFF0050FF003AFF
0028FF001DFF0017FF0017FF001EFF002AFF003CFF0054FF0071FF0093FF00B8FF00E0FF
00FFF400FFC800FF9B00FF6E00FF4300FF180EFF0033FF0053FF006FFF0086FF0098FF00
A4FF00AAFF00AAFF00A4FF0097FF0085FF006DFF0050FF002EFF0008FF0000FF2200FF50
00FF8000FFB200FFE600E5FF00B1FF007DFF004BFF001CFF
4CFF001DFF0000FF1400FF4700FF7B00FFAF00FFE300E9FF00B9FF008AFF005FFF0038FF
0015FF0800FF2100FF3400FF4200FF4900FF4B00FF4600FF3B00FF2A00FF1400FF0006FF
0026FF0049FF0070FF009AFF00C6FF00F2FF00FFE000FFB300FF8800FF6000FF3A00FF18
05FF001EFF0031FF003FFF0047FF0048FF0044FF0039FF0029FF0014FF0000FF0600FF24
00FF4500FF6900FF8E00FFB400FFD900FFFD00E1FF00C4FF00AAFF0096FF0087FF007EFF
007BFF007FFF0088FF0097FF00ABFF00C3FF00DEFF00FCFF00FFE500FFC700FFAA00FF91
00FF7B00FF6A00FF5F00FF5A00FF5B00FF6200FF6F00FF8000FF9500FFAC00FFC300FFD9
00FFEC00FFFA00FDFF00FAFF00FEFF00FFF700FFE900FFD900FFC900FFBC00FFB500FFB5
00FFBB00FFC400FFCC00FFCD00FFC800FFC700FFCE00FFD800FFDF00FFE000FFDA00FFCE
00FFBF00FFAF00FFA000FF9600FF9000FF9100FF9900FFA600FFB800FFCD00FFE400FFFB
00EFFF00DCFF00CFFF00C6FF00C4FF00C8FF00D2FF00E2FF00F6FF00FFF000FFD400FFB6
00FF9700FF7A00FF5E00FF4500FF3000FF2000FF1600FF1100FF1300FF1B00FF2800FF3C
00FF5400FF7100FF9100FFB500FFD900FFFF00DBFF00B6FF0094FF0076FF005BFF0044FF
0033FF0027FF0022FF0022FF0028FF0035FF0047FF005FFF007CFF009DFF00C2FF00EBFF
00FFEA00FFBE00FF9100FF6400FF3800FF0E19FF003DFF005EFF007AFF0091FF00A3FF00
AEFF00B4FF00B4FF00AEFF00A2FF0090FF0078FF005BFF0039FF0012FF0000FF1700FF45
00FF7500FFA800FFDB00EFFF00BBFF0088FF0056FF0026FF
51FF0022FF0000FF0E00FF4100FF7600FFAA00FFDE00EFFF00BEFF008FFF0064FF003DFF
001AFF0300FF1C00FF2F00FF3D00FF4400FF4500FF4000FF3600FF2500FF0F00FF000BFF
002BFF004EFF0076FF009FFF00CBFF00F8FF00FFDB00FFAE00FF8300FF5A00FF3400FF12
0AFF0023FF0037FF0044FF004CFF004EFF0049FF003EFF002EFF0019FF0000FF0000FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF700E7FF00C9FF00B0FF009BFF008CFF0084FF
0081FF0084FF008DFF009CFF00B0FF00C8FF00E4FF00FFFE00FFDF00FFC100FFA500FF8B
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE600FFF500FFFD00FFFF00FFFB00FFF200FFE400FFD300FFC400FFB700FFB000FFB0
00FFB500FFBF00FFC700FFC800FFC300FFC200FFC900FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9000FF8B00FF8C00FF9300FFA100FFB200FFC800FFDF00FFF6
00F4FF00E2FF00D4FF00CCFF00C9FF00CDFF00D7FF00E7FF00FCFF00FFEA00FFCE00FFB0
00FF9200FF7400FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1500FF2300FF36
00FF4F00FF6C00FF8C00FFAF00FFD400FFFA00E0FF00BCFF009AFF007BFF0060FF0049FF
0038FF002DFF0027FF0027FF002EFF003AFF004CFF0064FF0081FF00A2FF00C8FF00F0FF
00FFE400FFB800FF8B00FF5F00FF3300FF081EFF0043FF0063FF007FFF0096FF00A8FF00
B4FF00BAFF00BAFF00B3FF00A7FF0095FF007DFF0060FF003EFF0018FF0000FF1200FF40
00FF7000FFA200FFD600F5FF00C0FF008DFF005BFF002CFF
50FF0021FF0000FF0F00FF4200FF7600FFAB00FFDF00EEFF00BDFF008FFF0063FF003CFF
0019FF0400FF1D00FF3000FF3E00FF4500FF4600FF4100FF3700FF2600FF1000FF000AFF
002AFF004DFF0075FF009EFF00CAFF00F7FF00FFDB00FFAF00FF8400FF5B00FF3500FF13
09FF0022FF0036FF0043FF004BFF004DFF0048FF003DFF002DFF0018FF0000FF0100FF20
00FF4100FF6500FF8A00FFB000FFD500FFF800E6FF00C8FF00AFFF009AFF008BFF0083FF
0080FF0083FF008CFF009BFF00AFFF00C7FF00E3FF00FFFF00FFE000FFC200FFA600FF8C
00FF7700FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7C00FF9100FFA800FFBF00FFD5
00FFE700FFF600FFFE00FFFF00FFFC00FFF300FFE500FFD400FFC500FFB800FFB100FFB1
00FFB600FFC000FFC800FFC900FFC400FFC300FFCA00FFD400FFDB00FFDC00FFD600FFCA
00FFBB00FFAA00FF9C00FF9100FF8C00FF8D00FF9400FFA200FFB300FFC900FFE000FFF7
00F3FF00E1FF00D3FF00CBFF00C8FF00CCFF00D6FF00E6FF00FBFF00FFEB00FFCF00FFB1
00FF9300FF7500FF5A00FF4100FF2C00FF1C00FF1200FF0D00FF0F00FF1600FF2400FF37
00FF5000FF6D00FF8D00FFB000FFD500FFFB00DFFF00BBFF0099FF007AFF005FFF0049FF
0037FF002CFF0026FF0026FF002DFF0039FF004BFF0063FF0080FF00A1FF00C7FF00EFFF
00FFE500FFB900FF8C00FF5F00FF3400FF091DFF0042FF0062FF007EFF0095FF00A7FF00
B3FF00B9FF00B9FF00B2FF00A6FF0094FF007CFF005FFF003DFF0017FF0000FF1300FF41
00FF7100FFA300FFD700F4FF00BFFF008CFF005AFF002BFF
49FF001AFF0000FF1700FF4A00FF7E00FFB200FFE600E6FF00B5FF0087FF005CFF0035FF
0012FF0B00FF2400FF3800FF4500FF4C00FF4E00FF4900FF3E00FF2D00FF1700FF0003FF
0022FF0046FF006DFF0097FF00C2FF00EFFF00FFE300FFB600FF8B00FF6300FF3D00FF1B
02FF001BFF002EFF003CFF0044FF0045FF0041FF0036FF0026FF0010FF0000FF0900FF27
00FF4800FF6C00FF9100FFB700FFDC00FFFF00DEFF00C1FF00A7FF0093FF0084FF007BFF
0078FF007CFF0085FF0094FF00A8FF00C0FF00DBFF00F9FF00FFE800FFCA00FFAD00FF94
00FF7E00FF6D00FF6200FF5D00FF5E00FF6500FF7200FF8300FF9800FFAF00FFC600FFDC
00FFEF00FFFD00FAFF00F7FF00FBFF00FFFA00FFEC00FFDC00FFCC00FFC000FFB800FFB8
00FFBE00FFC700FFCF00FFD000FFCB00FFCA00FFD100FFDB00FFE200FFE300FFDD00FFD1
00FFC200FFB200FFA300FF9900FF9300FF9400FF9C00FFA900FFBB00FFD000FFE700FFFE
00ECFF00D9FF00CCFF00C3FF00C1FF00C5FF00CFFF00DFFF00F3FF00FFF300FFD700FFB9
00FF9A00FF7D00FF6100FF4800FF3300FF2300FF1900FF1400FF1600FF1E00FF2B00FF3F
00FF5700FF7400FF9400FFB800FFDC00FDFF00D8FF00B3FF0091FF0073FF0058FF0041FF
0030FF0024FF001EFF001FFF0025FF0032FF0044FF005CFF0079FF009AFF00BFFF00E8FF
00FFED00FFC100FF9400FF6700FF3B00FF1116FF003AFF005BFF0077FF008EFF009FFF00
ABFF00B1FF00B1FF00ABFF009FFF008DFF0075FF0058FF0036FF000FFF0000FF1A00FF48
00FF7800FFAB00FFDE00ECFF00B8FF0085FF0053FF0023FF
3CFF000DFF0000FF2400FF5700FF8B00FFBF00FFF300D9FF00A8FF007AFF004FFF0028FF
0005FF1900FF3100FF4500FF5200FF5900FF5B00FF5600FF4B00FF3B00FF2500FF0900FF
0015FF0039FF0060FF008AFF00B5FF00E2FF00FFF000FFC400FF9900FF7000FF4A00FF28
00FF0A0EFF0021FF002FFF0037FF0038FF0033FF0029FF0019FF0003FF0000FF1600FF34
00FF5500FF7900FF9E00FFC400FFE900F2FF00D1FF00B4FF009AFF0086FF0077FF006EFF
006BFF006FFF0078FF0087FF009BFF00B3FF00CEFF00ECFF00FFF500FFD700FFBB00FFA1
00FF8B00FF7A00FF6F00FF6A00FF6B00FF7200FF7F00FF9100FFA500FFBC00FFD300FFE9
00FFFC00F5FF00ECFF00EAFF00EEFF00F8FF00FFF900FFE900FFD900FFCD00FFC600FFC5
00FFCB00FFD500FFDD00FFDD00FFD900FFD800FFDF00FFE800FFEF00FFF000FFEA00FFDF
00FFCF00FFBF00FFB000FFA600FFA100FFA200FFA900FFB600FFC800FFDD00FFF400F4FF
00DEFF00CCFF00BEFF00B6FF00B4FF00B8FF00C2FF00D1FF00E6FF00FFFF00FFE400FFC6
00FFA800FF8A00FF6E00FF5500FF4000FF3100FF2600FF2100FF2300FF2B00FF3900FF4C
00FF6400FF8100FFA200FFC500FFEA00F0FF00CAFF00A6FF0084FF0065FF004AFF0034FF
0023FF0017FF0011FF0012FF0018FF0025FF0037FF004FFF006CFF008DFF00B2FF00DAFF
00FFFA00FFCE00FFA100FF7400FF4800FF1E09FF002DFF004EFF006AFF0081FF0092FF00
9EFF00A4FF00A4FF009EFF0092FF0080FF0068FF004BFF0029FF0002FF0000FF2700FF55
00FF8600FFB800FFEC00DFFF00ABFF0078FF0046FF0016FF
2AFF0000FF0400FF3600FF6900FF9D00FFD100FAFF00C7FF0096FF0068FF003DFF0016FF
0C00FF2A00FF4300FF5700FF6400FF6B00FF6D00FF6800FF5D00FF4D00FF3600FF1B00FF
0003FF0027FF004EFF0078FF00A3FF00D0FF00FDFF00FFD600FFAB00FF8200FF5C00FF3A
00FF1C00FF030FFF001DFF0025FF0026FF0022FF0017FF0007FF0000FF0E00FF2800FF46
00FF6700FF8B00FFB000FFD600FFFB00E0FF00BFFF00A2FF0088FF0074FF0065FF005CFF
0059FF005DFF0066FF0075FF0089FF00A1FF00BCFF00DAFF00F8FF00FFE900FFCC00FFB3
00FF9D00FF8C00FF8100FF7C00FF7D00FF8400FF9100FFA300FFB700FFCE00FFE500FFFB
00F1FF00E3FF00DAFF00D8FF00DCFF00E6FF00F4FF00FFFB00FFEB00FFDF00FFD700FFD7
00FFDD00FFE600FFEF00FFEF00FFEB00FFEA00FFF100FFFA00FEFF00FDFF00FFFC00FFF0
00FFE100FFD100FFC200FFB800FFB200FFB300FFBB00FFC800FFDA00FFEF00F9FF00E2FF
00CCFF00BAFF00ACFF00A4FF00A2FF00A6FF00B0FF00BFFF00D4FF00EDFF00FFF600FFD8
00FFBA00FF9C00FF8000FF6700FF5200FF4200FF3800FF3300FF3500FF3D00FF4A00FF5E
00FF7600FF9300FFB400FFD700FFFC00DEFF00B8FF0094FF0072FF0053FF0038FF0022FF
0011FF0005FF0000FF0000FF0006FF0013FF0025FF003DFF005AFF007BFF00A0FF00C8FF
00F3FF00FFE000FFB300FF8600FF5A00FF3000FF081BFF003CFF0058FF006FFF0080FF00
8CFF0092FF0092FF008CFF0080FF006EFF0056FF0039FF0017FF0000FF0F00FF3900FF67
00FF9700FFCA00FFFE00CDFF0099FF0066FF0034FF0004FF
14FF0000FF1A00FF4B00FF7E00FFB200FFE700E5FF00B2FF0081FF0053FF0028FF0000FF
2200FF4000FF5900FF6C00FF7900FF8100FF8200FF7D00FF7200FF6200FF4C00FF3100FF
1100FF0012FF0039FF0062FF008EFF00BBFF00E8FF00FFEB00FFC000FF9700FF7100FF4F
00FF3100FF1800FF0508FF000FFF0011FF000CFF0002FF0000FF0E00FF2300FF3D00FF5B
00FF7D00FFA100FFC600FFEB00EEFF00CBFF00AAFF008CFF0073FF005FFF0050FF0047FF
0044FF0047FF0051FF0060FF0074FF008CFF00A7FF00C4FF00E3FF00FFFE00FFE200FFC8
00FFB200FFA200FF9600FF9100FF9200FF9A00FFA600FFB800FFCD00FFE300FFFB00EFFF
00DCFF00CEFF00C5FF00C3FF00C7FF00D1FF00DFFF00EFFF00FEFF00FFF400FFED00FFEC
00FFF200FFFC00FBFF00FAFF00FFFF00FFFF00F9FF00EFFF00E8FF00E8FF00EEFF00F9FF
00FFF600FFE600FFD800FFCD00FFC800FFC900FFD000FFDD00FFEF00FAFF00E3FF00CCFF
00B7FF00A5FF0097FF008FFF008CFF0090FF009AFF00AAFF00BFFF00D8FF00F4FF00FFED
00FFCF00FFB100FF9500FF7D00FF6800FF5800FF4D00FF4900FF4A00FF5200FF6000FF73
00FF8C00FFA800FFC900FFEC00EEFF00C8FF00A3FF007FFF005DFF003EFF0023FF000DFF
0400FF0F00FF1500FF1500FF0E00FF0200FF0010FF0027FF0044FF0066FF008BFF00B3FF
00DEFF00FFF500FFC800FF9B00FF6F00FF4500FF1E06FF0026FF0042FF0059FF006BFF00
77FF007DFF007DFF0077FF006AFF0058FF0040FF0023FF0001FF0000FF2400FF4F00FF7C
00FFAD00FFDF00ECFF00B8FF0084FF0050FF001FFF1000FF
00FF0200FF3100FF6200FF9500FFC900FFFE00CEFF009BFF006AFF003CFF0011FF1600FF
3900FF5700FF7000FF8300FF9000FF9800FF9900FF9400FF8900FF7900FF6300FF4800FF
2800FF0400FF0022FF004BFF0077FF00A4FF00D1FF00FDFF00FFD700FFAE00FF8800FF66
00FF4800FF3000FF1C00FF0E00FF0700FF0500FF0A00FF1400FF2500FF3A00FF5400FF72
00FF9400FFB800FFDD00FDFF00D7FF00B4FF0093FF0075FF005CFF0048FF0039FF0030FF
002DFF0030FF003AFF0049FF005CFF0075FF0090FF00ADFF00CCFF00EAFF00FFF900FFDF
00FFC900FFB900FFAD00FFA800FFAA00FFB100FFBD00FFCF00FFE400FFFB00EDFF00D8FF
00C5FF00B7FF00AEFF00ACFF00B0FF00BAFF00C8FF00D8FF00E7FF00F4FF00FBFF00FCFF
00F6FF00ECFF00E4FF00E3FF00E8FF00E9FF00E2FF00D8FF00D1FF00D1FF00D6FF00E2FF
00F1FF00FFFD00FFEF00FFE400FFDF00FFE000FFE700FFF400F9FF00E3FF00CCFF00B5FF
00A0FF008EFF0080FF0078FF0075FF0079FF0083FF0093FF00A8FF00C1FF00DDFF00FBFF
00FFE600FFC800FFAC00FF9400FF7F00FF6F00FF6400FF6000FF6100FF6900FF7700FF8A
00FFA300FFBF00FFE000FCFF00D7FF00B1FF008CFF0068FF0046FF0027FF000CFF0900FF
1B00FF2600FF2C00FF2C00FF2500FF1900FF0600FF0010FF002DFF004FFF0074FF009CFF
00C7FF00F3FF00FFDF00FFB200FF8600FF5C00FF3500FF100FFF002BFF0042FF0054FF00
60FF0066FF0066FF0060FF0053FF0041FF0029FF000CFF0000FF1500FF3B00FF6600FF93
00FFC400FFF600D5FF00A1FF006DFF0039FF0008FF2700FF
00FF1900FF4800FF7900FFAC00FFE000EAFF00B6FF0084FF0053FF0025FF0500FF2D00FF
5000FF6E00FF8700FF9A00FFA700FFAF00FFB000FFAB00FFA000FF9000FF7A00FF5F00FF
3F00FF1B00FF000BFF0034FF0060FF008DFF00BAFF00E6FF00FFEE00FFC500FF9F00FF7D
00FF5F00FF4700FF3300FF2500FF1E00FF1C00FF2100FF2B00FF3C00FF5100FF6B00FF89
00FFAB00FFCF00FFF400E6FF00C0FF009DFF007CFF005EFF0045FF0031FF0022FF0019FF
0016FF0019FF0023FF0032FF0045FF005EFF0079FF0096FF00B5FF00D3FF00EFFF00FFF6
00FFE000FFD000FFC400FFBF00FFC100FFC800FFD400FFE600FFFB00EDFF00D6FF00C1FF
00AEFF00A0FF0097FF0095FF0099FF00A3FF00B1FF00C1FF00D0FF00DDFF00E4FF00E5FF
00DFFF00D5FF00CDFF00CCFF00D1FF00D2FF00CBFF00C1FF00BAFF00BAFF00BFFF00CBFF
00DAFF00EBFF00F9FF00FFFB00FFF600FFF700FFFE00F4FF00E2FF00CCFF00B5FF009EFF
0089FF0077FF0069FF0061FF005EFF0062FF006CFF007CFF0091FF00AAFF00C6FF00E4FF
00FFFD00FFDF00FFC300FFAB00FF9600FF8600FF7B00FF7700FF7800FF8000FF8E00FFA1
00FFBA00FFD600FFF700E5FF00C0FF009AFF0075FF0051FF002FFF0010FF0A00FF2000FF
3200FF3D00FF4300FF4300FF3C00FF3000FF1D00FF0600FF0016FF0038FF005DFF0085FF
00B0FF00DCFF00FFF600FFC900FF9D00FF7300FF4C00FF2700FF0714FF002BFF003DFF00
49FF004FFF004FFF0049FF003CFF002AFF0012FF0000FF0A00FF2C00FF5200FF7D00FFAA
00FFDB00F2FF00BEFF008AFF0056FF0022FF0E00FF3E00FF
00FF2E00FF5D00FF8F00FFC200FFF600D5FF00A1FF006EFF003EFF000FFF1B00FF4200FF
6500FF8300FF9C00FFAF00FFBD00FFC400FFC500FFC100FFB600FFA500FF8F00FF7400FF
5400FF3100FF0A00FF001FFF004BFF0077FF00A4FF00D1FF00FCFF00FFDA00FFB500FF92
00FF7500FF5C00FF4800FF3B00FF3300FF3200FF3600FF4100FF5100FF6600FF8100FF9F
00FFC000FFE400F6FF00D0FF00ABFF0088FF0066FF0049FF0030FF001BFF000CFF0003FF
0001FF0004FF000DFF001CFF0030FF0048FF0064FF0081FF009FFF00BDFF00DAFF00F3FF
00FFF600FFE500FFDA00FFD500FFD600FFDD00FFEA00FFFB00EFFF00D8FF00C1FF00ABFF
0098FF008AFF0082FF007FFF0084FF008DFF009BFF00ABFF00BBFF00C8FF00CFFF00CFFF
00C9FF00C0FF00B8FF00B7FF00BCFF00BDFF00B6FF00ACFF00A5FF00A4FF00AAFF00B6FF
00C5FF00D5FF00E4FF00EFFF00F4FF00F3FF00ECFF00DEFF00CCFF00B7FF00A0FF0089FF
0074FF0062FF0054FF004BFF0049FF004DFF0057FF0067FF007CFF0095FF00B1FF00CEFF
00EDFF00FFF400FFD900FFC000FFAB00FF9B00FF9100FF8C00FF8E00FF9500FFA300FFB7
00FFCF00FFEC00F3FF00D0FF00ABFF0085FF0060FF003CFF001AFF0400FF1F00FF3600FF
4700FF5300FF5800FF5800FF5200FF4500FF3300FF1B00FF0001FF0022FF0047FF0070FF
009AFF00C7FF00F4FF00FFDF00FFB300FF8900FF6100FF3D00FF1C00FF0016FF0028FF00
34FF003AFF003AFF0033FF0027FF0015FF0000FF0200FF1F00FF4100FF6800FF9200FFC0
00FFF000DCFF00A9FF0074FF0040FF000DFF2400FF5300FF
00FF4000FF6F00FFA100FFD400F7FF00C3FF008FFF005CFF002BFF0200FF2D00FF5400FF
7700FF9500FFAE00FFC100FFCF00FFD600FFD800FFD300FFC800FFB700FFA100FF8600FF
6700FF4300FF1C00FF000DFF0039FF0065FF0092FF00BFFF00EAFF00FFED00FFC700FFA5
00FF8700FF6E00FF5B00FF4D00FF4500FF4400FF4800FF5300FF6300FF7900FF9300FFB1
00FFD200FFF600E4FF00BEFF0099FF0075FF0054FF0037FF001DFF0009FF0500FF0E00FF
1100FF0D00FF0400FF000AFF001EFF0036FF0051FF006FFF008DFF00ABFF00C8FF00E1FF
00F7FF00FFF700FFEC00FFE700FFE800FFEF00FFFC00F2FF00DDFF00C6FF00AFFF0099FF
0086FF0078FF0070FF006DFF0071FF007BFF0089FF0099FF00A9FF00B5FF00BDFF00BDFF
00B7FF00AEFF00A6FF00A5FF00AAFF00ABFF00A4FF009AFF0093FF0092FF0098FF00A4FF
00B3FF00C3FF00D2FF00DCFF00E2FF00E1FF00D9FF00CCFF00BAFF00A5FF008EFF0077FF
0062FF004FFF0042FF0039FF0037FF003BFF0045FF0055FF0069FF0082FF009EFF00BCFF
00DBFF00F8FF00FFEB00FFD200FFBD00FFAD00FFA300FF9E00FFA000FFA800FFB500FFC9
00FFE100FFFE00E1FF00BDFF0099FF0073FF004EFF0029FF0007FF1600FF3100FF4800FF
5900FF6500FF6B00FF6A00FF6400FF5700FF4500FF2D00FF1000FF0010FF0035FF005EFF
0088FF00B4FF00E1FF00FFF100FFC500FF9B00FF7300FF4F00FF2E00FF1204FF0015FF00
21FF0027FF0027FF0021FF0015FF0003FF0000FF1400FF3100FF5300FF7A00FFA400FFD2
00FDFF00CAFF0097FF0062FF002EFF0400FF3600FF6600FF
00FF4E00FF7D00FFAE00FFE100E9FF00B5FF0081FF004FFF001EFF1000FF3B00FF6200FF
8500FFA300FFBC00FFCF00FFDD00FFE400FFE500FFE000FFD600FFC500FFAF00FF9400FF
7400FF5100FF2A00FF0000FF002BFF0057FF0084FF00B1FF00DCFF00FFFA00FFD400FFB2
00FF9500FF7C00FF6800FF5B00FF5300FF5100FF5600FF6100FF7100FF8600FFA000FFBF
00FFE000FBFF00D6FF00B0FF008BFF0068FF0047FF0029FF0010FF0400FF1300FF1B00FF
1E00FF1B00FF1200FF0300FF0010FF0028FF0044FF0061FF007FFF009EFF00BAFF00D4FF
00E9FF00FAFF00FFFA00FFF500FFF600FFFD00F5FF00E4FF00CFFF00B8FF00A1FF008BFF
0079FF006AFF0062FF0060FF0064FF006DFF007BFF008BFF009BFF00A8FF00AFFF00AFFF
00A9FF00A0FF0098FF0097FF009CFF009DFF0096FF008CFF0085FF0084FF008AFF0096FF
00A5FF00B5FF00C4FF00CFFF00D4FF00D3FF00CCFF00BEFF00ACFF0097FF0080FF0069FF
0054FF0042FF0034FF002CFF0029FF002DFF0037FF0047FF005CFF0075FF0091FF00AEFF
00CDFF00EBFF00FFF900FFE000FFCB00FFBB00FFB100FFAC00FFAE00FFB500FFC300FFD6
00FFEF00F3FF00D3FF00B0FF008BFF0065FF0040FF001CFF0500FF2400FF3F00FF5600FF
6700FF7200FF7800FF7800FF7100FF6500FF5300FF3B00FF1E00FF0002FF0028FF0050FF
007BFF00A7FF00D4FF00FFFF00FFD300FFA900FF8100FF5D00FF3C00FF2000FF0908FF00
14FF001AFF001AFF0013FF0007FF0000FF0A00FF2200FF3F00FF6100FF8800FFB200FFE0
00EFFF00BDFF0089FF0055FF0020FF1200FF4400FF7300FF
00FF5600FF8500FFB700FFEA00E1FF00ADFF0079FF0046FF0015FF1800FF4300FF6A00FF
8D00FFAB00FFC400FFD800FFE500FFEC00FFEE00FFE900FFDE00FFCD00FFB700FF9C00FF
7D00FF5900FF3200FF0800FF0022FF004FFF007CFF00A9FF00D4FF00FCFF00FFDD00FFBB
00FF9D00FF8400FF7100FF6300FF5B00FF5A00FF5E00FF6900FF7900FF8F00FFA900FFC7
00FFE800F3FF00CEFF00A8FF0083FF005FFF003EFF0021FF0007FF0C00FF1B00FF2400FF
2700FF2300FF1A00FF0B00FF0008FF0020FF003BFF0059FF0077FF0095FF00B2FF00CBFF
00E1FF00F2FF00FDFF00FFFD00FFFE00FAFF00EDFF00DCFF00C7FF00B0FF0099FF0083FF
0070FF0062FF005AFF0057FF005BFF0065FF0073FF0083FF0093FF009FFF00A7FF00A7FF
00A1FF0098FF0090FF008FFF0093FF0095FF008DFF0084FF007DFF007CFF0082FF008EFF
009DFF00ADFF00BCFF00C6FF00CCFF00CBFF00C3FF00B6FF00A4FF008FFF0078FF0061FF
004BFF0039FF002CFF0023FF0021FF0025FF002FFF003FFF0053FF006CFF0088FF00A6FF
00C5FF00E2FF00FEFF00FFE800FFD300FFC300FFB900FFB400FFB600FFBE00FFCB00FFDF
00FFF700EBFF00CBFF00A7FF0082FF005DFF0037FF0013FF0E00FF2C00FF4700FF5E00FF
6F00FF7B00FF8100FF8000FF7A00FF6D00FF5B00FF4300FF2600FF0500FF001FFF0048FF
0072FF009EFF00CBFF00F8FF00FFDB00FFB100FF8900FF6500FF4400FF2800FF1100FF00
0BFF0011FF0011FF000BFF0000FF0000FF1200FF2A00FF4700FF6900FF9000FFBA00FFE8
00E7FF00B4FF0081FF004CFF0018FF1A00FF4C00FF7C00FF
00FF5900FF8800FFB900FFEC00DFFF00AAFF0077FF0044FF0013FF1A00FF4500FF6D00FF
9000FFAE00FFC700FFDA00FFE700FFEF00FFF000FFEB00FFE000FFD000FFBA00FF9F00FF
7F00FF5B00FF3400FF0B00FF0020FF004DFF007AFF00A6FF00D1FF00FAFF00FFDF00FFBD
00FF9F00FF8600FF7300FF6500FF5E00FF5C00FF6100FF6B00FF7B00FF9100FFAB00FFC9
00FFEB00F1FF00CBFF00A6FF0081FF005DFF003CFF001EFF0005FF0E00FF1D00FF2600FF
2900FF2600FF1C00FF0D00FF0006FF001EFF0039FF0056FF0075FF0093FF00AFFF00C9FF
00DFFF00EFFF00FBFF00FFFF00FFFF00F7FF00EBFF00D9FF00C4FF00AEFF0096FF0081FF
006EFF0060FF0057FF0055FF0059FF0063FF0071FF0081FF0090FF009DFF00A4FF00A5FF
009FFF0095FF008DFF008CFF0091FF0092FF008BFF0081FF007AFF007AFF0080FF008BFF
009BFF00ABFF00B9FF00C4FF00C9FF00C8FF00C1FF00B4FF00A2FF008CFF0075FF005EFF
0049FF0037FF0029FF0021FF001FFF0022FF002CFF003CFF0051FF006AFF0086FF00A4FF
00C2FF00E0FF00FCFF00FFEA00FFD600FFC600FFBB00FFB700FFB800FFC000FFCE00FFE1
00FFFA00E9FF00C8FF00A5FF0080FF005AFF0035FF0011FF1000FF2F00FF4A00FF6000FF
7200FF7D00FF8300FF8300FF7C00FF7000FF5D00FF4500FF2900FF0700FF001DFF0045FF
0070FF009CFF00C9FF00F6FF00FFDD00FFB300FF8C00FF6700FF4700FF2B00FF1400FF02
09FF000FFF000FFF0009FF0000FF0300FF1500FF2D00FF4A00FF6C00FF9200FFBD00FFEA
00E4FF00B2FF007EFF004AFF0016FF1D00FF4E00FF7E00FF
00FF5500FF8400FFB500FFE800E3FF00AEFF007AFF0048FF0017FF1600FF4100FF6900FF
8C00FFAA00FFC300FFD600FFE300FFEB00FFEC00FFE700FFDC00FFCC00FFB600FF9B00FF
7B00FF5700FF3000FF0700FF0024FF0051FF007EFF00AAFF00D5FF00FEFF00FFDB00FFB9
00FF9B00FF8300FF6F00FF6100FF5A00FF5800FF5D00FF6700FF7800FF8D00FFA700FFC5
00FFE700F4FF00CFFF00AAFF0084FF0061FF0040FF0022FF0009FF0B00FF1900FF2200FF
2500FF2200FF1800FF0900FF0009FF0022FF003DFF005AFF0079FF0097FF00B3FF00CDFF
00E2FF00F3FF00FEFF00FFFB00FFFD00FBFF00EEFF00DDFF00C8FF00B1FF009AFF0085FF
0072FF0064FF005BFF0059FF005DFF0067FF0075FF0085FF0094FF00A1FF00A8FF00A9FF
00A3FF0099FF0091FF0090FF0095FF0096FF008FFF0085FF007EFF007EFF0083FF008FFF
009EFF00AFFF00BDFF00C8FF00CDFF00CCFF00C5FF00B8FF00A6FF0090FF0079FF0062FF
004DFF003BFF002DFF0025FF0022FF0026FF0030FF0040FF0055FF006EFF008AFF00A8FF
00C6FF00E4FF00FFFF00FFE700FFD200FFC200FFB700FFB300FFB400FFBC00FFCA00FFDD
00FFF600EDFF00CCFF00A9FF0084FF005EFF0039FF0015FF0C00FF2B00FF4600FF5C00FF
6E00FF7900FF7F00FF7F00FF7800FF6C00FF5900FF4200FF2500FF0300FF0021FF0049FF
0074FF00A0FF00CDFF00FAFF00FFD900FFAF00FF8800FF6300FF4300FF2700FF1001FF00
0DFF0013FF0013FF000DFF0000FF0000FF1100FF2900FF4600FF6800FF8E00FFB900FFE6
00E8FF00B6FF0082FF004EFF001AFF1900FF4A00FF7A00FF
00FF4B00FF7A00FFAB00FFDE00EDFF00B8FF0084FF0052FF0021FF0C00FF3700FF5F00FF
8200FFA000FFB900FFCC00FFD900FFE100FFE200FFDD00FFD200FFC200FFAC00FF9100FF
7100FF4D00FF2600FF0002FF002EFF005BFF0088FF00B4FF00DFFF00FFF700FFD100FFAF
00FF9100FF7900FF6500FF5700FF5000FF4E00FF5300FF5D00FF6E00FF8300FF9D00FFBB
00FFDD00FEFF00D9FF00B4FF008EFF006BFF004AFF002CFF0013FF0000FF0F00FF1800FF
1B00FF1800FF0E00FF0000FF0013FF002CFF0047FF0064FF0083FF00A1FF00BDFF00D7FF
00EDFF00FDFF00FFF600FFF100FFF300FFFA00F9FF00E7FF00D2FF00BBFF00A4FF008FFF
007CFF006EFF0065FF0063FF0067FF0071FF007FFF008FFF009EFF00ABFF00B2FF00B3FF
00ADFF00A3FF009BFF009AFF009FFF00A0FF0099FF008FFF0088FF0088FF008DFF0099FF
00A8FF00B9FF00C7FF00D2FF00D7FF00D6FF00CFFF00C2FF00B0FF009AFF0083FF006CFF
0057FF0045FF0037FF002FFF002CFF0030FF003AFF004AFF005FFF0078FF0094FF00B2FF
00D0FF00EEFF00FFF500FFDD00FFC800FFB800FFAD00FFA900FFAA00FFB200FFC000FFD3
00FFEC00F7FF00D6FF00B3FF008EFF0068FF0043FF001FFF0200FF2100FF3C00FF5200FF
6400FF6F00FF7500FF7500FF6E00FF6200FF4F00FF3800FF1B00FF0006FF002BFF0053FF
007EFF00AAFF00D7FF00FFFB00FFCF00FFA500FF7E00FF5900FF3900FF1D00FF060BFF00
17FF001DFF001DFF0017FF000AFF0000FF0700FF1F00FF3C00FF5E00FF8400FFAF00FFDC
00F2FF00C0FF008CFF0058FF0024FF0F00FF4000FF7000FF
00FF3B00FF6A00FF9B00FFCF00FCFF00C8FF0094FF0062FF0031FF0002FF2800FF4F00FF
7200FF9000FFA900FFBC00FFCA00FFD100FFD200FFCD00FFC300FFB200FF9C00FF8100FF
6100FF3E00FF1700FF0012FF003EFF006AFF0097FF00C4FF00EFFF00FFE700FFC100FF9F
00FF8200FF6900FF5500FF4800FF4000FF3E00FF4300FF4E00FF5E00FF7300FF8D00FFAC
00FFCD00FFF100E9FF00C3FF009EFF007BFF005AFF003CFF0023FF000EFF0000FF0900FF
0B00FF0800FF0000FF000FFF0023FF003BFF0057FF0074FF0092FF00B1FF00CDFF00E7FF
00FCFF00FFF200FFE700FFE200FFE300FFEA00FFF700F7FF00E2FF00CBFF00B4FF009EFF
008CFF007DFF0075FF0073FF0077FF0080FF008EFF009EFF00AEFF00BBFF00C2FF00C2FF
00BCFF00B3FF00ABFF00AAFF00AFFF00B0FF00A9FF009FFF0098FF0097FF009DFF00A9FF
00B8FF00C8FF00D7FF00E2FF00E7FF00E6FF00DFFF00D1FF00BFFF00AAFF0093FF007CFF
0067FF0055FF0047FF003FFF003CFF0040FF004AFF005AFF006FFF0088FF00A4FF00C1FF
00E0FF00FEFF00FFE600FFCD00FFB800FFA800FF9E00FF9900FF9B00FFA200FFB000FFC3
00FFDC00FFF900E6FF00C3FF009EFF0078FF0053FF002FFF000DFF1100FF2C00FF4300FF
5400FF6000FF6500FF6500FF5E00FF5200FF4000FF2800FF0B00FF0015FF003BFF0063FF
008EFF00BAFF00E7FF00FFEC00FFC000FF9600FF6E00FF4A00FF2900FF0D09FF001BFF00
27FF002DFF002DFF0026FF001AFF0008FF0000FF0F00FF2C00FF4E00FF7500FF9F00FFCD
00FFFD00D0FF009CFF0068FF0033FF0000FF3100FF6000FF
00FF2600FF5500FF8700FFBA00FFEE00DDFF00A9FF0076FF0046FF0017FF1300FF3A00FF
5D00FF7B00FF9400FFA700FFB500FFBC00FFBD00FFB900FFAE00FF9D00FF8700FF6C00FF
4C00FF2900FF0200FF0027FF0053FF007FFF00ACFF00D9FF00FFFB00FFD300FFAD00FF8B
00FF6D00FF5400FF4100FF3300FF2B00FF2A00FF2E00FF3900FF4900FF5E00FF7900FF97
00FFB800FFDC00FEFF00D8FF00B3FF008FFF006EFF0051FF0037FF0023FF0014FF000BFF
0009FF000CFF0015FF0024FF0038FF0050FF006BFF0089FF00A7FF00C5FF00E2FF00FBFF
00FFEE00FFDD00FFD200FFCD00FFCE00FFD500FFE200FFF300F7FF00E0FF00C9FF00B3FF
00A0FF0092FF008AFF0087FF008CFF0095FF00A3FF00B3FF00C3FF00D0FF00D7FF00D7FF
00D1FF00C8FF00C0FF00BFFF00C4FF00C5FF00BEFF00B4FF00ADFF00ACFF00B2FF00BEFF
00CDFF00DDFF00ECFF00F6FF00FCFF00FBFF00F3FF00E6FF00D4FF00BFFF00A8FF0091FF
007CFF0069FF005CFF0053FF0051FF0055FF005FFF006FFF0084FF009CFF00B8FF00D6FF
00F5FF00FFED00FFD100FFB800FFA300FF9300FF8900FF8400FF8600FF8E00FF9B00FFAF
00FFC700FFE400FBFF00D8FF00B3FF008DFF0068FF0043FF0022FF0003FF1700FF2E00FF
3F00FF4B00FF5000FF5000FF4A00FF3D00FF2B00FF1300FF0009FF002AFF004FFF0078FF
00A2FF00CFFF00FBFF00FFD700FFAB00FF8100FF5900FF3500FF1407FF001EFF0030FF00
3CFF0042FF0041FF003BFF002FFF001DFF0005FF0000FF1700FF3900FF6000FF8A00FFB8
00FFE800E4FF00B1FF007CFF0048FF0015FF1C00FF4B00FF
00FF0D00FF3C00FF6E00FFA100FFD500F6FF00C2FF008FFF005FFF0030FF0005FF2100FF
4400FF6200FF7B00FF8E00FF9C00FFA300FFA500FFA000FF9500FF8400FF6E00FF5300FF
3300FF1000FF0016FF0040FF006CFF0098FF00C5FF00F2FF00FFE200FFBA00FF9400FF72
00FF5400FF3B00FF2800FF1A00FF1200FF1100FF1500FF2000FF3000FF4600FF6000FF7E
00FF9F00FFC300FFE800F1FF00CCFF00A8FF0087FF006AFF0050FF003CFF002DFF0024FF
0021FF0025FF002EFF003DFF0051FF0069FF0084FF00A2FF00C0FF00DEFF00FBFF00FFEB
00FFD500FFC400FFB900FFB400FFB500FFBC00FFC900FFDA00FFEF00F9FF00E2FF00CCFF
00B9FF00ABFF00A3FF00A0FF00A4FF00AEFF00BCFF00CCFF00DCFF00E8FF00F0FF00F0FF
00EAFF00E1FF00D9FF00D8FF00DDFF00DEFF00D7FF00CDFF00C6FF00C5FF00CBFF00D7FF
00E6FF00F6FF00FFFA00FFF000FFEA00FFEB00FFF300FFFF00EDFF00D8FF00C1FF00AAFF
0095FF0082FF0075FF006CFF006AFF006EFF0078FF0088FF009CFF00B5FF00D1FF00EFFF
00FFF100FFD400FFB800FF9F00FF8A00FF7A00FF7000FF6B00FF6D00FF7500FF8200FF96
00FFAE00FFCB00FFEB00F0FF00CCFF00A6FF0081FF005CFF003AFF001CFF0001FF1500FF
2600FF3200FF3700FF3700FF3100FF2400FF1200FF0005FF0022FF0043FF0068FF0091FF
00BBFF00E7FF00FFEB00FFBE00FF9200FF6800FF4000FF1C04FF0020FF0037FF0049FF00
54FF005AFF005AFF0054FF0048FF0036FF001EFF0001FF0000FF2000FF4700FF7100FF9F
00FFCF00FDFF00CAFF0095FF0061FF002EFF0300FF3300FF
0EFF0000FF2000FF5200FF8500FFB900FFED00DEFF00ABFF007AFF004CFF0021FF0500FF
2800FF4600FF5F00FF7200FF8000FF8700FF8900FF8400FF7900FF6800FF5200FF3700FF
1800FF000BFF0032FF005CFF0088FF00B4FF00E1FF00FFF100FFC600FF9E00FF7800FF56
00FF3800FF1F00FF0C01FF0009FF000AFF0006FF0000FF0400FF1400FF2A00FF4400FF62
00FF8300FFA700FFCC00FFF200E8FF00C4FF00A3FF0086FF006CFF0058FF0049FF0040FF
003DFF0041FF004AFF0059FF006DFF0085FF00A0FF00BEFF00DCFF00FAFF00FFE800FFCF
00FFB900FFA800FF9D00FF9800FF9900FFA000FFAD00FFBE00FFD300FFEA00FEFF00E8FF
00D5FF00C7FF00BFFF00BCFF00C0FF00CAFF00D8FF00E8FF00F8FF00FFFB00FFF300FFF3
00FFF900FDFF00F5FF00F4FF00F9FF00FAFF00F3FF00E9FF00E2FF00E1FF00E7FF00F3FF
00FFFD00FFED00FFDE00FFD400FFCE00FFCF00FFD700FFE400FFF600F4FF00DDFF00C6FF
00B1FF009EFF0091FF0088FF0086FF008AFF0094FF00A4FF00B8FF00D1FF00EDFF00FFF4
00FFD500FFB800FF9C00FF8300FF6E00FF5E00FF5400FF4F00FF5100FF5900FF6600FF7A
00FF9200FFAF00FFCF00FFF300E8FF00C2FF009DFF0078FF0056FF0038FF001DFF0006FF
0A00FF1600FF1C00FF1B00FF1500FF0800FF0009FF0021FF003EFF005FFF0084FF00ADFF
00D7FF00FFFC00FFCF00FFA200FF7600FF4C00FF2400FF0020FF003CFF0053FF0065FF00
70FF0076FF0076FF0070FF0064FF0052FF003AFF001DFF0000FF0400FF2B00FF5500FF83
00FFB300FFE600E6FF00B1FF007DFF004AFF0018FF1700FF
2CFF0000FF0200FF3400FF6700FF9B00FFCF00FCFF00C9FF0098FF006AFF003FFF0018FF
0A00FF2800FF4100FF5500FF6200FF6900FF6B00FF6600FF5B00FF4B00FF3400FF1900FF
0005FF0029FF0050FF007AFF00A5FF00D2FF00FFFF00FFD400FFA900FF8000FF5A00FF38
00FF1A00FF0111FF001FFF0027FF0028FF0024FF0019FF0009FF0000FF0C00FF2600FF44
00FF6500FF8900FFAE00FFD400FFF900E2FF00C1FF00A4FF008AFF0076FF0067FF005EFF
005BFF005FFF0068FF0077FF008BFF00A3FF00BEFF00DCFF00FAFF00FFE700FFCA00FFB1
00FF9B00FF8A00FF7F00FF7A00FF7B00FF8200FF8F00FFA100FFB500FFCC00FFE300FFF9
00F3FF00E5FF00DCFF00DAFF00DEFF00E8FF00F6FF00FFF900FFE900FFDD00FFD500FFD5
00FFDB00FFE400FFED00FFED00FFE900FFE800FFEF00FFF800FFFF00FFFF00FFFA00FFEE
00FFDF00FFCF00FFC000FFB600FFB000FFB100FFB900FFC600FFD800FFED00FBFF00E4FF
00CEFF00BCFF00AEFF00A6FF00A4FF00A8FF00B2FF00C1FF00D6FF00EFFF00FFF400FFD6
00FFB800FF9A00FF7E00FF6500FF5000FF4000FF3600FF3100FF3300FF3B00FF4800FF5C
00FF7400FF9100FFB200FFD500FFFA00E0FF00BAFF0096FF0074FF0055FF003AFF0024FF
0013FF0007FF0001FF0002FF0008FF0015FF0027FF003FFF005CFF007DFF00A2FF00CAFF
00F5FF00FFDE00FFB100FF8400FF5800FF2E00FF061DFF003EFF005AFF0071FF0082FF00
8EFF0094FF0094FF008EFF0082FF0070FF0058FF003BFF0019FF0000FF0D00FF3700FF65
00FF9500FFC800FFFC00CFFF009BFF0068FF0036FF0006FF
4AFF001BFF0000FF1500FF4900FF7D00FFB100FFE500E8FF00B7FF0088FF005DFF0036FF
0013FF0A00FF2300FF3600FF4400FF4B00FF4C00FF4700FF3D00FF2C00FF1600FF0004FF
0024FF0047FF006EFF0098FF00C4FF00F0FF00FFE200FFB500FF8A00FF6100FF3B00FF19
03FF001CFF0030FF003DFF0045FF0047FF0042FF0037FF0027FF0012FF0000FF0700FF26
00FF4700FF6B00FF9000FFB600FFDB00FFFE00E0FF00C2FF00A9FF0094FF0085FF007CFF
007AFF007DFF0086FF0095FF00A9FF00C1FF00DDFF00FAFF00FFE700FFC800FFAC00FF92
00FF7D00FF6C00FF6100FF5C00FF5D00FF6400FF7100FF8200FF9700FFAE00FFC500FFDB
00FFED00FFFC00FBFF00F9FF00FDFF00FFF900FFEB00FFDB00FFCB00FFBE00FFB700FFB7
00FFBD00FFC600FFCE00FFCF00FFCA00FFC900FFD000FFDA00FFE100FFE200FFDC00FFD0
00FFC100FFB100FFA200FF9700FF9200FF9300FF9A00FFA800FFBA00FFCF00FFE600FFFD
00EDFF00DBFF00CDFF00C5FF00C2FF00C6FF00D0FF00E0FF00F5FF00FFF100FFD500FFB8
00FF9900FF7B00FF6000FF4700FF3200FF2200FF1800FF1300FF1500FF1C00FF2A00FF3D
00FF5600FF7300FF9300FFB600FFDB00FEFF00D9FF00B5FF0093FF0074FF0059FF0042FF
0031FF0026FF0020FF0020FF0027FF0033FF0045FF005DFF007AFF009BFF00C1FF00E9FF
00FFEB00FFBF00FF9200FF6600FF3A00FF1017FF003BFF005CFF0078FF008FFF00A1FF00
ADFF00B3FF00B3FF00ACFF00A0FF008EFF0076FF0059FF0037FF0010FF0000FF1900FF47
00FF7700FFA900FFDD00EEFF00B9FF0086FF0054FF0025FF
68FF0039FF0007FF0000FF2B00FF5F00FF9300FFC700FFFA00D4FF00A6FF007BFF0054FF
0031FF0013FF0500FF1800FF2600FF2D00FF2F00FF2A00FF1F00FF0E00FF0007FF0022FF
0041FF0065FF008CFF00B6FF00E1FF00FFF100FFC400FF9700FF6C00FF4400FF1E03FF00
21FF003AFF004DFF005BFF0063FF0064FF0060FF0055FF0045FF002FFF0015FF0000FF08
00FF2900FF4D00FF7200FF9800FFBD00FFE100FDFF00E0FF00C6FF00B2FF00A3FF009AFF
0097FF009BFF00A4FF00B3FF00C7FF00DFFF00FAFF00FFE700FFC900FFAB00FF8E00FF75
00FF5F00FF4E00FF4300FF3E00FF3F00FF4600FF5300FF6400FF7900FF9000FFA700FFBD
00FFD000FFDE00FFE600FFE900FFE500FFDB00FFCD00FFBD00FFAD00FFA100FF9900FF99
00FF9F00FFA800FFB000FFB100FFAC00FFAB00FFB200FFBC00FFC300FFC400FFBE00FFB2
00FFA300FF9300FF8400FF7A00FF7400FF7500FF7D00FF8A00FF9C00FFB100FFC800FFDF
00FFF400F8FF00EBFF00E2FF00E0FF00E4FF00EEFF00FEFF00FFED00FFD400FFB800FF9A
00FF7B00FF5E00FF4200FF2900FF1400FF0405FF000AFF0008FF0000FF0000FF0C00FF20
00FF3800FF5500FF7500FF9900FFBD00FFE300F7FF00D2FF00B0FF0092FF0077FF0060FF
004FFF0043FF003DFF003EFF0044FF0051FF0063FF007BFF0098FF00B9FF00DEFF00FFF8
00FFCE00FFA200FF7500FF4800FF1C0DFF0035FF0059FF007AFF0096FF00ADFF00BEFF00
CAFF00D0FF00D0FF00CAFF00BEFF00ACFF0094FF0077FF0055FF002EFF0004FF0000FF29
00FF5900FF8C00FFBF00FFF400D7FF00A4FF0072FF0042FF
84FF0055FF0023FF0000FF0F00FF4300FF7700FFAB00FFDE00F0FF00C2FF0097FF0070FF
004DFF002EFF0016FF0002FF0A00FF1100FF1300FF0E00FF0300FF000CFF0022FF003EFF
005DFF0081FF00A8FF00D2FF00FDFF00FFD500FFA800FF7C00FF5100FF2800FF021FFF00
3DFF0056FF0069FF0077FF007FFF0080FF007BFF0071FF0061FF004BFF0031FF0013FF00
00FF0D00FF3100FF5600FF7C00FFA100FFC500FFE600FCFF00E2FF00CEFF00BFFF00B6FF
00B3FF00B7FF00C0FF00CFFF00E3FF00FBFF00FFE900FFCB00FFAD00FF8F00FF7300FF59
00FF4300FF3200FF2700FF2200FF2300FF2A00FF3700FF4900FF5D00FF7400FF8B00FFA1
00FFB400FFC200FFCB00FFCD00FFC900FFBF00FFB100FFA100FF9100FF8500FF7E00FF7D
00FF8300FF8D00FF9500FF9500FF9100FF9000FF9700FFA000FFA700FFA800FFA200FF97
00FF8700FF7700FF6800FF5E00FF5900FF5A00FF6100FF6E00FF8000FF9500FFAC00FFC3
00FFD900FFEB00FFF900FEFF00FCFF00FFFF00FFF500FFE600FFD100FFB800FF9C00FF7E
00FF6000FF4200FF2600FF0D07FF0016FF0021FF0026FF0024FF001CFF000EFF0000FF04
00FF1C00FF3900FF5A00FF7D00FFA200FFC700FFED00EEFF00CCFF00ADFF0092FF007CFF
006BFF005FFF0059FF005AFF0060FF006DFF007FFF0097FF00B4FF00D5FF00FAFF00FFDD
00FFB200FF8600FF5900FF2C00FF0029FF0051FF0075FF0096FF00B2FF00C9FF00DAFF00
E6FF00ECFF00ECFF00E6FF00DAFF00C8FF00B0FF0093FF0071FF004AFF0020FF0000FF0D
00FF3E00FF7000FFA400FFD800F3FF00C0FF008EFF005EFF
9CFF006DFF003CFF0009FF0000FF2A00FF5F00FF9200FFC500FFF600DBFF00B0FF0088FF
0065FF0047FF002EFF001BFF000EFF0006FF0005FF000AFF0015FF0025FF003BFF0056FF
0076FF009AFF00C1FF00EBFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006FFF0082FF0090FF0097FF0099FF0094FF008AFF007AFF0064FF004AFF002CFF00
0AFF0000FF1800FF3E00FF6300FF8800FFAC00FFCD00FFEB00FBFF00E7FF00D8FF00CFFF
00CCFF00CFFF00D9FF00E8FF00FCFF00FFEB00FFD000FFB300FF9400FF7600FF5A00FF40
00FF2A00FF1A00FF0E00FF0900FF0A00FF1200FF1E00FF3000FF4500FF5B00FF7300FF88
00FF9B00FFA900FFB200FFB400FFB000FFA600FF9800FF8800FF7900FF6C00FF6500FF64
00FF6A00FF7400FF7C00FF7D00FF7800FF7700FF7E00FF8800FF8E00FF8F00FF8900FF7E
00FF6E00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7D00FF9400FFAB
00FFC000FFD200FFE000FFE800FFEA00FFE700FFDD00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0BFF001FFF002FFF003AFF003EFF003DFF0035FF0027FF0014FF00
00FF0400FF2000FF4100FF6400FF8900FFAE00FFD400FFF800E5FF00C6FF00ABFF0095FF
0084FF0078FF0072FF0072FF0079FF0085FF0098FF00B0FF00CCFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1318FF0042FF0069FF008EFF00AEFF00CAFF00E1FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F2FF00E0FF00C9FF00ABFF0089FF0063FF0038FF000BFF00
00FF2500FF5700FF8B00FFBF00FFF300D8FF00A7FF0077FF
B1FF0082FF0051FF001EFF0000FF1500FF4A00FF7E00FFB000FFE100F0FF00C4FF009DFF
007AFF005CFF0043FF0030FF0022FF001BFF001AFF001FFF0029FF003AFF0050FF006BFF
008BFF00AFFF00D6FF00FFFF00FFD400FFA700FF7A00FF4E00FF2305FF002BFF004DFF00
6BFF0083FF0097FF00A4FF00ACFF00AEFF00A9FF009FFF008EFF0079FF005FFF0041FF00
1FFF0000FF0400FF2900FF4F00FF7400FF9700FFB800FFD600FFEF00FBFF00EDFF00E4FF
00E1FF00E4FF00EEFF00FCFF00FFEF00FFD700FFBB00FF9E00FF7F00FF6100FF4500FF2B
00FF1600FF0505FF000AFF0009FF0002FF0000FF0A00FF1B00FF3000FF4700FF5E00FF74
00FF8600FF9500FF9D00FF9F00FF9B00FF9100FF8400FF7300FF6400FF5700FF5000FF50
00FF5500FF5F00FF6700FF6800FF6300FF6200FF6900FF7300FF7A00FF7B00FF7500FF69
00FF5A00FF4900FF3B00FF3000FF2B00FF2C00FF3300FF4000FF5200FF6800FF7F00FF96
00FFAB00FFBD00FFCB00FFD300FFD600FFD200FFC800FFB800FFA300FF8A00FF6E00FF50
00FF3200FF1407FF001FFF0034FF0044FF004FFF0053FF0051FF004AFF003CFF0029FF00
10FF0000FF0C00FF2C00FF4F00FF7400FF9A00FFBF00FFE300FAFF00DBFF00C0FF00AAFF
0098FF008DFF0087FF0087FF008EFF009AFF00ADFF00C4FF00E1FF00FFFC00FFD700FFAF
00FF8400FF5800FF2B01FF002CFF0057FF007EFF00A3FF00C3FF00DFFF00F6FF00FFF700
FFEB00FFE500FFE500FFEB00FFF800F5FF00DDFF00C0FF009EFF0078FF004DFF001FFF00
00FF1000FF4200FF7600FFAA00FFDE00EDFF00BBFF008CFF
C1FF0092FF0061FF002EFF0000FF0600FF3A00FF6E00FFA000FFD100FFFF00D4FF00ADFF
008AFF006CFF0053FF0040FF0032FF002BFF002AFF002FFF0039FF004AFF0060FF007BFF
009BFF00BEFF00E6FF00FFF000FFC400FF9700FF6B00FF3E00FF1315FF003BFF005DFF00
7AFF0093FF00A7FF00B4FF00BCFF00BEFF00B9FF00AEFF009EFF0089FF006FFF0050FF00
2FFF000BFF0000FF1900FF3F00FF6400FF8700FFA800FFC600FFDF00FFF400FCFF00F4FF
00F1FF00F4FF00FDFF00FFF300FFDF00FFC700FFAB00FF8E00FF6F00FF5100FF3500FF1B
00FF060AFF0015FF001AFF0019FF0012FF0005FF0000FF0B00FF2000FF3700FF4E00FF64
00FF7600FF8500FF8D00FF8F00FF8B00FF8200FF7400FF6300FF5400FF4700FF4000FF40
00FF4500FF4F00FF5700FF5800FF5300FF5200FF5900FF6300FF6A00FF6B00FF6500FF59
00FF4A00FF3900FF2B00FF2000FF1B00FF1C00FF2300FF3100FF4200FF5800FF6F00FF86
00FF9B00FFAD00FFBB00FFC300FFC600FFC200FFB800FFA800FF9300FF7A00FF5E00FF40
00FF2200FF0416FF002FFF0044FF0054FF005EFF0063FF0061FF005AFF004CFF0039FF00
20FF0003FF0000FF1C00FF3F00FF6400FF8A00FFAF00FFD300FFF500EBFF00D0FF00BAFF
00A8FF009DFF0097FF0097FF009EFF00AAFF00BCFF00D4FF00F1FF00FFED00FFC700FF9F
00FF7400FF4800FF1B11FF003CFF0067FF008EFF00B3FF00D3FF00EFFF00FFF900FFE700
FFDB00FFD500FFD500FFDC00FFE800FFFA00EDFF00D0FF00AEFF0088FF005DFF002FFF00
00FF0000FF3200FF6600FF9A00FFCF00FDFF00CBFF009CFF
CCFF009DFF006BFF0038FF0004FF0000FF2F00FF6300FF9600FFC700FFF500DFFF00B8FF
0095FF0076FF005EFF004AFF003DFF0035FF0034FF0039FF0044FF0054FF006AFF0086FF
00A5FF00C9FF00F0FF00FFE500FFBA00FF8D00FF6000FF3400FF091FFF0045FF0067FF00
85FF009EFF00B1FF00BFFF00C7FF00C8FF00C3FF00B9FF00A9FF0093FF0079FF005BFF00
3AFF0016FF0000FF0E00FF3400FF5900FF7D00FF9E00FFBB00FFD500FFE900FFF800FEFF
00FBFF00FFFF00FFF700FFE800FFD400FFBC00FFA100FF8300FF6500FF4700FF2B00FF11
04FF0015FF0020FF0025FF0024FF001DFF0010FF0000FF0100FF1500FF2C00FF4300FF59
00FF6C00FF7A00FF8300FF8500FF8100FF7700FF6900FF5900FF4900FF3D00FF3600FF35
00FF3B00FF4500FF4D00FF4D00FF4900FF4800FF4F00FF5800FF5F00FF6000FF5A00FF4F
00FF3F00FF2F00FF2000FF1600FF1100FF1200FF1900FF2600FF3800FF4D00FF6400FF7B
00FF9100FFA300FFB100FFB900FFBB00FFB700FFAD00FF9E00FF8900FF7000FF5400FF36
00FF1805FF0021FF003AFF004FFF005EFF0069FF006DFF006CFF0064FF0056FF0043FF00
2BFF000EFF0000FF1200FF3500FF5A00FF7F00FFA500FFC900FFEB00F5FF00DAFF00C4FF
00B3FF00A7FF00A1FF00A2FF00A8FF00B5FF00C7FF00DFFF00FCFF00FFE200FFBD00FF95
00FF6A00FF3E00FF111BFF0047FF0071FF0099FF00BDFF00DEFF00FAFF00FFEE00FFDD00
FFD100FFCB00FFCB00FFD100FFDD00FFEF00F8FF00DBFF00B8FF0092FF0068FF003AFF00
09FF0000FF2800FF5C00FF9000FFC400FFF700D6FF00A6FF
D0FF00A1FF0070FF003DFF0009FF0000FF2B00FF5F00FF9100FFC200FFF000E3FF00BCFF
0099FF007BFF0062FF004FFF0041FF003AFF0039FF003EFF0048FF0059FF006FFF008AFF
00AAFF00CDFF00F5FF00FFE100FFB500FF8800FF5B00FF2F00FF0424FF004AFF006CFF00
89FF00A2FF00B6FF00C3FF00CBFF00CDFF00C8FF00BDFF00ADFF0098FF007EFF005FFF00
3EFF001AFF0000FF0A00FF3000FF5500FF7800FF9900FFB700FFD000FFE500FFF400FFFC
00FFFF00FFFC00FFF200FFE400FFD000FFB800FF9C00FF7F00FF6000FF4200FF2600FF0C
08FF0019FF0024FF0029FF0028FF0021FF0014FF0003FF0000FF1100FF2800FF3F00FF55
00FF6700FF7600FF7E00FF8000FF7C00FF7200FF6500FF5400FF4500FF3800FF3100FF31
00FF3600FF4000FF4800FF4900FF4400FF4300FF4A00FF5400FF5B00FF5C00FF5600FF4A
00FF3B00FF2A00FF1C00FF1100FF0C00FF0D00FF1400FF2100FF3300FF4900FF6000FF77
00FF8C00FF9E00FFAC00FFB400FFB700FFB300FFA900FF9900FF8400FF6B00FF4F00FF31
00FF130AFF0026FF003EFF0053FF0063FF006DFF0072FF0070FF0069FF005BFF0048FF00
2FFF0012FF0000FF0D00FF3000FF5500FF7B00FFA000FFC400FFE600FAFF00DFFF00C9FF
00B7FF00ACFF00A6FF00A6FF00ADFF00B9FF00CBFF00E3FF00FFFF00FFDE00FFB800FF90
00FF6500FF3900FF0C20FF004BFF0076FF009DFF00C2FF00E2FF00FEFF00FFEA00FFD800
FFCC00FFC600FFC600FFCD00FFD900FFEB00FCFF00DFFF00BDFF0097FF006CFF003EFF00
0EFF0000FF2300FF5700FF8B00FFBF00FFF300DAFF00ABFF
CFFF00A0FF006EFF003BFF0007FF0000FF2C00FF6000FF9300FFC400FFF200E2FF00BBFF
0098FF0079FF0061FF004DFF0040FF0038FF0037FF003CFF0047FF0057FF006DFF0089FF
00A8FF00CCFF00F3FF00FFE200FFB700FF8A00FF5D00FF3100FF0622FF0048FF006AFF00
88FF00A1FF00B4FF00C2FF00CAFF00CBFF00C6FF00BCFF00ACFF0096FF007CFF005EFF00
3CFF0019FF0000FF0C00FF3100FF5600FF7A00FF9B00FFB900FFD200FFE600FFF500FFFE
00FEFF00FFFD00FFF400FFE500FFD100FFB900FF9E00FF8000FF6200FF4400FF2800FF0E
07FF0018FF0023FF0028FF0027FF0020FF0013FF0001FF0000FF1200FF2900FF4000FF56
00FF6900FF7700FF8000FF8200FF7E00FF7400FF6600FF5600FF4600FF3A00FF3300FF32
00FF3800FF4200FF4A00FF4A00FF4600FF4500FF4C00FF5500FF5C00FF5D00FF5700FF4C
00FF3C00FF2C00FF1E00FF1300FF0E00FF0F00FF1600FF2300FF3500FF4A00FF6100FF78
00FF8E00FFA000FFAE00FFB600FFB800FFB400FFAA00FF9B00FF8600FF6D00FF5100FF33
00FF1508FF0024FF003DFF0051FF0061FF006CFF0070FF006FFF0067FF0059FF0046FF00
2EFF0011FF0000FF0F00FF3200FF5700FF7C00FFA200FFC600FFE800F8FF00DDFF00C7FF
00B6FF00AAFF00A4FF00A5FF00ABFF00B8FF00CAFF00E2FF00FFFF00FFDF00FFBA00FF92
00FF6700FF3B00FF0E1EFF004AFF0074FF009CFF00C0FF00E0FF00FDFF00FFEB00FFDA00
FFCE00FFC800FFC800FFCE00FFDA00FFED00FBFF00DEFF00BBFF0095FF006BFF003DFF00
0CFF0000FF2500FF5900FF8D00FFC100FFF400D9FF00A9FF
C7FF0098FF0066FF0033FF0000FF0000FF3400FF6800FF9B00FFCC00FFFA00DAFF00B3FF
0090FF0072FF0059FF0046FF0038FF0031FF002FFF0034FF003FFF0050FF0066FF0081FF
00A0FF00C4FF00EBFF00FFEA00FFBE00FF9200FF6500FF3800FF0D1AFF0040FF0062FF00
80FF0099FF00ACFF00BAFF00C2FF00C3FF00BFFF00B4FF00A4FF008EFF0074FF0056FF00
35FF0011FF0000FF1300FF3900FF5E00FF8200FFA300FFC000FFDA00FFEE00FFFD00F9FF
00F6FF00FAFF00FFFC00FFED00FFD900FFC100FFA600FF8800FF6A00FF4C00FF2F00FF16
00FF0010FF001BFF0020FF001FFF0018FF000BFF0000FF0500FF1A00FF3100FF4800FF5E
00FF7100FF7F00FF8700FF8A00FF8600FF7C00FF6E00FF5E00FF4E00FF4200FF3A00FF3A
00FF4000FF4900FF5100FF5200FF4D00FF4C00FF5300FF5D00FF6400FF6500FF5F00FF53
00FF4400FF3400FF2500FF1B00FF1500FF1600FF1E00FF2B00FF3D00FF5200FF6900FF80
00FF9500FFA800FFB500FFBE00FFC000FFBC00FFB200FFA200FF8E00FF7500FF5900FF3B
00FF1C00FF001CFF0035FF004AFF005AFF0064FF0069FF0067FF005FFF0052FF003EFF00
26FF0009FF0000FF1600FF3A00FF5E00FF8400FFA900FFCE00FFF000F1FF00D6FF00BFFF
00AEFF00A2FF009CFF009DFF00A3FF00B0FF00C2FF00DAFF00F7FF00FFE700FFC200FF99
00FF6F00FF4300FF1616FF0042FF006CFF0094FF00B8FF00D9FF00F5FF00FFF300FFE200
FFD600FFD000FFD000FFD600FFE200FFF400F3FF00D6FF00B4FF008DFF0063FF0035FF00
05FF0000FF2D00FF6000FF9500FFC900FFFC00D1FF00A1FF
B9FF008AFF0059FF0026FF0000FF0E00FF4200FF7600FFA800FFD900F7FF00CCFF00A5FF
0082FF0064FF004BFF0038FF002AFF0023FF0022FF0027FF0031FF0042FF0058FF0073FF
0093FF00B6FF00DDFF00FFF800FFCC00FFA000FF7300FF4600FF1B0DFF0033FF0055FF00
72FF008BFF009FFF00ACFF00B4FF00B6FF00B1FF00A6FF0096FF0081FF0067FF0048FF00
27FF0003FF0000FF2100FF4700FF6C00FF8F00FFB000FFCE00FFE700FFFC00F4FF00ECFF
00E9FF00ECFF00F5FF00FFFB00FFE700FFCF00FFB300FF9600FF7800FF5900FF3D00FF23
00FF0E02FF000DFF0012FF0011FF000AFF0000FF0200FF1300FF2800FF3F00FF5600FF6C
00FF7E00FF8D00FF9500FF9700FF9300FF8A00FF7C00FF6C00FF5C00FF4F00FF4800FF48
00FF4D00FF5700FF5F00FF6000FF5B00FF5A00FF6100FF6B00FF7200FF7300FF6D00FF61
00FF5200FF4200FF3300FF2800FF2300FF2400FF2B00FF3900FF4A00FF6000FF7700FF8E
00FFA300FFB500FFC300FFCB00FFCE00FFCA00FFC000FFB000FF9B00FF8200FF6600FF48
00FF2A00FF0C0EFF0027FF003CFF004CFF0056FF005BFF0059FF0052FF0044FF0031FF00
18FF0000FF0400FF2400FF4700FF6C00FF9200FFB700FFDB00FFFD00E3FF00C8FF00B1FF
00A0FF0095FF008FFF008FFF0096FF00A2FF00B4FF00CCFF00E9FF00FFF500FFCF00FFA7
00FF7C00FF5000FF2308FF0034FF005EFF0086FF00AAFF00CBFF00E7FF00FEFF00FFEF00
FFE300FFDD00FFDD00FFE400FFF000FDFF00E5FF00C8FF00A6FF007FFF0055FF0027FF00
00FF0800FF3A00FF6E00FFA200FFD700F5FF00C3FF0094FF
A6FF0077FF0045FF0012FF0000FF2100FF5500FF8900FFBC00FFED00E4FF00B9FF0092FF
006FFF0051FF0038FF0024FF0017FF0010FF000EFF0013FF001EFF002FFF0045FF0060FF
007FFF00A3FF00CAFF00F4FF00FFE000FFB300FF8600FF5900FF2E00FF061FFF0041FF00
5FFF0078FF008BFF0099FF00A1FF00A2FF009EFF0093FF0083FF006DFF0053FF0035FF00
14FF0000FF0F00FF3400FF5A00FF7F00FFA300FFC400FFE100FFFB00F0FF00E1FF00D8FF
00D5FF00D9FF00E2FF00F1FF00FFFA00FFE200FFC700FFA900FF8B00FF6D00FF5000FF37
00FF2100FF1000FF0500FF0000FF0100FF0800FF1500FF2600FF3B00FF5200FF6900FF7F
00FF9200FFA000FFA800FFAB00FFA700FF9D00FF8F00FF7F00FF6F00FF6300FF5B00FF5B
00FF6100FF6A00FF7200FF7300FF6F00FF6D00FF7500FF7E00FF8500FF8600FF8000FF74
00FF6500FF5500FF4600FF3C00FF3600FF3700FF3F00FF4C00FF5E00FF7300FF8A00FFA1
00FFB700FFC900FFD600FFDF00FFE100FFDD00FFD300FFC300FFAF00FF9600FF7A00FF5C
00FF3D00FF2000FF0414FF0029FF0039FF0043FF0048FF0046FF003EFF0031FF001DFF00
05FF0000FF1700FF3700FF5B00FF7F00FFA500FFCB00FFEF00EEFF00D0FF00B5FF009EFF
008DFF0081FF007BFF007CFF0082FF008FFF00A1FF00B9FF00D6FF00F7FF00FFE300FFBA
00FF9000FF6400FF3700FF0A21FF004BFF0073FF0097FF00B8FF00D4FF00EBFF00FCFF00
FFF700FFF100FFF100FFF700FCFF00EAFF00D2FF00B5FF0093FF006CFF0042FF0014FF00
00FF1B00FF4E00FF8100FFB600FFEA00E2FF00B0FF0080FF
8DFF005EFF002DFF0000FF0500FF3900FF6E00FFA100FFD400FAFF00CCFF00A1FF0079FF
0056FF0038FF001FFF000CFF0000FF0800FF0900FF0400FF0006FF0016FF002CFF0047FF
0067FF008BFF00B2FF00DBFF00FFF800FFCB00FF9E00FF7200FF4700FF1E07FF0029FF00
47FF005FFF0073FF0081FF0088FF008AFF0085FF007BFF006AFF0055FF003BFF001DFF00
00FF0400FF2800FF4D00FF7200FF9800FFBB00FFDC00FFFA00ECFF00D8FF00C9FF00C0FF
00BDFF00C0FF00CAFF00D9FF00ECFF00FFFA00FFDF00FFC200FFA300FF8500FF6900FF4F
00FF3900FF2900FF1D00FF1800FF1A00FF2100FF2D00FF3F00FF5400FF6B00FF8200FF97
00FFAA00FFB800FFC100FFC300FFBF00FFB500FFA700FF9700FF8800FF7B00FF7400FF73
00FF7900FF8300FF8B00FF8C00FF8700FF8600FF8D00FF9700FF9E00FF9E00FF9900FF8D
00FF7E00FF6D00FF5F00FF5400FF4F00FF5000FF5700FF6400FF7600FF8C00FFA300FFBA
00FFCF00FFE100FFEF00FFF700FFFA00FFF600FFEC00FFDC00FFC700FFAE00FF9200FF74
00FF5600FF3800FF1C00FF0410FF0020FF002BFF002FFF002EFF0026FF0018FF0005FF00
00FF1300FF2F00FF5000FF7300FF9800FFBE00FFE300F8FF00D6FF00B7FF009CFF0086FF
0074FF0069FF0063FF0063FF006AFF0076FF0089FF00A0FF00BDFF00DFFF00FFFB00FFD3
00FFA800FF7C00FF4F00FF2209FF0033FF005AFF007FFF009FFF00BBFF00D2FF00E4FF00
F0FF00F6FF00F6FF00F0FF00E3FF00D1FF00B9FF009CFF007AFF0054FF0029FF0000FF03
00FF3400FF6600FF9A00FFCE00FDFF00C9FF0098FF0068FF
71FF0041FF0010FF0000FF2200FF5600FF8A00FFBE00FFF100DDFF00AFFF0084FF005CFF
0039FF001BFF0002FF1000FF1D00FF2500FF2600FF2100FF1600FF0600FF000FFF002AFF
004AFF006EFF0095FF00BFFF00EAFF00FFE800FFBB00FF8F00FF6400FF3B00FF150CFF00
2AFF0043FF0056FF0064FF006BFF006DFF0068FF005EFF004EFF0038FF001EFF0000FF00
00FF2100FF4400FF6A00FF8F00FFB400FFD800FFF900E8FF00CFFF00BBFF00ACFF00A3FF
00A0FF00A3FF00ADFF00BCFF00D0FF00E8FF00FFFC00FFDF00FFC000FFA200FF8600FF6C
00FF5600FF4500FF3A00FF3500FF3600FF3E00FF4A00FF5C00FF7100FF8700FF9E00FFB4
00FFC700FFD500FFDE00FFE000FFDC00FFD200FFC400FFB400FFA400FF9800FF9100FF90
00FF9600FFA000FFA800FFA800FFA400FFA300FFAA00FFB400FFBA00FFBB00FFB500FFAA
00FF9A00FF8A00FF7C00FF7100FF6C00FF6D00FF7400FF8100FF9300FFA800FFBF00FFD6
00FFEC00FFFE00F3FF00EBFF00E9FF00EDFF00F7FF00FFF900FFE400FFCB00FFAF00FF91
00FF7300FF5500FF3900FF2000FF0C03FF000EFF0012FF0011FF0009FF0000FF0400FF17
00FF2F00FF4C00FF6D00FF9000FFB500FFDA00FFFF00DBFF00B9FF009AFF007FFF0069FF
0058FF004CFF0046FF0046FF004DFF0059FF006CFF0084FF00A0FF00C2FF00E7FF00FFF0
00FFC500FF9900FF6C00FF3F00FF1316FF003DFF0062FF0082FF009EFF00B5FF00C7FF00
D3FF00D9FF00D9FF00D3FF00C7FF00B4FF009DFF007FFF005DFF0037FF000CFF0000FF20
00FF5100FF8300FFB700FFEB00E0FF00ADFF007BFF004BFF
50FF0021FF0000FF0F00FF4300FF7700FFAB00FFDF00EEFF00BDFF008EFF0063FF003CFF
0019FF0400FF1D00FF3000FF3E00FF4500FF4600FF4200FF3700FF2600FF1000FF000AFF
002AFF004DFF0074FF009EFF00CAFF00F6FF00FFDC00FFAF00FF8400FF5B00FF3600FF13
09FF0022FF0036FF0043FF004BFF004DFF0048FF003DFF002DFF0018FF0000FF0100FF20
00FF4100FF6500FF8A00FFB000FFD500FFF800E6FF00C8FF00AFFF009AFF008BFF0082FF
0080FF0083FF008CFF009BFF00AFFF00C7FF00E3FF00FFFF00FFE100FFC300FFA600FF8C
00FF7700FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7C00FF9100FFA800FFBF00FFD5
00FFE700FFF600FFFE00FFFF00FFFC00FFF300FFE500FFD500FFC500FFB800FFB100FFB1
00FFB700FFC000FFC800FFC900FFC400FFC300FFCA00FFD400FFDB00FFDC00FFD600FFCA
00FFBB00FFAB00FF9C00FF9100FF8C00FF8D00FF9400FFA200FFB400FFC900FFE000FFF7
00F3FF00E1FF00D3FF00CBFF00C8FF00CCFF00D6FF00E6FF00FBFF00FFEB00FFCF00FFB2
00FF9300FF7500FF5A00FF4100FF2C00FF1C00FF1200FF0D00FF0F00FF1600FF2400FF37
00FF5000FF6D00FF8D00FFB000FFD500FFFB00DFFF00BBFF0099FF007AFF005FFF0048FF
0037FF002BFF0026FF0026FF002DFF0039FF004BFF0063FF0080FF00A1FF00C7FF00EFFF
00FFE600FFB900FF8C00FF6000FF3400FF0A1DFF0041FF0062FF007EFF0095FF00A7FF00
B3FF00B9FF00B9FF00B2FF00A6FF0094FF007CFF005FFF003DFF0016FF0000FF1300FF41
00FF7100FFA300FFD700F4FF00BFFF008CFF005AFF002BFF
2DFF0000FF0100FF3300FF6600FF9A00FFCE00FDFF00CAFF009AFF006BFF0040FF0019FF
0900FF2700FF4000FF5300FF6100FF6800FF6900FF6500FF5A00FF4900FF3300FF1800FF
0007FF002AFF0051FF007BFF00A7FF00D3FF00FFFF00FFD200FFA700FF7E00FF5900FF37
00FF1900FF0013FF0020FF0028FF0029FF0025FF001AFF000AFF0000FF0A00FF2500FF43
00FF6400FF8800FFAD00FFD300FFF800E3FF00C2FF00A5FF008BFF0077FF0068FF005FFF
005DFF0060FF0069FF0078FF008CFF00A4FF00BFFF00DDFF00FBFF00FFE600FFC900FFB0
00FF9A00FF8900FF7E00FF7900FF7A00FF8100FF8E00FF9F00FFB400FFCB00FFE200FFF8
00F4FF00E6FF00DEFF00DBFF00E0FF00E9FF00F7FF00FFF800FFE800FFDB00FFD400FFD4
00FFDA00FFE300FFEB00FFEC00FFE700FFE600FFED00FFF700FFFE00FFFF00FFF900FFED
00FFDE00FFCE00FFBF00FFB500FFAF00FFB000FFB800FFC500FFD700FFEC00FCFF00E5FF
00D0FF00BDFF00B0FF00A7FF00A5FF00A9FF00B3FF00C3FF00D8FF00F0FF00FFF300FFD5
00FFB600FF9900FF7D00FF6400FF4F00FF3F00FF3500FF3000FF3200FF3A00FF4700FF5B
00FF7300FF9000FFB000FFD300FFF800E1FF00BCFF0097FF0076FF0057FF003CFF0025FF
0014FF0008FF0003FF0003FF0009FF0016FF0028FF0040FF005DFF007EFF00A3FF00CCFF
00F6FF00FFDC00FFB000FF8300FF5700FF2D00FF051EFF003FFF005BFF0072FF0084FF00
90FF0096FF0095FF008FFF0083FF0071FF0059FF003CFF001AFF0000FF0C00FF3600FF64
00FF9400FFC700FFFA00D0FF009CFF0069FF0037FF0008FF
08FF0000FF2600FF5700FF8B00FFBF00FFF300D8FF00A6FF0075FF0046FF001BFF0B00FF
2E00FF4C00FF6500FF7800FF8600FF8D00FF8E00FF8A00FF7F00FF6E00FF5800FF3D00FF
1D00FF0005FF002CFF0056FF0082FF00AEFF00DBFF00FFF700FFCC00FFA300FF7E00FF5B
00FF3E00FF2500FF1100FF0403FF0004FF0000FF0000FF0A00FF1A00FF2F00FF4900FF68
00FF8900FFAD00FFD200FFF800E2FF00BFFF009EFF0080FF0067FF0052FF0043FF003AFF
0038FF003BFF0044FF0053FF0067FF007FFF009BFF00B8FF00D6FF00F4FF00FFEE00FFD4
00FFBF00FFAE00FFA300FF9E00FF9F00FFA600FFB300FFC400FFD900FFF000F8FF00E2FF
00D0FF00C1FF00B9FF00B7FF00BBFF00C4FF00D2FF00E2FF00F2FF00FFFF00FFF900FFF9
00FFFF00F7FF00EFFF00EEFF00F3FF00F4FF00EDFF00E3FF00DCFF00DBFF00E1FF00EDFF
00FCFF00FFF300FFE400FFD900FFD400FFD500FFDC00FFEA00FFFC00EEFF00D7FF00C0FF
00ABFF0099FF008BFF0082FF0080FF0084FF008EFF009EFF00B3FF00CCFF00E8FF00FFFA
00FFDB00FFBD00FFA200FF8900FF7400FF6400FF5A00FF5500FF5700FF5E00FF6C00FF7F
00FF9800FFB500FFD500FFF800E2FF00BCFF0097FF0073FF0051FF0032FF0017FF0000FF
1000FF1C00FF2100FF2100FF1B00FF0E00FF0003FF001BFF0038FF0059FF007EFF00A7FF
00D1FF00FEFF00FFD400FFA800FF7C00FF5200FF2A00FF061AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006AFF005EFF004CFF0034FF0017FF0000FF0A00FF3100FF5B00FF89
00FFB900FFEC00E0FF00ACFF0077FF0044FF0012FF1C00FF
00FF1D00FF4C00FF7D00FFB000FFE400E6FF00B3FF0080FF004FFF0021FF0900FF3100FF
5400FF7200FF8B00FF9E00FFAB00FFB300FFB400FFAF00FFA400FF9400FF7E00FF6300FF
4300FF1F00FF0007FF0030FF005CFF0089FF00B6FF00E2FF00FFF200FFC900FFA300FF81
00FF6300FF4A00FF3700FF2900FF2200FF2000FF2500FF2F00FF4000FF5500FF6F00FF8D
00FFAF00FFD200FFF800E2FF00BCFF0099FF0078FF005AFF0041FF002DFF001EFF0015FF
0012FF0015FF001FFF002EFF0042FF005AFF0075FF0092FF00B1FF00CFFF00EBFF00FFFA
00FFE400FFD400FFC800FFC300FFC400FFCC00FFD800FFEA00FFFF00EAFF00D2FF00BDFF
00AAFF009CFF0093FF0091FF0095FF009FFF00ADFF00BDFF00CCFF00D9FF00E0FF00E1FF
00DBFF00D1FF00C9FF00C8FF00CDFF00CEFF00C7FF00BDFF00B6FF00B6FF00BCFF00C7FF
00D7FF00E7FF00F5FF00FFFF00FFFA00FFFB00FDFF00F0FF00DEFF00C8FF00B1FF009AFF
0085FF0073FF0065FF005DFF005AFF005EFF0068FF0078FF008DFF00A6FF00C2FF00E0FF
00FEFF00FFE300FFC700FFAE00FF9A00FF8A00FF7F00FF7B00FF7C00FF8400FF9200FFA5
00FFBE00FFDA00FFFB00E1FF00BCFF0096FF0071FF004DFF002BFF000CFF0E00FF2400FF
3600FF4100FF4700FF4700FF4000FF3400FF2100FF0900FF0012FF0034FF0059FF0081FF
00ACFF00D8FF00FFFA00FFCD00FFA100FF7700FF5000FF2B00FF0B10FF0027FF0039FF00
45FF004BFF004BFF0045FF0038FF0026FF000EFF0000FF0E00FF3000FF5600FF8100FFAE
00FFDF00EEFF00BAFF0086FF0052FF001EFF1200FF4200FF
00FF4200FF7100FFA300FFD600F5FF00C1FF008DFF005AFF002AFF0400FF2F00FF5600FF
7900FF9700FFB000FFC300FFD100FFD800FFD900FFD500FFCA00FFB900FFA300FF8800FF
6800FF4500FF1E00FF000BFF0037FF0063FF0090FF00BDFF00E8FF00FFEE00FFC900FFA6
00FF8900FF7000FF5C00FF4F00FF4700FF4600FF4A00FF5500FF6500FF7A00FF9500FFB3
00FFD400FFF800E2FF00BCFF0097FF0074FF0053FF0035FF001CFF0007FF0700FF1000FF
1200FF0F00FF0600FF0008FF001CFF0034FF0050FF006DFF008BFF00A9FF00C6FF00DFFF
00F5FF00FFF900FFEE00FFE900FFEA00FFF100FFFE00F0FF00DBFF00C4FF00ADFF0097FF
0084FF0076FF006EFF006CFF0070FF0079FF0087FF0097FF00A7FF00B4FF00BBFF00BBFF
00B5FF00ACFF00A4FF00A3FF00A8FF00A9FF00A2FF0098FF0091FF0090FF0096FF00A2FF
00B1FF00C1FF00D0FF00DBFF00E0FF00DFFF00D8FF00CAFF00B8FF00A3FF008CFF0075FF
0060FF004EFF0040FF0037FF0035FF0039FF0043FF0053FF0068FF0081FF009DFF00BAFF
00D9FF00F7FF00FFED00FFD400FFBF00FFAF00FFA500FFA000FFA200FFA900FFB700FFCB
00FFE300FFFF00DFFF00BCFF0097FF0071FF004CFF0028FF0006FF1800FF3300FF4A00FF
5B00FF6700FF6C00FF6C00FF6600FF5900FF4700FF2F00FF1200FF000EFF0033FF005CFF
0086FF00B3FF00E0FF00FFF300FFC700FF9D00FF7500FF5100FF3000FF1402FF0014FF00
20FF0026FF0026FF001FFF0013FF0001FF0000FF1600FF3300FF5500FF7C00FFA600FFD4
00FBFF00C8FF0095FF0060FF002CFF0600FF3800FF6700FF
00FF6600FF9500FFC700FFFA00D1FF009DFF0069FF0036FF0006FF2800FF5300FF7A00FF
9D00FFBB00FFD400FFE700FFF500FFFC00FFFE00FFF900FFEE00FFDD00FFC700FFAC00FF
8C00FF6900FF4200FF1800FF0013FF003FFF006CFF0099FF00C4FF00ECFF00FFED00FFCB
00FFAD00FF9400FF8100FF7300FF6B00FF6A00FF6E00FF7900FF8900FF9F00FFB900FFD7
00FFF800E3FF00BEFF0098FF0073FF004FFF002EFF0011FF0800FF1C00FF2B00FF3400FF
3700FF3300FF2A00FF1B00FF0700FF0010FF002BFF0049FF0067FF0085FF00A2FF00BBFF
00D1FF00E2FF00EDFF00F2FF00F1FF00EAFF00DDFF00CCFF00B7FF00A0FF0089FF0073FF
0060FF0052FF004AFF0047FF004BFF0055FF0063FF0073FF0083FF008FFF0097FF0097FF
0091FF0088FF0080FF007FFF0084FF0085FF007EFF0074FF006DFF006CFF0072FF007EFF
008DFF009DFF00ACFF00B6FF00BCFF00BBFF00B3FF00A6FF0094FF007FFF0068FF0051FF
003CFF0029FF001CFF0013FF0011FF0015FF001FFF002FFF0043FF005CFF0078FF0096FF
00B5FF00D2FF00EEFF00FFF800FFE300FFD300FFC900FFC400FFC600FFCE00FFDB00FFEF
00F8FF00DBFF00BBFF0097FF0073FF004DFF0028FF0003FF1E00FF3C00FF5700FF6E00FF
7F00FF8B00FF9100FF9000FF8A00FF7D00FF6B00FF5300FF3600FF1500FF000FFF0038FF
0062FF008EFF00BBFF00E8FF00FFEB00FFC100FF9900FF7500FF5400FF3800FF2100FF0F
00FF0401FF0001FF0000FF0400FF1000FF2200FF3A00FF5700FF7900FFA000FFCA00FFF8
00D7FF00A4FF0071FF003CFF0008FF2A00FF5C00FF8C00FF
00FF8800FFB700FFE900E3FF00AFFF007BFF0047FF0014FF1B00FF4A00FF7500FF9C00FF
BF00FFDD00FFF600FFFF00F6FF00E8FF00E1FF00E0FF00E4FF00EFFF00FFE900FFCE00FF
AE00FF8B00FF6400FF3A00FF0E00FF001DFF004AFF0077FF00A2FF00CAFF00F0FF00FFED
00FFCF00FFB600FFA200FF9500FF8D00FF8C00FF9000FF9B00FFAB00FFC000FFDB00FFF9
00E5FF00C1FF009CFF0076FF0051FF002DFF000CFF1000FF2A00FF3E00FF4D00FF5600FF
5800FF5500FF4C00FF3D00FF2900FF1100FF0009FF0027FF0045FF0063FF0080FF0099FF
00AFFF00C0FF00CBFF00D0FF00CFFF00C8FF00BBFF00AAFF0095FF007EFF0067FF0051FF
003EFF0030FF0028FF0025FF002AFF0033FF0041FF0051FF0061FF006EFF0075FF0075FF
006FFF0066FF005EFF005DFF0062FF0063FF005CFF0052FF004BFF004AFF0050FF005CFF
006BFF007BFF008AFF0094FF009AFF0099FF0091FF0084FF0072FF005DFF0046FF002FFF
001AFF0007FF0500FF0E00FF1000FF0C00FF0200FF000DFF0022FF003AFF0056FF0074FF
0093FF00B0FF00CCFF00E5FF00FAFF00FFF500FFEB00FFE600FFE800FFF000FFFD00EEFF
00D6FF00B9FF0099FF0076FF0051FF002BFF0006FF1E00FF3F00FF5E00FF7900FF9000FF
A100FFAD00FFB200FFB200FFAC00FF9F00FF8D00FF7500FF5800FF3700FF1200FF0016FF
0040FF006DFF0099FF00C6FF00F2FF00FFE300FFBB00FF9700FF7600FF5A00FF4300FF31
00FF2500FF1F00FF2000FF2600FF3200FF4400FF5C00FF7900FF9B00FFC200FFEC00E5FF
00B5FF0082FF004FFF001AFF1900FF4C00FF7E00FFAD00FF
00FFA700FFD600F8FF00C4FF0090FF005CFF0028FF0900FF3A00FF6900FF9400FFBB00FF
DE00FFFC00FFFF00EAFF00D7FF00C9FF00C2FF00C1FF00C5FF00D0FF00E1FF00F7ED00FF
CD00FFAA00FF8300FF5900FF2D00FF0100FF002BFF0058FF0083FF00ACFF00D1FF00F4FF
00FFEE00FFD500FFC100FFB400FFAC00FFAA00FFAF00FFBA00FFCA00FFDF00FFF900E7FF
00C6FF00A2FF007DFF0057FF0032FF000FFF1100FF2F00FF4800FF5D00FF6C00FF7500FF
7700FF7400FF6B00FF5C00FF4800FF3000FF1400FF0008FF0026FF0044FF0061FF007BFF
0090FF00A1FF00ACFF00B1FF00B0FF00A9FF009CFF008BFF0076FF005FFF0048FF0032FF
0020FF0011FF0009FF0007FF000BFF0014FF0022FF0032FF0042FF004FFF0056FF0056FF
0050FF0047FF003FFF003EFF0043FF0044FF003DFF0033FF002CFF002BFF0031FF003DFF
004CFF005CFF006BFF0076FF007BFF007AFF0073FF0065FF0053FF003EFF0027FF0010FF
0400FF1600FF2400FF2C00FF2F00FF2B00FF2100FF1100FF0003FF001CFF0038FF0055FF
0074FF0092FF00ADFF00C6FF00DBFF00EBFF00F5FF00FAFF00F8FF00F1FF00E3FF00D0FF
00B7FF009AFF007AFF0057FF0032FF000CFF1800FF3C00FF5E00FF7D00FF9800FFAF00FF
C000FFCC00FFD100FFD100FFCA00FFBE00FFAC00FF9400FF7700FF5600FF3000FF0800FF
0021FF004EFF007BFF00A7FF00D3FF00FDFF00FFDA00FFB600FF9500FF7900FF6200FF50
00FF4400FF3E00FF3E00FF4500FF5100FF6300FF7B00FF9800FFBA00FFE100F4FF00C6FF
0096FF0064FF0030FF0300FF3800FF6B00FF9D00FFCC00FF
00FFC200FFF100DDFF00A9FF0075FF0041FF000DFF2400FF5500FF8400FFAF00FFD600FF
F900FFFF00E8FF00CFFF00BCFF00AEFF00A7FF00A6FF00AAFF00B5FF00C6FF00DCFF00F7
E800FFC500FF9E00FF7400FF4800FF1C00FF0010FF003DFF0068FF0091FF00B6FF00D9FF
00F6FF00FFF000FFDC00FFCF00FFC700FFC500FFCA00FFD500FFE500FFFA00EBFF00CCFF
00ABFF0087FF0062FF003CFF0017FF0B00FF2C00FF4A00FF6300FF7800FF8700FF9000FF
9200FF8F00FF8600FF7700FF6300FF4B00FF2F00FF1200FF000BFF0029FF0046FF0060FF
0075FF0086FF0091FF0096FF0095FF008EFF0081FF0070FF005BFF0044FF002DFF0017FF
0005FF0900FF1100FF1300FF0F00FF0600FF0007FF0017FF0027FF0034FF003BFF003BFF
0035FF002CFF0024FF0023FF0028FF0029FF0022FF0018FF0011FF0010FF0016FF0022FF
0031FF0041FF0050FF005BFF0060FF005FFF0058FF004AFF0038FF0023FF000CFF0A00FF
1F00FF3100FF3F00FF4700FF4A00FF4600FF3C00FF2C00FF1700FF0001FF001DFF003AFF
0059FF0077FF0092FF00ABFF00C0FF00D0FF00DAFF00DFFF00DDFF00D6FF00C8FF00B5FF
009CFF007FFF005FFF003CFF0017FF0E00FF3300FF5700FF7900FF9800FFB300FFCA00FF
DB00FFE700FFEC00FFEC00FFE500FFD900FFC700FFAF00FF9200FF7100FF4B00FF2300FF
0006FF0033FF0060FF008CFF00B8FF00E2FF00FFF500FFD100FFB000FF9400FF7D00FF6B
00FF5F00FF5900FF5900FF6000FF6C00FF7E00FF9600FFB300FFD500FFFC00D9FF00ABFF
007BFF0049FF0015FF1E00FF5300FF8600FFB800FFE700FF
00FFD800F8FF00C6FF0093FF005FFF002BFF0800FF3B00FF6C00FF9A00FFC500FFEC00FF
FF00F0FF00D1FF00B9FF00A5FF0098FF0091FF008FFF0094FF009FFF00AFFF00C6FF00E1
FF00FFDB00FFB400FF8A00FF5F00FF3200FF0500FF0026FF0051FF007AFF00A0FF00C2FF
00E0FF00F9FF00FFF300FFE500FFDD00FFDC00FFE000FFEB00FFFB00EEFF00D4FF00B6FF
0095FF0071FF004CFF0026FF0001FF2200FF4300FF6000FF7A00FF8E00FF9D00FFA600FF
A900FFA500FF9C00FF8D00FF7900FF6100FF4600FF2800FF0A00FF0013FF0030FF0049FF
005FFF0070FF007BFF0080FF007FFF0078FF006BFF0059FF0045FF002EFF0017FF0001FF
1100FF1F00FF2800FF2A00FF2600FF1C00FF0E00FF0001FF0011FF001DFF0024FF0025FF
001FFF0015FF000DFF000DFF0011FF0012FF000BFF0002FF0400FF0500FF0000FF000CFF
001BFF002BFF003AFF0044FF0049FF0049FF0041FF0034FF0022FF000DFF0900FF2000FF
3600FF4800FF5600FF5E00FF6000FF5C00FF5200FF4300FF2E00FF1500FF0006FF0024FF
0042FF0060FF007CFF0095FF00AAFF00BAFF00C4FF00C9FF00C7FF00BFFF00B1FF009EFF
0086FF0069FF0048FF0025FF0000FF2400FF4A00FF6E00FF9000FFAF00FFCA00FFE000FF
F100FFFD00FFFF00FCFF00FDFC00FFEF00FFDD00FFC500FFA800FF8700FF6200FF3A00FF
0F00FF001CFF0049FF0076FF00A2FF00CCFF00F4FF00FFE700FFC600FFAA00FF9300FF82
00FF7600FF7000FF7000FF7600FF8200FF9400FFAC00FFC900FFEB00EDFF00C3FF0095FF
0065FF0032FF0100FF3500FF6900FF9C00FFCE00FFFE00FF
00FFEA00E6FF00B5FF0082FF004EFF0019FF1900FF4C00FF7D00FFAB00FFD600FFFE00FF
FF00DEFF00C0FF00A7FF0094FF0087FF007FFF007EFF0083FF008EFF009EFF00B4FF00CF
FF00EFEC00FFC500FF9C00FF7000FF4300FF1600FF0015FF0040FF0069FF008FFF00B1FF
00CFFF00E8FF00FBFF00FFF600FFEF00FFED00FFF200FFFC00F2FF00DDFF00C3FF00A5FF
0083FF0060FF003AFF0015FF1000FF3300FF5400FF7200FF8B00FF9F00FFAE00FFB700FF
BA00FFB700FFAD00FF9E00FF8A00FF7200FF5700FF3A00FF1B00FF0002FF001EFF0038FF
004EFF005EFF006AFF006FFF006EFF0066FF005AFF0048FF0033FF001DFF0005FF0F00FF
2200FF3000FF3900FF3B00FF3700FF2D00FF1F00FF0F00FF0000FF000CFF0013FF0014FF
000EFF0004FF0300FF0400FF0000FF0001FF0500FF0F00FF1600FF1600FF1000FF0500FF
000AFF001AFF0028FF0033FF0038FF0037FF0030FF0023FF0011FF0400FF1B00FF3200FF
4700FF5900FF6700FF6F00FF7200FF6E00FF6400FF5400FF3F00FF2600FF0A00FF0013FF
0031FF004FFF006BFF0084FF0098FF00A8FF00B3FF00B7FF00B6FF00AEFF00A0FF008DFF
0074FF0058FF0037FF0014FF1000FF3600FF5B00FF7F00FFA100FFC000FFDB00FFF100FF
FF00FCFF00F1FF00EBFF00EBFF00F2FF00FEEE00FFD600FFBA00FF9800FF7300FF4B00FF
2000FF000BFF0038FF0065FF0091FF00BBFF00E2FF00FFF800FFD800FFBC00FFA500FF93
00FF8700FF8100FF8100FF8700FF9400FFA600FFBE00FFDB00FFFD00DCFF00B1FF0084FF
0053FF0021FF1200FF4600FF7A00FFAE00FFDF00FFFF00F0
00FFF500DBFF00A9FF0076FF0042FF000EFF2500FF5800FF8900FFB700FFE200FFFF00F6
FF00D3FF00B5FF009CFF0088FF007BFF0074FF0072FF0077FF0082FF0093FF00A9FF00C4
FF00E3F800FFD100FFA700FF7C00FF4F00FF2200FF0009FF0034FF005DFF0083FF00A5FF
00C3FF00DCFF00EFFF00FDFF00FFFA00FFF900FFFD00F7FF00E7FF00D1FF00B7FF0099FF
0078FF0054FF002FFF0009FF1B00FF3F00FF6000FF7D00FF9700FFAB00FFBA00FFC300FF
C600FFC200FFB900FFAA00FF9600FF7E00FF6300FF4500FF2700FF0900FF0013FF002CFF
0042FF0053FF005EFF0063FF0062FF005BFF004EFF003DFF0028FF0011FF0500FF1B00FF
2E00FF3C00FF4500FF4700FF4300FF3900FF2B00FF1B00FF0B00FF0000FF0008FF0008FF
0002FF0600FF0F00FF0F00FF0B00FF0A00FF1100FF1A00FF2100FF2200FF1C00FF1000FF
0100FF000EFF001DFF0027FF002DFF002CFF0024FF0017FF0005FF0F00FF2600FF3D00FF
5300FF6500FF7200FF7B00FF7D00FF7900FF6F00FF6000FF4B00FF3200FF1600FF0007FF
0026FF0043FF005FFF0078FF008DFF009DFF00A7FF00ACFF00AAFF00A2FF0095FF0081FF
0069FF004CFF002BFF0008FF1C00FF4100FF6700FF8B00FFAD00FFCC00FFE700FFFD00FF
FF00F1FF00E5FF00DFFF00E0FF00E6FF00F3FA00FFE200FFC500FFA400FF7F00FF5700FF
2C00FF0000FF002CFF0059FF0085FF00AFFF00D7FF00FBFF00FFE300FFC700FFB000FF9F
00FF9300FF8D00FF8D00FF9300FF9F00FFB100FFC900FFE600F7FF00D0FF00A6FF0078FF
0048FF0015FF1E00FF5200FF8600FFB900FFEB00FFFF00E4
00FFFB00D5FF00A3FF0070FF003CFF0008FF2B00FF5E00FF8E00FFBD00FFE800FFFF00F0
FF00CDFF00AFFF0096FF0083FF0075FF006EFF006DFF0071FF007CFF008DFF00A3FF00BE
FF00DEFE00FFD700FFAD00FF8100FF5500FF2800FF0004FF002FFF0058FF007DFF009FFF
00BDFF00D6FF00EAFF00F7FF00FFFF00FFFF00FCFF00F1FF00E1FF00CCFF00B1FF0093FF
0072FF004EFF0029FF0003FF2100FF4500FF6600FF8300FF9D00FFB100FFC000FFC900FF
CB00FFC800FFBF00FFB000FF9C00FF8400FF6900FF4B00FF2D00FF0F00FF000DFF0026FF
003CFF004DFF0058FF005DFF005CFF0055FF0048FF0037FF0022FF000BFF0B00FF2100FF
3400FF4200FF4A00FF4D00FF4800FF3F00FF3100FF2100FF1100FF0400FF0002FF0002FF
0300FF0C00FF1400FF1500FF1000FF0F00FF1600FF2000FF2700FF2800FF2200FF1600FF
0700FF0008FF0017FF0022FF0027FF0026FF001EFF0011FF0000FF1500FF2C00FF4300FF
5800FF6B00FF7800FF8100FF8300FF7F00FF7500FF6500FF5000FF3700FF1C00FF0001FF
0020FF003DFF0059FF0072FF0087FF0097FF00A1FF00A6FF00A4FF009CFF008FFF007BFF
0063FF0046FF0026FF0003FF2100FF4700FF6C00FF9100FFB200FFD100FFEC00FFFF00FC
FF00EBFF00DFFF00DAFF00DAFF00E0FF00EDFF00FFE800FFCB00FFAA00FF8500FF5C00FF
3200FF0500FF0026FF0053FF007FFF00A9FF00D1FF00F5FF00FFE900FFCD00FFB600FFA4
00FF9800FF9200FF9300FF9900FFA500FFB700FFCF00FFEC00F1FF00CAFF00A0FF0072FF
0042FF000FFF2300FF5800FF8C00FFBF00FFF100FFFF00DF
00FFFB00D5FF00A4FF0071FF003DFF0008FF2B00FF5D00FF8E00FFBC00FFE700FFFF00F0
FF00CDFF00AFFF0096FF0083FF0076FF006EFF006DFF0072FF007DFF008DFF00A3FF00BE
FF00DEFD00FFD600FFAD00FF8100FF5400FF2700FF0004FF002FFF0058FF007EFF00A0FF
00BEFF00D6FF00EAFF00F8FF00FFFF00FFFE00FCFF00F2FF00E1FF00CCFF00B2FF0094FF
0072FF004EFF0029FF0004FF2100FF4400FF6500FF8300FF9C00FFB100FFBF00FFC800FF
CB00FFC800FFBE00FFAF00FF9C00FF8300FF6800FF4B00FF2C00FF0E00FF000DFF0027FF
003CFF004DFF0058FF005EFF005CFF0055FF0048FF0037FF0022FF000BFF0B00FF2100FF
3300FF4100FF4A00FF4C00FF4800FF3E00FF3000FF2000FF1100FF0400FF0002FF0003FF
0200FF0C00FF1400FF1500FF1000FF0F00FF1600FF2000FF2700FF2800FF2200FF1600FF
0700FF0009FF0017FF0022FF0027FF0026FF001FFF0012FF0000FF1500FF2C00FF4300FF
5800FF6A00FF7800FF8000FF8300FF7F00FF7500FF6500FF5000FF3700FF1B00FF0002FF
0020FF003EFF005AFF0072FF0087FF0097FF00A2FF00A6FF00A5FF009DFF008FFF007CFF
0063FF0046FF0026FF0003FF2100FF4700FF6C00FF9000FFB200FFD100FFEC00FFFF00FD
FF00EBFF00E0FF00DAFF00DAFF00E1FF00EDFF00FFE800FFCB00FFA900FF8400FF5C00FF
3100FF0500FF0027FF0054FF007FFF00AAFF00D1FF00F6FF00FFE900FFCD00FFB600FFA4
00FF9800FF9200FF9200FF9800FFA500FFB700FFCF00FFEC00F1FF00CBFF00A0FF0073FF
0042FF0010FF2300FF5700FF8B00FFBF00FFF100FFFF00DF
00FFF400DCFF00AAFF0077FF0043FF000FFF2400FF5700FF8800FFB600FFE100FFFF00F7
FF00D4FF00B6FF009DFF0089FF007CFF0075FF0073FF0078FF0083FF0094FF00AAFF00C5
FF00E4F700FFD000FFA600FF7B00FF4E00FF2100FF000AFF0036FF005EFF0084FF00A6FF
00C4FF00DDFF00F0FF00FEFF00FFF900FFF800FFFC00F8FF00E8FF00D2FF00B8FF009AFF
0079FF0055FF0030FF000AFF1A00FF3E00FF5F00FF7C00FF9600FFAA00FFB900FFC200FF
C500FFC100FFB800FFA900FF9500FF7D00FF6200FF4400FF2600FF0800FF0014FF002DFF
0043FF0054FF005FFF0064FF0063FF005CFF004FFF003EFF0029FF0012FF0400FF1A00FF
2D00FF3B00FF4400FF4600FF4200FF3800FF2A00FF1A00FF0A00FF0001FF0009FF0009FF
0003FF0500FF0D00FF0E00FF0A00FF0900FF1000FF1900FF2000FF2100FF1B00FF0F00FF
0000FF000FFF001EFF0028FF002EFF002DFF0025FF0018FF0006FF0E00FF2500FF3C00FF
5200FF6400FF7100FF7A00FF7C00FF7800FF6E00FF5E00FF4A00FF3100FF1500FF0008FF
0027FF0044FF0060FF0079FF008EFF009EFF00A8FF00ADFF00ABFF00A3FF0096FF0082FF
006AFF004DFF002DFF0009FF1B00FF4000FF6600FF8A00FFAC00FFCA00FFE500FFFC00FF
FF00F2FF00E6FF00E0FF00E1FF00E7FF00F4F900FFE100FFC400FFA300FF7E00FF5600FF
2B00FF0000FF002DFF005AFF0086FF00B0FF00D8FF00FCFF00FFE200FFC600FFAF00FF9E
00FF9200FF8C00FF8C00FF9200FF9E00FFB000FFC800FFE500F8FF00D1FF00A7FF0079FF
0049FF0016FF1C00FF5100FF8500FFB800FFEA00FFFF00E5
00FFE800E8FF00B7FF0084FF0050FF001BFF1800FF4A00FF7B00FFA900FFD400FFFC00FF
FF00E0FF00C2FF00A9FF0096FF0089FF0081FF0080FF0085FF008FFF00A0FF00B6FF00D1
FF00F1EA00FFC300FF9A00FF6E00FF4100FF1400FF0017FF0042FF006BFF0091FF00B3FF
00D1FF00E9FF00FDFF00FFF400FFED00FFEB00FFF000FFFA00F4FF00DFFF00C5FF00A7FF
0085FF0061FF003CFF0016FF0E00FF3100FF5200FF7000FF8900FF9E00FFAC00FFB500FF
B800FFB500FFAB00FF9C00FF8900FF7100FF5500FF3800FF1900FF0004FF0020FF003AFF
004FFF0060FF006BFF0071FF006FFF0068FF005BFF004AFF0035FF001EFF0007FF0E00FF
2000FF2E00FF3700FF3900FF3500FF2B00FF1D00FF0D00FF0001FF000EFF0015FF0016FF
0010FF0006FF0100FF0200FF0002FF0003FF0300FF0D00FF1400FF1500FF0F00FF0300FF
000BFF001CFF002AFF0035FF003AFF0039FF0032FF0025FF0013FF0200FF1900FF3000FF
4500FF5700FF6500FF6D00FF7000FF6C00FF6200FF5200FF3D00FF2400FF0800FF0015FF
0033FF0051FF006DFF0085FF009AFF00AAFF00B5FF00B9FF00B8FF00B0FF00A2FF008FFF
0076FF0059FF0039FF0016FF0E00FF3400FF5900FF7D00FF9F00FFBE00FFD900FFEF00FF
FF00FEFF00F3FF00EDFF00EDFF00F4FF00FFEC00FFD500FFB800FF9600FF7100FF4900FF
1E00FF000DFF003AFF0067FF0092FF00BDFF00E4FF00FFF600FFD600FFBA00FFA300FF91
00FF8500FF7F00FF7F00FF8500FF9200FFA400FFBC00FFD900FFFB00DEFF00B3FF0086FF
0055FF0023FF1000FF4400FF7800FFAC00FFDE00FFFF00F2
00FFD500FBFF00C9FF0096FF0062FF002EFF0500FF3800FF6900FF9700FFC200FFE900FF
FF00F3FF00D4FF00BCFF00A8FF009BFF0093FF0092FF0097FF00A2FF00B2FF00C8FF00E4
FC00FFD800FFB100FF8700FF5C00FF2F00FF0200FF0029FF0054FF007DFF00A3FF00C5FF
00E3FF00FCFF00FFF000FFE200FFDA00FFD900FFDE00FFE800FFF800F1FF00D7FF00B9FF
0098FF0074FF004FFF0029FF0004FF1F00FF4000FF5D00FF7700FF8B00FF9A00FFA300FF
A600FFA200FF9900FF8A00FF7600FF5E00FF4300FF2500FF0700FF0016FF0032FF004CFF
0062FF0073FF007EFF0083FF0082FF007BFF006EFF005CFF0048FF0031FF001AFF0004FF
0E00FF1C00FF2500FF2700FF2300FF1900FF0B00FF0004FF0014FF0020FF0027FF0028FF
0022FF0018FF0010FF0010FF0014FF0015FF000EFF0005FF0100FF0200FF0003FF000EFF
001EFF002EFF003CFF0047FF004CFF004BFF0044FF0037FF0025FF0010FF0600FF1D00FF
3300FF4500FF5300FF5B00FF5D00FF5900FF4F00FF4000FF2B00FF1200FF0009FF0027FF
0045FF0063FF007FFF0098FF00ADFF00BCFF00C7FF00CBFF00CAFF00C2FF00B4FF00A1FF
0089FF006CFF004BFF0028FF0003FF2100FF4700FF6B00FF8D00FFAC00FFC700FFDD00FF
EE00FFFA00FFFF00FFFF00FFF900FFEC00FFDA00FFC200FFA500FF8400FF5F00FF3700FF
0C00FF001FFF004CFF0079FF00A5FF00CFFF00F7FF00FFE400FFC400FFA700FF9000FF7F
00FF7300FF6D00FF6D00FF7300FF7F00FF9200FFA900FFC600FFE900F0FF00C6FF0098FF
0067FF0035FF0001FF3200FF6600FF9900FFCB00FFFB00FF
00FFBE00FFED00E1FF00AEFF007AFF0045FF0012FF2000FF5100FF7F00FFAA00FFD200FF
F500FFFF00ECFF00D3FF00C0FF00B3FF00ABFF00AAFF00AFFF00BAFF00CAFF00E0FF00FB
E400FFC000FF9900FF6F00FF4400FF1700FF0015FF0041FF006CFF0095FF00BBFF00DDFF
00FBFF00FFEB00FFD800FFCA00FFC300FFC100FFC600FFD000FFE000FFF600EFFF00D1FF
00AFFF008CFF0066FF0041FF001CFF0700FF2800FF4600FF5F00FF7300FF8200FF8B00FF
8E00FF8B00FF8100FF7200FF5E00FF4600FF2B00FF0E00FF0010FF002EFF004AFF0064FF
007AFF008AFF0096FF009BFF009AFF0092FF0086FF0074FF005FFF0049FF0031FF001CFF
0009FF0400FF0D00FF0F00FF0B00FF0100FF000CFF001CFF002BFF0038FF003FFF0040FF
003AFF0030FF0028FF0027FF002CFF002DFF0026FF001CFF0016FF0015FF001BFF0026FF
0036FF0046FF0054FF005FFF0064FF0063FF005CFF004FFF003DFF0027FF0010FF0600FF
1B00FF2D00FF3B00FF4300FF4500FF4200FF3800FF2800FF1300FF0005FF0021FF003FFF
005DFF007BFF0097FF00B0FF00C4FF00D4FF00DFFF00E3FF00E2FF00DAFF00CCFF00B9FF
00A0FF0084FF0063FF0040FF001BFF0900FF2F00FF5300FF7500FF9400FFAF00FFC500FF
D600FFE200FFE800FFE800FFE100FFD500FFC200FFAA00FF8E00FF6C00FF4700FF1F00FF
000BFF0037FF0064FF0091FF00BDFF00E7FF00FFF100FFCC00FFAC00FF9000FF7900FF67
00FF5B00FF5500FF5500FF5B00FF6800FF7A00FF9100FFAF00FFD100FFF700DDFF00B0FF
007FFF004DFF0019FF1A00FF4E00FF8200FFB300FFE300FF
00FFA100FFD000FEFF00CBFF0097FF0062FF002EFF0300FF3400FF6200FF8D00FFB500FF
D800FFF600FFFF00F0FF00DDFF00D0FF00C8FF00C7FF00CCFF00D7FF00E7FF00FDE700FF
C700FFA300FF7C00FF5300FF2700FF0005FF0032FF005EFF0089FF00B2FF00D8FF00FAFF
00FFE700FFCF00FFBB00FFAD00FFA600FFA400FFA900FFB300FFC400FFD900FFF300EEFF
00CCFF00A8FF0083FF005EFF0038FF0015FF0B00FF2900FF4200FF5700FF6500FF6E00FF
7100FF6E00FF6400FF5500FF4200FF2900FF0E00FF000EFF002DFF004BFF0067FF0081FF
0096FF00A7FF00B2FF00B8FF00B6FF00AFFF00A2FF0091FF007CFF0065FF004EFF0038FF
0026FF0018FF000FFF000DFF0011FF001BFF0029FF0039FF0048FF0055FF005CFF005DFF
0057FF004DFF0045FF0044FF0049FF004AFF0043FF0039FF0032FF0031FF0037FF0043FF
0052FF0063FF0071FF007CFF0081FF0080FF0079FF006CFF005AFF0044FF002DFF0016FF
0001FF1000FF1E00FF2600FF2900FF2500FF1B00FF0B00FF0009FF0022FF003EFF005CFF
007AFF0098FF00B4FF00CCFF00E1FF00F1FF00FCFF00FFFF00FFFF00F7FF00E9FF00D6FF
00BDFF00A0FF0080FF005DFF0038FF0012FF1200FF3600FF5800FF7700FF9200FFA800FF
BA00FFC500FFCB00FFCB00FFC400FFB800FFA500FF8E00FF7100FF4F00FF2A00FF0200FF
0028FF0054FF0081FF00AEFF00DAFF00FFFB00FFD400FFAF00FF8F00FF7300FF5C00FF4A
00FF3E00FF3800FF3800FF3E00FF4B00FF5D00FF7500FF9200FFB400FFDA00FAFF00CDFF
009CFF006AFF0036FF0002FF3100FF6500FF9700FFC600FF
00FF7F00FFAE00FFE000ECFF00B8FF0084FF0050FF001DFF1300FF4100FF6C00FF9300FF
B600FFD500FFED00FFFF00FEFF00F1FF00E9FF00E8FF00EDFF00F8F700FFE100FFC500FF
A600FF8200FF5B00FF3100FF0600FF0026FF0053FF007FFF00AAFF00D3FF00F9FF00FFE4
00FFC600FFAD00FF9A00FF8C00FF8400FF8300FF8800FF9200FFA200FFB800FFD200FFF0
00EEFF00CAFF00A5FF007FFF005AFF0036FF0015FF0700FF2100FF3500FF4400FF4D00FF
5000FF4C00FF4300FF3400FF2000FF0800FF0012FF0030FF004EFF006CFF0088FF00A2FF
00B8FF00C9FF00D4FF00D9FF00D8FF00D1FF00C4FF00B2FF009EFF0087FF0070FF005AFF
0047FF0039FF0030FF002EFF0032FF003CFF004AFF005AFF006AFF0076FF007DFF007EFF
0078FF006EFF0066FF0066FF006AFF006BFF0064FF005BFF0054FF0053FF0059FF0064FF
0074FF0084FF0093FF009DFF00A2FF00A1FF009AFF008DFF007BFF0066FF004FFF0038FF
0022FF0010FF0002FF0500FF0700FF0300FF0006FF0015FF002AFF0043FF005FFF007DFF
009BFF00B9FF00D5FF00EEFF00FFFC00FFED00FFE200FFDE00FFDF00FFE700FFF500F7FF
00DFFF00C2FF00A1FF007EFF0059FF0034FF000EFF1500FF3700FF5600FF7100FF8700FF
9800FFA400FFAA00FFA900FFA300FF9600FF8400FF6C00FF4F00FF2E00FF0900FF001EFF
0049FF0075FF00A2FF00CFFF00FBFF00FFDA00FFB200FF8E00FF6E00FF5100FF3A00FF29
00FF1D00FF1700FF1700FF1D00FF2900FF3B00FF5300FF7000FF9300FFB900FFE300EEFF
00BDFF008BFF0057FF0023FF1000FF4300FF7500FFA500FF
00FF5A00FF8900FFBB00FFEE00DDFF00A9FF0075FF0042FF0011FF1C00FF4700FF6E00FF
9100FFAF00FFC800FFDC00FFE900FFF000FFF200FFED00FFE200FFD100FFBB00FFA000FF
8100FF5D00FF3600FF0C00FF001EFF004BFF0078FF00A5FF00D0FF00F8FF00FFE100FFBF
00FFA100FF8800FF7500FF6700FF5F00FF5E00FF6200FF6D00FF7D00FF9300FFAD00FFCB
00FFEC00EFFF00CAFF00A4FF007FFF005BFF003AFF001DFF0003FF1000FF1F00FF2800FF
2B00FF2700FF1E00FF0F00FF0004FF001CFF0037FF0055FF0073FF0091FF00AEFF00C7FF
00DDFF00EEFF00F9FF00FEFF00FDFF00F6FF00E9FF00D8FF00C3FF00ACFF0095FF007FFF
006CFF005EFF0056FF0053FF0057FF0061FF006FFF007FFF008FFF009BFF00A3FF00A3FF
009DFF0094FF008CFF008BFF008FFF0091FF0089FF0080FF0079FF0078FF007EFF008AFF
0099FF00A9FF00B8FF00C2FF00C8FF00C7FF00BFFF00B2FF00A0FF008BFF0074FF005DFF
0047FF0035FF0028FF001FFF001DFF0021FF002BFF003BFF004FFF0068FF0084FF00A2FF
00C1FF00DEFF00FAFF00FFEC00FFD700FFC700FFBD00FFB800FFBA00FFC200FFCF00FFE3
00FFFB00E7FF00C7FF00A3FF007EFF0059FF0033FF000FFF1200FF3000FF4B00FF6200FF
7300FF7F00FF8500FF8400FF7E00FF7100FF5F00FF4700FF2A00FF0900FF001BFF0044FF
006EFF009AFF00C7FF00F4FF00FFDF00FFB500FF8D00FF6900FF4800FF2C00FF1500FF04
07FF000DFF000DFF0007FF0000FF0400FF1600FF2E00FF4B00FF6D00FF9400FFBE00FFEC
00E3FF00B0FF007DFF0048FF0014FF1E00FF5000FF8000FF
00FF3200FF6100FF9200FFC600FFFA00D1FF009DFF006BFF003AFF000BFF1F00FF4600FF
6900FF8700FFA000FFB300FFC100FFC800FFC900FFC500FFBA00FFA900FF9300FF7800FF
5800FF3500FF0E00FF001BFF0047FF0073FF00A0FF00CDFF00F8FF00FFDE00FFB900FF96
00FF7900FF6000FF4C00FF3F00FF3700FF3600FF3A00FF4500FF5500FF6A00FF8400FFA3
00FFC400FFE800F2FF00CCFF00A7FF0084FF0063FF0045FF002CFF0017FF0008FF0000FF
0200FF0000FF0009FF0018FF002CFF0044FF0060FF007DFF009BFF00B9FF00D6FF00F0FF
00FFFA00FFE900FFDE00FFD900FFDA00FFE100FFEE00FFFF00EBFF00D4FF00BDFF00A7FF
0095FF0086FF007EFF007CFF0080FF0089FF0097FF00A7FF00B7FF00C4FF00CBFF00CBFF
00C5FF00BCFF00B4FF00B3FF00B8FF00B9FF00B2FF00A8FF00A1FF00A0FF00A6FF00B2FF
00C1FF00D1FF00E0FF00EBFF00F0FF00EFFF00E8FF00DAFF00C8FF00B3FF009CFF0085FF
0070FF005EFF0050FF0048FF0045FF0049FF0053FF0063FF0078FF0091FF00ADFF00CAFF
00E9FF00FFF800FFDD00FFC400FFAF00FF9F00FF9500FF9000FF9200FF9900FFA700FFBA
00FFD300FFF000EFFF00CCFF00A7FF0081FF005CFF0038FF0016FF0800FF2300FF3A00FF
4B00FF5700FF5C00FF5C00FF5600FF4900FF3700FF1F00FF0200FF001EFF0044FF006CFF
0096FF00C3FF00F0FF00FFE300FFB700FF8D00FF6500FF4100FF2000FF0412FF0024FF00
30FF0036FF0036FF002FFF0023FF0011FF0000FF0600FF2300FF4500FF6C00FF9600FFC4
00FFF400D9FF00A5FF0071FF003CFF0009FF2800FF5700FF
00FF0700FF3600FF6800FF9B00FFCF00FCFF00C8FF0095FF0064FF0036FF000BFF1B00FF
3E00FF5C00FF7500FF8900FF9600FF9D00FF9F00FF9A00FF8F00FF7E00FF6800FF4D00FF
2E00FF0A00FF001CFF0046FF0071FF009EFF00CBFF00F7FF00FFDD00FFB400FF8E00FF6C
00FF4E00FF3500FF2200FF1400FF0C00FF0B00FF0F00FF1A00FF2A00FF4000FF5A00FF78
00FF9900FFBD00FFE200F7FF00D2FF00AEFF008DFF0070FF0056FF0042FF0033FF002AFF
0027FF002BFF0034FF0043FF0057FF006FFF008AFF00A8FF00C6FF00E4FF00FFFE00FFE5
00FFCF00FFBE00FFB300FFAE00FFAF00FFB600FFC300FFD400FFE900FFFF00E8FF00D2FF
00BFFF00B1FF00A8FF00A6FF00AAFF00B4FF00C2FF00D2FF00E2FF00EEFF00F6FF00F6FF
00F0FF00E7FF00DEFF00DEFF00E2FF00E3FF00DCFF00D3FF00CCFF00CBFF00D1FF00DDFF
00ECFF00FCFF00FFF400FFEA00FFE400FFE500FFED00FFFA00F3FF00DEFF00C7FF00B0FF
009AFF0088FF007BFF0072FF0070FF0074FF007EFF008EFF00A2FF00BBFF00D7FF00F5FF
00FFEB00FFCE00FFB200FF9900FF8400FF7400FF6A00FF6500FF6700FF6F00FF7C00FF90
00FFA800FFC500FFE600F6FF00D1FF00ACFF0086FF0062FF0040FF0021FF0006FF0F00FF
2000FF2C00FF3200FF3100FF2B00FF1E00FF0C00FF000BFF0028FF0049FF006EFF0096FF
00C1FF00EDFF00FFE500FFB800FF8C00FF6200FF3A00FF160AFF0026FF003DFF004EFF00
5AFF0060FF0060FF005AFF004EFF003CFF0024FF0007FF0000FF1A00FF4100FF6B00FF99
00FFC900FFFC00CFFF009BFF0067FF0034FF0002FF2D00FF
24FF0000FF0A00FF3C00FF6F00FFA300FFD700F4FF00C1FF0091FF0062FF0037FF0010FF
1200FF3000FF4900FF5C00FF6A00FF7100FF7200FF6E00FF6300FF5200FF3C00FF2100FF
0100FF0021FF0048FF0072FF009EFF00CAFF00F7FF00FFDB00FFB000FF8800FF6200FF40
00FF2200FF0909FF0017FF001FFF0020FF001CFF0011FF0001FF0000FF1300FF2E00FF4C
00FF6D00FF9100FFB600FFDC00FEFF00DAFF00B9FF009CFF0082FF006EFF005FFF0056FF
0054FF0057FF0060FF006FFF0083FF009BFF00B6FF00D4FF00F2FF00FFEF00FFD200FFB9
00FFA300FF9200FF8700FF8200FF8300FF8A00FF9700FFA800FFBD00FFD400FFEB00FEFF
00EBFF00DDFF00D5FF00D2FF00D7FF00E0FF00EEFF00FEFF00FFF100FFE400FFDD00FFDD
00FFE300FFEC00FFF400FFF500FFF000FFEF00FFF600FFFF00F8FF00F7FF00FDFF00FFF6
00FFE700FFD700FFC800FFBE00FFB800FFB900FFC100FFCE00FFE000FFF500F3FF00DCFF
00C7FF00B4FF00A7FF009EFF009CFF00A0FF00AAFF00BAFF00CFFF00E7FF00FFFC00FFDE
00FFBF00FFA200FF8600FF6D00FF5800FF4800FF3E00FF3900FF3B00FF4300FF5000FF64
00FF7C00FF9900FFB900FFDC00FEFF00D8FF00B3FF008EFF006DFF004EFF0033FF001CFF
000BFF0000FF0500FF0500FF0000FF000DFF001FFF0037FF0054FF0075FF009AFF00C3FF
00EDFF00FFE500FFB900FF8C00FF6000FF3600FF0E15FF0036FF0052FF0069FF007BFF00
87FF008DFF008CFF0086FF007AFF0068FF0050FF0033FF0011FF0000FF1500FF3F00FF6D
00FF9D00FFD000FCFF00C7FF0093FF0060FF002EFF0000FF
51FF0022FF0000FF0F00FF4200FF7600FFAA00FFDE00EEFF00BDFF008FFF0064FF003DFF
001AFF0300FF1C00FF2F00FF3D00FF4400FF4600FF4100FF3600FF2500FF0F00FF000BFF
002AFF004EFF0075FF009FFF00CBFF00F7FF00FFDB00FFAE00FF8300FF5B00FF3500FF13
0AFF0023FF0036FF0044FF004CFF004DFF0049FF003EFF002EFF0018FF0000FF0100FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF800E6FF00C9FF00AFFF009BFF008CFF0083FF
0080FF0084FF008DFF009CFF00B0FF00C8FF00E3FF00FFFE00FFE000FFC200FFA500FF8C
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE700FFF500FFFD00FFFF00FFFC00FFF200FFE400FFD400FFC400FFB800FFB000FFB0
00FFB600FFBF00FFC700FFC800FFC300FFC200FFC900FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9100FF8B00FF8C00FF9400FFA100FFB300FFC800FFDF00FFF6
00F4FF00E1FF00D4FF00CBFF00C9FF00CDFF00D7FF00E7FF00FBFF00FFEB00FFCF00FFB1
00FF9200FF7500FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1600FF2300FF37
00FF4F00FF6C00FF8C00FFB000FFD400FFFA00E0FF00BBFF0099FF007BFF0060FF0049FF
0038FF002CFF0026FF0027FF002DFF003AFF004CFF0064FF0081FF00A2FF00C7FF00F0FF
00FFE500FFB900FF8C00FF5F00FF3300FF091EFF0042FF0063FF007FFF0096FF00A7FF00
B3FF00B9FF00B9FF00B3FF00A7FF0095FF007DFF0060FF003EFF0017FF0000FF1200FF40
00FF7000FFA300FFD600F4FF00C0FF008DFF005BFF002BFF
7EFF004FFF001DFF0000FF1500FF4900FF7D00FFB100FFE400EAFF00BCFF0091FF006AFF
0047FF0028FF0010FF0300FF1000FF1700FF1900FF1400FF0900FF0006FF001DFF0038FF
0057FF007BFF00A2FF00CCFF00F7FF00FFDB00FFAE00FF8200FF5700FF2E00FF0819FF00
37FF0050FF0063FF0071FF0079FF007AFF0076FF006BFF005BFF0045FF002BFF000DFF00
00FF1300FF3700FF5C00FF8200FFA700FFCB00FFEC00F6FF00DCFF00C8FF00B9FF00B0FF
00ADFF00B1FF00BAFF00C9FF00DDFF00F5FF00FFEF00FFD100FFB300FF9500FF7800FF5F
00FF4900FF3800FF2D00FF2800FF2900FF3000FF3D00FF4F00FF6300FF7A00FF9100FFA7
00FFBA00FFC800FFD100FFD300FFCF00FFC500FFB700FFA700FF9700FF8B00FF8400FF83
00FF8900FF9300FF9B00FF9B00FF9700FF9600FF9D00FFA600FFAD00FFAE00FFA800FF9C
00FF8D00FF7D00FF6E00FF6400FF5F00FF5F00FF6700FF7400FF8600FF9B00FFB200FFC9
00FFDF00FFF100FFFF00F8FF00F6FF00FAFF00FFFB00FFEC00FFD700FFBE00FFA200FF84
00FF6600FF4800FF2C00FF1301FF0011FF001BFF0020FF001EFF0016FF0008FF0000FF0A
00FF2200FF3F00FF6000FF8300FFA800FFCD00FFF300E8FF00C6FF00A7FF008CFF0076FF
0065FF0059FF0053FF0054FF005AFF0067FF0079FF0091FF00AEFF00CFFF00F4FF00FFE3
00FFB800FF8C00FF5F00FF3200FF0623FF004BFF006FFF0090FF00ACFF00C3FF00D4FF00
E0FF00E6FF00E6FF00E0FF00D4FF00C2FF00AAFF008DFF006BFF0044FF001AFF0000FF13
00FF4300FF7600FFAA00FFDE00EDFF00BAFF0088FF0058FF
AAFF007AFF0049FF0016FF0000FF1D00FF5100FF8500FFB800FFE900E8FF00BDFF0095FF
0073FF0054FF003BFF0028FF001BFF0013FF0012FF0017FF0022FF0032FF0048FF0063FF
0083FF00A7FF00CEFF00F8FF00FFDC00FFAF00FF8200FF5600FF2B00FF0223FF0045FF00
63FF007CFF008FFF009DFF00A4FF00A6FF00A1FF0097FF0087FF0071FF0057FF0039FF00
17FF0000FF0B00FF3100FF5600FF7B00FF9F00FFC000FFDE00FFF700F4FF00E5FF00DCFF
00D9FF00DDFF00E6FF00F5FF00FFF600FFDE00FFC300FFA500FF8700FF6900FF4D00FF33
00FF1D00FF0C00FF0103FF0002FF0000FF0500FF1100FF2300FF3800FF4E00FF6500FF7B
00FF8E00FF9C00FFA500FFA700FFA300FF9900FF8B00FF7B00FF6B00FF5F00FF5800FF57
00FF5D00FF6700FF6F00FF6F00FF6B00FF6A00FF7100FF7A00FF8100FF8200FF7C00FF71
00FF6100FF5100FF4300FF3800FF3300FF3400FF3B00FF4800FF5A00FF6F00FF8600FF9D
00FFB300FFC500FFD300FFDB00FFDD00FFD900FFCF00FFC000FFAB00FF9200FF7600FF58
00FF3A00FF1C00FF0018FF002CFF003CFF0047FF004BFF004AFF0042FF0034FF0021FF00
09FF0000FF1300FF3400FF5700FF7C00FFA100FFC700FFEB00F2FF00D3FF00B8FF00A2FF
0091FF0085FF007FFF007FFF0086FF0092FF00A5FF00BDFF00DAFF00FBFF00FFDF00FFB7
00FF8C00FF6000FF3300FF0625FF004FFF0077FF009BFF00BBFF00D7FF00EFFF00FFFF00
FFF300FFED00FFED00FFF300FFFF00EDFF00D6FF00B8FF0096FF0070FF0045FF0018FF00
00FF1800FF4A00FF7E00FFB200FFE600E6FF00B4FF0084FF
D4FF00A5FF0073FF0040FF000CFF0000FF2700FF5B00FF8E00FFBF00FFED00E7FF00C0FF
009DFF007FFF0066FF0052FF0045FF003EFF003CFF0041FF004CFF005CFF0073FF008EFF
00ADFF00D1FF00F8FF00FFDD00FFB200FF8500FF5800FF2C00FF0127FF004DFF006FFF00
8DFF00A6FF00B9FF00C7FF00CFFF00D0FF00CCFF00C1FF00B1FF009BFF0081FF0063FF00
42FF001EFF0000FF0600FF2C00FF5100FF7500FF9600FFB300FFCD00FFE100FFF000FFF9
00FFFC00FFF800FFEF00FFE000FFCC00FFB400FF9900FF7B00FF5D00FF3F00FF2200FF09
0CFF001DFF0028FF002DFF002CFF0025FF0018FF0006FF0000FF0D00FF2400FF3B00FF51
00FF6400FF7200FF7B00FF7D00FF7900FF6F00FF6100FF5100FF4100FF3500FF2E00FF2D
00FF3300FF3C00FF4500FF4500FF4100FF4000FF4700FF5000FF5700FF5800FF5200FF46
00FF3700FF2700FF1800FF0E00FF0800FF0900FF1100FF1E00FF3000FF4500FF5C00FF73
00FF8900FF9B00FFA900FFB100FFB300FFAF00FFA500FF9600FF8100FF6800FF4C00FF2E
00FF100DFF0029FF0042FF0057FF0067FF0071FF0076FF0074FF006CFF005EFF004BFF00
33FF0016FF0000FF0A00FF2D00FF5200FF7700FF9D00FFC100FFE300FDFF00E2FF00CCFF
00BBFF00AFFF00A9FF00AAFF00B0FF00BDFF00CFFF00E7FF00FFFB00FFDA00FFB500FF8D
00FF6200FF3600FF0923FF004FFF0079FF00A1FF00C5FF00E6FF00FFFD00FFE600FFD500
FFC900FFC300FFC300FFC900FFD500FFE700FFFF00E3FF00C1FF009AFF0070FF0042FF00
12FF0000FF2000FF5400FF8800FFBC00FFEF00DEFF00AEFF
FBFF00CCFF009BFF0068FF0034FF0000FF0000FF3400FF6600FF9700FFC500FFF000E7FF
00C4FF00A6FF008DFF007AFF006DFF0065FF0064FF0069FF0074FF0084FF009AFF00B5FF
00D5FF00F9FF00FFDF00FFB600FF8A00FF5D00FF3000FF0426FF004FFF0075FF0097FF00
B5FF00CDFF00E1FF00EFFF00F6FF00F8FF00F3FF00E9FF00D8FF00C3FF00A9FF008BFF00
69FF0045FF0020FF0000FF0400FF2A00FF4D00FF6E00FF8C00FFA500FFBA00FFC800FFD1
00FFD400FFD100FFC700FFB800FFA500FF8C00FF7100FF5400FF3500FF1704FF001EFF00
33FF0044FF004FFF0055FF0053FF004CFF003FFF002EFF0019FF0002FF0000FF1400FF2A
00FF3C00FF4A00FF5300FF5500FF5100FF4700FF3900FF2900FF1A00FF0D00FF0600FF05
00FF0B00FF1500FF1D00FF1E00FF1900FF1800FF1F00FF2900FF3000FF3100FF2B00FF1F
00FF1000FF000EFF0019FF001EFF001DFF0016FF0009FF0000FF0800FF1E00FF3500FF4C
00FF6100FF7300FF8100FF8900FF8C00FF8800FF7E00FF6E00FF5900FF4000FF2400FF06
17FF0035FF0051FF0069FF007EFF008EFF0099FF009DFF009CFF0094FF0086FF0073FF00
5AFF003DFF001DFF0000FF0500FF2A00FF5000FF7500FF9900FFBB00FFDA00FFF500F4FF
00E2FF00D7FF00D1FF00D1FF00D8FF00E4FF00F7FF00FFF100FFD400FFB200FF8D00FF65
00FF3A00FF0E1EFF004BFF0077FF00A1FF00C8FF00EDFF00FFF200FFD600FFBF00FFAD00
FFA100FF9B00FF9B00FFA100FFAE00FFC000FFD800FFF500E8FF00C2FF0097FF006AFF00
39FF0007FF0000FF2C00FF6000FF9400FFC800FFFA00D6FF
FFDF00F1FF00BFFF008CFF0058FF0024FF0000FF0F00FF4200FF7300FFA100FFCC00FFF3
00E9FF00CBFF00B2FF009EFF0091FF008AFF0088FF008DFF0098FF00A8FF00BFFF00DAFF
00F9FF00FFE200FFBB00FF9100FF6600FF3900FF0C1FFF004AFF0073FF0099FF00BBFF00
D9FF00F2FF00FFFA00FFEC00FFE400FFE300FFE700FFF200FDFF00E7FF00CDFF00AFFF00
8EFF006AFF0045FF001FFF0000FF0500FF2900FF4A00FF6700FF8100FF9500FFA400FFAD
00FFB000FFAC00FFA300FF9400FF8000FF6800FF4D00FF2F00FF110CFF0029FF0042FF00
58FF0069FF0074FF0079FF0078FF0071FF0064FF0052FF003EFF0027FF0010FF0000FF05
00FF1800FF2600FF2F00FF3100FF2D00FF2300FF1500FF050AFF0016FF001EFF001EFF00
18FF000FFF0006FF0006FF000AFF000BFF0004FF0000FF0400FF0B00FF0C00FF0605FF00
14FF0024FF0033FF003DFF0043FF0042FF003AFF002DFF001BFF0006FF0000FF1000FF27
00FF3D00FF4F00FF5D00FF6500FF6700FF6300FF5900FF4A00FF3500FF1C00FF001DFF00
3BFF0059FF0075FF008EFF00A3FF00B3FF00BDFF00C2FF00C0FF00B8FF00AAFF0097FF00
7FFF0062FF0041FF001EFF0000FF0600FF2B00FF5100FF7500FF9700FFB600FFD100FFE7
00FFF800FBFF00F5FF00F6FF00FCFF00FFF600FFE400FFCC00FFAF00FF8E00FF6900FF41
00FF1615FF0042FF006FFF009BFF00C5FF00EDFF00FFEE00FFCD00FFB100FF9A00FF8900
FF7D00FF7700FF7700FF7D00FF8900FF9B00FFB300FFD000FFF200E6FF00BCFF008EFF00
5EFF002BFF0000FF0800FF3C00FF7000FFA300FFD500FAFF
FFBF00FFEE00E0FF00ADFF0079FF0044FF0010FF0000FF2100FF5200FF8000FFAC00FFD3
00FFF600EBFF00D2FF00BFFF00B1FF00AAFF00A9FF00AEFF00B8FF00C9FF00DFFF00FAFF
00FFE500FFC100FF9A00FF7100FF4500FF1814FF0040FF006BFF0094FF00BAFF00DCFF00
F9FF00FFED00FFD900FFCC00FFC400FFC200FFC700FFD200FFE200FFF700EEFF00CFFF00
AEFF008AFF0065FF003FFF001AFF0000FF0800FF2900FF4700FF6000FF7500FF8300FF8C
00FF8F00FF8C00FF8200FF7400FF6000FF4800FF2C00FF0F0FFF002DFF0049FF0063FF00
78FF0089FF0094FF0099FF0098FF0091FF0084FF0073FF005EFF0047FF0030FF001AFF00
08FF0000FF0600FF0E00FF1000FF0C00FF020AFF001BFF002AFF0037FF003EFF003EFF00
39FF002FFF0027FF0026FF002BFF002CFF0025FF001BFF0014FF0013FF0019FF0025FF00
34FF0045FF0053FF005EFF0063FF0062FF005BFF004EFF003CFF0026FF000FFF0000FF07
00FF1C00FF2E00FF3C00FF4400FF4700FF4300FF3900FF2900FF1404FF0020FF003EFF00
5CFF007AFF0096FF00AEFF00C3FF00D3FF00DEFF00E2FF00E0FF00D9FF00CBFF00B8FF00
9FFF0082FF0062FF003FFF001AFF0000FF0B00FF3000FF5400FF7600FF9500FFB000FFC6
00FFD800FFE300FFE900FFE900FFE200FFD600FFC400FFAC00FF8F00FF6E00FF4800FF20
0AFF0036FF0063FF0090FF00BBFF00E6FF00FFF200FFCD00FFAD00FF9100FF7A00FF6800
FF5C00FF5600FF5600FF5D00FF6900FF7B00FF9300FFB000FFD200FFF800DCFF00AEFF00
7EFF004CFF0018FF0000FF1B00FF4F00FF8300FFB500FFE4
FFA300FFD200FCFF00C9FF0095FF0060FF002CFF0000FF0500FF3600FF6400FF9000FFB7
00FFDA00FFF800EEFF00DBFF00CDFF00C6FF00C5FF00CAFF00D4FF00E5FF00FBFF00FFE9
00FFC900FFA500FF7E00FF5500FF2903FF0030FF005CFF0087FF00B0FF00D6FF00F8FF00
FFE900FFD100FFBD00FFB000FFA800FFA600FFAB00FFB500FFC600FFDB00FFF500ECFF00
CAFF00A6FF0081FF005BFF0036FF0013FF0000FF0D00FF2B00FF4400FF5900FF6700FF70
00FF7300FF7000FF6600FF5800FF4400FF2C00FF100CFF002BFF0049FF0065FF007FFF00
94FF00A5FF00B0FF00B6FF00B4FF00ADFF00A0FF008FFF007AFF0063FF004CFF0036FF00
24FF0016FF000DFF000BFF000FFF0019FF0026FF0037FF0046FF0053FF005AFF005AFF00
55FF004BFF0043FF0042FF0047FF0048FF0041FF0037FF0030FF002FFF0035FF0041FF00
50FF0061FF006FFF007AFF007FFF007EFF0077FF006AFF0058FF0042FF002BFF0014FF00
00FF0000FF1200FF2000FF2800FF2B00FF2700FF1D00FF0D07FF0020FF003CFF005AFF00
78FF0096FF00B2FF00CAFF00DFFF00EFFF00FAFF00FEFF00FDFF00F5FF00E7FF00D4FF00
BBFF009EFF007EFF005BFF0036FF0010FF0000FF1400FF3800FF5A00FF7900FF9400FFAA
00FFBC00FFC700FFCD00FFCD00FFC600FFBA00FFA700FF9000FF7300FF5100FF2C00FF04
26FF0052FF007FFF00ACFF00D7FF00FFFD00FFD600FFB100FF9100FF7500FF5E00FF4C00
FF4000FF3A00FF3A00FF4000FF4D00FF5F00FF7700FF9400FFB600FFDC00F8FF00CAFF00
9AFF0068FF0034FF0000FF0000FF3300FF6700FF9900FFC8
FF8C00FFBB00FFEC00E0FF00ACFF0077FF0043FF0011FF0000FF1F00FF4D00FF7800FFA0
00FFC300FFE100FFFA00F2FF00E5FF00DDFF00DCFF00E1FF00ECFF00FCFF00FFED00FFD2
00FFB200FF8E00FF6700FF3E00FF121AFF0047FF0073FF009EFF00C7FF00EDFF00FFF000
FFD200FFBA00FFA600FF9800FF9100FF8F00FF9400FF9E00FFAF00FFC400FFDE00FFFC00
E1FF00BDFF0098FF0073FF004DFF002AFF0009FF0000FF1400FF2D00FF4200FF5000FF59
00FF5C00FF5900FF4F00FF4000FF2D00FF1406FF0023FF0042FF0060FF007CFF0096FF00
ABFF00BCFF00C7FF00CDFF00CBFF00C4FF00B7FF00A6FF0091FF007AFF0063FF004DFF00
3BFF002DFF0024FF0022FF0026FF0030FF003EFF004EFF005DFF006AFF0071FF0072FF00
6CFF0062FF005AFF0059FF005EFF005FFF0058FF004EFF0047FF0046FF004CFF0058FF00
67FF0078FF0086FF0091FF0096FF0095FF008EFF0081FF006FFF0059FF0042FF002BFF00
16FF0004FF0000FF0900FF1100FF1400FF1000FF0609FF001EFF0037FF0053FF0071FF00
8FFF00ADFF00C9FF00E1FF00F6FF00FFF900FFEE00FFEA00FFEB00FFF300FEFF00EBFF00
D2FF00B5FF0095FF0072FF004DFF0027FF0002FF0000FF2100FF4300FF6200FF7D00FF93
00FFA500FFB000FFB600FFB600FFAF00FFA300FF9000FF7900FF5C00FF3A00FF1512FF00
3DFF0069FF0096FF00C3FF00EFFF00FFE600FFBF00FF9A00FF7A00FF5E00FF4700FF3500
FF2900FF2300FF2300FF2900FF3600FF4800FF6000FF7D00FF9F00FFC500FFF000E2FF00
B1FF007FFF004BFF0017FF0000FF1C00FF5000FF8200FFB1
FF7A00FFA900FFDB00F1FF00BDFF0089FF0055FF0022FF0000FF0D00FF3C00FF6700FF8E
00FFB100FFCF00FFE800FFFB00F6FF00EFFF00EEFF00F2FF00FDFF00FFF100FFDB00FFC0
00FFA000FF7D00FF5600FF2C00FF002BFF0058FF0085FF00B0FF00D9FF00FEFF00FFDF00
FFC100FFA800FF9400FF8700FF7F00FF7E00FF8200FF8D00FF9D00FFB200FFCD00FFEB00
F3FF00CFFF00AAFF0084FF005FFF003BFF001AFF0000FF0200FF1B00FF3000FF3F00FF48
00FF4A00FF4700FF3E00FF2F00FF1B00FF0317FF0035FF0053FF0071FF008EFF00A7FF00
BDFF00CEFF00D9FF00DEFF00DDFF00D6FF00C9FF00B8FF00A3FF008CFF0075FF005FFF00
4CFF003EFF0036FF0033FF0038FF0041FF004FFF005FFF006FFF007CFF0083FF0083FF00
7DFF0074FF006CFF006BFF0070FF0071FF006AFF0060FF0059FF0058FF005EFF006AFF00
79FF0089FF0098FF00A3FF00A8FF00A7FF009FFF0092FF0080FF006BFF0054FF003DFF00
28FF0015FF0008FF0000FF0000FF0201FF000BFF001BFF0030FF0049FF0065FF0082FF00
A1FF00BEFF00DAFF00F3FF00FFF700FFE700FFDD00FFD800FFDA00FFE200FFEF00FCFF00
E4FF00C7FF00A7FF0084FF005FFF0039FF0014FF0000FF0F00FF3100FF5000FF6B00FF82
00FF9300FF9F00FFA400FFA400FF9E00FF9100FF7F00FF6700FF4A00FF2900FF0424FF00
4EFF007BFF00A7FF00D4FF00FFFF00FFD500FFAD00FF8900FF6800FF4C00FF3500FF2300
FF1700FF1100FF1200FF1800FF2400FF3600FF4E00FF6B00FF8D00FFB400FFDE00F3FF00
C3FF0090FF005DFF0028FF0000FF0B00FF3E00FF7000FF9F
FF6E00FF9D00FFCF00FDFF00C9FF0095FF0061FF002EFF0000FF0100FF3000FF5B00FF82
00FFA500FFC300FFDC00FFEF00FFFD00FBFF00FAFF00FEFF00FFF600FFE500FFCF00FFB4
00FF9400FF7100FF4A00FF200BFF0037FF0064FF0091FF00BCFF00E4FF00FFF500FFD300
FFB500FF9C00FF8900FF7B00FF7300FF7200FF7600FF8100FF9100FFA600FFC100FFDF00
FFFF00DBFF00B6FF0090FF006BFF0047FF0026FF0009FF0000FF1000FF2400FF3300FF3C
00FF3E00FF3B00FF3200FF2300FF0F08FF0023FF0041FF005FFF007DFF009AFF00B3FF00
C9FF00DAFF00E5FF00EAFF00E9FF00E2FF00D5FF00C4FF00AFFF0098FF0081FF006BFF00
58FF004AFF0042FF003FFF0044FF004DFF005BFF006BFF007BFF0088FF008FFF008FFF00
89FF0080FF0078FF0077FF007CFF007DFF0076FF006CFF0065FF0064FF006AFF0076FF00
85FF0095FF00A4FF00AEFF00B4FF00B3FF00ABFF009EFF008CFF0077FF0060FF0049FF00
34FF0021FF0014FF000BFF0009FF000DFF0017FF0027FF003CFF0054FF0070FF008EFF00
ADFF00CAFF00E6FF00FFFF00FFEB00FFDB00FFD100FFCC00FFCE00FFD600FFE300FFF700
F0FF00D3FF00B3FF0090FF006BFF0045FF0020FF0000FF0400FF2500FF4400FF5F00FF76
00FF8700FF9300FF9800FF9800FF9200FF8500FF7300FF5B00FF3E00FF1D07FF0030FF00
5AFF0087FF00B3FF00E0FF00FFF300FFC900FFA100FF7D00FF5C00FF4000FF2900FF1700
FF0B00FF0500FF0600FF0C00FF1800FF2A00FF4200FF5F00FF8100FFA800FFD200FFFF00
CFFF009CFF0069FF0034FF0000FF0000FF3200FF6400FF94
FF6800FF9700FFC900FFFC00CFFF009BFF0067FF0034FF0004FF0000FF2A00FF5500FF7C
00FF9F00FFBD00FFD600FFE900FFF700FFFE00FFFF00FFFB00FFF000FFDF00FFC900FFAE
00FF8E00FF6B00FF4400FF1A11FF003DFF006AFF0097FF00C2FF00EAFF00FFEF00FFCD00
FFAF00FF9600FF8300FF7500FF6D00FF6C00FF7000FF7B00FF8B00FFA000FFBB00FFD900
FFFA00E1FF00BCFF0096FF0071FF004DFF002CFF000FFF0000FF0A00FF1E00FF2D00FF36
00FF3800FF3500FF2C00FF1D00FF090EFF0029FF0047FF0065FF0083FF00A0FF00B9FF00
CFFF00E0FF00EBFF00F0FF00EFFF00E8FF00DBFF00CAFF00B5FF009EFF0087FF0071FF00
5EFF0050FF0048FF0045FF004AFF0053FF0061FF0071FF0081FF008EFF0095FF0095FF00
8FFF0086FF007EFF007DFF0082FF0083FF007CFF0072FF006BFF006AFF0070FF007CFF00
8BFF009BFF00AAFF00B4FF00BAFF00B9FF00B1FF00A4FF0092FF007DFF0066FF004FFF00
3AFF0027FF001AFF0011FF000FFF0013FF001DFF002DFF0042FF005AFF0076FF0094FF00
B3FF00D0FF00ECFF00FFFA00FFE500FFD500FFCB00FFC600FFC800FFD000FFDD00FFF100
F6FF00D9FF00B9FF0096FF0071FF004BFF0026FF0001FF0000FF1F00FF3E00FF5900FF70
00FF8100FF8D00FF9200FF9200FF8C00FF7F00FF6D00FF5500FF3800FF170DFF0036FF00
60FF008DFF00B9FF00E6FF00FFED00FFC300FF9B00FF7700FF5600FF3A00FF2300FF1100
FF0500000000000000FF0600FF1200FF2400FF3C00FF5900FF7B00FFA200FFCC00FFFA00
D5FF00A2FF006FFF003AFF0006FF0000FF2C00FF5E00FF8E
FF6800FF9700FFC900FFFC00CFFF009BFF0067FF0034FF0003FF0000FF2A00FF5500FF7C
00FF9F00FFBD00FFD600FFEA00FFF700FFFE00FFFF00FFFB00FFF000FFDF00FFC900FFAE
00FF8F00FF6B00FF4400FF1A10FF003DFF006AFF0097FF00C2FF00EAFF00FFEF00FFCD00
FFAF00FF9600FF8300FF7500FF6D00FF6C00FF7000FF7B00FF8B00FFA100FFBB00FFD900
FFFA00E1FF00BCFF0096FF0071FF004DFF002CFF000FFF0000FF0A00FF1E00FF2D00FF36
00FF3900FF3500FF2C00FF1D00FF090EFF0029FF0047FF0065FF0083FF00A0FF00B9FF00
CFFF00E0FF00EBFF00F0FF00EFFF00E8FF00DBFF00CAFF00B5FF009EFF0087FF0071FF00
5EFF0050FF0048FF0045FF0049FF0053FF0061FF0071FF0081FF008DFF0095FF0095FF00
8FFF0086FF007EFF007DFF0082FF0083FF007CFF0072FF006BFF006AFF0070FF007CFF00
8BFF009BFF00AAFF00B4FF00BAFF00B9FF00B1FF00A4FF0092FF007DFF0066FF004FFF00
3AFF0027FF001AFF0011FF000FFF0013FF001DFF002DFF0041FF005AFF0076FF0094FF00
B3FF00D0FF00ECFF00FFFA00FFE500FFD500FFCB00FFC600FFC800FFD000FFDD00FFF100
F6FF00D9FF00B9FF0095FF0071FF004BFF0026FF0001FF0000FF2000FF3E00FF5900FF70
00FF8100FF8D00FF9300FF9200FF8C00FF7F00FF6D00FF5500FF3800FF170DFF0036FF00
60FF008CFF00B9FF00E6FF00FFED00FFC300FF9B00FF7700FF5600FF3A00FF2300FF1200
FF0600000000000000FF0600FF1200FF2400FF3C00FF5900FF7B00FFA200FFCC00FFFA00
D5FF00A2FF006FFF003AFF0006FF0000FF2C00FF5E00FF8E
FF6E00FF9D00FFCF00FDFF00C9FF0095FF0061FF002EFF0000FF0200FF3000FF5B00FF82
00FFA500FFC400FFDC00FFF000FFFD00FAFF00F9FF00FEFF00FFF600FFE600FFD000FFB4
00FF9500FF7100FF4A00FF200AFF0037FF0064FF0090FF00BBFF00E4FF00FFF500FFD300
FFB500FF9C00FF8900FF7B00FF7300FF7200FF7700FF8100FF9100FFA700FFC100FFDF00
FFFF00DBFF00B6FF0090FF006BFF0047FF0026FF0009FF0000FF1000FF2400FF3300FF3C
00FF3F00FF3B00FF3200FF2300FF0F08FF0023FF0041FF005FFF007DFF0099FF00B3FF00
C9FF00DAFF00E5FF00EAFF00E9FF00E2FF00D5FF00C3FF00AFFF0098FF0081FF006BFF00
58FF004AFF0041FF003FFF0043FF004DFF005BFF006BFF007BFF0087FF008EFF008FFF00
89FF007FFF0077FF0077FF007BFF007CFF0075FF006CFF0065FF0064FF006AFF0075FF00
85FF0095FF00A4FF00AEFF00B3FF00B2FF00ABFF009EFF008CFF0077FF0060FF0049FF00
33FF0021FF0013FF000BFF0009FF000DFF0017FF0026FF003BFF0054FF0070FF008EFF00
ACFF00CAFF00E6FF00FFFF00FFEB00FFDC00FFD100FFCD00FFCE00FFD600FFE400FFF700
F0FF00D3FF00B2FF008FFF006AFF0045FF001FFF0000FF0400FF2600FF4500FF6000FF76
00FF8700FF9300FF9900FF9800FF9200FF8500FF7300FF5B00FF3E00FF1D07FF002FFF00
5AFF0086FF00B3FF00E0FF00FFF300FFC900FFA100FF7D00FF5D00FF4000FF2900FF1800
FF0C00FF0600FF0600FF0C00FF1800FF2A00FF4200FF5F00FF8200FFA800FFD200FFFF00
CEFF009CFF0068FF0034FF0000FF0000FF3200FF6400FF94
FF7B00FFAA00FFDB00F1FF00BDFF0088FF0055FF0022FF0000FF0E00FF3C00FF6700FF8F
00FFB200FFD000FFE900FFFC00F6FF00EEFF00EDFF00F2FF00FDFF00FFF200FFDC00FFC1
00FFA100FF7D00FF5600FF2D00FF012BFF0058FF0084FF00AFFF00D8FF00FEFF00FFDF00
FFC100FFA800FF9500FF8700FF8000FF7E00FF8300FF8D00FF9E00FFB300FFCD00FFEB00
F2FF00CEFF00A9FF0084FF005EFF003BFF001AFF0000FF0300FF1C00FF3000FF3F00FF48
00FF4B00FF4800FF3E00FF2F00FF1B00FF0317FF0034FF0053FF0071FF008DFF00A7FF00
BDFF00CDFF00D9FF00DEFF00DCFF00D5FF00C9FF00B7FF00A2FF008CFF0074FF005FFF00
4CFF003EFF0035FF0033FF0037FF0041FF004FFF005FFF006EFF007BFF0082FF0083FF00
7DFF0073FF006BFF006AFF006FFF0070FF0069FF005FFF0058FF0058FF005EFF0069FF00
78FF0089FF0097FF00A2FF00A7FF00A6FF009FFF0092FF0080FF006AFF0053FF003CFF00
27FF0015FF0007FF0000FF0000FF0300FF000AFF001AFF002FFF0048FF0064FF0082FF00
A0FF00BEFF00DAFF00F2FF00FFF800FFE800FFDD00FFD900FFDA00FFE200FFF000FCFF00
E3FF00C7FF00A6FF0083FF005EFF0038FF0013FF0000FF1000FF3200FF5100FF6C00FF82
00FF9400FF9F00FFA500FFA500FF9E00FF9200FF7F00FF6800FF4B00FF2900FF0423FF00
4EFF007AFF00A7FF00D4FF00FFFF00FFD500FFAE00FF8900FF6900FF4D00FF3600FF2400
FF1800FF1200FF1200FF1800FF2500FF3700FF4F00FF6C00FF8E00FFB400FFDF00F3FF00
C2FF0090FF005CFF0028FF0000FF0B00FF3F00FF7000FFA0
FF8D00FFBC00FFED00DFFF00ABFF0076FF0042FF0010FF0000FF2000FF4E00FF7A00FFA1
00FFC400FFE200FFFB00F1FF00E3FF00DCFF00DBFF00E0FF00EAFF00FBFF00FFEE00FFD3
00FFB300FF8F00FF6800FF3F00FF1319FF0046FF0072FF009DFF00C6FF00ECFF00FFF100
FFD300FFBB00FFA700FF9A00FF9200FF9000FF9500FF9F00FFB000FFC500FFDF00FFFD00
E0FF00BCFF0097FF0071FF004CFF0029FF0008FF0000FF1500FF2E00FF4300FF5100FF5A
00FF5D00FF5A00FF5000FF4200FF2E00FF1605FF0022FF0041FF005FFF007BFF0095FF00
AAFF00BBFF00C6FF00CBFF00CAFF00C3FF00B6FF00A5FF0090FF0079FF0062FF004CFF00
3AFF002BFF0023FF0021FF0025FF002FFF003CFF004DFF005CFF0069FF0070FF0070FF00
6BFF0061FF0059FF0058FF005DFF005EFF0057FF004DFF0046FF0045FF004BFF0057FF00
66FF0077FF0085FF0090FF0095FF0094FF008DFF0080FF006EFF0058FF0041FF002AFF00
15FF0003FF0000FF0A00FF1200FF1500FF1100FF0708FF001DFF0036FF0052FF0070FF00
8EFF00ACFF00C8FF00E0FF00F5FF00FFFA00FFEF00FFEB00FFED00FFF400FDFF00EAFF00
D1FF00B4FF0094FF0071FF004CFF0026FF0001FF0000FF2200FF4400FF6300FF7E00FF94
00FFA600FFB100FFB700FFB700FFB000FFA400FF9200FF7A00FF5D00FF3B00FF1611FF00
3CFF0068FF0095FF00C2FF00EDFF00FFE700FFC000FF9B00FF7B00FF5F00FF4800FF3600
FF2A00FF2400FF2400FF2A00FF3700FF4900FF6100FF7E00FFA000FFC600FFF100E0FF00
B0FF007EFF004AFF0016FF0000FF1D00FF5100FF8300FFB2
FFA500FFD400FAFF00C7FF0093FF005EFF002BFF0000FF0700FF3800FF6600FF9100FFB9
00FFDC00FFFA00ECFF00D9FF00CCFF00C4FF00C3FF00C8FF00D3FF00E3FF00F9FF00FFEB
00FFCB00FFA700FF8000FF5700FF2B01FF002EFF005AFF0085FF00AEFF00D4FF00F6FF00
FFEB00FFD200FFBF00FFB100FFAA00FFA800FFAD00FFB700FFC800FFDD00FFF700EAFF00
C8FF00A5FF007FFF005AFF0034FF0011FF0000FF0F00FF2D00FF4600FF5A00FF6900FF72
00FF7500FF7200FF6800FF5900FF4500FF2D00FF120AFF0029FF0047FF0063FF007DFF00
93FF00A3FF00AFFF00B4FF00B3FF00ABFF009FFF008DFF0078FF0062FF004AFF0035FF00
22FF0014FF000BFF0009FF000DFF0017FF0025FF0035FF0044FF0051FF0058FF0059FF00
53FF0049FF0041FF0040FF0045FF0046FF003FFF0035FF002EFF002EFF0034FF003FFF00
4FFF005FFF006DFF0078FF007DFF007CFF0075FF0068FF0056FF0040FF0029FF0012FF00
00FF0200FF1400FF2200FF2A00FF2D00FF2900FF1F00FF0F05FF001EFF003AFF0058FF00
76FF0094FF00B0FF00C9FF00DDFF00EDFF00F8FF00FCFF00FBFF00F3FF00E5FF00D2FF00
B9FF009DFF007CFF0059FF0034FF000EFF0000FF1600FF3A00FF5C00FF7B00FF9600FFAC
00FFBE00FFC900FFCF00FFCF00FFC800FFBC00FFA900FF9100FF7500FF5300FF2E00FF06
24FF0050FF007DFF00AAFF00D6FF00FFFF00FFD800FFB300FF9300FF7700FF6000FF4E00
FF4200FF3C00FF3C00FF4200FF4F00FF6100FF7900FF9600FFB800FFDE00F6FF00C9FF00
98FF0066FF0032FF0000FF0100FF3500FF6900FF9A00FFCA
FFC200FFF100DDFF00AAFF0076FF0041FF000DFF0000FF2400FF5500FF8300FFAF00FFD6
00FFF900E8FF00CFFF00BCFF00AEFF00A7FF00A6FF00ABFF00B5FF00C6FF00DCFF00F7FF
00FFE800FFC400FF9D00FF7400FF4800FF1B11FF003DFF0068FF0091FF00B7FF00D9FF00
F7FF00FFF000FFDC00FFCF00FFC700FFC500FFCA00FFD400FFE500FFFA00EBFF00CDFF00
ABFF0087FF0062FF003CFF0017FF0000FF0B00FF2C00FF4A00FF6300FF7800FF8600FF8F
00FF9200FF8F00FF8500FF7700FF6300FF4B00FF2F00FF120CFF002AFF0046FF0060FF00
75FF0086FF0091FF0097FF0095FF008EFF0081FF0070FF005BFF0044FF002DFF0017FF00
05FF0000FF0800FF1100FF1300FF0F00FF0508FF0018FF0027FF0034FF003BFF003CFF00
36FF002CFF0024FF0023FF0028FF0029FF0022FF0018FF0011FF0010FF0016FF0022FF00
31FF0042FF0050FF005BFF0060FF005FFF0058FF004BFF0039FF0023FF000CFF0000FF0A
00FF1F00FF3100FF3F00FF4700FF4A00FF4600FF3C00FF2C00FF1701FF001DFF003BFF00
59FF0077FF0093FF00ABFF00C0FF00D0FF00DBFF00DFFF00DEFF00D6FF00C8FF00B5FF00
9CFF007FFF005FFF003CFF0017FF0000FF0E00FF3300FF5700FF7900FF9800FFB300FFC9
00FFDB00FFE600FFEC00FFEC00FFE500FFD900FFC600FFAF00FF9200FF7000FF4B00FF23
07FF0033FF0060FF008DFF00B8FF00E3FF00FFF500FFD000FFB000FF9400FF7D00FF6B00
FF5F00FF5900FF5900FF5F00FF6C00FF7E00FF9600FFB300FFD500FFFB00D9FF00ABFF00
7BFF0049FF0015FF0000FF1E00FF5200FF8600FFB800FFE7
FFE400ECFF00BBFF0088FF0054FF001FFF0000FF1400FF4600FF7700FFA500FFD100FFF8
00E4FF00C6FF00ADFF009AFF008CFF0085FF0084FF0089FF0093FF00A4FF00BAFF00D5FF
00F5FF00FFE700FFBF00FF9600FF6A00FF3D00FF101BFF0046FF006FFF0095FF00B7FF00
D4FF00EDFF00FFFE00FFF100FFE900FFE700FFEC00FFF700F8FF00E3FF00C9FF00AAFF00
89FF0065FF0040FF001AFF0000FF0A00FF2D00FF4E00FF6C00FF8500FF9A00FFA900FFB1
00FFB400FFB100FFA700FF9900FF8500FF6D00FF5100FF3400FF1508FF0024FF003EFF00
53FF0064FF006FFF0074FF0073FF006CFF005FFF004EFF0039FF0022FF000BFF0000FF0A
00FF1C00FF2B00FF3300FF3500FF3100FF2700FF1A00FF0905FF0012FF0019FF0019FF00
14FF000AFF0002FF0001FF0006FF0007FF0000FF0000FF0900FF1000FF1100FF0B00FF00
0FFF0020FF002EFF0039FF003EFF003DFF0036FF0029FF0017FF0001FF0000FF1500FF2C
00FF4100FF5300FF6100FF6900FF6C00FF6800FF5E00FF4E00FF3900FF2000FF0419FF00
37FF0055FF0071FF0089FF009EFF00AEFF00B8FF00BDFF00BBFF00B4FF00A6FF0093FF00
7AFF005DFF003DFF001AFF0000FF0A00FF3000FF5500FF7900FF9B00FFBA00FFD500FFEB
00FFFD00F7FF00F1FF00F1FF00F8FF00FFFB00FFE900FFD100FFB400FF9300FF6D00FF45
00FF1A11FF003EFF006BFF0096FF00C1FF00E8FF00FFF200FFD200FFB600FF9F00FF8D00
FF8100FF7B00FF7B00FF8200FF8E00FFA000FFB800FFD500FFF700E2FF00B7FF0089FF00
59FF0027FF0000FF0C00FF4000FF7400FFA800FFDA00F6FF
F5FF00C6FF0094FF0061FF002DFF0000FF0600FF3A00FF6D00FF9E00FFCC00FFF700E1FF
00BEFF00A0FF0087FF0073FF0066FF005FFF005DFF0062FF006DFF007DFF0094FF00AFFF
00CEFF00F2FF00FFE600FFBC00FF9100FF6400FF3700FF0B1FFF0048FF006EFF0090FF00
AEFF00C7FF00DAFF00E8FF00F0FF00F1FF00EDFF00E2FF00D2FF00BCFF00A2FF0084FF00
63FF003FFF001AFF0000FF0B00FF3000FF5400FF7500FF9200FFAC00FFC000FFCF00FFD8
00FFDB00FFD700FFCE00FFBF00FFAB00FF9300FF7800FF5A00FF3C00FF1E00FF0117FF00
2DFF003EFF0049FF004EFF004DFF0046FF0039FF0027FF0013FF0000FF0300FF1A00FF30
00FF4300FF5100FF5A00FF5C00FF5800FF4E00FF4000FF3000FF2000FF1400FF0D00FF0C
00FF1200FF1B00FF2400FF2400FF2000FF1F00FF2600FF2F00FF3600FF3700FF3100FF25
00FF1600FF0608FF0012FF0018FF0017FF000FFF0002FF0000FF0F00FF2400FF3B00FF52
00FF6800FF7A00FF8800FF9000FF9200FF8E00FF8400FF7500FF6000FF4700FF2B00FF0D
10FF002EFF004AFF0063FF0078FF0088FF0092FF0097FF0095FF008DFF007FFF006CFF00
54FF0037FF0016FF0000FF0C00FF3100FF5600FF7C00FFA000FFC200FFE100FFFC00EDFF
00DCFF00D0FF00CAFF00CBFF00D1FF00DEFF00F0FF00FFF700FFDA00FFB900FF9400FF6C
00FF4100FF1517FF0044FF0070FF009AFF00C2FF00E6FF00FFF800FFDC00FFC500FFB400
FFA800FFA200FFA200FFA800FFB400FFC600FFDE00FFFB00E2FF00BBFF0091FF0063FF00
33FF0000FF0000FF3300FF6700FF9B00FFCE00FFFF00CFFF
CAFF009BFF006AFF0037FF0003FF0000FF3100FF6500FF9700FFC800FFF600DEFF00B6FF
0093FF0075FF005CFF0049FF003CFF0034FF0033FF0038FF0042FF0053FF0069FF0084FF
00A4FF00C8FF00EFFF00FFE700FFBB00FF8E00FF6100FF3500FF0A1EFF0044FF0066FF00
84FF009CFF00B0FF00BEFF00C5FF00C7FF00C2FF00B8FF00A7FF0092FF0078FF005AFF00
38FF0014FF0000FF1000FF3600FF5B00FF7E00FF9F00FFBD00FFD600FFEB00FFF900FDFF
00FAFF00FDFF00FFF800FFE900FFD600FFBE00FFA200FF8500FF6600FF4800FF2C00FF12
02FF0013FF001EFF0024FF0022FF001BFF000EFF0000FF0200FF1700FF2E00FF4500FF5B
00FF6D00FF7B00FF8400FF8600FF8200FF7800FF6A00FF5A00FF4B00FF3E00FF3700FF36
00FF3C00FF4600FF4E00FF4F00FF4A00FF4900FF5000FF5A00FF6100FF6200FF5C00FF50
00FF4100FF3000FF2200FF1700FF1200FF1300FF1A00FF2700FF3900FF4F00FF6600FF7D
00FF9200FFA400FFB200FFBA00FFBD00FFB900FFAF00FF9F00FF8A00FF7100FF5500FF37
00FF1904FF0020FF0038FF004DFF005DFF0068FF006CFF006BFF0063FF0055FF0042FF00
29FF000CFF0000FF1300FF3600FF5B00FF8100FFA600FFCA00FFEC00F4FF00D9FF00C3FF
00B1FF00A6FF00A0FF00A0FF00A7FF00B3FF00C6FF00DDFF00FAFF00FFE300FFBE00FF96
00FF6B00FF3F00FF121AFF0045FF0070FF0097FF00BCFF00DCFF00F8FF00FFF000FFDE00
FFD200FFCC00FFCC00FFD200FFDF00FFF100F6FF00D9FF00B7FF0091FF0066FF0039FF00
08FF0000FF2900FF5D00FF9100FFC500FFF900D4FF00A5FF
9DFF006DFF003CFF0009FF0000FF2A00FF5E00FF9200FFC500FFF600DBFF00B0FF0088FF
0066FF0047FF002FFF001BFF000EFF0006FF0005FF000AFF0015FF0025FF003BFF0057FF
0076FF009AFF00C1FF00EBFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006FFF0082FF0090FF0097FF0099FF0094FF008AFF007AFF0064FF004AFF002CFF00
0AFF0000FF1800FF3E00FF6300FF8800FFAC00FFCD00FFEB00FBFF00E7FF00D8FF00CFFF
00CCFF00D0FF00D9FF00E8FF00FCFF00FFEB00FFD000FFB200FF9400FF7600FF5A00FF40
00FF2A00FF1900FF0E00FF0900FF0A00FF1200FF1E00FF3000FF4400FF5B00FF7200FF88
00FF9B00FFA900FFB200FFB400FFB000FFA600FF9800FF8800FF7800FF6C00FF6500FF64
00FF6A00FF7400FF7C00FF7C00FF7800FF7700FF7E00FF8700FF8E00FF8F00FF8900FF7E
00FF6E00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7C00FF9300FFAA
00FFC000FFD200FFE000FFE800FFEA00FFE600FFDC00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0BFF001FFF002FFF003AFF003EFF003DFF0035FF0027FF0014FF00
00FF0300FF2000FF4100FF6400FF8900FFAE00FFD400FFF800E5FF00C6FF00ABFF0095FF
0084FF0078FF0072FF0073FF0079FF0086FF0098FF00B0FF00CDFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1318FF0042FF006AFF008EFF00AEFF00CAFF00E2FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F3FF00E0FF00C9FF00ABFF0089FF0063FF0039FF000BFF00
00FF2500FF5700FF8B00FFBF00FFF300D9FF00A7FF0077FF
6CFF003DFF000CFF0000FF2600FF5B00FF8F00FFC300FFF500D9FF00ABFF007FFF0058FF
0035FF0017FF0100FF1400FF2200FF2900FF2A00FF2500FF1B00FF0A00FF000BFF0026FF
0046FF0069FF0091FF00BAFF00E6FF00FFEC00FFBF00FF9300FF6800FF3F00FF1908FF00
25FF003EFF0052FF005FFF0067FF0069FF0064FF0059FF0049FF0034FF001AFF0000FF04
00FF2500FF4900FF6E00FF9400FFB900FFDC00FFFD00E4FF00CBFF00B6FF00A7FF009FFF
009CFF009FFF00A8FF00B7FF00CBFF00E3FF00FFFF00FFE300FFC400FFA600FF8A00FF70
00FF5B00FF4A00FF3F00FF3A00FF3B00FF4200FF4F00FF6000FF7500FF8C00FFA300FFB9
00FFCB00FFDA00FFE200FFE400FFE000FFD700FFC900FFB800FFA900FF9C00FF9500FF95
00FF9A00FFA400FFAC00FFAD00FFA800FFA700FFAE00FFB800FFBF00FFC000FFBA00FFAE
00FF9F00FF8E00FF8000FF7500FF7000FF7100FF7800FF8600FF9700FFAD00FFC400FFDB
00FFF000FDFF00EFFF00E7FF00E4FF00E8FF00F2FF00FFFD00FFE800FFCF00FFB300FF95
00FF7700FF5900FF3E00FF2500FF1000FF0009FF000EFF000CFF0005FF0000FF0800FF1B
00FF3400FF5100FF7100FF9400FFB900FFDF00FBFF00D7FF00B5FF0096FF007BFF0065FF
0053FF0048FF0042FF0042FF0049FF0055FF0067FF007FFF009CFF00BDFF00E3FF00FFF4
00FFC900FF9D00FF7000FF4300FF1812FF0039FF005EFF007EFF009AFF00B1FF00C3FF00
CFFF00D5FF00D5FF00CEFF00C2FF00B0FF0098FF007BFF0059FF0033FF0008FF0000FF25
00FF5500FF8700FFBB00FFEF00DBFF00A8FF0076FF0047FF
3AFF000BFF0000FF2600FF5900FF8D00FFC100FFF500D7FF00A6FF0078FF004DFF0026FF
0003FF1A00FF3300FF4700FF5400FF5B00FF5D00FF5800FF4D00FF3C00FF2600FF0B00FF
0013FF0037FF005EFF0088FF00B3FF00E0FF00FFF200FFC500FF9A00FF7200FF4C00FF2A
00FF0C0CFF001FFF002DFF0035FF0036FF0032FF0027FF0017FF0001FF0000FF1800FF36
00FF5700FF7B00FFA000FFC600FFEB00F0FF00CFFF00B2FF0098FF0084FF0075FF006CFF
0069FF006DFF0076FF0085FF0099FF00B1FF00CCFF00EAFF00FFF700FFD900FFBC00FFA3
00FF8D00FF7C00FF7100FF6C00FF6D00FF7400FF8100FF9200FFA700FFBE00FFD500FFEB
00FFFE00F3FF00EBFF00E8FF00ECFF00F6FF00FFFB00FFEB00FFDB00FFCF00FFC700FFC7
00FFCD00FFD600FFDE00FFDF00FFDB00FFD900FFE100FFEA00FFF100FFF200FFEC00FFE0
00FFD100FFC100FFB200FFA800FFA200FFA300FFAB00FFB800FFCA00FFDF00FFF600F2FF
00DCFF00CAFF00BDFF00B4FF00B2FF00B6FF00C0FF00D0FF00E4FF00FDFF00FFE600FFC8
00FFA900FF8C00FF7000FF5700FF4200FF3200FF2800FF2300FF2500FF2D00FF3A00FF4E
00FF6600FF8300FFA300FFC700FFEC00EEFF00C8FF00A4FF0082FF0064FF0049FF0032FF
0021FF0015FF000FFF0010FF0016FF0023FF0035FF004DFF006AFF008BFF00B0FF00D9FF
00FFFC00FFD000FFA300FF7600FF4A00FF2007FF002BFF004CFF0068FF007FFF0090FF00
9CFF00A2FF00A2FF009CFF0090FF007EFF0066FF0049FF0027FF0000FF0000FF2900FF57
00FF8700FFBA00FFED00DDFF00A9FF0076FF0044FF0014FF
06FF0000FF2800FF5900FF8D00FFC100FFF500D6FF00A4FF0073FF0044FF0019FF0D00FF
3000FF4E00FF6700FF7A00FF8800FF8F00FF9000FF8B00FF8100FF7000FF5A00FF3F00FF
1F00FF0003FF002AFF0054FF0080FF00ACFF00D9FF00FFF900FFCE00FFA500FF8000FF5D
00FF4000FF2700FF1300FF0601FF0003FF0000FF0100FF0C00FF1C00FF3100FF4B00FF6A
00FF8B00FFAF00FFD400FFFA00E0FF00BDFF009CFF007EFF0065FF0050FF0041FF0038FF
0036FF0039FF0042FF0051FF0065FF007DFF0099FF00B6FF00D4FF00F2FF00FFF000FFD6
00FFC100FFB000FFA500FFA000FFA100FFA800FFB500FFC600FFDB00FFF200F6FF00E0FF
00CEFF00BFFF00B7FF00B5FF00B9FF00C2FF00D0FF00E0FF00F0FF00FDFF00FFFB00FFFB
00FEFF00F5FF00EDFF00ECFF00F1FF00F2FF00EBFF00E1FF00DAFF00D9FF00DFFF00EBFF
00FAFF00FFF500FFE600FFDB00FFD600FFD700FFDE00FFEC00FFFE00ECFF00D5FF00BEFF
00A9FF0097FF0089FF0081FF007EFF0082FF008CFF009CFF00B1FF00CAFF00E6FF00FFFC
00FFDD00FFBF00FFA400FF8B00FF7600FF6600FF5C00FF5700FF5900FF6000FF6E00FF81
00FF9A00FFB700FFD700FFFA00E0FF00BAFF0095FF0071FF004FFF0030FF0015FF0100FF
1200FF1E00FF2300FF2300FF1C00FF1000FF0001FF0019FF0036FF0057FF007DFF00A5FF
00CFFF00FCFF00FFD600FFAA00FF7E00FF5400FF2C00FF0818FF0034FF004BFF005DFF00
69FF006FFF006FFF0068FF005CFF004AFF0032FF0015FF0000FF0C00FF3300FF5D00FF8B
00FFBB00FFED00DEFF00AAFF0075FF0042FF0010FF1E00FF
00FF2D00FF5C00FF8E00FFC100FFF500D6FF00A2FF006FFF003EFF0010FF1A00FF4100FF
6400FF8200FF9B00FFAF00FFBC00FFC300FFC500FFC000FFB500FFA400FF8E00FF7300FF
5400FF3000FF0900FF0020FF004BFF0078FF00A5FF00D2FF00FDFF00FFDA00FFB400FF92
00FF7400FF5B00FF4800FF3A00FF3200FF3100FF3500FF4000FF5000FF6600FF8000FF9E
00FFBF00FFE300F7FF00D1FF00ACFF0088FF0067FF004AFF0030FF001CFF000DFF0004FF
0001FF0005FF000EFF001DFF0031FF0049FF0064FF0082FF00A0FF00BEFF00DBFF00F4FF
00FFF500FFE400FFD900FFD400FFD500FFDC00FFE900FFFA00F0FF00D9FF00C2FF00ACFF
0099FF008BFF0083FF0080FF0084FF008EFF009CFF00ACFF00BCFF00C8FF00D0FF00D0FF
00CAFF00C1FF00B9FF00B8FF00BDFF00BEFF00B6FF00ADFF00A6FF00A5FF00ABFF00B7FF
00C6FF00D6FF00E5FF00EFFF00F5FF00F4FF00ECFF00DFFF00CDFF00B8FF00A1FF008AFF
0074FF0062FF0055FF004CFF004AFF004EFF0058FF0068FF007CFF0095FF00B1FF00CFFF
00EEFF00FFF400FFD800FFBF00FFAA00FF9A00FF9000FF8B00FF8D00FF9500FFA200FFB6
00FFCE00FFEB00F4FF00D0FF00ACFF0086FF0060FF003CFF001AFF0300FF1E00FF3500FF
4600FF5200FF5800FF5700FF5100FF4400FF3200FF1A00FF0002FF0023FF0048FF0071FF
009BFF00C7FF00F4FF00FFDE00FFB200FF8800FF6000FF3C00FF1B00FF0017FF0028FF00
34FF003AFF003AFF0034FF0028FF0016FF0000FF0100FF1E00FF4000FF6700FF9100FFBF
00FFEF00DDFF00AAFF0075FF0041FF000EFF2300FF5300FF
00FF6100FF9000FFC200FFF500D6FF00A2FF006EFF003BFF000AFF2300FF4E00FF7500FF
9800FFB700FFCF00FFE300FFF000FFF700FFF900FFF400FFE900FFD900FFC300FFA700FF
8800FF6400FF3D00FF1300FF0017FF0044FF0071FF009DFF00C8FF00F1FF00FFE800FFC6
00FFA800FF8F00FF7C00FF6E00FF6600FF6500FF6A00FF7400FF8400FF9A00FFB400FFD2
00FFF300E8FF00C3FF009DFF0078FF0054FF0033FF0016FF0300FF1700FF2600FF2F00FF
3200FF2E00FF2500FF1600FF0200FF0015FF0030FF004EFF006CFF008AFF00A6FF00C0FF
00D6FF00E7FF00F2FF00F7FF00F6FF00EFFF00E2FF00D0FF00BCFF00A5FF008EFF0078FF
0065FF0057FF004EFF004CFF0050FF005AFF0068FF0078FF0088FF0094FF009BFF009CFF
0096FF008CFF0084FF0084FF0088FF0089FF0082FF0079FF0072FF0071FF0077FF0082FF
0092FF00A2FF00B1FF00BBFF00C0FF00BFFF00B8FF00ABFF0099FF0084FF006DFF0056FF
0040FF002EFF0020FF0018FF0016FF001AFF0024FF0033FF0048FF0061FF007DFF009BFF
00B9FF00D7FF00F3FF00FFF300FFDE00FFCF00FFC400FFBF00FFC100FFC900FFD700FFEA
00FDFF00E0FF00BFFF009CFF0077FF0052FF002CFF0008FF1900FF3800FF5300FF6900FF
7A00FF8600FF8C00FF8B00FF8500FF7800FF6600FF4E00FF3100FF1000FF0014FF003CFF
0067FF0093FF00C0FF00EDFF00FFE600FFBC00FF9400FF7000FF4F00FF3300FF1C00FF0B
00FF0006FF0006FF0000FF0000FF0B00FF1D00FF3500FF5200FF7400FF9B00FFC500FFF3
00DBFF00A9FF0075FF0041FF000DFF2500FF5700FF8700FF
00FF9500FFC400FFF500D7FF00A3FF006EFF003AFF0008FF2800FF5600FF8100FFA900FF
CC00FFEA00FFFF00FCFF00E9FF00DCFF00D4FF00D3FF00D8FF00E3FF00F3F600FFDB00FF
BB00FF9700FF7000FF4700FF1B00FF0011FF003EFF006AFF0095FF00BEFF00E4FF00FFF9
00FFDB00FFC300FFAF00FFA100FF9A00FF9800FF9D00FFA700FFB800FFCD00FFE700FAFF
00D8FF00B4FF008FFF006AFF0044FF0021FF0000FF1D00FF3600FF4B00FF5900FF6200FF
6500FF6200FF5800FF4900FF3600FF1D00FF0200FF001AFF0039FF0057FF0073FF008DFF
00A2FF00B3FF00BEFF00C4FF00C2FF00BBFF00AEFF009DFF0088FF0071FF005AFF0045FF
0032FF0024FF001BFF0019FF001DFF0027FF0035FF0045FF0054FF0061FF0068FF0069FF
0063FF0059FF0051FF0050FF0055FF0056FF004FFF0045FF003EFF003EFF0043FF004FFF
005EFF006FFF007DFF0088FF008DFF008CFF0085FF0078FF0066FF0050FF0039FF0022FF
000DFF0400FF1200FF1A00FF1D00FF1900FF0F00FF0000FF0015FF002EFF004AFF0068FF
0086FF00A4FF00C0FF00D8FF00EDFF00FDFF00FFF700FFF300FFF400FFFC00F5FF00E2FF
00C9FF00ADFF008CFF0069FF0044FF001EFF0600FF2A00FF4C00FF6B00FF8600FF9C00FF
AE00FFB900FFBF00FFBF00FFB800FFAC00FF9900FF8200FF6500FF4300FF1E00FF0009FF
0034FF0060FF008DFF00BAFF00E6FF00FFEF00FFC800FFA300FF8300FF6700FF5000FF3E
00FF3200FF2C00FF2C00FF3200FF3F00FF5100FF6900FF8600FFA800FFCE00FFF900D9FF
00A8FF0076FF0042FF000EFF2500FF5900FF8A00FFBA00FF
00FFC600FFF600D8FF00A5FF0071FF003DFF0009FF2900FF5A00FF8800FFB300FFDB00FF
FE00FFFF00E3FF00CAFF00B7FF00AAFF00A2FF00A1FF00A6FF00B1FF00C1FF00D7FF00F2
ED00FFC900FFA200FF7800FF4D00FF2000FF000CFF0038FF0063FF008CFF00B2FF00D4FF
00F2FF00FFF400FFE100FFD300FFCC00FFCA00FFCF00FFD900FFE900FFFF00E6FF00C8FF
00A6FF0083FF005DFF0038FF0013FF1000FF3100FF4F00FF6800FF7C00FF8B00FF9400FF
9700FF9400FF8A00FF7B00FF6700FF4F00FF3400FF1700FF0007FF0025FF0041FF005BFF
0071FF0082FF008DFF0092FF0091FF0089FF007DFF006BFF0056FF0040FF0028FF0013FF
0000FF0D00FF1600FF1800FF1400FF0A00FF0003FF0013FF0023FF002FFF0036FF0037FF
0031FF0027FF001FFF001FFF0023FF0024FF001DFF0013FF000DFF000CFF0012FF001DFF
002DFF003DFF004BFF0056FF005BFF005AFF0053FF0046FF0034FF001FFF0008FF0E00FF
2400FF3600FF4400FF4C00FF4E00FF4A00FF4000FF3100FF1C00FF0300FF0018FF0036FF
0054FF0072FF008EFF00A7FF00BBFF00CBFF00D6FF00DAFF00D9FF00D1FF00C3FF00B0FF
0098FF007BFF005AFF0037FF0012FF1200FF3800FF5C00FF7E00FF9D00FFB800FFCE00FF
DF00FFEB00FFF100FFF100FFEA00FFDE00FFCB00FFB300FF9700FF7500FF5000FF2800FF
0002FF002EFF005BFF0088FF00B4FF00DEFF00FFFA00FFD500FFB500FF9900FF8200FF70
00FF6400FF5E00FF5E00FF6400FF7000FF8300FF9A00FFB800FFDA00FFFF00D4FF00A7FF
0076FF0044FF0010FF2300FF5700FF8A00FFBC00FFEC00FF
00FFF600DAFF00A8FF0075FF0041FF000DFF2600FF5900FF8900FFB800FFE300FFFF00F5
FF00D2FF00B4FF009BFF0088FF007AFF0073FF0071FF0076FF0081FF0092FF00A8FF00C3
FF00E3F900FFD200FFA800FF7C00FF5000FF2300FF0009FF0034FF005CFF0082FF00A4FF
00C2FF00DBFF00EEFF00FCFF00FFFB00FFFA00FFFE00F6FF00E6FF00D1FF00B6FF0098FF
0077FF0053FF002EFF0008FF1C00FF4000FF6100FF7E00FF9800FFAC00FFBB00FFC400FF
C600FFC300FFBA00FFAB00FF9700FF7F00FF6400FF4600FF2800FF0A00FF0012FF002BFF
0041FF0052FF005DFF0062FF0061FF005AFF004DFF003CFF0027FF0010FF0600FF1C00FF
2F00FF3D00FF4500FF4800FF4400FF3A00FF2C00FF1C00FF0C00FF0000FF0007FF0007FF
0001FF0700FF0F00FF1000FF0B00FF0A00FF1100FF1B00FF2200FF2300FF1D00FF1100FF
0200FF000DFF001CFF0026FF002CFF002BFF0023FF0016FF0004FF1000FF2700FF3E00FF
5300FF6600FF7300FF7C00FF7E00FF7A00FF7000FF6000FF4B00FF3300FF1700FF0006FF
0025FF0042FF005EFF0077FF008CFF009CFF00A6FF00ABFF00A9FF00A1FF0094FF0080FF
0068FF004BFF002BFF0008FF1C00FF4200FF6700FF8C00FFAD00FFCC00FFE700FFFE00FF
FF00F0FF00E4FF00DFFF00DFFF00E5FF00F2FB00FFE300FFC600FFA500FF8000FF5700FF
2D00FF0000FF002BFF0058FF0084FF00AEFF00D6FF00FAFF00FFE400FFC800FFB100FF9F
00FF9400FF8E00FF8E00FF9400FFA000FFB200FFCA00FFE700F6FF00CFFF00A5FF0077FF
0047FF0014FF1E00FF5300FF8700FFBA00FFEC00FFFF00E3
pop
P
% End of image
1 1 1 r
.5 .02381 m
.5 .97619 L
.5465 .97619 L
.5465 .02381 L
F
.59301 .02381 m
.59301 .97619 L
.68601 .97619 L
.68601 .02381 L
F
.02381 .5 m
.02381 .77902 L
.97619 .77902 L
.97619 .5 L
F
0 g
gsave
.5 .68601 -105 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Forbidden) show
123.000 13.000 moveto
(area) show
147.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .59301 -105 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Hard) show
93.000 13.000 moveto
(constrain) show
147.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.015 w
.83203 .43795 Mdot
[(1)] .84703 .43795 -1 0 Mshowa
.10751 .45698 Mdot
[(2)] .12251 .45698 -1 0 Mshowa
.19215 .86644 Mdot
[(3)] .20715 .86644 -1 0 Mshowa
.81157 .89249 Mdot
[(4)] .82657 .89249 -1 0 Mshowa
.77251 .79483 Mdot
[(5)] .78751 .79483 -1 0 Mshowa
.57168 .1859 Mdot
[(6)] .58668 .1859 -1 0 Mshowa
.39304 .88318 Mdot
[(7)] .40804 .88318 -1 0 Mshowa
.56789 .46744 Mdot
[(8)] .58289 .46744 -1 0 Mshowa
.91202 .94922 Mdot
[(9)] .92702 .94922 -1 0 Mshowa
.44885 .1894 Mdot
[(10)] .46385 .1894 -1 0 Mshowa
.03 w
.83203 .43795 Mdot
.10751 .45698 Mdot
.19215 .86644 Mdot
.81157 .89249 Mdot
.77251 .79483 Mdot
.57168 .1859 Mdot
.39304 .88318 Mdot
.56789 .46744 Mdot
.91202 .94922 Mdot
.44885 .1894 Mdot
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.0055371 0.732558 0.227021 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.00093006 0.5 0.00093006 [
[.12798 -0.0125 -12 -9 ]
[.12798 -0.0125 12 0 ]
[.31399 -0.0125 -12 -9 ]
[.31399 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.68601 -0.0125 -9 -9 ]
[.68601 -0.0125 9 0 ]
[.87202 -0.0125 -9 -9 ]
[.87202 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .12798 -24 -4.5 ]
[-0.0125 .12798 0 4.5 ]
[-0.0125 .31399 -24 -4.5 ]
[-0.0125 .31399 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .68601 -18 -4.5 ]
[-0.0125 .68601 0 4.5 ]
[-0.0125 .87202 -18 -4.5 ]
[-0.0125 .87202 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 .68601 -44 -6.375 ]
[.5 .68601 44 6.375 ]
[.5 .59301 -44 -6.375 ]
[.5 .59301 44 6.375 ]
[.91586 .87202 0 -4.5 ]
[.91586 .87202 6 4.5 ]
[.58484 .21836 0 -4.5 ]
[.58484 .21836 6 4.5 ]
[.60622 .3746 0 -4.5 ]
[.60622 .3746 6 4.5 ]
[.19134 .81529 0 -4.5 ]
[.19134 .81529 6 4.5 ]
[.57903 .39466 0 -4.5 ]
[.57903 .39466 6 4.5 ]
[.56857 .47689 0 -4.5 ]
[.56857 .47689 6 4.5 ]
[.48617 .80041 0 -4.5 ]
[.48617 .80041 6 4.5 ]
[.98375 .78181 0 -4.5 ]
[.98375 .78181 6 4.5 ]
[.38386 .37127 0 -4.5 ]
[.38386 .37127 6 4.5 ]
[.58182 .91481 0 -4.5 ]
[.58182 .91481 12 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12798 0 m
.12798 .00625 L
s
[(-400)] .12798 -0.0125 0 1 Mshowa
.31399 0 m
.31399 .00625 L
s
[(-200)] .31399 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.68601 0 m
.68601 .00625 L
s
[(200)] .68601 -0.0125 0 1 Mshowa
.87202 0 m
.87202 .00625 L
s
[(400)] .87202 -0.0125 0 1 Mshowa
.125 Mabswid
.17448 0 m
.17448 .00375 L
s
.22098 0 m
.22098 .00375 L
s
.26749 0 m
.26749 .00375 L
s
.36049 0 m
.36049 .00375 L
s
.40699 0 m
.40699 .00375 L
s
.4535 0 m
.4535 .00375 L
s
.5465 0 m
.5465 .00375 L
s
.59301 0 m
.59301 .00375 L
s
.63951 0 m
.63951 .00375 L
s
.73251 0 m
.73251 .00375 L
s
.77902 0 m
.77902 .00375 L
s
.82552 0 m
.82552 .00375 L
s
.08147 0 m
.08147 .00375 L
s
.03497 0 m
.03497 .00375 L
s
.91853 0 m
.91853 .00375 L
s
.96503 0 m
.96503 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .12798 m
.00625 .12798 L
s
[(-400)] -0.0125 .12798 1 0 Mshowa
0 .31399 m
.00625 .31399 L
s
[(-200)] -0.0125 .31399 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .68601 m
.00625 .68601 L
s
[(200)] -0.0125 .68601 1 0 Mshowa
0 .87202 m
.00625 .87202 L
s
[(400)] -0.0125 .87202 1 0 Mshowa
.125 Mabswid
0 .17448 m
.00375 .17448 L
s
0 .22098 m
.00375 .22098 L
s
0 .26749 m
.00375 .26749 L
s
0 .36049 m
.00375 .36049 L
s
0 .40699 m
.00375 .40699 L
s
0 .4535 m
.00375 .4535 L
s
0 .5465 m
.00375 .5465 L
s
0 .59301 m
.00375 .59301 L
s
0 .63951 m
.00375 .63951 L
s
0 .73251 m
.00375 .73251 L
s
0 .77902 m
.00375 .77902 L
s
0 .82552 m
.00375 .82552 L
s
0 .08147 m
.00375 .08147 L
s
0 .03497 m
.00375 .03497 L
s
0 .91853 m
.00375 .91853 L
s
0 .96503 m
.00375 .96503 L
s
.25 Mabswid
0 0 m
0 1 L
s
.12798 .99375 m
.12798 1 L
s
.31399 .99375 m
.31399 1 L
s
.5 .99375 m
.5 1 L
s
.68601 .99375 m
.68601 1 L
s
.87202 .99375 m
.87202 1 L
s
.125 Mabswid
.17448 .99625 m
.17448 1 L
s
.22098 .99625 m
.22098 1 L
s
.26749 .99625 m
.26749 1 L
s
.36049 .99625 m
.36049 1 L
s
.40699 .99625 m
.40699 1 L
s
.4535 .99625 m
.4535 1 L
s
.5465 .99625 m
.5465 1 L
s
.59301 .99625 m
.59301 1 L
s
.63951 .99625 m
.63951 1 L
s
.73251 .99625 m
.73251 1 L
s
.77902 .99625 m
.77902 1 L
s
.82552 .99625 m
.82552 1 L
s
.08147 .99625 m
.08147 1 L
s
.03497 .99625 m
.03497 1 L
s
.91853 .99625 m
.91853 1 L
s
.96503 .99625 m
.96503 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .12798 m
1 .12798 L
s
.99375 .31399 m
1 .31399 L
s
.99375 .5 m
1 .5 L
s
.99375 .68601 m
1 .68601 L
s
.99375 .87202 m
1 .87202 L
s
.125 Mabswid
.99625 .17448 m
1 .17448 L
s
.99625 .22098 m
1 .22098 L
s
.99625 .26749 m
1 .26749 L
s
.99625 .36049 m
1 .36049 L
s
.99625 .40699 m
1 .40699 L
s
.99625 .4535 m
1 .4535 L
s
.99625 .5465 m
1 .5465 L
s
.99625 .59301 m
1 .59301 L
s
.99625 .63951 m
1 .63951 L
s
.99625 .73251 m
1 .73251 L
s
.99625 .77902 m
1 .77902 L
s
.99625 .82552 m
1 .82552 L
s
.99625 .08147 m
1 .08147 L
s
.99625 .03497 m
1 .03497 L
s
.99625 .91853 m
1 .91853 L
s
.99625 .96503 m
1 .96503 L
s
.25 Mabswid
1 0 m
1 1 L
s
% Start of colorimage (RGB)
p
.02381 .02381 translate
.95145 .95145 scale
600 string
200 200 8 [200 0 0 200 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  false 3 Mcolorimage
FFD100FFFF00CEFF009BFF0067FF0032FF0000FF0100FF3300FF6400FF9200FFBD00FFE5
00F7FF00D9FF00C0FF00ADFF00A0FF0098FF0097FF009CFF00A7FF00B7FF00CDFF00E8FF
00FFF700FFD300FFAC00FF8300FF5700FF2A02FF002EFF0059FF0082FF00A8FF00CAFF00
E8FF00FFFF00FFEB00FFDD00FFD600FFD400FFD900FFE300FFF400F6FF00DCFF00BEFF00
9CFF0078FF0053FF002EFF0008FF0000FF1A00FF3B00FF5900FF7200FF8700FF9500FF9E
00FFA100FF9E00FF9400FF8500FF7200FF5900FF3E00FF2100FF021BFF0037FF0051FF00
67FF0077FF0083FF0088FF0086FF007FFF0073FF0061FF004CFF0035FF001EFF0009FF00
00FF0900FF1700FF2000FF2200FF1E00FF1400FF0609FF0018FF0025FF002CFF002DFF00
27FF001DFF0015FF0014FF0019FF001AFF0013FF0009FF0002FF0002FF0007FF0013FF00
22FF0033FF0041FF004CFF0051FF0050FF0049FF003CFF002AFF0014FF0000FF0200FF19
00FF2E00FF4000FF4E00FF5600FF5900FF5500FF4B00FF3B00FF2600FF0D0EFF002CFF00
4AFF0068FF0084FF009CFF00B1FF00C1FF00CCFF00D0FF00CFFF00C7FF00B9FF00A6FF00
8DFF0071FF0050FF002DFF0008FF0000FF1D00FF4200FF6600FF8800FFA700FFC200FFD8
00FFEA00FFF500FFFB00FFFB00FFF400FFE800FFD500FFBE00FFA100FF7F00FF5A00FF32
00FF0724FF0051FF007EFF00AAFF00D4FF00FBFF00FFDF00FFBF00FFA300FF8C00FF7A00
FF6E00FF6800FF6800FF6E00FF7B00FF8D00FFA500FFC200FFE400F5FF00CAFF009DFF00
6CFF003AFF0006FF0000FF2D00FF6100FF9500FFC600FFF6
FFFF00D0FF009FFF006CFF0038FF0003FF0000FF3000FF6200FF9300FFC100FFED00EBFF
00C8FF00AAFF0091FF007EFF0070FF0069FF0068FF006DFF0077FF0088FF009EFF00B9FF
00D9FF00FDFF00FFDB00FFB200FF8600FF5900FF2C00FF002AFF0053FF0079FF009BFF00
B9FF00D1FF00E5FF00F2FF00FAFF00FCFF00F7FF00EDFF00DCFF00C7FF00ADFF008FFF00
6DFF0049FF0024FF0000FF0100FF2600FF4900FF6A00FF8800FFA100FFB600FFC400FFCD
00FFD000FFCD00FFC300FFB500FFA100FF8900FF6D00FF5000FF3100FF1308FF0022FF00
37FF0048FF0053FF0058FF0057FF0050FF0043FF0032FF001DFF0006FF0000FF1000FF26
00FF3800FF4700FF4F00FF5100FF4D00FF4300FF3600FF2500FF1600FF0900FF0200FF02
00FF0700FF1100FF1900FF1A00FF1500FF1400FF1B00FF2500FF2C00FF2D00FF2700FF1B
00FF0C04FF0012FF001DFF0022FF0021FF001AFF000DFF0000FF0400FF1A00FF3100FF48
00FF5D00FF6F00FF7D00FF8500FF8800FF8400FF7A00FF6A00FF5500FF3C00FF2000FF02
1BFF0039FF0055FF006DFF0082FF0092FF009DFF00A1FF00A0FF0098FF008AFF0077FF00
5EFF0041FF0021FF0000FF0100FF2600FF4C00FF7100FF9500FFB700FFD600FFF100F8FF
00E6FF00DBFF00D5FF00D5FF00DCFF00E8FF00FBFF00FFED00FFD000FFAE00FF8900FF61
00FF3600FF0A22FF004FFF007AFF00A5FF00CCFF00F1FF00FFEE00FFD200FFBB00FFA900
FF9D00FF9700FF9700FF9D00FFAA00FFBC00FFD400FFF100ECFF00C6FF009BFF006DFF00
3DFF000BFF0000FF2800FF5C00FF9000FFC400FFF600DAFF
CEFF009FFF006DFF003AFF0006FF0000FF2D00FF6100FF9400FFC500FFF300E1FF00BAFF
0097FF0079FF0060FF004CFF003FFF0038FF0036FF003BFF0046FF0057FF006DFF0088FF
00A7FF00CBFF00F2FF00FFE300FFB800FF8B00FF5E00FF3100FF0621FF0047FF0069FF00
87FF00A0FF00B3FF00C1FF00C9FF00CAFF00C6FF00BBFF00ABFF0095FF007BFF005DFF00
3CFF0018FF0000FF0C00FF3200FF5700FF7B00FF9C00FFB900FFD300FFE700FFF600FFFF
00FDFF00FFFE00FFF500FFE600FFD200FFBA00FF9F00FF8100FF6300FF4500FF2800FF0F
06FF0017FF0022FF0027FF0026FF001FFF0012FF0001FF0000FF1300FF2A00FF4100FF57
00FF6A00FF7800FF8000FF8300FF7F00FF7500FF6700FF5700FF4700FF3B00FF3300FF33
00FF3900FF4200FF4A00FF4B00FF4700FF4500FF4D00FF5600FF5D00FF5E00FF5800FF4C
00FF3D00FF2D00FF1E00FF1400FF0E00FF0F00FF1700FF2400FF3600FF4B00FF6200FF79
00FF8F00FFA100FFAE00FFB700FFB900FFB500FFAB00FF9B00FF8700FF6E00FF5200FF34
00FF1507FF0023FF003CFF0051FF0061FF006BFF0070FF006EFF0066FF0059FF0045FF00
2DFF0010FF0000FF0F00FF3300FF5700FF7D00FFA300FFC700FFE900F8FF00DDFF00C6FF
00B5FF00A9FF00A3FF00A4FF00AAFF00B7FF00C9FF00E1FF00FEFF00FFE000FFBB00FF92
00FF6800FF3C00FF0F1DFF0049FF0073FF009BFF00BFFF00E0FF00FCFF00FFEC00FFDB00
FFCF00FFC900FFC900FFCF00FFDB00FFED00FAFF00DDFF00BBFF0094FF006AFF003CFF00
0CFF0000FF2600FF5900FF8E00FFC200FFF500D8FF00A8FF
9BFF006CFF003AFF0007FF0000FF2C00FF6000FF9400FFC700FFF800D9FF00AEFF0087FF
0064FF0046FF002DFF0019FF000CFF0005FF0003FF0008FF0013FF0024FF003AFF0055FF
0074FF0098FF00BFFF00E9FF00FFEB00FFBE00FF9100FF6500FF3A00FF1114FF0036FF00
54FF006DFF0080FF008EFF0096FF0097FF0093FF0088FF0078FF0062FF0048FF002AFF00
09FF0000FF1A00FF3F00FF6500FF8A00FFAE00FFCF00FFEC00F9FF00E5FF00D6FF00CDFF
00CAFF00CEFF00D7FF00E6FF00FAFF00FFED00FFD200FFB400FF9600FF7800FF5B00FF42
00FF2C00FF1B00FF1000FF0B00FF0C00FF1300FF2000FF3200FF4600FF5D00FF7400FF8A
00FF9D00FFAB00FFB400FFB600FFB200FFA800FF9A00FF8A00FF7A00FF6E00FF6600FF66
00FF6C00FF7500FF7E00FF7E00FF7A00FF7900FF8000FF8900FF9000FF9100FF8B00FF7F
00FF7000FF6000FF5100FF4700FF4100FF4200FF4A00FF5700FF6900FF7E00FF9500FFAC
00FFC200FFD400FFE100FFEA00FFEC00FFE800FFDE00FFCF00FFBA00FFA100FF8500FF67
00FF4900FF2B00FF0F09FF001EFF002EFF0038FF003DFF003BFF0033FF0026FF0012FF00
00FF0500FF2200FF4300FF6600FF8B00FFB000FFD600FFFA00E3FF00C4FF00A9FF0093FF
0082FF0076FF0070FF0071FF0077FF0084FF0096FF00AEFF00CBFF00ECFF00FFEE00FFC6
00FF9B00FF6F00FF4200FF1516FF0040FF0068FF008CFF00ADFF00C9FF00E0FF00F1FF00
FDFF00FFFC00FFFC00FDFF00F1FF00DFFF00C7FF00AAFF0088FF0061FF0037FF0009FF00
00FF2600FF5900FF8D00FFC100FFF500D7FF00A5FF0075FF
67FF0038FF0006FF0000FF2C00FF6000FF9400FFC800FFFB00D3FF00A5FF007AFF0053FF
0030FF0011FF0600FF1A00FF2700FF2E00FF3000FF2B00FF2000FF1000FF0005FF0021FF
0040FF0064FF008BFF00B5FF00E0FF00FFF200FFC500FF9900FF6E00FF4500FF1F02FF00
20FF0039FF004CFF005AFF0062FF0063FF005EFF0054FF0044FF002EFF0014FF0000FF09
00FF2A00FF4E00FF7300FF9900FFBE00FFE200FCFF00DFFF00C5FF00B1FF00A2FF0099FF
0096FF009AFF00A3FF00B2FF00C6FF00DEFF00F9FF00FFE800FFCA00FFAC00FF8F00FF76
00FF6000FF4F00FF4400FF3F00FF4000FF4700FF5400FF6600FF7A00FF9100FFA800FFBE
00FFD100FFDF00FFE800FFEA00FFE600FFDC00FFCE00FFBE00FFAE00FFA200FF9B00FF9A
00FFA000FFAA00FFB200FFB200FFAE00FFAD00FFB400FFBD00FFC400FFC500FFBF00FFB4
00FFA400FF9400FF8500FF7B00FF7600FF7600FF7E00FF8B00FF9D00FFB200FFC900FFE0
00FFF600F7FF00E9FF00E1FF00DFFF00E3FF00EDFF00FCFF00FFEE00FFD500FFB900FF9B
00FF7D00FF5F00FF4300FF2A00FF1500FF0604FF0009FF0007FF0000FF0000FF0E00FF21
00FF3900FF5600FF7700FF9A00FFBF00FFE400F5FF00D1FF00AFFF0090FF0075FF005FFF
004EFF0042FF003CFF003DFF0043FF0050FF0062FF007AFF0097FF00B8FF00DDFF00FFFA
00FFCF00FFA300FF7600FF4900FF1D0CFF0034FF0058FF0079FF0095FF00ACFF00BDFF00
C9FF00CFFF00CFFF00C9FF00BDFF00ABFF0093FF0076FF0054FF002DFF0003FF0000FF2A
00FF5B00FF8D00FFC100FFF500D6FF00A3FF0071FF0041FF
32FF0003FF0000FF2D00FF6000FF9400FFC900FFFD00D0FF009FFF0071FF0046FF001EFF
0400FF2200FF3B00FF4E00FF5B00FF6300FF6400FF5F00FF5400FF4400FF2E00FF1300FF
000CFF0030FF0057FF0080FF00ACFF00D9FF00FFF900FFCD00FFA200FF7900FF5300FF31
00FF1304FF0018FF0026FF002DFF002FFF002AFF0020FF000FFF0000FF0500FF1F00FF3D
00FF5F00FF8300FFA800FFCD00FFF300E9FF00C8FF00AAFF0091FF007DFF006EFF0065FF
0062FF0065FF006FFF007EFF0091FF00AAFF00C5FF00E2FF00FFFE00FFE000FFC400FFAA
00FF9400FF8400FF7800FF7300FF7500FF7C00FF8800FF9A00FFAF00FFC600FFDD00FFF2
00FAFF00ECFF00E3FF00E1FF00E5FF00EFFF00FDFF00FFF200FFE300FFD600FFCF00FFCE
00FFD400FFDE00FFE600FFE700FFE200FFE100FFE800FFF200FFF900FFF900FFF400FFE8
00FFD900FFC800FFBA00FFAF00FFAA00FFAB00FFB200FFBF00FFD100FFE700FFFE00EAFF
00D5FF00C3FF00B5FF00ADFF00AAFF00AEFF00B8FF00C8FF00DDFF00F6FF00FFED00FFCF
00FFB100FF9300FF7700FF5F00FF4A00FF3A00FF2F00FF2B00FF2C00FF3400FF4200FF55
00FF6E00FF8A00FFAB00FFCE00FFF300E6FF00C1FF009DFF007BFF005CFF0041FF002BFF
0019FF000EFF0008FF0008FF000FFF001BFF002EFF0045FF0062FF0084FF00A9FF00D1FF
00FCFF00FFD700FFAA00FF7D00FF5100FF2700FF0024FF0044FF0060FF0077FF0089FF00
95FF009BFF009BFF0095FF0088FF0076FF005EFF0041FF001FFF0000FF0600FF3100FF5E
00FF8F00FFC100FFF500D6FF00A2FF006EFF003DFF000DFF
00FF0100FF3000FF6100FF9400FFC800FFFD00CFFF009CFF006BFF003DFF0012FF1500FF
3800FF5600FF6F00FF8200FF8F00FF9700FF9800FF9300FF8800FF7800FF6200FF4700FF
2700FF0300FF0023FF004DFF0078FF00A5FF00D2FF00FEFF00FFD600FFAD00FF8700FF65
00FF4700FF2E00FF1B00FF0D00FF0600FF0400FF0900FF1300FF2300FF3900FF5300FF71
00FF9300FFB600FFDC00FEFF00D9FF00B5FF0094FF0076FF005DFF0049FF003AFF0031FF
002EFF0031FF003BFF004AFF005EFF0076FF0091FF00AEFF00CDFF00EBFF00FFF800FFDE
00FFC800FFB800FFAC00FFA700FFA800FFB000FFBC00FFCE00FFE300FFF900EEFF00D9FF
00C6FF00B8FF00AFFF00ADFF00B1FF00BBFF00C9FF00D9FF00E9FF00F5FF00FCFF00FDFF
00F7FF00EDFF00E5FF00E5FF00E9FF00EAFF00E3FF00D9FF00D3FF00D2FF00D8FF00E3FF
00F3FF00FFFC00FFEE00FFE300FFDE00FFDF00FFE600FFF300FAFF00E5FF00CEFF00B6FF
00A1FF008FFF0081FF0079FF0077FF007AFF0084FF0094FF00A9FF00C2FF00DEFF00FCFF
00FFE500FFC700FFAB00FF9200FF7E00FF6E00FF6300FF5F00FF6000FF6800FF7600FF89
00FFA100FFBE00FFDF00FDFF00D8FF00B3FF008DFF0069FF0047FF0028FF000DFF0800FF
1900FF2500FF2B00FF2B00FF2400FF1800FF0500FF0012FF002EFF0050FF0075FF009DFF
00C8FF00F4FF00FFDE00FFB100FF8500FF5B00FF3400FF0F10FF002CFF0043FF0055FF00
61FF0067FF0067FF0061FF0055FF0042FF002BFF000DFF0000FF1400FF3A00FF6500FF92
00FFC300FFF500D6FF00A2FF006EFF003AFF0009FF2600FF
00FF3300FF6200FF9400FFC700FFFB00D0FF009CFF0069FF0038FF000AFF2000FF4700FF
6A00FF8800FFA100FFB500FFC200FFC900FFCB00FFC600FFBB00FFAA00FF9400FF7900FF
5A00FF3600FF0F00FF001AFF0045FF0072FF009FFF00CCFF00F7FF00FFE000FFBA00FF98
00FF7A00FF6100FF4E00FF4000FF3800FF3700FF3B00FF4600FF5600FF6C00FF8600FFA4
00FFC500FFE900F1FF00CBFF00A6FF0082FF0061FF0044FF002AFF0016FF0007FF0100FF
0400FF0000FF0008FF0017FF002BFF0043FF005EFF007CFF009AFF00B8FF00D5FF00EEFF
00FFFB00FFEA00FFDF00FFDA00FFDB00FFE200FFEF00FFFF00EAFF00D3FF00BCFF00A6FF
0093FF0085FF007DFF007AFF007EFF0088FF0096FF00A6FF00B6FF00C2FF00CAFF00CAFF
00C4FF00BBFF00B3FF00B2FF00B6FF00B8FF00B0FF00A7FF00A0FF009FFF00A5FF00B1FF
00C0FF00D0FF00DFFF00E9FF00EFFF00EEFF00E6FF00D9FF00C7FF00B2FF009BFF0084FF
006EFF005CFF004FFF0046FF0044FF0048FF0052FF0062FF0076FF008FFF00ABFF00C9FF
00E8FF00FFFA00FFDE00FFC500FFB000FFA000FF9600FF9100FF9300FF9B00FFA800FFBC
00FFD400FFF100EEFF00CAFF00A6FF0080FF005AFF0036FF0014FF0900FF2400FF3B00FF
4C00FF5800FF5E00FF5D00FF5700FF4A00FF3800FF2000FF0300FF001DFF0042FF006BFF
0095FF00C1FF00EEFF00FFE400FFB800FF8E00FF6600FF4200FF2100FF0511FF0022FF00
2EFF0034FF0034FF002EFF0022FF0010FF0000FF0700FF2400FF4600FF6D00FF9700FFC5
00FFF500D7FF00A4FF006FFF003BFF0008FF2900FF5900FF
00FF6400FF9300FFC500FFF800D3FF009FFF006BFF0038FF0008FF2600FF5100FF7800FF
9B00FFB900FFD200FFE500FFF300FFFA00FFFB00FFF700FFEC00FFDB00FFC500FFAA00FF
8A00FF6700FF4000FF1600FF0015FF0041FF006EFF009BFF00C6FF00EFFF00FFEB00FFC9
00FFAB00FF9200FF7E00FF7100FF6900FF6800FF6C00FF7700FF8700FF9C00FFB700FFD5
00FFF600E5FF00C0FF009AFF0075FF0051FF0030FF0013FF0500FF1A00FF2900FF3200FF
3400FF3100FF2800FF1900FF0500FF0012FF002DFF004BFF0069FF0087FF00A4FF00BDFF
00D3FF00E4FF00EFFF00F4FF00F3FF00ECFF00DFFF00CEFF00B9FF00A2FF008BFF0075FF
0062FF0054FF004CFF0049FF004EFF0057FF0065FF0075FF0085FF0092FF0099FF0099FF
0093FF008AFF0082FF0081FF0086FF0087FF0080FF0076FF006FFF006EFF0074FF0080FF
008FFF009FFF00AEFF00B9FF00BEFF00BDFF00B5FF00A8FF0096FF0081FF006AFF0053FF
003EFF002BFF001EFF0015FF0013FF0017FF0021FF0031FF0046FF005FFF007AFF0098FF
00B7FF00D4FF00F0FF00FFF600FFE100FFD100FFC700FFC200FFC400FFCC00FFD900FFED
00FAFF00DDFF00BDFF009AFF0075FF004FFF002AFF0006FF1B00FF3A00FF5500FF6C00FF
7D00FF8900FF8E00FF8E00FF8800FF7B00FF6900FF5100FF3400FF1300FF0011FF003AFF
0064FF0091FF00BDFF00EAFF00FFE900FFBF00FF9700FF7300FF5200FF3600FF1F00FF0D
00FF0104FF0003FF0000FF0200FF0E00FF2000FF3800FF5500FF7700FF9E00FFC800FFF6
00D9FF00A6FF0073FF003EFF000AFF2800FF5A00FF8900FF
00FF9200FFC100FFF300D9FF00A5FF0071FF003DFF000AFF2600FF5400FF7F00FFA600FF
C900FFE700FFFF00FFFF00EBFF00DEFF00D7FF00D5FF00DAFF00E5FF00F5F300FFD800FF
B900FF9500FF6E00FF4400FF1900FF0013FF0040FF006CFF0097FF00C0FF00E6FF00FFF7
00FFD900FFC000FFAD00FF9F00FF9700FF9600FF9A00FFA500FFB500FFCB00FFE500FCFF
00DBFF00B7FF0092FF006CFF0047FF0023FF0002FF1A00FF3400FF4800FF5700FF6000FF
6300FF5F00FF5600FF4700FF3300FF1B00FF0000FF001DFF003BFF0059FF0076FF008FFF
00A5FF00B6FF00C1FF00C6FF00C5FF00BEFF00B1FF009FFF008BFF0074FF005DFF0047FF
0034FF0026FF001DFF001BFF001FFF0029FF0037FF0047FF0057FF0063FF006AFF006BFF
0065FF005BFF0053FF0053FF0057FF0058FF0051FF0048FF0041FF0040FF0046FF0052FF
0061FF0071FF0080FF008AFF008FFF008FFF0087FF007AFF0068FF0053FF003CFF0025FF
000FFF0200FF1000FF1800FF1A00FF1600FF0C00FF0002FF0017FF0030FF004CFF006AFF
0088FF00A6FF00C2FF00DBFF00F0FF00FFFF00FFF500FFF000FFF200FFFA00F7FF00E4FF
00CCFF00AFFF008EFF006BFF0046FF0021FF0400FF2800FF4A00FF6900FF8400FF9A00FF
AB00FFB700FFBD00FFBC00FFB600FFA900FF9700FF7F00FF6200FF4100FF1C00FF000BFF
0036FF0062FF008FFF00BCFF00E8FF00FFED00FFC500FFA100FF8000FF6400FF4D00FF3C
00FF3000FF2A00FF2A00FF3000FF3C00FF4E00FF6600FF8300FFA500FFCC00FFF600DBFF
00ABFF0078FF0044FF0010FF2300FF5600FF8800FFB800FF
00FFBD00FFED00E1FF00AEFF007AFF0046FF0012FF2000FF5100FF7F00FFAA00FFD100FF
F400FFFF00ECFF00D4FF00C0FF00B3FF00ABFF00AAFF00AFFF00BAFF00CAFF00E0FF00FC
E400FFC000FF9900FF6F00FF4400FF1700FF0015FF0041FF006CFF0095FF00BBFF00DDFF
00FBFF00FFEB00FFD800FFCA00FFC300FFC100FFC600FFD000FFE000FFF600EFFF00D1FF
00AFFF008CFF0066FF0041FF001CFF0700FF2800FF4600FF5F00FF7300FF8200FF8B00FF
8E00FF8A00FF8100FF7200FF5E00FF4600FF2B00FF0D00FF0010FF002EFF004AFF0064FF
007AFF008BFF0096FF009BFF009AFF0092FF0086FF0074FF0060FF0049FF0032FF001CFF
0009FF0400FF0D00FF0F00FF0B00FF0100FF000CFF001CFF002CFF0038FF003FFF0040FF
003AFF0030FF0028FF0028FF002CFF002DFF0026FF001DFF0016FF0015FF001BFF0026FF
0036FF0046FF0054FF005FFF0064FF0063FF005CFF004FFF003DFF0028FF0011FF0500FF
1B00FF2D00FF3B00FF4300FF4500FF4100FF3700FF2800FF1300FF0005FF0021FF003FFF
005DFF007BFF0097FF00B0FF00C4FF00D4FF00DFFF00E3FF00E2FF00DAFF00CCFF00B9FF
00A1FF0084FF0063FF0040FF001BFF0900FF2F00FF5300FF7500FF9400FFAF00FFC500FF
D600FFE200FFE800FFE700FFE100FFD400FFC200FFAA00FF8D00FF6C00FF4700FF1F00FF
000BFF0037FF0064FF0091FF00BDFF00E7FF00FFF000FFCC00FFAC00FF9000FF7800FF67
00FF5B00FF5500FF5500FF5B00FF6700FF7A00FF9100FFAF00FFD100FFF700DEFF00B0FF
007FFF004DFF0019FF1A00FF4E00FF8100FFB300FFE300FF
00FFE500EBFF00BAFF0087FF0053FF001EFF1500FF4700FF7800FFA600FFD100FFF900FF
FF00E3FF00C5FF00ACFF0099FF008CFF0084FF0083FF0088FF0092FF00A3FF00B9FF00D4
FF00F4E700FFC000FF9700FF6B00FF3E00FF1100FF001AFF0045FF006EFF0094FF00B6FF
00D4FF00ECFF00FFFF00FFF100FFEA00FFE800FFED00FFF700F7FF00E2FF00C8FF00AAFF
0088FF0064FF003FFF0019FF0B00FF2E00FF4F00FF6D00FF8600FF9B00FFA900FFB200FF
B500FFB200FFA800FF9A00FF8600FF6E00FF5200FF3500FF1600FF0007FF0023FF003DFF
0052FF0063FF006EFF0074FF0072FF006BFF005EFF004DFF0038FF0021FF000AFF0B00FF
1D00FF2B00FF3400FF3600FF3200FF2800FF1A00FF0A00FF0004FF0011FF0018FF0019FF
0013FF0009FF0001FF0000FF0005FF0006FF0000FF0A00FF1100FF1200FF0C00FF0000FF
000EFF001FFF002DFF0038FF003DFF003CFF0035FF0028FF0016FF0000FF1600FF2D00FF
4200FF5400FF6200FF6A00FF6D00FF6900FF5F00FF4F00FF3A00FF2100FF0500FF0018FF
0036FF0054FF0070FF0088FF009DFF00ADFF00B8FF00BCFF00BBFF00B3FF00A5FF0092FF
0079FF005CFF003CFF0019FF0B00FF3100FF5600FF7A00FF9C00FFBB00FFD600FFEC00FF
FE00FFFF00F6FF00F0FF00F0FF00F7FC00FFE900FFD200FFB500FF9300FF6E00FF4600FF
1B00FF0010FF003DFF006AFF0095FF00C0FF00E7FF00FFF300FFD300FFB700FFA000FF8E
00FF8200FF7C00FF7C00FF8200FF8F00FFA100FFB900FFD600FFF800E1FF00B6FF0088FF
0058FF0026FF0D00FF4100FF7500FFA900FFDB00FFFF00F5
00F7FF00C8FF0097FF0064FF0030FF0400FF3800FF6A00FF9B00FFC900FFF400FFFF00E3
FF00C0FF00A2FF0089FF0076FF0069FF0061FF0060FF0065FF0070FF0080FF0096FF00B1
FF00D1FF00F5E300FFBA00FF8E00FF6100FF3400FF0800FF0022FF004BFF0071FF0093FF
00B1FF00C9FF00DDFF00EBFF00F2FF00F4FF00EFFF00E5FF00D4FF00BFFF00A5FF0087FF
0065FF0041FF001CFF0800FF2E00FF5100FF7200FF9000FFA900FFBE00FFCC00FFD500FF
D800FFD500FFCB00FFBC00FFA900FF9000FF7500FF5800FF3900FF1B00FF0000FF001AFF
002FFF0040FF004BFF0051FF004FFF0048FF003BFF002AFF0015FF0100FF1800FF2E00FF
4000FF4E00FF5700FF5900FF5500FF4B00FF3D00FF2D00FF1E00FF1100FF0A00FF0900FF
0F00FF1900FF2100FF2200FF1D00FF1C00FF2300FF2D00FF3400FF3500FF2F00FF2300FF
1400FF0300FF000AFF0015FF001AFF0019FF0012FF0005FF0C00FF2200FF3900FF5000FF
6500FF7700FF8500FF8D00FF9000FF8C00FF8200FF7200FF5D00FF4400FF2800FF0A00FF
0013FF0031FF004DFF0065FF007AFF008AFF0095FF0099FF0098FF0090FF0082FF006FFF
0056FF0039FF0019FF0900FF2E00FF5400FF7900FF9D00FFBF00FFDE00FFF900FFFF00F0
FF00DEFF00D3FF00CDFF00CDFF00D4FF00E0FF00F3F500FFD800FFB600FF9100FF6900FF
3E00FF1200FF001AFF0047FF0073FF009DFF00C4FF00E9FF00FFF600FFDA00FFC300FFB1
00FFA500FF9F00FF9F00FFA500FFB200FFC400FFDC00FFF900E4FF00BEFF0093FF0066FF
0035FF0003FF3000FF6400FF9800FFCC00FFFE00FFFF00D2
00D9FF00AAFF0079FF0046FF0011FF2200FF5600FF8800FFB900FFE700FFFF00ECFF00C5
FF00A2FF0084FF006BFF0058FF004AFF0043FF0042FF0047FF0051FF0062FF0078FF0093
FF00B3FF00D6FF00FED800FFAC00FF7F00FF5300FF2600FF0004FF002DFF0053FF0075FF
0092FF00ABFF00BFFF00CCFF00D4FF00D6FF00D1FF00C6FF00B6FF00A1FF0087FF0068FF
0047FF0023FF0100FF2700FF4C00FF6F00FF9000FFAE00FFC700FFDC00FFEB00FFF300FF
F600FFF300FFEA00FFDB00FFC700FFAF00FF9300FF7600FF5700FF3900FF1D00FF0300FF
0011FF0022FF002DFF0032FF0031FF002AFF001DFF000CFF0800FF1F00FF3600FF4C00FF
5E00FF6D00FF7500FF7700FF7300FF6A00FF5C00FF4B00FF3C00FF2F00FF2800FF2800FF
2D00FF3700FF3F00FF4000FF3B00FF3A00FF4100FF4B00FF5200FF5300FF4D00FF4100FF
3200FF2200FF1300FF0800FF0300FF0400FF0B00FF1900FF2A00FF4000FF5700FF6E00FF
8300FF9500FFA300FFAB00FFAE00FFAA00FFA000FF9000FF7B00FF6200FF4600FF2800FF
0A00FF0013FF002EFF0047FF005CFF006CFF0076FF007BFF0079FF0072FF0064FF0051FF
0038FF001BFF0400FF2700FF4C00FF7200FF9700FFBB00FFDD00FFFC00FFFF00E8FF00D1
FF00C0FF00B5FF00AFFF00AFFF00B6FF00C2FF00D4FF00ECF600FFD500FFAF00FF8700FF
5C00FF3000FF0300FF0028FF0054FF007FFF00A6FF00CBFF00EBFF00FFF800FFE100FFCF
00FFC300FFBD00FFBD00FFC400FFD000FFE200FFFA00E8FF00C6FF00A0FF0075FF0047FF
0017FF1A00FF4E00FF8200FFB700FFEA00FFFF00E3FF00B4
00C0FF0091FF0060FF002DFF0600FF3B00FF6F00FFA100FFD200FFFF00FFFF00D4FF00AC
FF0089FF006BFF0052FF003FFF0032FF002AFF0029FF002EFF0038FF0049FF005FFF007A
FF009AFF00BEFF00E5F100FFC500FF9800FF6B00FF3F00FF1400FF0014FF003AFF005CFF
007AFF0092FF00A6FF00B4FF00BBFF00BDFF00B8FF00AEFF009DFF0088FF006EFF0050FF
002EFF000AFF1A00FF4000FF6500FF8800FFA900FFC700FFE000FFF500FFFF00FCFF00F3
FF00F0FF00F3FF00FDF300FFE000FFC800FFAC00FF8F00FF7000FF5200FF3600FF1C00FF
0700FF0009FF0014FF001AFF0018FF0011FF0004FF0C00FF2100FF3800FF4F00FF6500FF
7700FF8500FF8E00FF9000FF8C00FF8200FF7400FF6400FF5500FF4800FF4100FF4000FF
4600FF5000FF5800FF5900FF5400FF5300FF5A00FF6400FF6B00FF6C00FF6600FF5A00FF
4B00FF3A00FF2C00FF2100FF1C00FF1D00FF2400FF3100FF4300FF5900FF7000FF8700FF
9C00FFAE00FFBC00FFC400FFC700FFC300FFB900FFA900FF9400FF7B00FF5F00FF4100FF
2300FF0500FF0016FF002EFF0043FF0053FF005EFF0062FF0061FF0059FF004BFF0038FF
001FFF0002FF1D00FF4000FF6500FF8B00FFB000FFD400FFF600FFFF00EAFF00CFFF00B9
FF00A7FF009CFF0096FF0096FF009DFF00A9FF00BCFF00D3FF00F0ED00FFC800FFA000FF
7500FF4900FF1C00FF0010FF003BFF0066FF008DFF00B2FF00D2FF00EEFF00FFFA00FFE8
00FFDC00FFD600FFD600FFDC00FFE900FFFB00ECFF00CFFF00ADFF0087FF005CFF002FFF
0100FF3300FF6700FF9B00FFCF00FFFF00FCFF00CAFF009B
00ADFF007EFF004CFF0019FF1A00FF4E00FF8200FFB500FFE500FFFF00EBFF00C0FF0099
FF0076FF0058FF003FFF002CFF001EFF0017FF0016FF001AFF0025FF0036FF004CFF0067
FF0087FF00AAFF00D1FF00FBD800FFAC00FF7F00FF5200FF2700FF0001FF0026FF0049FF
0066FF007FFF0093FF00A0FF00A8FF00A9FF00A5FF009AFF008AFF0075FF005AFF003CFF
001BFF0800FF2D00FF5300FF7800FF9B00FFBD00FFDA00FFF300FFFF00F7FF00E8FF00DF
FF00DDFF00E0FF00E9FF00F8F300FFDB00FFBF00FFA200FF8400FF6600FF4900FF3000FF
1A00FF0900FF0001FF0006FF0005FF0100FF0E00FF1F00FF3400FF4B00FF6200FF7800FF
8B00FF9900FFA100FFA400FF9F00FF9600FF8800FF7800FF6800FF5B00FF5400FF5400FF
5A00FF6300FF6B00FF6C00FF6700FF6600FF6D00FF7700FF7E00FF7F00FF7900FF6D00FF
5E00FF4E00FF3F00FF3400FF2F00FF3000FF3800FF4500FF5700FF6C00FF8300FF9A00FF
AF00FFC100FFCF00FFD800FFDA00FFD600FFCC00FFBC00FFA700FF8E00FF7200FF5500FF
3600FF1800FF0002FF001BFF0030FF0040FF004AFF004FFF004DFF0046FF0038FF0024FF
000CFF1000FF3000FF5300FF7800FF9E00FFC300FFE700FFFF00F6FF00D7FF00BCFF00A5
FF0094FF0088FF0083FF0083FF0089FF0096FF00A8FF00C0FF00DDFF00FEDC00FFB300FF
8900FF5C00FF2F00FF0300FF0028FF0052FF007AFF009EFF00BFFF00DBFF00F2FF00FFFB
00FFEF00FFE900FFEA00FFF000FFFC00F1FF00D9FF00BCFF009AFF0073FF0049FF001BFF
1400FF4700FF7A00FFAF00FFE300FFFF00E9FF00B7FF0088
00A0FF0070FF003FFF000CFF2700FF5B00FF8F00FFC200FFF300FFFF00DEFF00B3FF008C
FF0069FF004AFF0032FF001EFF0011FF0009FF0008FF000DFF0018FF0028FF003EFF005A
FF0079FF009DFF00C4FF00EEE600FFB900FF8C00FF6000FF3500FF0C00FF0019FF003BFF
0059FF0072FF0085FF0093FF009AFF009CFF0097FF008DFF007DFF0067FF004DFF002FFF
000DFF1500FF3B00FF6000FF8500FFA900FFCA00FFE800FFFF00FEFF00EAFF00DBFF00D2
FF00CFFF00D3FF00DCFF00EBFF00FFE800FFCD00FFAF00FF9100FF7300FF5700FF3D00FF
2700FF1600FF0B00FF0600FF0700FF0F00FF1B00FF2D00FF4100FF5800FF6F00FF8500FF
9800FFA600FFAF00FFB100FFAD00FFA300FF9500FF8500FF7500FF6900FF6200FF6100FF
6700FF7100FF7900FF7900FF7500FF7400FF7B00FF8400FF8B00FF8C00FF8600FF7B00FF
6B00FF5B00FF4D00FF4200FF3D00FF3E00FF4500FF5200FF6400FF7900FF9000FFA700FF
BD00FFCF00FFDD00FFE500FFE700FFE300FFD900FFCA00FFB500FF9C00FF8000FF6200FF
4400FF2600FF0A00FF000EFF0022FF0032FF003DFF0041FF0040FF0038FF002AFF0017FF
0000FF1D00FF3E00FF6100FF8600FFAB00FFD100FFF500FFFF00E8FF00C9FF00AEFF0098
FF0087FF007BFF0075FF0076FF007CFF0089FF009BFF00B3FF00D0FF00F1E900FFC100FF
9600FF6A00FF3D00FF1000FF001BFF0045FF006DFF0091FF00B1FF00CDFF00E5FF00F6FF
00FFFD00FFF700FFF700FFFD00F6FF00E3FF00CCFF00AEFF008CFF0066FF003CFF000EFF
2200FF5400FF8800FFBC00FFF000FFFF00DCFF00AAFF007A
0098FF0069FF0038FF0005FF2E00FF6300FF9700FFC900FFFA00FFFF00D7FF00ABFF0084
FF0061FF0043FF002AFF0017FF0009FF0002FF0001FF0006FF0010FF0021FF0037FF0052
FF0072FF0095FF00BDFF00E6ED00FFC000FF9300FF6700FF3C00FF1300FF0012FF0034FF
0051FF006AFF007EFF008BFF0093FF0095FF0090FF0085FF0075FF0060FF0046FF0027FF
0006FF1D00FF4200FF6800FF8D00FFB000FFD100FFEF00FFFF00F7FF00E2FF00D3FF00CB
FF00C8FF00CBFF00D5FF00E3FF00F7F000FFD400FFB700FF9800FF7A00FF5E00FF4400FF
2F00FF1E00FF1300FF0E00FF0F00FF1600FF2300FF3400FF4900FF6000FF7700FF8D00FF
9F00FFAE00FFB600FFB800FFB400FFAA00FF9D00FF8C00FF7D00FF7000FF6900FF6900FF
6E00FF7800FF8000FF8100FF7C00FF7B00FF8200FF8C00FF9300FF9400FF8E00FF8200FF
7300FF6200FF5400FF4900FF4400FF4500FF4C00FF5900FF6B00FF8100FF9800FFAF00FF
C400FFD600FFE400FFEC00FFEF00FFEB00FFE100FFD100FFBC00FFA300FF8700FF6900FF
4B00FF2D00FF1100FF0006FF001BFF002BFF0035FF003AFF0038FF0031FF0023FF0010FF
0800FF2500FF4500FF6800FF8D00FFB300FFD800FFFC00FFFF00E1FF00C2FF00A7FF0091
FF007FFF0074FF006EFF006EFF0075FF0081FF0093FF00ABFF00C8FF00E9F000FFC800FF
9D00FF7100FF4400FF1700FF0013FF003EFF0065FF008AFF00AAFF00C6FF00DDFF00EFFF
00FBFF00FFFE00FFFE00FAFF00EEFF00DCFF00C4FF00A7FF0085FF005FFF0034FF0006FF
2900FF5B00FF8F00FFC300FFF700FFFF00D4FF00A2FF0073
0097FF0068FF0036FF0003FF3000FF6400FF9800FFCB00FFFB00FFFF00D5FF00AAFF0083
FF0060FF0042FF0029FF0016FF0008FF0001FF0000FF0004FF000FFF0020FF0036FF0051
FF0071FF0094FF00BBFF00E5EE00FFC200FF9500FF6800FF3D00FF1500FF0010FF0032FF
0050FF0069FF007CFF008AFF0092FF0093FF008FFF0084FF0074FF005FFF0044FF0026FF
0005FF1E00FF4300FF6900FF8E00FFB200FFD300FFF000FFFF00F5FF00E1FF00D2FF00C9
FF00C7FF00CAFF00D3FF00E2FF00F6F100FFD600FFB800FF9A00FF7C00FF5F00FF4600FF
3000FF1F00FF1400FF0F00FF1000FF1700FF2400FF3500FF4A00FF6100FF7800FF8E00FF
A100FFAF00FFB700FFBA00FFB500FFAC00FF9E00FF8E00FF7E00FF7100FF6A00FF6A00FF
7000FF7900FF8100FF8200FF7D00FF7C00FF8300FF8D00FF9400FF9500FF8F00FF8300FF
7400FF6400FF5500FF4B00FF4500FF4600FF4E00FF5B00FF6D00FF8200FF9900FFB000FF
C500FFD800FFE500FFEE00FFF000FFEC00FFE200FFD200FFBD00FFA500FF8900FF6B00FF
4C00FF2F00FF1300FF0005FF001AFF002AFF0034FF0039FF0037FF002FFF0022FF000EFF
0900FF2600FF4600FF6900FF8E00FFB400FFD900FFFE00FFFF00E0FF00C1FF00A6FF008F
FF007EFF0072FF006DFF006DFF0073FF0080FF0092FF00AAFF00C7FF00E8F200FFC900FF
9F00FF7200FF4600FF1900FF0012FF003CFF0064FF0088FF00A9FF00C5FF00DCFF00EEFF
00FAFF00FFFF00FFFF00F9FF00EDFF00DBFF00C3FF00A6FF0084FF005DFF0033FF0005FF
2A00FF5D00FF9000FFC500FFF900FFFF00D3FF00A1FF0071
009CFF006DFF003BFF0008FF2B00FF5F00FF9300FFC600FFF700FFFF00DAFF00AFFF0088
FF0065FF0047FF002EFF001AFF000DFF0006FF0004FF0009FF0014FF0025FF003BFF0056
FF0075FF0099FF00C0FF00EAEA00FFBD00FF9000FF6400FF3900FF1000FF0015FF0037FF
0055FF006EFF0081FF008FFF0097FF0098FF0094FF0089FF0079FF0063FF0049FF002BFF
000AFF1900FF3E00FF6400FF8900FFAD00FFCE00FFEB00FFFF00FAFF00E6FF00D7FF00CE
FF00CBFF00CFFF00D8FF00E7FF00FBEC00FFD100FFB300FF9500FF7700FF5A00FF4100FF
2B00FF1A00FF0F00FF0A00FF0B00FF1200FF1F00FF3000FF4500FF5C00FF7300FF8900FF
9C00FFAA00FFB300FFB500FFB100FFA700FF9900FF8900FF7900FF6D00FF6500FF6500FF
6B00FF7400FF7C00FF7D00FF7900FF7800FF7F00FF8800FF8F00FF9000FF8A00FF7E00FF
6F00FF5F00FF5000FF4600FF4000FF4100FF4900FF5600FF6800FF7D00FF9400FFAB00FF
C100FFD300FFE000FFE900FFEB00FFE700FFDD00FFCD00FFB900FFA000FF8400FF6600FF
4700FF2A00FF0E00FF000AFF001FFF002FFF0039FF003EFF003CFF0034FF0027FF0013FF
0400FF2100FF4200FF6500FF8A00FFAF00FFD500FFF900FFFF00E4FF00C5FF00AAFF0094
FF0083FF0077FF0071FF0072FF0078FF0085FF0097FF00AFFF00CCFF00EDED00FFC500FF
9A00FF6E00FF4100FF1400FF0017FF0041FF0069FF008DFF00AEFF00CAFF00E1FF00F2FF
00FEFF00FFFB00FFFB00FEFF00F2FF00E0FF00C8FF00ABFF0089FF0062FF0038FF000AFF
2500FF5800FF8B00FFC000FFF400FFFF00D8FF00A6FF0076
00A7FF0077FF0046FF0013FF2000FF5400FF8800FFBB00FFEC00FFFF00E5FF00BAFF0092
FF0070FF0051FF0038FF0025FF0018FF0010FF000FFF0014FF001FFF002FFF0045FF0060
FF0080FF00A4FF00CBFF00F5DF00FFB200FF8500FF5900FF2E00FF0500FF0020FF0042FF
0060FF0079FF008CFF009AFF00A1FF00A3FF009EFF0094FF0084FF006EFF0054FF0036FF
0014FF0E00FF3400FF5900FF7E00FFA200FFC300FFE100FFFA00FFFF00F1FF00E2FF00D9
FF00D6FF00DAFF00E3FF00F2F900FFE100FFC600FFA800FF8A00FF6C00FF5000FF3600FF
2000FF0F00FF0400FF0000FF0000FF0800FF1400FF2600FF3A00FF5100FF6800FF7E00FF
9100FF9F00FFA800FFAA00FFA600FF9C00FF8E00FF7E00FF6E00FF6200FF5B00FF5A00FF
6000FF6A00FF7200FF7200FF6E00FF6D00FF7400FF7D00FF8400FF8500FF7F00FF7400FF
6400FF5400FF4600FF3B00FF3600FF3700FF3E00FF4B00FF5D00FF7200FF8900FFA000FF
B600FFC800FFD600FFDE00FFE000FFDC00FFD200FFC300FFAE00FF9500FF7900FF5B00FF
3D00FF1F00FF0300FF0015FF0029FF0039FF0044FF0048FF0047FF003FFF0031FF001EFF
0006FF1600FF3700FF5A00FF7F00FFA400FFCA00FFEE00FFFF00EFFF00D0FF00B5FF009F
FF008EFF0082FF007CFF007DFF0083FF008FFF00A2FF00BAFF00D7FF00F8E200FFBA00FF
8F00FF6300FF3600FF0900FF0022FF004CFF0074FF0098FF00B8FF00D4FF00ECFF00FDFF
00FFF600FFF000FFF000FFF600FDFF00EAFF00D3FF00B5FF0093FF006DFF0042FF0015FF
1B00FF4D00FF8100FFB500FFE900FFFF00E3FF00B1FF0081
00B7FF0088FF0057FF0024FF1000FF4400FF7800FFAA00FFDB00FFFF00F5FF00CAFF00A3
FF0080FF0062FF0049FF0036FF0028FF0021FF0020FF0025FF002FFF0040FF0056FF0071
FF0091FF00B4FF00DBFA00FFCE00FFA200FF7500FF4800FF1D00FF000BFF0031FF0053FF
0070FF0089FF009DFF00AAFF00B2FF00B4FF00AFFF00A4FF0094FF007FFF0065FF0046FF
0025FF0001FF2300FF4900FF6E00FF9100FFB200FFD000FFE900FFFE00FFFF00F2FF00EA
FF00E7FF00EAFF00F3FD00FFE900FFD100FFB500FF9800FF7A00FF5B00FF3F00FF2500FF
1000FF0000FF000BFF0010FF000FFF0008FF0400FF1500FF2A00FF4100FF5800FF6E00FF
8000FF8F00FF9700FF9900FF9500FF8C00FF7E00FF6E00FF5E00FF5100FF4A00FF4A00FF
5000FF5900FF6100FF6200FF5D00FF5C00FF6300FF6D00FF7400FF7500FF6F00FF6300FF
5400FF4400FF3500FF2A00FF2500FF2600FF2D00FF3B00FF4D00FF6200FF7900FF9000FF
A500FFB700FFC500FFCD00FFD000FFCC00FFC200FFB200FF9D00FF8400FF6800FF4B00FF
2C00FF0E00FF000CFF0025FF003AFF004AFF0054FF0059FF0057FF0050FF0042FF002FFF
0016FF0600FF2600FF4900FF6E00FF9400FFB900FFDD00FFFF00FFFF00E1FF00C6FF00AF
FF009EFF0093FF008DFF008DFF0094FF00A0FF00B2FF00CAFF00E7F700FFD100FFA900FF
7E00FF5200FF2500FF0006FF0032FF005CFF0084FF00A8FF00C9FF00E5FF00FCFF00FFF1
00FFE500FFDF00FFDF00FFE600FFF200FBFF00E3FF00C6FF00A4FF007DFF0053FF0025FF
0A00FF3C00FF7000FFA400FFD900FFFF00F3FF00C1FF0092
00CDFF009EFF006DFF003AFF0005FF2E00FF6200FF9400FFC500FFF300FFFF00E0FF00B9
FF0096FF0078FF005FFF004CFF003EFF0037FF0036FF003BFF0045FF0056FF006CFF0087
FF00A7FF00CAFF00F2E400FFB800FF8B00FF5F00FF3200FF0700FF0021FF0047FF0069FF
0086FF009FFF00B3FF00C0FF00C8FF00CAFF00C5FF00BAFF00AAFF0095FF007BFF005CFF
003BFF0017FF0D00FF3300FF5800FF7B00FF9C00FFBA00FFD300FFE800FFF700FFFF00FF
FF00FDFF00FFF600FFE700FFD300FFBB00FF9F00FF8200FF6300FF4500FF2900FF0F00FF
0005FF0016FF0021FF0026FF0025FF001EFF0011FF0000FF1400FF2B00FF4200FF5800FF
6A00FF7900FF8100FF8300FF7F00FF7600FF6800FF5700FF4800FF3B00FF3400FF3400FF
3900FF4300FF4B00FF4C00FF4700FF4600FF4D00FF5700FF5E00FF5F00FF5900FF4D00FF
3E00FF2D00FF1F00FF1400FF0F00FF1000FF1700FF2500FF3600FF4C00FF6300FF7A00FF
8F00FFA100FFAF00FFB700FFBA00FFB600FFAC00FF9C00FF8700FF6E00FF5200FF3400FF
1600FF0007FF0022FF003BFF0050FF0060FF006AFF006FFF006DFF0066FF0058FF0045FF
002CFF000FFF1000FF3300FF5800FF7E00FFA300FFC700FFE900FFFF00F7FF00DCFF00C6
FF00B4FF00A9FF00A3FF00A3FF00AAFF00B6FF00C8FF00E0FF00FDE100FFBB00FF9300FF
6800FF3C00FF0F00FF001DFF0048FF0073FF009AFF00BFFF00DFFF00FBFF00FFED00FFDB
00FFCF00FFC900FFC900FFD000FFDC00FFEE00F9FF00DCFF00BAFF0094FF0069FF003BFF
000BFF2600FF5A00FF8E00FFC300FFF600FFFF00D7FF00A8
00E8FF00B9FF0088FF0055FF0021FF1300FF4700FF7900FFAA00FFD800FFFF00FCFF00D4
FF00B1FF0093FF007AFF0067FF005AFF0052FF0051FF0056FF0060FF0071FF0087FF00A2
FF00C2FF00E6F200FFC900FF9D00FF7000FF4300FF1700FF0013FF003CFF0062FF0084FF
00A2FF00BAFF00CEFF00DCFF00E3FF00E5FF00E0FF00D6FF00C5FF00B0FF0096FF0078FF
0056FF0032FF000DFF1800FF3D00FF6000FF8100FF9F00FFB800FFCD00FFDB00FFE400FF
E700FFE400FFDA00FFCB00FFB800FFA000FF8400FF6700FF4800FF2A00FF0E00FF000BFF
0020FF0031FF003CFF0042FF0040FF0039FF002CFF001BFF0006FF1000FF2700FF3D00FF
4F00FF5D00FF6600FF6800FF6400FF5A00FF4C00FF3C00FF2D00FF2000FF1900FF1800FF
1E00FF2800FF3000FF3100FF2C00FF2B00FF3200FF3C00FF4300FF4400FF3E00FF3200FF
2300FF1200FF0400FF0006FF000BFF000AFF0003FF0900FF1B00FF3100FF4800FF5F00FF
7400FF8600FF9400FF9C00FF9F00FF9B00FF9100FF8100FF6C00FF5300FF3700FF1900FF
0004FF0022FF003EFF0056FF006BFF007BFF0086FF008AFF0089FF0081FF0073FF0060FF
0047FF002AFF000AFF1800FF3D00FF6300FF8800FFAC00FFCE00FFED00FFFF00F7FF00E1
FF00CFFF00C4FF00BEFF00BEFF00C5FF00D1FF00E4FF00FBE700FFC500FFA000FF7800FF
4D00FF2100FF000BFF0038FF0063FF008EFF00B5FF00DAFF00FAFF00FFE900FFD200FFC0
00FFB400FFAE00FFAE00FFB400FFC100FFD300FFEB00F7FF00D5FF00AFFF0084FF0057FF
0026FF0B00FF3F00FF7300FFA700FFDB00FFFF00F2FF00C3
00FFF700D9FF00A7FF0074FF0040FF000CFF2700FF5A00FF8A00FFB900FFE400FFFF00F4
FF00D1FF00B3FF009AFF0087FF0079FF0072FF0071FF0075FF0080FF0091FF00A7FF00C2
FF00E2FA00FFD300FFA900FF7D00FF5100FF2400FF0008FF0033FF005CFF0081FF00A3FF
00C1FF00DAFF00EEFF00FBFF00FFFC00FFFB00FFFF00F5FF00E5FF00D0FF00B5FF0097FF
0076FF0052FF002DFF0007FF1D00FF4100FF6200FF7F00FF9900FFAD00FFBC00FFC500FF
C700FFC400FFBB00FFAC00FF9800FF8000FF6500FF4700FF2900FF0B00FF0011FF002AFF
0040FF0051FF005CFF0061FF0060FF0059FF004CFF003BFF0026FF000FFF0700FF1D00FF
3000FF3E00FF4600FF4900FF4400FF3B00FF2D00FF1D00FF0D00FF0000FF0006FF0006FF
0000FF0800FF1000FF1100FF0C00FF0B00FF1200FF1C00FF2300FF2400FF1E00FF1200FF
0300FF000CFF001BFF0026FF002BFF002AFF0022FF0015FF0003FF1100FF2800FF3F00FF
5400FF6700FF7400FF7D00FF7F00FF7B00FF7100FF6100FF4C00FF3300FF1800FF0005FF
0024FF0041FF005DFF0076FF008BFF009BFF00A5FF00AAFF00A8FF00A0FF0093FF007FFF
0067FF004AFF002AFF0007FF1D00FF4300FF6800FF8C00FFAE00FFCD00FFE800FFFF00FF
FF00EFFF00E3FF00DEFF00DEFF00E4FF00F1FC00FFE400FFC700FFA600FF8100FF5800FF
2E00FF0100FF002AFF0057FF0083FF00ADFF00D5FF00F9FF00FFE500FFC900FFB200FFA0
00FF9400FF8E00FF8F00FF9500FFA100FFB300FFCB00FFE800F5FF00CEFF00A4FF0076FF
0046FF0013FF1F00FF5400FF8800FFBB00FFED00FFFF00E3
00FFD300FDFF00CBFF0098FF0064FF0030FF0300FF3600FF6700FF9500FFC000FFE700FF
FF00F5FF00D6FF00BEFF00AAFF009DFF0095FF0094FF0099FF00A4FF00B4FF00CAFF00E6
FA00FFD600FFAF00FF8500FF5A00FF2D00FF0000FF002BFF0056FF007FFF00A5FF00C7FF
00E5FF00FEFF00FFEE00FFE000FFD800FFD700FFDC00FFE600FFF600F3FF00D9FF00BBFF
009AFF0076FF0051FF002BFF0006FF1D00FF3E00FF5B00FF7500FF8900FF9800FFA100FF
A400FFA000FF9700FF8800FF7400FF5C00FF4100FF2300FF0500FF0018FF0034FF004EFF
0064FF0075FF0080FF0085FF0084FF007DFF0070FF005EFF004AFF0033FF001CFF0006FF
0C00FF1A00FF2300FF2500FF2100FF1700FF0900FF0006FF0016FF0022FF0029FF002AFF
0024FF001AFF0012FF0012FF0016FF0017FF0010FF0007FF0000FF0000FF0005FF0010FF
0020FF0030FF003FFF0049FF004EFF004DFF0046FF0039FF0027FF0012FF0400FF1B00FF
3100FF4300FF5100FF5900FF5B00FF5700FF4D00FF3E00FF2900FF1000FF000BFF0029FF
0047FF0065FF0081FF009AFF00AFFF00BEFF00C9FF00CDFF00CCFF00C4FF00B6FF00A3FF
008BFF006EFF004DFF002AFF0005FF1F00FF4500FF6900FF8B00FFAA00FFC500FFDB00FF
EC00FFF800FFFE00FFFD00FFF700FFEA00FFD800FFC000FFA300FF8200FF5D00FF3500FF
0A00FF0021FF004EFF007BFF00A7FF00D1FF00F9FF00FFE200FFC100FFA500FF8E00FF7D
00FF7100FF6B00FF6B00FF7100FF7D00FF8F00FFA700FFC400FFE700F2FF00C8FF009AFF
0069FF0037FF0003FF3000FF6400FF9700FFC900FFF900FF
00FFAC00FFDB00F2FF00BFFF008BFF0057FF0023FF0F00FF4000FF6E00FF9900FFC000FF
E300FFFF00FEFF00E5FF00D1FF00C4FF00BDFF00BBFF00C0FF00CBFF00DBFF00F2F200FF
D300FFAF00FF8800FF5E00FF3300FF0600FF0026FF0052FF007DFF00A6FF00CCFF00EEFF
00FFF300FFDA00FFC700FFB900FFB100FFB000FFB400FFBF00FFCF00FFE500FFFF00E2FF
00C1FF009DFF0078FF0052FF002DFF0009FF1700FF3400FF4E00FF6200FF7100FF7A00FF
7D00FF7900FF7000FF6100FF4D00FF3500FF1A00FF0003FF0021FF003FFF005CFF0075FF
008BFF009CFF00A7FF00ACFF00ABFF00A4FF0097FF0085FF0071FF005AFF0043FF002DFF
001AFF000CFF0003FF0001FF0005FF000FFF001DFF002DFF003DFF0049FF0050FF0051FF
004BFF0042FF0039FF0039FF003DFF003EFF0037FF002EFF0027FF0026FF002CFF0038FF
0047FF0057FF0066FF0070FF0076FF0075FF006DFF0060FF004EFF0039FF0022FF000BFF
0A00FF1C00FF2A00FF3200FF3400FF3000FF2600FF1700FF0200FF0016FF0032FF0050FF
006EFF008CFF00A8FF00C1FF00D6FF00E6FF00F0FF00F5FF00F3FF00EBFF00DDFF00CAFF
00B2FF0095FF0074FF0051FF002CFF0007FF1E00FF4200FF6400FF8300FF9E00FFB400FF
C500FFD100FFD700FFD600FFD000FFC300FFB100FF9900FF7C00FF5B00FF3600FF0E00FF
001CFF0048FF0075FF00A2FF00CEFF00F8FF00FFDF00FFBB00FF9A00FF7E00FF6700FF56
00FF4A00FF4400FF4400FF4A00FF5600FF6800FF8000FF9D00FFBF00FFE600EFFF00C1FF
0091FF005EFF002AFF0900FF3D00FF7000FFA200FFD200FF
00FF8300FFB200FFE300E9FF00B5FF0080FF004DFF001AFF1600FF4400FF6F00FF9700FF
BA00FFD800FFF100FFFF00FBFF00EEFF00E6FF00E5FF00EAFF00F5FA00FFE400FFC900FF
A900FF8500FF5E00FF3500FF0900FF0023FF0050FF007CFF00A7FF00D0FF00F6FF00FFE7
00FFC900FFB000FF9D00FF8F00FF8800FF8600FF8B00FF9500FFA600FFBB00FFD500FFF3
00EAFF00C6FF00A1FF007CFF0056FF0033FF0012FF0B00FF2400FF3800FF4700FF5000FF
5300FF5000FF4600FF3700FF2300FF0B00FF000FFF002CFF004BFF0069FF0085FF009FFF
00B5FF00C5FF00D1FF00D6FF00D5FF00CDFF00C1FF00AFFF009AFF0084FF006CFF0057FF
0044FF0036FF002DFF002BFF002FFF0039FF0047FF0057FF0066FF0073FF007AFF007BFF
0075FF006BFF0063FF0062FF0067FF0068FF0061FF0057FF0050FF0050FF0056FF0061FF
0071FF0081FF008FFF009AFF009FFF009EFF0097FF008AFF0078FF0062FF004BFF0034FF
001FFF000DFF0000FF0800FF0B00FF0700FF0002FF0012FF0027FF0040FF005CFF007AFF
0098FF00B6FF00D2FF00EBFF00FFFF00FFF000FFE500FFE100FFE200FFEA00FFF800F4FF
00DBFF00BFFF009EFF007BFF0056FF0030FF000BFF1800FF3A00FF5900FF7400FF8A00FF
9C00FFA700FFAD00FFAD00FFA600FF9A00FF8700FF6F00FF5300FF3100FF0C00FF001BFF
0046FF0072FF009FFF00CCFF00F8FF00FFDD00FFB600FF9100FF7100FF5500FF3E00FF2C
00FF2000FF1A00FF1A00FF2000FF2D00FF3F00FF5700FF7400FF9600FFBC00FFE700EBFF
00BAFF0088FF0054FF0020FF1300FF4700FF7800FFA800FF
00FF5700FF8600FFB800FFEB00E0FF00ACFF0078FF0045FF0015FF1900FF4400FF6B00FF
8E00FFAC00FFC500FFD800FFE600FFED00FFEE00FFEA00FFDF00FFCE00FFB800FF9D00FF
7D00FF5A00FF3300FF0900FF0022FF004EFF007BFF00A8FF00D3FF00FCFF00FFDE00FFBB
00FF9E00FF8500FF7100FF6400FF5C00FF5B00FF5F00FF6A00FF7A00FF8F00FFAA00FFC8
00FFE900F2FF00CDFF00A7FF0082FF005FFF003DFF0020FF0007FF0D00FF1C00FF2500FF
2700FF2400FF1B00FF0C00FF0007FF001FFF003BFF0058FF0076FF0094FF00B1FF00CAFF
00E0FF00F1FF00FCFF00FFFE00FFFF00F9FF00ECFF00DBFF00C6FF00AFFF0098FF0082FF
006FFF0061FF0059FF0056FF005BFF0064FF0072FF0082FF0092FF009FFF00A6FF00A6FF
00A0FF0097FF008FFF008EFF0093FF0094FF008DFF0083FF007CFF007BFF0081FF008DFF
009CFF00ACFF00BBFF00C6FF00CBFF00CAFF00C2FF00B5FF00A3FF008EFF0077FF0060FF
004BFF0039FF002BFF0022FF0020FF0024FF002EFF003EFF0053FF006CFF0088FF00A5FF
00C4FF00E1FF00FDFF00FFE900FFD400FFC400FFBA00FFB500FFB700FFBE00FFCC00FFE0
00FFF800EAFF00CAFF00A7FF0082FF005CFF0037FF0013FF0E00FF2D00FF4800FF5F00FF
7000FF7C00FF8100FF8100FF7B00FF6E00FF5C00FF4400FF2700FF0600FF001EFF0047FF
0071FF009EFF00CBFF00F7FF00FFDC00FFB200FF8A00FF6600FF4500FF2900FF1200FF00
0BFF0011FF0010FF000AFF0000FF0100FF1300FF2B00FF4800FF6A00FF9100FFBB00FFE9
00E6FF00B3FF0080FF004BFF0017FF1B00FF4D00FF7C00FF
00FF2A00FF5900FF8B00FFBE00FFF200D9FF00A5FF0072FF0041FF0013FF1700FF3E00FF
6100FF7F00FF9800FFAC00FFB900FFC000FFC200FFBD00FFB200FFA200FF8B00FF7000FF
5100FF2D00FF0600FF0023FF004EFF007BFF00A8FF00D4FF00FFFF00FFD700FFB100FF8F
00FF7100FF5800FF4500FF3700FF2F00FF2E00FF3200FF3D00FF4D00FF6300FF7D00FF9B
00FFBC00FFE000FAFF00D4FF00AFFF008BFF006AFF004DFF0033FF001FFF0010FF0007FF
0004FF0008FF0011FF0020FF0034FF004CFF0067FF0085FF00A3FF00C1FF00DEFF00F7FF
00FFF200FFE100FFD600FFD100FFD200FFD900FFE600FFF800F3FF00DCFF00C5FF00AFFF
009CFF008EFF0085FF0083FF0087FF0091FF009FFF00AFFF00BFFF00CBFF00D2FF00D3FF
00CDFF00C4FF00BBFF00BBFF00BFFF00C0FF00B9FF00B0FF00A9FF00A8FF00AEFF00BAFF
00C9FF00D9FF00E8FF00F2FF00F8FF00F7FF00EFFF00E2FF00D0FF00BBFF00A4FF008DFF
0077FF0065FF0057FF004FFF004DFF0051FF005BFF006AFF007FFF0098FF00B4FF00D2FF
00F0FF00FFF100FFD500FFBC00FFA700FF9700FF8D00FF8800FF8A00FF9200FFA000FFB3
00FFCB00FFE800F6FF00D3FF00AEFF0089FF0063FF003FFF001DFF0100FF1C00FF3200FF
4300FF4F00FF5500FF5400FF4E00FF4100FF2F00FF1700FF0005FF0026FF004BFF0073FF
009EFF00CAFF00F7FF00FFDB00FFAF00FF8500FF5D00FF3900FF1803FF001AFF002BFF00
37FF003DFF003DFF0037FF002BFF0019FF0001FF0000FF1B00FF3D00FF6400FF8E00FFBC
00FFEC00E0FF00ACFF0078FF0044FF0011FF2000FF5000FF
02FF0000FF2C00FF5E00FF9100FFC500FFF900D2FF009FFF006EFF0040FF0015FF1100FF
3400FF5300FF6B00FF7F00FF8C00FF9300FF9500FF9000FF8500FF7500FF5F00FF4300FF
2400FF0000FF0026FF0050FF007BFF00A8FF00D5FF00FFFE00FFD300FFAA00FF8400FF62
00FF4400FF2B00FF1800FF0A00FF0200FF0100FF0600FF1000FF2000FF3600FF5000FF6E
00FF8F00FFB300FFD800FFFE00DCFF00B8FF0097FF007AFF0060FF004CFF003DFF0034FF
0031FF0035FF003EFF004DFF0061FF0079FF0094FF00B2FF00D0FF00EEFF00FFF400FFDB
00FFC500FFB400FFA900FFA400FFA500FFAC00FFB900FFCB00FFDF00FFF600F2FF00DCFF
00C9FF00BBFF00B2FF00B0FF00B4FF00BEFF00CCFF00DCFF00ECFF00F8FF00FFFF00FFFF
00FAFF00F0FF00E8FF00E8FF00ECFF00EDFF00E6FF00DDFF00D6FF00D5FF00DBFF00E6FF
00F6FF00FFF900FFEA00FFE000FFDB00FFDB00FFE300FFF000FDFF00E8FF00D1FF00BAFF
00A4FF0092FF0084FF007CFF007AFF007EFF0088FF0097FF00ACFF00C5FF00E1FF00FFFF
00FFE200FFC400FFA800FF8F00FF7A00FF6B00FF6000FF5B00FF5D00FF6500FF7300FF86
00FF9E00FFBB00FFDC00FFFF00DBFF00B6FF0090FF006CFF004AFF002BFF0010FF0500FF
1600FF2200FF2800FF2700FF2100FF1400FF0200FF0015FF0032FF0053FF0078FF00A0FF
00CBFF00F7FF00FFDB00FFAE00FF8200FF5800FF3000FF0C14FF0030FF0047FF0058FF00
64FF006AFF006AFF0064FF0058FF0046FF002EFF0011FF0000FF1000FF3700FF6100FF8F
00FFBF00FFF200D9FF00A5FF0071FF003EFF000CFF2300FF
2EFF0000FF0000FF3100FF6500FF9900FFCD00FEFF00CCFF009BFF006CFF0041FF001AFF
0800FF2600FF3F00FF5200FF6000FF6700FF6800FF6400FF5900FF4800FF3200FF1700FF
0008FF002BFF0052FF007CFF00A8FF00D4FF00FFFE00FFD100FFA600FF7D00FF5800FF35
00FF1800FF0014FF0021FF0029FF002AFF0026FF001BFF000BFF0000FF0900FF2300FF42
00FF6300FF8700FFAC00FFD200FFF700E5FF00C4FF00A6FF008DFF0078FF0069FF0060FF
005EFF0061FF006AFF0079FF008DFF00A5FF00C1FF00DEFF00FCFF00FFE500FFC800FFAE
00FF9900FF8800FF7D00FF7800FF7900FF8000FF8D00FF9E00FFB300FFCA00FFE100FFF7
00F6FF00E7FF00DFFF00DDFF00E1FF00EAFF00F8FF00FFF700FFE700FFDA00FFD300FFD3
00FFD900FFE200FFEA00FFEB00FFE600FFE500FFEC00FFF600FFFD00FFFE00FFF800FFEC
00FFDD00FFCD00FFBE00FFB300FFAE00FFAF00FFB600FFC400FFD600FFEB00FDFF00E6FF
00D1FF00BFFF00B1FF00A9FF00A6FF00AAFF00B4FF00C4FF00D9FF00F2FF00FFF100FFD4
00FFB500FF9700FF7C00FF6300FF4E00FF3E00FF3400FF2F00FF3100FF3800FF4600FF59
00FF7200FF8F00FFAF00FFD200FFF700E2FF00BDFF0099FF0077FF0058FF003DFF0026FF
0015FF0009FF0004FF0004FF000AFF0017FF0029FF0041FF005EFF007FFF00A5FF00CDFF
00F7FF00FFDB00FFAE00FF8200FF5600FF2C00FF041FFF0040FF005CFF0073FF0085FF00
91FF0097FF0097FF0090FF0084FF0072FF005AFF003DFF001BFF0000FF0B00FF3500FF63
00FF9300FFC500FFF900D2FF009DFF006AFF0038FF0009FF
59FF002AFF0000FF0600FF3A00FF6E00FFA200FFD600F7FF00C6FF0097FF006CFF0045FF
0022FF0004FF1400FF2700FF3500FF3C00FF3D00FF3900FF2E00FF1D00FF0700FF0013FF
0033FF0056FF007DFF00A7FF00D3FF00FFFF00FFD300FFA600FF7B00FF5200FF2D00FF0A
12FF002BFF003FFF004CFF0054FF0056FF0051FF0046FF0036FF0021FF0007FF0000FF17
00FF3800FF5C00FF8100FFA700FFCC00FFEF00EFFF00D1FF00B8FF00A3FF0094FF008BFF
0089FF008CFF0095FF00A4FF00B8FF00D0FF00ECFF00FFF600FFD800FFBA00FF9D00FF83
00FF6E00FF5D00FF5200FF4D00FF4E00FF5500FF6200FF7300FF8800FF9F00FFB600FFCC
00FFDE00FFED00FFF500FFF700FFF300FFEA00FFDC00FFCC00FFBC00FFAF00FFA800FFA8
00FFAE00FFB700FFBF00FFC000FFBB00FFBA00FFC100FFCB00FFD200FFD300FFCD00FFC1
00FFB200FFA200FF9300FF8800FF8300FF8400FF8B00FF9900FFAB00FFC000FFD700FFEE
00FCFF00EAFF00DCFF00D4FF00D1FF00D5FF00DFFF00EFFF00FFFB00FFE200FFC600FFA9
00FF8A00FF6C00FF5100FF3800FF2300FF1300FF0900FF0400FF0600FF0D00FF1B00FF2E
00FF4700FF6400FF8400FFA700FFCC00FFF200E8FF00C4FF00A2FF0083FF0068FF0051FF
0040FF0034FF002FFF002FFF0036FF0042FF0054FF006CFF0089FF00AAFF00D0FF00F8FF
00FFDD00FFB000FF8300FF5700FF2B00FF0126FF004AFF006BFF0087FF009EFF00B0FF00
BCFF00C2FF00C2FF00BBFF00AFFF009DFF0085FF0068FF0046FF001FFF0000FF0A00FF38
00FF6800FF9A00FFCE00FDFF00C8FF0095FF0063FF0034FF
82FF0053FF0021FF0000FF1100FF4500FF7900FFAD00FFE000EFFF00C0FF0095FF006EFF
004BFF002DFF0014FF0001FF0C00FF1300FF1500FF1000FF0500FF000BFF0021FF003CFF
005CFF007FFF00A6FF00D0FF00FCFF00FFD700FFAA00FF7D00FF5200FF2A00FF041DFF00
3BFF0054FF0067FF0075FF007DFF007EFF007AFF006FFF005FFF004AFF002FFF0011FF00
00FF0F00FF3300FF5800FF7E00FFA300FFC700FFE800FAFF00E0FF00CCFF00BDFF00B4FF
00B1FF00B5FF00BEFF00CDFF00E1FF00F9FF00FFEB00FFCD00FFAF00FF9100FF7400FF5B
00FF4500FF3400FF2900FF2400FF2500FF2C00FF3900FF4A00FF5F00FF7600FF8D00FFA3
00FFB600FFC400FFCC00FFCF00FFCB00FFC100FFB300FFA300FF9300FF8600FF7F00FF7F
00FF8500FF8E00FF9600FF9700FF9200FF9100FF9800FFA200FFA900FFAA00FFA400FF98
00FF8900FF7900FF6A00FF6000FF5A00FF5B00FF6300FF7000FF8200FF9700FFAE00FFC5
00FFDA00FFED00FFFA00FCFF00FAFF00FEFF00FFF700FFE700FFD300FFBA00FF9E00FF80
00FF6100FF4400FF2800FF0F05FF0015FF001FFF0024FF0022FF001AFF000DFF0000FF06
00FF1E00FF3B00FF5B00FF7E00FFA300FFC900FFEE00ECFF00CAFF00ACFF0091FF007AFF
0069FF005DFF0058FF0058FF005EFF006BFF007DFF0095FF00B2FF00D3FF00F8FF00FFDE
00FFB400FF8800FF5B00FF2E00FF0227FF004FFF0073FF0094FF00B0FF00C7FF00D9FF00
E4FF00EAFF00EAFF00E4FF00D8FF00C6FF00AEFF0091FF006FFF0048FF001EFF0000FF0F
00FF3F00FF7200FFA500FFDA00F1FF00BEFF008CFF005CFF
A8FF0079FF0047FF0014FF0000FF1F00FF5300FF8700FFBA00FFEB00E6FF00BBFF0094FF
0071FF0053FF003AFF0026FF0019FF0012FF0010FF0015FF0020FF0031FF0047FF0062FF
0081FF00A5FF00CCFF00F6FF00FFDE00FFB100FF8400FF5800FF2D00FF0421FF0043FF00
61FF007AFF008DFF009BFF00A3FF00A4FF00A0FF0095FF0085FF006FFF0055FF0037FF00
16FF0000FF0D00FF3200FF5800FF7D00FFA100FFC200FFDF00FFF900F2FF00E3FF00DAFF
00D7FF00DBFF00E4FF00F3FF00FFF800FFE000FFC500FFA700FF8900FF6B00FF4E00FF35
00FF1F00FF0E00FF0301FF0000FF0000FF0600FF1300FF2400FF3900FF5000FF6700FF7D
00FF9000FF9E00FFA700FFA900FFA500FF9B00FF8D00FF7D00FF6D00FF6100FF5900FF59
00FF5F00FF6800FF7100FF7100FF6D00FF6C00FF7300FF7C00FF8300FF8400FF7E00FF72
00FF6300FF5300FF4400FF3A00FF3400FF3500FF3D00FF4A00FF5C00FF7100FF8800FF9F
00FFB500FFC700FFD400FFDD00FFDF00FFDB00FFD100FFC100FFAD00FF9400FF7800FF5A
00FF3B00FF1E00FF0216FF002BFF003BFF0045FF004AFF0048FF0040FF0033FF001FFF00
07FF0000FF1500FF3600FF5900FF7E00FFA300FFC900FFED00F0FF00D1FF00B6FF00A0FF
008FFF0083FF007DFF007EFF0084FF0091FF00A3FF00BBFF00D8FF00F9FF00FFE100FFB9
00FF8E00FF6200FF3500FF0823FF004DFF0075FF0099FF00BAFF00D6FF00EDFF00FEFF00
FFF500FFEF00FFEF00FFF500FEFF00ECFF00D4FF00B7FF0095FF006EFF0044FF0016FF00
00FF1900FF4C00FF8000FFB400FFE800E4FF00B2FF0082FF
CAFF009BFF0069FF0036FF0002FF0000FF3100FF6500FF9800FFC900FFF700DDFF00B6FF
0093FF0075FF005CFF0049FF003BFF0034FF0032FF0037FF0042FF0053FF0069FF0084FF
00A3FF00C7FF00EEFF00FFE700FFBB00FF8F00FF6200FF3500FF0A1DFF0043FF0065FF00
83FF009CFF00AFFF00BDFF00C5FF00C6FF00C2FF00B7FF00A7FF0091FF0077FF0059FF00
38FF0014FF0000FF1000FF3600FF5B00FF7F00FFA000FFBD00FFD700FFEB00FFFA00FCFF
00F9FF00FDFF00FFF900FFEA00FFD600FFBE00FFA300FF8500FF6700FF4900FF2C00FF13
02FF0013FF001EFF0023FF0022FF001BFF000EFF0000FF0200FF1700FF2E00FF4500FF5B
00FF6E00FF7C00FF8400FF8700FF8300FF7900FF6B00FF5B00FF4B00FF3F00FF3700FF37
00FF3D00FF4600FF4E00FF4F00FF4A00FF4900FF5000FF5A00FF6100FF6200FF5C00FF50
00FF4100FF3100FF2200FF1800FF1200FF1300FF1B00FF2800FF3A00FF4F00FF6600FF7D
00FF9200FFA500FFB200FFBB00FFBD00FFB900FFAF00FF9F00FF8B00FF7200FF5600FF38
00FF1903FF001FFF0038FF004DFF005DFF0067FF006CFF006AFF0062FF0055FF0041FF00
29FF000CFF0000FF1300FF3700FF5B00FF8100FFA600FFCB00FFED00F4FF00D9FF00C2FF
00B1FF00A5FF009FFF00A0FF00A6FF00B3FF00C5FF00DDFF00FAFF00FFE400FFBF00FF96
00FF6C00FF4000FF1319FF0045FF006FFF0097FF00BBFF00DCFF00F8FF00FFF000FFDF00
FFD300FFCD00FFCD00FFD300FFDF00FFF100F6FF00D9FF00B7FF0090FF0066FF0038FF00
08FF0000FF2A00FF5D00FF9200FFC600FFF900D4FF00A4FF
E8FF00B9FF0087FF0054FF0020FF0000FF1300FF4700FF7A00FFAB00FFD900FBFF00D4FF
00B1FF0092FF007AFF0066FF0059FF0051FF0050FF0055FF0060FF0070FF0086FF00A2FF
00C1FF00E5FF00FFF300FFC900FF9E00FF7100FF4400FF1812FF003BFF0061FF0083FF00
A1FF00BAFF00CDFF00DBFF00E3FF00E4FF00DFFF00D5FF00C5FF00AFFF0095FF0077FF00
56FF0032FF000DFF0000FF1800FF3D00FF6100FF8200FF9F00FFB900FFCD00FFDC00FFE5
00FFE800FFE400FFDB00FFCC00FFB800FFA000FF8500FF6700FF4900FF2B00FF0F0AFF00
20FF0031FF003CFF0041FF0040FF0039FF002CFF001AFF0006FF0000FF1000FF2700FF3D
00FF5000FF5E00FF6700FF6900FF6500FF5B00FF4D00FF3D00FF2D00FF2100FF1A00FF19
00FF1F00FF2900FF3100FF3100FF2D00FF2C00FF3300FF3C00FF4300FF4400FF3E00FF33
00FF2300FF1300FF0505FF000AFF0009FF0002FF0000FF0A00FF1C00FF3100FF4800FF5F
00FF7500FF8700FF9500FF9D00FF9F00FF9B00FF9100FF8200FF6D00FF5400FF3800FF1A
03FF0021FF003DFF0056FF006BFF007AFF0085FF0089FF0088FF0080FF0072FF005FFF00
47FF002AFF0009FF0000FF1900FF3E00FF6300FF8900FFAD00FFCF00FFEE00F6FF00E0FF
00CFFF00C3FF00BDFF00BEFF00C4FF00D1FF00E3FF00FBFF00FFE700FFC600FFA100FF79
00FF4E00FF220AFF0037FF0063FF008DFF00B5FF00D9FF00F9FF00FFE900FFD200FFC100
FFB500FFAF00FFAF00FFB500FFC100FFD300FFEB00F7FF00D4FF00AEFF0084FF0056FF00
25FF0000FF0C00FF4000FF7400FFA800FFDB00F2FF00C2FF
FFFF00D1FF00A0FF006DFF0039FF0004FF0000FF2E00FF6100FF9200FFC000FFEB00ECFF
00C9FF00ABFF0092FF007FFF0072FF006AFF0069FF006EFF0079FF0089FF009FFF00BAFF
00DAFF00FEFF00FFDA00FFB000FF8500FF5800FF2B00FF002BFF0054FF007AFF009CFF00
BAFF00D3FF00E6FF00F4FF00FBFF00FDFF00F8FF00EEFF00DEFF00C8FF00AEFF0090FF00
6EFF004BFF0025FF0000FF0000FF2400FF4800FF6900FF8700FFA000FFB400FFC300FFCC
00FFCF00FFCC00FFC200FFB300FF9F00FF8700FF6C00FF4F00FF3000FF1209FF0023FF00
39FF0049FF0055FF005AFF0059FF0051FF0045FF0033FF001EFF0008FF0000FF0F00FF24
00FF3700FF4500FF4E00FF5000FF4C00FF4200FF3400FF2400FF1500FF0800FF0100FF00
00FF0600FF1000FF1800FF1800FF1400FF1300FF1A00FF2400FF2A00FF2B00FF2500FF1A
00FF0A05FF0013FF001EFF0023FF0022FF001BFF000EFF0000FF0300FF1800FF3000FF47
00FF5C00FF6E00FF7C00FF8400FF8600FF8300FF7900FF6900FF5400FF3B00FF1F00FF01
1CFF003AFF0056FF006FFF0083FF0093FF009EFF00A2FF00A1FF0099FF008BFF0078FF00
5FFF0043FF0022FF0000FF0000FF2500FF4A00FF7000FF9400FFB600FFD500FFF000F9FF
00E8FF00DCFF00D6FF00D6FF00DDFF00E9FF00FCFF00FFEB00FFCF00FFAD00FF8800FF60
00FF3500FF0923FF0050FF007CFF00A6FF00CDFF00F2FF00FFED00FFD100FFBA00FFA800
FF9C00FF9600FF9600FF9C00FFA800FFBB00FFD200FFF000EDFF00C7FF009CFF006FFF00
3EFF000CFF0000FF2700FF5B00FF8F00FFC300FFF400DBFF
FFEB00E5FF00B3FF0080FF004CFF0018FF0000FF1B00FF4E00FF7E00FFAD00FFD800FFFF
00DDFF00BFFF00A6FF0093FF0085FF007EFF007CFF0081FF008CFF009DFF00B3FF00CEFF
00EEFF00FFEE00FFC700FF9D00FF7100FF4500FF1814FF003FFF0067FF008DFF00AFFF00
CDFF00E6FF00F9FF00FFF800FFF000FFEF00FFF300FFFE00F1FF00DCFF00C1FF00A3FF00
82FF005EFF0039FF0013FF0000FF1100FF3500FF5600FF7300FF8D00FFA100FFB000FFB9
00FFBC00FFB800FFAF00FFA000FF8C00FF7400FF5900FF3B00FF1D00FF001DFF0036FF00
4CFF005DFF0068FF006DFF006CFF0065FF0058FF0047FF0032FF001BFF0004FF0000FF11
00FF2400FF3200FF3A00FF3D00FF3900FF2F00FF2100FF1100FF010BFF0012FF0012FF00
0CFF0003FF0000FF0400FF0500FF0000FF0000FF0600FF1000FF1700FF1800FF1200FF06
08FF0018FF0027FF0031FF0037FF0036FF002EFF0021FF000FFF0000FF0500FF1C00FF33
00FF4800FF5B00FF6800FF7100FF7300FF6F00FF6500FF5500FF4100FF2800FF0C11FF00
30FF004DFF0069FF0082FF0097FF00A7FF00B1FF00B6FF00B4FF00ACFF009FFF008BFF00
73FF0056FF0036FF0013FF0000FF1100FF3700FF5C00FF8100FFA200FFC100FFDC00FFF3
00FBFF00EFFF00EAFF00EAFF00F0FF00FDFF00FFF000FFD800FFBB00FF9A00FF7500FF4C
00FF2209FF0036FF0063FF008FFF00B9FF00E1FF00FFFA00FFD900FFBD00FFA600FF9400
FF8900FF8300FF8300FF8900FF9500FFA700FFBF00FFDC00FFFE00DAFF00B0FF0082FF00
52FF001FFF0000FF1300FF4800FF7C00FFAF00FFE100EEFF
FFDD00F2FF00C1FF008EFF005AFF0026FF0000FF0D00FF4000FF7100FF9F00FFCA00FFF1
00EBFF00CCFF00B4FF00A0FF0093FF008BFF008AFF008FFF009AFF00AAFF00C0FF00DCFF
00FBFF00FFE000FFB900FF8F00FF6400FF3700FF0A21FF004CFF0075FF009BFF00BDFF00
DBFF00F4FF00FFF800FFEA00FFE300FFE100FFE600FFF000FFFF00E9FF00CFFF00B1FF00
8FFF006CFF0046FF0021FF0000FF0300FF2700FF4800FF6600FF7F00FF9300FFA200FFAB
00FFAE00FFAA00FFA100FF9200FF7E00FF6600FF4B00FF2D00FF0F0EFF002AFF0044FF00
5AFF006BFF0076FF007BFF007AFF0072FF0066FF0054FF0040FF0029FF0012FF0000FF03
00FF1600FF2400FF2D00FF2F00FF2B00FF2100FF1300FF030CFF0018FF001FFF0020FF00
1AFF0010FF0008FF0008FF000CFF000DFF0006FF0000FF0200FF0900FF0A00FF0406FF00
16FF0026FF0034FF003FFF0044FF0043FF003CFF002FFF001DFF0008FF0000FF0E00FF25
00FF3B00FF4D00FF5B00FF6300FF6500FF6100FF5700FF4800FF3300FF1A01FF001FFF00
3DFF005BFF0077FF0090FF00A4FF00B4FF00BFFF00C3FF00C2FF00BAFF00ACFF0099FF00
81FF0064FF0043FF0020FF0000FF0400FF2900FF4F00FF7300FF9500FFB400FFCF00FFE5
00FFF600FDFF00F7FF00F8FF00FEFF00FFF400FFE200FFCA00FFAD00FF8C00FF6700FF3F
00FF1417FF0044FF0071FF009DFF00C7FF00EFFF00FFEC00FFCC00FFB000FF9800FF8700
FF7B00FF7500FF7500FF7B00FF8700FF9A00FFB100FFCF00FFF100E8FF00BEFF0090FF00
5FFF002DFF0000FF0600FF3A00FF6E00FFA100FFD300FCFF
FFD600FAFF00C9FF0096FF0062FF002DFF0000FF0600FF3800FF6900FF9700FFC300FFEA
00F2FF00D4FF00BBFF00A8FF009AFF0093FF0092FF0097FF00A1FF00B2FF00C8FF00E3FF
00FFFC00FFD800FFB100FF8800FF5C00FF2F00FF0229FF0054FF007DFF00A3FF00C5FF00
E3FF00FBFF00FFF000FFE300FFDB00FFD900FFDE00FFE800FFF900F1FF00D7FF00B9FF00
97FF0073FF004EFF0028FF0003FF0000FF1F00FF4000FF5E00FF7700FF8C00FF9A00FFA3
00FFA600FFA300FF9900FF8B00FF7700FF5F00FF4300FF2600FF0716FF0032FF004CFF00
61FF0072FF007DFF0082FF0081FF007AFF006DFF005CFF0047FF0030FF0019FF0003FF00
00FF0E00FF1D00FF2500FF2700FF2300FF1900FF0C04FF0013FF0020FF0027FF0027FF00
22FF0018FF0010FF000FFF0014FF0015FF000EFF0004FF0000FF0200FF0302FF000EFF00
1DFF002EFF003CFF0047FF004CFF004BFF0044FF0037FF0025FF000FFF0000FF0700FF1E
00FF3300FF4500FF5300FF5B00FF5E00FF5A00FF5000FF4000FF2B00FF1209FF0027FF00
45FF0063FF007FFF0097FF00ACFF00BCFF00C7FF00CBFF00CAFF00C2FF00B4FF00A1FF00
88FF006BFF004BFF0028FF0003FF0000FF2200FF4700FF6B00FF8D00FFAC00FFC700FFDD
00FFEF00FFFA00FFFF00FFFF00FFF900FFED00FFDA00FFC300FFA600FF8400FF5F00FF37
00FF0C1FFF004CFF0079FF00A4FF00CFFF00F6FF00FFE400FFC400FFA800FF9100FF7F00
FF7300FF6D00FF6D00FF7300FF8000FF9200FFAA00FFC700FFE900F0FF00C5FF0097FF00
67FF0035FF0001FF0000FF3200FF6600FF9A00FFCC00FFFB
FFD400FCFF00CAFF0097FF0063FF002FFF0000FF0400FF3700FF6800FF9600FFC100FFE8
00F4FF00D6FF00BDFF00A9FF009CFF0095FF0093FF0098FF00A3FF00B4FF00CAFF00E5FF
00FFFB00FFD700FFB000FF8600FF5B00FF2E00FF012AFF0056FF007EFF00A4FF00C6FF00
E4FF00FDFF00FFEF00FFE100FFD900FFD800FFDC00FFE700FFF700F2FF00D8FF00BAFF00
99FF0075FF0050FF002AFF0005FF0000FF1E00FF3F00FF5C00FF7600FF8A00FF9900FFA2
00FFA500FFA100FF9800FF8900FF7500FF5D00FF4200FF2400FF0617FF0034FF004DFF00
63FF0074FF007FFF0084FF0083FF007CFF006FFF005EFF0049FF0032FF001BFF0005FF00
00FF0D00FF1B00FF2400FF2600FF2200FF1800FF0A05FF0015FF0021FF0029FF0029FF00
23FF001AFF0012FF0011FF0015FF0016FF000FFF0006FF0000FF0000FF0104FF0010FF00
1FFF002FFF003EFF0048FF004EFF004DFF0045FF0038FF0026FF0011FF0000FF0500FF1C
00FF3200FF4400FF5100FF5A00FF5C00FF5800FF4E00FF3E00FF2A00FF110AFF0028FF00
47FF0064FF0080FF0099FF00AEFF00BEFF00C8FF00CDFF00CBFF00C3FF00B6FF00A2FF00
8AFF006DFF004DFF0029FF0004FF0000FF2000FF4600FF6A00FF8C00FFAA00FFC500FFDC
00FFED00FFF900FFFF00FFFE00FFF800FFEB00FFD900FFC100FFA400FF8300FF5E00FF36
00FF0B20FF004DFF007AFF00A6FF00D0FF00F8FF00FFE300FFC200FFA600FF8F00FF7E00
FF7200FF6C00FF6C00FF7200FF7E00FF9000FFA800FFC500FFE700F1FF00C7FF0099FF00
69FF0036FF0003FF0000FF3100FF6500FF9800FFCA00FFFA
FFD900F7FF00C6FF0093FF005EFF002AFF0000FF0900FF3B00FF6C00FF9A00FFC600FFED
00EFFF00D1FF00B8FF00A5FF0097FF0090FF008FFF0094FF009EFF00AFFF00C5FF00E0FF
00FFFF00FFDC00FFB400FF8B00FF5F00FF3200FF0626FF0051FF007AFF00A0FF00C2FF00
DFFF00F8FF00FFF300FFE600FFDE00FFDC00FFE100FFEC00FFFC00EEFF00D4FF00B5FF00
94FF0070FF004BFF0025FF0000FF0000FF2200FF4300FF6100FF7A00FF8F00FF9E00FFA6
00FFA900FFA600FF9D00FF8E00FF7A00FF6200FF4600FF2900FF0A13FF002FFF0049FF00
5EFF006FFF007AFF007FFF007EFF0077FF006AFF0059FF0044FF002DFF0016FF0000FF00
00FF1100FF2000FF2800FF2A00FF2600FF1D00FF0F01FF0010FF001DFF0024FF0024FF00
1FFF0015FF000DFF000CFF0011FF0012FF000BFF0001FF0000FF0500FF0600FF000BFF00
1AFF002BFF0039FF0044FF0049FF0048FF0041FF0033FF0022FF000CFF0000FF0A00FF21
00FF3600FF4800FF5600FF5E00FF6100FF5D00FF5300FF4300FF2E00FF1506FF0024FF00
42FF0060FF007BFF0094FF00A9FF00B9FF00C3FF00C8FF00C6FF00BFFF00B1FF009EFF00
85FF0068FF0048FF0025FF0000FF0000FF2500FF4A00FF6E00FF9000FFAF00FFCA00FFE0
00FFF200FFFD00FCFF00FCFF00FFFC00FFF000FFDE00FFC600FFA900FF8800FF6200FF3A
00FF0F1CFF0049FF0076FF00A1FF00CCFF00F3FF00FFE700FFC700FFAB00FF9400FF8200
FF7600FF7000FF7000FF7700FF8300FF9500FFAD00FFCA00FFEC00EDFF00C2FF0094FF00
64FF0032FF0000FF0100FF3500FF6A00FF9D00FFCF00FFFE
FFE300EDFF00BBFF0088FF0054FF0020FF0000FF1300FF4600FF7700FFA500FFD000FFF7
00E5FF00C6FF00AEFF009AFF008DFF0085FF0084FF0089FF0094FF00A4FF00BAFF00D6FF
00F5FF00FFE600FFBF00FF9500FF6A00FF3D00FF101BFF0046FF006FFF0095FF00B7FF00
D5FF00EEFF00FFFE00FFF000FFE800FFE700FFEC00FFF600F9FF00E3FF00C9FF00ABFF00
8AFF0066FF0041FF001BFF0000FF0900FF2D00FF4E00FF6B00FF8500FF9900FFA800FFB1
00FFB400FFB000FFA700FF9800FF8400FF6C00FF5100FF3300FF1508FF0024FF003EFF00
54FF0065FF0070FF0075FF0074FF006DFF0060FF004EFF003AFF0023FF000CFF0000FF09
00FF1C00FF2A00FF3300FF3500FF3100FF2700FF1900FF0906FF0012FF0019FF001AFF00
14FF000AFF0002FF0002FF0006FF0007FF0000FF0000FF0800FF0F00FF1000FF0A00FF00
10FF0020FF002FFF0039FF003EFF003DFF0036FF0029FF0017FF0002FF0000FF1400FF2B
00FF4100FF5300FF6100FF6900FF6B00FF6700FF5D00FF4E00FF3900FF2000FF0419FF00
37FF0055FF0071FF008AFF009FFF00AEFF00B9FF00BDFF00BCFF00B4FF00A6FF0093FF00
7BFF005EFF003DFF001AFF0000FF0A00FF2F00FF5500FF7900FF9B00FFBA00FFD500FFEB
00FFFC00F7FF00F1FF00F2FF00F8FF00FFFA00FFE800FFD000FFB300FF9200FF6D00FF45
00FF1A11FF003EFF006BFF0097FF00C1FF00E9FF00FFF200FFD200FFB500FF9E00FF8D00
FF8100FF7B00FF7B00FF8100FF8D00FF9F00FFB700FFD400FFF700E2FF00B8FF008AFF00
59FF0027FF0000FF0C00FF4000FF7400FFA700FFD900F6FF
FFF400DCFF00ABFF0078FF0044FF000FFF0000FF2300FF5600FF8700FFB500FFE000F7FF
00D4FF00B6FF009DFF008AFF007DFF0075FF0074FF0079FF0084FF0094FF00AAFF00C5FF
00E5FF00FFF600FFCF00FFA600FF7A00FF4D00FF200BFF0036FF005FFF0085FF00A7FF00
C5FF00DEFF00F1FF00FFFF00FFF900FFF700FFFC00F9FF00E8FF00D3FF00B9FF009BFF00
79FF0056FF0030FF000BFF0000FF1900FF3D00FF5E00FF7C00FF9500FFA900FFB800FFC1
00FFC400FFC100FFB700FFA800FF9400FF7C00FF6100FF4400FF2500FF0714FF002EFF00
44FF0054FF0060FF0065FF0064FF005CFF0050FF003EFF0029FF0013FF0000FF0400FF19
00FF2C00FF3A00FF4300FF4500FF4100FF3700FF2900FF1900FF0A02FF0009FF000AFF00
04FF0000FF0500FF0D00FF0E00FF0900FF0800FF0F00FF1900FF2000FF2000FF1A00FF0F
00FF0010FF001EFF0029FF002EFF002DFF0026FF0019FF0007FF0000FF0E00FF2500FF3C
00FF5100FF6300FF7100FF7900FF7B00FF7800FF6E00FF5E00FF4900FF3000FF1409FF00
27FF0045FF0061FF007AFF008EFF009EFF00A9FF00ADFF00ACFF00A4FF0096FF0083FF00
6AFF004EFF002DFF000AFF0000FF1A00FF4000FF6500FF8900FFAB00FFCA00FFE500FFFB
00F2FF00E7FF00E1FF00E1FF00E8FF00F4FF00FFF800FFE000FFC400FFA200FF7D00FF55
00FF2A01FF002EFF005BFF0087FF00B1FF00D8FF00FDFF00FFE200FFC600FFAF00FF9D00
FF9100FF8B00FF8B00FF9100FF9E00FFB000FFC800FFE500F8FF00D2FF00A7FF007AFF00
49FF0017FF0000FF1C00FF5000FF8400FFB800FFE900E6FF
F6FF00C7FF0095FF0062FF002EFF0000FF0500FF3900FF6C00FF9C00FFCB00FFF600E2FF
00BFFF00A1FF0088FF0075FF0067FF0060FF005FFF0063FF006EFF007FFF0095FF00B0FF
00D0FF00F3FF00FFE500FFBB00FF8F00FF6300FF3600FF0921FF004AFF006FFF0091FF00
AFFF00C8FF00DCFF00E9FF00F1FF00F2FF00EEFF00E3FF00D3FF00BEFF00A3FF0085FF00
64FF0040FF001BFF0000FF0A00FF2F00FF5300FF7400FF9100FFAB00FFBF00FFCE00FFD7
00FFD900FFD600FFCD00FFBE00FFAA00FF9200FF7700FF5900FF3B00FF1D00FF0018FF00
2EFF003FFF004AFF004FFF004EFF0047FF003AFF0029FF0014FF0000FF0200FF1900FF2F
00FF4200FF5000FF5800FF5B00FF5600FF4D00FF3F00FF2F00FF1F00FF1200FF0B00FF0B
00FF1100FF1A00FF2200FF2300FF1E00FF1D00FF2400FF2E00FF3500FF3600FF3000FF24
00FF1500FF0509FF0014FF0019FF0018FF0010FF0003FF0000FF0E00FF2300FF3A00FF51
00FF6600FF7900FF8600FF8F00FF9100FF8D00FF8300FF7300FF5E00FF4600FF2A00FF0C
12FF002FFF004BFF0064FF0079FF0089FF0093FF0098FF0096FF008EFF0081FF006DFF00
55FF0038FF0018FF0000FF0A00FF2F00FF5500FF7A00FF9F00FFC000FFDF00FFFA00EEFF
00DDFF00D1FF00CCFF00CCFF00D2FF00DFFF00F1FF00FFF600FFD900FFB800FF9300FF6A
00FF4000FF1318FF0045FF0071FF009BFF00C3FF00E7FF00FFF700FFDB00FFC400FFB200
FFA600FFA000FFA100FFA700FFB300FFC500FFDD00FFFA00E3FF00BCFF0092FF0064FF00
34FF0001FF0000FF3100FF6600FF9A00FFCD00FFFF00D1FF
DCFF00ADFF007BFF0048FF0014FF0000FF1F00FF5300FF8600FFB700FFE500EFFF00C8FF
00A5FF0087FF006EFF005AFF004DFF0046FF0044FF0049FF0054FF0065FF007BFF0096FF
00B5FF00D9FF00FFFF00FFD500FFAA00FF7D00FF5000FF2307FF002FFF0055FF0077FF00
95FF00AEFF00C1FF00CFFF00D7FF00D8FF00D4FF00C9FF00B9FF00A3FF0089FF006BFF00
4AFF0026FF0001FF0000FF2400FF4900FF6D00FF8E00FFAB00FFC500FFD900FFE800FFF1
00FFF400FFF000FFE700FFD800FFC400FFAC00FF9100FF7300FF5500FF3700FF1A00FF01
14FF0025FF0030FF0035FF0034FF002DFF0020FF000FFF0000FF0500FF1C00FF3300FF49
00FF5C00FF6A00FF7200FF7500FF7100FF6700FF5900FF4900FF3900FF2D00FF2500FF25
00FF2B00FF3400FF3C00FF3D00FF3900FF3700FF3F00FF4800FF4F00FF5000FF4A00FF3E
00FF2F00FF1F00FF1000FF0600FF0000FF0100FF0900FF1600FF2800FF3D00FF5400FF6B
00FF8100FF9300FFA000FFA900FFAB00FFA700FF9D00FF8D00FF7900FF6000FF4400FF26
00FF0715FF0031FF004AFF005FFF006FFF0079FF007EFF007CFF0074FF0067FF0053FF00
3BFF001EFF0000FF0100FF2500FF4900FF6F00FF9500FFB900FFDB00FFF900EBFF00D4FF
00C3FF00B7FF00B1FF00B2FF00B8FF00C5FF00D7FF00EFFF00FFF300FFD200FFAD00FF84
00FF5A00FF2E00FF012BFF0057FF0081FF00A9FF00CDFF00EEFF00FFF500FFDE00FFCD00
FFC100FFBB00FFBB00FFC100FFCD00FFDF00FFF700EBFF00C9FF00A2FF0078FF004AFF00
1AFF0000FF1800FF4B00FF8000FFB400FFE700E6FF00B6FF
BEFF008FFF005DFF002AFF0000FF0900FF3D00FF7100FFA400FFD500FCFF00D1FF00AAFF
0087FF0068FF0050FF003CFF002FFF0027FF0026FF002BFF0036FF0046FF005CFF0078FF
0097FF00BBFF00E2FF00FFF300FFC800FF9B00FF6E00FF4200FF1711FF0037FF0059FF00
77FF0090FF00A3FF00B1FF00B9FF00BAFF00B5FF00ABFF009BFF0085FF006BFF004DFF00
2CFF0008FF0000FF1C00FF4200FF6700FF8B00FFAC00FFC900FFE300FFF700F9FF00F0FF
00EDFF00F1FF00FAFF00FFF600FFE200FFCA00FFAF00FF9100FF7300FF5500FF3900FF1F
00FF0907FF0012FF0017FF0016FF000FFF0002FF0000FF0F00FF2300FF3A00FF5100FF67
00FF7A00FF8800FF9100FF9300FF8F00FF8500FF7700FF6700FF5700FF4B00FF4400FF43
00FF4900FF5300FF5B00FF5B00FF5700FF5600FF5D00FF6600FF6D00FF6E00FF6800FF5D
00FF4D00FF3D00FF2E00FF2400FF1F00FF2000FF2700FF3400FF4600FF5B00FF7200FF89
00FF9F00FFB100FFBF00FFC700FFC900FFC500FFBB00FFAC00FF9700FF7E00FF6200FF44
00FF2600FF0813FF002CFF0041FF0050FF005BFF005FFF005EFF0056FF0048FF0035FF00
1DFF0000FF0000FF2000FF4300FF6800FF8D00FFB300FFD700FFF900E7FF00CCFF00B6FF
00A5FF0099FF0093FF0094FF009AFF00A7FF00B9FF00D1FF00EEFF00FFF000FFCB00FFA3
00FF7800FF4C00FF1F0DFF0039FF0063FF008BFF00AFFF00CFFF00ECFF00FFFC00FFEB00
FFDF00FFD900FFD900FFDF00FFEB00FFFD00EAFF00CDFF00AAFF0084FF005AFF002CFF00
00FF0400FF3600FF6A00FF9E00FFD200FAFF00C8FF0098FF
9CFF006DFF003CFF0009FF0000FF2A00FF5F00FF9300FFC500FFF600DBFF00AFFF0088FF
0065FF0047FF002EFF001BFF000DFF0006FF0005FF000AFF0014FF0025FF003BFF0056FF
0076FF009AFF00C1FF00EAFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006EFF0082FF008FFF0097FF0099FF0094FF008AFF0079FF0064FF004AFF002CFF00
0AFF0000FF1900FF3E00FF6400FF8900FFAC00FFCD00FFEB00FBFF00E6FF00D8FF00CFFF
00CCFF00CFFF00D9FF00E7FF00FBFF00FFEC00FFD000FFB300FF9400FF7600FF5A00FF40
00FF2B00FF1A00FF0F00FF0A00FF0B00FF1200FF1F00FF3000FF4500FF5C00FF7300FF89
00FF9B00FFAA00FFB200FFB400FFB000FFA600FF9900FF8800FF7900FF6C00FF6500FF65
00FF6A00FF7400FF7C00FF7D00FF7800FF7700FF7E00FF8800FF8F00FF9000FF8A00FF7E
00FF6F00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7D00FF9400FFAB
00FFC000FFD200FFE000FFE800FFEB00FFE700FFDD00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0AFF001FFF002FFF003AFF003EFF003CFF0035FF0027FF0014FF00
00FF0400FF2100FF4100FF6400FF8900FFAF00FFD400FFF800E5FF00C6FF00ABFF0095FF
0083FF0078FF0072FF0072FF0079FF0085FF0098FF00AFFF00CCFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1317FF0042FF0069FF008EFF00AEFF00CAFF00E1FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F2FF00E0FF00C8FF00ABFF0089FF0063FF0038FF000AFF00
00FF2500FF5700FF8B00FFBF00FFF300D8FF00A6FF0077FF
78FF0049FF0018FF0000FF1A00FF4E00FF8300FFB600FFE900E5FF00B7FF008CFF0064FF
0041FF0023FF000AFF0800FF1500FF1D00FF1E00FF1900FF0E00FF0001FF0017FF0032FF
0052FF0076FF009DFF00C6FF00F2FF00FFE000FFB300FF8700FF5C00FF3300FF0D14FF00
32FF004BFF005EFF006CFF0073FF0075FF0070FF0066FF0056FF0040FF0026FF0008FF00
00FF1900FF3C00FF6200FF8700FFAC00FFD000FFF100F0FF00D7FF00C3FF00B4FF00ABFF
00A8FF00ABFF00B5FF00C4FF00D8FF00F0FF00FFF400FFD700FFB800FF9A00FF7E00FF64
00FF4E00FF3E00FF3200FF2D00FF2E00FF3600FF4200FF5400FF6900FF7F00FF9700FFAC
00FFBF00FFCD00FFD600FFD800FFD400FFCA00FFBC00FFAC00FF9D00FF9000FF8900FF88
00FF8E00FF9800FFA000FFA100FF9C00FF9B00FFA200FFAC00FFB200FFB300FFAD00FFA2
00FF9200FF8200FF7400FF6900FF6400FF6500FF6C00FF7900FF8B00FFA100FFB800FFCF
00FFE400FFF600FBFF00F3FF00F1FF00F4FF00FEFF00FFF100FFDC00FFC300FFA700FF89
00FF6B00FF4D00FF3100FF1800FF040BFF0016FF001AFF0019FF0011FF0003FF0000FF0F
00FF2800FF4400FF6500FF8800FFAD00FFD200FFF800E3FF00C1FF00A2FF0087FF0071FF
0060FF0054FF004EFF004EFF0055FF0061FF0074FF008CFF00A8FF00CAFF00EFFF00FFE8
00FFBD00FF9100FF6400FF3700FF0B1EFF0045FF006AFF008AFF00A6FF00BDFF00CFFF00
DBFF00E1FF00E1FF00DBFF00CEFF00BCFF00A5FF0087FF0065FF003FFF0014FF0000FF18
00FF4900FF7B00FFAF00FFE300E8FF00B4FF0083FF0053FF
53FF0024FF0000FF0C00FF3F00FF7300FFA800FFDC00F1FF00C0FF0092FF0066FF003FFF
001CFF0100FF1A00FF2D00FF3B00FF4200FF4300FF3E00FF3400FF2300FF0D00FF000DFF
002DFF0051FF0078FF00A1FF00CDFF00FAFF00FFD800FFAC00FF8100FF5800FF3200FF10
0DFF0025FF0039FF0046FF004EFF0050FF004BFF0041FF0030FF001BFF0001FF0000FF1C
00FF3E00FF6200FF8700FFAD00FFD200FFF500E9FF00CBFF00B2FF009DFF008FFF0086FF
0083FF0086FF0090FF009EFF00B2FF00CAFF00E6FF00FFFC00FFDD00FFBF00FFA300FF89
00FF7400FF6300FF5800FF5300FF5400FF5B00FF6800FF7900FF8E00FFA500FFBC00FFD2
00FFE400FFF300FFFB00FFFD00FFF900FFEF00FFE200FFD100FFC200FFB500FFAE00FFAE
00FFB300FFBD00FFC500FFC600FFC100FFC000FFC700FFD100FFD800FFD900FFD300FFC7
00FFB800FFA700FF9900FF8E00FF8900FF8A00FF9100FF9E00FFB000FFC600FFDD00FFF4
00F6FF00E4FF00D6FF00CEFF00CBFF00CFFF00D9FF00E9FF00FEFF00FFE800FFCC00FFAE
00FF9000FF7200FF5600FF3E00FF2900FF1900FF0E00FF0A00FF0C00FF1300FF2100FF34
00FF4D00FF6A00FF8A00FFAD00FFD200FFF800E2FF00BEFF009CFF007DFF0062FF004CFF
003AFF002FFF0029FF0029FF0030FF003CFF004FFF0066FF0083FF00A5FF00CAFF00F2FF
00FFE200FFB600FF8900FF5C00FF3100FF0620FF0045FF0065FF0081FF0098FF00AAFF00
B6FF00BCFF00BCFF00B6FF00A9FF0097FF007FFF0062FF0040FF001AFF0000FF1000FF3E
00FF6E00FFA000FFD400F7FF00C3FF008FFF005DFF002EFF
2EFF0000FF0100FF3200FF6500FF9900FFCD00FEFF00CBFF009AFF006CFF0041FF0019FF
0800FF2700FF4000FF5300FF6000FF6800FF6900FF6400FF5900FF4900FF3300FF1800FF
0007FF002BFF0052FF007CFF00A7FF00D4FF00FFFE00FFD200FFA700FF7E00FF5800FF36
00FF1800FF0013FF0021FF0028FF002AFF0025FF001BFF000BFF0000FF0A00FF2400FF42
00FF6400FF8700FFAD00FFD200FFF700E4FF00C3FF00A5FF008CFF0078FF0069FF0060FF
005DFF0061FF006AFF0079FF008DFF00A5FF00C0FF00DEFF00FCFF00FFE500FFC900FFAF
00FF9900FF8800FF7D00FF7800FF7900FF8100FF8D00FF9F00FFB300FFCA00FFE100FFF7
00F5FF00E7FF00DEFF00DCFF00E0FF00EAFF00F8FF00FFF700FFE700FFDB00FFD400FFD3
00FFD900FFE300FFEB00FFEB00FFE700FFE600FFED00FFF600FFFD00FFFE00FFF800FFED
00FFDD00FFCD00FFBF00FFB400FFAF00FFB000FFB700FFC400FFD600FFEB00FDFF00E6FF
00D0FF00BEFF00B0FF00A8FF00A6FF00AAFF00B4FF00C3FF00D8FF00F1FF00FFF200FFD4
00FFB600FF9800FF7C00FF6300FF4F00FF3F00FF3400FF3000FF3100FF3900FF4700FF5A
00FF7200FF8F00FFB000FFD300FFF800E2FF00BCFF0098FF0076FF0057FF003CFF0026FF
0015FF0009FF0003FF0004FF000AFF0016FF0029FF0041FF005EFF007FFF00A4FF00CCFF
00F7FF00FFDC00FFAF00FF8200FF5600FF2C00FF041FFF003FFF005BFF0073FF0084FF00
90FF0096FF0096FF0090FF0084FF0071FF005AFF003CFF001AFF0000FF0B00FF3600FF63
00FF9400FFC600FFFA00D1FF009DFF006AFF0038FF0008FF
08FF0000FF2600FF5700FF8A00FFBE00FFF300D9FF00A6FF0075FF0047FF001CFF0B00FF
2E00FF4C00FF6500FF7800FF8500FF8D00FF8E00FF8900FF7E00FF6E00FF5800FF3D00FF
1D00FF0006FF002DFF0056FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0303FF0005FF0000FF0000FF0900FF1900FF2F00FF4900FF67
00FF8900FFAC00FFD200FFF700E3FF00BFFF009EFF0080FF0067FF0053FF0044FF003BFF
0038FF003BFF0045FF0054FF0068FF0080FF009BFF00B8FF00D7FF00F5FF00FFEE00FFD4
00FFBE00FFAE00FFA200FF9D00FF9E00FFA600FFB200FFC400FFD900FFEF00F8FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F2FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EEFF00F3FF00F4FF00EDFF00E3FF00DCFF00DCFF00E2FF00EDFF
00FDFF00FFF200FFE400FFD900FFD400FFD500FFDC00FFE900FFFB00EEFF00D7FF00C0FF
00ABFF0099FF008BFF0083FF0081FF0084FF008EFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7400FF6400FF5900FF5500FF5600FF5E00FF6C00FF7F
00FF9800FFB400FFD500FFF800E2FF00BCFF0097FF0073FF0051FF0032FF0017FF0001FF
1000FF1B00FF2100FF2100FF1A00FF0E00FF0004FF001CFF0038FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2A00FF051AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006BFF005EFF004CFF0034FF0017FF0000FF0A00FF3000FF5B00FF88
00FFB900FFEB00E0FF00ACFF0078FF0044FF0013FF1C00FF
00FF1A00FF4900FF7B00FFAE00FFE200E9FF00B5FF0082FF0051FF0023FF0700FF2E00FF
5100FF6F00FF8800FF9B00FFA900FFB000FFB200FFAD00FFA200FF9100FF7B00FF6000FF
4100FF1D00FF0009FF0033FF005FFF008BFF00B8FF00E5FF00FFEF00FFC700FFA100FF7F
00FF6100FF4800FF3500FF2700FF1F00FF1E00FF2200FF2D00FF3D00FF5300FF6D00FF8B
00FFAC00FFD000FFF500E4FF00BFFF009BFF007AFF005DFF0043FF002FFF0020FF0017FF
0014FF0018FF0021FF0030FF0044FF005CFF0077FF0095FF00B3FF00D1FF00EEFF00FFF8
00FFE200FFD100FFC600FFC100FFC200FFC900FFD600FFE700FFFC00ECFF00D5FF00BFFF
00ACFF009EFF0096FF0093FF0097FF00A1FF00AFFF00BFFF00CFFF00DBFF00E3FF00E3FF
00DDFF00D4FF00CCFF00CBFF00D0FF00D1FF00CAFF00C0FF00B9FF00B8FF00BEFF00CAFF
00D9FF00E9FF00F8FF00FFFD00FFF700FFF800FFFF00F2FF00E0FF00CBFF00B4FF009DFF
0088FF0075FF0068FF005FFF005DFF0061FF006BFF007BFF008FFF00A8FF00C4FF00E2FF
00FFFE00FFE100FFC500FFAC00FF9700FF8700FF7D00FF7800FF7A00FF8200FF8F00FFA3
00FFBB00FFD800FFF800E3FF00BFFF0099FF0074FF004FFF002DFF000FFF0B00FF2200FF
3300FF3F00FF4500FF4400FF3E00FF3100FF1F00FF0700FF0015FF0036FF005BFF0084FF
00AEFF00DAFF00FFF800FFCB00FF9F00FF7500FF4D00FF2900FF0813FF002AFF003BFF00
47FF004DFF004DFF0047FF003BFF0029FF0011FF0000FF0B00FF2D00FF5400FF7E00FFAC
00FFDC00F0FF00BDFF0088FF0054FF0021FF1000FF4000FF
00FF3B00FF6A00FF9C00FFCF00FCFF00C8FF0094FF0061FF0030FF0002FF2800FF4F00FF
7200FF9000FFA900FFBD00FFCA00FFD100FFD300FFCE00FFC300FFB200FF9C00FF8100FF
6200FF3E00FF1700FF0012FF003DFF006AFF0097FF00C4FF00EFFF00FFE800FFC200FFA0
00FF8200FF6900FF5600FF4800FF4000FF3F00FF4300FF4E00FF5E00FF7400FF8E00FFAC
00FFCD00FFF100E9FF00C3FF009EFF007AFF0059FF003CFF0022FF000EFF0000FF0900FF
0C00FF0800FF0000FF000FFF0023FF003BFF0056FF0074FF0092FF00B0FF00CDFF00E6FF
00FCFF00FFF200FFE700FFE200FFE300FFEA00FFF700F7FF00E2FF00CBFF00B4FF009EFF
008BFF007DFF0075FF0072FF0076FF0080FF008EFF009EFF00AEFF00BAFF00C2FF00C2FF
00BCFF00B3FF00ABFF00AAFF00AFFF00B0FF00A9FF009FFF0098FF0097FF009DFF00A9FF
00B8FF00C8FF00D7FF00E1FF00E7FF00E6FF00DEFF00D1FF00BFFF00AAFF0093FF007CFF
0066FF0054FF0047FF003EFF003CFF0040FF004AFF005AFF006EFF0087FF00A3FF00C1FF
00E0FF00FDFF00FFE600FFCD00FFB800FFA800FF9E00FF9900FF9B00FFA300FFB000FFC4
00FFDC00FFF900E6FF00C2FF009EFF0078FF0053FF002EFF000CFF1100FF2C00FF4300FF
5400FF6000FF6600FF6500FF5F00FF5200FF4000FF2800FF0B00FF0015FF003AFF0063FF
008DFF00B9FF00E6FF00FFEC00FFC000FF9600FF6E00FF4A00FF2900FF0D09FF001AFF00
26FF002CFF002CFF0026FF001AFF0008FF0000FF0F00FF2C00FF4E00FF7500FF9F00FFCD
00FFFD00CFFF009CFF0067FF0033FF0000FF3100FF6100FF
00FF5900FF8800FFB900FFEC00DFFF00AAFF0076FF0044FF0013FF1A00FF4600FF6D00FF
9000FFAE00FFC700FFDA00FFE800FFEF00FFF000FFEB00FFE100FFD000FFBA00FF9F00FF
7F00FF5B00FF3400FF0B00FF0020FF004DFF007AFF00A6FF00D1FF00FAFF00FFDF00FFBD
00FF9F00FF8700FF7300FF6600FF5E00FF5C00FF6100FF6B00FF7C00FF9100FFAB00FFC9
00FFEB00F0FF00CBFF00A5FF0080FF005DFF003CFF001EFF0005FF0F00FF1D00FF2600FF
2900FF2600FF1C00FF0E00FF0005FF001DFF0039FF0056FF0075FF0093FF00AFFF00C9FF
00DEFF00EFFF00FAFF00FFFF00FEFF00F7FF00EAFF00D9FF00C4FF00ADFF0096FF0080FF
006EFF005FFF0057FF0055FF0059FF0063FF0070FF0081FF0090FF009DFF00A4FF00A4FF
009FFF0095FF008DFF008CFF0091FF0092FF008BFF0081FF007AFF0079FF007FFF008BFF
009AFF00ABFF00B9FF00C4FF00C9FF00C8FF00C1FF00B4FF00A2FF008CFF0075FF005EFF
0049FF0037FF0029FF0021FF001EFF0022FF002CFF003CFF0051FF006AFF0086FF00A4FF
00C2FF00E0FF00FCFF00FFEB00FFD600FFC600FFBB00FFB700FFB900FFC000FFCE00FFE1
00FFFA00E8FF00C8FF00A5FF0080FF005AFF0035FF0011FF1000FF2F00FF4A00FF6000FF
7200FF7D00FF8300FF8300FF7C00FF7000FF5D00FF4600FF2900FF0700FF001DFF0045FF
0070FF009CFF00C9FF00F6FF00FFDE00FFB300FF8C00FF6700FF4700FF2B00FF1400FF02
09FF000FFF000FFF0009FF0000FF0300FF1500FF2D00FF4A00FF6C00FF9200FFBD00FFEB
00E4FF00B2FF007EFF004AFF0016FF1D00FF4F00FF7E00FF
00FF7200FFA100FFD300F9FF00C5FF0091FF005DFF002AFF0500FF3400FF5F00FF8600FF
A900FFC700FFE000FFF300FFFF00FEFF00F7FF00F5FF00FAFA00FFE900FFD300FFB800FF
9900FF7500FF4E00FF2400FF0007FF0033FF0060FF008DFF00B8FF00E0FF00FFF900FFD7
00FFB900FFA000FF8D00FF7F00FF7700FF7600FF7A00FF8500FF9500FFAB00FFC500FFE3
00FBFF00D7FF00B2FF008CFF0067FF0043FF0022FF0005FF1400FF2800FF3700FF4000FF
4300FF3F00FF3600FF2700FF1300FF0004FF001FFF003DFF005BFF0079FF0096FF00AFFF
00C5FF00D6FF00E1FF00E6FF00E5FF00DEFF00D1FF00C0FF00ABFF0094FF007DFF0067FF
0054FF0046FF003EFF003BFF003FFF0049FF0057FF0067FF0077FF0083FF008BFF008BFF
0085FF007CFF0074FF0073FF0078FF0079FF0072FF0068FF0061FF0060FF0066FF0072FF
0081FF0091FF00A0FF00AAFF00B0FF00AFFF00A7FF009AFF0088FF0073FF005CFF0045FF
0030FF001DFF0010FF0007FF0005FF0009FF0013FF0023FF0037FF0050FF006CFF008AFF
00A9FF00C6FF00E2FF00FBFF00FFEF00FFDF00FFD500FFD000FFD200FFDA00FFE700FFFB
00ECFF00CFFF00AFFF008BFF0067FF0041FF001CFF0800FF2A00FF4800FF6300FF7A00FF
8B00FF9700FF9D00FF9C00FF9600FF8900FF7700FF5F00FF4200FF2100FF0003FF002CFF
0056FF0082FF00AFFF00DCFF00FFF700FFCD00FFA500FF8100FF6000FF4400FF2D00FF1B
00FF1000FF0A00FF0A00FF1000FF1C00FF2E00FF4600FF6300FF8500FFAC00FFD600FBFF
00CBFF0098FF0065FF0030FF0300FF3600FF6800FF9800FF
00FF8700FFB600FFE700E5FF00B1FF007DFF0049FF0016FF1A00FF4800FF7300FF9B00FF
BE00FFDC00FFF500FFFF00F7FF00EAFF00E2FF00E1FF00E6FF00F1FE00FFE800FFCD00FF
AD00FF8900FF6200FF3800FF0D00FF001FFF004CFF0078FF00A3FF00CCFF00F2FF00FFEB
00FFCD00FFB400FFA100FF9300FF8C00FF8A00FF8F00FF9900FFA900FFBF00FFD900FFF7
00E6FF00C3FF009DFF0078FF0053FF002FFF000EFF0F00FF2800FF3C00FF4B00FF5400FF
5700FF5400FF4A00FF3B00FF2700FF0F00FF000BFF0028FF0047FF0065FF0081FF009BFF
00B1FF00C1FF00CDFF00D2FF00D1FF00C9FF00BDFF00ABFF0096FF0080FF0068FF0053FF
0040FF0032FF0029FF0027FF002BFF0035FF0043FF0053FF0063FF006FFF0076FF0077FF
0071FF0067FF005FFF005FFF0063FF0064FF005DFF0053FF004DFF004CFF0052FF005DFF
006DFF007DFF008BFF0096FF009BFF009AFF0093FF0086FF0074FF005FFF0048FF0031FF
001BFF0009FF0400FF0C00FF0E00FF0B00FF0000FF000EFF0023FF003CFF0058FF0076FF
0094FF00B2FF00CEFF00E7FF00FBFF00FFF400FFE900FFE500FFE600FFEE00FFFC00F0FF
00D8FF00BBFF009AFF0077FF0052FF002DFF0007FF1C00FF3E00FF5D00FF7800FF8E00FF
9F00FFAB00FFB100FFB100FFAA00FF9E00FF8B00FF7300FF5700FF3500FF1000FF0017FF
0042FF006EFF009BFF00C8FF00F4FF00FFE100FFBA00FF9500FF7500FF5900FF4200FF30
00FF2400FF1E00FF1E00FF2400FF3000FF4300FF5A00FF7800FF9A00FFC000FFEB00E7FF
00B6FF0084FF0050FF001CFF1700FF4B00FF7C00FFAC00FF
00FF9500FFC400FFF600D6FF00A2FF006EFF003AFF0007FF2900FF5700FF8200FFA900FF
CC00FFEB00FFFF00FCFF00E8FF00DBFF00D3FF00D2FF00D7FF00E2FF00F2F700FFDB00FF
BC00FF9800FF7100FF4700FF1C00FF0010FF003DFF0069FF0094FF00BDFF00E3FF00FFFA
00FFDC00FFC300FFB000FFA200FF9A00FF9900FF9E00FFA800FFB800FFCE00FFE800F9FF
00D8FF00B4FF008FFF0069FF0044FF0020FF0000FF1D00FF3700FF4B00FF5A00FF6300FF
6600FF6200FF5900FF4A00FF3600FF1E00FF0300FF001AFF0038FF0056FF0072FF008CFF
00A2FF00B3FF00BEFF00C3FF00C2FF00BBFF00AEFF009CFF0088FF0071FF005AFF0044FF
0031FF0023FF001AFF0018FF001CFF0026FF0034FF0044FF0054FF0060FF0067FF0068FF
0062FF0058FF0050FF0050FF0054FF0055FF004EFF0045FF003EFF003DFF0043FF004EFF
005EFF006EFF007DFF0087FF008CFF008BFF0084FF0077FF0065FF0050FF0039FF0022FF
000CFF0500FF1300FF1B00FF1D00FF1900FF0F00FF0000FF0014FF002DFF0049FF0067FF
0085FF00A3FF00BFFF00D8FF00EDFF00FCFF00FFF800FFF400FFF500FFFD00F4FF00E1FF
00C9FF00ACFF008BFF0068FF0043FF001EFF0700FF2B00FF4D00FF6C00FF8700FF9D00FF
AE00FFBA00FFC000FFBF00FFB900FFAC00FF9A00FF8200FF6500FF4400FF1F00FF0008FF
0033FF005FFF008CFF00B9FF00E5FF00FFF000FFC800FFA400FF8300FF6700FF5000FF3F
00FF3300FF2D00FF2D00FF3300FF3F00FF5100FF6900FF8600FFA900FFCF00FFF900D8FF
00A7FF0075FF0041FF000DFF2600FF5900FF8B00FFBB00FF
00FF9E00FFCD00FFFF00CDFF0099FF0065FF0031FF0100FF3200FF6000FF8B00FFB200FF
D500FFF300FFFF00F3FF00DFFF00D2FF00CBFF00C9FF00CEFF00D9FF00EAFF00FFE400FF
C500FFA100FF7A00FF5000FF2500FF0007FF0034FF0060FF008BFF00B4FF00DAFF00FCFF
00FFE500FFCC00FFB900FFAB00FFA300FFA200FFA600FFB100FFC100FFD700FFF100F0FF
00CFFF00ABFF0086FF0060FF003BFF0017FF0900FF2600FF4000FF5400FF6300FF6C00FF
6F00FF6B00FF6200FF5300FF3F00FF2700FF0C00FF0011FF002FFF004DFF006AFF0083FF
0099FF00AAFF00B5FF00BAFF00B9FF00B2FF00A5FF0093FF007FFF0068FF0051FF003BFF
0028FF001AFF0011FF000FFF0013FF001DFF002BFF003BFF004BFF0057FF005FFF005FFF
0059FF0050FF0047FF0047FF004BFF004CFF0045FF003CFF0035FF0034FF003AFF0046FF
0055FF0065FF0074FF007EFF0084FF0083FF007BFF006EFF005CFF0047FF0030FF0019FF
0003FF0E00FF1B00FF2400FF2600FF2200FF1800FF0900FF000BFF0024FF0040FF005EFF
007CFF009AFF00B6FF00CFFF00E4FF00F4FF00FEFF00FFFC00FFFE00F9FF00ECFF00D8FF
00C0FF00A3FF0082FF005FFF003AFF0015FF1000FF3400FF5600FF7500FF9000FFA600FF
B700FFC300FFC900FFC800FFC200FFB500FFA300FF8B00FF6E00FF4D00FF2800FF0000FF
002AFF0056FF0083FF00B0FF00DCFF00FFF900FFD100FFAD00FF8C00FF7000FF5900FF48
00FF3C00FF3600FF3600FF3C00FF4800FF5A00FF7200FF8F00FFB100FFD800FDFF00CFFF
009FFF006CFF0038FF0004FF2F00FF6200FF9400FFC400FF
00FFA100FFD000FDFF00CAFF0096FF0062FF002EFF0400FF3400FF6300FF8E00FFB500FF
D800FFF600FFFF00F0FF00DDFF00CFFF00C8FF00C7FF00CBFF00D6FF00E7FF00FDE700FF
C700FFA400FF7D00FF5300FF2700FF0004FF0031FF005EFF0089FF00B1FF00D7FF00F9FF
00FFE800FFCF00FFBC00FFAE00FFA600FFA500FFA900FFB400FFC400FFD900FFF400EDFF
00CCFF00A8FF0083FF005DFF0038FF0014FF0C00FF2900FF4300FF5700FF6600FF6F00FF
7100FF6E00FF6500FF5600FF4200FF2A00FF0F00FF000EFF002CFF004AFF0067FF0080FF
0096FF00A7FF00B2FF00B7FF00B6FF00AFFF00A2FF0091FF007CFF0065FF004EFF0038FF
0025FF0017FF000FFF000CFF0011FF001AFF0028FF0038FF0048FF0055FF005CFF005CFF
0056FF004DFF0045FF0044FF0049FF004AFF0043FF0039FF0032FF0031FF0037FF0043FF
0052FF0062FF0071FF007BFF0081FF0080FF0078FF006BFF0059FF0044FF002DFF0016FF
0001FF1100FF1E00FF2700FF2900FF2500FF1B00FF0B00FF0009FF0021FF003DFF005BFF
007AFF0097FF00B3FF00CCFF00E1FF00F1FF00FBFF00FFFF00FEFF00F6FF00E9FF00D5FF
00BDFF00A0FF0080FF005DFF0038FF0012FF1200FF3700FF5800FF7700FF9200FFA900FF
BA00FFC600FFCB00FFCB00FFC500FFB800FFA600FF8E00FF7100FF5000FF2B00FF0200FF
0027FF0054FF0080FF00ADFF00D9FF00FFFC00FFD400FFB000FF8F00FF7300FF5C00FF4A
00FF3E00FF3800FF3900FF3F00FF4B00FF5D00FF7500FF9200FFB400FFDB00FAFF00CCFF
009CFF0069FF0036FF0001FF3200FF6500FF9700FFC600FF
00FF9E00FFCD00FFFE00CEFF009AFF0065FF0031FF0000FF3100FF5F00FF8A00FFB200FF
D500FFF300FFFF00F3FF00E0FF00D3FF00CBFF00CAFF00CFFF00DAFF00EAFF00FFE400FF
C400FFA000FF7900FF5000FF2400FF0008FF0035FF0061FF008CFF00B5FF00DBFF00FDFF
00FFE400FFCC00FFB800FFAA00FFA300FFA100FFA600FFB000FFC100FFD600FFF000F1FF
00CFFF00ABFF0086FF0061FF003BFF0018FF0800FF2600FF3F00FF5400FF6200FF6B00FF
6E00FF6B00FF6100FF5200FF3F00FF2600FF0B00FF0011FF0030FF004EFF006AFF0084FF
0099FF00AAFF00B5FF00BBFF00B9FF00B2FF00A5FF0094FF007FFF0068FF0051FF003BFF
0029FF001BFF0012FF0010FF0014FF001EFF002CFF003CFF004BFF0058FF005FFF0060FF
005AFF0050FF0048FF0047FF004CFF004DFF0046FF003CFF0035FF0034FF003AFF0046FF
0055FF0066FF0074FF007FFF0084FF0083FF007CFF006FFF005DFF0047FF0030FF0019FF
0004FF0D00FF1B00FF2300FF2600FF2200FF1800FF0800FF000CFF0025FF0041FF005FFF
007DFF009BFF00B7FF00CFFF00E4FF00F4FF00FFFF00FFFC00FFFD00FAFF00ECFF00D9FF
00C0FF00A3FF0083FF0060FF003BFF0015FF0F00FF3300FF5500FF7400FF8F00FFA500FF
B700FFC200FFC800FFC800FFC100FFB500FFA200FF8B00FF6E00FF4C00FF2700FF0000FF
002BFF0057FF0084FF00B1FF00DDFF00FFF800FFD100FFAC00FF8C00FF7000FF5900FF47
00FF3B00FF3500FF3500FF3B00FF4800FF5A00FF7200FF8F00FFB100FFD700FDFF00D0FF
009FFF006DFF0039FF0005FF2E00FF6200FF9400FFC300FF
00FF9400FFC300FFF500D7FF00A3FF006FFF003BFF0008FF2800FF5600FF8100FFA800FF
CB00FFEA00FFFF00FDFF00E9FF00DCFF00D5FF00D3FF00D8FF00E3FF00F3F600FFDA00FF
BB00FF9700FF7000FF4600FF1B00FF0011FF003EFF006AFF0095FF00BEFF00E4FF00FFF9
00FFDB00FFC200FFAF00FFA100FF9900FF9800FF9D00FFA700FFB700FFCD00FFE700FAFF
00D9FF00B5FF0090FF006AFF0045FF0021FF0000FF1C00FF3600FF4A00FF5900FF6200FF
6500FF6100FF5800FF4900FF3500FF1D00FF0200FF001BFF0039FF0057FF0073FF008DFF
00A3FF00B4FF00BFFF00C4FF00C3FF00BCFF00AFFF009DFF0089FF0072FF005BFF0045FF
0032FF0024FF001BFF0019FF001DFF0027FF0035FF0045FF0055FF0061FF0068FF0069FF
0063FF0059FF0051FF0051FF0055FF0056FF004FFF0046FF003FFF003EFF0044FF004FFF
005FFF006FFF007EFF0088FF008DFF008CFF0085FF0078FF0066FF0051FF003AFF0023FF
000DFF0400FF1200FF1A00FF1C00FF1800FF0E00FF0000FF0015FF002EFF004AFF0068FF
0086FF00A4FF00C0FF00D9FF00EEFF00FDFF00FFF700FFF200FFF400FFFC00F5FF00E2FF
00CAFF00ADFF008CFF0069FF0044FF001FFF0600FF2A00FF4C00FF6B00FF8600FF9C00FF
AD00FFB900FFBF00FFBE00FFB800FFAB00FF9900FF8100FF6400FF4300FF1E00FF0009FF
0034FF0060FF008DFF00BAFF00E6FF00FFEF00FFC700FFA300FF8200FF6600FF4F00FF3E
00FF3200FF2C00FF2C00FF3200FF3E00FF5000FF6800FF8500FFA700FFCE00FFF800D9FF
00A8FF0076FF0042FF000EFF2500FF5800FF8A00FFBA00FF
00FF8500FFB500FFE600E6FF00B2FF007EFF004AFF0017FF1900FF4700FF7200FF9A00FF
BC00FFDB00FFF300FFFF00F8FF00EBFF00E3FF00E2FF00E7FF00F2FD00FFE700FFCB00FF
AC00FF8800FF6100FF3700FF0C00FF0020FF004DFF0079FF00A4FF00CDFF00F3FF00FFEA
00FFCC00FFB300FFA000FF9200FF8B00FF8900FF8E00FF9800FFA800FFBE00FFD800FFF6
00E7FF00C4FF009EFF0079FF0054FF0030FF000FFF0E00FF2700FF3B00FF4A00FF5300FF
5600FF5200FF4900FF3A00FF2600FF0E00FF000CFF002AFF0048FF0066FF0082FF009CFF
00B2FF00C3FF00CEFF00D3FF00D2FF00CAFF00BEFF00ACFF0098FF0081FF006AFF0054FF
0041FF0033FF002AFF0028FF002CFF0036FF0044FF0054FF0064FF0070FF0077FF0078FF
0072FF0068FF0060FF0060FF0064FF0065FF005EFF0055FF004EFF004DFF0053FF005EFF
006EFF007EFF008CFF0097FF009CFF009BFF0094FF0087FF0075FF0060FF0049FF0032FF
001CFF000AFF0300FF0B00FF0D00FF0900FF0000FF000FFF0024FF003DFF0059FF0077FF
0095FF00B3FF00CFFF00E8FF00FCFF00FFF300FFE800FFE400FFE500FFED00FFFB00F1FF
00D9FF00BCFF009BFF0078FF0053FF002EFF0008FF1B00FF3D00FF5C00FF7700FF8D00FF
9E00FFAA00FFB000FFAF00FFA900FF9C00FF8A00FF7200FF5500FF3400FF0F00FF0018FF
0043FF006FFF009CFF00C9FF00F5FF00FFE000FFB800FF9400FF7400FF5800FF4000FF2F
00FF2300FF1D00FF1D00FF2300FF2F00FF4200FF5900FF7700FF9900FFBF00FFE900E8FF
00B7FF0085FF0051FF001DFF1600FF4900FF7B00FFAB00FF
00FF7200FFA100FFD200FAFF00C6FF0091FF005EFF002BFF0500FF3300FF5E00FF8600FF
A900FFC700FFE000FFF300FFFF00FFFF00F7FF00F6FF00FBF900FFE900FFD300FFB800FF
9800FF7400FF4D00FF2300FF0007FF0034FF0061FF008DFF00B8FF00E1FF00FFF800FFD6
00FFB800FF9F00FF8C00FF7E00FF7700FF7500FF7A00FF8400FF9400FFAA00FFC400FFE2
00FBFF00D8FF00B2FF008DFF0068FF0044FF0023FF0005FF1300FF2700FF3600FF3F00FF
4200FF3F00FF3500FF2600FF1200FF0005FF0020FF003DFF005CFF007AFF0096FF00B0FF
00C6FF00D6FF00E2FF00E7FF00E6FF00DEFF00D2FF00C0FF00ABFF0095FF007DFF0068FF
0055FF0047FF003EFF003CFF0040FF004AFF0058FF0068FF0077FF0084FF008BFF008CFF
0086FF007CFF0074FF0074FF0078FF0079FF0072FF0068FF0062FF0061FF0067FF0072FF
0082FF0092FF00A0FF00ABFF00B0FF00AFFF00A8FF009BFF0089FF0074FF005CFF0045FF
0030FF001EFF0010FF0008FF0006FF0009FF0013FF0023FF0038FF0051FF006DFF008BFF
00A9FF00C7FF00E3FF00FCFF00FFEF00FFDF00FFD400FFD000FFD100FFD900FFE700FFFA
00ECFF00D0FF00AFFF008CFF0067FF0042FF001CFF0700FF2900FF4800FF6300FF7900FF
8A00FF9600FF9C00FF9C00FF9500FF8900FF7600FF5E00FF4200FF2000FF0004FF002CFF
0057FF0083FF00B0FF00DDFF00FFF600FFCC00FFA500FF8000FF6000FF4400FF2D00FF1B
00FF0F00FF0900FF0900FF0F00FF1B00FF2E00FF4500FF6300FF8500FFAB00FFD600FCFF
00CBFF0099FF0065FF0031FF0200FF3600FF6700FF9700FF
00FF5900FF8900FFBA00FFED00DEFF00AAFF0076FF0043FF0012FF1B00FF4600FF6E00FF
9000FFAF00FFC800FFDB00FFE800FFF000FFF100FFEC00FFE100FFD100FFBB00FFA000FF
8000FF5C00FF3500FF0B00FF001FFF004CFF0079FF00A5FF00D0FF00F9FF00FFE000FFBE
00FFA000FF8700FF7400FF6600FF5F00FF5D00FF6200FF6C00FF7C00FF9200FFAC00FFCA
00FFEC00F0FF00CAFF00A5FF0080FF005CFF003BFF001DFF0004FF0F00FF1E00FF2700FF
2A00FF2600FF1D00FF0E00FF0005FF001DFF0038FF0056FF0074FF0092FF00AEFF00C8FF
00DEFF00EFFF00FAFF00FFFF00FEFF00F6FF00EAFF00D8FF00C4FF00ADFF0096FF0080FF
006DFF005FFF0056FF0054FF0058FF0062FF0070FF0080FF0090FF009CFF00A3FF00A4FF
009EFF0094FF008CFF008CFF0090FF0091FF008AFF0081FF007AFF0079FF007FFF008AFF
009AFF00AAFF00B8FF00C3FF00C8FF00C7FF00C0FF00B3FF00A1FF008CFF0075FF005EFF
0048FF0036FF0028FF0020FF001EFF0022FF002CFF003BFF0050FF0069FF0085FF00A3FF
00C1FF00DFFF00FBFF00FFEB00FFD700FFC700FFBC00FFB800FFB900FFC100FFCF00FFE2
00FFFA00E8FF00C7FF00A4FF007FFF005AFF0034FF0010FF1100FF3000FF4B00FF6100FF
7200FF7E00FF8400FF8300FF7D00FF7100FF5E00FF4600FF2900FF0800FF001CFF0044FF
006FFF009BFF00C8FF00F5FF00FFDE00FFB400FF8C00FF6800FF4800FF2C00FF1400FF03
08FF000EFF000EFF0008FF0000FF0300FF1600FF2D00FF4B00FF6D00FF9300FFBE00FFEB
00E3FF00B1FF007DFF0049FF0015FF1D00FF4F00FF7F00FF
00FF3E00FF6D00FF9F00FFD200F9FF00C5FF0091FF005EFF002DFF0000FF2B00FF5200FF
7500FF9300FFAC00FFBF00FFCD00FFD400FFD600FFD100FFC600FFB500FF9F00FF8400FF
6500FF4100FF1A00FF000FFF003BFF0067FF0094FF00C1FF00ECFF00FFEB00FFC500FFA3
00FF8500FF6C00FF5900FF4B00FF4300FF4200FF4600FF5100FF6100FF7700FF9100FFAF
00FFD000FFF400E6FF00C0FF009BFF0077FF0056FF0039FF001FFF000BFF0300FF0C00FF
0F00FF0B00FF0200FF000CFF0020FF0038FF0053FF0071FF008FFF00ADFF00CAFF00E3FF
00F9FF00FFF500FFEA00FFE500FFE600FFED00FFFA00F4FF00DFFF00C8FF00B1FF009BFF
0088FF007AFF0072FF006FFF0073FF007DFF008BFF009BFF00ABFF00B7FF00BFFF00BFFF
00B9FF00B0FF00A8FF00A7FF00ACFF00ADFF00A6FF009CFF0095FF0094FF009AFF00A6FF
00B5FF00C5FF00D4FF00DEFF00E4FF00E3FF00DBFF00CEFF00BCFF00A7FF0090FF0079FF
0064FF0051FF0044FF003BFF0039FF003DFF0047FF0057FF006BFF0084FF00A0FF00BEFF
00DDFF00FAFF00FFE900FFD000FFBB00FFAB00FFA100FF9C00FF9E00FFA600FFB300FFC7
00FFDF00FFFC00E3FF00BFFF009BFF0075FF0050FF002BFF0009FF1400FF2F00FF4600FF
5700FF6300FF6900FF6800FF6200FF5500FF4300FF2B00FF0E00FF0012FF0037FF0060FF
008AFF00B6FF00E3FF00FFEF00FFC300FF9900FF7100FF4D00FF2C00FF1006FF0017FF00
23FF0029FF0029FF0023FF0017FF0005FF0000FF1200FF2F00FF5100FF7800FFA200FFD0
00FFFF00CCFF0099FF0064FF0030FF0200FF3400FF6400FF
00FF2100FF5000FF8100FFB400FFE800E2FF00AEFF007CFF004BFF001DFF0D00FF3500FF
5800FF7600FF8F00FFA200FFAF00FFB700FFB800FFB300FFA800FF9800FF8200FF6700FF
4700FF2300FF0003FF002CFF0058FF0085FF00B2FF00DEFF00FFF600FFCD00FFA700FF85
00FF6700FF4F00FF3B00FF2D00FF2600FF2400FF2900FF3300FF4400FF5900FF7300FF91
00FFB300FFD700FFFC00DEFF00B8FF0095FF0074FF0056FF003DFF0028FF001AFF0011FF
000EFF0011FF001BFF002AFF003DFF0056FF0071FF008EFF00ADFF00CBFF00E7FF00FFFE
00FFE900FFD800FFCD00FFC700FFC900FFD000FFDD00FFEE00FCFF00E5FF00CEFF00B9FF
00A6FF0098FF008FFF008DFF0091FF009BFF00A9FF00B9FF00C8FF00D5FF00DCFF00DDFF
00D7FF00CDFF00C5FF00C4FF00C9FF00CAFF00C3FF00B9FF00B2FF00B1FF00B7FF00C3FF
00D2FF00E3FF00F1FF00FCFF00FFFE00FFFF00F9FF00ECFF00DAFF00C4FF00ADFF0096FF
0081FF006FFF0061FF0059FF0056FF005AFF0064FF0074FF0089FF00A2FF00BEFF00DCFF
00FAFF00FFE700FFCB00FFB300FF9E00FF8E00FF8300FF7F00FF8000FF8800FF9600FFA9
00FFC200FFDF00FFFF00DDFF00B8FF0092FF006DFF0049FF0027FF0008FF1200FF2800FF
3A00FF4500FF4B00FF4B00FF4400FF3800FF2500FF0E00FF000EFF0030FF0055FF007DFF
00A8FF00D4FF00FFFE00FFD100FFA500FF7B00FF5400FF2F00FF0F0CFF0023FF0035FF00
41FF0047FF0047FF0041FF0034FF0022FF000AFF0000FF1200FF3400FF5A00FF8500FFB2
00FFE300EAFF00B6FF0082FF004EFF001AFF1700FF4600FF
00FF0200FF3100FF6300FF9600FFCA00FFFE00CDFF009AFF0069FF003BFF0010FF1600FF
3900FF5700FF7000FF8400FF9100FF9800FF9A00FF9500FF8A00FF7A00FF6300FF4800FF
2900FF0500FF0021FF004BFF0076FF00A3FF00D0FF00FCFF00FFD800FFAF00FF8900FF67
00FF4900FF3000FF1D00FF0F00FF0700FF0600FF0A00FF1500FF2500FF3B00FF5500FF73
00FF9400FFB800FFDD00FCFF00D7FF00B3FF0092FF0075FF005BFF0047FF0038FF002FFF
002CFF0030FF0039FF0048FF005CFF0074FF008FFF00ADFF00CBFF00E9FF00FFF900FFE0
00FFCA00FFB900FFAE00FFA900FFAA00FFB100FFBE00FFD000FFE400FFFB00EDFF00D7FF
00C4FF00B6FF00ADFF00ABFF00AFFF00B9FF00C7FF00D7FF00E7FF00F3FF00FAFF00FBFF
00F5FF00ECFF00E3FF00E3FF00E7FF00E8FF00E1FF00D8FF00D1FF00D0FF00D6FF00E2FF
00F1FF00FFFE00FFEF00FFE500FFDF00FFE000FFE800FFF500F8FF00E3FF00CCFF00B5FF
009FFF008DFF007FFF0077FF0075FF0079FF0083FF0092FF00A7FF00C0FF00DCFF00FAFF
00FFE700FFC900FFAD00FF9400FF7F00FF6F00FF6500FF6000FF6200FF6A00FF7800FF8B
00FFA300FFC000FFE100FBFF00D6FF00B1FF008BFF0067FF0045FF0026FF000BFF0A00FF
1B00FF2700FF2D00FF2C00FF2600FF1900FF0700FF0010FF002DFF004EFF0073FF009BFF
00C6FF00F2FF00FFE000FFB300FF8700FF5D00FF3500FF110FFF002BFF0042FF0053FF00
5FFF0065FF0065FF005FFF0053FF0041FF0029FF000CFF0000FF1500FF3C00FF6600FF94
00FFC400FFF700D4FF00A0FF006CFF0039FF0007FF2800FF
1BFF0000FF1300FF4500FF7800FFAC00FFE000EBFF00B8FF0087FF0059FF002EFF0007FF
1B00FF3900FF5200FF6600FF7300FF7A00FF7C00FF7700FF6C00FF5B00FF4500FF2A00FF
0B00FF0018FF003FFF0069FF0094FF00C1FF00EEFF00FFE500FFBA00FF9100FF6B00FF49
00FF2B00FF1200FF000EFF0016FF0017FF0013FF0008FF0000FF0700FF1D00FF3700FF55
00FF7600FF9A00FFBF00FFE500F5FF00D1FF00B0FF0093FF0079FF0065FF0056FF004DFF
004AFF004EFF0057FF0066FF007AFF0092FF00ADFF00CBFF00E9FF00FFF800FFDB00FFC2
00FFAC00FF9B00FF9000FF8B00FF8C00FF9300FFA000FFB100FFC600FFDD00FFF400F5FF
00E2FF00D4FF00CBFF00C9FF00CDFF00D7FF00E5FF00F5FF00FFFA00FFEE00FFE600FFE6
00FFEC00FFF500FFFE00FFFE00FFFA00FFF900FFFF00F6FF00EFFF00EEFF00F4FF00FFFF
00FFF000FFE000FFD100FFC700FFC100FFC200FFCA00FFD700FFE900FFFE00EAFF00D3FF
00BDFF00ABFF009EFF0095FF0093FF0097FF00A1FF00B1FF00C5FF00DEFF00FAFF00FFE7
00FFC800FFAB00FF8F00FF7600FF6100FF5100FF4700FF4200FF4400FF4C00FF5900FF6D
00FF8500FFA200FFC300FFE600F4FF00CFFF00A9FF0085FF0063FF0044FF0029FF0013FF
0002FF0900FF0F00FF0E00FF0800FF0004FF0016FF002EFF004BFF006CFF0091FF00B9FF
00E4FF00FFEF00FFC200FF9500FF6900FF3F00FF170CFF002DFF0049FF0060FF0071FF00
7DFF0083FF0083FF007DFF0071FF005FFF0047FF002AFF0008FF0000FF1E00FF4800FF76
00FFA600FFD900F2FF00BEFF008AFF0057FF0025FF0A00FF
37FF0008FF0000FF2800FF5B00FF8F00FFC400FFF800D5FF00A4FF0076FF004AFF0023FF
0000FF1D00FF3600FF4900FF5700FF5E00FF5F00FF5A00FF5000FF3F00FF2900FF0E00FF
0011FF0034FF005CFF0085FF00B1FF00DEFF00FFF400FFC800FF9D00FF7400FF4E00FF2C
00FF0F09FF001DFF002AFF0032FF0034FF002FFF0024FF0014FF0000FF0000FF1A00FF39
00FF5A00FF7E00FFA300FFC900FFEE00EEFF00CDFF00AFFF0096FF0081FF0072FF006AFF
0067FF006AFF0073FF0082FF0096FF00AEFF00CAFF00E7FF00FFF900FFDB00FFBF00FFA5
00FF9000FF7F00FF7400FF6F00FF7000FF7700FF8400FF9500FFAA00FFC100FFD800FFEE
00FFFF00F0FF00E8FF00E6FF00EAFF00F3FF00FFFE00FFED00FFDE00FFD100FFCA00FFCA
00FFCF00FFD900FFE100FFE200FFDD00FFDC00FFE300FFED00FFF400FFF500FFEF00FFE3
00FFD400FFC300FFB500FFAA00FFA500FFA600FFAD00FFBB00FFCC00FFE200FFF900EFFF
00DAFF00C8FF00BAFF00B2FF00AFFF00B3FF00BDFF00CDFF00E2FF00FBFF00FFE800FFCA
00FFAC00FF8E00FF7300FF5A00FF4500FF3500FF2B00FF2600FF2800FF2F00FF3D00FF50
00FF6900FF8600FFA600FFC900FFEE00EBFF00C6FF00A2FF0080FF0061FF0046FF0030FF
001EFF0013FF000DFF000DFF0014FF0020FF0032FF004AFF0067FF0088FF00AEFF00D6FF
00FFFE00FFD200FFA500FF7800FF4D00FF2204FF0029FF0049FF0065FF007CFF008EFF00
9AFF00A0FF00A0FF0099FF008DFF007BFF0063FF0046FF0024FF0000FF0100FF2C00FF5A
00FF8A00FFBC00FFF000DBFF00A6FF0073FF0041FF0012FF
51FF0022FF0000FF0F00FF4200FF7600FFAA00FFDE00EEFF00BDFF008FFF0064FF003DFF
001AFF0300FF1C00FF3000FF3D00FF4400FF4600FF4100FF3600FF2500FF0F00FF000BFF
002AFF004EFF0075FF009FFF00CAFF00F7FF00FFDB00FFAE00FF8300FF5B00FF3500FF13
0AFF0023FF0036FF0044FF004CFF004DFF0049FF003EFF002EFF0018FF0000FF0100FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF800E6FF00C9FF00AFFF009BFF008CFF0083FF
0080FF0084FF008DFF009CFF00B0FF00C8FF00E3FF00FFFE00FFE000FFC200FFA500FF8C
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE700FFF500FFFD00FFFF00FFFC00FFF200FFE400FFD400FFC400FFB800FFB000FFB0
00FFB600FFBF00FFC700FFC800FFC300FFC200FFCA00FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9100FF8B00FF8C00FF9400FFA100FFB300FFC800FFDF00FFF6
00F3FF00E1FF00D4FF00CBFF00C9FF00CDFF00D7FF00E7FF00FBFF00FFEB00FFCF00FFB1
00FF9200FF7500FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1600FF2300FF37
00FF4F00FF6C00FF8C00FFB000FFD400FFFA00DFFF00BBFF0099FF007BFF0060FF0049FF
0038FF002CFF0026FF0027FF002DFF003AFF004CFF0064FF0081FF00A2FF00C7FF00F0FF
00FFE500FFB900FF8C00FF5F00FF3300FF091EFF0042FF0063FF007FFF0096FF00A7FF00
B3FF00B9FF00B9FF00B3FF00A7FF0095FF007DFF0060FF003EFF0017FF0000FF1200FF40
00FF7000FFA300FFD600F4FF00C0FF008DFF005BFF002BFF
67FF0037FF0006FF0000FF2C00FF6000FF9400FFC800FFFB00D3FF00A5FF007AFF0052FF
002FFF0011FF0700FF1A00FF2700FF2F00FF3000FF2B00FF2000FF1000FF0005FF0020FF
0040FF0064FF008BFF00B5FF00E0FF00FFF200FFC500FF9900FF6E00FF4500FF1F02FF00
20FF0039FF004CFF005AFF0061FF0063FF005EFF0054FF0044FF002EFF0014FF0000FF09
00FF2B00FF4E00FF7400FF9900FFBE00FFE200FCFF00DEFF00C5FF00B1FF00A2FF0099FF
0096FF0099FF00A3FF00B2FF00C6FF00DEFF00F9FF00FFE900FFCA00FFAC00FF9000FF76
00FF6000FF5000FF4400FF3F00FF4000FF4800FF5400FF6600FF7B00FF9100FFA900FFBE
00FFD100FFDF00FFE800FFEA00FFE600FFDC00FFCE00FFBE00FFAE00FFA200FF9B00FF9A
00FFA000FFAA00FFB200FFB200FFAE00FFAD00FFB400FFBE00FFC400FFC500FFBF00FFB4
00FFA400FF9400FF8600FF7B00FF7600FF7700FF7E00FF8B00FF9D00FFB200FFC900FFE0
00FFF600F7FF00E9FF00E1FF00DFFF00E2FF00EDFF00FCFF00FFEE00FFD500FFB900FF9B
00FF7D00FF5F00FF4300FF2A00FF1600FF0604FF0008FF0007FF0000FF0000FF0E00FF21
00FF3900FF5600FF7700FF9A00FFBF00FFE400F5FF00D1FF00AFFF0090FF0075FF005FFF
004EFF0042FF003CFF003CFF0043FF004FFF0062FF007AFF0096FF00B8FF00DDFF00FFFA
00FFCF00FFA300FF7600FF4900FF1D0CFF0033FF0058FF0078FF0094FF00ABFF00BDFF00
C9FF00CFFF00CFFF00C9FF00BDFF00AAFF0093FF0075FF0053FF002DFF0002FF0000FF2A
00FF5B00FF8D00FFC100FFF500D6FF00A2FF0071FF0041FF
77FF0048FF0017FF0000FF1B00FF4F00FF8400FFB800FFEA00E4FF00B6FF008BFF0063FF
0040FF0022FF0009FF0900FF1600FF1E00FF1F00FF1A00FF0F00FF0000FF0016FF0031FF
0051FF0075FF009CFF00C5FF00F1FF00FFE100FFB400FF8800FF5D00FF3400FF0E13FF00
31FF0049FF005DFF006BFF0072FF0074FF006FFF0065FF0054FF003FFF0025FF0007FF00
00FF1A00FF3E00FF6300FF8800FFAE00FFD100FFF200EFFF00D6FF00C1FF00B3FF00AAFF
00A7FF00AAFF00B4FF00C3FF00D6FF00EFFF00FFF500FFD800FFB900FF9B00FF7F00FF65
00FF5000FF3F00FF3400FF2E00FF3000FF3700FF4400FF5500FF6A00FF8100FF9800FFAD
00FFC000FFCE00FFD700FFD900FFD500FFCB00FFBD00FFAD00FF9E00FF9100FF8A00FF89
00FF8F00FF9900FFA100FFA200FF9D00FF9C00FFA300FFAD00FFB400FFB400FFAF00FFA3
00FF9400FF8300FF7500FF6A00FF6500FF6600FF6D00FF7A00FF8C00FFA200FFB900FFD0
00FFE500FFF700FAFF00F2FF00EFFF00F3FF00FDFF00FFF200FFDD00FFC400FFA800FF8A
00FF6C00FF4E00FF3200FF1A00FF050AFF0015FF0019FF0018FF0010FF0002FF0000FF10
00FF2900FF4500FF6600FF8900FFAE00FFD400FFF900E2FF00C0FF00A1FF0086FF0070FF
005EFF0053FF004DFF004DFF0054FF0060FF0073FF008AFF00A7FF00C9FF00EEFF00FFE9
00FFBE00FF9200FF6500FF3800FF0C1DFF0044FF0069FF0089FF00A5FF00BCFF00CEFF00
DAFF00E0FF00E0FF00DAFF00CDFF00BBFF00A3FF0086FF0064FF003EFF0013FF0000FF19
00FF4A00FF7C00FFB000FFE400E7FF00B3FF0082FF0052FF
83FF0053FF0022FF0000FF1000FF4400FF7800FFAC00FFDF00EFFF00C1FF0096FF006EFF
004BFF002DFF0014FF0001FF0B00FF1300FF1400FF0F00FF0400FF000BFF0021FF003CFF
005CFF0080FF00A7FF00D1FF00FCFF00FFD600FFA900FF7D00FF5200FF2900FF031EFF00
3CFF0055FF0068FF0076FF007DFF007FFF007AFF0070FF0060FF004AFF0030FF0012FF00
00FF0F00FF3200FF5800FF7D00FFA200FFC600FFE700FAFF00E1FF00CDFF00BEFF00B5FF
00B2FF00B5FF00BFFF00CEFF00E2FF00FAFF00FFEA00FFCD00FFAE00FF9000FF7400FF5A
00FF4400FF3400FF2800FF2300FF2400FF2C00FF3800FF4A00FF5F00FF7500FF8D00FFA2
00FFB500FFC300FFCC00FFCE00FFCA00FFC000FFB200FFA200FF9200FF8600FF7F00FF7E
00FF8400FF8E00FF9600FF9600FF9200FF9100FF9800FFA200FFA800FFA900FFA300FF98
00FF8800FF7800FF6A00FF5F00FF5A00FF5B00FF6200FF6F00FF8100FF9600FFAD00FFC4
00FFDA00FFEC00FFFA00FDFF00FBFF00FEFF00FFF600FFE700FFD200FFB900FF9D00FF7F
00FF6100FF4300FF2700FF0E05FF0015FF0020FF0024FF0023FF001BFF000DFF0000FF05
00FF1D00FF3A00FF5B00FF7E00FFA300FFC800FFEE00EDFF00CBFF00ACFF0091FF007BFF
006AFF005EFF0058FF0058FF005FFF006BFF007EFF0096FF00B2FF00D4FF00F9FF00FFDE
00FFB300FF8700FF5A00FF2D00FF0128FF004FFF0074FF0094FF00B0FF00C7FF00D9FF00
E5FF00EBFF00EBFF00E5FF00D9FF00C6FF00AFFF0091FF006FFF0049FF001EFF0000FF0E
00FF3F00FF7100FFA500FFD900F2FF00BEFF008DFF005DFF
88FF0058FF0027FF0000FF0B00FF3F00FF7300FFA700FFDA00F4FF00C6FF009BFF0074FF
0051FF0032FF001AFF0006FF0600FF0E00FF0F00FF0A00FF0000FF0010FF0026FF0042FF
0061FF0085FF00ACFF00D6FF00FFFE00FFD100FFA400FF7800FF4D00FF2401FF0023FF00
41FF005AFF006DFF007BFF0082FF0084FF007FFF0075FF0065FF004FFF0035FF0017FF00
00FF0A00FF2D00FF5300FF7800FF9D00FFC100FFE200FFFF00E6FF00D2FF00C3FF00BAFF
00B7FF00BBFF00C4FF00D3FF00E7FF00FFFF00FFE500FFC700FFA900FF8B00FF6F00FF55
00FF3F00FF2E00FF2300FF1E00FF1F00FF2600FF3300FF4500FF5900FF7000FF8700FF9D
00FFB000FFBE00FFC700FFC900FFC500FFBB00FFAD00FF9D00FF8D00FF8100FF7A00FF79
00FF7F00FF8900FF9100FF9100FF8D00FF8C00FF9300FF9C00FFA300FFA400FF9E00FF93
00FF8300FF7300FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7C00FF9100FFA800FFBF
00FFD500FFE700FFF500FFFD00FFFF00FFFB00FFF100FFE200FFCD00FFB400FF9800FF7A
00FF5C00FF3E00FF2200FF090AFF001AFF0025FF0029FF0028FF0020FF0012FF0000FF00
00FF1800FF3500FF5600FF7900FF9E00FFC300FFE900F2FF00D0FF00B1FF0096FF0080FF
006FFF0063FF005DFF005EFF0064FF0071FF0083FF009BFF00B8FF00D9FF00FEFF00FFD9
00FFAE00FF8200FF5500FF2803FF002DFF0055FF0079FF0099FF00B6FF00CDFF00DEFF00
EAFF00F0FF00F0FF00EAFF00DEFF00CBFF00B4FF0097FF0074FF004EFF0024FF0000FF09
00FF3A00FF6C00FFA000FFD400F7FF00C4FF0092FF0062FF
86FF0057FF0026FF0000FF0C00FF4000FF7500FFA800FFDB00F3FF00C5FF009AFF0072FF
004FFF0031FF0018FF0005FF0700FF0F00FF1000FF0B00FF0000FF000FFF0025FF0040FF
0060FF0084FF00ABFF00D5FF00FFFF00FFD200FFA500FF7900FF4E00FF2500FF0022FF00
40FF0059FF006CFF007AFF0081FF0083FF007EFF0074FF0064FF004EFF0034FF0016FF00
00FF0B00FF2E00FF5400FF7900FF9E00FFC200FFE300FEFF00E5FF00D1FF00C2FF00B9FF
00B6FF00B9FF00C3FF00D2FF00E6FF00FEFF00FFE600FFC900FFAA00FF8C00FF7000FF56
00FF4000FF3000FF2400FF1F00FF2000FF2800FF3400FF4600FF5B00FF7100FF8900FF9E
00FFB100FFBF00FFC800FFCA00FFC600FFBC00FFAE00FF9E00FF8F00FF8200FF7B00FF7A
00FF8000FF8A00FF9200FF9300FF8E00FF8D00FF9400FF9E00FFA400FFA500FF9F00FF94
00FF8400FF7400FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7D00FF9200FFAA00FFC1
00FFD600FFE800FFF600FFFE00FFFF00FFFD00FFF300FFE300FFCE00FFB500FF9900FF7B
00FF5D00FF3F00FF2300FF0A09FF0019FF0024FF0028FF0027FF001FFF0011FF0000FF01
00FF1A00FF3600FF5700FF7A00FF9F00FFC400FFEA00F1FF00CFFF00B0FF0095FF007FFF
006EFF0062FF005CFF005CFF0063FF006FFF0082FF009AFF00B6FF00D8FF00FDFF00FFDA
00FFAF00FF8300FF5600FF2902FF002CFF0053FF0078FF0098FF00B4FF00CBFF00DDFF00
E9FF00EFFF00EFFF00E9FF00DCFF00CAFF00B3FF0095FF0073FF004DFF0022FF0000FF0A
00FF3B00FF6D00FFA100FFD500F6FF00C2FF0091FF0061FF
7FFF0050FF001FFF0000FF1300FF4700FF7C00FFB000FFE200ECFF00BEFF0092FF006BFF
0048FF002AFF0011FF0100FF0F00FF1600FF1700FF1200FF0800FF0008FF001EFF0039FF
0059FF007DFF00A4FF00CDFF00F9FF00FFD900FFAC00FF8000FF5500FF2C00FF061BFF00
39FF0051FF0065FF0072FF007AFF007CFF0077FF006DFF005CFF0047FF002DFF000FFF00
00FF1200FF3600FF5B00FF8100FFA600FFC900FFEA00F7FF00DEFF00C9FF00BBFF00B2FF
00AFFF00B2FF00BCFF00CAFF00DEFF00F6FF00FFED00FFD000FFB100FF9300FF7700FF5D
00FF4800FF3700FF2C00FF2600FF2800FF2F00FF3C00FF4D00FF6200FF7900FF9000FFA6
00FFB800FFC600FFCF00FFD100FFCD00FFC300FFB600FFA500FF9600FF8900FF8200FF81
00FF8700FF9100FF9900FF9A00FF9500FF9400FF9B00FFA500FFAC00FFAD00FFA700FF9B
00FF8C00FF7B00FF6D00FF6200FF5D00FF5E00FF6500FF7200FF8400FF9A00FFB100FFC8
00FFDD00FFEF00FFFD00FAFF00F7FF00FBFF00FFFA00FFEA00FFD500FFBC00FFA000FF82
00FF6400FF4600FF2A00FF1202FF0012FF001DFF0021FF0020FF0018FF000AFF0000FF08
00FF2100FF3E00FF5E00FF8100FFA600FFCC00FFF100EAFF00C8FF00A9FF008EFF0078FF
0066FF005BFF0055FF0055FF005CFF0068FF007BFF0092FF00AFFF00D1FF00F6FF00FFE1
00FFB600FF8A00FF5D00FF3000FF0525FF004CFF0071FF0091FF00ADFF00C4FF00D6FF00
E2FF00E8FF00E8FF00E2FF00D5FF00C3FF00ABFF008EFF006CFF0046FF001BFF0000FF12
00FF4200FF7400FFA800FFDC00EFFF00BBFF0089FF005AFF
73FF0043FF0012FF0000FF2000FF5400FF8800FFBC00FFEF00DFFF00B1FF0086FF005EFF
003BFF001DFF0004FF0E00FF1B00FF2300FF2400FF1F00FF1400FF0400FF0011FF002CFF
004CFF0070FF0097FF00C1FF00ECFF00FFE600FFB900FF8D00FF6200FF3900FF130EFF00
2CFF0045FF0058FF0066FF006DFF006FFF006AFF0060FF0050FF003AFF0020FF0002FF00
00FF1F00FF4200FF6800FF8D00FFB200FFD600FFF700EAFF00D1FF00BDFF00AEFF00A5FF
00A2FF00A5FF00AFFF00BEFF00D2FF00EAFF00FFFA00FFDD00FFBE00FFA000FF8400FF6A
00FF5400FF4400FF3800FF3300FF3400FF3C00FF4800FF5A00FF6F00FF8500FF9D00FFB2
00FFC500FFD300FFDC00FFDE00FFDA00FFD000FFC200FFB200FFA200FF9600FF8F00FF8E
00FF9400FF9E00FFA600FFA600FFA200FFA100FFA800FFB200FFB800FFB900FFB300FFA8
00FF9800FF8800FF7A00FF6F00FF6A00FF6B00FF7200FF7F00FF9100FFA600FFBD00FFD4
00FFEA00FFFC00F5FF00EDFF00EBFF00EEFF00F9FF00FFF700FFE200FFC900FFAD00FF8F
00FF7100FF5300FF3700FF1E00FF0A05FF0010FF0014FF0013FF000BFF0000FF0200FF15
00FF2D00FF4A00FF6B00FF8E00FFB300FFD800FFFE00DDFF00BBFF009CFF0081FF006BFF
005AFF004EFF0048FF0048FF004FFF005BFF006EFF0086FF00A2FF00C4FF00E9FF00FFEE
00FFC300FF9700FF6A00FF3D00FF1118FF003FFF0064FF0084FF00A0FF00B7FF00C9FF00
D5FF00DBFF00DBFF00D5FF00C9FF00B6FF009FFF0081FF005FFF0039FF000EFF0000FF1E
00FF4F00FF8100FFB500FFE900E2FF00AEFF007DFF004DFF
61FF0032FF0001FF0000FF3200FF6600FF9A00FFCE00FFFF00CEFF009FFF0074FF004DFF
002AFF000CFF0C00FF1F00FF2D00FF3400FF3500FF3000FF2600FF1500FF0000FF001BFF
003BFF005EFF0085FF00AFFF00DBFF00FFF800FFCB00FF9E00FF7300FF4A00FF2400FF02
1AFF0033FF0047FF0054FF005CFF005EFF0059FF004EFF003EFF0029FF000FFF0000FF0F
00FF3000FF5400FF7900FF9F00FFC400FFE700F7FF00D9FF00C0FF00ABFF009CFF0093FF
0091FF0094FF009DFF00ACFF00C0FF00D8FF00F4FF00FFEE00FFD000FFB100FF9500FF7B
00FF6600FF5500FF4A00FF4500FF4600FF4D00FF5A00FF6B00FF8000FF9700FFAE00FFC4
00FFD600FFE500FFED00FFEF00FFEB00FFE200FFD400FFC400FFB400FFA700FFA000FFA0
00FFA600FFAF00FFB700FFB800FFB300FFB200FFB900FFC300FFCA00FFCB00FFC500FFB9
00FFAA00FF9A00FF8B00FF8000FF7B00FF7C00FF8300FF9100FFA300FFB800FFCF00FFE6
00FFFB00F2FF00E4FF00DCFF00D9FF00DDFF00E7FF00F7FF00FFF300FFDA00FFBE00FFA1
00FF8200FF6400FF4900FF3000FF1B00FF0B00FF0103FF0001FF0000FF0500FF1300FF26
00FF3F00FF5C00FF7C00FF9F00FFC400FFEA00F0FF00CCFF00AAFF008BFF0070FF0059FF
0048FF003DFF0037FF0037FF003EFF004AFF005CFF0074FF0091FF00B2FF00D8FF00FFFF
00FFD400FFA800FF7B00FF4F00FF2306FF002EFF0052FF0073FF008FFF00A6FF00B8FF00
C4FF00CAFF00CAFF00C3FF00B7FF00A5FF008DFF0070FF004EFF0027FF0000FF0200FF30
00FF6000FF9200FFC600FFFA00D0FF009DFF006BFF003CFF
4CFF001DFF0000FF1300FF4600FF7A00FFAF00FFE300EAFF00B9FF008BFF0060FF0038FF
0015FF0800FF2100FF3400FF4100FF4900FF4A00FF4500FF3A00FF2A00FF1400FF0006FF
0026FF004AFF0071FF009AFF00C6FF00F3FF00FFDF00FFB300FF8800FF5F00FF3900FF17
06FF001EFF0032FF0040FF0047FF0049FF0044FF003AFF0029FF0014FF0000FF0500FF23
00FF4500FF6900FF8E00FFB300FFD900FFFC00E2FF00C4FF00ABFF0096FF0088FF007FFF
007CFF007FFF0089FF0098FF00ABFF00C4FF00DFFF00FCFF00FFE400FFC600FFAA00FF90
00FF7B00FF6A00FF5F00FF5900FF5B00FF6200FF6F00FF8000FF9500FFAC00FFC300FFD9
00FFEB00FFF900FDFF00FBFF00FFFF00FFF600FFE800FFD800FFC900FFBC00FFB500FFB4
00FFBA00FFC400FFCC00FFCD00FFC800FFC700FFCE00FFD800FFDF00FFE000FFDA00FFCE
00FFBF00FFAE00FFA000FF9500FF9000FF9100FF9800FFA500FFB700FFCD00FFE400FFFB
00EFFF00DDFF00CFFF00C7FF00C4FF00C8FF00D2FF00E2FF00F7FF00FFEF00FFD300FFB5
00FF9700FF7900FF5D00FF4500FF3000FF2000FF1500FF1100FF1200FF1A00FF2800FF3B
00FF5400FF7100FF9100FFB400FFD900FFFF00DBFF00B7FF0095FF0076FF005BFF0045FF
0033FF0028FF0022FF0022FF0029FF0035FF0048FF005FFF007CFF009EFF00C3FF00EBFF
00FFE900FFBD00FF9000FF6300FF3800FF0D19FF003EFF005EFF007AFF0091FF00A3FF00
AFFF00B5FF00B5FF00AFFF00A2FF0090FF0078FF005BFF0039FF0013FF0000FF1700FF44
00FF7500FFA700FFDB00F0FF00BCFF0088FF0056FF0027FF
35FF0006FF0000FF2A00FF5D00FF9100FFC600FFF900D3FF00A2FF0074FF0049FF0021FF
0100FF1F00FF3800FF4B00FF5800FF6000FF6100FF5C00FF5100FF4100FF2B00FF1000FF
000FFF0033FF005AFF0084FF00AFFF00DCFF00FFF600FFCA00FF9F00FF7600FF5000FF2E
00FF1008FF001BFF0029FF0030FF0032FF002DFF0023FF0013FF0000FF0200FF1C00FF3A
00FF5C00FF7F00FFA500FFCA00FFEF00ECFF00CBFF00ADFF0094FF0080FF0071FF0068FF
0065FF0068FF0072FF0081FF0095FF00ADFF00C8FF00E5FF00FFFB00FFDD00FFC100FFA7
00FF9100FF8100FF7500FF7000FF7100FF7900FF8500FF9700FFAC00FFC200FFDA00FFEF
00FDFF00EFFF00E6FF00E4FF00E8FF00F2FF00FFFF00FFEF00FFE000FFD300FFCC00FFCB
00FFD100FFDB00FFE300FFE300FFDF00FFDE00FFE500FFEF00FFF500FFF600FFF000FFE5
00FFD500FFC500FFB700FFAC00FFA700FFA800FFAF00FFBC00FFCE00FFE300FFFB00EDFF
00D8FF00C6FF00B8FF00B0FF00AEFF00B1FF00BBFF00CBFF00E0FF00F9FF00FFEA00FFCC
00FFAE00FF9000FF7400FF5B00FF4700FF3700FF2C00FF2800FF2900FF3100FF3F00FF52
00FF6B00FF8700FFA800FFCB00FFF000EAFF00C4FF00A0FF007EFF005FFF0044FF002EFF
001DFF0011FF000BFF000BFF0012FF001EFF0031FF0049FF0065FF0087FF00ACFF00D4FF
00FFFF00FFD400FFA700FF7A00FF4E00FF2402FF0027FF0047FF0063FF007AFF008CFF00
98FF009EFF009EFF0098FF008CFF0079FF0062FF0044FF0022FF0000FF0300FF2E00FF5B
00FF8C00FFBE00FFF200D9FF00A5FF0071FF0040FF0010FF
1EFF0000FF1000FF4100FF7400FFA800FFDD00EEFF00BCFF008BFF005DFF0032FF000AFF
1800FF3600FF4F00FF6200FF6F00FF7700FF7800FF7300FF6800FF5800FF4200FF2700FF
0700FF001CFF0043FF006CFF0098FF00C5FF00F2FF00FFE100FFB600FF8D00FF6700FF45
00FF2700FF0F04FF0012FF0019FF001BFF0016FF000CFF0000FF0400FF1900FF3300FF51
00FF7300FF9700FFBC00FFE100F8FF00D5FF00B4FF0096FF007DFF0068FF005AFF0051FF
004EFF0051FF005BFF006AFF007DFF0096FF00B1FF00CEFF00EDFF00FFF400FFD800FFBE
00FFA900FF9800FF8D00FF8700FF8900FF9000FF9D00FFAE00FFC300FFDA00FFF100F9FF
00E6FF00D8FF00CFFF00CDFF00D1FF00DBFF00E9FF00F9FF00FFF700FFEA00FFE300FFE2
00FFE800FFF200FFFA00FFFB00FFF600FFF500FFFC00F9FF00F2FF00F2FF00F7FF00FFFC
00FFED00FFDC00FFCE00FFC300FFBE00FFBF00FFC600FFD300FFE500FFFB00EDFF00D6FF
00C1FF00AFFF00A1FF0099FF0096FF009AFF00A4FF00B4FF00C9FF00E2FF00FEFF00FFE3
00FFC500FFA700FF8B00FF7300FF5E00FF4E00FF4300FF3F00FF4000FF4800FF5600FF69
00FF8200FF9E00FFBF00FFE200F8FF00D2FF00ADFF0089FF0067FF0048FF002DFF0017FF
0005FF0500FF0B00FF0B00FF0400FF0007FF001AFF0031FF004EFF0070FF0095FF00BDFF
00E8FF00FFEB00FFBE00FF9100FF6500FF3B00FF1410FF0030FF004CFF0063FF0075FF00
81FF0087FF0087FF0081FF0074FF0062FF004AFF002DFF000BFF0000FF1A00FF4500FF72
00FFA300FFD500F6FF00C2FF008EFF005AFF0028FF0600FF
09FF0000FF2600FF5700FF8A00FFBE00FFF200D9FF00A6FF0075FF0047FF001CFF0B00FF
2E00FF4C00FF6500FF7800FF8500FF8D00FF8E00FF8900FF7E00FF6E00FF5800FF3D00FF
1D00FF0006FF002DFF0057FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0303FF0005FF0000FF0000FF0900FF1900FF2F00FF4900FF67
00FF8900FFAC00FFD200FFF700E3FF00BFFF009EFF0080FF0067FF0053FF0044FF003BFF
0038FF003BFF0045FF0054FF0068FF0080FF009BFF00B9FF00D7FF00F5FF00FFEE00FFD4
00FFBE00FFAD00FFA200FF9D00FF9E00FFA600FFB200FFC400FFD900FFEF00F9FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F3FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EFFF00F3FF00F4FF00EDFF00E3FF00DDFF00DCFF00E2FF00EDFF
00FDFF00FFF200FFE400FFD900FFD400FFD500FFDC00FFE900FFFB00EFFF00D8FF00C1FF
00ABFF0099FF008BFF0083FF0081FF0085FF008FFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7400FF6400FF5900FF5500FF5600FF5E00FF6C00FF7F
00FF9700FFB400FFD500FFF800E2FF00BDFF0097FF0073FF0051FF0032FF0017FF0001FF
0F00FF1B00FF2100FF2100FF1A00FF0E00FF0004FF001CFF0038FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2A00FF051AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006BFF005FFF004CFF0035FF0017FF0000FF0A00FF3000FF5B00FF88
00FFB900FFEB00E0FF00ACFF0078FF0045FF0013FF1C00FF
00FF0900FF3800FF6A00FF9D00FFD100FAFF00C6FF0093FF0062FF0034FF0009FF1D00FF
4000FF5E00FF7700FF8B00FF9800FF9F00FFA100FF9C00FF9100FF8000FF6A00FF4F00FF
3000FF0C00FF001AFF0044FF006FFF009CFF00C9FF00F6FF00FFDE00FFB600FF9000FF6E
00FF5000FF3700FF2400FF1600FF0E00FF0D00FF1100FF1C00FF2C00FF4200FF5C00FF7A
00FF9B00FFBF00FFE400F5FF00D0FF00ACFF008BFF006EFF0054FF0040FF0031FF0028FF
0025FF0029FF0032FF0041FF0055FF006DFF0088FF00A6FF00C4FF00E2FF00FFFF00FFE7
00FFD100FFC000FFB500FFB000FFB100FFB800FFC500FFD600FFEB00FDFF00E6FF00D0FF
00BDFF00AFFF00A7FF00A4FF00A8FF00B2FF00C0FF00D0FF00E0FF00ECFF00F4FF00F4FF
00EEFF00E5FF00DDFF00DCFF00E0FF00E2FF00DAFF00D1FF00CAFF00C9FF00CFFF00DBFF
00EAFF00FAFF00FFF600FFEC00FFE600FFE700FFEF00FFFC00F1FF00DCFF00C5FF00AEFF
0098FF0086FF0079FF0070FF006EFF0072FF007CFF008CFF00A0FF00B9FF00D5FF00F3FF
00FFED00FFD000FFB400FF9B00FF8600FF7600FF6C00FF6700FF6900FF7100FF7E00FF92
00FFAA00FFC700FFE700F4FF00D0FF00AAFF0084FF0060FF003EFF0020FF0005FF1100FF
2200FF2E00FF3400FF3300FF2D00FF2000FF0E00FF0009FF0026FF0047FF006CFF0095FF
00BFFF00EBFF00FFE700FFBA00FF8E00FF6400FF3C00FF1808FF0024FF003BFF004CFF00
58FF005EFF005EFF0058FF004CFF003AFF0022FF0005FF0000FF1C00FF4300FF6D00FF9B
00FFCB00FFFE00CEFF0099FF0065FF0032FF0000FF2F00FF
00FF1700FF4700FF7800FFAB00FFDF00ECFF00B8FF0085FF0054FF0026FF0400FF2B00FF
4E00FF6D00FF8500FF9900FFA600FFAE00FFAF00FFAA00FF9F00FF8F00FF7900FF5D00FF
3E00FF1A00FF000CFF0036FF0061FF008EFF00BBFF00E7FF00FFED00FFC400FF9E00FF7C
00FF5E00FF4500FF3200FF2400FF1D00FF1B00FF2000FF2A00FF3A00FF5000FF6A00FF88
00FFAA00FFCD00FFF300E7FF00C2FF009EFF007DFF005FFF0046FF0032FF0023FF001AFF
0017FF001BFF0024FF0033FF0047FF005FFF007AFF0098FF00B6FF00D4FF00F0FF00FFF5
00FFDF00FFCE00FFC300FFBE00FFBF00FFC600FFD300FFE500FFF900EFFF00D8FF00C2FF
00AFFF00A1FF0098FF0096FF009AFF00A4FF00B2FF00C2FF00D2FF00DEFF00E5FF00E6FF
00E0FF00D6FF00CEFF00CEFF00D2FF00D3FF00CCFF00C3FF00BCFF00BBFF00C1FF00CCFF
00DCFF00ECFF00FAFF00FFFA00FFF500FFF600FFFD00F5FF00E3FF00CEFF00B7FF00A0FF
008AFF0078FF006AFF0062FF0060FF0064FF006EFF007DFF0092FF00ABFF00C7FF00E5FF
00FFFC00FFDE00FFC200FFA900FF9500FF8500FF7A00FF7600FF7700FF7F00FF8D00FFA0
00FFB800FFD500FFF600E6FF00C1FF009CFF0076FF0052FF0030FF0011FF0900FF1F00FF
3000FF3C00FF4200FF4100FF3B00FF2E00FF1C00FF0400FF0018FF0039FF005EFF0086FF
00B1FF00DDFF00FFF500FFC800FF9C00FF7200FF4A00FF2600FF0616FF002DFF003EFF00
4AFF0050FF0050FF004AFF003EFF002BFF0014FF0000FF0800FF2B00FF5100FF7B00FFA9
00FFDA00F3FF00BFFF008BFF0057FF0024FF0D00FF3D00FF
00FF2000FF4F00FF8000FFB400FFE800E3FF00AFFF007DFF004CFF001DFF0D00FF3400FF
5700FF7500FF8E00FFA100FFAF00FFB600FFB700FFB300FFA800FF9700FF8100FF6600FF
4600FF2300FF0003FF002DFF0059FF0085FF00B2FF00DFFF00FFF500FFCC00FFA700FF84
00FF6700FF4E00FF3A00FF2D00FF2500FF2400FF2800FF3300FF4300FF5800FF7200FF91
00FFB200FFD600FFFB00DEFF00B9FF0096FF0075FF0057FF003EFF0029FF001AFF0011FF
000FFF0012FF001BFF002AFF003EFF0056FF0072FF008FFF00ADFF00CBFF00E8FF00FFFD
00FFE800FFD700FFCC00FFC700FFC800FFCF00FFDC00FFED00FDFF00E6FF00CFFF00B9FF
00A7FF0098FF0090FF008EFF0092FF009BFF00A9FF00B9FF00C9FF00D6FF00DDFF00DDFF
00D7FF00CEFF00C6FF00C5FF00CAFF00CBFF00C4FF00BAFF00B3FF00B2FF00B8FF00C4FF
00D3FF00E3FF00F2FF00FDFF00FFFD00FFFE00FAFF00ECFF00DAFF00C5FF00AEFF0097FF
0082FF0070FF0062FF005AFF0057FF005BFF0065FF0075FF008AFF00A3FF00BFFF00DCFF
00FBFF00FFE600FFCB00FFB200FF9D00FF8D00FF8300FF7E00FF8000FF8700FF9500FFA8
00FFC100FFDE00FFFE00DEFF00B9FF0093FF006EFF004AFF0028FF0009FF1100FF2800FF
3900FF4500FF4A00FF4A00FF4400FF3700FF2500FF0D00FF000FFF0030FF0056FF007EFF
00A8FF00D5FF00FFFD00FFD100FFA500FF7B00FF5300FF2F00FF0E0DFF0024FF0036FF00
42FF0048FF0048FF0041FF0035FF0023FF000BFF0000FF1100FF3300FF5A00FF8400FFB2
00FFE200EBFF00B7FF0083FF004EFF001BFF1600FF4500FF
00FF2200FF5100FF8300FFB600FFEA00E1FF00ADFF007AFF0049FF001BFF0F00FF3600FF
5900FF7700FF9000FFA400FFB100FFB800FFBA00FFB500FFAA00FF9900FF8300FF6800FF
4900FF2500FF0001FF002BFF0056FF0083FF00B0FF00DDFF00FFF700FFCF00FFA900FF87
00FF6900FF5000FF3D00FF2F00FF2700FF2600FF2A00FF3500FF4500FF5B00FF7500FF93
00FFB400FFD800FFFD00DCFF00B7FF0093FF0072FF0055FF003BFF0027FF0018FF000FFF
000CFF0010FF0019FF0028FF003CFF0054FF006FFF008DFF00ABFF00C9FF00E6FF00FFFF
00FFEA00FFD900FFCE00FFC900FFCA00FFD100FFDE00FFEF00FBFF00E4FF00CDFF00B7FF
00A4FF0096FF008EFF008BFF008FFF0099FF00A7FF00B7FF00C7FF00D3FF00DBFF00DBFF
00D5FF00CCFF00C4FF00C3FF00C8FF00C9FF00C2FF00B8FF00B1FF00B0FF00B6FF00C2FF
00D1FF00E1FF00F0FF00FAFF00FFFF00FFFF00F7FF00EAFF00D8FF00C3FF00ACFF0095FF
007FFF006DFF0060FF0057FF0055FF0059FF0063FF0073FF0087FF00A0FF00BCFF00DAFF
00F9FF00FFE900FFCD00FFB400FF9F00FF8F00FF8500FF8000FF8200FF8A00FF9700FFAB
00FFC300FFE000FFFF00DBFF00B7FF0091FF006CFF0047FF0025FF0007FF1300FF2A00FF
3B00FF4700FF4D00FF4C00FF4600FF3900FF2700FF0F00FF000DFF002EFF0053FF007CFF
00A6FF00D2FF00FFFF00FFD300FFA700FF7D00FF5500FF3100FF100BFF0022FF0033FF00
3FFF0045FF0045FF003FFF0033FF0021FF0009FF0000FF1300FF3500FF5C00FF8600FFB4
00FFE400E8FF00B5FF0080FF004CFF0019FF1800FF4800FF
00FF1E00FF4D00FF7F00FFB200FFE600E5FF00B1FF007EFF004EFF001FFF0B00FF3200FF
5500FF7300FF8C00FF9F00FFAD00FFB400FFB500FFB100FFA600FF9500FF7F00FF6400FF
4400FF2100FF0005FF002FFF005BFF0087FF00B4FF00E1FF00FFF300FFCB00FFA500FF83
00FF6500FF4C00FF3900FF2B00FF2300FF2200FF2600FF3100FF4100FF5600FF7100FF8F
00FFB000FFD400FFF900E0FF00BBFF0097FF0076FF0059FF003FFF002BFF001CFF0013FF
0011FF0014FF001DFF002CFF0040FF0058FF0073FF0091FF00AFFF00CDFF00EAFF00FFFC
00FFE600FFD500FFCA00FFC500FFC600FFCD00FFDA00FFEB00FFFF00E8FF00D1FF00BBFF
00A8FF009AFF0092FF008FFF0094FF009DFF00ABFF00BBFF00CBFF00D8FF00DFFF00DFFF
00D9FF00D0FF00C8FF00C7FF00CCFF00CDFF00C6FF00BCFF00B5FF00B4FF00BAFF00C6FF
00D5FF00E5FF00F4FF00FEFF00FFFB00FFFC00FBFF00EEFF00DCFF00C7FF00B0FF0099FF
0084FF0071FF0064FF005BFF0059FF005DFF0067FF0077FF008CFF00A4FF00C0FF00DEFF
00FDFF00FFE500FFC900FFB000FF9B00FF8B00FF8100FF7C00FF7E00FF8600FF9300FFA7
00FFBF00FFDC00FFFC00E0FF00BBFF0095FF0070FF004BFF002AFF000BFF0F00FF2600FF
3700FF4300FF4800FF4800FF4200FF3500FF2300FF0B00FF0011FF0032FF0057FF0080FF
00AAFF00D7FF00FFFC00FFCF00FFA300FF7900FF5100FF2D00FF0C0FFF0026FF0038FF00
44FF004AFF0049FF0043FF0037FF0025FF000DFF0000FF0F00FF3100FF5800FF8200FFB0
00FFE000ECFF00B9FF0084FF0050FF001DFF1400FF4400FF
00FF1400FF4300FF7500FFA800FFDC00EFFF00BBFF0088FF0057FF0029FF0100FF2800FF
4B00FF6A00FF8200FF9600FFA300FFAA00FFAC00FFA700FF9C00FF8C00FF7600FF5A00FF
3B00FF1700FF000FFF0039FF0064FF0091FF00BEFF00EAFF00FFEA00FFC100FF9B00FF79
00FF5B00FF4200FF2F00FF2100FF1900FF1800FF1D00FF2700FF3700FF4D00FF6700FF85
00FFA600FFCA00FFEF00EAFF00C5FF00A1FF0080FF0063FF0049FF0035FF0026FF001DFF
001AFF001EFF0027FF0036FF004AFF0062FF007DFF009BFF00B9FF00D7FF00F3FF00FFF2
00FFDC00FFCB00FFC000FFBB00FFBC00FFC300FFD000FFE200FFF600F2FF00DBFF00C5FF
00B2FF00A4FF009BFF0099FF009DFF00A7FF00B5FF00C5FF00D5FF00E1FF00E8FF00E9FF
00E3FF00D9FF00D1FF00D1FF00D5FF00D6FF00CFFF00C6FF00BFFF00BEFF00C4FF00CFFF
00DFFF00EFFF00FEFF00FFF700FFF200FFF300FFFA00F8FF00E6FF00D1FF00BAFF00A3FF
008DFF007BFF006DFF0065FF0063FF0067FF0071FF0080FF0095FF00AEFF00CAFF00E8FF
00FFF900FFDB00FFBF00FFA600FF9100FF8200FF7700FF7200FF7400FF7C00FF8A00FF9D
00FFB500FFD200FFF300E9FF00C4FF009FFF0079FF0055FF0033FF0014FF0600FF1C00FF
2D00FF3900FF3F00FF3E00FF3800FF2B00FF1900FF0100FF001BFF003CFF0061FF0089FF
00B4FF00E0FF00FFF200FFC500FF9900FF6F00FF4700FF2300FF0219FF0030FF0041FF00
4DFF0053FF0053FF004DFF0041FF002FFF0017FF0000FF0500FF2700FF4E00FF7800FFA6
00FFD700F6FF00C2FF008EFF005AFF0027FF0A00FF3A00FF
00FF0600FF3600FF6700FF9A00FFCE00FDFF00C9FF0096FF0065FF0037FF000CFF1A00FF
3D00FF5C00FF7400FF8800FF9500FF9D00FF9E00FF9900FF8E00FF7E00FF6800FF4C00FF
2D00FF0900FF001DFF0047FF0072FF009FFF00CCFF00F8FF00FFDC00FFB300FF8D00FF6B
00FF4D00FF3400FF2100FF1300FF0C00FF0A00FF0F00FF1900FF2900FF3F00FF5900FF77
00FF9900FFBC00FFE200F8FF00D3FF00AFFF008EFF0070FF0057FF0043FF0034FF002BFF
0028FF002CFF0035FF0044FF0058FF0070FF008BFF00A9FF00C7FF00E5FF00FFFE00FFE4
00FFCE00FFBD00FFB200FFAD00FFAE00FFB600FFC200FFD400FFE800FFFF00E9FF00D3FF
00C0FF00B2FF00A9FF00A7FF00ABFF00B5FF00C3FF00D3FF00E3FF00EFFF00F6FF00F7FF
00F1FF00E7FF00DFFF00DFFF00E3FF00E4FF00DDFF00D4FF00CDFF00CCFF00D2FF00DDFF
00EDFF00FDFF00FFF400FFE900FFE400FFE500FFEC00FFF900F4FF00DFFF00C8FF00B1FF
009BFF0089FF007BFF0073FF0071FF0075FF007FFF008EFF00A3FF00BCFF00D8FF00F6FF
00FFEB00FFCD00FFB100FF9800FF8400FF7400FF6900FF6500FF6600FF6E00FF7C00FF8F
00FFA700FFC400FFE500F7FF00D2FF00ADFF0087FF0063FF0041FF0022FF0007FF0E00FF
1F00FF2B00FF3100FF3000FF2A00FF1D00FF0B00FF000CFF0029FF004AFF006FFF0097FF
00C2FF00EEFF00FFE400FFB700FF8B00FF6100FF3900FF150AFF0026FF003EFF004FFF00
5BFF0061FF0061FF005BFF004FFF003CFF0025FF0008FF0000FF1A00FF4000FF6A00FF98
00FFC900FFFB00D0FF009CFF0068FF0035FF0003FF2C00FF
09FF0000FF2500FF5700FF8A00FFBE00FFF200D9FF00A6FF0075FF0047FF001CFF0A00FF
2D00FF4B00FF6400FF7800FF8500FF8C00FF8E00FF8900FF7E00FF6E00FF5700FF3C00FF
1D00FF0006FF002DFF0057FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0304FF0005FF0001FF0000FF0900FF1900FF2F00FF4900FF67
00FF8800FFAC00FFD100FFF700E3FF00BFFF009EFF0081FF0067FF0053FF0044FF003BFF
0038FF003CFF0045FF0054FF0068FF0080FF009BFF00B9FF00D7FF00F5FF00FFED00FFD4
00FFBE00FFAD00FFA200FF9D00FF9E00FFA500FFB200FFC400FFD800FFEF00F9FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F3FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EFFF00F3FF00F4FF00EDFF00E4FF00DDFF00DCFF00E2FF00EEFF
00FDFF00FFF200FFE300FFD900FFD300FFD400FFDC00FFE900FFFB00EFFF00D8FF00C1FF
00ABFF0099FF008BFF0083FF0081FF0085FF008FFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7300FF6300FF5900FF5400FF5600FF5E00FF6C00FF7F
00FF9700FFB400FFD500FFF800E2FF00BDFF0097FF0073FF0051FF0032FF0017FF0001FF
0F00FF1B00FF2100FF2000FF1A00FF0D00FF0004FF001CFF0039FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2900FF051BFF0037FF004EFF005FFF00
6BFF0071FF0071FF006BFF005FFF004DFF0035FF0018FF0000FF0900FF3000FF5A00FF88
00FFB800FFEB00E0FF00ACFF0078FF0045FF0013FF1C00FF
18FF0000FF1600FF4700FF7A00FFAE00FFE300E9FF00B6FF0085FF0057FF002CFF0004FF
1E00FF3C00FF5500FF6800FF7500FF7D00FF7E00FF7900FF6E00FF5E00FF4800FF2D00FF
0D00FF0016FF003DFF0066FF0092FF00BFFF00ECFF00FFE700FFBC00FF9300FF6D00FF4B
00FF2D00FF1500FF010CFF0013FF0015FF0010FF0006FF0000FF0A00FF1F00FF3900FF57
00FF7900FF9D00FFC200FFE700F2FF00CFFF00AEFF0090FF0077FF0063FF0054FF004BFF
0048FF004BFF0055FF0064FF0077FF0090FF00ABFF00C8FF00E7FF00FFFA00FFDE00FFC4
00FFAE00FF9E00FF9200FF8D00FF8F00FF9600FFA200FFB400FFC900FFE000FFF700F3FF
00E0FF00D2FF00C9FF00C7FF00CBFF00D5FF00E3FF00F3FF00FFFD00FFF000FFE900FFE8
00FFEE00FFF800FFFF00FEFF00FFFC00FFFB00FDFF00F3FF00ECFF00ECFF00F1FF00FDFF
00FFF300FFE200FFD400FFC900FFC400FFC500FFCC00FFD900FFEB00FEFF00E7FF00D0FF
00BBFF00A9FF009BFF0093FF0090FF0094FF009EFF00AEFF00C3FF00DCFF00F8FF00FFE9
00FFCB00FFAD00FF9100FF7900FF6400FF5400FF4900FF4500FF4600FF4E00FF5C00FF6F
00FF8800FFA400FFC500FFE800F2FF00CCFF00A7FF0083FF0061FF0042FF0027FF0011FF
0000FF0B00FF1100FF1100FF0A00FF0001FF0014FF002BFF0048FF006AFF008FFF00B7FF
00E2FF00FFF100FFC400FF9700FF6B00FF4100FF1A0AFF002AFF0046FF005DFF006FFF00
7BFF0081FF0081FF007BFF006EFF005CFF0044FF0027FF0005FF0000FF2000FF4B00FF78
00FFA900FFDB00F0FF00BCFF0088FF0054FF0023FF0C00FF
25FF0000FF0900FF3B00FF6E00FFA200FFD600F5FF00C2FF0092FF0063FF0038FF0011FF
1100FF2F00FF4800FF5B00FF6900FF7000FF7100FF6D00FF6200FF5100FF3B00FF2000FF
0000FF0022FF0049FF0073FF009FFF00CBFF00F8FF00FFDA00FFAF00FF8600FF6100FF3F
00FF2100FF080BFF0018FF0020FF0021FF001DFF0012FF0002FF0000FF1200FF2D00FF4B
00FF6C00FF9000FFB500FFDB00FFFF00DBFF00BAFF009DFF0083FF006FFF0060FF0057FF
0055FF0058FF0061FF0070FF0084FF009CFF00B7FF00D5FF00F3FF00FFEE00FFD100FFB8
00FFA200FF9100FF8600FF8100FF8200FF8900FF9600FFA700FFBC00FFD300FFEA00FFFF
00ECFF00DEFF00D6FF00D3FF00D8FF00E1FF00EFFF00FFFF00FFF000FFE300FFDC00FFDC
00FFE200FFEB00FFF300FFF400FFEF00FFEE00FFF500FFFF00F9FF00F8FF00FEFF00FFF5
00FFE600FFD600FFC700FFBC00FFB700FFB800FFC000FFCD00FFDF00FFF400F4FF00DDFF
00C8FF00B5FF00A8FF009FFF009DFF00A1FF00ABFF00BBFF00D0FF00E8FF00FFFB00FFDD
00FFBE00FFA100FF8500FF6C00FF5700FF4700FF3D00FF3800FF3A00FF4200FF4F00FF63
00FF7B00FF9800FFB800FFDB00FFFF00D9FF00B4FF008FFF006EFF004FFF0034FF001DFF
000CFF0000FF0400FF0400FF0001FF000EFF0020FF0038FF0055FF0076FF009BFF00C4FF
00EEFF00FFE400FFB800FF8B00FF5F00FF3500FF0D16FF0037FF0053FF006AFF007CFF00
88FF008EFF008DFF0087FF007BFF0069FF0051FF0034FF0012FF0000FF1400FF3E00FF6C
00FF9C00FFCF00FDFF00C8FF0094FF0061FF002FFF0000FF
2CFF0000FF0200FF3300FF6600FF9B00FFCF00FCFF00CAFF0099FF006AFF003FFF0018FF
0A00FF2800FF4100FF5400FF6200FF6900FF6A00FF6500FF5B00FF4A00FF3400FF1900FF
0006FF0029FF0050FF007AFF00A6FF00D2FF00FFFF00FFD300FFA800FF7F00FF5900FF37
00FF1A00FF0112FF001FFF0027FF0029FF0024FF0019FF0009FF0000FF0B00FF2500FF44
00FF6500FF8900FFAE00FFD400FFF900E3FF00C2FF00A4FF008BFF0076FF0067FF005FFF
005CFF005FFF0068FF0077FF008BFF00A3FF00BFFF00DCFF00FAFF00FFE600FFCA00FFB0
00FF9B00FF8A00FF7F00FF7A00FF7B00FF8200FF8F00FFA000FFB500FFCC00FFE300FFF9
00F4FF00E5FF00DDFF00DBFF00DFFF00E8FF00F6FF00FFF900FFE900FFDC00FFD500FFD5
00FFDA00FFE400FFEC00FFED00FFE800FFE700FFEE00FFF800FFFF00FFFF00FFFA00FFEE
00FFDF00FFCF00FFC000FFB500FFB000FFB100FFB800FFC600FFD700FFED00FBFF00E4FF
00CFFF00BDFF00AFFF00A7FF00A4FF00A8FF00B2FF00C2FF00D7FF00F0FF00FFF300FFD5
00FFB700FF9900FF7E00FF6500FF5000FF4000FF3600FF3100FF3300FF3A00FF4800FF5B
00FF7400FF9100FFB100FFD400FFF900E0FF00BBFF0097FF0075FF0056FF003BFF0024FF
0013FF0008FF0002FF0002FF0009FF0015FF0027FF003FFF005CFF007DFF00A3FF00CBFF
00F6FF00FFDD00FFB000FF8400FF5800FF2E00FF061EFF003EFF005AFF0071FF0083FF00
8FFF0095FF0095FF008EFF0082FF0070FF0058FF003BFF0019FF0000FF0D00FF3700FF65
00FF9500FFC700FFFB00D0FF009BFF0068FF0036FF0007FF
2DFF0000FF0200FF3300FF6600FF9A00FFCE00FDFF00CAFF0099FF006BFF0040FF0019FF
0900FF2800FF4000FF5400FF6100FF6900FF6A00FF6500FF5A00FF4A00FF3400FF1800FF
0006FF002AFF0051FF007BFF00A6FF00D3FF00FFFF00FFD300FFA800FF7F00FF5900FF37
00FF1900FF0012FF0020FF0027FF0029FF0024FF001AFF000AFF0000FF0B00FF2500FF43
00FF6500FF8800FFAE00FFD300FFF800E3FF00C2FF00A4FF008BFF0077FF0068FF005FFF
005CFF0060FF0069FF0078FF008CFF00A4FF00BFFF00DDFF00FBFF00FFE600FFCA00FFB0
00FF9A00FF8900FF7E00FF7900FF7A00FF8100FF8E00FFA000FFB400FFCB00FFE200FFF8
00F4FF00E6FF00DDFF00DBFF00DFFF00E9FF00F7FF00FFF800FFE800FFDC00FFD500FFD4
00FFDA00FFE400FFEC00FFEC00FFE800FFE700FFEE00FFF700FFFE00FFFF00FFF900FFEE
00FFDE00FFCE00FFC000FFB500FFB000FFB100FFB800FFC500FFD700FFEC00FCFF00E5FF
00CFFF00BDFF00AFFF00A7FF00A5FF00A9FF00B3FF00C2FF00D7FF00F0FF00FFF300FFD5
00FFB700FF9900FF7D00FF6400FF5000FF4000FF3500FF3100FF3200FF3A00FF4800FF5B
00FF7300FF9000FFB100FFD400FFF900E1FF00BBFF0097FF0075FF0056FF003BFF0025FF
0014FF0008FF0002FF0003FF0009FF0016FF0028FF0040FF005DFF007EFF00A3FF00CBFF
00F6FF00FFDD00FFB000FF8300FF5700FF2D00FF051EFF003EFF005AFF0072FF0083FF00
8FFF0095FF0095FF008FFF0083FF0070FF0059FF003CFF0019FF0000FF0C00FF3600FF64
00FF9500FFC700FFFB00D0FF009CFF0069FF0037FF0007FF
27FF0000FF0700FF3900FF6C00FFA000FFD400F7FF00C4FF0093FF0065FF003AFF0013FF
0F00FF2D00FF4600FF5A00FF6700FF6E00FF7000FF6B00FF6000FF5000FF3900FF1E00FF
0000FF0024FF004BFF0075FF00A0FF00CDFF00FAFF00FFD900FFAE00FF8500FF5F00FF3D
00FF1F00FF060CFF001AFF0022FF0023FF001FFF0014FF0004FF0000FF1100FF2B00FF49
00FF6A00FF8E00FFB300FFD900FFFE00DDFF00BCFF009FFF0085FF0071FF0062FF0059FF
0056FF005AFF0063FF0072FF0086FF009EFF00B9FF00D7FF00F5FF00FFEC00FFCF00FFB6
00FFA000FF8F00FF8400FF7F00FF8000FF8700FF9400FFA600FFBA00FFD100FFE800FFFE
00EEFF00E0FF00D7FF00D5FF00D9FF00E3FF00F1FF00FFFE00FFEE00FFE200FFDA00FFDA
00FFE000FFE900FFF200FFF200FFEE00FFED00FFF400FFFD00FBFF00FAFF00FFFF00FFF3
00FFE400FFD400FFC500FFBB00FFB500FFB600FFBE00FFCB00FFDD00FFF200F6FF00DFFF
00C9FF00B7FF00A9FF00A1FF009FFF00A3FF00ADFF00BCFF00D1FF00EAFF00FFF900FFDB
00FFBD00FF9F00FF8300FF6A00FF5500FF4500FF3B00FF3600FF3800FF4000FF4D00FF61
00FF7900FF9600FFB700FFDA00FFFF00DBFF00B5FF0091FF006FFF0050FF0035FF001FFF
000EFF0002FF0300FF0200FF0003FF0010FF0022FF003AFF0057FF0078FF009DFF00C5FF
00F0FF00FFE300FFB600FF8900FF5D00FF3300FF0B18FF0039FF0055FF006CFF007DFF00
89FF008FFF008FFF0089FF007DFF006BFF0053FF0036FF0014FF0000FF1200FF3C00FF6A
00FF9A00FFCD00FEFF00CAFF0096FF0063FF0031FF0001FF
1DFF0000FF1100FF4200FF7500FFAA00FFDE00EDFF00BBFF008AFF005BFF0030FF0009FF
1900FF3700FF5000FF6300FF7100FF7800FF7900FF7400FF6A00FF5900FF4300FF2800FF
0800FF001AFF0042FF006BFF0097FF00C4FF00F0FF00FFE200FFB700FF8E00FF6800FF46
00FF2900FF1003FF0010FF0018FF001AFF0015FF000AFF0000FF0500FF1A00FF3400FF53
00FF7400FF9800FFBD00FFE300F7FF00D4FF00B3FF0095FF007CFF0067FF0058FF0050FF
004DFF0050FF0059FF0068FF007CFF0094FF00B0FF00CDFF00ECFF00FFF500FFD900FFBF
00FFAA00FF9900FF8E00FF8900FF8A00FF9100FF9E00FFAF00FFC400FFDB00FFF200F7FF
00E5FF00D6FF00CEFF00CCFF00D0FF00D9FF00E7FF00F7FF00FFF800FFEB00FFE400FFE4
00FFE900FFF300FFFB00FFFC00FFF700FFF600FFFD00F8FF00F1FF00F0FF00F6FF00FFFD
00FFEE00FFDE00FFCF00FFC400FFBF00FFC000FFC700FFD500FFE600FFFC00ECFF00D5FF
00C0FF00AEFF00A0FF0098FF0095FF0099FF00A3FF00B3FF00C8FF00E1FF00FDFF00FFE4
00FFC600FFA800FF8D00FF7400FF5F00FF4F00FF4500FF4000FF4200FF4900FF5700FF6A
00FF8300FFA000FFC000FFE300F7FF00D1FF00ACFF0088FF0066FF0047FF002CFF0015FF
0004FF0600FF0C00FF0C00FF0500FF0006FF0018FF0030FF004DFF006EFF0094FF00BCFF
00E7FF00FFEC00FFBF00FF9300FF6700FF3C00FF150FFF002FFF004BFF0062FF0074FF00
80FF0086FF0086FF007FFF0073FF0061FF0049FF002CFF000AFF0000FF1B00FF4600FF74
00FFA400FFD600F5FF00C1FF008CFF0059FF0027FF0700FF
15FF0000FF1900FF4A00FF7E00FFB200FFE600E5FF00B3FF0082FF0053FF0028FF0001FF
2100FF3F00FF5800FF6B00FF7900FF8000FF8100FF7C00FF7200FF6100FF4B00FF3000FF
1000FF0012FF0039FF0063FF008FFF00BBFF00E8FF00FFEA00FFBF00FF9600FF7100FF4E
00FF3100FF1800FF0408FF0010FF0012FF000DFF0002FF0000FF0D00FF2200FF3C00FF5B
00FF7C00FFA000FFC500FFEB00EFFF00CCFF00ABFF008DFF0074FF005FFF0050FF0047FF
0045FF0048FF0051FF0060FF0074FF008CFF00A8FF00C5FF00E3FF00FFFE00FFE100FFC7
00FFB200FFA100FF9600FF9100FF9200FF9900FFA600FFB700FFCC00FFE300FFFA00EFFF
00DDFF00CEFF00C6FF00C4FF00C8FF00D1FF00DFFF00EFFF00FFFF00FFF300FFEC00FFEC
00FFF200FFFB00FCFF00FBFF00FFFF00FFFE00FAFF00F0FF00E9FF00E8FF00EEFF00FAFF
00FFF600FFE600FFD700FFCC00FFC700FFC800FFCF00FFDD00FFEF00FBFF00E4FF00CDFF
00B8FF00A6FF0098FF0090FF008DFF0091FF009BFF00ABFF00C0FF00D9FF00F5FF00FFED
00FFCE00FFB000FF9500FF7C00FF6700FF5700FF4D00FF4800FF4A00FF5100FF5F00FF72
00FF8B00FFA800FFC800FFEB00EFFF00C9FF00A4FF0080FF005EFF003FFF0024FF000DFF
0300FF0F00FF1400FF1400FF0D00FF0100FF0010FF0028FF0045FF0066FF008CFF00B4FF
00DEFF00FFF400FFC700FF9B00FF6F00FF4500FF1D06FF0027FF0043FF005AFF006CFF00
78FF007EFF007EFF0077FF006BFF0059FF0041FF0024FF0002FF0000FF2400FF4E00FF7C
00FFAC00FFDE00EDFF00B9FF0084FF0051FF001FFF0F00FF
14FF0000FF1A00FF4B00FF7E00FFB200FFE700E5FF00B2FF0081FF0053FF0028FF0000FF
2200FF4000FF5900FF6C00FF7900FF8100FF8200FF7D00FF7200FF6200FF4C00FF3100FF
1100FF0012FF0039FF0062FF008EFF00BBFF00E8FF00FFEB00FFC000FF9700FF7100FF4F
00FF3100FF1800FF0508FF000FFF0011FF000CFF0002FF0000FF0E00FF2300FF3D00FF5B
00FF7D00FFA100FFC600FFEB00EEFF00CBFF00AAFF008CFF0073FF005FFF0050FF0047FF
0044FF0047FF0051FF0060FF0074FF008CFF00A7FF00C4FF00E3FF00FFFE00FFE200FFC8
00FFB200FFA200FF9600FF9100FF9300FF9A00FFA600FFB800FFCD00FFE300FFFB00EFFF
00DCFF00CEFF00C5FF00C3FF00C7FF00D1FF00DFFF00EFFF00FEFF00FFF400FFED00FFEC
00FFF200FFFC00FBFF00FAFF00FFFF00FFFF00F9FF00EFFF00E8FF00E8FF00EEFF00F9FF
00FFF700FFE600FFD800FFCD00FFC800FFC900FFD000FFDD00FFEF00FAFF00E3FF00CCFF
00B7FF00A5FF0097FF008FFF008CFF0090FF009AFF00AAFF00BFFF00D8FF00F4FF00FFED
00FFCF00FFB100FF9500FF7D00FF6800FF5800FF4D00FF4900FF4A00FF5200FF6000FF73
00FF8C00FFA800FFC900FFEC00EEFF00C8FF00A3FF007FFF005DFF003EFF0023FF000DFF
0400FF0F00FF1500FF1500FF0E00FF0200FF0010FF0027FF0044FF0066FF008BFF00B3FF
00DEFF00FFF500FFC800FF9B00FF6F00FF4500FF1E06FF0026FF0042FF0059FF006BFF00
77FF007DFF007DFF0077FF006AFF0058FF0040FF0023FF0001FF0000FF2400FF4F00FF7C
00FFAD00FFDF00ECFF00B8FF0084FF0050FF001FFF1000FF
19FF0000FF1500FF4700FF7A00FFAE00FFE200E9FF00B6FF0086FF0057FF002CFF0005FF
1D00FF3B00FF5400FF6700FF7500FF7C00FF7D00FF7900FF6E00FF5D00FF4700FF2C00FF
0C00FF0016FF003DFF0067FF0093FF00BFFF00ECFF00FFE600FFBB00FF9200FF6D00FF4A
00FF2D00FF1400FF000CFF0014FF0015FF0011FF0006FF0000FF0900FF1E00FF3900FF57
00FF7800FF9C00FFC100FFE700F3FF00D0FF00AFFF0091FF0078FF0063FF0054FF004BFF
0049FF004CFF0055FF0064FF0078FF0090FF00ACFF00C9FF00E7FF00FFFA00FFDD00FFC3
00FFAE00FF9D00FF9200FF8D00FF8E00FF9500FFA200FFB300FFC800FFDF00FFF600F3FF
00E0FF00D2FF00CAFF00C8FF00CCFF00D5FF00E3FF00F3FF00FFFC00FFEF00FFE800FFE8
00FFEE00FFF700FFFF00FFFF00FFFB00FFFA00FEFF00F4FF00EDFF00ECFF00F2FF00FEFF
00FFF200FFE200FFD300FFC800FFC300FFC400FFCB00FFD900FFEB00FFFF00E8FF00D1FF
00BCFF00AAFF009CFF0093FF0091FF0095FF009FFF00AFFF00C4FF00DDFF00F9FF00FFE9
00FFCA00FFAC00FF9100FF7800FF6300FF5300FF4900FF4400FF4600FF4D00FF5B00FF6F
00FF8700FFA400FFC400FFE700F3FF00CDFF00A8FF0084FF0062FF0043FF0028FF0011FF
0000FF0B00FF1000FF1000FF0A00FF0002FF0014FF002CFF0049FF006AFF008FFF00B8FF
00E2FF00FFF000FFC300FF9700FF6B00FF4100FF190AFF002BFF0047FF005EFF0070FF00
7CFF0082FF0082FF007BFF006FFF005DFF0045FF0028FF0006FF0000FF2000FF4A00FF78
00FFA800FFDB00F1FF00BDFF0088FF0055FF0023FF0B00FF
1AFF0000FF1400FF4500FF7900FFAD00FFE100EAFF00B8FF0087FF0058FF002DFF0006FF
1C00FF3A00FF5300FF6600FF7400FF7B00FF7C00FF7800FF6D00FF5C00FF4600FF2B00FF
0B00FF0017FF003EFF0068FF0094FF00C0FF00EDFF00FFE500FFBA00FF9100FF6C00FF49
00FF2C00FF1300FF000DFF0015FF0016FF0012FF0007FF0000FF0800FF1D00FF3700FF56
00FF7700FF9B00FFC000FFE600F4FF00D1FF00B0FF0092FF0079FF0064FF0055FF004CFF
004AFF004DFF0056FF0065FF0079FF0091FF00ADFF00CAFF00E8FF00FFF900FFDC00FFC2
00FFAD00FF9C00FF9100FF8C00FF8D00FF9400FFA100FFB200FFC700FFDE00FFF500F4FF
00E2FF00D3FF00CBFF00C9FF00CDFF00D6FF00E4FF00F4FF00FFFB00FFEE00FFE700FFE7
00FFED00FFF600FFFE00FFFF00FFFA00FFF900FFFF00F5FF00EEFF00EDFF00F3FF00FFFF
00FFF100FFE100FFD200FFC700FFC200FFC300FFCA00FFD800FFEA00FFFF00E9FF00D2FF
00BDFF00ABFF009DFF0095FF0092FF0096FF00A0FF00B0FF00C5FF00DEFF00FAFF00FFE8
00FFC900FFAB00FF9000FF7700FF6200FF5200FF4800FF4300FF4500FF4C00FF5A00FF6D
00FF8600FFA300FFC300FFE600F4FF00CEFF00A9FF0085FF0063FF0044FF0029FF0012FF
0001FF0A00FF0F00FF0F00FF0900FF0003FF0015FF002DFF004AFF006BFF0091FF00B9FF
00E3FF00FFEF00FFC200FF9600FF6A00FF4000FF180BFF002CFF0048FF005FFF0071FF00
7DFF0083FF0083FF007CFF0070FF005EFF0046FF0029FF0007FF0000FF1F00FF4900FF77
00FFA700FFD900F2FF00BEFF0089FF0056FF0024FF0A00FF
13FF0000FF1B00FF4D00FF8000FFB400FFE800E3FF00B0FF0080FF0051FF0026FF0000FF
2300FF4100FF5A00FF6D00FF7B00FF8200FF8300FF7F00FF7400FF6300FF4D00FF3200FF
1200FF0010FF0037FF0061FF008DFF00B9FF00E6FF00FFEC00FFC100FF9800FF7300FF50
00FF3300FF1A00FF0606FF000EFF000FFF000BFF0000FF0000FF0F00FF2400FF3F00FF5D
00FF7E00FFA200FFC700FFED00EDFF00CAFF00A9FF008BFF0072FF005DFF004EFF0045FF
0043FF0046FF004FFF005EFF0072FF008AFF00A6FF00C3FF00E1FF00FFFF00FFE300FFCA
00FFB400FFA300FF9800FF9300FF9400FF9B00FFA800FFB900FFCE00FFE500FFFC00EDFF
00DAFF00CCFF00C4FF00C2FF00C6FF00CFFF00DDFF00EDFF00FDFF00FFF500FFEE00FFEE
00FFF400FFFD00FAFF00F9FF00FEFF00FFFF00F8FF00EEFF00E7FF00E6FF00ECFF00F8FF
00FFF800FFE800FFD900FFCE00FFC900FFCA00FFD100FFDF00FFF100F9FF00E2FF00CBFF
00B6FF00A4FF0096FF008DFF008BFF008FFF0099FF00A9FF00BEFF00D7FF00F3FF00FFEF
00FFD000FFB200FF9700FF7E00FF6900FF5900FF4F00FF4A00FF4C00FF5300FF6100FF75
00FF8D00FFAA00FFCA00FFED00EDFF00C7FF00A2FF007EFF005CFF003DFF0022FF000BFF
0500FF1100FF1600FF1600FF1000FF0300FF000EFF0026FF0043FF0064FF0089FF00B2FF
00DCFF00FFF600FFC900FF9D00FF7100FF4700FF1F04FF0025FF0041FF0058FF006AFF00
76FF007CFF007CFF0075FF0069FF0057FF003FFF0022FF0000FF0000FF2600FF5000FF7E
00FFAE00FFE100EBFF00B6FF0082FF004FFF001DFF1100FF
09FF0000FF2500FF5600FF8900FFBD00FFF200D9FF00A7FF0076FF0048FF001DFF0A00FF
2D00FF4B00FF6400FF7700FF8400FF8C00FF8D00FF8800FF7D00FF6D00FF5700FF3C00FF
1C00FF0007FF002EFF0057FF0083FF00B0FF00DDFF00FFF600FFCB00FFA200FF7C00FF5A
00FF3C00FF2400FF1000FF0204FF0006FF0001FF0000FF0800FF1900FF2E00FF4800FF66
00FF8800FFAC00FFD100FFF600E3FF00C0FF009FFF0081FF0068FF0053FF0045FF003CFF
0039FF003CFF0046FF0055FF0068FF0081FF009CFF00B9FF00D8FF00F6FF00FFED00FFD3
00FFBE00FFAD00FFA200FF9C00FF9E00FFA500FFB200FFC300FFD800FFEF00F9FF00E3FF
00D1FF00C3FF00BAFF00B8FF00BCFF00C6FF00D4FF00E4FF00F3FF00FFFF00FFF800FFF7
00FFFD00F8FF00F0FF00EFFF00F4FF00F5FF00EEFF00E4FF00DDFF00DCFF00E2FF00EEFF
00FDFF00FFF100FFE300FFD800FFD300FFD400FFDB00FFE800FFFA00EFFF00D8FF00C1FF
00ACFF009AFF008CFF0084FF0081FF0085FF008FFF009FFF00B4FF00CDFF00E9FF00FFF8
00FFDA00FFBC00FFA000FF8800FF7300FF6300FF5800FF5400FF5500FF5D00FF6B00FF7E
00FF9700FFB400FFD400FFF700E3FF00BDFF0098FF0074FF0052FF0033FF0018FF0002FF
0F00FF1A00FF2000FF2000FF1900FF0D00FF0005FF001CFF0039FF005BFF0080FF00A8FF
00D3FF00FFFF00FFD300FFA600FF7A00FF5000FF2900FF041BFF0037FF004EFF0060FF00
6CFF0072FF0072FF006CFF005FFF004DFF0035FF0018FF0000FF0900FF2F00FF5A00FF87
00FFB800FFEA00E1FF00ADFF0079FF0045FF0013FF1B00FF
02FF0000FF2C00FF5D00FF9000FFC400FFF900D3FF00A0FF006FFF0041FF0016FF1100FF
3400FF5200FF6B00FF7E00FF8B00FF9300FF9400FF8F00FF8400FF7400FF5E00FF4300FF
2300FF0000FF0027FF0050FF007CFF00A9FF00D6FF00FFFD00FFD200FFA900FF8300FF61
00FF4300FF2A00FF1700FF0900FF0200FF0000FF0500FF0F00FF2000FF3500FF4F00FF6D
00FF8F00FFB200FFD800FFFD00DCFF00B9FF0098FF007AFF0061FF004DFF003EFF0035FF
0032FF0035FF003FFF004EFF0062FF007AFF0095FF00B2FF00D1FF00EFFF00FFF400FFDA
00FFC400FFB400FFA800FFA300FFA400FFAC00FFB800FFCA00FFDF00FFF500F2FF00DDFF
00CAFF00BCFF00B3FF00B1FF00B5FF00BFFF00CDFF00DDFF00ECFF00F9FF00FFFF00FFFE
00FBFF00F1FF00E9FF00E8FF00EDFF00EEFF00E7FF00DDFF00D6FF00D6FF00DCFF00E7FF
00F7FF00FFF800FFEA00FFDF00FFDA00FFDB00FFE200FFEF00FEFF00E8FF00D1FF00BAFF
00A5FF0093FF0085FF007DFF007AFF007EFF0088FF0098FF00ADFF00C6FF00E2FF00FFFF
00FFE100FFC300FFA700FF8E00FF7A00FF6A00FF5F00FF5B00FF5C00FF6400FF7200FF85
00FF9E00FFBA00FFDB00FFFE00DCFF00B6FF0091FF006DFF004BFF002CFF0011FF0400FF
1600FF2100FF2700FF2700FF2000FF1400FF0100FF0016FF0032FF0054FF0079FF00A1FF
00CCFF00F8FF00FFDA00FFAD00FF8100FF5700FF3000FF0B14FF0030FF0047FF0059FF00
65FF006BFF006BFF0065FF0058FF0046FF002EFF0011FF0000FF1000FF3600FF6100FF8E
00FFBF00FFF100DAFF00A6FF0072FF003EFF000DFF2200FF
02FF0000FF2D00FF5E00FF9100FFC500FFF900D2FF009FFF006EFF0040FF0015FF1200FF
3500FF5300FF6C00FF7F00FF8C00FF9400FF9500FF9000FF8500FF7500FF5F00FF4400FF
2400FF0000FF0026FF0050FF007BFF00A8FF00D5FF00FFFE00FFD300FFAA00FF8400FF62
00FF4400FF2B00FF1800FF0A00FF0300FF0100FF0600FF1000FF2000FF3600FF5000FF6E
00FF9000FFB300FFD900FFFE00DCFF00B8FF0097FF0079FF0060FF004CFF003DFF0034FF
0031FF0034FF003EFF004DFF0061FF0079FF0094FF00B1FF00D0FF00EEFF00FFF500FFDB
00FFC500FFB400FFA900FFA400FFA500FFAD00FFB900FFCB00FFE000FFF600F2FF00DCFF
00C9FF00BBFF00B2FF00B0FF00B4FF00BEFF00CCFF00DCFF00ECFF00F8FF00FFFF00FFFF
00FAFF00F0FF00E8FF00E8FF00ECFF00EDFF00E6FF00DCFF00D6FF00D5FF00DBFF00E6FF
00F6FF00FFF900FFEB00FFE000FFDB00FFDC00FFE300FFF000FDFF00E8FF00D1FF00BAFF
00A4FF0092FF0084FF007CFF007AFF007EFF0088FF0097FF00ACFF00C5FF00E1FF00FFFF
00FFE200FFC400FFA800FF8F00FF7B00FF6B00FF6000FF5C00FF5D00FF6500FF7300FF86
00FF9E00FFBB00FFDC00FFFF00DBFF00B6FF0090FF006CFF004AFF002BFF0010FF0500FF
1600FF2200FF2800FF2800FF2100FF1500FF0200FF0015FF0031FF0053FF0078FF00A0FF
00CBFF00F7FF00FFDB00FFAE00FF8200FF5800FF3100FF0C13FF002FFF0046FF0058FF00
64FF006AFF006AFF0064FF0058FF0045FF002EFF0010FF0000FF1100FF3700FF6200FF8F
00FFC000FFF200D9FF00A5FF0071FF003EFF000CFF2300FF
07FF0000FF2700FF5800FF8B00FFBF00FFF400D8FF00A5FF0074FF0046FF001BFF0C00FF
2F00FF4D00FF6600FF7900FF8600FF8E00FF8F00FF8A00FF7F00FF6F00FF5900FF3E00FF
1E00FF0005FF002CFF0056FF0081FF00AEFF00DBFF00FFF800FFCD00FFA400FF7E00FF5C
00FF3E00FF2500FF1200FF0402FF0004FF0000FF0000FF0A00FF1A00FF3000FF4A00FF68
00FF8A00FFAD00FFD300FFF800E2FF00BEFF009DFF007FFF0066FF0052FF0043FF003AFF
0037FF003AFF0044FF0053FF0067FF007FFF009AFF00B7FF00D6FF00F4FF00FFEF00FFD5
00FFBF00FFAF00FFA300FF9E00FF9F00FFA700FFB300FFC500FFDA00FFF000F7FF00E2FF
00CFFF00C1FF00B8FF00B6FF00BAFF00C4FF00D2FF00E2FF00F1FF00FEFF00FFFA00FFF9
00FFFF00F6FF00EEFF00EEFF00F2FF00F3FF00ECFF00E2FF00DCFF00DBFF00E1FF00ECFF
00FCFF00FFF300FFE500FFDA00FFD500FFD600FFDD00FFEA00FFFC00EEFF00D6FF00BFFF
00AAFF0098FF008AFF0082FF0080FF0083FF008DFF009DFF00B2FF00CBFF00E7FF00FFFA
00FFDC00FFBE00FFA200FF8900FF7500FF6500FF5A00FF5600FF5700FF5F00FF6D00FF80
00FF9900FFB500FFD600FFF900E1FF00BCFF0096FF0072FF0050FF0031FF0016FF0000FF
1000FF1C00FF2200FF2200FF1B00FF0F00FF0003FF001BFF0037FF0059FF007EFF00A6FF
00D1FF00FDFF00FFD500FFA800FF7C00FF5200FF2B00FF0619FF0035FF004CFF005EFF00
6AFF0070FF0070FF006AFF005EFF004BFF0034FF0016FF0000FF0B00FF3100FF5C00FF89
00FFBA00FFEC00DFFF00ABFF0077FF0043FF0012FF1D00FF
13FF0000FF1B00FF4C00FF7F00FFB400FFE800E3FF00B1FF0080FF0052FF0026FF0000FF
2300FF4100FF5A00FF6D00FF7B00FF8200FF8300FF7E00FF7400FF6300FF4D00FF3200FF
1200FF0010FF0038FF0061FF008DFF00BAFF00E6FF00FFEC00FFC100FF9800FF7200FF50
00FF3300FF1A00FF0606FF000EFF0010FF000BFF0000FF0000FF0F00FF2400FF3E00FF5D
00FF7E00FFA200FFC700FFED00EDFF00CAFF00A9FF008BFF0072FF005DFF004EFF0046FF
0043FF0046FF004FFF005EFF0072FF008AFF00A6FF00C3FF00E2FF00FFFF00FFE300FFC9
00FFB400FFA300FF9800FF9300FF9400FF9B00FFA800FFB900FFCE00FFE500FFFC00EDFF
00DBFF00CCFF00C4FF00C2FF00C6FF00CFFF00DDFF00EEFF00FDFF00FFF500FFEE00FFEE
00FFF300FFFD00FAFF00F9FF00FEFF00FFFF00F8FF00EEFF00E7FF00E6FF00ECFF00F8FF
00FFF800FFE700FFD900FFCE00FFC900FFCA00FFD100FFDF00FFF000F9FF00E2FF00CBFF
00B6FF00A4FF0096FF008EFF008BFF008FFF0099FF00A9FF00BEFF00D7FF00F3FF00FFEE
00FFD000FFB200FF9700FF7E00FF6900FF5900FF4F00FF4A00FF4C00FF5300FF6100FF74
00FF8D00FFAA00FFCA00FFED00EDFF00C7FF00A2FF007EFF005CFF003DFF0022FF000CFF
0500FF1000FF1600FF1600FF0F00FF0300FF000EFF0026FF0043FF0064FF008AFF00B2FF
00DDFF00FFF600FFC900FF9C00FF7100FF4600FF1F05FF0025FF0041FF0058FF006AFF00
76FF007CFF007CFF0075FF0069FF0057FF003FFF0022FF0000FF0000FF2500FF5000FF7E
00FFAE00FFE000EBFF00B7FF0082FF004FFF001DFF1100FF
22FF0000FF0C00FF3D00FF7000FFA400FFD900F3FF00C0FF008FFF0061FF0036FF000EFF
1400FF3200FF4B00FF5E00FF6B00FF7300FF7400FF6F00FF6400FF5400FF3E00FF2300FF
0300FF0020FF0047FF0071FF009CFF00C9FF00F6FF00FFDD00FFB200FF8900FF6300FF41
00FF2300FF0A08FF0016FF001DFF001FFF001AFF0010FF0000FF0000FF1500FF2F00FF4D
00FF6F00FF9200FFB800FFDD00FDFF00D9FF00B8FF009AFF0081FF006DFF005EFF0055FF
0052FF0055FF005FFF006EFF0082FF009AFF00B5FF00D2FF00F1FF00FFF000FFD400FFBA
00FFA400FF9400FF8800FF8300FF8400FF8C00FF9800FFAA00FFBF00FFD500FFED00FDFF
00EAFF00DCFF00D3FF00D1FF00D5FF00DFFF00EDFF00FDFF00FFF300FFE600FFDF00FFDE
00FFE400FFEE00FFF600FFF700FFF200FFF100FFF800FDFF00F7FF00F6FF00FCFF00FFF8
00FFE800FFD800FFCA00FFBF00FFBA00FFBB00FFC200FFCF00FFE100FFF600F1FF00DAFF
00C5FF00B3FF00A5FF009DFF009BFF009EFF00A8FF00B8FF00CDFF00E6FF00FFFD00FFDF
00FFC100FFA300FF8700FF6E00FF5A00FF4A00FF3F00FF3B00FF3C00FF4400FF5200FF65
00FF7E00FF9A00FFBB00FFDE00FCFF00D7FF00B1FF008DFF006BFF004CFF0031FF001BFF
000AFF0100FF0700FF0700FF0000FF000BFF001EFF0036FF0052FF0074FF0099FF00C1FF
00ECFF00FFE700FFBA00FF8D00FF6100FF3700FF1014FF0034FF0050FF0067FF0079FF00
85FF008BFF008BFF0085FF0078FF0066FF004FFF0031FF000FFF0000FF1600FF4100FF6E
00FF9F00FFD100FAFF00C6FF0092FF005EFF002DFF0200FF
33FF0004FF0000FF2D00FF6000FF9400FFC800FFFC00D0FF009FFF0071FF0046FF001FFF
0300FF2200FF3A00FF4E00FF5B00FF6200FF6400FF5F00FF5400FF4400FF2D00FF1200FF
000CFF0030FF0057FF0081FF00ACFF00D9FF00FFF900FFCD00FFA200FF7900FF5300FF31
00FF1305FF0018FF0026FF002EFF002FFF002BFF0020FF0010FF0000FF0500FF1F00FF3D
00FF5E00FF8200FFA700FFCD00FFF200E9FF00C8FF00ABFF0091FF007DFF006EFF0065FF
0062FF0066FF006FFF007EFF0092FF00AAFF00C5FF00E3FF00FFFE00FFE000FFC300FFAA
00FF9400FF8300FF7800FF7300FF7400FF7B00FF8800FF9A00FFAE00FFC500FFDC00FFF2
00FAFF00ECFF00E3FF00E1FF00E5FF00EFFF00FDFF00FFF200FFE200FFD600FFCF00FFCE
00FFD400FFDE00FFE600FFE600FFE200FFE100FFE800FFF100FFF800FFF900FFF300FFE7
00FFD800FFC800FFB900FFAF00FFAA00FFAA00FFB200FFBF00FFD100FFE600FFFD00EBFF
00D5FF00C3FF00B5FF00ADFF00ABFF00AFFF00B9FF00C8FF00DDFF00F6FF00FFED00FFCF
00FFB100FF9300FF7700FF5E00FF4900FF3900FF2F00FF2A00FF2C00FF3400FF4200FF55
00FF6D00FF8A00FFAB00FFCE00FFF300E7FF00C1FF009DFF007BFF005CFF0041FF002BFF
001AFF000EFF0008FF0009FF000FFF001CFF002EFF0046FF0063FF0084FF00A9FF00D1FF
00FCFF00FFD700FFAA00FF7D00FF5100FF2700FF0024FF0045FF0061FF0078FF0089FF00
95FF009BFF009BFF0095FF0089FF0077FF005FFF0042FF0020FF0000FF0600FF3000FF5E
00FF8E00FFC100FFF500D6FF00A2FF006FFF003DFF000DFF
41FF0012FF0000FF1E00FF5100FF8500FFBA00FFEE00DFFF00AEFF0080FF0054FF002DFF
000AFF1300FF2C00FF3F00FF4D00FF5400FF5500FF5000FF4600FF3500FF1F00FF0400FF
001BFF003FFF0066FF008FFF00BBFF00E8FF00FFEA00FFBE00FF9300FF6A00FF4400FF22
00FF0513FF0027FF0034FF003CFF003EFF0039FF002FFF001EFF0009FF0000FF1000FF2E
00FF5000FF7400FF9900FFBF00FFE400F8FF00D7FF00B9FF00A0FF008BFF007DFF0074FF
0071FF0074FF007EFF008CFF00A0FF00B8FF00D4FF00F1FF00FFEF00FFD100FFB500FF9B
00FF8600FF7500FF6A00FF6500FF6600FF6D00FF7A00FF8B00FFA000FFB700FFCE00FFE4
00FFF600FAFF00F2FF00F0FF00F4FF00FEFF00FFF400FFE300FFD400FFC700FFC000FFC0
00FFC500FFCF00FFD700FFD800FFD300FFD200FFD900FFE300FFEA00FFEB00FFE500FFD9
00FFCA00FFB900FFAB00FFA000FF9B00FF9C00FFA300FFB000FFC200FFD800FFEF00F9FF
00E4FF00D2FF00C4FF00BCFF00B9FF00BDFF00C7FF00D7FF00ECFF00FFFA00FFDE00FFC0
00FFA200FF8400FF6800FF5000FF3B00FF2B00FF2000FF1C00FF1E00FF2500FF3300FF46
00FF5F00FF7C00FF9C00FFBF00FFE400F5FF00D0FF00ACFF008AFF006BFF0050FF003AFF
0028FF001DFF0017FF0017FF001EFF002AFF003CFF0054FF0071FF0093FF00B8FF00E0FF
00FFF400FFC800FF9B00FF6E00FF4300FF180EFF0033FF0053FF006FFF0086FF0098FF00
A4FF00AAFF00AAFF00A4FF0097FF0085FF006DFF0050FF002EFF0008FF0000FF2200FF50
00FF8000FFB200FFE600E5FF00B1FF007DFF004BFF001CFF
4CFF001DFF0000FF1400FF4700FF7B00FFAF00FFE300E9FF00B9FF008AFF005FFF0038FF
0015FF0800FF2100FF3400FF4200FF4900FF4B00FF4600FF3B00FF2A00FF1400FF0006FF
0026FF0049FF0070FF009AFF00C6FF00F2FF00FFE000FFB300FF8800FF6000FF3A00FF18
05FF001EFF0031FF003FFF0047FF0048FF0044FF0039FF0029FF0014FF0000FF0600FF24
00FF4500FF6900FF8E00FFB400FFD900FFFD00E1FF00C4FF00AAFF0096FF0087FF007EFF
007BFF007FFF0088FF0097FF00ABFF00C3FF00DEFF00FCFF00FFE500FFC700FFAA00FF91
00FF7B00FF6A00FF5F00FF5A00FF5B00FF6200FF6F00FF8000FF9500FFAC00FFC300FFD9
00FFEC00FFFA00FDFF00FAFF00FEFF00FFF700FFE900FFD900FFC900FFBC00FFB500FFB5
00FFBB00FFC400FFCC00FFCD00FFC800FFC700FFCE00FFD800FFDF00FFE000FFDA00FFCE
00FFBF00FFAF00FFA000FF9600FF9000FF9100FF9900FFA600FFB800FFCD00FFE400FFFB
00EFFF00DCFF00CFFF00C6FF00C4FF00C8FF00D2FF00E2FF00F6FF00FFF000FFD400FFB6
00FF9700FF7A00FF5E00FF4500FF3000FF2000FF1600FF1100FF1300FF1B00FF2800FF3C
00FF5400FF7100FF9100FFB500FFD900FFFF00DBFF00B6FF0094FF0076FF005BFF0044FF
0033FF0027FF0022FF0022FF0028FF0035FF0047FF005FFF007CFF009DFF00C2FF00EBFF
00FFEA00FFBE00FF9100FF6400FF3800FF0E19FF003DFF005EFF007AFF0091FF00A3FF00
AEFF00B4FF00B4FF00AEFF00A2FF0090FF0078FF005BFF0039FF0012FF0000FF1700FF45
00FF7500FFA800FFDB00EFFF00BBFF0088FF0056FF0026FF
51FF0022FF0000FF0E00FF4100FF7600FFAA00FFDE00EFFF00BEFF008FFF0064FF003DFF
001AFF0300FF1C00FF2F00FF3D00FF4400FF4500FF4000FF3600FF2500FF0F00FF000BFF
002BFF004EFF0076FF009FFF00CBFF00F8FF00FFDB00FFAE00FF8300FF5A00FF3400FF12
0AFF0023FF0037FF0044FF004CFF004EFF0049FF003EFF002EFF0019FF0000FF0000FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF700E7FF00C9FF00B0FF009BFF008CFF0084FF
0081FF0084FF008DFF009CFF00B0FF00C8FF00E4FF00FFFE00FFDF00FFC100FFA500FF8B
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE600FFF500FFFD00FFFF00FFFB00FFF200FFE400FFD300FFC400FFB700FFB000FFB0
00FFB500FFBF00FFC700FFC800FFC300FFC200FFC900FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9000FF8B00FF8C00FF9300FFA100FFB200FFC800FFDF00FFF6
00F4FF00E2FF00D4FF00CCFF00C9FF00CDFF00D7FF00E7FF00FCFF00FFEA00FFCE00FFB0
00FF9200FF7400FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1500FF2300FF36
00FF4F00FF6C00FF8C00FFAF00FFD400FFFA00E0FF00BCFF009AFF007BFF0060FF0049FF
0038FF002DFF0027FF0027FF002EFF003AFF004CFF0064FF0081FF00A2FF00C8FF00F0FF
00FFE400FFB800FF8B00FF5F00FF3300FF081EFF0043FF0063FF007FFF0096FF00A8FF00
B4FF00BAFF00BAFF00B3FF00A7FF0095FF007DFF0060FF003EFF0018FF0000FF1200FF40
00FF7000FFA200FFD600F5FF00C0FF008DFF005BFF002CFF
50FF0021FF0000FF0F00FF4200FF7600FFAB00FFDF00EEFF00BDFF008FFF0063FF003CFF
0019FF0400FF1D00FF3000FF3E00FF4500FF4600FF4100FF3700FF2600FF1000FF000AFF
002AFF004DFF0075FF009EFF00CAFF00F7FF00FFDB00FFAF00FF8400FF5B00FF3500FF13
09FF0022FF0036FF0043FF004BFF004DFF0048FF003DFF002DFF0018FF0000FF0100FF20
00FF4100FF6500FF8A00FFB000FFD500FFF800E6FF00C8FF00AFFF009AFF008BFF0083FF
0080FF0083FF008CFF009BFF00AFFF00C7FF00E3FF00FFFF00FFE000FFC200FFA600FF8C
00FF7700FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7C00FF9100FFA800FFBF00FFD5
00FFE700FFF600FFFE00FFFF00FFFC00FFF300FFE500FFD400FFC500FFB800FFB100FFB1
00FFB600FFC000FFC800FFC900FFC400FFC300FFCA00FFD400FFDB00FFDC00FFD600FFCA
00FFBB00FFAA00FF9C00FF9100FF8C00FF8D00FF9400FFA200FFB300FFC900FFE000FFF7
00F3FF00E1FF00D3FF00CBFF00C8FF00CCFF00D6FF00E6FF00FBFF00FFEB00FFCF00FFB1
00FF9300FF7500FF5A00FF4100FF2C00FF1C00FF1200FF0D00FF0F00FF1600FF2400FF37
00FF5000FF6D00FF8D00FFB000FFD500FFFB00DFFF00BBFF0099FF007AFF005FFF0049FF
0037FF002CFF0026FF0026FF002DFF0039FF004BFF0063FF0080FF00A1FF00C7FF00EFFF
00FFE500FFB900FF8C00FF5F00FF3400FF091DFF0042FF0062FF007EFF0095FF00A7FF00
B3FF00B9FF00B9FF00B2FF00A6FF0094FF007CFF005FFF003DFF0017FF0000FF1300FF41
00FF7100FFA300FFD700F4FF00BFFF008CFF005AFF002BFF
49FF001AFF0000FF1700FF4A00FF7E00FFB200FFE600E6FF00B5FF0087FF005CFF0035FF
0012FF0B00FF2400FF3800FF4500FF4C00FF4E00FF4900FF3E00FF2D00FF1700FF0003FF
0022FF0046FF006DFF0097FF00C2FF00EFFF00FFE300FFB600FF8B00FF6300FF3D00FF1B
02FF001BFF002EFF003CFF0044FF0045FF0041FF0036FF0026FF0010FF0000FF0900FF27
00FF4800FF6C00FF9100FFB700FFDC00FFFF00DEFF00C1FF00A7FF0093FF0084FF007BFF
0078FF007CFF0085FF0094FF00A8FF00C0FF00DBFF00F9FF00FFE800FFCA00FFAD00FF94
00FF7E00FF6D00FF6200FF5D00FF5E00FF6500FF7200FF8300FF9800FFAF00FFC600FFDC
00FFEF00FFFD00FAFF00F7FF00FBFF00FFFA00FFEC00FFDC00FFCC00FFC000FFB800FFB8
00FFBE00FFC700FFCF00FFD000FFCB00FFCA00FFD100FFDB00FFE200FFE300FFDD00FFD1
00FFC200FFB200FFA300FF9900FF9300FF9400FF9C00FFA900FFBB00FFD000FFE700FFFE
00ECFF00D9FF00CCFF00C3FF00C1FF00C5FF00CFFF00DFFF00F3FF00FFF300FFD700FFB9
00FF9A00FF7D00FF6100FF4800FF3300FF2300FF1900FF1400FF1600FF1E00FF2B00FF3F
00FF5700FF7400FF9400FFB800FFDC00FDFF00D8FF00B3FF0091FF0073FF0058FF0041FF
0030FF0024FF001EFF001FFF0025FF0032FF0044FF005CFF0079FF009AFF00BFFF00E8FF
00FFED00FFC100FF9400FF6700FF3B00FF1116FF003AFF005BFF0077FF008EFF009FFF00
ABFF00B1FF00B1FF00ABFF009FFF008DFF0075FF0058FF0036FF000FFF0000FF1A00FF48
00FF7800FFAB00FFDE00ECFF00B8FF0085FF0053FF0023FF
3CFF000DFF0000FF2400FF5700FF8B00FFBF00FFF300D9FF00A8FF007AFF004FFF0028FF
0005FF1900FF3100FF4500FF5200FF5900FF5B00FF5600FF4B00FF3B00FF2500FF0900FF
0015FF0039FF0060FF008AFF00B5FF00E2FF00FFF000FFC400FF9900FF7000FF4A00FF28
00FF0A0EFF0021FF002FFF0037FF0038FF0033FF0029FF0019FF0003FF0000FF1600FF34
00FF5500FF7900FF9E00FFC400FFE900F2FF00D1FF00B4FF009AFF0086FF0077FF006EFF
006BFF006FFF0078FF0087FF009BFF00B3FF00CEFF00ECFF00FFF500FFD700FFBB00FFA1
00FF8B00FF7A00FF6F00FF6A00FF6B00FF7200FF7F00FF9100FFA500FFBC00FFD300FFE9
00FFFC00F5FF00ECFF00EAFF00EEFF00F8FF00FFF900FFE900FFD900FFCD00FFC600FFC5
00FFCB00FFD500FFDD00FFDD00FFD900FFD800FFDF00FFE800FFEF00FFF000FFEA00FFDF
00FFCF00FFBF00FFB000FFA600FFA100FFA200FFA900FFB600FFC800FFDD00FFF400F4FF
00DEFF00CCFF00BEFF00B6FF00B4FF00B8FF00C2FF00D1FF00E6FF00FFFF00FFE400FFC6
00FFA800FF8A00FF6E00FF5500FF4000FF3100FF2600FF2100FF2300FF2B00FF3900FF4C
00FF6400FF8100FFA200FFC500FFEA00F0FF00CAFF00A6FF0084FF0065FF004AFF0034FF
0023FF0017FF0011FF0012FF0018FF0025FF0037FF004FFF006CFF008DFF00B2FF00DAFF
00FFFA00FFCE00FFA100FF7400FF4800FF1E09FF002DFF004EFF006AFF0081FF0092FF00
9EFF00A4FF00A4FF009EFF0092FF0080FF0068FF004BFF0029FF0002FF0000FF2700FF55
00FF8600FFB800FFEC00DFFF00ABFF0078FF0046FF0016FF
2AFF0000FF0400FF3600FF6900FF9D00FFD100FAFF00C7FF0096FF0068FF003DFF0016FF
0C00FF2A00FF4300FF5700FF6400FF6B00FF6D00FF6800FF5D00FF4D00FF3600FF1B00FF
0003FF0027FF004EFF0078FF00A3FF00D0FF00FDFF00FFD600FFAB00FF8200FF5C00FF3A
00FF1C00FF030FFF001DFF0025FF0026FF0022FF0017FF0007FF0000FF0E00FF2800FF46
00FF6700FF8B00FFB000FFD600FFFB00E0FF00BFFF00A2FF0088FF0074FF0065FF005CFF
0059FF005DFF0066FF0075FF0089FF00A1FF00BCFF00DAFF00F8FF00FFE900FFCC00FFB3
00FF9D00FF8C00FF8100FF7C00FF7D00FF8400FF9100FFA300FFB700FFCE00FFE500FFFB
00F1FF00E3FF00DAFF00D8FF00DCFF00E6FF00F4FF00FFFB00FFEB00FFDF00FFD700FFD7
00FFDD00FFE600FFEF00FFEF00FFEB00FFEA00FFF100FFFA00FEFF00FDFF00FFFC00FFF0
00FFE100FFD100FFC200FFB800FFB200FFB300FFBB00FFC800FFDA00FFEF00F9FF00E2FF
00CCFF00BAFF00ACFF00A4FF00A2FF00A6FF00B0FF00BFFF00D4FF00EDFF00FFF600FFD8
00FFBA00FF9C00FF8000FF6700FF5200FF4200FF3800FF3300FF3500FF3D00FF4A00FF5E
00FF7600FF9300FFB400FFD700FFFC00DEFF00B8FF0094FF0072FF0053FF0038FF0022FF
0011FF0005FF0000FF0000FF0006FF0013FF0025FF003DFF005AFF007BFF00A0FF00C8FF
00F3FF00FFE000FFB300FF8600FF5A00FF3000FF081BFF003CFF0058FF006FFF0080FF00
8CFF0092FF0092FF008CFF0080FF006EFF0056FF0039FF0017FF0000FF0F00FF3900FF67
00FF9700FFCA00FFFE00CDFF0099FF0066FF0034FF0004FF
14FF0000FF1A00FF4B00FF7E00FFB200FFE700E5FF00B2FF0081FF0053FF0028FF0000FF
2200FF4000FF5900FF6C00FF7900FF8100FF8200FF7D00FF7200FF6200FF4C00FF3100FF
1100FF0012FF0039FF0062FF008EFF00BBFF00E8FF00FFEB00FFC000FF9700FF7100FF4F
00FF3100FF1800FF0508FF000FFF0011FF000CFF0002FF0000FF0E00FF2300FF3D00FF5B
00FF7D00FFA100FFC600FFEB00EEFF00CBFF00AAFF008CFF0073FF005FFF0050FF0047FF
0044FF0047FF0051FF0060FF0074FF008CFF00A7FF00C4FF00E3FF00FFFE00FFE200FFC8
00FFB200FFA200FF9600FF9100FF9200FF9A00FFA600FFB800FFCD00FFE300FFFB00EFFF
00DCFF00CEFF00C5FF00C3FF00C7FF00D1FF00DFFF00EFFF00FEFF00FFF400FFED00FFEC
00FFF200FFFC00FBFF00FAFF00FFFF00FFFF00F9FF00EFFF00E8FF00E8FF00EEFF00F9FF
00FFF600FFE600FFD800FFCD00FFC800FFC900FFD000FFDD00FFEF00FAFF00E3FF00CCFF
00B7FF00A5FF0097FF008FFF008CFF0090FF009AFF00AAFF00BFFF00D8FF00F4FF00FFED
00FFCF00FFB100FF9500FF7D00FF6800FF5800FF4D00FF4900FF4A00FF5200FF6000FF73
00FF8C00FFA800FFC900FFEC00EEFF00C8FF00A3FF007FFF005DFF003EFF0023FF000DFF
0400FF0F00FF1500FF1500FF0E00FF0200FF0010FF0027FF0044FF0066FF008BFF00B3FF
00DEFF00FFF500FFC800FF9B00FF6F00FF4500FF1E06FF0026FF0042FF0059FF006BFF00
77FF007DFF007DFF0077FF006AFF0058FF0040FF0023FF0001FF0000FF2400FF4F00FF7C
00FFAD00FFDF00ECFF00B8FF0084FF0050FF001FFF1000FF
00FF0200FF3100FF6200FF9500FFC900FFFE00CEFF009BFF006AFF003CFF0011FF1600FF
3900FF5700FF7000FF8300FF9000FF9800FF9900FF9400FF8900FF7900FF6300FF4800FF
2800FF0400FF0022FF004BFF0077FF00A4FF00D1FF00FDFF00FFD700FFAE00FF8800FF66
00FF4800FF3000FF1C00FF0E00FF0700FF0500FF0A00FF1400FF2500FF3A00FF5400FF72
00FF9400FFB800FFDD00FDFF00D7FF00B4FF0093FF0075FF005CFF0048FF0039FF0030FF
002DFF0030FF003AFF0049FF005CFF0075FF0090FF00ADFF00CCFF00EAFF00FFF900FFDF
00FFC900FFB900FFAD00FFA800FFAA00FFB100FFBD00FFCF00FFE400FFFB00EDFF00D8FF
00C5FF00B7FF00AEFF00ACFF00B0FF00BAFF00C8FF00D8FF00E7FF00F4FF00FBFF00FCFF
00F6FF00ECFF00E4FF00E3FF00E8FF00E9FF00E2FF00D8FF00D1FF00D1FF00D6FF00E2FF
00F1FF00FFFD00FFEF00FFE400FFDF00FFE000FFE700FFF400F9FF00E3FF00CCFF00B5FF
00A0FF008EFF0080FF0078FF0075FF0079FF0083FF0093FF00A8FF00C1FF00DDFF00FBFF
00FFE600FFC800FFAC00FF9400FF7F00FF6F00FF6400FF6000FF6100FF6900FF7700FF8A
00FFA300FFBF00FFE000FCFF00D7FF00B1FF008CFF0068FF0046FF0027FF000CFF0900FF
1B00FF2600FF2C00FF2C00FF2500FF1900FF0600FF0010FF002DFF004FFF0074FF009CFF
00C7FF00F3FF00FFDF00FFB200FF8600FF5C00FF3500FF100FFF002BFF0042FF0054FF00
60FF0066FF0066FF0060FF0053FF0041FF0029FF000CFF0000FF1500FF3B00FF6600FF93
00FFC400FFF600D5FF00A1FF006DFF0039FF0008FF2700FF
00FF1900FF4800FF7900FFAC00FFE000EAFF00B6FF0084FF0053FF0025FF0500FF2D00FF
5000FF6E00FF8700FF9A00FFA700FFAF00FFB000FFAB00FFA000FF9000FF7A00FF5F00FF
3F00FF1B00FF000BFF0034FF0060FF008DFF00BAFF00E6FF00FFEE00FFC500FF9F00FF7D
00FF5F00FF4700FF3300FF2500FF1E00FF1C00FF2100FF2B00FF3C00FF5100FF6B00FF89
00FFAB00FFCF00FFF400E6FF00C0FF009DFF007CFF005EFF0045FF0031FF0022FF0019FF
0016FF0019FF0023FF0032FF0045FF005EFF0079FF0096FF00B5FF00D3FF00EFFF00FFF6
00FFE000FFD000FFC400FFBF00FFC100FFC800FFD400FFE600FFFB00EDFF00D6FF00C1FF
00AEFF00A0FF0097FF0095FF0099FF00A3FF00B1FF00C1FF00D0FF00DDFF00E4FF00E5FF
00DFFF00D5FF00CDFF00CCFF00D1FF00D2FF00CBFF00C1FF00BAFF00BAFF00BFFF00CBFF
00DAFF00EBFF00F9FF00FFFB00FFF600FFF700FFFE00F4FF00E2FF00CCFF00B5FF009EFF
0089FF0077FF0069FF0061FF005EFF0062FF006CFF007CFF0091FF00AAFF00C6FF00E4FF
00FFFD00FFDF00FFC300FFAB00FF9600FF8600FF7B00FF7700FF7800FF8000FF8E00FFA1
00FFBA00FFD600FFF700E5FF00C0FF009AFF0075FF0051FF002FFF0010FF0A00FF2000FF
3200FF3D00FF4300FF4300FF3C00FF3000FF1D00FF0600FF0016FF0038FF005DFF0085FF
00B0FF00DCFF00FFF600FFC900FF9D00FF7300FF4C00FF2700FF0714FF002BFF003DFF00
49FF004FFF004FFF0049FF003CFF002AFF0012FF0000FF0A00FF2C00FF5200FF7D00FFAA
00FFDB00F2FF00BEFF008AFF0056FF0022FF0E00FF3E00FF
00FF2E00FF5D00FF8F00FFC200FFF600D5FF00A1FF006EFF003EFF000FFF1B00FF4200FF
6500FF8300FF9C00FFAF00FFBD00FFC400FFC500FFC100FFB600FFA500FF8F00FF7400FF
5400FF3100FF0A00FF001FFF004BFF0077FF00A4FF00D1FF00FCFF00FFDA00FFB500FF92
00FF7500FF5C00FF4800FF3B00FF3300FF3200FF3600FF4100FF5100FF6600FF8100FF9F
00FFC000FFE400F6FF00D0FF00ABFF0088FF0066FF0049FF0030FF001BFF000CFF0003FF
0001FF0004FF000DFF001CFF0030FF0048FF0064FF0081FF009FFF00BDFF00DAFF00F3FF
00FFF600FFE500FFDA00FFD500FFD600FFDD00FFEA00FFFB00EFFF00D8FF00C1FF00ABFF
0098FF008AFF0082FF007FFF0084FF008DFF009BFF00ABFF00BBFF00C8FF00CFFF00CFFF
00C9FF00C0FF00B8FF00B7FF00BCFF00BDFF00B6FF00ACFF00A5FF00A4FF00AAFF00B6FF
00C5FF00D5FF00E4FF00EFFF00F4FF00F3FF00ECFF00DEFF00CCFF00B7FF00A0FF0089FF
0074FF0062FF0054FF004BFF0049FF004DFF0057FF0067FF007CFF0095FF00B1FF00CEFF
00EDFF00FFF400FFD900FFC000FFAB00FF9B00FF9100FF8C00FF8E00FF9500FFA300FFB7
00FFCF00FFEC00F3FF00D0FF00ABFF0085FF0060FF003CFF001AFF0400FF1F00FF3600FF
4700FF5300FF5800FF5800FF5200FF4500FF3300FF1B00FF0001FF0022FF0047FF0070FF
009AFF00C7FF00F4FF00FFDF00FFB300FF8900FF6100FF3D00FF1C00FF0016FF0028FF00
34FF003AFF003AFF0033FF0027FF0015FF0000FF0200FF1F00FF4100FF6800FF9200FFC0
00FFF000DCFF00A9FF0074FF0040FF000DFF2400FF5300FF
00FF4000FF6F00FFA100FFD400F7FF00C3FF008FFF005CFF002BFF0200FF2D00FF5400FF
7700FF9500FFAE00FFC100FFCF00FFD600FFD800FFD300FFC800FFB700FFA100FF8600FF
6700FF4300FF1C00FF000DFF0039FF0065FF0092FF00BFFF00EAFF00FFED00FFC700FFA5
00FF8700FF6E00FF5B00FF4D00FF4500FF4400FF4800FF5300FF6300FF7900FF9300FFB1
00FFD200FFF600E4FF00BEFF0099FF0075FF0054FF0037FF001DFF0009FF0500FF0E00FF
1100FF0D00FF0400FF000AFF001EFF0036FF0051FF006FFF008DFF00ABFF00C8FF00E1FF
00F7FF00FFF700FFEC00FFE700FFE800FFEF00FFFC00F2FF00DDFF00C6FF00AFFF0099FF
0086FF0078FF0070FF006DFF0071FF007BFF0089FF0099FF00A9FF00B5FF00BDFF00BDFF
00B7FF00AEFF00A6FF00A5FF00AAFF00ABFF00A4FF009AFF0093FF0092FF0098FF00A4FF
00B3FF00C3FF00D2FF00DCFF00E2FF00E1FF00D9FF00CCFF00BAFF00A5FF008EFF0077FF
0062FF004FFF0042FF0039FF0037FF003BFF0045FF0055FF0069FF0082FF009EFF00BCFF
00DBFF00F8FF00FFEB00FFD200FFBD00FFAD00FFA300FF9E00FFA000FFA800FFB500FFC9
00FFE100FFFE00E1FF00BDFF0099FF0073FF004EFF0029FF0007FF1600FF3100FF4800FF
5900FF6500FF6B00FF6A00FF6400FF5700FF4500FF2D00FF1000FF0010FF0035FF005EFF
0088FF00B4FF00E1FF00FFF100FFC500FF9B00FF7300FF4F00FF2E00FF1204FF0015FF00
21FF0027FF0027FF0021FF0015FF0003FF0000FF1400FF3100FF5300FF7A00FFA400FFD2
00FDFF00CAFF0097FF0062FF002EFF0400FF3600FF6600FF
00FF4E00FF7D00FFAE00FFE100E9FF00B5FF0081FF004FFF001EFF1000FF3B00FF6200FF
8500FFA300FFBC00FFCF00FFDD00FFE400FFE500FFE000FFD600FFC500FFAF00FF9400FF
7400FF5100FF2A00FF0000FF002BFF0057FF0084FF00B1FF00DCFF00FFFA00FFD400FFB2
00FF9500FF7C00FF6800FF5B00FF5300FF5100FF5600FF6100FF7100FF8600FFA000FFBF
00FFE000FBFF00D6FF00B0FF008BFF0068FF0047FF0029FF0010FF0400FF1300FF1B00FF
1E00FF1B00FF1200FF0300FF0010FF0028FF0044FF0061FF007FFF009EFF00BAFF00D4FF
00E9FF00FAFF00FFFA00FFF500FFF600FFFD00F5FF00E4FF00CFFF00B8FF00A1FF008BFF
0079FF006AFF0062FF0060FF0064FF006DFF007BFF008BFF009BFF00A8FF00AFFF00AFFF
00A9FF00A0FF0098FF0097FF009CFF009DFF0096FF008CFF0085FF0084FF008AFF0096FF
00A5FF00B5FF00C4FF00CFFF00D4FF00D3FF00CCFF00BEFF00ACFF0097FF0080FF0069FF
0054FF0042FF0034FF002CFF0029FF002DFF0037FF0047FF005CFF0075FF0091FF00AEFF
00CDFF00EBFF00FFF900FFE000FFCB00FFBB00FFB100FFAC00FFAE00FFB500FFC300FFD6
00FFEF00F3FF00D3FF00B0FF008BFF0065FF0040FF001CFF0500FF2400FF3F00FF5600FF
6700FF7200FF7800FF7800FF7100FF6500FF5300FF3B00FF1E00FF0002FF0028FF0050FF
007BFF00A7FF00D4FF00FFFF00FFD300FFA900FF8100FF5D00FF3C00FF2000FF0908FF00
14FF001AFF001AFF0013FF0007FF0000FF0A00FF2200FF3F00FF6100FF8800FFB200FFE0
00EFFF00BDFF0089FF0055FF0020FF1200FF4400FF7300FF
00FF5600FF8500FFB700FFEA00E1FF00ADFF0079FF0046FF0015FF1800FF4300FF6A00FF
8D00FFAB00FFC400FFD800FFE500FFEC00FFEE00FFE900FFDE00FFCD00FFB700FF9C00FF
7D00FF5900FF3200FF0800FF0022FF004FFF007CFF00A9FF00D4FF00FCFF00FFDD00FFBB
00FF9D00FF8400FF7100FF6300FF5B00FF5A00FF5E00FF6900FF7900FF8F00FFA900FFC7
00FFE800F3FF00CEFF00A8FF0083FF005FFF003EFF0021FF0007FF0C00FF1B00FF2400FF
2700FF2300FF1A00FF0B00FF0008FF0020FF003BFF0059FF0077FF0095FF00B2FF00CBFF
00E1FF00F2FF00FDFF00FFFD00FFFE00FAFF00EDFF00DCFF00C7FF00B0FF0099FF0083FF
0070FF0062FF005AFF0057FF005BFF0065FF0073FF0083FF0093FF009FFF00A7FF00A7FF
00A1FF0098FF0090FF008FFF0093FF0095FF008DFF0084FF007DFF007CFF0082FF008EFF
009DFF00ADFF00BCFF00C6FF00CCFF00CBFF00C3FF00B6FF00A4FF008FFF0078FF0061FF
004BFF0039FF002CFF0023FF0021FF0025FF002FFF003FFF0053FF006CFF0088FF00A6FF
00C5FF00E2FF00FEFF00FFE800FFD300FFC300FFB900FFB400FFB600FFBE00FFCB00FFDF
00FFF700EBFF00CBFF00A7FF0082FF005DFF0037FF0013FF0E00FF2C00FF4700FF5E00FF
6F00FF7B00FF8100FF8000FF7A00FF6D00FF5B00FF4300FF2600FF0500FF001FFF0048FF
0072FF009EFF00CBFF00F8FF00FFDB00FFB100FF8900FF6500FF4400FF2800FF1100FF00
0BFF0011FF0011FF000BFF0000FF0000FF1200FF2A00FF4700FF6900FF9000FFBA00FFE8
00E7FF00B4FF0081FF004CFF0018FF1A00FF4C00FF7C00FF
00FF5900FF8800FFB900FFEC00DFFF00AAFF0077FF0044FF0013FF1A00FF4500FF6D00FF
9000FFAE00FFC700FFDA00FFE700FFEF00FFF000FFEB00FFE000FFD000FFBA00FF9F00FF
7F00FF5B00FF3400FF0B00FF0020FF004DFF007AFF00A6FF00D1FF00FAFF00FFDF00FFBD
00FF9F00FF8600FF7300FF6500FF5E00FF5C00FF6100FF6B00FF7B00FF9100FFAB00FFC9
00FFEB00F1FF00CBFF00A6FF0081FF005DFF003CFF001EFF0005FF0E00FF1D00FF2600FF
2900FF2600FF1C00FF0D00FF0006FF001EFF0039FF0056FF0075FF0093FF00AFFF00C9FF
00DFFF00EFFF00FBFF00FFFF00FFFF00F7FF00EBFF00D9FF00C4FF00AEFF0096FF0081FF
006EFF0060FF0057FF0055FF0059FF0063FF0071FF0081FF0090FF009DFF00A4FF00A5FF
009FFF0095FF008DFF008CFF0091FF0092FF008BFF0081FF007AFF007AFF0080FF008BFF
009BFF00ABFF00B9FF00C4FF00C9FF00C8FF00C1FF00B4FF00A2FF008CFF0075FF005EFF
0049FF0037FF0029FF0021FF001FFF0022FF002CFF003CFF0051FF006AFF0086FF00A4FF
00C2FF00E0FF00FCFF00FFEA00FFD600FFC600FFBB00FFB700FFB800FFC000FFCE00FFE1
00FFFA00E9FF00C8FF00A5FF0080FF005AFF0035FF0011FF1000FF2F00FF4A00FF6000FF
7200FF7D00FF8300FF8300FF7C00FF7000FF5D00FF4500FF2900FF0700FF001DFF0045FF
0070FF009CFF00C9FF00F6FF00FFDD00FFB300FF8C00FF6700FF4700FF2B00FF1400FF02
09FF000FFF000FFF0009FF0000FF0300FF1500FF2D00FF4A00FF6C00FF9200FFBD00FFEA
00E4FF00B2FF007EFF004AFF0016FF1D00FF4E00FF7E00FF
00FF5500FF8400FFB500FFE800E3FF00AEFF007AFF0048FF0017FF1600FF4100FF6900FF
8C00FFAA00FFC300FFD600FFE300FFEB00FFEC00FFE700FFDC00FFCC00FFB600FF9B00FF
7B00FF5700FF3000FF0700FF0024FF0051FF007EFF00AAFF00D5FF00FEFF00FFDB00FFB9
00FF9B00FF8300FF6F00FF6100FF5A00FF5800FF5D00FF6700FF7800FF8D00FFA700FFC5
00FFE700F4FF00CFFF00AAFF0084FF0061FF0040FF0022FF0009FF0B00FF1900FF2200FF
2500FF2200FF1800FF0900FF0009FF0022FF003DFF005AFF0079FF0097FF00B3FF00CDFF
00E2FF00F3FF00FEFF00FFFB00FFFD00FBFF00EEFF00DDFF00C8FF00B1FF009AFF0085FF
0072FF0064FF005BFF0059FF005DFF0067FF0075FF0085FF0094FF00A1FF00A8FF00A9FF
00A3FF0099FF0091FF0090FF0095FF0096FF008FFF0085FF007EFF007EFF0083FF008FFF
009EFF00AFFF00BDFF00C8FF00CDFF00CCFF00C5FF00B8FF00A6FF0090FF0079FF0062FF
004DFF003BFF002DFF0025FF0022FF0026FF0030FF0040FF0055FF006EFF008AFF00A8FF
00C6FF00E4FF00FFFF00FFE700FFD200FFC200FFB700FFB300FFB400FFBC00FFCA00FFDD
00FFF600EDFF00CCFF00A9FF0084FF005EFF0039FF0015FF0C00FF2B00FF4600FF5C00FF
6E00FF7900FF7F00FF7F00FF7800FF6C00FF5900FF4200FF2500FF0300FF0021FF0049FF
0074FF00A0FF00CDFF00FAFF00FFD900FFAF00FF8800FF6300FF4300FF2700FF1001FF00
0DFF0013FF0013FF000DFF0000FF0000FF1100FF2900FF4600FF6800FF8E00FFB900FFE6
00E8FF00B6FF0082FF004EFF001AFF1900FF4A00FF7A00FF
00FF4B00FF7A00FFAB00FFDE00EDFF00B8FF0084FF0052FF0021FF0C00FF3700FF5F00FF
8200FFA000FFB900FFCC00FFD900FFE100FFE200FFDD00FFD200FFC200FFAC00FF9100FF
7100FF4D00FF2600FF0002FF002EFF005BFF0088FF00B4FF00DFFF00FFF700FFD100FFAF
00FF9100FF7900FF6500FF5700FF5000FF4E00FF5300FF5D00FF6E00FF8300FF9D00FFBB
00FFDD00FEFF00D9FF00B4FF008EFF006BFF004AFF002CFF0013FF0000FF0F00FF1800FF
1B00FF1800FF0E00FF0000FF0013FF002CFF0047FF0064FF0083FF00A1FF00BDFF00D7FF
00EDFF00FDFF00FFF600FFF100FFF300FFFA00F9FF00E7FF00D2FF00BBFF00A4FF008FFF
007CFF006EFF0065FF0063FF0067FF0071FF007FFF008FFF009EFF00ABFF00B2FF00B3FF
00ADFF00A3FF009BFF009AFF009FFF00A0FF0099FF008FFF0088FF0088FF008DFF0099FF
00A8FF00B9FF00C7FF00D2FF00D7FF00D6FF00CFFF00C2FF00B0FF009AFF0083FF006CFF
0057FF0045FF0037FF002FFF002CFF0030FF003AFF004AFF005FFF0078FF0094FF00B2FF
00D0FF00EEFF00FFF500FFDD00FFC800FFB800FFAD00FFA900FFAA00FFB200FFC000FFD3
00FFEC00F7FF00D6FF00B3FF008EFF0068FF0043FF001FFF0200FF2100FF3C00FF5200FF
6400FF6F00FF7500FF7500FF6E00FF6200FF4F00FF3800FF1B00FF0006FF002BFF0053FF
007EFF00AAFF00D7FF00FFFB00FFCF00FFA500FF7E00FF5900FF3900FF1D00FF060BFF00
17FF001DFF001DFF0017FF000AFF0000FF0700FF1F00FF3C00FF5E00FF8400FFAF00FFDC
00F2FF00C0FF008CFF0058FF0024FF0F00FF4000FF7000FF
00FF3B00FF6A00FF9B00FFCF00FCFF00C8FF0094FF0062FF0031FF0002FF2800FF4F00FF
7200FF9000FFA900FFBC00FFCA00FFD100FFD200FFCD00FFC300FFB200FF9C00FF8100FF
6100FF3E00FF1700FF0012FF003EFF006AFF0097FF00C4FF00EFFF00FFE700FFC100FF9F
00FF8200FF6900FF5500FF4800FF4000FF3E00FF4300FF4E00FF5E00FF7300FF8D00FFAC
00FFCD00FFF100E9FF00C3FF009EFF007BFF005AFF003CFF0023FF000EFF0000FF0900FF
0B00FF0800FF0000FF000FFF0023FF003BFF0057FF0074FF0092FF00B1FF00CDFF00E7FF
00FCFF00FFF200FFE700FFE200FFE300FFEA00FFF700F7FF00E2FF00CBFF00B4FF009EFF
008CFF007DFF0075FF0073FF0077FF0080FF008EFF009EFF00AEFF00BBFF00C2FF00C2FF
00BCFF00B3FF00ABFF00AAFF00AFFF00B0FF00A9FF009FFF0098FF0097FF009DFF00A9FF
00B8FF00C8FF00D7FF00E2FF00E7FF00E6FF00DFFF00D1FF00BFFF00AAFF0093FF007CFF
0067FF0055FF0047FF003FFF003CFF0040FF004AFF005AFF006FFF0088FF00A4FF00C1FF
00E0FF00FEFF00FFE600FFCD00FFB800FFA800FF9E00FF9900FF9B00FFA200FFB000FFC3
00FFDC00FFF900E6FF00C3FF009EFF0078FF0053FF002FFF000DFF1100FF2C00FF4300FF
5400FF6000FF6500FF6500FF5E00FF5200FF4000FF2800FF0B00FF0015FF003BFF0063FF
008EFF00BAFF00E7FF00FFEC00FFC000FF9600FF6E00FF4A00FF2900FF0D09FF001BFF00
27FF002DFF002DFF0026FF001AFF0008FF0000FF0F00FF2C00FF4E00FF7500FF9F00FFCD
00FFFD00D0FF009CFF0068FF0033FF0000FF3100FF6000FF
00FF2600FF5500FF8700FFBA00FFEE00DDFF00A9FF0076FF0046FF0017FF1300FF3A00FF
5D00FF7B00FF9400FFA700FFB500FFBC00FFBD00FFB900FFAE00FF9D00FF8700FF6C00FF
4C00FF2900FF0200FF0027FF0053FF007FFF00ACFF00D9FF00FFFB00FFD300FFAD00FF8B
00FF6D00FF5400FF4100FF3300FF2B00FF2A00FF2E00FF3900FF4900FF5E00FF7900FF97
00FFB800FFDC00FEFF00D8FF00B3FF008FFF006EFF0051FF0037FF0023FF0014FF000BFF
0009FF000CFF0015FF0024FF0038FF0050FF006BFF0089FF00A7FF00C5FF00E2FF00FBFF
00FFEE00FFDD00FFD200FFCD00FFCE00FFD500FFE200FFF300F7FF00E0FF00C9FF00B3FF
00A0FF0092FF008AFF0087FF008CFF0095FF00A3FF00B3FF00C3FF00D0FF00D7FF00D7FF
00D1FF00C8FF00C0FF00BFFF00C4FF00C5FF00BEFF00B4FF00ADFF00ACFF00B2FF00BEFF
00CDFF00DDFF00ECFF00F6FF00FCFF00FBFF00F3FF00E6FF00D4FF00BFFF00A8FF0091FF
007CFF0069FF005CFF0053FF0051FF0055FF005FFF006FFF0084FF009CFF00B8FF00D6FF
00F5FF00FFED00FFD100FFB800FFA300FF9300FF8900FF8400FF8600FF8E00FF9B00FFAF
00FFC700FFE400FBFF00D8FF00B3FF008DFF0068FF0043FF0022FF0003FF1700FF2E00FF
3F00FF4B00FF5000FF5000FF4A00FF3D00FF2B00FF1300FF0009FF002AFF004FFF0078FF
00A2FF00CFFF00FBFF00FFD700FFAB00FF8100FF5900FF3500FF1407FF001EFF0030FF00
3CFF0042FF0041FF003BFF002FFF001DFF0005FF0000FF1700FF3900FF6000FF8A00FFB8
00FFE800E4FF00B1FF007CFF0048FF0015FF1C00FF4B00FF
00FF0D00FF3C00FF6E00FFA100FFD500F6FF00C2FF008FFF005FFF0030FF0005FF2100FF
4400FF6200FF7B00FF8E00FF9C00FFA300FFA500FFA000FF9500FF8400FF6E00FF5300FF
3300FF1000FF0016FF0040FF006CFF0098FF00C5FF00F2FF00FFE200FFBA00FF9400FF72
00FF5400FF3B00FF2800FF1A00FF1200FF1100FF1500FF2000FF3000FF4600FF6000FF7E
00FF9F00FFC300FFE800F1FF00CCFF00A8FF0087FF006AFF0050FF003CFF002DFF0024FF
0021FF0025FF002EFF003DFF0051FF0069FF0084FF00A2FF00C0FF00DEFF00FBFF00FFEB
00FFD500FFC400FFB900FFB400FFB500FFBC00FFC900FFDA00FFEF00F9FF00E2FF00CCFF
00B9FF00ABFF00A3FF00A0FF00A4FF00AEFF00BCFF00CCFF00DCFF00E8FF00F0FF00F0FF
00EAFF00E1FF00D9FF00D8FF00DDFF00DEFF00D7FF00CDFF00C6FF00C5FF00CBFF00D7FF
00E6FF00F6FF00FFFA00FFF000FFEA00FFEB00FFF300FFFF00EDFF00D8FF00C1FF00AAFF
0095FF0082FF0075FF006CFF006AFF006EFF0078FF0088FF009CFF00B5FF00D1FF00EFFF
00FFF100FFD400FFB800FF9F00FF8A00FF7A00FF7000FF6B00FF6D00FF7500FF8200FF96
00FFAE00FFCB00FFEB00F0FF00CCFF00A6FF0081FF005CFF003AFF001CFF0001FF1500FF
2600FF3200FF3700FF3700FF3100FF2400FF1200FF0005FF0022FF0043FF0068FF0091FF
00BBFF00E7FF00FFEB00FFBE00FF9200FF6800FF4000FF1C04FF0020FF0037FF0049FF00
54FF005AFF005AFF0054FF0048FF0036FF001EFF0001FF0000FF2000FF4700FF7100FF9F
00FFCF00FDFF00CAFF0095FF0061FF002EFF0300FF3300FF
0EFF0000FF2000FF5200FF8500FFB900FFED00DEFF00ABFF007AFF004CFF0021FF0500FF
2800FF4600FF5F00FF7200FF8000FF8700FF8900FF8400FF7900FF6800FF5200FF3700FF
1800FF000BFF0032FF005CFF0088FF00B4FF00E1FF00FFF100FFC600FF9E00FF7800FF56
00FF3800FF1F00FF0C01FF0009FF000AFF0006FF0000FF0400FF1400FF2A00FF4400FF62
00FF8300FFA700FFCC00FFF200E8FF00C4FF00A3FF0086FF006CFF0058FF0049FF0040FF
003DFF0041FF004AFF0059FF006DFF0085FF00A0FF00BEFF00DCFF00FAFF00FFE800FFCF
00FFB900FFA800FF9D00FF9800FF9900FFA000FFAD00FFBE00FFD300FFEA00FEFF00E8FF
00D5FF00C7FF00BFFF00BCFF00C0FF00CAFF00D8FF00E8FF00F8FF00FFFB00FFF300FFF3
00FFF900FDFF00F5FF00F4FF00F9FF00FAFF00F3FF00E9FF00E2FF00E1FF00E7FF00F3FF
00FFFD00FFED00FFDE00FFD400FFCE00FFCF00FFD700FFE400FFF600F4FF00DDFF00C6FF
00B1FF009EFF0091FF0088FF0086FF008AFF0094FF00A4FF00B8FF00D1FF00EDFF00FFF4
00FFD500FFB800FF9C00FF8300FF6E00FF5E00FF5400FF4F00FF5100FF5900FF6600FF7A
00FF9200FFAF00FFCF00FFF300E8FF00C2FF009DFF0078FF0056FF0038FF001DFF0006FF
0A00FF1600FF1C00FF1B00FF1500FF0800FF0009FF0021FF003EFF005FFF0084FF00ADFF
00D7FF00FFFC00FFCF00FFA200FF7600FF4C00FF2400FF0020FF003CFF0053FF0065FF00
70FF0076FF0076FF0070FF0064FF0052FF003AFF001DFF0000FF0400FF2B00FF5500FF83
00FFB300FFE600E6FF00B1FF007DFF004AFF0018FF1700FF
2CFF0000FF0200FF3400FF6700FF9B00FFCF00FCFF00C9FF0098FF006AFF003FFF0018FF
0A00FF2800FF4100FF5500FF6200FF6900FF6B00FF6600FF5B00FF4B00FF3400FF1900FF
0005FF0029FF0050FF007AFF00A5FF00D2FF00FFFF00FFD400FFA900FF8000FF5A00FF38
00FF1A00FF0111FF001FFF0027FF0028FF0024FF0019FF0009FF0000FF0C00FF2600FF44
00FF6500FF8900FFAE00FFD400FFF900E2FF00C1FF00A4FF008AFF0076FF0067FF005EFF
005BFF005FFF0068FF0077FF008BFF00A3FF00BEFF00DCFF00FAFF00FFE700FFCA00FFB1
00FF9B00FF8A00FF7F00FF7A00FF7B00FF8200FF8F00FFA100FFB500FFCC00FFE300FFF9
00F3FF00E5FF00DCFF00DAFF00DEFF00E8FF00F6FF00FFF900FFE900FFDD00FFD500FFD5
00FFDB00FFE400FFED00FFED00FFE900FFE800FFEF00FFF800FFFF00FFFF00FFFA00FFEE
00FFDF00FFCF00FFC000FFB600FFB000FFB100FFB900FFC600FFD800FFED00FBFF00E4FF
00CEFF00BCFF00AEFF00A6FF00A4FF00A8FF00B2FF00C1FF00D6FF00EFFF00FFF400FFD6
00FFB800FF9A00FF7E00FF6500FF5000FF4000FF3600FF3100FF3300FF3B00FF4800FF5C
00FF7400FF9100FFB200FFD500FFFA00E0FF00BAFF0096FF0074FF0055FF003AFF0024FF
0013FF0007FF0001FF0002FF0008FF0015FF0027FF003FFF005CFF007DFF00A2FF00CAFF
00F5FF00FFDE00FFB100FF8400FF5800FF2E00FF061DFF003EFF005AFF0071FF0082FF00
8EFF0094FF0094FF008EFF0082FF0070FF0058FF003BFF0019FF0000FF0D00FF3700FF65
00FF9500FFC800FFFC00CFFF009BFF0068FF0036FF0006FF
4AFF001BFF0000FF1500FF4900FF7D00FFB100FFE500E8FF00B7FF0088FF005DFF0036FF
0013FF0A00FF2300FF3600FF4400FF4B00FF4C00FF4700FF3D00FF2C00FF1600FF0004FF
0024FF0047FF006EFF0098FF00C4FF00F0FF00FFE200FFB500FF8A00FF6100FF3B00FF19
03FF001CFF0030FF003DFF0045FF0047FF0042FF0037FF0027FF0012FF0000FF0700FF26
00FF4700FF6B00FF9000FFB600FFDB00FFFE00E0FF00C2FF00A9FF0094FF0085FF007CFF
007AFF007DFF0086FF0095FF00A9FF00C1FF00DDFF00FAFF00FFE700FFC800FFAC00FF92
00FF7D00FF6C00FF6100FF5C00FF5D00FF6400FF7100FF8200FF9700FFAE00FFC500FFDB
00FFED00FFFC00FBFF00F9FF00FDFF00FFF900FFEB00FFDB00FFCB00FFBE00FFB700FFB7
00FFBD00FFC600FFCE00FFCF00FFCA00FFC900FFD000FFDA00FFE100FFE200FFDC00FFD0
00FFC100FFB100FFA200FF9700FF9200FF9300FF9A00FFA800FFBA00FFCF00FFE600FFFD
00EDFF00DBFF00CDFF00C5FF00C2FF00C6FF00D0FF00E0FF00F5FF00FFF100FFD500FFB8
00FF9900FF7B00FF6000FF4700FF3200FF2200FF1800FF1300FF1500FF1C00FF2A00FF3D
00FF5600FF7300FF9300FFB600FFDB00FEFF00D9FF00B5FF0093FF0074FF0059FF0042FF
0031FF0026FF0020FF0020FF0027FF0033FF0045FF005DFF007AFF009BFF00C1FF00E9FF
00FFEB00FFBF00FF9200FF6600FF3A00FF1017FF003BFF005CFF0078FF008FFF00A1FF00
ADFF00B3FF00B3FF00ACFF00A0FF008EFF0076FF0059FF0037FF0010FF0000FF1900FF47
00FF7700FFA900FFDD00EEFF00B9FF0086FF0054FF0025FF
68FF0039FF0007FF0000FF2B00FF5F00FF9300FFC700FFFA00D4FF00A6FF007BFF0054FF
0031FF0013FF0500FF1800FF2600FF2D00FF2F00FF2A00FF1F00FF0E00FF0007FF0022FF
0041FF0065FF008CFF00B6FF00E1FF00FFF100FFC400FF9700FF6C00FF4400FF1E03FF00
21FF003AFF004DFF005BFF0063FF0064FF0060FF0055FF0045FF002FFF0015FF0000FF08
00FF2900FF4D00FF7200FF9800FFBD00FFE100FDFF00E0FF00C6FF00B2FF00A3FF009AFF
0097FF009BFF00A4FF00B3FF00C7FF00DFFF00FAFF00FFE700FFC900FFAB00FF8E00FF75
00FF5F00FF4E00FF4300FF3E00FF3F00FF4600FF5300FF6400FF7900FF9000FFA700FFBD
00FFD000FFDE00FFE600FFE900FFE500FFDB00FFCD00FFBD00FFAD00FFA100FF9900FF99
00FF9F00FFA800FFB000FFB100FFAC00FFAB00FFB200FFBC00FFC300FFC400FFBE00FFB2
00FFA300FF9300FF8400FF7A00FF7400FF7500FF7D00FF8A00FF9C00FFB100FFC800FFDF
00FFF400F8FF00EBFF00E2FF00E0FF00E4FF00EEFF00FEFF00FFED00FFD400FFB800FF9A
00FF7B00FF5E00FF4200FF2900FF1400FF0405FF000AFF0008FF0000FF0000FF0C00FF20
00FF3800FF5500FF7500FF9900FFBD00FFE300F7FF00D2FF00B0FF0092FF0077FF0060FF
004FFF0043FF003DFF003EFF0044FF0051FF0063FF007BFF0098FF00B9FF00DEFF00FFF8
00FFCE00FFA200FF7500FF4800FF1C0DFF0035FF0059FF007AFF0096FF00ADFF00BEFF00
CAFF00D0FF00D0FF00CAFF00BEFF00ACFF0094FF0077FF0055FF002EFF0004FF0000FF29
00FF5900FF8C00FFBF00FFF400D7FF00A4FF0072FF0042FF
84FF0055FF0023FF0000FF0F00FF4300FF7700FFAB00FFDE00F0FF00C2FF0097FF0070FF
004DFF002EFF0016FF0002FF0A00FF1100FF1300FF0E00FF0300FF000CFF0022FF003EFF
005DFF0081FF00A8FF00D2FF00FDFF00FFD500FFA800FF7C00FF5100FF2800FF021FFF00
3DFF0056FF0069FF0077FF007FFF0080FF007BFF0071FF0061FF004BFF0031FF0013FF00
00FF0D00FF3100FF5600FF7C00FFA100FFC500FFE600FCFF00E2FF00CEFF00BFFF00B6FF
00B3FF00B7FF00C0FF00CFFF00E3FF00FBFF00FFE900FFCB00FFAD00FF8F00FF7300FF59
00FF4300FF3200FF2700FF2200FF2300FF2A00FF3700FF4900FF5D00FF7400FF8B00FFA1
00FFB400FFC200FFCB00FFCD00FFC900FFBF00FFB100FFA100FF9100FF8500FF7E00FF7D
00FF8300FF8D00FF9500FF9500FF9100FF9000FF9700FFA000FFA700FFA800FFA200FF97
00FF8700FF7700FF6800FF5E00FF5900FF5A00FF6100FF6E00FF8000FF9500FFAC00FFC3
00FFD900FFEB00FFF900FEFF00FCFF00FFFF00FFF500FFE600FFD100FFB800FF9C00FF7E
00FF6000FF4200FF2600FF0D07FF0016FF0021FF0026FF0024FF001CFF000EFF0000FF04
00FF1C00FF3900FF5A00FF7D00FFA200FFC700FFED00EEFF00CCFF00ADFF0092FF007CFF
006BFF005FFF0059FF005AFF0060FF006DFF007FFF0097FF00B4FF00D5FF00FAFF00FFDD
00FFB200FF8600FF5900FF2C00FF0029FF0051FF0075FF0096FF00B2FF00C9FF00DAFF00
E6FF00ECFF00ECFF00E6FF00DAFF00C8FF00B0FF0093FF0071FF004AFF0020FF0000FF0D
00FF3E00FF7000FFA400FFD800F3FF00C0FF008EFF005EFF
9CFF006DFF003CFF0009FF0000FF2A00FF5F00FF9200FFC500FFF600DBFF00B0FF0088FF
0065FF0047FF002EFF001BFF000EFF0006FF0005FF000AFF0015FF0025FF003BFF0056FF
0076FF009AFF00C1FF00EBFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006FFF0082FF0090FF0097FF0099FF0094FF008AFF007AFF0064FF004AFF002CFF00
0AFF0000FF1800FF3E00FF6300FF8800FFAC00FFCD00FFEB00FBFF00E7FF00D8FF00CFFF
00CCFF00CFFF00D9FF00E8FF00FCFF00FFEB00FFD000FFB300FF9400FF7600FF5A00FF40
00FF2A00FF1A00FF0E00FF0900FF0A00FF1200FF1E00FF3000FF4500FF5B00FF7300FF88
00FF9B00FFA900FFB200FFB400FFB000FFA600FF9800FF8800FF7900FF6C00FF6500FF64
00FF6A00FF7400FF7C00FF7D00FF7800FF7700FF7E00FF8800FF8E00FF8F00FF8900FF7E
00FF6E00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7D00FF9400FFAB
00FFC000FFD200FFE000FFE800FFEA00FFE700FFDD00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0BFF001FFF002FFF003AFF003EFF003DFF0035FF0027FF0014FF00
00FF0400FF2000FF4100FF6400FF8900FFAE00FFD400FFF800E5FF00C6FF00ABFF0095FF
0084FF0078FF0072FF0072FF0079FF0085FF0098FF00B0FF00CCFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1318FF0042FF0069FF008EFF00AEFF00CAFF00E1FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F2FF00E0FF00C9FF00ABFF0089FF0063FF0038FF000BFF00
00FF2500FF5700FF8B00FFBF00FFF300D8FF00A7FF0077FF
B1FF0082FF0051FF001EFF0000FF1500FF4A00FF7E00FFB000FFE100F0FF00C4FF009DFF
007AFF005CFF0043FF0030FF0022FF001BFF001AFF001FFF0029FF003AFF0050FF006BFF
008BFF00AFFF00D6FF00FFFF00FFD400FFA700FF7A00FF4E00FF2305FF002BFF004DFF00
6BFF0083FF0097FF00A4FF00ACFF00AEFF00A9FF009FFF008EFF0079FF005FFF0041FF00
1FFF0000FF0400FF2900FF4F00FF7400FF9700FFB800FFD600FFEF00FBFF00EDFF00E4FF
00E1FF00E4FF00EEFF00FCFF00FFEF00FFD700FFBB00FF9E00FF7F00FF6100FF4500FF2B
00FF1600FF0505FF000AFF0009FF0002FF0000FF0A00FF1B00FF3000FF4700FF5E00FF74
00FF8600FF9500FF9D00FF9F00FF9B00FF9100FF8400FF7300FF6400FF5700FF5000FF50
00FF5500FF5F00FF6700FF6800FF6300FF6200FF6900FF7300FF7A00FF7B00FF7500FF69
00FF5A00FF4900FF3B00FF3000FF2B00FF2C00FF3300FF4000FF5200FF6800FF7F00FF96
00FFAB00FFBD00FFCB00FFD300FFD600FFD200FFC800FFB800FFA300FF8A00FF6E00FF50
00FF3200FF1407FF001FFF0034FF0044FF004FFF0053FF0051FF004AFF003CFF0029FF00
10FF0000FF0C00FF2C00FF4F00FF7400FF9A00FFBF00FFE300FAFF00DBFF00C0FF00AAFF
0098FF008DFF0087FF0087FF008EFF009AFF00ADFF00C4FF00E1FF00FFFC00FFD700FFAF
00FF8400FF5800FF2B01FF002CFF0057FF007EFF00A3FF00C3FF00DFFF00F6FF00FFF700
FFEB00FFE500FFE500FFEB00FFF800F5FF00DDFF00C0FF009EFF0078FF004DFF001FFF00
00FF1000FF4200FF7600FFAA00FFDE00EDFF00BBFF008CFF
C1FF0092FF0061FF002EFF0000FF0600FF3A00FF6E00FFA000FFD100FFFF00D4FF00ADFF
008AFF006CFF0053FF0040FF0032FF002BFF002AFF002FFF0039FF004AFF0060FF007BFF
009BFF00BEFF00E6FF00FFF000FFC400FF9700FF6B00FF3E00FF1315FF003BFF005DFF00
7AFF0093FF00A7FF00B4FF00BCFF00BEFF00B9FF00AEFF009EFF0089FF006FFF0050FF00
2FFF000BFF0000FF1900FF3F00FF6400FF8700FFA800FFC600FFDF00FFF400FCFF00F4FF
00F1FF00F4FF00FDFF00FFF300FFDF00FFC700FFAB00FF8E00FF6F00FF5100FF3500FF1B
00FF060AFF0015FF001AFF0019FF0012FF0005FF0000FF0B00FF2000FF3700FF4E00FF64
00FF7600FF8500FF8D00FF8F00FF8B00FF8200FF7400FF6300FF5400FF4700FF4000FF40
00FF4500FF4F00FF5700FF5800FF5300FF5200FF5900FF6300FF6A00FF6B00FF6500FF59
00FF4A00FF3900FF2B00FF2000FF1B00FF1C00FF2300FF3100FF4200FF5800FF6F00FF86
00FF9B00FFAD00FFBB00FFC300FFC600FFC200FFB800FFA800FF9300FF7A00FF5E00FF40
00FF2200FF0416FF002FFF0044FF0054FF005EFF0063FF0061FF005AFF004CFF0039FF00
20FF0003FF0000FF1C00FF3F00FF6400FF8A00FFAF00FFD300FFF500EBFF00D0FF00BAFF
00A8FF009DFF0097FF0097FF009EFF00AAFF00BCFF00D4FF00F1FF00FFED00FFC700FF9F
00FF7400FF4800FF1B11FF003CFF0067FF008EFF00B3FF00D3FF00EFFF00FFF900FFE700
FFDB00FFD500FFD500FFDC00FFE800FFFA00EDFF00D0FF00AEFF0088FF005DFF002FFF00
00FF0000FF3200FF6600FF9A00FFCF00FDFF00CBFF009CFF
CCFF009DFF006BFF0038FF0004FF0000FF2F00FF6300FF9600FFC700FFF500DFFF00B8FF
0095FF0076FF005EFF004AFF003DFF0035FF0034FF0039FF0044FF0054FF006AFF0086FF
00A5FF00C9FF00F0FF00FFE500FFBA00FF8D00FF6000FF3400FF091FFF0045FF0067FF00
85FF009EFF00B1FF00BFFF00C7FF00C8FF00C3FF00B9FF00A9FF0093FF0079FF005BFF00
3AFF0016FF0000FF0E00FF3400FF5900FF7D00FF9E00FFBB00FFD500FFE900FFF800FEFF
00FBFF00FFFF00FFF700FFE800FFD400FFBC00FFA100FF8300FF6500FF4700FF2B00FF11
04FF0015FF0020FF0025FF0024FF001DFF0010FF0000FF0100FF1500FF2C00FF4300FF59
00FF6C00FF7A00FF8300FF8500FF8100FF7700FF6900FF5900FF4900FF3D00FF3600FF35
00FF3B00FF4500FF4D00FF4D00FF4900FF4800FF4F00FF5800FF5F00FF6000FF5A00FF4F
00FF3F00FF2F00FF2000FF1600FF1100FF1200FF1900FF2600FF3800FF4D00FF6400FF7B
00FF9100FFA300FFB100FFB900FFBB00FFB700FFAD00FF9E00FF8900FF7000FF5400FF36
00FF1805FF0021FF003AFF004FFF005EFF0069FF006DFF006CFF0064FF0056FF0043FF00
2BFF000EFF0000FF1200FF3500FF5A00FF7F00FFA500FFC900FFEB00F5FF00DAFF00C4FF
00B3FF00A7FF00A1FF00A2FF00A8FF00B5FF00C7FF00DFFF00FCFF00FFE200FFBD00FF95
00FF6A00FF3E00FF111BFF0047FF0071FF0099FF00BDFF00DEFF00FAFF00FFEE00FFDD00
FFD100FFCB00FFCB00FFD100FFDD00FFEF00F8FF00DBFF00B8FF0092FF0068FF003AFF00
09FF0000FF2800FF5C00FF9000FFC400FFF700D6FF00A6FF
D0FF00A1FF0070FF003DFF0009FF0000FF2B00FF5F00FF9100FFC200FFF000E3FF00BCFF
0099FF007BFF0062FF004FFF0041FF003AFF0039FF003EFF0048FF0059FF006FFF008AFF
00AAFF00CDFF00F5FF00FFE100FFB500FF8800FF5B00FF2F00FF0424FF004AFF006CFF00
89FF00A2FF00B6FF00C3FF00CBFF00CDFF00C8FF00BDFF00ADFF0098FF007EFF005FFF00
3EFF001AFF0000FF0A00FF3000FF5500FF7800FF9900FFB700FFD000FFE500FFF400FFFC
00FFFF00FFFC00FFF200FFE400FFD000FFB800FF9C00FF7F00FF6000FF4200FF2600FF0C
08FF0019FF0024FF0029FF0028FF0021FF0014FF0003FF0000FF1100FF2800FF3F00FF55
00FF6700FF7600FF7E00FF8000FF7C00FF7200FF6500FF5400FF4500FF3800FF3100FF31
00FF3600FF4000FF4800FF4900FF4400FF4300FF4A00FF5400FF5B00FF5C00FF5600FF4A
00FF3B00FF2A00FF1C00FF1100FF0C00FF0D00FF1400FF2100FF3300FF4900FF6000FF77
00FF8C00FF9E00FFAC00FFB400FFB700FFB300FFA900FF9900FF8400FF6B00FF4F00FF31
00FF130AFF0026FF003EFF0053FF0063FF006DFF0072FF0070FF0069FF005BFF0048FF00
2FFF0012FF0000FF0D00FF3000FF5500FF7B00FFA000FFC400FFE600FAFF00DFFF00C9FF
00B7FF00ACFF00A6FF00A6FF00ADFF00B9FF00CBFF00E3FF00FFFF00FFDE00FFB800FF90
00FF6500FF3900FF0C20FF004BFF0076FF009DFF00C2FF00E2FF00FEFF00FFEA00FFD800
FFCC00FFC600FFC600FFCD00FFD900FFEB00FCFF00DFFF00BDFF0097FF006CFF003EFF00
0EFF0000FF2300FF5700FF8B00FFBF00FFF300DAFF00ABFF
CFFF00A0FF006EFF003BFF0007FF0000FF2C00FF6000FF9300FFC400FFF200E2FF00BBFF
0098FF0079FF0061FF004DFF0040FF0038FF0037FF003CFF0047FF0057FF006DFF0089FF
00A8FF00CCFF00F3FF00FFE200FFB700FF8A00FF5D00FF3100FF0622FF0048FF006AFF00
88FF00A1FF00B4FF00C2FF00CAFF00CBFF00C6FF00BCFF00ACFF0096FF007CFF005EFF00
3CFF0019FF0000FF0C00FF3100FF5600FF7A00FF9B00FFB900FFD200FFE600FFF500FFFE
00FEFF00FFFD00FFF400FFE500FFD100FFB900FF9E00FF8000FF6200FF4400FF2800FF0E
07FF0018FF0023FF0028FF0027FF0020FF0013FF0001FF0000FF1200FF2900FF4000FF56
00FF6900FF7700FF8000FF8200FF7E00FF7400FF6600FF5600FF4600FF3A00FF3300FF32
00FF3800FF4200FF4A00FF4A00FF4600FF4500FF4C00FF5500FF5C00FF5D00FF5700FF4C
00FF3C00FF2C00FF1E00FF1300FF0E00FF0F00FF1600FF2300FF3500FF4A00FF6100FF78
00FF8E00FFA000FFAE00FFB600FFB800FFB400FFAA00FF9B00FF8600FF6D00FF5100FF33
00FF1508FF0024FF003DFF0051FF0061FF006CFF0070FF006FFF0067FF0059FF0046FF00
2EFF0011FF0000FF0F00FF3200FF5700FF7C00FFA200FFC600FFE800F8FF00DDFF00C7FF
00B6FF00AAFF00A4FF00A5FF00ABFF00B8FF00CAFF00E2FF00FFFF00FFDF00FFBA00FF92
00FF6700FF3B00FF0E1EFF004AFF0074FF009CFF00C0FF00E0FF00FDFF00FFEB00FFDA00
FFCE00FFC800FFC800FFCE00FFDA00FFED00FBFF00DEFF00BBFF0095FF006BFF003DFF00
0CFF0000FF2500FF5900FF8D00FFC100FFF400D9FF00A9FF
C7FF0098FF0066FF0033FF0000FF0000FF3400FF6800FF9B00FFCC00FFFA00DAFF00B3FF
0090FF0072FF0059FF0046FF0038FF0031FF002FFF0034FF003FFF0050FF0066FF0081FF
00A0FF00C4FF00EBFF00FFEA00FFBE00FF9200FF6500FF3800FF0D1AFF0040FF0062FF00
80FF0099FF00ACFF00BAFF00C2FF00C3FF00BFFF00B4FF00A4FF008EFF0074FF0056FF00
35FF0011FF0000FF1300FF3900FF5E00FF8200FFA300FFC000FFDA00FFEE00FFFD00F9FF
00F6FF00FAFF00FFFC00FFED00FFD900FFC100FFA600FF8800FF6A00FF4C00FF2F00FF16
00FF0010FF001BFF0020FF001FFF0018FF000BFF0000FF0500FF1A00FF3100FF4800FF5E
00FF7100FF7F00FF8700FF8A00FF8600FF7C00FF6E00FF5E00FF4E00FF4200FF3A00FF3A
00FF4000FF4900FF5100FF5200FF4D00FF4C00FF5300FF5D00FF6400FF6500FF5F00FF53
00FF4400FF3400FF2500FF1B00FF1500FF1600FF1E00FF2B00FF3D00FF5200FF6900FF80
00FF9500FFA800FFB500FFBE00FFC000FFBC00FFB200FFA200FF8E00FF7500FF5900FF3B
00FF1C00FF001CFF0035FF004AFF005AFF0064FF0069FF0067FF005FFF0052FF003EFF00
26FF0009FF0000FF1600FF3A00FF5E00FF8400FFA900FFCE00FFF000F1FF00D6FF00BFFF
00AEFF00A2FF009CFF009DFF00A3FF00B0FF00C2FF00DAFF00F7FF00FFE700FFC200FF99
00FF6F00FF4300FF1616FF0042FF006CFF0094FF00B8FF00D9FF00F5FF00FFF300FFE200
FFD600FFD000FFD000FFD600FFE200FFF400F3FF00D6FF00B4FF008DFF0063FF0035FF00
05FF0000FF2D00FF6000FF9500FFC900FFFC00D1FF00A1FF
B9FF008AFF0059FF0026FF0000FF0E00FF4200FF7600FFA800FFD900F7FF00CCFF00A5FF
0082FF0064FF004BFF0038FF002AFF0023FF0022FF0027FF0031FF0042FF0058FF0073FF
0093FF00B6FF00DDFF00FFF800FFCC00FFA000FF7300FF4600FF1B0DFF0033FF0055FF00
72FF008BFF009FFF00ACFF00B4FF00B6FF00B1FF00A6FF0096FF0081FF0067FF0048FF00
27FF0003FF0000FF2100FF4700FF6C00FF8F00FFB000FFCE00FFE700FFFC00F4FF00ECFF
00E9FF00ECFF00F5FF00FFFB00FFE700FFCF00FFB300FF9600FF7800FF5900FF3D00FF23
00FF0E02FF000DFF0012FF0011FF000AFF0000FF0200FF1300FF2800FF3F00FF5600FF6C
00FF7E00FF8D00FF9500FF9700FF9300FF8A00FF7C00FF6C00FF5C00FF4F00FF4800FF48
00FF4D00FF5700FF5F00FF6000FF5B00FF5A00FF6100FF6B00FF7200FF7300FF6D00FF61
00FF5200FF4200FF3300FF2800FF2300FF2400FF2B00FF3900FF4A00FF6000FF7700FF8E
00FFA300FFB500FFC300FFCB00FFCE00FFCA00FFC000FFB000FF9B00FF8200FF6600FF48
00FF2A00FF0C0EFF0027FF003CFF004CFF0056FF005BFF0059FF0052FF0044FF0031FF00
18FF0000FF0400FF2400FF4700FF6C00FF9200FFB700FFDB00FFFD00E3FF00C8FF00B1FF
00A0FF0095FF008FFF008FFF0096FF00A2FF00B4FF00CCFF00E9FF00FFF500FFCF00FFA7
00FF7C00FF5000FF2308FF0034FF005EFF0086FF00AAFF00CBFF00E7FF00FEFF00FFEF00
FFE300FFDD00FFDD00FFE400FFF000FDFF00E5FF00C8FF00A6FF007FFF0055FF0027FF00
00FF0800FF3A00FF6E00FFA200FFD700F5FF00C3FF0094FF
A6FF0077FF0045FF0012FF0000FF2100FF5500FF8900FFBC00FFED00E4FF00B9FF0092FF
006FFF0051FF0038FF0024FF0017FF0010FF000EFF0013FF001EFF002FFF0045FF0060FF
007FFF00A3FF00CAFF00F4FF00FFE000FFB300FF8600FF5900FF2E00FF061FFF0041FF00
5FFF0078FF008BFF0099FF00A1FF00A2FF009EFF0093FF0083FF006DFF0053FF0035FF00
14FF0000FF0F00FF3400FF5A00FF7F00FFA300FFC400FFE100FFFB00F0FF00E1FF00D8FF
00D5FF00D9FF00E2FF00F1FF00FFFA00FFE200FFC700FFA900FF8B00FF6D00FF5000FF37
00FF2100FF1000FF0500FF0000FF0100FF0800FF1500FF2600FF3B00FF5200FF6900FF7F
00FF9200FFA000FFA800FFAB00FFA700FF9D00FF8F00FF7F00FF6F00FF6300FF5B00FF5B
00FF6100FF6A00FF7200FF7300FF6F00FF6D00FF7500FF7E00FF8500FF8600FF8000FF74
00FF6500FF5500FF4600FF3C00FF3600FF3700FF3F00FF4C00FF5E00FF7300FF8A00FFA1
00FFB700FFC900FFD600FFDF00FFE100FFDD00FFD300FFC300FFAF00FF9600FF7A00FF5C
00FF3D00FF2000FF0414FF0029FF0039FF0043FF0048FF0046FF003EFF0031FF001DFF00
05FF0000FF1700FF3700FF5B00FF7F00FFA500FFCB00FFEF00EEFF00D0FF00B5FF009EFF
008DFF0081FF007BFF007CFF0082FF008FFF00A1FF00B9FF00D6FF00F7FF00FFE300FFBA
00FF9000FF6400FF3700FF0A21FF004BFF0073FF0097FF00B8FF00D4FF00EBFF00FCFF00
FFF700FFF100FFF100FFF700FCFF00EAFF00D2FF00B5FF0093FF006CFF0042FF0014FF00
00FF1B00FF4E00FF8100FFB600FFEA00E2FF00B0FF0080FF
8DFF005EFF002DFF0000FF0500FF3900FF6E00FFA100FFD400FAFF00CCFF00A1FF0079FF
0056FF0038FF001FFF000CFF0000FF0800FF0900FF0400FF0006FF0016FF002CFF0047FF
0067FF008BFF00B2FF00DBFF00FFF800FFCB00FF9E00FF7200FF4700FF1E07FF0029FF00
47FF005FFF0073FF0081FF0088FF008AFF0085FF007BFF006AFF0055FF003BFF001DFF00
00FF0400FF2800FF4D00FF7200FF9800FFBB00FFDC00FFFA00ECFF00D8FF00C9FF00C0FF
00BDFF00C0FF00CAFF00D9FF00ECFF00FFFA00FFDF00FFC200FFA300FF8500FF6900FF4F
00FF3900FF2900FF1D00FF1800FF1A00FF2100FF2D00FF3F00FF5400FF6B00FF8200FF97
00FFAA00FFB800FFC100FFC300FFBF00FFB500FFA700FF9700FF8800FF7B00FF7400FF73
00FF7900FF8300FF8B00FF8C00FF8700FF8600FF8D00FF9700FF9E00FF9E00FF9900FF8D
00FF7E00FF6D00FF5F00FF5400FF4F00FF5000FF5700FF6400FF7600FF8C00FFA300FFBA
00FFCF00FFE100FFEF00FFF700FFFA00FFF600FFEC00FFDC00FFC700FFAE00FF9200FF74
00FF5600FF3800FF1C00FF0410FF0020FF002BFF002FFF002EFF0026FF0018FF0005FF00
00FF1300FF2F00FF5000FF7300FF9800FFBE00FFE300F8FF00D6FF00B7FF009CFF0086FF
0074FF0069FF0063FF0063FF006AFF0076FF0089FF00A0FF00BDFF00DFFF00FFFB00FFD3
00FFA800FF7C00FF4F00FF2209FF0033FF005AFF007FFF009FFF00BBFF00D2FF00E4FF00
F0FF00F6FF00F6FF00F0FF00E3FF00D1FF00B9FF009CFF007AFF0054FF0029FF0000FF03
00FF3400FF6600FF9A00FFCE00FDFF00C9FF0098FF0068FF
71FF0041FF0010FF0000FF2200FF5600FF8A00FFBE00FFF100DDFF00AFFF0084FF005CFF
0039FF001BFF0002FF1000FF1D00FF2500FF2600FF2100FF1600FF0600FF000FFF002AFF
004AFF006EFF0095FF00BFFF00EAFF00FFE800FFBB00FF8F00FF6400FF3B00FF150CFF00
2AFF0043FF0056FF0064FF006BFF006DFF0068FF005EFF004EFF0038FF001EFF0000FF00
00FF2100FF4400FF6A00FF8F00FFB400FFD800FFF900E8FF00CFFF00BBFF00ACFF00A3FF
00A0FF00A3FF00ADFF00BCFF00D0FF00E8FF00FFFC00FFDF00FFC000FFA200FF8600FF6C
00FF5600FF4500FF3A00FF3500FF3600FF3E00FF4A00FF5C00FF7100FF8700FF9E00FFB4
00FFC700FFD500FFDE00FFE000FFDC00FFD200FFC400FFB400FFA400FF9800FF9100FF90
00FF9600FFA000FFA800FFA800FFA400FFA300FFAA00FFB400FFBA00FFBB00FFB500FFAA
00FF9A00FF8A00FF7C00FF7100FF6C00FF6D00FF7400FF8100FF9300FFA800FFBF00FFD6
00FFEC00FFFE00F3FF00EBFF00E9FF00EDFF00F7FF00FFF900FFE400FFCB00FFAF00FF91
00FF7300FF5500FF3900FF2000FF0C03FF000EFF0012FF0011FF0009FF0000FF0400FF17
00FF2F00FF4C00FF6D00FF9000FFB500FFDA00FFFF00DBFF00B9FF009AFF007FFF0069FF
0058FF004CFF0046FF0046FF004DFF0059FF006CFF0084FF00A0FF00C2FF00E7FF00FFF0
00FFC500FF9900FF6C00FF3F00FF1316FF003DFF0062FF0082FF009EFF00B5FF00C7FF00
D3FF00D9FF00D9FF00D3FF00C7FF00B4FF009DFF007FFF005DFF0037FF000CFF0000FF20
00FF5100FF8300FFB700FFEB00E0FF00ADFF007BFF004BFF
50FF0021FF0000FF0F00FF4300FF7700FFAB00FFDF00EEFF00BDFF008EFF0063FF003CFF
0019FF0400FF1D00FF3000FF3E00FF4500FF4600FF4200FF3700FF2600FF1000FF000AFF
002AFF004DFF0074FF009EFF00CAFF00F6FF00FFDC00FFAF00FF8400FF5B00FF3600FF13
09FF0022FF0036FF0043FF004BFF004DFF0048FF003DFF002DFF0018FF0000FF0100FF20
00FF4100FF6500FF8A00FFB000FFD500FFF800E6FF00C8FF00AFFF009AFF008BFF0082FF
0080FF0083FF008CFF009BFF00AFFF00C7FF00E3FF00FFFF00FFE100FFC300FFA600FF8C
00FF7700FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7C00FF9100FFA800FFBF00FFD5
00FFE700FFF600FFFE00FFFF00FFFC00FFF300FFE500FFD500FFC500FFB800FFB100FFB1
00FFB700FFC000FFC800FFC900FFC400FFC300FFCA00FFD400FFDB00FFDC00FFD600FFCA
00FFBB00FFAB00FF9C00FF9100FF8C00FF8D00FF9400FFA200FFB400FFC900FFE000FFF7
00F3FF00E1FF00D3FF00CBFF00C8FF00CCFF00D6FF00E6FF00FBFF00FFEB00FFCF00FFB2
00FF9300FF7500FF5A00FF4100FF2C00FF1C00FF1200FF0D00FF0F00FF1600FF2400FF37
00FF5000FF6D00FF8D00FFB000FFD500FFFB00DFFF00BBFF0099FF007AFF005FFF0048FF
0037FF002BFF0026FF0026FF002DFF0039FF004BFF0063FF0080FF00A1FF00C7FF00EFFF
00FFE600FFB900FF8C00FF6000FF3400FF0A1DFF0041FF0062FF007EFF0095FF00A7FF00
B3FF00B9FF00B9FF00B2FF00A6FF0094FF007CFF005FFF003DFF0016FF0000FF1300FF41
00FF7100FFA300FFD700F4FF00BFFF008CFF005AFF002BFF
2DFF0000FF0100FF3300FF6600FF9A00FFCE00FDFF00CAFF009AFF006BFF0040FF0019FF
0900FF2700FF4000FF5300FF6100FF6800FF6900FF6500FF5A00FF4900FF3300FF1800FF
0007FF002AFF0051FF007BFF00A7FF00D3FF00FFFF00FFD200FFA700FF7E00FF5900FF37
00FF1900FF0013FF0020FF0028FF0029FF0025FF001AFF000AFF0000FF0A00FF2500FF43
00FF6400FF8800FFAD00FFD300FFF800E3FF00C2FF00A5FF008BFF0077FF0068FF005FFF
005DFF0060FF0069FF0078FF008CFF00A4FF00BFFF00DDFF00FBFF00FFE600FFC900FFB0
00FF9A00FF8900FF7E00FF7900FF7A00FF8100FF8E00FF9F00FFB400FFCB00FFE200FFF8
00F4FF00E6FF00DEFF00DBFF00E0FF00E9FF00F7FF00FFF800FFE800FFDB00FFD400FFD4
00FFDA00FFE300FFEB00FFEC00FFE700FFE600FFED00FFF700FFFE00FFFF00FFF900FFED
00FFDE00FFCE00FFBF00FFB500FFAF00FFB000FFB800FFC500FFD700FFEC00FCFF00E5FF
00D0FF00BDFF00B0FF00A7FF00A5FF00A9FF00B3FF00C3FF00D8FF00F0FF00FFF300FFD5
00FFB600FF9900FF7D00FF6400FF4F00FF3F00FF3500FF3000FF3200FF3A00FF4700FF5B
00FF7300FF9000FFB000FFD300FFF800E1FF00BCFF0097FF0076FF0057FF003CFF0025FF
0014FF0008FF0003FF0003FF0009FF0016FF0028FF0040FF005DFF007EFF00A3FF00CCFF
00F6FF00FFDC00FFB000FF8300FF5700FF2D00FF051EFF003FFF005BFF0072FF0084FF00
90FF0096FF0095FF008FFF0083FF0071FF0059FF003CFF001AFF0000FF0C00FF3600FF64
00FF9400FFC700FFFA00D0FF009CFF0069FF0037FF0008FF
08FF0000FF2600FF5700FF8B00FFBF00FFF300D8FF00A6FF0075FF0046FF001BFF0B00FF
2E00FF4C00FF6500FF7800FF8600FF8D00FF8E00FF8A00FF7F00FF6E00FF5800FF3D00FF
1D00FF0005FF002CFF0056FF0082FF00AEFF00DBFF00FFF700FFCC00FFA300FF7E00FF5B
00FF3E00FF2500FF1100FF0403FF0004FF0000FF0000FF0A00FF1A00FF2F00FF4900FF68
00FF8900FFAD00FFD200FFF800E2FF00BFFF009EFF0080FF0067FF0052FF0043FF003AFF
0038FF003BFF0044FF0053FF0067FF007FFF009BFF00B8FF00D6FF00F4FF00FFEE00FFD4
00FFBF00FFAE00FFA300FF9E00FF9F00FFA600FFB300FFC400FFD900FFF000F8FF00E2FF
00D0FF00C1FF00B9FF00B7FF00BBFF00C4FF00D2FF00E2FF00F2FF00FFFF00FFF900FFF9
00FFFF00F7FF00EFFF00EEFF00F3FF00F4FF00EDFF00E3FF00DCFF00DBFF00E1FF00EDFF
00FCFF00FFF300FFE400FFD900FFD400FFD500FFDC00FFEA00FFFC00EEFF00D7FF00C0FF
00ABFF0099FF008BFF0082FF0080FF0084FF008EFF009EFF00B3FF00CCFF00E8FF00FFFA
00FFDB00FFBD00FFA200FF8900FF7400FF6400FF5A00FF5500FF5700FF5E00FF6C00FF7F
00FF9800FFB500FFD500FFF800E2FF00BCFF0097FF0073FF0051FF0032FF0017FF0000FF
1000FF1C00FF2100FF2100FF1B00FF0E00FF0003FF001BFF0038FF0059FF007EFF00A7FF
00D1FF00FEFF00FFD400FFA800FF7C00FF5200FF2A00FF061AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006AFF005EFF004CFF0034FF0017FF0000FF0A00FF3100FF5B00FF89
00FFB900FFEC00E0FF00ACFF0077FF0044FF0012FF1C00FF
00FF1D00FF4C00FF7D00FFB000FFE400E6FF00B3FF0080FF004FFF0021FF0900FF3100FF
5400FF7200FF8B00FF9E00FFAB00FFB300FFB400FFAF00FFA400FF9400FF7E00FF6300FF
4300FF1F00FF0007FF0030FF005CFF0089FF00B6FF00E2FF00FFF200FFC900FFA300FF81
00FF6300FF4A00FF3700FF2900FF2200FF2000FF2500FF2F00FF4000FF5500FF6F00FF8D
00FFAF00FFD200FFF800E2FF00BCFF0099FF0078FF005AFF0041FF002DFF001EFF0015FF
0012FF0015FF001FFF002EFF0042FF005AFF0075FF0092FF00B1FF00CFFF00EBFF00FFFA
00FFE400FFD400FFC800FFC300FFC400FFCC00FFD800FFEA00FFFF00EAFF00D2FF00BDFF
00AAFF009CFF0093FF0091FF0095FF009FFF00ADFF00BDFF00CCFF00D9FF00E0FF00E1FF
00DBFF00D1FF00C9FF00C8FF00CDFF00CEFF00C7FF00BDFF00B6FF00B6FF00BCFF00C7FF
00D7FF00E7FF00F5FF00FFFF00FFFA00FFFB00FDFF00F0FF00DEFF00C8FF00B1FF009AFF
0085FF0073FF0065FF005DFF005AFF005EFF0068FF0078FF008DFF00A6FF00C2FF00E0FF
00FEFF00FFE300FFC700FFAE00FF9A00FF8A00FF7F00FF7B00FF7C00FF8400FF9200FFA5
00FFBE00FFDA00FFFB00E1FF00BCFF0096FF0071FF004DFF002BFF000CFF0E00FF2400FF
3600FF4100FF4700FF4700FF4000FF3400FF2100FF0900FF0012FF0034FF0059FF0081FF
00ACFF00D8FF00FFFA00FFCD00FFA100FF7700FF5000FF2B00FF0B10FF0027FF0039FF00
45FF004BFF004BFF0045FF0038FF0026FF000EFF0000FF0E00FF3000FF5600FF8100FFAE
00FFDF00EEFF00BAFF0086FF0052FF001EFF1200FF4200FF
00FF4200FF7100FFA300FFD600F5FF00C1FF008DFF005AFF002AFF0400FF2F00FF5600FF
7900FF9700FFB000FFC300FFD100FFD800FFD900FFD500FFCA00FFB900FFA300FF8800FF
6800FF4500FF1E00FF000BFF0037FF0063FF0090FF00BDFF00E8FF00FFEE00FFC900FFA6
00FF8900FF7000FF5C00FF4F00FF4700FF4600FF4A00FF5500FF6500FF7A00FF9500FFB3
00FFD400FFF800E2FF00BCFF0097FF0074FF0053FF0035FF001CFF0007FF0700FF1000FF
1200FF0F00FF0600FF0008FF001CFF0034FF0050FF006DFF008BFF00A9FF00C6FF00DFFF
00F5FF00FFF900FFEE00FFE900FFEA00FFF100FFFE00F0FF00DBFF00C4FF00ADFF0097FF
0084FF0076FF006EFF006CFF0070FF0079FF0087FF0097FF00A7FF00B4FF00BBFF00BBFF
00B5FF00ACFF00A4FF00A3FF00A8FF00A9FF00A2FF0098FF0091FF0090FF0096FF00A2FF
00B1FF00C1FF00D0FF00DBFF00E0FF00DFFF00D8FF00CAFF00B8FF00A3FF008CFF0075FF
0060FF004EFF0040FF0037FF0035FF0039FF0043FF0053FF0068FF0081FF009DFF00BAFF
00D9FF00F7FF00FFED00FFD400FFBF00FFAF00FFA500FFA000FFA200FFA900FFB700FFCB
00FFE300FFFF00DFFF00BCFF0097FF0071FF004CFF0028FF0006FF1800FF3300FF4A00FF
5B00FF6700FF6C00FF6C00FF6600FF5900FF4700FF2F00FF1200FF000EFF0033FF005CFF
0086FF00B3FF00E0FF00FFF300FFC700FF9D00FF7500FF5100FF3000FF1402FF0014FF00
20FF0026FF0026FF001FFF0013FF0001FF0000FF1600FF3300FF5500FF7C00FFA600FFD4
00FBFF00C8FF0095FF0060FF002CFF0600FF3800FF6700FF
00FF6600FF9500FFC700FFFA00D1FF009DFF0069FF0036FF0006FF2800FF5300FF7A00FF
9D00FFBB00FFD400FFE700FFF500FFFC00FFFE00FFF900FFEE00FFDD00FFC700FFAC00FF
8C00FF6900FF4200FF1800FF0013FF003FFF006CFF0099FF00C4FF00ECFF00FFED00FFCB
00FFAD00FF9400FF8100FF7300FF6B00FF6A00FF6E00FF7900FF8900FF9F00FFB900FFD7
00FFF800E3FF00BEFF0098FF0073FF004FFF002EFF0011FF0800FF1C00FF2B00FF3400FF
3700FF3300FF2A00FF1B00FF0700FF0010FF002BFF0049FF0067FF0085FF00A2FF00BBFF
00D1FF00E2FF00EDFF00F2FF00F1FF00EAFF00DDFF00CCFF00B7FF00A0FF0089FF0073FF
0060FF0052FF004AFF0047FF004BFF0055FF0063FF0073FF0083FF008FFF0097FF0097FF
0091FF0088FF0080FF007FFF0084FF0085FF007EFF0074FF006DFF006CFF0072FF007EFF
008DFF009DFF00ACFF00B6FF00BCFF00BBFF00B3FF00A6FF0094FF007FFF0068FF0051FF
003CFF0029FF001CFF0013FF0011FF0015FF001FFF002FFF0043FF005CFF0078FF0096FF
00B5FF00D2FF00EEFF00FFF800FFE300FFD300FFC900FFC400FFC600FFCE00FFDB00FFEF
00F8FF00DBFF00BBFF0097FF0073FF004DFF0028FF0003FF1E00FF3C00FF5700FF6E00FF
7F00FF8B00FF9100FF9000FF8A00FF7D00FF6B00FF5300FF3600FF1500FF000FFF0038FF
0062FF008EFF00BBFF00E8FF00FFEB00FFC100FF9900FF7500FF5400FF3800FF2100FF0F
00FF0401FF0001FF0000FF0400FF1000FF2200FF3A00FF5700FF7900FFA000FFCA00FFF8
00D7FF00A4FF0071FF003CFF0008FF2A00FF5C00FF8C00FF
00FF8800FFB700FFE900E3FF00AFFF007BFF0047FF0014FF1B00FF4A00FF7500FF9C00FF
BF00FFDD00FFF600FFFF00F6FF00E8FF00E1FF00E0FF00E4FF00EFFF00FFE900FFCE00FF
AE00FF8B00FF6400FF3A00FF0E00FF001DFF004AFF0077FF00A2FF00CAFF00F0FF00FFED
00FFCF00FFB600FFA200FF9500FF8D00FF8C00FF9000FF9B00FFAB00FFC000FFDB00FFF9
00E5FF00C1FF009CFF0076FF0051FF002DFF000CFF1000FF2A00FF3E00FF4D00FF5600FF
5800FF5500FF4C00FF3D00FF2900FF1100FF0009FF0027FF0045FF0063FF0080FF0099FF
00AFFF00C0FF00CBFF00D0FF00CFFF00C8FF00BBFF00AAFF0095FF007EFF0067FF0051FF
003EFF0030FF0028FF0025FF002AFF0033FF0041FF0051FF0061FF006EFF0075FF0075FF
006FFF0066FF005EFF005DFF0062FF0063FF005CFF0052FF004BFF004AFF0050FF005CFF
006BFF007BFF008AFF0094FF009AFF0099FF0091FF0084FF0072FF005DFF0046FF002FFF
001AFF0007FF0500FF0E00FF1000FF0C00FF0200FF000DFF0022FF003AFF0056FF0074FF
0093FF00B0FF00CCFF00E5FF00FAFF00FFF500FFEB00FFE600FFE800FFF000FFFD00EEFF
00D6FF00B9FF0099FF0076FF0051FF002BFF0006FF1E00FF3F00FF5E00FF7900FF9000FF
A100FFAD00FFB200FFB200FFAC00FF9F00FF8D00FF7500FF5800FF3700FF1200FF0016FF
0040FF006DFF0099FF00C6FF00F2FF00FFE300FFBB00FF9700FF7600FF5A00FF4300FF31
00FF2500FF1F00FF2000FF2600FF3200FF4400FF5C00FF7900FF9B00FFC200FFEC00E5FF
00B5FF0082FF004FFF001AFF1900FF4C00FF7E00FFAD00FF
00FFA700FFD600F8FF00C4FF0090FF005CFF0028FF0900FF3A00FF6900FF9400FFBB00FF
DE00FFFC00FFFF00EAFF00D7FF00C9FF00C2FF00C1FF00C5FF00D0FF00E1FF00F7ED00FF
CD00FFAA00FF8300FF5900FF2D00FF0100FF002BFF0058FF0083FF00ACFF00D1FF00F4FF
00FFEE00FFD500FFC100FFB400FFAC00FFAA00FFAF00FFBA00FFCA00FFDF00FFF900E7FF
00C6FF00A2FF007DFF0057FF0032FF000FFF1100FF2F00FF4800FF5D00FF6C00FF7500FF
7700FF7400FF6B00FF5C00FF4800FF3000FF1400FF0008FF0026FF0044FF0061FF007BFF
0090FF00A1FF00ACFF00B1FF00B0FF00A9FF009CFF008BFF0076FF005FFF0048FF0032FF
0020FF0011FF0009FF0007FF000BFF0014FF0022FF0032FF0042FF004FFF0056FF0056FF
0050FF0047FF003FFF003EFF0043FF0044FF003DFF0033FF002CFF002BFF0031FF003DFF
004CFF005CFF006BFF0076FF007BFF007AFF0073FF0065FF0053FF003EFF0027FF0010FF
0400FF1600FF2400FF2C00FF2F00FF2B00FF2100FF1100FF0003FF001CFF0038FF0055FF
0074FF0092FF00ADFF00C6FF00DBFF00EBFF00F5FF00FAFF00F8FF00F1FF00E3FF00D0FF
00B7FF009AFF007AFF0057FF0032FF000CFF1800FF3C00FF5E00FF7D00FF9800FFAF00FF
C000FFCC00FFD100FFD100FFCA00FFBE00FFAC00FF9400FF7700FF5600FF3000FF0800FF
0021FF004EFF007BFF00A7FF00D3FF00FDFF00FFDA00FFB600FF9500FF7900FF6200FF50
00FF4400FF3E00FF3E00FF4500FF5100FF6300FF7B00FF9800FFBA00FFE100F4FF00C6FF
0096FF0064FF0030FF0300FF3800FF6B00FF9D00FFCC00FF
00FFC200FFF100DDFF00A9FF0075FF0041FF000DFF2400FF5500FF8400FFAF00FFD600FF
F900FFFF00E8FF00CFFF00BCFF00AEFF00A7FF00A6FF00AAFF00B5FF00C6FF00DCFF00F7
E800FFC500FF9E00FF7400FF4800FF1C00FF0010FF003DFF0068FF0091FF00B6FF00D9FF
00F6FF00FFF000FFDC00FFCF00FFC700FFC500FFCA00FFD500FFE500FFFA00EBFF00CCFF
00ABFF0087FF0062FF003CFF0017FF0B00FF2C00FF4A00FF6300FF7800FF8700FF9000FF
9200FF8F00FF8600FF7700FF6300FF4B00FF2F00FF1200FF000BFF0029FF0046FF0060FF
0075FF0086FF0091FF0096FF0095FF008EFF0081FF0070FF005BFF0044FF002DFF0017FF
0005FF0900FF1100FF1300FF0F00FF0600FF0007FF0017FF0027FF0034FF003BFF003BFF
0035FF002CFF0024FF0023FF0028FF0029FF0022FF0018FF0011FF0010FF0016FF0022FF
0031FF0041FF0050FF005BFF0060FF005FFF0058FF004AFF0038FF0023FF000CFF0A00FF
1F00FF3100FF3F00FF4700FF4A00FF4600FF3C00FF2C00FF1700FF0001FF001DFF003AFF
0059FF0077FF0092FF00ABFF00C0FF00D0FF00DAFF00DFFF00DDFF00D6FF00C8FF00B5FF
009CFF007FFF005FFF003CFF0017FF0E00FF3300FF5700FF7900FF9800FFB300FFCA00FF
DB00FFE700FFEC00FFEC00FFE500FFD900FFC700FFAF00FF9200FF7100FF4B00FF2300FF
0006FF0033FF0060FF008CFF00B8FF00E2FF00FFF500FFD100FFB000FF9400FF7D00FF6B
00FF5F00FF5900FF5900FF6000FF6C00FF7E00FF9600FFB300FFD500FFFC00D9FF00ABFF
007BFF0049FF0015FF1E00FF5300FF8600FFB800FFE700FF
00FFD800F8FF00C6FF0093FF005FFF002BFF0800FF3B00FF6C00FF9A00FFC500FFEC00FF
FF00F0FF00D1FF00B9FF00A5FF0098FF0091FF008FFF0094FF009FFF00AFFF00C6FF00E1
FF00FFDB00FFB400FF8A00FF5F00FF3200FF0500FF0026FF0051FF007AFF00A0FF00C2FF
00E0FF00F9FF00FFF300FFE500FFDD00FFDC00FFE000FFEB00FFFB00EEFF00D4FF00B6FF
0095FF0071FF004CFF0026FF0001FF2200FF4300FF6000FF7A00FF8E00FF9D00FFA600FF
A900FFA500FF9C00FF8D00FF7900FF6100FF4600FF2800FF0A00FF0013FF0030FF0049FF
005FFF0070FF007BFF0080FF007FFF0078FF006BFF0059FF0045FF002EFF0017FF0001FF
1100FF1F00FF2800FF2A00FF2600FF1C00FF0E00FF0001FF0011FF001DFF0024FF0025FF
001FFF0015FF000DFF000DFF0011FF0012FF000BFF0002FF0400FF0500FF0000FF000CFF
001BFF002BFF003AFF0044FF0049FF0049FF0041FF0034FF0022FF000DFF0900FF2000FF
3600FF4800FF5600FF5E00FF6000FF5C00FF5200FF4300FF2E00FF1500FF0006FF0024FF
0042FF0060FF007CFF0095FF00AAFF00BAFF00C4FF00C9FF00C7FF00BFFF00B1FF009EFF
0086FF0069FF0048FF0025FF0000FF2400FF4A00FF6E00FF9000FFAF00FFCA00FFE000FF
F100FFFD00FFFF00FCFF00FDFC00FFEF00FFDD00FFC500FFA800FF8700FF6200FF3A00FF
0F00FF001CFF0049FF0076FF00A2FF00CCFF00F4FF00FFE700FFC600FFAA00FF9300FF82
00FF7600FF7000FF7000FF7600FF8200FF9400FFAC00FFC900FFEB00EDFF00C3FF0095FF
0065FF0032FF0100FF3500FF6900FF9C00FFCE00FFFE00FF
00FFEA00E6FF00B5FF0082FF004EFF0019FF1900FF4C00FF7D00FFAB00FFD600FFFE00FF
FF00DEFF00C0FF00A7FF0094FF0087FF007FFF007EFF0083FF008EFF009EFF00B4FF00CF
FF00EFEC00FFC500FF9C00FF7000FF4300FF1600FF0015FF0040FF0069FF008FFF00B1FF
00CFFF00E8FF00FBFF00FFF600FFEF00FFED00FFF200FFFC00F2FF00DDFF00C3FF00A5FF
0083FF0060FF003AFF0015FF1000FF3300FF5400FF7200FF8B00FF9F00FFAE00FFB700FF
BA00FFB700FFAD00FF9E00FF8A00FF7200FF5700FF3A00FF1B00FF0002FF001EFF0038FF
004EFF005EFF006AFF006FFF006EFF0066FF005AFF0048FF0033FF001DFF0005FF0F00FF
2200FF3000FF3900FF3B00FF3700FF2D00FF1F00FF0F00FF0000FF000CFF0013FF0014FF
000EFF0004FF0300FF0400FF0000FF0001FF0500FF0F00FF1600FF1600FF1000FF0500FF
000AFF001AFF0028FF0033FF0038FF0037FF0030FF0023FF0011FF0400FF1B00FF3200FF
4700FF5900FF6700FF6F00FF7200FF6E00FF6400FF5400FF3F00FF2600FF0A00FF0013FF
0031FF004FFF006BFF0084FF0098FF00A8FF00B3FF00B7FF00B6FF00AEFF00A0FF008DFF
0074FF0058FF0037FF0014FF1000FF3600FF5B00FF7F00FFA100FFC000FFDB00FFF100FF
FF00FCFF00F1FF00EBFF00EBFF00F2FF00FEEE00FFD600FFBA00FF9800FF7300FF4B00FF
2000FF000BFF0038FF0065FF0091FF00BBFF00E2FF00FFF800FFD800FFBC00FFA500FF93
00FF8700FF8100FF8100FF8700FF9400FFA600FFBE00FFDB00FFFD00DCFF00B1FF0084FF
0053FF0021FF1200FF4600FF7A00FFAE00FFDF00FFFF00F0
00FFF500DBFF00A9FF0076FF0042FF000EFF2500FF5800FF8900FFB700FFE200FFFF00F6
FF00D3FF00B5FF009CFF0088FF007BFF0074FF0072FF0077FF0082FF0093FF00A9FF00C4
FF00E3F800FFD100FFA700FF7C00FF4F00FF2200FF0009FF0034FF005DFF0083FF00A5FF
00C3FF00DCFF00EFFF00FDFF00FFFA00FFF900FFFD00F7FF00E7FF00D1FF00B7FF0099FF
0078FF0054FF002FFF0009FF1B00FF3F00FF6000FF7D00FF9700FFAB00FFBA00FFC300FF
C600FFC200FFB900FFAA00FF9600FF7E00FF6300FF4500FF2700FF0900FF0013FF002CFF
0042FF0053FF005EFF0063FF0062FF005BFF004EFF003DFF0028FF0011FF0500FF1B00FF
2E00FF3C00FF4500FF4700FF4300FF3900FF2B00FF1B00FF0B00FF0000FF0008FF0008FF
0002FF0600FF0F00FF0F00FF0B00FF0A00FF1100FF1A00FF2100FF2200FF1C00FF1000FF
0100FF000EFF001DFF0027FF002DFF002CFF0024FF0017FF0005FF0F00FF2600FF3D00FF
5300FF6500FF7200FF7B00FF7D00FF7900FF6F00FF6000FF4B00FF3200FF1600FF0007FF
0026FF0043FF005FFF0078FF008DFF009DFF00A7FF00ACFF00AAFF00A2FF0095FF0081FF
0069FF004CFF002BFF0008FF1C00FF4100FF6700FF8B00FFAD00FFCC00FFE700FFFD00FF
FF00F1FF00E5FF00DFFF00E0FF00E6FF00F3FA00FFE200FFC500FFA400FF7F00FF5700FF
2C00FF0000FF002CFF0059FF0085FF00AFFF00D7FF00FBFF00FFE300FFC700FFB000FF9F
00FF9300FF8D00FF8D00FF9300FF9F00FFB100FFC900FFE600F7FF00D0FF00A6FF0078FF
0048FF0015FF1E00FF5200FF8600FFB900FFEB00FFFF00E4
00FFFB00D5FF00A3FF0070FF003CFF0008FF2B00FF5E00FF8E00FFBD00FFE800FFFF00F0
FF00CDFF00AFFF0096FF0083FF0075FF006EFF006DFF0071FF007CFF008DFF00A3FF00BE
FF00DEFE00FFD700FFAD00FF8100FF5500FF2800FF0004FF002FFF0058FF007DFF009FFF
00BDFF00D6FF00EAFF00F7FF00FFFF00FFFF00FCFF00F1FF00E1FF00CCFF00B1FF0093FF
0072FF004EFF0029FF0003FF2100FF4500FF6600FF8300FF9D00FFB100FFC000FFC900FF
CB00FFC800FFBF00FFB000FF9C00FF8400FF6900FF4B00FF2D00FF0F00FF000DFF0026FF
003CFF004DFF0058FF005DFF005CFF0055FF0048FF0037FF0022FF000BFF0B00FF2100FF
3400FF4200FF4A00FF4D00FF4800FF3F00FF3100FF2100FF1100FF0400FF0002FF0002FF
0300FF0C00FF1400FF1500FF1000FF0F00FF1600FF2000FF2700FF2800FF2200FF1600FF
0700FF0008FF0017FF0022FF0027FF0026FF001EFF0011FF0000FF1500FF2C00FF4300FF
5800FF6B00FF7800FF8100FF8300FF7F00FF7500FF6500FF5000FF3700FF1C00FF0001FF
0020FF003DFF0059FF0072FF0087FF0097FF00A1FF00A6FF00A4FF009CFF008FFF007BFF
0063FF0046FF0026FF0003FF2100FF4700FF6C00FF9100FFB200FFD100FFEC00FFFF00FC
FF00EBFF00DFFF00DAFF00DAFF00E0FF00EDFF00FFE800FFCB00FFAA00FF8500FF5C00FF
3200FF0500FF0026FF0053FF007FFF00A9FF00D1FF00F5FF00FFE900FFCD00FFB600FFA4
00FF9800FF9200FF9300FF9900FFA500FFB700FFCF00FFEC00F1FF00CAFF00A0FF0072FF
0042FF000FFF2300FF5800FF8C00FFBF00FFF100FFFF00DF
00FFFB00D5FF00A4FF0071FF003DFF0008FF2B00FF5D00FF8E00FFBC00FFE700FFFF00F0
FF00CDFF00AFFF0096FF0083FF0076FF006EFF006DFF0072FF007DFF008DFF00A3FF00BE
FF00DEFD00FFD600FFAD00FF8100FF5400FF2700FF0004FF002FFF0058FF007EFF00A0FF
00BEFF00D6FF00EAFF00F8FF00FFFF00FFFE00FCFF00F2FF00E1FF00CCFF00B2FF0094FF
0072FF004EFF0029FF0004FF2100FF4400FF6500FF8300FF9C00FFB100FFBF00FFC800FF
CB00FFC800FFBE00FFAF00FF9C00FF8300FF6800FF4B00FF2C00FF0E00FF000DFF0027FF
003CFF004DFF0058FF005EFF005CFF0055FF0048FF0037FF0022FF000BFF0B00FF2100FF
3300FF4100FF4A00FF4C00FF4800FF3E00FF3000FF2000FF1100FF0400FF0002FF0003FF
0200FF0C00FF1400FF1500FF1000FF0F00FF1600FF2000FF2700FF2800FF2200FF1600FF
0700FF0009FF0017FF0022FF0027FF0026FF001FFF0012FF0000FF1500FF2C00FF4300FF
5800FF6A00FF7800FF8000FF8300FF7F00FF7500FF6500FF5000FF3700FF1B00FF0002FF
0020FF003EFF005AFF0072FF0087FF0097FF00A2FF00A6FF00A5FF009DFF008FFF007CFF
0063FF0046FF0026FF0003FF2100FF4700FF6C00FF9000FFB200FFD100FFEC00FFFF00FD
FF00EBFF00E0FF00DAFF00DAFF00E1FF00EDFF00FFE800FFCB00FFA900FF8400FF5C00FF
3100FF0500FF0027FF0054FF007FFF00AAFF00D1FF00F6FF00FFE900FFCD00FFB600FFA4
00FF9800FF9200FF9200FF9800FFA500FFB700FFCF00FFEC00F1FF00CBFF00A0FF0073FF
0042FF0010FF2300FF5700FF8B00FFBF00FFF100FFFF00DF
00FFF400DCFF00AAFF0077FF0043FF000FFF2400FF5700FF8800FFB600FFE100FFFF00F7
FF00D4FF00B6FF009DFF0089FF007CFF0075FF0073FF0078FF0083FF0094FF00AAFF00C5
FF00E4F700FFD000FFA600FF7B00FF4E00FF2100FF000AFF0036FF005EFF0084FF00A6FF
00C4FF00DDFF00F0FF00FEFF00FFF900FFF800FFFC00F8FF00E8FF00D2FF00B8FF009AFF
0079FF0055FF0030FF000AFF1A00FF3E00FF5F00FF7C00FF9600FFAA00FFB900FFC200FF
C500FFC100FFB800FFA900FF9500FF7D00FF6200FF4400FF2600FF0800FF0014FF002DFF
0043FF0054FF005FFF0064FF0063FF005CFF004FFF003EFF0029FF0012FF0400FF1A00FF
2D00FF3B00FF4400FF4600FF4200FF3800FF2A00FF1A00FF0A00FF0001FF0009FF0009FF
0003FF0500FF0D00FF0E00FF0A00FF0900FF1000FF1900FF2000FF2100FF1B00FF0F00FF
0000FF000FFF001EFF0028FF002EFF002DFF0025FF0018FF0006FF0E00FF2500FF3C00FF
5200FF6400FF7100FF7A00FF7C00FF7800FF6E00FF5E00FF4A00FF3100FF1500FF0008FF
0027FF0044FF0060FF0079FF008EFF009EFF00A8FF00ADFF00ABFF00A3FF0096FF0082FF
006AFF004DFF002DFF0009FF1B00FF4000FF6600FF8A00FFAC00FFCA00FFE500FFFC00FF
FF00F2FF00E6FF00E0FF00E1FF00E7FF00F4F900FFE100FFC400FFA300FF7E00FF5600FF
2B00FF0000FF002DFF005AFF0086FF00B0FF00D8FF00FCFF00FFE200FFC600FFAF00FF9E
00FF9200FF8C00FF8C00FF9200FF9E00FFB000FFC800FFE500F8FF00D1FF00A7FF0079FF
0049FF0016FF1C00FF5100FF8500FFB800FFEA00FFFF00E5
00FFE800E8FF00B7FF0084FF0050FF001BFF1800FF4A00FF7B00FFA900FFD400FFFC00FF
FF00E0FF00C2FF00A9FF0096FF0089FF0081FF0080FF0085FF008FFF00A0FF00B6FF00D1
FF00F1EA00FFC300FF9A00FF6E00FF4100FF1400FF0017FF0042FF006BFF0091FF00B3FF
00D1FF00E9FF00FDFF00FFF400FFED00FFEB00FFF000FFFA00F4FF00DFFF00C5FF00A7FF
0085FF0061FF003CFF0016FF0E00FF3100FF5200FF7000FF8900FF9E00FFAC00FFB500FF
B800FFB500FFAB00FF9C00FF8900FF7100FF5500FF3800FF1900FF0004FF0020FF003AFF
004FFF0060FF006BFF0071FF006FFF0068FF005BFF004AFF0035FF001EFF0007FF0E00FF
2000FF2E00FF3700FF3900FF3500FF2B00FF1D00FF0D00FF0001FF000EFF0015FF0016FF
0010FF0006FF0100FF0200FF0002FF0003FF0300FF0D00FF1400FF1500FF0F00FF0300FF
000BFF001CFF002AFF0035FF003AFF0039FF0032FF0025FF0013FF0200FF1900FF3000FF
4500FF5700FF6500FF6D00FF7000FF6C00FF6200FF5200FF3D00FF2400FF0800FF0015FF
0033FF0051FF006DFF0085FF009AFF00AAFF00B5FF00B9FF00B8FF00B0FF00A2FF008FFF
0076FF0059FF0039FF0016FF0E00FF3400FF5900FF7D00FF9F00FFBE00FFD900FFEF00FF
FF00FEFF00F3FF00EDFF00EDFF00F4FF00FFEC00FFD500FFB800FF9600FF7100FF4900FF
1E00FF000DFF003AFF0067FF0092FF00BDFF00E4FF00FFF600FFD600FFBA00FFA300FF91
00FF8500FF7F00FF7F00FF8500FF9200FFA400FFBC00FFD900FFFB00DEFF00B3FF0086FF
0055FF0023FF1000FF4400FF7800FFAC00FFDE00FFFF00F2
00FFD500FBFF00C9FF0096FF0062FF002EFF0500FF3800FF6900FF9700FFC200FFE900FF
FF00F3FF00D4FF00BCFF00A8FF009BFF0093FF0092FF0097FF00A2FF00B2FF00C8FF00E4
FC00FFD800FFB100FF8700FF5C00FF2F00FF0200FF0029FF0054FF007DFF00A3FF00C5FF
00E3FF00FCFF00FFF000FFE200FFDA00FFD900FFDE00FFE800FFF800F1FF00D7FF00B9FF
0098FF0074FF004FFF0029FF0004FF1F00FF4000FF5D00FF7700FF8B00FF9A00FFA300FF
A600FFA200FF9900FF8A00FF7600FF5E00FF4300FF2500FF0700FF0016FF0032FF004CFF
0062FF0073FF007EFF0083FF0082FF007BFF006EFF005CFF0048FF0031FF001AFF0004FF
0E00FF1C00FF2500FF2700FF2300FF1900FF0B00FF0004FF0014FF0020FF0027FF0028FF
0022FF0018FF0010FF0010FF0014FF0015FF000EFF0005FF0100FF0200FF0003FF000EFF
001EFF002EFF003CFF0047FF004CFF004BFF0044FF0037FF0025FF0010FF0600FF1D00FF
3300FF4500FF5300FF5B00FF5D00FF5900FF4F00FF4000FF2B00FF1200FF0009FF0027FF
0045FF0063FF007FFF0098FF00ADFF00BCFF00C7FF00CBFF00CAFF00C2FF00B4FF00A1FF
0089FF006CFF004BFF0028FF0003FF2100FF4700FF6B00FF8D00FFAC00FFC700FFDD00FF
EE00FFFA00FFFF00FFFF00FFF900FFEC00FFDA00FFC200FFA500FF8400FF5F00FF3700FF
0C00FF001FFF004CFF0079FF00A5FF00CFFF00F7FF00FFE400FFC400FFA700FF9000FF7F
00FF7300FF6D00FF6D00FF7300FF7F00FF9200FFA900FFC600FFE900F0FF00C6FF0098FF
0067FF0035FF0001FF3200FF6600FF9900FFCB00FFFB00FF
00FFBE00FFED00E1FF00AEFF007AFF0045FF0012FF2000FF5100FF7F00FFAA00FFD200FF
F500FFFF00ECFF00D3FF00C0FF00B3FF00ABFF00AAFF00AFFF00BAFF00CAFF00E0FF00FB
E400FFC000FF9900FF6F00FF4400FF1700FF0015FF0041FF006CFF0095FF00BBFF00DDFF
00FBFF00FFEB00FFD800FFCA00FFC300FFC100FFC600FFD000FFE000FFF600EFFF00D1FF
00AFFF008CFF0066FF0041FF001CFF0700FF2800FF4600FF5F00FF7300FF8200FF8B00FF
8E00FF8B00FF8100FF7200FF5E00FF4600FF2B00FF0E00FF0010FF002EFF004AFF0064FF
007AFF008AFF0096FF009BFF009AFF0092FF0086FF0074FF005FFF0049FF0031FF001CFF
0009FF0400FF0D00FF0F00FF0B00FF0100FF000CFF001CFF002BFF0038FF003FFF0040FF
003AFF0030FF0028FF0027FF002CFF002DFF0026FF001CFF0016FF0015FF001BFF0026FF
0036FF0046FF0054FF005FFF0064FF0063FF005CFF004FFF003DFF0027FF0010FF0600FF
1B00FF2D00FF3B00FF4300FF4500FF4200FF3800FF2800FF1300FF0005FF0021FF003FFF
005DFF007BFF0097FF00B0FF00C4FF00D4FF00DFFF00E3FF00E2FF00DAFF00CCFF00B9FF
00A0FF0084FF0063FF0040FF001BFF0900FF2F00FF5300FF7500FF9400FFAF00FFC500FF
D600FFE200FFE800FFE800FFE100FFD500FFC200FFAA00FF8E00FF6C00FF4700FF1F00FF
000BFF0037FF0064FF0091FF00BDFF00E7FF00FFF100FFCC00FFAC00FF9000FF7900FF67
00FF5B00FF5500FF5500FF5B00FF6800FF7A00FF9100FFAF00FFD100FFF700DDFF00B0FF
007FFF004DFF0019FF1A00FF4E00FF8200FFB300FFE300FF
00FFA100FFD000FEFF00CBFF0097FF0062FF002EFF0300FF3400FF6200FF8D00FFB500FF
D800FFF600FFFF00F0FF00DDFF00D0FF00C8FF00C7FF00CCFF00D7FF00E7FF00FDE700FF
C700FFA300FF7C00FF5300FF2700FF0005FF0032FF005EFF0089FF00B2FF00D8FF00FAFF
00FFE700FFCF00FFBB00FFAD00FFA600FFA400FFA900FFB300FFC400FFD900FFF300EEFF
00CCFF00A8FF0083FF005EFF0038FF0015FF0B00FF2900FF4200FF5700FF6500FF6E00FF
7100FF6E00FF6400FF5500FF4200FF2900FF0E00FF000EFF002DFF004BFF0067FF0081FF
0096FF00A7FF00B2FF00B8FF00B6FF00AFFF00A2FF0091FF007CFF0065FF004EFF0038FF
0026FF0018FF000FFF000DFF0011FF001BFF0029FF0039FF0048FF0055FF005CFF005DFF
0057FF004DFF0045FF0044FF0049FF004AFF0043FF0039FF0032FF0031FF0037FF0043FF
0052FF0063FF0071FF007CFF0081FF0080FF0079FF006CFF005AFF0044FF002DFF0016FF
0001FF1000FF1E00FF2600FF2900FF2500FF1B00FF0B00FF0009FF0022FF003EFF005CFF
007AFF0098FF00B4FF00CCFF00E1FF00F1FF00FCFF00FFFF00FFFF00F7FF00E9FF00D6FF
00BDFF00A0FF0080FF005DFF0038FF0012FF1200FF3600FF5800FF7700FF9200FFA800FF
BA00FFC500FFCB00FFCB00FFC400FFB800FFA500FF8E00FF7100FF4F00FF2A00FF0200FF
0028FF0054FF0081FF00AEFF00DAFF00FFFB00FFD400FFAF00FF8F00FF7300FF5C00FF4A
00FF3E00FF3800FF3800FF3E00FF4B00FF5D00FF7500FF9200FFB400FFDA00FAFF00CDFF
009CFF006AFF0036FF0002FF3100FF6500FF9700FFC600FF
00FF7F00FFAE00FFE000ECFF00B8FF0084FF0050FF001DFF1300FF4100FF6C00FF9300FF
B600FFD500FFED00FFFF00FEFF00F1FF00E9FF00E8FF00EDFF00F8F700FFE100FFC500FF
A600FF8200FF5B00FF3100FF0600FF0026FF0053FF007FFF00AAFF00D3FF00F9FF00FFE4
00FFC600FFAD00FF9A00FF8C00FF8400FF8300FF8800FF9200FFA200FFB800FFD200FFF0
00EEFF00CAFF00A5FF007FFF005AFF0036FF0015FF0700FF2100FF3500FF4400FF4D00FF
5000FF4C00FF4300FF3400FF2000FF0800FF0012FF0030FF004EFF006CFF0088FF00A2FF
00B8FF00C9FF00D4FF00D9FF00D8FF00D1FF00C4FF00B2FF009EFF0087FF0070FF005AFF
0047FF0039FF0030FF002EFF0032FF003CFF004AFF005AFF006AFF0076FF007DFF007EFF
0078FF006EFF0066FF0066FF006AFF006BFF0064FF005BFF0054FF0053FF0059FF0064FF
0074FF0084FF0093FF009DFF00A2FF00A1FF009AFF008DFF007BFF0066FF004FFF0038FF
0022FF0010FF0002FF0500FF0700FF0300FF0006FF0015FF002AFF0043FF005FFF007DFF
009BFF00B9FF00D5FF00EEFF00FFFC00FFED00FFE200FFDE00FFDF00FFE700FFF500F7FF
00DFFF00C2FF00A1FF007EFF0059FF0034FF000EFF1500FF3700FF5600FF7100FF8700FF
9800FFA400FFAA00FFA900FFA300FF9600FF8400FF6C00FF4F00FF2E00FF0900FF001EFF
0049FF0075FF00A2FF00CFFF00FBFF00FFDA00FFB200FF8E00FF6E00FF5100FF3A00FF29
00FF1D00FF1700FF1700FF1D00FF2900FF3B00FF5300FF7000FF9300FFB900FFE300EEFF
00BDFF008BFF0057FF0023FF1000FF4300FF7500FFA500FF
00FF5A00FF8900FFBB00FFEE00DDFF00A9FF0075FF0042FF0011FF1C00FF4700FF6E00FF
9100FFAF00FFC800FFDC00FFE900FFF000FFF200FFED00FFE200FFD100FFBB00FFA000FF
8100FF5D00FF3600FF0C00FF001EFF004BFF0078FF00A5FF00D0FF00F8FF00FFE100FFBF
00FFA100FF8800FF7500FF6700FF5F00FF5E00FF6200FF6D00FF7D00FF9300FFAD00FFCB
00FFEC00EFFF00CAFF00A4FF007FFF005BFF003AFF001DFF0003FF1000FF1F00FF2800FF
2B00FF2700FF1E00FF0F00FF0004FF001CFF0037FF0055FF0073FF0091FF00AEFF00C7FF
00DDFF00EEFF00F9FF00FEFF00FDFF00F6FF00E9FF00D8FF00C3FF00ACFF0095FF007FFF
006CFF005EFF0056FF0053FF0057FF0061FF006FFF007FFF008FFF009BFF00A3FF00A3FF
009DFF0094FF008CFF008BFF008FFF0091FF0089FF0080FF0079FF0078FF007EFF008AFF
0099FF00A9FF00B8FF00C2FF00C8FF00C7FF00BFFF00B2FF00A0FF008BFF0074FF005DFF
0047FF0035FF0028FF001FFF001DFF0021FF002BFF003BFF004FFF0068FF0084FF00A2FF
00C1FF00DEFF00FAFF00FFEC00FFD700FFC700FFBD00FFB800FFBA00FFC200FFCF00FFE3
00FFFB00E7FF00C7FF00A3FF007EFF0059FF0033FF000FFF1200FF3000FF4B00FF6200FF
7300FF7F00FF8500FF8400FF7E00FF7100FF5F00FF4700FF2A00FF0900FF001BFF0044FF
006EFF009AFF00C7FF00F4FF00FFDF00FFB500FF8D00FF6900FF4800FF2C00FF1500FF04
07FF000DFF000DFF0007FF0000FF0400FF1600FF2E00FF4B00FF6D00FF9400FFBE00FFEC
00E3FF00B0FF007DFF0048FF0014FF1E00FF5000FF8000FF
00FF3200FF6100FF9200FFC600FFFA00D1FF009DFF006BFF003AFF000BFF1F00FF4600FF
6900FF8700FFA000FFB300FFC100FFC800FFC900FFC500FFBA00FFA900FF9300FF7800FF
5800FF3500FF0E00FF001BFF0047FF0073FF00A0FF00CDFF00F8FF00FFDE00FFB900FF96
00FF7900FF6000FF4C00FF3F00FF3700FF3600FF3A00FF4500FF5500FF6A00FF8400FFA3
00FFC400FFE800F2FF00CCFF00A7FF0084FF0063FF0045FF002CFF0017FF0008FF0000FF
0200FF0000FF0009FF0018FF002CFF0044FF0060FF007DFF009BFF00B9FF00D6FF00F0FF
00FFFA00FFE900FFDE00FFD900FFDA00FFE100FFEE00FFFF00EBFF00D4FF00BDFF00A7FF
0095FF0086FF007EFF007CFF0080FF0089FF0097FF00A7FF00B7FF00C4FF00CBFF00CBFF
00C5FF00BCFF00B4FF00B3FF00B8FF00B9FF00B2FF00A8FF00A1FF00A0FF00A6FF00B2FF
00C1FF00D1FF00E0FF00EBFF00F0FF00EFFF00E8FF00DAFF00C8FF00B3FF009CFF0085FF
0070FF005EFF0050FF0048FF0045FF0049FF0053FF0063FF0078FF0091FF00ADFF00CAFF
00E9FF00FFF800FFDD00FFC400FFAF00FF9F00FF9500FF9000FF9200FF9900FFA700FFBA
00FFD300FFF000EFFF00CCFF00A7FF0081FF005CFF0038FF0016FF0800FF2300FF3A00FF
4B00FF5700FF5C00FF5C00FF5600FF4900FF3700FF1F00FF0200FF001EFF0044FF006CFF
0096FF00C3FF00F0FF00FFE300FFB700FF8D00FF6500FF4100FF2000FF0412FF0024FF00
30FF0036FF0036FF002FFF0023FF0011FF0000FF0600FF2300FF4500FF6C00FF9600FFC4
00FFF400D9FF00A5FF0071FF003CFF0009FF2800FF5700FF
00FF0700FF3600FF6800FF9B00FFCF00FCFF00C8FF0095FF0064FF0036FF000BFF1B00FF
3E00FF5C00FF7500FF8900FF9600FF9D00FF9F00FF9A00FF8F00FF7E00FF6800FF4D00FF
2E00FF0A00FF001CFF0046FF0071FF009EFF00CBFF00F7FF00FFDD00FFB400FF8E00FF6C
00FF4E00FF3500FF2200FF1400FF0C00FF0B00FF0F00FF1A00FF2A00FF4000FF5A00FF78
00FF9900FFBD00FFE200F7FF00D2FF00AEFF008DFF0070FF0056FF0042FF0033FF002AFF
0027FF002BFF0034FF0043FF0057FF006FFF008AFF00A8FF00C6FF00E4FF00FFFE00FFE5
00FFCF00FFBE00FFB300FFAE00FFAF00FFB600FFC300FFD400FFE900FFFF00E8FF00D2FF
00BFFF00B1FF00A8FF00A6FF00AAFF00B4FF00C2FF00D2FF00E2FF00EEFF00F6FF00F6FF
00F0FF00E7FF00DEFF00DEFF00E2FF00E3FF00DCFF00D3FF00CCFF00CBFF00D1FF00DDFF
00ECFF00FCFF00FFF400FFEA00FFE400FFE500FFED00FFFA00F3FF00DEFF00C7FF00B0FF
009AFF0088FF007BFF0072FF0070FF0074FF007EFF008EFF00A2FF00BBFF00D7FF00F5FF
00FFEB00FFCE00FFB200FF9900FF8400FF7400FF6A00FF6500FF6700FF6F00FF7C00FF90
00FFA800FFC500FFE600F6FF00D1FF00ACFF0086FF0062FF0040FF0021FF0006FF0F00FF
2000FF2C00FF3200FF3100FF2B00FF1E00FF0C00FF000BFF0028FF0049FF006EFF0096FF
00C1FF00EDFF00FFE500FFB800FF8C00FF6200FF3A00FF160AFF0026FF003DFF004EFF00
5AFF0060FF0060FF005AFF004EFF003CFF0024FF0007FF0000FF1A00FF4100FF6B00FF99
00FFC900FFFC00CFFF009BFF0067FF0034FF0002FF2D00FF
24FF0000FF0A00FF3C00FF6F00FFA300FFD700F4FF00C1FF0091FF0062FF0037FF0010FF
1200FF3000FF4900FF5C00FF6A00FF7100FF7200FF6E00FF6300FF5200FF3C00FF2100FF
0100FF0021FF0048FF0072FF009EFF00CAFF00F7FF00FFDB00FFB000FF8800FF6200FF40
00FF2200FF0909FF0017FF001FFF0020FF001CFF0011FF0001FF0000FF1300FF2E00FF4C
00FF6D00FF9100FFB600FFDC00FEFF00DAFF00B9FF009CFF0082FF006EFF005FFF0056FF
0054FF0057FF0060FF006FFF0083FF009BFF00B6FF00D4FF00F2FF00FFEF00FFD200FFB9
00FFA300FF9200FF8700FF8200FF8300FF8A00FF9700FFA800FFBD00FFD400FFEB00FEFF
00EBFF00DDFF00D5FF00D2FF00D7FF00E0FF00EEFF00FEFF00FFF100FFE400FFDD00FFDD
00FFE300FFEC00FFF400FFF500FFF000FFEF00FFF600FFFF00F8FF00F7FF00FDFF00FFF6
00FFE700FFD700FFC800FFBE00FFB800FFB900FFC100FFCE00FFE000FFF500F3FF00DCFF
00C7FF00B4FF00A7FF009EFF009CFF00A0FF00AAFF00BAFF00CFFF00E7FF00FFFC00FFDE
00FFBF00FFA200FF8600FF6D00FF5800FF4800FF3E00FF3900FF3B00FF4300FF5000FF64
00FF7C00FF9900FFB900FFDC00FEFF00D8FF00B3FF008EFF006DFF004EFF0033FF001CFF
000BFF0000FF0500FF0500FF0000FF000DFF001FFF0037FF0054FF0075FF009AFF00C3FF
00EDFF00FFE500FFB900FF8C00FF6000FF3600FF0E15FF0036FF0052FF0069FF007BFF00
87FF008DFF008CFF0086FF007AFF0068FF0050FF0033FF0011FF0000FF1500FF3F00FF6D
00FF9D00FFD000FCFF00C7FF0093FF0060FF002EFF0000FF
51FF0022FF0000FF0F00FF4200FF7600FFAA00FFDE00EEFF00BDFF008FFF0064FF003DFF
001AFF0300FF1C00FF2F00FF3D00FF4400FF4600FF4100FF3600FF2500FF0F00FF000BFF
002AFF004EFF0075FF009FFF00CBFF00F7FF00FFDB00FFAE00FF8300FF5B00FF3500FF13
0AFF0023FF0036FF0044FF004CFF004DFF0049FF003EFF002EFF0018FF0000FF0100FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF800E6FF00C9FF00AFFF009BFF008CFF0083FF
0080FF0084FF008DFF009CFF00B0FF00C8FF00E3FF00FFFE00FFE000FFC200FFA500FF8C
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE700FFF500FFFD00FFFF00FFFC00FFF200FFE400FFD400FFC400FFB800FFB000FFB0
00FFB600FFBF00FFC700FFC800FFC300FFC200FFC900FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9100FF8B00FF8C00FF9400FFA100FFB300FFC800FFDF00FFF6
00F4FF00E1FF00D4FF00CBFF00C9FF00CDFF00D7FF00E7FF00FBFF00FFEB00FFCF00FFB1
00FF9200FF7500FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1600FF2300FF37
00FF4F00FF6C00FF8C00FFB000FFD400FFFA00E0FF00BBFF0099FF007BFF0060FF0049FF
0038FF002CFF0026FF0027FF002DFF003AFF004CFF0064FF0081FF00A2FF00C7FF00F0FF
00FFE500FFB900FF8C00FF5F00FF3300FF091EFF0042FF0063FF007FFF0096FF00A7FF00
B3FF00B9FF00B9FF00B3FF00A7FF0095FF007DFF0060FF003EFF0017FF0000FF1200FF40
00FF7000FFA300FFD600F4FF00C0FF008DFF005BFF002BFF
7EFF004FFF001DFF0000FF1500FF4900FF7D00FFB100FFE400EAFF00BCFF0091FF006AFF
0047FF0028FF0010FF0300FF1000FF1700FF1900FF1400FF0900FF0006FF001DFF0038FF
0057FF007BFF00A2FF00CCFF00F7FF00FFDB00FFAE00FF8200FF5700FF2E00FF0819FF00
37FF0050FF0063FF0071FF0079FF007AFF0076FF006BFF005BFF0045FF002BFF000DFF00
00FF1300FF3700FF5C00FF8200FFA700FFCB00FFEC00F6FF00DCFF00C8FF00B9FF00B0FF
00ADFF00B1FF00BAFF00C9FF00DDFF00F5FF00FFEF00FFD100FFB300FF9500FF7800FF5F
00FF4900FF3800FF2D00FF2800FF2900FF3000FF3D00FF4F00FF6300FF7A00FF9100FFA7
00FFBA00FFC800FFD100FFD300FFCF00FFC500FFB700FFA700FF9700FF8B00FF8400FF83
00FF8900FF9300FF9B00FF9B00FF9700FF9600FF9D00FFA600FFAD00FFAE00FFA800FF9C
00FF8D00FF7D00FF6E00FF6400FF5F00FF5F00FF6700FF7400FF8600FF9B00FFB200FFC9
00FFDF00FFF100FFFF00F8FF00F6FF00FAFF00FFFB00FFEC00FFD700FFBE00FFA200FF84
00FF6600FF4800FF2C00FF1301FF0011FF001BFF0020FF001EFF0016FF0008FF0000FF0A
00FF2200FF3F00FF6000FF8300FFA800FFCD00FFF300E8FF00C6FF00A7FF008CFF0076FF
0065FF0059FF0053FF0054FF005AFF0067FF0079FF0091FF00AEFF00CFFF00F4FF00FFE3
00FFB800FF8C00FF5F00FF3200FF0623FF004BFF006FFF0090FF00ACFF00C3FF00D4FF00
E0FF00E6FF00E6FF00E0FF00D4FF00C2FF00AAFF008DFF006BFF0044FF001AFF0000FF13
00FF4300FF7600FFAA00FFDE00EDFF00BAFF0088FF0058FF
AAFF007AFF0049FF0016FF0000FF1D00FF5100FF8500FFB800FFE900E8FF00BDFF0095FF
0073FF0054FF003BFF0028FF001BFF0013FF0012FF0017FF0022FF0032FF0048FF0063FF
0083FF00A7FF00CEFF00F8FF00FFDC00FFAF00FF8200FF5600FF2B00FF0223FF0045FF00
63FF007CFF008FFF009DFF00A4FF00A6FF00A1FF0097FF0087FF0071FF0057FF0039FF00
17FF0000FF0B00FF3100FF5600FF7B00FF9F00FFC000FFDE00FFF700F4FF00E5FF00DCFF
00D9FF00DDFF00E6FF00F5FF00FFF600FFDE00FFC300FFA500FF8700FF6900FF4D00FF33
00FF1D00FF0C00FF0103FF0002FF0000FF0500FF1100FF2300FF3800FF4E00FF6500FF7B
00FF8E00FF9C00FFA500FFA700FFA300FF9900FF8B00FF7B00FF6B00FF5F00FF5800FF57
00FF5D00FF6700FF6F00FF6F00FF6B00FF6A00FF7100FF7A00FF8100FF8200FF7C00FF71
00FF6100FF5100FF4300FF3800FF3300FF3400FF3B00FF4800FF5A00FF6F00FF8600FF9D
00FFB300FFC500FFD300FFDB00FFDD00FFD900FFCF00FFC000FFAB00FF9200FF7600FF58
00FF3A00FF1C00FF0018FF002CFF003CFF0047FF004BFF004AFF0042FF0034FF0021FF00
09FF0000FF1300FF3400FF5700FF7C00FFA100FFC700FFEB00F2FF00D3FF00B8FF00A2FF
0091FF0085FF007FFF007FFF0086FF0092FF00A5FF00BDFF00DAFF00FBFF00FFDF00FFB7
00FF8C00FF6000FF3300FF0625FF004FFF0077FF009BFF00BBFF00D7FF00EFFF00FFFF00
FFF300FFED00FFED00FFF300FFFF00EDFF00D6FF00B8FF0096FF0070FF0045FF0018FF00
00FF1800FF4A00FF7E00FFB200FFE600E6FF00B4FF0084FF
D4FF00A5FF0073FF0040FF000CFF0000FF2700FF5B00FF8E00FFBF00FFED00E7FF00C0FF
009DFF007FFF0066FF0052FF0045FF003EFF003CFF0041FF004CFF005CFF0073FF008EFF
00ADFF00D1FF00F8FF00FFDD00FFB200FF8500FF5800FF2C00FF0127FF004DFF006FFF00
8DFF00A6FF00B9FF00C7FF00CFFF00D0FF00CCFF00C1FF00B1FF009BFF0081FF0063FF00
42FF001EFF0000FF0600FF2C00FF5100FF7500FF9600FFB300FFCD00FFE100FFF000FFF9
00FFFC00FFF800FFEF00FFE000FFCC00FFB400FF9900FF7B00FF5D00FF3F00FF2200FF09
0CFF001DFF0028FF002DFF002CFF0025FF0018FF0006FF0000FF0D00FF2400FF3B00FF51
00FF6400FF7200FF7B00FF7D00FF7900FF6F00FF6100FF5100FF4100FF3500FF2E00FF2D
00FF3300FF3C00FF4500FF4500FF4100FF4000FF4700FF5000FF5700FF5800FF5200FF46
00FF3700FF2700FF1800FF0E00FF0800FF0900FF1100FF1E00FF3000FF4500FF5C00FF73
00FF8900FF9B00FFA900FFB100FFB300FFAF00FFA500FF9600FF8100FF6800FF4C00FF2E
00FF100DFF0029FF0042FF0057FF0067FF0071FF0076FF0074FF006CFF005EFF004BFF00
33FF0016FF0000FF0A00FF2D00FF5200FF7700FF9D00FFC100FFE300FDFF00E2FF00CCFF
00BBFF00AFFF00A9FF00AAFF00B0FF00BDFF00CFFF00E7FF00FFFB00FFDA00FFB500FF8D
00FF6200FF3600FF0923FF004FFF0079FF00A1FF00C5FF00E6FF00FFFD00FFE600FFD500
FFC900FFC300FFC300FFC900FFD500FFE700FFFF00E3FF00C1FF009AFF0070FF0042FF00
12FF0000FF2000FF5400FF8800FFBC00FFEF00DEFF00AEFF
FBFF00CCFF009BFF0068FF0034FF0000FF0000FF3400FF6600FF9700FFC500FFF000E7FF
00C4FF00A6FF008DFF007AFF006DFF0065FF0064FF0069FF0074FF0084FF009AFF00B5FF
00D5FF00F9FF00FFDF00FFB600FF8A00FF5D00FF3000FF0426FF004FFF0075FF0097FF00
B5FF00CDFF00E1FF00EFFF00F6FF00F8FF00F3FF00E9FF00D8FF00C3FF00A9FF008BFF00
69FF0045FF0020FF0000FF0400FF2A00FF4D00FF6E00FF8C00FFA500FFBA00FFC800FFD1
00FFD400FFD100FFC700FFB800FFA500FF8C00FF7100FF5400FF3500FF1704FF001EFF00
33FF0044FF004FFF0055FF0053FF004CFF003FFF002EFF0019FF0002FF0000FF1400FF2A
00FF3C00FF4A00FF5300FF5500FF5100FF4700FF3900FF2900FF1A00FF0D00FF0600FF05
00FF0B00FF1500FF1D00FF1E00FF1900FF1800FF1F00FF2900FF3000FF3100FF2B00FF1F
00FF1000FF000EFF0019FF001EFF001DFF0016FF0009FF0000FF0800FF1E00FF3500FF4C
00FF6100FF7300FF8100FF8900FF8C00FF8800FF7E00FF6E00FF5900FF4000FF2400FF06
17FF0035FF0051FF0069FF007EFF008EFF0099FF009DFF009CFF0094FF0086FF0073FF00
5AFF003DFF001DFF0000FF0500FF2A00FF5000FF7500FF9900FFBB00FFDA00FFF500F4FF
00E2FF00D7FF00D1FF00D1FF00D8FF00E4FF00F7FF00FFF100FFD400FFB200FF8D00FF65
00FF3A00FF0E1EFF004BFF0077FF00A1FF00C8FF00EDFF00FFF200FFD600FFBF00FFAD00
FFA100FF9B00FF9B00FFA100FFAE00FFC000FFD800FFF500E8FF00C2FF0097FF006AFF00
39FF0007FF0000FF2C00FF6000FF9400FFC800FFFA00D6FF
FFDF00F1FF00BFFF008CFF0058FF0024FF0000FF0F00FF4200FF7300FFA100FFCC00FFF3
00E9FF00CBFF00B2FF009EFF0091FF008AFF0088FF008DFF0098FF00A8FF00BFFF00DAFF
00F9FF00FFE200FFBB00FF9100FF6600FF3900FF0C1FFF004AFF0073FF0099FF00BBFF00
D9FF00F2FF00FFFA00FFEC00FFE400FFE300FFE700FFF200FDFF00E7FF00CDFF00AFFF00
8EFF006AFF0045FF001FFF0000FF0500FF2900FF4A00FF6700FF8100FF9500FFA400FFAD
00FFB000FFAC00FFA300FF9400FF8000FF6800FF4D00FF2F00FF110CFF0029FF0042FF00
58FF0069FF0074FF0079FF0078FF0071FF0064FF0052FF003EFF0027FF0010FF0000FF05
00FF1800FF2600FF2F00FF3100FF2D00FF2300FF1500FF050AFF0016FF001EFF001EFF00
18FF000FFF0006FF0006FF000AFF000BFF0004FF0000FF0400FF0B00FF0C00FF0605FF00
14FF0024FF0033FF003DFF0043FF0042FF003AFF002DFF001BFF0006FF0000FF1000FF27
00FF3D00FF4F00FF5D00FF6500FF6700FF6300FF5900FF4A00FF3500FF1C00FF001DFF00
3BFF0059FF0075FF008EFF00A3FF00B3FF00BDFF00C2FF00C0FF00B8FF00AAFF0097FF00
7FFF0062FF0041FF001EFF0000FF0600FF2B00FF5100FF7500FF9700FFB600FFD100FFE7
00FFF800FBFF00F5FF00F6FF00FCFF00FFF600FFE400FFCC00FFAF00FF8E00FF6900FF41
00FF1615FF0042FF006FFF009BFF00C5FF00EDFF00FFEE00FFCD00FFB100FF9A00FF8900
FF7D00FF7700FF7700FF7D00FF8900FF9B00FFB300FFD000FFF200E6FF00BCFF008EFF00
5EFF002BFF0000FF0800FF3C00FF7000FFA300FFD500FAFF
FFBF00FFEE00E0FF00ADFF0079FF0044FF0010FF0000FF2100FF5200FF8000FFAC00FFD3
00FFF600EBFF00D2FF00BFFF00B1FF00AAFF00A9FF00AEFF00B8FF00C9FF00DFFF00FAFF
00FFE500FFC100FF9A00FF7100FF4500FF1814FF0040FF006BFF0094FF00BAFF00DCFF00
F9FF00FFED00FFD900FFCC00FFC400FFC200FFC700FFD200FFE200FFF700EEFF00CFFF00
AEFF008AFF0065FF003FFF001AFF0000FF0800FF2900FF4700FF6000FF7500FF8300FF8C
00FF8F00FF8C00FF8200FF7400FF6000FF4800FF2C00FF0F0FFF002DFF0049FF0063FF00
78FF0089FF0094FF0099FF0098FF0091FF0084FF0073FF005EFF0047FF0030FF001AFF00
08FF0000FF0600FF0E00FF1000FF0C00FF020AFF001BFF002AFF0037FF003EFF003EFF00
39FF002FFF0027FF0026FF002BFF002CFF0025FF001BFF0014FF0013FF0019FF0025FF00
34FF0045FF0053FF005EFF0063FF0062FF005BFF004EFF003CFF0026FF000FFF0000FF07
00FF1C00FF2E00FF3C00FF4400FF4700FF4300FF3900FF2900FF1404FF0020FF003EFF00
5CFF007AFF0096FF00AEFF00C3FF00D3FF00DEFF00E2FF00E0FF00D9FF00CBFF00B8FF00
9FFF0082FF0062FF003FFF001AFF0000FF0B00FF3000FF5400FF7600FF9500FFB000FFC6
00FFD800FFE300FFE900FFE900FFE200FFD600FFC400FFAC00FF8F00FF6E00FF4800FF20
0AFF0036FF0063FF0090FF00BBFF00E6FF00FFF200FFCD00FFAD00FF9100FF7A00FF6800
FF5C00FF5600FF5600FF5D00FF6900FF7B00FF9300FFB000FFD200FFF800DCFF00AEFF00
7EFF004CFF0018FF0000FF1B00FF4F00FF8300FFB500FFE4
FFA300FFD200FCFF00C9FF0095FF0060FF002CFF0000FF0500FF3600FF6400FF9000FFB7
00FFDA00FFF800EEFF00DBFF00CDFF00C6FF00C5FF00CAFF00D4FF00E5FF00FBFF00FFE9
00FFC900FFA500FF7E00FF5500FF2903FF0030FF005CFF0087FF00B0FF00D6FF00F8FF00
FFE900FFD100FFBD00FFB000FFA800FFA600FFAB00FFB500FFC600FFDB00FFF500ECFF00
CAFF00A6FF0081FF005BFF0036FF0013FF0000FF0D00FF2B00FF4400FF5900FF6700FF70
00FF7300FF7000FF6600FF5800FF4400FF2C00FF100CFF002BFF0049FF0065FF007FFF00
94FF00A5FF00B0FF00B6FF00B4FF00ADFF00A0FF008FFF007AFF0063FF004CFF0036FF00
24FF0016FF000DFF000BFF000FFF0019FF0026FF0037FF0046FF0053FF005AFF005AFF00
55FF004BFF0043FF0042FF0047FF0048FF0041FF0037FF0030FF002FFF0035FF0041FF00
50FF0061FF006FFF007AFF007FFF007EFF0077FF006AFF0058FF0042FF002BFF0014FF00
00FF0000FF1200FF2000FF2800FF2B00FF2700FF1D00FF0D07FF0020FF003CFF005AFF00
78FF0096FF00B2FF00CAFF00DFFF00EFFF00FAFF00FEFF00FDFF00F5FF00E7FF00D4FF00
BBFF009EFF007EFF005BFF0036FF0010FF0000FF1400FF3800FF5A00FF7900FF9400FFAA
00FFBC00FFC700FFCD00FFCD00FFC600FFBA00FFA700FF9000FF7300FF5100FF2C00FF04
26FF0052FF007FFF00ACFF00D7FF00FFFD00FFD600FFB100FF9100FF7500FF5E00FF4C00
FF4000FF3A00FF3A00FF4000FF4D00FF5F00FF7700FF9400FFB600FFDC00F8FF00CAFF00
9AFF0068FF0034FF0000FF0000FF3300FF6700FF9900FFC8
FF8C00FFBB00FFEC00E0FF00ACFF0077FF0043FF0011FF0000FF1F00FF4D00FF7800FFA0
00FFC300FFE100FFFA00F2FF00E5FF00DDFF00DCFF00E1FF00ECFF00FCFF00FFED00FFD2
00FFB200FF8E00FF6700FF3E00FF121AFF0047FF0073FF009EFF00C7FF00EDFF00FFF000
FFD200FFBA00FFA600FF9800FF9100FF8F00FF9400FF9E00FFAF00FFC400FFDE00FFFC00
E1FF00BDFF0098FF0073FF004DFF002AFF0009FF0000FF1400FF2D00FF4200FF5000FF59
00FF5C00FF5900FF4F00FF4000FF2D00FF1406FF0023FF0042FF0060FF007CFF0096FF00
ABFF00BCFF00C7FF00CDFF00CBFF00C4FF00B7FF00A6FF0091FF007AFF0063FF004DFF00
3BFF002DFF0024FF0022FF0026FF0030FF003EFF004EFF005DFF006AFF0071FF0072FF00
6CFF0062FF005AFF0059FF005EFF005FFF0058FF004EFF0047FF0046FF004CFF0058FF00
67FF0078FF0086FF0091FF0096FF0095FF008EFF0081FF006FFF0059FF0042FF002BFF00
16FF0004FF0000FF0900FF1100FF1400FF1000FF0609FF001EFF0037FF0053FF0071FF00
8FFF00ADFF00C9FF00E1FF00F6FF00FFF900FFEE00FFEA00FFEB00FFF300FEFF00EBFF00
D2FF00B5FF0095FF0072FF004DFF0027FF0002FF0000FF2100FF4300FF6200FF7D00FF93
00FFA500FFB000FFB600FFB600FFAF00FFA300FF9000FF7900FF5C00FF3A00FF1512FF00
3DFF0069FF0096FF00C3FF00EFFF00FFE600FFBF00FF9A00FF7A00FF5E00FF4700FF3500
FF2900FF2300FF2300FF2900FF3600FF4800FF6000FF7D00FF9F00FFC500FFF000E2FF00
B1FF007FFF004BFF0017FF0000FF1C00FF5000FF8200FFB1
FF7A00FFA900FFDB00F1FF00BDFF0089FF0055FF0022FF0000FF0D00FF3C00FF6700FF8E
00FFB100FFCF00FFE800FFFB00F6FF00EFFF00EEFF00F2FF00FDFF00FFF100FFDB00FFC0
00FFA000FF7D00FF5600FF2C00FF002BFF0058FF0085FF00B0FF00D9FF00FEFF00FFDF00
FFC100FFA800FF9400FF8700FF7F00FF7E00FF8200FF8D00FF9D00FFB200FFCD00FFEB00
F3FF00CFFF00AAFF0084FF005FFF003BFF001AFF0000FF0200FF1B00FF3000FF3F00FF48
00FF4A00FF4700FF3E00FF2F00FF1B00FF0317FF0035FF0053FF0071FF008EFF00A7FF00
BDFF00CEFF00D9FF00DEFF00DDFF00D6FF00C9FF00B8FF00A3FF008CFF0075FF005FFF00
4CFF003EFF0036FF0033FF0038FF0041FF004FFF005FFF006FFF007CFF0083FF0083FF00
7DFF0074FF006CFF006BFF0070FF0071FF006AFF0060FF0059FF0058FF005EFF006AFF00
79FF0089FF0098FF00A3FF00A8FF00A7FF009FFF0092FF0080FF006BFF0054FF003DFF00
28FF0015FF0008FF0000FF0000FF0201FF000BFF001BFF0030FF0049FF0065FF0082FF00
A1FF00BEFF00DAFF00F3FF00FFF700FFE700FFDD00FFD800FFDA00FFE200FFEF00FCFF00
E4FF00C7FF00A7FF0084FF005FFF0039FF0014FF0000FF0F00FF3100FF5000FF6B00FF82
00FF9300FF9F00FFA400FFA400FF9E00FF9100FF7F00FF6700FF4A00FF2900FF0424FF00
4EFF007BFF00A7FF00D4FF00FFFF00FFD500FFAD00FF8900FF6800FF4C00FF3500FF2300
FF1700FF1100FF1200FF1800FF2400FF3600FF4E00FF6B00FF8D00FFB400FFDE00F3FF00
C3FF0090FF005DFF0028FF0000FF0B00FF3E00FF7000FF9F
FF6E00FF9D00FFCF00FDFF00C9FF0095FF0061FF002EFF0000FF0100FF3000FF5B00FF82
00FFA500FFC300FFDC00FFEF00FFFD00FBFF00FAFF00FEFF00FFF600FFE500FFCF00FFB4
00FF9400FF7100FF4A00FF200BFF0037FF0064FF0091FF00BCFF00E4FF00FFF500FFD300
FFB500FF9C00FF8900FF7B00FF7300FF7200FF7600FF8100FF9100FFA600FFC100FFDF00
FFFF00DBFF00B6FF0090FF006BFF0047FF0026FF0009FF0000FF1000FF2400FF3300FF3C
00FF3E00FF3B00FF3200FF2300FF0F08FF0023FF0041FF005FFF007DFF009AFF00B3FF00
C9FF00DAFF00E5FF00EAFF00E9FF00E2FF00D5FF00C4FF00AFFF0098FF0081FF006BFF00
58FF004AFF0042FF003FFF0044FF004DFF005BFF006BFF007BFF0088FF008FFF008FFF00
89FF0080FF0078FF0077FF007CFF007DFF0076FF006CFF0065FF0064FF006AFF0076FF00
85FF0095FF00A4FF00AEFF00B4FF00B3FF00ABFF009EFF008CFF0077FF0060FF0049FF00
34FF0021FF0014FF000BFF0009FF000DFF0017FF0027FF003CFF0054FF0070FF008EFF00
ADFF00CAFF00E6FF00FFFF00FFEB00FFDB00FFD100FFCC00FFCE00FFD600FFE300FFF700
F0FF00D3FF00B3FF0090FF006BFF0045FF0020FF0000FF0400FF2500FF4400FF5F00FF76
00FF8700FF9300FF9800FF9800FF9200FF8500FF7300FF5B00FF3E00FF1D07FF0030FF00
5AFF0087FF00B3FF00E0FF00FFF300FFC900FFA100FF7D00FF5C00FF4000FF2900FF1700
FF0B00FF0500FF0600FF0C00FF1800FF2A00FF4200FF5F00FF8100FFA800FFD200FFFF00
CFFF009CFF0069FF0034FF0000FF0000FF3200FF6400FF94
FF6800FF9700FFC900FFFC00CFFF009BFF0067FF0034FF0004FF0000FF2A00FF5500FF7C
00FF9F00FFBD00FFD600FFE900FFF700FFFE00FFFF00FFFB00FFF000FFDF00FFC900FFAE
00FF8E00FF6B00FF4400FF1A11FF003DFF006AFF0097FF00C2FF00EAFF00FFEF00FFCD00
FFAF00FF9600FF8300FF7500FF6D00FF6C00FF7000FF7B00FF8B00FFA000FFBB00FFD900
FFFA00E1FF00BCFF0096FF0071FF004DFF002CFF000FFF0000FF0A00FF1E00FF2D00FF36
00FF3800FF3500FF2C00FF1D00FF090EFF0029FF0047FF0065FF0083FF00A0FF00B9FF00
CFFF00E0FF00EBFF00F0FF00EFFF00E8FF00DBFF00CAFF00B5FF009EFF0087FF0071FF00
5EFF0050FF0048FF0045FF004AFF0053FF0061FF0071FF0081FF008EFF0095FF0095FF00
8FFF0086FF007EFF007DFF0082FF0083FF007CFF0072FF006BFF006AFF0070FF007CFF00
8BFF009BFF00AAFF00B4FF00BAFF00B9FF00B1FF00A4FF0092FF007DFF0066FF004FFF00
3AFF0027FF001AFF0011FF000FFF0013FF001DFF002DFF0042FF005AFF0076FF0094FF00
B3FF00D0FF00ECFF00FFFA00FFE500FFD500FFCB00FFC600FFC800FFD000FFDD00FFF100
F6FF00D9FF00B9FF0096FF0071FF004BFF0026FF0001FF0000FF1F00FF3E00FF5900FF70
00FF8100FF8D00FF9200FF9200FF8C00FF7F00FF6D00FF5500FF3800FF170DFF0036FF00
60FF008DFF00B9FF00E6FF00FFED00FFC300FF9B00FF7700FF5600FF3A00FF2300FF1100
FF0500000000000000FF0600FF1200FF2400FF3C00FF5900FF7B00FFA200FFCC00FFFA00
D5FF00A2FF006FFF003AFF0006FF0000FF2C00FF5E00FF8E
FF6800FF9700FFC900FFFC00CFFF009BFF0067FF0034FF0003FF0000FF2A00FF5500FF7C
00FF9F00FFBD00FFD600FFEA00FFF700FFFE00FFFF00FFFB00FFF000FFDF00FFC900FFAE
00FF8F00FF6B00FF4400FF1A10FF003DFF006AFF0097FF00C2FF00EAFF00FFEF00FFCD00
FFAF00FF9600FF8300FF7500FF6D00FF6C00FF7000FF7B00FF8B00FFA100FFBB00FFD900
FFFA00E1FF00BCFF0096FF0071FF004DFF002CFF000FFF0000FF0A00FF1E00FF2D00FF36
00FF3900FF3500FF2C00FF1D00FF090EFF0029FF0047FF0065FF0083FF00A0FF00B9FF00
CFFF00E0FF00EBFF00F0FF00EFFF00E8FF00DBFF00CAFF00B5FF009EFF0087FF0071FF00
5EFF0050FF0048FF0045FF0049FF0053FF0061FF0071FF0081FF008DFF0095FF0095FF00
8FFF0086FF007EFF007DFF0082FF0083FF007CFF0072FF006BFF006AFF0070FF007CFF00
8BFF009BFF00AAFF00B4FF00BAFF00B9FF00B1FF00A4FF0092FF007DFF0066FF004FFF00
3AFF0027FF001AFF0011FF000FFF0013FF001DFF002DFF0041FF005AFF0076FF0094FF00
B3FF00D0FF00ECFF00FFFA00FFE500FFD500FFCB00FFC600FFC800FFD000FFDD00FFF100
F6FF00D9FF00B9FF0095FF0071FF004BFF0026FF0001FF0000FF2000FF3E00FF5900FF70
00FF8100FF8D00FF9300FF9200FF8C00FF7F00FF6D00FF5500FF3800FF170DFF0036FF00
60FF008CFF00B9FF00E6FF00FFED00FFC300FF9B00FF7700FF5600FF3A00FF2300FF1200
FF0600000000000000FF0600FF1200FF2400FF3C00FF5900FF7B00FFA200FFCC00FFFA00
D5FF00A2FF006FFF003AFF0006FF0000FF2C00FF5E00FF8E
FF6E00FF9D00FFCF00FDFF00C9FF0095FF0061FF002EFF0000FF0200FF3000FF5B00FF82
00FFA500FFC400FFDC00FFF000FFFD00FAFF00F9FF00FEFF00FFF600FFE600FFD000FFB4
00FF9500FF7100FF4A00FF200AFF0037FF0064FF0090FF00BBFF00E4FF00FFF500FFD300
FFB500FF9C00FF8900FF7B00FF7300FF7200FF7700FF8100FF9100FFA700FFC100FFDF00
FFFF00DBFF00B6FF0090FF006BFF0047FF0026FF0009FF0000FF1000FF2400FF3300FF3C
00FF3F00FF3B00FF3200FF2300FF0F08FF0023FF0041FF005FFF007DFF0099FF00B3FF00
C9FF00DAFF00E5FF00EAFF00E9FF00E2FF00D5FF00C3FF00AFFF0098FF0081FF006BFF00
58FF004AFF0041FF003FFF0043FF004DFF005BFF006BFF007BFF0087FF008EFF008FFF00
89FF007FFF0077FF0077FF007BFF007CFF0075FF006CFF0065FF0064FF006AFF0075FF00
85FF0095FF00A4FF00AEFF00B3FF00B2FF00ABFF009EFF008CFF0077FF0060FF0049FF00
33FF0021FF0013FF000BFF0009FF000DFF0017FF0026FF003BFF0054FF0070FF008EFF00
ACFF00CAFF00E6FF00FFFF00FFEB00FFDC00FFD100FFCD00FFCE00FFD600FFE400FFF700
F0FF00D3FF00B2FF008FFF006AFF0045FF001FFF0000FF0400FF2600FF4500FF6000FF76
00FF8700FF9300FF9900FF9800FF9200FF8500FF7300FF5B00FF3E00FF1D07FF002FFF00
5AFF0086FF00B3FF00E0FF00FFF300FFC900FFA100FF7D00FF5D00FF4000FF2900FF1800
FF0C00FF0600FF0600FF0C00FF1800FF2A00FF4200FF5F00FF8200FFA800FFD200FFFF00
CEFF009CFF0068FF0034FF0000FF0000FF3200FF6400FF94
FF7B00FFAA00FFDB00F1FF00BDFF0088FF0055FF0022FF0000FF0E00FF3C00FF6700FF8F
00FFB200FFD000FFE900FFFC00F6FF00EEFF00EDFF00F2FF00FDFF00FFF200FFDC00FFC1
00FFA100FF7D00FF5600FF2D00FF012BFF0058FF0084FF00AFFF00D8FF00FEFF00FFDF00
FFC100FFA800FF9500FF8700FF8000FF7E00FF8300FF8D00FF9E00FFB300FFCD00FFEB00
F2FF00CEFF00A9FF0084FF005EFF003BFF001AFF0000FF0300FF1C00FF3000FF3F00FF48
00FF4B00FF4800FF3E00FF2F00FF1B00FF0317FF0034FF0053FF0071FF008DFF00A7FF00
BDFF00CDFF00D9FF00DEFF00DCFF00D5FF00C9FF00B7FF00A2FF008CFF0074FF005FFF00
4CFF003EFF0035FF0033FF0037FF0041FF004FFF005FFF006EFF007BFF0082FF0083FF00
7DFF0073FF006BFF006AFF006FFF0070FF0069FF005FFF0058FF0058FF005EFF0069FF00
78FF0089FF0097FF00A2FF00A7FF00A6FF009FFF0092FF0080FF006AFF0053FF003CFF00
27FF0015FF0007FF0000FF0000FF0300FF000AFF001AFF002FFF0048FF0064FF0082FF00
A0FF00BEFF00DAFF00F2FF00FFF800FFE800FFDD00FFD900FFDA00FFE200FFF000FCFF00
E3FF00C7FF00A6FF0083FF005EFF0038FF0013FF0000FF1000FF3200FF5100FF6C00FF82
00FF9400FF9F00FFA500FFA500FF9E00FF9200FF7F00FF6800FF4B00FF2900FF0423FF00
4EFF007AFF00A7FF00D4FF00FFFF00FFD500FFAE00FF8900FF6900FF4D00FF3600FF2400
FF1800FF1200FF1200FF1800FF2500FF3700FF4F00FF6C00FF8E00FFB400FFDF00F3FF00
C2FF0090FF005CFF0028FF0000FF0B00FF3F00FF7000FFA0
FF8D00FFBC00FFED00DFFF00ABFF0076FF0042FF0010FF0000FF2000FF4E00FF7A00FFA1
00FFC400FFE200FFFB00F1FF00E3FF00DCFF00DBFF00E0FF00EAFF00FBFF00FFEE00FFD3
00FFB300FF8F00FF6800FF3F00FF1319FF0046FF0072FF009DFF00C6FF00ECFF00FFF100
FFD300FFBB00FFA700FF9A00FF9200FF9000FF9500FF9F00FFB000FFC500FFDF00FFFD00
E0FF00BCFF0097FF0071FF004CFF0029FF0008FF0000FF1500FF2E00FF4300FF5100FF5A
00FF5D00FF5A00FF5000FF4200FF2E00FF1605FF0022FF0041FF005FFF007BFF0095FF00
AAFF00BBFF00C6FF00CBFF00CAFF00C3FF00B6FF00A5FF0090FF0079FF0062FF004CFF00
3AFF002BFF0023FF0021FF0025FF002FFF003CFF004DFF005CFF0069FF0070FF0070FF00
6BFF0061FF0059FF0058FF005DFF005EFF0057FF004DFF0046FF0045FF004BFF0057FF00
66FF0077FF0085FF0090FF0095FF0094FF008DFF0080FF006EFF0058FF0041FF002AFF00
15FF0003FF0000FF0A00FF1200FF1500FF1100FF0708FF001DFF0036FF0052FF0070FF00
8EFF00ACFF00C8FF00E0FF00F5FF00FFFA00FFEF00FFEB00FFED00FFF400FDFF00EAFF00
D1FF00B4FF0094FF0071FF004CFF0026FF0001FF0000FF2200FF4400FF6300FF7E00FF94
00FFA600FFB100FFB700FFB700FFB000FFA400FF9200FF7A00FF5D00FF3B00FF1611FF00
3CFF0068FF0095FF00C2FF00EDFF00FFE700FFC000FF9B00FF7B00FF5F00FF4800FF3600
FF2A00FF2400FF2400FF2A00FF3700FF4900FF6100FF7E00FFA000FFC600FFF100E0FF00
B0FF007EFF004AFF0016FF0000FF1D00FF5100FF8300FFB2
FFA500FFD400FAFF00C7FF0093FF005EFF002BFF0000FF0700FF3800FF6600FF9100FFB9
00FFDC00FFFA00ECFF00D9FF00CCFF00C4FF00C3FF00C8FF00D3FF00E3FF00F9FF00FFEB
00FFCB00FFA700FF8000FF5700FF2B01FF002EFF005AFF0085FF00AEFF00D4FF00F6FF00
FFEB00FFD200FFBF00FFB100FFAA00FFA800FFAD00FFB700FFC800FFDD00FFF700EAFF00
C8FF00A5FF007FFF005AFF0034FF0011FF0000FF0F00FF2D00FF4600FF5A00FF6900FF72
00FF7500FF7200FF6800FF5900FF4500FF2D00FF120AFF0029FF0047FF0063FF007DFF00
93FF00A3FF00AFFF00B4FF00B3FF00ABFF009FFF008DFF0078FF0062FF004AFF0035FF00
22FF0014FF000BFF0009FF000DFF0017FF0025FF0035FF0044FF0051FF0058FF0059FF00
53FF0049FF0041FF0040FF0045FF0046FF003FFF0035FF002EFF002EFF0034FF003FFF00
4FFF005FFF006DFF0078FF007DFF007CFF0075FF0068FF0056FF0040FF0029FF0012FF00
00FF0200FF1400FF2200FF2A00FF2D00FF2900FF1F00FF0F05FF001EFF003AFF0058FF00
76FF0094FF00B0FF00C9FF00DDFF00EDFF00F8FF00FCFF00FBFF00F3FF00E5FF00D2FF00
B9FF009DFF007CFF0059FF0034FF000EFF0000FF1600FF3A00FF5C00FF7B00FF9600FFAC
00FFBE00FFC900FFCF00FFCF00FFC800FFBC00FFA900FF9100FF7500FF5300FF2E00FF06
24FF0050FF007DFF00AAFF00D6FF00FFFF00FFD800FFB300FF9300FF7700FF6000FF4E00
FF4200FF3C00FF3C00FF4200FF4F00FF6100FF7900FF9600FFB800FFDE00F6FF00C9FF00
98FF0066FF0032FF0000FF0100FF3500FF6900FF9A00FFCA
FFC200FFF100DDFF00AAFF0076FF0041FF000DFF0000FF2400FF5500FF8300FFAF00FFD6
00FFF900E8FF00CFFF00BCFF00AEFF00A7FF00A6FF00ABFF00B5FF00C6FF00DCFF00F7FF
00FFE800FFC400FF9D00FF7400FF4800FF1B11FF003DFF0068FF0091FF00B7FF00D9FF00
F7FF00FFF000FFDC00FFCF00FFC700FFC500FFCA00FFD400FFE500FFFA00EBFF00CDFF00
ABFF0087FF0062FF003CFF0017FF0000FF0B00FF2C00FF4A00FF6300FF7800FF8600FF8F
00FF9200FF8F00FF8500FF7700FF6300FF4B00FF2F00FF120CFF002AFF0046FF0060FF00
75FF0086FF0091FF0097FF0095FF008EFF0081FF0070FF005BFF0044FF002DFF0017FF00
05FF0000FF0800FF1100FF1300FF0F00FF0508FF0018FF0027FF0034FF003BFF003CFF00
36FF002CFF0024FF0023FF0028FF0029FF0022FF0018FF0011FF0010FF0016FF0022FF00
31FF0042FF0050FF005BFF0060FF005FFF0058FF004BFF0039FF0023FF000CFF0000FF0A
00FF1F00FF3100FF3F00FF4700FF4A00FF4600FF3C00FF2C00FF1701FF001DFF003BFF00
59FF0077FF0093FF00ABFF00C0FF00D0FF00DBFF00DFFF00DEFF00D6FF00C8FF00B5FF00
9CFF007FFF005FFF003CFF0017FF0000FF0E00FF3300FF5700FF7900FF9800FFB300FFC9
00FFDB00FFE600FFEC00FFEC00FFE500FFD900FFC600FFAF00FF9200FF7000FF4B00FF23
07FF0033FF0060FF008DFF00B8FF00E3FF00FFF500FFD000FFB000FF9400FF7D00FF6B00
FF5F00FF5900FF5900FF5F00FF6C00FF7E00FF9600FFB300FFD500FFFB00D9FF00ABFF00
7BFF0049FF0015FF0000FF1E00FF5200FF8600FFB800FFE7
FFE400ECFF00BBFF0088FF0054FF001FFF0000FF1400FF4600FF7700FFA500FFD100FFF8
00E4FF00C6FF00ADFF009AFF008CFF0085FF0084FF0089FF0093FF00A4FF00BAFF00D5FF
00F5FF00FFE700FFBF00FF9600FF6A00FF3D00FF101BFF0046FF006FFF0095FF00B7FF00
D4FF00EDFF00FFFE00FFF100FFE900FFE700FFEC00FFF700F8FF00E3FF00C9FF00AAFF00
89FF0065FF0040FF001AFF0000FF0A00FF2D00FF4E00FF6C00FF8500FF9A00FFA900FFB1
00FFB400FFB100FFA700FF9900FF8500FF6D00FF5100FF3400FF1508FF0024FF003EFF00
53FF0064FF006FFF0074FF0073FF006CFF005FFF004EFF0039FF0022FF000BFF0000FF0A
00FF1C00FF2B00FF3300FF3500FF3100FF2700FF1A00FF0905FF0012FF0019FF0019FF00
14FF000AFF0002FF0001FF0006FF0007FF0000FF0000FF0900FF1000FF1100FF0B00FF00
0FFF0020FF002EFF0039FF003EFF003DFF0036FF0029FF0017FF0001FF0000FF1500FF2C
00FF4100FF5300FF6100FF6900FF6C00FF6800FF5E00FF4E00FF3900FF2000FF0419FF00
37FF0055FF0071FF0089FF009EFF00AEFF00B8FF00BDFF00BBFF00B4FF00A6FF0093FF00
7AFF005DFF003DFF001AFF0000FF0A00FF3000FF5500FF7900FF9B00FFBA00FFD500FFEB
00FFFD00F7FF00F1FF00F1FF00F8FF00FFFB00FFE900FFD100FFB400FF9300FF6D00FF45
00FF1A11FF003EFF006BFF0096FF00C1FF00E8FF00FFF200FFD200FFB600FF9F00FF8D00
FF8100FF7B00FF7B00FF8200FF8E00FFA000FFB800FFD500FFF700E2FF00B7FF0089FF00
59FF0027FF0000FF0C00FF4000FF7400FFA800FFDA00F6FF
F5FF00C6FF0094FF0061FF002DFF0000FF0600FF3A00FF6D00FF9E00FFCC00FFF700E1FF
00BEFF00A0FF0087FF0073FF0066FF005FFF005DFF0062FF006DFF007DFF0094FF00AFFF
00CEFF00F2FF00FFE600FFBC00FF9100FF6400FF3700FF0B1FFF0048FF006EFF0090FF00
AEFF00C7FF00DAFF00E8FF00F0FF00F1FF00EDFF00E2FF00D2FF00BCFF00A2FF0084FF00
63FF003FFF001AFF0000FF0B00FF3000FF5400FF7500FF9200FFAC00FFC000FFCF00FFD8
00FFDB00FFD700FFCE00FFBF00FFAB00FF9300FF7800FF5A00FF3C00FF1E00FF0117FF00
2DFF003EFF0049FF004EFF004DFF0046FF0039FF0027FF0013FF0000FF0300FF1A00FF30
00FF4300FF5100FF5A00FF5C00FF5800FF4E00FF4000FF3000FF2000FF1400FF0D00FF0C
00FF1200FF1B00FF2400FF2400FF2000FF1F00FF2600FF2F00FF3600FF3700FF3100FF25
00FF1600FF0608FF0012FF0018FF0017FF000FFF0002FF0000FF0F00FF2400FF3B00FF52
00FF6800FF7A00FF8800FF9000FF9200FF8E00FF8400FF7500FF6000FF4700FF2B00FF0D
10FF002EFF004AFF0063FF0078FF0088FF0092FF0097FF0095FF008DFF007FFF006CFF00
54FF0037FF0016FF0000FF0C00FF3100FF5600FF7C00FFA000FFC200FFE100FFFC00EDFF
00DCFF00D0FF00CAFF00CBFF00D1FF00DEFF00F0FF00FFF700FFDA00FFB900FF9400FF6C
00FF4100FF1517FF0044FF0070FF009AFF00C2FF00E6FF00FFF800FFDC00FFC500FFB400
FFA800FFA200FFA200FFA800FFB400FFC600FFDE00FFFB00E2FF00BBFF0091FF0063FF00
33FF0000FF0000FF3300FF6700FF9B00FFCE00FFFF00CFFF
CAFF009BFF006AFF0037FF0003FF0000FF3100FF6500FF9700FFC800FFF600DEFF00B6FF
0093FF0075FF005CFF0049FF003CFF0034FF0033FF0038FF0042FF0053FF0069FF0084FF
00A4FF00C8FF00EFFF00FFE700FFBB00FF8E00FF6100FF3500FF0A1EFF0044FF0066FF00
84FF009CFF00B0FF00BEFF00C5FF00C7FF00C2FF00B8FF00A7FF0092FF0078FF005AFF00
38FF0014FF0000FF1000FF3600FF5B00FF7E00FF9F00FFBD00FFD600FFEB00FFF900FDFF
00FAFF00FDFF00FFF800FFE900FFD600FFBE00FFA200FF8500FF6600FF4800FF2C00FF12
02FF0013FF001EFF0024FF0022FF001BFF000EFF0000FF0200FF1700FF2E00FF4500FF5B
00FF6D00FF7B00FF8400FF8600FF8200FF7800FF6A00FF5A00FF4B00FF3E00FF3700FF36
00FF3C00FF4600FF4E00FF4F00FF4A00FF4900FF5000FF5A00FF6100FF6200FF5C00FF50
00FF4100FF3000FF2200FF1700FF1200FF1300FF1A00FF2700FF3900FF4F00FF6600FF7D
00FF9200FFA400FFB200FFBA00FFBD00FFB900FFAF00FF9F00FF8A00FF7100FF5500FF37
00FF1904FF0020FF0038FF004DFF005DFF0068FF006CFF006BFF0063FF0055FF0042FF00
29FF000CFF0000FF1300FF3600FF5B00FF8100FFA600FFCA00FFEC00F4FF00D9FF00C3FF
00B1FF00A6FF00A0FF00A0FF00A7FF00B3FF00C6FF00DDFF00FAFF00FFE300FFBE00FF96
00FF6B00FF3F00FF121AFF0045FF0070FF0097FF00BCFF00DCFF00F8FF00FFF000FFDE00
FFD200FFCC00FFCC00FFD200FFDF00FFF100F6FF00D9FF00B7FF0091FF0066FF0039FF00
08FF0000FF2900FF5D00FF9100FFC500FFF900D4FF00A5FF
9DFF006DFF003CFF0009FF0000FF2A00FF5E00FF9200FFC500FFF600DBFF00B0FF0088FF
0066FF0047FF002FFF001BFF000EFF0006FF0005FF000AFF0015FF0025FF003BFF0057FF
0076FF009AFF00C1FF00EBFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006FFF0082FF0090FF0097FF0099FF0094FF008AFF007AFF0064FF004AFF002CFF00
0AFF0000FF1800FF3E00FF6300FF8800FFAC00FFCD00FFEB00FBFF00E7FF00D8FF00CFFF
00CCFF00D0FF00D9FF00E8FF00FCFF00FFEB00FFD000FFB200FF9400FF7600FF5A00FF40
00FF2A00FF1900FF0E00FF0900FF0A00FF1200FF1E00FF3000FF4400FF5B00FF7200FF88
00FF9B00FFA900FFB200FFB400FFB000FFA600FF9800FF8800FF7800FF6C00FF6500FF64
00FF6A00FF7400FF7C00FF7C00FF7800FF7700FF7E00FF8700FF8E00FF8F00FF8900FF7E
00FF6E00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7C00FF9300FFAA
00FFC000FFD200FFE000FFE800FFEA00FFE600FFDC00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0BFF001FFF002FFF003AFF003EFF003DFF0035FF0027FF0014FF00
00FF0300FF2000FF4100FF6400FF8900FFAE00FFD400FFF800E5FF00C6FF00ABFF0095FF
0084FF0078FF0072FF0073FF0079FF0086FF0098FF00B0FF00CDFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1318FF0042FF006AFF008EFF00AEFF00CAFF00E2FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F3FF00E0FF00C9FF00ABFF0089FF0063FF0039FF000BFF00
00FF2500FF5700FF8B00FFBF00FFF300D9FF00A7FF0077FF
6CFF003DFF000CFF0000FF2600FF5B00FF8F00FFC300FFF500D9FF00ABFF007FFF0058FF
0035FF0017FF0100FF1400FF2200FF2900FF2A00FF2500FF1B00FF0A00FF000BFF0026FF
0046FF0069FF0091FF00BAFF00E6FF00FFEC00FFBF00FF9300FF6800FF3F00FF1908FF00
25FF003EFF0052FF005FFF0067FF0069FF0064FF0059FF0049FF0034FF001AFF0000FF04
00FF2500FF4900FF6E00FF9400FFB900FFDC00FFFD00E4FF00CBFF00B6FF00A7FF009FFF
009CFF009FFF00A8FF00B7FF00CBFF00E3FF00FFFF00FFE300FFC400FFA600FF8A00FF70
00FF5B00FF4A00FF3F00FF3A00FF3B00FF4200FF4F00FF6000FF7500FF8C00FFA300FFB9
00FFCB00FFDA00FFE200FFE400FFE000FFD700FFC900FFB800FFA900FF9C00FF9500FF95
00FF9A00FFA400FFAC00FFAD00FFA800FFA700FFAE00FFB800FFBF00FFC000FFBA00FFAE
00FF9F00FF8E00FF8000FF7500FF7000FF7100FF7800FF8600FF9700FFAD00FFC400FFDB
00FFF000FDFF00EFFF00E7FF00E4FF00E8FF00F2FF00FFFD00FFE800FFCF00FFB300FF95
00FF7700FF5900FF3E00FF2500FF1000FF0009FF000EFF000CFF0005FF0000FF0800FF1B
00FF3400FF5100FF7100FF9400FFB900FFDF00FBFF00D7FF00B5FF0096FF007BFF0065FF
0053FF0048FF0042FF0042FF0049FF0055FF0067FF007FFF009CFF00BDFF00E3FF00FFF4
00FFC900FF9D00FF7000FF4300FF1812FF0039FF005EFF007EFF009AFF00B1FF00C3FF00
CFFF00D5FF00D5FF00CEFF00C2FF00B0FF0098FF007BFF0059FF0033FF0008FF0000FF25
00FF5500FF8700FFBB00FFEF00DBFF00A8FF0076FF0047FF
3AFF000BFF0000FF2600FF5900FF8D00FFC100FFF500D7FF00A6FF0078FF004DFF0026FF
0003FF1A00FF3300FF4700FF5400FF5B00FF5D00FF5800FF4D00FF3C00FF2600FF0B00FF
0013FF0037FF005EFF0088FF00B3FF00E0FF00FFF200FFC500FF9A00FF7200FF4C00FF2A
00FF0C0CFF001FFF002DFF0035FF0036FF0032FF0027FF0017FF0001FF0000FF1800FF36
00FF5700FF7B00FFA000FFC600FFEB00F0FF00CFFF00B2FF0098FF0084FF0075FF006CFF
0069FF006DFF0076FF0085FF0099FF00B1FF00CCFF00EAFF00FFF700FFD900FFBC00FFA3
00FF8D00FF7C00FF7100FF6C00FF6D00FF7400FF8100FF9200FFA700FFBE00FFD500FFEB
00FFFE00F3FF00EBFF00E8FF00ECFF00F6FF00FFFB00FFEB00FFDB00FFCF00FFC700FFC7
00FFCD00FFD600FFDE00FFDF00FFDB00FFD900FFE100FFEA00FFF100FFF200FFEC00FFE0
00FFD100FFC100FFB200FFA800FFA200FFA300FFAB00FFB800FFCA00FFDF00FFF600F2FF
00DCFF00CAFF00BDFF00B4FF00B2FF00B6FF00C0FF00D0FF00E4FF00FDFF00FFE600FFC8
00FFA900FF8C00FF7000FF5700FF4200FF3200FF2800FF2300FF2500FF2D00FF3A00FF4E
00FF6600FF8300FFA300FFC700FFEC00EEFF00C8FF00A4FF0082FF0064FF0049FF0032FF
0021FF0015FF000FFF0010FF0016FF0023FF0035FF004DFF006AFF008BFF00B0FF00D9FF
00FFFC00FFD000FFA300FF7600FF4A00FF2007FF002BFF004CFF0068FF007FFF0090FF00
9CFF00A2FF00A2FF009CFF0090FF007EFF0066FF0049FF0027FF0000FF0000FF2900FF57
00FF8700FFBA00FFED00DDFF00A9FF0076FF0044FF0014FF
06FF0000FF2800FF5900FF8D00FFC100FFF500D6FF00A4FF0073FF0044FF0019FF0D00FF
3000FF4E00FF6700FF7A00FF8800FF8F00FF9000FF8B00FF8100FF7000FF5A00FF3F00FF
1F00FF0003FF002AFF0054FF0080FF00ACFF00D9FF00FFF900FFCE00FFA500FF8000FF5D
00FF4000FF2700FF1300FF0601FF0003FF0000FF0100FF0C00FF1C00FF3100FF4B00FF6A
00FF8B00FFAF00FFD400FFFA00E0FF00BDFF009CFF007EFF0065FF0050FF0041FF0038FF
0036FF0039FF0042FF0051FF0065FF007DFF0099FF00B6FF00D4FF00F2FF00FFF000FFD6
00FFC100FFB000FFA500FFA000FFA100FFA800FFB500FFC600FFDB00FFF200F6FF00E0FF
00CEFF00BFFF00B7FF00B5FF00B9FF00C2FF00D0FF00E0FF00F0FF00FDFF00FFFB00FFFB
00FEFF00F5FF00EDFF00ECFF00F1FF00F2FF00EBFF00E1FF00DAFF00D9FF00DFFF00EBFF
00FAFF00FFF500FFE600FFDB00FFD600FFD700FFDE00FFEC00FFFE00ECFF00D5FF00BEFF
00A9FF0097FF0089FF0081FF007EFF0082FF008CFF009CFF00B1FF00CAFF00E6FF00FFFC
00FFDD00FFBF00FFA400FF8B00FF7600FF6600FF5C00FF5700FF5900FF6000FF6E00FF81
00FF9A00FFB700FFD700FFFA00E0FF00BAFF0095FF0071FF004FFF0030FF0015FF0100FF
1200FF1E00FF2300FF2300FF1C00FF1000FF0001FF0019FF0036FF0057FF007DFF00A5FF
00CFFF00FCFF00FFD600FFAA00FF7E00FF5400FF2C00FF0818FF0034FF004BFF005DFF00
69FF006FFF006FFF0068FF005CFF004AFF0032FF0015FF0000FF0C00FF3300FF5D00FF8B
00FFBB00FFED00DEFF00AAFF0075FF0042FF0010FF1E00FF
00FF2D00FF5C00FF8E00FFC100FFF500D6FF00A2FF006FFF003EFF0010FF1A00FF4100FF
6400FF8200FF9B00FFAF00FFBC00FFC300FFC500FFC000FFB500FFA400FF8E00FF7300FF
5400FF3000FF0900FF0020FF004BFF0078FF00A5FF00D2FF00FDFF00FFDA00FFB400FF92
00FF7400FF5B00FF4800FF3A00FF3200FF3100FF3500FF4000FF5000FF6600FF8000FF9E
00FFBF00FFE300F7FF00D1FF00ACFF0088FF0067FF004AFF0030FF001CFF000DFF0004FF
0001FF0005FF000EFF001DFF0031FF0049FF0064FF0082FF00A0FF00BEFF00DBFF00F4FF
00FFF500FFE400FFD900FFD400FFD500FFDC00FFE900FFFA00F0FF00D9FF00C2FF00ACFF
0099FF008BFF0083FF0080FF0084FF008EFF009CFF00ACFF00BCFF00C8FF00D0FF00D0FF
00CAFF00C1FF00B9FF00B8FF00BDFF00BEFF00B6FF00ADFF00A6FF00A5FF00ABFF00B7FF
00C6FF00D6FF00E5FF00EFFF00F5FF00F4FF00ECFF00DFFF00CDFF00B8FF00A1FF008AFF
0074FF0062FF0055FF004CFF004AFF004EFF0058FF0068FF007CFF0095FF00B1FF00CFFF
00EEFF00FFF400FFD800FFBF00FFAA00FF9A00FF9000FF8B00FF8D00FF9500FFA200FFB6
00FFCE00FFEB00F4FF00D0FF00ACFF0086FF0060FF003CFF001AFF0300FF1E00FF3500FF
4600FF5200FF5800FF5700FF5100FF4400FF3200FF1A00FF0002FF0023FF0048FF0071FF
009BFF00C7FF00F4FF00FFDE00FFB200FF8800FF6000FF3C00FF1B00FF0017FF0028FF00
34FF003AFF003AFF0034FF0028FF0016FF0000FF0100FF1E00FF4000FF6700FF9100FFBF
00FFEF00DDFF00AAFF0075FF0041FF000EFF2300FF5300FF
00FF6100FF9000FFC200FFF500D6FF00A2FF006EFF003BFF000AFF2300FF4E00FF7500FF
9800FFB700FFCF00FFE300FFF000FFF700FFF900FFF400FFE900FFD900FFC300FFA700FF
8800FF6400FF3D00FF1300FF0017FF0044FF0071FF009DFF00C8FF00F1FF00FFE800FFC6
00FFA800FF8F00FF7C00FF6E00FF6600FF6500FF6A00FF7400FF8400FF9A00FFB400FFD2
00FFF300E8FF00C3FF009DFF0078FF0054FF0033FF0016FF0300FF1700FF2600FF2F00FF
3200FF2E00FF2500FF1600FF0200FF0015FF0030FF004EFF006CFF008AFF00A6FF00C0FF
00D6FF00E7FF00F2FF00F7FF00F6FF00EFFF00E2FF00D0FF00BCFF00A5FF008EFF0078FF
0065FF0057FF004EFF004CFF0050FF005AFF0068FF0078FF0088FF0094FF009BFF009CFF
0096FF008CFF0084FF0084FF0088FF0089FF0082FF0079FF0072FF0071FF0077FF0082FF
0092FF00A2FF00B1FF00BBFF00C0FF00BFFF00B8FF00ABFF0099FF0084FF006DFF0056FF
0040FF002EFF0020FF0018FF0016FF001AFF0024FF0033FF0048FF0061FF007DFF009BFF
00B9FF00D7FF00F3FF00FFF300FFDE00FFCF00FFC400FFBF00FFC100FFC900FFD700FFEA
00FDFF00E0FF00BFFF009CFF0077FF0052FF002CFF0008FF1900FF3800FF5300FF6900FF
7A00FF8600FF8C00FF8B00FF8500FF7800FF6600FF4E00FF3100FF1000FF0014FF003CFF
0067FF0093FF00C0FF00EDFF00FFE600FFBC00FF9400FF7000FF4F00FF3300FF1C00FF0B
00FF0006FF0006FF0000FF0000FF0B00FF1D00FF3500FF5200FF7400FF9B00FFC500FFF3
00DBFF00A9FF0075FF0041FF000DFF2500FF5700FF8700FF
00FF9500FFC400FFF500D7FF00A3FF006EFF003AFF0008FF2800FF5600FF8100FFA900FF
CC00FFEA00FFFF00FCFF00E9FF00DCFF00D4FF00D3FF00D8FF00E3FF00F3F600FFDB00FF
BB00FF9700FF7000FF4700FF1B00FF0011FF003EFF006AFF0095FF00BEFF00E4FF00FFF9
00FFDB00FFC300FFAF00FFA100FF9A00FF9800FF9D00FFA700FFB800FFCD00FFE700FAFF
00D8FF00B4FF008FFF006AFF0044FF0021FF0000FF1D00FF3600FF4B00FF5900FF6200FF
6500FF6200FF5800FF4900FF3600FF1D00FF0200FF001AFF0039FF0057FF0073FF008DFF
00A2FF00B3FF00BEFF00C4FF00C2FF00BBFF00AEFF009DFF0088FF0071FF005AFF0045FF
0032FF0024FF001BFF0019FF001DFF0027FF0035FF0045FF0054FF0061FF0068FF0069FF
0063FF0059FF0051FF0050FF0055FF0056FF004FFF0045FF003EFF003EFF0043FF004FFF
005EFF006FFF007DFF0088FF008DFF008CFF0085FF0078FF0066FF0050FF0039FF0022FF
000DFF0400FF1200FF1A00FF1D00FF1900FF0F00FF0000FF0015FF002EFF004AFF0068FF
0086FF00A4FF00C0FF00D8FF00EDFF00FDFF00FFF700FFF300FFF400FFFC00F5FF00E2FF
00C9FF00ADFF008CFF0069FF0044FF001EFF0600FF2A00FF4C00FF6B00FF8600FF9C00FF
AE00FFB900FFBF00FFBF00FFB800FFAC00FF9900FF8200FF6500FF4300FF1E00FF0009FF
0034FF0060FF008DFF00BAFF00E6FF00FFEF00FFC800FFA300FF8300FF6700FF5000FF3E
00FF3200FF2C00FF2C00FF3200FF3F00FF5100FF6900FF8600FFA800FFCE00FFF900D9FF
00A8FF0076FF0042FF000EFF2500FF5900FF8A00FFBA00FF
00FFC600FFF600D8FF00A5FF0071FF003DFF0009FF2900FF5A00FF8800FFB300FFDB00FF
FE00FFFF00E3FF00CAFF00B7FF00AAFF00A2FF00A1FF00A6FF00B1FF00C1FF00D7FF00F2
ED00FFC900FFA200FF7800FF4D00FF2000FF000CFF0038FF0063FF008CFF00B2FF00D4FF
00F2FF00FFF400FFE100FFD300FFCC00FFCA00FFCF00FFD900FFE900FFFF00E6FF00C8FF
00A6FF0083FF005DFF0038FF0013FF1000FF3100FF4F00FF6800FF7C00FF8B00FF9400FF
9700FF9400FF8A00FF7B00FF6700FF4F00FF3400FF1700FF0007FF0025FF0041FF005BFF
0071FF0082FF008DFF0092FF0091FF0089FF007DFF006BFF0056FF0040FF0028FF0013FF
0000FF0D00FF1600FF1800FF1400FF0A00FF0003FF0013FF0023FF002FFF0036FF0037FF
0031FF0027FF001FFF001FFF0023FF0024FF001DFF0013FF000DFF000CFF0012FF001DFF
002DFF003DFF004BFF0056FF005BFF005AFF0053FF0046FF0034FF001FFF0008FF0E00FF
2400FF3600FF4400FF4C00FF4E00FF4A00FF4000FF3100FF1C00FF0300FF0018FF0036FF
0054FF0072FF008EFF00A7FF00BBFF00CBFF00D6FF00DAFF00D9FF00D1FF00C3FF00B0FF
0098FF007BFF005AFF0037FF0012FF1200FF3800FF5C00FF7E00FF9D00FFB800FFCE00FF
DF00FFEB00FFF100FFF100FFEA00FFDE00FFCB00FFB300FF9700FF7500FF5000FF2800FF
0002FF002EFF005BFF0088FF00B4FF00DEFF00FFFA00FFD500FFB500FF9900FF8200FF70
00FF6400FF5E00FF5E00FF6400FF7000FF8300FF9A00FFB800FFDA00FFFF00D4FF00A7FF
0076FF0044FF0010FF2300FF5700FF8A00FFBC00FFEC00FF
00FFF600DAFF00A8FF0075FF0041FF000DFF2600FF5900FF8900FFB800FFE300FFFF00F5
FF00D2FF00B4FF009BFF0088FF007AFF0073FF0071FF0076FF0081FF0092FF00A8FF00C3
FF00E3F900FFD200FFA800FF7C00FF5000FF2300FF0009FF0034FF005CFF0082FF00A4FF
00C2FF00DBFF00EEFF00FCFF00FFFB00FFFA00FFFE00F6FF00E6FF00D1FF00B6FF0098FF
0077FF0053FF002EFF0008FF1C00FF4000FF6100FF7E00FF9800FFAC00FFBB00FFC400FF
C600FFC300FFBA00FFAB00FF9700FF7F00FF6400FF4600FF2800FF0A00FF0012FF002BFF
0041FF0052FF005DFF0062FF0061FF005AFF004DFF003CFF0027FF0010FF0600FF1C00FF
2F00FF3D00FF4500FF4800FF4400FF3A00FF2C00FF1C00FF0C00FF0000FF0007FF0007FF
0001FF0700FF0F00FF1000FF0B00FF0A00FF1100FF1B00FF2200FF2300FF1D00FF1100FF
0200FF000DFF001CFF0026FF002CFF002BFF0023FF0016FF0004FF1000FF2700FF3E00FF
5300FF6600FF7300FF7C00FF7E00FF7A00FF7000FF6000FF4B00FF3300FF1700FF0006FF
0025FF0042FF005EFF0077FF008CFF009CFF00A6FF00ABFF00A9FF00A1FF0094FF0080FF
0068FF004BFF002BFF0008FF1C00FF4200FF6700FF8C00FFAD00FFCC00FFE700FFFE00FF
FF00F0FF00E4FF00DFFF00DFFF00E5FF00F2FB00FFE300FFC600FFA500FF8000FF5700FF
2D00FF0000FF002BFF0058FF0084FF00AEFF00D6FF00FAFF00FFE400FFC800FFB100FF9F
00FF9400FF8E00FF8E00FF9400FFA000FFB200FFCA00FFE700F6FF00CFFF00A5FF0077FF
0047FF0014FF1E00FF5300FF8700FFBA00FFEC00FFFF00E3
pop
P
% End of image
1 1 1 r
.5 .02381 m
.5 .97619 L
.5465 .97619 L
.5465 .02381 L
F
.59301 .02381 m
.59301 .97619 L
.68601 .97619 L
.68601 .02381 L
F
.02381 .5 m
.02381 .77902 L
.97619 .77902 L
.97619 .5 L
F
0 g
gsave
.5 .68601 -105 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Forbidden) show
123.000 13.000 moveto
(area) show
147.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .59301 -105 -10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.75 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Hard) show
93.000 13.000 moveto
(constrain) show
147.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.015 w
.90086 .87202 Mdot
[(1)] .91586 .87202 -1 0 Mshowa
.56984 .21836 Mdot
[(2)] .58484 .21836 -1 0 Mshowa
.59122 .3746 Mdot
[(3)] .60622 .3746 -1 0 Mshowa
.17634 .81529 Mdot
[(4)] .19134 .81529 -1 0 Mshowa
.56403 .39466 Mdot
[(5)] .57903 .39466 -1 0 Mshowa
.55357 .47689 Mdot
[(6)] .56857 .47689 -1 0 Mshowa
.47117 .80041 Mdot
[(7)] .48617 .80041 -1 0 Mshowa
.96875 .78181 Mdot
[(8)] .98375 .78181 -1 0 Mshowa
.36886 .37127 Mdot
[(9)] .38386 .37127 -1 0 Mshowa
.56682 .91481 Mdot
[(10)] .58182 .91481 -1 0 Mshowa
.03 w
.90086 .87202 Mdot
.56984 .21836 Mdot
.59122 .3746 Mdot
.17634 .81529 Mdot
.56403 .39466 Mdot
.55357 .47689 Mdot
.47117 .80041 Mdot
.96875 .78181 Mdot
.36886 .37127 Mdot
.56682 .91481 Mdot
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.754707 0.0055371 0.97619 0.227021 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.00093006 0.5 0.00093006 [
[.12798 -0.0125 -12 -9 ]
[.12798 -0.0125 12 0 ]
[.31399 -0.0125 -12 -9 ]
[.31399 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.68601 -0.0125 -9 -9 ]
[.68601 -0.0125 9 0 ]
[.87202 -0.0125 -9 -9 ]
[.87202 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .12798 -24 -4.5 ]
[-0.0125 .12798 0 4.5 ]
[-0.0125 .31399 -24 -4.5 ]
[-0.0125 .31399 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .68601 -18 -4.5 ]
[-0.0125 .68601 0 4.5 ]
[-0.0125 .87202 -18 -4.5 ]
[-0.0125 .87202 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 .68601 -44 -6.375 ]
[.5 .68601 44 6.375 ]
[.5 .59301 -44 -6.375 ]
[.5 .59301 44 6.375 ]
[.59673 .83482 0 -4.5 ]
[.59673 .83482 6 4.5 ]
[.58084 .37523 0 -4.5 ]
[.58084 .37523 6 4.5 ]
[.57935 .25571 0 -4.5 ]
[.57935 .25571 6 4.5 ]
[.57039 .95945 0 -4.5 ]
[.57039 .95945 6 4.5 ]
[.08996 .82738 0 -4.5 ]
[.08996 .82738 6 4.5 ]
[.74379 .24801 0 -4.5 ]
[.74379 .24801 6 4.5 ]
[.74844 .97247 0 -4.5 ]
[.74844 .97247 6 4.5 ]
[.10949 .90737 0 -4.5 ]
[.10949 .90737 6 4.5 ]
[.91121 .94364 0 -4.5 ]
[.91121 .94364 6 4.5 ]
[.57329 .90365 0 -4.5 ]
[.57329 .90365 12 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12798 0 m
.12798 .00625 L
s
[(-400)] .12798 -0.0125 0 1 Mshowa
.31399 0 m
.31399 .00625 L
s
[(-200)] .31399 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.68601 0 m
.68601 .00625 L
s
[(200)] .68601 -0.0125 0 1 Mshowa
.87202 0 m
.87202 .00625 L
s
[(400)] .87202 -0.0125 0 1 Mshowa
.125 Mabswid
.17448 0 m
.17448 .00375 L
s
.22098 0 m
.22098 .00375 L
s
.26749 0 m
.26749 .00375 L
s
.36049 0 m
.36049 .00375 L
s
.40699 0 m
.40699 .00375 L
s
.4535 0 m
.4535 .00375 L
s
.5465 0 m
.5465 .00375 L
s
.59301 0 m
.59301 .00375 L
s
.63951 0 m
.63951 .00375 L
s
.73251 0 m
.73251 .00375 L
s
.77902 0 m
.77902 .00375 L
s
.82552 0 m
.82552 .00375 L
s
.08147 0 m
.08147 .00375 L
s
.03497 0 m
.03497 .00375 L
s
.91853 0 m
.91853 .00375 L
s
.96503 0 m
.96503 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .12798 m
.00625 .12798 L
s
[(-400)] -0.0125 .12798 1 0 Mshowa
0 .31399 m
.00625 .31399 L
s
[(-200)] -0.0125 .31399 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .68601 m
.00625 .68601 L
s
[(200)] -0.0125 .68601 1 0 Mshowa
0 .87202 m
.00625 .87202 L
s
[(400)] -0.0125 .87202 1 0 Mshowa
.125 Mabswid
0 .17448 m
.00375 .17448 L
s
0 .22098 m
.00375 .22098 L
s
0 .26749 m
.00375 .26749 L
s
0 .36049 m
.00375 .36049 L
s
0 .40699 m
.00375 .40699 L
s
0 .4535 m
.00375 .4535 L
s
0 .5465 m
.00375 .5465 L
s
0 .59301 m
.00375 .59301 L
s
0 .63951 m
.00375 .63951 L
s
0 .73251 m
.00375 .73251 L
s
0 .77902 m
.00375 .77902 L
s
0 .82552 m
.00375 .82552 L
s
0 .08147 m
.00375 .08147 L
s
0 .03497 m
.00375 .03497 L
s
0 .91853 m
.00375 .91853 L
s
0 .96503 m
.00375 .96503 L
s
.25 Mabswid
0 0 m
0 1 L
s
.12798 .99375 m
.12798 1 L
s
.31399 .99375 m
.31399 1 L
s
.5 .99375 m
.5 1 L
s
.68601 .99375 m
.68601 1 L
s
.87202 .99375 m
.87202 1 L
s
.125 Mabswid
.17448 .99625 m
.17448 1 L
s
.22098 .99625 m
.22098 1 L
s
.26749 .99625 m
.26749 1 L
s
.36049 .99625 m
.36049 1 L
s
.40699 .99625 m
.40699 1 L
s
.4535 .99625 m
.4535 1 L
s
.5465 .99625 m
.5465 1 L
s
.59301 .99625 m
.59301 1 L
s
.63951 .99625 m
.63951 1 L
s
.73251 .99625 m
.73251 1 L
s
.77902 .99625 m
.77902 1 L
s
.82552 .99625 m
.82552 1 L
s
.08147 .99625 m
.08147 1 L
s
.03497 .99625 m
.03497 1 L
s
.91853 .99625 m
.91853 1 L
s
.96503 .99625 m
.96503 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .12798 m
1 .12798 L
s
.99375 .31399 m
1 .31399 L
s
.99375 .5 m
1 .5 L
s
.99375 .68601 m
1 .68601 L
s
.99375 .87202 m
1 .87202 L
s
.125 Mabswid
.99625 .17448 m
1 .17448 L
s
.99625 .22098 m
1 .22098 L
s
.99625 .26749 m
1 .26749 L
s
.99625 .36049 m
1 .36049 L
s
.99625 .40699 m
1 .40699 L
s
.99625 .4535 m
1 .4535 L
s
.99625 .5465 m
1 .5465 L
s
.99625 .59301 m
1 .59301 L
s
.99625 .63951 m
1 .63951 L
s
.99625 .73251 m
1 .73251 L
s
.99625 .77902 m
1 .77902 L
s
.99625 .82552 m
1 .82552 L
s
.99625 .08147 m
1 .08147 L
s
.99625 .03497 m
1 .03497 L
s
.99625 .91853 m
1 .91853 L
s
.99625 .96503 m
1 .96503 L
s
.25 Mabswid
1 0 m
1 1 L
s
% Start of colorimage (RGB)
p
.02381 .02381 translate
.95145 .95145 scale
600 string
200 200 8 [200 0 0 200 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  false 3 Mcolorimage
FFD100FFFF00CEFF009BFF0067FF0032FF0000FF0100FF3300FF6400FF9200FFBD00FFE5
00F7FF00D9FF00C0FF00ADFF00A0FF0098FF0097FF009CFF00A7FF00B7FF00CDFF00E8FF
00FFF700FFD300FFAC00FF8300FF5700FF2A02FF002EFF0059FF0082FF00A8FF00CAFF00
E8FF00FFFF00FFEB00FFDD00FFD600FFD400FFD900FFE300FFF400F6FF00DCFF00BEFF00
9CFF0078FF0053FF002EFF0008FF0000FF1A00FF3B00FF5900FF7200FF8700FF9500FF9E
00FFA100FF9E00FF9400FF8500FF7200FF5900FF3E00FF2100FF021BFF0037FF0051FF00
67FF0077FF0083FF0088FF0086FF007FFF0073FF0061FF004CFF0035FF001EFF0009FF00
00FF0900FF1700FF2000FF2200FF1E00FF1400FF0609FF0018FF0025FF002CFF002DFF00
27FF001DFF0015FF0014FF0019FF001AFF0013FF0009FF0002FF0002FF0007FF0013FF00
22FF0033FF0041FF004CFF0051FF0050FF0049FF003CFF002AFF0014FF0000FF0200FF19
00FF2E00FF4000FF4E00FF5600FF5900FF5500FF4B00FF3B00FF2600FF0D0EFF002CFF00
4AFF0068FF0084FF009CFF00B1FF00C1FF00CCFF00D0FF00CFFF00C7FF00B9FF00A6FF00
8DFF0071FF0050FF002DFF0008FF0000FF1D00FF4200FF6600FF8800FFA700FFC200FFD8
00FFEA00FFF500FFFB00FFFB00FFF400FFE800FFD500FFBE00FFA100FF7F00FF5A00FF32
00FF0724FF0051FF007EFF00AAFF00D4FF00FBFF00FFDF00FFBF00FFA300FF8C00FF7A00
FF6E00FF6800FF6800FF6E00FF7B00FF8D00FFA500FFC200FFE400F5FF00CAFF009DFF00
6CFF003AFF0006FF0000FF2D00FF6100FF9500FFC600FFF6
FFFF00D0FF009FFF006CFF0038FF0003FF0000FF3000FF6200FF9300FFC100FFED00EBFF
00C8FF00AAFF0091FF007EFF0070FF0069FF0068FF006DFF0077FF0088FF009EFF00B9FF
00D9FF00FDFF00FFDB00FFB200FF8600FF5900FF2C00FF002AFF0053FF0079FF009BFF00
B9FF00D1FF00E5FF00F2FF00FAFF00FCFF00F7FF00EDFF00DCFF00C7FF00ADFF008FFF00
6DFF0049FF0024FF0000FF0100FF2600FF4900FF6A00FF8800FFA100FFB600FFC400FFCD
00FFD000FFCD00FFC300FFB500FFA100FF8900FF6D00FF5000FF3100FF1308FF0022FF00
37FF0048FF0053FF0058FF0057FF0050FF0043FF0032FF001DFF0006FF0000FF1000FF26
00FF3800FF4700FF4F00FF5100FF4D00FF4300FF3600FF2500FF1600FF0900FF0200FF02
00FF0700FF1100FF1900FF1A00FF1500FF1400FF1B00FF2500FF2C00FF2D00FF2700FF1B
00FF0C04FF0012FF001DFF0022FF0021FF001AFF000DFF0000FF0400FF1A00FF3100FF48
00FF5D00FF6F00FF7D00FF8500FF8800FF8400FF7A00FF6A00FF5500FF3C00FF2000FF02
1BFF0039FF0055FF006DFF0082FF0092FF009DFF00A1FF00A0FF0098FF008AFF0077FF00
5EFF0041FF0021FF0000FF0100FF2600FF4C00FF7100FF9500FFB700FFD600FFF100F8FF
00E6FF00DBFF00D5FF00D5FF00DCFF00E8FF00FBFF00FFED00FFD000FFAE00FF8900FF61
00FF3600FF0A22FF004FFF007AFF00A5FF00CCFF00F1FF00FFEE00FFD200FFBB00FFA900
FF9D00FF9700FF9700FF9D00FFAA00FFBC00FFD400FFF100ECFF00C6FF009BFF006DFF00
3DFF000BFF0000FF2800FF5C00FF9000FFC400FFF600DAFF
CEFF009FFF006DFF003AFF0006FF0000FF2D00FF6100FF9400FFC500FFF300E1FF00BAFF
0097FF0079FF0060FF004CFF003FFF0038FF0036FF003BFF0046FF0057FF006DFF0088FF
00A7FF00CBFF00F2FF00FFE300FFB800FF8B00FF5E00FF3100FF0621FF0047FF0069FF00
87FF00A0FF00B3FF00C1FF00C9FF00CAFF00C6FF00BBFF00ABFF0095FF007BFF005DFF00
3CFF0018FF0000FF0C00FF3200FF5700FF7B00FF9C00FFB900FFD300FFE700FFF600FFFF
00FDFF00FFFE00FFF500FFE600FFD200FFBA00FF9F00FF8100FF6300FF4500FF2800FF0F
06FF0017FF0022FF0027FF0026FF001FFF0012FF0001FF0000FF1300FF2A00FF4100FF57
00FF6A00FF7800FF8000FF8300FF7F00FF7500FF6700FF5700FF4700FF3B00FF3300FF33
00FF3900FF4200FF4A00FF4B00FF4700FF4500FF4D00FF5600FF5D00FF5E00FF5800FF4C
00FF3D00FF2D00FF1E00FF1400FF0E00FF0F00FF1700FF2400FF3600FF4B00FF6200FF79
00FF8F00FFA100FFAE00FFB700FFB900FFB500FFAB00FF9B00FF8700FF6E00FF5200FF34
00FF1507FF0023FF003CFF0051FF0061FF006BFF0070FF006EFF0066FF0059FF0045FF00
2DFF0010FF0000FF0F00FF3300FF5700FF7D00FFA300FFC700FFE900F8FF00DDFF00C6FF
00B5FF00A9FF00A3FF00A4FF00AAFF00B7FF00C9FF00E1FF00FEFF00FFE000FFBB00FF92
00FF6800FF3C00FF0F1DFF0049FF0073FF009BFF00BFFF00E0FF00FCFF00FFEC00FFDB00
FFCF00FFC900FFC900FFCF00FFDB00FFED00FAFF00DDFF00BBFF0094FF006AFF003CFF00
0CFF0000FF2600FF5900FF8E00FFC200FFF500D8FF00A8FF
9BFF006CFF003AFF0007FF0000FF2C00FF6000FF9400FFC700FFF800D9FF00AEFF0087FF
0064FF0046FF002DFF0019FF000CFF0005FF0003FF0008FF0013FF0024FF003AFF0055FF
0074FF0098FF00BFFF00E9FF00FFEB00FFBE00FF9100FF6500FF3A00FF1114FF0036FF00
54FF006DFF0080FF008EFF0096FF0097FF0093FF0088FF0078FF0062FF0048FF002AFF00
09FF0000FF1A00FF3F00FF6500FF8A00FFAE00FFCF00FFEC00F9FF00E5FF00D6FF00CDFF
00CAFF00CEFF00D7FF00E6FF00FAFF00FFED00FFD200FFB400FF9600FF7800FF5B00FF42
00FF2C00FF1B00FF1000FF0B00FF0C00FF1300FF2000FF3200FF4600FF5D00FF7400FF8A
00FF9D00FFAB00FFB400FFB600FFB200FFA800FF9A00FF8A00FF7A00FF6E00FF6600FF66
00FF6C00FF7500FF7E00FF7E00FF7A00FF7900FF8000FF8900FF9000FF9100FF8B00FF7F
00FF7000FF6000FF5100FF4700FF4100FF4200FF4A00FF5700FF6900FF7E00FF9500FFAC
00FFC200FFD400FFE100FFEA00FFEC00FFE800FFDE00FFCF00FFBA00FFA100FF8500FF67
00FF4900FF2B00FF0F09FF001EFF002EFF0038FF003DFF003BFF0033FF0026FF0012FF00
00FF0500FF2200FF4300FF6600FF8B00FFB000FFD600FFFA00E3FF00C4FF00A9FF0093FF
0082FF0076FF0070FF0071FF0077FF0084FF0096FF00AEFF00CBFF00ECFF00FFEE00FFC6
00FF9B00FF6F00FF4200FF1516FF0040FF0068FF008CFF00ADFF00C9FF00E0FF00F1FF00
FDFF00FFFC00FFFC00FDFF00F1FF00DFFF00C7FF00AAFF0088FF0061FF0037FF0009FF00
00FF2600FF5900FF8D00FFC100FFF500D7FF00A5FF0075FF
67FF0038FF0006FF0000FF2C00FF6000FF9400FFC800FFFB00D3FF00A5FF007AFF0053FF
0030FF0011FF0600FF1A00FF2700FF2E00FF3000FF2B00FF2000FF1000FF0005FF0021FF
0040FF0064FF008BFF00B5FF00E0FF00FFF200FFC500FF9900FF6E00FF4500FF1F02FF00
20FF0039FF004CFF005AFF0062FF0063FF005EFF0054FF0044FF002EFF0014FF0000FF09
00FF2A00FF4E00FF7300FF9900FFBE00FFE200FCFF00DFFF00C5FF00B1FF00A2FF0099FF
0096FF009AFF00A3FF00B2FF00C6FF00DEFF00F9FF00FFE800FFCA00FFAC00FF8F00FF76
00FF6000FF4F00FF4400FF3F00FF4000FF4700FF5400FF6600FF7A00FF9100FFA800FFBE
00FFD100FFDF00FFE800FFEA00FFE600FFDC00FFCE00FFBE00FFAE00FFA200FF9B00FF9A
00FFA000FFAA00FFB200FFB200FFAE00FFAD00FFB400FFBD00FFC400FFC500FFBF00FFB4
00FFA400FF9400FF8500FF7B00FF7600FF7600FF7E00FF8B00FF9D00FFB200FFC900FFE0
00FFF600F7FF00E9FF00E1FF00DFFF00E3FF00EDFF00FCFF00FFEE00FFD500FFB900FF9B
00FF7D00FF5F00FF4300FF2A00FF1500FF0604FF0009FF0007FF0000FF0000FF0E00FF21
00FF3900FF5600FF7700FF9A00FFBF00FFE400F5FF00D1FF00AFFF0090FF0075FF005FFF
004EFF0042FF003CFF003DFF0043FF0050FF0062FF007AFF0097FF00B8FF00DDFF00FFFA
00FFCF00FFA300FF7600FF4900FF1D0CFF0034FF0058FF0079FF0095FF00ACFF00BDFF00
C9FF00CFFF00CFFF00C9FF00BDFF00ABFF0093FF0076FF0054FF002DFF0003FF0000FF2A
00FF5B00FF8D00FFC100FFF500D6FF00A3FF0071FF0041FF
32FF0003FF0000FF2D00FF6000FF9400FFC900FFFD00D0FF009FFF0071FF0046FF001EFF
0400FF2200FF3B00FF4E00FF5B00FF6300FF6400FF5F00FF5400FF4400FF2E00FF1300FF
000CFF0030FF0057FF0080FF00ACFF00D9FF00FFF900FFCD00FFA200FF7900FF5300FF31
00FF1304FF0018FF0026FF002DFF002FFF002AFF0020FF000FFF0000FF0500FF1F00FF3D
00FF5F00FF8300FFA800FFCD00FFF300E9FF00C8FF00AAFF0091FF007DFF006EFF0065FF
0062FF0065FF006FFF007EFF0091FF00AAFF00C5FF00E2FF00FFFE00FFE000FFC400FFAA
00FF9400FF8400FF7800FF7300FF7500FF7C00FF8800FF9A00FFAF00FFC600FFDD00FFF2
00FAFF00ECFF00E3FF00E1FF00E5FF00EFFF00FDFF00FFF200FFE300FFD600FFCF00FFCE
00FFD400FFDE00FFE600FFE700FFE200FFE100FFE800FFF200FFF900FFF900FFF400FFE8
00FFD900FFC800FFBA00FFAF00FFAA00FFAB00FFB200FFBF00FFD100FFE700FFFE00EAFF
00D5FF00C3FF00B5FF00ADFF00AAFF00AEFF00B8FF00C8FF00DDFF00F6FF00FFED00FFCF
00FFB100FF9300FF7700FF5F00FF4A00FF3A00FF2F00FF2B00FF2C00FF3400FF4200FF55
00FF6E00FF8A00FFAB00FFCE00FFF300E6FF00C1FF009DFF007BFF005CFF0041FF002BFF
0019FF000EFF0008FF0008FF000FFF001BFF002EFF0045FF0062FF0084FF00A9FF00D1FF
00FCFF00FFD700FFAA00FF7D00FF5100FF2700FF0024FF0044FF0060FF0077FF0089FF00
95FF009BFF009BFF0095FF0088FF0076FF005EFF0041FF001FFF0000FF0600FF3100FF5E
00FF8F00FFC100FFF500D6FF00A2FF006EFF003DFF000DFF
00FF0100FF3000FF6100FF9400FFC800FFFD00CFFF009CFF006BFF003DFF0012FF1500FF
3800FF5600FF6F00FF8200FF8F00FF9700FF9800FF9300FF8800FF7800FF6200FF4700FF
2700FF0300FF0023FF004DFF0078FF00A5FF00D2FF00FEFF00FFD600FFAD00FF8700FF65
00FF4700FF2E00FF1B00FF0D00FF0600FF0400FF0900FF1300FF2300FF3900FF5300FF71
00FF9300FFB600FFDC00FEFF00D9FF00B5FF0094FF0076FF005DFF0049FF003AFF0031FF
002EFF0031FF003BFF004AFF005EFF0076FF0091FF00AEFF00CDFF00EBFF00FFF800FFDE
00FFC800FFB800FFAC00FFA700FFA800FFB000FFBC00FFCE00FFE300FFF900EEFF00D9FF
00C6FF00B8FF00AFFF00ADFF00B1FF00BBFF00C9FF00D9FF00E9FF00F5FF00FCFF00FDFF
00F7FF00EDFF00E5FF00E5FF00E9FF00EAFF00E3FF00D9FF00D3FF00D2FF00D8FF00E3FF
00F3FF00FFFC00FFEE00FFE300FFDE00FFDF00FFE600FFF300FAFF00E5FF00CEFF00B6FF
00A1FF008FFF0081FF0079FF0077FF007AFF0084FF0094FF00A9FF00C2FF00DEFF00FCFF
00FFE500FFC700FFAB00FF9200FF7E00FF6E00FF6300FF5F00FF6000FF6800FF7600FF89
00FFA100FFBE00FFDF00FDFF00D8FF00B3FF008DFF0069FF0047FF0028FF000DFF0800FF
1900FF2500FF2B00FF2B00FF2400FF1800FF0500FF0012FF002EFF0050FF0075FF009DFF
00C8FF00F4FF00FFDE00FFB100FF8500FF5B00FF3400FF0F10FF002CFF0043FF0055FF00
61FF0067FF0067FF0061FF0055FF0042FF002BFF000DFF0000FF1400FF3A00FF6500FF92
00FFC300FFF500D6FF00A2FF006EFF003AFF0009FF2600FF
00FF3300FF6200FF9400FFC700FFFB00D0FF009CFF0069FF0038FF000AFF2000FF4700FF
6A00FF8800FFA100FFB500FFC200FFC900FFCB00FFC600FFBB00FFAA00FF9400FF7900FF
5A00FF3600FF0F00FF001AFF0045FF0072FF009FFF00CCFF00F7FF00FFE000FFBA00FF98
00FF7A00FF6100FF4E00FF4000FF3800FF3700FF3B00FF4600FF5600FF6C00FF8600FFA4
00FFC500FFE900F1FF00CBFF00A6FF0082FF0061FF0044FF002AFF0016FF0007FF0100FF
0400FF0000FF0008FF0017FF002BFF0043FF005EFF007CFF009AFF00B8FF00D5FF00EEFF
00FFFB00FFEA00FFDF00FFDA00FFDB00FFE200FFEF00FFFF00EAFF00D3FF00BCFF00A6FF
0093FF0085FF007DFF007AFF007EFF0088FF0096FF00A6FF00B6FF00C2FF00CAFF00CAFF
00C4FF00BBFF00B3FF00B2FF00B6FF00B8FF00B0FF00A7FF00A0FF009FFF00A5FF00B1FF
00C0FF00D0FF00DFFF00E9FF00EFFF00EEFF00E6FF00D9FF00C7FF00B2FF009BFF0084FF
006EFF005CFF004FFF0046FF0044FF0048FF0052FF0062FF0076FF008FFF00ABFF00C9FF
00E8FF00FFFA00FFDE00FFC500FFB000FFA000FF9600FF9100FF9300FF9B00FFA800FFBC
00FFD400FFF100EEFF00CAFF00A6FF0080FF005AFF0036FF0014FF0900FF2400FF3B00FF
4C00FF5800FF5E00FF5D00FF5700FF4A00FF3800FF2000FF0300FF001DFF0042FF006BFF
0095FF00C1FF00EEFF00FFE400FFB800FF8E00FF6600FF4200FF2100FF0511FF0022FF00
2EFF0034FF0034FF002EFF0022FF0010FF0000FF0700FF2400FF4600FF6D00FF9700FFC5
00FFF500D7FF00A4FF006FFF003BFF0008FF2900FF5900FF
00FF6400FF9300FFC500FFF800D3FF009FFF006BFF0038FF0008FF2600FF5100FF7800FF
9B00FFB900FFD200FFE500FFF300FFFA00FFFB00FFF700FFEC00FFDB00FFC500FFAA00FF
8A00FF6700FF4000FF1600FF0015FF0041FF006EFF009BFF00C6FF00EFFF00FFEB00FFC9
00FFAB00FF9200FF7E00FF7100FF6900FF6800FF6C00FF7700FF8700FF9C00FFB700FFD5
00FFF600E5FF00C0FF009AFF0075FF0051FF0030FF0013FF0500FF1A00FF2900FF3200FF
3400FF3100FF2800FF1900FF0500FF0012FF002DFF004BFF0069FF0087FF00A4FF00BDFF
00D3FF00E4FF00EFFF00F4FF00F3FF00ECFF00DFFF00CEFF00B9FF00A2FF008BFF0075FF
0062FF0054FF004CFF0049FF004EFF0057FF0065FF0075FF0085FF0092FF0099FF0099FF
0093FF008AFF0082FF0081FF0086FF0087FF0080FF0076FF006FFF006EFF0074FF0080FF
008FFF009FFF00AEFF00B9FF00BEFF00BDFF00B5FF00A8FF0096FF0081FF006AFF0053FF
003EFF002BFF001EFF0015FF0013FF0017FF0021FF0031FF0046FF005FFF007AFF0098FF
00B7FF00D4FF00F0FF00FFF600FFE100FFD100FFC700FFC200FFC400FFCC00FFD900FFED
00FAFF00DDFF00BDFF009AFF0075FF004FFF002AFF0006FF1B00FF3A00FF5500FF6C00FF
7D00FF8900FF8E00FF8E00FF8800FF7B00FF6900FF5100FF3400FF1300FF0011FF003AFF
0064FF0091FF00BDFF00EAFF00FFE900FFBF00FF9700FF7300FF5200FF3600FF1F00FF0D
00FF0104FF0003FF0000FF0200FF0E00FF2000FF3800FF5500FF7700FF9E00FFC800FFF6
00D9FF00A6FF0073FF003EFF000AFF2800FF5A00FF8900FF
00FF9200FFC100FFF300D9FF00A5FF0071FF003DFF000AFF2600FF5400FF7F00FFA600FF
C900FFE700FFFF00FFFF00EBFF00DEFF00D7FF00D5FF00DAFF00E5FF00F5F300FFD800FF
B900FF9500FF6E00FF4400FF1900FF0013FF0040FF006CFF0097FF00C0FF00E6FF00FFF7
00FFD900FFC000FFAD00FF9F00FF9700FF9600FF9A00FFA500FFB500FFCB00FFE500FCFF
00DBFF00B7FF0092FF006CFF0047FF0023FF0002FF1A00FF3400FF4800FF5700FF6000FF
6300FF5F00FF5600FF4700FF3300FF1B00FF0000FF001DFF003BFF0059FF0076FF008FFF
00A5FF00B6FF00C1FF00C6FF00C5FF00BEFF00B1FF009FFF008BFF0074FF005DFF0047FF
0034FF0026FF001DFF001BFF001FFF0029FF0037FF0047FF0057FF0063FF006AFF006BFF
0065FF005BFF0053FF0053FF0057FF0058FF0051FF0048FF0041FF0040FF0046FF0052FF
0061FF0071FF0080FF008AFF008FFF008FFF0087FF007AFF0068FF0053FF003CFF0025FF
000FFF0200FF1000FF1800FF1A00FF1600FF0C00FF0002FF0017FF0030FF004CFF006AFF
0088FF00A6FF00C2FF00DBFF00F0FF00FFFF00FFF500FFF000FFF200FFFA00F7FF00E4FF
00CCFF00AFFF008EFF006BFF0046FF0021FF0400FF2800FF4A00FF6900FF8400FF9A00FF
AB00FFB700FFBD00FFBC00FFB600FFA900FF9700FF7F00FF6200FF4100FF1C00FF000BFF
0036FF0062FF008FFF00BCFF00E8FF00FFED00FFC500FFA100FF8000FF6400FF4D00FF3C
00FF3000FF2A00FF2A00FF3000FF3C00FF4E00FF6600FF8300FFA500FFCC00FFF600DBFF
00ABFF0078FF0044FF0010FF2300FF5600FF8800FFB800FF
00FFBD00FFED00E1FF00AEFF007AFF0046FF0012FF2000FF5100FF7F00FFAA00FFD100FF
F400FFFF00ECFF00D4FF00C0FF00B3FF00ABFF00AAFF00AFFF00BAFF00CAFF00E0FF00FC
E400FFC000FF9900FF6F00FF4400FF1700FF0015FF0041FF006CFF0095FF00BBFF00DDFF
00FBFF00FFEB00FFD800FFCA00FFC300FFC100FFC600FFD000FFE000FFF600EFFF00D1FF
00AFFF008CFF0066FF0041FF001CFF0700FF2800FF4600FF5F00FF7300FF8200FF8B00FF
8E00FF8A00FF8100FF7200FF5E00FF4600FF2B00FF0D00FF0010FF002EFF004AFF0064FF
007AFF008BFF0096FF009BFF009AFF0092FF0086FF0074FF0060FF0049FF0032FF001CFF
0009FF0400FF0D00FF0F00FF0B00FF0100FF000CFF001CFF002CFF0038FF003FFF0040FF
003AFF0030FF0028FF0028FF002CFF002DFF0026FF001DFF0016FF0015FF001BFF0026FF
0036FF0046FF0054FF005FFF0064FF0063FF005CFF004FFF003DFF0028FF0011FF0500FF
1B00FF2D00FF3B00FF4300FF4500FF4100FF3700FF2800FF1300FF0005FF0021FF003FFF
005DFF007BFF0097FF00B0FF00C4FF00D4FF00DFFF00E3FF00E2FF00DAFF00CCFF00B9FF
00A1FF0084FF0063FF0040FF001BFF0900FF2F00FF5300FF7500FF9400FFAF00FFC500FF
D600FFE200FFE800FFE700FFE100FFD400FFC200FFAA00FF8D00FF6C00FF4700FF1F00FF
000BFF0037FF0064FF0091FF00BDFF00E7FF00FFF000FFCC00FFAC00FF9000FF7800FF67
00FF5B00FF5500FF5500FF5B00FF6700FF7A00FF9100FFAF00FFD100FFF700DEFF00B0FF
007FFF004DFF0019FF1A00FF4E00FF8100FFB300FFE300FF
00FFE500EBFF00BAFF0087FF0053FF001EFF1500FF4700FF7800FFA600FFD100FFF900FF
FF00E3FF00C5FF00ACFF0099FF008CFF0084FF0083FF0088FF0092FF00A3FF00B9FF00D4
FF00F4E700FFC000FF9700FF6B00FF3E00FF1100FF001AFF0045FF006EFF0094FF00B6FF
00D4FF00ECFF00FFFF00FFF100FFEA00FFE800FFED00FFF700F7FF00E2FF00C8FF00AAFF
0088FF0064FF003FFF0019FF0B00FF2E00FF4F00FF6D00FF8600FF9B00FFA900FFB200FF
B500FFB200FFA800FF9A00FF8600FF6E00FF5200FF3500FF1600FF0007FF0023FF003DFF
0052FF0063FF006EFF0074FF0072FF006BFF005EFF004DFF0038FF0021FF000AFF0B00FF
1D00FF2B00FF3400FF3600FF3200FF2800FF1A00FF0A00FF0004FF0011FF0018FF0019FF
0013FF0009FF0001FF0000FF0005FF0006FF0000FF0A00FF1100FF1200FF0C00FF0000FF
000EFF001FFF002DFF0038FF003DFF003CFF0035FF0028FF0016FF0000FF1600FF2D00FF
4200FF5400FF6200FF6A00FF6D00FF6900FF5F00FF4F00FF3A00FF2100FF0500FF0018FF
0036FF0054FF0070FF0088FF009DFF00ADFF00B8FF00BCFF00BBFF00B3FF00A5FF0092FF
0079FF005CFF003CFF0019FF0B00FF3100FF5600FF7A00FF9C00FFBB00FFD600FFEC00FF
FE00FFFF00F6FF00F0FF00F0FF00F7FC00FFE900FFD200FFB500FF9300FF6E00FF4600FF
1B00FF0010FF003DFF006AFF0095FF00C0FF00E7FF00FFF300FFD300FFB700FFA000FF8E
00FF8200FF7C00FF7C00FF8200FF8F00FFA100FFB900FFD600FFF800E1FF00B6FF0088FF
0058FF0026FF0D00FF4100FF7500FFA900FFDB00FFFF00F5
00F7FF00C8FF0097FF0064FF0030FF0400FF3800FF6A00FF9B00FFC900FFF400FFFF00E3
FF00C0FF00A2FF0089FF0076FF0069FF0061FF0060FF0065FF0070FF0080FF0096FF00B1
FF00D1FF00F5E300FFBA00FF8E00FF6100FF3400FF0800FF0022FF004BFF0071FF0093FF
00B1FF00C9FF00DDFF00EBFF00F2FF00F4FF00EFFF00E5FF00D4FF00BFFF00A5FF0087FF
0065FF0041FF001CFF0800FF2E00FF5100FF7200FF9000FFA900FFBE00FFCC00FFD500FF
D800FFD500FFCB00FFBC00FFA900FF9000FF7500FF5800FF3900FF1B00FF0000FF001AFF
002FFF0040FF004BFF0051FF004FFF0048FF003BFF002AFF0015FF0100FF1800FF2E00FF
4000FF4E00FF5700FF5900FF5500FF4B00FF3D00FF2D00FF1E00FF1100FF0A00FF0900FF
0F00FF1900FF2100FF2200FF1D00FF1C00FF2300FF2D00FF3400FF3500FF2F00FF2300FF
1400FF0300FF000AFF0015FF001AFF0019FF0012FF0005FF0C00FF2200FF3900FF5000FF
6500FF7700FF8500FF8D00FF9000FF8C00FF8200FF7200FF5D00FF4400FF2800FF0A00FF
0013FF0031FF004DFF0065FF007AFF008AFF0095FF0099FF0098FF0090FF0082FF006FFF
0056FF0039FF0019FF0900FF2E00FF5400FF7900FF9D00FFBF00FFDE00FFF900FFFF00F0
FF00DEFF00D3FF00CDFF00CDFF00D4FF00E0FF00F3F500FFD800FFB600FF9100FF6900FF
3E00FF1200FF001AFF0047FF0073FF009DFF00C4FF00E9FF00FFF600FFDA00FFC300FFB1
00FFA500FF9F00FF9F00FFA500FFB200FFC400FFDC00FFF900E4FF00BEFF0093FF0066FF
0035FF0003FF3000FF6400FF9800FFCC00FFFE00FFFF00D2
00D9FF00AAFF0079FF0046FF0011FF2200FF5600FF8800FFB900FFE700FFFF00ECFF00C5
FF00A2FF0084FF006BFF0058FF004AFF0043FF0042FF0047FF0051FF0062FF0078FF0093
FF00B3FF00D6FF00FED800FFAC00FF7F00FF5300FF2600FF0004FF002DFF0053FF0075FF
0092FF00ABFF00BFFF00CCFF00D4FF00D6FF00D1FF00C6FF00B6FF00A1FF0087FF0068FF
0047FF0023FF0100FF2700FF4C00FF6F00FF9000FFAE00FFC700FFDC00FFEB00FFF300FF
F600FFF300FFEA00FFDB00FFC700FFAF00FF9300FF7600FF5700FF3900FF1D00FF0300FF
0011FF0022FF002DFF0032FF0031FF002AFF001DFF000CFF0800FF1F00FF3600FF4C00FF
5E00FF6D00FF7500FF7700FF7300FF6A00FF5C00FF4B00FF3C00FF2F00FF2800FF2800FF
2D00FF3700FF3F00FF4000FF3B00FF3A00FF4100FF4B00FF5200FF5300FF4D00FF4100FF
3200FF2200FF1300FF0800FF0300FF0400FF0B00FF1900FF2A00FF4000FF5700FF6E00FF
8300FF9500FFA300FFAB00FFAE00FFAA00FFA000FF9000FF7B00FF6200FF4600FF2800FF
0A00FF0013FF002EFF0047FF005CFF006CFF0076FF007BFF0079FF0072FF0064FF0051FF
0038FF001BFF0400FF2700FF4C00FF7200FF9700FFBB00FFDD00FFFC00FFFF00E8FF00D1
FF00C0FF00B5FF00AFFF00AFFF00B6FF00C2FF00D4FF00ECF600FFD500FFAF00FF8700FF
5C00FF3000FF0300FF0028FF0054FF007FFF00A6FF00CBFF00EBFF00FFF800FFE100FFCF
00FFC300FFBD00FFBD00FFC400FFD000FFE200FFFA00E8FF00C6FF00A0FF0075FF0047FF
0017FF1A00FF4E00FF8200FFB700FFEA00FFFF00E3FF00B4
00C0FF0091FF0060FF002DFF0600FF3B00FF6F00FFA100FFD200FFFF00FFFF00D4FF00AC
FF0089FF006BFF0052FF003FFF0032FF002AFF0029FF002EFF0038FF0049FF005FFF007A
FF009AFF00BEFF00E5F100FFC500FF9800FF6B00FF3F00FF1400FF0014FF003AFF005CFF
007AFF0092FF00A6FF00B4FF00BBFF00BDFF00B8FF00AEFF009DFF0088FF006EFF0050FF
002EFF000AFF1A00FF4000FF6500FF8800FFA900FFC700FFE000FFF500FFFF00FCFF00F3
FF00F0FF00F3FF00FDF300FFE000FFC800FFAC00FF8F00FF7000FF5200FF3600FF1C00FF
0700FF0009FF0014FF001AFF0018FF0011FF0004FF0C00FF2100FF3800FF4F00FF6500FF
7700FF8500FF8E00FF9000FF8C00FF8200FF7400FF6400FF5500FF4800FF4100FF4000FF
4600FF5000FF5800FF5900FF5400FF5300FF5A00FF6400FF6B00FF6C00FF6600FF5A00FF
4B00FF3A00FF2C00FF2100FF1C00FF1D00FF2400FF3100FF4300FF5900FF7000FF8700FF
9C00FFAE00FFBC00FFC400FFC700FFC300FFB900FFA900FF9400FF7B00FF5F00FF4100FF
2300FF0500FF0016FF002EFF0043FF0053FF005EFF0062FF0061FF0059FF004BFF0038FF
001FFF0002FF1D00FF4000FF6500FF8B00FFB000FFD400FFF600FFFF00EAFF00CFFF00B9
FF00A7FF009CFF0096FF0096FF009DFF00A9FF00BCFF00D3FF00F0ED00FFC800FFA000FF
7500FF4900FF1C00FF0010FF003BFF0066FF008DFF00B2FF00D2FF00EEFF00FFFA00FFE8
00FFDC00FFD600FFD600FFDC00FFE900FFFB00ECFF00CFFF00ADFF0087FF005CFF002FFF
0100FF3300FF6700FF9B00FFCF00FFFF00FCFF00CAFF009B
00ADFF007EFF004CFF0019FF1A00FF4E00FF8200FFB500FFE500FFFF00EBFF00C0FF0099
FF0076FF0058FF003FFF002CFF001EFF0017FF0016FF001AFF0025FF0036FF004CFF0067
FF0087FF00AAFF00D1FF00FBD800FFAC00FF7F00FF5200FF2700FF0001FF0026FF0049FF
0066FF007FFF0093FF00A0FF00A8FF00A9FF00A5FF009AFF008AFF0075FF005AFF003CFF
001BFF0800FF2D00FF5300FF7800FF9B00FFBD00FFDA00FFF300FFFF00F7FF00E8FF00DF
FF00DDFF00E0FF00E9FF00F8F300FFDB00FFBF00FFA200FF8400FF6600FF4900FF3000FF
1A00FF0900FF0001FF0006FF0005FF0100FF0E00FF1F00FF3400FF4B00FF6200FF7800FF
8B00FF9900FFA100FFA400FF9F00FF9600FF8800FF7800FF6800FF5B00FF5400FF5400FF
5A00FF6300FF6B00FF6C00FF6700FF6600FF6D00FF7700FF7E00FF7F00FF7900FF6D00FF
5E00FF4E00FF3F00FF3400FF2F00FF3000FF3800FF4500FF5700FF6C00FF8300FF9A00FF
AF00FFC100FFCF00FFD800FFDA00FFD600FFCC00FFBC00FFA700FF8E00FF7200FF5500FF
3600FF1800FF0002FF001BFF0030FF0040FF004AFF004FFF004DFF0046FF0038FF0024FF
000CFF1000FF3000FF5300FF7800FF9E00FFC300FFE700FFFF00F6FF00D7FF00BCFF00A5
FF0094FF0088FF0083FF0083FF0089FF0096FF00A8FF00C0FF00DDFF00FEDC00FFB300FF
8900FF5C00FF2F00FF0300FF0028FF0052FF007AFF009EFF00BFFF00DBFF00F2FF00FFFB
00FFEF00FFE900FFEA00FFF000FFFC00F1FF00D9FF00BCFF009AFF0073FF0049FF001BFF
1400FF4700FF7A00FFAF00FFE300FFFF00E9FF00B7FF0088
00A0FF0070FF003FFF000CFF2700FF5B00FF8F00FFC200FFF300FFFF00DEFF00B3FF008C
FF0069FF004AFF0032FF001EFF0011FF0009FF0008FF000DFF0018FF0028FF003EFF005A
FF0079FF009DFF00C4FF00EEE600FFB900FF8C00FF6000FF3500FF0C00FF0019FF003BFF
0059FF0072FF0085FF0093FF009AFF009CFF0097FF008DFF007DFF0067FF004DFF002FFF
000DFF1500FF3B00FF6000FF8500FFA900FFCA00FFE800FFFF00FEFF00EAFF00DBFF00D2
FF00CFFF00D3FF00DCFF00EBFF00FFE800FFCD00FFAF00FF9100FF7300FF5700FF3D00FF
2700FF1600FF0B00FF0600FF0700FF0F00FF1B00FF2D00FF4100FF5800FF6F00FF8500FF
9800FFA600FFAF00FFB100FFAD00FFA300FF9500FF8500FF7500FF6900FF6200FF6100FF
6700FF7100FF7900FF7900FF7500FF7400FF7B00FF8400FF8B00FF8C00FF8600FF7B00FF
6B00FF5B00FF4D00FF4200FF3D00FF3E00FF4500FF5200FF6400FF7900FF9000FFA700FF
BD00FFCF00FFDD00FFE500FFE700FFE300FFD900FFCA00FFB500FF9C00FF8000FF6200FF
4400FF2600FF0A00FF000EFF0022FF0032FF003DFF0041FF0040FF0038FF002AFF0017FF
0000FF1D00FF3E00FF6100FF8600FFAB00FFD100FFF500FFFF00E8FF00C9FF00AEFF0098
FF0087FF007BFF0075FF0076FF007CFF0089FF009BFF00B3FF00D0FF00F1E900FFC100FF
9600FF6A00FF3D00FF1000FF001BFF0045FF006DFF0091FF00B1FF00CDFF00E5FF00F6FF
00FFFD00FFF700FFF700FFFD00F6FF00E3FF00CCFF00AEFF008CFF0066FF003CFF000EFF
2200FF5400FF8800FFBC00FFF000FFFF00DCFF00AAFF007A
0098FF0069FF0038FF0005FF2E00FF6300FF9700FFC900FFFA00FFFF00D7FF00ABFF0084
FF0061FF0043FF002AFF0017FF0009FF0002FF0001FF0006FF0010FF0021FF0037FF0052
FF0072FF0095FF00BDFF00E6ED00FFC000FF9300FF6700FF3C00FF1300FF0012FF0034FF
0051FF006AFF007EFF008BFF0093FF0095FF0090FF0085FF0075FF0060FF0046FF0027FF
0006FF1D00FF4200FF6800FF8D00FFB000FFD100FFEF00FFFF00F7FF00E2FF00D3FF00CB
FF00C8FF00CBFF00D5FF00E3FF00F7F000FFD400FFB700FF9800FF7A00FF5E00FF4400FF
2F00FF1E00FF1300FF0E00FF0F00FF1600FF2300FF3400FF4900FF6000FF7700FF8D00FF
9F00FFAE00FFB600FFB800FFB400FFAA00FF9D00FF8C00FF7D00FF7000FF6900FF6900FF
6E00FF7800FF8000FF8100FF7C00FF7B00FF8200FF8C00FF9300FF9400FF8E00FF8200FF
7300FF6200FF5400FF4900FF4400FF4500FF4C00FF5900FF6B00FF8100FF9800FFAF00FF
C400FFD600FFE400FFEC00FFEF00FFEB00FFE100FFD100FFBC00FFA300FF8700FF6900FF
4B00FF2D00FF1100FF0006FF001BFF002BFF0035FF003AFF0038FF0031FF0023FF0010FF
0800FF2500FF4500FF6800FF8D00FFB300FFD800FFFC00FFFF00E1FF00C2FF00A7FF0091
FF007FFF0074FF006EFF006EFF0075FF0081FF0093FF00ABFF00C8FF00E9F000FFC800FF
9D00FF7100FF4400FF1700FF0013FF003EFF0065FF008AFF00AAFF00C6FF00DDFF00EFFF
00FBFF00FFFE00FFFE00FAFF00EEFF00DCFF00C4FF00A7FF0085FF005FFF0034FF0006FF
2900FF5B00FF8F00FFC300FFF700FFFF00D4FF00A2FF0073
0097FF0068FF0036FF0003FF3000FF6400FF9800FFCB00FFFB00FFFF00D5FF00AAFF0083
FF0060FF0042FF0029FF0016FF0008FF0001FF0000FF0004FF000FFF0020FF0036FF0051
FF0071FF0094FF00BBFF00E5EE00FFC200FF9500FF6800FF3D00FF1500FF0010FF0032FF
0050FF0069FF007CFF008AFF0092FF0093FF008FFF0084FF0074FF005FFF0044FF0026FF
0005FF1E00FF4300FF6900FF8E00FFB200FFD300FFF000FFFF00F5FF00E1FF00D2FF00C9
FF00C7FF00CAFF00D3FF00E2FF00F6F100FFD600FFB800FF9A00FF7C00FF5F00FF4600FF
3000FF1F00FF1400FF0F00FF1000FF1700FF2400FF3500FF4A00FF6100FF7800FF8E00FF
A100FFAF00FFB700FFBA00FFB500FFAC00FF9E00FF8E00FF7E00FF7100FF6A00FF6A00FF
7000FF7900FF8100FF8200FF7D00FF7C00FF8300FF8D00FF9400FF9500FF8F00FF8300FF
7400FF6400FF5500FF4B00FF4500FF4600FF4E00FF5B00FF6D00FF8200FF9900FFB000FF
C500FFD800FFE500FFEE00FFF000FFEC00FFE200FFD200FFBD00FFA500FF8900FF6B00FF
4C00FF2F00FF1300FF0005FF001AFF002AFF0034FF0039FF0037FF002FFF0022FF000EFF
0900FF2600FF4600FF6900FF8E00FFB400FFD900FFFE00FFFF00E0FF00C1FF00A6FF008F
FF007EFF0072FF006DFF006DFF0073FF0080FF0092FF00AAFF00C7FF00E8F200FFC900FF
9F00FF7200FF4600FF1900FF0012FF003CFF0064FF0088FF00A9FF00C5FF00DCFF00EEFF
00FAFF00FFFF00FFFF00F9FF00EDFF00DBFF00C3FF00A6FF0084FF005DFF0033FF0005FF
2A00FF5D00FF9000FFC500FFF900FFFF00D3FF00A1FF0071
009CFF006DFF003BFF0008FF2B00FF5F00FF9300FFC600FFF700FFFF00DAFF00AFFF0088
FF0065FF0047FF002EFF001AFF000DFF0006FF0004FF0009FF0014FF0025FF003BFF0056
FF0075FF0099FF00C0FF00EAEA00FFBD00FF9000FF6400FF3900FF1000FF0015FF0037FF
0055FF006EFF0081FF008FFF0097FF0098FF0094FF0089FF0079FF0063FF0049FF002BFF
000AFF1900FF3E00FF6400FF8900FFAD00FFCE00FFEB00FFFF00FAFF00E6FF00D7FF00CE
FF00CBFF00CFFF00D8FF00E7FF00FBEC00FFD100FFB300FF9500FF7700FF5A00FF4100FF
2B00FF1A00FF0F00FF0A00FF0B00FF1200FF1F00FF3000FF4500FF5C00FF7300FF8900FF
9C00FFAA00FFB300FFB500FFB100FFA700FF9900FF8900FF7900FF6D00FF6500FF6500FF
6B00FF7400FF7C00FF7D00FF7900FF7800FF7F00FF8800FF8F00FF9000FF8A00FF7E00FF
6F00FF5F00FF5000FF4600FF4000FF4100FF4900FF5600FF6800FF7D00FF9400FFAB00FF
C100FFD300FFE000FFE900FFEB00FFE700FFDD00FFCD00FFB900FFA000FF8400FF6600FF
4700FF2A00FF0E00FF000AFF001FFF002FFF0039FF003EFF003CFF0034FF0027FF0013FF
0400FF2100FF4200FF6500FF8A00FFAF00FFD500FFF900FFFF00E4FF00C5FF00AAFF0094
FF0083FF0077FF0071FF0072FF0078FF0085FF0097FF00AFFF00CCFF00EDED00FFC500FF
9A00FF6E00FF4100FF1400FF0017FF0041FF0069FF008DFF00AEFF00CAFF00E1FF00F2FF
00FEFF00FFFB00FFFB00FEFF00F2FF00E0FF00C8FF00ABFF0089FF0062FF0038FF000AFF
2500FF5800FF8B00FFC000FFF400FFFF00D8FF00A6FF0076
00A7FF0077FF0046FF0013FF2000FF5400FF8800FFBB00FFEC00FFFF00E5FF00BAFF0092
FF0070FF0051FF0038FF0025FF0018FF0010FF000FFF0014FF001FFF002FFF0045FF0060
FF0080FF00A4FF00CBFF00F5DF00FFB200FF8500FF5900FF2E00FF0500FF0020FF0042FF
0060FF0079FF008CFF009AFF00A1FF00A3FF009EFF0094FF0084FF006EFF0054FF0036FF
0014FF0E00FF3400FF5900FF7E00FFA200FFC300FFE100FFFA00FFFF00F1FF00E2FF00D9
FF00D6FF00DAFF00E3FF00F2F900FFE100FFC600FFA800FF8A00FF6C00FF5000FF3600FF
2000FF0F00FF0400FF0000FF0000FF0800FF1400FF2600FF3A00FF5100FF6800FF7E00FF
9100FF9F00FFA800FFAA00FFA600FF9C00FF8E00FF7E00FF6E00FF6200FF5B00FF5A00FF
6000FF6A00FF7200FF7200FF6E00FF6D00FF7400FF7D00FF8400FF8500FF7F00FF7400FF
6400FF5400FF4600FF3B00FF3600FF3700FF3E00FF4B00FF5D00FF7200FF8900FFA000FF
B600FFC800FFD600FFDE00FFE000FFDC00FFD200FFC300FFAE00FF9500FF7900FF5B00FF
3D00FF1F00FF0300FF0015FF0029FF0039FF0044FF0048FF0047FF003FFF0031FF001EFF
0006FF1600FF3700FF5A00FF7F00FFA400FFCA00FFEE00FFFF00EFFF00D0FF00B5FF009F
FF008EFF0082FF007CFF007DFF0083FF008FFF00A2FF00BAFF00D7FF00F8E200FFBA00FF
8F00FF6300FF3600FF0900FF0022FF004CFF0074FF0098FF00B8FF00D4FF00ECFF00FDFF
00FFF600FFF000FFF000FFF600FDFF00EAFF00D3FF00B5FF0093FF006DFF0042FF0015FF
1B00FF4D00FF8100FFB500FFE900FFFF00E3FF00B1FF0081
00B7FF0088FF0057FF0024FF1000FF4400FF7800FFAA00FFDB00FFFF00F5FF00CAFF00A3
FF0080FF0062FF0049FF0036FF0028FF0021FF0020FF0025FF002FFF0040FF0056FF0071
FF0091FF00B4FF00DBFA00FFCE00FFA200FF7500FF4800FF1D00FF000BFF0031FF0053FF
0070FF0089FF009DFF00AAFF00B2FF00B4FF00AFFF00A4FF0094FF007FFF0065FF0046FF
0025FF0001FF2300FF4900FF6E00FF9100FFB200FFD000FFE900FFFE00FFFF00F2FF00EA
FF00E7FF00EAFF00F3FD00FFE900FFD100FFB500FF9800FF7A00FF5B00FF3F00FF2500FF
1000FF0000FF000BFF0010FF000FFF0008FF0400FF1500FF2A00FF4100FF5800FF6E00FF
8000FF8F00FF9700FF9900FF9500FF8C00FF7E00FF6E00FF5E00FF5100FF4A00FF4A00FF
5000FF5900FF6100FF6200FF5D00FF5C00FF6300FF6D00FF7400FF7500FF6F00FF6300FF
5400FF4400FF3500FF2A00FF2500FF2600FF2D00FF3B00FF4D00FF6200FF7900FF9000FF
A500FFB700FFC500FFCD00FFD000FFCC00FFC200FFB200FF9D00FF8400FF6800FF4B00FF
2C00FF0E00FF000CFF0025FF003AFF004AFF0054FF0059FF0057FF0050FF0042FF002FFF
0016FF0600FF2600FF4900FF6E00FF9400FFB900FFDD00FFFF00FFFF00E1FF00C6FF00AF
FF009EFF0093FF008DFF008DFF0094FF00A0FF00B2FF00CAFF00E7F700FFD100FFA900FF
7E00FF5200FF2500FF0006FF0032FF005CFF0084FF00A8FF00C9FF00E5FF00FCFF00FFF1
00FFE500FFDF00FFDF00FFE600FFF200FBFF00E3FF00C6FF00A4FF007DFF0053FF0025FF
0A00FF3C00FF7000FFA400FFD900FFFF00F3FF00C1FF0092
00CDFF009EFF006DFF003AFF0005FF2E00FF6200FF9400FFC500FFF300FFFF00E0FF00B9
FF0096FF0078FF005FFF004CFF003EFF0037FF0036FF003BFF0045FF0056FF006CFF0087
FF00A7FF00CAFF00F2E400FFB800FF8B00FF5F00FF3200FF0700FF0021FF0047FF0069FF
0086FF009FFF00B3FF00C0FF00C8FF00CAFF00C5FF00BAFF00AAFF0095FF007BFF005CFF
003BFF0017FF0D00FF3300FF5800FF7B00FF9C00FFBA00FFD300FFE800FFF700FFFF00FF
FF00FDFF00FFF600FFE700FFD300FFBB00FF9F00FF8200FF6300FF4500FF2900FF0F00FF
0005FF0016FF0021FF0026FF0025FF001EFF0011FF0000FF1400FF2B00FF4200FF5800FF
6A00FF7900FF8100FF8300FF7F00FF7600FF6800FF5700FF4800FF3B00FF3400FF3400FF
3900FF4300FF4B00FF4C00FF4700FF4600FF4D00FF5700FF5E00FF5F00FF5900FF4D00FF
3E00FF2D00FF1F00FF1400FF0F00FF1000FF1700FF2500FF3600FF4C00FF6300FF7A00FF
8F00FFA100FFAF00FFB700FFBA00FFB600FFAC00FF9C00FF8700FF6E00FF5200FF3400FF
1600FF0007FF0022FF003BFF0050FF0060FF006AFF006FFF006DFF0066FF0058FF0045FF
002CFF000FFF1000FF3300FF5800FF7E00FFA300FFC700FFE900FFFF00F7FF00DCFF00C6
FF00B4FF00A9FF00A3FF00A3FF00AAFF00B6FF00C8FF00E0FF00FDE100FFBB00FF9300FF
6800FF3C00FF0F00FF001DFF0048FF0073FF009AFF00BFFF00DFFF00FBFF00FFED00FFDB
00FFCF00FFC900FFC900FFD000FFDC00FFEE00F9FF00DCFF00BAFF0094FF0069FF003BFF
000BFF2600FF5A00FF8E00FFC300FFF600FFFF00D7FF00A8
00E8FF00B9FF0088FF0055FF0021FF1300FF4700FF7900FFAA00FFD800FFFF00FCFF00D4
FF00B1FF0093FF007AFF0067FF005AFF0052FF0051FF0056FF0060FF0071FF0087FF00A2
FF00C2FF00E6F200FFC900FF9D00FF7000FF4300FF1700FF0013FF003CFF0062FF0084FF
00A2FF00BAFF00CEFF00DCFF00E3FF00E5FF00E0FF00D6FF00C5FF00B0FF0096FF0078FF
0056FF0032FF000DFF1800FF3D00FF6000FF8100FF9F00FFB800FFCD00FFDB00FFE400FF
E700FFE400FFDA00FFCB00FFB800FFA000FF8400FF6700FF4800FF2A00FF0E00FF000BFF
0020FF0031FF003CFF0042FF0040FF0039FF002CFF001BFF0006FF1000FF2700FF3D00FF
4F00FF5D00FF6600FF6800FF6400FF5A00FF4C00FF3C00FF2D00FF2000FF1900FF1800FF
1E00FF2800FF3000FF3100FF2C00FF2B00FF3200FF3C00FF4300FF4400FF3E00FF3200FF
2300FF1200FF0400FF0006FF000BFF000AFF0003FF0900FF1B00FF3100FF4800FF5F00FF
7400FF8600FF9400FF9C00FF9F00FF9B00FF9100FF8100FF6C00FF5300FF3700FF1900FF
0004FF0022FF003EFF0056FF006BFF007BFF0086FF008AFF0089FF0081FF0073FF0060FF
0047FF002AFF000AFF1800FF3D00FF6300FF8800FFAC00FFCE00FFED00FFFF00F7FF00E1
FF00CFFF00C4FF00BEFF00BEFF00C5FF00D1FF00E4FF00FBE700FFC500FFA000FF7800FF
4D00FF2100FF000BFF0038FF0063FF008EFF00B5FF00DAFF00FAFF00FFE900FFD200FFC0
00FFB400FFAE00FFAE00FFB400FFC100FFD300FFEB00F7FF00D5FF00AFFF0084FF0057FF
0026FF0B00FF3F00FF7300FFA700FFDB00FFFF00F2FF00C3
00FFF700D9FF00A7FF0074FF0040FF000CFF2700FF5A00FF8A00FFB900FFE400FFFF00F4
FF00D1FF00B3FF009AFF0087FF0079FF0072FF0071FF0075FF0080FF0091FF00A7FF00C2
FF00E2FA00FFD300FFA900FF7D00FF5100FF2400FF0008FF0033FF005CFF0081FF00A3FF
00C1FF00DAFF00EEFF00FBFF00FFFC00FFFB00FFFF00F5FF00E5FF00D0FF00B5FF0097FF
0076FF0052FF002DFF0007FF1D00FF4100FF6200FF7F00FF9900FFAD00FFBC00FFC500FF
C700FFC400FFBB00FFAC00FF9800FF8000FF6500FF4700FF2900FF0B00FF0011FF002AFF
0040FF0051FF005CFF0061FF0060FF0059FF004CFF003BFF0026FF000FFF0700FF1D00FF
3000FF3E00FF4600FF4900FF4400FF3B00FF2D00FF1D00FF0D00FF0000FF0006FF0006FF
0000FF0800FF1000FF1100FF0C00FF0B00FF1200FF1C00FF2300FF2400FF1E00FF1200FF
0300FF000CFF001BFF0026FF002BFF002AFF0022FF0015FF0003FF1100FF2800FF3F00FF
5400FF6700FF7400FF7D00FF7F00FF7B00FF7100FF6100FF4C00FF3300FF1800FF0005FF
0024FF0041FF005DFF0076FF008BFF009BFF00A5FF00AAFF00A8FF00A0FF0093FF007FFF
0067FF004AFF002AFF0007FF1D00FF4300FF6800FF8C00FFAE00FFCD00FFE800FFFF00FF
FF00EFFF00E3FF00DEFF00DEFF00E4FF00F1FC00FFE400FFC700FFA600FF8100FF5800FF
2E00FF0100FF002AFF0057FF0083FF00ADFF00D5FF00F9FF00FFE500FFC900FFB200FFA0
00FF9400FF8E00FF8F00FF9500FFA100FFB300FFCB00FFE800F5FF00CEFF00A4FF0076FF
0046FF0013FF1F00FF5400FF8800FFBB00FFED00FFFF00E3
00FFD300FDFF00CBFF0098FF0064FF0030FF0300FF3600FF6700FF9500FFC000FFE700FF
FF00F5FF00D6FF00BEFF00AAFF009DFF0095FF0094FF0099FF00A4FF00B4FF00CAFF00E6
FA00FFD600FFAF00FF8500FF5A00FF2D00FF0000FF002BFF0056FF007FFF00A5FF00C7FF
00E5FF00FEFF00FFEE00FFE000FFD800FFD700FFDC00FFE600FFF600F3FF00D9FF00BBFF
009AFF0076FF0051FF002BFF0006FF1D00FF3E00FF5B00FF7500FF8900FF9800FFA100FF
A400FFA000FF9700FF8800FF7400FF5C00FF4100FF2300FF0500FF0018FF0034FF004EFF
0064FF0075FF0080FF0085FF0084FF007DFF0070FF005EFF004AFF0033FF001CFF0006FF
0C00FF1A00FF2300FF2500FF2100FF1700FF0900FF0006FF0016FF0022FF0029FF002AFF
0024FF001AFF0012FF0012FF0016FF0017FF0010FF0007FF0000FF0000FF0005FF0010FF
0020FF0030FF003FFF0049FF004EFF004DFF0046FF0039FF0027FF0012FF0400FF1B00FF
3100FF4300FF5100FF5900FF5B00FF5700FF4D00FF3E00FF2900FF1000FF000BFF0029FF
0047FF0065FF0081FF009AFF00AFFF00BEFF00C9FF00CDFF00CCFF00C4FF00B6FF00A3FF
008BFF006EFF004DFF002AFF0005FF1F00FF4500FF6900FF8B00FFAA00FFC500FFDB00FF
EC00FFF800FFFE00FFFD00FFF700FFEA00FFD800FFC000FFA300FF8200FF5D00FF3500FF
0A00FF0021FF004EFF007BFF00A7FF00D1FF00F9FF00FFE200FFC100FFA500FF8E00FF7D
00FF7100FF6B00FF6B00FF7100FF7D00FF8F00FFA700FFC400FFE700F2FF00C8FF009AFF
0069FF0037FF0003FF3000FF6400FF9700FFC900FFF900FF
00FFAC00FFDB00F2FF00BFFF008BFF0057FF0023FF0F00FF4000FF6E00FF9900FFC000FF
E300FFFF00FEFF00E5FF00D1FF00C4FF00BDFF00BBFF00C0FF00CBFF00DBFF00F2F200FF
D300FFAF00FF8800FF5E00FF3300FF0600FF0026FF0052FF007DFF00A6FF00CCFF00EEFF
00FFF300FFDA00FFC700FFB900FFB100FFB000FFB400FFBF00FFCF00FFE500FFFF00E2FF
00C1FF009DFF0078FF0052FF002DFF0009FF1700FF3400FF4E00FF6200FF7100FF7A00FF
7D00FF7900FF7000FF6100FF4D00FF3500FF1A00FF0003FF0021FF003FFF005CFF0075FF
008BFF009CFF00A7FF00ACFF00ABFF00A4FF0097FF0085FF0071FF005AFF0043FF002DFF
001AFF000CFF0003FF0001FF0005FF000FFF001DFF002DFF003DFF0049FF0050FF0051FF
004BFF0042FF0039FF0039FF003DFF003EFF0037FF002EFF0027FF0026FF002CFF0038FF
0047FF0057FF0066FF0070FF0076FF0075FF006DFF0060FF004EFF0039FF0022FF000BFF
0A00FF1C00FF2A00FF3200FF3400FF3000FF2600FF1700FF0200FF0016FF0032FF0050FF
006EFF008CFF00A8FF00C1FF00D6FF00E6FF00F0FF00F5FF00F3FF00EBFF00DDFF00CAFF
00B2FF0095FF0074FF0051FF002CFF0007FF1E00FF4200FF6400FF8300FF9E00FFB400FF
C500FFD100FFD700FFD600FFD000FFC300FFB100FF9900FF7C00FF5B00FF3600FF0E00FF
001CFF0048FF0075FF00A2FF00CEFF00F8FF00FFDF00FFBB00FF9A00FF7E00FF6700FF56
00FF4A00FF4400FF4400FF4A00FF5600FF6800FF8000FF9D00FFBF00FFE600EFFF00C1FF
0091FF005EFF002AFF0900FF3D00FF7000FFA200FFD200FF
00FF8300FFB200FFE300E9FF00B5FF0080FF004DFF001AFF1600FF4400FF6F00FF9700FF
BA00FFD800FFF100FFFF00FBFF00EEFF00E6FF00E5FF00EAFF00F5FA00FFE400FFC900FF
A900FF8500FF5E00FF3500FF0900FF0023FF0050FF007CFF00A7FF00D0FF00F6FF00FFE7
00FFC900FFB000FF9D00FF8F00FF8800FF8600FF8B00FF9500FFA600FFBB00FFD500FFF3
00EAFF00C6FF00A1FF007CFF0056FF0033FF0012FF0B00FF2400FF3800FF4700FF5000FF
5300FF5000FF4600FF3700FF2300FF0B00FF000FFF002CFF004BFF0069FF0085FF009FFF
00B5FF00C5FF00D1FF00D6FF00D5FF00CDFF00C1FF00AFFF009AFF0084FF006CFF0057FF
0044FF0036FF002DFF002BFF002FFF0039FF0047FF0057FF0066FF0073FF007AFF007BFF
0075FF006BFF0063FF0062FF0067FF0068FF0061FF0057FF0050FF0050FF0056FF0061FF
0071FF0081FF008FFF009AFF009FFF009EFF0097FF008AFF0078FF0062FF004BFF0034FF
001FFF000DFF0000FF0800FF0B00FF0700FF0002FF0012FF0027FF0040FF005CFF007AFF
0098FF00B6FF00D2FF00EBFF00FFFF00FFF000FFE500FFE100FFE200FFEA00FFF800F4FF
00DBFF00BFFF009EFF007BFF0056FF0030FF000BFF1800FF3A00FF5900FF7400FF8A00FF
9C00FFA700FFAD00FFAD00FFA600FF9A00FF8700FF6F00FF5300FF3100FF0C00FF001BFF
0046FF0072FF009FFF00CCFF00F8FF00FFDD00FFB600FF9100FF7100FF5500FF3E00FF2C
00FF2000FF1A00FF1A00FF2000FF2D00FF3F00FF5700FF7400FF9600FFBC00FFE700EBFF
00BAFF0088FF0054FF0020FF1300FF4700FF7800FFA800FF
00FF5700FF8600FFB800FFEB00E0FF00ACFF0078FF0045FF0015FF1900FF4400FF6B00FF
8E00FFAC00FFC500FFD800FFE600FFED00FFEE00FFEA00FFDF00FFCE00FFB800FF9D00FF
7D00FF5A00FF3300FF0900FF0022FF004EFF007BFF00A8FF00D3FF00FCFF00FFDE00FFBB
00FF9E00FF8500FF7100FF6400FF5C00FF5B00FF5F00FF6A00FF7A00FF8F00FFAA00FFC8
00FFE900F2FF00CDFF00A7FF0082FF005FFF003DFF0020FF0007FF0D00FF1C00FF2500FF
2700FF2400FF1B00FF0C00FF0007FF001FFF003BFF0058FF0076FF0094FF00B1FF00CAFF
00E0FF00F1FF00FCFF00FFFE00FFFF00F9FF00ECFF00DBFF00C6FF00AFFF0098FF0082FF
006FFF0061FF0059FF0056FF005BFF0064FF0072FF0082FF0092FF009FFF00A6FF00A6FF
00A0FF0097FF008FFF008EFF0093FF0094FF008DFF0083FF007CFF007BFF0081FF008DFF
009CFF00ACFF00BBFF00C6FF00CBFF00CAFF00C2FF00B5FF00A3FF008EFF0077FF0060FF
004BFF0039FF002BFF0022FF0020FF0024FF002EFF003EFF0053FF006CFF0088FF00A5FF
00C4FF00E1FF00FDFF00FFE900FFD400FFC400FFBA00FFB500FFB700FFBE00FFCC00FFE0
00FFF800EAFF00CAFF00A7FF0082FF005CFF0037FF0013FF0E00FF2D00FF4800FF5F00FF
7000FF7C00FF8100FF8100FF7B00FF6E00FF5C00FF4400FF2700FF0600FF001EFF0047FF
0071FF009EFF00CBFF00F7FF00FFDC00FFB200FF8A00FF6600FF4500FF2900FF1200FF00
0BFF0011FF0010FF000AFF0000FF0100FF1300FF2B00FF4800FF6A00FF9100FFBB00FFE9
00E6FF00B3FF0080FF004BFF0017FF1B00FF4D00FF7C00FF
00FF2A00FF5900FF8B00FFBE00FFF200D9FF00A5FF0072FF0041FF0013FF1700FF3E00FF
6100FF7F00FF9800FFAC00FFB900FFC000FFC200FFBD00FFB200FFA200FF8B00FF7000FF
5100FF2D00FF0600FF0023FF004EFF007BFF00A8FF00D4FF00FFFF00FFD700FFB100FF8F
00FF7100FF5800FF4500FF3700FF2F00FF2E00FF3200FF3D00FF4D00FF6300FF7D00FF9B
00FFBC00FFE000FAFF00D4FF00AFFF008BFF006AFF004DFF0033FF001FFF0010FF0007FF
0004FF0008FF0011FF0020FF0034FF004CFF0067FF0085FF00A3FF00C1FF00DEFF00F7FF
00FFF200FFE100FFD600FFD100FFD200FFD900FFE600FFF800F3FF00DCFF00C5FF00AFFF
009CFF008EFF0085FF0083FF0087FF0091FF009FFF00AFFF00BFFF00CBFF00D2FF00D3FF
00CDFF00C4FF00BBFF00BBFF00BFFF00C0FF00B9FF00B0FF00A9FF00A8FF00AEFF00BAFF
00C9FF00D9FF00E8FF00F2FF00F8FF00F7FF00EFFF00E2FF00D0FF00BBFF00A4FF008DFF
0077FF0065FF0057FF004FFF004DFF0051FF005BFF006AFF007FFF0098FF00B4FF00D2FF
00F0FF00FFF100FFD500FFBC00FFA700FF9700FF8D00FF8800FF8A00FF9200FFA000FFB3
00FFCB00FFE800F6FF00D3FF00AEFF0089FF0063FF003FFF001DFF0100FF1C00FF3200FF
4300FF4F00FF5500FF5400FF4E00FF4100FF2F00FF1700FF0005FF0026FF004BFF0073FF
009EFF00CAFF00F7FF00FFDB00FFAF00FF8500FF5D00FF3900FF1803FF001AFF002BFF00
37FF003DFF003DFF0037FF002BFF0019FF0001FF0000FF1B00FF3D00FF6400FF8E00FFBC
00FFEC00E0FF00ACFF0078FF0044FF0011FF2000FF5000FF
02FF0000FF2C00FF5E00FF9100FFC500FFF900D2FF009FFF006EFF0040FF0015FF1100FF
3400FF5300FF6B00FF7F00FF8C00FF9300FF9500FF9000FF8500FF7500FF5F00FF4300FF
2400FF0000FF0026FF0050FF007BFF00A8FF00D5FF00FFFE00FFD300FFAA00FF8400FF62
00FF4400FF2B00FF1800FF0A00FF0200FF0100FF0600FF1000FF2000FF3600FF5000FF6E
00FF8F00FFB300FFD800FFFE00DCFF00B8FF0097FF007AFF0060FF004CFF003DFF0034FF
0031FF0035FF003EFF004DFF0061FF0079FF0094FF00B2FF00D0FF00EEFF00FFF400FFDB
00FFC500FFB400FFA900FFA400FFA500FFAC00FFB900FFCB00FFDF00FFF600F2FF00DCFF
00C9FF00BBFF00B2FF00B0FF00B4FF00BEFF00CCFF00DCFF00ECFF00F8FF00FFFF00FFFF
00FAFF00F0FF00E8FF00E8FF00ECFF00EDFF00E6FF00DDFF00D6FF00D5FF00DBFF00E6FF
00F6FF00FFF900FFEA00FFE000FFDB00FFDB00FFE300FFF000FDFF00E8FF00D1FF00BAFF
00A4FF0092FF0084FF007CFF007AFF007EFF0088FF0097FF00ACFF00C5FF00E1FF00FFFF
00FFE200FFC400FFA800FF8F00FF7A00FF6B00FF6000FF5B00FF5D00FF6500FF7300FF86
00FF9E00FFBB00FFDC00FFFF00DBFF00B6FF0090FF006CFF004AFF002BFF0010FF0500FF
1600FF2200FF2800FF2700FF2100FF1400FF0200FF0015FF0032FF0053FF0078FF00A0FF
00CBFF00F7FF00FFDB00FFAE00FF8200FF5800FF3000FF0C14FF0030FF0047FF0058FF00
64FF006AFF006AFF0064FF0058FF0046FF002EFF0011FF0000FF1000FF3700FF6100FF8F
00FFBF00FFF200D9FF00A5FF0071FF003EFF000CFF2300FF
2EFF0000FF0000FF3100FF6500FF9900FFCD00FEFF00CCFF009BFF006CFF0041FF001AFF
0800FF2600FF3F00FF5200FF6000FF6700FF6800FF6400FF5900FF4800FF3200FF1700FF
0008FF002BFF0052FF007CFF00A8FF00D4FF00FFFE00FFD100FFA600FF7D00FF5800FF35
00FF1800FF0014FF0021FF0029FF002AFF0026FF001BFF000BFF0000FF0900FF2300FF42
00FF6300FF8700FFAC00FFD200FFF700E5FF00C4FF00A6FF008DFF0078FF0069FF0060FF
005EFF0061FF006AFF0079FF008DFF00A5FF00C1FF00DEFF00FCFF00FFE500FFC800FFAE
00FF9900FF8800FF7D00FF7800FF7900FF8000FF8D00FF9E00FFB300FFCA00FFE100FFF7
00F6FF00E7FF00DFFF00DDFF00E1FF00EAFF00F8FF00FFF700FFE700FFDA00FFD300FFD3
00FFD900FFE200FFEA00FFEB00FFE600FFE500FFEC00FFF600FFFD00FFFE00FFF800FFEC
00FFDD00FFCD00FFBE00FFB300FFAE00FFAF00FFB600FFC400FFD600FFEB00FDFF00E6FF
00D1FF00BFFF00B1FF00A9FF00A6FF00AAFF00B4FF00C4FF00D9FF00F2FF00FFF100FFD4
00FFB500FF9700FF7C00FF6300FF4E00FF3E00FF3400FF2F00FF3100FF3800FF4600FF59
00FF7200FF8F00FFAF00FFD200FFF700E2FF00BDFF0099FF0077FF0058FF003DFF0026FF
0015FF0009FF0004FF0004FF000AFF0017FF0029FF0041FF005EFF007FFF00A5FF00CDFF
00F7FF00FFDB00FFAE00FF8200FF5600FF2C00FF041FFF0040FF005CFF0073FF0085FF00
91FF0097FF0097FF0090FF0084FF0072FF005AFF003DFF001BFF0000FF0B00FF3500FF63
00FF9300FFC500FFF900D2FF009DFF006AFF0038FF0009FF
59FF002AFF0000FF0600FF3A00FF6E00FFA200FFD600F7FF00C6FF0097FF006CFF0045FF
0022FF0004FF1400FF2700FF3500FF3C00FF3D00FF3900FF2E00FF1D00FF0700FF0013FF
0033FF0056FF007DFF00A7FF00D3FF00FFFF00FFD300FFA600FF7B00FF5200FF2D00FF0A
12FF002BFF003FFF004CFF0054FF0056FF0051FF0046FF0036FF0021FF0007FF0000FF17
00FF3800FF5C00FF8100FFA700FFCC00FFEF00EFFF00D1FF00B8FF00A3FF0094FF008BFF
0089FF008CFF0095FF00A4FF00B8FF00D0FF00ECFF00FFF600FFD800FFBA00FF9D00FF83
00FF6E00FF5D00FF5200FF4D00FF4E00FF5500FF6200FF7300FF8800FF9F00FFB600FFCC
00FFDE00FFED00FFF500FFF700FFF300FFEA00FFDC00FFCC00FFBC00FFAF00FFA800FFA8
00FFAE00FFB700FFBF00FFC000FFBB00FFBA00FFC100FFCB00FFD200FFD300FFCD00FFC1
00FFB200FFA200FF9300FF8800FF8300FF8400FF8B00FF9900FFAB00FFC000FFD700FFEE
00FCFF00EAFF00DCFF00D4FF00D1FF00D5FF00DFFF00EFFF00FFFB00FFE200FFC600FFA9
00FF8A00FF6C00FF5100FF3800FF2300FF1300FF0900FF0400FF0600FF0D00FF1B00FF2E
00FF4700FF6400FF8400FFA700FFCC00FFF200E8FF00C4FF00A2FF0083FF0068FF0051FF
0040FF0034FF002FFF002FFF0036FF0042FF0054FF006CFF0089FF00AAFF00D0FF00F8FF
00FFDD00FFB000FF8300FF5700FF2B00FF0126FF004AFF006BFF0087FF009EFF00B0FF00
BCFF00C2FF00C2FF00BBFF00AFFF009DFF0085FF0068FF0046FF001FFF0000FF0A00FF38
00FF6800FF9A00FFCE00FDFF00C8FF0095FF0063FF0034FF
82FF0053FF0021FF0000FF1100FF4500FF7900FFAD00FFE000EFFF00C0FF0095FF006EFF
004BFF002DFF0014FF0001FF0C00FF1300FF1500FF1000FF0500FF000BFF0021FF003CFF
005CFF007FFF00A6FF00D0FF00FCFF00FFD700FFAA00FF7D00FF5200FF2A00FF041DFF00
3BFF0054FF0067FF0075FF007DFF007EFF007AFF006FFF005FFF004AFF002FFF0011FF00
00FF0F00FF3300FF5800FF7E00FFA300FFC700FFE800FAFF00E0FF00CCFF00BDFF00B4FF
00B1FF00B5FF00BEFF00CDFF00E1FF00F9FF00FFEB00FFCD00FFAF00FF9100FF7400FF5B
00FF4500FF3400FF2900FF2400FF2500FF2C00FF3900FF4A00FF5F00FF7600FF8D00FFA3
00FFB600FFC400FFCC00FFCF00FFCB00FFC100FFB300FFA300FF9300FF8600FF7F00FF7F
00FF8500FF8E00FF9600FF9700FF9200FF9100FF9800FFA200FFA900FFAA00FFA400FF98
00FF8900FF7900FF6A00FF6000FF5A00FF5B00FF6300FF7000FF8200FF9700FFAE00FFC5
00FFDA00FFED00FFFA00FCFF00FAFF00FEFF00FFF700FFE700FFD300FFBA00FF9E00FF80
00FF6100FF4400FF2800FF0F05FF0015FF001FFF0024FF0022FF001AFF000DFF0000FF06
00FF1E00FF3B00FF5B00FF7E00FFA300FFC900FFEE00ECFF00CAFF00ACFF0091FF007AFF
0069FF005DFF0058FF0058FF005EFF006BFF007DFF0095FF00B2FF00D3FF00F8FF00FFDE
00FFB400FF8800FF5B00FF2E00FF0227FF004FFF0073FF0094FF00B0FF00C7FF00D9FF00
E4FF00EAFF00EAFF00E4FF00D8FF00C6FF00AEFF0091FF006FFF0048FF001EFF0000FF0F
00FF3F00FF7200FFA500FFDA00F1FF00BEFF008CFF005CFF
A8FF0079FF0047FF0014FF0000FF1F00FF5300FF8700FFBA00FFEB00E6FF00BBFF0094FF
0071FF0053FF003AFF0026FF0019FF0012FF0010FF0015FF0020FF0031FF0047FF0062FF
0081FF00A5FF00CCFF00F6FF00FFDE00FFB100FF8400FF5800FF2D00FF0421FF0043FF00
61FF007AFF008DFF009BFF00A3FF00A4FF00A0FF0095FF0085FF006FFF0055FF0037FF00
16FF0000FF0D00FF3200FF5800FF7D00FFA100FFC200FFDF00FFF900F2FF00E3FF00DAFF
00D7FF00DBFF00E4FF00F3FF00FFF800FFE000FFC500FFA700FF8900FF6B00FF4E00FF35
00FF1F00FF0E00FF0301FF0000FF0000FF0600FF1300FF2400FF3900FF5000FF6700FF7D
00FF9000FF9E00FFA700FFA900FFA500FF9B00FF8D00FF7D00FF6D00FF6100FF5900FF59
00FF5F00FF6800FF7100FF7100FF6D00FF6C00FF7300FF7C00FF8300FF8400FF7E00FF72
00FF6300FF5300FF4400FF3A00FF3400FF3500FF3D00FF4A00FF5C00FF7100FF8800FF9F
00FFB500FFC700FFD400FFDD00FFDF00FFDB00FFD100FFC100FFAD00FF9400FF7800FF5A
00FF3B00FF1E00FF0216FF002BFF003BFF0045FF004AFF0048FF0040FF0033FF001FFF00
07FF0000FF1500FF3600FF5900FF7E00FFA300FFC900FFED00F0FF00D1FF00B6FF00A0FF
008FFF0083FF007DFF007EFF0084FF0091FF00A3FF00BBFF00D8FF00F9FF00FFE100FFB9
00FF8E00FF6200FF3500FF0823FF004DFF0075FF0099FF00BAFF00D6FF00EDFF00FEFF00
FFF500FFEF00FFEF00FFF500FEFF00ECFF00D4FF00B7FF0095FF006EFF0044FF0016FF00
00FF1900FF4C00FF8000FFB400FFE800E4FF00B2FF0082FF
CAFF009BFF0069FF0036FF0002FF0000FF3100FF6500FF9800FFC900FFF700DDFF00B6FF
0093FF0075FF005CFF0049FF003BFF0034FF0032FF0037FF0042FF0053FF0069FF0084FF
00A3FF00C7FF00EEFF00FFE700FFBB00FF8F00FF6200FF3500FF0A1DFF0043FF0065FF00
83FF009CFF00AFFF00BDFF00C5FF00C6FF00C2FF00B7FF00A7FF0091FF0077FF0059FF00
38FF0014FF0000FF1000FF3600FF5B00FF7F00FFA000FFBD00FFD700FFEB00FFFA00FCFF
00F9FF00FDFF00FFF900FFEA00FFD600FFBE00FFA300FF8500FF6700FF4900FF2C00FF13
02FF0013FF001EFF0023FF0022FF001BFF000EFF0000FF0200FF1700FF2E00FF4500FF5B
00FF6E00FF7C00FF8400FF8700FF8300FF7900FF6B00FF5B00FF4B00FF3F00FF3700FF37
00FF3D00FF4600FF4E00FF4F00FF4A00FF4900FF5000FF5A00FF6100FF6200FF5C00FF50
00FF4100FF3100FF2200FF1800FF1200FF1300FF1B00FF2800FF3A00FF4F00FF6600FF7D
00FF9200FFA500FFB200FFBB00FFBD00FFB900FFAF00FF9F00FF8B00FF7200FF5600FF38
00FF1903FF001FFF0038FF004DFF005DFF0067FF006CFF006AFF0062FF0055FF0041FF00
29FF000CFF0000FF1300FF3700FF5B00FF8100FFA600FFCB00FFED00F4FF00D9FF00C2FF
00B1FF00A5FF009FFF00A0FF00A6FF00B3FF00C5FF00DDFF00FAFF00FFE400FFBF00FF96
00FF6C00FF4000FF1319FF0045FF006FFF0097FF00BBFF00DCFF00F8FF00FFF000FFDF00
FFD300FFCD00FFCD00FFD300FFDF00FFF100F6FF00D9FF00B7FF0090FF0066FF0038FF00
08FF0000FF2A00FF5D00FF9200FFC600FFF900D4FF00A4FF
E8FF00B9FF0087FF0054FF0020FF0000FF1300FF4700FF7A00FFAB00FFD900FBFF00D4FF
00B1FF0092FF007AFF0066FF0059FF0051FF0050FF0055FF0060FF0070FF0086FF00A2FF
00C1FF00E5FF00FFF300FFC900FF9E00FF7100FF4400FF1812FF003BFF0061FF0083FF00
A1FF00BAFF00CDFF00DBFF00E3FF00E4FF00DFFF00D5FF00C5FF00AFFF0095FF0077FF00
56FF0032FF000DFF0000FF1800FF3D00FF6100FF8200FF9F00FFB900FFCD00FFDC00FFE5
00FFE800FFE400FFDB00FFCC00FFB800FFA000FF8500FF6700FF4900FF2B00FF0F0AFF00
20FF0031FF003CFF0041FF0040FF0039FF002CFF001AFF0006FF0000FF1000FF2700FF3D
00FF5000FF5E00FF6700FF6900FF6500FF5B00FF4D00FF3D00FF2D00FF2100FF1A00FF19
00FF1F00FF2900FF3100FF3100FF2D00FF2C00FF3300FF3C00FF4300FF4400FF3E00FF33
00FF2300FF1300FF0505FF000AFF0009FF0002FF0000FF0A00FF1C00FF3100FF4800FF5F
00FF7500FF8700FF9500FF9D00FF9F00FF9B00FF9100FF8200FF6D00FF5400FF3800FF1A
03FF0021FF003DFF0056FF006BFF007AFF0085FF0089FF0088FF0080FF0072FF005FFF00
47FF002AFF0009FF0000FF1900FF3E00FF6300FF8900FFAD00FFCF00FFEE00F6FF00E0FF
00CFFF00C3FF00BDFF00BEFF00C4FF00D1FF00E3FF00FBFF00FFE700FFC600FFA100FF79
00FF4E00FF220AFF0037FF0063FF008DFF00B5FF00D9FF00F9FF00FFE900FFD200FFC100
FFB500FFAF00FFAF00FFB500FFC100FFD300FFEB00F7FF00D4FF00AEFF0084FF0056FF00
25FF0000FF0C00FF4000FF7400FFA800FFDB00F2FF00C2FF
FFFF00D1FF00A0FF006DFF0039FF0004FF0000FF2E00FF6100FF9200FFC000FFEB00ECFF
00C9FF00ABFF0092FF007FFF0072FF006AFF0069FF006EFF0079FF0089FF009FFF00BAFF
00DAFF00FEFF00FFDA00FFB000FF8500FF5800FF2B00FF002BFF0054FF007AFF009CFF00
BAFF00D3FF00E6FF00F4FF00FBFF00FDFF00F8FF00EEFF00DEFF00C8FF00AEFF0090FF00
6EFF004BFF0025FF0000FF0000FF2400FF4800FF6900FF8700FFA000FFB400FFC300FFCC
00FFCF00FFCC00FFC200FFB300FF9F00FF8700FF6C00FF4F00FF3000FF1209FF0023FF00
39FF0049FF0055FF005AFF0059FF0051FF0045FF0033FF001EFF0008FF0000FF0F00FF24
00FF3700FF4500FF4E00FF5000FF4C00FF4200FF3400FF2400FF1500FF0800FF0100FF00
00FF0600FF1000FF1800FF1800FF1400FF1300FF1A00FF2400FF2A00FF2B00FF2500FF1A
00FF0A05FF0013FF001EFF0023FF0022FF001BFF000EFF0000FF0300FF1800FF3000FF47
00FF5C00FF6E00FF7C00FF8400FF8600FF8300FF7900FF6900FF5400FF3B00FF1F00FF01
1CFF003AFF0056FF006FFF0083FF0093FF009EFF00A2FF00A1FF0099FF008BFF0078FF00
5FFF0043FF0022FF0000FF0000FF2500FF4A00FF7000FF9400FFB600FFD500FFF000F9FF
00E8FF00DCFF00D6FF00D6FF00DDFF00E9FF00FCFF00FFEB00FFCF00FFAD00FF8800FF60
00FF3500FF0923FF0050FF007CFF00A6FF00CDFF00F2FF00FFED00FFD100FFBA00FFA800
FF9C00FF9600FF9600FF9C00FFA800FFBB00FFD200FFF000EDFF00C7FF009CFF006FFF00
3EFF000CFF0000FF2700FF5B00FF8F00FFC300FFF400DBFF
FFEB00E5FF00B3FF0080FF004CFF0018FF0000FF1B00FF4E00FF7E00FFAD00FFD800FFFF
00DDFF00BFFF00A6FF0093FF0085FF007EFF007CFF0081FF008CFF009DFF00B3FF00CEFF
00EEFF00FFEE00FFC700FF9D00FF7100FF4500FF1814FF003FFF0067FF008DFF00AFFF00
CDFF00E6FF00F9FF00FFF800FFF000FFEF00FFF300FFFE00F1FF00DCFF00C1FF00A3FF00
82FF005EFF0039FF0013FF0000FF1100FF3500FF5600FF7300FF8D00FFA100FFB000FFB9
00FFBC00FFB800FFAF00FFA000FF8C00FF7400FF5900FF3B00FF1D00FF001DFF0036FF00
4CFF005DFF0068FF006DFF006CFF0065FF0058FF0047FF0032FF001BFF0004FF0000FF11
00FF2400FF3200FF3A00FF3D00FF3900FF2F00FF2100FF1100FF010BFF0012FF0012FF00
0CFF0003FF0000FF0400FF0500FF0000FF0000FF0600FF1000FF1700FF1800FF1200FF06
08FF0018FF0027FF0031FF0037FF0036FF002EFF0021FF000FFF0000FF0500FF1C00FF33
00FF4800FF5B00FF6800FF7100FF7300FF6F00FF6500FF5500FF4100FF2800FF0C11FF00
30FF004DFF0069FF0082FF0097FF00A7FF00B1FF00B6FF00B4FF00ACFF009FFF008BFF00
73FF0056FF0036FF0013FF0000FF1100FF3700FF5C00FF8100FFA200FFC100FFDC00FFF3
00FBFF00EFFF00EAFF00EAFF00F0FF00FDFF00FFF000FFD800FFBB00FF9A00FF7500FF4C
00FF2209FF0036FF0063FF008FFF00B9FF00E1FF00FFFA00FFD900FFBD00FFA600FF9400
FF8900FF8300FF8300FF8900FF9500FFA700FFBF00FFDC00FFFE00DAFF00B0FF0082FF00
52FF001FFF0000FF1300FF4800FF7C00FFAF00FFE100EEFF
FFDD00F2FF00C1FF008EFF005AFF0026FF0000FF0D00FF4000FF7100FF9F00FFCA00FFF1
00EBFF00CCFF00B4FF00A0FF0093FF008BFF008AFF008FFF009AFF00AAFF00C0FF00DCFF
00FBFF00FFE000FFB900FF8F00FF6400FF3700FF0A21FF004CFF0075FF009BFF00BDFF00
DBFF00F4FF00FFF800FFEA00FFE300FFE100FFE600FFF000FFFF00E9FF00CFFF00B1FF00
8FFF006CFF0046FF0021FF0000FF0300FF2700FF4800FF6600FF7F00FF9300FFA200FFAB
00FFAE00FFAA00FFA100FF9200FF7E00FF6600FF4B00FF2D00FF0F0EFF002AFF0044FF00
5AFF006BFF0076FF007BFF007AFF0072FF0066FF0054FF0040FF0029FF0012FF0000FF03
00FF1600FF2400FF2D00FF2F00FF2B00FF2100FF1300FF030CFF0018FF001FFF0020FF00
1AFF0010FF0008FF0008FF000CFF000DFF0006FF0000FF0200FF0900FF0A00FF0406FF00
16FF0026FF0034FF003FFF0044FF0043FF003CFF002FFF001DFF0008FF0000FF0E00FF25
00FF3B00FF4D00FF5B00FF6300FF6500FF6100FF5700FF4800FF3300FF1A01FF001FFF00
3DFF005BFF0077FF0090FF00A4FF00B4FF00BFFF00C3FF00C2FF00BAFF00ACFF0099FF00
81FF0064FF0043FF0020FF0000FF0400FF2900FF4F00FF7300FF9500FFB400FFCF00FFE5
00FFF600FDFF00F7FF00F8FF00FEFF00FFF400FFE200FFCA00FFAD00FF8C00FF6700FF3F
00FF1417FF0044FF0071FF009DFF00C7FF00EFFF00FFEC00FFCC00FFB000FF9800FF8700
FF7B00FF7500FF7500FF7B00FF8700FF9A00FFB100FFCF00FFF100E8FF00BEFF0090FF00
5FFF002DFF0000FF0600FF3A00FF6E00FFA100FFD300FCFF
FFD600FAFF00C9FF0096FF0062FF002DFF0000FF0600FF3800FF6900FF9700FFC300FFEA
00F2FF00D4FF00BBFF00A8FF009AFF0093FF0092FF0097FF00A1FF00B2FF00C8FF00E3FF
00FFFC00FFD800FFB100FF8800FF5C00FF2F00FF0229FF0054FF007DFF00A3FF00C5FF00
E3FF00FBFF00FFF000FFE300FFDB00FFD900FFDE00FFE800FFF900F1FF00D7FF00B9FF00
97FF0073FF004EFF0028FF0003FF0000FF1F00FF4000FF5E00FF7700FF8C00FF9A00FFA3
00FFA600FFA300FF9900FF8B00FF7700FF5F00FF4300FF2600FF0716FF0032FF004CFF00
61FF0072FF007DFF0082FF0081FF007AFF006DFF005CFF0047FF0030FF0019FF0003FF00
00FF0E00FF1D00FF2500FF2700FF2300FF1900FF0C04FF0013FF0020FF0027FF0027FF00
22FF0018FF0010FF000FFF0014FF0015FF000EFF0004FF0000FF0200FF0302FF000EFF00
1DFF002EFF003CFF0047FF004CFF004BFF0044FF0037FF0025FF000FFF0000FF0700FF1E
00FF3300FF4500FF5300FF5B00FF5E00FF5A00FF5000FF4000FF2B00FF1209FF0027FF00
45FF0063FF007FFF0097FF00ACFF00BCFF00C7FF00CBFF00CAFF00C2FF00B4FF00A1FF00
88FF006BFF004BFF0028FF0003FF0000FF2200FF4700FF6B00FF8D00FFAC00FFC700FFDD
00FFEF00FFFA00FFFF00FFFF00FFF900FFED00FFDA00FFC300FFA600FF8400FF5F00FF37
00FF0C1FFF004CFF0079FF00A4FF00CFFF00F6FF00FFE400FFC400FFA800FF9100FF7F00
FF7300FF6D00FF6D00FF7300FF8000FF9200FFAA00FFC700FFE900F0FF00C5FF0097FF00
67FF0035FF0001FF0000FF3200FF6600FF9A00FFCC00FFFB
FFD400FCFF00CAFF0097FF0063FF002FFF0000FF0400FF3700FF6800FF9600FFC100FFE8
00F4FF00D6FF00BDFF00A9FF009CFF0095FF0093FF0098FF00A3FF00B4FF00CAFF00E5FF
00FFFB00FFD700FFB000FF8600FF5B00FF2E00FF012AFF0056FF007EFF00A4FF00C6FF00
E4FF00FDFF00FFEF00FFE100FFD900FFD800FFDC00FFE700FFF700F2FF00D8FF00BAFF00
99FF0075FF0050FF002AFF0005FF0000FF1E00FF3F00FF5C00FF7600FF8A00FF9900FFA2
00FFA500FFA100FF9800FF8900FF7500FF5D00FF4200FF2400FF0617FF0034FF004DFF00
63FF0074FF007FFF0084FF0083FF007CFF006FFF005EFF0049FF0032FF001BFF0005FF00
00FF0D00FF1B00FF2400FF2600FF2200FF1800FF0A05FF0015FF0021FF0029FF0029FF00
23FF001AFF0012FF0011FF0015FF0016FF000FFF0006FF0000FF0000FF0104FF0010FF00
1FFF002FFF003EFF0048FF004EFF004DFF0045FF0038FF0026FF0011FF0000FF0500FF1C
00FF3200FF4400FF5100FF5A00FF5C00FF5800FF4E00FF3E00FF2A00FF110AFF0028FF00
47FF0064FF0080FF0099FF00AEFF00BEFF00C8FF00CDFF00CBFF00C3FF00B6FF00A2FF00
8AFF006DFF004DFF0029FF0004FF0000FF2000FF4600FF6A00FF8C00FFAA00FFC500FFDC
00FFED00FFF900FFFF00FFFE00FFF800FFEB00FFD900FFC100FFA400FF8300FF5E00FF36
00FF0B20FF004DFF007AFF00A6FF00D0FF00F8FF00FFE300FFC200FFA600FF8F00FF7E00
FF7200FF6C00FF6C00FF7200FF7E00FF9000FFA800FFC500FFE700F1FF00C7FF0099FF00
69FF0036FF0003FF0000FF3100FF6500FF9800FFCA00FFFA
FFD900F7FF00C6FF0093FF005EFF002AFF0000FF0900FF3B00FF6C00FF9A00FFC600FFED
00EFFF00D1FF00B8FF00A5FF0097FF0090FF008FFF0094FF009EFF00AFFF00C5FF00E0FF
00FFFF00FFDC00FFB400FF8B00FF5F00FF3200FF0626FF0051FF007AFF00A0FF00C2FF00
DFFF00F8FF00FFF300FFE600FFDE00FFDC00FFE100FFEC00FFFC00EEFF00D4FF00B5FF00
94FF0070FF004BFF0025FF0000FF0000FF2200FF4300FF6100FF7A00FF8F00FF9E00FFA6
00FFA900FFA600FF9D00FF8E00FF7A00FF6200FF4600FF2900FF0A13FF002FFF0049FF00
5EFF006FFF007AFF007FFF007EFF0077FF006AFF0059FF0044FF002DFF0016FF0000FF00
00FF1100FF2000FF2800FF2A00FF2600FF1D00FF0F01FF0010FF001DFF0024FF0024FF00
1FFF0015FF000DFF000CFF0011FF0012FF000BFF0001FF0000FF0500FF0600FF000BFF00
1AFF002BFF0039FF0044FF0049FF0048FF0041FF0033FF0022FF000CFF0000FF0A00FF21
00FF3600FF4800FF5600FF5E00FF6100FF5D00FF5300FF4300FF2E00FF1506FF0024FF00
42FF0060FF007BFF0094FF00A9FF00B9FF00C3FF00C8FF00C6FF00BFFF00B1FF009EFF00
85FF0068FF0048FF0025FF0000FF0000FF2500FF4A00FF6E00FF9000FFAF00FFCA00FFE0
00FFF200FFFD00FCFF00FCFF00FFFC00FFF000FFDE00FFC600FFA900FF8800FF6200FF3A
00FF0F1CFF0049FF0076FF00A1FF00CCFF00F3FF00FFE700FFC700FFAB00FF9400FF8200
FF7600FF7000FF7000FF7700FF8300FF9500FFAD00FFCA00FFEC00EDFF00C2FF0094FF00
64FF0032FF0000FF0100FF3500FF6A00FF9D00FFCF00FFFE
FFE300EDFF00BBFF0088FF0054FF0020FF0000FF1300FF4600FF7700FFA500FFD000FFF7
00E5FF00C6FF00AEFF009AFF008DFF0085FF0084FF0089FF0094FF00A4FF00BAFF00D6FF
00F5FF00FFE600FFBF00FF9500FF6A00FF3D00FF101BFF0046FF006FFF0095FF00B7FF00
D5FF00EEFF00FFFE00FFF000FFE800FFE700FFEC00FFF600F9FF00E3FF00C9FF00ABFF00
8AFF0066FF0041FF001BFF0000FF0900FF2D00FF4E00FF6B00FF8500FF9900FFA800FFB1
00FFB400FFB000FFA700FF9800FF8400FF6C00FF5100FF3300FF1508FF0024FF003EFF00
54FF0065FF0070FF0075FF0074FF006DFF0060FF004EFF003AFF0023FF000CFF0000FF09
00FF1C00FF2A00FF3300FF3500FF3100FF2700FF1900FF0906FF0012FF0019FF001AFF00
14FF000AFF0002FF0002FF0006FF0007FF0000FF0000FF0800FF0F00FF1000FF0A00FF00
10FF0020FF002FFF0039FF003EFF003DFF0036FF0029FF0017FF0002FF0000FF1400FF2B
00FF4100FF5300FF6100FF6900FF6B00FF6700FF5D00FF4E00FF3900FF2000FF0419FF00
37FF0055FF0071FF008AFF009FFF00AEFF00B9FF00BDFF00BCFF00B4FF00A6FF0093FF00
7BFF005EFF003DFF001AFF0000FF0A00FF2F00FF5500FF7900FF9B00FFBA00FFD500FFEB
00FFFC00F7FF00F1FF00F2FF00F8FF00FFFA00FFE800FFD000FFB300FF9200FF6D00FF45
00FF1A11FF003EFF006BFF0097FF00C1FF00E9FF00FFF200FFD200FFB500FF9E00FF8D00
FF8100FF7B00FF7B00FF8100FF8D00FF9F00FFB700FFD400FFF700E2FF00B8FF008AFF00
59FF0027FF0000FF0C00FF4000FF7400FFA700FFD900F6FF
FFF400DCFF00ABFF0078FF0044FF000FFF0000FF2300FF5600FF8700FFB500FFE000F7FF
00D4FF00B6FF009DFF008AFF007DFF0075FF0074FF0079FF0084FF0094FF00AAFF00C5FF
00E5FF00FFF600FFCF00FFA600FF7A00FF4D00FF200BFF0036FF005FFF0085FF00A7FF00
C5FF00DEFF00F1FF00FFFF00FFF900FFF700FFFC00F9FF00E8FF00D3FF00B9FF009BFF00
79FF0056FF0030FF000BFF0000FF1900FF3D00FF5E00FF7C00FF9500FFA900FFB800FFC1
00FFC400FFC100FFB700FFA800FF9400FF7C00FF6100FF4400FF2500FF0714FF002EFF00
44FF0054FF0060FF0065FF0064FF005CFF0050FF003EFF0029FF0013FF0000FF0400FF19
00FF2C00FF3A00FF4300FF4500FF4100FF3700FF2900FF1900FF0A02FF0009FF000AFF00
04FF0000FF0500FF0D00FF0E00FF0900FF0800FF0F00FF1900FF2000FF2000FF1A00FF0F
00FF0010FF001EFF0029FF002EFF002DFF0026FF0019FF0007FF0000FF0E00FF2500FF3C
00FF5100FF6300FF7100FF7900FF7B00FF7800FF6E00FF5E00FF4900FF3000FF1409FF00
27FF0045FF0061FF007AFF008EFF009EFF00A9FF00ADFF00ACFF00A4FF0096FF0083FF00
6AFF004EFF002DFF000AFF0000FF1A00FF4000FF6500FF8900FFAB00FFCA00FFE500FFFB
00F2FF00E7FF00E1FF00E1FF00E8FF00F4FF00FFF800FFE000FFC400FFA200FF7D00FF55
00FF2A01FF002EFF005BFF0087FF00B1FF00D8FF00FDFF00FFE200FFC600FFAF00FF9D00
FF9100FF8B00FF8B00FF9100FF9E00FFB000FFC800FFE500F8FF00D2FF00A7FF007AFF00
49FF0017FF0000FF1C00FF5000FF8400FFB800FFE900E6FF
F6FF00C7FF0095FF0062FF002EFF0000FF0500FF3900FF6C00FF9C00FFCB00FFF600E2FF
00BFFF00A1FF0088FF0075FF0067FF0060FF005FFF0063FF006EFF007FFF0095FF00B0FF
00D0FF00F3FF00FFE500FFBB00FF8F00FF6300FF3600FF0921FF004AFF006FFF0091FF00
AFFF00C8FF00DCFF00E9FF00F1FF00F2FF00EEFF00E3FF00D3FF00BEFF00A3FF0085FF00
64FF0040FF001BFF0000FF0A00FF2F00FF5300FF7400FF9100FFAB00FFBF00FFCE00FFD7
00FFD900FFD600FFCD00FFBE00FFAA00FF9200FF7700FF5900FF3B00FF1D00FF0018FF00
2EFF003FFF004AFF004FFF004EFF0047FF003AFF0029FF0014FF0000FF0200FF1900FF2F
00FF4200FF5000FF5800FF5B00FF5600FF4D00FF3F00FF2F00FF1F00FF1200FF0B00FF0B
00FF1100FF1A00FF2200FF2300FF1E00FF1D00FF2400FF2E00FF3500FF3600FF3000FF24
00FF1500FF0509FF0014FF0019FF0018FF0010FF0003FF0000FF0E00FF2300FF3A00FF51
00FF6600FF7900FF8600FF8F00FF9100FF8D00FF8300FF7300FF5E00FF4600FF2A00FF0C
12FF002FFF004BFF0064FF0079FF0089FF0093FF0098FF0096FF008EFF0081FF006DFF00
55FF0038FF0018FF0000FF0A00FF2F00FF5500FF7A00FF9F00FFC000FFDF00FFFA00EEFF
00DDFF00D1FF00CCFF00CCFF00D2FF00DFFF00F1FF00FFF600FFD900FFB800FF9300FF6A
00FF4000FF1318FF0045FF0071FF009BFF00C3FF00E7FF00FFF700FFDB00FFC400FFB200
FFA600FFA000FFA100FFA700FFB300FFC500FFDD00FFFA00E3FF00BCFF0092FF0064FF00
34FF0001FF0000FF3100FF6600FF9A00FFCD00FFFF00D1FF
DCFF00ADFF007BFF0048FF0014FF0000FF1F00FF5300FF8600FFB700FFE500EFFF00C8FF
00A5FF0087FF006EFF005AFF004DFF0046FF0044FF0049FF0054FF0065FF007BFF0096FF
00B5FF00D9FF00FFFF00FFD500FFAA00FF7D00FF5000FF2307FF002FFF0055FF0077FF00
95FF00AEFF00C1FF00CFFF00D7FF00D8FF00D4FF00C9FF00B9FF00A3FF0089FF006BFF00
4AFF0026FF0001FF0000FF2400FF4900FF6D00FF8E00FFAB00FFC500FFD900FFE800FFF1
00FFF400FFF000FFE700FFD800FFC400FFAC00FF9100FF7300FF5500FF3700FF1A00FF01
14FF0025FF0030FF0035FF0034FF002DFF0020FF000FFF0000FF0500FF1C00FF3300FF49
00FF5C00FF6A00FF7200FF7500FF7100FF6700FF5900FF4900FF3900FF2D00FF2500FF25
00FF2B00FF3400FF3C00FF3D00FF3900FF3700FF3F00FF4800FF4F00FF5000FF4A00FF3E
00FF2F00FF1F00FF1000FF0600FF0000FF0100FF0900FF1600FF2800FF3D00FF5400FF6B
00FF8100FF9300FFA000FFA900FFAB00FFA700FF9D00FF8D00FF7900FF6000FF4400FF26
00FF0715FF0031FF004AFF005FFF006FFF0079FF007EFF007CFF0074FF0067FF0053FF00
3BFF001EFF0000FF0100FF2500FF4900FF6F00FF9500FFB900FFDB00FFF900EBFF00D4FF
00C3FF00B7FF00B1FF00B2FF00B8FF00C5FF00D7FF00EFFF00FFF300FFD200FFAD00FF84
00FF5A00FF2E00FF012BFF0057FF0081FF00A9FF00CDFF00EEFF00FFF500FFDE00FFCD00
FFC100FFBB00FFBB00FFC100FFCD00FFDF00FFF700EBFF00C9FF00A2FF0078FF004AFF00
1AFF0000FF1800FF4B00FF8000FFB400FFE700E6FF00B6FF
BEFF008FFF005DFF002AFF0000FF0900FF3D00FF7100FFA400FFD500FCFF00D1FF00AAFF
0087FF0068FF0050FF003CFF002FFF0027FF0026FF002BFF0036FF0046FF005CFF0078FF
0097FF00BBFF00E2FF00FFF300FFC800FF9B00FF6E00FF4200FF1711FF0037FF0059FF00
77FF0090FF00A3FF00B1FF00B9FF00BAFF00B5FF00ABFF009BFF0085FF006BFF004DFF00
2CFF0008FF0000FF1C00FF4200FF6700FF8B00FFAC00FFC900FFE300FFF700F9FF00F0FF
00EDFF00F1FF00FAFF00FFF600FFE200FFCA00FFAF00FF9100FF7300FF5500FF3900FF1F
00FF0907FF0012FF0017FF0016FF000FFF0002FF0000FF0F00FF2300FF3A00FF5100FF67
00FF7A00FF8800FF9100FF9300FF8F00FF8500FF7700FF6700FF5700FF4B00FF4400FF43
00FF4900FF5300FF5B00FF5B00FF5700FF5600FF5D00FF6600FF6D00FF6E00FF6800FF5D
00FF4D00FF3D00FF2E00FF2400FF1F00FF2000FF2700FF3400FF4600FF5B00FF7200FF89
00FF9F00FFB100FFBF00FFC700FFC900FFC500FFBB00FFAC00FF9700FF7E00FF6200FF44
00FF2600FF0813FF002CFF0041FF0050FF005BFF005FFF005EFF0056FF0048FF0035FF00
1DFF0000FF0000FF2000FF4300FF6800FF8D00FFB300FFD700FFF900E7FF00CCFF00B6FF
00A5FF0099FF0093FF0094FF009AFF00A7FF00B9FF00D1FF00EEFF00FFF000FFCB00FFA3
00FF7800FF4C00FF1F0DFF0039FF0063FF008BFF00AFFF00CFFF00ECFF00FFFC00FFEB00
FFDF00FFD900FFD900FFDF00FFEB00FFFD00EAFF00CDFF00AAFF0084FF005AFF002CFF00
00FF0400FF3600FF6A00FF9E00FFD200FAFF00C8FF0098FF
9CFF006DFF003CFF0009FF0000FF2A00FF5F00FF9300FFC500FFF600DBFF00AFFF0088FF
0065FF0047FF002EFF001BFF000DFF0006FF0005FF000AFF0014FF0025FF003BFF0056FF
0076FF009AFF00C1FF00EAFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006EFF0082FF008FFF0097FF0099FF0094FF008AFF0079FF0064FF004AFF002CFF00
0AFF0000FF1900FF3E00FF6400FF8900FFAC00FFCD00FFEB00FBFF00E6FF00D8FF00CFFF
00CCFF00CFFF00D9FF00E7FF00FBFF00FFEC00FFD000FFB300FF9400FF7600FF5A00FF40
00FF2B00FF1A00FF0F00FF0A00FF0B00FF1200FF1F00FF3000FF4500FF5C00FF7300FF89
00FF9B00FFAA00FFB200FFB400FFB000FFA600FF9900FF8800FF7900FF6C00FF6500FF65
00FF6A00FF7400FF7C00FF7D00FF7800FF7700FF7E00FF8800FF8F00FF9000FF8A00FF7E
00FF6F00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7D00FF9400FFAB
00FFC000FFD200FFE000FFE800FFEB00FFE700FFDD00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0AFF001FFF002FFF003AFF003EFF003CFF0035FF0027FF0014FF00
00FF0400FF2100FF4100FF6400FF8900FFAF00FFD400FFF800E5FF00C6FF00ABFF0095FF
0083FF0078FF0072FF0072FF0079FF0085FF0098FF00AFFF00CCFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1317FF0042FF0069FF008EFF00AEFF00CAFF00E1FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F2FF00E0FF00C8FF00ABFF0089FF0063FF0038FF000AFF00
00FF2500FF5700FF8B00FFBF00FFF300D8FF00A6FF0077FF
78FF0049FF0018FF0000FF1A00FF4E00FF8300FFB600FFE900E5FF00B7FF008CFF0064FF
0041FF0023FF000AFF0800FF1500FF1D00FF1E00FF1900FF0E00FF0001FF0017FF0032FF
0052FF0076FF009DFF00C6FF00F2FF00FFE000FFB300FF8700FF5C00FF3300FF0D14FF00
32FF004BFF005EFF006CFF0073FF0075FF0070FF0066FF0056FF0040FF0026FF0008FF00
00FF1900FF3C00FF6200FF8700FFAC00FFD000FFF100F0FF00D7FF00C3FF00B4FF00ABFF
00A8FF00ABFF00B5FF00C4FF00D8FF00F0FF00FFF400FFD700FFB800FF9A00FF7E00FF64
00FF4E00FF3E00FF3200FF2D00FF2E00FF3600FF4200FF5400FF6900FF7F00FF9700FFAC
00FFBF00FFCD00FFD600FFD800FFD400FFCA00FFBC00FFAC00FF9D00FF9000FF8900FF88
00FF8E00FF9800FFA000FFA100FF9C00FF9B00FFA200FFAC00FFB200FFB300FFAD00FFA2
00FF9200FF8200FF7400FF6900FF6400FF6500FF6C00FF7900FF8B00FFA100FFB800FFCF
00FFE400FFF600FBFF00F3FF00F1FF00F4FF00FEFF00FFF100FFDC00FFC300FFA700FF89
00FF6B00FF4D00FF3100FF1800FF040BFF0016FF001AFF0019FF0011FF0003FF0000FF0F
00FF2800FF4400FF6500FF8800FFAD00FFD200FFF800E3FF00C1FF00A2FF0087FF0071FF
0060FF0054FF004EFF004EFF0055FF0061FF0074FF008CFF00A8FF00CAFF00EFFF00FFE8
00FFBD00FF9100FF6400FF3700FF0B1EFF0045FF006AFF008AFF00A6FF00BDFF00CFFF00
DBFF00E1FF00E1FF00DBFF00CEFF00BCFF00A5FF0087FF0065FF003FFF0014FF0000FF18
00FF4900FF7B00FFAF00FFE300E8FF00B4FF0083FF0053FF
53FF0024FF0000FF0C00FF3F00FF7300FFA800FFDC00F1FF00C0FF0092FF0066FF003FFF
001CFF0100FF1A00FF2D00FF3B00FF4200FF4300FF3E00FF3400FF2300FF0D00FF000DFF
002DFF0051FF0078FF00A1FF00CDFF00FAFF00FFD800FFAC00FF8100FF5800FF3200FF10
0DFF0025FF0039FF0046FF004EFF0050FF004BFF0041FF0030FF001BFF0001FF0000FF1C
00FF3E00FF6200FF8700FFAD00FFD200FFF500E9FF00CBFF00B2FF009DFF008FFF0086FF
0083FF0086FF0090FF009EFF00B2FF00CAFF00E6FF00FFFC00FFDD00FFBF00FFA300FF89
00FF7400FF6300FF5800FF5300FF5400FF5B00FF6800FF7900FF8E00FFA500FFBC00FFD2
00FFE400FFF300FFFB00FFFD00FFF900FFEF00FFE200FFD100FFC200FFB500FFAE00FFAE
00FFB300FFBD00FFC500FFC600FFC100FFC000FFC700FFD100FFD800FFD900FFD300FFC7
00FFB800FFA700FF9900FF8E00FF8900FF8A00FF9100FF9E00FFB000FFC600FFDD00FFF4
00F6FF00E4FF00D6FF00CEFF00CBFF00CFFF00D9FF00E9FF00FEFF00FFE800FFCC00FFAE
00FF9000FF7200FF5600FF3E00FF2900FF1900FF0E00FF0A00FF0C00FF1300FF2100FF34
00FF4D00FF6A00FF8A00FFAD00FFD200FFF800E2FF00BEFF009CFF007DFF0062FF004CFF
003AFF002FFF0029FF0029FF0030FF003CFF004FFF0066FF0083FF00A5FF00CAFF00F2FF
00FFE200FFB600FF8900FF5C00FF3100FF0620FF0045FF0065FF0081FF0098FF00AAFF00
B6FF00BCFF00BCFF00B6FF00A9FF0097FF007FFF0062FF0040FF001AFF0000FF1000FF3E
00FF6E00FFA000FFD400F7FF00C3FF008FFF005DFF002EFF
2EFF0000FF0100FF3200FF6500FF9900FFCD00FEFF00CBFF009AFF006CFF0041FF0019FF
0800FF2700FF4000FF5300FF6000FF6800FF6900FF6400FF5900FF4900FF3300FF1800FF
0007FF002BFF0052FF007CFF00A7FF00D4FF00FFFE00FFD200FFA700FF7E00FF5800FF36
00FF1800FF0013FF0021FF0028FF002AFF0025FF001BFF000BFF0000FF0A00FF2400FF42
00FF6400FF8700FFAD00FFD200FFF700E4FF00C3FF00A5FF008CFF0078FF0069FF0060FF
005DFF0061FF006AFF0079FF008DFF00A5FF00C0FF00DEFF00FCFF00FFE500FFC900FFAF
00FF9900FF8800FF7D00FF7800FF7900FF8100FF8D00FF9F00FFB300FFCA00FFE100FFF7
00F5FF00E7FF00DEFF00DCFF00E0FF00EAFF00F8FF00FFF700FFE700FFDB00FFD400FFD3
00FFD900FFE300FFEB00FFEB00FFE700FFE600FFED00FFF600FFFD00FFFE00FFF800FFED
00FFDD00FFCD00FFBF00FFB400FFAF00FFB000FFB700FFC400FFD600FFEB00FDFF00E6FF
00D0FF00BEFF00B0FF00A8FF00A6FF00AAFF00B4FF00C3FF00D8FF00F1FF00FFF200FFD4
00FFB600FF9800FF7C00FF6300FF4F00FF3F00FF3400FF3000FF3100FF3900FF4700FF5A
00FF7200FF8F00FFB000FFD300FFF800E2FF00BCFF0098FF0076FF0057FF003CFF0026FF
0015FF0009FF0003FF0004FF000AFF0016FF0029FF0041FF005EFF007FFF00A4FF00CCFF
00F7FF00FFDC00FFAF00FF8200FF5600FF2C00FF041FFF003FFF005BFF0073FF0084FF00
90FF0096FF0096FF0090FF0084FF0071FF005AFF003CFF001AFF0000FF0B00FF3600FF63
00FF9400FFC600FFFA00D1FF009DFF006AFF0038FF0008FF
08FF0000FF2600FF5700FF8A00FFBE00FFF300D9FF00A6FF0075FF0047FF001CFF0B00FF
2E00FF4C00FF6500FF7800FF8500FF8D00FF8E00FF8900FF7E00FF6E00FF5800FF3D00FF
1D00FF0006FF002DFF0056FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0303FF0005FF0000FF0000FF0900FF1900FF2F00FF4900FF67
00FF8900FFAC00FFD200FFF700E3FF00BFFF009EFF0080FF0067FF0053FF0044FF003BFF
0038FF003BFF0045FF0054FF0068FF0080FF009BFF00B8FF00D7FF00F5FF00FFEE00FFD4
00FFBE00FFAE00FFA200FF9D00FF9E00FFA600FFB200FFC400FFD900FFEF00F8FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F2FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EEFF00F3FF00F4FF00EDFF00E3FF00DCFF00DCFF00E2FF00EDFF
00FDFF00FFF200FFE400FFD900FFD400FFD500FFDC00FFE900FFFB00EEFF00D7FF00C0FF
00ABFF0099FF008BFF0083FF0081FF0084FF008EFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7400FF6400FF5900FF5500FF5600FF5E00FF6C00FF7F
00FF9800FFB400FFD500FFF800E2FF00BCFF0097FF0073FF0051FF0032FF0017FF0001FF
1000FF1B00FF2100FF2100FF1A00FF0E00FF0004FF001CFF0038FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2A00FF051AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006BFF005EFF004CFF0034FF0017FF0000FF0A00FF3000FF5B00FF88
00FFB900FFEB00E0FF00ACFF0078FF0044FF0013FF1C00FF
00FF1A00FF4900FF7B00FFAE00FFE200E9FF00B5FF0082FF0051FF0023FF0700FF2E00FF
5100FF6F00FF8800FF9B00FFA900FFB000FFB200FFAD00FFA200FF9100FF7B00FF6000FF
4100FF1D00FF0009FF0033FF005FFF008BFF00B8FF00E5FF00FFEF00FFC700FFA100FF7F
00FF6100FF4800FF3500FF2700FF1F00FF1E00FF2200FF2D00FF3D00FF5300FF6D00FF8B
00FFAC00FFD000FFF500E4FF00BFFF009BFF007AFF005DFF0043FF002FFF0020FF0017FF
0014FF0018FF0021FF0030FF0044FF005CFF0077FF0095FF00B3FF00D1FF00EEFF00FFF8
00FFE200FFD100FFC600FFC100FFC200FFC900FFD600FFE700FFFC00ECFF00D5FF00BFFF
00ACFF009EFF0096FF0093FF0097FF00A1FF00AFFF00BFFF00CFFF00DBFF00E3FF00E3FF
00DDFF00D4FF00CCFF00CBFF00D0FF00D1FF00CAFF00C0FF00B9FF00B8FF00BEFF00CAFF
00D9FF00E9FF00F8FF00FFFD00FFF700FFF800FFFF00F2FF00E0FF00CBFF00B4FF009DFF
0088FF0075FF0068FF005FFF005DFF0061FF006BFF007BFF008FFF00A8FF00C4FF00E2FF
00FFFE00FFE100FFC500FFAC00FF9700FF8700FF7D00FF7800FF7A00FF8200FF8F00FFA3
00FFBB00FFD800FFF800E3FF00BFFF0099FF0074FF004FFF002DFF000FFF0B00FF2200FF
3300FF3F00FF4500FF4400FF3E00FF3100FF1F00FF0700FF0015FF0036FF005BFF0084FF
00AEFF00DAFF00FFF800FFCB00FF9F00FF7500FF4D00FF2900FF0813FF002AFF003BFF00
47FF004DFF004DFF0047FF003BFF0029FF0011FF0000FF0B00FF2D00FF5400FF7E00FFAC
00FFDC00F0FF00BDFF0088FF0054FF0021FF1000FF4000FF
00FF3B00FF6A00FF9C00FFCF00FCFF00C8FF0094FF0061FF0030FF0002FF2800FF4F00FF
7200FF9000FFA900FFBD00FFCA00FFD100FFD300FFCE00FFC300FFB200FF9C00FF8100FF
6200FF3E00FF1700FF0012FF003DFF006AFF0097FF00C4FF00EFFF00FFE800FFC200FFA0
00FF8200FF6900FF5600FF4800FF4000FF3F00FF4300FF4E00FF5E00FF7400FF8E00FFAC
00FFCD00FFF100E9FF00C3FF009EFF007AFF0059FF003CFF0022FF000EFF0000FF0900FF
0C00FF0800FF0000FF000FFF0023FF003BFF0056FF0074FF0092FF00B0FF00CDFF00E6FF
00FCFF00FFF200FFE700FFE200FFE300FFEA00FFF700F7FF00E2FF00CBFF00B4FF009EFF
008BFF007DFF0075FF0072FF0076FF0080FF008EFF009EFF00AEFF00BAFF00C2FF00C2FF
00BCFF00B3FF00ABFF00AAFF00AFFF00B0FF00A9FF009FFF0098FF0097FF009DFF00A9FF
00B8FF00C8FF00D7FF00E1FF00E7FF00E6FF00DEFF00D1FF00BFFF00AAFF0093FF007CFF
0066FF0054FF0047FF003EFF003CFF0040FF004AFF005AFF006EFF0087FF00A3FF00C1FF
00E0FF00FDFF00FFE600FFCD00FFB800FFA800FF9E00FF9900FF9B00FFA300FFB000FFC4
00FFDC00FFF900E6FF00C2FF009EFF0078FF0053FF002EFF000CFF1100FF2C00FF4300FF
5400FF6000FF6600FF6500FF5F00FF5200FF4000FF2800FF0B00FF0015FF003AFF0063FF
008DFF00B9FF00E6FF00FFEC00FFC000FF9600FF6E00FF4A00FF2900FF0D09FF001AFF00
26FF002CFF002CFF0026FF001AFF0008FF0000FF0F00FF2C00FF4E00FF7500FF9F00FFCD
00FFFD00CFFF009CFF0067FF0033FF0000FF3100FF6100FF
00FF5900FF8800FFB900FFEC00DFFF00AAFF0076FF0044FF0013FF1A00FF4600FF6D00FF
9000FFAE00FFC700FFDA00FFE800FFEF00FFF000FFEB00FFE100FFD000FFBA00FF9F00FF
7F00FF5B00FF3400FF0B00FF0020FF004DFF007AFF00A6FF00D1FF00FAFF00FFDF00FFBD
00FF9F00FF8700FF7300FF6600FF5E00FF5C00FF6100FF6B00FF7C00FF9100FFAB00FFC9
00FFEB00F0FF00CBFF00A5FF0080FF005DFF003CFF001EFF0005FF0F00FF1D00FF2600FF
2900FF2600FF1C00FF0E00FF0005FF001DFF0039FF0056FF0075FF0093FF00AFFF00C9FF
00DEFF00EFFF00FAFF00FFFF00FEFF00F7FF00EAFF00D9FF00C4FF00ADFF0096FF0080FF
006EFF005FFF0057FF0055FF0059FF0063FF0070FF0081FF0090FF009DFF00A4FF00A4FF
009FFF0095FF008DFF008CFF0091FF0092FF008BFF0081FF007AFF0079FF007FFF008BFF
009AFF00ABFF00B9FF00C4FF00C9FF00C8FF00C1FF00B4FF00A2FF008CFF0075FF005EFF
0049FF0037FF0029FF0021FF001EFF0022FF002CFF003CFF0051FF006AFF0086FF00A4FF
00C2FF00E0FF00FCFF00FFEB00FFD600FFC600FFBB00FFB700FFB900FFC000FFCE00FFE1
00FFFA00E8FF00C8FF00A5FF0080FF005AFF0035FF0011FF1000FF2F00FF4A00FF6000FF
7200FF7D00FF8300FF8300FF7C00FF7000FF5D00FF4600FF2900FF0700FF001DFF0045FF
0070FF009CFF00C9FF00F6FF00FFDE00FFB300FF8C00FF6700FF4700FF2B00FF1400FF02
09FF000FFF000FFF0009FF0000FF0300FF1500FF2D00FF4A00FF6C00FF9200FFBD00FFEB
00E4FF00B2FF007EFF004AFF0016FF1D00FF4F00FF7E00FF
00FF7200FFA100FFD300F9FF00C5FF0091FF005DFF002AFF0500FF3400FF5F00FF8600FF
A900FFC700FFE000FFF300FFFF00FEFF00F7FF00F5FF00FAFA00FFE900FFD300FFB800FF
9900FF7500FF4E00FF2400FF0007FF0033FF0060FF008DFF00B8FF00E0FF00FFF900FFD7
00FFB900FFA000FF8D00FF7F00FF7700FF7600FF7A00FF8500FF9500FFAB00FFC500FFE3
00FBFF00D7FF00B2FF008CFF0067FF0043FF0022FF0005FF1400FF2800FF3700FF4000FF
4300FF3F00FF3600FF2700FF1300FF0004FF001FFF003DFF005BFF0079FF0096FF00AFFF
00C5FF00D6FF00E1FF00E6FF00E5FF00DEFF00D1FF00C0FF00ABFF0094FF007DFF0067FF
0054FF0046FF003EFF003BFF003FFF0049FF0057FF0067FF0077FF0083FF008BFF008BFF
0085FF007CFF0074FF0073FF0078FF0079FF0072FF0068FF0061FF0060FF0066FF0072FF
0081FF0091FF00A0FF00AAFF00B0FF00AFFF00A7FF009AFF0088FF0073FF005CFF0045FF
0030FF001DFF0010FF0007FF0005FF0009FF0013FF0023FF0037FF0050FF006CFF008AFF
00A9FF00C6FF00E2FF00FBFF00FFEF00FFDF00FFD500FFD000FFD200FFDA00FFE700FFFB
00ECFF00CFFF00AFFF008BFF0067FF0041FF001CFF0800FF2A00FF4800FF6300FF7A00FF
8B00FF9700FF9D00FF9C00FF9600FF8900FF7700FF5F00FF4200FF2100FF0003FF002CFF
0056FF0082FF00AFFF00DCFF00FFF700FFCD00FFA500FF8100FF6000FF4400FF2D00FF1B
00FF1000FF0A00FF0A00FF1000FF1C00FF2E00FF4600FF6300FF8500FFAC00FFD600FBFF
00CBFF0098FF0065FF0030FF0300FF3600FF6800FF9800FF
00FF8700FFB600FFE700E5FF00B1FF007DFF0049FF0016FF1A00FF4800FF7300FF9B00FF
BE00FFDC00FFF500FFFF00F7FF00EAFF00E2FF00E1FF00E6FF00F1FE00FFE800FFCD00FF
AD00FF8900FF6200FF3800FF0D00FF001FFF004CFF0078FF00A3FF00CCFF00F2FF00FFEB
00FFCD00FFB400FFA100FF9300FF8C00FF8A00FF8F00FF9900FFA900FFBF00FFD900FFF7
00E6FF00C3FF009DFF0078FF0053FF002FFF000EFF0F00FF2800FF3C00FF4B00FF5400FF
5700FF5400FF4A00FF3B00FF2700FF0F00FF000BFF0028FF0047FF0065FF0081FF009BFF
00B1FF00C1FF00CDFF00D2FF00D1FF00C9FF00BDFF00ABFF0096FF0080FF0068FF0053FF
0040FF0032FF0029FF0027FF002BFF0035FF0043FF0053FF0063FF006FFF0076FF0077FF
0071FF0067FF005FFF005FFF0063FF0064FF005DFF0053FF004DFF004CFF0052FF005DFF
006DFF007DFF008BFF0096FF009BFF009AFF0093FF0086FF0074FF005FFF0048FF0031FF
001BFF0009FF0400FF0C00FF0E00FF0B00FF0000FF000EFF0023FF003CFF0058FF0076FF
0094FF00B2FF00CEFF00E7FF00FBFF00FFF400FFE900FFE500FFE600FFEE00FFFC00F0FF
00D8FF00BBFF009AFF0077FF0052FF002DFF0007FF1C00FF3E00FF5D00FF7800FF8E00FF
9F00FFAB00FFB100FFB100FFAA00FF9E00FF8B00FF7300FF5700FF3500FF1000FF0017FF
0042FF006EFF009BFF00C8FF00F4FF00FFE100FFBA00FF9500FF7500FF5900FF4200FF30
00FF2400FF1E00FF1E00FF2400FF3000FF4300FF5A00FF7800FF9A00FFC000FFEB00E7FF
00B6FF0084FF0050FF001CFF1700FF4B00FF7C00FFAC00FF
00FF9500FFC400FFF600D6FF00A2FF006EFF003AFF0007FF2900FF5700FF8200FFA900FF
CC00FFEB00FFFF00FCFF00E8FF00DBFF00D3FF00D2FF00D7FF00E2FF00F2F700FFDB00FF
BC00FF9800FF7100FF4700FF1C00FF0010FF003DFF0069FF0094FF00BDFF00E3FF00FFFA
00FFDC00FFC300FFB000FFA200FF9A00FF9900FF9E00FFA800FFB800FFCE00FFE800F9FF
00D8FF00B4FF008FFF0069FF0044FF0020FF0000FF1D00FF3700FF4B00FF5A00FF6300FF
6600FF6200FF5900FF4A00FF3600FF1E00FF0300FF001AFF0038FF0056FF0072FF008CFF
00A2FF00B3FF00BEFF00C3FF00C2FF00BBFF00AEFF009CFF0088FF0071FF005AFF0044FF
0031FF0023FF001AFF0018FF001CFF0026FF0034FF0044FF0054FF0060FF0067FF0068FF
0062FF0058FF0050FF0050FF0054FF0055FF004EFF0045FF003EFF003DFF0043FF004EFF
005EFF006EFF007DFF0087FF008CFF008BFF0084FF0077FF0065FF0050FF0039FF0022FF
000CFF0500FF1300FF1B00FF1D00FF1900FF0F00FF0000FF0014FF002DFF0049FF0067FF
0085FF00A3FF00BFFF00D8FF00EDFF00FCFF00FFF800FFF400FFF500FFFD00F4FF00E1FF
00C9FF00ACFF008BFF0068FF0043FF001EFF0700FF2B00FF4D00FF6C00FF8700FF9D00FF
AE00FFBA00FFC000FFBF00FFB900FFAC00FF9A00FF8200FF6500FF4400FF1F00FF0008FF
0033FF005FFF008CFF00B9FF00E5FF00FFF000FFC800FFA400FF8300FF6700FF5000FF3F
00FF3300FF2D00FF2D00FF3300FF3F00FF5100FF6900FF8600FFA900FFCF00FFF900D8FF
00A7FF0075FF0041FF000DFF2600FF5900FF8B00FFBB00FF
00FF9E00FFCD00FFFF00CDFF0099FF0065FF0031FF0100FF3200FF6000FF8B00FFB200FF
D500FFF300FFFF00F3FF00DFFF00D2FF00CBFF00C9FF00CEFF00D9FF00EAFF00FFE400FF
C500FFA100FF7A00FF5000FF2500FF0007FF0034FF0060FF008BFF00B4FF00DAFF00FCFF
00FFE500FFCC00FFB900FFAB00FFA300FFA200FFA600FFB100FFC100FFD700FFF100F0FF
00CFFF00ABFF0086FF0060FF003BFF0017FF0900FF2600FF4000FF5400FF6300FF6C00FF
6F00FF6B00FF6200FF5300FF3F00FF2700FF0C00FF0011FF002FFF004DFF006AFF0083FF
0099FF00AAFF00B5FF00BAFF00B9FF00B2FF00A5FF0093FF007FFF0068FF0051FF003BFF
0028FF001AFF0011FF000FFF0013FF001DFF002BFF003BFF004BFF0057FF005FFF005FFF
0059FF0050FF0047FF0047FF004BFF004CFF0045FF003CFF0035FF0034FF003AFF0046FF
0055FF0065FF0074FF007EFF0084FF0083FF007BFF006EFF005CFF0047FF0030FF0019FF
0003FF0E00FF1B00FF2400FF2600FF2200FF1800FF0900FF000BFF0024FF0040FF005EFF
007CFF009AFF00B6FF00CFFF00E4FF00F4FF00FEFF00FFFC00FFFE00F9FF00ECFF00D8FF
00C0FF00A3FF0082FF005FFF003AFF0015FF1000FF3400FF5600FF7500FF9000FFA600FF
B700FFC300FFC900FFC800FFC200FFB500FFA300FF8B00FF6E00FF4D00FF2800FF0000FF
002AFF0056FF0083FF00B0FF00DCFF00FFF900FFD100FFAD00FF8C00FF7000FF5900FF48
00FF3C00FF3600FF3600FF3C00FF4800FF5A00FF7200FF8F00FFB100FFD800FDFF00CFFF
009FFF006CFF0038FF0004FF2F00FF6200FF9400FFC400FF
00FFA100FFD000FDFF00CAFF0096FF0062FF002EFF0400FF3400FF6300FF8E00FFB500FF
D800FFF600FFFF00F0FF00DDFF00CFFF00C8FF00C7FF00CBFF00D6FF00E7FF00FDE700FF
C700FFA400FF7D00FF5300FF2700FF0004FF0031FF005EFF0089FF00B1FF00D7FF00F9FF
00FFE800FFCF00FFBC00FFAE00FFA600FFA500FFA900FFB400FFC400FFD900FFF400EDFF
00CCFF00A8FF0083FF005DFF0038FF0014FF0C00FF2900FF4300FF5700FF6600FF6F00FF
7100FF6E00FF6500FF5600FF4200FF2A00FF0F00FF000EFF002CFF004AFF0067FF0080FF
0096FF00A7FF00B2FF00B7FF00B6FF00AFFF00A2FF0091FF007CFF0065FF004EFF0038FF
0025FF0017FF000FFF000CFF0011FF001AFF0028FF0038FF0048FF0055FF005CFF005CFF
0056FF004DFF0045FF0044FF0049FF004AFF0043FF0039FF0032FF0031FF0037FF0043FF
0052FF0062FF0071FF007BFF0081FF0080FF0078FF006BFF0059FF0044FF002DFF0016FF
0001FF1100FF1E00FF2700FF2900FF2500FF1B00FF0B00FF0009FF0021FF003DFF005BFF
007AFF0097FF00B3FF00CCFF00E1FF00F1FF00FBFF00FFFF00FEFF00F6FF00E9FF00D5FF
00BDFF00A0FF0080FF005DFF0038FF0012FF1200FF3700FF5800FF7700FF9200FFA900FF
BA00FFC600FFCB00FFCB00FFC500FFB800FFA600FF8E00FF7100FF5000FF2B00FF0200FF
0027FF0054FF0080FF00ADFF00D9FF00FFFC00FFD400FFB000FF8F00FF7300FF5C00FF4A
00FF3E00FF3800FF3900FF3F00FF4B00FF5D00FF7500FF9200FFB400FFDB00FAFF00CCFF
009CFF0069FF0036FF0001FF3200FF6500FF9700FFC600FF
00FF9E00FFCD00FFFE00CEFF009AFF0065FF0031FF0000FF3100FF5F00FF8A00FFB200FF
D500FFF300FFFF00F3FF00E0FF00D3FF00CBFF00CAFF00CFFF00DAFF00EAFF00FFE400FF
C400FFA000FF7900FF5000FF2400FF0008FF0035FF0061FF008CFF00B5FF00DBFF00FDFF
00FFE400FFCC00FFB800FFAA00FFA300FFA100FFA600FFB000FFC100FFD600FFF000F1FF
00CFFF00ABFF0086FF0061FF003BFF0018FF0800FF2600FF3F00FF5400FF6200FF6B00FF
6E00FF6B00FF6100FF5200FF3F00FF2600FF0B00FF0011FF0030FF004EFF006AFF0084FF
0099FF00AAFF00B5FF00BBFF00B9FF00B2FF00A5FF0094FF007FFF0068FF0051FF003BFF
0029FF001BFF0012FF0010FF0014FF001EFF002CFF003CFF004BFF0058FF005FFF0060FF
005AFF0050FF0048FF0047FF004CFF004DFF0046FF003CFF0035FF0034FF003AFF0046FF
0055FF0066FF0074FF007FFF0084FF0083FF007CFF006FFF005DFF0047FF0030FF0019FF
0004FF0D00FF1B00FF2300FF2600FF2200FF1800FF0800FF000CFF0025FF0041FF005FFF
007DFF009BFF00B7FF00CFFF00E4FF00F4FF00FFFF00FFFC00FFFD00FAFF00ECFF00D9FF
00C0FF00A3FF0083FF0060FF003BFF0015FF0F00FF3300FF5500FF7400FF8F00FFA500FF
B700FFC200FFC800FFC800FFC100FFB500FFA200FF8B00FF6E00FF4C00FF2700FF0000FF
002BFF0057FF0084FF00B1FF00DDFF00FFF800FFD100FFAC00FF8C00FF7000FF5900FF47
00FF3B00FF3500FF3500FF3B00FF4800FF5A00FF7200FF8F00FFB100FFD700FDFF00D0FF
009FFF006DFF0039FF0005FF2E00FF6200FF9400FFC300FF
00FF9400FFC300FFF500D7FF00A3FF006FFF003BFF0008FF2800FF5600FF8100FFA800FF
CB00FFEA00FFFF00FDFF00E9FF00DCFF00D5FF00D3FF00D8FF00E3FF00F3F600FFDA00FF
BB00FF9700FF7000FF4600FF1B00FF0011FF003EFF006AFF0095FF00BEFF00E4FF00FFF9
00FFDB00FFC200FFAF00FFA100FF9900FF9800FF9D00FFA700FFB700FFCD00FFE700FAFF
00D9FF00B5FF0090FF006AFF0045FF0021FF0000FF1C00FF3600FF4A00FF5900FF6200FF
6500FF6100FF5800FF4900FF3500FF1D00FF0200FF001BFF0039FF0057FF0073FF008DFF
00A3FF00B4FF00BFFF00C4FF00C3FF00BCFF00AFFF009DFF0089FF0072FF005BFF0045FF
0032FF0024FF001BFF0019FF001DFF0027FF0035FF0045FF0055FF0061FF0068FF0069FF
0063FF0059FF0051FF0051FF0055FF0056FF004FFF0046FF003FFF003EFF0044FF004FFF
005FFF006FFF007EFF0088FF008DFF008CFF0085FF0078FF0066FF0051FF003AFF0023FF
000DFF0400FF1200FF1A00FF1C00FF1800FF0E00FF0000FF0015FF002EFF004AFF0068FF
0086FF00A4FF00C0FF00D9FF00EEFF00FDFF00FFF700FFF200FFF400FFFC00F5FF00E2FF
00CAFF00ADFF008CFF0069FF0044FF001FFF0600FF2A00FF4C00FF6B00FF8600FF9C00FF
AD00FFB900FFBF00FFBE00FFB800FFAB00FF9900FF8100FF6400FF4300FF1E00FF0009FF
0034FF0060FF008DFF00BAFF00E6FF00FFEF00FFC700FFA300FF8200FF6600FF4F00FF3E
00FF3200FF2C00FF2C00FF3200FF3E00FF5000FF6800FF8500FFA700FFCE00FFF800D9FF
00A8FF0076FF0042FF000EFF2500FF5800FF8A00FFBA00FF
00FF8500FFB500FFE600E6FF00B2FF007EFF004AFF0017FF1900FF4700FF7200FF9A00FF
BC00FFDB00FFF300FFFF00F8FF00EBFF00E3FF00E2FF00E7FF00F2FD00FFE700FFCB00FF
AC00FF8800FF6100FF3700FF0C00FF0020FF004DFF0079FF00A4FF00CDFF00F3FF00FFEA
00FFCC00FFB300FFA000FF9200FF8B00FF8900FF8E00FF9800FFA800FFBE00FFD800FFF6
00E7FF00C4FF009EFF0079FF0054FF0030FF000FFF0E00FF2700FF3B00FF4A00FF5300FF
5600FF5200FF4900FF3A00FF2600FF0E00FF000CFF002AFF0048FF0066FF0082FF009CFF
00B2FF00C3FF00CEFF00D3FF00D2FF00CAFF00BEFF00ACFF0098FF0081FF006AFF0054FF
0041FF0033FF002AFF0028FF002CFF0036FF0044FF0054FF0064FF0070FF0077FF0078FF
0072FF0068FF0060FF0060FF0064FF0065FF005EFF0055FF004EFF004DFF0053FF005EFF
006EFF007EFF008CFF0097FF009CFF009BFF0094FF0087FF0075FF0060FF0049FF0032FF
001CFF000AFF0300FF0B00FF0D00FF0900FF0000FF000FFF0024FF003DFF0059FF0077FF
0095FF00B3FF00CFFF00E8FF00FCFF00FFF300FFE800FFE400FFE500FFED00FFFB00F1FF
00D9FF00BCFF009BFF0078FF0053FF002EFF0008FF1B00FF3D00FF5C00FF7700FF8D00FF
9E00FFAA00FFB000FFAF00FFA900FF9C00FF8A00FF7200FF5500FF3400FF0F00FF0018FF
0043FF006FFF009CFF00C9FF00F5FF00FFE000FFB800FF9400FF7400FF5800FF4000FF2F
00FF2300FF1D00FF1D00FF2300FF2F00FF4200FF5900FF7700FF9900FFBF00FFE900E8FF
00B7FF0085FF0051FF001DFF1600FF4900FF7B00FFAB00FF
00FF7200FFA100FFD200FAFF00C6FF0091FF005EFF002BFF0500FF3300FF5E00FF8600FF
A900FFC700FFE000FFF300FFFF00FFFF00F7FF00F6FF00FBF900FFE900FFD300FFB800FF
9800FF7400FF4D00FF2300FF0007FF0034FF0061FF008DFF00B8FF00E1FF00FFF800FFD6
00FFB800FF9F00FF8C00FF7E00FF7700FF7500FF7A00FF8400FF9400FFAA00FFC400FFE2
00FBFF00D8FF00B2FF008DFF0068FF0044FF0023FF0005FF1300FF2700FF3600FF3F00FF
4200FF3F00FF3500FF2600FF1200FF0005FF0020FF003DFF005CFF007AFF0096FF00B0FF
00C6FF00D6FF00E2FF00E7FF00E6FF00DEFF00D2FF00C0FF00ABFF0095FF007DFF0068FF
0055FF0047FF003EFF003CFF0040FF004AFF0058FF0068FF0077FF0084FF008BFF008CFF
0086FF007CFF0074FF0074FF0078FF0079FF0072FF0068FF0062FF0061FF0067FF0072FF
0082FF0092FF00A0FF00ABFF00B0FF00AFFF00A8FF009BFF0089FF0074FF005CFF0045FF
0030FF001EFF0010FF0008FF0006FF0009FF0013FF0023FF0038FF0051FF006DFF008BFF
00A9FF00C7FF00E3FF00FCFF00FFEF00FFDF00FFD400FFD000FFD100FFD900FFE700FFFA
00ECFF00D0FF00AFFF008CFF0067FF0042FF001CFF0700FF2900FF4800FF6300FF7900FF
8A00FF9600FF9C00FF9C00FF9500FF8900FF7600FF5E00FF4200FF2000FF0004FF002CFF
0057FF0083FF00B0FF00DDFF00FFF600FFCC00FFA500FF8000FF6000FF4400FF2D00FF1B
00FF0F00FF0900FF0900FF0F00FF1B00FF2E00FF4500FF6300FF8500FFAB00FFD600FCFF
00CBFF0099FF0065FF0031FF0200FF3600FF6700FF9700FF
00FF5900FF8900FFBA00FFED00DEFF00AAFF0076FF0043FF0012FF1B00FF4600FF6E00FF
9000FFAF00FFC800FFDB00FFE800FFF000FFF100FFEC00FFE100FFD100FFBB00FFA000FF
8000FF5C00FF3500FF0B00FF001FFF004CFF0079FF00A5FF00D0FF00F9FF00FFE000FFBE
00FFA000FF8700FF7400FF6600FF5F00FF5D00FF6200FF6C00FF7C00FF9200FFAC00FFCA
00FFEC00F0FF00CAFF00A5FF0080FF005CFF003BFF001DFF0004FF0F00FF1E00FF2700FF
2A00FF2600FF1D00FF0E00FF0005FF001DFF0038FF0056FF0074FF0092FF00AEFF00C8FF
00DEFF00EFFF00FAFF00FFFF00FEFF00F6FF00EAFF00D8FF00C4FF00ADFF0096FF0080FF
006DFF005FFF0056FF0054FF0058FF0062FF0070FF0080FF0090FF009CFF00A3FF00A4FF
009EFF0094FF008CFF008CFF0090FF0091FF008AFF0081FF007AFF0079FF007FFF008AFF
009AFF00AAFF00B8FF00C3FF00C8FF00C7FF00C0FF00B3FF00A1FF008CFF0075FF005EFF
0048FF0036FF0028FF0020FF001EFF0022FF002CFF003BFF0050FF0069FF0085FF00A3FF
00C1FF00DFFF00FBFF00FFEB00FFD700FFC700FFBC00FFB800FFB900FFC100FFCF00FFE2
00FFFA00E8FF00C7FF00A4FF007FFF005AFF0034FF0010FF1100FF3000FF4B00FF6100FF
7200FF7E00FF8400FF8300FF7D00FF7100FF5E00FF4600FF2900FF0800FF001CFF0044FF
006FFF009BFF00C8FF00F5FF00FFDE00FFB400FF8C00FF6800FF4800FF2C00FF1400FF03
08FF000EFF000EFF0008FF0000FF0300FF1600FF2D00FF4B00FF6D00FF9300FFBE00FFEB
00E3FF00B1FF007DFF0049FF0015FF1D00FF4F00FF7F00FF
00FF3E00FF6D00FF9F00FFD200F9FF00C5FF0091FF005EFF002DFF0000FF2B00FF5200FF
7500FF9300FFAC00FFBF00FFCD00FFD400FFD600FFD100FFC600FFB500FF9F00FF8400FF
6500FF4100FF1A00FF000FFF003BFF0067FF0094FF00C1FF00ECFF00FFEB00FFC500FFA3
00FF8500FF6C00FF5900FF4B00FF4300FF4200FF4600FF5100FF6100FF7700FF9100FFAF
00FFD000FFF400E6FF00C0FF009BFF0077FF0056FF0039FF001FFF000BFF0300FF0C00FF
0F00FF0B00FF0200FF000CFF0020FF0038FF0053FF0071FF008FFF00ADFF00CAFF00E3FF
00F9FF00FFF500FFEA00FFE500FFE600FFED00FFFA00F4FF00DFFF00C8FF00B1FF009BFF
0088FF007AFF0072FF006FFF0073FF007DFF008BFF009BFF00ABFF00B7FF00BFFF00BFFF
00B9FF00B0FF00A8FF00A7FF00ACFF00ADFF00A6FF009CFF0095FF0094FF009AFF00A6FF
00B5FF00C5FF00D4FF00DEFF00E4FF00E3FF00DBFF00CEFF00BCFF00A7FF0090FF0079FF
0064FF0051FF0044FF003BFF0039FF003DFF0047FF0057FF006BFF0084FF00A0FF00BEFF
00DDFF00FAFF00FFE900FFD000FFBB00FFAB00FFA100FF9C00FF9E00FFA600FFB300FFC7
00FFDF00FFFC00E3FF00BFFF009BFF0075FF0050FF002BFF0009FF1400FF2F00FF4600FF
5700FF6300FF6900FF6800FF6200FF5500FF4300FF2B00FF0E00FF0012FF0037FF0060FF
008AFF00B6FF00E3FF00FFEF00FFC300FF9900FF7100FF4D00FF2C00FF1006FF0017FF00
23FF0029FF0029FF0023FF0017FF0005FF0000FF1200FF2F00FF5100FF7800FFA200FFD0
00FFFF00CCFF0099FF0064FF0030FF0200FF3400FF6400FF
00FF2100FF5000FF8100FFB400FFE800E2FF00AEFF007CFF004BFF001DFF0D00FF3500FF
5800FF7600FF8F00FFA200FFAF00FFB700FFB800FFB300FFA800FF9800FF8200FF6700FF
4700FF2300FF0003FF002CFF0058FF0085FF00B2FF00DEFF00FFF600FFCD00FFA700FF85
00FF6700FF4F00FF3B00FF2D00FF2600FF2400FF2900FF3300FF4400FF5900FF7300FF91
00FFB300FFD700FFFC00DEFF00B8FF0095FF0074FF0056FF003DFF0028FF001AFF0011FF
000EFF0011FF001BFF002AFF003DFF0056FF0071FF008EFF00ADFF00CBFF00E7FF00FFFE
00FFE900FFD800FFCD00FFC700FFC900FFD000FFDD00FFEE00FCFF00E5FF00CEFF00B9FF
00A6FF0098FF008FFF008DFF0091FF009BFF00A9FF00B9FF00C8FF00D5FF00DCFF00DDFF
00D7FF00CDFF00C5FF00C4FF00C9FF00CAFF00C3FF00B9FF00B2FF00B1FF00B7FF00C3FF
00D2FF00E3FF00F1FF00FCFF00FFFE00FFFF00F9FF00ECFF00DAFF00C4FF00ADFF0096FF
0081FF006FFF0061FF0059FF0056FF005AFF0064FF0074FF0089FF00A2FF00BEFF00DCFF
00FAFF00FFE700FFCB00FFB300FF9E00FF8E00FF8300FF7F00FF8000FF8800FF9600FFA9
00FFC200FFDF00FFFF00DDFF00B8FF0092FF006DFF0049FF0027FF0008FF1200FF2800FF
3A00FF4500FF4B00FF4B00FF4400FF3800FF2500FF0E00FF000EFF0030FF0055FF007DFF
00A8FF00D4FF00FFFE00FFD100FFA500FF7B00FF5400FF2F00FF0F0CFF0023FF0035FF00
41FF0047FF0047FF0041FF0034FF0022FF000AFF0000FF1200FF3400FF5A00FF8500FFB2
00FFE300EAFF00B6FF0082FF004EFF001AFF1700FF4600FF
00FF0200FF3100FF6300FF9600FFCA00FFFE00CDFF009AFF0069FF003BFF0010FF1600FF
3900FF5700FF7000FF8400FF9100FF9800FF9A00FF9500FF8A00FF7A00FF6300FF4800FF
2900FF0500FF0021FF004BFF0076FF00A3FF00D0FF00FCFF00FFD800FFAF00FF8900FF67
00FF4900FF3000FF1D00FF0F00FF0700FF0600FF0A00FF1500FF2500FF3B00FF5500FF73
00FF9400FFB800FFDD00FCFF00D7FF00B3FF0092FF0075FF005BFF0047FF0038FF002FFF
002CFF0030FF0039FF0048FF005CFF0074FF008FFF00ADFF00CBFF00E9FF00FFF900FFE0
00FFCA00FFB900FFAE00FFA900FFAA00FFB100FFBE00FFD000FFE400FFFB00EDFF00D7FF
00C4FF00B6FF00ADFF00ABFF00AFFF00B9FF00C7FF00D7FF00E7FF00F3FF00FAFF00FBFF
00F5FF00ECFF00E3FF00E3FF00E7FF00E8FF00E1FF00D8FF00D1FF00D0FF00D6FF00E2FF
00F1FF00FFFE00FFEF00FFE500FFDF00FFE000FFE800FFF500F8FF00E3FF00CCFF00B5FF
009FFF008DFF007FFF0077FF0075FF0079FF0083FF0092FF00A7FF00C0FF00DCFF00FAFF
00FFE700FFC900FFAD00FF9400FF7F00FF6F00FF6500FF6000FF6200FF6A00FF7800FF8B
00FFA300FFC000FFE100FBFF00D6FF00B1FF008BFF0067FF0045FF0026FF000BFF0A00FF
1B00FF2700FF2D00FF2C00FF2600FF1900FF0700FF0010FF002DFF004EFF0073FF009BFF
00C6FF00F2FF00FFE000FFB300FF8700FF5D00FF3500FF110FFF002BFF0042FF0053FF00
5FFF0065FF0065FF005FFF0053FF0041FF0029FF000CFF0000FF1500FF3C00FF6600FF94
00FFC400FFF700D4FF00A0FF006CFF0039FF0007FF2800FF
1BFF0000FF1300FF4500FF7800FFAC00FFE000EBFF00B8FF0087FF0059FF002EFF0007FF
1B00FF3900FF5200FF6600FF7300FF7A00FF7C00FF7700FF6C00FF5B00FF4500FF2A00FF
0B00FF0018FF003FFF0069FF0094FF00C1FF00EEFF00FFE500FFBA00FF9100FF6B00FF49
00FF2B00FF1200FF000EFF0016FF0017FF0013FF0008FF0000FF0700FF1D00FF3700FF55
00FF7600FF9A00FFBF00FFE500F5FF00D1FF00B0FF0093FF0079FF0065FF0056FF004DFF
004AFF004EFF0057FF0066FF007AFF0092FF00ADFF00CBFF00E9FF00FFF800FFDB00FFC2
00FFAC00FF9B00FF9000FF8B00FF8C00FF9300FFA000FFB100FFC600FFDD00FFF400F5FF
00E2FF00D4FF00CBFF00C9FF00CDFF00D7FF00E5FF00F5FF00FFFA00FFEE00FFE600FFE6
00FFEC00FFF500FFFE00FFFE00FFFA00FFF900FFFF00F6FF00EFFF00EEFF00F4FF00FFFF
00FFF000FFE000FFD100FFC700FFC100FFC200FFCA00FFD700FFE900FFFE00EAFF00D3FF
00BDFF00ABFF009EFF0095FF0093FF0097FF00A1FF00B1FF00C5FF00DEFF00FAFF00FFE7
00FFC800FFAB00FF8F00FF7600FF6100FF5100FF4700FF4200FF4400FF4C00FF5900FF6D
00FF8500FFA200FFC300FFE600F4FF00CFFF00A9FF0085FF0063FF0044FF0029FF0013FF
0002FF0900FF0F00FF0E00FF0800FF0004FF0016FF002EFF004BFF006CFF0091FF00B9FF
00E4FF00FFEF00FFC200FF9500FF6900FF3F00FF170CFF002DFF0049FF0060FF0071FF00
7DFF0083FF0083FF007DFF0071FF005FFF0047FF002AFF0008FF0000FF1E00FF4800FF76
00FFA600FFD900F2FF00BEFF008AFF0057FF0025FF0A00FF
37FF0008FF0000FF2800FF5B00FF8F00FFC400FFF800D5FF00A4FF0076FF004AFF0023FF
0000FF1D00FF3600FF4900FF5700FF5E00FF5F00FF5A00FF5000FF3F00FF2900FF0E00FF
0011FF0034FF005CFF0085FF00B1FF00DEFF00FFF400FFC800FF9D00FF7400FF4E00FF2C
00FF0F09FF001DFF002AFF0032FF0034FF002FFF0024FF0014FF0000FF0000FF1A00FF39
00FF5A00FF7E00FFA300FFC900FFEE00EEFF00CDFF00AFFF0096FF0081FF0072FF006AFF
0067FF006AFF0073FF0082FF0096FF00AEFF00CAFF00E7FF00FFF900FFDB00FFBF00FFA5
00FF9000FF7F00FF7400FF6F00FF7000FF7700FF8400FF9500FFAA00FFC100FFD800FFEE
00FFFF00F0FF00E8FF00E6FF00EAFF00F3FF00FFFE00FFED00FFDE00FFD100FFCA00FFCA
00FFCF00FFD900FFE100FFE200FFDD00FFDC00FFE300FFED00FFF400FFF500FFEF00FFE3
00FFD400FFC300FFB500FFAA00FFA500FFA600FFAD00FFBB00FFCC00FFE200FFF900EFFF
00DAFF00C8FF00BAFF00B2FF00AFFF00B3FF00BDFF00CDFF00E2FF00FBFF00FFE800FFCA
00FFAC00FF8E00FF7300FF5A00FF4500FF3500FF2B00FF2600FF2800FF2F00FF3D00FF50
00FF6900FF8600FFA600FFC900FFEE00EBFF00C6FF00A2FF0080FF0061FF0046FF0030FF
001EFF0013FF000DFF000DFF0014FF0020FF0032FF004AFF0067FF0088FF00AEFF00D6FF
00FFFE00FFD200FFA500FF7800FF4D00FF2204FF0029FF0049FF0065FF007CFF008EFF00
9AFF00A0FF00A0FF0099FF008DFF007BFF0063FF0046FF0024FF0000FF0100FF2C00FF5A
00FF8A00FFBC00FFF000DBFF00A6FF0073FF0041FF0012FF
51FF0022FF0000FF0F00FF4200FF7600FFAA00FFDE00EEFF00BDFF008FFF0064FF003DFF
001AFF0300FF1C00FF3000FF3D00FF4400FF4600FF4100FF3600FF2500FF0F00FF000BFF
002AFF004EFF0075FF009FFF00CAFF00F7FF00FFDB00FFAE00FF8300FF5B00FF3500FF13
0AFF0023FF0036FF0044FF004CFF004DFF0049FF003EFF002EFF0018FF0000FF0100FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF800E6FF00C9FF00AFFF009BFF008CFF0083FF
0080FF0084FF008DFF009CFF00B0FF00C8FF00E3FF00FFFE00FFE000FFC200FFA500FF8C
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE700FFF500FFFD00FFFF00FFFC00FFF200FFE400FFD400FFC400FFB800FFB000FFB0
00FFB600FFBF00FFC700FFC800FFC300FFC200FFCA00FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9100FF8B00FF8C00FF9400FFA100FFB300FFC800FFDF00FFF6
00F3FF00E1FF00D4FF00CBFF00C9FF00CDFF00D7FF00E7FF00FBFF00FFEB00FFCF00FFB1
00FF9200FF7500FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1600FF2300FF37
00FF4F00FF6C00FF8C00FFB000FFD400FFFA00DFFF00BBFF0099FF007BFF0060FF0049FF
0038FF002CFF0026FF0027FF002DFF003AFF004CFF0064FF0081FF00A2FF00C7FF00F0FF
00FFE500FFB900FF8C00FF5F00FF3300FF091EFF0042FF0063FF007FFF0096FF00A7FF00
B3FF00B9FF00B9FF00B3FF00A7FF0095FF007DFF0060FF003EFF0017FF0000FF1200FF40
00FF7000FFA300FFD600F4FF00C0FF008DFF005BFF002BFF
67FF0037FF0006FF0000FF2C00FF6000FF9400FFC800FFFB00D3FF00A5FF007AFF0052FF
002FFF0011FF0700FF1A00FF2700FF2F00FF3000FF2B00FF2000FF1000FF0005FF0020FF
0040FF0064FF008BFF00B5FF00E0FF00FFF200FFC500FF9900FF6E00FF4500FF1F02FF00
20FF0039FF004CFF005AFF0061FF0063FF005EFF0054FF0044FF002EFF0014FF0000FF09
00FF2B00FF4E00FF7400FF9900FFBE00FFE200FCFF00DEFF00C5FF00B1FF00A2FF0099FF
0096FF0099FF00A3FF00B2FF00C6FF00DEFF00F9FF00FFE900FFCA00FFAC00FF9000FF76
00FF6000FF5000FF4400FF3F00FF4000FF4800FF5400FF6600FF7B00FF9100FFA900FFBE
00FFD100FFDF00FFE800FFEA00FFE600FFDC00FFCE00FFBE00FFAE00FFA200FF9B00FF9A
00FFA000FFAA00FFB200FFB200FFAE00FFAD00FFB400FFBE00FFC400FFC500FFBF00FFB4
00FFA400FF9400FF8600FF7B00FF7600FF7700FF7E00FF8B00FF9D00FFB200FFC900FFE0
00FFF600F7FF00E9FF00E1FF00DFFF00E2FF00EDFF00FCFF00FFEE00FFD500FFB900FF9B
00FF7D00FF5F00FF4300FF2A00FF1600FF0604FF0008FF0007FF0000FF0000FF0E00FF21
00FF3900FF5600FF7700FF9A00FFBF00FFE400F5FF00D1FF00AFFF0090FF0075FF005FFF
004EFF0042FF003CFF003CFF0043FF004FFF0062FF007AFF0096FF00B8FF00DDFF00FFFA
00FFCF00FFA300FF7600FF4900FF1D0CFF0033FF0058FF0078FF0094FF00ABFF00BDFF00
C9FF00CFFF00CFFF00C9FF00BDFF00AAFF0093FF0075FF0053FF002DFF0002FF0000FF2A
00FF5B00FF8D00FFC100FFF500D6FF00A2FF0071FF0041FF
77FF0048FF0017FF0000FF1B00FF4F00FF8400FFB800FFEA00E4FF00B6FF008BFF0063FF
0040FF0022FF0009FF0900FF1600FF1E00FF1F00FF1A00FF0F00FF0000FF0016FF0031FF
0051FF0075FF009CFF00C5FF00F1FF00FFE100FFB400FF8800FF5D00FF3400FF0E13FF00
31FF0049FF005DFF006BFF0072FF0074FF006FFF0065FF0054FF003FFF0025FF0007FF00
00FF1A00FF3E00FF6300FF8800FFAE00FFD100FFF200EFFF00D6FF00C1FF00B3FF00AAFF
00A7FF00AAFF00B4FF00C3FF00D6FF00EFFF00FFF500FFD800FFB900FF9B00FF7F00FF65
00FF5000FF3F00FF3400FF2E00FF3000FF3700FF4400FF5500FF6A00FF8100FF9800FFAD
00FFC000FFCE00FFD700FFD900FFD500FFCB00FFBD00FFAD00FF9E00FF9100FF8A00FF89
00FF8F00FF9900FFA100FFA200FF9D00FF9C00FFA300FFAD00FFB400FFB400FFAF00FFA3
00FF9400FF8300FF7500FF6A00FF6500FF6600FF6D00FF7A00FF8C00FFA200FFB900FFD0
00FFE500FFF700FAFF00F2FF00EFFF00F3FF00FDFF00FFF200FFDD00FFC400FFA800FF8A
00FF6C00FF4E00FF3200FF1A00FF050AFF0015FF0019FF0018FF0010FF0002FF0000FF10
00FF2900FF4500FF6600FF8900FFAE00FFD400FFF900E2FF00C0FF00A1FF0086FF0070FF
005EFF0053FF004DFF004DFF0054FF0060FF0073FF008AFF00A7FF00C9FF00EEFF00FFE9
00FFBE00FF9200FF6500FF3800FF0C1DFF0044FF0069FF0089FF00A5FF00BCFF00CEFF00
DAFF00E0FF00E0FF00DAFF00CDFF00BBFF00A3FF0086FF0064FF003EFF0013FF0000FF19
00FF4A00FF7C00FFB000FFE400E7FF00B3FF0082FF0052FF
83FF0053FF0022FF0000FF1000FF4400FF7800FFAC00FFDF00EFFF00C1FF0096FF006EFF
004BFF002DFF0014FF0001FF0B00FF1300FF1400FF0F00FF0400FF000BFF0021FF003CFF
005CFF0080FF00A7FF00D1FF00FCFF00FFD600FFA900FF7D00FF5200FF2900FF031EFF00
3CFF0055FF0068FF0076FF007DFF007FFF007AFF0070FF0060FF004AFF0030FF0012FF00
00FF0F00FF3200FF5800FF7D00FFA200FFC600FFE700FAFF00E1FF00CDFF00BEFF00B5FF
00B2FF00B5FF00BFFF00CEFF00E2FF00FAFF00FFEA00FFCD00FFAE00FF9000FF7400FF5A
00FF4400FF3400FF2800FF2300FF2400FF2C00FF3800FF4A00FF5F00FF7500FF8D00FFA2
00FFB500FFC300FFCC00FFCE00FFCA00FFC000FFB200FFA200FF9200FF8600FF7F00FF7E
00FF8400FF8E00FF9600FF9600FF9200FF9100FF9800FFA200FFA800FFA900FFA300FF98
00FF8800FF7800FF6A00FF5F00FF5A00FF5B00FF6200FF6F00FF8100FF9600FFAD00FFC4
00FFDA00FFEC00FFFA00FDFF00FBFF00FEFF00FFF600FFE700FFD200FFB900FF9D00FF7F
00FF6100FF4300FF2700FF0E05FF0015FF0020FF0024FF0023FF001BFF000DFF0000FF05
00FF1D00FF3A00FF5B00FF7E00FFA300FFC800FFEE00EDFF00CBFF00ACFF0091FF007BFF
006AFF005EFF0058FF0058FF005FFF006BFF007EFF0096FF00B2FF00D4FF00F9FF00FFDE
00FFB300FF8700FF5A00FF2D00FF0128FF004FFF0074FF0094FF00B0FF00C7FF00D9FF00
E5FF00EBFF00EBFF00E5FF00D9FF00C6FF00AFFF0091FF006FFF0049FF001EFF0000FF0E
00FF3F00FF7100FFA500FFD900F2FF00BEFF008DFF005DFF
88FF0058FF0027FF0000FF0B00FF3F00FF7300FFA700FFDA00F4FF00C6FF009BFF0074FF
0051FF0032FF001AFF0006FF0600FF0E00FF0F00FF0A00FF0000FF0010FF0026FF0042FF
0061FF0085FF00ACFF00D6FF00FFFE00FFD100FFA400FF7800FF4D00FF2401FF0023FF00
41FF005AFF006DFF007BFF0082FF0084FF007FFF0075FF0065FF004FFF0035FF0017FF00
00FF0A00FF2D00FF5300FF7800FF9D00FFC100FFE200FFFF00E6FF00D2FF00C3FF00BAFF
00B7FF00BBFF00C4FF00D3FF00E7FF00FFFF00FFE500FFC700FFA900FF8B00FF6F00FF55
00FF3F00FF2E00FF2300FF1E00FF1F00FF2600FF3300FF4500FF5900FF7000FF8700FF9D
00FFB000FFBE00FFC700FFC900FFC500FFBB00FFAD00FF9D00FF8D00FF8100FF7A00FF79
00FF7F00FF8900FF9100FF9100FF8D00FF8C00FF9300FF9C00FFA300FFA400FF9E00FF93
00FF8300FF7300FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7C00FF9100FFA800FFBF
00FFD500FFE700FFF500FFFD00FFFF00FFFB00FFF100FFE200FFCD00FFB400FF9800FF7A
00FF5C00FF3E00FF2200FF090AFF001AFF0025FF0029FF0028FF0020FF0012FF0000FF00
00FF1800FF3500FF5600FF7900FF9E00FFC300FFE900F2FF00D0FF00B1FF0096FF0080FF
006FFF0063FF005DFF005EFF0064FF0071FF0083FF009BFF00B8FF00D9FF00FEFF00FFD9
00FFAE00FF8200FF5500FF2803FF002DFF0055FF0079FF0099FF00B6FF00CDFF00DEFF00
EAFF00F0FF00F0FF00EAFF00DEFF00CBFF00B4FF0097FF0074FF004EFF0024FF0000FF09
00FF3A00FF6C00FFA000FFD400F7FF00C4FF0092FF0062FF
86FF0057FF0026FF0000FF0C00FF4000FF7500FFA800FFDB00F3FF00C5FF009AFF0072FF
004FFF0031FF0018FF0005FF0700FF0F00FF1000FF0B00FF0000FF000FFF0025FF0040FF
0060FF0084FF00ABFF00D5FF00FFFF00FFD200FFA500FF7900FF4E00FF2500FF0022FF00
40FF0059FF006CFF007AFF0081FF0083FF007EFF0074FF0064FF004EFF0034FF0016FF00
00FF0B00FF2E00FF5400FF7900FF9E00FFC200FFE300FEFF00E5FF00D1FF00C2FF00B9FF
00B6FF00B9FF00C3FF00D2FF00E6FF00FEFF00FFE600FFC900FFAA00FF8C00FF7000FF56
00FF4000FF3000FF2400FF1F00FF2000FF2800FF3400FF4600FF5B00FF7100FF8900FF9E
00FFB100FFBF00FFC800FFCA00FFC600FFBC00FFAE00FF9E00FF8F00FF8200FF7B00FF7A
00FF8000FF8A00FF9200FF9300FF8E00FF8D00FF9400FF9E00FFA400FFA500FF9F00FF94
00FF8400FF7400FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7D00FF9200FFAA00FFC1
00FFD600FFE800FFF600FFFE00FFFF00FFFD00FFF300FFE300FFCE00FFB500FF9900FF7B
00FF5D00FF3F00FF2300FF0A09FF0019FF0024FF0028FF0027FF001FFF0011FF0000FF01
00FF1A00FF3600FF5700FF7A00FF9F00FFC400FFEA00F1FF00CFFF00B0FF0095FF007FFF
006EFF0062FF005CFF005CFF0063FF006FFF0082FF009AFF00B6FF00D8FF00FDFF00FFDA
00FFAF00FF8300FF5600FF2902FF002CFF0053FF0078FF0098FF00B4FF00CBFF00DDFF00
E9FF00EFFF00EFFF00E9FF00DCFF00CAFF00B3FF0095FF0073FF004DFF0022FF0000FF0A
00FF3B00FF6D00FFA100FFD500F6FF00C2FF0091FF0061FF
7FFF0050FF001FFF0000FF1300FF4700FF7C00FFB000FFE200ECFF00BEFF0092FF006BFF
0048FF002AFF0011FF0100FF0F00FF1600FF1700FF1200FF0800FF0008FF001EFF0039FF
0059FF007DFF00A4FF00CDFF00F9FF00FFD900FFAC00FF8000FF5500FF2C00FF061BFF00
39FF0051FF0065FF0072FF007AFF007CFF0077FF006DFF005CFF0047FF002DFF000FFF00
00FF1200FF3600FF5B00FF8100FFA600FFC900FFEA00F7FF00DEFF00C9FF00BBFF00B2FF
00AFFF00B2FF00BCFF00CAFF00DEFF00F6FF00FFED00FFD000FFB100FF9300FF7700FF5D
00FF4800FF3700FF2C00FF2600FF2800FF2F00FF3C00FF4D00FF6200FF7900FF9000FFA6
00FFB800FFC600FFCF00FFD100FFCD00FFC300FFB600FFA500FF9600FF8900FF8200FF81
00FF8700FF9100FF9900FF9A00FF9500FF9400FF9B00FFA500FFAC00FFAD00FFA700FF9B
00FF8C00FF7B00FF6D00FF6200FF5D00FF5E00FF6500FF7200FF8400FF9A00FFB100FFC8
00FFDD00FFEF00FFFD00FAFF00F7FF00FBFF00FFFA00FFEA00FFD500FFBC00FFA000FF82
00FF6400FF4600FF2A00FF1202FF0012FF001DFF0021FF0020FF0018FF000AFF0000FF08
00FF2100FF3E00FF5E00FF8100FFA600FFCC00FFF100EAFF00C8FF00A9FF008EFF0078FF
0066FF005BFF0055FF0055FF005CFF0068FF007BFF0092FF00AFFF00D1FF00F6FF00FFE1
00FFB600FF8A00FF5D00FF3000FF0525FF004CFF0071FF0091FF00ADFF00C4FF00D6FF00
E2FF00E8FF00E8FF00E2FF00D5FF00C3FF00ABFF008EFF006CFF0046FF001BFF0000FF12
00FF4200FF7400FFA800FFDC00EFFF00BBFF0089FF005AFF
73FF0043FF0012FF0000FF2000FF5400FF8800FFBC00FFEF00DFFF00B1FF0086FF005EFF
003BFF001DFF0004FF0E00FF1B00FF2300FF2400FF1F00FF1400FF0400FF0011FF002CFF
004CFF0070FF0097FF00C1FF00ECFF00FFE600FFB900FF8D00FF6200FF3900FF130EFF00
2CFF0045FF0058FF0066FF006DFF006FFF006AFF0060FF0050FF003AFF0020FF0002FF00
00FF1F00FF4200FF6800FF8D00FFB200FFD600FFF700EAFF00D1FF00BDFF00AEFF00A5FF
00A2FF00A5FF00AFFF00BEFF00D2FF00EAFF00FFFA00FFDD00FFBE00FFA000FF8400FF6A
00FF5400FF4400FF3800FF3300FF3400FF3C00FF4800FF5A00FF6F00FF8500FF9D00FFB2
00FFC500FFD300FFDC00FFDE00FFDA00FFD000FFC200FFB200FFA200FF9600FF8F00FF8E
00FF9400FF9E00FFA600FFA600FFA200FFA100FFA800FFB200FFB800FFB900FFB300FFA8
00FF9800FF8800FF7A00FF6F00FF6A00FF6B00FF7200FF7F00FF9100FFA600FFBD00FFD4
00FFEA00FFFC00F5FF00EDFF00EBFF00EEFF00F9FF00FFF700FFE200FFC900FFAD00FF8F
00FF7100FF5300FF3700FF1E00FF0A05FF0010FF0014FF0013FF000BFF0000FF0200FF15
00FF2D00FF4A00FF6B00FF8E00FFB300FFD800FFFE00DDFF00BBFF009CFF0081FF006BFF
005AFF004EFF0048FF0048FF004FFF005BFF006EFF0086FF00A2FF00C4FF00E9FF00FFEE
00FFC300FF9700FF6A00FF3D00FF1118FF003FFF0064FF0084FF00A0FF00B7FF00C9FF00
D5FF00DBFF00DBFF00D5FF00C9FF00B6FF009FFF0081FF005FFF0039FF000EFF0000FF1E
00FF4F00FF8100FFB500FFE900E2FF00AEFF007DFF004DFF
61FF0032FF0001FF0000FF3200FF6600FF9A00FFCE00FFFF00CEFF009FFF0074FF004DFF
002AFF000CFF0C00FF1F00FF2D00FF3400FF3500FF3000FF2600FF1500FF0000FF001BFF
003BFF005EFF0085FF00AFFF00DBFF00FFF800FFCB00FF9E00FF7300FF4A00FF2400FF02
1AFF0033FF0047FF0054FF005CFF005EFF0059FF004EFF003EFF0029FF000FFF0000FF0F
00FF3000FF5400FF7900FF9F00FFC400FFE700F7FF00D9FF00C0FF00ABFF009CFF0093FF
0091FF0094FF009DFF00ACFF00C0FF00D8FF00F4FF00FFEE00FFD000FFB100FF9500FF7B
00FF6600FF5500FF4A00FF4500FF4600FF4D00FF5A00FF6B00FF8000FF9700FFAE00FFC4
00FFD600FFE500FFED00FFEF00FFEB00FFE200FFD400FFC400FFB400FFA700FFA000FFA0
00FFA600FFAF00FFB700FFB800FFB300FFB200FFB900FFC300FFCA00FFCB00FFC500FFB9
00FFAA00FF9A00FF8B00FF8000FF7B00FF7C00FF8300FF9100FFA300FFB800FFCF00FFE6
00FFFB00F2FF00E4FF00DCFF00D9FF00DDFF00E7FF00F7FF00FFF300FFDA00FFBE00FFA1
00FF8200FF6400FF4900FF3000FF1B00FF0B00FF0103FF0001FF0000FF0500FF1300FF26
00FF3F00FF5C00FF7C00FF9F00FFC400FFEA00F0FF00CCFF00AAFF008BFF0070FF0059FF
0048FF003DFF0037FF0037FF003EFF004AFF005CFF0074FF0091FF00B2FF00D8FF00FFFF
00FFD400FFA800FF7B00FF4F00FF2306FF002EFF0052FF0073FF008FFF00A6FF00B8FF00
C4FF00CAFF00CAFF00C3FF00B7FF00A5FF008DFF0070FF004EFF0027FF0000FF0200FF30
00FF6000FF9200FFC600FFFA00D0FF009DFF006BFF003CFF
4CFF001DFF0000FF1300FF4600FF7A00FFAF00FFE300EAFF00B9FF008BFF0060FF0038FF
0015FF0800FF2100FF3400FF4100FF4900FF4A00FF4500FF3A00FF2A00FF1400FF0006FF
0026FF004AFF0071FF009AFF00C6FF00F3FF00FFDF00FFB300FF8800FF5F00FF3900FF17
06FF001EFF0032FF0040FF0047FF0049FF0044FF003AFF0029FF0014FF0000FF0500FF23
00FF4500FF6900FF8E00FFB300FFD900FFFC00E2FF00C4FF00ABFF0096FF0088FF007FFF
007CFF007FFF0089FF0098FF00ABFF00C4FF00DFFF00FCFF00FFE400FFC600FFAA00FF90
00FF7B00FF6A00FF5F00FF5900FF5B00FF6200FF6F00FF8000FF9500FFAC00FFC300FFD9
00FFEB00FFF900FDFF00FBFF00FFFF00FFF600FFE800FFD800FFC900FFBC00FFB500FFB4
00FFBA00FFC400FFCC00FFCD00FFC800FFC700FFCE00FFD800FFDF00FFE000FFDA00FFCE
00FFBF00FFAE00FFA000FF9500FF9000FF9100FF9800FFA500FFB700FFCD00FFE400FFFB
00EFFF00DDFF00CFFF00C7FF00C4FF00C8FF00D2FF00E2FF00F7FF00FFEF00FFD300FFB5
00FF9700FF7900FF5D00FF4500FF3000FF2000FF1500FF1100FF1200FF1A00FF2800FF3B
00FF5400FF7100FF9100FFB400FFD900FFFF00DBFF00B7FF0095FF0076FF005BFF0045FF
0033FF0028FF0022FF0022FF0029FF0035FF0048FF005FFF007CFF009EFF00C3FF00EBFF
00FFE900FFBD00FF9000FF6300FF3800FF0D19FF003EFF005EFF007AFF0091FF00A3FF00
AFFF00B5FF00B5FF00AFFF00A2FF0090FF0078FF005BFF0039FF0013FF0000FF1700FF44
00FF7500FFA700FFDB00F0FF00BCFF0088FF0056FF0027FF
35FF0006FF0000FF2A00FF5D00FF9100FFC600FFF900D3FF00A2FF0074FF0049FF0021FF
0100FF1F00FF3800FF4B00FF5800FF6000FF6100FF5C00FF5100FF4100FF2B00FF1000FF
000FFF0033FF005AFF0084FF00AFFF00DCFF00FFF600FFCA00FF9F00FF7600FF5000FF2E
00FF1008FF001BFF0029FF0030FF0032FF002DFF0023FF0013FF0000FF0200FF1C00FF3A
00FF5C00FF7F00FFA500FFCA00FFEF00ECFF00CBFF00ADFF0094FF0080FF0071FF0068FF
0065FF0068FF0072FF0081FF0095FF00ADFF00C8FF00E5FF00FFFB00FFDD00FFC100FFA7
00FF9100FF8100FF7500FF7000FF7100FF7900FF8500FF9700FFAC00FFC200FFDA00FFEF
00FDFF00EFFF00E6FF00E4FF00E8FF00F2FF00FFFF00FFEF00FFE000FFD300FFCC00FFCB
00FFD100FFDB00FFE300FFE300FFDF00FFDE00FFE500FFEF00FFF500FFF600FFF000FFE5
00FFD500FFC500FFB700FFAC00FFA700FFA800FFAF00FFBC00FFCE00FFE300FFFB00EDFF
00D8FF00C6FF00B8FF00B0FF00AEFF00B1FF00BBFF00CBFF00E0FF00F9FF00FFEA00FFCC
00FFAE00FF9000FF7400FF5B00FF4700FF3700FF2C00FF2800FF2900FF3100FF3F00FF52
00FF6B00FF8700FFA800FFCB00FFF000EAFF00C4FF00A0FF007EFF005FFF0044FF002EFF
001DFF0011FF000BFF000BFF0012FF001EFF0031FF0049FF0065FF0087FF00ACFF00D4FF
00FFFF00FFD400FFA700FF7A00FF4E00FF2402FF0027FF0047FF0063FF007AFF008CFF00
98FF009EFF009EFF0098FF008CFF0079FF0062FF0044FF0022FF0000FF0300FF2E00FF5B
00FF8C00FFBE00FFF200D9FF00A5FF0071FF0040FF0010FF
1EFF0000FF1000FF4100FF7400FFA800FFDD00EEFF00BCFF008BFF005DFF0032FF000AFF
1800FF3600FF4F00FF6200FF6F00FF7700FF7800FF7300FF6800FF5800FF4200FF2700FF
0700FF001CFF0043FF006CFF0098FF00C5FF00F2FF00FFE100FFB600FF8D00FF6700FF45
00FF2700FF0F04FF0012FF0019FF001BFF0016FF000CFF0000FF0400FF1900FF3300FF51
00FF7300FF9700FFBC00FFE100F8FF00D5FF00B4FF0096FF007DFF0068FF005AFF0051FF
004EFF0051FF005BFF006AFF007DFF0096FF00B1FF00CEFF00EDFF00FFF400FFD800FFBE
00FFA900FF9800FF8D00FF8700FF8900FF9000FF9D00FFAE00FFC300FFDA00FFF100F9FF
00E6FF00D8FF00CFFF00CDFF00D1FF00DBFF00E9FF00F9FF00FFF700FFEA00FFE300FFE2
00FFE800FFF200FFFA00FFFB00FFF600FFF500FFFC00F9FF00F2FF00F2FF00F7FF00FFFC
00FFED00FFDC00FFCE00FFC300FFBE00FFBF00FFC600FFD300FFE500FFFB00EDFF00D6FF
00C1FF00AFFF00A1FF0099FF0096FF009AFF00A4FF00B4FF00C9FF00E2FF00FEFF00FFE3
00FFC500FFA700FF8B00FF7300FF5E00FF4E00FF4300FF3F00FF4000FF4800FF5600FF69
00FF8200FF9E00FFBF00FFE200F8FF00D2FF00ADFF0089FF0067FF0048FF002DFF0017FF
0005FF0500FF0B00FF0B00FF0400FF0007FF001AFF0031FF004EFF0070FF0095FF00BDFF
00E8FF00FFEB00FFBE00FF9100FF6500FF3B00FF1410FF0030FF004CFF0063FF0075FF00
81FF0087FF0087FF0081FF0074FF0062FF004AFF002DFF000BFF0000FF1A00FF4500FF72
00FFA300FFD500F6FF00C2FF008EFF005AFF0028FF0600FF
09FF0000FF2600FF5700FF8A00FFBE00FFF200D9FF00A6FF0075FF0047FF001CFF0B00FF
2E00FF4C00FF6500FF7800FF8500FF8D00FF8E00FF8900FF7E00FF6E00FF5800FF3D00FF
1D00FF0006FF002DFF0057FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0303FF0005FF0000FF0000FF0900FF1900FF2F00FF4900FF67
00FF8900FFAC00FFD200FFF700E3FF00BFFF009EFF0080FF0067FF0053FF0044FF003BFF
0038FF003BFF0045FF0054FF0068FF0080FF009BFF00B9FF00D7FF00F5FF00FFEE00FFD4
00FFBE00FFAD00FFA200FF9D00FF9E00FFA600FFB200FFC400FFD900FFEF00F9FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F3FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EFFF00F3FF00F4FF00EDFF00E3FF00DDFF00DCFF00E2FF00EDFF
00FDFF00FFF200FFE400FFD900FFD400FFD500FFDC00FFE900FFFB00EFFF00D8FF00C1FF
00ABFF0099FF008BFF0083FF0081FF0085FF008FFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7400FF6400FF5900FF5500FF5600FF5E00FF6C00FF7F
00FF9700FFB400FFD500FFF800E2FF00BDFF0097FF0073FF0051FF0032FF0017FF0001FF
0F00FF1B00FF2100FF2100FF1A00FF0E00FF0004FF001CFF0038FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2A00FF051AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006BFF005FFF004CFF0035FF0017FF0000FF0A00FF3000FF5B00FF88
00FFB900FFEB00E0FF00ACFF0078FF0045FF0013FF1C00FF
00FF0900FF3800FF6A00FF9D00FFD100FAFF00C6FF0093FF0062FF0034FF0009FF1D00FF
4000FF5E00FF7700FF8B00FF9800FF9F00FFA100FF9C00FF9100FF8000FF6A00FF4F00FF
3000FF0C00FF001AFF0044FF006FFF009CFF00C9FF00F6FF00FFDE00FFB600FF9000FF6E
00FF5000FF3700FF2400FF1600FF0E00FF0D00FF1100FF1C00FF2C00FF4200FF5C00FF7A
00FF9B00FFBF00FFE400F5FF00D0FF00ACFF008BFF006EFF0054FF0040FF0031FF0028FF
0025FF0029FF0032FF0041FF0055FF006DFF0088FF00A6FF00C4FF00E2FF00FFFF00FFE7
00FFD100FFC000FFB500FFB000FFB100FFB800FFC500FFD600FFEB00FDFF00E6FF00D0FF
00BDFF00AFFF00A7FF00A4FF00A8FF00B2FF00C0FF00D0FF00E0FF00ECFF00F4FF00F4FF
00EEFF00E5FF00DDFF00DCFF00E0FF00E2FF00DAFF00D1FF00CAFF00C9FF00CFFF00DBFF
00EAFF00FAFF00FFF600FFEC00FFE600FFE700FFEF00FFFC00F1FF00DCFF00C5FF00AEFF
0098FF0086FF0079FF0070FF006EFF0072FF007CFF008CFF00A0FF00B9FF00D5FF00F3FF
00FFED00FFD000FFB400FF9B00FF8600FF7600FF6C00FF6700FF6900FF7100FF7E00FF92
00FFAA00FFC700FFE700F4FF00D0FF00AAFF0084FF0060FF003EFF0020FF0005FF1100FF
2200FF2E00FF3400FF3300FF2D00FF2000FF0E00FF0009FF0026FF0047FF006CFF0095FF
00BFFF00EBFF00FFE700FFBA00FF8E00FF6400FF3C00FF1808FF0024FF003BFF004CFF00
58FF005EFF005EFF0058FF004CFF003AFF0022FF0005FF0000FF1C00FF4300FF6D00FF9B
00FFCB00FFFE00CEFF0099FF0065FF0032FF0000FF2F00FF
00FF1700FF4700FF7800FFAB00FFDF00ECFF00B8FF0085FF0054FF0026FF0400FF2B00FF
4E00FF6D00FF8500FF9900FFA600FFAE00FFAF00FFAA00FF9F00FF8F00FF7900FF5D00FF
3E00FF1A00FF000CFF0036FF0061FF008EFF00BBFF00E7FF00FFED00FFC400FF9E00FF7C
00FF5E00FF4500FF3200FF2400FF1D00FF1B00FF2000FF2A00FF3A00FF5000FF6A00FF88
00FFAA00FFCD00FFF300E7FF00C2FF009EFF007DFF005FFF0046FF0032FF0023FF001AFF
0017FF001BFF0024FF0033FF0047FF005FFF007AFF0098FF00B6FF00D4FF00F0FF00FFF5
00FFDF00FFCE00FFC300FFBE00FFBF00FFC600FFD300FFE500FFF900EFFF00D8FF00C2FF
00AFFF00A1FF0098FF0096FF009AFF00A4FF00B2FF00C2FF00D2FF00DEFF00E5FF00E6FF
00E0FF00D6FF00CEFF00CEFF00D2FF00D3FF00CCFF00C3FF00BCFF00BBFF00C1FF00CCFF
00DCFF00ECFF00FAFF00FFFA00FFF500FFF600FFFD00F5FF00E3FF00CEFF00B7FF00A0FF
008AFF0078FF006AFF0062FF0060FF0064FF006EFF007DFF0092FF00ABFF00C7FF00E5FF
00FFFC00FFDE00FFC200FFA900FF9500FF8500FF7A00FF7600FF7700FF7F00FF8D00FFA0
00FFB800FFD500FFF600E6FF00C1FF009CFF0076FF0052FF0030FF0011FF0900FF1F00FF
3000FF3C00FF4200FF4100FF3B00FF2E00FF1C00FF0400FF0018FF0039FF005EFF0086FF
00B1FF00DDFF00FFF500FFC800FF9C00FF7200FF4A00FF2600FF0616FF002DFF003EFF00
4AFF0050FF0050FF004AFF003EFF002BFF0014FF0000FF0800FF2B00FF5100FF7B00FFA9
00FFDA00F3FF00BFFF008BFF0057FF0024FF0D00FF3D00FF
00FF2000FF4F00FF8000FFB400FFE800E3FF00AFFF007DFF004CFF001DFF0D00FF3400FF
5700FF7500FF8E00FFA100FFAF00FFB600FFB700FFB300FFA800FF9700FF8100FF6600FF
4600FF2300FF0003FF002DFF0059FF0085FF00B2FF00DFFF00FFF500FFCC00FFA700FF84
00FF6700FF4E00FF3A00FF2D00FF2500FF2400FF2800FF3300FF4300FF5800FF7200FF91
00FFB200FFD600FFFB00DEFF00B9FF0096FF0075FF0057FF003EFF0029FF001AFF0011FF
000FFF0012FF001BFF002AFF003EFF0056FF0072FF008FFF00ADFF00CBFF00E8FF00FFFD
00FFE800FFD700FFCC00FFC700FFC800FFCF00FFDC00FFED00FDFF00E6FF00CFFF00B9FF
00A7FF0098FF0090FF008EFF0092FF009BFF00A9FF00B9FF00C9FF00D6FF00DDFF00DDFF
00D7FF00CEFF00C6FF00C5FF00CAFF00CBFF00C4FF00BAFF00B3FF00B2FF00B8FF00C4FF
00D3FF00E3FF00F2FF00FDFF00FFFD00FFFE00FAFF00ECFF00DAFF00C5FF00AEFF0097FF
0082FF0070FF0062FF005AFF0057FF005BFF0065FF0075FF008AFF00A3FF00BFFF00DCFF
00FBFF00FFE600FFCB00FFB200FF9D00FF8D00FF8300FF7E00FF8000FF8700FF9500FFA8
00FFC100FFDE00FFFE00DEFF00B9FF0093FF006EFF004AFF0028FF0009FF1100FF2800FF
3900FF4500FF4A00FF4A00FF4400FF3700FF2500FF0D00FF000FFF0030FF0056FF007EFF
00A8FF00D5FF00FFFD00FFD100FFA500FF7B00FF5300FF2F00FF0E0DFF0024FF0036FF00
42FF0048FF0048FF0041FF0035FF0023FF000BFF0000FF1100FF3300FF5A00FF8400FFB2
00FFE200EBFF00B7FF0083FF004EFF001BFF1600FF4500FF
00FF2200FF5100FF8300FFB600FFEA00E1FF00ADFF007AFF0049FF001BFF0F00FF3600FF
5900FF7700FF9000FFA400FFB100FFB800FFBA00FFB500FFAA00FF9900FF8300FF6800FF
4900FF2500FF0001FF002BFF0056FF0083FF00B0FF00DDFF00FFF700FFCF00FFA900FF87
00FF6900FF5000FF3D00FF2F00FF2700FF2600FF2A00FF3500FF4500FF5B00FF7500FF93
00FFB400FFD800FFFD00DCFF00B7FF0093FF0072FF0055FF003BFF0027FF0018FF000FFF
000CFF0010FF0019FF0028FF003CFF0054FF006FFF008DFF00ABFF00C9FF00E6FF00FFFF
00FFEA00FFD900FFCE00FFC900FFCA00FFD100FFDE00FFEF00FBFF00E4FF00CDFF00B7FF
00A4FF0096FF008EFF008BFF008FFF0099FF00A7FF00B7FF00C7FF00D3FF00DBFF00DBFF
00D5FF00CCFF00C4FF00C3FF00C8FF00C9FF00C2FF00B8FF00B1FF00B0FF00B6FF00C2FF
00D1FF00E1FF00F0FF00FAFF00FFFF00FFFF00F7FF00EAFF00D8FF00C3FF00ACFF0095FF
007FFF006DFF0060FF0057FF0055FF0059FF0063FF0073FF0087FF00A0FF00BCFF00DAFF
00F9FF00FFE900FFCD00FFB400FF9F00FF8F00FF8500FF8000FF8200FF8A00FF9700FFAB
00FFC300FFE000FFFF00DBFF00B7FF0091FF006CFF0047FF0025FF0007FF1300FF2A00FF
3B00FF4700FF4D00FF4C00FF4600FF3900FF2700FF0F00FF000DFF002EFF0053FF007CFF
00A6FF00D2FF00FFFF00FFD300FFA700FF7D00FF5500FF3100FF100BFF0022FF0033FF00
3FFF0045FF0045FF003FFF0033FF0021FF0009FF0000FF1300FF3500FF5C00FF8600FFB4
00FFE400E8FF00B5FF0080FF004CFF0019FF1800FF4800FF
00FF1E00FF4D00FF7F00FFB200FFE600E5FF00B1FF007EFF004EFF001FFF0B00FF3200FF
5500FF7300FF8C00FF9F00FFAD00FFB400FFB500FFB100FFA600FF9500FF7F00FF6400FF
4400FF2100FF0005FF002FFF005BFF0087FF00B4FF00E1FF00FFF300FFCB00FFA500FF83
00FF6500FF4C00FF3900FF2B00FF2300FF2200FF2600FF3100FF4100FF5600FF7100FF8F
00FFB000FFD400FFF900E0FF00BBFF0097FF0076FF0059FF003FFF002BFF001CFF0013FF
0011FF0014FF001DFF002CFF0040FF0058FF0073FF0091FF00AFFF00CDFF00EAFF00FFFC
00FFE600FFD500FFCA00FFC500FFC600FFCD00FFDA00FFEB00FFFF00E8FF00D1FF00BBFF
00A8FF009AFF0092FF008FFF0094FF009DFF00ABFF00BBFF00CBFF00D8FF00DFFF00DFFF
00D9FF00D0FF00C8FF00C7FF00CCFF00CDFF00C6FF00BCFF00B5FF00B4FF00BAFF00C6FF
00D5FF00E5FF00F4FF00FEFF00FFFB00FFFC00FBFF00EEFF00DCFF00C7FF00B0FF0099FF
0084FF0071FF0064FF005BFF0059FF005DFF0067FF0077FF008CFF00A4FF00C0FF00DEFF
00FDFF00FFE500FFC900FFB000FF9B00FF8B00FF8100FF7C00FF7E00FF8600FF9300FFA7
00FFBF00FFDC00FFFC00E0FF00BBFF0095FF0070FF004BFF002AFF000BFF0F00FF2600FF
3700FF4300FF4800FF4800FF4200FF3500FF2300FF0B00FF0011FF0032FF0057FF0080FF
00AAFF00D7FF00FFFC00FFCF00FFA300FF7900FF5100FF2D00FF0C0FFF0026FF0038FF00
44FF004AFF0049FF0043FF0037FF0025FF000DFF0000FF0F00FF3100FF5800FF8200FFB0
00FFE000ECFF00B9FF0084FF0050FF001DFF1400FF4400FF
00FF1400FF4300FF7500FFA800FFDC00EFFF00BBFF0088FF0057FF0029FF0100FF2800FF
4B00FF6A00FF8200FF9600FFA300FFAA00FFAC00FFA700FF9C00FF8C00FF7600FF5A00FF
3B00FF1700FF000FFF0039FF0064FF0091FF00BEFF00EAFF00FFEA00FFC100FF9B00FF79
00FF5B00FF4200FF2F00FF2100FF1900FF1800FF1D00FF2700FF3700FF4D00FF6700FF85
00FFA600FFCA00FFEF00EAFF00C5FF00A1FF0080FF0063FF0049FF0035FF0026FF001DFF
001AFF001EFF0027FF0036FF004AFF0062FF007DFF009BFF00B9FF00D7FF00F3FF00FFF2
00FFDC00FFCB00FFC000FFBB00FFBC00FFC300FFD000FFE200FFF600F2FF00DBFF00C5FF
00B2FF00A4FF009BFF0099FF009DFF00A7FF00B5FF00C5FF00D5FF00E1FF00E8FF00E9FF
00E3FF00D9FF00D1FF00D1FF00D5FF00D6FF00CFFF00C6FF00BFFF00BEFF00C4FF00CFFF
00DFFF00EFFF00FEFF00FFF700FFF200FFF300FFFA00F8FF00E6FF00D1FF00BAFF00A3FF
008DFF007BFF006DFF0065FF0063FF0067FF0071FF0080FF0095FF00AEFF00CAFF00E8FF
00FFF900FFDB00FFBF00FFA600FF9100FF8200FF7700FF7200FF7400FF7C00FF8A00FF9D
00FFB500FFD200FFF300E9FF00C4FF009FFF0079FF0055FF0033FF0014FF0600FF1C00FF
2D00FF3900FF3F00FF3E00FF3800FF2B00FF1900FF0100FF001BFF003CFF0061FF0089FF
00B4FF00E0FF00FFF200FFC500FF9900FF6F00FF4700FF2300FF0219FF0030FF0041FF00
4DFF0053FF0053FF004DFF0041FF002FFF0017FF0000FF0500FF2700FF4E00FF7800FFA6
00FFD700F6FF00C2FF008EFF005AFF0027FF0A00FF3A00FF
00FF0600FF3600FF6700FF9A00FFCE00FDFF00C9FF0096FF0065FF0037FF000CFF1A00FF
3D00FF5C00FF7400FF8800FF9500FF9D00FF9E00FF9900FF8E00FF7E00FF6800FF4C00FF
2D00FF0900FF001DFF0047FF0072FF009FFF00CCFF00F8FF00FFDC00FFB300FF8D00FF6B
00FF4D00FF3400FF2100FF1300FF0C00FF0A00FF0F00FF1900FF2900FF3F00FF5900FF77
00FF9900FFBC00FFE200F8FF00D3FF00AFFF008EFF0070FF0057FF0043FF0034FF002BFF
0028FF002CFF0035FF0044FF0058FF0070FF008BFF00A9FF00C7FF00E5FF00FFFE00FFE4
00FFCE00FFBD00FFB200FFAD00FFAE00FFB600FFC200FFD400FFE800FFFF00E9FF00D3FF
00C0FF00B2FF00A9FF00A7FF00ABFF00B5FF00C3FF00D3FF00E3FF00EFFF00F6FF00F7FF
00F1FF00E7FF00DFFF00DFFF00E3FF00E4FF00DDFF00D4FF00CDFF00CCFF00D2FF00DDFF
00EDFF00FDFF00FFF400FFE900FFE400FFE500FFEC00FFF900F4FF00DFFF00C8FF00B1FF
009BFF0089FF007BFF0073FF0071FF0075FF007FFF008EFF00A3FF00BCFF00D8FF00F6FF
00FFEB00FFCD00FFB100FF9800FF8400FF7400FF6900FF6500FF6600FF6E00FF7C00FF8F
00FFA700FFC400FFE500F7FF00D2FF00ADFF0087FF0063FF0041FF0022FF0007FF0E00FF
1F00FF2B00FF3100FF3000FF2A00FF1D00FF0B00FF000CFF0029FF004AFF006FFF0097FF
00C2FF00EEFF00FFE400FFB700FF8B00FF6100FF3900FF150AFF0026FF003EFF004FFF00
5BFF0061FF0061FF005BFF004FFF003CFF0025FF0008FF0000FF1A00FF4000FF6A00FF98
00FFC900FFFB00D0FF009CFF0068FF0035FF0003FF2C00FF
09FF0000FF2500FF5700FF8A00FFBE00FFF200D9FF00A6FF0075FF0047FF001CFF0A00FF
2D00FF4B00FF6400FF7800FF8500FF8C00FF8E00FF8900FF7E00FF6E00FF5700FF3C00FF
1D00FF0006FF002DFF0057FF0082FF00AFFF00DCFF00FFF700FFCC00FFA300FF7D00FF5B
00FF3D00FF2400FF1100FF0304FF0005FF0001FF0000FF0900FF1900FF2F00FF4900FF67
00FF8800FFAC00FFD100FFF700E3FF00BFFF009EFF0081FF0067FF0053FF0044FF003BFF
0038FF003CFF0045FF0054FF0068FF0080FF009BFF00B9FF00D7FF00F5FF00FFED00FFD4
00FFBE00FFAD00FFA200FF9D00FF9E00FFA500FFB200FFC400FFD800FFEF00F9FF00E3FF
00D0FF00C2FF00B9FF00B7FF00BBFF00C5FF00D3FF00E3FF00F3FF00FFFF00FFF900FFF8
00FFFE00F7FF00EFFF00EFFF00F3FF00F4FF00EDFF00E4FF00DDFF00DCFF00E2FF00EEFF
00FDFF00FFF200FFE300FFD900FFD300FFD400FFDC00FFE900FFFB00EFFF00D8FF00C1FF
00ABFF0099FF008BFF0083FF0081FF0085FF008FFF009EFF00B3FF00CCFF00E8FF00FFF9
00FFDB00FFBD00FFA100FF8800FF7300FF6300FF5900FF5400FF5600FF5E00FF6C00FF7F
00FF9700FFB400FFD500FFF800E2FF00BDFF0097FF0073FF0051FF0032FF0017FF0001FF
0F00FF1B00FF2100FF2000FF1A00FF0D00FF0004FF001CFF0039FF005AFF007FFF00A7FF
00D2FF00FEFF00FFD400FFA700FF7B00FF5100FF2900FF051BFF0037FF004EFF005FFF00
6BFF0071FF0071FF006BFF005FFF004DFF0035FF0018FF0000FF0900FF3000FF5A00FF88
00FFB800FFEB00E0FF00ACFF0078FF0045FF0013FF1C00FF
18FF0000FF1600FF4700FF7A00FFAE00FFE300E9FF00B6FF0085FF0057FF002CFF0004FF
1E00FF3C00FF5500FF6800FF7500FF7D00FF7E00FF7900FF6E00FF5E00FF4800FF2D00FF
0D00FF0016FF003DFF0066FF0092FF00BFFF00ECFF00FFE700FFBC00FF9300FF6D00FF4B
00FF2D00FF1500FF010CFF0013FF0015FF0010FF0006FF0000FF0A00FF1F00FF3900FF57
00FF7900FF9D00FFC200FFE700F2FF00CFFF00AEFF0090FF0077FF0063FF0054FF004BFF
0048FF004BFF0055FF0064FF0077FF0090FF00ABFF00C8FF00E7FF00FFFA00FFDE00FFC4
00FFAE00FF9E00FF9200FF8D00FF8F00FF9600FFA200FFB400FFC900FFE000FFF700F3FF
00E0FF00D2FF00C9FF00C7FF00CBFF00D5FF00E3FF00F3FF00FFFD00FFF000FFE900FFE8
00FFEE00FFF800FFFF00FEFF00FFFC00FFFB00FDFF00F3FF00ECFF00ECFF00F1FF00FDFF
00FFF300FFE200FFD400FFC900FFC400FFC500FFCC00FFD900FFEB00FEFF00E7FF00D0FF
00BBFF00A9FF009BFF0093FF0090FF0094FF009EFF00AEFF00C3FF00DCFF00F8FF00FFE9
00FFCB00FFAD00FF9100FF7900FF6400FF5400FF4900FF4500FF4600FF4E00FF5C00FF6F
00FF8800FFA400FFC500FFE800F2FF00CCFF00A7FF0083FF0061FF0042FF0027FF0011FF
0000FF0B00FF1100FF1100FF0A00FF0001FF0014FF002BFF0048FF006AFF008FFF00B7FF
00E2FF00FFF100FFC400FF9700FF6B00FF4100FF1A0AFF002AFF0046FF005DFF006FFF00
7BFF0081FF0081FF007BFF006EFF005CFF0044FF0027FF0005FF0000FF2000FF4B00FF78
00FFA900FFDB00F0FF00BCFF0088FF0054FF0023FF0C00FF
25FF0000FF0900FF3B00FF6E00FFA200FFD600F5FF00C2FF0092FF0063FF0038FF0011FF
1100FF2F00FF4800FF5B00FF6900FF7000FF7100FF6D00FF6200FF5100FF3B00FF2000FF
0000FF0022FF0049FF0073FF009FFF00CBFF00F8FF00FFDA00FFAF00FF8600FF6100FF3F
00FF2100FF080BFF0018FF0020FF0021FF001DFF0012FF0002FF0000FF1200FF2D00FF4B
00FF6C00FF9000FFB500FFDB00FFFF00DBFF00BAFF009DFF0083FF006FFF0060FF0057FF
0055FF0058FF0061FF0070FF0084FF009CFF00B7FF00D5FF00F3FF00FFEE00FFD100FFB8
00FFA200FF9100FF8600FF8100FF8200FF8900FF9600FFA700FFBC00FFD300FFEA00FFFF
00ECFF00DEFF00D6FF00D3FF00D8FF00E1FF00EFFF00FFFF00FFF000FFE300FFDC00FFDC
00FFE200FFEB00FFF300FFF400FFEF00FFEE00FFF500FFFF00F9FF00F8FF00FEFF00FFF5
00FFE600FFD600FFC700FFBC00FFB700FFB800FFC000FFCD00FFDF00FFF400F4FF00DDFF
00C8FF00B5FF00A8FF009FFF009DFF00A1FF00ABFF00BBFF00D0FF00E8FF00FFFB00FFDD
00FFBE00FFA100FF8500FF6C00FF5700FF4700FF3D00FF3800FF3A00FF4200FF4F00FF63
00FF7B00FF9800FFB800FFDB00FFFF00D9FF00B4FF008FFF006EFF004FFF0034FF001DFF
000CFF0000FF0400FF0400FF0001FF000EFF0020FF0038FF0055FF0076FF009BFF00C4FF
00EEFF00FFE400FFB800FF8B00FF5F00FF3500FF0D16FF0037FF0053FF006AFF007CFF00
88FF008EFF008DFF0087FF007BFF0069FF0051FF0034FF0012FF0000FF1400FF3E00FF6C
00FF9C00FFCF00FDFF00C8FF0094FF0061FF002FFF0000FF
2CFF0000FF0200FF3300FF6600FF9B00FFCF00FCFF00CAFF0099FF006AFF003FFF0018FF
0A00FF2800FF4100FF5400FF6200FF6900FF6A00FF6500FF5B00FF4A00FF3400FF1900FF
0006FF0029FF0050FF007AFF00A6FF00D2FF00FFFF00FFD300FFA800FF7F00FF5900FF37
00FF1A00FF0112FF001FFF0027FF0029FF0024FF0019FF0009FF0000FF0B00FF2500FF44
00FF6500FF8900FFAE00FFD400FFF900E3FF00C2FF00A4FF008BFF0076FF0067FF005FFF
005CFF005FFF0068FF0077FF008BFF00A3FF00BFFF00DCFF00FAFF00FFE600FFCA00FFB0
00FF9B00FF8A00FF7F00FF7A00FF7B00FF8200FF8F00FFA000FFB500FFCC00FFE300FFF9
00F4FF00E5FF00DDFF00DBFF00DFFF00E8FF00F6FF00FFF900FFE900FFDC00FFD500FFD5
00FFDA00FFE400FFEC00FFED00FFE800FFE700FFEE00FFF800FFFF00FFFF00FFFA00FFEE
00FFDF00FFCF00FFC000FFB500FFB000FFB100FFB800FFC600FFD700FFED00FBFF00E4FF
00CFFF00BDFF00AFFF00A7FF00A4FF00A8FF00B2FF00C2FF00D7FF00F0FF00FFF300FFD5
00FFB700FF9900FF7E00FF6500FF5000FF4000FF3600FF3100FF3300FF3A00FF4800FF5B
00FF7400FF9100FFB100FFD400FFF900E0FF00BBFF0097FF0075FF0056FF003BFF0024FF
0013FF0008FF0002FF0002FF0009FF0015FF0027FF003FFF005CFF007DFF00A3FF00CBFF
00F6FF00FFDD00FFB000FF8400FF5800FF2E00FF061EFF003EFF005AFF0071FF0083FF00
8FFF0095FF0095FF008EFF0082FF0070FF0058FF003BFF0019FF0000FF0D00FF3700FF65
00FF9500FFC700FFFB00D0FF009BFF0068FF0036FF0007FF
2DFF0000FF0200FF3300FF6600FF9A00FFCE00FDFF00CAFF0099FF006BFF0040FF0019FF
0900FF2800FF4000FF5400FF6100FF6900FF6A00FF6500FF5A00FF4A00FF3400FF1800FF
0006FF002AFF0051FF007BFF00A6FF00D3FF00FFFF00FFD300FFA800FF7F00FF5900FF37
00FF1900FF0012FF0020FF0027FF0029FF0024FF001AFF000AFF0000FF0B00FF2500FF43
00FF6500FF8800FFAE00FFD300FFF800E3FF00C2FF00A4FF008BFF0077FF0068FF005FFF
005CFF0060FF0069FF0078FF008CFF00A4FF00BFFF00DDFF00FBFF00FFE600FFCA00FFB0
00FF9A00FF8900FF7E00FF7900FF7A00FF8100FF8E00FFA000FFB400FFCB00FFE200FFF8
00F4FF00E6FF00DDFF00DBFF00DFFF00E9FF00F7FF00FFF800FFE800FFDC00FFD500FFD4
00FFDA00FFE400FFEC00FFEC00FFE800FFE700FFEE00FFF700FFFE00FFFF00FFF900FFEE
00FFDE00FFCE00FFC000FFB500FFB000FFB100FFB800FFC500FFD700FFEC00FCFF00E5FF
00CFFF00BDFF00AFFF00A7FF00A5FF00A9FF00B3FF00C2FF00D7FF00F0FF00FFF300FFD5
00FFB700FF9900FF7D00FF6400FF5000FF4000FF3500FF3100FF3200FF3A00FF4800FF5B
00FF7300FF9000FFB100FFD400FFF900E1FF00BBFF0097FF0075FF0056FF003BFF0025FF
0014FF0008FF0002FF0003FF0009FF0016FF0028FF0040FF005DFF007EFF00A3FF00CBFF
00F6FF00FFDD00FFB000FF8300FF5700FF2D00FF051EFF003EFF005AFF0072FF0083FF00
8FFF0095FF0095FF008FFF0083FF0070FF0059FF003CFF0019FF0000FF0C00FF3600FF64
00FF9500FFC700FFFB00D0FF009CFF0069FF0037FF0007FF
27FF0000FF0700FF3900FF6C00FFA000FFD400F7FF00C4FF0093FF0065FF003AFF0013FF
0F00FF2D00FF4600FF5A00FF6700FF6E00FF7000FF6B00FF6000FF5000FF3900FF1E00FF
0000FF0024FF004BFF0075FF00A0FF00CDFF00FAFF00FFD900FFAE00FF8500FF5F00FF3D
00FF1F00FF060CFF001AFF0022FF0023FF001FFF0014FF0004FF0000FF1100FF2B00FF49
00FF6A00FF8E00FFB300FFD900FFFE00DDFF00BCFF009FFF0085FF0071FF0062FF0059FF
0056FF005AFF0063FF0072FF0086FF009EFF00B9FF00D7FF00F5FF00FFEC00FFCF00FFB6
00FFA000FF8F00FF8400FF7F00FF8000FF8700FF9400FFA600FFBA00FFD100FFE800FFFE
00EEFF00E0FF00D7FF00D5FF00D9FF00E3FF00F1FF00FFFE00FFEE00FFE200FFDA00FFDA
00FFE000FFE900FFF200FFF200FFEE00FFED00FFF400FFFD00FBFF00FAFF00FFFF00FFF3
00FFE400FFD400FFC500FFBB00FFB500FFB600FFBE00FFCB00FFDD00FFF200F6FF00DFFF
00C9FF00B7FF00A9FF00A1FF009FFF00A3FF00ADFF00BCFF00D1FF00EAFF00FFF900FFDB
00FFBD00FF9F00FF8300FF6A00FF5500FF4500FF3B00FF3600FF3800FF4000FF4D00FF61
00FF7900FF9600FFB700FFDA00FFFF00DBFF00B5FF0091FF006FFF0050FF0035FF001FFF
000EFF0002FF0300FF0200FF0003FF0010FF0022FF003AFF0057FF0078FF009DFF00C5FF
00F0FF00FFE300FFB600FF8900FF5D00FF3300FF0B18FF0039FF0055FF006CFF007DFF00
89FF008FFF008FFF0089FF007DFF006BFF0053FF0036FF0014FF0000FF1200FF3C00FF6A
00FF9A00FFCD00FEFF00CAFF0096FF0063FF0031FF0001FF
1DFF0000FF1100FF4200FF7500FFAA00FFDE00EDFF00BBFF008AFF005BFF0030FF0009FF
1900FF3700FF5000FF6300FF7100FF7800FF7900FF7400FF6A00FF5900FF4300FF2800FF
0800FF001AFF0042FF006BFF0097FF00C4FF00F0FF00FFE200FFB700FF8E00FF6800FF46
00FF2900FF1003FF0010FF0018FF001AFF0015FF000AFF0000FF0500FF1A00FF3400FF53
00FF7400FF9800FFBD00FFE300F7FF00D4FF00B3FF0095FF007CFF0067FF0058FF0050FF
004DFF0050FF0059FF0068FF007CFF0094FF00B0FF00CDFF00ECFF00FFF500FFD900FFBF
00FFAA00FF9900FF8E00FF8900FF8A00FF9100FF9E00FFAF00FFC400FFDB00FFF200F7FF
00E5FF00D6FF00CEFF00CCFF00D0FF00D9FF00E7FF00F7FF00FFF800FFEB00FFE400FFE4
00FFE900FFF300FFFB00FFFC00FFF700FFF600FFFD00F8FF00F1FF00F0FF00F6FF00FFFD
00FFEE00FFDE00FFCF00FFC400FFBF00FFC000FFC700FFD500FFE600FFFC00ECFF00D5FF
00C0FF00AEFF00A0FF0098FF0095FF0099FF00A3FF00B3FF00C8FF00E1FF00FDFF00FFE4
00FFC600FFA800FF8D00FF7400FF5F00FF4F00FF4500FF4000FF4200FF4900FF5700FF6A
00FF8300FFA000FFC000FFE300F7FF00D1FF00ACFF0088FF0066FF0047FF002CFF0015FF
0004FF0600FF0C00FF0C00FF0500FF0006FF0018FF0030FF004DFF006EFF0094FF00BCFF
00E7FF00FFEC00FFBF00FF9300FF6700FF3C00FF150FFF002FFF004BFF0062FF0074FF00
80FF0086FF0086FF007FFF0073FF0061FF0049FF002CFF000AFF0000FF1B00FF4600FF74
00FFA400FFD600F5FF00C1FF008CFF0059FF0027FF0700FF
15FF0000FF1900FF4A00FF7E00FFB200FFE600E5FF00B3FF0082FF0053FF0028FF0001FF
2100FF3F00FF5800FF6B00FF7900FF8000FF8100FF7C00FF7200FF6100FF4B00FF3000FF
1000FF0012FF0039FF0063FF008FFF00BBFF00E8FF00FFEA00FFBF00FF9600FF7100FF4E
00FF3100FF1800FF0408FF0010FF0012FF000DFF0002FF0000FF0D00FF2200FF3C00FF5B
00FF7C00FFA000FFC500FFEB00EFFF00CCFF00ABFF008DFF0074FF005FFF0050FF0047FF
0045FF0048FF0051FF0060FF0074FF008CFF00A8FF00C5FF00E3FF00FFFE00FFE100FFC7
00FFB200FFA100FF9600FF9100FF9200FF9900FFA600FFB700FFCC00FFE300FFFA00EFFF
00DDFF00CEFF00C6FF00C4FF00C8FF00D1FF00DFFF00EFFF00FFFF00FFF300FFEC00FFEC
00FFF200FFFB00FCFF00FBFF00FFFF00FFFE00FAFF00F0FF00E9FF00E8FF00EEFF00FAFF
00FFF600FFE600FFD700FFCC00FFC700FFC800FFCF00FFDD00FFEF00FBFF00E4FF00CDFF
00B8FF00A6FF0098FF0090FF008DFF0091FF009BFF00ABFF00C0FF00D9FF00F5FF00FFED
00FFCE00FFB000FF9500FF7C00FF6700FF5700FF4D00FF4800FF4A00FF5100FF5F00FF72
00FF8B00FFA800FFC800FFEB00EFFF00C9FF00A4FF0080FF005EFF003FFF0024FF000DFF
0300FF0F00FF1400FF1400FF0D00FF0100FF0010FF0028FF0045FF0066FF008CFF00B4FF
00DEFF00FFF400FFC700FF9B00FF6F00FF4500FF1D06FF0027FF0043FF005AFF006CFF00
78FF007EFF007EFF0077FF006BFF0059FF0041FF0024FF0002FF0000FF2400FF4E00FF7C
00FFAC00FFDE00EDFF00B9FF0084FF0051FF001FFF0F00FF
14FF0000FF1A00FF4B00FF7E00FFB200FFE700E5FF00B2FF0081FF0053FF0028FF0000FF
2200FF4000FF5900FF6C00FF7900FF8100FF8200FF7D00FF7200FF6200FF4C00FF3100FF
1100FF0012FF0039FF0062FF008EFF00BBFF00E8FF00FFEB00FFC000FF9700FF7100FF4F
00FF3100FF1800FF0508FF000FFF0011FF000CFF0002FF0000FF0E00FF2300FF3D00FF5B
00FF7D00FFA100FFC600FFEB00EEFF00CBFF00AAFF008CFF0073FF005FFF0050FF0047FF
0044FF0047FF0051FF0060FF0074FF008CFF00A7FF00C4FF00E3FF00FFFE00FFE200FFC8
00FFB200FFA200FF9600FF9100FF9300FF9A00FFA600FFB800FFCD00FFE300FFFB00EFFF
00DCFF00CEFF00C5FF00C3FF00C7FF00D1FF00DFFF00EFFF00FEFF00FFF400FFED00FFEC
00FFF200FFFC00FBFF00FAFF00FFFF00FFFF00F9FF00EFFF00E8FF00E8FF00EEFF00F9FF
00FFF700FFE600FFD800FFCD00FFC800FFC900FFD000FFDD00FFEF00FAFF00E3FF00CCFF
00B7FF00A5FF0097FF008FFF008CFF0090FF009AFF00AAFF00BFFF00D8FF00F4FF00FFED
00FFCF00FFB100FF9500FF7D00FF6800FF5800FF4D00FF4900FF4A00FF5200FF6000FF73
00FF8C00FFA800FFC900FFEC00EEFF00C8FF00A3FF007FFF005DFF003EFF0023FF000DFF
0400FF0F00FF1500FF1500FF0E00FF0200FF0010FF0027FF0044FF0066FF008BFF00B3FF
00DEFF00FFF500FFC800FF9B00FF6F00FF4500FF1E06FF0026FF0042FF0059FF006BFF00
77FF007DFF007DFF0077FF006AFF0058FF0040FF0023FF0001FF0000FF2400FF4F00FF7C
00FFAD00FFDF00ECFF00B8FF0084FF0050FF001FFF1000FF
19FF0000FF1500FF4700FF7A00FFAE00FFE200E9FF00B6FF0086FF0057FF002CFF0005FF
1D00FF3B00FF5400FF6700FF7500FF7C00FF7D00FF7900FF6E00FF5D00FF4700FF2C00FF
0C00FF0016FF003DFF0067FF0093FF00BFFF00ECFF00FFE600FFBB00FF9200FF6D00FF4A
00FF2D00FF1400FF000CFF0014FF0015FF0011FF0006FF0000FF0900FF1E00FF3900FF57
00FF7800FF9C00FFC100FFE700F3FF00D0FF00AFFF0091FF0078FF0063FF0054FF004BFF
0049FF004CFF0055FF0064FF0078FF0090FF00ACFF00C9FF00E7FF00FFFA00FFDD00FFC3
00FFAE00FF9D00FF9200FF8D00FF8E00FF9500FFA200FFB300FFC800FFDF00FFF600F3FF
00E0FF00D2FF00CAFF00C8FF00CCFF00D5FF00E3FF00F3FF00FFFC00FFEF00FFE800FFE8
00FFEE00FFF700FFFF00FFFF00FFFB00FFFA00FEFF00F4FF00EDFF00ECFF00F2FF00FEFF
00FFF200FFE200FFD300FFC800FFC300FFC400FFCB00FFD900FFEB00FFFF00E8FF00D1FF
00BCFF00AAFF009CFF0093FF0091FF0095FF009FFF00AFFF00C4FF00DDFF00F9FF00FFE9
00FFCA00FFAC00FF9100FF7800FF6300FF5300FF4900FF4400FF4600FF4D00FF5B00FF6F
00FF8700FFA400FFC400FFE700F3FF00CDFF00A8FF0084FF0062FF0043FF0028FF0011FF
0000FF0B00FF1000FF1000FF0A00FF0002FF0014FF002CFF0049FF006AFF008FFF00B8FF
00E2FF00FFF000FFC300FF9700FF6B00FF4100FF190AFF002BFF0047FF005EFF0070FF00
7CFF0082FF0082FF007BFF006FFF005DFF0045FF0028FF0006FF0000FF2000FF4A00FF78
00FFA800FFDB00F1FF00BDFF0088FF0055FF0023FF0B00FF
1AFF0000FF1400FF4500FF7900FFAD00FFE100EAFF00B8FF0087FF0058FF002DFF0006FF
1C00FF3A00FF5300FF6600FF7400FF7B00FF7C00FF7800FF6D00FF5C00FF4600FF2B00FF
0B00FF0017FF003EFF0068FF0094FF00C0FF00EDFF00FFE500FFBA00FF9100FF6C00FF49
00FF2C00FF1300FF000DFF0015FF0016FF0012FF0007FF0000FF0800FF1D00FF3700FF56
00FF7700FF9B00FFC000FFE600F4FF00D1FF00B0FF0092FF0079FF0064FF0055FF004CFF
004AFF004DFF0056FF0065FF0079FF0091FF00ADFF00CAFF00E8FF00FFF900FFDC00FFC2
00FFAD00FF9C00FF9100FF8C00FF8D00FF9400FFA100FFB200FFC700FFDE00FFF500F4FF
00E2FF00D3FF00CBFF00C9FF00CDFF00D6FF00E4FF00F4FF00FFFB00FFEE00FFE700FFE7
00FFED00FFF600FFFE00FFFF00FFFA00FFF900FFFF00F5FF00EEFF00EDFF00F3FF00FFFF
00FFF100FFE100FFD200FFC700FFC200FFC300FFCA00FFD800FFEA00FFFF00E9FF00D2FF
00BDFF00ABFF009DFF0095FF0092FF0096FF00A0FF00B0FF00C5FF00DEFF00FAFF00FFE8
00FFC900FFAB00FF9000FF7700FF6200FF5200FF4800FF4300FF4500FF4C00FF5A00FF6D
00FF8600FFA300FFC300FFE600F4FF00CEFF00A9FF0085FF0063FF0044FF0029FF0012FF
0001FF0A00FF0F00FF0F00FF0900FF0003FF0015FF002DFF004AFF006BFF0091FF00B9FF
00E3FF00FFEF00FFC200FF9600FF6A00FF4000FF180BFF002CFF0048FF005FFF0071FF00
7DFF0083FF0083FF007CFF0070FF005EFF0046FF0029FF0007FF0000FF1F00FF4900FF77
00FFA700FFD900F2FF00BEFF0089FF0056FF0024FF0A00FF
13FF0000FF1B00FF4D00FF8000FFB400FFE800E3FF00B0FF0080FF0051FF0026FF0000FF
2300FF4100FF5A00FF6D00FF7B00FF8200FF8300FF7F00FF7400FF6300FF4D00FF3200FF
1200FF0010FF0037FF0061FF008DFF00B9FF00E6FF00FFEC00FFC100FF9800FF7300FF50
00FF3300FF1A00FF0606FF000EFF000FFF000BFF0000FF0000FF0F00FF2400FF3F00FF5D
00FF7E00FFA200FFC700FFED00EDFF00CAFF00A9FF008BFF0072FF005DFF004EFF0045FF
0043FF0046FF004FFF005EFF0072FF008AFF00A6FF00C3FF00E1FF00FFFF00FFE300FFCA
00FFB400FFA300FF9800FF9300FF9400FF9B00FFA800FFB900FFCE00FFE500FFFC00EDFF
00DAFF00CCFF00C4FF00C2FF00C6FF00CFFF00DDFF00EDFF00FDFF00FFF500FFEE00FFEE
00FFF400FFFD00FAFF00F9FF00FEFF00FFFF00F8FF00EEFF00E7FF00E6FF00ECFF00F8FF
00FFF800FFE800FFD900FFCE00FFC900FFCA00FFD100FFDF00FFF100F9FF00E2FF00CBFF
00B6FF00A4FF0096FF008DFF008BFF008FFF0099FF00A9FF00BEFF00D7FF00F3FF00FFEF
00FFD000FFB200FF9700FF7E00FF6900FF5900FF4F00FF4A00FF4C00FF5300FF6100FF75
00FF8D00FFAA00FFCA00FFED00EDFF00C7FF00A2FF007EFF005CFF003DFF0022FF000BFF
0500FF1100FF1600FF1600FF1000FF0300FF000EFF0026FF0043FF0064FF0089FF00B2FF
00DCFF00FFF600FFC900FF9D00FF7100FF4700FF1F04FF0025FF0041FF0058FF006AFF00
76FF007CFF007CFF0075FF0069FF0057FF003FFF0022FF0000FF0000FF2600FF5000FF7E
00FFAE00FFE100EBFF00B6FF0082FF004FFF001DFF1100FF
09FF0000FF2500FF5600FF8900FFBD00FFF200D9FF00A7FF0076FF0048FF001DFF0A00FF
2D00FF4B00FF6400FF7700FF8400FF8C00FF8D00FF8800FF7D00FF6D00FF5700FF3C00FF
1C00FF0007FF002EFF0057FF0083FF00B0FF00DDFF00FFF600FFCB00FFA200FF7C00FF5A
00FF3C00FF2400FF1000FF0204FF0006FF0001FF0000FF0800FF1900FF2E00FF4800FF66
00FF8800FFAC00FFD100FFF600E3FF00C0FF009FFF0081FF0068FF0053FF0045FF003CFF
0039FF003CFF0046FF0055FF0068FF0081FF009CFF00B9FF00D8FF00F6FF00FFED00FFD3
00FFBE00FFAD00FFA200FF9C00FF9E00FFA500FFB200FFC300FFD800FFEF00F9FF00E3FF
00D1FF00C3FF00BAFF00B8FF00BCFF00C6FF00D4FF00E4FF00F3FF00FFFF00FFF800FFF7
00FFFD00F8FF00F0FF00EFFF00F4FF00F5FF00EEFF00E4FF00DDFF00DCFF00E2FF00EEFF
00FDFF00FFF100FFE300FFD800FFD300FFD400FFDB00FFE800FFFA00EFFF00D8FF00C1FF
00ACFF009AFF008CFF0084FF0081FF0085FF008FFF009FFF00B4FF00CDFF00E9FF00FFF8
00FFDA00FFBC00FFA000FF8800FF7300FF6300FF5800FF5400FF5500FF5D00FF6B00FF7E
00FF9700FFB400FFD400FFF700E3FF00BDFF0098FF0074FF0052FF0033FF0018FF0002FF
0F00FF1A00FF2000FF2000FF1900FF0D00FF0005FF001CFF0039FF005BFF0080FF00A8FF
00D3FF00FFFF00FFD300FFA600FF7A00FF5000FF2900FF041BFF0037FF004EFF0060FF00
6CFF0072FF0072FF006CFF005FFF004DFF0035FF0018FF0000FF0900FF2F00FF5A00FF87
00FFB800FFEA00E1FF00ADFF0079FF0045FF0013FF1B00FF
02FF0000FF2C00FF5D00FF9000FFC400FFF900D3FF00A0FF006FFF0041FF0016FF1100FF
3400FF5200FF6B00FF7E00FF8B00FF9300FF9400FF8F00FF8400FF7400FF5E00FF4300FF
2300FF0000FF0027FF0050FF007CFF00A9FF00D6FF00FFFD00FFD200FFA900FF8300FF61
00FF4300FF2A00FF1700FF0900FF0200FF0000FF0500FF0F00FF2000FF3500FF4F00FF6D
00FF8F00FFB200FFD800FFFD00DCFF00B9FF0098FF007AFF0061FF004DFF003EFF0035FF
0032FF0035FF003FFF004EFF0062FF007AFF0095FF00B2FF00D1FF00EFFF00FFF400FFDA
00FFC400FFB400FFA800FFA300FFA400FFAC00FFB800FFCA00FFDF00FFF500F2FF00DDFF
00CAFF00BCFF00B3FF00B1FF00B5FF00BFFF00CDFF00DDFF00ECFF00F9FF00FFFF00FFFE
00FBFF00F1FF00E9FF00E8FF00EDFF00EEFF00E7FF00DDFF00D6FF00D6FF00DCFF00E7FF
00F7FF00FFF800FFEA00FFDF00FFDA00FFDB00FFE200FFEF00FEFF00E8FF00D1FF00BAFF
00A5FF0093FF0085FF007DFF007AFF007EFF0088FF0098FF00ADFF00C6FF00E2FF00FFFF
00FFE100FFC300FFA700FF8E00FF7A00FF6A00FF5F00FF5B00FF5C00FF6400FF7200FF85
00FF9E00FFBA00FFDB00FFFE00DCFF00B6FF0091FF006DFF004BFF002CFF0011FF0400FF
1600FF2100FF2700FF2700FF2000FF1400FF0100FF0016FF0032FF0054FF0079FF00A1FF
00CCFF00F8FF00FFDA00FFAD00FF8100FF5700FF3000FF0B14FF0030FF0047FF0059FF00
65FF006BFF006BFF0065FF0058FF0046FF002EFF0011FF0000FF1000FF3600FF6100FF8E
00FFBF00FFF100DAFF00A6FF0072FF003EFF000DFF2200FF
02FF0000FF2D00FF5E00FF9100FFC500FFF900D2FF009FFF006EFF0040FF0015FF1200FF
3500FF5300FF6C00FF7F00FF8C00FF9400FF9500FF9000FF8500FF7500FF5F00FF4400FF
2400FF0000FF0026FF0050FF007BFF00A8FF00D5FF00FFFE00FFD300FFAA00FF8400FF62
00FF4400FF2B00FF1800FF0A00FF0300FF0100FF0600FF1000FF2000FF3600FF5000FF6E
00FF9000FFB300FFD900FFFE00DCFF00B8FF0097FF0079FF0060FF004CFF003DFF0034FF
0031FF0034FF003EFF004DFF0061FF0079FF0094FF00B1FF00D0FF00EEFF00FFF500FFDB
00FFC500FFB400FFA900FFA400FFA500FFAD00FFB900FFCB00FFE000FFF600F2FF00DCFF
00C9FF00BBFF00B2FF00B0FF00B4FF00BEFF00CCFF00DCFF00ECFF00F8FF00FFFF00FFFF
00FAFF00F0FF00E8FF00E8FF00ECFF00EDFF00E6FF00DCFF00D6FF00D5FF00DBFF00E6FF
00F6FF00FFF900FFEB00FFE000FFDB00FFDC00FFE300FFF000FDFF00E8FF00D1FF00BAFF
00A4FF0092FF0084FF007CFF007AFF007EFF0088FF0097FF00ACFF00C5FF00E1FF00FFFF
00FFE200FFC400FFA800FF8F00FF7B00FF6B00FF6000FF5C00FF5D00FF6500FF7300FF86
00FF9E00FFBB00FFDC00FFFF00DBFF00B6FF0090FF006CFF004AFF002BFF0010FF0500FF
1600FF2200FF2800FF2800FF2100FF1500FF0200FF0015FF0031FF0053FF0078FF00A0FF
00CBFF00F7FF00FFDB00FFAE00FF8200FF5800FF3100FF0C13FF002FFF0046FF0058FF00
64FF006AFF006AFF0064FF0058FF0045FF002EFF0010FF0000FF1100FF3700FF6200FF8F
00FFC000FFF200D9FF00A5FF0071FF003EFF000CFF2300FF
07FF0000FF2700FF5800FF8B00FFBF00FFF400D8FF00A5FF0074FF0046FF001BFF0C00FF
2F00FF4D00FF6600FF7900FF8600FF8E00FF8F00FF8A00FF7F00FF6F00FF5900FF3E00FF
1E00FF0005FF002CFF0056FF0081FF00AEFF00DBFF00FFF800FFCD00FFA400FF7E00FF5C
00FF3E00FF2500FF1200FF0402FF0004FF0000FF0000FF0A00FF1A00FF3000FF4A00FF68
00FF8A00FFAD00FFD300FFF800E2FF00BEFF009DFF007FFF0066FF0052FF0043FF003AFF
0037FF003AFF0044FF0053FF0067FF007FFF009AFF00B7FF00D6FF00F4FF00FFEF00FFD5
00FFBF00FFAF00FFA300FF9E00FF9F00FFA700FFB300FFC500FFDA00FFF000F7FF00E2FF
00CFFF00C1FF00B8FF00B6FF00BAFF00C4FF00D2FF00E2FF00F1FF00FEFF00FFFA00FFF9
00FFFF00F6FF00EEFF00EEFF00F2FF00F3FF00ECFF00E2FF00DCFF00DBFF00E1FF00ECFF
00FCFF00FFF300FFE500FFDA00FFD500FFD600FFDD00FFEA00FFFC00EEFF00D6FF00BFFF
00AAFF0098FF008AFF0082FF0080FF0083FF008DFF009DFF00B2FF00CBFF00E7FF00FFFA
00FFDC00FFBE00FFA200FF8900FF7500FF6500FF5A00FF5600FF5700FF5F00FF6D00FF80
00FF9900FFB500FFD600FFF900E1FF00BCFF0096FF0072FF0050FF0031FF0016FF0000FF
1000FF1C00FF2200FF2200FF1B00FF0F00FF0003FF001BFF0037FF0059FF007EFF00A6FF
00D1FF00FDFF00FFD500FFA800FF7C00FF5200FF2B00FF0619FF0035FF004CFF005EFF00
6AFF0070FF0070FF006AFF005EFF004BFF0034FF0016FF0000FF0B00FF3100FF5C00FF89
00FFBA00FFEC00DFFF00ABFF0077FF0043FF0012FF1D00FF
13FF0000FF1B00FF4C00FF7F00FFB400FFE800E3FF00B1FF0080FF0052FF0026FF0000FF
2300FF4100FF5A00FF6D00FF7B00FF8200FF8300FF7E00FF7400FF6300FF4D00FF3200FF
1200FF0010FF0038FF0061FF008DFF00BAFF00E6FF00FFEC00FFC100FF9800FF7200FF50
00FF3300FF1A00FF0606FF000EFF0010FF000BFF0000FF0000FF0F00FF2400FF3E00FF5D
00FF7E00FFA200FFC700FFED00EDFF00CAFF00A9FF008BFF0072FF005DFF004EFF0046FF
0043FF0046FF004FFF005EFF0072FF008AFF00A6FF00C3FF00E2FF00FFFF00FFE300FFC9
00FFB400FFA300FF9800FF9300FF9400FF9B00FFA800FFB900FFCE00FFE500FFFC00EDFF
00DBFF00CCFF00C4FF00C2FF00C6FF00CFFF00DDFF00EEFF00FDFF00FFF500FFEE00FFEE
00FFF300FFFD00FAFF00F9FF00FEFF00FFFF00F8FF00EEFF00E7FF00E6FF00ECFF00F8FF
00FFF800FFE700FFD900FFCE00FFC900FFCA00FFD100FFDF00FFF000F9FF00E2FF00CBFF
00B6FF00A4FF0096FF008EFF008BFF008FFF0099FF00A9FF00BEFF00D7FF00F3FF00FFEE
00FFD000FFB200FF9700FF7E00FF6900FF5900FF4F00FF4A00FF4C00FF5300FF6100FF74
00FF8D00FFAA00FFCA00FFED00EDFF00C7FF00A2FF007EFF005CFF003DFF0022FF000CFF
0500FF1000FF1600FF1600FF0F00FF0300FF000EFF0026FF0043FF0064FF008AFF00B2FF
00DDFF00FFF600FFC900FF9C00FF7100FF4600FF1F05FF0025FF0041FF0058FF006AFF00
76FF007CFF007CFF0075FF0069FF0057FF003FFF0022FF0000FF0000FF2500FF5000FF7E
00FFAE00FFE000EBFF00B7FF0082FF004FFF001DFF1100FF
22FF0000FF0C00FF3D00FF7000FFA400FFD900F3FF00C0FF008FFF0061FF0036FF000EFF
1400FF3200FF4B00FF5E00FF6B00FF7300FF7400FF6F00FF6400FF5400FF3E00FF2300FF
0300FF0020FF0047FF0071FF009CFF00C9FF00F6FF00FFDD00FFB200FF8900FF6300FF41
00FF2300FF0A08FF0016FF001DFF001FFF001AFF0010FF0000FF0000FF1500FF2F00FF4D
00FF6F00FF9200FFB800FFDD00FDFF00D9FF00B8FF009AFF0081FF006DFF005EFF0055FF
0052FF0055FF005FFF006EFF0082FF009AFF00B5FF00D2FF00F1FF00FFF000FFD400FFBA
00FFA400FF9400FF8800FF8300FF8400FF8C00FF9800FFAA00FFBF00FFD500FFED00FDFF
00EAFF00DCFF00D3FF00D1FF00D5FF00DFFF00EDFF00FDFF00FFF300FFE600FFDF00FFDE
00FFE400FFEE00FFF600FFF700FFF200FFF100FFF800FDFF00F7FF00F6FF00FCFF00FFF8
00FFE800FFD800FFCA00FFBF00FFBA00FFBB00FFC200FFCF00FFE100FFF600F1FF00DAFF
00C5FF00B3FF00A5FF009DFF009BFF009EFF00A8FF00B8FF00CDFF00E6FF00FFFD00FFDF
00FFC100FFA300FF8700FF6E00FF5A00FF4A00FF3F00FF3B00FF3C00FF4400FF5200FF65
00FF7E00FF9A00FFBB00FFDE00FCFF00D7FF00B1FF008DFF006BFF004CFF0031FF001BFF
000AFF0100FF0700FF0700FF0000FF000BFF001EFF0036FF0052FF0074FF0099FF00C1FF
00ECFF00FFE700FFBA00FF8D00FF6100FF3700FF1014FF0034FF0050FF0067FF0079FF00
85FF008BFF008BFF0085FF0078FF0066FF004FFF0031FF000FFF0000FF1600FF4100FF6E
00FF9F00FFD100FAFF00C6FF0092FF005EFF002DFF0200FF
33FF0004FF0000FF2D00FF6000FF9400FFC800FFFC00D0FF009FFF0071FF0046FF001FFF
0300FF2200FF3A00FF4E00FF5B00FF6200FF6400FF5F00FF5400FF4400FF2D00FF1200FF
000CFF0030FF0057FF0081FF00ACFF00D9FF00FFF900FFCD00FFA200FF7900FF5300FF31
00FF1305FF0018FF0026FF002EFF002FFF002BFF0020FF0010FF0000FF0500FF1F00FF3D
00FF5E00FF8200FFA700FFCD00FFF200E9FF00C8FF00ABFF0091FF007DFF006EFF0065FF
0062FF0066FF006FFF007EFF0092FF00AAFF00C5FF00E3FF00FFFE00FFE000FFC300FFAA
00FF9400FF8300FF7800FF7300FF7400FF7B00FF8800FF9A00FFAE00FFC500FFDC00FFF2
00FAFF00ECFF00E3FF00E1FF00E5FF00EFFF00FDFF00FFF200FFE200FFD600FFCF00FFCE
00FFD400FFDE00FFE600FFE600FFE200FFE100FFE800FFF100FFF800FFF900FFF300FFE7
00FFD800FFC800FFB900FFAF00FFAA00FFAA00FFB200FFBF00FFD100FFE600FFFD00EBFF
00D5FF00C3FF00B5FF00ADFF00ABFF00AFFF00B9FF00C8FF00DDFF00F6FF00FFED00FFCF
00FFB100FF9300FF7700FF5E00FF4900FF3900FF2F00FF2A00FF2C00FF3400FF4200FF55
00FF6D00FF8A00FFAB00FFCE00FFF300E7FF00C1FF009DFF007BFF005CFF0041FF002BFF
001AFF000EFF0008FF0009FF000FFF001CFF002EFF0046FF0063FF0084FF00A9FF00D1FF
00FCFF00FFD700FFAA00FF7D00FF5100FF2700FF0024FF0045FF0061FF0078FF0089FF00
95FF009BFF009BFF0095FF0089FF0077FF005FFF0042FF0020FF0000FF0600FF3000FF5E
00FF8E00FFC100FFF500D6FF00A2FF006FFF003DFF000DFF
41FF0012FF0000FF1E00FF5100FF8500FFBA00FFEE00DFFF00AEFF0080FF0054FF002DFF
000AFF1300FF2C00FF3F00FF4D00FF5400FF5500FF5000FF4600FF3500FF1F00FF0400FF
001BFF003FFF0066FF008FFF00BBFF00E8FF00FFEA00FFBE00FF9300FF6A00FF4400FF22
00FF0513FF0027FF0034FF003CFF003EFF0039FF002FFF001EFF0009FF0000FF1000FF2E
00FF5000FF7400FF9900FFBF00FFE400F8FF00D7FF00B9FF00A0FF008BFF007DFF0074FF
0071FF0074FF007EFF008CFF00A0FF00B8FF00D4FF00F1FF00FFEF00FFD100FFB500FF9B
00FF8600FF7500FF6A00FF6500FF6600FF6D00FF7A00FF8B00FFA000FFB700FFCE00FFE4
00FFF600FAFF00F2FF00F0FF00F4FF00FEFF00FFF400FFE300FFD400FFC700FFC000FFC0
00FFC500FFCF00FFD700FFD800FFD300FFD200FFD900FFE300FFEA00FFEB00FFE500FFD9
00FFCA00FFB900FFAB00FFA000FF9B00FF9C00FFA300FFB000FFC200FFD800FFEF00F9FF
00E4FF00D2FF00C4FF00BCFF00B9FF00BDFF00C7FF00D7FF00ECFF00FFFA00FFDE00FFC0
00FFA200FF8400FF6800FF5000FF3B00FF2B00FF2000FF1C00FF1E00FF2500FF3300FF46
00FF5F00FF7C00FF9C00FFBF00FFE400F5FF00D0FF00ACFF008AFF006BFF0050FF003AFF
0028FF001DFF0017FF0017FF001EFF002AFF003CFF0054FF0071FF0093FF00B8FF00E0FF
00FFF400FFC800FF9B00FF6E00FF4300FF180EFF0033FF0053FF006FFF0086FF0098FF00
A4FF00AAFF00AAFF00A4FF0097FF0085FF006DFF0050FF002EFF0008FF0000FF2200FF50
00FF8000FFB200FFE600E5FF00B1FF007DFF004BFF001CFF
4CFF001DFF0000FF1400FF4700FF7B00FFAF00FFE300E9FF00B9FF008AFF005FFF0038FF
0015FF0800FF2100FF3400FF4200FF4900FF4B00FF4600FF3B00FF2A00FF1400FF0006FF
0026FF0049FF0070FF009AFF00C6FF00F2FF00FFE000FFB300FF8800FF6000FF3A00FF18
05FF001EFF0031FF003FFF0047FF0048FF0044FF0039FF0029FF0014FF0000FF0600FF24
00FF4500FF6900FF8E00FFB400FFD900FFFD00E1FF00C4FF00AAFF0096FF0087FF007EFF
007BFF007FFF0088FF0097FF00ABFF00C3FF00DEFF00FCFF00FFE500FFC700FFAA00FF91
00FF7B00FF6A00FF5F00FF5A00FF5B00FF6200FF6F00FF8000FF9500FFAC00FFC300FFD9
00FFEC00FFFA00FDFF00FAFF00FEFF00FFF700FFE900FFD900FFC900FFBC00FFB500FFB5
00FFBB00FFC400FFCC00FFCD00FFC800FFC700FFCE00FFD800FFDF00FFE000FFDA00FFCE
00FFBF00FFAF00FFA000FF9600FF9000FF9100FF9900FFA600FFB800FFCD00FFE400FFFB
00EFFF00DCFF00CFFF00C6FF00C4FF00C8FF00D2FF00E2FF00F6FF00FFF000FFD400FFB6
00FF9700FF7A00FF5E00FF4500FF3000FF2000FF1600FF1100FF1300FF1B00FF2800FF3C
00FF5400FF7100FF9100FFB500FFD900FFFF00DBFF00B6FF0094FF0076FF005BFF0044FF
0033FF0027FF0022FF0022FF0028FF0035FF0047FF005FFF007CFF009DFF00C2FF00EBFF
00FFEA00FFBE00FF9100FF6400FF3800FF0E19FF003DFF005EFF007AFF0091FF00A3FF00
AEFF00B4FF00B4FF00AEFF00A2FF0090FF0078FF005BFF0039FF0012FF0000FF1700FF45
00FF7500FFA800FFDB00EFFF00BBFF0088FF0056FF0026FF
51FF0022FF0000FF0E00FF4100FF7600FFAA00FFDE00EFFF00BEFF008FFF0064FF003DFF
001AFF0300FF1C00FF2F00FF3D00FF4400FF4500FF4000FF3600FF2500FF0F00FF000BFF
002BFF004EFF0076FF009FFF00CBFF00F8FF00FFDB00FFAE00FF8300FF5A00FF3400FF12
0AFF0023FF0037FF0044FF004CFF004EFF0049FF003EFF002EFF0019FF0000FF0000FF1F
00FF4000FF6400FF8900FFAF00FFD400FFF700E7FF00C9FF00B0FF009BFF008CFF0084FF
0081FF0084FF008DFF009CFF00B0FF00C8FF00E4FF00FFFE00FFDF00FFC100FFA500FF8B
00FF7600FF6500FF5A00FF5500FF5600FF5D00FF6A00FF7B00FF9000FFA700FFBE00FFD4
00FFE600FFF500FFFD00FFFF00FFFB00FFF200FFE400FFD300FFC400FFB700FFB000FFB0
00FFB500FFBF00FFC700FFC800FFC300FFC200FFC900FFD300FFDA00FFDB00FFD500FFC9
00FFBA00FFAA00FF9B00FF9000FF8B00FF8C00FF9300FFA100FFB200FFC800FFDF00FFF6
00F4FF00E2FF00D4FF00CCFF00C9FF00CDFF00D7FF00E7FF00FCFF00FFEA00FFCE00FFB0
00FF9200FF7400FF5900FF4000FF2B00FF1B00FF1100FF0C00FF0E00FF1500FF2300FF36
00FF4F00FF6C00FF8C00FFAF00FFD400FFFA00E0FF00BCFF009AFF007BFF0060FF0049FF
0038FF002DFF0027FF0027FF002EFF003AFF004CFF0064FF0081FF00A2FF00C8FF00F0FF
00FFE400FFB800FF8B00FF5F00FF3300FF081EFF0043FF0063FF007FFF0096FF00A8FF00
B4FF00BAFF00BAFF00B3FF00A7FF0095FF007DFF0060FF003EFF0018FF0000FF1200FF40
00FF7000FFA200FFD600F5FF00C0FF008DFF005BFF002CFF
50FF0021FF0000FF0F00FF4200FF7600FFAB00FFDF00EEFF00BDFF008FFF0063FF003CFF
0019FF0400FF1D00FF3000FF3E00FF4500FF4600FF4100FF3700FF2600FF1000FF000AFF
002AFF004DFF0075FF009EFF00CAFF00F7FF00FFDB00FFAF00FF8400FF5B00FF3500FF13
09FF0022FF0036FF0043FF004BFF004DFF0048FF003DFF002DFF0018FF0000FF0100FF20
00FF4100FF6500FF8A00FFB000FFD500FFF800E6FF00C8FF00AFFF009AFF008BFF0083FF
0080FF0083FF008CFF009BFF00AFFF00C7FF00E3FF00FFFF00FFE000FFC200FFA600FF8C
00FF7700FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7C00FF9100FFA800FFBF00FFD5
00FFE700FFF600FFFE00FFFF00FFFC00FFF300FFE500FFD400FFC500FFB800FFB100FFB1
00FFB600FFC000FFC800FFC900FFC400FFC300FFCA00FFD400FFDB00FFDC00FFD600FFCA
00FFBB00FFAA00FF9C00FF9100FF8C00FF8D00FF9400FFA200FFB300FFC900FFE000FFF7
00F3FF00E1FF00D3FF00CBFF00C8FF00CCFF00D6FF00E6FF00FBFF00FFEB00FFCF00FFB1
00FF9300FF7500FF5A00FF4100FF2C00FF1C00FF1200FF0D00FF0F00FF1600FF2400FF37
00FF5000FF6D00FF8D00FFB000FFD500FFFB00DFFF00BBFF0099FF007AFF005FFF0049FF
0037FF002CFF0026FF0026FF002DFF0039FF004BFF0063FF0080FF00A1FF00C7FF00EFFF
00FFE500FFB900FF8C00FF5F00FF3400FF091DFF0042FF0062FF007EFF0095FF00A7FF00
B3FF00B9FF00B9FF00B2FF00A6FF0094FF007CFF005FFF003DFF0017FF0000FF1300FF41
00FF7100FFA300FFD700F4FF00BFFF008CFF005AFF002BFF
49FF001AFF0000FF1700FF4A00FF7E00FFB200FFE600E6FF00B5FF0087FF005CFF0035FF
0012FF0B00FF2400FF3800FF4500FF4C00FF4E00FF4900FF3E00FF2D00FF1700FF0003FF
0022FF0046FF006DFF0097FF00C2FF00EFFF00FFE300FFB600FF8B00FF6300FF3D00FF1B
02FF001BFF002EFF003CFF0044FF0045FF0041FF0036FF0026FF0010FF0000FF0900FF27
00FF4800FF6C00FF9100FFB700FFDC00FFFF00DEFF00C1FF00A7FF0093FF0084FF007BFF
0078FF007CFF0085FF0094FF00A8FF00C0FF00DBFF00F9FF00FFE800FFCA00FFAD00FF94
00FF7E00FF6D00FF6200FF5D00FF5E00FF6500FF7200FF8300FF9800FFAF00FFC600FFDC
00FFEF00FFFD00FAFF00F7FF00FBFF00FFFA00FFEC00FFDC00FFCC00FFC000FFB800FFB8
00FFBE00FFC700FFCF00FFD000FFCB00FFCA00FFD100FFDB00FFE200FFE300FFDD00FFD1
00FFC200FFB200FFA300FF9900FF9300FF9400FF9C00FFA900FFBB00FFD000FFE700FFFE
00ECFF00D9FF00CCFF00C3FF00C1FF00C5FF00CFFF00DFFF00F3FF00FFF300FFD700FFB9
00FF9A00FF7D00FF6100FF4800FF3300FF2300FF1900FF1400FF1600FF1E00FF2B00FF3F
00FF5700FF7400FF9400FFB800FFDC00FDFF00D8FF00B3FF0091FF0073FF0058FF0041FF
0030FF0024FF001EFF001FFF0025FF0032FF0044FF005CFF0079FF009AFF00BFFF00E8FF
00FFED00FFC100FF9400FF6700FF3B00FF1116FF003AFF005BFF0077FF008EFF009FFF00
ABFF00B1FF00B1FF00ABFF009FFF008DFF0075FF0058FF0036FF000FFF0000FF1A00FF48
00FF7800FFAB00FFDE00ECFF00B8FF0085FF0053FF0023FF
3CFF000DFF0000FF2400FF5700FF8B00FFBF00FFF300D9FF00A8FF007AFF004FFF0028FF
0005FF1900FF3100FF4500FF5200FF5900FF5B00FF5600FF4B00FF3B00FF2500FF0900FF
0015FF0039FF0060FF008AFF00B5FF00E2FF00FFF000FFC400FF9900FF7000FF4A00FF28
00FF0A0EFF0021FF002FFF0037FF0038FF0033FF0029FF0019FF0003FF0000FF1600FF34
00FF5500FF7900FF9E00FFC400FFE900F2FF00D1FF00B4FF009AFF0086FF0077FF006EFF
006BFF006FFF0078FF0087FF009BFF00B3FF00CEFF00ECFF00FFF500FFD700FFBB00FFA1
00FF8B00FF7A00FF6F00FF6A00FF6B00FF7200FF7F00FF9100FFA500FFBC00FFD300FFE9
00FFFC00F5FF00ECFF00EAFF00EEFF00F8FF00FFF900FFE900FFD900FFCD00FFC600FFC5
00FFCB00FFD500FFDD00FFDD00FFD900FFD800FFDF00FFE800FFEF00FFF000FFEA00FFDF
00FFCF00FFBF00FFB000FFA600FFA100FFA200FFA900FFB600FFC800FFDD00FFF400F4FF
00DEFF00CCFF00BEFF00B6FF00B4FF00B8FF00C2FF00D1FF00E6FF00FFFF00FFE400FFC6
00FFA800FF8A00FF6E00FF5500FF4000FF3100FF2600FF2100FF2300FF2B00FF3900FF4C
00FF6400FF8100FFA200FFC500FFEA00F0FF00CAFF00A6FF0084FF0065FF004AFF0034FF
0023FF0017FF0011FF0012FF0018FF0025FF0037FF004FFF006CFF008DFF00B2FF00DAFF
00FFFA00FFCE00FFA100FF7400FF4800FF1E09FF002DFF004EFF006AFF0081FF0092FF00
9EFF00A4FF00A4FF009EFF0092FF0080FF0068FF004BFF0029FF0002FF0000FF2700FF55
00FF8600FFB800FFEC00DFFF00ABFF0078FF0046FF0016FF
2AFF0000FF0400FF3600FF6900FF9D00FFD100FAFF00C7FF0096FF0068FF003DFF0016FF
0C00FF2A00FF4300FF5700FF6400FF6B00FF6D00FF6800FF5D00FF4D00FF3600FF1B00FF
0003FF0027FF004EFF0078FF00A3FF00D0FF00FDFF00FFD600FFAB00FF8200FF5C00FF3A
00FF1C00FF030FFF001DFF0025FF0026FF0022FF0017FF0007FF0000FF0E00FF2800FF46
00FF6700FF8B00FFB000FFD600FFFB00E0FF00BFFF00A2FF0088FF0074FF0065FF005CFF
0059FF005DFF0066FF0075FF0089FF00A1FF00BCFF00DAFF00F8FF00FFE900FFCC00FFB3
00FF9D00FF8C00FF8100FF7C00FF7D00FF8400FF9100FFA300FFB700FFCE00FFE500FFFB
00F1FF00E3FF00DAFF00D8FF00DCFF00E6FF00F4FF00FFFB00FFEB00FFDF00FFD700FFD7
00FFDD00FFE600FFEF00FFEF00FFEB00FFEA00FFF100FFFA00FEFF00FDFF00FFFC00FFF0
00FFE100FFD100FFC200FFB800FFB200FFB300FFBB00FFC800FFDA00FFEF00F9FF00E2FF
00CCFF00BAFF00ACFF00A4FF00A2FF00A6FF00B0FF00BFFF00D4FF00EDFF00FFF600FFD8
00FFBA00FF9C00FF8000FF6700FF5200FF4200FF3800FF3300FF3500FF3D00FF4A00FF5E
00FF7600FF9300FFB400FFD700FFFC00DEFF00B8FF0094FF0072FF0053FF0038FF0022FF
0011FF0005FF0000FF0000FF0006FF0013FF0025FF003DFF005AFF007BFF00A0FF00C8FF
00F3FF00FFE000FFB300FF8600FF5A00FF3000FF081BFF003CFF0058FF006FFF0080FF00
8CFF0092FF0092FF008CFF0080FF006EFF0056FF0039FF0017FF0000FF0F00FF3900FF67
00FF9700FFCA00FFFE00CDFF0099FF0066FF0034FF0004FF
14FF0000FF1A00FF4B00FF7E00FFB200FFE700E5FF00B2FF0081FF0053FF0028FF0000FF
2200FF4000FF5900FF6C00FF7900FF8100FF8200FF7D00FF7200FF6200FF4C00FF3100FF
1100FF0012FF0039FF0062FF008EFF00BBFF00E8FF00FFEB00FFC000FF9700FF7100FF4F
00FF3100FF1800FF0508FF000FFF0011FF000CFF0002FF0000FF0E00FF2300FF3D00FF5B
00FF7D00FFA100FFC600FFEB00EEFF00CBFF00AAFF008CFF0073FF005FFF0050FF0047FF
0044FF0047FF0051FF0060FF0074FF008CFF00A7FF00C4FF00E3FF00FFFE00FFE200FFC8
00FFB200FFA200FF9600FF9100FF9200FF9A00FFA600FFB800FFCD00FFE300FFFB00EFFF
00DCFF00CEFF00C5FF00C3FF00C7FF00D1FF00DFFF00EFFF00FEFF00FFF400FFED00FFEC
00FFF200FFFC00FBFF00FAFF00FFFF00FFFF00F9FF00EFFF00E8FF00E8FF00EEFF00F9FF
00FFF600FFE600FFD800FFCD00FFC800FFC900FFD000FFDD00FFEF00FAFF00E3FF00CCFF
00B7FF00A5FF0097FF008FFF008CFF0090FF009AFF00AAFF00BFFF00D8FF00F4FF00FFED
00FFCF00FFB100FF9500FF7D00FF6800FF5800FF4D00FF4900FF4A00FF5200FF6000FF73
00FF8C00FFA800FFC900FFEC00EEFF00C8FF00A3FF007FFF005DFF003EFF0023FF000DFF
0400FF0F00FF1500FF1500FF0E00FF0200FF0010FF0027FF0044FF0066FF008BFF00B3FF
00DEFF00FFF500FFC800FF9B00FF6F00FF4500FF1E06FF0026FF0042FF0059FF006BFF00
77FF007DFF007DFF0077FF006AFF0058FF0040FF0023FF0001FF0000FF2400FF4F00FF7C
00FFAD00FFDF00ECFF00B8FF0084FF0050FF001FFF1000FF
00FF0200FF3100FF6200FF9500FFC900FFFE00CEFF009BFF006AFF003CFF0011FF1600FF
3900FF5700FF7000FF8300FF9000FF9800FF9900FF9400FF8900FF7900FF6300FF4800FF
2800FF0400FF0022FF004BFF0077FF00A4FF00D1FF00FDFF00FFD700FFAE00FF8800FF66
00FF4800FF3000FF1C00FF0E00FF0700FF0500FF0A00FF1400FF2500FF3A00FF5400FF72
00FF9400FFB800FFDD00FDFF00D7FF00B4FF0093FF0075FF005CFF0048FF0039FF0030FF
002DFF0030FF003AFF0049FF005CFF0075FF0090FF00ADFF00CCFF00EAFF00FFF900FFDF
00FFC900FFB900FFAD00FFA800FFAA00FFB100FFBD00FFCF00FFE400FFFB00EDFF00D8FF
00C5FF00B7FF00AEFF00ACFF00B0FF00BAFF00C8FF00D8FF00E7FF00F4FF00FBFF00FCFF
00F6FF00ECFF00E4FF00E3FF00E8FF00E9FF00E2FF00D8FF00D1FF00D1FF00D6FF00E2FF
00F1FF00FFFD00FFEF00FFE400FFDF00FFE000FFE700FFF400F9FF00E3FF00CCFF00B5FF
00A0FF008EFF0080FF0078FF0075FF0079FF0083FF0093FF00A8FF00C1FF00DDFF00FBFF
00FFE600FFC800FFAC00FF9400FF7F00FF6F00FF6400FF6000FF6100FF6900FF7700FF8A
00FFA300FFBF00FFE000FCFF00D7FF00B1FF008CFF0068FF0046FF0027FF000CFF0900FF
1B00FF2600FF2C00FF2C00FF2500FF1900FF0600FF0010FF002DFF004FFF0074FF009CFF
00C7FF00F3FF00FFDF00FFB200FF8600FF5C00FF3500FF100FFF002BFF0042FF0054FF00
60FF0066FF0066FF0060FF0053FF0041FF0029FF000CFF0000FF1500FF3B00FF6600FF93
00FFC400FFF600D5FF00A1FF006DFF0039FF0008FF2700FF
00FF1900FF4800FF7900FFAC00FFE000EAFF00B6FF0084FF0053FF0025FF0500FF2D00FF
5000FF6E00FF8700FF9A00FFA700FFAF00FFB000FFAB00FFA000FF9000FF7A00FF5F00FF
3F00FF1B00FF000BFF0034FF0060FF008DFF00BAFF00E6FF00FFEE00FFC500FF9F00FF7D
00FF5F00FF4700FF3300FF2500FF1E00FF1C00FF2100FF2B00FF3C00FF5100FF6B00FF89
00FFAB00FFCF00FFF400E6FF00C0FF009DFF007CFF005EFF0045FF0031FF0022FF0019FF
0016FF0019FF0023FF0032FF0045FF005EFF0079FF0096FF00B5FF00D3FF00EFFF00FFF6
00FFE000FFD000FFC400FFBF00FFC100FFC800FFD400FFE600FFFB00EDFF00D6FF00C1FF
00AEFF00A0FF0097FF0095FF0099FF00A3FF00B1FF00C1FF00D0FF00DDFF00E4FF00E5FF
00DFFF00D5FF00CDFF00CCFF00D1FF00D2FF00CBFF00C1FF00BAFF00BAFF00BFFF00CBFF
00DAFF00EBFF00F9FF00FFFB00FFF600FFF700FFFE00F4FF00E2FF00CCFF00B5FF009EFF
0089FF0077FF0069FF0061FF005EFF0062FF006CFF007CFF0091FF00AAFF00C6FF00E4FF
00FFFD00FFDF00FFC300FFAB00FF9600FF8600FF7B00FF7700FF7800FF8000FF8E00FFA1
00FFBA00FFD600FFF700E5FF00C0FF009AFF0075FF0051FF002FFF0010FF0A00FF2000FF
3200FF3D00FF4300FF4300FF3C00FF3000FF1D00FF0600FF0016FF0038FF005DFF0085FF
00B0FF00DCFF00FFF600FFC900FF9D00FF7300FF4C00FF2700FF0714FF002BFF003DFF00
49FF004FFF004FFF0049FF003CFF002AFF0012FF0000FF0A00FF2C00FF5200FF7D00FFAA
00FFDB00F2FF00BEFF008AFF0056FF0022FF0E00FF3E00FF
00FF2E00FF5D00FF8F00FFC200FFF600D5FF00A1FF006EFF003EFF000FFF1B00FF4200FF
6500FF8300FF9C00FFAF00FFBD00FFC400FFC500FFC100FFB600FFA500FF8F00FF7400FF
5400FF3100FF0A00FF001FFF004BFF0077FF00A4FF00D1FF00FCFF00FFDA00FFB500FF92
00FF7500FF5C00FF4800FF3B00FF3300FF3200FF3600FF4100FF5100FF6600FF8100FF9F
00FFC000FFE400F6FF00D0FF00ABFF0088FF0066FF0049FF0030FF001BFF000CFF0003FF
0001FF0004FF000DFF001CFF0030FF0048FF0064FF0081FF009FFF00BDFF00DAFF00F3FF
00FFF600FFE500FFDA00FFD500FFD600FFDD00FFEA00FFFB00EFFF00D8FF00C1FF00ABFF
0098FF008AFF0082FF007FFF0084FF008DFF009BFF00ABFF00BBFF00C8FF00CFFF00CFFF
00C9FF00C0FF00B8FF00B7FF00BCFF00BDFF00B6FF00ACFF00A5FF00A4FF00AAFF00B6FF
00C5FF00D5FF00E4FF00EFFF00F4FF00F3FF00ECFF00DEFF00CCFF00B7FF00A0FF0089FF
0074FF0062FF0054FF004BFF0049FF004DFF0057FF0067FF007CFF0095FF00B1FF00CEFF
00EDFF00FFF400FFD900FFC000FFAB00FF9B00FF9100FF8C00FF8E00FF9500FFA300FFB7
00FFCF00FFEC00F3FF00D0FF00ABFF0085FF0060FF003CFF001AFF0400FF1F00FF3600FF
4700FF5300FF5800FF5800FF5200FF4500FF3300FF1B00FF0001FF0022FF0047FF0070FF
009AFF00C7FF00F4FF00FFDF00FFB300FF8900FF6100FF3D00FF1C00FF0016FF0028FF00
34FF003AFF003AFF0033FF0027FF0015FF0000FF0200FF1F00FF4100FF6800FF9200FFC0
00FFF000DCFF00A9FF0074FF0040FF000DFF2400FF5300FF
00FF4000FF6F00FFA100FFD400F7FF00C3FF008FFF005CFF002BFF0200FF2D00FF5400FF
7700FF9500FFAE00FFC100FFCF00FFD600FFD800FFD300FFC800FFB700FFA100FF8600FF
6700FF4300FF1C00FF000DFF0039FF0065FF0092FF00BFFF00EAFF00FFED00FFC700FFA5
00FF8700FF6E00FF5B00FF4D00FF4500FF4400FF4800FF5300FF6300FF7900FF9300FFB1
00FFD200FFF600E4FF00BEFF0099FF0075FF0054FF0037FF001DFF0009FF0500FF0E00FF
1100FF0D00FF0400FF000AFF001EFF0036FF0051FF006FFF008DFF00ABFF00C8FF00E1FF
00F7FF00FFF700FFEC00FFE700FFE800FFEF00FFFC00F2FF00DDFF00C6FF00AFFF0099FF
0086FF0078FF0070FF006DFF0071FF007BFF0089FF0099FF00A9FF00B5FF00BDFF00BDFF
00B7FF00AEFF00A6FF00A5FF00AAFF00ABFF00A4FF009AFF0093FF0092FF0098FF00A4FF
00B3FF00C3FF00D2FF00DCFF00E2FF00E1FF00D9FF00CCFF00BAFF00A5FF008EFF0077FF
0062FF004FFF0042FF0039FF0037FF003BFF0045FF0055FF0069FF0082FF009EFF00BCFF
00DBFF00F8FF00FFEB00FFD200FFBD00FFAD00FFA300FF9E00FFA000FFA800FFB500FFC9
00FFE100FFFE00E1FF00BDFF0099FF0073FF004EFF0029FF0007FF1600FF3100FF4800FF
5900FF6500FF6B00FF6A00FF6400FF5700FF4500FF2D00FF1000FF0010FF0035FF005EFF
0088FF00B4FF00E1FF00FFF100FFC500FF9B00FF7300FF4F00FF2E00FF1204FF0015FF00
21FF0027FF0027FF0021FF0015FF0003FF0000FF1400FF3100FF5300FF7A00FFA400FFD2
00FDFF00CAFF0097FF0062FF002EFF0400FF3600FF6600FF
00FF4E00FF7D00FFAE00FFE100E9FF00B5FF0081FF004FFF001EFF1000FF3B00FF6200FF
8500FFA300FFBC00FFCF00FFDD00FFE400FFE500FFE000FFD600FFC500FFAF00FF9400FF
7400FF5100FF2A00FF0000FF002BFF0057FF0084FF00B1FF00DCFF00FFFA00FFD400FFB2
00FF9500FF7C00FF6800FF5B00FF5300FF5100FF5600FF6100FF7100FF8600FFA000FFBF
00FFE000FBFF00D6FF00B0FF008BFF0068FF0047FF0029FF0010FF0400FF1300FF1B00FF
1E00FF1B00FF1200FF0300FF0010FF0028FF0044FF0061FF007FFF009EFF00BAFF00D4FF
00E9FF00FAFF00FFFA00FFF500FFF600FFFD00F5FF00E4FF00CFFF00B8FF00A1FF008BFF
0079FF006AFF0062FF0060FF0064FF006DFF007BFF008BFF009BFF00A8FF00AFFF00AFFF
00A9FF00A0FF0098FF0097FF009CFF009DFF0096FF008CFF0085FF0084FF008AFF0096FF
00A5FF00B5FF00C4FF00CFFF00D4FF00D3FF00CCFF00BEFF00ACFF0097FF0080FF0069FF
0054FF0042FF0034FF002CFF0029FF002DFF0037FF0047FF005CFF0075FF0091FF00AEFF
00CDFF00EBFF00FFF900FFE000FFCB00FFBB00FFB100FFAC00FFAE00FFB500FFC300FFD6
00FFEF00F3FF00D3FF00B0FF008BFF0065FF0040FF001CFF0500FF2400FF3F00FF5600FF
6700FF7200FF7800FF7800FF7100FF6500FF5300FF3B00FF1E00FF0002FF0028FF0050FF
007BFF00A7FF00D4FF00FFFF00FFD300FFA900FF8100FF5D00FF3C00FF2000FF0908FF00
14FF001AFF001AFF0013FF0007FF0000FF0A00FF2200FF3F00FF6100FF8800FFB200FFE0
00EFFF00BDFF0089FF0055FF0020FF1200FF4400FF7300FF
00FF5600FF8500FFB700FFEA00E1FF00ADFF0079FF0046FF0015FF1800FF4300FF6A00FF
8D00FFAB00FFC400FFD800FFE500FFEC00FFEE00FFE900FFDE00FFCD00FFB700FF9C00FF
7D00FF5900FF3200FF0800FF0022FF004FFF007CFF00A9FF00D4FF00FCFF00FFDD00FFBB
00FF9D00FF8400FF7100FF6300FF5B00FF5A00FF5E00FF6900FF7900FF8F00FFA900FFC7
00FFE800F3FF00CEFF00A8FF0083FF005FFF003EFF0021FF0007FF0C00FF1B00FF2400FF
2700FF2300FF1A00FF0B00FF0008FF0020FF003BFF0059FF0077FF0095FF00B2FF00CBFF
00E1FF00F2FF00FDFF00FFFD00FFFE00FAFF00EDFF00DCFF00C7FF00B0FF0099FF0083FF
0070FF0062FF005AFF0057FF005BFF0065FF0073FF0083FF0093FF009FFF00A7FF00A7FF
00A1FF0098FF0090FF008FFF0093FF0095FF008DFF0084FF007DFF007CFF0082FF008EFF
009DFF00ADFF00BCFF00C6FF00CCFF00CBFF00C3FF00B6FF00A4FF008FFF0078FF0061FF
004BFF0039FF002CFF0023FF0021FF0025FF002FFF003FFF0053FF006CFF0088FF00A6FF
00C5FF00E2FF00FEFF00FFE800FFD300FFC300FFB900FFB400FFB600FFBE00FFCB00FFDF
00FFF700EBFF00CBFF00A7FF0082FF005DFF0037FF0013FF0E00FF2C00FF4700FF5E00FF
6F00FF7B00FF8100FF8000FF7A00FF6D00FF5B00FF4300FF2600FF0500FF001FFF0048FF
0072FF009EFF00CBFF00F8FF00FFDB00FFB100FF8900FF6500FF4400FF2800FF1100FF00
0BFF0011FF0011FF000BFF0000FF0000FF1200FF2A00FF4700FF6900FF9000FFBA00FFE8
00E7FF00B4FF0081FF004CFF0018FF1A00FF4C00FF7C00FF
00FF5900FF8800FFB900FFEC00DFFF00AAFF0077FF0044FF0013FF1A00FF4500FF6D00FF
9000FFAE00FFC700FFDA00FFE700FFEF00FFF000FFEB00FFE000FFD000FFBA00FF9F00FF
7F00FF5B00FF3400FF0B00FF0020FF004DFF007AFF00A6FF00D1FF00FAFF00FFDF00FFBD
00FF9F00FF8600FF7300FF6500FF5E00FF5C00FF6100FF6B00FF7B00FF9100FFAB00FFC9
00FFEB00F1FF00CBFF00A6FF0081FF005DFF003CFF001EFF0005FF0E00FF1D00FF2600FF
2900FF2600FF1C00FF0D00FF0006FF001EFF0039FF0056FF0075FF0093FF00AFFF00C9FF
00DFFF00EFFF00FBFF00FFFF00FFFF00F7FF00EBFF00D9FF00C4FF00AEFF0096FF0081FF
006EFF0060FF0057FF0055FF0059FF0063FF0071FF0081FF0090FF009DFF00A4FF00A5FF
009FFF0095FF008DFF008CFF0091FF0092FF008BFF0081FF007AFF007AFF0080FF008BFF
009BFF00ABFF00B9FF00C4FF00C9FF00C8FF00C1FF00B4FF00A2FF008CFF0075FF005EFF
0049FF0037FF0029FF0021FF001FFF0022FF002CFF003CFF0051FF006AFF0086FF00A4FF
00C2FF00E0FF00FCFF00FFEA00FFD600FFC600FFBB00FFB700FFB800FFC000FFCE00FFE1
00FFFA00E9FF00C8FF00A5FF0080FF005AFF0035FF0011FF1000FF2F00FF4A00FF6000FF
7200FF7D00FF8300FF8300FF7C00FF7000FF5D00FF4500FF2900FF0700FF001DFF0045FF
0070FF009CFF00C9FF00F6FF00FFDD00FFB300FF8C00FF6700FF4700FF2B00FF1400FF02
09FF000FFF000FFF0009FF0000FF0300FF1500FF2D00FF4A00FF6C00FF9200FFBD00FFEA
00E4FF00B2FF007EFF004AFF0016FF1D00FF4E00FF7E00FF
00FF5500FF8400FFB500FFE800E3FF00AEFF007AFF0048FF0017FF1600FF4100FF6900FF
8C00FFAA00FFC300FFD600FFE300FFEB00FFEC00FFE700FFDC00FFCC00FFB600FF9B00FF
7B00FF5700FF3000FF0700FF0024FF0051FF007EFF00AAFF00D5FF00FEFF00FFDB00FFB9
00FF9B00FF8300FF6F00FF6100FF5A00FF5800FF5D00FF6700FF7800FF8D00FFA700FFC5
00FFE700F4FF00CFFF00AAFF0084FF0061FF0040FF0022FF0009FF0B00FF1900FF2200FF
2500FF2200FF1800FF0900FF0009FF0022FF003DFF005AFF0079FF0097FF00B3FF00CDFF
00E2FF00F3FF00FEFF00FFFB00FFFD00FBFF00EEFF00DDFF00C8FF00B1FF009AFF0085FF
0072FF0064FF005BFF0059FF005DFF0067FF0075FF0085FF0094FF00A1FF00A8FF00A9FF
00A3FF0099FF0091FF0090FF0095FF0096FF008FFF0085FF007EFF007EFF0083FF008FFF
009EFF00AFFF00BDFF00C8FF00CDFF00CCFF00C5FF00B8FF00A6FF0090FF0079FF0062FF
004DFF003BFF002DFF0025FF0022FF0026FF0030FF0040FF0055FF006EFF008AFF00A8FF
00C6FF00E4FF00FFFF00FFE700FFD200FFC200FFB700FFB300FFB400FFBC00FFCA00FFDD
00FFF600EDFF00CCFF00A9FF0084FF005EFF0039FF0015FF0C00FF2B00FF4600FF5C00FF
6E00FF7900FF7F00FF7F00FF7800FF6C00FF5900FF4200FF2500FF0300FF0021FF0049FF
0074FF00A0FF00CDFF00FAFF00FFD900FFAF00FF8800FF6300FF4300FF2700FF1001FF00
0DFF0013FF0013FF000DFF0000FF0000FF1100FF2900FF4600FF6800FF8E00FFB900FFE6
00E8FF00B6FF0082FF004EFF001AFF1900FF4A00FF7A00FF
00FF4B00FF7A00FFAB00FFDE00EDFF00B8FF0084FF0052FF0021FF0C00FF3700FF5F00FF
8200FFA000FFB900FFCC00FFD900FFE100FFE200FFDD00FFD200FFC200FFAC00FF9100FF
7100FF4D00FF2600FF0002FF002EFF005BFF0088FF00B4FF00DFFF00FFF700FFD100FFAF
00FF9100FF7900FF6500FF5700FF5000FF4E00FF5300FF5D00FF6E00FF8300FF9D00FFBB
00FFDD00FEFF00D9FF00B4FF008EFF006BFF004AFF002CFF0013FF0000FF0F00FF1800FF
1B00FF1800FF0E00FF0000FF0013FF002CFF0047FF0064FF0083FF00A1FF00BDFF00D7FF
00EDFF00FDFF00FFF600FFF100FFF300FFFA00F9FF00E7FF00D2FF00BBFF00A4FF008FFF
007CFF006EFF0065FF0063FF0067FF0071FF007FFF008FFF009EFF00ABFF00B2FF00B3FF
00ADFF00A3FF009BFF009AFF009FFF00A0FF0099FF008FFF0088FF0088FF008DFF0099FF
00A8FF00B9FF00C7FF00D2FF00D7FF00D6FF00CFFF00C2FF00B0FF009AFF0083FF006CFF
0057FF0045FF0037FF002FFF002CFF0030FF003AFF004AFF005FFF0078FF0094FF00B2FF
00D0FF00EEFF00FFF500FFDD00FFC800FFB800FFAD00FFA900FFAA00FFB200FFC000FFD3
00FFEC00F7FF00D6FF00B3FF008EFF0068FF0043FF001FFF0200FF2100FF3C00FF5200FF
6400FF6F00FF7500FF7500FF6E00FF6200FF4F00FF3800FF1B00FF0006FF002BFF0053FF
007EFF00AAFF00D7FF00FFFB00FFCF00FFA500FF7E00FF5900FF3900FF1D00FF060BFF00
17FF001DFF001DFF0017FF000AFF0000FF0700FF1F00FF3C00FF5E00FF8400FFAF00FFDC
00F2FF00C0FF008CFF0058FF0024FF0F00FF4000FF7000FF
00FF3B00FF6A00FF9B00FFCF00FCFF00C8FF0094FF0062FF0031FF0002FF2800FF4F00FF
7200FF9000FFA900FFBC00FFCA00FFD100FFD200FFCD00FFC300FFB200FF9C00FF8100FF
6100FF3E00FF1700FF0012FF003EFF006AFF0097FF00C4FF00EFFF00FFE700FFC100FF9F
00FF8200FF6900FF5500FF4800FF4000FF3E00FF4300FF4E00FF5E00FF7300FF8D00FFAC
00FFCD00FFF100E9FF00C3FF009EFF007BFF005AFF003CFF0023FF000EFF0000FF0900FF
0B00FF0800FF0000FF000FFF0023FF003BFF0057FF0074FF0092FF00B1FF00CDFF00E7FF
00FCFF00FFF200FFE700FFE200FFE300FFEA00FFF700F7FF00E2FF00CBFF00B4FF009EFF
008CFF007DFF0075FF0073FF0077FF0080FF008EFF009EFF00AEFF00BBFF00C2FF00C2FF
00BCFF00B3FF00ABFF00AAFF00AFFF00B0FF00A9FF009FFF0098FF0097FF009DFF00A9FF
00B8FF00C8FF00D7FF00E2FF00E7FF00E6FF00DFFF00D1FF00BFFF00AAFF0093FF007CFF
0067FF0055FF0047FF003FFF003CFF0040FF004AFF005AFF006FFF0088FF00A4FF00C1FF
00E0FF00FEFF00FFE600FFCD00FFB800FFA800FF9E00FF9900FF9B00FFA200FFB000FFC3
00FFDC00FFF900E6FF00C3FF009EFF0078FF0053FF002FFF000DFF1100FF2C00FF4300FF
5400FF6000FF6500FF6500FF5E00FF5200FF4000FF2800FF0B00FF0015FF003BFF0063FF
008EFF00BAFF00E7FF00FFEC00FFC000FF9600FF6E00FF4A00FF2900FF0D09FF001BFF00
27FF002DFF002DFF0026FF001AFF0008FF0000FF0F00FF2C00FF4E00FF7500FF9F00FFCD
00FFFD00D0FF009CFF0068FF0033FF0000FF3100FF6000FF
00FF2600FF5500FF8700FFBA00FFEE00DDFF00A9FF0076FF0046FF0017FF1300FF3A00FF
5D00FF7B00FF9400FFA700FFB500FFBC00FFBD00FFB900FFAE00FF9D00FF8700FF6C00FF
4C00FF2900FF0200FF0027FF0053FF007FFF00ACFF00D9FF00FFFB00FFD300FFAD00FF8B
00FF6D00FF5400FF4100FF3300FF2B00FF2A00FF2E00FF3900FF4900FF5E00FF7900FF97
00FFB800FFDC00FEFF00D8FF00B3FF008FFF006EFF0051FF0037FF0023FF0014FF000BFF
0009FF000CFF0015FF0024FF0038FF0050FF006BFF0089FF00A7FF00C5FF00E2FF00FBFF
00FFEE00FFDD00FFD200FFCD00FFCE00FFD500FFE200FFF300F7FF00E0FF00C9FF00B3FF
00A0FF0092FF008AFF0087FF008CFF0095FF00A3FF00B3FF00C3FF00D0FF00D7FF00D7FF
00D1FF00C8FF00C0FF00BFFF00C4FF00C5FF00BEFF00B4FF00ADFF00ACFF00B2FF00BEFF
00CDFF00DDFF00ECFF00F6FF00FCFF00FBFF00F3FF00E6FF00D4FF00BFFF00A8FF0091FF
007CFF0069FF005CFF0053FF0051FF0055FF005FFF006FFF0084FF009CFF00B8FF00D6FF
00F5FF00FFED00FFD100FFB800FFA300FF9300FF8900FF8400FF8600FF8E00FF9B00FFAF
00FFC700FFE400FBFF00D8FF00B3FF008DFF0068FF0043FF0022FF0003FF1700FF2E00FF
3F00FF4B00FF5000FF5000FF4A00FF3D00FF2B00FF1300FF0009FF002AFF004FFF0078FF
00A2FF00CFFF00FBFF00FFD700FFAB00FF8100FF5900FF3500FF1407FF001EFF0030FF00
3CFF0042FF0041FF003BFF002FFF001DFF0005FF0000FF1700FF3900FF6000FF8A00FFB8
00FFE800E4FF00B1FF007CFF0048FF0015FF1C00FF4B00FF
00FF0D00FF3C00FF6E00FFA100FFD500F6FF00C2FF008FFF005FFF0030FF0005FF2100FF
4400FF6200FF7B00FF8E00FF9C00FFA300FFA500FFA000FF9500FF8400FF6E00FF5300FF
3300FF1000FF0016FF0040FF006CFF0098FF00C5FF00F2FF00FFE200FFBA00FF9400FF72
00FF5400FF3B00FF2800FF1A00FF1200FF1100FF1500FF2000FF3000FF4600FF6000FF7E
00FF9F00FFC300FFE800F1FF00CCFF00A8FF0087FF006AFF0050FF003CFF002DFF0024FF
0021FF0025FF002EFF003DFF0051FF0069FF0084FF00A2FF00C0FF00DEFF00FBFF00FFEB
00FFD500FFC400FFB900FFB400FFB500FFBC00FFC900FFDA00FFEF00F9FF00E2FF00CCFF
00B9FF00ABFF00A3FF00A0FF00A4FF00AEFF00BCFF00CCFF00DCFF00E8FF00F0FF00F0FF
00EAFF00E1FF00D9FF00D8FF00DDFF00DEFF00D7FF00CDFF00C6FF00C5FF00CBFF00D7FF
00E6FF00F6FF00FFFA00FFF000FFEA00FFEB00FFF300FFFF00EDFF00D8FF00C1FF00AAFF
0095FF0082FF0075FF006CFF006AFF006EFF0078FF0088FF009CFF00B5FF00D1FF00EFFF
00FFF100FFD400FFB800FF9F00FF8A00FF7A00FF7000FF6B00FF6D00FF7500FF8200FF96
00FFAE00FFCB00FFEB00F0FF00CCFF00A6FF0081FF005CFF003AFF001CFF0001FF1500FF
2600FF3200FF3700FF3700FF3100FF2400FF1200FF0005FF0022FF0043FF0068FF0091FF
00BBFF00E7FF00FFEB00FFBE00FF9200FF6800FF4000FF1C04FF0020FF0037FF0049FF00
54FF005AFF005AFF0054FF0048FF0036FF001EFF0001FF0000FF2000FF4700FF7100FF9F
00FFCF00FDFF00CAFF0095FF0061FF002EFF0300FF3300FF
0EFF0000FF2000FF5200FF8500FFB900FFED00DEFF00ABFF007AFF004CFF0021FF0500FF
2800FF4600FF5F00FF7200FF8000FF8700FF8900FF8400FF7900FF6800FF5200FF3700FF
1800FF000BFF0032FF005CFF0088FF00B4FF00E1FF00FFF100FFC600FF9E00FF7800FF56
00FF3800FF1F00FF0C01FF0009FF000AFF0006FF0000FF0400FF1400FF2A00FF4400FF62
00FF8300FFA700FFCC00FFF200E8FF00C4FF00A3FF0086FF006CFF0058FF0049FF0040FF
003DFF0041FF004AFF0059FF006DFF0085FF00A0FF00BEFF00DCFF00FAFF00FFE800FFCF
00FFB900FFA800FF9D00FF9800FF9900FFA000FFAD00FFBE00FFD300FFEA00FEFF00E8FF
00D5FF00C7FF00BFFF00BCFF00C0FF00CAFF00D8FF00E8FF00F8FF00FFFB00FFF300FFF3
00FFF900FDFF00F5FF00F4FF00F9FF00FAFF00F3FF00E9FF00E2FF00E1FF00E7FF00F3FF
00FFFD00FFED00FFDE00FFD400FFCE00FFCF00FFD700FFE400FFF600F4FF00DDFF00C6FF
00B1FF009EFF0091FF0088FF0086FF008AFF0094FF00A4FF00B8FF00D1FF00EDFF00FFF4
00FFD500FFB800FF9C00FF8300FF6E00FF5E00FF5400FF4F00FF5100FF5900FF6600FF7A
00FF9200FFAF00FFCF00FFF300E8FF00C2FF009DFF0078FF0056FF0038FF001DFF0006FF
0A00FF1600FF1C00FF1B00FF1500FF0800FF0009FF0021FF003EFF005FFF0084FF00ADFF
00D7FF00FFFC00FFCF00FFA200FF7600FF4C00FF2400FF0020FF003CFF0053FF0065FF00
70FF0076FF0076FF0070FF0064FF0052FF003AFF001DFF0000FF0400FF2B00FF5500FF83
00FFB300FFE600E6FF00B1FF007DFF004AFF0018FF1700FF
2CFF0000FF0200FF3400FF6700FF9B00FFCF00FCFF00C9FF0098FF006AFF003FFF0018FF
0A00FF2800FF4100FF5500FF6200FF6900FF6B00FF6600FF5B00FF4B00FF3400FF1900FF
0005FF0029FF0050FF007AFF00A5FF00D2FF00FFFF00FFD400FFA900FF8000FF5A00FF38
00FF1A00FF0111FF001FFF0027FF0028FF0024FF0019FF0009FF0000FF0C00FF2600FF44
00FF6500FF8900FFAE00FFD400FFF900E2FF00C1FF00A4FF008AFF0076FF0067FF005EFF
005BFF005FFF0068FF0077FF008BFF00A3FF00BEFF00DCFF00FAFF00FFE700FFCA00FFB1
00FF9B00FF8A00FF7F00FF7A00FF7B00FF8200FF8F00FFA100FFB500FFCC00FFE300FFF9
00F3FF00E5FF00DCFF00DAFF00DEFF00E8FF00F6FF00FFF900FFE900FFDD00FFD500FFD5
00FFDB00FFE400FFED00FFED00FFE900FFE800FFEF00FFF800FFFF00FFFF00FFFA00FFEE
00FFDF00FFCF00FFC000FFB600FFB000FFB100FFB900FFC600FFD800FFED00FBFF00E4FF
00CEFF00BCFF00AEFF00A6FF00A4FF00A8FF00B2FF00C1FF00D6FF00EFFF00FFF400FFD6
00FFB800FF9A00FF7E00FF6500FF5000FF4000FF3600FF3100FF3300FF3B00FF4800FF5C
00FF7400FF9100FFB200FFD500FFFA00E0FF00BAFF0096FF0074FF0055FF003AFF0024FF
0013FF0007FF0001FF0002FF0008FF0015FF0027FF003FFF005CFF007DFF00A2FF00CAFF
00F5FF00FFDE00FFB100FF8400FF5800FF2E00FF061DFF003EFF005AFF0071FF0082FF00
8EFF0094FF0094FF008EFF0082FF0070FF0058FF003BFF0019FF0000FF0D00FF3700FF65
00FF9500FFC800FFFC00CFFF009BFF0068FF0036FF0006FF
4AFF001BFF0000FF1500FF4900FF7D00FFB100FFE500E8FF00B7FF0088FF005DFF0036FF
0013FF0A00FF2300FF3600FF4400FF4B00FF4C00FF4700FF3D00FF2C00FF1600FF0004FF
0024FF0047FF006EFF0098FF00C4FF00F0FF00FFE200FFB500FF8A00FF6100FF3B00FF19
03FF001CFF0030FF003DFF0045FF0047FF0042FF0037FF0027FF0012FF0000FF0700FF26
00FF4700FF6B00FF9000FFB600FFDB00FFFE00E0FF00C2FF00A9FF0094FF0085FF007CFF
007AFF007DFF0086FF0095FF00A9FF00C1FF00DDFF00FAFF00FFE700FFC800FFAC00FF92
00FF7D00FF6C00FF6100FF5C00FF5D00FF6400FF7100FF8200FF9700FFAE00FFC500FFDB
00FFED00FFFC00FBFF00F9FF00FDFF00FFF900FFEB00FFDB00FFCB00FFBE00FFB700FFB7
00FFBD00FFC600FFCE00FFCF00FFCA00FFC900FFD000FFDA00FFE100FFE200FFDC00FFD0
00FFC100FFB100FFA200FF9700FF9200FF9300FF9A00FFA800FFBA00FFCF00FFE600FFFD
00EDFF00DBFF00CDFF00C5FF00C2FF00C6FF00D0FF00E0FF00F5FF00FFF100FFD500FFB8
00FF9900FF7B00FF6000FF4700FF3200FF2200FF1800FF1300FF1500FF1C00FF2A00FF3D
00FF5600FF7300FF9300FFB600FFDB00FEFF00D9FF00B5FF0093FF0074FF0059FF0042FF
0031FF0026FF0020FF0020FF0027FF0033FF0045FF005DFF007AFF009BFF00C1FF00E9FF
00FFEB00FFBF00FF9200FF6600FF3A00FF1017FF003BFF005CFF0078FF008FFF00A1FF00
ADFF00B3FF00B3FF00ACFF00A0FF008EFF0076FF0059FF0037FF0010FF0000FF1900FF47
00FF7700FFA900FFDD00EEFF00B9FF0086FF0054FF0025FF
68FF0039FF0007FF0000FF2B00FF5F00FF9300FFC700FFFA00D4FF00A6FF007BFF0054FF
0031FF0013FF0500FF1800FF2600FF2D00FF2F00FF2A00FF1F00FF0E00FF0007FF0022FF
0041FF0065FF008CFF00B6FF00E1FF00FFF100FFC400FF9700FF6C00FF4400FF1E03FF00
21FF003AFF004DFF005BFF0063FF0064FF0060FF0055FF0045FF002FFF0015FF0000FF08
00FF2900FF4D00FF7200FF9800FFBD00FFE100FDFF00E0FF00C6FF00B2FF00A3FF009AFF
0097FF009BFF00A4FF00B3FF00C7FF00DFFF00FAFF00FFE700FFC900FFAB00FF8E00FF75
00FF5F00FF4E00FF4300FF3E00FF3F00FF4600FF5300FF6400FF7900FF9000FFA700FFBD
00FFD000FFDE00FFE600FFE900FFE500FFDB00FFCD00FFBD00FFAD00FFA100FF9900FF99
00FF9F00FFA800FFB000FFB100FFAC00FFAB00FFB200FFBC00FFC300FFC400FFBE00FFB2
00FFA300FF9300FF8400FF7A00FF7400FF7500FF7D00FF8A00FF9C00FFB100FFC800FFDF
00FFF400F8FF00EBFF00E2FF00E0FF00E4FF00EEFF00FEFF00FFED00FFD400FFB800FF9A
00FF7B00FF5E00FF4200FF2900FF1400FF0405FF000AFF0008FF0000FF0000FF0C00FF20
00FF3800FF5500FF7500FF9900FFBD00FFE300F7FF00D2FF00B0FF0092FF0077FF0060FF
004FFF0043FF003DFF003EFF0044FF0051FF0063FF007BFF0098FF00B9FF00DEFF00FFF8
00FFCE00FFA200FF7500FF4800FF1C0DFF0035FF0059FF007AFF0096FF00ADFF00BEFF00
CAFF00D0FF00D0FF00CAFF00BEFF00ACFF0094FF0077FF0055FF002EFF0004FF0000FF29
00FF5900FF8C00FFBF00FFF400D7FF00A4FF0072FF0042FF
84FF0055FF0023FF0000FF0F00FF4300FF7700FFAB00FFDE00F0FF00C2FF0097FF0070FF
004DFF002EFF0016FF0002FF0A00FF1100FF1300FF0E00FF0300FF000CFF0022FF003EFF
005DFF0081FF00A8FF00D2FF00FDFF00FFD500FFA800FF7C00FF5100FF2800FF021FFF00
3DFF0056FF0069FF0077FF007FFF0080FF007BFF0071FF0061FF004BFF0031FF0013FF00
00FF0D00FF3100FF5600FF7C00FFA100FFC500FFE600FCFF00E2FF00CEFF00BFFF00B6FF
00B3FF00B7FF00C0FF00CFFF00E3FF00FBFF00FFE900FFCB00FFAD00FF8F00FF7300FF59
00FF4300FF3200FF2700FF2200FF2300FF2A00FF3700FF4900FF5D00FF7400FF8B00FFA1
00FFB400FFC200FFCB00FFCD00FFC900FFBF00FFB100FFA100FF9100FF8500FF7E00FF7D
00FF8300FF8D00FF9500FF9500FF9100FF9000FF9700FFA000FFA700FFA800FFA200FF97
00FF8700FF7700FF6800FF5E00FF5900FF5A00FF6100FF6E00FF8000FF9500FFAC00FFC3
00FFD900FFEB00FFF900FEFF00FCFF00FFFF00FFF500FFE600FFD100FFB800FF9C00FF7E
00FF6000FF4200FF2600FF0D07FF0016FF0021FF0026FF0024FF001CFF000EFF0000FF04
00FF1C00FF3900FF5A00FF7D00FFA200FFC700FFED00EEFF00CCFF00ADFF0092FF007CFF
006BFF005FFF0059FF005AFF0060FF006DFF007FFF0097FF00B4FF00D5FF00FAFF00FFDD
00FFB200FF8600FF5900FF2C00FF0029FF0051FF0075FF0096FF00B2FF00C9FF00DAFF00
E6FF00ECFF00ECFF00E6FF00DAFF00C8FF00B0FF0093FF0071FF004AFF0020FF0000FF0D
00FF3E00FF7000FFA400FFD800F3FF00C0FF008EFF005EFF
9CFF006DFF003CFF0009FF0000FF2A00FF5F00FF9200FFC500FFF600DBFF00B0FF0088FF
0065FF0047FF002EFF001BFF000EFF0006FF0005FF000AFF0015FF0025FF003BFF0056FF
0076FF009AFF00C1FF00EBFF00FFE900FFBC00FF8F00FF6300FF3800FF0F16FF0038FF00
56FF006FFF0082FF0090FF0097FF0099FF0094FF008AFF007AFF0064FF004AFF002CFF00
0AFF0000FF1800FF3E00FF6300FF8800FFAC00FFCD00FFEB00FBFF00E7FF00D8FF00CFFF
00CCFF00CFFF00D9FF00E8FF00FCFF00FFEB00FFD000FFB300FF9400FF7600FF5A00FF40
00FF2A00FF1A00FF0E00FF0900FF0A00FF1200FF1E00FF3000FF4500FF5B00FF7300FF88
00FF9B00FFA900FFB200FFB400FFB000FFA600FF9800FF8800FF7900FF6C00FF6500FF64
00FF6A00FF7400FF7C00FF7D00FF7800FF7700FF7E00FF8800FF8E00FF8F00FF8900FF7E
00FF6E00FF5E00FF5000FF4500FF4000FF4100FF4800FF5500FF6700FF7D00FF9400FFAB
00FFC000FFD200FFE000FFE800FFEA00FFE700FFDD00FFCD00FFB800FF9F00FF8300FF65
00FF4700FF2900FF0D0BFF001FFF002FFF003AFF003EFF003DFF0035FF0027FF0014FF00
00FF0400FF2000FF4100FF6400FF8900FFAE00FFD400FFF800E5FF00C6FF00ABFF0095FF
0084FF0078FF0072FF0072FF0079FF0085FF0098FF00B0FF00CCFF00EEFF00FFEC00FFC4
00FF9900FF6D00FF4000FF1318FF0042FF0069FF008EFF00AEFF00CAFF00E1FF00F3FF00
FFFF00FFFA00FFFA00FFFF00F2FF00E0FF00C9FF00ABFF0089FF0063FF0038FF000BFF00
00FF2500FF5700FF8B00FFBF00FFF300D8FF00A7FF0077FF
B1FF0082FF0051FF001EFF0000FF1500FF4A00FF7E00FFB000FFE100F0FF00C4FF009DFF
007AFF005CFF0043FF0030FF0022FF001BFF001AFF001FFF0029FF003AFF0050FF006BFF
008BFF00AFFF00D6FF00FFFF00FFD400FFA700FF7A00FF4E00FF2305FF002BFF004DFF00
6BFF0083FF0097FF00A4FF00ACFF00AEFF00A9FF009FFF008EFF0079FF005FFF0041FF00
1FFF0000FF0400FF2900FF4F00FF7400FF9700FFB800FFD600FFEF00FBFF00EDFF00E4FF
00E1FF00E4FF00EEFF00FCFF00FFEF00FFD700FFBB00FF9E00FF7F00FF6100FF4500FF2B
00FF1600FF0505FF000AFF0009FF0002FF0000FF0A00FF1B00FF3000FF4700FF5E00FF74
00FF8600FF9500FF9D00FF9F00FF9B00FF9100FF8400FF7300FF6400FF5700FF5000FF50
00FF5500FF5F00FF6700FF6800FF6300FF6200FF6900FF7300FF7A00FF7B00FF7500FF69
00FF5A00FF4900FF3B00FF3000FF2B00FF2C00FF3300FF4000FF5200FF6800FF7F00FF96
00FFAB00FFBD00FFCB00FFD300FFD600FFD200FFC800FFB800FFA300FF8A00FF6E00FF50
00FF3200FF1407FF001FFF0034FF0044FF004FFF0053FF0051FF004AFF003CFF0029FF00
10FF0000FF0C00FF2C00FF4F00FF7400FF9A00FFBF00FFE300FAFF00DBFF00C0FF00AAFF
0098FF008DFF0087FF0087FF008EFF009AFF00ADFF00C4FF00E1FF00FFFC00FFD700FFAF
00FF8400FF5800FF2B01FF002CFF0057FF007EFF00A3FF00C3FF00DFFF00F6FF00FFF700
FFEB00FFE500FFE500FFEB00FFF800F5FF00DDFF00C0FF009EFF0078FF004DFF001FFF00
00FF1000FF4200FF7600FFAA00FFDE00EDFF00BBFF008CFF
C1FF0092FF0061FF002EFF0000FF0600FF3A00FF6E00FFA000FFD100FFFF00D4FF00ADFF
008AFF006CFF0053FF0040FF0032FF002BFF002AFF002FFF0039FF004AFF0060FF007BFF
009BFF00BEFF00E6FF00FFF000FFC400FF9700FF6B00FF3E00FF1315FF003BFF005DFF00
7AFF0093FF00A7FF00B4FF00BCFF00BEFF00B9FF00AEFF009EFF0089FF006FFF0050FF00
2FFF000BFF0000FF1900FF3F00FF6400FF8700FFA800FFC600FFDF00FFF400FCFF00F4FF
00F1FF00F4FF00FDFF00FFF300FFDF00FFC700FFAB00FF8E00FF6F00FF5100FF3500FF1B
00FF060AFF0015FF001AFF0019FF0012FF0005FF0000FF0B00FF2000FF3700FF4E00FF64
00FF7600FF8500FF8D00FF8F00FF8B00FF8200FF7400FF6300FF5400FF4700FF4000FF40
00FF4500FF4F00FF5700FF5800FF5300FF5200FF5900FF6300FF6A00FF6B00FF6500FF59
00FF4A00FF3900FF2B00FF2000FF1B00FF1C00FF2300FF3100FF4200FF5800FF6F00FF86
00FF9B00FFAD00FFBB00FFC300FFC600FFC200FFB800FFA800FF9300FF7A00FF5E00FF40
00FF2200FF0416FF002FFF0044FF0054FF005EFF0063FF0061FF005AFF004CFF0039FF00
20FF0003FF0000FF1C00FF3F00FF6400FF8A00FFAF00FFD300FFF500EBFF00D0FF00BAFF
00A8FF009DFF0097FF0097FF009EFF00AAFF00BCFF00D4FF00F1FF00FFED00FFC700FF9F
00FF7400FF4800FF1B11FF003CFF0067FF008EFF00B3FF00D3FF00EFFF00FFF900FFE700
FFDB00FFD500FFD500FFDC00FFE800FFFA00EDFF00D0FF00AEFF0088FF005DFF002FFF00
00FF0000FF3200FF6600FF9A00FFCF00FDFF00CBFF009CFF
CCFF009DFF006BFF0038FF0004FF0000FF2F00FF6300FF9600FFC700FFF500DFFF00B8FF
0095FF0076FF005EFF004AFF003DFF0035FF0034FF0039FF0044FF0054FF006AFF0086FF
00A5FF00C9FF00F0FF00FFE500FFBA00FF8D00FF6000FF3400FF091FFF0045FF0067FF00
85FF009EFF00B1FF00BFFF00C7FF00C8FF00C3FF00B9FF00A9FF0093FF0079FF005BFF00
3AFF0016FF0000FF0E00FF3400FF5900FF7D00FF9E00FFBB00FFD500FFE900FFF800FEFF
00FBFF00FFFF00FFF700FFE800FFD400FFBC00FFA100FF8300FF6500FF4700FF2B00FF11
04FF0015FF0020FF0025FF0024FF001DFF0010FF0000FF0100FF1500FF2C00FF4300FF59
00FF6C00FF7A00FF8300FF8500FF8100FF7700FF6900FF5900FF4900FF3D00FF3600FF35
00FF3B00FF4500FF4D00FF4D00FF4900FF4800FF4F00FF5800FF5F00FF6000FF5A00FF4F
00FF3F00FF2F00FF2000FF1600FF1100FF1200FF1900FF2600FF3800FF4D00FF6400FF7B
00FF9100FFA300FFB100FFB900FFBB00FFB700FFAD00FF9E00FF8900FF7000FF5400FF36
00FF1805FF0021FF003AFF004FFF005EFF0069FF006DFF006CFF0064FF0056FF0043FF00
2BFF000EFF0000FF1200FF3500FF5A00FF7F00FFA500FFC900FFEB00F5FF00DAFF00C4FF
00B3FF00A7FF00A1FF00A2FF00A8FF00B5FF00C7FF00DFFF00FCFF00FFE200FFBD00FF95
00FF6A00FF3E00FF111BFF0047FF0071FF0099FF00BDFF00DEFF00FAFF00FFEE00FFDD00
FFD100FFCB00FFCB00FFD100FFDD00FFEF00F8FF00DBFF00B8FF0092FF0068FF003AFF00
09FF0000FF2800FF5C00FF9000FFC400FFF700D6FF00A6FF
D0FF00A1FF0070FF003DFF0009FF0000FF2B00FF5F00FF9100FFC200FFF000E3FF00BCFF
0099FF007BFF0062FF004FFF0041FF003AFF0039FF003EFF0048FF0059FF006FFF008AFF
00AAFF00CDFF00F5FF00FFE100FFB500FF8800FF5B00FF2F00FF0424FF004AFF006CFF00
89FF00A2FF00B6FF00C3FF00CBFF00CDFF00C8FF00BDFF00ADFF0098FF007EFF005FFF00
3EFF001AFF0000FF0A00FF3000FF5500FF7800FF9900FFB700FFD000FFE500FFF400FFFC
00FFFF00FFFC00FFF200FFE400FFD000FFB800FF9C00FF7F00FF6000FF4200FF2600FF0C
08FF0019FF0024FF0029FF0028FF0021FF0014FF0003FF0000FF1100FF2800FF3F00FF55
00FF6700FF7600FF7E00FF8000FF7C00FF7200FF6500FF5400FF4500FF3800FF3100FF31
00FF3600FF4000FF4800FF4900FF4400FF4300FF4A00FF5400FF5B00FF5C00FF5600FF4A
00FF3B00FF2A00FF1C00FF1100FF0C00FF0D00FF1400FF2100FF3300FF4900FF6000FF77
00FF8C00FF9E00FFAC00FFB400FFB700FFB300FFA900FF9900FF8400FF6B00FF4F00FF31
00FF130AFF0026FF003EFF0053FF0063FF006DFF0072FF0070FF0069FF005BFF0048FF00
2FFF0012FF0000FF0D00FF3000FF5500FF7B00FFA000FFC400FFE600FAFF00DFFF00C9FF
00B7FF00ACFF00A6FF00A6FF00ADFF00B9FF00CBFF00E3FF00FFFF00FFDE00FFB800FF90
00FF6500FF3900FF0C20FF004BFF0076FF009DFF00C2FF00E2FF00FEFF00FFEA00FFD800
FFCC00FFC600FFC600FFCD00FFD900FFEB00FCFF00DFFF00BDFF0097FF006CFF003EFF00
0EFF0000FF2300FF5700FF8B00FFBF00FFF300DAFF00ABFF
CFFF00A0FF006EFF003BFF0007FF0000FF2C00FF6000FF9300FFC400FFF200E2FF00BBFF
0098FF0079FF0061FF004DFF0040FF0038FF0037FF003CFF0047FF0057FF006DFF0089FF
00A8FF00CCFF00F3FF00FFE200FFB700FF8A00FF5D00FF3100FF0622FF0048FF006AFF00
88FF00A1FF00B4FF00C2FF00CAFF00CBFF00C6FF00BCFF00ACFF0096FF007CFF005EFF00
3CFF0019FF0000FF0C00FF3100FF5600FF7A00FF9B00FFB900FFD200FFE600FFF500FFFE
00FEFF00FFFD00FFF400FFE500FFD100FFB900FF9E00FF8000FF6200FF4400FF2800FF0E
07FF0018FF0023FF0028FF0027FF0020FF0013FF0001FF0000FF1200FF2900FF4000FF56
00FF6900FF7700FF8000FF8200FF7E00FF7400FF6600FF5600FF4600FF3A00FF3300FF32
00FF3800FF4200FF4A00FF4A00FF4600FF4500FF4C00FF5500FF5C00FF5D00FF5700FF4C
00FF3C00FF2C00FF1E00FF1300FF0E00FF0F00FF1600FF2300FF3500FF4A00FF6100FF78
00FF8E00FFA000FFAE00FFB600FFB800FFB400FFAA00FF9B00FF8600FF6D00FF5100FF33
00FF1508FF0024FF003DFF0051FF0061FF006CFF0070FF006FFF0067FF0059FF0046FF00
2EFF0011FF0000FF0F00FF3200FF5700FF7C00FFA200FFC600FFE800F8FF00DDFF00C7FF
00B6FF00AAFF00A4FF00A5FF00ABFF00B8FF00CAFF00E2FF00FFFF00FFDF00FFBA00FF92
00FF6700FF3B00FF0E1EFF004AFF0074FF009CFF00C0FF00E0FF00FDFF00FFEB00FFDA00
FFCE00FFC800FFC800FFCE00FFDA00FFED00FBFF00DEFF00BBFF0095FF006BFF003DFF00
0CFF0000FF2500FF5900FF8D00FFC100FFF400D9FF00A9FF
C7FF0098FF0066FF0033FF0000FF0000FF3400FF6800FF9B00FFCC00FFFA00DAFF00B3FF
0090FF0072FF0059FF0046FF0038FF0031FF002FFF0034FF003FFF0050FF0066FF0081FF
00A0FF00C4FF00EBFF00FFEA00FFBE00FF9200FF6500FF3800FF0D1AFF0040FF0062FF00
80FF0099FF00ACFF00BAFF00C2FF00C3FF00BFFF00B4FF00A4FF008EFF0074FF0056FF00
35FF0011FF0000FF1300FF3900FF5E00FF8200FFA300FFC000FFDA00FFEE00FFFD00F9FF
00F6FF00FAFF00FFFC00FFED00FFD900FFC100FFA600FF8800FF6A00FF4C00FF2F00FF16
00FF0010FF001BFF0020FF001FFF0018FF000BFF0000FF0500FF1A00FF3100FF4800FF5E
00FF7100FF7F00FF8700FF8A00FF8600FF7C00FF6E00FF5E00FF4E00FF4200FF3A00FF3A
00FF4000FF4900FF5100FF5200FF4D00FF4C00FF5300FF5D00FF6400FF6500FF5F00FF53
00FF4400FF3400FF2500FF1B00FF1500FF1600FF1E00FF2B00FF3D00FF5200FF6900FF80
00FF9500FFA800FFB500FFBE00FFC000FFBC00FFB200FFA200FF8E00FF7500FF5900FF3B
00FF1C00FF001CFF0035FF004AFF005AFF0064FF0069FF0067FF005FFF0052FF003EFF00
26FF0009FF0000FF1600FF3A00FF5E00FF8400FFA900FFCE00FFF000F1FF00D6FF00BFFF
00AEFF00A2FF009CFF009DFF00A3FF00B0FF00C2FF00DAFF00F7FF00FFE700FFC200FF99
00FF6F00FF4300FF1616FF0042FF006CFF0094FF00B8FF00D9FF00F5FF00FFF300FFE200
FFD600FFD000FFD000FFD600FFE200FFF400F3FF00D6FF00B4FF008DFF0063FF0035FF00
05FF0000FF2D00FF6000FF9500FFC900FFFC00D1FF00A1FF
B9FF008AFF0059FF0026FF0000FF0E00FF4200FF7600FFA800FFD900F7FF00CCFF00A5FF
0082FF0064FF004BFF0038FF002AFF0023FF0022FF0027FF0031FF0042FF0058FF0073FF
0093FF00B6FF00DDFF00FFF800FFCC00FFA000FF7300FF4600FF1B0DFF0033FF0055FF00
72FF008BFF009FFF00ACFF00B4FF00B6FF00B1FF00A6FF0096FF0081FF0067FF0048FF00
27FF0003FF0000FF2100FF4700FF6C00FF8F00FFB000FFCE00FFE700FFFC00F4FF00ECFF
00E9FF00ECFF00F5FF00FFFB00FFE700FFCF00FFB300FF9600FF7800FF5900FF3D00FF23
00FF0E02FF000DFF0012FF0011FF000AFF0000FF0200FF1300FF2800FF3F00FF5600FF6C
00FF7E00FF8D00FF9500FF9700FF9300FF8A00FF7C00FF6C00FF5C00FF4F00FF4800FF48
00FF4D00FF5700FF5F00FF6000FF5B00FF5A00FF6100FF6B00FF7200FF7300FF6D00FF61
00FF5200FF4200FF3300FF2800FF2300FF2400FF2B00FF3900FF4A00FF6000FF7700FF8E
00FFA300FFB500FFC300FFCB00FFCE00FFCA00FFC000FFB000FF9B00FF8200FF6600FF48
00FF2A00FF0C0EFF0027FF003CFF004CFF0056FF005BFF0059FF0052FF0044FF0031FF00
18FF0000FF0400FF2400FF4700FF6C00FF9200FFB700FFDB00FFFD00E3FF00C8FF00B1FF
00A0FF0095FF008FFF008FFF0096FF00A2FF00B4FF00CCFF00E9FF00FFF500FFCF00FFA7
00FF7C00FF5000FF2308FF0034FF005EFF0086FF00AAFF00CBFF00E7FF00FEFF00FFEF00
FFE300FFDD00FFDD00FFE400FFF000FDFF00E5FF00C8FF00A6FF007FFF0055FF0027FF00
00FF0800FF3A00FF6E00FFA200FFD700F5FF00C3FF0094FF
A6FF0077FF0045FF0012FF0000FF2100FF5500FF8900FFBC00FFED00E4FF00B9FF0092FF
006FFF0051FF0038FF0024FF0017FF0010FF000EFF0013FF001EFF002FFF0045FF0060FF
007FFF00A3FF00CAFF00F4FF00FFE000FFB300FF8600FF5900FF2E00FF061FFF0041FF00
5FFF0078FF008BFF0099FF00A1FF00A2FF009EFF0093FF0083FF006DFF0053FF0035FF00
14FF0000FF0F00FF3400FF5A00FF7F00FFA300FFC400FFE100FFFB00F0FF00E1FF00D8FF
00D5FF00D9FF00E2FF00F1FF00FFFA00FFE200FFC700FFA900FF8B00FF6D00FF5000FF37
00FF2100FF1000FF0500FF0000FF0100FF0800FF1500FF2600FF3B00FF5200FF6900FF7F
00FF9200FFA000FFA800FFAB00FFA700FF9D00FF8F00FF7F00FF6F00FF6300FF5B00FF5B
00FF6100FF6A00FF7200FF7300FF6F00FF6D00FF7500FF7E00FF8500FF8600FF8000FF74
00FF6500FF5500FF4600FF3C00FF3600FF3700FF3F00FF4C00FF5E00FF7300FF8A00FFA1
00FFB700FFC900FFD600FFDF00FFE100FFDD00FFD300FFC300FFAF00FF9600FF7A00FF5C
00FF3D00FF2000FF0414FF0029FF0039FF0043FF0048FF0046FF003EFF0031FF001DFF00
05FF0000FF1700FF3700FF5B00FF7F00FFA500FFCB00FFEF00EEFF00D0FF00B5FF009EFF
008DFF0081FF007BFF007CFF0082FF008FFF00A1FF00B9FF00D6FF00F7FF00FFE300FFBA
00FF9000FF6400FF3700FF0A21FF004BFF0073FF0097FF00B8FF00D4FF00EBFF00FCFF00
FFF700FFF100FFF100FFF700FCFF00EAFF00D2FF00B5FF0093FF006CFF0042FF0014FF00
00FF1B00FF4E00FF8100FFB600FFEA00E2FF00B0FF0080FF
8DFF005EFF002DFF0000FF0500FF3900FF6E00FFA100FFD400FAFF00CCFF00A1FF0079FF
0056FF0038FF001FFF000CFF0000FF0800FF0900FF0400FF0006FF0016FF002CFF0047FF
0067FF008BFF00B2FF00DBFF00FFF800FFCB00FF9E00FF7200FF4700FF1E07FF0029FF00
47FF005FFF0073FF0081FF0088FF008AFF0085FF007BFF006AFF0055FF003BFF001DFF00
00FF0400FF2800FF4D00FF7200FF9800FFBB00FFDC00FFFA00ECFF00D8FF00C9FF00C0FF
00BDFF00C0FF00CAFF00D9FF00ECFF00FFFA00FFDF00FFC200FFA300FF8500FF6900FF4F
00FF3900FF2900FF1D00FF1800FF1A00FF2100FF2D00FF3F00FF5400FF6B00FF8200FF97
00FFAA00FFB800FFC100FFC300FFBF00FFB500FFA700FF9700FF8800FF7B00FF7400FF73
00FF7900FF8300FF8B00FF8C00FF8700FF8600FF8D00FF9700FF9E00FF9E00FF9900FF8D
00FF7E00FF6D00FF5F00FF5400FF4F00FF5000FF5700FF6400FF7600FF8C00FFA300FFBA
00FFCF00FFE100FFEF00FFF700FFFA00FFF600FFEC00FFDC00FFC700FFAE00FF9200FF74
00FF5600FF3800FF1C00FF0410FF0020FF002BFF002FFF002EFF0026FF0018FF0005FF00
00FF1300FF2F00FF5000FF7300FF9800FFBE00FFE300F8FF00D6FF00B7FF009CFF0086FF
0074FF0069FF0063FF0063FF006AFF0076FF0089FF00A0FF00BDFF00DFFF00FFFB00FFD3
00FFA800FF7C00FF4F00FF2209FF0033FF005AFF007FFF009FFF00BBFF00D2FF00E4FF00
F0FF00F6FF00F6FF00F0FF00E3FF00D1FF00B9FF009CFF007AFF0054FF0029FF0000FF03
00FF3400FF6600FF9A00FFCE00FDFF00C9FF0098FF0068FF
71FF0041FF0010FF0000FF2200FF5600FF8A00FFBE00FFF100DDFF00AFFF0084FF005CFF
0039FF001BFF0002FF1000FF1D00FF2500FF2600FF2100FF1600FF0600FF000FFF002AFF
004AFF006EFF0095FF00BFFF00EAFF00FFE800FFBB00FF8F00FF6400FF3B00FF150CFF00
2AFF0043FF0056FF0064FF006BFF006DFF0068FF005EFF004EFF0038FF001EFF0000FF00
00FF2100FF4400FF6A00FF8F00FFB400FFD800FFF900E8FF00CFFF00BBFF00ACFF00A3FF
00A0FF00A3FF00ADFF00BCFF00D0FF00E8FF00FFFC00FFDF00FFC000FFA200FF8600FF6C
00FF5600FF4500FF3A00FF3500FF3600FF3E00FF4A00FF5C00FF7100FF8700FF9E00FFB4
00FFC700FFD500FFDE00FFE000FFDC00FFD200FFC400FFB400FFA400FF9800FF9100FF90
00FF9600FFA000FFA800FFA800FFA400FFA300FFAA00FFB400FFBA00FFBB00FFB500FFAA
00FF9A00FF8A00FF7C00FF7100FF6C00FF6D00FF7400FF8100FF9300FFA800FFBF00FFD6
00FFEC00FFFE00F3FF00EBFF00E9FF00EDFF00F7FF00FFF900FFE400FFCB00FFAF00FF91
00FF7300FF5500FF3900FF2000FF0C03FF000EFF0012FF0011FF0009FF0000FF0400FF17
00FF2F00FF4C00FF6D00FF9000FFB500FFDA00FFFF00DBFF00B9FF009AFF007FFF0069FF
0058FF004CFF0046FF0046FF004DFF0059FF006CFF0084FF00A0FF00C2FF00E7FF00FFF0
00FFC500FF9900FF6C00FF3F00FF1316FF003DFF0062FF0082FF009EFF00B5FF00C7FF00
D3FF00D9FF00D9FF00D3FF00C7FF00B4FF009DFF007FFF005DFF0037FF000CFF0000FF20
00FF5100FF8300FFB700FFEB00E0FF00ADFF007BFF004BFF
50FF0021FF0000FF0F00FF4300FF7700FFAB00FFDF00EEFF00BDFF008EFF0063FF003CFF
0019FF0400FF1D00FF3000FF3E00FF4500FF4600FF4200FF3700FF2600FF1000FF000AFF
002AFF004DFF0074FF009EFF00CAFF00F6FF00FFDC00FFAF00FF8400FF5B00FF3600FF13
09FF0022FF0036FF0043FF004BFF004DFF0048FF003DFF002DFF0018FF0000FF0100FF20
00FF4100FF6500FF8A00FFB000FFD500FFF800E6FF00C8FF00AFFF009AFF008BFF0082FF
0080FF0083FF008CFF009BFF00AFFF00C7FF00E3FF00FFFF00FFE100FFC300FFA600FF8C
00FF7700FF6600FF5B00FF5600FF5700FF5E00FF6B00FF7C00FF9100FFA800FFBF00FFD5
00FFE700FFF600FFFE00FFFF00FFFC00FFF300FFE500FFD500FFC500FFB800FFB100FFB1
00FFB700FFC000FFC800FFC900FFC400FFC300FFCA00FFD400FFDB00FFDC00FFD600FFCA
00FFBB00FFAB00FF9C00FF9100FF8C00FF8D00FF9400FFA200FFB400FFC900FFE000FFF7
00F3FF00E1FF00D3FF00CBFF00C8FF00CCFF00D6FF00E6FF00FBFF00FFEB00FFCF00FFB2
00FF9300FF7500FF5A00FF4100FF2C00FF1C00FF1200FF0D00FF0F00FF1600FF2400FF37
00FF5000FF6D00FF8D00FFB000FFD500FFFB00DFFF00BBFF0099FF007AFF005FFF0048FF
0037FF002BFF0026FF0026FF002DFF0039FF004BFF0063FF0080FF00A1FF00C7FF00EFFF
00FFE600FFB900FF8C00FF6000FF3400FF0A1DFF0041FF0062FF007EFF0095FF00A7FF00
B3FF00B9FF00B9FF00B2FF00A6FF0094FF007CFF005FFF003DFF0016FF0000FF1300FF41
00FF7100FFA300FFD700F4FF00BFFF008CFF005AFF002BFF
2DFF0000FF0100FF3300FF6600FF9A00FFCE00FDFF00CAFF009AFF006BFF0040FF0019FF
0900FF2700FF4000FF5300FF6100FF6800FF6900FF6500FF5A00FF4900FF3300FF1800FF
0007FF002AFF0051FF007BFF00A7FF00D3FF00FFFF00FFD200FFA700FF7E00FF5900FF37
00FF1900FF0013FF0020FF0028FF0029FF0025FF001AFF000AFF0000FF0A00FF2500FF43
00FF6400FF8800FFAD00FFD300FFF800E3FF00C2FF00A5FF008BFF0077FF0068FF005FFF
005DFF0060FF0069FF0078FF008CFF00A4FF00BFFF00DDFF00FBFF00FFE600FFC900FFB0
00FF9A00FF8900FF7E00FF7900FF7A00FF8100FF8E00FF9F00FFB400FFCB00FFE200FFF8
00F4FF00E6FF00DEFF00DBFF00E0FF00E9FF00F7FF00FFF800FFE800FFDB00FFD400FFD4
00FFDA00FFE300FFEB00FFEC00FFE700FFE600FFED00FFF700FFFE00FFFF00FFF900FFED
00FFDE00FFCE00FFBF00FFB500FFAF00FFB000FFB800FFC500FFD700FFEC00FCFF00E5FF
00D0FF00BDFF00B0FF00A7FF00A5FF00A9FF00B3FF00C3FF00D8FF00F0FF00FFF300FFD5
00FFB600FF9900FF7D00FF6400FF4F00FF3F00FF3500FF3000FF3200FF3A00FF4700FF5B
00FF7300FF9000FFB000FFD300FFF800E1FF00BCFF0097FF0076FF0057FF003CFF0025FF
0014FF0008FF0003FF0003FF0009FF0016FF0028FF0040FF005DFF007EFF00A3FF00CCFF
00F6FF00FFDC00FFB000FF8300FF5700FF2D00FF051EFF003FFF005BFF0072FF0084FF00
90FF0096FF0095FF008FFF0083FF0071FF0059FF003CFF001AFF0000FF0C00FF3600FF64
00FF9400FFC700FFFA00D0FF009CFF0069FF0037FF0008FF
08FF0000FF2600FF5700FF8B00FFBF00FFF300D8FF00A6FF0075FF0046FF001BFF0B00FF
2E00FF4C00FF6500FF7800FF8600FF8D00FF8E00FF8A00FF7F00FF6E00FF5800FF3D00FF
1D00FF0005FF002CFF0056FF0082FF00AEFF00DBFF00FFF700FFCC00FFA300FF7E00FF5B
00FF3E00FF2500FF1100FF0403FF0004FF0000FF0000FF0A00FF1A00FF2F00FF4900FF68
00FF8900FFAD00FFD200FFF800E2FF00BFFF009EFF0080FF0067FF0052FF0043FF003AFF
0038FF003BFF0044FF0053FF0067FF007FFF009BFF00B8FF00D6FF00F4FF00FFEE00FFD4
00FFBF00FFAE00FFA300FF9E00FF9F00FFA600FFB300FFC400FFD900FFF000F8FF00E2FF
00D0FF00C1FF00B9FF00B7FF00BBFF00C4FF00D2FF00E2FF00F2FF00FFFF00FFF900FFF9
00FFFF00F7FF00EFFF00EEFF00F3FF00F4FF00EDFF00E3FF00DCFF00DBFF00E1FF00EDFF
00FCFF00FFF300FFE400FFD900FFD400FFD500FFDC00FFEA00FFFC00EEFF00D7FF00C0FF
00ABFF0099FF008BFF0082FF0080FF0084FF008EFF009EFF00B3FF00CCFF00E8FF00FFFA
00FFDB00FFBD00FFA200FF8900FF7400FF6400FF5A00FF5500FF5700FF5E00FF6C00FF7F
00FF9800FFB500FFD500FFF800E2FF00BCFF0097FF0073FF0051FF0032FF0017FF0000FF
1000FF1C00FF2100FF2100FF1B00FF0E00FF0003FF001BFF0038FF0059FF007EFF00A7FF
00D1FF00FEFF00FFD400FFA800FF7C00FF5200FF2A00FF061AFF0036FF004DFF005FFF00
6BFF0071FF0071FF006AFF005EFF004CFF0034FF0017FF0000FF0A00FF3100FF5B00FF89
00FFB900FFEC00E0FF00ACFF0077FF0044FF0012FF1C00FF
00FF1D00FF4C00FF7D00FFB000FFE400E6FF00B3FF0080FF004FFF0021FF0900FF3100FF
5400FF7200FF8B00FF9E00FFAB00FFB300FFB400FFAF00FFA400FF9400FF7E00FF6300FF
4300FF1F00FF0007FF0030FF005CFF0089FF00B6FF00E2FF00FFF200FFC900FFA300FF81
00FF6300FF4A00FF3700FF2900FF2200FF2000FF2500FF2F00FF4000FF5500FF6F00FF8D
00FFAF00FFD200FFF800E2FF00BCFF0099FF0078FF005AFF0041FF002DFF001EFF0015FF
0012FF0015FF001FFF002EFF0042FF005AFF0075FF0092FF00B1FF00CFFF00EBFF00FFFA
00FFE400FFD400FFC800FFC300FFC400FFCC00FFD800FFEA00FFFF00EAFF00D2FF00BDFF
00AAFF009CFF0093FF0091FF0095FF009FFF00ADFF00BDFF00CCFF00D9FF00E0FF00E1FF
00DBFF00D1FF00C9FF00C8FF00CDFF00CEFF00C7FF00BDFF00B6FF00B6FF00BCFF00C7FF
00D7FF00E7FF00F5FF00FFFF00FFFA00FFFB00FDFF00F0FF00DEFF00C8FF00B1FF009AFF
0085FF0073FF0065FF005DFF005AFF005EFF0068FF0078FF008DFF00A6FF00C2FF00E0FF
00FEFF00FFE300FFC700FFAE00FF9A00FF8A00FF7F00FF7B00FF7C00FF8400FF9200FFA5
00FFBE00FFDA00FFFB00E1FF00BCFF0096FF0071FF004DFF002BFF000CFF0E00FF2400FF
3600FF4100FF4700FF4700FF4000FF3400FF2100FF0900FF0012FF0034FF0059FF0081FF
00ACFF00D8FF00FFFA00FFCD00FFA100FF7700FF5000FF2B00FF0B10FF0027FF0039FF00
45FF004BFF004BFF0045FF0038FF0026FF000EFF0000FF0E00FF3000FF5600FF8100FFAE
00FFDF00EEFF00BAFF0086FF0052FF001EFF1200FF4200FF
00FF4200FF7100FFA300FFD600F5FF00C1FF008DFF005AFF002AFF0400FF2F00FF5600FF
7900FF9700FFB000FFC300FFD100FFD800FFD900FFD500FFCA00FFB900FFA300FF8800FF
6800FF4500FF1E00FF000BFF0037FF0063FF0090FF00BDFF00E8FF00FFEE00FFC900FFA6
00FF8900FF7000FF5C00FF4F00FF4700FF4600FF4A00FF5500FF6500FF7A00FF9500FFB3
00FFD400FFF800E2FF00BCFF0097FF0074FF0053FF0035FF001CFF0007FF0700FF1000FF
1200FF0F00FF0600FF0008FF001CFF0034FF0050FF006DFF008BFF00A9FF00C6FF00DFFF
00F5FF00FFF900FFEE00FFE900FFEA00FFF100FFFE00F0FF00DBFF00C4FF00ADFF0097FF
0084FF0076FF006EFF006CFF0070FF0079FF0087FF0097FF00A7FF00B4FF00BBFF00BBFF
00B5FF00ACFF00A4FF00A3FF00A8FF00A9FF00A2FF0098FF0091FF0090FF0096FF00A2FF
00B1FF00C1FF00D0FF00DBFF00E0FF00DFFF00D8FF00CAFF00B8FF00A3FF008CFF0075FF
0060FF004EFF0040FF0037FF0035FF0039FF0043FF0053FF0068FF0081FF009DFF00BAFF
00D9FF00F7FF00FFED00FFD400FFBF00FFAF00FFA500FFA000FFA200FFA900FFB700FFCB
00FFE300FFFF00DFFF00BCFF0097FF0071FF004CFF0028FF0006FF1800FF3300FF4A00FF
5B00FF6700FF6C00FF6C00FF6600FF5900FF4700FF2F00FF1200FF000EFF0033FF005CFF
0086FF00B3FF00E0FF00FFF300FFC700FF9D00FF7500FF5100FF3000FF1402FF0014FF00
20FF0026FF0026FF001FFF0013FF0001FF0000FF1600FF3300FF5500FF7C00FFA600FFD4
00FBFF00C8FF0095FF0060FF002CFF0600FF3800FF6700FF
00FF6600FF9500FFC700FFFA00D1FF009DFF0069FF0036FF0006FF2800FF5300FF7A00FF
9D00FFBB00FFD400FFE700FFF500FFFC00FFFE00FFF900FFEE00FFDD00FFC700FFAC00FF
8C00FF6900FF4200FF1800FF0013FF003FFF006CFF0099FF00C4FF00ECFF00FFED00FFCB
00FFAD00FF9400FF8100FF7300FF6B00FF6A00FF6E00FF7900FF8900FF9F00FFB900FFD7
00FFF800E3FF00BEFF0098FF0073FF004FFF002EFF0011FF0800FF1C00FF2B00FF3400FF
3700FF3300FF2A00FF1B00FF0700FF0010FF002BFF0049FF0067FF0085FF00A2FF00BBFF
00D1FF00E2FF00EDFF00F2FF00F1FF00EAFF00DDFF00CCFF00B7FF00A0FF0089FF0073FF
0060FF0052FF004AFF0047FF004BFF0055FF0063FF0073FF0083FF008FFF0097FF0097FF
0091FF0088FF0080FF007FFF0084FF0085FF007EFF0074FF006DFF006CFF0072FF007EFF
008DFF009DFF00ACFF00B6FF00BCFF00BBFF00B3FF00A6FF0094FF007FFF0068FF0051FF
003CFF0029FF001CFF0013FF0011FF0015FF001FFF002FFF0043FF005CFF0078FF0096FF
00B5FF00D2FF00EEFF00FFF800FFE300FFD300FFC900FFC400FFC600FFCE00FFDB00FFEF
00F8FF00DBFF00BBFF0097FF0073FF004DFF0028FF0003FF1E00FF3C00FF5700FF6E00FF
7F00FF8B00FF9100FF9000FF8A00FF7D00FF6B00FF5300FF3600FF1500FF000FFF0038FF
0062FF008EFF00BBFF00E8FF00FFEB00FFC100FF9900FF7500FF5400FF3800FF2100FF0F
00FF0401FF0001FF0000FF0400FF1000FF2200FF3A00FF5700FF7900FFA000FFCA00FFF8
00D7FF00A4FF0071FF003CFF0008FF2A00FF5C00FF8C00FF
00FF8800FFB700FFE900E3FF00AFFF007BFF0047FF0014FF1B00FF4A00FF7500FF9C00FF
BF00FFDD00FFF600FFFF00F6FF00E8FF00E1FF00E0FF00E4FF00EFFF00FFE900FFCE00FF
AE00FF8B00FF6400FF3A00FF0E00FF001DFF004AFF0077FF00A2FF00CAFF00F0FF00FFED
00FFCF00FFB600FFA200FF9500FF8D00FF8C00FF9000FF9B00FFAB00FFC000FFDB00FFF9
00E5FF00C1FF009CFF0076FF0051FF002DFF000CFF1000FF2A00FF3E00FF4D00FF5600FF
5800FF5500FF4C00FF3D00FF2900FF1100FF0009FF0027FF0045FF0063FF0080FF0099FF
00AFFF00C0FF00CBFF00D0FF00CFFF00C8FF00BBFF00AAFF0095FF007EFF0067FF0051FF
003EFF0030FF0028FF0025FF002AFF0033FF0041FF0051FF0061FF006EFF0075FF0075FF
006FFF0066FF005EFF005DFF0062FF0063FF005CFF0052FF004BFF004AFF0050FF005CFF
006BFF007BFF008AFF0094FF009AFF0099FF0091FF0084FF0072FF005DFF0046FF002FFF
001AFF0007FF0500FF0E00FF1000FF0C00FF0200FF000DFF0022FF003AFF0056FF0074FF
0093FF00B0FF00CCFF00E5FF00FAFF00FFF500FFEB00FFE600FFE800FFF000FFFD00EEFF
00D6FF00B9FF0099FF0076FF0051FF002BFF0006FF1E00FF3F00FF5E00FF7900FF9000FF
A100FFAD00FFB200FFB200FFAC00FF9F00FF8D00FF7500FF5800FF3700FF1200FF0016FF
0040FF006DFF0099FF00C6FF00F2FF00FFE300FFBB00FF9700FF7600FF5A00FF4300FF31
00FF2500FF1F00FF2000FF2600FF3200FF4400FF5C00FF7900FF9B00FFC200FFEC00E5FF
00B5FF0082FF004FFF001AFF1900FF4C00FF7E00FFAD00FF
00FFA700FFD600F8FF00C4FF0090FF005CFF0028FF0900FF3A00FF6900FF9400FFBB00FF
DE00FFFC00FFFF00EAFF00D7FF00C9FF00C2FF00C1FF00C5FF00D0FF00E1FF00F7ED00FF
CD00FFAA00FF8300FF5900FF2D00FF0100FF002BFF0058FF0083FF00ACFF00D1FF00F4FF
00FFEE00FFD500FFC100FFB400FFAC00FFAA00FFAF00FFBA00FFCA00FFDF00FFF900E7FF
00C6FF00A2FF007DFF0057FF0032FF000FFF1100FF2F00FF4800FF5D00FF6C00FF7500FF
7700FF7400FF6B00FF5C00FF4800FF3000FF1400FF0008FF0026FF0044FF0061FF007BFF
0090FF00A1FF00ACFF00B1FF00B0FF00A9FF009CFF008BFF0076FF005FFF0048FF0032FF
0020FF0011FF0009FF0007FF000BFF0014FF0022FF0032FF0042FF004FFF0056FF0056FF
0050FF0047FF003FFF003EFF0043FF0044FF003DFF0033FF002CFF002BFF0031FF003DFF
004CFF005CFF006BFF0076FF007BFF007AFF0073FF0065FF0053FF003EFF0027FF0010FF
0400FF1600FF2400FF2C00FF2F00FF2B00FF2100FF1100FF0003FF001CFF0038FF0055FF
0074FF0092FF00ADFF00C6FF00DBFF00EBFF00F5FF00FAFF00F8FF00F1FF00E3FF00D0FF
00B7FF009AFF007AFF0057FF0032FF000CFF1800FF3C00FF5E00FF7D00FF9800FFAF00FF
C000FFCC00FFD100FFD100FFCA00FFBE00FFAC00FF9400FF7700FF5600FF3000FF0800FF
0021FF004EFF007BFF00A7FF00D3FF00FDFF00FFDA00FFB600FF9500FF7900FF6200FF50
00FF4400FF3E00FF3E00FF4500FF5100FF6300FF7B00FF9800FFBA00FFE100F4FF00C6FF
0096FF0064FF0030FF0300FF3800FF6B00FF9D00FFCC00FF
00FFC200FFF100DDFF00A9FF0075FF0041FF000DFF2400FF5500FF8400FFAF00FFD600FF
F900FFFF00E8FF00CFFF00BCFF00AEFF00A7FF00A6FF00AAFF00B5FF00C6FF00DCFF00F7
E800FFC500FF9E00FF7400FF4800FF1C00FF0010FF003DFF0068FF0091FF00B6FF00D9FF
00F6FF00FFF000FFDC00FFCF00FFC700FFC500FFCA00FFD500FFE500FFFA00EBFF00CCFF
00ABFF0087FF0062FF003CFF0017FF0B00FF2C00FF4A00FF6300FF7800FF8700FF9000FF
9200FF8F00FF8600FF7700FF6300FF4B00FF2F00FF1200FF000BFF0029FF0046FF0060FF
0075FF0086FF0091FF0096FF0095FF008EFF0081FF0070FF005BFF0044FF002DFF0017FF
0005FF0900FF1100FF1300FF0F00FF0600FF0007FF0017FF0027FF0034FF003BFF003BFF
0035FF002CFF0024FF0023FF0028FF0029FF0022FF0018FF0011FF0010FF0016FF0022FF
0031FF0041FF0050FF005BFF0060FF005FFF0058FF004AFF0038FF0023FF000CFF0A00FF
1F00FF3100FF3F00FF4700FF4A00FF4600FF3C00FF2C00FF1700FF0001FF001DFF003AFF
0059FF0077FF0092FF00ABFF00C0FF00D0FF00DAFF00DFFF00DDFF00D6FF00C8FF00B5FF
009CFF007FFF005FFF003CFF0017FF0E00FF3300FF5700FF7900FF9800FFB300FFCA00FF
DB00FFE700FFEC00FFEC00FFE500FFD900FFC700FFAF00FF9200FF7100FF4B00FF2300FF
0006FF0033FF0060FF008CFF00B8FF00E2FF00FFF500FFD100FFB000FF9400FF7D00FF6B
00FF5F00FF5900FF5900FF6000FF6C00FF7E00FF9600FFB300FFD500FFFC00D9FF00ABFF
007BFF0049FF0015FF1E00FF5300FF8600FFB800FFE700FF
00FFD800F8FF00C6FF0093FF005FFF002BFF0800FF3B00FF6C00FF9A00FFC500FFEC00FF
FF00F0FF00D1FF00B9FF00A5FF0098FF0091FF008FFF0094FF009FFF00AFFF00C6FF00E1
FF00FFDB00FFB400FF8A00FF5F00FF3200FF0500FF0026FF0051FF007AFF00A0FF00C2FF
00E0FF00F9FF00FFF300FFE500FFDD00FFDC00FFE000FFEB00FFFB00EEFF00D4FF00B6FF
0095FF0071FF004CFF0026FF0001FF2200FF4300FF6000FF7A00FF8E00FF9D00FFA600FF
A900FFA500FF9C00FF8D00FF7900FF6100FF4600FF2800FF0A00FF0013FF0030FF0049FF
005FFF0070FF007BFF0080FF007FFF0078FF006BFF0059FF0045FF002EFF0017FF0001FF
1100FF1F00FF2800FF2A00FF2600FF1C00FF0E00FF0001FF0011FF001DFF0024FF0025FF
001FFF0015FF000DFF000DFF0011FF0012FF000BFF0002FF0400FF0500FF0000FF000CFF
001BFF002BFF003AFF0044FF0049FF0049FF0041FF0034FF0022FF000DFF0900FF2000FF
3600FF4800FF5600FF5E00FF6000FF5C00FF5200FF4300FF2E00FF1500FF0006FF0024FF
0042FF0060FF007CFF0095FF00AAFF00BAFF00C4FF00C9FF00C7FF00BFFF00B1FF009EFF
0086FF0069FF0048FF0025FF0000FF2400FF4A00FF6E00FF9000FFAF00FFCA00FFE000FF
F100FFFD00FFFF00FCFF00FDFC00FFEF00FFDD00FFC500FFA800FF8700FF6200FF3A00FF
0F00FF001CFF0049FF0076FF00A2FF00CCFF00F4FF00FFE700FFC600FFAA00FF9300FF82
00FF7600FF7000FF7000FF7600FF8200FF9400FFAC00FFC900FFEB00EDFF00C3FF0095FF
0065FF0032FF0100FF3500FF6900FF9C00FFCE00FFFE00FF
00FFEA00E6FF00B5FF0082FF004EFF0019FF1900FF4C00FF7D00FFAB00FFD600FFFE00FF
FF00DEFF00C0FF00A7FF0094FF0087FF007FFF007EFF0083FF008EFF009EFF00B4FF00CF
FF00EFEC00FFC500FF9C00FF7000FF4300FF1600FF0015FF0040FF0069FF008FFF00B1FF
00CFFF00E8FF00FBFF00FFF600FFEF00FFED00FFF200FFFC00F2FF00DDFF00C3FF00A5FF
0083FF0060FF003AFF0015FF1000FF3300FF5400FF7200FF8B00FF9F00FFAE00FFB700FF
BA00FFB700FFAD00FF9E00FF8A00FF7200FF5700FF3A00FF1B00FF0002FF001EFF0038FF
004EFF005EFF006AFF006FFF006EFF0066FF005AFF0048FF0033FF001DFF0005FF0F00FF
2200FF3000FF3900FF3B00FF3700FF2D00FF1F00FF0F00FF0000FF000CFF0013FF0014FF
000EFF0004FF0300FF0400FF0000FF0001FF0500FF0F00FF1600FF1600FF1000FF0500FF
000AFF001AFF0028FF0033FF0038FF0037FF0030FF0023FF0011FF0400FF1B00FF3200FF
4700FF5900FF6700FF6F00FF7200FF6E00FF6400FF5400FF3F00FF2600FF0A00FF0013FF
0031FF004FFF006BFF0084FF0098FF00A8FF00B3FF00B7FF00B6FF00AEFF00A0FF008DFF
0074FF0058FF0037FF0014FF1000FF3600FF5B00FF7F00FFA100FFC000FFDB00FFF100FF
FF00FCFF00F1FF00EBFF00EBFF00F2FF00FEEE00FFD600FFBA00FF9800FF7300FF4B00FF
2000FF000BFF0038FF0065FF0091FF00BBFF00E2FF00FFF800FFD800FFBC00FFA500FF93
00FF8700FF8100FF8100FF8700FF9400FFA600FFBE00FFDB00FFFD00DCFF00B1FF0084FF
0053FF0021FF1200FF4600FF7A00FFAE00FFDF00FFFF00F0
00FFF500DBFF00A9FF0076FF0042FF000EFF2500FF5800FF8900FFB700FFE200FFFF00F6
FF00D3FF00B5FF009CFF0088FF007BFF0074FF0072FF0077FF0082FF0093FF00A9FF00C4
FF00E3F800FFD100FFA700FF7C00FF4F00FF2200FF0009FF0034FF005DFF0083FF00A5FF
00C3FF00DCFF00EFFF00FDFF00FFFA00FFF900FFFD00F7FF00E7FF00D1FF00B7FF0099FF
0078FF0054FF002FFF0009FF1B00FF3F00FF6000FF7D00FF9700FFAB00FFBA00FFC300FF
C600FFC200FFB900FFAA00FF9600FF7E00FF6300FF4500FF2700FF0900FF0013FF002CFF
0042FF0053FF005EFF0063FF0062FF005BFF004EFF003DFF0028FF0011FF0500FF1B00FF
2E00FF3C00FF4500FF4700FF4300FF3900FF2B00FF1B00FF0B00FF0000FF0008FF0008FF
0002FF0600FF0F00FF0F00FF0B00FF0A00FF1100FF1A00FF2100FF2200FF1C00FF1000FF
0100FF000EFF001DFF0027FF002DFF002CFF0024FF0017FF0005FF0F00FF2600FF3D00FF
5300FF6500FF7200FF7B00FF7D00FF7900FF6F00FF6000FF4B00FF3200FF1600FF0007FF
0026FF0043FF005FFF0078FF008DFF009DFF00A7FF00ACFF00AAFF00A2FF0095FF0081FF
0069FF004CFF002BFF0008FF1C00FF4100FF6700FF8B00FFAD00FFCC00FFE700FFFD00FF
FF00F1FF00E5FF00DFFF00E0FF00E6FF00F3FA00FFE200FFC500FFA400FF7F00FF5700FF
2C00FF0000FF002CFF0059FF0085FF00AFFF00D7FF00FBFF00FFE300FFC700FFB000FF9F
00FF9300FF8D00FF8D00FF9300FF9F00FFB100FFC900FFE600F7FF00D0FF00A6FF0078FF
0048FF0015FF1E00FF5200FF8600FFB900FFEB00FFFF00E4
00FFFB00D5FF00A3FF0070FF003CFF0008FF2B00FF5E00FF8E00FFBD00FFE800FFFF00F0
FF00CDFF00AFFF0096FF0083FF0075FF006EFF006DFF0071FF007CFF008DFF00A3FF00BE
FF00DEFE00FFD700FFAD00FF8100FF5500FF2800FF0004FF002FFF0058FF007DFF009FFF
00BDFF00D6FF00EAFF00F7FF00FFFF00FFFF00FCFF00F1FF00E1FF00CCFF00B1FF0093FF
0072FF004EFF0029FF0003FF2100FF4500FF6600FF8300FF9D00FFB100FFC000FFC900FF
CB00FFC800FFBF00FFB000FF9C00FF8400FF6900FF4B00FF2D00FF0F00FF000DFF0026FF
003CFF004DFF0058FF005DFF005CFF0055FF0048FF0037FF0022FF000BFF0B00FF2100FF
3400FF4200FF4A00FF4D00FF4800FF3F00FF3100FF2100FF1100FF0400FF0002FF0002FF
0300FF0C00FF1400FF1500FF1000FF0F00FF1600FF2000FF2700FF2800FF2200FF1600FF
0700FF0008FF0017FF0022FF0027FF0026FF001EFF0011FF0000FF1500FF2C00FF4300FF
5800FF6B00FF7800FF8100FF8300FF7F00FF7500FF6500FF5000FF3700FF1C00FF0001FF
0020FF003DFF0059FF0072FF0087FF0097FF00A1FF00A6FF00A4FF009CFF008FFF007BFF
0063FF0046FF0026FF0003FF2100FF4700FF6C00FF9100FFB200FFD100FFEC00FFFF00FC
FF00EBFF00DFFF00DAFF00DAFF00E0FF00EDFF00FFE800FFCB00FFAA00FF8500FF5C00FF
3200FF0500FF0026FF0053FF007FFF00A9FF00D1FF00F5FF00FFE900FFCD00FFB600FFA4
00FF9800FF9200FF9300FF9900FFA500FFB700FFCF00FFEC00F1FF00CAFF00A0FF0072FF
0042FF000FFF2300FF5800FF8C00FFBF00FFF100FFFF00DF
00FFFB00D5FF00A4FF0071FF003DFF0008FF2B00FF5D00FF8E00FFBC00FFE700FFFF00F0
FF00CDFF00AFFF0096FF0083FF0076FF006EFF006DFF0072FF007DFF008DFF00A3FF00BE
FF00DEFD00FFD600FFAD00FF8100FF5400FF2700FF0004FF002FFF0058FF007EFF00A0FF
00BEFF00D6FF00EAFF00F8FF00FFFF00FFFE00FCFF00F2FF00E1FF00CCFF00B2FF0094FF
0072FF004EFF0029FF0004FF2100FF4400FF6500FF8300FF9C00FFB100FFBF00FFC800FF
CB00FFC800FFBE00FFAF00FF9C00FF8300FF6800FF4B00FF2C00FF0E00FF000DFF0027FF
003CFF004DFF0058FF005EFF005CFF0055FF0048FF0037FF0022FF000BFF0B00FF2100FF
3300FF4100FF4A00FF4C00FF4800FF3E00FF3000FF2000FF1100FF0400FF0002FF0003FF
0200FF0C00FF1400FF1500FF1000FF0F00FF1600FF2000FF2700FF2800FF2200FF1600FF
0700FF0009FF0017FF0022FF0027FF0026FF001FFF0012FF0000FF1500FF2C00FF4300FF
5800FF6A00FF7800FF8000FF8300FF7F00FF7500FF6500FF5000FF3700FF1B00FF0002FF
0020FF003EFF005AFF0072FF0087FF0097FF00A2FF00A6FF00A5FF009DFF008FFF007CFF
0063FF0046FF0026FF0003FF2100FF4700FF6C00FF9000FFB200FFD100FFEC00FFFF00FD
FF00EBFF00E0FF00DAFF00DAFF00E1FF00EDFF00FFE800FFCB00FFA900FF8400FF5C00FF
3100FF0500FF0027FF0054FF007FFF00AAFF00D1FF00F6FF00FFE900FFCD00FFB600FFA4
00FF9800FF9200FF9200FF9800FFA500FFB700FFCF00FFEC00F1FF00CBFF00A0FF0073FF
0042FF0010FF2300FF5700FF8B00FFBF00FFF100FFFF00DF
00FFF400DCFF00AAFF0077FF0043FF000FFF2400FF5700FF8800FFB600FFE100FFFF00F7
FF00D4FF00B6FF009DFF0089FF007CFF0075FF0073FF0078FF0083FF0094FF00AAFF00C5
FF00E4F700FFD000FFA600FF7B00FF4E00FF2100FF000AFF0036FF005EFF0084FF00A6FF
00C4FF00DDFF00F0FF00FEFF00FFF900FFF800FFFC00F8FF00E8FF00D2FF00B8FF009AFF
0079FF0055FF0030FF000AFF1A00FF3E00FF5F00FF7C00FF9600FFAA00FFB900FFC200FF
C500FFC100FFB800FFA900FF9500FF7D00FF6200FF4400FF2600FF0800FF0014FF002DFF
0043FF0054FF005FFF0064FF0063FF005CFF004FFF003EFF0029FF0012FF0400FF1A00FF
2D00FF3B00FF4400FF4600FF4200FF3800FF2A00FF1A00FF0A00FF0001FF0009FF0009FF
0003FF0500FF0D00FF0E00FF0A00FF0900FF1000FF1900FF2000FF2100FF1B00FF0F00FF
0000FF000FFF001EFF0028FF002EFF002DFF0025FF0018FF0006FF0E00FF2500FF3C00FF
5200FF6400FF7100FF7A00FF7C00FF7800FF6E00FF5E00FF4A00FF3100FF1500FF0008FF
0027FF0044FF0060FF0079FF008EFF009EFF00A8FF00ADFF00ABFF00A3FF0096FF0082FF
006AFF004DFF002DFF0009FF1B00FF4000FF6600FF8A00FFAC00FFCA00FFE500FFFC00FF
FF00F2FF00E6FF00E0FF00E1FF00E7FF00F4F900FFE100FFC400FFA300FF7E00FF5600FF
2B00FF0000FF002DFF005AFF0086FF00B0FF00D8FF00FCFF00FFE200FFC600FFAF00FF9E
00FF9200FF8C00FF8C00FF9200FF9E00FFB000FFC800FFE500F8FF00D1FF00A7FF0079FF
0049FF0016FF1C00FF5100FF8500FFB800FFEA00FFFF00E5
00FFE800E8FF00B7FF0084FF0050FF001BFF1800FF4A00FF7B00FFA900FFD400FFFC00FF
FF00E0FF00C2FF00A9FF0096FF0089FF0081FF0080FF0085FF008FFF00A0FF00B6FF00D1
FF00F1EA00FFC300FF9A00FF6E00FF4100FF1400FF0017FF0042FF006BFF0091FF00B3FF
00D1FF00E9FF00FDFF00FFF400FFED00FFEB00FFF000FFFA00F4FF00DFFF00C5FF00A7FF
0085FF0061FF003CFF0016FF0E00FF3100FF5200FF7000FF8900FF9E00FFAC00FFB500FF
B800FFB500FFAB00FF9C00FF8900FF7100FF5500FF3800FF1900FF0004FF0020FF003AFF
004FFF0060FF006BFF0071FF006FFF0068FF005BFF004AFF0035FF001EFF0007FF0E00FF
2000FF2E00FF3700FF3900FF3500FF2B00FF1D00FF0D00FF0001FF000EFF0015FF0016FF
0010FF0006FF0100FF0200FF0002FF0003FF0300FF0D00FF1400FF1500FF0F00FF0300FF
000BFF001CFF002AFF0035FF003AFF0039FF0032FF0025FF0013FF0200FF1900FF3000FF
4500FF5700FF6500FF6D00FF7000FF6C00FF6200FF5200FF3D00FF2400FF0800FF0015FF
0033FF0051FF006DFF0085FF009AFF00AAFF00B5FF00B9FF00B8FF00B0FF00A2FF008FFF
0076FF0059FF0039FF0016FF0E00FF3400FF5900FF7D00FF9F00FFBE00FFD900FFEF00FF
FF00FEFF00F3FF00EDFF00EDFF00F4FF00FFEC00FFD500FFB800FF9600FF7100FF4900FF
1E00FF000DFF003AFF0067FF0092FF00BDFF00E4FF00FFF600FFD600FFBA00FFA300FF91
00FF8500FF7F00FF7F00FF8500FF9200FFA400FFBC00FFD900FFFB00DEFF00B3FF0086FF
0055FF0023FF1000FF4400FF7800FFAC00FFDE00FFFF00F2
00FFD500FBFF00C9FF0096FF0062FF002EFF0500FF3800FF6900FF9700FFC200FFE900FF
FF00F3FF00D4FF00BCFF00A8FF009BFF0093FF0092FF0097FF00A2FF00B2FF00C8FF00E4
FC00FFD800FFB100FF8700FF5C00FF2F00FF0200FF0029FF0054FF007DFF00A3FF00C5FF
00E3FF00FCFF00FFF000FFE200FFDA00FFD900FFDE00FFE800FFF800F1FF00D7FF00B9FF
0098FF0074FF004FFF0029FF0004FF1F00FF4000FF5D00FF7700FF8B00FF9A00FFA300FF
A600FFA200FF9900FF8A00FF7600FF5E00FF4300FF2500FF0700FF0016FF0032FF004CFF
0062FF0073FF007EFF0083FF0082FF007BFF006EFF005CFF0048FF0031FF001AFF0004FF
0E00FF1C00FF2500FF2700FF2300FF1900FF0B00FF0004FF0014FF0020FF0027FF0028FF
0022FF0018FF0010FF0010FF0014FF0015FF000EFF0005FF0100FF0200FF0003FF000EFF
001EFF002EFF003CFF0047FF004CFF004BFF0044FF0037FF0025FF0010FF0600FF1D00FF
3300FF4500FF5300FF5B00FF5D00FF5900FF4F00FF4000FF2B00FF1200FF0009FF0027FF
0045FF0063FF007FFF0098FF00ADFF00BCFF00C7FF00CBFF00CAFF00C2FF00B4FF00A1FF
0089FF006CFF004BFF0028FF0003FF2100FF4700FF6B00FF8D00FFAC00FFC700FFDD00FF
EE00FFFA00FFFF00FFFF00FFF900FFEC00FFDA00FFC200FFA500FF8400FF5F00FF3700FF
0C00FF001FFF004CFF0079FF00A5FF00CFFF00F7FF00FFE400FFC400FFA700FF9000FF7F
00FF7300FF6D00FF6D00FF7300FF7F00FF9200FFA900FFC600FFE900F0FF00C6FF0098FF
0067FF0035FF0001FF3200FF6600FF9900FFCB00FFFB00FF
00FFBE00FFED00E1FF00AEFF007AFF0045FF0012FF2000FF5100FF7F00FFAA00FFD200FF
F500FFFF00ECFF00D3FF00C0FF00B3FF00ABFF00AAFF00AFFF00BAFF00CAFF00E0FF00FB
E400FFC000FF9900FF6F00FF4400FF1700FF0015FF0041FF006CFF0095FF00BBFF00DDFF
00FBFF00FFEB00FFD800FFCA00FFC300FFC100FFC600FFD000FFE000FFF600EFFF00D1FF
00AFFF008CFF0066FF0041FF001CFF0700FF2800FF4600FF5F00FF7300FF8200FF8B00FF
8E00FF8B00FF8100FF7200FF5E00FF4600FF2B00FF0E00FF0010FF002EFF004AFF0064FF
007AFF008AFF0096FF009BFF009AFF0092FF0086FF0074FF005FFF0049FF0031FF001CFF
0009FF0400FF0D00FF0F00FF0B00FF0100FF000CFF001CFF002BFF0038FF003FFF0040FF
003AFF0030FF0028FF0027FF002CFF002DFF0026FF001CFF0016FF0015FF001BFF0026FF
0036FF0046FF0054FF005FFF0064FF0063FF005CFF004FFF003DFF0027FF0010FF0600FF
1B00FF2D00FF3B00FF4300FF4500FF4200FF3800FF2800FF1300FF0005FF0021FF003FFF
005DFF007BFF0097FF00B0FF00C4FF00D4FF00DFFF00E3FF00E2FF00DAFF00CCFF00B9FF
00A0FF0084FF0063FF0040FF001BFF0900FF2F00FF5300FF7500FF9400FFAF00FFC500FF
D600FFE200FFE800FFE800FFE100FFD500FFC200FFAA00FF8E00FF6C00FF4700FF1F00FF
000BFF0037FF0064FF0091FF00BDFF00E7FF00FFF100FFCC00FFAC00FF9000FF7900FF67
00FF5B00FF5500FF5500FF5B00FF6800FF7A00FF9100FFAF00FFD100FFF700DDFF00B0FF
007FFF004DFF0019FF1A00FF4E00FF8200FFB300FFE300FF
00FFA100FFD000FEFF00CBFF0097FF0062FF002EFF0300FF3400FF6200FF8D00FFB500FF
D800FFF600FFFF00F0FF00DDFF00D0FF00C8FF00C7FF00CCFF00D7FF00E7FF00FDE700FF
C700FFA300FF7C00FF5300FF2700FF0005FF0032FF005EFF0089FF00B2FF00D8FF00FAFF
00FFE700FFCF00FFBB00FFAD00FFA600FFA400FFA900FFB300FFC400FFD900FFF300EEFF
00CCFF00A8FF0083FF005EFF0038FF0015FF0B00FF2900FF4200FF5700FF6500FF6E00FF
7100FF6E00FF6400FF5500FF4200FF2900FF0E00FF000EFF002DFF004BFF0067FF0081FF
0096FF